/**
 * 
 */
package querqy.rewrite;

import java.util.Collections;
import java.util.Set;

import querqy.model.ExpandedQuery;
import querqy.model.Term;

/**
 * @author René Kriegler, @renekrie
 *
 */
public abstract class RewriterFactory {

    private final String rewriterId;

    protected RewriterFactory(final String rewriterId) {
        this.rewriterId = rewriterId;
    }

    // TODO: ExpandedQuery input is not used by any factory
    //  SearchEngineRequestAdapter is only used by SimpleCommonRulesRewriterFactory for the creation of SelectionStrategy.
    //  Both parameters can be fully removed, as SearchEngineRequestAdapter is also passed to the rewriter via
    //  QueryRewriter#rewrite
    public abstract QueryRewriter createRewriter(ExpandedQuery input,
                                                 SearchEngineRequestAdapter searchEngineRequestAdapter);

    /**
     * For clarity, implement {@link #getCacheableGenerableTerms()} instead of this
     * method. To ensure backwards compatibility, said method delegates to this one.
     * 
     * @return The set of {@link Term}s to be generated, defaults to an empty set.
     */
    @Deprecated
    public Set<Term> getGenerableTerms() {
        return Collections.emptySet();
    }
                                                 
    /**
     * <p>Get all {@link querqy.model.Term}s that will be generated by Rewriters that will be created by this class.</p>
    * <p>This only includes terms that are known when the factory is created. The terms returned from this method might
    * be used to optimise caching.</p>
    * <p>This method must return an empty set if no such term exists.</p>
    *
    * @return The set of {@link Term}s to be generated, defaults to an empty set.
    */
    public Set<Term> getCacheableGenerableTerms() {
        return getGenerableTerms();
    }

    public String getRewriterId() {
        return rewriterId;
    }


}
