// Code generated by "precompile.go". DO NOT EDIT.

package rulesdata

import "github.com/quasilyte/go-ruleguard/ruleguard/ir"

var Universal = &ir.File{
	PkgPath:       "gorules",
	CustomDecls:   []string{},
	BundleImports: []ir.BundleImport{},
	RuleGroups: []ir.RuleGroup{
		{
			Line:        46,
			Name:        "stringsCut",
			MatcherName: "m",
			DocTags:     []string{"o1", "score3"},
			DocSummary:  "Detects use cases for strings.Cut",
			DocBefore:   "email := strings.Split(s, \"@\")[0]",
			DocAfter:    "email, _, _ := strings.Cut(s, \"@\")",
			Rules: []ir.Rule{
				{
					Line:            47,
					SyntaxPatterns:  []ir.PatternString{{Line: 47, Value: "$dst := strings.Split($s, $sep)[0]"}},
					ReportTemplate:  "$$ => $dst, _, _ := strings.Cut($s, $sep)",
					SuggestTemplate: "$dst, _, _ := strings.Cut($s, $sep)",
					WhereExpr: ir.FilterExpr{
						Line:  48,
						Op:    ir.FilterGoVersionGreaterEqThanOp,
						Src:   "m.GoVersion().GreaterEqThan(\"1.18\")",
						Value: "1.18",
					},
				},
				{
					Line:            50,
					SyntaxPatterns:  []ir.PatternString{{Line: 50, Value: "$dst = strings.Split($s, $sep)[0]"}},
					ReportTemplate:  "$$ => $dst, _, _ = strings.Cut($s, $sep)",
					SuggestTemplate: "$dst, _, _ = strings.Cut($s, $sep)",
					WhereExpr: ir.FilterExpr{
						Line:  51,
						Op:    ir.FilterGoVersionGreaterEqThanOp,
						Src:   "m.GoVersion().GreaterEqThan(\"1.18\")",
						Value: "1.18",
					},
				},
			},
		},
		{
			Line:        59,
			Name:        "bytesCut",
			MatcherName: "m",
			DocTags:     []string{"o1", "score3"},
			DocSummary:  "Detects use cases for bytes.Cut",
			DocBefore:   "email := bytes.Split(b, \"@\")[0]",
			DocAfter:    "email, _, _ := bytes.Cut(b, []byte(\"@\"))",
			Rules: []ir.Rule{
				{
					Line:            60,
					SyntaxPatterns:  []ir.PatternString{{Line: 60, Value: "$dst := bytes.Split($b, $sep)[0]"}},
					ReportTemplate:  "$$ => $dst, _, _ := bytes.Cut($b, $sep)",
					SuggestTemplate: "$dst, _, _ := bytes.Cut($b, $sep)",
					WhereExpr: ir.FilterExpr{
						Line:  61,
						Op:    ir.FilterGoVersionGreaterEqThanOp,
						Src:   "m.GoVersion().GreaterEqThan(\"1.18\")",
						Value: "1.18",
					},
				},
				{
					Line:            63,
					SyntaxPatterns:  []ir.PatternString{{Line: 63, Value: "$dst = bytes.Split($b, $sep)[0]"}},
					ReportTemplate:  "$$ => $dst, _, _ = bytes.Cut($b, $sep)",
					SuggestTemplate: "$dst, _, _ = bytes.Cut($b, $sep)",
					WhereExpr: ir.FilterExpr{
						Line:  64,
						Op:    ir.FilterGoVersionGreaterEqThanOp,
						Src:   "m.GoVersion().GreaterEqThan(\"1.18\")",
						Value: "1.18",
					},
				},
			},
		},
		{
			Line:        72,
			Name:        "stringsClone",
			MatcherName: "m",
			DocTags:     []string{"o1", "score3"},
			DocSummary:  "Detects use cases for strings.Clone",
			DocBefore:   "s2 := string([]byte(s1))",
			DocAfter:    "s2 := strings.Clone(s1)",
			Rules: []ir.Rule{{
				Line:            73,
				SyntaxPatterns:  []ir.PatternString{{Line: 73, Value: "string([]byte($s))"}},
				ReportTemplate:  "$$ => strings.Clone($s)",
				SuggestTemplate: "strings.Clone($s)",
				WhereExpr: ir.FilterExpr{
					Line: 74,
					Op:   ir.FilterAndOp,
					Src:  "m[\"s\"].Type.Is(`string`) &&\n\t!m[\"s\"].Const &&\n\tm.GoVersion().GreaterEqThan(\"1.18\")",
					Args: []ir.FilterExpr{
						{
							Line: 74,
							Op:   ir.FilterAndOp,
							Src:  "m[\"s\"].Type.Is(`string`) &&\n\t!m[\"s\"].Const",
							Args: []ir.FilterExpr{
								{
									Line:  74,
									Op:    ir.FilterVarTypeIsOp,
									Src:   "m[\"s\"].Type.Is(`string`)",
									Value: "s",
									Args:  []ir.FilterExpr{{Line: 74, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
								},
								{
									Line: 75,
									Op:   ir.FilterNotOp,
									Src:  "!m[\"s\"].Const",
									Args: []ir.FilterExpr{{
										Line:  75,
										Op:    ir.FilterVarConstOp,
										Src:   "m[\"s\"].Const",
										Value: "s",
									}},
								},
							},
						},
						{
							Line:  76,
							Op:    ir.FilterGoVersionGreaterEqThanOp,
							Src:   "m.GoVersion().GreaterEqThan(\"1.18\")",
							Value: "1.18",
						},
					},
				},
			}},
		},
		{
			Line:        84,
			Name:        "equalFold",
			MatcherName: "m",
			DocTags:     []string{"o1", "score2"},
			DocSummary:  "Detects unoptimal strings/bytes case-insensitive comparison",
			DocBefore:   "strings.ToLower(x) == strings.ToLower(y)",
			DocAfter:    "strings.EqualFold(x, y)",
			Rules: []ir.Rule{
				{
					Line: 86,
					SyntaxPatterns: []ir.PatternString{
						{Line: 87, Value: "strings.ToLower($x) == $y"},
						{Line: 88, Value: "strings.ToLower($x) == strings.ToLower($y)"},
						{Line: 89, Value: "$x == strings.ToLower($y)"},
						{Line: 90, Value: "strings.ToUpper($x) == $y"},
						{Line: 91, Value: "strings.ToUpper($x) == strings.ToUpper($y)"},
						{Line: 92, Value: "$x == strings.ToUpper($y)"},
					},
					ReportTemplate:  "$$ => strings.EqualFold($x, $y)",
					SuggestTemplate: "strings.EqualFold($x, $y)",
					WhereExpr: ir.FilterExpr{
						Line: 93,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Pure && m[\"y\"].Pure && m[\"x\"].Text != m[\"y\"].Text",
						Args: []ir.FilterExpr{
							{
								Line: 93,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure && m[\"y\"].Pure",
								Args: []ir.FilterExpr{
									{Line: 93, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
									{Line: 93, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
								},
							},
							{
								Line: 93,
								Op:   ir.FilterNeqOp,
								Src:  "m[\"x\"].Text != m[\"y\"].Text",
								Args: []ir.FilterExpr{
									{Line: 93, Op: ir.FilterVarTextOp, Src: "m[\"x\"].Text", Value: "x"},
									{Line: 93, Op: ir.FilterVarTextOp, Src: "m[\"y\"].Text", Value: "y"},
								},
							},
						},
					},
				},
				{
					Line: 97,
					SyntaxPatterns: []ir.PatternString{
						{Line: 98, Value: "strings.ToLower($x) != $y"},
						{Line: 99, Value: "strings.ToLower($x) != strings.ToLower($y)"},
						{Line: 100, Value: "$x != strings.ToLower($y)"},
						{Line: 101, Value: "strings.ToUpper($x) != $y"},
						{Line: 102, Value: "strings.ToUpper($x) != strings.ToUpper($y)"},
						{Line: 103, Value: "$x != strings.ToUpper($y)"},
					},
					ReportTemplate:  "$$ => !strings.EqualFold($x, $y)",
					SuggestTemplate: "!strings.EqualFold($x, $y)",
					WhereExpr: ir.FilterExpr{
						Line: 104,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Pure && m[\"y\"].Pure && m[\"x\"].Text != m[\"y\"].Text",
						Args: []ir.FilterExpr{
							{
								Line: 104,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure && m[\"y\"].Pure",
								Args: []ir.FilterExpr{
									{Line: 104, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
									{Line: 104, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
								},
							},
							{
								Line: 104,
								Op:   ir.FilterNeqOp,
								Src:  "m[\"x\"].Text != m[\"y\"].Text",
								Args: []ir.FilterExpr{
									{Line: 104, Op: ir.FilterVarTextOp, Src: "m[\"x\"].Text", Value: "x"},
									{Line: 104, Op: ir.FilterVarTextOp, Src: "m[\"y\"].Text", Value: "y"},
								},
							},
						},
					},
				},
				{
					Line: 108,
					SyntaxPatterns: []ir.PatternString{
						{Line: 109, Value: "bytes.Equal(bytes.ToLower($x), $y)"},
						{Line: 110, Value: "bytes.Equal(bytes.ToLower($x), bytes.ToLower($y))"},
						{Line: 111, Value: "bytes.Equal($x, bytes.ToLower($y))"},
						{Line: 112, Value: "bytes.Equal(bytes.ToUpper($x), $y)"},
						{Line: 113, Value: "bytes.Equal(bytes.ToUpper($x), bytes.ToUpper($y))"},
						{Line: 114, Value: "bytes.Equal($x, bytes.ToUpper($y))"},
					},
					ReportTemplate:  "$$ => bytes.EqualFold($x, $y)",
					SuggestTemplate: "bytes.EqualFold($x, $y)",
					WhereExpr: ir.FilterExpr{
						Line: 115,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Pure && m[\"y\"].Pure && m[\"x\"].Text != m[\"y\"].Text",
						Args: []ir.FilterExpr{
							{
								Line: 115,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure && m[\"y\"].Pure",
								Args: []ir.FilterExpr{
									{Line: 115, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
									{Line: 115, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
								},
							},
							{
								Line: 115,
								Op:   ir.FilterNeqOp,
								Src:  "m[\"x\"].Text != m[\"y\"].Text",
								Args: []ir.FilterExpr{
									{Line: 115, Op: ir.FilterVarTextOp, Src: "m[\"x\"].Text", Value: "x"},
									{Line: 115, Op: ir.FilterVarTextOp, Src: "m[\"y\"].Text", Value: "y"},
								},
							},
						},
					},
				},
				{
					Line: 119,
					SyntaxPatterns: []ir.PatternString{
						{Line: 120, Value: "strings.HasPrefix(strings.ToLower($x), $y)"},
						{Line: 121, Value: "strings.HasPrefix(strings.ToUpper($x), $y)"},
					},
					ReportTemplate:  "$$ => (len($x) >= len($y) && strings.EqualFold($x[:len($y)], $y))",
					SuggestTemplate: "(len($x) >= len($y) && strings.EqualFold($x[:len($y)], $y))",
					WhereExpr: ir.FilterExpr{
						Line: 122,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Pure && m[\"y\"].Pure && m[\"x\"].Text != m[\"y\"].Text",
						Args: []ir.FilterExpr{
							{
								Line: 122,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure && m[\"y\"].Pure",
								Args: []ir.FilterExpr{
									{Line: 122, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
									{Line: 122, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
								},
							},
							{
								Line: 122,
								Op:   ir.FilterNeqOp,
								Src:  "m[\"x\"].Text != m[\"y\"].Text",
								Args: []ir.FilterExpr{
									{Line: 122, Op: ir.FilterVarTextOp, Src: "m[\"x\"].Text", Value: "x"},
									{Line: 122, Op: ir.FilterVarTextOp, Src: "m[\"y\"].Text", Value: "y"},
								},
							},
						},
					},
				},
				{
					Line: 124,
					SyntaxPatterns: []ir.PatternString{
						{Line: 125, Value: "strings.HasSuffix(strings.ToLower($x), $y)"},
						{Line: 126, Value: "strings.HasSuffix(strings.ToUpper($x), $y)"},
					},
					ReportTemplate:  "$$ => (len($x) >= len($y) && strings.EqualFold($x[len($x)-len($y):], $y))",
					SuggestTemplate: "(len($x) >= len($y) && strings.EqualFold($x[len($x)-len($y):], $y))",
					WhereExpr: ir.FilterExpr{
						Line: 127,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Pure && m[\"y\"].Pure && m[\"x\"].Text != m[\"y\"].Text",
						Args: []ir.FilterExpr{
							{
								Line: 127,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure && m[\"y\"].Pure",
								Args: []ir.FilterExpr{
									{Line: 127, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
									{Line: 127, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
								},
							},
							{
								Line: 127,
								Op:   ir.FilterNeqOp,
								Src:  "m[\"x\"].Text != m[\"y\"].Text",
								Args: []ir.FilterExpr{
									{Line: 127, Op: ir.FilterVarTextOp, Src: "m[\"x\"].Text", Value: "x"},
									{Line: 127, Op: ir.FilterVarTextOp, Src: "m[\"y\"].Text", Value: "y"},
								},
							},
						},
					},
				},
				{
					Line: 131,
					SyntaxPatterns: []ir.PatternString{
						{Line: 132, Value: "bytes.HasPrefix(bytes.ToLower($x), $y)"},
						{Line: 133, Value: "bytes.HasPrefix(bytes.ToUpper($x), $y)"},
					},
					ReportTemplate:  "$$ => (len($x) >= len($y) && bytes.EqualFold($x[:len($y)], $y))",
					SuggestTemplate: "(len($x) >= len($y) && bytes.EqualFold($x[:len($y)], $y))",
					WhereExpr: ir.FilterExpr{
						Line: 134,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Pure && m[\"y\"].Pure && m[\"x\"].Text != m[\"y\"].Text",
						Args: []ir.FilterExpr{
							{
								Line: 134,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure && m[\"y\"].Pure",
								Args: []ir.FilterExpr{
									{Line: 134, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
									{Line: 134, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
								},
							},
							{
								Line: 134,
								Op:   ir.FilterNeqOp,
								Src:  "m[\"x\"].Text != m[\"y\"].Text",
								Args: []ir.FilterExpr{
									{Line: 134, Op: ir.FilterVarTextOp, Src: "m[\"x\"].Text", Value: "x"},
									{Line: 134, Op: ir.FilterVarTextOp, Src: "m[\"y\"].Text", Value: "y"},
								},
							},
						},
					},
				},
				{
					Line: 136,
					SyntaxPatterns: []ir.PatternString{
						{Line: 137, Value: "bytes.HasSuffix(bytes.ToLower($x), $y)"},
						{Line: 138, Value: "bytes.HasSuffix(bytes.ToUpper($x), $y)"},
					},
					ReportTemplate:  "$$ => (len($x) >= len($y) && bytes.EqualFold($x[len($x)-len($y):], $y))",
					SuggestTemplate: "(len($x) >= len($y) && bytes.EqualFold($x[len($x)-len($y):], $y))",
					WhereExpr: ir.FilterExpr{
						Line: 139,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Pure && m[\"y\"].Pure && m[\"x\"].Text != m[\"y\"].Text",
						Args: []ir.FilterExpr{
							{
								Line: 139,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure && m[\"y\"].Pure",
								Args: []ir.FilterExpr{
									{Line: 139, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
									{Line: 139, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
								},
							},
							{
								Line: 139,
								Op:   ir.FilterNeqOp,
								Src:  "m[\"x\"].Text != m[\"y\"].Text",
								Args: []ir.FilterExpr{
									{Line: 139, Op: ir.FilterVarTextOp, Src: "m[\"x\"].Text", Value: "x"},
									{Line: 139, Op: ir.FilterVarTextOp, Src: "m[\"y\"].Text", Value: "y"},
								},
							},
						},
					},
				},
			},
		},
		{
			Line:        145,
			Name:        "redundantSprint",
			MatcherName: "m",
			DocTags:     []string{"o1", "score3"},
			DocSummary:  "Detects redundant fmt.Sprint calls",
			Rules: []ir.Rule{
				{
					Line: 146,
					SyntaxPatterns: []ir.PatternString{
						{Line: 146, Value: "fmt.Sprint($x)"},
						{Line: 146, Value: "fmt.Sprintf(\"%s\", $x)"},
						{Line: 146, Value: "fmt.Sprintf(\"%v\", $x)"},
					},
					ReportTemplate:  "$$ => $x.String()",
					SuggestTemplate: "$x.String()",
					WhereExpr: ir.FilterExpr{
						Line:  147,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"x\"].Type.Implements(`fmt.Stringer`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 147, Op: ir.FilterStringOp, Src: "`fmt.Stringer`", Value: "fmt.Stringer"}},
					},
				},
				{
					Line: 150,
					SyntaxPatterns: []ir.PatternString{
						{Line: 150, Value: "fmt.Sprint($x)"},
						{Line: 150, Value: "fmt.Sprintf(\"%s\", $x)"},
						{Line: 150, Value: "fmt.Sprintf(\"%v\", $x)"},
					},
					ReportTemplate:  "$$ => $x.Error()",
					SuggestTemplate: "$x.Error()",
					WhereExpr: ir.FilterExpr{
						Line:  151,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"x\"].Type.Implements(`error`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 151, Op: ir.FilterStringOp, Src: "`error`", Value: "error"}},
					},
				},
				{
					Line: 154,
					SyntaxPatterns: []ir.PatternString{
						{Line: 154, Value: "fmt.Sprint($x)"},
						{Line: 154, Value: "fmt.Sprintf(\"%s\", $x)"},
						{Line: 154, Value: "fmt.Sprintf(\"%v\", $x)"},
					},
					ReportTemplate:  "$$ => $x",
					SuggestTemplate: "$x",
					WhereExpr: ir.FilterExpr{
						Line:  155,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`string`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 155, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
					},
				},
				{
					Line: 158,
					SyntaxPatterns: []ir.PatternString{
						{Line: 158, Value: "fmt.Sprint($x)"},
						{Line: 158, Value: "fmt.Sprintf(\"%s\", $x)"},
						{Line: 158, Value: "fmt.Sprintf(\"%v\", $x)"},
					},
					ReportTemplate:  "$$ => string($x)",
					SuggestTemplate: "string($x)",
					WhereExpr: ir.FilterExpr{
						Line: 160,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Type.ConvertibleTo(`string`) &&\n\t!m[\"x\"].Type.OfKind(\"numeric\") &&\n\t!m[\"x\"].Type.Is(`[]rune`)",
						Args: []ir.FilterExpr{
							{
								Line: 160,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Type.ConvertibleTo(`string`) &&\n\t!m[\"x\"].Type.OfKind(\"numeric\")",
								Args: []ir.FilterExpr{
									{
										Line:  160,
										Op:    ir.FilterVarTypeConvertibleToOp,
										Src:   "m[\"x\"].Type.ConvertibleTo(`string`)",
										Value: "x",
										Args:  []ir.FilterExpr{{Line: 160, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
									},
									{
										Line: 161,
										Op:   ir.FilterNotOp,
										Src:  "!m[\"x\"].Type.OfKind(\"numeric\")",
										Args: []ir.FilterExpr{{
											Line:  161,
											Op:    ir.FilterVarTypeOfKindOp,
											Src:   "m[\"x\"].Type.OfKind(\"numeric\")",
											Value: "x",
											Args:  []ir.FilterExpr{{Line: 161, Op: ir.FilterStringOp, Src: "\"numeric\"", Value: "numeric"}},
										}},
									},
								},
							},
							{
								Line: 162,
								Op:   ir.FilterNotOp,
								Src:  "!m[\"x\"].Type.Is(`[]rune`)",
								Args: []ir.FilterExpr{{
									Line:  162,
									Op:    ir.FilterVarTypeIsOp,
									Src:   "m[\"x\"].Type.Is(`[]rune`)",
									Value: "x",
									Args:  []ir.FilterExpr{{Line: 162, Op: ir.FilterStringOp, Src: "`[]rune`", Value: "[]rune"}},
								}},
							},
						},
					},
				},
			},
		},
		{
			Line:        170,
			Name:        "redundantFprint",
			MatcherName: "m",
			DocTags:     []string{"o1", "score3"},
			DocSummary:  "Detects redundant fmt.Fprint calls",
			DocBefore:   "fmt.Fprintf(w, \"%s\", data)",
			DocAfter:    "w.WriteString(data.String())",
			Rules: []ir.Rule{
				{
					Line: 171,
					SyntaxPatterns: []ir.PatternString{
						{Line: 171, Value: "fmt.Fprint($w, $x)"},
						{Line: 171, Value: "fmt.Fprintf($w, \"%s\", $x)"},
						{Line: 171, Value: "fmt.Fprintf($w, \"%v\", $x)"},
					},
					ReportTemplate:  "$$ => $w.WriteString($x.String())",
					SuggestTemplate: "$w.WriteString($x.String())",
					WhereExpr: ir.FilterExpr{
						Line: 172,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Type.Implements(`fmt.Stringer`) && m[\"w\"].Type.Implements(`io.StringWriter`)",
						Args: []ir.FilterExpr{
							{
								Line:  172,
								Op:    ir.FilterVarTypeImplementsOp,
								Src:   "m[\"x\"].Type.Implements(`fmt.Stringer`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 172, Op: ir.FilterStringOp, Src: "`fmt.Stringer`", Value: "fmt.Stringer"}},
							},
							{
								Line:  172,
								Op:    ir.FilterVarTypeImplementsOp,
								Src:   "m[\"w\"].Type.Implements(`io.StringWriter`)",
								Value: "w",
								Args:  []ir.FilterExpr{{Line: 172, Op: ir.FilterStringOp, Src: "`io.StringWriter`", Value: "io.StringWriter"}},
							},
						},
					},
				},
				{
					Line: 175,
					SyntaxPatterns: []ir.PatternString{
						{Line: 175, Value: "fmt.Fprint($w, $x)"},
						{Line: 175, Value: "fmt.Fprintf($w, \"%s\", $x)"},
						{Line: 175, Value: "fmt.Fprintf($w, \"%v\", $x)"},
					},
					ReportTemplate:  "$$ => $w.WriteString($x.Error())",
					SuggestTemplate: "$w.WriteString($x.Error())",
					WhereExpr: ir.FilterExpr{
						Line: 176,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Type.Implements(`error`) && m[\"w\"].Type.Implements(`io.StringWriter`)",
						Args: []ir.FilterExpr{
							{
								Line:  176,
								Op:    ir.FilterVarTypeImplementsOp,
								Src:   "m[\"x\"].Type.Implements(`error`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 176, Op: ir.FilterStringOp, Src: "`error`", Value: "error"}},
							},
							{
								Line:  176,
								Op:    ir.FilterVarTypeImplementsOp,
								Src:   "m[\"w\"].Type.Implements(`io.StringWriter`)",
								Value: "w",
								Args:  []ir.FilterExpr{{Line: 176, Op: ir.FilterStringOp, Src: "`io.StringWriter`", Value: "io.StringWriter"}},
							},
						},
					},
				},
				{
					Line: 179,
					SyntaxPatterns: []ir.PatternString{
						{Line: 179, Value: "fmt.Fprint($w, $x)"},
						{Line: 179, Value: "fmt.Fprintf($w, \"%s\", $x)"},
						{Line: 179, Value: "fmt.Fprintf($w, \"%v\", $x)"},
					},
					ReportTemplate:  "$$ => $w.WriteString($x)",
					SuggestTemplate: "$w.WriteString($x)",
					WhereExpr: ir.FilterExpr{
						Line: 180,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Type.Is(`string`) && m[\"w\"].Type.Implements(`io.StringWriter`)",
						Args: []ir.FilterExpr{
							{
								Line:  180,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"x\"].Type.Is(`string`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 180, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
							{
								Line:  180,
								Op:    ir.FilterVarTypeImplementsOp,
								Src:   "m[\"w\"].Type.Implements(`io.StringWriter`)",
								Value: "w",
								Args:  []ir.FilterExpr{{Line: 180, Op: ir.FilterStringOp, Src: "`io.StringWriter`", Value: "io.StringWriter"}},
							},
						},
					},
				},
				{
					Line: 183,
					SyntaxPatterns: []ir.PatternString{
						{Line: 183, Value: "fmt.Fprint($w, $x)"},
						{Line: 183, Value: "fmt.Fprintf($w, \"%s\", $x)"},
						{Line: 183, Value: "fmt.Fprintf($w, \"%v\", $x)"},
					},
					ReportTemplate:  "$$ => $w.Write($x)",
					SuggestTemplate: "$w.Write($x)",
					WhereExpr: ir.FilterExpr{
						Line:  184,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`[]byte`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 184, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
					},
				},
			},
		},
		{
			Line:        192,
			Name:        "sliceClone",
			MatcherName: "m",
			DocTags:     []string{"o2", "score2"},
			DocSummary:  "Detects slice copying patterns that can be optimized",
			DocBefore:   "dst := append([]int(nil), src...)",
			DocAfter:    "dst := make([]int, len(src)); copy(dst, src)",
			Rules: []ir.Rule{
				{
					Line:            196,
					SyntaxPatterns:  []ir.PatternString{{Line: 196, Value: "append([]byte($s), $s2...)"}},
					ReportTemplate:  "$$ => append(append(make([]byte, 0, len($s)+len($s2)), $s...), $s2...)",
					SuggestTemplate: "append(append(make([]byte, 0, len($s)+len($s2)), $s...), $s2...)",
					WhereExpr: ir.FilterExpr{
						Line: 197,
						Op:   ir.FilterAndOp,
						Src:  "m[\"s\"].Type.Is(`string`) && m[\"s\"].Pure",
						Args: []ir.FilterExpr{
							{
								Line:  197,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 197, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
							{Line: 197, Op: ir.FilterVarPureOp, Src: "m[\"s\"].Pure", Value: "s"},
						},
					},
				},
				{
					Line: 200,
					SyntaxPatterns: []ir.PatternString{
						{Line: 200, Value: "$dst = append([]$elem(nil), $src...)"},
						{Line: 200, Value: "$dst = append([]$elem{}, $src...)"},
					},
					ReportTemplate:  "$$ => $dst = make([]$elem, len($src)); copy($dst, $src)",
					SuggestTemplate: "$dst = make([]$elem, len($src)); copy($dst, $src)",
					WhereExpr: ir.FilterExpr{
						Line: 201,
						Op:   ir.FilterNotOp,
						Src:  "!m[\"elem\"].Type.HasPointers()",
						Args: []ir.FilterExpr{{
							Line:  201,
							Op:    ir.FilterVarTypeHasPointersOp,
							Src:   "m[\"elem\"].Type.HasPointers()",
							Value: "elem",
						}},
					},
				},
				{
					Line: 203,
					SyntaxPatterns: []ir.PatternString{
						{Line: 203, Value: "$dst := append([]$elem(nil), $src...)"},
						{Line: 203, Value: "$dst := append([]$elem{}, $src...)"},
					},
					ReportTemplate:  "$$ => $dst := make([]$elem, len($src)); copy($dst, $src)",
					SuggestTemplate: "$dst := make([]$elem, len($src)); copy($dst, $src)",
					WhereExpr: ir.FilterExpr{
						Line: 204,
						Op:   ir.FilterNotOp,
						Src:  "!m[\"elem\"].Type.HasPointers()",
						Args: []ir.FilterExpr{{
							Line:  204,
							Op:    ir.FilterVarTypeHasPointersOp,
							Src:   "m[\"elem\"].Type.HasPointers()",
							Value: "elem",
						}},
					},
				},
			},
		},
		{
			Line:        210,
			Name:        "stringsJoinConcat",
			MatcherName: "m",
			DocTags:     []string{"o1", "score3"},
			DocSummary:  "Detect strings.Join usages that can be rewritten as a string concat",
			Rules: []ir.Rule{
				{
					Line:            211,
					SyntaxPatterns:  []ir.PatternString{{Line: 211, Value: "strings.Join([]string{$x, $y}, \"\")"}},
					ReportTemplate:  "$$ => $x + $y",
					SuggestTemplate: "$x + $y",
					WhereExpr: ir.FilterExpr{
						Line: 212,
						Op:   ir.FilterAndOp,
						Src:  "!m[\"x\"].Const && !m[\"y\"].Const",
						Args: []ir.FilterExpr{
							{
								Line: 212,
								Op:   ir.FilterNotOp,
								Src:  "!m[\"x\"].Const",
								Args: []ir.FilterExpr{{
									Line:  212,
									Op:    ir.FilterVarConstOp,
									Src:   "m[\"x\"].Const",
									Value: "x",
								}},
							},
							{
								Line: 212,
								Op:   ir.FilterNotOp,
								Src:  "!m[\"y\"].Const",
								Args: []ir.FilterExpr{{
									Line:  212,
									Op:    ir.FilterVarConstOp,
									Src:   "m[\"y\"].Const",
									Value: "y",
								}},
							},
						},
					},
				},
				{
					Line:            214,
					SyntaxPatterns:  []ir.PatternString{{Line: 214, Value: "strings.Join([]string{$x, $y, $z}, \"\")"}},
					ReportTemplate:  "$$ => $x + $y + $z",
					SuggestTemplate: "$x + $y + $z",
					WhereExpr: ir.FilterExpr{
						Line: 215,
						Op:   ir.FilterAndOp,
						Src:  "!m[\"x\"].Const && !m[\"y\"].Const && !m[\"z\"].Const",
						Args: []ir.FilterExpr{
							{
								Line: 215,
								Op:   ir.FilterAndOp,
								Src:  "!m[\"x\"].Const && !m[\"y\"].Const",
								Args: []ir.FilterExpr{
									{
										Line: 215,
										Op:   ir.FilterNotOp,
										Src:  "!m[\"x\"].Const",
										Args: []ir.FilterExpr{{
											Line:  215,
											Op:    ir.FilterVarConstOp,
											Src:   "m[\"x\"].Const",
											Value: "x",
										}},
									},
									{
										Line: 215,
										Op:   ir.FilterNotOp,
										Src:  "!m[\"y\"].Const",
										Args: []ir.FilterExpr{{
											Line:  215,
											Op:    ir.FilterVarConstOp,
											Src:   "m[\"y\"].Const",
											Value: "y",
										}},
									},
								},
							},
							{
								Line: 215,
								Op:   ir.FilterNotOp,
								Src:  "!m[\"z\"].Const",
								Args: []ir.FilterExpr{{
									Line:  215,
									Op:    ir.FilterVarConstOp,
									Src:   "m[\"z\"].Const",
									Value: "z",
								}},
							},
						},
					},
				},
				{
					Line:            218,
					SyntaxPatterns:  []ir.PatternString{{Line: 218, Value: "strings.Join([]string{$x, $y}, $glue)"}},
					ReportTemplate:  "$$ => $x + $glue + $y",
					SuggestTemplate: "$x + $glue + $y",
					WhereExpr: ir.FilterExpr{
						Line: 219,
						Op:   ir.FilterAndOp,
						Src:  "!m[\"x\"].Const && !m[\"y\"].Const",
						Args: []ir.FilterExpr{
							{
								Line: 219,
								Op:   ir.FilterNotOp,
								Src:  "!m[\"x\"].Const",
								Args: []ir.FilterExpr{{
									Line:  219,
									Op:    ir.FilterVarConstOp,
									Src:   "m[\"x\"].Const",
									Value: "x",
								}},
							},
							{
								Line: 219,
								Op:   ir.FilterNotOp,
								Src:  "!m[\"y\"].Const",
								Args: []ir.FilterExpr{{
									Line:  219,
									Op:    ir.FilterVarConstOp,
									Src:   "m[\"y\"].Const",
									Value: "y",
								}},
							},
						},
					},
				},
				{
					Line:            222,
					SyntaxPatterns:  []ir.PatternString{{Line: 222, Value: "strings.Join([]string{$x, $y, $z}, $glue)"}},
					ReportTemplate:  "$$ => $x + $glue + $y + $glue + $z",
					SuggestTemplate: "$x + $glue + $y + $glue + $z",
					WhereExpr: ir.FilterExpr{
						Line: 223,
						Op:   ir.FilterAndOp,
						Src:  "m[\"glue\"].Const && !m[\"x\"].Const && !m[\"y\"].Const && !m[\"z\"].Const",
						Args: []ir.FilterExpr{
							{
								Line: 223,
								Op:   ir.FilterAndOp,
								Src:  "m[\"glue\"].Const && !m[\"x\"].Const && !m[\"y\"].Const",
								Args: []ir.FilterExpr{
									{
										Line: 223,
										Op:   ir.FilterAndOp,
										Src:  "m[\"glue\"].Const && !m[\"x\"].Const",
										Args: []ir.FilterExpr{
											{
												Line:  223,
												Op:    ir.FilterVarConstOp,
												Src:   "m[\"glue\"].Const",
												Value: "glue",
											},
											{
												Line: 223,
												Op:   ir.FilterNotOp,
												Src:  "!m[\"x\"].Const",
												Args: []ir.FilterExpr{{
													Line:  223,
													Op:    ir.FilterVarConstOp,
													Src:   "m[\"x\"].Const",
													Value: "x",
												}},
											},
										},
									},
									{
										Line: 223,
										Op:   ir.FilterNotOp,
										Src:  "!m[\"y\"].Const",
										Args: []ir.FilterExpr{{
											Line:  223,
											Op:    ir.FilterVarConstOp,
											Src:   "m[\"y\"].Const",
											Value: "y",
										}},
									},
								},
							},
							{
								Line: 223,
								Op:   ir.FilterNotOp,
								Src:  "!m[\"z\"].Const",
								Args: []ir.FilterExpr{{
									Line:  223,
									Op:    ir.FilterVarConstOp,
									Src:   "m[\"z\"].Const",
									Value: "z",
								}},
							},
						},
					},
				},
			},
		},
		{
			Line:        231,
			Name:        "sprintfConcat",
			MatcherName: "m",
			DocTags:     []string{"o1", "score3"},
			DocSummary:  "Detects sprint calls that can be rewritten as a string concat",
			DocBefore:   "fmt.Sprintf(\"%s%s\", x, y)",
			DocAfter:    "x + y",
			Rules: []ir.Rule{
				{
					Line:            232,
					SyntaxPatterns:  []ir.PatternString{{Line: 232, Value: "fmt.Sprintf(\"%s%s\", $x, $y)"}},
					ReportTemplate:  "$$ => $x + $y",
					SuggestTemplate: "$x + $y",
					WhereExpr: ir.FilterExpr{
						Line: 233,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Type.Is(`string`) && m[\"y\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line:  233,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"x\"].Type.Is(`string`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 233, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
							{
								Line:  233,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"y\"].Type.Is(`string`)",
								Value: "y",
								Args:  []ir.FilterExpr{{Line: 233, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            236,
					SyntaxPatterns:  []ir.PatternString{{Line: 236, Value: "fmt.Sprintf(\"%s%s\", $x, $y)"}},
					ReportTemplate:  "$$ => $x.String() + $y.String()",
					SuggestTemplate: "$x.String() + $y.String()",
					WhereExpr: ir.FilterExpr{
						Line: 237,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Type.Implements(`fmt.Stringer`) && m[\"y\"].Type.Implements(`fmt.Stringer`)",
						Args: []ir.FilterExpr{
							{
								Line:  237,
								Op:    ir.FilterVarTypeImplementsOp,
								Src:   "m[\"x\"].Type.Implements(`fmt.Stringer`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 237, Op: ir.FilterStringOp, Src: "`fmt.Stringer`", Value: "fmt.Stringer"}},
							},
							{
								Line:  237,
								Op:    ir.FilterVarTypeImplementsOp,
								Src:   "m[\"y\"].Type.Implements(`fmt.Stringer`)",
								Value: "y",
								Args:  []ir.FilterExpr{{Line: 237, Op: ir.FilterStringOp, Src: "`fmt.Stringer`", Value: "fmt.Stringer"}},
							},
						},
					},
				},
			},
		},
		{
			Line:        245,
			Name:        "sprintfError",
			MatcherName: "m",
			DocTags:     []string{"o1", "score2"},
			DocSummary:  "Detects sprintf calls that are used to create an error",
			DocBefore:   "errors.New(fmt.Sprintf(\"%s:%d\", file, line))",
			DocAfter:    "fmt.Errorf(\"%s:%d\", file, line)",
			Rules: []ir.Rule{{
				Line:            246,
				SyntaxPatterns:  []ir.PatternString{{Line: 246, Value: "errors.New(fmt.Sprintf($format, $*args))"}},
				ReportTemplate:  "$$ => fmt.Errorf($format, $args)",
				SuggestTemplate: "fmt.Errorf($format, $args)",
			}},
		},
		{
			Line:        254,
			Name:        "strconv",
			MatcherName: "m",
			DocTags:     []string{"o1", "score2"},
			DocSummary:  "Detects fmt uses that can be replaced with strconv",
			DocBefore:   "fmt.Sprintf(\"%d\", i)",
			DocAfter:    "strconv.Itoa(i)",
			Rules: []ir.Rule{
				{
					Line: 258,
					SyntaxPatterns: []ir.PatternString{
						{Line: 258, Value: "fmt.Sprintf(\"%d\", $x)"},
						{Line: 258, Value: "fmt.Sprintf(\"%v\", $x)"},
						{Line: 258, Value: "fmt.Sprint($x)"},
					},
					ReportTemplate:  "$$ => strconv.Itoa($x)",
					SuggestTemplate: "strconv.Itoa($x)",
					WhereExpr: ir.FilterExpr{
						Line:  259,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`int`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 259, Op: ir.FilterStringOp, Src: "`int`", Value: "int"}},
					},
				},
				{
					Line: 263,
					SyntaxPatterns: []ir.PatternString{
						{Line: 263, Value: "fmt.Sprintf(\"%d\", $x)"},
						{Line: 263, Value: "fmt.Sprintf(\"%v\", $x)"},
						{Line: 263, Value: "fmt.Sprint($x)"},
					},
					ReportTemplate:  "$$ => strconv.FormatInt($x, 10)",
					SuggestTemplate: "strconv.FormatInt($x, 10)",
					WhereExpr: ir.FilterExpr{
						Line:  264,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`int64`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 264, Op: ir.FilterStringOp, Src: "`int64`", Value: "int64"}},
					},
				},
				{
					Line:            265,
					SyntaxPatterns:  []ir.PatternString{{Line: 265, Value: "fmt.Sprintf(\"%x\", $x)"}},
					ReportTemplate:  "$$ => strconv.FormatInt($x, 16)",
					SuggestTemplate: "strconv.FormatInt($x, 16)",
					WhereExpr: ir.FilterExpr{
						Line:  266,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`int64`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 266, Op: ir.FilterStringOp, Src: "`int64`", Value: "int64"}},
					},
				},
				{
					Line: 267,
					SyntaxPatterns: []ir.PatternString{
						{Line: 267, Value: "fmt.Sprintf(\"%d\", $x)"},
						{Line: 267, Value: "fmt.Sprintf(\"%v\", $x)"},
						{Line: 267, Value: "fmt.Sprint($x)"},
					},
					ReportTemplate:  "$$ => strconv.FormatUint($x, 10)",
					SuggestTemplate: "strconv.FormatUint($x, 10)",
					WhereExpr: ir.FilterExpr{
						Line:  268,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`uint64`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 268, Op: ir.FilterStringOp, Src: "`uint64`", Value: "uint64"}},
					},
				},
				{
					Line:            269,
					SyntaxPatterns:  []ir.PatternString{{Line: 269, Value: "fmt.Sprintf(\"%x\", $x)"}},
					ReportTemplate:  "$$ => strconv.FormatUint($x, 16)",
					SuggestTemplate: "strconv.FormatUint($x, 16)",
					WhereExpr: ir.FilterExpr{
						Line:  270,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`uint64`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 270, Op: ir.FilterStringOp, Src: "`uint64`", Value: "uint64"}},
					},
				},
				{
					Line: 272,
					SyntaxPatterns: []ir.PatternString{
						{Line: 272, Value: "fmt.Sprintf(\"%d\", $x)"},
						{Line: 272, Value: "fmt.Sprintf(\"%v\", $x)"},
						{Line: 272, Value: "fmt.Sprint($x)"},
					},
					ReportTemplate:  "$$ => strconv.FormatInt(int64($x), 10)",
					SuggestTemplate: "strconv.FormatInt(int64($x), 10)",
					WhereExpr: ir.FilterExpr{
						Line:  273,
						Op:    ir.FilterVarTypeOfKindOp,
						Src:   "m[\"x\"].Type.OfKind(`int`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 273, Op: ir.FilterStringOp, Src: "`int`", Value: "int"}},
					},
				},
				{
					Line:            274,
					SyntaxPatterns:  []ir.PatternString{{Line: 274, Value: "fmt.Sprintf(\"%x\", $x)"}},
					ReportTemplate:  "$$ => strconv.FormatInt(int64($x), 16)",
					SuggestTemplate: "strconv.FormatInt(int64($x), 16)",
					WhereExpr: ir.FilterExpr{
						Line:  275,
						Op:    ir.FilterVarTypeOfKindOp,
						Src:   "m[\"x\"].Type.OfKind(`int`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 275, Op: ir.FilterStringOp, Src: "`int`", Value: "int"}},
					},
				},
				{
					Line: 277,
					SyntaxPatterns: []ir.PatternString{
						{Line: 277, Value: "fmt.Sprintf(\"%d\", $x)"},
						{Line: 277, Value: "fmt.Sprintf(\"%v\", $x)"},
						{Line: 277, Value: "fmt.Sprint($x)"},
					},
					ReportTemplate:  "$$ => strconv.FormatUint(uint64($x), 10)",
					SuggestTemplate: "strconv.FormatUint(uint64($x), 10)",
					WhereExpr: ir.FilterExpr{
						Line:  278,
						Op:    ir.FilterVarTypeOfKindOp,
						Src:   "m[\"x\"].Type.OfKind(`uint`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 278, Op: ir.FilterStringOp, Src: "`uint`", Value: "uint"}},
					},
				},
				{
					Line:            279,
					SyntaxPatterns:  []ir.PatternString{{Line: 279, Value: "fmt.Sprintf(\"%x\", $x)"}},
					ReportTemplate:  "$$ => strconv.FormatUint(uint64($x), 16)",
					SuggestTemplate: "strconv.FormatUint(uint64($x), 16)",
					WhereExpr: ir.FilterExpr{
						Line:  280,
						Op:    ir.FilterVarTypeOfKindOp,
						Src:   "m[\"x\"].Type.OfKind(`uint`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 280, Op: ir.FilterStringOp, Src: "`uint`", Value: "uint"}},
					},
				},
			},
		},
		{
			Line:        287,
			Name:        "appendAPI",
			MatcherName: "m",
			DocTags:     []string{"o1", "score4"},
			DocSummary:  "Detects cases that can benefit from append-friendly APIs",
			DocBefore:   "b = append(b, strconv.Itoa(v)...)",
			DocAfter:    "b = strconv.AppendInt(b, v, 10)",
			Rules: []ir.Rule{
				{
					Line:            295,
					SyntaxPatterns:  []ir.PatternString{{Line: 295, Value: "$b = append($b, strconv.Itoa($x)...)"}},
					ReportTemplate:  "$$ => $b = strconv.AppendInt($b, int64($x), 10)",
					SuggestTemplate: "$b = strconv.AppendInt($b, int64($x), 10)",
				},
				{
					Line:            297,
					SyntaxPatterns:  []ir.PatternString{{Line: 297, Value: "$b = append($b, strconv.FormatInt($x, $base)...)"}},
					ReportTemplate:  "$$ => $b = strconv.AppendInt($b, $x, $base)",
					SuggestTemplate: "$b = strconv.AppendInt($b, $x, $base)",
				},
				{
					Line:            299,
					SyntaxPatterns:  []ir.PatternString{{Line: 299, Value: "$b = append($b, strconv.FormatUint($x, $base)...)"}},
					ReportTemplate:  "$$ => $b = strconv.AppendUint($b, $x, $base)",
					SuggestTemplate: "$b = strconv.AppendUint($b, $x, $base)",
				},
				{
					Line:            302,
					SyntaxPatterns:  []ir.PatternString{{Line: 302, Value: "$b = append($b, $t.Format($layout)...)"}},
					ReportTemplate:  "$$ => $b = $t.AppendFormat($b, $layout)",
					SuggestTemplate: "$b = $t.AppendFormat($b, $layout)",
					WhereExpr: ir.FilterExpr{
						Line: 303,
						Op:   ir.FilterOrOp,
						Src:  "m[\"t\"].Type.Is(`time.Time`) || m[\"t\"].Type.Is(`*time.Time`)",
						Args: []ir.FilterExpr{
							{
								Line:  303,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"t\"].Type.Is(`time.Time`)",
								Value: "t",
								Args:  []ir.FilterExpr{{Line: 303, Op: ir.FilterStringOp, Src: "`time.Time`", Value: "time.Time"}},
							},
							{
								Line:  303,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"t\"].Type.Is(`*time.Time`)",
								Value: "t",
								Args:  []ir.FilterExpr{{Line: 303, Op: ir.FilterStringOp, Src: "`*time.Time`", Value: "*time.Time"}},
							},
						},
					},
				},
				{
					Line:            306,
					SyntaxPatterns:  []ir.PatternString{{Line: 306, Value: "$b = append($b, $v.String()...)"}},
					ReportTemplate:  "$$ => $b = $v.Append($b, 'g', 10)",
					SuggestTemplate: "$b = $v.Append($b, 'g', 10)",
					WhereExpr: ir.FilterExpr{
						Line: 307,
						Op:   ir.FilterOrOp,
						Src:  "m[\"v\"].Type.Is(`big.Float`) || m[\"v\"].Type.Is(`*big.Float`)",
						Args: []ir.FilterExpr{
							{
								Line:  307,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"v\"].Type.Is(`big.Float`)",
								Value: "v",
								Args:  []ir.FilterExpr{{Line: 307, Op: ir.FilterStringOp, Src: "`big.Float`", Value: "big.Float"}},
							},
							{
								Line:  307,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"v\"].Type.Is(`*big.Float`)",
								Value: "v",
								Args:  []ir.FilterExpr{{Line: 307, Op: ir.FilterStringOp, Src: "`*big.Float`", Value: "*big.Float"}},
							},
						},
					},
				},
				{
					Line:            309,
					SyntaxPatterns:  []ir.PatternString{{Line: 309, Value: "$b = append($b, $v.Text($format, $prec)...)"}},
					ReportTemplate:  "$$ => $b = $v.Append($b, $format, $prec)",
					SuggestTemplate: "$b = $v.Append($b, $format, $prec)",
					WhereExpr: ir.FilterExpr{
						Line: 310,
						Op:   ir.FilterOrOp,
						Src:  "m[\"v\"].Type.Is(`big.Float`) || m[\"v\"].Type.Is(`*big.Float`)",
						Args: []ir.FilterExpr{
							{
								Line:  310,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"v\"].Type.Is(`big.Float`)",
								Value: "v",
								Args:  []ir.FilterExpr{{Line: 310, Op: ir.FilterStringOp, Src: "`big.Float`", Value: "big.Float"}},
							},
							{
								Line:  310,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"v\"].Type.Is(`*big.Float`)",
								Value: "v",
								Args:  []ir.FilterExpr{{Line: 310, Op: ir.FilterStringOp, Src: "`*big.Float`", Value: "*big.Float"}},
							},
						},
					},
				},
				{
					Line:            313,
					SyntaxPatterns:  []ir.PatternString{{Line: 313, Value: "$b = append($b, $v.String()...)"}},
					ReportTemplate:  "$$ => $b = $v.Append($b, 10)",
					SuggestTemplate: "$b = $v.Append($b, 10)",
					WhereExpr: ir.FilterExpr{
						Line: 314,
						Op:   ir.FilterOrOp,
						Src:  "m[\"v\"].Type.Is(`big.Int`) || m[\"v\"].Type.Is(`*big.Int`)",
						Args: []ir.FilterExpr{
							{
								Line:  314,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"v\"].Type.Is(`big.Int`)",
								Value: "v",
								Args:  []ir.FilterExpr{{Line: 314, Op: ir.FilterStringOp, Src: "`big.Int`", Value: "big.Int"}},
							},
							{
								Line:  314,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"v\"].Type.Is(`*big.Int`)",
								Value: "v",
								Args:  []ir.FilterExpr{{Line: 314, Op: ir.FilterStringOp, Src: "`*big.Int`", Value: "*big.Int"}},
							},
						},
					},
				},
				{
					Line:            316,
					SyntaxPatterns:  []ir.PatternString{{Line: 316, Value: "$b = append($b, $v.Text($base)...)"}},
					ReportTemplate:  "$$ => $b = $v.Append($b, $base)",
					SuggestTemplate: "$b = $v.Append($b, $base)",
					WhereExpr: ir.FilterExpr{
						Line: 317,
						Op:   ir.FilterOrOp,
						Src:  "m[\"v\"].Type.Is(`big.Int`) || m[\"v\"].Type.Is(`*big.Int`)",
						Args: []ir.FilterExpr{
							{
								Line:  317,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"v\"].Type.Is(`big.Int`)",
								Value: "v",
								Args:  []ir.FilterExpr{{Line: 317, Op: ir.FilterStringOp, Src: "`big.Int`", Value: "big.Int"}},
							},
							{
								Line:  317,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"v\"].Type.Is(`*big.Int`)",
								Value: "v",
								Args:  []ir.FilterExpr{{Line: 317, Op: ir.FilterStringOp, Src: "`*big.Int`", Value: "*big.Int"}},
							},
						},
					},
				},
			},
		},
		{
			Line:        325,
			Name:        "convReorder",
			MatcherName: "m",
			DocTags:     []string{"o1", "score2"},
			DocSummary:  "Detects patterns that can be reordered to make the code faster",
			DocBefore:   "strings.TrimSpace(string(b))",
			DocAfter:    "string(bytes.TrimSpace(b))",
			Rules: []ir.Rule{
				{
					Line:            331,
					SyntaxPatterns:  []ir.PatternString{{Line: 331, Value: "strings.TrimSpace(string($b))"}},
					ReportTemplate:  "$$ => string(bytes.TrimSpace($b))",
					SuggestTemplate: "string(bytes.TrimSpace($b))",
					WhereExpr: ir.FilterExpr{
						Line:  332,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"b\"].Type.Is(`[]byte`)",
						Value: "b",
						Args:  []ir.FilterExpr{{Line: 332, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
					},
				},
				{
					Line:            335,
					SyntaxPatterns:  []ir.PatternString{{Line: 335, Value: "bytes.TrimSpace([]byte($s))"}},
					ReportTemplate:  "$$ => []byte(strings.TrimSpace($s))",
					SuggestTemplate: "[]byte(strings.TrimSpace($s))",
					WhereExpr: ir.FilterExpr{
						Line:  336,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"s\"].Type.Is(`string`)",
						Value: "s",
						Args:  []ir.FilterExpr{{Line: 336, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
					},
				},
				{
					Line:            339,
					SyntaxPatterns:  []ir.PatternString{{Line: 339, Value: "strings.TrimPrefix(string($b1), string($b2))"}},
					ReportTemplate:  "$$ => string(bytes.TrimPrefix($b1, $b2))",
					SuggestTemplate: "string(bytes.TrimPrefix($b1, $b2))",
					WhereExpr: ir.FilterExpr{
						Line: 340,
						Op:   ir.FilterAndOp,
						Src:  "m[\"b1\"].Type.Is(`[]byte`) && m[\"b2\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line:  340,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b1\"].Type.Is(`[]byte`)",
								Value: "b1",
								Args:  []ir.FilterExpr{{Line: 340, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
							{
								Line:  340,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b2\"].Type.Is(`[]byte`)",
								Value: "b2",
								Args:  []ir.FilterExpr{{Line: 340, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            343,
					SyntaxPatterns:  []ir.PatternString{{Line: 343, Value: "bytes.TrimPrefix([]byte($s1), []byte($s2))"}},
					ReportTemplate:  "$$ => []byte(strings.TrimPrefix($s1, $s2))",
					SuggestTemplate: "[]byte(strings.TrimPrefix($s1, $s2))",
					WhereExpr: ir.FilterExpr{
						Line: 344,
						Op:   ir.FilterAndOp,
						Src:  "m[\"s1\"].Type.Is(`string`) && m[\"s2\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line:  344,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s1\"].Type.Is(`string`)",
								Value: "s1",
								Args:  []ir.FilterExpr{{Line: 344, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
							{
								Line:  344,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s2\"].Type.Is(`string`)",
								Value: "s2",
								Args:  []ir.FilterExpr{{Line: 344, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
			},
		},
		{
			Line:        352,
			Name:        "slicedConv",
			MatcherName: "m",
			DocTags:     []string{"o1", "score3"},
			DocSummary:  "Detects sliced slice copying that can be optimized",
			DocBefore:   "string(b)[:n]",
			DocAfter:    "string(b[:n])",
			Rules: []ir.Rule{
				{
					Line:            353,
					SyntaxPatterns:  []ir.PatternString{{Line: 353, Value: "string($b)[:$n]"}},
					ReportTemplate:  "$$ => string($b[:$n])",
					SuggestTemplate: "string($b[:$n])",
					WhereExpr: ir.FilterExpr{
						Line:  354,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"b\"].Type.Is(`[]byte`)",
						Value: "b",
						Args:  []ir.FilterExpr{{Line: 354, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
					},
				},
				{
					Line:            357,
					SyntaxPatterns:  []ir.PatternString{{Line: 357, Value: "[]byte($s)[:$n]"}},
					ReportTemplate:  "$$ => []byte($s[:$n])",
					SuggestTemplate: "[]byte($s[:$n])",
					WhereExpr: ir.FilterExpr{
						Line:  358,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"s\"].Type.Is(`string`)",
						Value: "s",
						Args:  []ir.FilterExpr{{Line: 358, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
					},
				},
			},
		},
		{
			Line:        366,
			Name:        "stringCopyElim",
			MatcherName: "m",
			DocTags:     []string{"o1", "score4"},
			DocSummary:  "Detects redundant conversions between string and []byte",
			DocBefore:   "copy(b, []byte(s))",
			DocAfter:    "copy(b, s)",
			Rules: []ir.Rule{
				{
					Line:            367,
					SyntaxPatterns:  []ir.PatternString{{Line: 367, Value: "copy($b, []byte($s))"}},
					ReportTemplate:  "$$ => copy($b, $s)",
					SuggestTemplate: "copy($b, $s)",
					WhereExpr: ir.FilterExpr{
						Line:  368,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"s\"].Type.Is(`string`)",
						Value: "s",
						Args:  []ir.FilterExpr{{Line: 368, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
					},
				},
				{
					Line:            371,
					SyntaxPatterns:  []ir.PatternString{{Line: 371, Value: "append($b, []byte($s)...)"}},
					ReportTemplate:  "$$ => append($b, $s...)",
					SuggestTemplate: "append($b, $s...)",
					WhereExpr: ir.FilterExpr{
						Line:  372,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"s\"].Type.Is(`string`)",
						Value: "s",
						Args:  []ir.FilterExpr{{Line: 372, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
					},
				},
				{
					Line:            375,
					SyntaxPatterns:  []ir.PatternString{{Line: 375, Value: "append($b, string($b2)...)"}},
					ReportTemplate:  "$$ => append($b, $b2...)",
					SuggestTemplate: "append($b, $b2...)",
					WhereExpr: ir.FilterExpr{
						Line:  376,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"b2\"].Type.Is(`[]byte`)",
						Value: "b2",
						Args:  []ir.FilterExpr{{Line: 376, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
					},
				},
				{
					Line:            379,
					SyntaxPatterns:  []ir.PatternString{{Line: 379, Value: "len(string($b))"}},
					ReportTemplate:  "$$ => len($b)",
					SuggestTemplate: "len($b)",
					WhereExpr: ir.FilterExpr{
						Line:  379,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"b\"].Type.Is(`[]byte`)",
						Value: "b",
						Args:  []ir.FilterExpr{{Line: 379, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
					},
				},
				{
					Line:            381,
					SyntaxPatterns:  []ir.PatternString{{Line: 381, Value: "[]byte(strings.$f(string($b)))"}},
					ReportTemplate:  "$$ => bytes.$f($b)",
					SuggestTemplate: "bytes.$f($b)",
					WhereExpr: ir.FilterExpr{
						Line: 382,
						Op:   ir.FilterAndOp,
						Src:  "m[\"b\"].Type.Is(`[]byte`) &&\n\tm[\"f\"].Text.Matches(`ToUpper|ToLower|TrimSpace`)",
						Args: []ir.FilterExpr{
							{
								Line:  382,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b\"].Type.Is(`[]byte`)",
								Value: "b",
								Args:  []ir.FilterExpr{{Line: 382, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
							{
								Line:  383,
								Op:    ir.FilterVarTextMatchesOp,
								Src:   "m[\"f\"].Text.Matches(`ToUpper|ToLower|TrimSpace`)",
								Value: "f",
								Args:  []ir.FilterExpr{{Line: 383, Op: ir.FilterStringOp, Src: "`ToUpper|ToLower|TrimSpace`", Value: "ToUpper|ToLower|TrimSpace"}},
							},
						},
					},
				},
				{
					Line:            386,
					SyntaxPatterns:  []ir.PatternString{{Line: 386, Value: "[]byte(strings.$f(string($b), $s2))"}},
					ReportTemplate:  "$$ => bytes.$f($b, []byte($s2))",
					SuggestTemplate: "bytes.$f($b, []byte($s2))",
					WhereExpr: ir.FilterExpr{
						Line: 387,
						Op:   ir.FilterAndOp,
						Src:  "m[\"b\"].Type.Is(`[]byte`) &&\n\tm[\"f\"].Text.Matches(`TrimPrefix|TrimSuffix`)",
						Args: []ir.FilterExpr{
							{
								Line:  387,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b\"].Type.Is(`[]byte`)",
								Value: "b",
								Args:  []ir.FilterExpr{{Line: 387, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
							{
								Line:  388,
								Op:    ir.FilterVarTextMatchesOp,
								Src:   "m[\"f\"].Text.Matches(`TrimPrefix|TrimSuffix`)",
								Value: "f",
								Args:  []ir.FilterExpr{{Line: 388, Op: ir.FilterStringOp, Src: "`TrimPrefix|TrimSuffix`", Value: "TrimPrefix|TrimSuffix"}},
							},
						},
					},
				},
				{
					Line:            391,
					SyntaxPatterns:  []ir.PatternString{{Line: 391, Value: "bytes.NewReader([]byte($x))"}},
					ReportTemplate:  "$$ => strings.NewReader($x)",
					SuggestTemplate: "strings.NewReader($x)",
					WhereExpr: ir.FilterExpr{
						Line:  392,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`string`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 392, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
					},
				},
				{
					Line:            395,
					SyntaxPatterns:  []ir.PatternString{{Line: 395, Value: "strings.NewReader(string($x))"}},
					ReportTemplate:  "$$ => bytes.NewReader($x)",
					SuggestTemplate: "bytes.NewReader($x)",
					WhereExpr: ir.FilterExpr{
						Line:  396,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`[]byte`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 396, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
					},
				},
			},
		},
		{
			Line:        404,
			Name:        "regexpStringCopyElim",
			MatcherName: "m",
			DocTags:     []string{"o1", "score3"},
			DocSummary:  "Detects inefficient regexp usage in regard to string/[]byte conversions",
			DocBefore:   "regexp.ReplaceAll([]byte(s), []byte(\"foo\"))",
			DocAfter:    "regexp.ReplaceAllString(s, \"foo\")",
			Rules: []ir.Rule{
				{
					Line:            407,
					SyntaxPatterns:  []ir.PatternString{{Line: 407, Value: "$re.Match([]byte($s))"}},
					ReportTemplate:  "$$ => $re.MatchString($s)",
					SuggestTemplate: "$re.MatchString($s)",
					WhereExpr: ir.FilterExpr{
						Line: 408,
						Op:   ir.FilterAndOp,
						Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"s\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line:  408,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"re\"].Type.Is(`*regexp.Regexp`)",
								Value: "re",
								Args:  []ir.FilterExpr{{Line: 408, Op: ir.FilterStringOp, Src: "`*regexp.Regexp`", Value: "*regexp.Regexp"}},
							},
							{
								Line:  408,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 408, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            411,
					SyntaxPatterns:  []ir.PatternString{{Line: 411, Value: "$re.FindIndex([]byte($s))"}},
					ReportTemplate:  "$$ => $re.FindStringIndex($s)",
					SuggestTemplate: "$re.FindStringIndex($s)",
					WhereExpr: ir.FilterExpr{
						Line: 412,
						Op:   ir.FilterAndOp,
						Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"s\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line:  412,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"re\"].Type.Is(`*regexp.Regexp`)",
								Value: "re",
								Args:  []ir.FilterExpr{{Line: 412, Op: ir.FilterStringOp, Src: "`*regexp.Regexp`", Value: "*regexp.Regexp"}},
							},
							{
								Line:  412,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 412, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            415,
					SyntaxPatterns:  []ir.PatternString{{Line: 415, Value: "$re.FindAllIndex([]byte($s), $n)"}},
					ReportTemplate:  "$$ => $re.FindAllStringIndex($s, $n)",
					SuggestTemplate: "$re.FindAllStringIndex($s, $n)",
					WhereExpr: ir.FilterExpr{
						Line: 416,
						Op:   ir.FilterAndOp,
						Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"s\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line:  416,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"re\"].Type.Is(`*regexp.Regexp`)",
								Value: "re",
								Args:  []ir.FilterExpr{{Line: 416, Op: ir.FilterStringOp, Src: "`*regexp.Regexp`", Value: "*regexp.Regexp"}},
							},
							{
								Line:  416,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 416, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            419,
					SyntaxPatterns:  []ir.PatternString{{Line: 419, Value: "string($re.ReplaceAll([]byte($s), []byte($s2)))"}},
					ReportTemplate:  "$$ => $re.ReplaceAllString($s, $s2)",
					SuggestTemplate: "$re.ReplaceAllString($s, $s2)",
					WhereExpr: ir.FilterExpr{
						Line: 420,
						Op:   ir.FilterAndOp,
						Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"s\"].Type.Is(`string`) && m[\"s2\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line: 420,
								Op:   ir.FilterAndOp,
								Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"s\"].Type.Is(`string`)",
								Args: []ir.FilterExpr{
									{
										Line:  420,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"re\"].Type.Is(`*regexp.Regexp`)",
										Value: "re",
										Args:  []ir.FilterExpr{{Line: 420, Op: ir.FilterStringOp, Src: "`*regexp.Regexp`", Value: "*regexp.Regexp"}},
									},
									{
										Line:  420,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"s\"].Type.Is(`string`)",
										Value: "s",
										Args:  []ir.FilterExpr{{Line: 420, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
									},
								},
							},
							{
								Line:  420,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s2\"].Type.Is(`string`)",
								Value: "s2",
								Args:  []ir.FilterExpr{{Line: 420, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            423,
					SyntaxPatterns:  []ir.PatternString{{Line: 423, Value: "string($re.ReplaceAll([]byte($s), $b))"}},
					ReportTemplate:  "$$ => $re.ReplaceAllString($s, string($b))",
					SuggestTemplate: "$re.ReplaceAllString($s, string($b))",
					WhereExpr: ir.FilterExpr{
						Line: 424,
						Op:   ir.FilterAndOp,
						Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"s\"].Type.Is(`string`) && m[\"b\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line: 424,
								Op:   ir.FilterAndOp,
								Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"s\"].Type.Is(`string`)",
								Args: []ir.FilterExpr{
									{
										Line:  424,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"re\"].Type.Is(`*regexp.Regexp`)",
										Value: "re",
										Args:  []ir.FilterExpr{{Line: 424, Op: ir.FilterStringOp, Src: "`*regexp.Regexp`", Value: "*regexp.Regexp"}},
									},
									{
										Line:  424,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"s\"].Type.Is(`string`)",
										Value: "s",
										Args:  []ir.FilterExpr{{Line: 424, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
									},
								},
							},
							{
								Line:  424,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b\"].Type.Is(`[]byte`)",
								Value: "b",
								Args:  []ir.FilterExpr{{Line: 424, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            429,
					SyntaxPatterns:  []ir.PatternString{{Line: 429, Value: "$re.MatchString(string($b))"}},
					ReportTemplate:  "$$ => $re.Match($b)",
					SuggestTemplate: "$re.Match($b)",
					WhereExpr: ir.FilterExpr{
						Line: 430,
						Op:   ir.FilterAndOp,
						Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"b\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line:  430,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"re\"].Type.Is(`*regexp.Regexp`)",
								Value: "re",
								Args:  []ir.FilterExpr{{Line: 430, Op: ir.FilterStringOp, Src: "`*regexp.Regexp`", Value: "*regexp.Regexp"}},
							},
							{
								Line:  430,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b\"].Type.Is(`[]byte`)",
								Value: "b",
								Args:  []ir.FilterExpr{{Line: 430, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            433,
					SyntaxPatterns:  []ir.PatternString{{Line: 433, Value: "$re.FindStringIndex(string($b))"}},
					ReportTemplate:  "$$ => $re.FindIndex($b)",
					SuggestTemplate: "$re.FindIndex($b)",
					WhereExpr: ir.FilterExpr{
						Line: 434,
						Op:   ir.FilterAndOp,
						Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"b\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line:  434,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"re\"].Type.Is(`*regexp.Regexp`)",
								Value: "re",
								Args:  []ir.FilterExpr{{Line: 434, Op: ir.FilterStringOp, Src: "`*regexp.Regexp`", Value: "*regexp.Regexp"}},
							},
							{
								Line:  434,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b\"].Type.Is(`[]byte`)",
								Value: "b",
								Args:  []ir.FilterExpr{{Line: 434, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            437,
					SyntaxPatterns:  []ir.PatternString{{Line: 437, Value: "$re.FindAllStringIndex(string($b), $n)"}},
					ReportTemplate:  "$$ => $re.FindAllIndex($b, $n)",
					SuggestTemplate: "$re.FindAllIndex($b, $n)",
					WhereExpr: ir.FilterExpr{
						Line: 438,
						Op:   ir.FilterAndOp,
						Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"b\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line:  438,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"re\"].Type.Is(`*regexp.Regexp`)",
								Value: "re",
								Args:  []ir.FilterExpr{{Line: 438, Op: ir.FilterStringOp, Src: "`*regexp.Regexp`", Value: "*regexp.Regexp"}},
							},
							{
								Line:  438,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b\"].Type.Is(`[]byte`)",
								Value: "b",
								Args:  []ir.FilterExpr{{Line: 438, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            441,
					SyntaxPatterns:  []ir.PatternString{{Line: 441, Value: "[]byte($re.ReplaceAllString(string($b), string($b2)))"}},
					ReportTemplate:  "$$ => $re.ReplaceAll($b, $b2)",
					SuggestTemplate: "$re.ReplaceAll($b, $b2)",
					WhereExpr: ir.FilterExpr{
						Line: 442,
						Op:   ir.FilterAndOp,
						Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"b\"].Type.Is(`[]byte`) && m[\"b2\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line: 442,
								Op:   ir.FilterAndOp,
								Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"b\"].Type.Is(`[]byte`)",
								Args: []ir.FilterExpr{
									{
										Line:  442,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"re\"].Type.Is(`*regexp.Regexp`)",
										Value: "re",
										Args:  []ir.FilterExpr{{Line: 442, Op: ir.FilterStringOp, Src: "`*regexp.Regexp`", Value: "*regexp.Regexp"}},
									},
									{
										Line:  442,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"b\"].Type.Is(`[]byte`)",
										Value: "b",
										Args:  []ir.FilterExpr{{Line: 442, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
									},
								},
							},
							{
								Line:  442,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b2\"].Type.Is(`[]byte`)",
								Value: "b2",
								Args:  []ir.FilterExpr{{Line: 442, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            445,
					SyntaxPatterns:  []ir.PatternString{{Line: 445, Value: "[]byte($re.ReplaceAllString(string($b), $s))"}},
					ReportTemplate:  "$$ => $re.ReplaceAll($b, []byte($s))",
					SuggestTemplate: "$re.ReplaceAll($b, []byte($s))",
					WhereExpr: ir.FilterExpr{
						Line: 446,
						Op:   ir.FilterAndOp,
						Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"b\"].Type.Is(`[]byte`) && m[\"s\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line: 446,
								Op:   ir.FilterAndOp,
								Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"b\"].Type.Is(`[]byte`)",
								Args: []ir.FilterExpr{
									{
										Line:  446,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"re\"].Type.Is(`*regexp.Regexp`)",
										Value: "re",
										Args:  []ir.FilterExpr{{Line: 446, Op: ir.FilterStringOp, Src: "`*regexp.Regexp`", Value: "*regexp.Regexp"}},
									},
									{
										Line:  446,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"b\"].Type.Is(`[]byte`)",
										Value: "b",
										Args:  []ir.FilterExpr{{Line: 446, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
									},
								},
							},
							{
								Line:  446,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 446, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
			},
		},
		{
			Line:        455,
			Name:        "indexAlloc",
			MatcherName: "m",
			DocTags:     []string{"o1", "score3"},
			DocSummary:  "Detects strings.Index()-like calls that may allocate more than they should",
			DocBefore:   "strings.Index(string(x), y)",
			DocAfter:    "bytes.Index(x, []byte(y))",
			DocNote:     "See Go issue for details: https://github.com/golang/go/issues/25864",
			Rules: []ir.Rule{
				{
					Line:            459,
					SyntaxPatterns:  []ir.PatternString{{Line: 459, Value: "strings.$f(string($b1), string($b2))"}},
					ReportTemplate:  "$$ => bytes.$f($b1, $b2)",
					SuggestTemplate: "bytes.$f($b1, $b2)",
					WhereExpr: ir.FilterExpr{
						Line: 460,
						Op:   ir.FilterAndOp,
						Src:  "m[\"f\"].Text.Matches(`Compare|Contains|HasPrefix|HasSuffix|EqualFold`) &&\n\tm[\"b1\"].Type.Is(`[]byte`) && m[\"b2\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line: 460,
								Op:   ir.FilterAndOp,
								Src:  "m[\"f\"].Text.Matches(`Compare|Contains|HasPrefix|HasSuffix|EqualFold`) &&\n\tm[\"b1\"].Type.Is(`[]byte`)",
								Args: []ir.FilterExpr{
									{
										Line:  460,
										Op:    ir.FilterVarTextMatchesOp,
										Src:   "m[\"f\"].Text.Matches(`Compare|Contains|HasPrefix|HasSuffix|EqualFold`)",
										Value: "f",
										Args:  []ir.FilterExpr{{Line: 460, Op: ir.FilterStringOp, Src: "`Compare|Contains|HasPrefix|HasSuffix|EqualFold`", Value: "Compare|Contains|HasPrefix|HasSuffix|EqualFold"}},
									},
									{
										Line:  461,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"b1\"].Type.Is(`[]byte`)",
										Value: "b1",
										Args:  []ir.FilterExpr{{Line: 461, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
									},
								},
							},
							{
								Line:  461,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b2\"].Type.Is(`[]byte`)",
								Value: "b2",
								Args:  []ir.FilterExpr{{Line: 461, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            464,
					SyntaxPatterns:  []ir.PatternString{{Line: 464, Value: "bytes.$f([]byte($s1), []byte($s2))"}},
					ReportTemplate:  "$$ => strings.$f($s1, $s2)",
					SuggestTemplate: "strings.$f($s1, $s2)",
					WhereExpr: ir.FilterExpr{
						Line: 465,
						Op:   ir.FilterAndOp,
						Src:  "m[\"f\"].Text.Matches(`Compare|Contains|HasPrefix|HasSuffix|EqualFold`) &&\n\tm[\"s1\"].Type.Is(`string`) && m[\"s2\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line: 465,
								Op:   ir.FilterAndOp,
								Src:  "m[\"f\"].Text.Matches(`Compare|Contains|HasPrefix|HasSuffix|EqualFold`) &&\n\tm[\"s1\"].Type.Is(`string`)",
								Args: []ir.FilterExpr{
									{
										Line:  465,
										Op:    ir.FilterVarTextMatchesOp,
										Src:   "m[\"f\"].Text.Matches(`Compare|Contains|HasPrefix|HasSuffix|EqualFold`)",
										Value: "f",
										Args:  []ir.FilterExpr{{Line: 465, Op: ir.FilterStringOp, Src: "`Compare|Contains|HasPrefix|HasSuffix|EqualFold`", Value: "Compare|Contains|HasPrefix|HasSuffix|EqualFold"}},
									},
									{
										Line:  466,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"s1\"].Type.Is(`string`)",
										Value: "s1",
										Args:  []ir.FilterExpr{{Line: 466, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
									},
								},
							},
							{
								Line:  466,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s2\"].Type.Is(`string`)",
								Value: "s2",
								Args:  []ir.FilterExpr{{Line: 466, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            475,
					SyntaxPatterns:  []ir.PatternString{{Line: 475, Value: "strings.Index(string($x), $y)"}},
					ReportTemplate:  "$$ => bytes.Index($x, []byte($y))",
					SuggestTemplate: "bytes.Index($x, []byte($y))",
					WhereExpr: ir.FilterExpr{
						Line: 475,
						Op:   ir.FilterAndOp,
						Src:  "canOptimizeStrings(m)",
						Args: []ir.FilterExpr{
							{
								Line: 475,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure &&\n\t!m[\"y\"].Node.Is(`CallExpr`)",
								Args: []ir.FilterExpr{
									{
										Line: 475,
										Op:   ir.FilterAndOp,
										Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure",
										Args: []ir.FilterExpr{
											{Line: 475, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
											{Line: 475, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
										},
									},
									{
										Line: 471,
										Op:   ir.FilterNotOp,
										Src:  "!m[\"y\"].Node.Is(`CallExpr`)",
										Args: []ir.FilterExpr{{
											Line:  475,
											Op:    ir.FilterVarNodeIsOp,
											Src:   "m[\"y\"].Node.Is(`CallExpr`)",
											Value: "y",
											Args:  []ir.FilterExpr{{Line: 471, Op: ir.FilterStringOp, Src: "`CallExpr`", Value: "CallExpr"}},
										}},
									},
								},
							},
							{
								Line:  475,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"x\"].Type.Is(`[]byte`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 472, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            476,
					SyntaxPatterns:  []ir.PatternString{{Line: 476, Value: "strings.Contains(string($x), $y)"}},
					ReportTemplate:  "$$ => bytes.Contains($x, []byte($y))",
					SuggestTemplate: "bytes.Contains($x, []byte($y))",
					WhereExpr: ir.FilterExpr{
						Line: 476,
						Op:   ir.FilterAndOp,
						Src:  "canOptimizeStrings(m)",
						Args: []ir.FilterExpr{
							{
								Line: 476,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure &&\n\t!m[\"y\"].Node.Is(`CallExpr`)",
								Args: []ir.FilterExpr{
									{
										Line: 476,
										Op:   ir.FilterAndOp,
										Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure",
										Args: []ir.FilterExpr{
											{Line: 476, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
											{Line: 476, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
										},
									},
									{
										Line: 471,
										Op:   ir.FilterNotOp,
										Src:  "!m[\"y\"].Node.Is(`CallExpr`)",
										Args: []ir.FilterExpr{{
											Line:  476,
											Op:    ir.FilterVarNodeIsOp,
											Src:   "m[\"y\"].Node.Is(`CallExpr`)",
											Value: "y",
											Args:  []ir.FilterExpr{{Line: 471, Op: ir.FilterStringOp, Src: "`CallExpr`", Value: "CallExpr"}},
										}},
									},
								},
							},
							{
								Line:  476,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"x\"].Type.Is(`[]byte`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 472, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            477,
					SyntaxPatterns:  []ir.PatternString{{Line: 477, Value: "strings.HasPrefix(string($x), $y)"}},
					ReportTemplate:  "$$ => bytes.HasPrefix($x, []byte($y))",
					SuggestTemplate: "bytes.HasPrefix($x, []byte($y))",
					WhereExpr: ir.FilterExpr{
						Line: 477,
						Op:   ir.FilterAndOp,
						Src:  "canOptimizeStrings(m)",
						Args: []ir.FilterExpr{
							{
								Line: 477,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure &&\n\t!m[\"y\"].Node.Is(`CallExpr`)",
								Args: []ir.FilterExpr{
									{
										Line: 477,
										Op:   ir.FilterAndOp,
										Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure",
										Args: []ir.FilterExpr{
											{Line: 477, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
											{Line: 477, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
										},
									},
									{
										Line: 471,
										Op:   ir.FilterNotOp,
										Src:  "!m[\"y\"].Node.Is(`CallExpr`)",
										Args: []ir.FilterExpr{{
											Line:  477,
											Op:    ir.FilterVarNodeIsOp,
											Src:   "m[\"y\"].Node.Is(`CallExpr`)",
											Value: "y",
											Args:  []ir.FilterExpr{{Line: 471, Op: ir.FilterStringOp, Src: "`CallExpr`", Value: "CallExpr"}},
										}},
									},
								},
							},
							{
								Line:  477,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"x\"].Type.Is(`[]byte`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 472, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            478,
					SyntaxPatterns:  []ir.PatternString{{Line: 478, Value: "strings.HasSuffix(string($x), $y)"}},
					ReportTemplate:  "$$ => bytes.HasSuffix($x, []byte($y))",
					SuggestTemplate: "bytes.HasSuffix($x, []byte($y))",
					WhereExpr: ir.FilterExpr{
						Line: 478,
						Op:   ir.FilterAndOp,
						Src:  "canOptimizeStrings(m)",
						Args: []ir.FilterExpr{
							{
								Line: 478,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure &&\n\t!m[\"y\"].Node.Is(`CallExpr`)",
								Args: []ir.FilterExpr{
									{
										Line: 478,
										Op:   ir.FilterAndOp,
										Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure",
										Args: []ir.FilterExpr{
											{Line: 478, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
											{Line: 478, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
										},
									},
									{
										Line: 471,
										Op:   ir.FilterNotOp,
										Src:  "!m[\"y\"].Node.Is(`CallExpr`)",
										Args: []ir.FilterExpr{{
											Line:  478,
											Op:    ir.FilterVarNodeIsOp,
											Src:   "m[\"y\"].Node.Is(`CallExpr`)",
											Value: "y",
											Args:  []ir.FilterExpr{{Line: 471, Op: ir.FilterStringOp, Src: "`CallExpr`", Value: "CallExpr"}},
										}},
									},
								},
							},
							{
								Line:  478,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"x\"].Type.Is(`[]byte`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 472, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            486,
					SyntaxPatterns:  []ir.PatternString{{Line: 486, Value: "bytes.Index([]byte($x), $y)"}},
					ReportTemplate:  "$$ => strings.Index($x, string($y))",
					SuggestTemplate: "strings.Index($x, string($y))",
					WhereExpr: ir.FilterExpr{
						Line: 486,
						Op:   ir.FilterAndOp,
						Src:  "canOptimizeBytes(m)",
						Args: []ir.FilterExpr{
							{
								Line: 486,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure &&\n\t!m[\"y\"].Node.Is(`CallExpr`)",
								Args: []ir.FilterExpr{
									{
										Line: 486,
										Op:   ir.FilterAndOp,
										Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure",
										Args: []ir.FilterExpr{
											{Line: 486, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
											{Line: 486, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
										},
									},
									{
										Line: 482,
										Op:   ir.FilterNotOp,
										Src:  "!m[\"y\"].Node.Is(`CallExpr`)",
										Args: []ir.FilterExpr{{
											Line:  486,
											Op:    ir.FilterVarNodeIsOp,
											Src:   "m[\"y\"].Node.Is(`CallExpr`)",
											Value: "y",
											Args:  []ir.FilterExpr{{Line: 482, Op: ir.FilterStringOp, Src: "`CallExpr`", Value: "CallExpr"}},
										}},
									},
								},
							},
							{
								Line:  486,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"x\"].Type.Is(`string`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 483, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            487,
					SyntaxPatterns:  []ir.PatternString{{Line: 487, Value: "bytes.Contains([]byte($x), $y)"}},
					ReportTemplate:  "$$ => strings.Contains($x, string($y))",
					SuggestTemplate: "strings.Contains($x, string($y))",
					WhereExpr: ir.FilterExpr{
						Line: 487,
						Op:   ir.FilterAndOp,
						Src:  "canOptimizeBytes(m)",
						Args: []ir.FilterExpr{
							{
								Line: 487,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure &&\n\t!m[\"y\"].Node.Is(`CallExpr`)",
								Args: []ir.FilterExpr{
									{
										Line: 487,
										Op:   ir.FilterAndOp,
										Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure",
										Args: []ir.FilterExpr{
											{Line: 487, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
											{Line: 487, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
										},
									},
									{
										Line: 482,
										Op:   ir.FilterNotOp,
										Src:  "!m[\"y\"].Node.Is(`CallExpr`)",
										Args: []ir.FilterExpr{{
											Line:  487,
											Op:    ir.FilterVarNodeIsOp,
											Src:   "m[\"y\"].Node.Is(`CallExpr`)",
											Value: "y",
											Args:  []ir.FilterExpr{{Line: 482, Op: ir.FilterStringOp, Src: "`CallExpr`", Value: "CallExpr"}},
										}},
									},
								},
							},
							{
								Line:  487,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"x\"].Type.Is(`string`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 483, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            488,
					SyntaxPatterns:  []ir.PatternString{{Line: 488, Value: "bytes.HasPrefix([]byte($x), $y)"}},
					ReportTemplate:  "$$ => strings.HasPrefix($x, string($y))",
					SuggestTemplate: "strings.HasPrefix($x, string($y))",
					WhereExpr: ir.FilterExpr{
						Line: 488,
						Op:   ir.FilterAndOp,
						Src:  "canOptimizeBytes(m)",
						Args: []ir.FilterExpr{
							{
								Line: 488,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure &&\n\t!m[\"y\"].Node.Is(`CallExpr`)",
								Args: []ir.FilterExpr{
									{
										Line: 488,
										Op:   ir.FilterAndOp,
										Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure",
										Args: []ir.FilterExpr{
											{Line: 488, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
											{Line: 488, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
										},
									},
									{
										Line: 482,
										Op:   ir.FilterNotOp,
										Src:  "!m[\"y\"].Node.Is(`CallExpr`)",
										Args: []ir.FilterExpr{{
											Line:  488,
											Op:    ir.FilterVarNodeIsOp,
											Src:   "m[\"y\"].Node.Is(`CallExpr`)",
											Value: "y",
											Args:  []ir.FilterExpr{{Line: 482, Op: ir.FilterStringOp, Src: "`CallExpr`", Value: "CallExpr"}},
										}},
									},
								},
							},
							{
								Line:  488,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"x\"].Type.Is(`string`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 483, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            489,
					SyntaxPatterns:  []ir.PatternString{{Line: 489, Value: "bytes.HasSuffix([]byte($x), $y)"}},
					ReportTemplate:  "$$ => strings.HasSuffix($x, string($y))",
					SuggestTemplate: "strings.HasSuffix($x, string($y))",
					WhereExpr: ir.FilterExpr{
						Line: 489,
						Op:   ir.FilterAndOp,
						Src:  "canOptimizeBytes(m)",
						Args: []ir.FilterExpr{
							{
								Line: 489,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure &&\n\t!m[\"y\"].Node.Is(`CallExpr`)",
								Args: []ir.FilterExpr{
									{
										Line: 489,
										Op:   ir.FilterAndOp,
										Src:  "m[\"x\"].Pure &&\n\n\tm[\"y\"].Pure",
										Args: []ir.FilterExpr{
											{Line: 489, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
											{Line: 489, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
										},
									},
									{
										Line: 482,
										Op:   ir.FilterNotOp,
										Src:  "!m[\"y\"].Node.Is(`CallExpr`)",
										Args: []ir.FilterExpr{{
											Line:  489,
											Op:    ir.FilterVarNodeIsOp,
											Src:   "m[\"y\"].Node.Is(`CallExpr`)",
											Value: "y",
											Args:  []ir.FilterExpr{{Line: 482, Op: ir.FilterStringOp, Src: "`CallExpr`", Value: "CallExpr"}},
										}},
									},
								},
							},
							{
								Line:  489,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"x\"].Type.Is(`string`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 483, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
			},
		},
		{
			Line:        496,
			Name:        "writeByte",
			MatcherName: "m",
			DocTags:     []string{"o1", "score1"},
			DocSummary:  "Detects WriteRune calls with rune literal argument that is single byte and reports to use WriteByte instead",
			DocBefore:   "w.WriteRune('\\n')",
			DocAfter:    "w.WriteByte('\\n')",
			Rules: []ir.Rule{{
				Line:            500,
				SyntaxPatterns:  []ir.PatternString{{Line: 500, Value: "$w.WriteRune($c)"}},
				ReportTemplate:  "$$ => $w.WriteByte($c)",
				SuggestTemplate: "$w.WriteByte($c)",
				WhereExpr: ir.FilterExpr{
					Line: 501,
					Op:   ir.FilterAndOp,
					Src:  "m[\"w\"].Type.HasMethod(`io.ByteWriter.WriteByte`) && (m[\"c\"].Const && m[\"c\"].Value.Int() < runeSelf)",
					Args: []ir.FilterExpr{
						{
							Line:  501,
							Op:    ir.FilterVarTypeHasMethodOp,
							Src:   "m[\"w\"].Type.HasMethod(`io.ByteWriter.WriteByte`)",
							Value: "w",
							Args:  []ir.FilterExpr{{Line: 501, Op: ir.FilterStringOp, Src: "`io.ByteWriter.WriteByte`", Value: "io.ByteWriter.WriteByte"}},
						},
						{
							Line: 501,
							Op:   ir.FilterAndOp,
							Src:  "(m[\"c\"].Const && m[\"c\"].Value.Int() < runeSelf)",
							Args: []ir.FilterExpr{
								{
									Line:  501,
									Op:    ir.FilterVarConstOp,
									Src:   "m[\"c\"].Const",
									Value: "c",
								},
								{
									Line: 501,
									Op:   ir.FilterLtOp,
									Src:  "m[\"c\"].Value.Int() < runeSelf",
									Args: []ir.FilterExpr{
										{
											Line:  501,
											Op:    ir.FilterVarValueIntOp,
											Src:   "m[\"c\"].Value.Int()",
											Value: "c",
										},
										{
											Line:  501,
											Op:    ir.FilterIntOp,
											Src:   "runeSelf",
											Value: int64(128),
										},
									},
								},
							},
						},
					},
				},
			}},
		},
		{
			Line:        509,
			Name:        "sliceClear",
			MatcherName: "m",
			DocTags:     []string{"o1", "score2"},
			DocSummary:  "Detects slice clear loops, suggests an idiom that is recognized by the Go compiler",
			DocBefore:   "for i := 0; i < len(buf); i++ { buf[i] = 0 }",
			DocAfter:    "for i := range buf { buf[i] = 0 }",
			Rules: []ir.Rule{{
				Line:            510,
				SyntaxPatterns:  []ir.PatternString{{Line: 510, Value: "for $i := 0; $i < len($xs); $i++ { $xs[$i] = $zero }"}},
				ReportTemplate:  "for ... { ... } => for $i := range $xs { $xs[$i] = $zero }",
				SuggestTemplate: "for $i := range $xs { $xs[$i] = $zero }",
				WhereExpr: ir.FilterExpr{
					Line: 511,
					Op:   ir.FilterEqOp,
					Src:  "m[\"zero\"].Value.Int() == 0",
					Args: []ir.FilterExpr{
						{
							Line:  511,
							Op:    ir.FilterVarValueIntOp,
							Src:   "m[\"zero\"].Value.Int()",
							Value: "zero",
						},
						{
							Line:  511,
							Op:    ir.FilterIntOp,
							Src:   "0",
							Value: int64(0),
						},
					},
				},
			}},
		},
		{
			Line:        520,
			Name:        "mapClear",
			MatcherName: "m",
			DocTags:     []string{"o1", "score2", "reformat"},
			DocSummary:  "Detects cases where map clear idiom can be used",
			DocBefore:   "o.set = make(map[string]int, len(o.set))",
			DocAfter:    "for k := range o.set { delete(o.set, k) }",
			Rules: []ir.Rule{{
				Line:            521,
				SyntaxPatterns:  []ir.PatternString{{Line: 521, Value: "$m = make(map[$_]$_, len($m))"}},
				ReportTemplate:  "$$ => for k := range $m { delete($m, k) }",
				SuggestTemplate: "for k := range $m { delete($m, k) }",
			}},
		},
		{
			Line:        527,
			Name:        "mapAssignOp",
			MatcherName: "m",
			DocTags:     []string{"o1", "score2"},
			DocSummary:  "Detects map <op>= patterns that can be rewritten to avoid double hashing",
			Rules: []ir.Rule{
				{
					Line: 528,
					SyntaxPatterns: []ir.PatternString{
						{Line: 528, Value: "$m[$k] = $m[$k] + 1"},
						{Line: 528, Value: "$m[$k] += 1"},
					},
					ReportTemplate:  "$$ => $m[$k]++",
					SuggestTemplate: "$m[$k]++",
					WhereExpr: ir.FilterExpr{
						Line: 529,
						Op:   ir.FilterAndOp,
						Src:  "m[\"m\"].Type.Is(`map[$_]$_`) && m[\"k\"].Pure",
						Args: []ir.FilterExpr{
							{
								Line:  529,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"m\"].Type.Is(`map[$_]$_`)",
								Value: "m",
								Args:  []ir.FilterExpr{{Line: 529, Op: ir.FilterStringOp, Src: "`map[$_]$_`", Value: "map[$_]$_"}},
							},
							{Line: 529, Op: ir.FilterVarPureOp, Src: "m[\"k\"].Pure", Value: "k"},
						},
					},
				},
				{
					Line:            532,
					SyntaxPatterns:  []ir.PatternString{{Line: 532, Value: "$m[$k] = $m[$k] + $v"}},
					ReportTemplate:  "$$ => $m[$k] += $v",
					SuggestTemplate: "$m[$k] += $v",
					WhereExpr: ir.FilterExpr{
						Line: 533,
						Op:   ir.FilterAndOp,
						Src:  "m[\"m\"].Type.Is(`map[$_]$_`) && m[\"k\"].Pure",
						Args: []ir.FilterExpr{
							{
								Line:  533,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"m\"].Type.Is(`map[$_]$_`)",
								Value: "m",
								Args:  []ir.FilterExpr{{Line: 533, Op: ir.FilterStringOp, Src: "`map[$_]$_`", Value: "map[$_]$_"}},
							},
							{Line: 533, Op: ir.FilterVarPureOp, Src: "m[\"k\"].Pure", Value: "k"},
						},
					},
				},
				{
					Line:            535,
					SyntaxPatterns:  []ir.PatternString{{Line: 535, Value: "$m[$k] = $m[$k] - $v"}},
					ReportTemplate:  "$$ => $m[$k] -= $v",
					SuggestTemplate: "$m[$k] -= $v",
					WhereExpr: ir.FilterExpr{
						Line: 536,
						Op:   ir.FilterAndOp,
						Src:  "m[\"m\"].Type.Is(`map[$_]$_`) && m[\"k\"].Pure",
						Args: []ir.FilterExpr{
							{
								Line:  536,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"m\"].Type.Is(`map[$_]$_`)",
								Value: "m",
								Args:  []ir.FilterExpr{{Line: 536, Op: ir.FilterStringOp, Src: "`map[$_]$_`", Value: "map[$_]$_"}},
							},
							{Line: 536, Op: ir.FilterVarPureOp, Src: "m[\"k\"].Pure", Value: "k"},
						},
					},
				},
				{
					Line:            538,
					SyntaxPatterns:  []ir.PatternString{{Line: 538, Value: "$m[$k] = $m[$k] * $v"}},
					ReportTemplate:  "$$ => $m[$k] *= $v",
					SuggestTemplate: "$m[$k] *= $v",
					WhereExpr: ir.FilterExpr{
						Line: 539,
						Op:   ir.FilterAndOp,
						Src:  "m[\"m\"].Type.Is(`map[$_]$_`) && m[\"k\"].Pure",
						Args: []ir.FilterExpr{
							{
								Line:  539,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"m\"].Type.Is(`map[$_]$_`)",
								Value: "m",
								Args:  []ir.FilterExpr{{Line: 539, Op: ir.FilterStringOp, Src: "`map[$_]$_`", Value: "map[$_]$_"}},
							},
							{Line: 539, Op: ir.FilterVarPureOp, Src: "m[\"k\"].Pure", Value: "k"},
						},
					},
				},
				{
					Line:            541,
					SyntaxPatterns:  []ir.PatternString{{Line: 541, Value: "$m[$k] = $m[$k] / $v"}},
					ReportTemplate:  "$$ => $m[$k] /= $v",
					SuggestTemplate: "$m[$k] /= $v",
					WhereExpr: ir.FilterExpr{
						Line: 542,
						Op:   ir.FilterAndOp,
						Src:  "m[\"m\"].Type.Is(`map[$_]$_`) && m[\"k\"].Pure",
						Args: []ir.FilterExpr{
							{
								Line:  542,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"m\"].Type.Is(`map[$_]$_`)",
								Value: "m",
								Args:  []ir.FilterExpr{{Line: 542, Op: ir.FilterStringOp, Src: "`map[$_]$_`", Value: "map[$_]$_"}},
							},
							{Line: 542, Op: ir.FilterVarPureOp, Src: "m[\"k\"].Pure", Value: "k"},
						},
					},
				},
			},
		},
		{
			Line:        551,
			Name:        "utf8DecodeRune",
			MatcherName: "m",
			DocTags:     []string{"o1", "score4"},
			DocSummary:  "Detects expressions like []rune(s)[0] that may cause unwanted rune slice allocation",
			DocBefore:   "r := []rune(s)[0]",
			DocAfter:    "r, _ := utf8.DecodeRuneInString(s)",
			DocNote:     "See Go issue for details: https://github.com/golang/go/issues/45260",
			Rules: []ir.Rule{
				{
					Line:            558,
					SyntaxPatterns:  []ir.PatternString{{Line: 558, Value: "$ch := []rune($s)[0]"}},
					ReportTemplate:  "$$ => $ch, _ := utf8.DecodeRuneInString($ch)",
					SuggestTemplate: "$ch, _ := utf8.DecodeRuneInString($ch)",
					WhereExpr: ir.FilterExpr{
						Line: 559,
						Op:   ir.FilterAndOp,
						Src:  "m[\"s\"].Type.Is(`string`) && m.File().Imports(`unicode/utf8`)",
						Args: []ir.FilterExpr{
							{
								Line:  559,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 559, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
							{
								Line:  559,
								Op:    ir.FilterFileImportsOp,
								Src:   "m.File().Imports(`unicode/utf8`)",
								Value: "unicode/utf8",
							},
						},
					},
				},
				{
					Line:            562,
					SyntaxPatterns:  []ir.PatternString{{Line: 562, Value: "$ch = []rune($s)[0]"}},
					ReportTemplate:  "$$ => $ch, _ = utf8.DecodeRuneInString($ch)",
					SuggestTemplate: "$ch, _ = utf8.DecodeRuneInString($ch)",
					WhereExpr: ir.FilterExpr{
						Line: 563,
						Op:   ir.FilterAndOp,
						Src:  "m[\"s\"].Type.Is(`string`) && m.File().Imports(`unicode/utf8`)",
						Args: []ir.FilterExpr{
							{
								Line:  563,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 563, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
							{
								Line:  563,
								Op:    ir.FilterFileImportsOp,
								Src:   "m.File().Imports(`unicode/utf8`)",
								Value: "unicode/utf8",
							},
						},
					},
				},
				{
					Line:           568,
					SyntaxPatterns: []ir.PatternString{{Line: 568, Value: "[]rune($s)[0]"}},
					ReportTemplate: "use utf8.DecodeRuneInString($s) here",
					WhereExpr: ir.FilterExpr{
						Line: 569,
						Op:   ir.FilterAndOp,
						Src:  "m[\"s\"].Type.Is(`string`) && !m.File().Imports(`unicode/utf8`)",
						Args: []ir.FilterExpr{
							{
								Line:  569,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 569, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
							{
								Line: 569,
								Op:   ir.FilterNotOp,
								Src:  "!m.File().Imports(`unicode/utf8`)",
								Args: []ir.FilterExpr{{
									Line:  569,
									Op:    ir.FilterFileImportsOp,
									Src:   "m.File().Imports(`unicode/utf8`)",
									Value: "unicode/utf8",
								}},
							},
						},
					},
				},
			},
		},
		{
			Line:        577,
			Name:        "fprint",
			MatcherName: "m",
			DocTags:     []string{"o1", "score2"},
			DocSummary:  "Detects fmt.Sprint(f/ln) calls which can be replaced with fmt.Fprint(f/ln)",
			DocBefore:   "w.Write([]byte(fmt.Sprintf(\"%x\", 10)))",
			DocAfter:    "fmt.Fprintf(w, \"%x\", 10)",
			Rules: []ir.Rule{
				{
					Line:            578,
					SyntaxPatterns:  []ir.PatternString{{Line: 578, Value: "$w.Write([]byte(fmt.Sprint($*args)))"}},
					ReportTemplate:  "$$ => fmt.Fprint($w, $args)",
					SuggestTemplate: "fmt.Fprint($w, $args)",
					WhereExpr: ir.FilterExpr{
						Line:  579,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"w\"].Type.Implements(\"io.Writer\")",
						Value: "w",
						Args:  []ir.FilterExpr{{Line: 579, Op: ir.FilterStringOp, Src: "\"io.Writer\"", Value: "io.Writer"}},
					},
				},
				{
					Line:            582,
					SyntaxPatterns:  []ir.PatternString{{Line: 582, Value: "$w.Write([]byte(fmt.Sprintf($*args)))"}},
					ReportTemplate:  "$$ => fmt.Fprintf($w, $args)",
					SuggestTemplate: "fmt.Fprintf($w, $args)",
					WhereExpr: ir.FilterExpr{
						Line:  583,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"w\"].Type.Implements(\"io.Writer\")",
						Value: "w",
						Args:  []ir.FilterExpr{{Line: 583, Op: ir.FilterStringOp, Src: "\"io.Writer\"", Value: "io.Writer"}},
					},
				},
				{
					Line:            586,
					SyntaxPatterns:  []ir.PatternString{{Line: 586, Value: "$w.Write([]byte(fmt.Sprintln($*args)))"}},
					ReportTemplate:  "$$ => fmt.Fprintln($w, $args)",
					SuggestTemplate: "fmt.Fprintln($w, $args)",
					WhereExpr: ir.FilterExpr{
						Line:  587,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"w\"].Type.Implements(\"io.Writer\")",
						Value: "w",
						Args:  []ir.FilterExpr{{Line: 587, Op: ir.FilterStringOp, Src: "\"io.Writer\"", Value: "io.Writer"}},
					},
				},
				{
					Line:            590,
					SyntaxPatterns:  []ir.PatternString{{Line: 590, Value: "io.WriteString($w, fmt.Sprint($*args))"}},
					ReportTemplate:  "$$ => fmt.Fprint($w, $args)",
					SuggestTemplate: "fmt.Fprint($w, $args)",
				},
				{
					Line:            593,
					SyntaxPatterns:  []ir.PatternString{{Line: 593, Value: "io.WriteString($w, fmt.Sprintf($*args))"}},
					ReportTemplate:  "$$ => fmt.Fprintf($w, $args)",
					SuggestTemplate: "fmt.Fprintf($w, $args)",
				},
				{
					Line:            596,
					SyntaxPatterns:  []ir.PatternString{{Line: 596, Value: "io.WriteString($w, fmt.Sprintln($*args))"}},
					ReportTemplate:  "$$ => fmt.Fprintln($w, $args)",
					SuggestTemplate: "fmt.Fprintln($w, $args)",
				},
			},
		},
		{
			Line:        604,
			Name:        "writeString",
			MatcherName: "m",
			DocTags:     []string{"o1", "score4"},
			DocSummary:  "Detects w.Write calls which can be replaced with w.WriteString",
			DocBefore:   "w.Write([]byte(\"foo\"))",
			DocAfter:    "w.WriteString(\"foo\")",
			Rules: []ir.Rule{{
				Line:            605,
				SyntaxPatterns:  []ir.PatternString{{Line: 605, Value: "$w.Write([]byte($s))"}},
				ReportTemplate:  "$$ => $w.WriteString($s)",
				SuggestTemplate: "$w.WriteString($s)",
				WhereExpr: ir.FilterExpr{
					Line: 606,
					Op:   ir.FilterAndOp,
					Src:  "m[\"w\"].Type.HasMethod(\"io.StringWriter.WriteString\") && m[\"s\"].Type.Is(`string`)",
					Args: []ir.FilterExpr{
						{
							Line:  606,
							Op:    ir.FilterVarTypeHasMethodOp,
							Src:   "m[\"w\"].Type.HasMethod(\"io.StringWriter.WriteString\")",
							Value: "w",
							Args:  []ir.FilterExpr{{Line: 606, Op: ir.FilterStringOp, Src: "\"io.StringWriter.WriteString\"", Value: "io.StringWriter.WriteString"}},
						},
						{
							Line:  606,
							Op:    ir.FilterVarTypeIsOp,
							Src:   "m[\"s\"].Type.Is(`string`)",
							Value: "s",
							Args:  []ir.FilterExpr{{Line: 606, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
						},
					},
				},
			}},
		},
		{
			Line:        614,
			Name:        "writeBytes",
			MatcherName: "m",
			DocTags:     []string{"o1", "score4"},
			DocSummary:  "Detects w.WriteString calls which can be replaced with w.Write",
			DocBefore:   "w.WriteString(buf.String())",
			DocAfter:    "w.Write(buf.Bytes())",
			Rules: []ir.Rule{
				{
					Line:            619,
					SyntaxPatterns:  []ir.PatternString{{Line: 619, Value: "io.WriteString($w, $buf.String())"}},
					ReportTemplate:  "$$ => $w.Write($buf.Bytes())",
					SuggestTemplate: "$w.Write($buf.Bytes())",
					WhereExpr: ir.FilterExpr{
						Line: 620,
						Op:   ir.FilterOrOp,
						Src:  "isBuffer(m[\"buf\"])",
						Args: []ir.FilterExpr{
							{
								Line:  620,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
								Value: "buf",
								Args:  []ir.FilterExpr{{Line: 616, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
							},
							{
								Line:  620,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
								Value: "buf",
								Args:  []ir.FilterExpr{{Line: 616, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
							},
						},
					},
				},
				{
					Line:            623,
					SyntaxPatterns:  []ir.PatternString{{Line: 623, Value: "io.WriteString($w, string($buf.Bytes()))"}},
					ReportTemplate:  "$$ => $w.Write($buf.Bytes())",
					SuggestTemplate: "$w.Write($buf.Bytes())",
					WhereExpr: ir.FilterExpr{
						Line: 624,
						Op:   ir.FilterOrOp,
						Src:  "isBuffer(m[\"buf\"])",
						Args: []ir.FilterExpr{
							{
								Line:  624,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
								Value: "buf",
								Args:  []ir.FilterExpr{{Line: 616, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
							},
							{
								Line:  624,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
								Value: "buf",
								Args:  []ir.FilterExpr{{Line: 616, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
							},
						},
					},
				},
				{
					Line:            627,
					SyntaxPatterns:  []ir.PatternString{{Line: 627, Value: "$w.WriteString($buf.String())"}},
					ReportTemplate:  "$$ => $w.Write($buf.Bytes())",
					SuggestTemplate: "$w.Write($buf.Bytes())",
					WhereExpr: ir.FilterExpr{
						Line: 628,
						Op:   ir.FilterAndOp,
						Src:  "m[\"w\"].Type.HasMethod(\"io.Writer.Write\") && isBuffer(m[\"buf\"])",
						Args: []ir.FilterExpr{
							{
								Line:  628,
								Op:    ir.FilterVarTypeHasMethodOp,
								Src:   "m[\"w\"].Type.HasMethod(\"io.Writer.Write\")",
								Value: "w",
								Args:  []ir.FilterExpr{{Line: 628, Op: ir.FilterStringOp, Src: "\"io.Writer.Write\"", Value: "io.Writer.Write"}},
							},
							{
								Line: 628,
								Op:   ir.FilterOrOp,
								Src:  "isBuffer(m[\"buf\"])",
								Args: []ir.FilterExpr{
									{
										Line:  628,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 616, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
									},
									{
										Line:  628,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 616, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
									},
								},
							},
						},
					},
				},
				{
					Line:            631,
					SyntaxPatterns:  []ir.PatternString{{Line: 631, Value: "$w.WriteString(string($b))"}},
					ReportTemplate:  "$$ => $w.Write($b)",
					SuggestTemplate: "$w.Write($b)",
					WhereExpr: ir.FilterExpr{
						Line: 632,
						Op:   ir.FilterAndOp,
						Src:  "m[\"w\"].Type.HasMethod(\"io.Writer.Write\") && m[\"b\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line:  632,
								Op:    ir.FilterVarTypeHasMethodOp,
								Src:   "m[\"w\"].Type.HasMethod(\"io.Writer.Write\")",
								Value: "w",
								Args:  []ir.FilterExpr{{Line: 632, Op: ir.FilterStringOp, Src: "\"io.Writer.Write\"", Value: "io.Writer.Write"}},
							},
							{
								Line:  632,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b\"].Type.Is(`[]byte`)",
								Value: "b",
								Args:  []ir.FilterExpr{{Line: 632, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
			},
		},
		{
			Line:        640,
			Name:        "bufferString",
			MatcherName: "m",
			DocTags:     []string{"o1", "score4"},
			DocSummary:  "Detects bytes.Buffer String() calls where Bytes() could be used instead",
			DocBefore:   "strings.Contains(buf.String(), string(b))",
			DocAfter:    "bytes.Contains(buf.Bytes(), b)",
			Rules: []ir.Rule{
				{
					Line:            645,
					SyntaxPatterns:  []ir.PatternString{{Line: 645, Value: "strings.$f($buf1.String(), $buf2.String())"}},
					ReportTemplate:  "$$ => bytes.$f($buf1.Bytes(), $buf2.Bytes())",
					SuggestTemplate: "bytes.$f($buf1.Bytes(), $buf2.Bytes())",
					WhereExpr: ir.FilterExpr{
						Line: 647,
						Op:   ir.FilterAndOp,
						Src:  "isBuffer(m[\"buf1\"]) && isBuffer(m[\"buf2\"]) &&\n\tm[\"f\"].Text.Matches(`Compare|Contains|HasPrefix|HasSuffix|EqualFold`)",
						Args: []ir.FilterExpr{
							{
								Line: 647,
								Op:   ir.FilterAndOp,
								Src:  "isBuffer(m[\"buf1\"]) && isBuffer(m[\"buf2\"])",
								Args: []ir.FilterExpr{
									{
										Line: 647,
										Op:   ir.FilterOrOp,
										Src:  "isBuffer(m[\"buf1\"])",
										Args: []ir.FilterExpr{
											{
												Line:  647,
												Op:    ir.FilterVarTypeIsOp,
												Src:   "m[\"buf1\"].Type.Is(`bytes.Buffer`)",
												Value: "buf1",
												Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
											},
											{
												Line:  647,
												Op:    ir.FilterVarTypeIsOp,
												Src:   "m[\"buf1\"].Type.Is(`*bytes.Buffer`)",
												Value: "buf1",
												Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
											},
										},
									},
									{
										Line: 647,
										Op:   ir.FilterOrOp,
										Src:  "isBuffer(m[\"buf2\"])",
										Args: []ir.FilterExpr{
											{
												Line:  647,
												Op:    ir.FilterVarTypeIsOp,
												Src:   "m[\"buf2\"].Type.Is(`bytes.Buffer`)",
												Value: "buf2",
												Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
											},
											{
												Line:  647,
												Op:    ir.FilterVarTypeIsOp,
												Src:   "m[\"buf2\"].Type.Is(`*bytes.Buffer`)",
												Value: "buf2",
												Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
											},
										},
									},
								},
							},
							{
								Line:  648,
								Op:    ir.FilterVarTextMatchesOp,
								Src:   "m[\"f\"].Text.Matches(`Compare|Contains|HasPrefix|HasSuffix|EqualFold`)",
								Value: "f",
								Args:  []ir.FilterExpr{{Line: 648, Op: ir.FilterStringOp, Src: "`Compare|Contains|HasPrefix|HasSuffix|EqualFold`", Value: "Compare|Contains|HasPrefix|HasSuffix|EqualFold"}},
							},
						},
					},
				},
				{
					Line:            652,
					SyntaxPatterns:  []ir.PatternString{{Line: 652, Value: "strings.Contains($buf.String(), string($b))"}},
					ReportTemplate:  "$$ => bytes.Contains($buf.Bytes(), $b)",
					SuggestTemplate: "bytes.Contains($buf.Bytes(), $b)",
					WhereExpr: ir.FilterExpr{
						Line: 653,
						Op:   ir.FilterAndOp,
						Src:  "isBuffer(m[\"buf\"]) && m[\"b\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line: 653,
								Op:   ir.FilterOrOp,
								Src:  "isBuffer(m[\"buf\"])",
								Args: []ir.FilterExpr{
									{
										Line:  653,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
									},
									{
										Line:  653,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
									},
								},
							},
							{
								Line:  653,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b\"].Type.Is(`[]byte`)",
								Value: "b",
								Args:  []ir.FilterExpr{{Line: 653, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            655,
					SyntaxPatterns:  []ir.PatternString{{Line: 655, Value: "strings.HasPrefix($buf.String(), string($b))"}},
					ReportTemplate:  "$$ => bytes.HasPrefix($buf.Bytes(), $b)",
					SuggestTemplate: "bytes.HasPrefix($buf.Bytes(), $b)",
					WhereExpr: ir.FilterExpr{
						Line: 656,
						Op:   ir.FilterAndOp,
						Src:  "isBuffer(m[\"buf\"]) && m[\"b\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line: 656,
								Op:   ir.FilterOrOp,
								Src:  "isBuffer(m[\"buf\"])",
								Args: []ir.FilterExpr{
									{
										Line:  656,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
									},
									{
										Line:  656,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
									},
								},
							},
							{
								Line:  656,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b\"].Type.Is(`[]byte`)",
								Value: "b",
								Args:  []ir.FilterExpr{{Line: 656, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            658,
					SyntaxPatterns:  []ir.PatternString{{Line: 658, Value: "strings.HasSuffix($buf.String(), string($b))"}},
					ReportTemplate:  "$$ => bytes.HasSuffix($buf.Bytes(), $b)",
					SuggestTemplate: "bytes.HasSuffix($buf.Bytes(), $b)",
					WhereExpr: ir.FilterExpr{
						Line: 659,
						Op:   ir.FilterAndOp,
						Src:  "isBuffer(m[\"buf\"]) && m[\"b\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line: 659,
								Op:   ir.FilterOrOp,
								Src:  "isBuffer(m[\"buf\"])",
								Args: []ir.FilterExpr{
									{
										Line:  659,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
									},
									{
										Line:  659,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
									},
								},
							},
							{
								Line:  659,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b\"].Type.Is(`[]byte`)",
								Value: "b",
								Args:  []ir.FilterExpr{{Line: 659, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            661,
					SyntaxPatterns:  []ir.PatternString{{Line: 661, Value: "strings.Count($buf.String(), string($b))"}},
					ReportTemplate:  "$$ => bytes.Count($buf.Bytes(), $b)",
					SuggestTemplate: "bytes.Count($buf.Bytes(), $b)",
					WhereExpr: ir.FilterExpr{
						Line: 662,
						Op:   ir.FilterAndOp,
						Src:  "isBuffer(m[\"buf\"]) && m[\"b\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line: 662,
								Op:   ir.FilterOrOp,
								Src:  "isBuffer(m[\"buf\"])",
								Args: []ir.FilterExpr{
									{
										Line:  662,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
									},
									{
										Line:  662,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
									},
								},
							},
							{
								Line:  662,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b\"].Type.Is(`[]byte`)",
								Value: "b",
								Args:  []ir.FilterExpr{{Line: 662, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            664,
					SyntaxPatterns:  []ir.PatternString{{Line: 664, Value: "strings.Index($buf.String(), string($b))"}},
					ReportTemplate:  "$$ => bytes.Index($buf.Bytes(), $b)",
					SuggestTemplate: "bytes.Index($buf.Bytes(), $b)",
					WhereExpr: ir.FilterExpr{
						Line: 665,
						Op:   ir.FilterAndOp,
						Src:  "isBuffer(m[\"buf\"]) && m[\"b\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line: 665,
								Op:   ir.FilterOrOp,
								Src:  "isBuffer(m[\"buf\"])",
								Args: []ir.FilterExpr{
									{
										Line:  665,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
									},
									{
										Line:  665,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
									},
								},
							},
							{
								Line:  665,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b\"].Type.Is(`[]byte`)",
								Value: "b",
								Args:  []ir.FilterExpr{{Line: 665, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            667,
					SyntaxPatterns:  []ir.PatternString{{Line: 667, Value: "strings.EqualFold($buf.String(), string($b))"}},
					ReportTemplate:  "$$ => bytes.EqualFold($buf.Bytes(), $b)",
					SuggestTemplate: "bytes.EqualFold($buf.Bytes(), $b)",
					WhereExpr: ir.FilterExpr{
						Line: 668,
						Op:   ir.FilterAndOp,
						Src:  "isBuffer(m[\"buf\"]) && m[\"b\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line: 668,
								Op:   ir.FilterOrOp,
								Src:  "isBuffer(m[\"buf\"])",
								Args: []ir.FilterExpr{
									{
										Line:  668,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
									},
									{
										Line:  668,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
									},
								},
							},
							{
								Line:  668,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b\"].Type.Is(`[]byte`)",
								Value: "b",
								Args:  []ir.FilterExpr{{Line: 668, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            671,
					SyntaxPatterns:  []ir.PatternString{{Line: 671, Value: "strings.Contains($buf.String(), $s)"}},
					ReportTemplate:  "$$ => bytes.Contains($buf.Bytes(), []byte($s))",
					SuggestTemplate: "bytes.Contains($buf.Bytes(), []byte($s))",
					WhereExpr: ir.FilterExpr{
						Line: 672,
						Op:   ir.FilterAndOp,
						Src:  "isBuffer(m[\"buf\"]) && m[\"s\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line: 672,
								Op:   ir.FilterOrOp,
								Src:  "isBuffer(m[\"buf\"])",
								Args: []ir.FilterExpr{
									{
										Line:  672,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
									},
									{
										Line:  672,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
									},
								},
							},
							{
								Line:  672,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 672, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            674,
					SyntaxPatterns:  []ir.PatternString{{Line: 674, Value: "strings.HasPrefix($buf.String(), $s)"}},
					ReportTemplate:  "$$ => bytes.HasPrefix($buf.Bytes(), []byte($s))",
					SuggestTemplate: "bytes.HasPrefix($buf.Bytes(), []byte($s))",
					WhereExpr: ir.FilterExpr{
						Line: 675,
						Op:   ir.FilterAndOp,
						Src:  "isBuffer(m[\"buf\"]) && m[\"s\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line: 675,
								Op:   ir.FilterOrOp,
								Src:  "isBuffer(m[\"buf\"])",
								Args: []ir.FilterExpr{
									{
										Line:  675,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
									},
									{
										Line:  675,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
									},
								},
							},
							{
								Line:  675,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 675, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            677,
					SyntaxPatterns:  []ir.PatternString{{Line: 677, Value: "strings.HasSuffix($buf.String(), $s)"}},
					ReportTemplate:  "$$ => bytes.HasSuffix($buf.Bytes(), []byte($s))",
					SuggestTemplate: "bytes.HasSuffix($buf.Bytes(), []byte($s))",
					WhereExpr: ir.FilterExpr{
						Line: 678,
						Op:   ir.FilterAndOp,
						Src:  "isBuffer(m[\"buf\"]) && m[\"s\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line: 678,
								Op:   ir.FilterOrOp,
								Src:  "isBuffer(m[\"buf\"])",
								Args: []ir.FilterExpr{
									{
										Line:  678,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
									},
									{
										Line:  678,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
									},
								},
							},
							{
								Line:  678,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 678, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            680,
					SyntaxPatterns:  []ir.PatternString{{Line: 680, Value: "strings.Count($buf.String(), $s)"}},
					ReportTemplate:  "$$ => bytes.Count($buf.Bytes(), []byte($s))",
					SuggestTemplate: "bytes.Count($buf.Bytes(), []byte($s))",
					WhereExpr: ir.FilterExpr{
						Line: 681,
						Op:   ir.FilterAndOp,
						Src:  "isBuffer(m[\"buf\"]) && m[\"s\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line: 681,
								Op:   ir.FilterOrOp,
								Src:  "isBuffer(m[\"buf\"])",
								Args: []ir.FilterExpr{
									{
										Line:  681,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
									},
									{
										Line:  681,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
									},
								},
							},
							{
								Line:  681,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 681, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            683,
					SyntaxPatterns:  []ir.PatternString{{Line: 683, Value: "strings.Index($buf.String(), $s)"}},
					ReportTemplate:  "$$ => bytes.Index($buf.Bytes(), []byte($s))",
					SuggestTemplate: "bytes.Index($buf.Bytes(), []byte($s))",
					WhereExpr: ir.FilterExpr{
						Line: 684,
						Op:   ir.FilterAndOp,
						Src:  "isBuffer(m[\"buf\"]) && m[\"s\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line: 684,
								Op:   ir.FilterOrOp,
								Src:  "isBuffer(m[\"buf\"])",
								Args: []ir.FilterExpr{
									{
										Line:  684,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
									},
									{
										Line:  684,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
									},
								},
							},
							{
								Line:  684,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 684, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            686,
					SyntaxPatterns:  []ir.PatternString{{Line: 686, Value: "strings.EqualFold($buf.String(), $s)"}},
					ReportTemplate:  "$$ => bytes.EqualFold($buf.Bytes(), []byte($s))",
					SuggestTemplate: "bytes.EqualFold($buf.Bytes(), []byte($s))",
					WhereExpr: ir.FilterExpr{
						Line: 687,
						Op:   ir.FilterAndOp,
						Src:  "isBuffer(m[\"buf\"]) && m[\"s\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line: 687,
								Op:   ir.FilterOrOp,
								Src:  "isBuffer(m[\"buf\"])",
								Args: []ir.FilterExpr{
									{
										Line:  687,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
									},
									{
										Line:  687,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
										Value: "buf",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
									},
								},
							},
							{
								Line:  687,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 687, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            690,
					SyntaxPatterns:  []ir.PatternString{{Line: 690, Value: "[]byte($buf.String())"}},
					ReportTemplate:  "$$ => $buf.Bytes()",
					SuggestTemplate: "$buf.Bytes()",
					WhereExpr: ir.FilterExpr{
						Line: 690,
						Op:   ir.FilterOrOp,
						Src:  "isBuffer(m[\"buf\"])",
						Args: []ir.FilterExpr{
							{
								Line:  690,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
								Value: "buf",
								Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
							},
							{
								Line:  690,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
								Value: "buf",
								Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
							},
						},
					},
				},
				{
					Line: 692,
					SyntaxPatterns: []ir.PatternString{
						{Line: 692, Value: "fmt.Fprint($w, $buf.String())"},
						{Line: 692, Value: "fmt.Fprintf($w, \"%s\", $buf.String())"},
						{Line: 692, Value: "fmt.Fprintf($w, \"%v\", $buf.String())"},
					},
					ReportTemplate:  "$$ => $w.Write($buf.Bytes())",
					SuggestTemplate: "$w.Write($buf.Bytes())",
					WhereExpr: ir.FilterExpr{
						Line: 693,
						Op:   ir.FilterOrOp,
						Src:  "isBuffer(m[\"buf\"])",
						Args: []ir.FilterExpr{
							{
								Line:  693,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
								Value: "buf",
								Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
							},
							{
								Line:  693,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"buf\"].Type.Is(`*bytes.Buffer`)",
								Value: "buf",
								Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
							},
						},
					},
				},
			},
		},
		{
			Line:        699,
			Name:        "rangeExprCopy",
			MatcherName: "m",
			DocTags:     []string{"o1", "score2"},
			DocSummary:  "Detects array range loops that result in an excessive full data copy",
			Rules: []ir.Rule{
				{
					Line: 700,
					SyntaxPatterns: []ir.PatternString{
						{Line: 700, Value: "for $_, $_ := range $e"},
						{Line: 700, Value: "for $_, $_ = range $e"},
					},
					ReportTemplate:  "$e => &$e",
					SuggestTemplate: "&$e",
					WhereExpr: ir.FilterExpr{
						Line: 701,
						Op:   ir.FilterAndOp,
						Src:  "m[\"e\"].Addressable && m[\"e\"].Type.Is(`[$_]$_`) && m[\"e\"].Type.Size > 2048",
						Args: []ir.FilterExpr{
							{
								Line: 701,
								Op:   ir.FilterAndOp,
								Src:  "m[\"e\"].Addressable && m[\"e\"].Type.Is(`[$_]$_`)",
								Args: []ir.FilterExpr{
									{
										Line:  701,
										Op:    ir.FilterVarAddressableOp,
										Src:   "m[\"e\"].Addressable",
										Value: "e",
									},
									{
										Line:  701,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"e\"].Type.Is(`[$_]$_`)",
										Value: "e",
										Args:  []ir.FilterExpr{{Line: 701, Op: ir.FilterStringOp, Src: "`[$_]$_`", Value: "[$_]$_"}},
									},
								},
							},
							{
								Line: 701,
								Op:   ir.FilterGtOp,
								Src:  "m[\"e\"].Type.Size > 2048",
								Args: []ir.FilterExpr{
									{
										Line:  701,
										Op:    ir.FilterVarTypeSizeOp,
										Src:   "m[\"e\"].Type.Size",
										Value: "e",
									},
									{
										Line:  701,
										Op:    ir.FilterIntOp,
										Src:   "2048",
										Value: int64(2048),
									},
								},
							},
						},
					},
					LocationVar: "e",
				},
				{
					Line: 707,
					SyntaxPatterns: []ir.PatternString{
						{Line: 707, Value: "for $_, $_ := range $e"},
						{Line: 707, Value: "for $_, $_ = range $e"},
					},
					ReportTemplate: "range over big array value expression is ineffective",
					WhereExpr: ir.FilterExpr{
						Line: 708,
						Op:   ir.FilterAndOp,
						Src:  "m[\"e\"].Type.Is(`[$_]$_`) && m[\"e\"].Type.Size > 2048",
						Args: []ir.FilterExpr{
							{
								Line:  708,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"e\"].Type.Is(`[$_]$_`)",
								Value: "e",
								Args:  []ir.FilterExpr{{Line: 708, Op: ir.FilterStringOp, Src: "`[$_]$_`", Value: "[$_]$_"}},
							},
							{
								Line: 708,
								Op:   ir.FilterGtOp,
								Src:  "m[\"e\"].Type.Size > 2048",
								Args: []ir.FilterExpr{
									{
										Line:  708,
										Op:    ir.FilterVarTypeSizeOp,
										Src:   "m[\"e\"].Type.Size",
										Value: "e",
									},
									{
										Line:  708,
										Op:    ir.FilterIntOp,
										Src:   "2048",
										Value: int64(2048),
									},
								},
							},
						},
					},
					LocationVar: "e",
				},
			},
		},
		{
			Line:        715,
			Name:        "rangeToAppend",
			MatcherName: "m",
			DocTags:     []string{"o1", "score3"},
			DocSummary:  "Detects range loops that can be turned into a single append call",
			Rules: []ir.Rule{{
				Line:            716,
				SyntaxPatterns:  []ir.PatternString{{Line: 716, Value: "for _, $x := range $src { $dst = append($dst, $x) }"}},
				ReportTemplate:  "for … { … } => $dst = append($dst, $src...)",
				SuggestTemplate: "$dst = append($dst, $src...)",
				WhereExpr: ir.FilterExpr{
					Line: 717,
					Op:   ir.FilterAndOp,
					Src:  "m[\"src\"].Type.Is(`[]$_`) && !m[\"dst\"].Contains(`$x`) && m[\"src\"].Type.IdenticalTo(m[\"dst\"])",
					Args: []ir.FilterExpr{
						{
							Line: 717,
							Op:   ir.FilterAndOp,
							Src:  "m[\"src\"].Type.Is(`[]$_`) && !m[\"dst\"].Contains(`$x`)",
							Args: []ir.FilterExpr{
								{
									Line:  717,
									Op:    ir.FilterVarTypeIsOp,
									Src:   "m[\"src\"].Type.Is(`[]$_`)",
									Value: "src",
									Args:  []ir.FilterExpr{{Line: 717, Op: ir.FilterStringOp, Src: "`[]$_`", Value: "[]$_"}},
								},
								{
									Line: 717,
									Op:   ir.FilterNotOp,
									Src:  "!m[\"dst\"].Contains(`$x`)",
									Args: []ir.FilterExpr{{
										Line:  717,
										Op:    ir.FilterVarContainsOp,
										Src:   "m[\"dst\"].Contains(`$x`)",
										Value: "dst",
										Args:  []ir.FilterExpr{{Line: 0, Op: ir.FilterStringOp, Src: "", Value: "$x"}},
									}},
								},
							},
						},
						{
							Line:  717,
							Op:    ir.FilterVarTypeIdenticalToOp,
							Src:   "m[\"src\"].Type.IdenticalTo(m[\"dst\"])",
							Value: "src",
							Args:  []ir.FilterExpr{{Line: 0, Op: ir.FilterStringOp, Src: "", Value: "dst"}},
						},
					},
				},
			}},
		},
		{
			Line:        724,
			Name:        "rangeToCopy",
			MatcherName: "m",
			DocTags:     []string{"o1", "score4"},
			DocSummary:  "Detects range loops that can be turned into a single copy call",
			Rules: []ir.Rule{{
				Line: 725,
				SyntaxPatterns: []ir.PatternString{
					{Line: 726, Value: "for $i := range $src { $dst[$i] = $src[$i] }"},
					{Line: 727, Value: "for $i, $x := range $src { $dst[$i] = $x }"},
					{Line: 728, Value: "for $i := 0; $i < len($src); $i++ { $dst[$i] = $src[$i] }"},
				},
				ReportTemplate:  "for … { … } => copy($dst, $src)",
				SuggestTemplate: "copy($dst, $src)",
				WhereExpr: ir.FilterExpr{
					Line: 729,
					Op:   ir.FilterAndOp,
					Src:  "m[\"src\"].Type.Is(`[]$_`) && m[\"src\"].Type.IdenticalTo(m[\"dst\"])",
					Args: []ir.FilterExpr{
						{
							Line:  729,
							Op:    ir.FilterVarTypeIsOp,
							Src:   "m[\"src\"].Type.Is(`[]$_`)",
							Value: "src",
							Args:  []ir.FilterExpr{{Line: 729, Op: ir.FilterStringOp, Src: "`[]$_`", Value: "[]$_"}},
						},
						{
							Line:  729,
							Op:    ir.FilterVarTypeIdenticalToOp,
							Src:   "m[\"src\"].Type.IdenticalTo(m[\"dst\"])",
							Value: "src",
							Args:  []ir.FilterExpr{{Line: 0, Op: ir.FilterStringOp, Src: "", Value: "dst"}},
						},
					},
				},
			}},
		},
		{
			Line:        736,
			Name:        "sliceSelfCopy",
			MatcherName: "m",
			DocTags:     []string{"o1", "score4"},
			DocSummary:  "Detects loops where slice dst=src and they can be replaced with a copy call",
			Rules: []ir.Rule{{
				Line:            737,
				SyntaxPatterns:  []ir.PatternString{{Line: 738, Value: "for $i := 0; i < $n; $i++ { $s[$i] = $s[$offset+$i] }"}},
				ReportTemplate:  "for ... { ... } => copy($s[:$n], $s[$offset:])",
				SuggestTemplate: "copy($s[:$n], $s[$offset:])",
				WhereExpr: ir.FilterExpr{
					Line:  739,
					Op:    ir.FilterVarTypeIsOp,
					Src:   "m[\"s\"].Type.Is(`[]$_`)",
					Value: "s",
					Args:  []ir.FilterExpr{{Line: 739, Op: ir.FilterStringOp, Src: "`[]$_`", Value: "[]$_"}},
				},
			}},
		},
		{
			Line:        746,
			Name:        "rangeRuneSlice",
			MatcherName: "m",
			DocTags:     []string{"o1", "score3"},
			DocSummary:  "Detects a range over []rune(string) where copying to a new slice is redundant",
			Rules: []ir.Rule{
				{
					Line:            747,
					SyntaxPatterns:  []ir.PatternString{{Line: 747, Value: "for _, $r := range []rune($s)"}},
					ReportTemplate:  "$$ => for _, $r := range $s",
					SuggestTemplate: "for _, $r := range $s",
					WhereExpr: ir.FilterExpr{
						Line:  748,
						Op:    ir.FilterVarTypeUnderlyingIsOp,
						Src:   "m[\"s\"].Type.Underlying().Is(`string`)",
						Value: "s",
						Args:  []ir.FilterExpr{{Line: 748, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
					},
				},
				{
					Line:            751,
					SyntaxPatterns:  []ir.PatternString{{Line: 751, Value: "for _, $r = range []rune($s)"}},
					ReportTemplate:  "$$ => for _, $r = range $s",
					SuggestTemplate: "for _, $r = range $s",
					WhereExpr: ir.FilterExpr{
						Line:  752,
						Op:    ir.FilterVarTypeUnderlyingIsOp,
						Src:   "m[\"s\"].Type.Underlying().Is(`string`)",
						Value: "s",
						Args:  []ir.FilterExpr{{Line: 752, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
					},
				},
				{
					Line:            755,
					SyntaxPatterns:  []ir.PatternString{{Line: 755, Value: "for range []rune($s)"}},
					ReportTemplate:  "$$ => for range $s",
					SuggestTemplate: "for range $s",
					WhereExpr: ir.FilterExpr{
						Line:  756,
						Op:    ir.FilterVarTypeUnderlyingIsOp,
						Src:   "m[\"s\"].Type.Underlying().Is(`string`)",
						Value: "s",
						Args:  []ir.FilterExpr{{Line: 756, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
					},
				},
				{
					Line:            759,
					SyntaxPatterns:  []ir.PatternString{{Line: 759, Value: "for _, $r := range string($runes)"}},
					ReportTemplate:  "$$ => for _, $r := range $runes",
					SuggestTemplate: "for _, $r := range $runes",
					WhereExpr: ir.FilterExpr{
						Line:  760,
						Op:    ir.FilterVarTypeUnderlyingIsOp,
						Src:   "m[\"runes\"].Type.Underlying().Is(`[]rune`)",
						Value: "runes",
						Args:  []ir.FilterExpr{{Line: 760, Op: ir.FilterStringOp, Src: "`[]rune`", Value: "[]rune"}},
					},
				},
				{
					Line:            763,
					SyntaxPatterns:  []ir.PatternString{{Line: 763, Value: "for _, $r = range string($runes)"}},
					ReportTemplate:  "$$ => for _, $r = range $runes",
					SuggestTemplate: "for _, $r = range $runes",
					WhereExpr: ir.FilterExpr{
						Line:  764,
						Op:    ir.FilterVarTypeUnderlyingIsOp,
						Src:   "m[\"runes\"].Type.Underlying().Is(`[]rune`)",
						Value: "runes",
						Args:  []ir.FilterExpr{{Line: 764, Op: ir.FilterStringOp, Src: "`[]rune`", Value: "[]rune"}},
					},
				},
			},
		},
		{
			Line:        770,
			Name:        "reflectDeepEqual",
			MatcherName: "m",
			DocTags:     []string{"o1", "score2"},
			DocSummary:  "Detects usages of reflect.DeepEqual that can be rewritten",
			Rules: []ir.Rule{
				{
					Line:            771,
					SyntaxPatterns:  []ir.PatternString{{Line: 771, Value: "reflect.DeepEqual($x, $y)"}},
					ReportTemplate:  "$$ => bytes.Equal($x, $y)",
					SuggestTemplate: "bytes.Equal($x, $y)",
					WhereExpr: ir.FilterExpr{
						Line: 772,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Type.Is(`[]byte`) && m[\"y\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line:  772,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"x\"].Type.Is(`[]byte`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 772, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
							{
								Line:  772,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"y\"].Type.Is(`[]byte`)",
								Value: "y",
								Args:  []ir.FilterExpr{{Line: 772, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            779,
					SyntaxPatterns:  []ir.PatternString{{Line: 779, Value: "reflect.DeepEqual($x, $y)"}},
					ReportTemplate:  "$$ => ($x == $y)",
					SuggestTemplate: "($x == $y)",
					WhereExpr: ir.FilterExpr{
						Line: 780,
						Op:   ir.FilterOrOp,
						Src:  "(m[\"x\"].Type.Is(`string`) && m[\"y\"].Type.Is(`string`)) ||\n\t(m[\"x\"].Type.OfKind(`numeric`) && m[\"y\"].Type.OfKind(`numeric`))",
						Args: []ir.FilterExpr{
							{
								Line: 780,
								Op:   ir.FilterAndOp,
								Src:  "(m[\"x\"].Type.Is(`string`) && m[\"y\"].Type.Is(`string`))",
								Args: []ir.FilterExpr{
									{
										Line:  780,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"x\"].Type.Is(`string`)",
										Value: "x",
										Args:  []ir.FilterExpr{{Line: 780, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
									},
									{
										Line:  780,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"y\"].Type.Is(`string`)",
										Value: "y",
										Args:  []ir.FilterExpr{{Line: 780, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
									},
								},
							},
							{
								Line: 781,
								Op:   ir.FilterAndOp,
								Src:  "(m[\"x\"].Type.OfKind(`numeric`) && m[\"y\"].Type.OfKind(`numeric`))",
								Args: []ir.FilterExpr{
									{
										Line:  781,
										Op:    ir.FilterVarTypeOfKindOp,
										Src:   "m[\"x\"].Type.OfKind(`numeric`)",
										Value: "x",
										Args:  []ir.FilterExpr{{Line: 781, Op: ir.FilterStringOp, Src: "`numeric`", Value: "numeric"}},
									},
									{
										Line:  781,
										Op:    ir.FilterVarTypeOfKindOp,
										Src:   "m[\"y\"].Type.OfKind(`numeric`)",
										Value: "y",
										Args:  []ir.FilterExpr{{Line: 781, Op: ir.FilterStringOp, Src: "`numeric`", Value: "numeric"}},
									},
								},
							},
						},
					},
				},
				{
					Line: 784,
					SyntaxPatterns: []ir.PatternString{
						{Line: 784, Value: "reflect.DeepEqual($x, $y{})"},
						{Line: 784, Value: "reflect.DeepEqual($x{}, $y)"},
					},
					ReportTemplate:  "$$ => ($x == $y{})",
					SuggestTemplate: "($x == $y{})",
					WhereExpr: ir.FilterExpr{
						Line: 785,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Comparable && m[\"y\"].Comparable",
						Args: []ir.FilterExpr{
							{
								Line:  785,
								Op:    ir.FilterVarComparableOp,
								Src:   "m[\"x\"].Comparable",
								Value: "x",
							},
							{
								Line:  785,
								Op:    ir.FilterVarComparableOp,
								Src:   "m[\"y\"].Comparable",
								Value: "y",
							},
						},
					},
				},
			},
		},
		{
			Line:        791,
			Name:        "reflectType",
			MatcherName: "m",
			DocTags:     []string{"o1", "score1"},
			DocSummary:  "Detects reflect Type() related patterns that can be optimized",
			Rules: []ir.Rule{
				{
					Line:            792,
					SyntaxPatterns:  []ir.PatternString{{Line: 792, Value: "reflect.ValueOf($x).Type()"}},
					ReportTemplate:  "$$ => reflect.TypeOf($x)",
					SuggestTemplate: "reflect.TypeOf($x)",
				},
				{
					Line:            794,
					SyntaxPatterns:  []ir.PatternString{{Line: 794, Value: "reflect.TypeOf($x.Interface())"}},
					ReportTemplate:  "$$ => $x.Type()",
					SuggestTemplate: "$x.Type()",
					WhereExpr: ir.FilterExpr{
						Line:  795,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`reflect.Value`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 795, Op: ir.FilterStringOp, Src: "`reflect.Value`", Value: "reflect.Value"}},
					},
				},
				{
					Line:            798,
					SyntaxPatterns:  []ir.PatternString{{Line: 798, Value: "fmt.Sprintf(\"%T\", $x.Interface())"}},
					ReportTemplate:  "$$ => $x.Type().String()",
					SuggestTemplate: "$x.Type().String()",
					WhereExpr: ir.FilterExpr{
						Line:  799,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`reflect.Value`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 799, Op: ir.FilterStringOp, Src: "`reflect.Value`", Value: "reflect.Value"}},
					},
				},
				{
					Line:            801,
					SyntaxPatterns:  []ir.PatternString{{Line: 801, Value: "fmt.Sprintf(\"%T\", $x)"}},
					ReportTemplate:  "$$ => reflect.TypeOf($x).String()",
					SuggestTemplate: "reflect.TypeOf($x).String()",
				},
			},
		},
		{
			Line:        809,
			Name:        "reflectValueKind",
			MatcherName: "m",
			DocTags:     []string{"o1", "score2"},
			DocSummary:  "Detects reflect Value.Type().Kind() that can be simplified to Value.Kind()",
			DocBefore:   "v.Type().Kind()",
			DocAfter:    "v.Kind()",
			Rules: []ir.Rule{{
				Line:            810,
				SyntaxPatterns:  []ir.PatternString{{Line: 810, Value: "$x.Type().Kind()"}},
				ReportTemplate:  "$$ => $x.Kind()",
				SuggestTemplate: "$x.Kind()",
				WhereExpr: ir.FilterExpr{
					Line:  811,
					Op:    ir.FilterVarTypeIsOp,
					Src:   "m[\"x\"].Type.Is(`reflect.Value`)",
					Value: "x",
					Args:  []ir.FilterExpr{{Line: 811, Op: ir.FilterStringOp, Src: "`reflect.Value`", Value: "reflect.Value"}},
				},
			}},
		},
		{
			Line:        817,
			Name:        "arrayCopy",
			MatcherName: "m",
			DocTags:     []string{"o1", "score2"},
			DocSummary:  "Detects array copies that can be optimized",
			Rules: []ir.Rule{{
				Line:            822,
				SyntaxPatterns:  []ir.PatternString{{Line: 822, Value: "copy($x[:], $y[:])"}},
				ReportTemplate:  "$$ => $x = $y",
				SuggestTemplate: "$x = $y",
				WhereExpr: ir.FilterExpr{
					Line: 823,
					Op:   ir.FilterAndOp,
					Src:  "m[\"x\"].Type.Is(`[$_]$_`) && m[\"y\"].Type.Is(`[$_]$_`) &&\n\tm[\"x\"].Type.Size == m[\"y\"].Type.Size",
					Args: []ir.FilterExpr{
						{
							Line: 823,
							Op:   ir.FilterAndOp,
							Src:  "m[\"x\"].Type.Is(`[$_]$_`) && m[\"y\"].Type.Is(`[$_]$_`)",
							Args: []ir.FilterExpr{
								{
									Line:  823,
									Op:    ir.FilterVarTypeIsOp,
									Src:   "m[\"x\"].Type.Is(`[$_]$_`)",
									Value: "x",
									Args:  []ir.FilterExpr{{Line: 823, Op: ir.FilterStringOp, Src: "`[$_]$_`", Value: "[$_]$_"}},
								},
								{
									Line:  823,
									Op:    ir.FilterVarTypeIsOp,
									Src:   "m[\"y\"].Type.Is(`[$_]$_`)",
									Value: "y",
									Args:  []ir.FilterExpr{{Line: 823, Op: ir.FilterStringOp, Src: "`[$_]$_`", Value: "[$_]$_"}},
								},
							},
						},
						{
							Line: 824,
							Op:   ir.FilterEqOp,
							Src:  "m[\"x\"].Type.Size == m[\"y\"].Type.Size",
							Args: []ir.FilterExpr{
								{
									Line:  824,
									Op:    ir.FilterVarTypeSizeOp,
									Src:   "m[\"x\"].Type.Size",
									Value: "x",
								},
								{
									Line:  824,
									Op:    ir.FilterVarTypeSizeOp,
									Src:   "m[\"y\"].Type.Size",
									Value: "y",
								},
							},
						},
					},
				},
			}},
		},
		{
			Line:        830,
			Name:        "binaryWrite",
			MatcherName: "m",
			DocTags:     []string{"o1", "score3"},
			DocSummary:  "Detects binary.Write uses that can be optimized",
			Rules: []ir.Rule{
				{
					Line:            831,
					SyntaxPatterns:  []ir.PatternString{{Line: 831, Value: "$err := binary.Write($w, $_, $b)"}},
					ReportTemplate:  "$$ => _, $err := $w.Write($b)",
					SuggestTemplate: "_, $err := $w.Write($b)",
					WhereExpr: ir.FilterExpr{
						Line:  832,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"b\"].Type.Is(`[]byte`)",
						Value: "b",
						Args:  []ir.FilterExpr{{Line: 832, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
					},
				},
				{
					Line:            835,
					SyntaxPatterns:  []ir.PatternString{{Line: 835, Value: "binary.Write($w, $_, $b)"}},
					ReportTemplate:  "$$ => $w.Write($b)",
					SuggestTemplate: "$w.Write($b)",
					WhereExpr: ir.FilterExpr{
						Line: 836,
						Op:   ir.FilterAndOp,
						Src:  "m[\"$$\"].Node.Parent().Is(`ExprStmt`) && m[\"b\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line: 836,
								Op:   ir.FilterRootNodeParentIsOp,
								Src:  "m[\"$$\"].Node.Parent().Is(`ExprStmt`)",
								Args: []ir.FilterExpr{{Line: 836, Op: ir.FilterStringOp, Src: "`ExprStmt`", Value: "ExprStmt"}},
							},
							{
								Line:  836,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"b\"].Type.Is(`[]byte`)",
								Value: "b",
								Args:  []ir.FilterExpr{{Line: 836, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            839,
					SyntaxPatterns:  []ir.PatternString{{Line: 839, Value: "$err := binary.Write($w, $_, $s)"}},
					ReportTemplate:  "$$ => _, $err := $w.WriteString($s)",
					SuggestTemplate: "_, $err := $w.WriteString($s)",
					WhereExpr: ir.FilterExpr{
						Line: 840,
						Op:   ir.FilterAndOp,
						Src:  "m[\"s\"].Type.Is(`string`) && m[\"w\"].Type.HasMethod(`io.StringWriter.WriteString`)",
						Args: []ir.FilterExpr{
							{
								Line:  840,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 840, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
							{
								Line:  840,
								Op:    ir.FilterVarTypeHasMethodOp,
								Src:   "m[\"w\"].Type.HasMethod(`io.StringWriter.WriteString`)",
								Value: "w",
								Args:  []ir.FilterExpr{{Line: 840, Op: ir.FilterStringOp, Src: "`io.StringWriter.WriteString`", Value: "io.StringWriter.WriteString"}},
							},
						},
					},
				},
				{
					Line:            843,
					SyntaxPatterns:  []ir.PatternString{{Line: 843, Value: "binary.Write($w, $_, $s)"}},
					ReportTemplate:  "$$ => $w.WriteString($s)",
					SuggestTemplate: "$w.WriteString($s)",
					WhereExpr: ir.FilterExpr{
						Line: 844,
						Op:   ir.FilterAndOp,
						Src:  "m[\"$$\"].Node.Parent().Is(`ExprStmt`) && m[\"s\"].Type.Is(`string`) && m[\"w\"].Type.HasMethod(`io.StringWriter.WriteString`)",
						Args: []ir.FilterExpr{
							{
								Line: 844,
								Op:   ir.FilterAndOp,
								Src:  "m[\"$$\"].Node.Parent().Is(`ExprStmt`) && m[\"s\"].Type.Is(`string`)",
								Args: []ir.FilterExpr{
									{
										Line: 844,
										Op:   ir.FilterRootNodeParentIsOp,
										Src:  "m[\"$$\"].Node.Parent().Is(`ExprStmt`)",
										Args: []ir.FilterExpr{{Line: 844, Op: ir.FilterStringOp, Src: "`ExprStmt`", Value: "ExprStmt"}},
									},
									{
										Line:  844,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"s\"].Type.Is(`string`)",
										Value: "s",
										Args:  []ir.FilterExpr{{Line: 844, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
									},
								},
							},
							{
								Line:  844,
								Op:    ir.FilterVarTypeHasMethodOp,
								Src:   "m[\"w\"].Type.HasMethod(`io.StringWriter.WriteString`)",
								Value: "w",
								Args:  []ir.FilterExpr{{Line: 844, Op: ir.FilterStringOp, Src: "`io.StringWriter.WriteString`", Value: "io.StringWriter.WriteString"}},
							},
						},
					},
				},
			},
		},
		{
			Line:        850,
			Name:        "syncPoolPut",
			MatcherName: "m",
			DocTags:     []string{"o1", "score3"},
			DocSummary:  "Detects sync.Pool usage on non pointer objects",
			Rules: []ir.Rule{{
				Line:           857,
				SyntaxPatterns: []ir.PatternString{{Line: 857, Value: "$x.Put($y)"}},
				ReportTemplate: "non-pointer values in sync.Pool involve extra allocation",
				WhereExpr: ir.FilterExpr{
					Line: 858,
					Op:   ir.FilterAndOp,
					Src:  "m[\"x\"].Type.Is(\"sync.Pool\") && !isPtrLike(m[\"y\"])",
					Args: []ir.FilterExpr{
						{
							Line:  858,
							Op:    ir.FilterVarTypeIsOp,
							Src:   "m[\"x\"].Type.Is(\"sync.Pool\")",
							Value: "x",
							Args:  []ir.FilterExpr{{Line: 858, Op: ir.FilterStringOp, Src: "\"sync.Pool\"", Value: "sync.Pool"}},
						},
						{
							Line: 858,
							Op:   ir.FilterNotOp,
							Src:  "!isPtrLike(m[\"y\"])",
							Args: []ir.FilterExpr{{
								Line: 858,
								Op:   ir.FilterOrOp,
								Src:  "isPtrLike(m[\"y\"])",
								Args: []ir.FilterExpr{
									{
										Line: 858,
										Op:   ir.FilterOrOp,
										Src:  "m[\"y\"].Type.Underlying().Is(\"*$_\") ||\n\n\tm[\"y\"].Type.Underlying().Is(\"chan $_\") ||\n\n\tm[\"y\"].Type.Underlying().Is(\"map[$_]$_\") ||\n\n\tm[\"y\"].Type.Underlying().Is(\"interface{$*_}\") ||\n\n\tm[\"y\"].Type.Underlying().Is(`func($*_) $*_`)",
										Args: []ir.FilterExpr{
											{
												Line: 858,
												Op:   ir.FilterOrOp,
												Src:  "m[\"y\"].Type.Underlying().Is(\"*$_\") ||\n\n\tm[\"y\"].Type.Underlying().Is(\"chan $_\") ||\n\n\tm[\"y\"].Type.Underlying().Is(\"map[$_]$_\") ||\n\n\tm[\"y\"].Type.Underlying().Is(\"interface{$*_}\")",
												Args: []ir.FilterExpr{
													{
														Line: 858,
														Op:   ir.FilterOrOp,
														Src:  "m[\"y\"].Type.Underlying().Is(\"*$_\") ||\n\n\tm[\"y\"].Type.Underlying().Is(\"chan $_\") ||\n\n\tm[\"y\"].Type.Underlying().Is(\"map[$_]$_\")",
														Args: []ir.FilterExpr{
															{
																Line: 858,
																Op:   ir.FilterOrOp,
																Src:  "m[\"y\"].Type.Underlying().Is(\"*$_\") ||\n\n\tm[\"y\"].Type.Underlying().Is(\"chan $_\")",
																Args: []ir.FilterExpr{
																	{
																		Line:  858,
																		Op:    ir.FilterVarTypeUnderlyingIsOp,
																		Src:   "m[\"y\"].Type.Underlying().Is(\"*$_\")",
																		Value: "y",
																		Args:  []ir.FilterExpr{{Line: 852, Op: ir.FilterStringOp, Src: "\"*$_\"", Value: "*$_"}},
																	},
																	{
																		Line:  858,
																		Op:    ir.FilterVarTypeUnderlyingIsOp,
																		Src:   "m[\"y\"].Type.Underlying().Is(\"chan $_\")",
																		Value: "y",
																		Args:  []ir.FilterExpr{{Line: 852, Op: ir.FilterStringOp, Src: "\"chan $_\"", Value: "chan $_"}},
																	},
																},
															},
															{
																Line:  858,
																Op:    ir.FilterVarTypeUnderlyingIsOp,
																Src:   "m[\"y\"].Type.Underlying().Is(\"map[$_]$_\")",
																Value: "y",
																Args:  []ir.FilterExpr{{Line: 853, Op: ir.FilterStringOp, Src: "\"map[$_]$_\"", Value: "map[$_]$_"}},
															},
														},
													},
													{
														Line:  858,
														Op:    ir.FilterVarTypeUnderlyingIsOp,
														Src:   "m[\"y\"].Type.Underlying().Is(\"interface{$*_}\")",
														Value: "y",
														Args:  []ir.FilterExpr{{Line: 853, Op: ir.FilterStringOp, Src: "\"interface{$*_}\"", Value: "interface{$*_}"}},
													},
												},
											},
											{
												Line:  858,
												Op:    ir.FilterVarTypeUnderlyingIsOp,
												Src:   "m[\"y\"].Type.Underlying().Is(`func($*_) $*_`)",
												Value: "y",
												Args:  []ir.FilterExpr{{Line: 854, Op: ir.FilterStringOp, Src: "`func($*_) $*_`", Value: "func($*_) $*_"}},
											},
										},
									},
									{
										Line:  858,
										Op:    ir.FilterVarTypeUnderlyingIsOp,
										Src:   "m[\"y\"].Type.Underlying().Is(`unsafe.Pointer`)",
										Value: "y",
										Args:  []ir.FilterExpr{{Line: 854, Op: ir.FilterStringOp, Src: "`unsafe.Pointer`", Value: "unsafe.Pointer"}},
									},
								},
							}},
						},
					},
				},
				LocationVar: "y",
			}},
		},
		{
			Line:        867,
			Name:        "trim",
			MatcherName: "m",
			DocTags:     []string{"o1", "score2"},
			DocSummary:  "Detects trim calls that can be optimized",
			DocBefore:   "strings.TrimFunc(s, unicode.IsSpace)",
			DocAfter:    "strings.TrimSpace(s)",
			Rules: []ir.Rule{
				{
					Line: 868,
					SyntaxPatterns: []ir.PatternString{
						{Line: 869, Value: "strings.TrimRight(strings.TrimLeft($s, $x), $x)"},
						{Line: 870, Value: "strings.TrimLeft(strings.TrimRight($s, $x), $x)"},
					},
					ReportTemplate:  "$$ => strings.Trim($s, $x)",
					SuggestTemplate: "strings.Trim($s, $x)",
					WhereExpr:       ir.FilterExpr{Line: 871, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
				{
					Line: 872,
					SyntaxPatterns: []ir.PatternString{
						{Line: 873, Value: "bytes.TrimRight(bytes.TrimLeft($s, $x), $x)"},
						{Line: 874, Value: "bytes.TrimLeft(bytes.TrimRight($s, $x), $x)"},
					},
					ReportTemplate:  "$$ => bytes.Trim($s, $x)",
					SuggestTemplate: "bytes.Trim($s, $x)",
					WhereExpr:       ir.FilterExpr{Line: 875, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
				{
					Line:            877,
					SyntaxPatterns:  []ir.PatternString{{Line: 877, Value: "strings.TrimFunc($s, unicode.IsSpace)"}},
					ReportTemplate:  "$$ => strings.TrimSpace($s)",
					SuggestTemplate: "strings.TrimSpace($s)",
				},
				{
					Line:            879,
					SyntaxPatterns:  []ir.PatternString{{Line: 879, Value: "bytes.TrimFunc($s, unicode.IsSpace)"}},
					ReportTemplate:  "$$ => bytes.TrimSpace($s)",
					SuggestTemplate: "bytes.TrimSpace($s)",
				},
				{
					Line:            882,
					SyntaxPatterns:  []ir.PatternString{{Line: 882, Value: "strings.Trim($s, $cutset)"}},
					ReportTemplate:  "$$ => strings.TrimSpace($s)",
					SuggestTemplate: "strings.TrimSpace($s)",
					WhereExpr: ir.FilterExpr{
						Line: 883,
						Op:   ir.FilterAndOp,
						Src:  "m[\"cutset\"].Const && m[\"cutset\"].Text.Matches(`^\"(?: |\\\\[fnrtv]){3,}\"$`)",
						Args: []ir.FilterExpr{
							{
								Line:  883,
								Op:    ir.FilterVarConstOp,
								Src:   "m[\"cutset\"].Const",
								Value: "cutset",
							},
							{
								Line:  883,
								Op:    ir.FilterVarTextMatchesOp,
								Src:   "m[\"cutset\"].Text.Matches(`^\"(?: |\\\\[fnrtv]){3,}\"$`)",
								Value: "cutset",
								Args:  []ir.FilterExpr{{Line: 883, Op: ir.FilterStringOp, Src: "`^\"(?: |\\\\[fnrtv]){3,}\"$`", Value: "^\"(?: |\\\\[fnrtv]){3,}\"$"}},
							},
						},
					},
				},
				{
					Line:            885,
					SyntaxPatterns:  []ir.PatternString{{Line: 885, Value: "bytes.Trim($s, $cutset)"}},
					ReportTemplate:  "$$ => bytes.TrimSpace($s)",
					SuggestTemplate: "bytes.TrimSpace($s)",
					WhereExpr: ir.FilterExpr{
						Line: 886,
						Op:   ir.FilterAndOp,
						Src:  "m[\"cutset\"].Const && m[\"cutset\"].Text.Matches(`^\"(?: |\\\\[fnrtv]){3,}\"$`)",
						Args: []ir.FilterExpr{
							{
								Line:  886,
								Op:    ir.FilterVarConstOp,
								Src:   "m[\"cutset\"].Const",
								Value: "cutset",
							},
							{
								Line:  886,
								Op:    ir.FilterVarTextMatchesOp,
								Src:   "m[\"cutset\"].Text.Matches(`^\"(?: |\\\\[fnrtv]){3,}\"$`)",
								Value: "cutset",
								Args:  []ir.FilterExpr{{Line: 886, Op: ir.FilterStringOp, Src: "`^\"(?: |\\\\[fnrtv]){3,}\"$`", Value: "^\"(?: |\\\\[fnrtv]){3,}\"$"}},
							},
						},
					},
				},
			},
		},
		{
			Line:        894,
			Name:        "redundantNilCheck",
			MatcherName: "m",
			DocTags:     []string{"o1", "score1"},
			DocSummary:  "Detects redundant nil checks",
			DocBefore:   "b == nil || len(b) == 0",
			DocAfter:    "len(b) == 0",
			Rules: []ir.Rule{
				{
					Line: 895,
					SyntaxPatterns: []ir.PatternString{
						{Line: 895, Value: "$b == nil || len($b) == 0"},
						{Line: 895, Value: "len($b) == 0 || $b == nil"},
					},
					ReportTemplate:  "$$ => len($b) == 0",
					SuggestTemplate: "len($b) == 0",
					WhereExpr:       ir.FilterExpr{Line: 896, Op: ir.FilterVarPureOp, Src: "m[\"b\"].Pure", Value: "b"},
				},
				{
					Line: 898,
					SyntaxPatterns: []ir.PatternString{
						{Line: 898, Value: "$b == nil || cap($b) == 0"},
						{Line: 898, Value: "cap($b) == 0 || $b == nil"},
					},
					ReportTemplate:  "$$ => cap($b) == 0",
					SuggestTemplate: "cap($b) == 0",
					WhereExpr:       ir.FilterExpr{Line: 899, Op: ir.FilterVarPureOp, Src: "m[\"b\"].Pure", Value: "b"},
				},
			},
		},
		{
			Line:        907,
			Name:        "stringsCompare",
			MatcherName: "m",
			DocTags:     []string{"o1", "score1"},
			DocSummary:  "Detects strings.Compare calls that can be optimized",
			DocBefore:   "strings.Compare(s1, s2) == 0",
			DocAfter:    "s1 == s2",
			Rules: []ir.Rule{
				{
					Line:            908,
					SyntaxPatterns:  []ir.PatternString{{Line: 908, Value: "strings.Compare($a, $b) == 0"}},
					ReportTemplate:  "$$ => $a == $b",
					SuggestTemplate: "$a == $b",
				},
				{
					Line:            909,
					SyntaxPatterns:  []ir.PatternString{{Line: 909, Value: "strings.Compare($a, $b) != 0"}},
					ReportTemplate:  "$$ => $a != $b",
					SuggestTemplate: "$a != $b",
				},
				{
					Line: 911,
					SyntaxPatterns: []ir.PatternString{
						{Line: 911, Value: "strings.Compare($a, $b) >= 0"},
						{Line: 911, Value: "strings.Compare($a, $b) != -1"},
					},
					ReportTemplate:  "$$ => $a >= $b",
					SuggestTemplate: "$a >= $b",
				},
				{
					Line: 913,
					SyntaxPatterns: []ir.PatternString{
						{Line: 913, Value: "strings.Compare($a, $b) <= 0"},
						{Line: 913, Value: "strings.Compare($a, $b) != 1"},
					},
					ReportTemplate:  "$$ => $a <= $b",
					SuggestTemplate: "$a <= $b",
				},
				{
					Line: 916,
					SyntaxPatterns: []ir.PatternString{
						{Line: 916, Value: "strings.Compare($a, $b) == -1"},
						{Line: 916, Value: "strings.Compare($a, $b) < 0"},
					},
					ReportTemplate:  "$$ => $a < $b",
					SuggestTemplate: "$a < $b",
				},
				{
					Line: 918,
					SyntaxPatterns: []ir.PatternString{
						{Line: 918, Value: "strings.Compare($a, $b) == 1"},
						{Line: 918, Value: "strings.Compare($a, $b) > 0"},
					},
					ReportTemplate:  "$$ => $a > $b",
					SuggestTemplate: "$a > $b",
				},
			},
		},
		{
			Line:        926,
			Name:        "bytesCompare",
			MatcherName: "m",
			DocTags:     []string{"o1", "score1"},
			DocSummary:  "Detects bytes.Compare calls that can be optimized",
			DocBefore:   "bytes.Compare(b1, b1) == 0",
			DocAfter:    "bytes.Equal(b1, b2)",
			Rules: []ir.Rule{
				{
					Line:            927,
					SyntaxPatterns:  []ir.PatternString{{Line: 927, Value: "bytes.Compare($a, $b) == 0"}},
					ReportTemplate:  "$$ => bytes.Equal($a, $b)",
					SuggestTemplate: "bytes.Equal($a, $b)",
				},
				{
					Line:            928,
					SyntaxPatterns:  []ir.PatternString{{Line: 928, Value: "bytes.Compare($a, $b) != 0"}},
					ReportTemplate:  "$$ => !bytes.Equal($a, $b)",
					SuggestTemplate: "!bytes.Equal($a, $b)",
				},
			},
		},
		{
			Line:        935,
			Name:        "sliceLit",
			MatcherName: "m",
			DocTags:     []string{"o1", "score2"},
			DocSummary:  "Detects suitable places for slice literals",
			DocBefore:   "append([]byte, b1, b2)",
			DocAfter:    "[]byte{b1, b2}",
			Rules: []ir.Rule{
				{
					Line:            936,
					SyntaxPatterns:  []ir.PatternString{{Line: 936, Value: "append([]$typ{$x}, $y)"}},
					ReportTemplate:  "$$ => []$typ{$x, $y}",
					SuggestTemplate: "[]$typ{$x, $y}",
				},
				{
					Line:            937,
					SyntaxPatterns:  []ir.PatternString{{Line: 937, Value: "append([]$typ{$x}, $y, $*rest)"}},
					ReportTemplate:  "$$ => []$typ{$x, $y, $rest}",
					SuggestTemplate: "[]$typ{$x, $y, $rest}",
				},
				{
					Line:            939,
					SyntaxPatterns:  []ir.PatternString{{Line: 939, Value: "append([]$typ{}, $x)"}},
					ReportTemplate:  "$$ => []$typ{$x}",
					SuggestTemplate: "[]$typ{$x}",
				},
				{
					Line:            940,
					SyntaxPatterns:  []ir.PatternString{{Line: 940, Value: "append([]$typ{}, $x, $*rest)"}},
					ReportTemplate:  "$$ => []$typ{$x, $rest}",
					SuggestTemplate: "[]$typ{$x, $rest}",
				},
				{
					Line:            942,
					SyntaxPatterns:  []ir.PatternString{{Line: 942, Value: "append([]$typ(nil), $x)"}},
					ReportTemplate:  "$$ => []$typ{$x}",
					SuggestTemplate: "[]$typ{$x}",
				},
				{
					Line:            943,
					SyntaxPatterns:  []ir.PatternString{{Line: 943, Value: "append([]$typ(nil), $x, $*rest)"}},
					ReportTemplate:  "$$ => []$typ{$x, $rest}",
					SuggestTemplate: "[]$typ{$x, $rest}",
				},
			},
		},
		{
			Line:        950,
			Name:        "mathExpr",
			MatcherName: "m",
			DocTags:     []string{"o1", "score1"},
			DocSummary:  "Detects math package expressions that can be optimized",
			DocBefore:   "math.Abs(x) * math.Abs(y)",
			DocAfter:    "math.Abs(x * y)",
			Rules: []ir.Rule{
				{
					Line:            951,
					SyntaxPatterns:  []ir.PatternString{{Line: 951, Value: "math.Abs($x) * math.Abs($y)"}},
					ReportTemplate:  "$$ => math.Abs(($x) * ($y))",
					SuggestTemplate: "math.Abs(($x) * ($y))",
				},
				{
					Line:            952,
					SyntaxPatterns:  []ir.PatternString{{Line: 952, Value: "math.Abs($x) / math.Abs($y)"}},
					ReportTemplate:  "$$ => math.Abs(($x) / ($y))",
					SuggestTemplate: "math.Abs(($x) / ($y))",
				},
			},
		},
		{
			Line:        959,
			Name:        "ioCopy",
			MatcherName: "m",
			DocTags:     []string{"o1", "score3"},
			DocSummary:  "Detects io.Copy calls that can be optimized",
			DocBefore:   "io.Copy(dst, src)",
			DocAfter:    "src.WriteTo(dst)",
			Rules: []ir.Rule{
				{
					Line:            963,
					SyntaxPatterns:  []ir.PatternString{{Line: 963, Value: "io.Copy($dst, bytes.NewReader($data))"}},
					ReportTemplate:  "$$ => $dst.Write($data)",
					SuggestTemplate: "$dst.Write($data)",
					WhereExpr: ir.FilterExpr{
						Line: 964,
						Op:   ir.FilterRootNodeParentIsOp,
						Src:  "m[\"$$\"].Node.Parent().Is(`ExprStmt`)",
						Args: []ir.FilterExpr{{Line: 964, Op: ir.FilterStringOp, Src: "`ExprStmt`", Value: "ExprStmt"}},
					},
				},
				{
					Line:            966,
					SyntaxPatterns:  []ir.PatternString{{Line: 966, Value: "io.Copy($dst, strings.NewReader($data))"}},
					ReportTemplate:  "$$ => $dst.WriteString($data)",
					SuggestTemplate: "$dst.WriteString($data)",
					WhereExpr: ir.FilterExpr{
						Line: 967,
						Op:   ir.FilterAndOp,
						Src:  "m[\"$$\"].Node.Parent().Is(`ExprStmt`) && m[\"dst\"].Type.HasMethod(`io.StringWriter.WriteString`)",
						Args: []ir.FilterExpr{
							{
								Line: 967,
								Op:   ir.FilterRootNodeParentIsOp,
								Src:  "m[\"$$\"].Node.Parent().Is(`ExprStmt`)",
								Args: []ir.FilterExpr{{Line: 967, Op: ir.FilterStringOp, Src: "`ExprStmt`", Value: "ExprStmt"}},
							},
							{
								Line:  967,
								Op:    ir.FilterVarTypeHasMethodOp,
								Src:   "m[\"dst\"].Type.HasMethod(`io.StringWriter.WriteString`)",
								Value: "dst",
								Args:  []ir.FilterExpr{{Line: 967, Op: ir.FilterStringOp, Src: "`io.StringWriter.WriteString`", Value: "io.StringWriter.WriteString"}},
							},
						},
					},
				},
				{
					Line:            970,
					SyntaxPatterns:  []ir.PatternString{{Line: 970, Value: "io.Copy($dst, $src)"}},
					ReportTemplate:  "$$ => $src.WriteTo($dst)",
					SuggestTemplate: "$src.WriteTo($dst)",
					WhereExpr: ir.FilterExpr{
						Line: 971,
						Op:   ir.FilterAndOp,
						Src:  "m[\"dst\"].Pure && m[\"dst\"].Pure && m[\"src\"].Type.HasMethod(`io.WriterTo.WriteTo`)",
						Args: []ir.FilterExpr{
							{
								Line: 971,
								Op:   ir.FilterAndOp,
								Src:  "m[\"dst\"].Pure && m[\"dst\"].Pure",
								Args: []ir.FilterExpr{
									{Line: 971, Op: ir.FilterVarPureOp, Src: "m[\"dst\"].Pure", Value: "dst"},
									{Line: 971, Op: ir.FilterVarPureOp, Src: "m[\"dst\"].Pure", Value: "dst"},
								},
							},
							{
								Line:  971,
								Op:    ir.FilterVarTypeHasMethodOp,
								Src:   "m[\"src\"].Type.HasMethod(`io.WriterTo.WriteTo`)",
								Value: "src",
								Args:  []ir.FilterExpr{{Line: 971, Op: ir.FilterStringOp, Src: "`io.WriterTo.WriteTo`", Value: "io.WriterTo.WriteTo"}},
							},
						},
					},
				},
				{
					Line:            974,
					SyntaxPatterns:  []ir.PatternString{{Line: 974, Value: "io.Copy($dst, $src)"}},
					ReportTemplate:  "$$ => $dst.ReadFrom($src)",
					SuggestTemplate: "$dst.ReadFrom($src)",
					WhereExpr: ir.FilterExpr{
						Line: 975,
						Op:   ir.FilterAndOp,
						Src:  "m[\"dst\"].Pure && m[\"dst\"].Pure && m[\"dst\"].Type.HasMethod(`io.ReaderFrom.ReadFrom`)",
						Args: []ir.FilterExpr{
							{
								Line: 975,
								Op:   ir.FilterAndOp,
								Src:  "m[\"dst\"].Pure && m[\"dst\"].Pure",
								Args: []ir.FilterExpr{
									{Line: 975, Op: ir.FilterVarPureOp, Src: "m[\"dst\"].Pure", Value: "dst"},
									{Line: 975, Op: ir.FilterVarPureOp, Src: "m[\"dst\"].Pure", Value: "dst"},
								},
							},
							{
								Line:  975,
								Op:    ir.FilterVarTypeHasMethodOp,
								Src:   "m[\"dst\"].Type.HasMethod(`io.ReaderFrom.ReadFrom`)",
								Value: "dst",
								Args:  []ir.FilterExpr{{Line: 975, Op: ir.FilterStringOp, Src: "`io.ReaderFrom.ReadFrom`", Value: "io.ReaderFrom.ReadFrom"}},
							},
						},
					},
				},
			},
		},
		{
			Line:        983,
			Name:        "bufio",
			MatcherName: "m",
			DocTags:     []string{"o1", "score4"},
			DocSummary:  "Detects places where bufio should and shouldn't be used",
			DocBefore:   "bufio.Reader(bytes.NewReader(data))",
			DocAfter:    "bytes.NewReader(data)",
			Rules: []ir.Rule{{
				Line:            991,
				SyntaxPatterns:  []ir.PatternString{{Line: 991, Value: "bufio.NewReader($r)"}},
				ReportTemplate:  "$$ => $r",
				SuggestTemplate: "$r",
				WhereExpr: ir.FilterExpr{
					Line: 992,
					Op:   ir.FilterAndOp,
					Src:  "isInmemoryReader(m[\"r\"]) && m[\"$$\"].SinkType.Is(`io.Reader`)",
					Args: []ir.FilterExpr{
						{
							Line: 992,
							Op:   ir.FilterOrOp,
							Src:  "isInmemoryReader(m[\"r\"])",
							Args: []ir.FilterExpr{
								{
									Line: 992,
									Op:   ir.FilterOrOp,
									Src:  "m[\"r\"].Type.Is(`*bytes.Reader`) ||\n\n\tm[\"r\"].Type.Is(`*bytes.Buffer`)",
									Args: []ir.FilterExpr{
										{
											Line:  992,
											Op:    ir.FilterVarTypeIsOp,
											Src:   "m[\"r\"].Type.Is(`*bytes.Reader`)",
											Value: "r",
											Args:  []ir.FilterExpr{{Line: 985, Op: ir.FilterStringOp, Src: "`*bytes.Reader`", Value: "*bytes.Reader"}},
										},
										{
											Line:  992,
											Op:    ir.FilterVarTypeIsOp,
											Src:   "m[\"r\"].Type.Is(`*bytes.Buffer`)",
											Value: "r",
											Args:  []ir.FilterExpr{{Line: 986, Op: ir.FilterStringOp, Src: "`*bytes.Buffer`", Value: "*bytes.Buffer"}},
										},
									},
								},
								{
									Line:  992,
									Op:    ir.FilterVarTypeIsOp,
									Src:   "m[\"r\"].Type.Is(`*strings.Reader`)",
									Value: "r",
									Args:  []ir.FilterExpr{{Line: 987, Op: ir.FilterStringOp, Src: "`*strings.Reader`", Value: "*strings.Reader"}},
								},
							},
						},
						{
							Line:  992,
							Op:    ir.FilterRootSinkTypeIsOp,
							Src:   "m[\"$$\"].SinkType.Is(`io.Reader`)",
							Value: "$$",
							Args:  []ir.FilterExpr{{Line: 992, Op: ir.FilterStringOp, Src: "`io.Reader`", Value: "io.Reader"}},
						},
					},
				},
			}},
		},
	},
}

