package main

import (
	"flag"
)

func addCommonFlags(r *runner, fs *flag.FlagSet) {
	fs.BoolVar(&r.autofix, "fix", false,
		`apply the suggested fixes automatically, where possible`)
	fs.StringVar(&r.goVersion, "go", "",
		`select the Go version to target; leave as empty string for the latest`)
	fs.BoolVar(&r.absFilenames, "abs", false,
		`print absolute filenames in the output`)
	fs.BoolVar(&r.args.quiet, "quiet", false,
		`do not print extra results information and stats`)
	fs.BoolVar(&r.args.autogen, "autogen", false,
		`whether to analyze autogenerated files`)
}
