DEVICE_ID_DEFAULT = 0                # The default device ID
INFINITE_TIMEOUT = -1                # Wait infinite for a response of the MC
INFINITE_TIMEOUT_INTERRUPTIBLE = -2  # Wait infinite for a response of the MC,
                                     # exit on signal
NO_TIMEOUT = 0                       # Do not wait for a response of the MC
MAX_TCI_LEN = 0x100000               # TCI/DCI must not exceed 1MiB

#
# MobiCore driver API error codes
# MAJOR part of error code is stable
# MCP part contains MCP result code
# DETAIL part may be used in testing for specific error code
#
ERROR_MAJOR = lambda ecode: ecode & 0xff
ERROR_MCP = lambda ecode: (ecode >> 8) & 0xff
ERROR_DETAIL = lambda ecode: (ecode >> 16) & 0xfff

#
# Return values of MobiCore driver functions
#
OK = 0x00000000
NO_NOTIFICATION = 0x00000001
ERR_NOTIFICATION = 0x00000002
ERR_NOT_IMPLEMENTED = 0x00000003
ERR_OUT_OF_RESOURCES = 0x00000004
ERR_INIT = 0x00000005
ERR_UNKNOWN = 0x00000006
ERR_UNKNOWN_DEVICE = 0x00000007
ERR_UNKNOWN_SESSION = 0x00000008
ERR_INVALID_OPERATION = 0x00000009
ERR_INVALID_RESPONSE = 0x0000000a
ERR_TIMEOUT = 0x0000000b
ERR_NO_FREE_MEMORY = 0x0000000c
ERR_FREE_MEMORY_FAILED = 0x0000000d
ERR_SESSION_PENDING = 0x0000000e
ERR_DAEMON_UNREACHABLE = 0x0000000f
ERR_INVALID_DEVICE_FILE = 0x00000010
ERR_INVALID_PARAMETER = 0x00000011
ERR_KERNEL_MODULE = 0x00000012
ERR_BULK_MAPPING = 0x00000013
ERR_BULK_UNMAPPING = 0x00000014
INFO_NOTIFICATION = 0x00000015
ERR_NQ_FAILED = 0x00000016

ERR_DAEMON_VERSION = 0x00000017
ERR_CONTAINER_VERSION = 0x00000018

#
# Those should become MCP or even detail codes on top of MC_DRV_ERR_MCP_ERROR
#
ERR_WRONG_PUBLIC_KEY = 0x00000019
ERR_CONTAINER_TYPE_MISMATCH = 0x0000001a
ERR_CONTAINER_LOCKED = 0x0000001b
ERR_SP_NO_CHILD = 0x0000001c
ERR_TL_NO_CHILD = 0x0000001d
ERR_UNWRAP_ROOT_FAILED = 0x0000001e
ERR_UNWRAP_SP_FAILED = 0x0000001f
ERR_UNWRAP_TRUSTLET_FAILED = 0x00000020

#
# Use separate numbers for those in the future
#
# ERR_DEVICE_ALREADY_OPEN = ERR_INVALID_OPERATION
# ERR_SOCKET_CONNECT = ERR_DAEMON_UNREACHABLE
# ERR_SOCKET_WRITE = ERR_DAEMON_UNREACHABLE
# ERR_SOCKET_READ = ERR_DAEMON_UNREACHABLE
# ERR_SOCKET_LENGTH = ERR_DAEMON_UNREACHABLE
# ERR_DAEMON_SOCKET = ERR_DAEMON_UNREACHABLE
# ERR_DEVICE_FILE_OPEN = ERR_INVALID_DEVICE_FILE
# ERR_NULL_POINTER = ERR_INVALID_PARAMETER
# ERR_TCI_TOO_BIG = ERR_INVALID_PARAMETER
# ERR_WSM_NOT_FOUND = ERR_INVALID_PARAMETER
# ERR_TCI_GREATER_THAN_WSM = ERR_INVALID_PARAMETER
# ERR_TRUSTLET_NOT_FOUND = ERR_INVALID_DEVICE_FILE
# ERR_TRUSTED_APPLICATION_NOT_FOUND = ERR_TRUSTLET_NOT_FOUND
# ERR_DAEMON_KMOD_ERROR = ERR_DAEMON_UNREACHABLE
# ERR_DAEMON_MCI_ERROR = ERR_DAEMON_UNREACHABLE
# ERR_MCP_ERROR = ERR_DAEMON_UNREACHABLE
# ERR_INVALID_LENGTH = ERR_NO_FREE_MEMORY
# ERR_KMOD_NOT_OPEN = ERR_NO_FREE_MEMORY
# ERR_BUFFER_ALREADY_MAPPED = ERR_BULK_MAPPING
# ERR_BLK_BUFF_NOT_FOUND = ERR_BULK_UNMAPPING

ERR_DAEMON_DEVICE_NOT_OPEN = 0x00000021
# ERR_DAEMON_WSM_HANDLE_NOT_FOUND = ERR_WSM_NOT_FOUND
# ERR_DAEMON_UNKNOWN_SESSION = ERR_UNKNOWN_SESSION

#
# Installation errors
#
ERR_TA_HEADER_ERROR = 0x00000021
ERR_TA_ATTESTATION_ERROR = 0x00000022

ERR_INTERRUPTED_BY_SIGNAL = 0x00000023

ERR_SERVICE_BLOCKED = 0x00000024
ERR_SERVICE_LOCKED = 0x00000025
ERR_SERVICE_KILLED = 0x00000026
ERR_NO_FREE_INSTANCES = 0x00000027

# MAKE_MCP_ERROR = lambda mcp_code: ERR_MCP_ERROR | ((mcp_code & 0xfffff) << 8)
# MAKE_KMOD_WITH_ERRNO = lambda err: ERR_KERNEL_MODULE | ((err & 0xffff) << 16)
