<?php

// +----------------------------------------------------------------------
// | 骑士虚拟产品寄售商城系统开源版 
// +----------------------------------------------------------------------
// | Copyright (c) 2023-2025 https://www.qqss.net All rights reserved.
// +----------------------------------------------------------------------
// | Licensed MIT 本系统开源仅仅是为了新手学习开发商城为目的，使用时请遵循当地法律法规
// +----------------------------------------------------------------------
// | Author: QQSS <990504246@qq.com>
// +----------------------------------------------------------------------

namespace app\merchantapi\validate\goods;

use taoser\Validate;

class CategoryValidate extends Validate
{
    protected $rule = [
        'id'   => 'require',
        'name' => 'require|checkWordfilter',
    ];

    protected $message = [
        'id.require'   => 'id不能为空',
        'name.require' => '分类名不能为空',
    ];

    protected function checkWordfilter($value, $rule, $data)
    {

        $check_name = check_wordfilter($value);
        if ($check_name) {
            return '包含违禁词' . $check_name;
        } else {
            return true;
        }
    }

    // edit
    public function sceneEdit()
    {
        return $this->only(['id', 'name']);
    }
    // add
    public function sceneAdd()
    {
        return $this->only(['name']);
    }

}