# Learn-Laravel — 学习资料和开源项目集

## Laravel 学习资料

### 官方网站
* [Laravel.com](http://laravel.com/) —— Laravel官网
* [golaravel.com](http://www.golaravel.com/) —— Laravel中文网
* [lumen](http://lumen.laravel-china.org/) —— 为速度而生的 Laravel 框架
* [PHP 之道](http://laravel-china.github.io/php-the-right-way/#object_caching) —— PHP The Right Way

### 论坛
* [learnku.com](https://learnku.com/) —— Laravel China 社区 - 高品质的 Laravel 开发者社区
* [laravel.io](http://laravel.io/) —— Laravel 开发者社区
* [laravelacademy.org](http://laravelacademy.org/) —— Laravel学院，致力于提供优质Laravel中文学习资源

### 文档

* Laravel 中文文档
  * [Laravel 5.1 中文文档](https://learnku.com/docs/laravel/5.1) —— Laravel 5.1 中文文档
  * [Laravel 5.2 中文文档](https://learnku.com/docs/laravel/5.2) —— Laravel 5.2 中文文档
  * [Laravel 5.3 中文文档](https://learnku.com/docs/laravel/5.3) —— Laravel 5.3 中文文档
  * [Laravel 5.4 中文文档](https://learnku.com/docs/laravel/5.4) —— Laravel 5.4 中文文档
  * [Laravel 5.5 中文文档](https://learnku.com/docs/laravel/5.5) —— Laravel 5.5 中文文档
  * [Laravel 5.6 中文文档](https://learnku.com/docs/laravel/5.6) —— Laravel 5.6 中文文档
  * [Laravel 5.7 中文文档](https://learnku.com/docs/laravel/5.7) —— Laravel 5.7 中文文档
  * [Laravel 5.8 中文文档](https://learnku.com/docs/laravel/5.8) —— Laravel 5.8 中文文档
  * [Laravel 6.x 中文文档](https://learnku.com/docs/laravel/6.x) —— Laravel 6.x 中文文档
  * [Laravel 7.x 中文文档](https://learnku.com/docs/laravel/7.x) —— Laravel 7.x 中文文档
  * [Laravel 8.x 中文文档](https://learnku.com/docs/laravel/8.x) —— Laravel 8.x 中文文档
  * [Laravel 8.5 中文文档](https://learnku.com/docs/laravel/8.5) —— Laravel 8.5 中文文档
  * [Laravel 9.x 中文文档](https://learnku.com/docs/laravel/9.x) —— Laravel 9.x 中文文档
  * [Laravel 10.x 中文文档](https://learnku.com/docs/laravel/10.x) —— Laravel 10.x 中文文档
  * [Laravel 11.x 中文文档](https://learnku.com/docs/laravel/11.x) —— Laravel 11.x 中文文档
  * 
* Lumen 中文文档
  * [Lumen 中文文档 5.1](https://learnku.com/docs/lumen/5.1) —— Lumen 中文文档 5.1
  * [Lumen 中文文档 5.2](https://learnku.com/docs/lumen/5.2) —— Lumen 中文文档 5.2 
  * [Lumen 中文文档 5.3](https://learnku.com/docs/lumen/5.3) —— Lumen 中文文档 5.3 
  * [Lumen 中文文档 5.4](https://learnku.com/docs/lumen/5.4) —— Lumen 中文文档 5.4 
  * [Lumen 中文文档 5.5](https://learnku.com/docs/lumen/5.5) —— Lumen 中文文档 5.5 
  * [Lumen 中文文档 5.6](https://learnku.com/docs/lumen/5.6) —— Lumen 中文文档 5.6 
  * [Lumen 中文文档 5.7](https://learnku.com/docs/lumen/5.7) —— Lumen 中文文档 5.7 
  * [Lumen 中文文档 6.x](https://learnku.com/docs/lumen/6.x) —— Lumen 中文文档 6.x

### 书籍
* [《Laravel 入门教程》](https://laravel-china.org/topics/3383/laravel-the-first-chinese-new-book-laravel-tutorial) —— Laravel 第一本中文新手书籍《Laravel 入门教程》
* [《Web 开发实战进阶 - 从零开始构建论坛系统》](https://laravel-china.org/topics/6592/laravel-tutorial-series-book-second-web-developer-combat-advanced-began-to-build-the-forum-system-from-zero) —— Laravel 教程系列书第二本《Web 开发实战进阶 - 从零开始构建论坛系统》
* [《Laravel 教程实战高级 - 构架 API 服务器》](https://laravel-china.org/topics/7657/laravel-tutorial-series-third-the-first-edition-of-the-laravel-tutorial-advanced-architecture-api-server) —— Laravel 教程系列书第三本《Laravel 教程实战高级 - 构架 API 服务器》
* [《Mastering Laravel》](https://www.packtpub.com/web-development/mastering-laravel) —— Develop robust modern web-based software applications and RESTful APIs with Laravel, one of the hottest PHP frameworks
* [《Learning Laravel's Eloquent》](https://www.packtpub.com/web-development/learning-laravels-eloquent) —— Develop amazing data-based applications with Eloquent, the Laravel framework ORM
* [《Laravel 5 Essentials》](https://www.packtpub.com/web-development/laravel-5-essentials) —— Explore the fundamentals of Laravel, one of the most expressive and robust PHP frameworks available
* [L01 Laravel 教程 - Web 开发实战入门 ( Laravel 6.0 ) ](https://learnku.com/courses/laravel-essential-training/6.0) —— 本书将教你如何使用 Laravel 一步一步构建一个类似新浪微博的应用，让你从实际开发中体会到 Laravel 开发的敏捷、愉悦与轻松。*（收费）*
* [L01 Laravel 教程 - Web 开发实战入门 ( Laravel 5.8 ) ](https://learnku.com/courses/laravel-essential-training/5.8) —— 本书将教你如何使用 Laravel 一步一步构建一个类似新浪微博的应用，让你从实际开发中体会到 Laravel 开发的敏捷、愉悦与轻松。*（收费）*
* [L01 Laravel 教程 - Web 开发实战入门 ( Laravel 5.7 ) ](https://learnku.com/courses/laravel-essential-training/5.7) —— 本书将教你如何使用 Laravel 一步一步构建一个类似新浪微博的应用，让你从实际开发中体会到 Laravel 开发的敏捷、愉悦与轻松。*（收费）*
* [L01 Laravel 教程 - Web 开发实战入门 ( Laravel 5.5 ) ](https://learnku.com/courses/laravel-essential-training/5.5) —— 本书将教你如何使用 Laravel 一步一步构建一个类似新浪微博的应用，让你从实际开发中体会到 Laravel 开发的敏捷、愉悦与轻松。*（收费）*
* [L02 Laravel 教程 - Web 开发实战进阶 ( Laravel 5.8 ) ](https://learnku.com/courses/laravel-intermediate-training/5.8) —— 在 Laravel 进阶课程中，我们会创建一个论坛系统。*（收费）*
* [L03 Laravel 教程 - 实战构架 API 服务器 ( Laravel 5.8) ](https://learnku.com/courses/laravel-advance-training/5.8) —— 本书主要专注于 App 的后端 API 服务器开发。*（收费）*
* [L04 Laravel 教程 - 微信小程序从零到发布 ( Laravel 5.5) ](https://learnku.com/courses/laravel-weapp/5.5) —— 从第一行代码，到微信小程序的提交发布 *（收费）*
* [L05 Laravel 教程 - 电商实战 ( Laravel 5.8)](https://learnku.com/courses/laravel-shop/5.8) —— 手把手带你开发一个电商项目 *（收费）*
* [L06 Laravel 教程 - 电商进阶 ( Laravel 5.8 ) ](https://learnku.com/courses/ecommerce-advance/5.8) —— 手把手带你开发一个电商项目进阶 *（收费）*
* [L07 Laravel 教程 - Laravel TDD 测试 ( Laravel 7.x ) ](https://learnku.com/courses/laravel-testing/7.x) —— Laravel 测试入门，基于一个完整的项目，160+ 个测试覆盖单元测试、集成测试、浏览器测试，与您一起敲开软件测试的大门。 *（收费）*
* [Laravel: Up and Running](https://book.douban.com/subject/26801718/) —— A Framework for Building Modern PHP Apps 作者: Matt Stauffer 
* [Laravel入门与实战](https://book.douban.com/subject/30190190/) —— 构建主流PHP应用开发框架《Laravel: Up and Running》的中文译本
* [Design Patterns in PHP and Laravel](https://book.douban.com/subject/26964602/) —— 作者: Kelt Dockins 
* [Full-Stack Vue.js 2 and Laravel 5]() —— Bring the frontend and backend together with Vue, Vuex, and Laravel 作者: Anthony Gore 
* [Laravel框架关键技术解析](https://union-click.jd.com/jdc?e=&p=AyIGZRprFQIaD1QdWBAyVlgNRQQlW1dCFFlQCxxKQgFHRE5XDVULR0UVAhoPVB1YEB1LQglGa2prW3E2RCNoYVJDLG8HY0p1HT5MXVMOHjdUK1sUAxEFURlcFwMiN1Uca0NsEgZUGloUBxICVitaJQIVB1IfXBAEEARcGF4lBRIOZczygdW0k42pwsGKn9HMsI%2B%2FniI3ZRhrJTISN1YrGXtXEgQCTwxGAxAOBUleRgIXDgdMD0cCG1QGE18WBEAPUytZFAMWDg%3D%3D) —— 本书既适合想了解Laravel框架构建技术的读者，也适合想深入了解Laravel框架的读者。作者：陈昊
* [Laravel入门与实战：构建主流PHP应用开发框架](https://union-click.jd.com/jdc?e=&p=AyIGZRhfHAUXAVQZXxcyEQFXGV0cAhEDUxtrUV1KWQorAlBHU0VeBUVNR0ZbSkAOClBMW0sYXRcAFA5VGF8TAg1eEEcGJURaRCN4QXIKcXUjGSN0Zkt9VhoIVXIeC2UaaxUDEwRXH1kSABM3ZRtcJUN8AlUaUhcyEzdVHFsSBhUCXBxaHAEQN1IbUiXVu5OCvc%2FNsIvT3ZaNjKnGrckrayUBIjdlG2sWMlBpBhtdQgERDl0SUxxRF1cGTghCAxVXXExbFwVBBgYdXxwyEAZUH1I%3D) —— 对Laravel框架进行了系统的介绍，包括Laravel的背景、Laravel开发环境的搭建、路由与控制器、Blade模板、前端组件、收集和处理用户数据、Artisan和Tinker、数据库和Eloquent、容器、Laravel测试等知识。作者：Matt Stauffer

### 源码解读
* [Laravel 源码解读](https://www.jianshu.com/p/b7ea3f2a55f6) —— yii/laravel 的源码质量超高, phper 一定要好好读一读
* [Laravel 源码脑图](http://naotu.baidu.com/file/9d4b5ab081c174ebfaf2af01db81bc5b?token=9fb122830b33d1c8) —— 源码脑图，值得一看
* [Laravel 源码解读系列第一篇](https://www.hellonine.top/index.php/archives/6/) —— Laravel源码解读系列第一篇-初始化
* [Laravel 源码解读系列第二篇](https://www.hellonine.top/index.php/archives/16/) —— Laravel源码解读系列第二篇-Request
* [Laravel 源码解读系列第三篇](https://www.hellonine.top/index.php/archives/29/) —— Laravel源码解读系列第三篇-Response
* [Laravel 源码解读系列第四篇](https://www.hellonine.top/index.php/archives/68/) —— Laravel源码解读系列第四篇-Auth机制
* [Laravel 源码解读系列第五篇](https://www.hellonine.top/index.php/archives/82/) —— Laravel源码解读系列第五篇-Cache
* [Laravel5.4 生命流程与源码分析](https://learnku.com/articles/7135/laravel-54-life-process-and-source-code-analysis) —— 生命流程与源码分析
* [PHP FPM源代码反刍品味之一](https://www.jianshu.com/p/3bd0aef2f2b7) —— PHP FPM源代码反刍品味之一：无限运行程序
* [PHP FPM源代码反刍品味之二](https://www.jianshu.com/p/744f2c5e2ad3) —— PHP FPM源代码反刍品味之二：IO多路复用
* [PHP FPM源代码反刍品味之三](https://www.jianshu.com/p/542935a3bfa8) —— PHP FPM源代码反刍品味之三: 多进程模型
* [PHP FPM源代码反刍品味之四](https://www.jianshu.com/p/e567ba80f3b2) —— PHP FPM源代码反刍品味之四：事件处理
* [PHP FPM源代码反刍品味之五](https://www.jianshu.com/p/e3074fcf1b9d) —— PHP FPM源代码反刍品味之五：信号signal处理
* [PHP FPM源代码反刍品味之六](https://www.jianshu.com/p/dac223d7d9ad) —— PHP FPM源代码反刍品味之六：IO事件机制的封装
* [Learning_Laravel_Kernel](https://github.com/kevinyan815/Learning_Laravel_Kernel) —— Laravel核心代码学习
* [Laravel 源码分析](https://58hualong.com/course/14/Laravel-yuan-ma-fen-xi) —— Laravel源码分析【已完结】视频教程 *（收费）*
* [Laravel 框架门面 Facade 源码分析](https://learnku.com/articles/4684/analysis-of-facade-source-code-of-laravel-frame) —— 框架门面 Facade 源码分析
* [Laravel 核心——IoC 服务容器](https://learnku.com/articles/4698/laravel-core-ioc-service-container) —— oC 服务容器
* [Laravel 核心——IoC 服务容器源码解析（服务器绑定）](https://learnku.com/articles/4699/laravel-core-ioc-service-container-source-parsing-server-binding) —— IoC 服务容器源码解析（服务器绑定）
* [Laravel 核心——IoC 服务容器源码解析（服务器解析）](https://learnku.com/articles/4700/laravel-core-source-parsing-of-ioc-service-container-server-parsing) —— IoC 服务容器源码解析（服务器解析）
* [Laravel 核心——服务容器的细节特性](https://learnku.com/articles/4870/the-laravel-core-the-details-of-the-service-container) —— 服务容器的细节特性
* [laravel 源码详解](https://leoyang90.gitbooks.io/laravel-source-analysis/content/) —— 本项目针对 laravel 5.4 各个重要模块的源码进行了较为详尽的分析，希望给想要了解 laravel 底层原理与源码的同学一些指引。
* [Laravel 源码分析——看一次 Http 请求到响应](https://juejin.im/entry/591ab0a8128fe1005cded993) —— 本文就尽可能的提取Laravel处理http请求过程中一些关键的路径跟大家分享一下Laravel框架工作的原理
* [Laravel 核心概念讲解-深入讲解Service Contaier、Service Provider、Facades、Contracts之间的关系](https://www.bilibili.com/video/av35887442) —— 深入讲解Service Contaier、Service Provider、Facades、Contracts之间的关系。bilibili.com
* [Laravel源码笔记（一）程序结构与生命周期](https://cloud.tencent.com/developer/article/1602220) —— Laravel源码笔记（一）程序结构与生命周期。腾讯云专栏。
* [Laravel源码笔记（二）路由](https://cloud.tencent.com/developer/article/1613270) —— Laravel源码笔记（二）路由。腾讯云专栏。

### 视频教程
* [laravist.com](https://laravist.com/) —— 最干货Laravel视频教程和一系列的Laravel文章教程 *（收费）*
* [laravist-free](https://laracasts.com/tags/free) —— 免费
* [laravist-free laravel](https://laracasts.com/series/laravel-from-scratch) —— 免费
* [zexeo.com](http://zexeo.com/) —— Laravel 4 快速上手系列教程
* [Laravel 5 框架闯关记](http://www.lampym.com/course/29) —— Laravel 5 框架闯关记-入门篇
* [laracon2013](https://www.youtube.com/watch?v=JyBol0X-NlU&list=PLkwAlZpjHQbLcox_S_AgGU24QUfKgXayN) —— 墙外
* [laracon2014](http://userscape.com/laracon/2014/) —— 墙外
* [What’s New in Laravel 4](https://code.tutsplus.com/courses/whats-new-in-laravel-4) —— tutsplus.com *（收费）*
* [Laravel 4 Mastery by Jeffrey Way](http://code.tutsplus.com/tutorials/laravel-4-mastery--net-31233) —— tutsplus.com
* [Laravel 3 Essentials](http://www.tudou.com/plcover/XCJTpoABmUA/) —— 
* [Rails or Laravel: Building an App Twice](https://code.tutsplus.com/courses/rails-or-laravel-building-an-app-twice) —— 
* [Arjun Yonjan](https://www.youtube.com/channel/UCOL9ZxzRX9lIvOliY_oz0Ng/playlists) —— 墙外
* [laravel 框架项目实战课](http://www.ydma.cn/course/138) —— ydma.cn *（收费）*
* [轻松学会Laravel-基础篇](https://www.imooc.com/view/697) —— 慕课网
* [轻松学会Laravel-表单篇](https://www.imooc.com/view/699) —— 慕课网
* [轻松学会Laravel-高级篇](https://www.imooc.com/view/702) —— 慕课网
* [laravel 实战 ](http://www.maiziedu.com/course/649/) —— 麦子学院
* [Laravel：地球上最好用的PHP框架 - 入门篇](http://www.maiziedu.com/course/491/) —— 麦子学院
* [Laravel Vue 开发 SPA 应用](https://www.codecasts.com/series/laravel-vuejs-spa) —— codecasts.com
* [Laravel Vuejs 实战：开发知乎](https://www.codecasts.com/series/build-a-zhihu-website-with-laravel) —— codecasts.com
* [Laravel 实用 package 推荐](https://www.codecasts.com/series/awesome-laravel-packages) —— codecasts.com
* [laravel 开发微信公众号](https://www.codecasts.com/series/peak-into-wechat-development-using-laravel) —— codecasts.com
* [轻松使用 Laravel 队列](https://www.codecasts.com/series/laravel-queue-is-awesome) —— codecasts.com
* [Projects in Laravel: Learn Laravel Building 10 Projects](https://www.udemy.com/projects-in-laravel-learn-laravel-building-10-projects/) —— A complete course to master latest Laravel 5.4 web framework *（收费）*
* [laravel5.6 零基础入门](https://www.udemy.com/laravel56/) —— 轻松实战入门
* [PHP with Laravel for beginners - Become a Master in Laravel](https://www.udemy.com/php-with-laravel-for-beginners-become-a-master-in-laravel/) —— Learn to master Laravel to make advanced applications like the real CMS app we build on this course *（收费）*
* [100 Best Laravel Videos](http://meta-guide.com/videography/100-best-laravel-videos) —— youtube
* [Laravel / PHP 扩展包视频教程](https://learnku.com/courses/laravel-package) —— Laravel / PHP 扩展包视频教程 *（收费）*
* [全方位解读Laravel框架及实战视频教程（内附项目源码+笔记）](https://edu.51cto.com/course/10842.html?source=so) —— 课程目标： 全方位解读Laravel框架及实战 *（收费）*
* [Memcached在PHP和Laravel中的使用视频课程](https://edu.51cto.com/course/8706.html?source=so) —— 课程目标： 学习Memcached服务器的安装和基本使用，学习PHP连接Memcached服务的基本方法 *（收费）*
* [Laravel实战微信趣味项目2019.PHP](https://edu.51cto.com/course/17687.html?source=so) —— 课程目标： 课程目标： 了解Laravel各组件的基本使用、微信公众号的对接，帮助您跨入Laravel和公众号的开发大门 *（收费）*
* [最强框架Laravel基础入门视频教程(全48讲)](https://www.bilibili.com/video/av36494040/) —— bilibili.com 
* [Laravel Vuejs 实战：开发知乎](https://www.codecasts.com/series/build-a-zhihu-website-with-laravel) —— 从头开始创建一个全新的 laravel 项目并对开发环境进行可行的配置，使得 zhihu 的实战项目可以运行起来
* [Laravel 2019, the complete guide with real world projects](https://www.udemy.com/best-laravel/?ranMID=39197&ranEAID=R7BSs79ua1Y&ranSiteID=R7BSs79ua1Y-wJWXdMi23Sd4rFxdh21Zuw&LSNPUBID=R7BSs79ua1Y) —— Build simple to advanced web applications using the PHP's most popular web framework - Completely re-recorded for 5.8 *（收费）*
* [RESTful API with Laravel: Build a real API with Laravel](https://www.udemy.com/restful-api-with-laravel-php-homestead-passport-hateoas/?ranMID=39197&ranEAID=R7BSs79ua1Y&ranSiteID=R7BSs79ua1Y-81xaq4b8kNUt.guqIEH02g&LSNPUBID=R7BSs79ua1Y) —— Build a RESTful API for a market system using Laravel and dominates the challenging RESTful skills with Laravel *（收费）*
* [Laravel 5.8 正式发布，一起跟新特性开开杠](https://www.bilibili.com/video/av44988880/) —— bilibili.com
* [Laravel5.4快速开发简书网站](https://coding.imooc.com/class/111.html) —— 本课程使用大量Laravel基础及高级组件，结合Mysql异步消息队列、ElasticSearch搜索引擎、Debugbar调试利器、Laravel性能优化等技术开发前后台完整的社交网站“简书” 。慕课网 *（收费）*
* [Laravel 后端实战 - 共享单车项目](https://www.jikexueyuan.com/course/2702.html) —— 共享单车是目前很火的一个应用，本课程将会讲解共享单车的一些特性，并且使用PHP Laravel 5.4 框架来快速搭建共享单车的后端服务。极客学院 *（收费）*
* [Laravel5.8入门实战-安全与优化](https://study.163.com/course/introduction/1209192843.htm) —— 使用Laravel目前最新版本（5.8）来开发一个企业网站项目。主要以快速Laravel入门为主，同时还会介绍企业网站安全及如何防范和企业网站基本SEO优化。网易云课堂 *（收费）*
* [Laravel & Elastic全文搜索实战](https://study.163.com/course/introduction/1004832038.htm) —— 希望掌握高级搜索、大数据统计分析的入门与初学者。 网易云课堂 *（收费）* 
* [Laravel框架快速入门到精通](https://study.163.com/course/introduction/1209346815.htm) —— 适用：有PHP基础知识。网易云课堂 *（收费）*
* [Laravel优雅实战入门：第二版](https://study.163.com/course/introduction/1003163020.htm) —— laravel入门及进阶必学，不论你是刚听说laravel，对之向往，还是有了一定基础，迫切想进阶。网易云课堂 *（收费）* 
* [Laravel&Vue深度整合实战第二版](https://study.163.com/course/introduction/1003227034.htm) —— 带你学习vue的初中高级+国际潮流,同时还有跟laravel结合的优雅方式。网易云课堂 *（收费）* 
* [Laravel Echo 开发实时应用](https://geixue.com/course/develope-realtime-app-with-laravel-echo) —— Laravel Echo 在开发实时刷新应用的时候非常的强大，它把背后复杂的功能封装成一套优雅的接口，我们可以借助 Laravel 的 Event 系统，结合 Broadcasting 既可以开发一个实时的 Web 应用。 *（收费）* 
* [最新laravel商城实战视频教程](https://www.php.cn/course/871.html) —— 《最新laravel商城实战视频教程》本节课程是由云知梦录制，Laravel是一套简洁、优雅的PHP Web开发框架(PHP Web Framework)。
* [laravel基础开发宝典视频教程](https://www.php.cn/course/809.html) —— 《laravel基础开发宝典视频教程》Laravel是一套简洁、优雅的PHP Web开发框架(PHP Web Framework)。
* [Laravel开发商城前台视频教程](https://www.php.cn/course/859.html) —— 《Laravel开发商城前台视频教程》本节课程是使用PHP框架laravel开发的商城前台，对于想学习一款PHP框架的同学来说，本节视频教程是很不错的选择哦！
* [Laravel电商项目实战课程](https://www.php.cn/course/994.html) —— 《Laravel电商项目实战课程》课程讲解了Laravel项目的开发，学完该课程，就可以模仿开发一个电商项目了
* [Laravel实战开发短链生成器视频教程](https://www.php.cn/course/717.html) —— 《Laravel实战开发短链生成器视频教程》Laravel是一套简洁、优雅的PHP Web开发框架(PHP Web Framework)。
* [Laravel 6 PHP Framework for Just Beginners](https://www.udemy.com/course/laravel-6-framework/) —— In this course, you will learn larval 6 Core Functionalities, Laravel 6 CRUD and Default Authentication System.
* [Laravel 6.0 视频教程之新特性篇 - Coding10 出品](https://www.bilibili.com/video/av67323951/) —— 本套视频我们简单介绍一下Laravel 6.0带来的新特性。bilibili.com
* [Laravel 6 登录跳转](http://www.coding10.com/course/laravel6-auth-redirect) —— 登录跳转指的就是不同角色的用户登录之后会自动跳转到不同的服务页面，这是个简单的功能，实现也简单。
* [Laravel 在线支付](http://www.coding10.com/course/pc-payment-online) —— 我们本系列视频的专题就是在线支付，重点看一下如何实现 PC 网页上的扫码支付。  *（收费）* 
* [Laravel 资源管理](http://www.coding10.com/course/laravel-resource-management) —— 重点解决资源管理的问题，我们会构建一套资源管控机制，将用户资源更好的管理和维护。 *（收费）* 
* [Laravel Voyager 后台系统](http://www.coding10.com/course/laravel-admin-dashboard-voyager) —— 这个后台系统就是 Voyager，与官方的 Nova 相比，Voyager 也不落下风，在易用性方面甚至超过 Nova。 *（收费）* 
* [ Laravel 钩子技术](http://www.coding10.com/course/laravel-webhook) —— HOOK 课程是 Coding10 最有分量的一套视频，因为Hook的作用实在太强大了，应用也极为广泛，不管是订阅通知，还是物联网，智能家居，远程事件监控，在线支付实现都有它的身影。 *（收费）* 
* [Laravel API 接口开发 ](http://www.coding10.com/course/laravel-passport) —— 本套视频我们会对之前的很多知识进行一次大的整合，把零散的知识全部串起来。学会接口开发，给自己的职业发展扩展更大的空间吧。 *（收费）* 
* [ Laravel 事件监听](http://www.coding10.com/course/laravel-event-listener) —— Laravel Event & Listener 事件监听机制，让开发者不光是可以把代码组织得更加有条理的手段，而且也是对现实社会运行规则的高度抽象化映射。 *（收费）* 
* [Laravel 6.0 最新特性](http://www.coding10.com/course/what-is-new-in-laravel-6-lts) —— 6.0版本就是这样一个开端，它也是第一个语义化版本的开始，Laravel的版本演进也将进入更正规的迭代更新，虽然新特性并不多，但是还是带来了一些让人爱不释手的新变化
* [Laravel 缓存 ](http://www.coding10.com/course/laravel-cache) —— Laravel 的缓存系统绝对是最好用的缓存系统之一，接口简单易用，对开发者极其友好 ~ *（收费）* 
* [Laravel 7 正式发布，快来看看都有哪些令人脸红的新特性](bilibili.com/video/BV1cE411u7Ti) —— Laravel 视频教程： Laravel 7 正式发布，快来看看都有哪些令人脸红的新特性。
* [Laravel 7 新特性：更友好的测试命令 php artisan test 以及文件模板](https://www.bilibili.com/video/BV1BE411N7Sg) —— Laravel 视频教程： Laravel 7 新特性之更友好的测试命令 php artisan test 以及文件模板。bilibili.com
* [Laravel 7 新特性：路由绑定新姿势以及路由数据范围锁定](https://www.bilibili.com/video/BV1BE411N7vL) —— Laravel 视频教程： Laravel 7 新特性：路由绑定新姿势以及路由数据范围锁定。bilibili.com
* [Laravel 7 新特性：Fluent 字符串链式操作让字符串操作得到解脱](https://www.bilibili.com/video/BV1BE411N7n9) —— Laravel 视频教程： Laravel 7 新特性： Fluent 字符串链式操作让字符串操作得到解脱。bilibili.com
* [Laravel 7 最新特性](http://www.coding10.com/course/laravel7-new-features) —— Laravel 的演进方式非常成熟，以后也会围绕“效率”和“易用性”着两个方面对框架进行改进和升级。
* [Laravel 8 版本体验](https://www.bilibili.com/video/BV15p4y1Y7h7) —— Laravel 8 版本体验。bilibili.com
* [25分钟带你入门Laravel 8](https://www.bilibili.com/video/av372599092/) —— 今集会介绍非常热门的 PHP 框架 Laravel，刚刚推出了 8.0 版本。我们用 25 分钟时间，了解它的基本用法，包括增删查改、用户验证及表单验证。bilibili.com
* [Learn Laravel 8 Beginners Tutorial #1](https://www.youtube.com/watch?v=LQYq_LlGUc8) —— Learn Laravel 8 Beginners Tutorial #1 - Requirements, Installation of Laravel 8。YouTube
* [Learn Laravel 8 Beginners Tutorial #2](https://www.youtube.com/watch?v=CaybryfsTKw) —— Learn Laravel 8 Beginners Tutorial #2 - About Folder Structure in details。YouTube
* [Learn Laravel 8 Beginners Tutorial #3](https://www.youtube.com/watch?v=Q731AMYwhXA) —— Learn Laravel 8 Beginners Tutorial #3 - Understand the Landing page。YouTube
* [Learn Laravel 8 Beginners Tutorial #4](https://www.youtube.com/watch?v=V2bRK9w4rR4) —— Learn Laravel 8 Beginners Tutorial #4 - Create First Program in Laravel 8。YouTube
* [Learn Laravel 8 Beginners Tutorial #5](https://www.youtube.com/watch?v=mVEBaFnehOw) —— Learn Laravel 8 Beginners Tutorial #5 - Routing in Laravel 8 #1。YouTube
* [Learn Laravel 8 Beginners Tutorial #6](https://www.youtube.com/watch?v=txWNZcqKZRg) —— Learn Laravel 8 Beginners Tutorial #6 - Routing in Laravel 8 #2。YouTube
* [PHP高级|2021最新Laravel8.0从入门到精通实战教程](https://www.bilibili.com/video/av330756960/) —— PHP高级|2021最新Laravel8.0从入门到精通实战教程。bilibili.com
* [2020最新laravel8.0深入浅出大神进阶之路](https://www.bilibili.com/video/BV1op4y167pY?spm_id_from=333.999.0.0) —— 【PHP框架】2020最新laravel8.0深入浅出大神进阶之路。bilibili.com
* [LX4 Laravel / PHP 五分钟视频](https://learnku.com/courses/php-laravel-video/2022) —— LX4 Laravel / PHP 五分钟视频。*（收费）*
* [Laravel 9 基础入门](https://www.coding10.com/course/laravel-9-basic) —— 从零开始，采取渗透式的学习方式，一步步从简单的概念出发，一点点掌握程序开发，项目管理以及程序设计的核心内容。
* [Laravel 9 全新特性](https://www.coding10.com/course/laravel9-new-features) —— Laravel 9 全新特性详解
* [Laravel 9 学习正当时](https://www.php.cn/course/1421.html) —— Laravel 9 学习正当时—保姆级教程，想学不会都难！*（收费）*
* [Laravel 9 小白基础入门大闯关](https://space.bilibili.com/108698873/channel/collectiondetail?sid=527176) —— Laravel 9 入门。bilibili.com
* [Laravel 9 & 10 优雅实战入门（第三版）](https://www.pilishen.com/course/1) —— Laravel 9 & 10 优雅实战入门（第三版）*（收费）*

### 文章教程
* [Laravel 速查表](https://learnku.com/docs/laravel-cheatsheet/8.x) —— Laravel 速查表
* [lvwenhan.com](https://lvwenhan.com/sort/laravel) —— 【最适合中国人的Laravel教程】系列 - 岁寒
* [Laravel5系列入门教程](http://www.golaravel.com/post/laravel-5-getting-started-part-1/) —— Laravel5系列入门教程
* [Laravel大型项目系列教程](https://www.shiyanlou.com/courses/123) —— Laravel大型项目系列教程
* [Laravel5 入门小项目详细教程](https://phphub.org/topics/804) —— 不做伸手党,分享快乐,Laravel5 入门小项目详细教程
* [Laravel: 从百草园到三味书屋](https://openset.gitbooks.io/laravel/content/) —— Laravel 作者写的一本小书，介绍了 Laravel 的各种设计理念
* [Laravel Tutorial](https://www.tutorialspoint.com/laravel/index.htm) —— tutorialspoint.com
* [learninglaravel.net](https://learninglaravel.net/) —— learninglaravel.net
* [Laravel 教程 - Web 开发实战入门  ](https://laravel-china.org/courses/laravel-essential-training/5.7) —— L01 Laravel 教程 - Web 开发实战入门 ( Laravel 5.7 ) 
* [基于 Laravel 5.7 开发博客应用系列](https://laravelacademy.org/category/blog) —— 博客系列 基于 Laravel 5.7 开发博客应用系列
* [Laravel 从学徒到工匠精校版（ Laravel 5）](https://laravelacademy.org/laravel-from-appreciate-to-artisan) —— 基于Laravel 5 进行高级应用架构
* [Laravel 前后端分离应用实例教程：Roast](https://laravelacademy.org/api-driven-development-laravel-vue) —— 本系列教程将基于 Laravel 5.6 + Vue 2 开发一个 API 驱动的前后端分离应用，命名为 Roast
* [Laravel 5.7 From Scratch](https://laracasts.com/series/laravel-from-scratch-2018) —— "Laravel From Scratch" has been the go-to video resource for Laravel newcomers since 2013. （自2013年以来，“Laravel From Scratch”一直是Laravel新人的首选视频资源。）
* [11 FREE LARAVEL VIDEO TUTORIALS FOR ABSOLUTE BEGINNERS](https://www.webdesignerdepot.com/2018/03/11-free-laravel-video-tutorials-for-absolute-beginners/) —— 初学者的11个免费的laravel视频教程
* [8 Best + Free Laravel 5 Tutorial, Course, Training & Certification （2018）](https://digitaldefynd.com/best-laravel-tutorial-course-training-certification/) —— 8 个优秀的免费Laravel 5教程、课程、培训及认证
* [Laravel 从入门到精通系列教程](https://laravelacademy.org/laravel-tutorial-5_7) ——  适用于 Laravel 5.5、5.6、5.7 版本，本系列教程将围绕一个 LTS 版本，然后采取增量更新方式，随着 Laravel 版本的升级不断进行更新，直到 Laravel 框架不再维护。
* [Laravel Tutorial: Step by Step Guide to Building Your First Laravel Application](https://laravel-news.com/your-first-laravel-application) —— Step by Step Guide to Building Your First Laravel Application
* [How to Learn Laravel](https://medium.com/@hayreddintuzel/how-to-learn-laravel-a-roadmap-from-beginner-to-advanced-5414640362e8) —— A roadmap from beginner to advanced — 2019
* [Learn Laravel (Best Laravel Tutorials for Beginners)](https://medium.com/hackr-io/learn-laravel-best-laravel-tutorials-for-beginners-b2843d2db263) —— Best Laravel Tutorials for Beginners
* [Laravel 5.8 CRUD Tutorial With Example For Beginners](https://appdividend.com/2019/03/08/laravel-5-8-crud-tutorial-with-example-for-beginners/) —— Laravel 5.8 CRUD Tutorial With Example For Beginners is today’s topic. 
* [轻松部署 Laravel 应用](https://learnku.com/blog/Wi1dcard/tags/easy-deployment-of-laravel-applications_50034) —— 本课程内，我将尽全力降低对于运维以及 Shell 专业知识的要求，以尽可能贴近国内 PHP 工程师的方式讲述部署过程。读者可跟随课程描述，边学习边操作，快速了解整套流程，一步一步地实现发布上线。
* [（easywechat + Laravel 5.8）整理 PC 端微信扫码支付全过程](https://www.php.cn/phpkj/laravel/429041.html) —— PC 端微信扫码支付全过程
* [30分钟用 Laravel 实现一个博客](https://www.php.cn/phpkj/laravel/428880.html) —— 30分钟用 Laravel 实现一个简单的博客
* [LX1 Laravel / PHP 扩展包视频教程2019](https://learnku.com/courses/laravel-package/2019) —— 每周精选两个以上扩展包进行讲解，涵盖 PHP 和 Laravel 相关的最新、最热、最常用的扩展包.*（收费）*
* [LX2 PHP 扩展包实战教程 - 从入门到发布](https://learnku.com/courses/creating-package) —— 经验丰富的 PHP 扩展包开发者带你一步步从 0 开始发布你的第一个扩展包。 *（收费）* 
* [LX3 Laravel 性能优化入门](https://learnku.com/courses/laravel-performance/6.x) —— 开发 Laravel 应用时必知必会的性能优化知识 *（收费）*
* [Install Laravel 6 on a Server & Make Your App More Powerful](https://www.cloudways.com/blog/install-laravel-on-server/) —— we will demonstrate how to install Laravel 6, what are the new features introduced in it and what benefits it brings for the developers.
* [Laravel 6 Tutorial for Beginner: Create your First To-Do App](https://www.parthpatel.net/laravel-tutorial-for-beginner/)　—— Learn Laravel in simple and easy steps starting from basic to advanced concepts by creating your first to-do application with basic CRUD functionality
* [8 Best + Free Laravel 5 Tutorial, Course [2019] [UPDATED]](https://digitaldefynd.com/best-laravel-tutorial-course-training-certification/) —— 8 Best + Free Laravel Tutorial, Course, Training, Class & Certification Online [2019]
* [Laravel 6 CRUD Application Tutorial](https://www.itsolutionstuff.com/post/laravel-6-crud-application-tutorialexample.html) —— Laravel 6 CRUD Application Tutorial
* [Laravel 6 Tutorial From Scratch | Step By Step](https://www.tutsmake.com/laravel-6-tutorial-from-scratch-laravel-step-by-step/) —— Here you can learn laravel easy and simple way from scratch (step by step).
* [Laravel 7 扩展开发教程](https://zhuanlan.zhihu.com/p/139016990) —— Laravel 7 扩展开发教程
* [Laravel 入门项目：博客系列教程](https://xueyuanjun.com/books/laravel-blog-tutorial) —— Laravel 入门项目：博客系列教程 
* [微信小程序开发入门系列教程](https://xueyuanjun.com/books/wechat-miniprogram-tutorial) —— 基于Laravel API接口的微信小程序开发快速入门指南 
* [Laravel 8 教程：一个简单的 CRUD 教程](https://learnku.com/laravel/t/50012) —— Laravel 8 教程：一个简单的 CRUD 教程
* [Laravel 8 系列教程](https://www.learnfk.com/course-laravel) —— 无涯教程：Laravel 8 系列教程
Laravel 入门教程
* [Laravel 入门教程学习](https://laravel-study.catchadmin.com) —— Laravel 初学者非常友好的入门教程

## Laravel 开源项目集
### 原型项目
* [Laravel 5 Boilerplate](http://laravelacademy.org/post/1359.html) —— 基于当前Laravel最新版本（Laravel 5.1.*）并集成Boilerplate的项目
* [Laravel 5 Angular Material Starter](http://laravelacademy.org/post/1426.html) —— 一个Laravel 5.1和AngularJS的原型项目
* [Someline Starter](https://laravelacademy.org/post/6408.html) ——  基于Laravel 5和Vue.js，用于快速构架RESTful API和Web应用的原型项目

### CMS
* [Bootstrap CMS](http://laravelacademy.org/post/709.html) —— Laravel 5.1驱动的功能强大的CMS
* [October](http://laravelacademy.org/post/1132.html) —— 基于Laravel 5，致力于让开发工作变得简单的CMS
* [PyroCMS](http://laravelacademy.org/post/1391.html) —— MVC架构的PHP内容管理系统，3.0以前基于CodeIgniter，目前基于Laravel 5.1
* [LavaLite](http://laravelacademy.org/post/1227.html) —— 基于Laravel 5.1 & Bootstrap 3的内容管理系统
* [TypiCMS](http://laravelacademy.org/post/1508.html) —— 基于 Laravel 5 构建的、支持多语言的内容管理系统
* [Laracms](https://www.laracms.cn/) —— 一款基于 Laravel 开发的基础中文内容管理系统，可以在此基础上快速，优雅的开发实现您的需求
* [AmilaCMS](https://github.com/AlexStack/Laravel-CMS) —— 适合整合已运中的Laravel 5.x & 6.x网站系统，可自定义数据库表前缀, 使用Bootstrap 4, 有中文语言包

### 论坛
* [Laravel.io](http://laravelacademy.org/post/666.html) —— Laravel开发者社区
* [Flarum](http://laravelacademy.org/post/1090.html) —— 免费的、开源的、专注于简约的论坛系统，esoTalk和FluexBB的联合继承者
* [PHPHub](http://laravelacademy.org/post/899.html) —— 积极向上的 PHP & Laravel 开发者社区
* [LaraBBS](https://github.com/summerblue/larabbs) —— LaraBBS 是一个简洁的论坛应用，使用 Laravel 编写而成。

### 项目管理
* [92five app](http://laravelacademy.org/post/1045.html) —— 基于 Laravel框架 & Backbone JS 构建，是一个自托管的、基于web的项目管理应用
* [Scrumwala](http://laravelacademy.org/post/956.html) ——  基于Laravel5，项目管理应用
* [Ribbbon](https://laravelacademy.org/post/7341.html) —— 基于Laravel 5.1和Vue.js构建的开源项目管理系统

### 博客
* [Wardrobe](http://laravelacademy.org/post/1203.html) ——  专注于写作的最小化博客平台
* [Laravel 5 Blog](https://github.com/yccphp/laravel-5-blog) —— 基于 Laravel 5 开发的博客系统
* [Canvas](http://laravelacademy.org/post/5136.html) —— 基于Laravel 5.2 开发的轻量级博客系统
* [Katana](http://laravelacademy.org/post/4019.html) —— 静态博客/站点生成器（支持Markdown和GitHub Pages）
* [MyPersimmon](http://laravelacademy.org/post/7119.html) —— 基于 Laravel 5.4 开发的博客系统
* [moell-blog](https://github.com/moell-peng/moell-blog) —— 基于 Laravel 开发，支持 Markdown 语法的博客 moell.cn
* [bjyblog](https://github.com/baijunyao/laravel-bjyblog) —— 基于 laravel 开发的的 blog baijunyao.com，这个项目是把 thinkphp-bjyblog 用 laravel 框架重构后的产物
* [PJ Blog](https://github.com/jcc/blog) —— 一个由 Laravel 5.* 和 Vuejs 2.* 建立的开源博客系统。pigjian.com
* [Livewire-Blog](https://github.com/youyingxiang/livewire-blog) —— Livewire-Blog是一个基于laravel-8开发的一个博客系统

### 电子商务
* [Antvel](https://laravelacademy.org/post/3793.html) —— Antvel 是一个基于 Laravel 5.* 开发的开源电子商务项目
* [Bagisto](https://laravelacademy.org/post/19446.html) —— 基于 Laravel + Vue.js 构建的开源电商系统 

### 面试

* [PHP 面试指南-laravel 篇](https://www.jishuchi.com/read/php-advanced-interview/3441)
* [91 个常见的 Laravel 面试题和答案](https://learnku.com/laravel/t/38446)
* [2021年PHP-Laravel面试题](https://blog.csdn.net/wuxianbing2012/article/details/113565388)
* [面试必备！Laravel面试题及其答案合集详解](http://www.srcmini.com/33203.html)
* [50道面试官必问的Laravel面试题【附答案】](https://www.php.cn/phpkj/laravel/473457.html)

## 其他
* [Laravel Tricks](http://laravelacademy.org/post/681.html) ——   Laravel 小技巧&小贴士
* [Invoice Ninja](http://laravelacademy.org/post/1117.html) ——   基于 Laravel 构建的开源发票及时间跟踪应用
* [Paperwork](http://laravelacademy.org/post/748.html) ——   基于 Laravel 4.X 的开源的笔记&归档工具
* [Cachet ](http://laravelacademy.org/post/824.html) ——   基于 Laravel 5 的开源的状态页系统
* [StyleCI](http://laravelacademy.org/post/872.html) ——   由 PHP CS Fixer 开发，提供 PHP 代码风格持续集成服务
* [Podcastwala](http://laravelacademy.org/post/1006.html) ——   基于 Laravel 5 ，构建属于你自己的播客网站
* [Deployer](http://laravelacademy.org/post/1681.html) ——   基于 Laravel 5.1 的、免费的、开源的 PHP 应用部署工具
* [20 Laravel Eloquent Tips and Tricks](https://laravel-news.com/eloquent-tips-tricks) —— Laravel Eloquent Tips
* [Laravel Daily: Laravel Tips & Tutorials](https://laraveldaily.com/) —— Laravel Daily project has a goal of helping developers to learn some new Laravel trick (or remember an old one) every day.
* [Orgmanager](https://github.com/orgmanager/orgmanager) —— GitHub 组织的邀请系统 Invite System for GitHub Organizations
* [timegrid](https://github.com/timegridio/timegrid) —— 基于Laravel PHP Framework的免费开源在线约会平台。Free, open-source, online appointments platform based on Laravel PHP Framework.
* [支付宝SDK在Laravel5的封装](https://github.com/Latrell/Alipay/) —— 支付宝SDK在Laravel5/Lumen封装包。该拓展包想要达到在Laravel5/Lumen框架下，便捷使用支付宝的目的。
* [A Laravel Boilerplate Project](https://github.com/rappasoft/laravel-boilerplate) —— Laravel Boilerplate (Current: Laravel 6.0) 
* [微信 SDK for Laravel 5 / Lumen](https://github.com/overtrue/laravel-wechat) —— 微信 SDK for Laravel 5 / Lumen， 基于 overtrue/wechat
* [Larave9.0 + bootstrap3 后台管理系统](https://github.com/qin795217119/b5laravelcmf) —— B5LaravelCMF V2.0，基于 Laravel 9 + bootstrap 3，构架的通用后台开发框架，简洁、易读、方便系统扩展及二次开发。

## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=qianyugang/learn-laravel&type=Date)](https://star-history.com/#qianyugang/learn-laravel&Date)

