
## 项目介绍

Mac软件清单、Mac使用技巧。正在不断完善中，努力做到最全，欢迎star。

你也可以关注公众号「千古壹号」，学习更多技能。


## 一、常用软件

### 启动工具

- [Raycast](https://www.raycast.com/) - Alfred 的竞品。[#](https://se7en.hedwig.pub/i/zui-jin-fei-chang-xi-huan-de-app-raycast-yi-ji-ta-de-cha-jian-xi-tong)【荐】

- [Alfred](https://www.alfredapp.com/) - Mac 上应该安装的第一个效率神器。【荐】

相关文章：[《程序员的macOS系列：高效Alfred进阶》](https://juejin.cn/post/6844904062484217863) [《Mac神器Alfred之自定义一个多应用快速切换的workflow》](https://mp.weixin.qq.com/s/DdT98goc5nR73RfK-ISGiQ)


### 截图

- [snipaste](https://zh.snipaste.com/) - 新生代截图工具。【荐】。

- [shottr](https://shottr.cc/) - 面向像素的屏幕截图工具，支持智能测距、滚动截图、元素智能删除、打码或隐藏、OCR 文本识别、距离标注等功能。他是为像素级专业人士（设计师、前端开发人员等）服务的，它的强项是精确度和速度，其杀手特征是变焦。【荐】。

- [Xnip](https://zh.xnipapp.com)- Mac上方便好用的截图工具，支持滚动截图；最大的优点是，**截图可以自带阴影，效果不错**。[#](https://sspai.com/post/42654)。【荐】

- [Picsee](http://picsee.chitaner.com/) - 看图 & 截图。

- [Annotate](https://itunes.apple.com/cn/app/annotate-capture-and-share/id918207447?mt=12) - 可对屏幕截图或者现有图片进行批注。同时，在基础的图片注释功能上还增加了“局部高亮”、“Emoji 表情”、 ”GIF 动图录制与注释“、“与 Dropbox/CloudApp 同步数据“等功能。[#](https://sspai.com/post/30486)

### 浏览器

- [Safari](http://www.apple.com/cn/safari/) - Mac预装的自带浏览器。【荐】

- [Chrome](http://www.google.cn/chrome/browser/) - Chrome浏览器，谷歌出品。【荐】

- [Arc](https://arc.net/)- 新一代浏览器；优点是交互新颖，缺点是占内存。【荐】

- [Firefox](http://www.firefox.com.cn/) - 火狐浏览器。

- [Opera](http://www.opera.com/zh-cn) - Opera 浏览器。

### 护眼工具

- [f.lux](https://justgetflux.com/) - 降低屏幕的色温，减弱蓝光，保护眼睛。【荐】

### 输入法

- [搜狗输入法](http://pinyin.sogou.com/mac/) - 搜狗输入法。【荐】

- [RIME](http://rime.im/) - 中州韻輸入法引擎。[开源](https://github.com/rime)。在Mac平台的名字叫「鼠须管」。 【荐】

- [Input Source Pro](https://inputsource.pro/) - 一款在不同应用之间自动切换输入法的小工具。通过简洁的提示方式，配合输入法自动切换功能，让每一次输入都信心十足。【荐】

开发者@[Runjuu](https://web.okjike.com/u/211AC08F-8546-4CAE-8274-5C371574332A)

- [百度输入法](https://srf.baidu.com/input/mac.html) - 支持拼音五笔输入。

- [清歌五笔输入法](https://qingg.im/index.html) - 为 iOS 和 Mac 专门打造的五笔输入法。

- [WBIM](http://www.pawpawsoft.com) - 五笔输入法。

- [Rocket](http://matthewpalmer.net/rocket/) - Emoji标签输入。

- [颜文字](https://itunes.apple.com/cn/app/yan-wen-zi/id914708191?mt=12) - 颜文字输入。

- [哈利路亚英文输入法](https://github.com/dongyuwei/hallelujahIM) - 智能英文输入法，具备自动补全，自动纠错功能。

### 菜单栏管理

> 对于崇尚简洁的Mac用户来说，菜单栏管理软件是很有必要的。

- [Hidden Bar](https://apps.apple.com/cn/app/hidden-bar/id1452453066?mt=12)：用最精简的功能，实现了在菜单栏隐藏应用图标这个小需求。[开源免费](https://github.com/dwarvesf/hidden)。【荐】

- [Vanilla](https://matthewpalmer.net/vanilla/) - 隐藏 Mac 菜单栏图标。基础功能免费，扩展功能付费。【荐】

- [Dozer](https://github.com/Mortennn/Dozer/releases)：一款隐藏macOS菜单栏图标的应用，开源免费，操作简单。

Dozer 操作方法很简单，Dozer运行后在菜单栏会出现一个「‧」，点击它，然后会在左侧出现另外一个「‧」，按住 command 键拖曳软件图标到最左侧即可。然后点击右侧的「‧」，软件图标就会被隐藏。

- [Bartender](https://www.macbartender.com/)：付费软件。能够创建一个二级的菜单栏，让我们把不需要直接显示的菜单栏的应用图标放在这个二级菜单栏中，或者直接隐藏。

- [MenubarX](https://menubarx.app/) - 一款强大的 Mac 菜单栏浏览器，可以在菜单栏固定任何网页，就像原生 App 一样使用。【荐】

### 日历工具

- [Itsycal](https://www.mowglii.com/itsycal/) - 一款简洁实用的开源日历工具。可以直接在 menubar 上展示今天是几号；点击后，还自动框选出了本月的时间范围。好处是，可以在最短的时间内查看日历，基本可以替代原生的时间了。[开源](https://github.com/sfsam/itsycal)。【荐】

日期格式举例：`yyyy/MM/dd HH:mm E`,对应的显示效果为`2023/10/18 20:08 周三`。

- [Fantastical](https://flexibits.com/fantastical) - 日历应用程序，你将管理好生活。【荐】。




### 下载工具

- [Motrix](https://motrix.app/) - 基于Aria2实现，支持磁力链、种子和迅雷链接，开源免费。【荐】

- [迅雷](https://www.xunlei.com/) - 限速严重，没有会员基本没法儿用。

- [Transmission](https://www.transmissionbt.com/) - 免费的BitTorrent客户端 [开源](https://github.com/Sigil-Ebook/Sigil)。

- [aria2](https://aria2.github.io/) - 一款支持多种协议的轻量级命令行下载工具。[开源](https://github.com/aria2)。

- [JDownloader](http://jdownloader.org/) - 下载工具，下载文件的一键式托管。

- [You-Get](https://you-get.org/) - 网络富媒体命令行下载工具。[开源](https://github.com/soimort/you-get)。

- [Free Download Manager](http://www.freedownloadmanager.org/) - 功能强大的下载加速器。

- [FOLX](http://mac.eltima.com/download-manager.html) - Folx 是一个Mac osx 系统风格界面的下载管理工具。

- [ENFI下载器](http://enfi.cloud/) - 使用P2P下载技术，支持HTTP，BT，磁力链等各种协议，高速下载让你摆脱限速的困扰，从此告别低速。

### 压缩／解压

- [MacZip](https://ezip.awehunt.com/)  - 由国人开发的免费Mac解压缩软件，而且支持解压带密码的压缩包。

- [Keka](https://www.keka.io/)

- [BetterZip 3](https://macitbetter.com/) - 压缩解压缩工具。支持格式 ZIP、TAR、TGZ、TBZ、TXZ (new)、7-ZIP、RAR。【荐】
- The Unarchiver - 压缩／解压工具。

### 其他工具

- [12306ForMac](https://github.com/fancymax/12306ForMac) - Mac版12306 订票/捡票 助手。[开源](https://github.com/fancymax/12306ForMac)
- [AirServer](http://www.airserver.com/Download) - 将手机投影到电脑上。
- [CheatSheet](https://www.mediaatelier.com/CheatSheet/) - CheatSheet 是一款Mac上的非常实用的快捷键快速提醒工具。
- [WWDC](https://github.com/insidegui/WWDC) - Mac OS的非官方的WWDC APP。[[开源]](https://github.com/insidegui/WWDC)
- [xScope](http://xscopeapp.com/) - 测量、检查和测试屏幕上的图形和布局的工具。搜索你的苹果和网络，快速打开应用程序。
- [Todoist](https://todoist.com/mac) - 跨平台的任务管理器与移动应用程序。
- [TaskPaper](https://www.taskpaper.com/) - 漂亮的纯文本任务列表。
- [Wunderlist](https://todoist.com/mac) - 奇妙清单跨平台的任务管理器与移动应用程序。
- [Ukelele](http://scripts.sil.org/ukelele) - Unicode键盘布局编辑器。
- [Karabiner](https://pqrs.org/osx/karabiner/) - 一个强大的和稳定的OS X的键盘定制。[[开源](https://github.com/tekezo/Karabiner)
- [Keytty](http://keytty.com) - 让你通过键盘使用鼠标。
- [AppCleaner](http://freemacsoft.net/appcleaner/) - 一个小应用程序，让你彻底卸载不需要的应用程序。
- [Numi](http://numi.io/) - 漂亮的计算器应用。
- [Day-O 2](http://www.shauninman.com/archive/2016/10/20/day_o_2_mac_menu_bar_clock) - 菜单日历更换内置日历。
- [OnyX](http://www.titanium.free.fr/) - 多功能实用工具来验证磁盘和文件，运行清洁和系统维护任务，配置隐藏选项等。
- [SSH Tunnel](https://codinn.com/products/ssh-tunnel/) - 管理你的SSH。
- [Tuxera NTFS](http://www.tuxera.com/products/tuxera-ntfs-for-mac/) - Mac上的NTFS文件系统驱动。
- [gfxCardStatus](https://gfx.io/) - 控制Mac独立显卡与集成显卡之间的切换。
- [openEmu](http://openemu.org/) - 模拟器，可以玩魂斗罗之类，放松回到小时候。[[开源]](https://github.com/OpenEmu/OpenEmu)
- [Hammerspoon](http://www.hammerspoon.org/) - 功能强大的自动化工具，Lua 脚本驱动，支持窗口管理。[[开源]](https://github.com/Hammerspoon/hammerspoon)
- [DaisyDisk](https://daisydiskapp.com/) - 磁盘空间使用扫描工具。
- [iStat pro](https://bjango.com/mac/istatmenus/) - 免费的Mac OS电脑硬件信息检测软件。
- [BitBar](https://getbitbar.com/) - 支持使用各种语言将信息展示到Mac OS的菜单栏。[开源](https://github.com/matryer/bitbar)
- [ClipMenu](http://www.clipmenu.com) - 一个剪贴板操作的管理器。
- [Paste](http://pasteapp.me) - 智能剪贴板历史片段管理。
- [ControlPlane](http://www.controlplaneapp.com/) - 自定义Mac情景模式。某些场景让Mac自动静音或是自动打开Mail客户端等等。[开源](https://github.com/dustinrue/ControlPlane)
- [Caffeine](http://lightheadsw.com/caffeine/) - 实用工具，菜单栏按钮，点击休眠。
- [HTML5 Player](http://zythum.sinaapp.com/youkuhtml5playerbookmark/) - Chrome插件解决中国视频网站播放视频电脑发热的情况。
- [Monity](http://www.monityapp.com/) - 帮助用户实时监控系统的一款非常漂亮的软件。
- [iStats](https://github.com/Chris911/iStats) - iStats 是一个可以让你快速查看电脑 CPU 温度，磁盘转速和电池等信息的命令行工具。[[开源]](https://github.com/Chris911/iStats)
- [InsomniaX](https://www.macupdate.com/app/mac/22211/insomniax) - 合上盖子不眠不休，继续听歌下载。
- [NoSleep](https://www.macupdate.com/app/mac/37991/nosleep) - 合上盖子不休眠，可根据是否连接电源单独设置。
- Finder
    - [Quicklook-Plugins](https://github.com/sindresorhus/quick-look-plugins) - Finder快速预览文件插件。
    - [Path Finder](http://www.cocoatech.com/pathfinder/) - 强大的Finder替代者，拥有很多特性。
    - [TotalFinder](http://totalfinder.binaryage.com/) - 强大的Finder替代者，界面风格像Chrome。【荐】
    - [XtraFinder](https://www.trankynam.com/xtrafinder/) - 给Finder添加有用的新特性。


## 二、进阶软件

### 科学上网（代理工具）

科学上网包括两步：代理工具+服务，缺一不可。（1）先安装工具；（2）然后购买服务，或者自行搭建服务。

- [clash](https://github.com/yichengchen/clashX/releases) - ClashX 旨在提供一个简单轻量化的代理客户端。【荐】
- [Shadowsocks](http://shadowsocks.org/) - 一个快速的隧道代理，可以帮助你绕过防火墙。
- [ShadowsocksX-NG](https://github.com/qiuyuzhou/ShadowsocksX-NG) - 一款ShadowsocksX客户端软件。
- [Surge](http://nssurge.com/) - 科学上网。

### 科学上网（服务）

- [AgentNEO](https://agneo.co/?rc=ut50176c) - 网速很快，很稳定。支持支付宝付款。【荐】
- [Lantern](https://getlantern.org) - 蓝灯。

### 密码管理

- [1password](https://1password.com/) - 全平台的帐号密码管理软件。【荐】

- [LastPass](https://lastpass.com/) - 密码管理器和安全的数字笔记。

- [KeePassX](https://www.keepassx.org) - 一个免费的，[开源](https://github.com/keepassx/keepassx)的，体积小的密码管理器。

- [MacPass](http://mstarke.github.io/MacPass/) - [开源](https://github.com/mstarke/MacPass)的密码管理器。

### 鼠标增强

- [Mos](https://mos.caldis.me/) - 普通鼠标的滚轮更流畅。且可以设置鼠标的滚动方向。[开源]()【荐】

普通鼠标滚轮一格一格的滚动效果总是没有触摸板来的顺滑，这款 Mos 可以让平滑滚动应用到系统的每个角落，让鼠标滚轮用起来也有触摸板的感觉。

- [Scroll Reverser](https://pilotmoon.com/scrollreverser/) - 免费软件，可以分别设置鼠标和触控板的滚动方向。【荐】

- [Smooze Pro](https://smooze.co/) - Mac 鼠标平滑滚动神器。付费软件。【荐】

- [BetterTouchTool](http://www.bettertouchtool.net/) - 触控板、Magic mouse 鼠标增强工具。比如，这个工具可以让Magic mouse实现「轻点代替点按」。[#](https://mp.weixin.qq.com/s/A_LP4uQKSVkSNZR5EKEaxA)、[#](https://mp.weixin.qq.com/s/DxvLJRF8nhIJ1z_7E5CuIA)、[#](https://mp.weixin.qq.com/s/DxvLJRF8nhIJ1z_7E5CuIA)

- Smooth Scroll - 付费软件，让鼠标的滚轮更流畅。

Smooth Scroll 提供了一些晦涩难懂的数值型设置选项，我认为默认的设定已经可以满足需求，并没有调节的必要。但一定不要忘记开启「Bounce back from edges」选项，打开之后就有橡皮筋回弹的效果啦。另外，需要注意的是：「Standard wheel direction」选项与 Scroll Reverser 一起使用会有「负负得正」的效果，所以建议把「Standard wheel direction」这个选项的勾去掉。[#](http://sspai.com/32832)

### gif图生成

- [Licecap](http://www.cockos.com/licecap/) - 是一款屏幕录制工具输出GIF，录制过程中可以随意改变录屏范围，录制的文件也非常小。支持 Mac 和 Windows 平台。[开源](https://github.com/justinfrankel/licecap) 【荐】。

录制结束后，如果觉得文件过大，可以在这个网站<https://ezgif.com/optimize>上进行压缩。

- [Gifox](https://gifox.io/) - 专业的高颜值GIF 录制应用。

- [Gifski](https://sindresorhus.com/gifski) - 一款视频转 GIF 的工具，只需拖入即可完整转换。可选择缩放比例、帧率、质量，还能实时看到对应体积，简单易用。

- [Kap](https://getkap.co/) - 轻量 GIF 录屏小工具。[开源](https://github.com/wulkano/kap)。



### 窗口管理

- [Magnet](https://magnet.crowdcafe.com/) - 窗口分屏工具。【荐】

- [ShiftIt](https://github.com/fikovnik/ShiftIt) - 窗口位置和大小管理软件。 [[开源]][https://github.com/fikovnik/ShiftIt](荐)

- [Moom](http://manytricks.com/moom/) - 多任务多窗口的软件。

- [Slate](https://github.com/jigish/slate) - 窗口管理器，可用JavaScript写配置。[[开源]](https://github.com/jigish/slate)

- [Amethyst](http://ianyh.com/amethyst/) - 窗口管理器（自动保持窗口大小的窗口）。[开源](https://github.com/ianyh/Amethyst)

- [Spectacle](https://www.spectacleapp.com) - 简单的移动和调整大小的窗口，和可定制的键盘快捷键。




### 翻译工具

- [欧路词典](http://www.eudic.net/eudic/mac_dictionary.aspx) - 欧路词典。
- [有道翻译](http://cidian.youdao.com/multi.html) - 有道词典桌面版。
- [Bob](https://ripperhe.gitee.io/bob/#/) - 截图翻译软件。
- [iTranslate](http://www.itranslate.com/) - 支持全世界超过 80 种语言发音和输出。


### Mac系统管理、磁盘清理

- [腾讯柠檬清理](https://lemon.qq.com/) - 匠心打磨清理体验，一键释放磁盘空间。【荐】
- [OmniDiskSweeper](https://www.omnigroup.com/more/) - 最简单易操作、免费的、强大的Macbook内存清理软件。它可以深度清掉Mac里那些犄角旮旯里的缓存数据，也就是那些占了很多内存但是你并找不到在哪里的「其他」。[#](https://web.okjike.com/originalPost/61fbdd4d0256da0010792d62)
- [CleanMyMac X](https://cleanmymac.com/) - 删除系统垃圾、不需要的应用程序和恶意软件，并调整你的 Mac 以获得最大速度。
- [MacBooster](https://www.macbooster.cn/) - 磁盘、内存清理工具。
- [DaisyDisk](https://daisydiskapp.com/) - 磁盘分析工具。了解磁盘使用状况，并进行准确的分析。DaisyDisk 的视觉系属性大大超过了功能性。 [#](https://www.twblogs.net/a/5baad01e2b7177781a0e94d6/zh-cn)

### iPhone 照片管理、文件管理工具

- [iMazing](https://imazing.com/zh) - 能够将照片、音乐、文件、消息和应用等数据从iPhone、iPad 或iPod 传输到Mac 或 PC 上。轻松管理和备份 iOS 设备，无需使用iTunes。付费软件。【荐】

### 锁屏、休眠相关

- [Caffeinated](https://caffeinated.app/) - 防止系统进入休眠状态。



### NTFS移动硬盘读写

> 其实，macOS 系统本身是已经原生支持 NTFS 磁盘格式的读与写的，只不过 NTFS 毕竟是老对手 微软 Windows 产品下的技术，碍于版权和商业上的原因，苹果只好把 NTFS 的“写入”功能给屏蔽掉，变成系统的隐藏特性。

- [Paragon NTFS for Mac](https://china.paragon-software.com/home-mac/ntfs-for-mac/) - NTFS移动硬盘读写工具。【荐】

- [NTFS for Mac 助手](https://www.ntfsformac.com/) - 轻松实现 Mac 电脑读写 NTFS 磁盘。【荐】。

- [Mounty](http://enjoygineering.com/mounty/) - 免费让 Mac 原生支持移动硬盘/U盘 NTFS 读写的驱动应用。团长把这个软件试用了一段时间，发现容易导致文件丢失，所以，请慎用。[#](http://www.iplaysoft.com/mounty-for-ntfs.html)



### 数据恢复

- [DiskWarrior](http://www.alsoft.com/DiskWarrior/) - 恢复文件系统损坏时，磁盘工具进行选择。
- [Data Rescue](https://www.prosofteng.com/datarescue-mac-data-recovery/) - 多种情况下的全面和专业的数据恢复。
- [Stellar Phoenix Mac Data Recovery](http://www.stellarinfo.com/data-recovery-mac.php) - 一个功能强大的恢复文件面向Mac的工具。
- [R-Studio for Mac](http://www.r-studio.com/data_recovery_macintosh/) - 可恢复分区被格式化、损坏或被删除的文件。


### 文件传输

- [Android File Transfer](https://www.android.com/filetransfer/) - Google 官方推出的，让Android设备连接电脑，进行文件管理。
- [handshaker](http://www.smartisan.com/apps/handshaker) - 锤子科技推出的，以前名叫SmartFinder.  [#](http://www.ifanr.com/app/612734)


### 远程协助

- [TeamViewer](https://www.teamviewer.com) - 远程协助及在线协作和会议功能的软件，商业软件个人使用免费。【荐】
- [RealVNC](https://www.realvnc.com) 是一款免费的远程控制跨多平台的程序。

### 虚拟机

- [Parallels Desktop](http://www.parallels.com/) - 虽然好用但是收费机制，更新花钱、花钱、花钱。[hot]
- [Virtual Box](http://www.virtualbox.org) - 免费、免费、免费，带NTFS读写，不用买ParagonNTFS，省100块。
- [VMWare Fusion](http://www.vmware.com/) - 强大的虚拟机，商业软件。


## 三、效率办公

### 即时通信 IM

- [Telegram](https://desktop.telegram.org) - 最安全的聊天软件，也可以作为新闻资讯的频道【荐】。推荐链接：<https://cn.tgstat.com/>
- [Discord](https://discord.com/) - 有组织、有结构地讨论；产品细节体验Max；中文支持友好；全平台同步聊天记录；全局搜索功能很好用。比 slack 更酷。【荐】
- [微信](https://mac.weixin.qq.com/)
- [QQ](http://im.qq.com/macqq/index.shtml)
- [WeeChat](https://weechat.org/) - 一个命令行聊天客户端。

### 协同办公

- [飞书](https://www.feishu.cn/) - 先进团队，先用飞书。
- [企业微信](https://work.weixin.qq.com/) - 连接创造价值。
- [钉钉](http://www.dingtalk.com/index-b.html#download_block) - 企业级办公通讯免费平台。

### 远程会议

- [腾讯会议](https://meeting.tencent.com/) -基于腾讯20多年音视频通讯经验，腾讯会议提供一站式音视频会议解决方案，让您能随时随地体验高清流畅的会议以及会议协作。【荐】

- 飞书

- [zoom](https://zoom.us/)

### Email 邮件客户端

> Mac 自带的邮件客户端已经很好用了。

- [Spark](https://sparkmailapp.com/) - 新推出的快速邮件客户端支持Mac和iPhone。【荐】
- [Foxmail](http://www.foxmail.com/mac/) - 快速的邮件客户端。
- [网易邮箱大师](http://mail.163.com/dashi/dlpro.html)。[#](https://www.waerfa.com/neteasemailmaster-for-mac)


### 网盘

- icloud - 苹果自带的 icloud ，管理和同步相册，非常方便。【荐】

- [Dropbox](http://www.dropboxchina.com/Download/dropbox-for-mac.html) - 非常好用的网络文件同步工具，提供在线存储服务。【荐】

- Google Drive - 谷歌推出的网盘。

- Microsoft OneDrive - 微软推出的网盘。

- [坚果云](https://www.jianguoyun.com/s/downloads) - 如果你不想用国外的网盘，那么，坚果云最适合作为私人网盘、同步盘。【荐】

- [百度网盘](http://pan.baidu.com/download?from=header#pan)

- [阿里云盘](https://www.aliyundrive.com/) - 百度网盘的替代品。

- [Mega](https://mega.nz) - 免费的云服务，提供50GB的免费存储空间。

- [腾讯微云](https://www.weiyun.com/)

- [亿方云](https://www.fangcloud.com/) - 硅谷团队打造，个人免费。

- [owncloud](https://owncloud.org) - 私有云网盘。

- [Seafile](https://www.seafile.com/) - 是由国内团队开发的国际化的开源云存储软件项目。

### 思维导图软件

- [XMind](http://www.xmind.net) - 思维导图软件。【荐】
- [MindNode](http://mindnode.com/) - 简洁的风格与人性化的操作，绘制思维脑图。
- iThoughtX - 进阶用户喜欢用它画脑图。[#](https://sspai.com/post/31516)


### 社交

- [WeiboX](http://weiboformac.sinaapp.com/) - 微博第三方Mac应用。

### GTD 时间管理

- [OmniFocus](https://www.omnigroup.com/omnifocus) - 著名 GTD，上手之后秒杀同类。79.99美元。[#](http://www.asianefficiency.com/technology/omnifocus-mac-review/)



### 其他办公软件

- [Slack](https://slack.com/) - 团队协作，沟通工具。
- [Textual](https://www.codeux.com/textual) - 最受欢迎的世界与我们相关的KPI应用 for OS X。
- [Gitter](https://gitter.im) - 关于GitHub的项目交流，支持 Markdown，对开发者极为友好。
- [简聊](https://github.com/jianliaoim/talk-os) - 企业级即时沟通工具，已经下线了，可以自己搭建一套[系统](https://github.com/jianliaoim/talk-os)玩儿。
- [Bitpost](https://voluntary.net/bitpost/) - 私人分散消息，[开源](https://github.com/Voluntarynet/Bitpost)。它是一个p2p的去中心化和无须第三方提供信用担保协议。
- [Coding.net](https://coding.net) - 代码托管，项目管理，WebIDE，演示部署，开启云端开发模式，让开发更简单。



## 四、笔记、阅读、写作

### 笔记软件 & 知识管理

- [Notion](https://www.notion.so/) - 新生代笔记软件。【荐】
- [AppFlowy](https://www.appflowy.io/) - 类似于 Notion 的[开源](https://github.com/AppFlowy-IO/appflowy)版本。
- [flomo](https://flomoapp.com/) - 碎片化记录。重要的不是记录，而是更好地思考。【荐】
- [obsidian](https://obsidian.md/) - 第二大脑。
- [Roam Research](https://roamresearch.com/) - A note-taking tool for networked thought
- [WorkFlowy](https://workflowy.com/downloads/mac/) - 很可能是极简主义者梦想中的笔记应用。
- [为知笔记](http://www.wiz.cn/download.html) - 支持Markdown，搜集整理图片链接导入文档。
- [印象笔记](https://www.yinxiang.com/) - 记录一切。
- [有道云笔记](http://note.youdao.com/) - 支持多目录，Markdown，iWork/Office预览。
- [Quiver](http://happenapps.com/#quiver) - 程序猿的笔记本。
- [leanote](http://app.leanote.com) - 蚂蚁笔记，支持Markdown的一款[开源](https://github.com/leanote/leanote)笔记软件，支持直接成为个人博客。


### 网络文章阅读

- [cubox](https://cubox.pro/) - 一站式信息收集、阅读、管理和回顾；善用网络碎片构建个人知识库。在信息碎片中重获专注。【荐】

### Markdown 编辑器

- [Typora](http://www.typora.io/) - 基于 Electron 的“读写一体” Markdown 编辑器。付费软件。【荐】

- [MarkText](https://marktext.app/) - Typora 的免费替代品。[开源软件](https://github.com/marktext/marktext)。

- [Ulysses](https://ulyssesapp.com/)- 专业文本编辑工具，支持 Markdown。

- [Bear](https://bear.app/)

- [MWeb](http://zh.mweb.im/) - 专业的 Markdown 写作、记笔记、静态博客生成软件。[hot]

- [MacDown](http://macdown.uranusjr.com/) - 一款开源的Markdown编辑器，深受[Mou](http://25.io/mou/)的影响。

- [Mou](http://25.io/mou/) - 免费 Markdown 编辑神器。

- [Marp](https://yhatt.github.io/marp/) -  Markdown 制作幻灯片编辑器。

- [TextNut](http://www.textnutwriter.com/) - Markdown编辑器，富文本之间自由切换。

- [EME](https://github.com/egoist/eme) - 最近刚出的一款Markdown编辑器，界面很像Chrome浏览器的界面，很简约。

- [LightPaper](http://lightpaper.42squares.in/) - 简单的Markdown文本编辑器。

- [Cmd Markdown](https://www.zybuluo.com/) - Cmd Markdown 编辑阅读器，支持实时同步预览，区分写作和阅读模式，支持在线存储，分享文稿网址。

### Markdown 图床工具

工具介绍：可将图片、各种文件上传到配置好的指定提供商的对象存储中，然后快速生成并获取可供互联网访问的文件 URL。链接格式可以是普通 URL、HTML 或者 Markdown 格式（Markdown 格式用得最多），任由你掌控。

工具特点：无论是本地文件、或者屏幕截图都可自动上传，菜单栏显示实时上传进度。上传完成后文件链接自动复制到剪切板，让你无论在写博客时能快速插入图片。

常见工具如下：

- [PicGo](https://molunerfinn.com/PicGo/) - Markdown 图片上传工具。开源免费。【荐】。[#](https://mp.weixin.qq.com/s/ZQtrlULJ5mNTd8jMCb5yEg)

- [Picsee](https://picsee.chitaner.com/) - 图片整理、截图、Markdown 图片上传。

- [iPic](https://toolinbox.net/iPic/) - Markdown 图片上传工具。60元/年。

- [uPic](https://github.com/gee1k/uPic) - 简洁的 Mac 图床客户端。

### 电子书相关

- [Calibre](http://calibre-ebook.com/) - 丑陋的软件，但强大的软件电子书管理、电子书格式转换。[开源](https://github.com/kovidgoyal/calibre) 。【荐】


- [Kindle App](http://www.amazon.com/gp/help/customer/display.html?nodeId=201246110) - 亚马逊 Kindle App 电子书阅读器。

- [Sigil](https://sigil-ebook.com/) - [开源](https://github.com/Sigil-Ebook/Sigil)、多平台EPUB编辑器。【荐】 。EPub 电子书制作教程：[#](https://kindlefere.com/post/73.html) [#](https://kindlefere.com/post/71.html) [#](https://kindlefere.com/post/72.html)

- [Knotes](http://knotesapp.com/cn) - 高效、优雅的读书笔记管理。

### pdf 阅读

- [MarginNote](https://marginnote.com/) - 在阅读时做标注，记笔记，并可以利用思维导图(Mindmap)和大纲工具(Outline)对笔记进行组织。但就是比较贵。【荐】

- PDF Expert - 极致的 PDF 阅读标注工作体验。

- [PDFelement](https://pdf.wondershare.cn/) - 采用类似word界面和工具条设计,无需改变工具操作习惯。国产良心软件。

- iAnnotate - 可以说是所有 PDF 标记类 app 中的No.1了。仅限 iOS 平台使用，没有Mac平台。

### RSS订阅

- [inoreader](https://www.inoreader.com/) - 重新掌控你的新闻订阅源。【荐】
- [NetNewsWire](https://netnewswire.com/) - 开源免费。【荐】
- [Feeds 2](http://www.feedsapp.com/) - 监控任何RSS。
- [Reeder 3](http://reederapp.com/mac/) - RSS 服务订阅。[hot]
- [ReadKit](http://readkitapp.com/) - 书签RSS管理客户端。
- [Leaf](http://www.rockysandstudio.com/) - RSS 客户端程序。[hot]
- [Vienna](http://www.vienna-rss.org/) - [开源](https://github.com/ViennaRSS/vienna-rss)的RSS/Atom 新闻阅读客户端。

### 其他

- [OpenOffice](http://www.openoffice.org/zh-cn/download/index.html) - 是一套[开源](http://openoffice.apache.org/source.html)、跨平台的办公室软件套件。
- [Spillo](https://bananafishsoftware.com/products/spillo/) - 功能强大，美观、快速网络书签网页阅读。
- [iChm](http://www.robinlu.com/ichm) - 读chm文件的软件。
- [Chmox](http://chmox.sourceforge.net/) - 读chm文件的软件。
- [CHM Reader](http://www.hewbo.com/chm-reader.html) - 读chm文件的软件。


## 五、图像处理&设计

### 图片编辑

- Photoshop - 最强大的位图处理软件。【荐】

- [Affinity Photo](https://affinity.serif.com/en-us/photo/) - 光栅图像设计工具，可以替代Adobe PS图象处理软件。【荐】

- [Affinity Designer](https://affinity.serif.com/en-us/designer/) - 矢量图像设计工具，对标 Adobe Illustrator。

- [Pixelmator Pro](https://www.pixelmator.com/pro/) - 强大的图像处理软件，对标 PS。

- [Acorn](https://secure.flyingmeat.com/acorn/) - 一个像PS，全面的功能集的图像编辑器。

### 原型设计、交互设计

- [Sketch](http://www.sketchapp.com/) - 特别适用于用户界面，Web和移动设计。【荐】

- [Figma](https://www.figma.com/) - 新一代原型设计工具。【荐】

- [Axure RP 8](http://www.axure.com) - 画原型图工具。

- [OmniGraffle](https://www.omnigroup.com/omnigraffle) - 可用来绘制图表、流程图、组织结构图、思维导图以及插图或原型。

- [Balsamiq Mockups](https://balsamiq.com/products/mockups/) - 一个快速的网页设计原型工具，帮助你更快、更聪明的工作。


### 图片管理

- [Eagle](https://cn.eagle.cool/) - 图片管理必备工具。30天试用期。

Eagle 可以轻松管理大量图片素材，满足图片素材「收藏、整理、查找」的各种场景，支持 Mac 与 Windows 系统。号称图片管理中的印象笔记。

### PPT模板

- iSlide：<https://www.islide.cc/>

### 3D设计软件

- [Blender](https://www.blender.org/) - 三维图像设计软件。

## 六、视频&音频

### 视频播放器

- [IINA](https://iina.io/) - 目前为止，Mac 上最好用对的视频播放器之一。风格很接近系统原生应用。【荐】

- [VLC](http://www.videolan.org/) - 开源的跨平台多媒体播放器及框架，可播放大多数多媒体文件。[开源](https://github.com/videolan/vlc)。

### 音乐播放器

- [TIDAL](https://offer.tidal.com/) - A streaming service for all music fans.

- [spotify](https://www.spotify.com/) - Spotify is all the music you'll ever need.

### 屏幕录制

- [ScreenFlow](http://www.telestream.net/screenflow/) - 屏幕和视频编辑软件。

- [OBS Studio](https://obsproject.com/zh-cn) - 免费且开源的用于视频录制以及直播串流的软件。

## 七、开发工具

### 版本控制分类

- [Git](https://git-scm.com/) - 版本控制工具，官网顺带推荐了[数十种GUI客户端](https://git-scm.com/download/gui/mac) for Mac。【荐】

Mac电脑上，可以直接安装 [Command Line Tools for Xcode](https://developer.apple.com/download/all/?q=command) 即可，安装完成后 Git 就有了。

- [SVN](http://subversion.apache.org/) - 版本控制工具。

### 版本控制-GUI软件

- [Tower](https://www.git-tower.com/) - 强大的Git客户端。【荐】

安装破解版时，dock 栏看看有没有一个橙色钥匙，那个就是注册机。

- [SourceTree](https://www.sourcetreeapp.com/) - 强大的Git跨平台客户端。【荐】
- [GitKraken](https://www.gitkraken.com/) - 强大的Git客户端。【荐】


- [GitHub Desktop](https://desktop.github.com/) - 使用GitHub的GUI应用。
- [Gitbar](https://github.com/Shikkic/gitbar) - 开源，在你的菜单栏上显示GitHub贡献统计。
- [Oh My Star](http://www.ohmystarapp.com/) - GitHub的star功能弱，比如分类，本地组织你的GitHub star!
- [GitUp](http://gitup.co/) - 一个简单功能强大的git客户端，[开源](https://github.com/git-up/GitUp)。
- [Hub](https://hub.github.com/) - 将GitHub接口和git命令进行包装，[开源](https://github.com/github/hub)。
- [Versions](http://www.versionsapp.com/) - Mac上最好的SVN管理工具。
- [Cornerstone](http://www.zennaware.com/cornerstone/) - Mac上最佳的SVN管理工具。

### 版本控制系统

- [GitHub](https://github.com) GitHub代码托管，项目管理，演示部署，瞧，您现在就访问GitHub。
- [GitLab](http://gitlab.com/) - 一个用于仓库管理系统的开源项目。
- [Coding.net](https://coding.net) - 代码托管，项目管理，WebIDE，演示部署，开启云端开发模式，让开发更简单。
- [phabricator](https://phabricator.com) phabricator支持Git、SVN、HG 基于 PHP + Mysql 的开放源代码软件开发平台。
- [Gogs](https://gogs.io) - 一款极易搭建的自助 Git 服务Golang版本。
- [Gerrit](https://gerrit.rockbox.org) Gerrit 是一个免费、开放源代码的代码审查软件，使用网页界面。
- [Gitblit](http://www.gitblit.com/) Java版本Git代码托管，项目管理。




### 代码编辑器

- [Visual Studio Code](http://code.visualstudio.com) - 微软推出的免费、[开源]((https://github.com/Microsoft/vscode))编辑器，TypeScript支持杠杠的。【荐】

- [Sublime Text](http://www.sublimetext.com/3) - 一个简洁大方带插件管理系统的流行编辑器，可永久免费试用。[Sublime常用插件](editor-plugin.md#sublime-text-plugin)。【荐】

- [TextMate](https://macromates.com/) - 一个强大的21世纪编辑器，能被坚持使用10年以上。[开源](https://github.com/textmate/textmate)免费。【荐】

- [Atom](https://atom.io) - GitHub推出的[开源](https://github.com/atom/atom)编辑器。

- [Vim](http://www.vim.org/) - Vim古老命令行中使用的编辑器。
  - [Vundle.vim](https://github.com/VundleVim/Vundle.vim) - Vim插件管理工具。[开源](https://github.com/VundleVim/Vundle.vim)
  - [vim-plug](https://github.com/junegunn/vim-plug) - 一个简约的vim插件管理器。[开源](https://github.com/junegunn/vim-plug)
  - [WebVim](https://github.com/krampstudio/webvim) - 倾向于开发JavaScript和Web的vim。
  - [vim-web](https://github.com/jaywcjlove/vim-web) - 一个前端开发工程师的vim。[开源](https://github.com/jaywcjlove/vim-web)
  - [Neovim](https://neovim.io/) -  提高Vim可扩张灵活性。[开源](https://github.com/neovim/neovim)
  - [Spacevim](https://github.com/ctjhoa/spacevim) -  模仿Spacemacs的使用方式。
  - [Spf13](http://vim.spf13.com/) - 一套全方位的配置项目。
- [Vimr](http://vimr.org/) - Vim客户端，升级Vim体验。[开源](https://github.com/qvacua/vimr/)

- [IntelliJ IDEA](https://www.jetbrains.com/idea/) - 一款Java开发集成环境。(学生免费)

- [Webstorm](http://www.jetbrains.com/webstorm/) - 是jetbrains公司旗下一款JavaScript开发工具。
  - **学生**免费，[点击这里](https://www.jetbrains.com/student/) 查看更多。
  - 一些很好的插件
    - [NodeJS](https://plugins.jetbrains.com/plugin/6098?pr=webStorm) - 集成`Node.js`，你肯定需要它，很多功能需要它。
    - [EditorConfig](https://plugins.jetbrains.com/plugin/7294?pr=webStorm) - 帮助开发者在不同的编辑器和IDE之间定义和维护一致的代码风格。
    - [Material Theme UI](https://plugins.jetbrains.com/plugin/8006?pr=webStorm) - Google为React开发的主题。


- [Eclipse](https://www.eclipse.org) - 流行的开源IDE，主要用于Java，但为多种语言和平台的插件支持。



### host修改工具


- [SwitchHosts](https://oldj.github.io/SwitchHosts/) - 一个管理、切换多个 hosts 方案的工具。[开源](https://github.com/oldj/SwitchHosts) 。【荐】
- [iHosts](http://toolinbox.net/iHosts/) - 唯一上架 [Mac App Store](https://itunes.apple.com/cn/app/id1102004240) 的 /etc/hosts 编辑神器，使用分组管理 Hosts，灵活组合、一键切换。


### 代码比对

- [Kaleidoscope](https://www.kaleidoscopeapp.com/) - Kaleidoscope 是一款很强大的文件和图像比较工具，支持任何文本文件和 jpeg、tiff、png、psd 等格式的图像文件，同时和 git、svn 等版本控制工具能够完美的结合。【荐】。

- [DiffMerge](http://sourcegear.com/diffmerge/) - 可视化的文件比较（也可进行目录比较）与合并工具。

- [Beyond Compare](http://www.scootersoftware.com/download.php) - 对比两个文件夹或者文件，并将差异以颜色标示。无限期试用。license连接：[#](https://gist.github.com/huqi/35f2a0792aef830898ca)


### 正则编辑器

- [Patterns](http://krillapps.com/patterns/) - 正则表达式编辑器。
- [Reginald](https://github.com/michaeltyson/Reginald) - 正则表达式测试应用程序，使用 [RegexKitLite](http://atastypixel.com/blog/reginald-regex-explorer/)。[开源](https://github.com/michaeltyson/Reginald) 。
- [Regex](http://motionobj.com/regex/?utm_source=RegexApp&utm_medium=app) - 感觉是用过最漂亮的正则表达式测试工具。
- [Reggy](http://reggyapp.com/) - 正则表达式编辑器。[开源](https://github.com/samsouder/reggy)。
- [RegExRX](http://www.mactechnologies.com/index.php?page=downloads#regexrx) - 正则表达式的开发工具。


### 数据库

- [Navicat Premium](https://www.navicat.com/en/products/navicat-premium) - 一款连接多种类型数据库进行管理的工具，比如同时连接到MySQL，Oracle，SQL Server，SQLite和PostgreSQL数据库。【荐】


### 测试工具

- [Charles](https://www.charlesproxy.com/) - 一个代理工具，允许你查看所有的HTTP和HTTPS流量。
- [Postman](https://www.getpostman.com) - Postman 帮助我们快速测试API。【荐】


### 命令行工具/终端/SSH 远程连接

- [iTerm2](http://www.iterm2.com) - 免费的终端工具，直接替代自带的Terminal，有非常多惊人的特性。[开源](https://github.com/gnachman/iTerm2) 。[#](https://github.com/sirius1024/iterm2-with-oh-my-zsh)【荐】

搭配 [wd 插件](https://16bh.github.io/2016/07/12/oh-my-zsh-plugin-wd/)食用，效果更加，可快速 cd 到指定目录。

- [SecureCRT](https://www.vandyke.com/products/securecrt/) - 一款支持SSH、Telnet等多种协议的终端仿真程序。【荐】

- [Royal TSX](https://royalapps.com/ts/mac) - 全平台终端软件。[#](https://guozh.net/macos-shell-royal-tsx-item2-ssh-ftp/)。【荐】

- [termius](https://termius.com/) - Mac 最好用的SSH连接客户端。

- [Oh my zsh](http://ohmyz.sh) - 拥有大量的有用的功能，助手，插件，主题，等特性的命令行工具插件。[开源](https://github.com/robbyrussell/oh-my-zsh)。【荐】

- [oh-my-fish](https://github.com/oh-my-fish/oh-my-fish) - 和**Oh my zsh**相似，建立在Fish Shell框架上。

### FTP客户端

-  [FileZilla](https://filezilla-project.org) - 跨平台的FTP，FTPS和SFTP客户端。【荐】

-  [Transmit](https://panic.com/transmit/) - 一个FTP客户端，支持FTP + SFTP + S3【荐】。

- [Flow](http://fivedetails.com/flow/) - 支持简单的 FTP + SFTP 客户端。

- [Yummy FTP](http://www.yummysoftware.com) - 专业快速，可靠的FTP客户端。

- [Cyberduck](https://cyberduck.io) - 免费FTP，SFTP，S3和WebDAV客户端 & OpenStack Swift Client。


## 八、网站推荐

> 这里主要是推荐一些软件下载的网站，还有一些MacOS软件分享网站。


### 盗版Mac软件下载网站黑名单

> 拒绝盗版从我做起，下面的网站提供大量破解软件下载，欢迎大家监督它们。


- Mac精品软件：<http://xclient.info/>【荐】

只收录精品Mac应用。

- https://appstorrent.ru/

- MacWk：<https://macwk.com/>

下载前，会有注意事项的提醒。该网站已停止维护。

- 潘多拉盒子：<https://www.inpandora.com/>

- 公众号「Mac软件管家」

下载 PS、Office等大型软件。也可翻看公众号的历史文章，或者回复关键词。

- 马可菠萝：<https://www.macbl.com/>

- mac毒：<https://www.macdu.org/>


- AppKed：<http://www.macbed.com>

- Macx：<http://www.macx.cn/>

### Mac工具介绍

- 少数派：[http://sspai.com/tag/Mac](http://sspai.com/tag/Mac)
- Mac玩儿法：[http://www.waerfa.com](http://www.waerfa.com)

- [OurMacs](https://ourmacs.com) - 优秀的mac应用。


#### GitHub项目

- [jaywcjlove/awesome-mac](https://github.com/jaywcjlove/awesome-mac/blob/master/README-zh.md)


**[⬆ 返回顶部](#目录)**







