/**
 * ***************************************************************************
 * Copyright (c) 2010 Qcadoo Limited
 * Project: Qcadoo MES
 * Version: 1.4
 *
 * This file is part of Qcadoo.
 *
 * Qcadoo is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation; either version 3 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * ***************************************************************************
 */
package com.qcadoo.mes.technologies.constants;

public final class TechnologyOperationComponentFields {

    private TechnologyOperationComponentFields() {

    }

    public static final String TECHNOLOGY = "technology";

    public static final String OPERATION = "operation";

    public static final String PARENT = "parent";

    public static final String CHILDREN = "children";

    public static final String ENTITY_TYPE = "entityType";

    public static final String PRIORITY = "priority";

    public static final String REFERENCE_TECHNOLOGY = "referenceTechnology";

    public static final String NODE_NUMBER = "nodeNumber";

    public static final String COMMENT = "comment";

    public static final String ATTACHMENT = "attachment";

    public static final String ARE_PRODUCT_QUANTITIES_DIVISIBLE = "areProductQuantitiesDivisible";

    public static final String IS_TJ_DIVISIBLE = "isTjDivisible";

    public static final String OPERATION_PRODUCT_IN_COMPONENTS = "operationProductInComponents";

    public static final String OPERATION_PRODUCT_OUT_COMPONENTS = "operationProductOutComponents";

    public static final String WORKSTATIONS = "workstations";

    public static final String WORKSTATION_TYPE = "workstationType";

    public static final String ASSIGNED_TO_OPERATION = "assignedToOperation";

    public static final String QUANTITY_OF_WORKSTATIONS = "quantityOfWorkstations";

    public static final String DIVISION = "division";

    public static final String TYPE_FROM_STRUCTURE_TREE = "typeFromStructureTree";

    public static final String PRODUCT_FROM_STRUCTURE_TREE = "productFromStructureTree";

    public static final String TECHNOLOGICAL_PROCESS_LIST = "technologicalProcessList";

    public static final String TECHNOLOGICAL_PROCESS_LIST_ASSIGNMENT_DATE = "technologicalProcessListAssignmentDate";

    public static final String SHOW_IN_PRODUCT_DATA = "showInProductData";

    public static final String PRODUCT_DATA_NUMBER = "productDataNumber";

    public static final String PRODUCT_DATA_OPERATIONS = "productDataOperations";

}
