/**
 * ***************************************************************************
 * Copyright (c) 2010 Qcadoo Limited
 * Project: Qcadoo MES
 * Version: 1.4
 *
 * This file is part of Qcadoo.
 *
 * Qcadoo is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation; either version 3 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * ***************************************************************************
 */
package com.qcadoo.mes.technologies.constants;

public final class TechnologiesConstants {

    public static final String MODEL_TECHNOLOGY_PRODUCTION_LINE = "technologyProductionLine";

    private TechnologiesConstants() {
    }

    public static final String PLUGIN_IDENTIFIER = "technologies";

    // MODEL

    public static final String MODEL_OPERATION = "operation";

    public static final String MODEL_OPERATION_PRODUCT_IN_COMPONENT = "operationProductInComponent";

    public static final String MODEL_OPERATION_PRODUCT_IN_COMPONENT_DTO = "operationProductInComponentDto";

    public static final String MODEL_OPERATION_PRODUCT_OUT_COMPONENT = "operationProductOutComponent";

    public static final String MODEL_TECHNOLOGY = "technology";

    public static final String MODEL_TECHNOLOGY_OPERATION_COMPONENT = "technologyOperationComponent";

    public static final String MODEL_OPERATION_NUMBER_FIELD_NAME = "number";

    public static final String MODEL_TECHNOLOGY_STATE_CHANGE = "technologyStateChange";

    public static final String MODEL_TECHNOLOGY_GROUP = "technologyGroup";

    public static final String MODEL_TECHNOLOGY_ATTACHMENT = "technologyAttachment";

    public static final String MODEL_BARCODE_OPERATION_COMPONENT = "barcodeOperationComponent";

    public static final String MODEL_PRODUCT_STRUCTURE_TREE_NODE = "productStructureTreeNode";

    public static final String OPERATION_COMPONENTS = "operationComponents";

    public static final String OPERATION_SKILL = "operationSkill";

    public static final String MODIFY_TECHNOLOGY_HELPER = "modifyTechnologyHelper";

    public static final String MODEL_PRODUCT_TO_PRODUCT_GROUP_TECHNOLOGY = "productToProductGroupTechnology";

    public static final String MODEL_TECHNOLOGICAL_PROCESS = "technologicalProcess";

    public static final String MODEL_TECHNOLOGICAL_PROCESS_COMPONENT = "technologicalProcessComponent";

    public static final String MODEL_TECHNOLOGICAL_PROCESS_LIST = "technologicalProcessList";

    public static final String MODEL_TECHNOLOGY_INPUT_PRODUCT_TYPE = "technologyInputProductType";

    public static final String MODEL_PRODUCT_BY_SIZE_GROUP = "productBySizeGroup";

    public static final String MODEL_PRODUCT_DATA = "productData";

    public static final String MODEL_PRODUCT_DATA_ATTACHMENT = "productDataAttachment";

    public static final String MODEL_PRODUCT_DATA_INPUT = "productDataInput";

    public static final String MODEL_PRODUCT_DATA_OPERATION = "productDataOperation";

    public static final String MODEL_WORKSTATION_CHANGEOVER_NORM = "workstationChangeoverNorm";

    public static final String MODEL_WORKSTATION_CHANGEOVER_NORM_DTO = "workstationChangeoverNormDto";

    public static final String MODEL_WORKSTATION_STATE_CHANGE = "workstationStateChange";

    public static final String MODEL_DIMENSION_CONTROL_ATTRIBUTE = "dimensionControlAttribute";

    // VIEW

    public static final String VIEW_OPERATION_DETAILS = "operationDetails";

    public static final String VIEW_OPERATION_PRODUCT_IN_COMPONENT_DETAILS = "operationProductInComponentDetails";

    public static final String VIEW_OPERATION_PRODUCT_OUT_COMPONENT_DETAILS = "operationProductOutComponentDetails";

    public static final String VIEW_OPERATIONS_LIST = "operationsList";

    public static final String VIEW_TECHNOLOGIES_LIST = "technologiesList";

    public static final String VIEW_TECHNOLOGY_DETAILS = "technologyDetails";

    public static final String VIEW_TECHNOLOGY_OPERATION_COMPONENT_DETAILS = "technologyOperationComponentDetails";

    public static final String UPLOAD_INPUT_ID = "productDataIdForMultiUpload";

    public static final String UPLOAD_INPUT_LOCALE = "productDataMultiUploadLocale";

}
