/**
 * ***************************************************************************
 * Copyright (c) 2010 Qcadoo Limited
 * Project: Qcadoo MES
 * Version: 1.4
 *
 * This file is part of Qcadoo.
 *
 * Qcadoo is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation; either version 3 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * ***************************************************************************
 */
package com.qcadoo.mes.productionCounting.constants;

public final class ProductionTrackingFields {

    private ProductionTrackingFields() {

    }

    public static final String NUMBER = "number";

    public static final String ORDER = "order";

    public static final String TECHNOLOGY_OPERATION_COMPONENT = "technologyOperationComponent";

    public static final String SHIFT = "shift";

    public static final String SHIFT_START_DAY = "shiftStartDay";

    public static final String TIME_RANGE_FROM = "timeRangeFrom";

    public static final String TIME_RANGE_TO = "timeRangeTo";

    public static final String LAST_STATE_CHANGE_FAILS = "lastStateChangeFails";

    public static final String LAST_STATE_CHANGE_FAIL_CAUSE = "lastStateChangeFailCause";

    public static final String IS_EXTERNAL_SYNCHRONIZED = "isExternalSynchronized";

    public static final String STATE = "state";

    public static final String TRACKING_OPERATION_PRODUCT_IN_COMPONENTS = "trackingOperationProductInComponents";

    public static final String TRACKING_OPERATION_PRODUCT_OUT_COMPONENTS = "trackingOperationProductOutComponents";

    public static final String LAST_TRACKING = "lastTracking";

    public static final String MACHINE_TIME = "machineTime";

    public static final String LABOR_TIME = "laborTime";

    public static final String STAFF = "staff";

    public static final String STAFF_WORK_TIMES = "staffWorkTimes";

    public static final String WORKSTATION = "workstation";

    public static final String DIVISION = "division";

    public static final String CORRECTION = "correction";

    public static final String IS_CORRECTION = "isCorrection";

    public static final String IS_CORRECTED = "isCorrected";

    public static final String UNDERGOING_CORRECTION = "undergoingCorrection";

    public static final String STATE_CHANGES = "stateChanges";

    public static final String BATCH = "batch";

    public static final String BATCH_NUMBER = "batchNumber";

    public static final String ADD_BATCH = "addBatch";

    public static final String EXPIRATION_DATE = "expirationDate";

    public static final String STOPPAGES = "stoppages";

    public static final String PIECEWORK_PRODUCTION = "pieceworkProduction";

    public static final String COMMENTS = "comments";

    public static final String ON_UNCORRECTION_PROCESS = "onUnCorrectionProcess";

}
