/**
 * ***************************************************************************
 * Copyright (c) 2010 Qcadoo Limited
 * Project: Qcadoo MES
 * Version: 1.4
 * <p>
 * This file is part of Qcadoo.
 * <p>
 * Qcadoo is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation; either version 3 of the License,
 * or (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * <p>
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * ***************************************************************************
 */
package com.qcadoo.mes.productionCounting.constants;

public final class OrderBalanceFields {

    private OrderBalanceFields() {

    }

    public static final String PRODUCTION_BALANCE = "productionBalance";

    public static final String ORDER_NUMBER = "orderNumber";

    public static final String PRODUCT_NUMBER = "productNumber";

    public static final String PRODUCT_NAME = "productName";

    public static final String PLANNED_QUANTITY = "plannedQuantity";

    public static final String PRODUCED_QUANTITY = "producedQuantity";

    public static final String DEVIATION = "deviation";

    public static final String PRODUCT_UNIT = "productUnit";

    public static final String PLANNED_MATERIAL_COSTS = "plannedMaterialCosts";

    public static final String MATERIAL_COSTS = "materialCosts";

    public static final String MATERIAL_COSTS_DEVIATION = "materialCostsDeviation";

    public static final String PLANNED_PRODUCTION_COSTS = "plannedProductionCosts";

    public static final String PRODUCTION_COSTS = "productionCosts";

    public static final String PRODUCTION_COSTS_DEVIATION = "productionCostsDeviation";

    public static final String TECHNICAL_PRODUCTION_COSTS = "technicalProductionCosts";

    public static final String MATERIAL_COST_MARGIN = "materialCostMargin";

    public static final String MATERIAL_COST_MARGIN_VALUE = "materialCostMarginValue";

    public static final String PRODUCTION_COST_MARGIN = "productionCostMargin";

    public static final String PRODUCTION_COST_MARGIN_VALUE = "productionCostMarginValue";

    public static final String ADDITIONAL_OVERHEAD = "additionalOverhead";

    public static final String DIRECT_ADDITIONAL_COST = "directAdditionalCost";

    public static final String EXTERNAL_SERVICES_COST = "externalServicesCost";

    public static final String TOTAL_COSTS = "totalCosts";

    public static final String REGISTRATION_PRICE = "registrationPrice";

    public static final String REGISTRATION_PRICE_OVERHEAD = "registrationPriceOverhead";

    public static final String REGISTRATION_PRICE_OVERHEAD_VALUE = "registrationPriceOverheadValue";

    public static final String REAL_PRODUCTION_COSTS = "realProductionCosts";

    public static final String TECHNICAL_PRODUCTION_COST_OVERHEAD = "technicalProductionCostOverhead";

    public static final String TECHNICAL_PRODUCTION_COST_OVERHEAD_VALUE = "technicalProductionCostOverheadValue";

    public static final String TOTAL_MANUFACTURING_COST = "totalManufacturingCost";

    public static final String PROFIT = "profit";

    public static final String PROFIT_VALUE = "profitValue";

    public static final String SELL_PRICE = "sellPrice";

}
