/**
 * ***************************************************************************
 * Copyright (c) 2010 Qcadoo Limited
 * Project: Qcadoo MES
 * Version: 1.4
 *
 * This file is part of Qcadoo.
 *
 * Qcadoo is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation; either version 3 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * ***************************************************************************
 */
package com.qcadoo.mes.orders.constants;

public final class OrderFields {

    private OrderFields() {

    }

    public static final String NUMBER = "number";

    public static final String NAME = "name";

    public static final String DESCRIPTION = "description";

    public static final String DEFAULT_TECHNOLOGY = "defaultTechnology";

    public static final String COMMENT_REASON_TYPE_CORRECTION_DATE_FROM = "commentReasonTypeCorrectionDateFrom";

    public static final String COMMENT_REASON_TYPE_CORRECTION_DATE_TO = "commentReasonTypeCorrectionDateTo";

    public static final String COMMENT_REASON_DEVIATION_EFFECTIVE_START = "commentReasonDeviationEffectiveStart";

    public static final String COMMENT_REASON_DEVIATION_EFFECTIVE_END = "commentReasonDeviationEffectiveEnd";

    public static final String EXTERNAL_NUMBER = "externalNumber";

    public static final String COMMENT_REASON_TYPE_DEVIATIONS_QUANTITY = "commentReasonTypeDeviationsQuantity";

    public static final String DATE_FROM = "dateFrom";

    public static final String DATE_TO = "dateTo";

    public static final String EFFECTIVE_DATE_FROM = "effectiveDateFrom";

    public static final String EFFECTIVE_DATE_TO = "effectiveDateTo";

    public static final String DEADLINE = "deadline";

    public static final String CORRECTED_DATE_FROM = "correctedDateFrom";

    public static final String CORRECTED_DATE_TO = "correctedDateTo";

    public static final String START_DATE = "startDate";

    public static final String FINISH_DATE = "finishDate";

    public static final String STATE = "state";

    public static final String COMPANY = "company";

    public static final String PRODUCT = "product";

    public static final String TECHNOLOGY = "technology";

    public static final String PRODUCTION_LINE = "productionLine";

    public static final String PLANNED_QUANTITY = "plannedQuantity";

    public static final String PLANNED_QUANTITY_FOR_ADDITIONAL_UNIT = "plannedQuantityForAdditionalUnit";

    public static final String DONE_QUANTITY = "doneQuantity";

    public static final String REPORTED_PRODUCTION_QUANTITY = "reportedProductionQuantity";

    public static final String EXTERNAL_SYNCHRONIZED = "externalSynchronized";

    public static final String STATE_CHANGES = "stateChanges";

    public static final String COMMISSIONED_PLANNED_QUANTITY = "commissionedPlannedQuantity";

    public static final String COMMISSIONED_CORRECTED_QUANTITY = "commissionedCorrectedQuantity";

    public static final String AMOUNT_OF_PRODUCT_PRODUCED = "amountOfProductProduced";

    public static final String WASTES_QUANTITY = "wastesQuantity";

    public static final String REMAINING_AMOUNT_OF_PRODUCT_TO_PRODUCE = "remainingAmountOfProductToProduce";

    public static final String TYPE_OF_CORRECTION_CAUSES = "typeOfCorrectionCauses";

    public static final String REASON_TYPES_CORRECTION_DATE_FROM = "reasonTypesCorrectionDateFrom";

    public static final String REASON_TYPES_CORRECTION_DATE_TO = "reasonTypesCorrectionDateTo";

    public static final String REASON_TYPES_DEVIATIONS_OF_EFFECTIVE_START = "reasonTypesDeviationsOfEffectiveStart";

    public static final String REASON_TYPES_DEVIATIONS_OF_EFFECTIVE_END = "reasonTypesDeviationsOfEffectiveEnd";

    public static final String DATES_CHANGED = "datesChanged";

    public static final String SOURCE_CORRECTED_DATE_FROM = "sourceCorrectedDateFrom";

    public static final String SOURCE_CORRECTED_DATE_TO = "sourceCorrectedDateTo";

    public static final String SOURCE_START_DATE = "sourceStartDate";

    public static final String SOURCE_FINISH_DATE = "sourceFinishDate";

    public static final String WORKER_TO_CHANGE = "workerToChange";

    public static final String ORDER_CATEGORY = "orderCategory";

    public static final String ADDRESS = "address";

    public static final String FINAL_PRODUCTION_TRACKING = "finalProductionTracking";

    public static final String GENERATE_PPS = "generatePPS";

    public static final String BARCODE_OPERATION_COMPONENTS = "barcodeOperationComponents";

    public static final String SCHEDULES = "schedules";

    public static final String SCHEDULE_POSITIONS = "schedulePositions";

    public static final String DIVISION = "division";

    public static final String OPERATIONAL_TASKS = "operationalTasks";

    public static final String TECHNOLOGY_OPERATION_COMPONENTS_MERGE_PRODUCT_IN = "technologyOperationComponentsMergeProductIn";

    public static final String TECHNOLOGY_OPERATION_COMPONENTS_MERGE_PRODUCT_OUT = "technologyOperationComponentsMergeProductOut";

    public static final String UNIT_FOR_ADDITIONAL_UNIT = "unitForAdditionalUnit";

    public static final String ACTIVE = "active";

    public static final String ORDER_PACKS = "orderPacks";

    public static final String ORDER_TECHNOLOGICAL_PROCESSES = "orderTechnologicalProcesses";

    public static final String ORDER_TECHNOLOGICAL_PROCESSES_DTO = "orderTechnologicalProcessesDto";

    public static final String ORDER_TECHNOLOGICAL_PROCESS_WASTES = "orderTechnologicalProcessWastes";

    public static final String NEW_VERSION_TECHNOLOGY_SET = "newVersionTechnologySet";

    public static final String STAFF = "staff";

    public static final String EXPIRATION_DATE = "expirationDate";

    public static final String ADDITIONAL_FINAL_PRODUCTS = "additionalFinalProducts";

    public static final String PRIORITY = "priority";

    public static final String VENDOR_INFO = "vendorInfo";
}
