/**
 * ***************************************************************************
 * Copyright (c) 2010 Qcadoo Limited
 * Project: Qcadoo MES
 * Version: 1.4
 *
 * This file is part of Qcadoo.
 *
 * Qcadoo is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation; either version 3 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * ***************************************************************************
 */
package com.qcadoo.mes.orders.constants;

public final class OperationalTaskFields {

    private OperationalTaskFields() {

    }

    public static final String NUMBER = "number";

    public static final String NAME = "name";

    public static final String DESCRIPTION = "description";

    public static final String TYPE = "type";

    public static final String START_DATE = "startDate";

    public static final String FINISH_DATE = "finishDate";

    public static final String STAFF = "staff";

    public static final String DIVISION = "division";

    public static final String WORKSTATION = "workstation";

    public static final String ORDER = "order";

    public static final String TECHNOLOGY = "technology";

    public static final String TECHNOLOGY_OPERATION_COMPONENT = "technologyOperationComponent";

    public static final String PRODUCT = "product";

    public static final String PLANNED_QUANTITY = "plannedQuantity";

    public static final String USED_QUANTITY = "usedQuantity";

    public static final String SCHEDULE_POSITION = "schedulePosition";

    public static final String STATE = "state";

    public static final String ACTUAL_STAFF = "actualStaff";

    public static final String WORKERS = "workers";

    public static final String SHOULD_SKIP = "shouldSkip";

    public static final String HAS_CHANGEOVERS = "hasChangeovers";

    public static final String CURRENT_WORKSTATION_CHANGEOVER_FOR_OPERATIONAL_TASKS = "currentWorkstationChangeoverForOperationalTasks";

    public static final String PREVIOUS_WORKSTATION_CHANGEOVER_FOR_OPERATIONAL_TASKS = "previousWorkstationChangeoverForOperationalTasks";

    public static final String PREVIOUS_WORKSTATION_CHANGEOVER_FOR_SCHEDULE_POSITIONS = "previousWorkstationChangeoverForSchedulePositions";

}
