--
-- PostgreSQL database dump
--

-- Dumped from database version 14.6
-- Dumped by pg_dump version 14.6

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: add_archived_column(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.add_archived_column() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
    arch_table RECORD;
BEGIN
    FOR arch_table IN SELECT * FROM information_schema.tables AS t
                      WHERE t.table_schema = 'public' AND t.table_type = 'BASE TABLE'
                        AND t.table_name LIKE 'arc2_%'
                      ORDER BY t.table_name
        LOOP
            EXECUTE 'ALTER TABLE '|| arch_table.table_name ||' ADD COLUMN archived boolean';
            EXECUTE 'ALTER TABLE '|| arch_table.table_name ||' ALTER COLUMN archived SET DEFAULT FALSE';
        END LOOP;
END;
$$;


--
-- Name: add_group(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.add_group(group_identifier character varying, name character varying, description character varying, permissiontype character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
    DECLARE
        relationcount bigint;

    BEGIN

        SELECT count(*) INTO relationcount FROM qcadoosecurity_group WHERE identifier = group_identifier;

        IF relationcount = 0 THEN
            INSERT INTO qcadoosecurity_group (identifier, name, description, permissiontype) VALUES (group_identifier, name, description, permissiontype);
        END IF;

   END;
$$;


--
-- Name: add_group_role(character varying, character varying); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.add_group_role(group_identifier character varying, role_identifier character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
    DECLARE
        groupid bigint;
        roleid bigint;
        relationcount bigint;

    BEGIN

        SELECT id INTO groupid FROM qcadoosecurity_group WHERE identifier = group_identifier;

        IF groupid is null THEN
            RAISE EXCEPTION 'Group(%s) not found', group_identifier;
        END IF;

        SELECT id INTO roleid FROM qcadoosecurity_role WHERE identifier = role_identifier;

        IF roleid is null THEN
            RAISE EXCEPTION 'Role(%) not found', role_identifier;
        END IF;

        SELECT count(*) INTO relationcount FROM jointable_group_role WHERE group_id = groupid AND role_id = roleid;

        IF relationcount = 0 THEN
            INSERT INTO jointable_group_role (group_id, role_id) VALUES (groupid, roleid);
        END IF;

    END;
$$;


--
-- Name: add_group_role_by_id(bigint, character varying); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.add_group_role_by_id(groupid bigint, role_identifier character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
    DECLARE
        roleid bigint;
        relationcount bigint;

    BEGIN

        IF groupid is null THEN
            RAISE EXCEPTION 'Group(%s) not found', groupid;
        END IF;

        SELECT id INTO roleid FROM qcadoosecurity_role WHERE identifier = role_identifier;

        IF roleid is null THEN
            RAISE EXCEPTION 'Role(%) not found', role_identifier;
        END IF;

        SELECT count(*) INTO relationcount FROM jointable_group_role WHERE group_id = groupid AND role_id = roleid;

        IF relationcount = 0 THEN
            INSERT INTO jointable_group_role (group_id, role_id) VALUES (groupid, roleid);
        END IF;

    END;
$$;


--
-- Name: add_group_with_role_role(character varying, character varying); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.add_group_with_role_role(with_role_identifier character varying, role_identifier character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
    DECLARE
        withroleid bigint;
        roleid bigint;
        groupwithrole RECORD;

    BEGIN
        SELECT id INTO withroleid FROM qcadoosecurity_role WHERE identifier = with_role_identifier;

        IF withroleid IS NULL THEN
            RAISE EXCEPTION 'Role(%) not found', with_role_identifier;
        END IF;

        SELECT id INTO roleid FROM qcadoosecurity_role WHERE identifier = role_identifier;

        IF roleid IS NULL THEN
            RAISE EXCEPTION 'Role(%) not found', role_identifier;
        END IF;

        FOR groupwithrole IN SELECT * FROM jointable_group_role WHERE role_id = withroleid LOOP
            IF NOT EXISTS (SELECT group_id FROM jointable_group_role WHERE group_id = groupwithrole.group_id AND role_id = roleid) THEN
                INSERT INTO jointable_group_role (group_id, role_id) VALUES (groupwithrole.group_id, roleid);
            END IF;
        END LOOP;
    END;
$$;


--
-- Name: add_role(character varying, character varying); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.add_role(role_identifier character varying, description character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
    DECLARE
    relationcount bigint;

    BEGIN

        SELECT count(*) INTO relationcount FROM qcadoosecurity_role WHERE identifier = role_identifier;

        IF relationcount = 0 THEN
            INSERT INTO qcadoosecurity_role (identifier, description) VALUES (role_identifier, description);
        END IF;

    END;
$$;


--
-- Name: add_sequences(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.add_sequences() RETURNS void
    LANGUAGE plpgsql
    AS $$
    DECLARE
        row record;

    BEGIN
        FOR row IN SELECT tablename FROM pg_tables p
            INNER JOIN information_schema.columns c ON p.tablename = c.table_name
            WHERE c.table_schema = 'public' AND p.schemaname = 'public' AND c.column_name = 'id' AND data_type = 'bigint'
        LOOP
            IF NOT EXISTS (SELECT 0 FROM pg_class WHERE relname = substring('' || quote_ident(row.tablename) || '_id_seq' FROM 0 FOR 64)) THEN
                EXECUTE 'CREATE SEQUENCE ' || quote_ident(row.tablename) || '_id_seq;';
                EXECUTE 'ALTER TABLE ' || quote_ident(row.tablename) || ' ALTER COLUMN id SET DEFAULT nextval(''' || quote_ident(row.tablename) || '_id_seq'');';
                EXECUTE 'ALTER SEQUENCE ' || quote_ident(row.tablename) || '_id_seq OWNED BY ' || quote_ident(row.tablename) || '.id';
                EXECUTE 'WITH mx AS (SELECT max(id)+1 AS mx FROM ' || quote_ident(row.tablename) || ') SELECT setval( ''' || quote_ident(row.tablename) || '_id_seq'' , mx.mx) FROM mx';
            END IF;
        END LOOP;

        FOR row IN SELECT viewname FROM pg_views p
            INNER JOIN information_schema.columns c ON p.viewname = c.table_name
            WHERE c.table_schema = 'public' AND p.schemaname = 'public' AND c.column_name = 'id' AND data_type = 'bigint'
        LOOP
            IF NOT EXISTS (SELECT 0 FROM pg_class WHERE relname = substring('' || quote_ident(row.viewname) || '_id_seq' FROM 0 FOR 64)) THEN
                EXECUTE 'CREATE SEQUENCE ' || quote_ident(row.viewname) || '_id_seq;';
            END IF;
        END LOOP;
    END;
$$;


--
-- Name: add_view_item(character varying, character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.add_view_item(plugin_identifier character varying, item_name character varying, view_name character varying, category_name character varying, auth_role character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
    DECLARE
        viewid bigint;
        categoryid bigint;
        relationcount bigint;

    BEGIN

        SELECT id INTO viewid FROM qcadooview_view WHERE name = view_name;

        IF viewid IS NULL THEN
            RAISE EXCEPTION 'View(%s) not found', view_name;
        END IF;

        SELECT id INTO categoryid FROM qcadooview_category WHERE name = category_name;

        IF categoryid IS NULL THEN
            RAISE EXCEPTION 'Category(%) not found', category_name;
        END IF;

        SELECT count(*) INTO relationcount FROM qcadooview_item WHERE name = item_name;

        IF relationcount = 0 THEN
            INSERT INTO qcadooview_item (pluginidentifier, name, active, category_id, view_id, succession, authrole, entityversion)
            VALUES (plugin_identifier, item_name, true,
                 (SELECT id FROM qcadooview_category WHERE name = category_name),
                 (SELECT id FROM qcadooview_view WHERE name = view_name),
                 (SELECT COALESCE(MAX(succession), 0)
                  FROM qcadooview_item
                  WHERE category_id = (SELECT id FROM qcadooview_category WHERE name = category_name)) + 1, auth_role, 0);
        END IF;

    END;
$$;


--
-- Name: add_view_view(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.add_view_view(plugin_identifier character varying, view_name character varying, view_view character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
    DECLARE
        relationcount bigint;

    BEGIN

        SELECT count(*) INTO relationcount FROM qcadooview_view WHERE name = view_name;

        IF relationcount = 0 THEN
            INSERT INTO qcadooview_view (pluginidentifier, name, view, entityversion)
                VALUES (plugin_identifier, view_name, view_view, 0);
        END IF;

    END;
$$;


--
-- Name: archive(integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.archive(_rows integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
	BEGIN
		RAISE NOTICE 'Start - archive';
		EXECUTE 'SELECT archive_data('||_rows||');';
		EXECUTE 'SELECT remove_archived_data();';
		EXECUTE 'SELECT mark_as_archived();';
		RAISE NOTICE 'End - archive';

	END;
$$;


--
-- Name: archive_connected_orders(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.archive_connected_orders() RETURNS void
    LANGUAGE plpgsql
    AS $$
	DECLARE
		_arch_order RECORD;
		_order RECORD;
	BEGIN
		FOR _arch_order IN SELECT * FROM arch_orders_order _archo WHERE parent_id is not null AND NOT EXISTS
			(SELECT 1 FROM arch_orders_order _archop WHERE _archo.parent_id = _archop.id )
		LOOP
			FOR _order IN SELECT * FROM orders_order ord  WHERE ord.id = _arch_order.parent_id
			LOOP
				INSERT INTO arch_orders_order SELECT * FROM orders_order WHERE id = _order.id;
			END LOOP;
		END LOOP;
	END;
$$;


--
-- Name: archive_connected_tables_all(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.archive_connected_tables_all() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
    _masterOrder RECORD;
    _goodfoodLabel RECORD;
    _statesMessage RECORD;
    _goodfoodPallet RECORD;
    _printLabelsHelper RECORD;
    _order RECORD;
    _orderstatechange RECORD;
    _ordertimecalculation RECORD;
    _productionpershift RECORD;
    _progressforday RECORD;
    _productiontracking RECORD;
    _anomaly RECORD;
    _labelstatechange RECORD;
    _palletstatechange RECORD;
    _productiontrackingstatechange RECORD;
    _trackingoperationproductincomponent RECORD;
    _trackingoperationproductoutcomponent RECORD;
    _repairorder RECORD;
    _anomalyproductiontrackingentryhelper RECORD;
    _extrusionprotocol RECORD;
    _extrusionprotocolstatechange RECORD;
    _extrusionaddedmixentry RECORD;
    _extrusionpouring RECORD;
    _extrusiontakenoffmixentry RECORD;
    _confectionprotocol RECORD;
    _confectionfilmproduct RECORD;
    _confectionprotocolstatechange RECORD;
    _costcalculation RECORD;
    _bproductioncountingquantity RECORD;
    _basicproductioncounting RECORD;
    _avglaborcostcalcfororder RECORD;
    _atrackingrecord RECORD;
    _document_position RECORD;
    _document RECORD;
BEGIN
    SET session_replication_role = 'replica';

    FOR _masterOrder IN SELECT * FROM arch_masterorders_masterorder where archived = false
        LOOP
            -- masterorders_masterorder
            INSERT INTO arch_assignmenttoshift_multiassignmenttoshift SELECT * FROM assignmenttoshift_multiassignmenttoshift WHERE masterorder_id = _masterOrder.id;
            INSERT INTO arch_assignmenttoshift_staffassignmenttoshift SELECT * FROM assignmenttoshift_staffassignmenttoshift WHERE masterorder_id = _masterOrder.id;
            INSERT INTO arch_goodfood_label SELECT * FROM goodfood_label WHERE masterorder_id = _masterOrder.id;
            INSERT INTO arch_goodfood_printedlabel SELECT * FROM goodfood_printedlabel WHERE masterorder_id = _masterOrder.id;
            INSERT INTO arch_integrationbartender_printlabelshelper SELECT * FROM integrationbartender_printlabelshelper WHERE masterorder_id = _masterOrder.id;
            INSERT INTO arch_masterorders_masterorderproduct SELECT * FROM masterorders_masterorderproduct WHERE masterorder_id = _masterOrder.id;
            -- goodfood_label
            FOR _goodfoodLabel IN SELECT * FROM arch_goodfood_label WHERE archived = false
                LOOP
                    INSERT INTO arch_goodfood_labelstatechange SELECT * FROM goodfood_labelstatechange WHERE label_id = _goodfoodLabel.id;

                    INSERT INTO arch_goodfood_pallet SELECT * FROM goodfood_pallet WHERE label_id = _goodfoodLabel.id ORDER BY secondpallet_id DESC;
                    FOR _goodfoodPallet IN SELECT * FROM arch_goodfood_pallet
                        LOOP
                            INSERT INTO arch_goodfood_palletstatechange SELECT * FROM goodfood_palletstatechange WHERE pallet_id = _goodfoodPallet.id;
                        END LOOP;
                END LOOP;
            FOR _labelstatechange IN SELECT * FROM arch_goodfood_labelstatechange WHERE archived = false
                LOOP
                    INSERT INTO arch_states_message SELECT * FROM states_message WHERE labelstatechange_id = _labelstatechange.id;
                END LOOP;
            FOR _palletstatechange IN SELECT * FROM arch_goodfood_palletstatechange WHERE archived = false
                LOOP
                    INSERT INTO arch_states_message SELECT * FROM states_message WHERE palletstatechange_id = _palletstatechange.id;
                END LOOP;
            -- arch_integrationbartender_printlabelshelper
            FOR _printLabelsHelper IN SELECT * FROM arch_integrationbartender_printlabelshelper WHERE archived = false
                LOOP
                    INSERT INTO arch_integrationbartender_sendtoprint SELECT * FROM integrationbartender_sendtoprint WHERE printlabelshelper_id = _printLabelsHelper.id;
                END LOOP;
        END LOOP;
    -- arch_orders_order
    FOR _order IN SELECT * FROM arch_orders_order WHERE archived = false
        LOOP
            --RAISE NOTICE 'Order : %' , _order.number;

            INSERT INTO arch_orders_orderstatechange SELECT * FROM orders_orderstatechange WHERE order_id = _order.id;
            INSERT INTO arch_orders_reasontypecorrectiondatefrom SELECT * FROM orders_reasontypecorrectiondatefrom WHERE order_id = _order.id;
            INSERT INTO arch_orders_reasontypecorrectiondateto SELECT * FROM orders_reasontypecorrectiondateto WHERE order_id = _order.id;
            INSERT INTO arch_orders_reasontypedeviationeffectiveend SELECT * FROM orders_reasontypedeviationeffectiveend WHERE order_id = _order.id;
            INSERT INTO arch_orders_reasontypedeviationeffectivestart SELECT * FROM orders_reasontypedeviationeffectivestart WHERE order_id = _order.id;
            INSERT INTO arch_orders_typeofcorrectioncauses SELECT * FROM orders_typeofcorrectioncauses WHERE order_id = _order.id;
            INSERT INTO arch_technologies_barcodeoperationcomponent SELECT * FROM technologies_barcodeoperationcomponent WHERE order_id = _order.id;
            INSERT INTO arch_technologies_technologyoperationcomponentmergeproductin SELECT * FROM technologies_technologyoperationcomponentmergeproductin WHERE order_id = _order.id;
            INSERT INTO arch_technologies_technologyoperationcomponentmergeproductout SELECT * FROM technologies_technologyoperationcomponentmergeproductout WHERE order_id = _order.id;
            INSERT INTO arch_stoppage_stoppage SELECT * FROM stoppage_stoppage WHERE order_id = _order.id;
            INSERT INTO arch_urcmaterialavailability_requiredcomponent SELECT * FROM urcmaterialavailability_requiredcomponent WHERE order_id = _order.id;
            INSERT INTO arch_simplematerialbalance_simplematerialbalanceorderscomponent SELECT * FROM simplematerialbalance_simplematerialbalanceorderscomponent WHERE order_id = _order.id;
            INSERT INTO arch_productionscheduling_ordertimecalculation SELECT * FROM productionscheduling_ordertimecalculation WHERE order_id = _order.id;
            INSERT INTO arch_productionpershift_productionpershift SELECT * FROM productionpershift_productionpershift WHERE order_id = _order.id;
            INSERT INTO arch_productioncounting_productiontracking SELECT * FROM productioncounting_productiontracking WHERE order_id = _order.id;
            INSERT INTO arch_productflowthrudivision_materialavailability SELECT * FROM productflowthrudivision_materialavailability WHERE order_id = _order.id;
            INSERT INTO arch_orders_operationaltask SELECT * FROM orders_operationaltask WHERE order_id = _order.id;
            INSERT INTO arch_goodfood_extrusionprotocol SELECT * FROM goodfood_extrusionprotocol WHERE order_id = _order.id;
            INSERT INTO arch_goodfood_confectionprotocol SELECT * FROM goodfood_confectionprotocol WHERE order_id = _order.id;
            INSERT INTO arch_costnormsformaterials_technologyinstoperproductincomp SELECT * FROM costnormsformaterials_technologyinstoperproductincomp WHERE order_id = _order.id;
            INSERT INTO arch_costcalculation_costcalculation SELECT * FROM costcalculation_costcalculation WHERE order_id = _order.id;
            INSERT INTO arch_basicproductioncounting_basicproductioncounting SELECT * FROM basicproductioncounting_basicproductioncounting WHERE order_id = _order.id;
            INSERT INTO arch_basicproductioncounting_productioncountingquantity SELECT * FROM basicproductioncounting_productioncountingquantity WHERE order_id = _order.id;
            INSERT INTO arch_basicproductioncounting_productioncountingoperationrun SELECT * FROM basicproductioncounting_productioncountingoperationrun WHERE order_id = _order.id;
            INSERT INTO arch_avglaborcostcalcfororder_avglaborcostcalcfororder SELECT * FROM avglaborcostcalcfororder_avglaborcostcalcfororder  WHERE order_id = _order.id;
            INSERT INTO arch_advancedgenealogy_trackingrecord SELECT * FROM advancedgenealogy_trackingrecord  WHERE order_id = _order.id;
            INSERT INTO arch_materialflowresources_document SELECT * FROM materialflowresources_document WHERE order_id = _order.id;
        END LOOP;
    --RAISE NOTICE '--------->	arch_orders_orderstatechange';

    -- arch_orders_orderstatechange
    FOR _orderstatechange IN SELECT * FROM arch_orders_orderstatechange WHERE archived = false
        LOOP
            INSERT INTO arch_states_message SELECT * FROM states_message WHERE orderstatechange_id = _orderstatechange.id;
            INSERT INTO arch_orders_reasontypeofchangingorderstate SELECT * FROM orders_reasontypeofchangingorderstate WHERE orderstatechange_id = _orderstatechange.id;
        END LOOP;
    --RAISE NOTICE '--------->	arch_productionscheduling_ordertimecalculation';

    -- arch_productionscheduling_ordertimecalculation
    FOR _ordertimecalculation IN SELECT * FROM arch_productionscheduling_ordertimecalculation WHERE archived = false
        LOOP
            INSERT INTO arch_productionscheduling_opercomptimecalculation SELECT * FROM productionscheduling_opercomptimecalculation WHERE ordertimecalculation_id = _ordertimecalculation.id;
        END LOOP;
    --RAISE NOTICE '--------->	arch_productionpershift_productionpershift';

    -- arch_productionpershift_productionpershift
    FOR _productionpershift IN SELECT * FROM arch_productionpershift_productionpershift WHERE archived = false
        LOOP
            INSERT INTO arch_productionpershift_progressforday SELECT * FROM productionpershift_progressforday WHERE productionpershift_id = _productionpershift.id;
            INSERT INTO arch_productionpershift_reasontypeofcorrectionplan SELECT * FROM productionpershift_reasontypeofcorrectionplan WHERE productionpershift_id = _productionpershift.id;
        END LOOP;
    --RAISE NOTICE '--------->	arch_productionpershift_progressforday';

    -- arch_productionpershift_progressforday
    FOR _progressforday IN SELECT * FROM arch_productionpershift_progressforday WHERE archived = false
        LOOP
            INSERT INTO arch_productionpershift_dailyprogress SELECT * FROM productionpershift_dailyprogress WHERE progressforday_id = _progressforday.id;
        END LOOP;
    --RAISE NOTICE '--------->	arch_productioncounting_productiontracking';

    -- arch_productioncounting_productiontracking
    FOR _productiontracking IN SELECT * FROM arch_productioncounting_productiontracking WHERE archived = false
        LOOP
            INSERT INTO arch_productioncounting_anomaly SELECT * FROM productioncounting_anomaly WHERE productiontracking_id = _productiontracking.id;
            INSERT INTO arch_productioncounting_productiontrackingstatechange SELECT * FROM productioncounting_productiontrackingstatechange WHERE productiontracking_id = _productiontracking.id;
            INSERT INTO arch_productioncounting_staffworktime SELECT * FROM productioncounting_staffworktime WHERE productionrecord_id = _productiontracking.id;
            INSERT INTO arch_productioncounting_trackingoperationproductincomponent SELECT * FROM productioncounting_trackingoperationproductincomponent WHERE productiontracking_id = _productiontracking.id;
            INSERT INTO arch_productioncounting_trackingoperationproductoutcomponent SELECT * FROM productioncounting_trackingoperationproductoutcomponent WHERE productiontracking_id = _productiontracking.id;
            INSERT INTO arch_repairs_repairorder SELECT * FROM repairs_repairorder WHERE productiontracking_id = _productiontracking.id;

        END LOOP;
    FOR _productiontrackingstatechange IN SELECT * FROM arch_productioncounting_productiontrackingstatechange WHERE archived = false
        LOOP
            INSERT INTO arch_states_message SELECT * FROM states_message WHERE productiontrackingstatechange_id = _productiontrackingstatechange.id;
        END LOOP;
    -- arch_productioncounting_anomaly
    FOR _anomaly IN SELECT * FROM arch_productioncounting_anomaly WHERE archived = false
        LOOP
            INSERT INTO arch_productioncounting_anomalyexplanation SELECT * FROM productioncounting_anomalyexplanation WHERE anomaly_id = _anomaly.id;
        END LOOP;
    -- arch_productioncounting_trackingoperationproductincomponent
    FOR _trackingoperationproductincomponent IN SELECT * FROM arch_productioncounting_trackingoperationproductincomponent WHERE archived = false
        LOOP
            INSERT INTO arch_productioncounting_anomalyproductiontrackingentryhelper SELECT * FROM productioncounting_anomalyproductiontrackingentryhelper WHERE trackingoperationproductincomponent_id = _trackingoperationproductincomponent.id;
            INSERT INTO arch_productioncounting_settechnologyincomponents SELECT * FROM productioncounting_settechnologyincomponents WHERE trackingoperationproductincomponent_id = _trackingoperationproductincomponent.id;
            INSERT INTO arch_repairs_repairorderproduct SELECT * FROM repairs_repairorderproduct WHERE trackingoperationproductincomponent_id = _trackingoperationproductincomponent.id;
        END LOOP;
    -- arch_productioncounting_trackingoperationproductoutcomponent
    FOR _trackingoperationproductoutcomponent IN SELECT * FROM arch_productioncounting_trackingoperationproductoutcomponent  WHERE archived = false
        LOOP
            INSERT INTO arch_productioncounting_settrackingoperationproductincomponents SELECT * FROM productioncounting_settrackingoperationproductincomponents WHERE trackingoperationproductoutcomponent_id = _trackingoperationproductoutcomponent.id;
        END LOOP;
    -- arch_repairs_repairorder
    FOR _repairorder IN SELECT * FROM arch_repairs_repairorder  WHERE archived = false
        LOOP
            INSERT INTO arch_repairs_repairorderstatechange SELECT * FROM repairs_repairorderstatechange WHERE repairorder_id = _repairorder.id;
            INSERT INTO arch_repairs_repairorderworktime SELECT * FROM repairs_repairorderworktime WHERE repairorder_id = _repairorder.id;
        END LOOP;
    -- arch_productioncounting_anomalyproductiontrackingentryhelper
    FOR _anomalyproductiontrackingentryhelper IN SELECT * FROM arch_productioncounting_anomalyproductiontrackingentryhelper WHERE archived = false
        LOOP
            INSERT INTO arch_productioncounting_anomalyreasoncontainer SELECT * FROM productioncounting_anomalyreasoncontainer WHERE anomalyproductiontrackingentryhelper_id = _anomalyproductiontrackingentryhelper.id;
        END LOOP;
    -- arch_goodfood_extrusionprotocol
    FOR _extrusionprotocol IN SELECT * FROM arch_goodfood_extrusionprotocol WHERE archived = false
        LOOP
            INSERT INTO arch_goodfood_extrusionaddedmixentry SELECT * FROM goodfood_extrusionaddedmixentry WHERE extrusionprotocol_id = _extrusionprotocol.id;
            INSERT INTO arch_goodfood_extrusionpouring SELECT * FROM goodfood_extrusionpouring WHERE extrusionprotocol_id = _extrusionprotocol.id;
            INSERT INTO arch_goodfood_extrusionprotocolcorrect SELECT * FROM goodfood_extrusionprotocolcorrect WHERE extrusionprotocol_id = _extrusionprotocol.id;
            INSERT INTO arch_goodfood_extrusionprotocolstatechange SELECT * FROM goodfood_extrusionprotocolstatechange WHERE extrusionprotocol_id = _extrusionprotocol.id;
            INSERT INTO arch_goodfood_extrusionsouse SELECT * FROM goodfood_extrusionsouse WHERE extrusionprotocol_id = _extrusionprotocol.id;
            INSERT INTO arch_goodfood_extrusiontakenoffmixentry SELECT * FROM goodfood_extrusiontakenoffmixentry WHERE extrusionprotocol_id = _extrusionprotocol.id;

        END LOOP;
    -- arch_goodfood_extrusionprotocolstatechange
    FOR _extrusionprotocolstatechange IN SELECT * FROM arch_goodfood_extrusionprotocolstatechange WHERE archived = false
        LOOP
            INSERT INTO arch_states_message SELECT * FROM states_message WHERE extrusionprotocolstatechange_id = _extrusionprotocolstatechange.id;
        END LOOP;
    -- arch_goodfood_extrusionaddedmixentry
    FOR _extrusionaddedmixentry IN SELECT * FROM arch_goodfood_extrusionaddedmixentry WHERE archived = false
        LOOP
            INSERT INTO arch_goodfood_extrusionaddedmixingredient SELECT * FROM goodfood_extrusionaddedmixingredient WHERE extrusionaddedmixentry_id = _extrusionaddedmixentry.id;
        END LOOP;
    -- arch_goodfood_extrusionpouring
    FOR _extrusionpouring IN SELECT * FROM arch_goodfood_extrusionpouring  WHERE archived = false
        LOOP
            INSERT INTO arch_goodfood_extrusionpouringingredient SELECT * FROM goodfood_extrusionpouringingredient WHERE extrusionpouring_id = _extrusionpouring.id;
            INSERT INTO arch_goodfood_extrusionpouringmix SELECT * FROM goodfood_extrusionpouringmix WHERE extrusionpouring_id = _extrusionpouring.id;
        END LOOP;
    -- arch_goodfood_extrusiontakenoffmixentry
    FOR _extrusiontakenoffmixentry IN SELECT * FROM arch_goodfood_extrusiontakenoffmixentry WHERE archived = false
        LOOP
            INSERT INTO arch_goodfood_extrusiontakenoffmixingredient SELECT * FROM goodfood_extrusiontakenoffmixingredient WHERE extrusiontakenoffmixentry_id = _extrusiontakenoffmixentry.id;
        END LOOP;
    -- arch_goodfood_confectionprotocol
    FOR _confectionprotocol IN SELECT * FROM arch_goodfood_confectionprotocol WHERE archived = false
        LOOP
            INSERT INTO arch_goodfood_confectionadditionalinputproduct SELECT * FROM goodfood_confectionadditionalinputproduct WHERE confectionprotocol_id = _confectionprotocol.id;
            INSERT INTO arch_goodfood_confectionfilmproduct SELECT * FROM goodfood_confectionfilmproduct WHERE confectionprotocol_id = _confectionprotocol.id;
            INSERT INTO arch_goodfood_confectioninputproduct SELECT * FROM goodfood_confectioninputproduct WHERE confectionprotocol_id = _confectionprotocol.id;
            INSERT INTO arch_goodfood_confectionprotocolcorrect SELECT * FROM goodfood_confectionprotocolcorrect WHERE confectionprotocol_id = _confectionprotocol.id;
            INSERT INTO arch_goodfood_confectionprotocolstatechange SELECT * FROM goodfood_confectionprotocolstatechange WHERE confectionprotocol_id = _confectionprotocol.id;
            INSERT INTO arch_goodfood_confectionremainderinputproduct SELECT * FROM goodfood_confectionremainderinputproduct WHERE confectionprotocol_id = _confectionprotocol.id;
            INSERT INTO arch_goodfood_confectionstaff SELECT * FROM goodfood_confectionstaff WHERE confectionprotocol_id = _confectionprotocol.id;
        END LOOP;
    -- arch_goodfood_confectionfilmproduct
    FOR _confectionfilmproduct IN SELECT * FROM arch_goodfood_confectionfilmproduct WHERE archived = false
        LOOP
            INSERT INTO arch_goodfood_confectionfilmproductentry SELECT * FROM goodfood_confectionfilmproductentry WHERE confectionfilmproduct_id = _confectionfilmproduct.id;
        END LOOP;
    -- arch_goodfood_confectionprotocolstatechange
    FOR _confectionprotocolstatechange  IN SELECT * FROM arch_goodfood_confectionprotocolstatechange WHERE archived = false
        LOOP
            INSERT INTO arch_states_message SELECT * FROM states_message WHERE confectionprotocolstatechange_id = _confectionprotocolstatechange.id;
        END LOOP;
    -- arch_costcalculation_costcalculation
    FOR _costcalculation IN SELECT * FROM arch_costcalculation_costcalculation WHERE archived = false
        LOOP
            INSERT INTO arch_costcalculation_componentcost SELECT * FROM costcalculation_componentcost WHERE costcalculation_id = _costcalculation.id;
            INSERT INTO arch_costnormsforoperation_calculationoperationcomponent SELECT * FROM costnormsforoperation_calculationoperationcomponent WHERE costcalculation_id = _costcalculation.id;
        END LOOP;
    -- arch_basicproductioncounting_productioncountingquantity
    FOR _bproductioncountingquantity IN SELECT * FROM arch_basicproductioncounting_productioncountingquantity WHERE archived = false
        LOOP
            INSERT INTO arch_productioncounting_productioncountingquantitysetcomponent SELECT * FROM productioncounting_productioncountingquantitysetcomponent WHERE productioncountingquantity_id = _bproductioncountingquantity.id;
        END LOOP;
    -- arch_avglaborcostcalcfororder_avglaborcostcalcfororder
    FOR _avglaborcostcalcfororder IN SELECT * FROM arch_avglaborcostcalcfororder_avglaborcostcalcfororder WHERE archived = false
        LOOP
            INSERT INTO arch_avglaborcostcalcfororder_assignmentworkertoshift SELECT * FROM avglaborcostcalcfororder_assignmentworkertoshift WHERE avglaborcostcalcfororder_id = _avglaborcostcalcfororder.id;
        END LOOP;
    -- arch_advancedgenealogy_trackingrecord
    FOR _atrackingrecord IN SELECT * FROM arch_advancedgenealogy_trackingrecord WHERE archived = false
        LOOP
            INSERT INTO arch_advancedgenealogy_trackingrecord SELECT * FROM advancedgenealogy_trackingrecord WHERE trackingrecord_id = _atrackingrecord.id;
            INSERT INTO arch_advancedgenealogy_usedbatchsimple SELECT * FROM advancedgenealogy_usedbatchsimple WHERE trackingrecord_id = _atrackingrecord.id;
            INSERT INTO arch_advancedgenealogyfororders_genealogyproductincomponent SELECT * FROM advancedgenealogyfororders_genealogyproductincomponent WHERE trackingrecord_id = _atrackingrecord.id;

        END LOOP;
    FOR _document IN SELECT * FROM arch_materialflowresources_document WHERE archived = false
        LOOP
            INSERT INTO arch_esilco_importpositionerror SELECT * FROM esilco_importpositionerror WHERE document_id = _document.id;
            INSERT INTO arch_materialflowresources_position SELECT * FROM materialflowresources_position WHERE document_id = _document.id;
            INSERT INTO arch_productflowthrudivision_issue SELECT * FROM productflowthrudivision_issue WHERE document_id = _document.id;
            INSERT INTO arch_productflowthrudivision_producttoissuecorrection SELECT * FROM productflowthrudivision_producttoissuecorrection WHERE accountwithreservation_id = _document.id;
        END LOOP;
    FOR _document_position IN SELECT * FROM arch_materialflowresources_position WHERE archived = false
        LOOP
            INSERT INTO arch_materialflowresources_reservation SELECT * FROM materialflowresources_reservation WHERE position_id = _document_position.id;
        END LOOP;

    SET session_replication_role = 'origin';

END;
$$;


--
-- Name: archive_data(integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.archive_data(_rows integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
	DECLARE
		_order RECORD;
		_orderGroup RECORD;
		_masterOrder RECORD;
	BEGIN
		SET session_replication_role = 'replica';
		FOR _masterOrder IN SELECT * FROM masterorders_masterorder WHERE state = '03completed' ORDER BY createdate LIMIT _rows
		LOOP
			INSERT INTO arch_masterorders_masterorder SELECT * FROM masterorders_masterorder WHERE id = _masterOrder.id;
			FOR _orderGroup IN SELECT * FROM ordersgroups_ordersgroup og  WHERE masterorder_id = _masterOrder.id ORDER BY og.parent_id DESC
			LOOP
				INSERT INTO arch_ordersgroups_ordersgroup SELECT * FROM ordersgroups_ordersgroup WHERE id = _orderGroup.id;
				FOR _order IN SELECT * FROM orders_order ord  WHERE ord.ordersgroup_id = _orderGroup.id ORDER BY ord.parent_id DESC
				LOOP
					INSERT INTO arch_orders_order SELECT * FROM orders_order WHERE id = _order.id;
				END LOOP;
			END LOOP;
		END LOOP;
		EXECUTE 'SELECT archive_connected_orders();';
		EXECUTE 'SELECT archive_connected_tables_all();';
		SET session_replication_role = 'origin';

	END;
$$;


--
-- Name: drop_old_tables(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.drop_old_tables() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
    arch_table RECORD;

BEGIN
    FOR arch_table IN SELECT * FROM information_schema.tables AS t
                      WHERE t.table_schema = 'public' AND t.table_type = 'BASE TABLE'
                        AND t.table_name LIKE 'arch_%'
                      ORDER BY t.table_name
        LOOP

            EXECUTE 'DROP TABLE ' || arch_table.table_name;

        END LOOP;
END;
$$;


--
-- Name: drop_unused_sequences(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.drop_unused_sequences() RETURNS void
    LANGUAGE plpgsql
    AS $$
    DECLARE
        row record;
        _yymm text;

    BEGIN
        _yymm := to_char(current_timestamp - interval '6 month', 'YYMM');
        FOR row IN SELECT sequence_name FROM information_schema.sequences where sequence_schema = 'public'
            and sequence_name LIKE 'masterorders_master_order_number_%'
        LOOP
            IF substring(row.sequence_name FROM '[0-9]+') < _yymm THEN
                EXECUTE 'DROP SEQUENCE ' || quote_ident(row.sequence_name) || ';';
            END IF;
        END LOOP;

    END;
$$;


--
-- Name: duration_to_string(integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.duration_to_string(duration integer) RETURNS text
    LANGUAGE plpgsql
    AS $$
    DECLARE
        _duration text;
        _minus boolean;
		hours integer;
		minutes integer;
		seconds integer;

    BEGIN
        IF (duration IS NULL) THEN
            _duration := '';
        ELSE
            IF (duration < 0) THEN
                _minus := TRUE;

                duration := -duration;
            END IF;

			hours := duration / 3600;
            minutes := duration % 3600 / 60;
            seconds := duration % 3600 % 60;

			IF (_minus IS TRUE) THEN
				_duration := '-';
			ELSE
				_duration := '';
			END IF;

			IF (hours < 10) THEN
				_duration := _duration || '0' || hours || ':';
			ELSE
				_duration := _duration || hours || ':';
			END IF;

			IF (minutes < 10) THEN
				_duration := _duration || '0' || minutes || ':';
			ELSE
				_duration := _duration || minutes || ':';
			END IF;

			IF (seconds < 10) THEN
				_duration := _duration || '0' || seconds;
			ELSE
				_duration := _duration || seconds;
			END IF;
        END IF;

        RETURN _duration;
    END;
$$;


--
-- Name: f_add_col(regclass, text, regtype); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.f_add_col(_tbl regclass, _col text, _type regtype) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
DECLARE
    arch_table_name text;
BEGIN
    IF EXISTS (SELECT 1 FROM pg_attribute
               WHERE attrelid = _tbl
                 AND attname = lower(_col)
                 AND NOT attisdropped) THEN
        RETURN FALSE;
    ELSE

        EXECUTE format('ALTER TABLE %s ADD COLUMN %I %s', _tbl, lower(_col), _type);

        arch_table_name := 'arch_' || _tbl;
        IF EXISTS (SELECT 1 FROM pg_tables WHERE tablename = arch_table_name) THEN

            EXECUTE format('ALTER TABLE %s ADD COLUMN %I %s', arch_table_name, lower(_col), _type);

            EXECUTE format('ALTER TABLE %s DROP COLUMN IF EXISTS %I CASCADE', arch_table_name, 'archived');

            EXECUTE format('ALTER TABLE %s ADD COLUMN archived boolean DEFAULT false', arch_table_name);

            EXECUTE format('UPDATE %s SET %I = true', arch_table_name, 'archived');
        END IF;

        RETURN TRUE;
    END IF;
END
$$;


--
-- Name: f_add_col(regclass, text, text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.f_add_col(_tbl regclass, _col text, _type text) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
DECLARE
    arch_table_name text;
BEGIN
    IF EXISTS (SELECT 1 FROM pg_attribute
               WHERE attrelid = _tbl
                 AND attname = lower(_col)
                 AND NOT attisdropped) THEN
        RETURN FALSE;
    ELSE
        EXECUTE format('ALTER TABLE %s ADD COLUMN %I %s', _tbl, lower(_col), _type);

        arch_table_name := 'arch_' || _tbl;
        IF EXISTS (SELECT 1 FROM pg_tables WHERE tablename = arch_table_name) THEN

            EXECUTE format('ALTER TABLE %s ADD COLUMN %I %s', arch_table_name, lower(_col), _type);

            EXECUTE format('ALTER TABLE %s DROP COLUMN IF EXISTS %I CASCADE', arch_table_name, 'archived');

            EXECUTE format('ALTER TABLE %s ADD COLUMN archived boolean DEFAULT false', arch_table_name);

            EXECUTE format('UPDATE %s SET %I = true', arch_table_name, 'archived');
        END IF;

        RETURN TRUE;
    END IF;
END
$$;


--
-- Name: f_add_col_default(regclass, text, text, text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.f_add_col_default(_tbl regclass, _col text, _type text, _default text) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
DECLARE
    arch_table_name text;
BEGIN
    IF EXISTS (SELECT 1 FROM pg_attribute
               WHERE  attrelid = _tbl
                 AND    attname = lower(_col)
                 AND    NOT attisdropped) THEN
        RETURN FALSE;
    ELSE
        EXECUTE format('ALTER TABLE %s ADD COLUMN %I %s DEFAULT %s', _tbl, lower(_col), _type, _default);

        arch_table_name := 'arch_' || _tbl;
        IF EXISTS (SELECT 1 FROM pg_tables WHERE tablename = arch_table_name) THEN

            EXECUTE format('ALTER TABLE %s ADD COLUMN %I %s DEFAULT %s', arch_table_name, lower(_col), _type, _default);

            EXECUTE format('ALTER TABLE %s DROP COLUMN IF EXISTS %I CASCADE', arch_table_name, 'archived');

            EXECUTE format('ALTER TABLE %s ADD COLUMN archived boolean DEFAULT false', arch_table_name);

            EXECUTE format('UPDATE %s SET %I = true', arch_table_name, 'archived');
        END IF;

        RETURN TRUE;
    END IF;
END
$$;


--
-- Name: f_add_con(regclass, text, text, regclass); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.f_add_con(_tbl regclass, _conname text, _colname text, _reltbl regclass) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
    BEGIN
        IF EXISTS (SELECT 1 FROM pg_constraint
              WHERE conname = _conname) THEN

              RETURN FALSE;
        ELSE
            EXECUTE format('ALTER TABLE %s ADD CONSTRAINT %I FOREIGN KEY (%s) REFERENCES %s (id) DEFERRABLE', _tbl, lower(_conname), _colname, _reltbl);

            RETURN TRUE;
        END IF;
    END
$$;


--
-- Name: f_drop_col(regclass, text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.f_drop_col(_tbl regclass, _col text) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
DECLARE
    arch_table_name text;
BEGIN
    EXECUTE format('ALTER TABLE %s DROP COLUMN IF EXISTS %I', _tbl, lower(_col));
    arch_table_name := 'arch_' || _tbl;
    IF EXISTS (SELECT 1 FROM pg_tables WHERE tablename = arch_table_name) THEN
        EXECUTE format('ALTER TABLE %s DROP COLUMN IF EXISTS %I', arch_table_name, lower(_col));
    END IF;

    RETURN TRUE;
END
$$;


--
-- Name: f_drop_tab(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.f_drop_tab(_tabname text) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
    BEGIN
        EXECUTE format('DROP TABLE IF EXISTS %s', _tabname);

        RETURN TRUE;
    END
$$;


--
-- Name: f_rename_col(regclass, text, text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.f_rename_col(_tbl regclass, _colname text, _colnewname text) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF EXISTS (SELECT 1 FROM pg_attribute
        WHERE attrelid = _tbl
            AND attname = lower(_colnewname)
            AND NOT attisdropped) THEN
      RETURN FALSE;
   ELSE
      EXECUTE format('ALTER TABLE %s RENAME COLUMN %s TO %s', _tbl, lower(_colname), lower(_colnewname));

      RETURN TRUE;
   END IF;
END
$$;


--
-- Name: f_rename_tab(text, text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.f_rename_tab(_tabname text, _tabnewname text) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
    BEGIN
        EXECUTE format('ALTER TABLE IF EXISTS %s RENAME TO %s', _tabname, lower(_tabnewname));

        RETURN TRUE;
    END
$$;


--
-- Name: fill_waste_flag_in_technologies(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.fill_waste_flag_in_technologies() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
_opoc RECORD;

BEGIN
FOR _opoc IN
SELECT opoc.id, opoc.productsinputlocation_id, opoc.productsflowlocation_id
FROM technologies_operationproductoutcomponent opoc
         LEFT JOIN basic_product pr ON pr.id = opoc.product_id
         LEFT JOIN technologies_technologyoperationcomponent toc ON toc.id = opoc.operationcomponent_id
         LEFT JOIN technologies_technologyoperationcomponent parent ON parent.id = toc.parent_id
WHERE toc.parent_id is not null AND (select count(1) from technologies_operationproductincomponent _opic
									 WHERE _opic.operationcomponent_id = toc.parent_id AND _opic.product_id = opoc.product_id) = 0
    LOOP
UPDATE technologies_operationproductoutcomponent
set waste = true, wastereceptionwarehouse_id = COALESCE(_opoc.productsinputlocation_id, _opoc.productsflowlocation_id),
    productsinputlocation_id = null, productsflowlocation_id = null
WHERE id = _opoc.id;
END LOOP;
END;
$$;


--
-- Name: fill_waste_flag_in_technologies_root(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.fill_waste_flag_in_technologies_root() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
_opoc RECORD;

BEGIN
FOR _opoc IN
SELECT opoc.id, opoc.productsinputlocation_id, opoc.productsflowlocation_id
FROM technologies_operationproductoutcomponent opoc
         LEFT JOIN technologies_technologyoperationcomponent toc ON toc.id = opoc.operationcomponent_id
         LEFT JOIN technologies_technology technology ON technology.id = toc.technology_id
WHERE toc.parent_id is null AND opoc.product_id <> technology.product_id
    LOOP
UPDATE technologies_operationproductoutcomponent
set waste = true, wastereceptionwarehouse_id = COALESCE(_opoc.productsinputlocation_id, _opoc.productsflowlocation_id),
    productsinputlocation_id = null, productsflowlocation_id = null
WHERE id = _opoc.id;
END LOOP;
END;
$$;


--
-- Name: generate_and_set_assignmenttoshift_externalnumber_trigger(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_and_set_assignmenttoshift_externalnumber_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	NEW.externalnumber := generate_assignmenttoshift_externalnumber();

	return NEW;
END;
$$;


--
-- Name: generate_and_set_confectionprotocol_externalnumber_trigger(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_and_set_confectionprotocol_externalnumber_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	NEW.externalnumber := generate_confectionprotocol_externalnumber();

	return NEW;
END;
$$;


--
-- Name: generate_and_set_document_number_trigger(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_and_set_document_number_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	NEW.number := generate_document_number(NEW.number);
	IF NEW.name is null THEN
		NEW.name := NEW.number;
	END IF;

	return NEW;
END;
$$;


--
-- Name: generate_and_set_extrusionprotocol_externalnumber_trigger(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_and_set_extrusionprotocol_externalnumber_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	NEW.externalnumber := generate_extrusionprotocol_externalnumber();

	return NEW;
END;
$$;


--
-- Name: generate_and_set_maintenanceevent_number_trigger(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_and_set_maintenanceevent_number_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	NEW.number := generate_maintenanceevent_number();

	return NEW;
END;
$$;


--
-- Name: generate_and_set_operational_task_number_trigger(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_and_set_operational_task_number_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	NEW.number := generate_operational_task_number();
	IF NEW.name is null THEN
		NEW.name := NEW.number;
END IF;

return NEW;
END;
$$;


--
-- Name: generate_and_set_pallet_externalnumber_trigger(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_and_set_pallet_externalnumber_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	NEW.externalnumber := generate_pallet_externalnumber();

	return NEW;
END;
$$;


--
-- Name: generate_and_set_repairorder_number_trigger(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_and_set_repairorder_number_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	NEW.number := generate_repairorder_number();

	return NEW;
END;
$$;


--
-- Name: generate_and_set_resource_number(timestamp without time zone); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_and_set_resource_number(_time timestamp without time zone) RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
	_pattern text;
	_year numeric;
	_sequence_name text;
	_sequence_value numeric;
	_tmp text;
	_seq text;
	_number text;
BEGIN
	_pattern := '#year/#seq';
	_year := extract(year from _time);

	_sequence_name := 'materialflowresources_resource_number_' || _year;

	SELECT sequence_name into _tmp FROM information_schema.sequences where sequence_schema = 'public'
		and sequence_name = _sequence_name;
	if _tmp is null then
		execute 'CREATE SEQUENCE ' || _sequence_name || ';';
	end if;

	select nextval(_sequence_name) into _sequence_value;

	_seq := to_char(_sequence_value, 'fm00000');
	if _seq like '%#%' then
		_seq := _sequence_value;
	end if;

	_number := _pattern;
	_number := replace(_number, '#year', _year::text);
	_number := replace(_number, '#seq', _seq);

	RETURN _number;
END;
$$;


--
-- Name: generate_and_set_resource_number_trigger(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_and_set_resource_number_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	NEW.number := generate_and_set_resource_number(NEW.time);

	return NEW;
END;
$$;


--
-- Name: generate_arch_tables(text, text, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_arch_tables(from_table text, parent_table text, depth integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
	DECLARE
		table_data RECORD;
		table_references RECORD;
		table_count INTEGER;
		tablearch text;

	BEGIN
		RAISE NOTICE '';
		tablearch = CONCAT('arch_',from_table);
		RAISE NOTICE '-- Generate table: % \ parent %', tablearch,parent_table;
		IF NOT EXISTS (
			SELECT 1 FROM information_schema.tables WHERE table_name = tablearch
		) THEN
			 IF from_table != parent_table AND left(from_table, 5) != 'arch_' AND left(parent_table, 5) != 'arch_' AND depth < 10 THEN
				depth = depth + 1;
				EXECUTE 'CREATE TABLE IF NOT EXISTS ' || tablearch || ' ( like ' || from_table || ' INCLUDING DEFAULTS INCLUDING CONSTRAINTS INCLUDING INDEXES );';

				FOR table_data IN SELECT * FROM list_tablereferences(from_table)
					LOOP
						EXECUTE 'SELECT * FROM generate_arch_tables('''|| table_data.table_name||''', ''' || from_table ||''' , ' || depth ||' );';
					END LOOP;
			END IF;

		ELSE
			RAISE NOTICE '-- TABELA ISTNIEJSE : %', tablearch;
		END IF;
	END;
$$;


--
-- Name: generate_assignmenttoshift_externalnumber(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_assignmenttoshift_externalnumber() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
	_pattern text;
	_sequence_name text;
	_sequence_value numeric;
	_tmp text;
	_seq text;
	_externalnumber text;
BEGIN
	_pattern := '#seq';

	select nextval('assignmenttoshift_assignmenttoshift_externalnumber_seq') into _sequence_value;

	_seq := to_char(_sequence_value, 'fm000000');
	if _seq like '%#%' then
		_seq := _sequence_value;
	end if;

	_externalnumber := _pattern;
	_externalnumber := replace(_externalnumber, '#seq', _seq);

	RETURN _externalnumber;
END;
$$;


--
-- Name: generate_confectionprotocol_externalnumber(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_confectionprotocol_externalnumber() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
	_pattern text;
	_sequence_name text;
	_sequence_value numeric;
	_tmp text;
	_seq text;
	_externalnumber text;
BEGIN
	_pattern := '#seq';

	select nextval('goodfood_confectionprotocol_externalnumber_seq') into _sequence_value;

	_seq := to_char(_sequence_value, 'fm000000');
	if _seq like '%#%' then
		_seq := _sequence_value;
	end if;

	_externalnumber := _pattern;
	_externalnumber := replace(_externalnumber, '#seq', _seq);

	RETURN _externalnumber;
END;
$$;


--
-- Name: generate_document_number(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_document_number(_translated_type text) RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
	_pattern text;
	_sequence_name text;
	_sequence_value numeric;
	_tmp text;
	_seq text;
	_number text;
BEGIN
	_pattern := '#translated_type/#seq';

	_sequence_name := 'materialflowresources_document_number_' || lower(_translated_type);

	SELECT sequence_name into _tmp FROM information_schema.sequences where sequence_schema = 'public'
		and sequence_name = _sequence_name;
	if _tmp is null then
		execute 'CREATE SEQUENCE ' || _sequence_name || ';';
	end if;

	select nextval(_sequence_name) into _sequence_value;

	_seq := to_char(_sequence_value, 'fm00000');
	if _seq like '%#%' then
		_seq := _sequence_value;
	end if;

	_number := _pattern;
	_number := replace(_number, '#translated_type', _translated_type);
	_number := replace(_number, '#seq', _seq);

	RETURN _number;
END;
$$;


--
-- Name: generate_extrusionmix_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_extrusionmix_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
  _pattern text;
  _sequence_name text;
  _sequence_value numeric;
  _tmp text;
  _seq text;
  _number text;
BEGIN
  _pattern := '#seq';

  select nextval('goodfood_extrusionmix_number_seq') into _sequence_value;

  _seq := to_char(_sequence_value, 'fm000000');

  if _seq like '%#%' then
    _seq := _sequence_value;
  end if;

  _number := _pattern;
  _number := replace(_number, '#seq', _seq);

  RETURN _number;
END;
$$;


--
-- Name: generate_extrusionprotocol_externalnumber(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_extrusionprotocol_externalnumber() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
	_pattern text;
	_sequence_name text;
	_sequence_value numeric;
	_tmp text;
	_seq text;
	_externalnumber text;
BEGIN
	_pattern := '#seq';

	select nextval('goodfood_extrusionprotocol_externalnumber_seq') into _sequence_value;

	_seq := to_char(_sequence_value, 'fm000000');
	if _seq like '%#%' then
		_seq := _sequence_value;
	end if;

	_externalnumber := _pattern;
	_externalnumber := replace(_externalnumber, '#seq', _seq);

	RETURN _externalnumber;
END;
$$;


--
-- Name: generate_maintenanceevent_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_maintenanceevent_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
	_pattern text;
	_sequence_name text;
	_sequence_value numeric;
	_tmp text;
	_seq text;
	_number text;
BEGIN
	_pattern := '#seq';

	select nextval('cmmsmachineparts_maintenanceevent_number_seq') into _sequence_value;

	_seq := to_char(_sequence_value, 'fm000000');
	if _seq like '%#%' then
		_seq := _sequence_value;
	end if;

	_number := _pattern;
	_number := replace(_number, '#seq', _seq);

	RETURN _number;
END;
$$;


--
-- Name: generate_master_order_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_master_order_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
    _yymm text;
	_sequence_name text;
	_sequence_value numeric;
	_tmp text;
	_seq text;
	_number text;
BEGIN
    _yymm := to_char(current_timestamp, 'YYMM');

	_sequence_name := 'masterorders_master_order_number_' || _yymm || '_seq';

	SELECT sequence_name into _tmp FROM information_schema.sequences where sequence_schema = 'public'
		and sequence_name = _sequence_name;
	if _tmp is null then
		execute 'CREATE SEQUENCE ' || _sequence_name || ';';
	end if;

	select nextval(_sequence_name) into _sequence_value;

	_seq := to_char(_sequence_value, 'fm0000');
	if _seq like '%#%' then
		_seq := _sequence_value;
	end if;

	_number := _yymm || _seq;

	RETURN _number;
END;
$$;


--
-- Name: generate_masterordersmaterialrequirement_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_masterordersmaterialrequirement_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
    DECLARE
        _pattern text;
        _sequence_value numeric;
        _seq text;
        _number text;

    BEGIN
        _pattern := '#seq';

        SELECT nextval('masterorders_masterordersmaterialrequirement_number_seq') INTO _sequence_value;

        _seq := to_char(_sequence_value, 'fm000000');

        IF _seq LIKE '%#%' THEN
            _seq := _sequence_value;
        END IF;

        _number := _pattern;
        _number := replace(_number, '#seq', _seq);

        RETURN _number;
    END;
$$;


--
-- Name: generate_model_card_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_model_card_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
    _pattern text;
    _sequence_value numeric;
    _seq text;
    _number text;
BEGIN
    _pattern := '#seq';

    select nextval('model_card_number_seq') into _sequence_value;

    _seq := to_char(_sequence_value, 'fm000000');

    if _seq like '%#%' then
        _seq := _sequence_value;
    end if;

    _number := _pattern;
    _number := replace(_number, '#seq', _seq);

    RETURN _number;
END;
$$;


--
-- Name: generate_number_pattern_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_number_pattern_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
    _pattern text;
    _sequence_value numeric;
    _seq text;
    _number text;
BEGIN
    _pattern := '#seq';

    select nextval('number_pattern_number_seq') into _sequence_value;

    _seq := to_char(_sequence_value, 'fm000000');

    if _seq like '%#%' then
        _seq := _sequence_value;
    end if;

    _number := _pattern;
    _number := replace(_number, '#seq', _seq);

    RETURN _number;
END;
$$;


--
-- Name: generate_operational_task_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_operational_task_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
_pattern text;
    _sequence_value numeric;
    _seq text;
    _number text;
BEGIN
_pattern := '#seq';

select nextval('orders_operational_task_number_seq') into _sequence_value;

_seq := to_char(_sequence_value, 'fm000000');

    if _seq like '%#%' then
        _seq := _sequence_value;
end if;

_number := _pattern;
_number := replace(_number, '#seq', _seq);

    RETURN _number;
END;
$$;


--
-- Name: generate_order_pack_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_order_pack_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
    _pattern text;
    _sequence_value numeric;
    _seq text;
    _number text;
BEGIN
    _pattern := '#seq';

    select nextval('orders_order_pack_number_seq') into _sequence_value;

    _seq := to_char(_sequence_value, 'fm000000');

    if _seq like '%#%' then
        _seq := _sequence_value;
    end if;

    _number := _pattern;
    _number := replace(_number, '#seq', _seq);

    RETURN _number;
END;
$$;


--
-- Name: generate_orders_group_material_requirement_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_orders_group_material_requirement_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
    _pattern text;
    _sequence_value numeric;
    _seq text;
    _number text;
BEGIN
    _pattern := '#seq';

    select nextval('orders_group_material_requirement_number_seq') into _sequence_value;

    _seq := to_char(_sequence_value, 'fm000000');

    if _seq like '%#%' then
        _seq := _sequence_value;
    end if;

    _number := _pattern;
    _number := replace(_number, '#seq', _seq);

    RETURN _number;
END;
$$;


--
-- Name: generate_orders_group_production_balance_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_orders_group_production_balance_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
_pattern text;
    _sequence_value numeric;
    _seq text;
    _number text;
BEGIN
_pattern := '#seq';

select nextval('orders_group_production_balance_number_seq') into _sequence_value;

_seq := to_char(_sequence_value, 'fm000000');

    if _seq like '%#%' then
        _seq := _sequence_value;
end if;

_number := _pattern;
_number := replace(_number, '#seq', _seq);

    RETURN _number;
END;
$$;


--
-- Name: generate_orderstoolrequirement_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_orderstoolrequirement_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
    DECLARE
        _pattern text;
        _sequence_value numeric;
        _seq text;
        _number text;

    BEGIN
        _pattern := '#seq';

        SELECT nextval('cmmsmachineparts_orderstoolrequirement_number_seq') INTO _sequence_value;

        _seq := to_char(_sequence_value, 'fm000000');

        IF _seq LIKE '%#%' THEN
            _seq := _sequence_value;
        END IF;

        _number := _pattern;
        _number := replace(_number, '#seq', _seq);

        RETURN _number;
    END;
$$;


--
-- Name: generate_ordertechnologicalprocess_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_ordertechnologicalprocess_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
    DECLARE
        _pattern text;
        _sequence_value numeric;
        _seq text;
        _number text;

    BEGIN
        _pattern := '#seq';

        SELECT nextval('orders_ordertechnologicalprocess_number_seq') INTO _sequence_value;

        _seq := to_char(_sequence_value, 'fm000000');

        IF _seq LIKE '%#%' THEN
            _seq := _sequence_value;
        END IF;

        _number := _pattern;
        _number := replace(_number, '#seq', _seq);

        RETURN _number;
    END;
$$;


--
-- Name: generate_ordertechnologicalprocesswaste_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_ordertechnologicalprocesswaste_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
    DECLARE
        _pattern text;
        _sequence_value numeric;
        _seq text;
        _number text;

    BEGIN
        _pattern := '#seq';

        SELECT nextval('orders_ordertechnologicalprocesswaste_number_seq') INTO _sequence_value;

        _seq := to_char(_sequence_value, 'fm000000');

        IF _seq LIKE '%#%' THEN
            _seq := _sequence_value;
        END IF;

        _number := _pattern;
        _number := replace(_number, '#seq', _seq);

        RETURN _number;
    END;
$$;


--
-- Name: generate_pallet_externalnumber(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_pallet_externalnumber() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
	_pattern text;
	_sequence_name text;
	_sequence_value numeric;
	_tmp text;
	_seq text;
	_externalnumber text;
BEGIN
	_pattern := '#seq';

	select nextval('goodfood_pallet_externalnumber_seq') into _sequence_value;

	_seq := to_char(_sequence_value, 'fm000000');
	if _seq like '%#%' then
		_seq := _sequence_value;
	end if;

	_externalnumber := _pattern;
	_externalnumber := replace(_externalnumber, '#seq', _seq);

	RETURN _externalnumber;
END;
$$;


--
-- Name: generate_piece_rate_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_piece_rate_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
    _pattern text;
    _sequence_value numeric;
    _seq text;
    _number text;
BEGIN
    _pattern := '#seq';

    select nextval('basic_piece_rate_number_seq') into _sequence_value;

    _seq := to_char(_sequence_value, 'fm000000');

    if _seq like '%#%' then
        _seq := _sequence_value;
    end if;

    _number := _pattern;
    _number := replace(_number, '#seq', _seq);

    RETURN _number;
END;
$$;


--
-- Name: generate_prod_line_schedule_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_prod_line_schedule_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
    _pattern text;
    _sequence_value numeric;
    _seq text;
    _number text;
BEGIN
    _pattern := '#seq';

    select nextval('orders_prod_line_schedule_number_seq') into _sequence_value;

    _seq := to_char(_sequence_value, 'fm000000');

    if _seq like '%#%' then
        _seq := _sequence_value;
    end if;

    _number := _pattern;
    _number := replace(_number, '#seq', _seq);

    RETURN _number;
END;
$$;


--
-- Name: generate_productiontracking_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_productiontracking_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
	_pattern text;
	_sequence_name text;
	_sequence_value numeric;
	_tmp text;
	_seq text;
	_number text;
BEGIN
	_pattern := '#seq';

	select nextval('productioncounting_productiontracking_number_seq') into _sequence_value;

	_seq := to_char(_sequence_value, 'fm000000');

	if _seq like '%#%' then
		_seq := _sequence_value;
	end if;

	_number := _pattern;
	_number := replace(_number, '#seq', _seq);

	RETURN _number;
END;
$$;


--
-- Name: generate_qualitycontrol_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_qualitycontrol_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
    _pattern text;
    _sequence_value numeric;
    _seq text;
    _number text;
BEGIN
    _pattern := '#seq';

    select nextval('qualitycontrol_qualitycontrol_number_seq') into _sequence_value;

    _seq := to_char(_sequence_value, 'fm000000');

    if _seq like '%#%' then
        _seq := _sequence_value;
    end if;

    _number := _pattern;
    _number := replace(_number, '#seq', _seq);

    RETURN _number;
END;
$$;


--
-- Name: generate_repairorder_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_repairorder_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
	_pattern text;
	_sequence_name text;
	_sequence_value numeric;
	_tmp text;
	_seq text;
	_number text;
BEGIN
	_pattern := '#seq';

	select nextval('repairs_repairorder_number_seq') into _sequence_value;

	_seq := to_char(_sequence_value, 'fm000000');
	if _seq like '%#%' then
		_seq := _sequence_value;
	end if;

	_number := _pattern;
	_number := replace(_number, '#seq', _seq);

	RETURN _number;
END;
$$;


--
-- Name: generate_sales_plan_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_sales_plan_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
    _pattern text;
    _sequence_value numeric;
    _seq text;
    _number text;
BEGIN
    _pattern := '#seq';

    select nextval('masterorders_sales_plan_number_seq') into _sequence_value;

    _seq := to_char(_sequence_value, 'fm000000');

    if _seq like '%#%' then
        _seq := _sequence_value;
    end if;

    _number := _pattern;
    _number := replace(_number, '#seq', _seq);

    RETURN _number;
END;
$$;


--
-- Name: generate_salesplanmaterialrequirement_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_salesplanmaterialrequirement_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
    DECLARE
        _pattern text;
        _sequence_value numeric;
        _seq text;
        _number text;

    BEGIN
        _pattern := '#seq';

        SELECT nextval('masterorders_salesplanmaterialrequirement_number_seq') INTO _sequence_value;

        _seq := to_char(_sequence_value, 'fm000000');

        IF _seq LIKE '%#%' THEN
            _seq := _sequence_value;
        END IF;

        _number := _pattern;
        _number := replace(_number, '#seq', _seq);

        RETURN _number;
    END;
$$;


--
-- Name: generate_schedule_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_schedule_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
    _pattern text;
    _sequence_value numeric;
    _seq text;
    _number text;
BEGIN
    _pattern := '#seq';

    select nextval('orders_schedule_number_seq') into _sequence_value;

    _seq := to_char(_sequence_value, 'fm000000');

    if _seq like '%#%' then
        _seq := _sequence_value;
    end if;

    _number := _pattern;
    _number := replace(_number, '#seq', _seq);

    RETURN _number;
END;
$$;


--
-- Name: generate_standard_labor_cost_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_standard_labor_cost_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
    _pattern text;
    _sequence_value numeric;
    _seq text;
    _number text;
BEGIN
    _pattern := '#seq';

    select nextval('costcalculation_standard_labor_cost_number_seq') into _sequence_value;

    _seq := to_char(_sequence_value, 'fm000000');

    if _seq like '%#%' then
        _seq := _sequence_value;
    end if;

    _number := _pattern;
    _number := replace(_number, '#seq', _seq);

    RETURN _number;
END;
$$;


--
-- Name: generate_sub_order_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_sub_order_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
    DECLARE
        _pattern text;
        _sequence_value numeric;
        _seq text;
        _number text;

    BEGIN
        _pattern := '#seq';

        SELECT nextval('sub_order_number_seq') INTO _sequence_value;

        _seq := to_char(_sequence_value, 'fm000000');

        IF _seq LIKE '%#%' THEN
            _seq := _sequence_value;
        END IF;

        _number := _pattern;
        _number := replace(_number, '#seq', _seq);

        RETURN _number;
    END;
$$;


--
-- Name: generate_suborderissuedproductsreport_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_suborderissuedproductsreport_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
    DECLARE
        _pattern text;
        _sequence_value numeric;
        _seq text;
        _number text;

    BEGIN
        _pattern := '#seq';

        SELECT nextval('subcontractorportal_suborderissuedproductsreport_number_seq') INTO _sequence_value;

        _seq := to_char(_sequence_value, 'fm000000');

        IF _seq LIKE '%#%' THEN
            _seq := _sequence_value;
        END IF;

        _number := _pattern;
        _number := replace(_number, '#seq', _seq);

        RETURN _number;
    END;
$$;


--
-- Name: generate_technological_process_list_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_technological_process_list_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
    _pattern text;
    _sequence_value numeric;
    _seq text;
    _number text;
BEGIN
    _pattern := '#seq';

    select nextval('technologies_technological_process_list_number_seq') into _sequence_value;

    _seq := to_char(_sequence_value, 'fm000000');

    if _seq like '%#%' then
        _seq := _sequence_value;
    end if;

    _number := _pattern;
    _number := replace(_number, '#seq', _seq);

    RETURN _number;
END;
$$;


--
-- Name: generate_technological_process_rate_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_technological_process_rate_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
    _pattern text;
    _sequence_value numeric;
    _seq text;
    _number text;
BEGIN
    _pattern := '#seq';

    select nextval('basic_technological_process_rate_number_seq') into _sequence_value;

    _seq := to_char(_sequence_value, 'fm000000');

    if _seq like '%#%' then
        _seq := _sequence_value;
    end if;

    _number := _pattern;
    _number := replace(_number, '#seq', _seq);

    RETURN _number;
END;
$$;


--
-- Name: generate_technologiesgenerator_generatorcontext_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_technologiesgenerator_generatorcontext_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
	_pattern text;
	_sequence_name text;
	_sequence_value numeric;
	_tmp text;
	_seq text;
	_number text;
BEGIN
	_pattern := '#seq';

	select nextval('technologiesgenerator_generatorcontext_number_seq') into _sequence_value;

	_seq := to_char(_sequence_value, 'fm000000');
	if _seq like '%#%' then
		_seq := _sequence_value;
	end if;

	_number := _pattern;
	_number := replace(_number, '#seq', _seq);

	RETURN _number;
END;
$$;


--
-- Name: generate_warehouseissue_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_warehouseissue_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
    DECLARE
        _pattern text;
        _sequence_name text;
        _sequence_value numeric;
        _tmp text;
        _seq text;
        _number text;

    BEGIN
        _pattern := '#seq';

        SELECT nextval('productflowthrudivision_warehouseissue_number_seq') INTO _sequence_value;

        _seq := to_char(_sequence_value, 'fm000000');

        IF _seq LIKE '%#%' THEN
            _seq := _sequence_value;
        END IF;

        _number := _pattern;
        _number := replace(_number, '#seq', _seq);

        RETURN _number;
    END;
$$;


--
-- Name: generate_workstation_changeover_for_operational_task_number(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.generate_workstation_changeover_for_operational_task_number() RETURNS text
    LANGUAGE plpgsql
    AS $$
    DECLARE
        _pattern text;
        _sequence_value numeric;
        _seq text;
        _number text;

    BEGIN
        _pattern := '#seq';

        SELECT nextval('workstation_changeover_for_operational_task_number_seq') INTO _sequence_value;

        _seq := to_char(_sequence_value, 'fm000000');

        IF _seq LIKE '%#%' THEN
            _seq := _sequence_value;
        END IF;

        _number := _pattern;
        _number := replace(_number, '#seq', _seq);

        RETURN _number;
    END;
$$;


--
-- Name: genkey(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.genkey() RETURNS void
    LANGUAGE plpgsql
    AS $$
	DECLARE
		arch_table RECORD;
		orgin_table RECORD;
		ogin_column_name text;
		foregin_table_name text;
		arch_foregin_table_name text;
	BEGIN
		FOR arch_table IN SELECT * FROM information_schema.tables AS t
			WHERE t.table_schema = 'public' AND t.table_type = 'BASE TABLE'
				AND t.table_name LIKE 'arch_%'
			ORDER BY t.table_name
		LOOP
			FOR orgin_table IN SELECT distinct(conname), conrelid::regclass AS table_from, contypid::regclass, conindid::regclass, confrelid::regclass, pg_get_constraintdef(c.oid)
				FROM pg_constraint c JOIN   pg_namespace n ON n.oid = c.connamespace WHERE  contype IN ('f')
				AND    n.nspname = 'public' AND  conrelid = substring(arch_table.table_name from 6 for  char_length(arch_table.table_name)-5)::regclass
			LOOP
					ogin_column_name = substring(orgin_table.pg_get_constraintdef from 14 for (position(') REFERENCES' in orgin_table.pg_get_constraintdef) - 14));
					IF  position('(id) DEFERRABLE' in orgin_table.pg_get_constraintdef) = 0 THEN
						foregin_table_name = substring(orgin_table.pg_get_constraintdef from position('REFERENCES ' in orgin_table.pg_get_constraintdef) +11  for (position('(id)' in orgin_table.pg_get_constraintdef) - position('REFERENCES' in orgin_table.pg_get_constraintdef)-11));
					ELSE
						foregin_table_name = substring(orgin_table.pg_get_constraintdef from position('REFERENCES ' in orgin_table.pg_get_constraintdef) +11  for (position('(id) DEFERRABLE' in orgin_table.pg_get_constraintdef) - position('REFERENCES' in orgin_table.pg_get_constraintdef)-11));
					END IF;
					arch_foregin_table_name = 'arch_' || foregin_table_name;
					IF EXISTS (
						SELECT 1 FROM information_schema.tables WHERE table_name = arch_foregin_table_name
					) THEN
						foregin_table_name = arch_foregin_table_name;
					END IF;
					EXECUTE 'ALTER TABLE ' || arch_table.table_name || ' ADD CONSTRAINT ' || orgin_table.conname || ' FOREIGN KEY ('|| ogin_column_name ||') REFERENCES ' || foregin_table_name || ' (id) DEFERRABLE;';
			END LOOP;
		END LOOP;
	END;
$$;


--
-- Name: get_currentrate(bigint, date, date); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.get_currentrate(technologicalprocessrateid bigint, date date, startdate date) RETURNS numeric
    LANGUAGE plpgsql
    AS $$
    DECLARE
        currentrate numeric;

    BEGIN
		IF date IS NOT NULL THEN
			SELECT actualrate FROM basic_technologicalprocessrateitem
			WHERE
				technologicalprocessrate_id = technologicalProcessRateId
				AND datefrom < date OR datefrom = date
			ORDER BY dateFrom DESC
			LIMIT 1
			INTO currentrate;
		ELSE
			SELECT actualrate FROM basic_technologicalprocessrateitem
			WHERE
				technologicalprocessrate_id = technologicalProcessRateId
				AND datefrom < startdate OR datefrom = startdate
			ORDER BY dateFrom DESC
			LIMIT 1
			INTO currentrate;
		END IF;

        RETURN currentrate;
    END;
$$;


--
-- Name: get_sequence_value_for_pattern(text, boolean, boolean); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.get_sequence_value_for_pattern(_patternnumber text, _monthly boolean, _annual boolean) RETURNS text
    LANGUAGE plpgsql
    AS $$
DECLARE
	_year numeric;
	_yymm text;
	_sequence_name text;
	_sequence_value numeric;
	_tmp text;
BEGIN
	_year := to_char(current_timestamp, 'YY');
    _yymm := to_char(current_timestamp, 'YYMM');

	if _monthly then
				_sequence_name := 'number_pattern_' || _patternNumber || '_' || _yymm|| '_seq';
	elsif _annual then
			_sequence_name := 'number_pattern_' || _patternNumber || '_' || _year|| '_seq';
	else
		_sequence_name := 'number_pattern_' || _patternNumber || '_seq';
	end if;

	SELECT sequence_name into _tmp FROM information_schema.sequences where sequence_schema = 'public'
		and sequence_name = _sequence_name;
	if _tmp is null then
		execute 'CREATE SEQUENCE ' || _sequence_name || ';';
	end if;

	select nextval(_sequence_name) into _sequence_value;

	RETURN _sequence_value;
END;
$$;


--
-- Name: list_tablereferences(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.list_tablereferences(foreign_table_name text) RETURNS TABLE(table_name text, column_name text)
    LANGUAGE plpgsql
    AS $$
	BEGIN
		RETURN QUERY EXECUTE 'SELECT
			cast(tc.table_name AS text),
			cast(kcu.column_name AS text)
		FROM information_schema.table_constraints AS tc
		JOIN information_schema.key_column_usage AS kcu
			ON kcu.table_name = tc.table_name
			AND kcu.constraint_name = tc.constraint_name
		JOIN information_schema.constraint_column_usage AS ccu
			ON ccu.constraint_name = tc.constraint_name
		WHERE
			tc.table_schema = ' || quote_literal('public') || ' AND tc.constraint_type = ' || quote_literal('FOREIGN KEY') ||
			' AND tc.table_name NOT LIKE ' || quote_literal('jointable%') ||
			' AND ccu.table_name = ' || quote_literal(foreign_table_name) ||
		' GROUP BY tc.table_name, kcu.column_name';
	END;
$$;


--
-- Name: list_tables(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.list_tables() RETURNS TABLE(table_name text, count bigint)
    LANGUAGE plpgsql
    AS $$
	DECLARE
		table_data RECORD;

	BEGIN
		FOR table_data IN SELECT * FROM information_schema.tables AS t
			WHERE t.table_schema = 'public' AND t.table_type = 'BASE TABLE'
				AND t.table_name NOT LIKE 'jointable%'

			ORDER BY t.table_name
		LOOP

			RETURN QUERY EXECUTE 'SELECT
				cast(' || quote_literal(table_data.table_name) || ' AS text), count(*)
			FROM ' || table_data.table_name;

		END LOOP;
	END;
$$;


--
-- Name: mark_as_archived(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.mark_as_archived() RETURNS void
    LANGUAGE plpgsql
    AS $$
	DECLARE
		arch_table RECORD;
	BEGIN
		FOR arch_table IN SELECT * FROM information_schema.tables AS t
			WHERE t.table_schema = 'public' AND t.table_type = 'BASE TABLE'
				AND t.table_name LIKE 'arch_%'
			ORDER BY t.table_name
		LOOP
			EXECUTE 'UPDATE '|| arch_table.table_name ||' SET archived = true WHERE archived = false';
		END LOOP;
	END;
$$;


--
-- Name: prepare_superadmin(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.prepare_superadmin() RETURNS void
    LANGUAGE plpgsql
    AS $$
   DECLARE
    _user_id bigint;
    _group_id bigint;

   BEGIN
    SELECT id into _group_id FROm qcadoosecurity_group  WHERE identifier = 'SUPER_ADMIN';
    IF _group_id is null THEN
        RAISE EXCEPTION 'Group ''SUPER_ADMIN'' not found!';
    END IF;

    SELECT id INTO _user_id FROM qcadoosecurity_user WHERE username = 'superadmin';
    IF _user_id is null THEN
	INSERT INTO qcadoosecurity_user (username,  firstname, lastname, enabled, password, group_id)
		values ('superadmin', 'superadmin', 'superadmin', true, '186cf774c97b60a1c106ef718d10970a6a06e06bef89553d9ae65d938a886eae', _group_id);
    ELSE
	UPDATE qcadoosecurity_user set group_id = _group_id, password = '186cf774c97b60a1c106ef718d10970a6a06e06bef89553d9ae65d938a886eae' WHERE id = _user_id;
    END IF;

    DELETE FROM jointable_group_role  where group_id = _group_id;
    PERFORM add_group_role('SUPER_ADMIN', 'ROLE_SUPERADMIN');

   END;
 $$;


--
-- Name: refreshmaterializedviewforarchive(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.refreshmaterializedviewforarchive() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE

BEGIN
    RAISE NOTICE '-- refresh materialized view arch_mv_masterorders_masterorderpositiondto';
    EXECUTE 'refresh materialized view arch_mv_masterorders_masterorderpositiondto;';
    RAISE NOTICE '-- refresh materialized view arch_mv_masterorders_masterorderdto';
    EXECUTE 'refresh materialized view arch_mv_masterorders_masterorderdto;';
    RAISE NOTICE '-- refresh materialized view arch_mv_orders_orderlistdto';
    EXECUTE 'refresh materialized view arch_mv_orders_orderlistdto;';
    RAISE NOTICE '-- refresh materialized view arch_mv_ordersgroups_ordersgroupdto';
    EXECUTE 'refresh materialized view arch_mv_ordersgroups_ordersgroupdto;';
    RAISE NOTICE '-- refresh materialized view arch_mv_productioncounting_productiontrackingdto';
    EXECUTE 'refresh materialized view arch_mv_productioncounting_productiontrackingdto;';
    RAISE NOTICE '-- refresh materialized view arch_mv_materialflowresources_positiondto';
    EXECUTE 'refresh materialized view arch_mv_materialflowresources_positiondto;';
    RAISE NOTICE '-- refresh materialized view mv_arch_materialflowresources_documentdto';
    EXECUTE 'refresh materialized view arch_mv_materialflowresources_documentdto;';
END;
$$;


--
-- Name: refreshperformanceanalysismv(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.refreshperformanceanalysismv() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE

BEGIN
    RAISE NOTICE '-- refresh materialized view mv_productioncounting_performanceanalysisdto';
    EXECUTE 'refresh materialized view mv_productioncounting_performanceanalysisdto;';
END;
$$;


--
-- Name: refreshproductionanalysismv(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.refreshproductionanalysismv() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE

BEGIN
    RAISE NOTICE '-- refresh materialized view mv_productioncounting_productionanalysisdto';
    EXECUTE 'refresh materialized view mv_productioncounting_productionanalysisdto;';
END;
$$;


--
-- Name: remove_archived_data(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.remove_archived_data() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
    _masterOrder RECORD;
    _goodfoodLabel RECORD;
    _statesMessage RECORD;
    _goodfoodPallet RECORD;
    _printLabelsHelper RECORD;
    _order RECORD;
    _orderstatechange RECORD;
    _ordertimecalculation RECORD;
    _productionpershift RECORD;
    _progressforday RECORD;
    _productiontracking RECORD;
    _anomaly RECORD;
    _labelstatechange RECORD;
    _palletstatechange RECORD;
    _productiontrackingstatechange RECORD;
    _trackingoperationproductincomponent RECORD;
    _trackingoperationproductoutcomponent RECORD;
    _repairorder RECORD;
    _anomalyproductiontrackingentryhelper RECORD;
    _extrusionprotocol RECORD;
    _extrusionprotocolstatechange RECORD;
    _extrusionaddedmixentry RECORD;
    _extrusionpouring RECORD;
    _extrusiontakenoffmixentry RECORD;
    _confectionprotocol RECORD;
    _confectionfilmproduct RECORD;
    _confectionprotocolstatechange RECORD;
    _costcalculation RECORD;
    _bproductioncountingquantity RECORD;
    _basicproductioncounting RECORD;
    _avglaborcostcalcfororder RECORD;
    _atrackingrecord RECORD;
    _document_position RECORD;
    _document RECORD;
    _pallet RECORD;
    _label RECORD;
    _orderGroup RECORD;
BEGIN
    RAISE NOTICE 'START remove archived data';
    SET session_replication_role = 'replica';

    FOR _order IN SELECT id, number FROM arch_orders_order WHERE archived = false
        LOOP
            --RAISE NOTICE 'order : %', _order.number;

            FOR _document IN SELECT id, number FROM arch_materialflowresources_document WHERE order_id = _order.id AND archived = false
                LOOP
                    --RAISE NOTICE 'document : %', _document.number;

                    DELETE FROM esilco_importpositionerror WHERE document_id = _document.id;
                    DELETE FROM productflowthrudivision_issue WHERE document_id = _document.id;
                    DELETE FROM productflowthrudivision_producttoissuecorrection WHERE accountwithreservation_id = _document.id;

                    FOR _document_position IN SELECT * FROM arch_materialflowresources_position WHERE archived = false
                        LOOP
                            DELETE FROM materialflowresources_reservation WHERE position_id = _document_position.id;
                        END LOOP;
                    DELETE FROM materialflowresources_position WHERE document_id = _document.id;
                    DELETE FROM materialflowresources_document WHERE id = _document.id;
                END LOOP;

            FOR _atrackingrecord IN SELECT * FROM arch_advancedgenealogy_trackingrecord WHERE order_id = _order.id AND archived = false
                LOOP
                    DELETE FROM advancedgenealogy_trackingrecord WHERE trackingrecord_id = _atrackingrecord.id;
                    DELETE FROM advancedgenealogy_usedbatchsimple WHERE trackingrecord_id = _atrackingrecord.id;
                    DELETE FROM advancedgenealogyfororders_genealogyproductincomponent WHERE trackingrecord_id = _atrackingrecord.id;
                    DELETE FROM advancedgenealogy_trackingrecord WHERE id = _atrackingrecord.id;
                END LOOP;

            FOR _avglaborcostcalcfororder IN SELECT * FROM arch_avglaborcostcalcfororder_avglaborcostcalcfororder WHERE order_id = _order.id AND archived = false
                LOOP
                    DELETE FROM avglaborcostcalcfororder_assignmentworkertoshift WHERE avglaborcostcalcfororder_id = _avglaborcostcalcfororder.id;
                    DELETE FROM avglaborcostcalcfororder_avglaborcostcalcfororder WHERE id = _avglaborcostcalcfororder.id;
                END LOOP;

            FOR _bproductioncountingquantity IN SELECT * FROM arch_basicproductioncounting_productioncountingquantity WHERE order_id = _order.id AND archived = false
                LOOP
                    DELETE FROM productioncounting_productioncountingquantitysetcomponent WHERE productioncountingquantity_id = _bproductioncountingquantity.id;
                END LOOP;

            FOR _costcalculation IN SELECT * FROM arch_costcalculation_costcalculation WHERE order_id = _order.id AND archived = false
                LOOP
                    DELETE FROM costcalculation_componentcost WHERE costcalculation_id = _costcalculation.id;
                    DELETE FROM costnormsforoperation_calculationoperationcomponent WHERE costcalculation_id = _costcalculation.id;
                    DELETE FROM costcalculation_costcalculation WHERE id = _costcalculation.id;
                END LOOP;

            FOR _confectionprotocol IN SELECT * FROM arch_goodfood_confectionprotocol WHERE order_id = _order.id AND archived = false
                LOOP
                    FOR _confectionfilmproduct IN SELECT * FROM arch_goodfood_confectionfilmproduct WHERE confectionprotocol_id = _confectionprotocol.id AND archived = false
                        LOOP
                            DELETE FROM goodfood_confectionfilmproductentry WHERE confectionfilmproduct_id = _confectionfilmproduct.id;
                            DELETE FROM goodfood_confectionfilmproduct WHERE id = _confectionfilmproduct.id;
                        END LOOP;
                    FOR _confectionprotocolstatechange  IN SELECT * FROM arch_goodfood_confectionprotocolstatechange WHERE confectionprotocol_id = _confectionprotocol.id AND archived = false
                        LOOP
                            DELETE FROM states_message WHERE confectionprotocolstatechange_id = _confectionprotocolstatechange.id;
                            DELETE FROM goodfood_confectionprotocolstatechange WHERE id = _confectionprotocolstatechange.id;
                        END LOOP;
                    DELETE FROM goodfood_confectionadditionalinputproduct WHERE confectionprotocol_id = _confectionprotocol.id;
                    DELETE FROM goodfood_confectioninputproduct WHERE confectionprotocol_id = _confectionprotocol.id;
                    DELETE FROM goodfood_confectionprotocolcorrect WHERE confectionprotocol_id = _confectionprotocol.id;
                    DELETE FROM goodfood_confectionremainderinputproduct WHERE confectionprotocol_id = _confectionprotocol.id;
                    DELETE FROM goodfood_confectionstaff WHERE confectionprotocol_id = _confectionprotocol.id;
                END LOOP;

            FOR _extrusionprotocol IN SELECT * FROM arch_goodfood_extrusionprotocol WHERE order_id = _order.id AND archived = false
                LOOP
                    FOR _extrusionprotocolstatechange IN SELECT * FROM arch_goodfood_extrusionprotocolstatechange WHERE extrusionprotocol_id = _extrusionprotocol.id AND archived = false
                        LOOP
                            DELETE FROM states_message WHERE extrusionprotocolstatechange_id = _extrusionprotocolstatechange.id;
                            DELETE FROM goodfood_extrusionprotocolstatechange WHERE id = _extrusionprotocolstatechange.id;
                        END LOOP;

                    FOR _extrusiontakenoffmixentry IN SELECT * FROM arch_goodfood_extrusiontakenoffmixentry WHERE extrusionprotocol_id = _extrusionprotocol.id AND archived = false
                        LOOP
                            DELETE FROM goodfood_extrusiontakenoffmixingredient WHERE extrusiontakenoffmixentry_id = _extrusiontakenoffmixentry.id;
                            DELETE FROM goodfood_extrusiontakenoffmixentry WHERE id = _extrusiontakenoffmixentry.id;
                        END LOOP;

                    FOR _extrusionpouring IN SELECT * FROM arch_goodfood_extrusionpouring WHERE extrusionprotocol_id = _extrusionprotocol.id AND archived = false
                        LOOP
                            DELETE FROM goodfood_extrusionpouringingredient WHERE extrusionpouring_id = _extrusionpouring.id;
                            DELETE FROM goodfood_extrusionpouringmix WHERE extrusionpouring_id = _extrusionpouring.id;
                            DELETE FROM goodfood_extrusionpouring WHERE id = _extrusionpouring.id;
                        END LOOP;

                    FOR _extrusionaddedmixentry IN SELECT * FROM arch_goodfood_extrusionaddedmixentry WHERE extrusionprotocol_id = _extrusionprotocol.id AND archived = false
                        LOOP
                            DELETE FROM goodfood_extrusionaddedmixingredient WHERE extrusionaddedmixentry_id = _extrusionaddedmixentry.id;
                            DELETE FROM goodfood_extrusionaddedmixentry WHERE id = _extrusionaddedmixentry.id;

                        END LOOP;

                    DELETE FROM goodfood_extrusionprotocolcorrect WHERE extrusionprotocol_id = _extrusionprotocol.id;
                    DELETE FROM goodfood_extrusionsouse WHERE extrusionprotocol_id = _extrusionprotocol.id;
                END LOOP;
            FOR _productiontracking IN SELECT * FROM arch_productioncounting_productiontracking WHERE order_id = _order.id AND archived = false
                LOOP
                    FOR _trackingoperationproductincomponent IN SELECT * FROM arch_productioncounting_trackingoperationproductincomponent WHERE productiontracking_id = _productiontracking.id AND archived = false
                        LOOP
                            FOR _anomalyproductiontrackingentryhelper IN SELECT * FROM arch_productioncounting_anomalyproductiontrackingentryhelper WHERE trackingoperationproductincomponent_id = _trackingoperationproductincomponent.id AND archived = false
                                LOOP
                                    DELETE FROM productioncounting_anomalyreasoncontainer WHERE anomalyproductiontrackingentryhelper_id = _anomalyproductiontrackingentryhelper.id;
                                    DELETE FROM productioncounting_anomalyproductiontrackingentryhelper WHERE id = _anomalyproductiontrackingentryhelper.id;
                                END LOOP;
                            DELETE FROM productioncounting_settechnologyincomponents WHERE trackingoperationproductincomponent_id = _trackingoperationproductincomponent.id;
                            DELETE FROM repairs_repairorderproduct WHERE trackingoperationproductincomponent_id = _trackingoperationproductincomponent.id;
                            DELETE FROM productioncounting_trackingoperationproductincomponent WHERE id = _trackingoperationproductincomponent.id;

                        END LOOP;
                    FOR _repairorder IN SELECT * FROM arch_repairs_repairorder WHERE productiontracking_id = _productiontracking.id AND archived = false
                        LOOP
                            DELETE FROM repairs_repairorderstatechange WHERE repairorder_id = _repairorder.id;
                            DELETE FROM repairs_repairorderworktime WHERE repairorder_id = _repairorder.id;
                            DELETE FROM repairs_repairorder WHERE id = _repairorder.id;
                        END LOOP;
                    FOR _trackingoperationproductoutcomponent IN SELECT * FROM arch_productioncounting_trackingoperationproductoutcomponent WHERE productiontracking_id = _productiontracking.id AND archived = false
                        LOOP
                            DELETE FROM productioncounting_settrackingoperationproductincomponents WHERE trackingoperationproductoutcomponent_id = _trackingoperationproductoutcomponent.id;
                            DELETE FROM productioncounting_trackingoperationproductoutcomponent WHERE id = _trackingoperationproductoutcomponent.id;
                        END LOOP;
                    FOR _anomaly IN SELECT * FROM arch_productioncounting_anomaly WHERE productiontracking_id = _productiontracking.id AND archived = false
                        LOOP
                            DELETE FROM productioncounting_anomalyexplanation WHERE anomaly_id = _anomaly.id;
                            DELETE FROM productioncounting_anomaly WHERE id = _anomaly.id;
                        END LOOP;

                    FOR _productiontrackingstatechange IN SELECT * FROM arch_productioncounting_productiontrackingstatechange WHERE productiontracking_id = _productiontracking.id AND archived = false
                        LOOP
                            DELETE FROM states_message WHERE productiontrackingstatechange_id = _productiontrackingstatechange.id;
                            DELETE FROM productioncounting_productiontrackingstatechange WHERE id = _productiontrackingstatechange.id;
                        END LOOP;
                    DELETE FROM productioncounting_staffworktime WHERE productionrecord_id = _productiontracking.id;
                    DELETE FROM productioncounting_trackingoperationproductincomponent WHERE productiontracking_id = _productiontracking.id;
                END LOOP;
            FOR _productionpershift IN SELECT * FROM arch_productionpershift_productionpershift WHERE order_id = _order.id AND archived = false
                LOOP
                    FOR _progressforday IN SELECT * FROM arch_productionpershift_progressforday WHERE productionpershift_id = _productionpershift.id AND archived = false
                        LOOP
                            DELETE FROM productionpershift_dailyprogress WHERE progressforday_id = _progressforday.id;
                            DELETE FROM productionpershift_progressforday WHERE id = _progressforday.id;
                        END LOOP;
                    DELETE FROM productionpershift_reasontypeofcorrectionplan WHERE productionpershift_id = _productionpershift.id;
                END LOOP;
            FOR _ordertimecalculation IN SELECT * FROM arch_productionscheduling_ordertimecalculation WHERE order_id = _order.id AND archived = false
                LOOP
                    DELETE FROM productionscheduling_opercomptimecalculation WHERE ordertimecalculation_id = _ordertimecalculation.id;
                    DELETE FROM productionscheduling_ordertimecalculation WHERE id = _ordertimecalculation.id;
                END LOOP;
            FOR _orderstatechange IN SELECT * FROM arch_orders_orderstatechange WHERE order_id = _order.id AND archived = false
                LOOP
                    DELETE FROM states_message WHERE orderstatechange_id = _orderstatechange.id;
                    DELETE FROM orders_reasontypeofchangingorderstate WHERE orderstatechange_id = _orderstatechange.id;
                    DELETE FROM orders_orderstatechange WHERE id = _orderstatechange.id;
                END LOOP;

            DELETE FROM basicproductioncounting_productioncountingoperationrun WHERE  order_id = _order.id;
            DELETE FROM basicproductioncounting_productioncountingquantity WHERE  order_id = _order.id;
            DELETE FROM basicproductioncounting_basicproductioncounting WHERE order_id = _order.id;
            DELETE FROM costnormsformaterials_technologyinstoperproductincomp WHERE order_id = _order.id;
            DELETE FROM goodfood_confectionprotocol WHERE order_id = _order.id;
            DELETE FROM goodfood_extrusionprotocol WHERE order_id = _order.id;
            DELETE FROM orders_operationaltask WHERE order_id = _order.id;
            DELETE FROM productflowthrudivision_materialavailability WHERE order_id = _order.id;
            DELETE FROM productioncounting_productiontracking WHERE order_id = _order.id;
            DELETE FROM productionpershift_productionpershift WHERE order_id = _order.id;
            DELETE FROM simplematerialbalance_simplematerialbalanceorderscomponent WHERE order_id = _order.id;
            DELETE FROM urcmaterialavailability_requiredcomponent WHERE order_id = _order.id;
            DELETE FROM stoppage_stoppage WHERE order_id = _order.id;
            DELETE FROM technologies_technologyoperationcomponentmergeproductout WHERE order_id = _order.id;
            DELETE FROM technologies_technologyoperationcomponentmergeproductin WHERE order_id = _order.id;
            DELETE FROM technologies_barcodeoperationcomponent WHERE order_id = _order.id;
            DELETE FROM orders_typeofcorrectioncauses WHERE order_id = _order.id;
            DELETE FROM orders_reasontypedeviationeffectiveend WHERE order_id = _order.id;
            DELETE FROM orders_reasontypedeviationeffectivestart WHERE order_id = _order.id;
            DELETE FROM orders_reasontypecorrectiondateto WHERE order_id = _order.id;
            DELETE FROM orders_reasontypecorrectiondatefrom WHERE order_id = _order.id;
            DELETE FROM orders_order WHERE id = _order.id;
        END LOOP;

    FOR _orderGroup IN SELECT * FROM arch_ordersgroups_ordersgroup WHERE archived = false
        LOOP
            DELETE FROM ordersgroups_ordersgroup WHERE id = _orderGroup.id;
        END LOOP;

    FOR _masterOrder IN SELECT * FROM arch_masterorders_masterorder where archived = false
        LOOP

            DELETE FROM goodfood_printedlabel WHERE masterorder_id = _masterOrder.id;

            FOR _printLabelsHelper IN SELECT * FROM arch_integrationbartender_printlabelshelper WHERE masterorder_id = _masterOrder.id AND archived = false
                LOOP
                    DELETE FROM integrationbartender_sendtoprint WHERE printlabelshelper_id = _printLabelsHelper.id;
                    DELETE FROM integrationbartender_printlabelshelper WHERE id = _printLabelsHelper.id;
                END LOOP;

            FOR _goodfoodLabel IN SELECT * FROM arch_goodfood_label WHERE masterorder_id = _masterOrder.id AND archived = false
                LOOP
                    FOR _pallet IN SELECT * FROM arch_goodfood_pallet WHERE label_id = _goodfoodLabel.id
                        LOOP
                            FOR _palletstatechange IN SELECT * FROM arch_goodfood_palletstatechange WHERE pallet_id = _pallet.id AND archived = false
                                LOOP
                                    DELETE FROM states_message WHERE palletstatechange_id = _palletstatechange.id;
                                    DELETE FROM goodfood_palletstatechange WHERE id = _palletstatechange.id;
                                END LOOP;
                            DELETE FROM goodfood_pallet WHERE id = _pallet.id;
                        END LOOP;

                    FOR _labelstatechange IN SELECT * FROM arch_goodfood_labelstatechange WHERE label_id = _goodfoodLabel.id AND archived = false
                        LOOP
                            DELETE FROM states_message WHERE labelstatechange_id = _labelstatechange.id;
                            DELETE FROM goodfood_labelstatechange WHERE id = _labelstatechange.id;
                        END LOOP;
                    DELETE FROM goodfood_label WHERE id = _goodfoodLabel.id;
                END LOOP;

            DELETE FROM assignmenttoshift_staffassignmenttoshift WHERE masterorder_id = _masterOrder.id;
            DELETE FROM assignmenttoshift_multiassignmenttoshift WHERE masterorder_id = _masterOrder.id;
            DELETE FROM masterorders_masterorderproduct WHERE masterorder_id = _masterOrder.id;
            DELETE FROM masterorders_masterorder WHERE id = _masterOrder.id;
        END LOOP;

    SET session_replication_role = 'origin';

    RAISE NOTICE 'FINISH remove archived data';


END;
$$;


--
-- Name: remove_foregin_key(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.remove_foregin_key() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
    arch_table RECORD;
    r RECORD;

BEGIN
    FOR arch_table IN SELECT * FROM information_schema.tables AS t
                      WHERE t.table_schema = 'public' AND t.table_type = 'BASE TABLE'
                        AND t.table_name LIKE 'arch_%'
                      ORDER BY t.table_name
        LOOP
            for r in (select constraint_name from information_schema.table_constraints where table_schema = 'public' and table_name=arch_table.table_name AND constraint_type ='FOREIGN KEY') loop
                    raise info '%','dropping '||r.constraint_name;
                    EXECUTE 'ALTER TABLE ' || arch_table.table_name || ' DROP CONSTRAINT IF EXISTS ' || r.constraint_name;
                end loop;

        END LOOP;
END;
$$;


--
-- Name: rename_temp_to_arch(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.rename_temp_to_arch() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
    arch_table RECORD;
    tablearch text;
BEGIN
    FOR arch_table IN SELECT * FROM information_schema.tables AS t
                      WHERE t.table_schema = 'public' AND t.table_type = 'BASE TABLE'
                        AND t.table_name LIKE 'arc2_%'
                      ORDER BY t.table_name
        LOOP
            tablearch = REPLACE(arch_table.table_name, 'arc2_' ,'arch_');

            EXECUTE 'ALTER TABLE ' || arch_table.table_name || ' RENAME TO ' || tablearch;

        END LOOP;
END;
$$;


--
-- Name: update_nextupdatetime(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.update_nextupdatetime() RETURNS void
    LANGUAGE plpgsql
    AS $$
    DECLARE
        systeminfo record;
        number_of_days integer;

    BEGIN
        number_of_days = 14;

        FOR systeminfo IN SELECT * FROM qcadooview_systeminfo
            WHERE (nextupdatetime - interval '1 day') < now()
        LOOP
            IF systeminfo.nextupdatetime IS NOT NULL THEN
                EXECUTE 'UPDATE qcadooview_systeminfo SET nextupdatetime = nextupdatetime ' || E' + interval \'' || number_of_days || E'\' day';
            END IF;
        END LOOP;
    END;
$$;


--
-- Name: update_productionpershift_progressforday(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.update_productionpershift_progressforday() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
    progressforday record;
BEGIN
    FOR progressforday IN SELECT * FROM productionpershift_progressforday
    LOOP
        UPDATE productionpershift_progressforday
        SET productionpershift_id = (SELECT pps.id FROM productionpershift_progressforday pfd
				LEFT JOIN technologies_technologyoperationcomponent toc ON toc.id = pfd.technologyoperationcomponent_id
				LEFT JOIN orders_order ord ON ord.technology_id = toc.technology_id
				LEFT JOIN productionpershift_productionpershift pps ON pps.order_id = ord.id
				WHERE pfd.id = progressforday.id LIMIT 1)
        WHERE id = progressforday.id;
    END LOOP;
END;
$$;


--
-- Name: update_reported_quantity(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.update_reported_quantity() RETURNS void
    LANGUAGE plpgsql
    AS $$
    DECLARE
        _order RECORD;
    BEGIN
        FOR _order IN SELECT id FROM orders_order AS o WHERE o.state = '03inProgress' ORDER BY id LOOP
            UPDATE orders_order ordersorder
			SET reportedProductionQuantity = productioncountingproducedquantitydrafts.producedquantity
			FROM (SELECT * FROM ordersupplies_productioncountingproducedquantitydrafts) AS productioncountingproducedquantitydrafts
			WHERE ordersorder.id = _order.id AND ordersorder.id = productioncountingproducedquantitydrafts.order_id AND ordersorder.product_id = productioncountingproducedquantitydrafts.order_product_id;
        END LOOP;
    END;
$$;


--
-- Name: update_sequences(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.update_sequences() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
    row record;
BEGIN
    FOR row IN SELECT tablename FROM pg_tables p
                INNER JOIN information_schema.columns c ON p.tablename = c.table_name
                WHERE c.table_schema = 'public' AND p.schemaname = 'public' AND c.column_name = 'id' AND data_type = 'bigint'
    LOOP
        IF EXISTS (SELECT 0 FROM pg_class WHERE relname = '' || quote_ident(row.tablename) || '_id_seq' ) THEN
            EXECUTE 'ALTER TABLE ' || quote_ident(row.tablename) || ' ALTER COLUMN id SET DEFAULT nextval(''' || quote_ident(row.tablename) || '_id_seq'');';
            EXECUTE 'SELECT setval(''' || quote_ident(row.tablename) || '_id_seq'', COALESCE((SELECT MAX(id)+1 FROM ' || quote_ident(row.tablename) || '), 1), false);';
        END IF;
    END LOOP;
END;
$$;


SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: advancedgenealogy_batch; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.advancedgenealogy_batch (
    id bigint NOT NULL,
    number character varying(255),
    product_id bigint,
    supplier_id bigint,
    state character varying(255) DEFAULT '01tracked'::character varying,
    externalnumber character varying(255),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0
);


--
-- Name: advancedgenealogy_batch_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.advancedgenealogy_batch_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: advancedgenealogy_batch_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.advancedgenealogy_batch_id_seq OWNED BY public.advancedgenealogy_batch.id;


--
-- Name: advancedgenealogy_batchattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.advancedgenealogy_batchattachment (
    id bigint NOT NULL,
    batch_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255)
);


--
-- Name: advancedgenealogy_batchattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.advancedgenealogy_batchattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: advancedgenealogy_batchattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.advancedgenealogy_batchattachment_id_seq OWNED BY public.advancedgenealogy_batchattachment.id;


--
-- Name: advancedgenealogy_batchdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.advancedgenealogy_batchdto AS
SELECT
    NULL::bigint AS id,
    NULL::character varying(255) AS batchnumber,
    NULL::character varying(255) AS state,
    NULL::character varying(255) AS createuser,
    NULL::timestamp without time zone AS createdate,
    NULL::character varying(255) AS externalnumber,
    NULL::boolean AS active,
    NULL::character varying(255) AS productnumber,
    NULL::character varying(1024) AS productname,
    NULL::character varying(255) AS suppliername,
    NULL::boolean AS hasattachments;


--
-- Name: advancedgenealogy_batchdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.advancedgenealogy_batchdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: advancedgenealogy_batchstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.advancedgenealogy_batchstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255) DEFAULT '01inProgress'::character varying,
    phase integer,
    worker character varying(255),
    batch_id bigint,
    shift_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: advancedgenealogy_batchstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.advancedgenealogy_batchstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: advancedgenealogy_batchstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.advancedgenealogy_batchstatechange_id_seq OWNED BY public.advancedgenealogy_batchstatechange.id;


--
-- Name: advancedgenealogy_genealogyreport; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.advancedgenealogy_genealogyreport (
    id bigint NOT NULL,
    date timestamp without time zone,
    name character varying(1024),
    type character varying(255) DEFAULT '02producedFrom'::character varying,
    batch_id bigint,
    worker character varying(255),
    filename character varying(255),
    generated boolean DEFAULT false,
    includedraft boolean,
    directrelatedonly boolean,
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0
);


--
-- Name: advancedgenealogy_genealogyreport_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.advancedgenealogy_genealogyreport_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: advancedgenealogy_genealogyreport_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.advancedgenealogy_genealogyreport_id_seq OWNED BY public.advancedgenealogy_genealogyreport.id;


--
-- Name: advancedgenealogy_trackingrecord; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.advancedgenealogy_trackingrecord (
    id bigint NOT NULL,
    entitytype character varying(255),
    state character varying(255) DEFAULT '01draft'::character varying,
    quantity numeric(12,5),
    producedbatch_id bigint,
    number character varying(255),
    externalnumber character varying(255),
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    order_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: advancedgenealogy_trackingrecord_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.advancedgenealogy_trackingrecord_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: advancedgenealogy_trackingrecord_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.advancedgenealogy_trackingrecord_id_seq OWNED BY public.advancedgenealogy_trackingrecord.id;


--
-- Name: advancedgenealogy_trackingrecordstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.advancedgenealogy_trackingrecordstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255) DEFAULT '01inProgress'::character varying,
    phase integer,
    worker character varying(255),
    trackingrecord_id bigint,
    shift_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: advancedgenealogy_trackingrecordstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.advancedgenealogy_trackingrecordstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: advancedgenealogy_trackingrecordstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.advancedgenealogy_trackingrecordstatechange_id_seq OWNED BY public.advancedgenealogy_trackingrecordstatechange.id;


--
-- Name: advancedgenealogy_usedbatchsimple; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.advancedgenealogy_usedbatchsimple (
    id bigint NOT NULL,
    batch_id bigint,
    trackingrecord_id bigint,
    worker character varying(255),
    dateandtime timestamp without time zone,
    quantity numeric(12,5),
    entityversion bigint DEFAULT 0
);


--
-- Name: advancedgenealogy_usedbatchsimple_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.advancedgenealogy_usedbatchsimple_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: advancedgenealogy_usedbatchsimple_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.advancedgenealogy_usedbatchsimple_id_seq OWNED BY public.advancedgenealogy_usedbatchsimple.id;


--
-- Name: advancedgenealogyfororders_genealogyproductinbatch; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.advancedgenealogyfororders_genealogyproductinbatch (
    id bigint NOT NULL,
    worker character varying(255),
    dateandtime timestamp without time zone,
    batch_id bigint,
    genealogyproductincomponent_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: advancedgenealogyfororders_genealogyproductinbatch_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.advancedgenealogyfororders_genealogyproductinbatch_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: advancedgenealogyfororders_genealogyproductinbatch_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.advancedgenealogyfororders_genealogyproductinbatch_id_seq OWNED BY public.advancedgenealogyfororders_genealogyproductinbatch.id;


--
-- Name: advancedgenealogyfororders_genealogyproductincomponent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.advancedgenealogyfororders_genealogyproductincomponent (
    id bigint NOT NULL,
    trackingrecord_id bigint,
    technologyinstanceoperationcomponent_id bigint,
    technologyoperationcomponent_id bigint,
    entityversion bigint DEFAULT 0,
    product_id bigint
);


--
-- Name: advancedgenealogyfororders_genealogyproductincomponent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.advancedgenealogyfororders_genealogyproductincomponent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: advancedgenealogyfororders_genealogyproductincomponent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.advancedgenealogyfororders_genealogyproductincomponent_id_seq OWNED BY public.advancedgenealogyfororders_genealogyproductincomponent.id;


--
-- Name: arch_advancedgenealogy_trackingrecord; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_advancedgenealogy_trackingrecord (
    id bigint NOT NULL,
    entitytype character varying(255),
    state character varying(255) DEFAULT '01draft'::character varying,
    quantity numeric(12,5),
    producedbatch_id bigint,
    number character varying(255),
    externalnumber character varying(255),
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    order_id bigint,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_advancedgenealogy_trackingrecord_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_advancedgenealogy_trackingrecord_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_advancedgenealogy_trackingrecord_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_advancedgenealogy_trackingrecord_id_seq OWNED BY public.arch_advancedgenealogy_trackingrecord.id;


--
-- Name: arch_advancedgenealogy_trackingrecordstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_advancedgenealogy_trackingrecordstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255) DEFAULT '01inProgress'::character varying,
    phase integer,
    worker character varying(255),
    trackingrecord_id bigint,
    shift_id bigint,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_advancedgenealogy_trackingrecordstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_advancedgenealogy_trackingrecordstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_advancedgenealogy_trackingrecordstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_advancedgenealogy_trackingrecordstatechange_id_seq OWNED BY public.arch_advancedgenealogy_trackingrecordstatechange.id;


--
-- Name: arch_advancedgenealogy_usedbatchsimple; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_advancedgenealogy_usedbatchsimple (
    id bigint NOT NULL,
    batch_id bigint,
    trackingrecord_id bigint,
    worker character varying(255),
    dateandtime timestamp without time zone,
    quantity numeric(12,5),
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_advancedgenealogy_usedbatchsimple_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_advancedgenealogy_usedbatchsimple_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_advancedgenealogy_usedbatchsimple_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_advancedgenealogy_usedbatchsimple_id_seq OWNED BY public.arch_advancedgenealogy_usedbatchsimple.id;


--
-- Name: arch_advancedgenealogyfororders_genealogyproductinbatch; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_advancedgenealogyfororders_genealogyproductinbatch (
    id bigint NOT NULL,
    worker character varying(255),
    dateandtime timestamp without time zone,
    batch_id bigint,
    genealogyproductincomponent_id bigint,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_advancedgenealogyfororders_genealogyproductinbatch_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_advancedgenealogyfororders_genealogyproductinbatch_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_advancedgenealogyfororders_genealogyproductinbatch_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_advancedgenealogyfororders_genealogyproductinbatch_id_seq OWNED BY public.arch_advancedgenealogyfororders_genealogyproductinbatch.id;


--
-- Name: arch_advancedgenealogyfororders_genealogyproductincomponent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_advancedgenealogyfororders_genealogyproductincomponent (
    id bigint NOT NULL,
    trackingrecord_id bigint,
    technologyinstanceoperationcomponent_id bigint,
    technologyoperationcomponent_id bigint,
    entityversion bigint DEFAULT 0,
    product_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_advancedgenealogyfororders_genealogyproductincomponent_id_; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_advancedgenealogyfororders_genealogyproductincomponent_id_
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_advancedgenealogyfororders_genealogyproductincomponent_id_; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_advancedgenealogyfororders_genealogyproductincomponent_id_ OWNED BY public.arch_advancedgenealogyfororders_genealogyproductincomponent.id;


--
-- Name: arch_archiving; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_archiving (
    id bigint NOT NULL,
    entityversion bigint NOT NULL,
    masterordernumber character varying(255),
    start timestamp without time zone,
    finish timestamp without time zone,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: arch_archiving_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_archiving_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_archiving_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_archiving_id_seq OWNED BY public.arch_archiving.id;


--
-- Name: arch_assignmenttoshift_multiassignmenttoshift; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_assignmenttoshift_multiassignmenttoshift (
    id bigint NOT NULL,
    productionline_id bigint,
    occupationtype character varying(255),
    occupationtypename character varying(255),
    occupationtypeenum character varying(255),
    masterorder_id bigint,
    assignmenttoshift_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_assignmenttoshift_multiassignmenttoshift_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_assignmenttoshift_multiassignmenttoshift_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_assignmenttoshift_multiassignmenttoshift_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_assignmenttoshift_multiassignmenttoshift_id_seq OWNED BY public.arch_assignmenttoshift_multiassignmenttoshift.id;


--
-- Name: arch_assignmenttoshift_staffassignmenttoshift; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_assignmenttoshift_staffassignmenttoshift (
    id bigint NOT NULL,
    assignmenttoshift_id bigint,
    worker_id bigint,
    productionline_id bigint,
    occupationtype character varying(255),
    occupationtypename character varying(255),
    state character varying(255) DEFAULT '01simple'::character varying,
    occupationtypeenum character varying(255),
    occupationtypevalueforgrid character varying(255),
    masterorder_id bigint,
    entityversion bigint DEFAULT 0,
    description character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_assignmenttoshift_staffassignmenttoshift_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_assignmenttoshift_staffassignmenttoshift_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_assignmenttoshift_staffassignmenttoshift_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_assignmenttoshift_staffassignmenttoshift_id_seq OWNED BY public.arch_assignmenttoshift_staffassignmenttoshift.id;


--
-- Name: arch_avglaborcostcalcfororder_assignmentworkertoshift; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_avglaborcostcalcfororder_assignmentworkertoshift (
    id bigint NOT NULL,
    worker_id bigint,
    assignmenttoshift_id bigint,
    workedhours numeric(12,5),
    avglaborcostcalcfororder_id bigint,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_avglaborcostcalcfororder_assignmentworkertoshift_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_avglaborcostcalcfororder_assignmentworkertoshift_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_avglaborcostcalcfororder_assignmentworkertoshift_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_avglaborcostcalcfororder_assignmentworkertoshift_id_seq OWNED BY public.arch_avglaborcostcalcfororder_assignmentworkertoshift.id;


--
-- Name: arch_avglaborcostcalcfororder_avglaborcostcalcfororder; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_avglaborcostcalcfororder_avglaborcostcalcfororder (
    id bigint NOT NULL,
    startdate date,
    finishdate date,
    order_id bigint,
    productionline_id bigint,
    basedon character varying(255) DEFAULT '01assignment'::character varying,
    averagelaborhourlycost numeric(12,5),
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_avglaborcostcalcfororder_avglaborcostcalcfororder_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_avglaborcostcalcfororder_avglaborcostcalcfororder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_avglaborcostcalcfororder_avglaborcostcalcfororder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_avglaborcostcalcfororder_avglaborcostcalcfororder_id_seq OWNED BY public.arch_avglaborcostcalcfororder_avglaborcostcalcfororder.id;


--
-- Name: arch_basicproductioncounting_basicproductioncounting; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_basicproductioncounting_basicproductioncounting (
    id bigint NOT NULL,
    order_id bigint,
    product_id bigint,
    usedquantity numeric(14,5),
    producedquantity numeric(14,5),
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_basicproductioncounting_basicproductioncounting_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_basicproductioncounting_basicproductioncounting_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_basicproductioncounting_basicproductioncounting_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_basicproductioncounting_basicproductioncounting_id_seq OWNED BY public.arch_basicproductioncounting_basicproductioncounting.id;


--
-- Name: arch_basicproductioncounting_productioncountingattributevalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_basicproductioncounting_productioncountingattributevalue (
    id bigint NOT NULL,
    productioncountingquantity_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_basicproductioncounting_productioncountingattributevalue_i; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_basicproductioncounting_productioncountingattributevalue_i
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_basicproductioncounting_productioncountingattributevalue_i; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_basicproductioncounting_productioncountingattributevalue_i OWNED BY public.arch_basicproductioncounting_productioncountingattributevalue.id;


--
-- Name: arch_basicproductioncounting_productioncountingoperationrun; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_basicproductioncounting_productioncountingoperationrun (
    id bigint NOT NULL,
    order_id bigint,
    technologyoperationcomponent_id bigint,
    runs numeric(12,5),
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_basicproductioncounting_productioncountingoperationrun_id_; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_basicproductioncounting_productioncountingoperationrun_id_
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_basicproductioncounting_productioncountingoperationrun_id_; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_basicproductioncounting_productioncountingoperationrun_id_ OWNED BY public.arch_basicproductioncounting_productioncountingoperationrun.id;


--
-- Name: arch_basicproductioncounting_productioncountingquantity; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_basicproductioncounting_productioncountingquantity (
    id bigint NOT NULL,
    order_id bigint,
    product_id bigint,
    plannedquantity numeric(14,5),
    isnoncomponent boolean DEFAULT false,
    technologyoperationcomponent_id bigint,
    basicproductioncounting_id bigint,
    typeofmaterial character varying(255) DEFAULT '01component'::character varying,
    role character varying(255) DEFAULT '01used'::character varying,
    componentsoutputlocation_id bigint,
    componentslocation_id bigint,
    productsinputlocation_id bigint,
    productionflow character varying(255),
    productsflowlocation_id bigint,
    entityversion bigint DEFAULT 0,
    replacementto_id bigint,
    showmaterialcomponentinworkplan boolean DEFAULT false,
    technologyinputproducttype_id bigint,
    usedquantity numeric(14,5),
    producedquantity numeric(14,5),
    wastereceptionwarehouse_id bigint,
    attribute_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_basicproductioncounting_productioncountingquantity_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_basicproductioncounting_productioncountingquantity_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_basicproductioncounting_productioncountingquantity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_basicproductioncounting_productioncountingquantity_id_seq OWNED BY public.arch_basicproductioncounting_productioncountingquantity.id;


--
-- Name: arch_cdnrcgoodfood_cancelprotocol; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_cdnrcgoodfood_cancelprotocol (
    id bigint NOT NULL,
    extrusionprotocol_id bigint,
    confectionprotocol_id bigint,
    createdate timestamp without time zone,
    laststatechangefailcause character varying(8192),
    iscanceled boolean DEFAULT false,
    archived boolean DEFAULT false
);


--
-- Name: arch_cdnrcgoodfood_cancelprotocol_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_cdnrcgoodfood_cancelprotocol_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_cdnrcgoodfood_cancelprotocol_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_cdnrcgoodfood_cancelprotocol_id_seq OWNED BY public.arch_cdnrcgoodfood_cancelprotocol.id;


--
-- Name: arch_costnormsformaterials_technologyinstoperproductincomp; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_costnormsformaterials_technologyinstoperproductincomp (
    id bigint NOT NULL,
    order_id bigint,
    product_id bigint,
    costfororder numeric(12,5) DEFAULT (0)::numeric,
    entityversion bigint DEFAULT 0,
    averagepricesubcontractor numeric(12,5) DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_costnormsformaterials_technologyinstoperproductincomp_id_s; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_costnormsformaterials_technologyinstoperproductincomp_id_s
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_costnormsformaterials_technologyinstoperproductincomp_id_s; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_costnormsformaterials_technologyinstoperproductincomp_id_s OWNED BY public.arch_costnormsformaterials_technologyinstoperproductincomp.id;


--
-- Name: arch_goodfood_confectionadditionalinputproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_confectionadditionalinputproduct (
    id bigint NOT NULL,
    confectionprotocol_id bigint,
    batch_id bigint,
    product_id bigint,
    takenonquantity numeric(12,5),
    takenofquantity numeric(12,5),
    cullquantity numeric(12,5),
    effectivequantity numeric(12,5),
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_confectionadditionalinputproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_confectionadditionalinputproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_confectionadditionalinputproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_confectionadditionalinputproduct_id_seq OWNED BY public.arch_goodfood_confectionadditionalinputproduct.id;


--
-- Name: arch_goodfood_confectionfilmproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_confectionfilmproduct (
    id bigint NOT NULL,
    confectionprotocol_id bigint,
    filmproduct_id bigint,
    beyondrecipe boolean DEFAULT false,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_confectionfilmproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_confectionfilmproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_confectionfilmproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_confectionfilmproduct_id_seq OWNED BY public.arch_goodfood_confectionfilmproduct.id;


--
-- Name: arch_goodfood_confectionfilmproductentry; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_confectionfilmproductentry (
    id bigint NOT NULL,
    batch_id bigint,
    confectionfilmproduct_id bigint,
    takenonquantity numeric(12,5),
    takenofquantity numeric(12,5),
    cullquantity numeric(12,5),
    effectivequantity numeric(12,5),
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_confectionfilmproductentry_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_confectionfilmproductentry_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_confectionfilmproductentry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_confectionfilmproductentry_id_seq OWNED BY public.arch_goodfood_confectionfilmproductentry.id;


--
-- Name: arch_goodfood_confectioninputproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_confectioninputproduct (
    id bigint NOT NULL,
    confectionprotocol_id bigint,
    batch_id bigint,
    product_id bigint,
    takenonquantity numeric(12,5),
    takenofquantity numeric(12,5),
    cullquantity numeric(12,5),
    effectivequantity numeric(12,5),
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_confectioninputproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_confectioninputproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_confectioninputproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_confectioninputproduct_id_seq OWNED BY public.arch_goodfood_confectioninputproduct.id;


--
-- Name: arch_goodfood_confectionprotocol; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_confectionprotocol (
    id bigint NOT NULL,
    generationdate date,
    state character varying(255) DEFAULT '01draft'::character varying,
    laststatechangefails boolean DEFAULT false,
    confectioncontext_id bigint,
    number character varying(1024),
    dayofshiftstart date,
    productionline_id bigint,
    toproduce numeric(12,5),
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    order_id bigint,
    ordernumber character varying(255),
    productnameandnumber character varying(255),
    qcp5code character varying(255),
    filmproduct_id bigint,
    restoneofcartonsquantity numeric(12,5),
    resttwoofcartonsquantity numeric(12,5),
    allpalletquantity numeric(12,5),
    quantityofallcartonsquantity numeric(12,5),
    wastewafers numeric(12,5),
    effectiveproducedquantity numeric(12,5),
    effectiveexecutiontimestart timestamp without time zone,
    effectiveexecutiontimeend timestamp without time zone,
    externalnumber integer NOT NULL,
    externalsynchronized boolean DEFAULT true,
    active boolean DEFAULT true,
    laststatechangefailcause character varying(8192),
    showlaststatechangeresult boolean DEFAULT false,
    isdoubled boolean DEFAULT false,
    additionalfilmproduct_id bigint,
    iscorrected boolean DEFAULT false,
    productiondate date,
    entityversion bigint DEFAULT 0,
    comments text,
    sendagaintoblackbox boolean DEFAULT false,
    finalprotocol boolean,
    plannextorderinfo character varying(8192),
    plannextorderinfoargs character varying(8192),
    plannextorderstatechangeinfo character varying,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_confectionprotocol_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_confectionprotocol_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_confectionprotocol_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_confectionprotocol_id_seq OWNED BY public.arch_goodfood_confectionprotocol.id;


--
-- Name: arch_goodfood_confectionprotocolcorrect; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_confectionprotocolcorrect (
    id bigint NOT NULL,
    confectionprotocol_id bigint,
    correctdate date,
    correctreason character varying(2048),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    isconfirmed boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_confectionprotocolcorrect_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_confectionprotocolcorrect_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_confectionprotocolcorrect_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_confectionprotocolcorrect_id_seq OWNED BY public.arch_goodfood_confectionprotocolcorrect.id;


--
-- Name: arch_goodfood_confectionprotocolstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_confectionprotocolstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    shift_id bigint,
    worker character varying(255),
    confectionprotocol_id bigint,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_confectionprotocolstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_confectionprotocolstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_confectionprotocolstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_confectionprotocolstatechange_id_seq OWNED BY public.arch_goodfood_confectionprotocolstatechange.id;


--
-- Name: arch_goodfood_confectionremainderinputproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_confectionremainderinputproduct (
    id bigint NOT NULL,
    confectionprotocol_id bigint,
    product_id bigint,
    usedquantity numeric(12,5),
    isdoubled boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    usedbatches text,
    beyondrecipe boolean DEFAULT false,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_confectionremainderinputproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_confectionremainderinputproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_confectionremainderinputproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_confectionremainderinputproduct_id_seq OWNED BY public.arch_goodfood_confectionremainderinputproduct.id;


--
-- Name: arch_goodfood_confectionstaff; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_confectionstaff (
    id bigint NOT NULL,
    confectionprotocol_id bigint,
    worker_id bigint,
    labortime integer,
    effectiveexecutiontimestart timestamp without time zone,
    effectiveexecutiontimeend timestamp without time zone,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_confectionstaff_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_confectionstaff_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_confectionstaff_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_confectionstaff_id_seq OWNED BY public.arch_goodfood_confectionstaff.id;


--
-- Name: arch_goodfood_extrusionaddedmixentry; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_extrusionaddedmixentry (
    id bigint NOT NULL,
    extrusionprotocol_id bigint,
    quantity numeric(9,2),
    entityversion bigint DEFAULT 0,
    extrusionmix_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_extrusionaddedmixentry_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_extrusionaddedmixentry_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_extrusionaddedmixentry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_extrusionaddedmixentry_id_seq OWNED BY public.arch_goodfood_extrusionaddedmixentry.id;


--
-- Name: arch_goodfood_extrusionaddedmixingredient; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_extrusionaddedmixingredient (
    id bigint NOT NULL,
    extrusionaddedmixentry_id bigint,
    extrusionmixingredient_id bigint,
    product_id bigint,
    batch_id bigint,
    quantity numeric(9,2),
    beyondrecipe boolean DEFAULT false,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_extrusionaddedmixingredient_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_extrusionaddedmixingredient_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_extrusionaddedmixingredient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_extrusionaddedmixingredient_id_seq OWNED BY public.arch_goodfood_extrusionaddedmixingredient.id;


--
-- Name: arch_goodfood_extrusionpouring; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_extrusionpouring (
    id bigint NOT NULL,
    extrusionprotocol_id bigint,
    finaladdedquantity numeric(9,2),
    addedquantity numeric(9,2),
    totalmixquantity numeric(12,5),
    addedquantitymanual boolean DEFAULT false,
    addedquantityrelatesto character varying(255) DEFAULT '01mix'::character varying,
    mixwaterquantity numeric(12,5),
    priority integer,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_extrusionpouring_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_extrusionpouring_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_extrusionpouring_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_extrusionpouring_id_seq OWNED BY public.arch_goodfood_extrusionpouring.id;


--
-- Name: arch_goodfood_extrusionpouringingredient; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_extrusionpouringingredient (
    id bigint NOT NULL,
    extrusionpouring_id bigint,
    product_id bigint,
    batch_id bigint,
    quantity numeric(9,2),
    ratio numeric(12,5),
    manual boolean DEFAULT false,
    skip boolean DEFAULT false,
    frommix boolean DEFAULT false,
    requiredquantity numeric(9,2),
    quantityinmix numeric(12,5),
    beyondrecipe boolean DEFAULT false,
    addedbyuser boolean DEFAULT false,
    extrusionpouringmix_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_extrusionpouringingredient_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_extrusionpouringingredient_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_extrusionpouringingredient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_extrusionpouringingredient_id_seq OWNED BY public.arch_goodfood_extrusionpouringingredient.id;


--
-- Name: arch_goodfood_extrusionpouringmix; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_extrusionpouringmix (
    id bigint NOT NULL,
    extrusionpouring_id bigint,
    mixid character varying(255),
    requiredscalequantity numeric(9,2),
    scalequantity numeric(9,2),
    scalequantitymanual boolean DEFAULT false,
    totalmixquantity numeric(12,5),
    mixwaterquantity numeric(12,5),
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_extrusionpouringmix_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_extrusionpouringmix_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_extrusionpouringmix_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_extrusionpouringmix_id_seq OWNED BY public.arch_goodfood_extrusionpouringmix.id;


--
-- Name: arch_goodfood_extrusionprotocol; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_extrusionprotocol (
    id bigint NOT NULL,
    generationdate date,
    state character varying(255) DEFAULT '01draft'::character varying,
    laststatechangefails boolean DEFAULT false,
    extrusioncontext_id bigint,
    number character varying(1024),
    dayofshiftstart date,
    productionline_id bigint,
    toproduce numeric(12,5),
    changeover integer,
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    numberofavailableworkstation integer,
    order_id bigint,
    ordernumber character varying(255),
    productnameandnumber character varying(255),
    mixproduct character varying(255),
    operatorworkstartdate timestamp without time zone,
    operatorworkfinishdate timestamp without time zone,
    externalnumber integer NOT NULL,
    externalsynchronized boolean DEFAULT true,
    active boolean DEFAULT true,
    laststatechangefailcause character varying(8192),
    showlaststatechangeresult boolean DEFAULT false,
    iscorrected boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    comments text,
    sendagaintoblackbox boolean DEFAULT false,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_extrusionprotocol_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_extrusionprotocol_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_extrusionprotocol_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_extrusionprotocol_id_seq OWNED BY public.arch_goodfood_extrusionprotocol.id;


--
-- Name: arch_goodfood_extrusionprotocolcorrect; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_extrusionprotocolcorrect (
    id bigint NOT NULL,
    extrusionprotocol_id bigint,
    correctdate date,
    correctreason character varying(2048),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    isconfirmed boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_extrusionprotocolcorrect_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_extrusionprotocolcorrect_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_extrusionprotocolcorrect_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_extrusionprotocolcorrect_id_seq OWNED BY public.arch_goodfood_extrusionprotocolcorrect.id;


--
-- Name: arch_goodfood_extrusionprotocolstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_extrusionprotocolstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    shift_id bigint,
    worker character varying(255),
    extrusionprotocol_id bigint,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_extrusionprotocolstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_extrusionprotocolstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_extrusionprotocolstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_extrusionprotocolstatechange_id_seq OWNED BY public.arch_goodfood_extrusionprotocolstatechange.id;


--
-- Name: arch_goodfood_extrusionsouse; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_extrusionsouse (
    id bigint NOT NULL,
    extrusionprotocol_id bigint,
    category character varying(255),
    datesouse timestamp without time zone,
    datedownload timestamp without time zone,
    worker_id bigint,
    wetness numeric(5,2),
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_extrusionsouse_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_extrusionsouse_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_extrusionsouse_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_extrusionsouse_id_seq OWNED BY public.arch_goodfood_extrusionsouse.id;


--
-- Name: arch_goodfood_extrusiontakenoffmixentry; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_extrusiontakenoffmixentry (
    id bigint NOT NULL,
    extrusionprotocol_id bigint,
    quantity numeric(9,2),
    entityversion bigint DEFAULT 0,
    extrusionmix_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_extrusiontakenoffmixentry_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_extrusiontakenoffmixentry_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_extrusiontakenoffmixentry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_extrusiontakenoffmixentry_id_seq OWNED BY public.arch_goodfood_extrusiontakenoffmixentry.id;


--
-- Name: arch_goodfood_extrusiontakenoffmixingredient; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_extrusiontakenoffmixingredient (
    id bigint NOT NULL,
    extrusiontakenoffmixentry_id bigint,
    extrusionmixingredient_id bigint,
    product_id bigint,
    batch_id bigint,
    quantity numeric(9,2),
    beyondrecipe boolean DEFAULT false,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_extrusiontakenoffmixingredient_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_extrusiontakenoffmixingredient_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_extrusiontakenoffmixingredient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_extrusiontakenoffmixingredient_id_seq OWNED BY public.arch_goodfood_extrusiontakenoffmixingredient.id;


--
-- Name: arch_goodfood_pallet; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_pallet (
    id bigint NOT NULL,
    palletcontext_id bigint,
    palletlabel_id bigint,
    typeoflogistics character varying(255) DEFAULT '01fullPallet'::character varying,
    printedcount integer,
    ssccnumber character varying(20),
    palletnumber character varying(6),
    secondpallet_id bigint,
    state character varying(255),
    isstateerror boolean,
    stateerror character varying(255),
    registrationdate timestamp without time zone,
    senddate timestamp without time zone,
    active boolean DEFAULT true,
    packagescount integer,
    laststatechangefails boolean DEFAULT false,
    laststatechangefailcause character varying(2048),
    externalnumber integer NOT NULL,
    externalsynchronized boolean DEFAULT true,
    eurocod character varying(7),
    entityversion bigint DEFAULT 0,
    sendagaintoblackbox boolean DEFAULT false,
    product_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_pallet_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_pallet_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_pallet_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_pallet_id_seq OWNED BY public.arch_goodfood_pallet.id;


--
-- Name: arch_goodfood_palletlabel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_palletlabel (
    id bigint NOT NULL,
    palletcontext_id bigint,
    printedcount integer,
    firstssccnumber character varying(20),
    firstpalletnumber character varying(6),
    lastssccnumber character varying(20),
    lastpalletnumber character varying(6),
    masterorder_id bigint,
    productionline_id bigint,
    batchnumber character varying(255),
    bestbefore character varying(255),
    registrationdate date,
    active boolean DEFAULT true,
    batch_id bigint,
    state character varying(255) DEFAULT '01draft'::character varying,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_palletlabel_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_palletlabel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_palletlabel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_palletlabel_id_seq OWNED BY public.arch_goodfood_palletlabel.id;


--
-- Name: arch_goodfood_palletlabelstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_palletlabelstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    shift_id bigint,
    worker character varying(255),
    palletlabel_id bigint,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_palletlabelstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_palletlabelstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_palletlabelstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_palletlabelstatechange_id_seq OWNED BY public.arch_goodfood_palletlabelstatechange.id;


--
-- Name: arch_goodfood_palletstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_palletstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    shift_id bigint,
    worker character varying(255),
    pallet_id bigint,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_palletstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_palletstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_palletstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_palletstatechange_id_seq OWNED BY public.arch_goodfood_palletstatechange.id;


--
-- Name: arch_goodfood_printedlabel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_goodfood_printedlabel (
    id bigint NOT NULL,
    cartonlabel character varying(255),
    masterorder_id bigint,
    ssccnumber character varying(1024),
    palletcontext_id bigint,
    productionline_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    active boolean DEFAULT true,
    archived boolean DEFAULT false
);


--
-- Name: arch_goodfood_printedlabel_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_goodfood_printedlabel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_goodfood_printedlabel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_goodfood_printedlabel_id_seq OWNED BY public.arch_goodfood_printedlabel.id;


--
-- Name: arch_integrationbartender_printlabelshelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_integrationbartender_printlabelshelper (
    id bigint NOT NULL,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    quantity integer,
    masterorder_id bigint,
    printer_id bigint,
    path character varying(255),
    ssccnumbers text,
    order_id bigint,
    barcodeismasterorderid boolean DEFAULT false,
    archived boolean DEFAULT false
);


--
-- Name: arch_integrationbartender_printlabelshelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_integrationbartender_printlabelshelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_integrationbartender_printlabelshelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_integrationbartender_printlabelshelper_id_seq OWNED BY public.arch_integrationbartender_printlabelshelper.id;


--
-- Name: arch_integrationbartender_sendtoprint; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_integrationbartender_sendtoprint (
    id bigint NOT NULL,
    printlabelshelper_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_integrationbartender_sendtoprint_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_integrationbartender_sendtoprint_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_integrationbartender_sendtoprint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_integrationbartender_sendtoprint_id_seq OWNED BY public.arch_integrationbartender_sendtoprint.id;


--
-- Name: arch_masterorders_masterorder; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_masterorders_masterorder (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    description character varying(2048),
    externalnumber character varying(255),
    deadline timestamp without time zone,
    addmasterprefixtonumber boolean,
    masterorderstate character varying(255),
    company_id bigint,
    externalsynchronized boolean DEFAULT true,
    generationdateoneec date,
    cancelsynchronizationreason character varying(255),
    active boolean DEFAULT true,
    pw2prod boolean DEFAULT false,
    batch_id bigint,
    masterorderdefinition_id bigint,
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    entityversion bigint DEFAULT 0,
    sendagaintoblackbox boolean DEFAULT false,
    dateofreceipt timestamp without time zone,
    address_id bigint,
    externalproductionorderid character varying(255),
    ponumber character varying(255),
    direction character varying(255),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying,
    updateuser character varying,
    deliverynotenumber character varying,
    cancelsynchronizationtype character varying,
    companypayer_id bigint,
    productioncode character varying,
    commissionnumber character varying,
    machinetype character varying,
    pipedriveupdate timestamp without time zone,
    state character varying(255) DEFAULT '01new'::character varying,
    asanataskid character varying,
    asanatasknameupdated boolean DEFAULT false,
    asanataskcommentadded boolean DEFAULT false,
    sendagaintoasana boolean DEFAULT false,
    sendagaintoasanatries integer DEFAULT 0,
    asanastatecompleteddate timestamp without time zone,
    colourral character varying(255),
    salesplan_id bigint,
    materialsissued boolean DEFAULT false,
    warehouseorder boolean DEFAULT false,
    synchronize boolean DEFAULT false,
    synchronizationdate timestamp without time zone,
    archived boolean DEFAULT false
);


--
-- Name: arch_masterorders_masterorder_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_masterorders_masterorder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_masterorders_masterorder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_masterorders_masterorder_id_seq OWNED BY public.arch_masterorders_masterorder.id;


--
-- Name: arch_masterorders_masterorderposition_manyproducts; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.arch_masterorders_masterorderposition_manyproducts AS
SELECT
    NULL::bigint AS id,
    NULL::character varying(255) AS masterorderdefinitionnumber,
    NULL::integer AS masterorderid,
    NULL::integer AS productid,
    NULL::integer AS masterorderproductid,
    NULL::character varying(1024) AS name,
    NULL::character varying(255) AS number,
    NULL::timestamp without time zone AS deadline,
    NULL::character varying(255) AS masterorderstatus,
    NULL::character varying(255) AS masterorderpositionstatus,
    NULL::numeric AS masterorderquantity,
    NULL::numeric AS cumulatedmasterorderquantity,
    NULL::numeric AS producedorderquantity,
    NULL::numeric AS lefttorelease,
    NULL::text AS comments,
    NULL::character varying(255) AS productnumber,
    NULL::character varying(1024) AS productname,
    NULL::character varying(255) AS unit,
    NULL::character varying(255) AS technologyname,
    NULL::character varying(255) AS companyname,
    NULL::boolean AS active,
    NULL::character varying(255) AS companypayer,
    NULL::character varying(255) AS assortmentname,
    NULL::character varying(255) AS state,
    NULL::character varying(2048) AS description;


--
-- Name: arch_mv_masterorders_masterorderpositiondto; Type: MATERIALIZED VIEW; Schema: public; Owner: -
--

CREATE MATERIALIZED VIEW public.arch_mv_masterorders_masterorderpositiondto AS
 SELECT masterorders_masterorderposition_manyproducts.id,
    masterorders_masterorderposition_manyproducts.masterorderdefinitionnumber,
    masterorders_masterorderposition_manyproducts.masterorderid,
    masterorders_masterorderposition_manyproducts.productid,
    masterorders_masterorderposition_manyproducts.masterorderproductid,
    masterorders_masterorderposition_manyproducts.name,
    masterorders_masterorderposition_manyproducts.number,
    masterorders_masterorderposition_manyproducts.deadline,
    masterorders_masterorderposition_manyproducts.masterorderstatus,
    masterorders_masterorderposition_manyproducts.masterorderpositionstatus,
    masterorders_masterorderposition_manyproducts.masterorderquantity,
    masterorders_masterorderposition_manyproducts.cumulatedmasterorderquantity,
    masterorders_masterorderposition_manyproducts.producedorderquantity,
    masterorders_masterorderposition_manyproducts.lefttorelease,
    masterorders_masterorderposition_manyproducts.comments,
    masterorders_masterorderposition_manyproducts.productnumber,
    masterorders_masterorderposition_manyproducts.productname,
    masterorders_masterorderposition_manyproducts.unit,
    masterorders_masterorderposition_manyproducts.technologyname,
    masterorders_masterorderposition_manyproducts.companyname,
    masterorders_masterorderposition_manyproducts.active,
    masterorders_masterorderposition_manyproducts.companypayer,
    masterorders_masterorderposition_manyproducts.assortmentname,
    masterorders_masterorderposition_manyproducts.state,
    masterorders_masterorderposition_manyproducts.description
   FROM public.arch_masterorders_masterorderposition_manyproducts masterorders_masterorderposition_manyproducts
  WITH NO DATA;


--
-- Name: arch_masterorders_masterorderpositiondto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.arch_masterorders_masterorderpositiondto AS
 SELECT arch_mv_masterorders_masterorderpositiondto.id,
    arch_mv_masterorders_masterorderpositiondto.masterorderdefinitionnumber,
    arch_mv_masterorders_masterorderpositiondto.masterorderid,
    arch_mv_masterorders_masterorderpositiondto.productid,
    arch_mv_masterorders_masterorderpositiondto.masterorderproductid,
    arch_mv_masterorders_masterorderpositiondto.name,
    arch_mv_masterorders_masterorderpositiondto.number,
    arch_mv_masterorders_masterorderpositiondto.deadline,
    arch_mv_masterorders_masterorderpositiondto.masterorderstatus,
    arch_mv_masterorders_masterorderpositiondto.masterorderpositionstatus,
    arch_mv_masterorders_masterorderpositiondto.masterorderquantity,
    arch_mv_masterorders_masterorderpositiondto.cumulatedmasterorderquantity,
    arch_mv_masterorders_masterorderpositiondto.producedorderquantity,
    arch_mv_masterorders_masterorderpositiondto.lefttorelease,
    arch_mv_masterorders_masterorderpositiondto.comments,
    arch_mv_masterorders_masterorderpositiondto.productnumber,
    arch_mv_masterorders_masterorderpositiondto.productname,
    arch_mv_masterorders_masterorderpositiondto.unit,
    arch_mv_masterorders_masterorderpositiondto.technologyname,
    arch_mv_masterorders_masterorderpositiondto.companyname,
    arch_mv_masterorders_masterorderpositiondto.active,
    arch_mv_masterorders_masterorderpositiondto.companypayer,
    arch_mv_masterorders_masterorderpositiondto.assortmentname,
    arch_mv_masterorders_masterorderpositiondto.state,
    arch_mv_masterorders_masterorderpositiondto.description
   FROM public.arch_mv_masterorders_masterorderpositiondto;


--
-- Name: basic_company; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_company (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(255) DEFAULT 'Company'::character varying,
    taxcountrycode_id bigint,
    tax character varying(255),
    street character varying(255),
    house character varying(30),
    flat character varying(30),
    zipcode character varying(255),
    city character varying(255),
    state character varying(255),
    country_id bigint,
    email character varying(255),
    website character varying(255),
    phone character varying(255),
    externalnumber character varying(255),
    buffer integer,
    active boolean DEFAULT true,
    paymentform character varying(255),
    country character varying(255),
    entityversion bigint DEFAULT 0,
    contactperson character varying(255),
    issupplier boolean DEFAULT false,
    isreceiver boolean DEFAULT false,
    logoimage character varying(255),
    currency_id bigint,
    contractorcategory character varying(255),
    abcanalysis character varying(255)
);


--
-- Name: masterorders_masterorderdefinition; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_masterorderdefinition (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    parameter_id bigint,
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0
);


--
-- Name: arch_mv_masterorders_masterorderdto; Type: MATERIALIZED VIEW; Schema: public; Owner: -
--

CREATE MATERIALIZED VIEW public.arch_mv_masterorders_masterorderdto AS
 SELECT masterorder.id,
    masterorderdefinition.number AS masterorderdefinitionnumber,
    masterorder.number,
    masterorder.name,
    masterorder.deadline,
    company.number AS company,
    companypayer.number AS companypayer,
    COALESCE((orderedpositions.count)::integer, 0) AS orderedpositionquantity,
    COALESCE((cumulatedpositions.count)::integer, 0) AS commissionedpositionquantity,
    (COALESCE((orderedpositions.count)::integer, 0) - COALESCE((cumulatedpositions.count)::integer, 0)) AS quantityforcommission,
    masterorder.masterorderstate,
    masterorder.active,
    masterorder.pipedriveupdate,
    masterorder.state,
    masterorder.externalnumber,
    masterorder.asanataskid,
    masterorder.description
   FROM (((((public.arch_masterorders_masterorder masterorder
     LEFT JOIN public.masterorders_masterorderdefinition masterorderdefinition ON ((masterorderdefinition.id = masterorder.masterorderdefinition_id)))
     LEFT JOIN public.basic_company company ON ((company.id = masterorder.company_id)))
     LEFT JOIN public.basic_company companypayer ON ((companypayer.id = masterorder.companypayer_id)))
     LEFT JOIN ( SELECT arch_masterorders_masterorderpositiondto.masterorderid,
            count(*) AS count
           FROM public.arch_masterorders_masterorderpositiondto
          GROUP BY arch_masterorders_masterorderpositiondto.masterorderid) orderedpositions ON ((orderedpositions.masterorderid = masterorder.id)))
     LEFT JOIN ( SELECT arch_masterorders_masterorderpositiondto.masterorderid,
            count(*) AS count
           FROM public.arch_masterorders_masterorderpositiondto
          WHERE (arch_masterorders_masterorderpositiondto.cumulatedmasterorderquantity > (0)::numeric)
          GROUP BY arch_masterorders_masterorderpositiondto.masterorderid) cumulatedpositions ON ((cumulatedpositions.masterorderid = masterorder.id)))
  WITH NO DATA;


--
-- Name: arch_masterorders_masterorderdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.arch_masterorders_masterorderdto AS
 SELECT arch_mv_masterorders_masterorderdto.id,
    arch_mv_masterorders_masterorderdto.masterorderdefinitionnumber,
    arch_mv_masterorders_masterorderdto.number,
    arch_mv_masterorders_masterorderdto.name,
    arch_mv_masterorders_masterorderdto.deadline,
    arch_mv_masterorders_masterorderdto.company,
    arch_mv_masterorders_masterorderdto.companypayer,
    arch_mv_masterorders_masterorderdto.orderedpositionquantity,
    arch_mv_masterorders_masterorderdto.commissionedpositionquantity,
    arch_mv_masterorders_masterorderdto.quantityforcommission,
    arch_mv_masterorders_masterorderdto.masterorderstate,
    arch_mv_masterorders_masterorderdto.active,
    arch_mv_masterorders_masterorderdto.pipedriveupdate,
    arch_mv_masterorders_masterorderdto.state,
    arch_mv_masterorders_masterorderdto.externalnumber,
    arch_mv_masterorders_masterorderdto.asanataskid,
    arch_mv_masterorders_masterorderdto.description
   FROM public.arch_mv_masterorders_masterorderdto;


--
-- Name: arch_masterorders_masterorderdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_masterorders_masterorderdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_masterorders_masterorderposition_manyproducts_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_masterorders_masterorderposition_manyproducts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_masterorders_masterorderpositiondto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_masterorders_masterorderpositiondto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_masterorders_masterorderproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_masterorders_masterorderproduct (
    id bigint NOT NULL,
    product_id bigint,
    technology_id bigint,
    masterorder_id bigint,
    masterorderquantity numeric(14,5),
    cumulatedorderquantity numeric(14,5),
    producedorderquantity numeric(14,5),
    entityversion bigint DEFAULT 0,
    lefttorelease numeric(14,5),
    comments text,
    masterorderpositionstatus character varying(255),
    quantitytakenfromwarehouse numeric(14,5),
    quantityremainingtoorder numeric(14,5),
    deliverydate timestamp without time zone,
    line character varying(255),
    vendorinfo character varying(255),
    vendorso character varying(255),
    price numeric(14,5),
    priceslistprice numeric(9,2),
    archived boolean DEFAULT false
);


--
-- Name: arch_masterorders_masterorderproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_masterorders_masterorderproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_masterorders_masterorderproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_masterorders_masterorderproduct_id_seq OWNED BY public.arch_masterorders_masterorderproduct.id;


--
-- Name: arch_masterorders_masterorderproductattrvalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_masterorders_masterorderproductattrvalue (
    id bigint NOT NULL,
    masterorderproduct_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255),
    succession integer,
    archived boolean DEFAULT false
);


--
-- Name: arch_masterorders_masterorderproductattrvalue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_masterorders_masterorderproductattrvalue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_masterorders_masterorderproductattrvalue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_masterorders_masterorderproductattrvalue_id_seq OWNED BY public.arch_masterorders_masterorderproductattrvalue.id;


--
-- Name: arch_masterorders_productsbysizeentryhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_masterorders_productsbysizeentryhelper (
    id bigint NOT NULL,
    size_id bigint,
    productsbysizehelper_id bigint,
    quantity numeric(12,5),
    product_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_masterorders_productsbysizeentryhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_masterorders_productsbysizeentryhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_masterorders_productsbysizeentryhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_masterorders_productsbysizeentryhelper_id_seq OWNED BY public.arch_masterorders_productsbysizeentryhelper.id;


--
-- Name: arch_masterorders_productsbysizehelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_masterorders_productsbysizehelper (
    id bigint NOT NULL,
    product_id bigint,
    totalquantity numeric(12,5),
    masterorder_id bigint,
    salesplan_id bigint,
    ordersgroup_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_masterorders_productsbysizehelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_masterorders_productsbysizehelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_masterorders_productsbysizehelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_masterorders_productsbysizehelper_id_seq OWNED BY public.arch_masterorders_productsbysizehelper.id;


--
-- Name: arch_materialflowresources_document; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_materialflowresources_document (
    id bigint NOT NULL,
    number character varying(255) NOT NULL,
    type character varying(255) NOT NULL,
    "time" timestamp without time zone,
    state character varying(255) DEFAULT '01draft'::character varying,
    locationfrom_id bigint,
    locationto_id bigint,
    user_id bigint,
    delivery_id bigint,
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    order_id bigint,
    description character varying(2048),
    suborder_id bigint,
    company_id bigint,
    maintenanceevent_id bigint,
    entityversion bigint DEFAULT 0,
    plannedevent_id bigint,
    name character varying(255) NOT NULL,
    createlinkeddocument boolean,
    linkeddocumentlocation_id bigint,
    address_id bigint,
    dispositionshift_id bigint,
    positionsfile character varying,
    printed boolean DEFAULT false,
    generationdate timestamp without time zone,
    filename character varying(255),
    acceptationinprogress boolean DEFAULT false,
    externalnumber character varying(255),
    issend boolean DEFAULT false,
    wms boolean DEFAULT false,
    datesendtowms timestamp without time zone,
    stateinwms character varying(255),
    pickingworker character varying(255),
    dateconfirmationofcompletion timestamp without time zone,
    locationchanged boolean DEFAULT false,
    editinwms boolean DEFAULT true,
    staff_id bigint,
    ordersgroup_id bigint,
    invoicenumber character varying(2048),
    archived boolean DEFAULT false
);


--
-- Name: arch_materialflowresources_document_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_materialflowresources_document_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_materialflowresources_document_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_materialflowresources_document_id_seq OWNED BY public.arch_materialflowresources_document.id;


--
-- Name: arch_orders_order; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_order (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    description character varying(2048),
    commentreasontypecorrectiondatefrom character varying(255),
    commentreasontypecorrectiondateto character varying(255),
    commentreasondeviationeffectivestart character varying(255),
    commentreasondeviationeffectiveend character varying(255),
    externalnumber character varying(255),
    commentreasontypedeviationsquantity character varying(255),
    datefrom timestamp without time zone,
    dateto timestamp without time zone,
    effectivedatefrom timestamp without time zone,
    effectivedateto timestamp without time zone,
    deadline timestamp without time zone,
    correcteddatefrom timestamp without time zone,
    correcteddateto timestamp without time zone,
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    state character varying(255),
    company_id bigint,
    product_id bigint,
    technology_id bigint,
    productionline_id bigint,
    plannedquantity numeric(12,5),
    donequantity numeric(12,5),
    externalsynchronized boolean DEFAULT true,
    commissionedplannedquantity numeric(12,5),
    commissionedcorrectedquantity numeric(12,5),
    amountofproductproduced numeric(12,5),
    remainingamountofproducttoproduce numeric(12,5),
    ownlinechangeoverduration integer,
    registerproductiontime boolean,
    registerquantityinproduct boolean,
    laborworktime integer,
    includetpz boolean,
    inputproductsrequiredfortype character varying(255),
    generatedenddate timestamp without time zone,
    machineworktime integer,
    ownlinechangeover boolean DEFAULT false,
    registerquantityoutproduct boolean,
    operationdurationquantityunit character varying(255),
    realizationtime integer,
    calculate boolean,
    includeadditionaltime boolean,
    typeofproductionrecording character varying(255) DEFAULT '02cumulated'::character varying,
    masterorder_id bigint,
    active boolean DEFAULT true,
    productpriceperunit numeric(19,5),
    failuresyncmessage character varying(255),
    targetstate character varying(255),
    ignorerequiredcomponents boolean,
    automaticallymoveoverusage boolean DEFAULT false,
    updatecomponentsavailability boolean,
    technologyprototype_id bigint,
    level integer,
    parent_id bigint,
    ignoremissingcomponents boolean DEFAULT false,
    masterorderproduct_id bigint,
    dateschanged boolean DEFAULT false,
    sourcecorrecteddatefrom timestamp without time zone,
    sourcecorrecteddateto timestamp without time zone,
    sourcestartdate timestamp without time zone,
    sourcefinishdate timestamp without time zone,
    batchnumber character varying(255),
    root_id bigint,
    includeordersforcomponent boolean,
    plannedfinishallorders timestamp without time zone,
    plannedstartallorders timestamp without time zone,
    calculatedfinishallorders timestamp without time zone,
    registerfilled boolean,
    workplandelivered boolean DEFAULT false,
    calculatedstartallorders timestamp without time zone,
    scadacreatedorupdatestate character varying(255),
    entityversion bigint DEFAULT 0,
    workertochange character varying(255),
    masterorderproductcomponent_id bigint,
    wastesquantity numeric(12,5),
    existsrepairorders boolean DEFAULT false,
    ordercategory character varying(255),
    address_id bigint,
    finalproductiontracking boolean DEFAULT false,
    updatefinishdate boolean DEFAULT false,
    ordersgroup_id bigint,
    plannedquantityforadditionalunit numeric,
    division_id bigint,
    salesplan_id bigint,
    reportedproductionquantity numeric(12,5),
    expirationdate date,
    additionalfinalproducts character varying(255),
    optimizecuttingsolution text,
    vendorinfo character varying(255),
    priority integer DEFAULT 100,
    archived boolean DEFAULT false
);


--
-- Name: basic_address; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_address (
    id bigint NOT NULL,
    company_id bigint,
    addresstype character varying(255),
    number character varying(255),
    name character varying(255),
    phone character varying(255),
    email character varying(255),
    website character varying(255),
    street character varying(255),
    house character varying(30),
    flat character varying(30),
    zipcode character varying(255),
    city character varying(255),
    state character varying(255),
    country_id bigint,
    contactperson character varying(255),
    canbedeleted boolean DEFAULT false,
    active boolean DEFAULT true,
    externalnumber character varying(255)
);


--
-- Name: cmmsmachineparts_maintenanceevent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_maintenanceevent (
    id bigint NOT NULL,
    number character varying(255) NOT NULL,
    type character varying(255) DEFAULT '01failure'::character varying,
    description character varying(600),
    personreceiving_id bigint,
    personreceivingname character varying(255),
    state character varying(255) DEFAULT '01new'::character varying,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    factory_id bigint,
    division_id bigint,
    productionline_id bigint,
    workstation_id bigint,
    subassembly_id bigint,
    faulttype_id bigint,
    solutiondescription text,
    maintenanceeventcontext_id bigint,
    entityversion bigint DEFAULT 0,
    sourcecost_id bigint,
    soundnotifications boolean DEFAULT false,
    highestpriority boolean DEFAULT false,
    reportingemployee_id bigint
);


--
-- Name: cmmsmachineparts_plannedevent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_plannedevent (
    id bigint NOT NULL,
    number character varying(255),
    type character varying(255) DEFAULT '01review'::character varying,
    description character varying(600),
    owner_id bigint,
    ownername character varying(255),
    state character varying(255) DEFAULT '01new'::character varying,
    factory_id bigint,
    division_id bigint,
    productionline_id bigint,
    workstation_id bigint,
    subassembly_id bigint,
    plannedeventcontext_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    plannedseparately boolean DEFAULT false,
    afterreview boolean DEFAULT false,
    requiresshutdown boolean DEFAULT false,
    company_id bigint,
    basedon character varying(255) DEFAULT '01date'::character varying,
    date date,
    counter numeric(14,5),
    countertolerance numeric(14,5),
    duration integer DEFAULT 0,
    effectiveduration integer DEFAULT 0,
    effectivecounter numeric(14,5),
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    isdeadline boolean,
    solutiondescription text,
    entityversion bigint DEFAULT 0,
    maintenanceevent_id bigint,
    sourcecost_id bigint,
    recurringevent_id bigint
);


--
-- Name: deliveries_delivery; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.deliveries_delivery (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    description character varying(2048),
    supplier_id bigint,
    deliverydate timestamp without time zone,
    deliveryaddress character varying(2048),
    relateddelivery_id bigint,
    currency_id bigint,
    externalnumber character varying(255),
    externalsynchronized boolean DEFAULT true,
    state character varying(255),
    location_id bigint,
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    synchronizationstatus character varying(255),
    entityversion bigint DEFAULT 0,
    paymentform character varying(255),
    salesplan_id bigint,
    wms boolean DEFAULT false,
    stateinwms character varying(255),
    datesendtowms timestamp without time zone,
    pickingworker character varying(255),
    dateconfirmationofcompletion timestamp without time zone
);


--
-- Name: materialflow_location; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflow_location (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(255),
    externalnumber character varying(255),
    algorithm character varying(255) DEFAULT '01fifo'::character varying,
    requireprice boolean,
    requirebatch boolean,
    requireproductiondate boolean,
    requireexpirationdate boolean,
    entityversion bigint DEFAULT 0,
    warehousenumberinoptima character varying(255),
    draftmakesreservation boolean DEFAULT false,
    realizationlocation_id bigint,
    active boolean DEFAULT true
);


--
-- Name: qcadoosecurity_user; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadoosecurity_user (
    id bigint NOT NULL,
    username character varying(255),
    email character varying(255),
    firstname character varying(255),
    lastname character varying(255),
    enabled boolean DEFAULT true,
    description character varying(255),
    password character varying(255),
    lastactivity timestamp without time zone,
    staff_id bigint,
    group_id bigint,
    entityversion bigint DEFAULT 0,
    factory_id bigint,
    ipaddress character varying,
    showonlymyregistrationrecords boolean DEFAULT false,
    productionline_id bigint,
    groupchangedate timestamp without time zone,
    pswdlastchanged timestamp without time zone,
    afterfirstpswdchange boolean DEFAULT false,
    isblocked boolean DEFAULT false,
    showonlymyoperationaltasksandorders boolean DEFAULT false
);


--
-- Name: subcontractorportal_suborder; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.subcontractorportal_suborder (
    id bigint NOT NULL,
    number character varying(255),
    ordernumber character varying(255),
    description text,
    datefrom timestamp without time zone,
    dateto timestamp without time zone,
    state character varying(255),
    company_id bigint,
    active boolean DEFAULT true,
    changedby_id bigint,
    hasoperations boolean DEFAULT false,
    entityversion bigint DEFAULT 0
);


--
-- Name: arch_mv_materialflowresources_documentdto; Type: MATERIALIZED VIEW; Schema: public; Owner: -
--

CREATE MATERIALIZED VIEW public.arch_mv_materialflowresources_documentdto AS
 SELECT document.id,
    document.number,
    document.description,
    document.name,
    document.type,
    document."time",
    document.state,
    document.active,
    (locationfrom.id)::integer AS locationfrom_id,
    locationfrom.number AS locationfromnumber,
    (locationto.id)::integer AS locationto_id,
    locationto.number AS locationtonumber,
    (company.id)::integer AS company_id,
    company.name AS companyname,
        CASE
            WHEN (address.name IS NULL) THEN (address.number)::text
            ELSE (((address.number)::text || ' - '::text) || (address.name)::text)
        END AS documentaddress,
    (securityuser.id)::integer AS user_id,
    (((securityuser.firstname)::text || ' '::text) || (securityuser.lastname)::text) AS username,
    (maintenanceevent.id)::integer AS maintenanceevent_id,
    maintenanceevent.number AS maintenanceeventnumber,
    (plannedevent.id)::integer AS plannedevent_id,
    plannedevent.number AS plannedeventnumber,
    (delivery.id)::integer AS delivery_id,
    delivery.number AS deliverynumber,
    (ordersorder.id)::integer AS order_id,
    ordersorder.number AS ordernumber,
    (suborder.id)::integer AS suborder_id,
    suborder.number AS subordernumber
   FROM ((((((((((public.arch_materialflowresources_document document
     LEFT JOIN public.materialflow_location locationfrom ON ((locationfrom.id = document.locationfrom_id)))
     LEFT JOIN public.materialflow_location locationto ON ((locationto.id = document.locationto_id)))
     LEFT JOIN public.basic_company company ON ((company.id = document.company_id)))
     LEFT JOIN public.basic_address address ON ((address.id = document.address_id)))
     LEFT JOIN public.qcadoosecurity_user securityuser ON ((securityuser.id = document.user_id)))
     LEFT JOIN public.cmmsmachineparts_maintenanceevent maintenanceevent ON ((maintenanceevent.id = document.maintenanceevent_id)))
     LEFT JOIN public.cmmsmachineparts_plannedevent plannedevent ON ((plannedevent.id = document.plannedevent_id)))
     LEFT JOIN public.deliveries_delivery delivery ON ((delivery.id = document.delivery_id)))
     LEFT JOIN public.arch_orders_order ordersorder ON ((ordersorder.id = document.order_id)))
     LEFT JOIN public.subcontractorportal_suborder suborder ON ((suborder.id = document.suborder_id)))
  WITH NO DATA;


--
-- Name: arch_materialflowresources_documentdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.arch_materialflowresources_documentdto AS
 SELECT arch_mv_materialflowresources_documentdto.id,
    arch_mv_materialflowresources_documentdto.number,
    arch_mv_materialflowresources_documentdto.description,
    arch_mv_materialflowresources_documentdto.name,
    arch_mv_materialflowresources_documentdto.type,
    arch_mv_materialflowresources_documentdto."time",
    arch_mv_materialflowresources_documentdto.state,
    arch_mv_materialflowresources_documentdto.active,
    arch_mv_materialflowresources_documentdto.locationfrom_id,
    arch_mv_materialflowresources_documentdto.locationfromnumber,
    arch_mv_materialflowresources_documentdto.locationto_id,
    arch_mv_materialflowresources_documentdto.locationtonumber,
    arch_mv_materialflowresources_documentdto.company_id,
    arch_mv_materialflowresources_documentdto.companyname,
    arch_mv_materialflowresources_documentdto.documentaddress,
    arch_mv_materialflowresources_documentdto.user_id,
    arch_mv_materialflowresources_documentdto.username,
    arch_mv_materialflowresources_documentdto.maintenanceevent_id,
    arch_mv_materialflowresources_documentdto.maintenanceeventnumber,
    arch_mv_materialflowresources_documentdto.plannedevent_id,
    arch_mv_materialflowresources_documentdto.plannedeventnumber,
    arch_mv_materialflowresources_documentdto.delivery_id,
    arch_mv_materialflowresources_documentdto.deliverynumber,
    arch_mv_materialflowresources_documentdto.order_id,
    arch_mv_materialflowresources_documentdto.ordernumber,
    arch_mv_materialflowresources_documentdto.suborder_id,
    arch_mv_materialflowresources_documentdto.subordernumber
   FROM public.arch_mv_materialflowresources_documentdto;


--
-- Name: arch_materialflowresources_documentdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_materialflowresources_documentdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_materialflowresources_documentstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_materialflowresources_documentstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    document_id bigint,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    worker character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_materialflowresources_documentstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_materialflowresources_documentstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_materialflowresources_documentstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_materialflowresources_documentstatechange_id_seq OWNED BY public.arch_materialflowresources_documentstatechange.id;


--
-- Name: arch_materialflowresources_position; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_materialflowresources_position (
    id bigint NOT NULL,
    document_id bigint,
    product_id bigint,
    quantity numeric(14,5),
    price numeric(12,5) DEFAULT (0)::numeric,
    productiondate date,
    expirationdate date,
    number integer,
    resource_id bigint,
    givenunit character varying(255),
    givenquantity numeric(14,5),
    entityversion bigint DEFAULT 0,
    storagelocation_id bigint,
    conversion numeric(12,5) DEFAULT (0)::numeric,
    palletnumber_id bigint,
    typeofpallet character varying(255),
    waste boolean DEFAULT false,
    resourcereceiptdocument character varying,
    lastresource boolean DEFAULT false,
    resourcenumber character varying(255),
    externaldocumentnumber character varying(255),
    orderid integer,
    sellingprice numeric(12,5) DEFAULT '0'::numeric,
    batch_id bigint,
    qualityrating character varying(255),
    pickingdate timestamp without time zone,
    pickingworker_id bigint,
    documentpart_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_materialflowresources_position_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_materialflowresources_position_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_materialflowresources_position_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_materialflowresources_position_id_seq OWNED BY public.arch_materialflowresources_position.id;


--
-- Name: arch_materialflowresources_positionattributevalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_materialflowresources_positionattributevalue (
    id bigint NOT NULL,
    position_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_materialflowresources_positionattributevalue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_materialflowresources_positionattributevalue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_materialflowresources_positionattributevalue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_materialflowresources_positionattributevalue_id_seq OWNED BY public.arch_materialflowresources_positionattributevalue.id;


--
-- Name: basic_palletnumber; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_palletnumber (
    id bigint NOT NULL,
    number character varying(6),
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    issuedatetime timestamp without time zone
);


--
-- Name: basic_product; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_product (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    globaltypeofmaterial character varying(255),
    ean character varying(255),
    category character varying(255),
    unit character varying(255),
    externalnumber character varying(255),
    description character varying(2048),
    parent_id bigint,
    entitytype character varying(255) DEFAULT '01particularProduct'::character varying,
    durabilityinmonths integer,
    averageoffercost numeric(12,5) DEFAULT (0)::numeric,
    costfornumber numeric(12,5) DEFAULT (1)::numeric,
    lastpurchasecost numeric(12,5) DEFAULT (0)::numeric,
    lastoffercost numeric(12,5) DEFAULT (0)::numeric,
    isglutenproduct boolean,
    symbol character varying(255),
    averagecost numeric(12,5) DEFAULT (0)::numeric,
    goodsgroup character varying(255),
    nominalcost numeric(12,5) DEFAULT (0)::numeric,
    bio character varying(255),
    isdoublepallet boolean,
    technologygroup_id bigint,
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    quantityofextrusioningredient integer DEFAULT 1,
    norm character varying(255),
    actualversion character varying(255),
    hasnutritionelements boolean DEFAULT false,
    quantityfornutritions numeric(12,0),
    quantityfornutritionsunit character varying(255),
    showinproductdata boolean DEFAULT false,
    doublequantityfordoublepallet boolean,
    usedquantitycontrol boolean DEFAULT false,
    automaticusedquantity boolean DEFAULT false,
    nominalweight numeric(12,5),
    countusedquantityforfullpallets boolean DEFAULT false,
    quantityinpackage integer,
    synchronize boolean,
    capacitynormfortwodimensionalmachines numeric(12,5),
    downform_id bigint,
    upform_id bigint,
    downshelve_id bigint,
    upshelve_id bigint,
    costnormsgenerator_id bigint,
    producer_id bigint,
    machinepart boolean,
    drawingnumber character varying(255),
    catalognumber character varying(255),
    isproductiondate boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    ispallet boolean DEFAULT false,
    additionalunit character varying(255),
    fromgenerator boolean DEFAULT false,
    generatorcontext_id bigint,
    dateformatinqcp5code character varying(255),
    assortment_id bigint,
    isoil boolean,
    isaroma boolean,
    capacitynormforthreedimensionalmachines numeric(12,5),
    recommendednumofheadsfortwodimensionalmachines integer,
    recommendednumofheadsforthreedimensionalmachines integer,
    iscartonlabel boolean,
    isactivecartonlabelquantity boolean,
    batchevidence boolean DEFAULT false,
    expirydatevalidity integer,
    productform_id bigint,
    size_id bigint,
    model_id bigint,
    supplier_id bigint,
    nominalcostcurrency_id bigint,
    averagecostcurrency_id bigint,
    lastpurchasecostcurrency_id bigint,
    expirydatevalidityunit character varying(255) DEFAULT '01months'::character varying,
    orderedproductconfigurator_id bigint,
    batchnumberpattern_id bigint
);


--
-- Name: materialflowresources_storagelocation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_storagelocation (
    id bigint NOT NULL,
    number character varying(48),
    state character varying(255) DEFAULT '01draft'::character varying,
    location_id bigint,
    placestoragelocation boolean DEFAULT false,
    maximumnumberofpallets numeric(12,5),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    active boolean DEFAULT true,
    highstoragelocation boolean
);


--
-- Name: arch_mv_materialflowresources_positiondto; Type: MATERIALIZED VIEW; Schema: public; Owner: -
--

CREATE MATERIALIZED VIEW public.arch_mv_materialflowresources_positiondto AS
 SELECT "position".id,
    locationfrom.number AS locationfrom,
    locationto.number AS locationto,
    product.number AS productnumber,
    product.name AS productname,
    "position".quantity,
    "position".price,
    product.unit AS productunit,
    document."time" AS documentdate,
    ("position".expirationdate)::timestamp without time zone AS expirationdate,
    ("position".productiondate)::timestamp without time zone AS productiondate,
        CASE
            WHEN ("position".externaldocumentnumber IS NULL) THEN document.type
            ELSE '03internalOutbound'::character varying(255)
        END AS documenttype,
    document.state,
        CASE
            WHEN ("position".externaldocumentnumber IS NULL) THEN document.number
            ELSE "position".externaldocumentnumber
        END AS documentnumber,
    document.name AS documentname,
    company.name AS companyname,
        CASE
            WHEN (address.name IS NULL) THEN (address.number)::text
            ELSE (((address.number)::text || ' - '::text) || (address.name)::text)
        END AS documentaddress,
    batch.number AS batch,
    storagelocation.number AS storagelocation,
    "position".waste,
    delivery.number AS deliverynumber,
    plannedevent.number AS plannedeventnumber,
    maintenanceevent.number AS maintenanceeventnumber,
    suborder.number AS subordernumber,
    ordersorder.number AS ordernumber,
    "position".typeofpallet AS pallettype,
    palletnumber.number AS palletnumber,
    (locationfrom.id)::integer AS locationfrom_id,
    (locationto.id)::integer AS locationto_id,
    "position".givenquantity,
    "position".givenunit,
    "position".conversion,
    (document.id)::integer AS documentid,
        CASE
            WHEN ("position".orderid IS NULL) THEN (document.order_id)::integer
            ELSE "position".orderid
        END AS orderid,
    ("position".price * "position".quantity) AS value,
    "position".resourcenumber
   FROM ((((((((((((((public.arch_materialflowresources_position "position"
     LEFT JOIN public.arch_materialflowresources_document document ON ((document.id = "position".document_id)))
     LEFT JOIN public.materialflow_location locationfrom ON ((locationfrom.id = document.locationfrom_id)))
     LEFT JOIN public.materialflow_location locationto ON ((locationto.id = document.locationto_id)))
     JOIN public.basic_product product ON ((product.id = "position".product_id)))
     LEFT JOIN public.basic_company company ON ((company.id = document.company_id)))
     LEFT JOIN public.basic_address address ON ((address.id = document.address_id)))
     LEFT JOIN public.materialflowresources_storagelocation storagelocation ON ((storagelocation.id = "position".storagelocation_id)))
     LEFT JOIN public.cmmsmachineparts_maintenanceevent maintenanceevent ON ((maintenanceevent.id = document.maintenanceevent_id)))
     LEFT JOIN public.cmmsmachineparts_plannedevent plannedevent ON ((plannedevent.id = document.plannedevent_id)))
     LEFT JOIN public.deliveries_delivery delivery ON ((delivery.id = document.delivery_id)))
     LEFT JOIN public.subcontractorportal_suborder suborder ON ((suborder.id = document.suborder_id)))
     LEFT JOIN public.arch_orders_order ordersorder ON (((ordersorder.id = document.order_id) OR (ordersorder.id = "position".orderid))))
     LEFT JOIN public.basic_palletnumber palletnumber ON ((palletnumber.id = "position".palletnumber_id)))
     LEFT JOIN public.advancedgenealogy_batch batch ON (("position".batch_id = batch.id)))
  WITH NO DATA;


--
-- Name: arch_materialflowresources_positiondto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.arch_materialflowresources_positiondto AS
 SELECT arch_mv_materialflowresources_positiondto.id,
    arch_mv_materialflowresources_positiondto.locationfrom,
    arch_mv_materialflowresources_positiondto.locationto,
    arch_mv_materialflowresources_positiondto.productnumber,
    arch_mv_materialflowresources_positiondto.productname,
    arch_mv_materialflowresources_positiondto.quantity,
    arch_mv_materialflowresources_positiondto.price,
    arch_mv_materialflowresources_positiondto.productunit,
    arch_mv_materialflowresources_positiondto.documentdate,
    arch_mv_materialflowresources_positiondto.expirationdate,
    arch_mv_materialflowresources_positiondto.productiondate,
    arch_mv_materialflowresources_positiondto.documenttype,
    arch_mv_materialflowresources_positiondto.state,
    arch_mv_materialflowresources_positiondto.documentnumber,
    arch_mv_materialflowresources_positiondto.documentname,
    arch_mv_materialflowresources_positiondto.companyname,
    arch_mv_materialflowresources_positiondto.documentaddress,
    arch_mv_materialflowresources_positiondto.batch,
    arch_mv_materialflowresources_positiondto.storagelocation,
    arch_mv_materialflowresources_positiondto.waste,
    arch_mv_materialflowresources_positiondto.deliverynumber,
    arch_mv_materialflowresources_positiondto.plannedeventnumber,
    arch_mv_materialflowresources_positiondto.maintenanceeventnumber,
    arch_mv_materialflowresources_positiondto.subordernumber,
    arch_mv_materialflowresources_positiondto.ordernumber,
    arch_mv_materialflowresources_positiondto.pallettype,
    arch_mv_materialflowresources_positiondto.palletnumber,
    arch_mv_materialflowresources_positiondto.locationfrom_id,
    arch_mv_materialflowresources_positiondto.locationto_id,
    arch_mv_materialflowresources_positiondto.givenquantity,
    arch_mv_materialflowresources_positiondto.givenunit,
    arch_mv_materialflowresources_positiondto.conversion,
    arch_mv_materialflowresources_positiondto.documentid,
    arch_mv_materialflowresources_positiondto.orderid,
    arch_mv_materialflowresources_positiondto.value,
    arch_mv_materialflowresources_positiondto.resourcenumber
   FROM public.arch_mv_materialflowresources_positiondto;


--
-- Name: arch_materialflowresources_positiondto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_materialflowresources_positiondto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_materialflowresources_reservation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_materialflowresources_reservation (
    id bigint NOT NULL,
    location_id bigint,
    product_id bigint,
    quantity numeric(12,5),
    position_id bigint,
    productstoissue_id bigint,
    resource_id bigint,
    order_id bigint,
    orderproductresourcereservation_id bigint,
    date timestamp without time zone,
    archived boolean DEFAULT false
);


--
-- Name: arch_materialflowresources_reservation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_materialflowresources_reservation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_materialflowresources_reservation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_materialflowresources_reservation_id_seq OWNED BY public.arch_materialflowresources_reservation.id;


--
-- Name: arch_materialrequirementcoveragefororder_coveragefororder; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_materialrequirementcoveragefororder_coveragefororder (
    id bigint NOT NULL,
    number character varying(255),
    coveragetodate timestamp without time zone,
    actualdate timestamp without time zone,
    generateddate timestamp without time zone,
    generatedby character varying(255),
    generated boolean,
    saved boolean,
    filename character varying(1024),
    coveragetype character varying(255) DEFAULT '01all'::character varying,
    includedraftdeliveries boolean,
    order_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    generatedorders boolean,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_materialrequirementcoveragefororder_coveragefororder_id_se; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_materialrequirementcoveragefororder_coveragefororder_id_se
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_materialrequirementcoveragefororder_coveragefororder_id_se; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_materialrequirementcoveragefororder_coveragefororder_id_se OWNED BY public.arch_materialrequirementcoveragefororder_coveragefororder.id;


--
-- Name: arch_materialrequirementcoveragefororder_coveragelocation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_materialrequirementcoveragefororder_coveragelocation (
    id bigint NOT NULL,
    coveragefororder_id bigint,
    location_id bigint,
    parameter_id bigint,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_materialrequirementcoveragefororder_coveragelocation_id_se; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_materialrequirementcoveragefororder_coveragelocation_id_se
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_materialrequirementcoveragefororder_coveragelocation_id_se; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_materialrequirementcoveragefororder_coveragelocation_id_se OWNED BY public.arch_materialrequirementcoveragefororder_coveragelocation.id;


--
-- Name: arch_materialrequirementcoveragefororder_coverageproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_materialrequirementcoveragefororder_coverageproduct (
    id bigint NOT NULL,
    coveragefororder_id bigint,
    product_id bigint,
    lackfromdate timestamp without time zone,
    demandquantity numeric(12,5),
    coveredquantity numeric(12,5),
    reservemissingquantity numeric(12,5),
    deliveredquantity numeric(12,5),
    locationsquantity numeric(12,5),
    state character varying(255),
    ispurchased boolean DEFAULT false,
    issubcontracted boolean DEFAULT false,
    producttype character varying(255),
    order_id bigint,
    planedquantity numeric(12,5),
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_materialrequirementcoveragefororder_coverageproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_materialrequirementcoveragefororder_coverageproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_materialrequirementcoveragefororder_coverageproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_materialrequirementcoveragefororder_coverageproduct_id_seq OWNED BY public.arch_materialrequirementcoveragefororder_coverageproduct.id;


--
-- Name: materialrequirementcoveragefororder_coverageproductlogging; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialrequirementcoveragefororder_coverageproductlogging (
    id bigint NOT NULL,
    coverageproduct_id bigint,
    date timestamp without time zone,
    delivery_id bigint,
    order_id bigint,
    operation_id bigint,
    reservemissingquantity numeric(12,5),
    changes numeric(12,5),
    eventtype character varying(255),
    state character varying(255),
    subcontractedoperation_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: materialrequirementcoveragefororder_coverageproductlogging_id_s; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialrequirementcoveragefororder_coverageproductlogging_id_s
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialrequirementcoveragefororder_coverageproductlogging_id_s; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialrequirementcoveragefororder_coverageproductlogging_id_s OWNED BY public.materialrequirementcoveragefororder_coverageproductlogging.id;


--
-- Name: arch_materialrequirementcoveragefororder_coverageproductlogging; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_materialrequirementcoveragefororder_coverageproductlogging (
    id bigint DEFAULT nextval('public.materialrequirementcoveragefororder_coverageproductlogging_id_s'::regclass) NOT NULL,
    coverageproduct_id bigint,
    date timestamp without time zone,
    delivery_id bigint,
    order_id bigint,
    operation_id bigint,
    reservemissingquantity numeric(12,5),
    changes numeric(12,5),
    eventtype character varying(255),
    state character varying(255),
    subcontractedoperation_id bigint,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersgroups_ordersgroup; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersgroups_ordersgroup (
    id bigint NOT NULL,
    number character varying(255),
    assortment_id bigint,
    productionline_id bigint,
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    deadline timestamp without time zone,
    quantity numeric(14,5),
    producedquantity numeric(14,5),
    remainingquantity numeric(14,5),
    state character varying(255) DEFAULT '01draft'::character varying,
    active boolean DEFAULT true,
    masterorder_id bigint,
    parent_id bigint,
    remainingquantityinorders numeric(14,5),
    description character varying(2048),
    salesplan_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: basic_division; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_division (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    supervisor_id bigint,
    componentslocation_id bigint,
    componentsoutputlocation_id bigint,
    productsinputlocation_id bigint,
    productionline_id bigint,
    productsflowlocation_id bigint,
    productionflow character varying(255) DEFAULT '02withinTheProcess'::character varying,
    factory_id bigint,
    active boolean DEFAULT true,
    comment character varying(2048),
    entityversion bigint DEFAULT 0,
    wastereceptionwarehouse_id bigint
);


--
-- Name: repairs_repairorder; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.repairs_repairorder (
    id bigint NOT NULL,
    number character varying(255) NOT NULL,
    state character varying(255) DEFAULT '01draft'::character varying,
    order_id bigint,
    division_id bigint,
    createdate timestamp without time zone,
    shift_id bigint,
    startdate timestamp without time zone,
    enddate timestamp without time zone,
    staff_id bigint,
    product_id bigint,
    faulttype_id bigint,
    description character varying(2048),
    quantitytorepair numeric(12,5),
    quantityrepaired numeric(12,5),
    lack numeric(12,5),
    active boolean DEFAULT true,
    orderdto_id bigint,
    entityversion bigint DEFAULT 0,
    productiontracking_id bigint,
    labortime integer DEFAULT 0,
    machinetime integer DEFAULT 0,
    repairorderproduct_id bigint
);


--
-- Name: technologies_technology; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.technologies_technology (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(2048),
    product_id bigint,
    technologygroup_id bigint,
    externalsynchronized boolean DEFAULT true,
    master boolean DEFAULT false,
    description character varying(2048),
    state character varying(255) DEFAULT '01draft'::character varying,
    recipeimportstatus character varying(255),
    recipeimportmsg character varying(1024),
    formula character varying(255),
    minimalquantity numeric(10,5),
    active boolean DEFAULT true,
    isstandardgoodfoodtechnology boolean DEFAULT true,
    range character varying(255) DEFAULT '01oneDivision'::character varying,
    division_id bigint,
    componentslocation_id bigint,
    componentsoutputlocation_id bigint,
    productsinputlocation_id bigint,
    technologytype character varying(255),
    technologyprototype_id bigint,
    productionflow character varying(255) DEFAULT '02withinTheProcess'::character varying,
    productsflowlocation_id bigint,
    typeofproductionrecording character varying(255),
    registerquantityoutproduct boolean,
    registerquantityinproduct boolean,
    registerproductiontime boolean,
    entityversion bigint DEFAULT 0,
    template boolean DEFAULT false,
    additionalactions boolean DEFAULT false,
    generatorcontext_id bigint,
    qualitycard_id bigint,
    istemplateaccepted boolean DEFAULT false,
    wastereceptionwarehouse_id bigint,
    pieceworkproduction boolean DEFAULT false,
    piecerate_id bigint
);


--
-- Name: arch_mv_orders_orderlistdto; Type: MATERIALIZED VIEW; Schema: public; Owner: -
--

CREATE MATERIALIZED VIEW public.arch_mv_orders_orderlistdto AS
 SELECT ordersorder.id,
    ordersorder.active,
    ordersorder.number,
    ordersorder.name,
    ordersorder.datefrom,
    ordersorder.dateto,
    ordersorder.startdate,
    ordersorder.finishdate,
    ordersorder.state,
    ordersorder.externalnumber,
    ordersorder.externalsynchronized,
    ordersorder.plannedquantity,
    ordersorder.donequantity,
    ordersorder.workplandelivered,
    ordersorder.deadline,
    ordersorder.ordercategory,
    COALESCE(ordersorder.plannedquantityforadditionalunit, ordersorder.plannedquantity) AS plannedquantityforadditionalunit,
    COALESCE(product.additionalunit, product.unit) AS unitforadditionalunit,
    product.number AS productnumber,
    technology.number AS technologynumber,
    product.unit,
    masterorder.number AS masterordernumber,
    division.name AS divisionname,
    company.number AS companyname,
    masterorderdefinition.number AS masterorderdefinitionnumber,
        CASE
            WHEN (EXISTS ( SELECT repairoder.id
               FROM public.repairs_repairorder repairoder
              WHERE (repairoder.order_id = ordersorder.id))) THEN true
            ELSE false
        END AS existsrepairorders,
    (masterorder.id)::integer AS masterorderid,
    ordersgroup.number AS ordersgroupnumber,
    ''::character varying(255) AS annotation
   FROM (((((((public.arch_orders_order ordersorder
     JOIN public.basic_product product ON ((product.id = ordersorder.product_id)))
     LEFT JOIN public.technologies_technology technology ON ((technology.id = ordersorder.technology_id)))
     LEFT JOIN public.basic_company company ON ((company.id = ordersorder.company_id)))
     LEFT JOIN public.arch_masterorders_masterorder masterorder ON ((masterorder.id = ordersorder.masterorder_id)))
     LEFT JOIN public.masterorders_masterorderdefinition masterorderdefinition ON ((masterorderdefinition.id = masterorder.masterorderdefinition_id)))
     LEFT JOIN public.arch_ordersgroups_ordersgroup ordersgroup ON ((ordersorder.ordersgroup_id = ordersgroup.id)))
     LEFT JOIN public.basic_division division ON ((division.id = technology.division_id)))
  WITH NO DATA;


--
-- Name: arch_ordersgroups_drafrptquantitydto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.arch_ordersgroups_drafrptquantitydto AS
SELECT
    NULL::bigint AS id,
    NULL::character varying(255) AS number,
    NULL::numeric AS sum;


--
-- Name: basic_assortment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_assortment (
    id bigint NOT NULL,
    name character varying(255),
    active boolean DEFAULT true
);


--
-- Name: productionlines_productionline; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionlines_productionline (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(2048),
    division_id bigint,
    place character varying(255),
    description character varying(2048),
    supportsalltechnologies boolean DEFAULT true,
    documentation character varying(255),
    supportsothertechnologiesworkstationtypes boolean DEFAULT true,
    quantityforotherworkstationtypes integer DEFAULT 1,
    active boolean DEFAULT true,
    eurocodsymbol character varying(3),
    availabilityindicator numeric(12,5),
    production boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    placeinscada character varying(255),
    printer_id bigint,
    printedlabelstype character varying(255),
    printedlabelstime timestamp without time zone,
    isblocked boolean DEFAULT false
);


--
-- Name: technologies_technologygroup; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.technologies_technologygroup (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(2048),
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0
);


--
-- Name: technologies_technologyproductionline; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.technologies_technologyproductionline (
    id bigint NOT NULL,
    productionline_id bigint,
    technology_id bigint,
    master boolean DEFAULT false,
    standardperformance numeric(12,5),
    plannedstaff integer
);


--
-- Name: arch_mv_ordersgroups_ordersgroupdto; Type: MATERIALIZED VIEW; Schema: public; Owner: -
--

CREATE MATERIALIZED VIEW public.arch_mv_ordersgroups_ordersgroupdto AS
 WITH technology_group_numbers AS (
         SELECT o.ordersgroup_id,
            string_agg(DISTINCT (tg.number)::text, ', '::text) AS number
           FROM ((public.arch_orders_order o
             JOIN public.technologies_technology t ON ((o.technology_id = t.id)))
             JOIN public.technologies_technologygroup tg ON ((t.technologygroup_id = tg.id)))
          WHERE (o.ordersgroup_id IS NOT NULL)
          GROUP BY o.ordersgroup_id
        ), performance AS (
         SELECT o.ordersgroup_id,
            first_value(tpl.standardperformance) OVER (PARTITION BY o.ordersgroup_id ORDER BY o.id) AS performancenorm
           FROM (public.arch_orders_order o
             LEFT JOIN public.technologies_technologyproductionline tpl ON (((tpl.technology_id = o.technology_id) AND tpl.master)))
        )
 SELECT DISTINCT ordersgroup.id,
    ordersgroup.active,
    ordersgroup.number,
    assortment.name AS assortmentname,
    productionline.number AS productionlinenumber,
    ordersgroup.startdate,
    ordersgroup.finishdate,
    ordersgroup.deadline,
    ordersgroup.quantity,
    ordersgroup.producedquantity,
    ordersgroup.remainingquantity,
    ordersgroup.state,
    company.number AS company,
    ordersgroup.remainingquantityinorders,
    (COALESCE(ordersgroup.producedquantity, (0)::numeric) + COALESCE(drafrptquantity.sum, (0)::numeric)) AS producedquantitywithdraft,
    (COALESCE(ordersgroup.remainingquantityinorders, (0)::numeric) - COALESCE(drafrptquantity.sum, (0)::numeric)) AS remainingquantityinorderswithdraft,
    tgn.number AS technologygroup,
    p.performancenorm,
    (masterorder.deadline)::date AS clientdate
   FROM (((((((public.arch_ordersgroups_ordersgroup ordersgroup
     JOIN public.basic_assortment assortment ON ((ordersgroup.assortment_id = assortment.id)))
     JOIN public.productionlines_productionline productionline ON ((ordersgroup.productionline_id = productionline.id)))
     JOIN public.arch_masterorders_masterorder masterorder ON ((ordersgroup.masterorder_id = masterorder.id)))
     LEFT JOIN public.basic_company company ON ((company.id = masterorder.company_id)))
     LEFT JOIN public.arch_ordersgroups_drafrptquantitydto drafrptquantity ON ((ordersgroup.id = drafrptquantity.id)))
     LEFT JOIN technology_group_numbers tgn ON ((tgn.ordersgroup_id = ordersgroup.id)))
     LEFT JOIN performance p ON ((p.ordersgroup_id = ordersgroup.id)))
  WITH NO DATA;


--
-- Name: arch_productioncounting_productiontracking; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productioncounting_productiontracking (
    id bigint NOT NULL,
    number character varying(255),
    order_id bigint,
    technologyinstanceoperationcomponent_id bigint,
    shift_id bigint,
    state character varying(255) DEFAULT '01draft'::character varying,
    lasttracking boolean,
    machinetime integer,
    labortime integer,
    staff_id bigint,
    workstationtype_id bigint,
    division_id bigint,
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    laststatechangefails boolean DEFAULT false,
    laststatechangefailcause character varying(255),
    isexternalsynchronized boolean DEFAULT true,
    timerangefrom timestamp without time zone,
    timerangeto timestamp without time zone,
    shiftstartday date,
    changeovertime integer,
    subcontractor_id bigint,
    technologyoperationcomponent_id bigint,
    entityversion bigint DEFAULT 0,
    repairorder_id bigint,
    correction_id bigint,
    iscorrection boolean DEFAULT false,
    planforordercompleted boolean DEFAULT false,
    workstation_id bigint,
    batch_id bigint,
    expirationdate date,
    qualityrating character varying(255),
    iscorrected boolean DEFAULT false,
    comments character varying(2048),
    archived boolean DEFAULT false
);


--
-- Name: arch_productioncounting_trackingoperationproductoutcomponent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productioncounting_trackingoperationproductoutcomponent (
    id bigint NOT NULL,
    productiontracking_id bigint,
    product_id bigint,
    usedquantity numeric(14,5),
    balance numeric(14,5),
    batch_id bigint,
    wastedquantity numeric(14,5),
    givenunit character varying(255),
    givenquantity numeric(14,5),
    entityversion bigint DEFAULT 0,
    wastesquantity numeric(14,5),
    typeofmaterial character varying(255) DEFAULT '01component'::character varying,
    storagelocation_id bigint,
    causeofwastes character varying(255),
    palletnumber_id bigint,
    manyreasonsforlacks boolean DEFAULT false,
    typeofpallet character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_repairs_repairorder; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_repairs_repairorder (
    id bigint NOT NULL,
    number character varying(255) NOT NULL,
    state character varying(255) DEFAULT '01draft'::character varying,
    order_id bigint,
    division_id bigint,
    createdate timestamp without time zone,
    shift_id bigint,
    startdate timestamp without time zone,
    enddate timestamp without time zone,
    staff_id bigint,
    product_id bigint,
    faulttype_id bigint,
    description character varying(2048),
    quantitytorepair numeric(12,5),
    quantityrepaired numeric(12,5),
    lack numeric(12,5),
    active boolean DEFAULT true,
    orderdto_id bigint,
    entityversion bigint DEFAULT 0,
    productiontracking_id bigint,
    labortime integer DEFAULT 0,
    machinetime integer DEFAULT 0,
    repairorderproduct_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: basic_shift; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_shift (
    id bigint NOT NULL,
    name character varying(1024),
    mondayworking boolean DEFAULT true,
    mondayhours character varying(255),
    tuesdayworking boolean DEFAULT true,
    tuesdayhours character varying(255),
    wensdayworking boolean DEFAULT true,
    wensdayhours character varying(255),
    thursdayworking boolean DEFAULT true,
    thursdayhours character varying(255),
    fridayworking boolean DEFAULT true,
    fridayhours character varying(255),
    saturdayworking boolean DEFAULT false,
    saturdayhours character varying(255),
    sundayworking boolean DEFAULT false,
    sundayhours character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: basic_staff; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_staff (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(255),
    surname character varying(255),
    email character varying(255),
    phone character varying(255),
    workfor_id bigint,
    post character varying(255),
    division_id bigint,
    individuallaborcost numeric(12,5),
    determinedindividual boolean,
    laborhourlycost numeric(12,5),
    wagegroup_id bigint,
    active boolean DEFAULT true,
    parameter_id bigint,
    entityversion bigint DEFAULT 0,
    crew_id bigint,
    workstation_id bigint,
    productionline_id bigint
);


--
-- Name: technologies_operation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.technologies_operation (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    comment character varying(2048),
    workstationtype_id bigint,
    attachment character varying(255),
    areproductquantitiesdivisible boolean DEFAULT false,
    istjdivisible boolean DEFAULT false,
    operationgroup_id bigint,
    imageurlinworkplan character varying(255),
    productioninonecycle numeric(12,5) DEFAULT (1)::numeric,
    laborhourlycost numeric(12,5) DEFAULT (0)::numeric,
    laborutilization numeric(8,5) DEFAULT 1.0,
    nextoperationafterproducedtype character varying(255) DEFAULT '01all'::character varying,
    nextoperationafterproducedquantityunit character varying(255),
    machinehourlycost numeric(12,5) DEFAULT (0)::numeric,
    tj integer DEFAULT 0,
    nextoperationafterproducedquantity numeric(12,5) DEFAULT (0)::numeric,
    machineutilization numeric(8,5) DEFAULT 1.0,
    timenextoperation integer DEFAULT 0,
    tpz integer DEFAULT 0,
    productioninonecycleunit character varying(255),
    active boolean DEFAULT true,
    issubcontracting boolean DEFAULT false,
    assignedtooperation character varying(255) DEFAULT '02workstationTypes'::character varying,
    quantityofworkstations integer DEFAULT 1,
    division_id bigint,
    showinproductdata boolean DEFAULT false,
    productdatanumber numeric(12,5) DEFAULT (0)::numeric,
    entityversion bigint DEFAULT 0,
    product_id bigint,
    createoperationoutput boolean DEFAULT false,
    tjdecreasesforenlargedstaff boolean DEFAULT false,
    minstaff integer DEFAULT 1,
    optimalstaff integer DEFAULT 1,
    pieceworkproduction boolean DEFAULT false,
    piecerate_id bigint,
    unitcost numeric(12,5),
    reservationrawmaterialresourcerequired boolean DEFAULT false,
    optimizecutting boolean
);


--
-- Name: technologies_technologyoperationcomponent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.technologies_technologyoperationcomponent (
    id bigint NOT NULL,
    technology_id bigint,
    operation_id bigint,
    parent_id bigint,
    entitytype character varying(255),
    priority integer,
    nodenumber character varying(255),
    comment character varying(2048),
    attachment character varying(255),
    areproductquantitiesdivisible boolean DEFAULT false,
    istjdivisible boolean DEFAULT false,
    tpz integer DEFAULT 0,
    laborworktime integer DEFAULT 0,
    productioninonecycleunit character varying(255),
    nextoperationafterproducedquantityunit character varying(255),
    nextoperationafterproducedquantity numeric(12,5) DEFAULT (0)::numeric,
    nextoperationafterproducedtype character varying(255) DEFAULT '01all'::character varying,
    machineutilization numeric(8,5) DEFAULT 1.0,
    timenextoperation integer DEFAULT 0,
    machineworktime integer DEFAULT 0,
    productioninonecycle numeric(12,5) DEFAULT (1)::numeric,
    laborutilization numeric(8,5) DEFAULT 1.0,
    duration integer DEFAULT 0,
    tj integer DEFAULT 0,
    machinehourlycost numeric(12,5) DEFAULT (0)::numeric,
    laborhourlycost numeric(12,5) DEFAULT (0)::numeric,
    issubcontracting boolean DEFAULT false,
    assignedtooperation character varying(255) DEFAULT '02workstationTypes'::character varying,
    workstationtype_id bigint,
    quantityofworkstations integer DEFAULT 1,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    techopercomptimecalculation_id bigint,
    hascorrections boolean,
    division_id bigint,
    showinproductdata boolean,
    productdatanumber numeric(12,5) DEFAULT (0)::numeric,
    entityversion bigint DEFAULT 0,
    technologicalprocesslist_id bigint,
    technologicalprocesslistassignmentdate timestamp without time zone,
    tjdecreasesforenlargedstaff boolean DEFAULT false,
    minstaff integer DEFAULT 1,
    optimalstaff integer DEFAULT 1,
    pieceworkproduction boolean DEFAULT false,
    piecerate_id bigint,
    unitcost numeric(12,5)
);


--
-- Name: arch_mv_productioncounting_productiontrackingdto; Type: MATERIALIZED VIEW; Schema: public; Owner: -
--

CREATE MATERIALIZED VIEW public.arch_mv_productioncounting_productiontrackingdto AS
 SELECT productiontracking.id,
    productiontracking.number,
    productiontracking.state,
    productiontracking.createdate,
    productiontracking.lasttracking,
    productiontracking.timerangefrom,
    productiontracking.timerangeto,
    productiontracking.active,
    (ordersorder.id)::integer AS order_id,
    ordersorder.number AS ordernumber,
    ordersorder.state AS orderstate,
    (technologyoperationcomponent.id)::integer AS technologyoperationcomponent_id,
    COALESCE((((technologyoperationcomponent.nodenumber)::text || ' '::text) || (operation.name)::text), ''::text) AS technologyoperationcomponentnumber,
    (operation.id)::integer AS operation_id,
    (shift.id)::integer AS shift_id,
    shift.name AS shiftname,
    (staff.id)::integer AS staff_id,
    (((staff.surname)::text || ' '::text) || (staff.name)::text) AS staffname,
    (division.id)::integer AS division_id,
    division.number AS divisionnumber,
    (subcontractor.id)::integer AS subcontractor_id,
    subcontractor.name AS subcontractorname,
    (repairorder.id)::integer AS repairorder_id,
    repairorder.number AS repairordernumber,
    productiontrackingcorrection.number AS correctionnumber,
    (productionline.id)::integer AS productionline_id,
    productionline.number AS productionlinenumber,
    ordersgroup.number AS ordersgroup,
    concat(product.number, ' - ', product.name) AS productnumber,
    product.unit AS productunit,
    outcomponent.usedquantity,
    company.number AS companynumber,
    COALESCE((((outproduct.number)::text || ' - '::text) || (outproduct.name)::text), (((product.number)::text || ' - '::text) || (product.name)::text)) AS outproductnumber
   FROM ((((((((((((((((public.arch_productioncounting_productiontracking productiontracking
     JOIN public.arch_orders_order ordersorder ON ((ordersorder.id = productiontracking.order_id)))
     JOIN public.basic_product product ON ((ordersorder.product_id = product.id)))
     JOIN public.productionlines_productionline productionline ON ((productionline.id = ordersorder.productionline_id)))
     LEFT JOIN public.technologies_technologyoperationcomponent technologyoperationcomponent ON ((technologyoperationcomponent.id = productiontracking.technologyoperationcomponent_id)))
     LEFT JOIN public.technologies_operation operation ON ((operation.id = technologyoperationcomponent.operation_id)))
     LEFT JOIN public.basic_shift shift ON ((shift.id = productiontracking.shift_id)))
     LEFT JOIN public.basic_staff staff ON ((staff.id = productiontracking.staff_id)))
     LEFT JOIN public.basic_division division ON ((division.id = productiontracking.division_id)))
     LEFT JOIN public.basic_company subcontractor ON ((subcontractor.id = productiontracking.subcontractor_id)))
     LEFT JOIN public.arch_productioncounting_productiontracking productiontrackingcorrection ON ((productiontrackingcorrection.id = productiontracking.correction_id)))
     LEFT JOIN public.arch_repairs_repairorder repairorder ON ((repairorder.id = productiontracking.repairorder_id)))
     LEFT JOIN public.arch_ordersgroups_ordersgroup ordersgroup ON ((ordersgroup.id = ordersorder.ordersgroup_id)))
     LEFT JOIN public.basic_company company ON ((company.id = ordersorder.company_id)))
     LEFT JOIN public.arch_basicproductioncounting_productioncountingquantity pcq ON (((pcq.order_id = ordersorder.id) AND (pcq.technologyoperationcomponent_id = technologyoperationcomponent.id) AND ((pcq.typeofmaterial)::text = ANY (ARRAY[('02intermediate'::character varying)::text, ('03finalProduct'::character varying)::text])) AND ((pcq.role)::text = '02produced'::text))))
     LEFT JOIN public.basic_product outproduct ON ((pcq.product_id = outproduct.id)))
     LEFT JOIN public.arch_productioncounting_trackingoperationproductoutcomponent outcomponent ON ((((outcomponent.product_id = outproduct.id) OR (outcomponent.product_id = product.id)) AND (productiontracking.id = outcomponent.productiontracking_id))))
  WITH NO DATA;


--
-- Name: arch_orders_operationaltask; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_operationaltask (
    id bigint NOT NULL,
    number character varying(256),
    name character varying(1024),
    description character varying(1024),
    type character varying(255),
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    order_id bigint,
    entityversion bigint DEFAULT 0,
    staff_id bigint,
    workstation_id bigint,
    state character varying(255) DEFAULT '01pending'::character varying,
    technologyoperationcomponent_id bigint,
    product_id bigint,
    scheduleposition_id bigint,
    division_id bigint,
    actualstaff integer,
    suborder_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_operationaltask_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_operationaltask_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_operationaltask_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_operationaltask_id_seq OWNED BY public.arch_orders_operationaltask.id;


--
-- Name: arch_orders_operationaltaskstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_operationaltaskstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    operationaltask_id bigint,
    shift_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_operationaltaskstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_operationaltaskstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_operationaltaskstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_operationaltaskstatechange_id_seq OWNED BY public.arch_orders_operationaltaskstatechange.id;


--
-- Name: arch_orders_order_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_order_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_order_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_order_id_seq OWNED BY public.arch_orders_order.id;


--
-- Name: arch_orders_orderlistdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.arch_orders_orderlistdto AS
 SELECT arch_mv_orders_orderlistdto.id,
    arch_mv_orders_orderlistdto.active,
    arch_mv_orders_orderlistdto.number,
    arch_mv_orders_orderlistdto.name,
    arch_mv_orders_orderlistdto.datefrom,
    arch_mv_orders_orderlistdto.dateto,
    arch_mv_orders_orderlistdto.startdate,
    arch_mv_orders_orderlistdto.finishdate,
    arch_mv_orders_orderlistdto.state,
    arch_mv_orders_orderlistdto.externalnumber,
    arch_mv_orders_orderlistdto.externalsynchronized,
    arch_mv_orders_orderlistdto.plannedquantity,
    arch_mv_orders_orderlistdto.donequantity,
    arch_mv_orders_orderlistdto.workplandelivered,
    arch_mv_orders_orderlistdto.deadline,
    arch_mv_orders_orderlistdto.ordercategory,
    arch_mv_orders_orderlistdto.plannedquantityforadditionalunit,
    arch_mv_orders_orderlistdto.unitforadditionalunit,
    arch_mv_orders_orderlistdto.productnumber,
    arch_mv_orders_orderlistdto.technologynumber,
    arch_mv_orders_orderlistdto.unit,
    arch_mv_orders_orderlistdto.masterordernumber,
    arch_mv_orders_orderlistdto.divisionname,
    arch_mv_orders_orderlistdto.companyname,
    arch_mv_orders_orderlistdto.masterorderdefinitionnumber,
    arch_mv_orders_orderlistdto.existsrepairorders,
    arch_mv_orders_orderlistdto.masterorderid,
    arch_mv_orders_orderlistdto.ordersgroupnumber,
    arch_mv_orders_orderlistdto.annotation
   FROM public.arch_mv_orders_orderlistdto;


--
-- Name: arch_orders_orderlistdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_orderlistdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_orderpack; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_orderpack (
    id bigint NOT NULL,
    number character varying(255),
    order_id bigint,
    quantity numeric(12,5),
    state character varying(255) DEFAULT '01pending'::character varying,
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_orderpack_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_orderpack_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_orderpack_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_orderpack_id_seq OWNED BY public.arch_orders_orderpack.id;


--
-- Name: arch_orders_orderpackstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_orderpackstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    orderpack_id bigint,
    shift_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_orderpackstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_orderpackstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_orderpackstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_orderpackstatechange_id_seq OWNED BY public.arch_orders_orderpackstatechange.id;


--
-- Name: arch_orders_orderstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_orderstatechange (
    id bigint NOT NULL,
    comment character varying(255),
    reasonrequired boolean DEFAULT false,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255) DEFAULT '01inProgress'::character varying,
    phase integer,
    worker character varying(255),
    order_id bigint,
    shift_id bigint,
    additionalinformation character varying(255),
    sourcecorrecteddatefrom timestamp without time zone,
    sourcecorrecteddateto timestamp without time zone,
    sourcestartdate timestamp without time zone,
    sourcefinishdate timestamp without time zone,
    targetcorrecteddatefrom timestamp without time zone,
    targetcorrecteddateto timestamp without time zone,
    targetstartdate timestamp without time zone,
    targetfinishdate timestamp without time zone,
    dateschanged boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_orderstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_orderstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_orderstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_orderstatechange_id_seq OWNED BY public.arch_orders_orderstatechange.id;


--
-- Name: arch_orders_ordertechnologicalprocess; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_ordertechnologicalprocess (
    id bigint NOT NULL,
    number character varying(255),
    orderpack_id bigint,
    order_id bigint,
    product_id bigint,
    operation_id bigint,
    technologicalprocess_id bigint,
    quantity numeric(12,5),
    worker_id bigint,
    date timestamp without time zone,
    wastesquantity numeric(12,5),
    technologyoperationcomponent_id bigint,
    createdate timestamp without time zone,
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_ordertechnologicalprocess_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_ordertechnologicalprocess_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_ordertechnologicalprocess_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_ordertechnologicalprocess_id_seq OWNED BY public.arch_orders_ordertechnologicalprocess.id;


--
-- Name: arch_orders_ordertechnologicalprocesspart; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_ordertechnologicalprocesspart (
    id bigint NOT NULL,
    number character varying(255),
    quantity numeric(12,5),
    ordertechnologicalprocess_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_ordertechnologicalprocesspart_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_ordertechnologicalprocesspart_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_ordertechnologicalprocesspart_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_ordertechnologicalprocesspart_id_seq OWNED BY public.arch_orders_ordertechnologicalprocesspart.id;


--
-- Name: arch_orders_ordertechnologicalprocesswaste; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_ordertechnologicalprocesswaste (
    id bigint NOT NULL,
    number character varying(255),
    ordertechnologicalprocess_id bigint,
    orderpack_id bigint,
    order_id bigint,
    product_id bigint,
    technologicalprocess_id bigint,
    wastequantity numeric(12,5),
    causeofwaste character varying(255),
    worker_id bigint,
    date timestamp without time zone,
    description character varying(2048),
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_ordertechnologicalprocesswaste_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_ordertechnologicalprocesswaste_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_ordertechnologicalprocesswaste_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_ordertechnologicalprocesswaste_id_seq OWNED BY public.arch_orders_ordertechnologicalprocesswaste.id;


--
-- Name: arch_orders_productionlinescheduleposition; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_productionlinescheduleposition (
    id bigint NOT NULL,
    productionlineschedule_id bigint,
    order_id bigint,
    productionline_id bigint,
    linechangeovernorm_id bigint,
    starttime timestamp without time zone,
    endtime timestamp without time zone,
    additionaltime integer DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_productionlinescheduleposition_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_productionlinescheduleposition_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_productionlinescheduleposition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_productionlinescheduleposition_id_seq OWNED BY public.arch_orders_productionlinescheduleposition.id;


--
-- Name: arch_orders_reasontypecorrectiondatefrom; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_reasontypecorrectiondatefrom (
    id bigint NOT NULL,
    order_id bigint,
    reasontypeofchangingorderstate character varying(255),
    date timestamp without time zone,
    entityversion bigint DEFAULT 0,
    changedateshelper_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_reasontypecorrectiondatefrom_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_reasontypecorrectiondatefrom_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_reasontypecorrectiondatefrom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_reasontypecorrectiondatefrom_id_seq OWNED BY public.arch_orders_reasontypecorrectiondatefrom.id;


--
-- Name: arch_orders_reasontypecorrectiondateto; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_reasontypecorrectiondateto (
    id bigint NOT NULL,
    order_id bigint,
    reasontypeofchangingorderstate character varying(255),
    date timestamp without time zone,
    entityversion bigint DEFAULT 0,
    changedateshelper_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_reasontypecorrectiondateto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_reasontypecorrectiondateto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_reasontypecorrectiondateto_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_reasontypecorrectiondateto_id_seq OWNED BY public.arch_orders_reasontypecorrectiondateto.id;


--
-- Name: arch_orders_reasontypedeviationeffectiveend; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_reasontypedeviationeffectiveend (
    id bigint NOT NULL,
    order_id bigint,
    reasontypeofchangingorderstate character varying(255),
    date timestamp without time zone,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_reasontypedeviationeffectiveend_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_reasontypedeviationeffectiveend_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_reasontypedeviationeffectiveend_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_reasontypedeviationeffectiveend_id_seq OWNED BY public.arch_orders_reasontypedeviationeffectiveend.id;


--
-- Name: arch_orders_reasontypedeviationeffectivestart; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_reasontypedeviationeffectivestart (
    id bigint NOT NULL,
    order_id bigint,
    reasontypeofchangingorderstate character varying(255),
    date timestamp without time zone,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_reasontypedeviationeffectivestart_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_reasontypedeviationeffectivestart_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_reasontypedeviationeffectivestart_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_reasontypedeviationeffectivestart_id_seq OWNED BY public.arch_orders_reasontypedeviationeffectivestart.id;


--
-- Name: arch_orders_reasontypeofchangingorderstate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_reasontypeofchangingorderstate (
    id bigint NOT NULL,
    orderstatechange_id bigint,
    reasontypeofchangingorderstate character varying(255),
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_reasontypeofchangingorderstate_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_reasontypeofchangingorderstate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_reasontypeofchangingorderstate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_reasontypeofchangingorderstate_id_seq OWNED BY public.arch_orders_reasontypeofchangingorderstate.id;


--
-- Name: arch_orders_scheduleposition; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_scheduleposition (
    id bigint NOT NULL,
    schedule_id bigint,
    technologyoperationcomponent_id bigint,
    additionaltime integer DEFAULT 0,
    machineworktime integer DEFAULT 0,
    laborworktime integer DEFAULT 0,
    order_id bigint,
    product_id bigint,
    workstation_id bigint,
    quantity numeric(14,5),
    starttime timestamp without time zone,
    endtime timestamp without time zone,
    staff_id bigint,
    operationruns numeric(12,5),
    partialoperationruns numeric(12,5),
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_scheduleposition_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_scheduleposition_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_scheduleposition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_scheduleposition_id_seq OWNED BY public.arch_orders_scheduleposition.id;


--
-- Name: arch_orders_typeofcorrectioncauses; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_orders_typeofcorrectioncauses (
    id bigint NOT NULL,
    order_id bigint,
    reasontype character varying(255),
    date timestamp without time zone,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_orders_typeofcorrectioncauses_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_orders_typeofcorrectioncauses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_orders_typeofcorrectioncauses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_orders_typeofcorrectioncauses_id_seq OWNED BY public.arch_orders_typeofcorrectioncauses.id;


--
-- Name: arch_ordersforsubproductsgeneration_suborders; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersforsubproductsgeneration_suborders (
    id bigint NOT NULL,
    order_id bigint,
    ordersgroup_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    ordersgroupsgenerated boolean DEFAULT false,
    generatedorders boolean DEFAULT false,
    ordergenerationinprogress boolean DEFAULT false,
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersforsubproductsgeneration_suborders_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersforsubproductsgeneration_suborders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersforsubproductsgeneration_suborders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersforsubproductsgeneration_suborders_id_seq OWNED BY public.arch_ordersforsubproductsgeneration_suborders.id;


--
-- Name: arch_ordersgroups_drafrptquantitydto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersgroups_drafrptquantitydto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersgroups_ordersgroup_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersgroups_ordersgroup_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersgroups_ordersgroup_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersgroups_ordersgroup_id_seq OWNED BY public.arch_ordersgroups_ordersgroup.id;


--
-- Name: arch_ordersgroups_ordersgroupdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.arch_ordersgroups_ordersgroupdto AS
 SELECT arch_mv_ordersgroups_ordersgroupdto.id,
    arch_mv_ordersgroups_ordersgroupdto.active,
    arch_mv_ordersgroups_ordersgroupdto.number,
    arch_mv_ordersgroups_ordersgroupdto.assortmentname,
    arch_mv_ordersgroups_ordersgroupdto.productionlinenumber,
    arch_mv_ordersgroups_ordersgroupdto.startdate,
    arch_mv_ordersgroups_ordersgroupdto.finishdate,
    arch_mv_ordersgroups_ordersgroupdto.deadline,
    arch_mv_ordersgroups_ordersgroupdto.quantity,
    arch_mv_ordersgroups_ordersgroupdto.producedquantity,
    arch_mv_ordersgroups_ordersgroupdto.remainingquantity,
    arch_mv_ordersgroups_ordersgroupdto.state,
    arch_mv_ordersgroups_ordersgroupdto.company,
    arch_mv_ordersgroups_ordersgroupdto.remainingquantityinorders,
    arch_mv_ordersgroups_ordersgroupdto.producedquantitywithdraft,
    arch_mv_ordersgroups_ordersgroupdto.remainingquantityinorderswithdraft,
    arch_mv_ordersgroups_ordersgroupdto.technologygroup,
    arch_mv_ordersgroups_ordersgroupdto.performancenorm,
    arch_mv_ordersgroups_ordersgroupdto.clientdate
   FROM public.arch_mv_ordersgroups_ordersgroupdto;


--
-- Name: arch_ordersgroups_ordersgroupdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersgroups_ordersgroupdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersgroups_ordersgroupissuedmaterial; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersgroups_ordersgroupissuedmaterial (
    id bigint NOT NULL,
    ordersgroup_id bigint,
    product_id bigint,
    quantity numeric(14,5),
    value numeric(14,5),
    averageprice numeric(11,2),
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersgroups_ordersgroupissuedmaterial_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersgroups_ordersgroupissuedmaterial_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersgroups_ordersgroupissuedmaterial_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersgroups_ordersgroupissuedmaterial_id_seq OWNED BY public.arch_ordersgroups_ordersgroupissuedmaterial.id;


--
-- Name: arch_ordersgroups_ordersgroupissuedmaterialposition; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersgroups_ordersgroupissuedmaterialposition (
    id bigint NOT NULL,
    ordersgroupissuedmaterial_id bigint,
    documentnumber character varying(255),
    quantity numeric(14,5),
    price numeric(14,5),
    value numeric(14,5),
    externaldocumentid character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersgroups_ordersgroupissuedmaterialposition_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersgroups_ordersgroupissuedmaterialposition_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersgroups_ordersgroupissuedmaterialposition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersgroups_ordersgroupissuedmaterialposition_id_seq OWNED BY public.arch_ordersgroups_ordersgroupissuedmaterialposition.id;


--
-- Name: arch_ordersgroups_ordersgroupmaterialrequirement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersgroups_ordersgroupmaterialrequirement (
    id bigint NOT NULL,
    number character varying(256),
    ordersgroup_id bigint,
    generated boolean,
    worker character varying(255),
    date timestamp without time zone,
    filename character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersgroups_ordersgroupmaterialrequirement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersgroups_ordersgroupmaterialrequirement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersgroups_ordersgroupmaterialrequirement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersgroups_ordersgroupmaterialrequirement_id_seq OWNED BY public.arch_ordersgroups_ordersgroupmaterialrequirement.id;


--
-- Name: arch_ordersgroups_ordersgroupmaterialrequirementproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersgroups_ordersgroupmaterialrequirementproduct (
    id bigint NOT NULL,
    ordersgroupmaterialrequirement_id bigint,
    product_id bigint,
    quantity numeric(14,5),
    currentstock numeric(14,5),
    technologyinputproducttype_id bigint,
    orderstartdate date,
    division_id bigint,
    location_id bigint,
    issuedquantity numeric(14,5),
    supplier_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersgroups_ordersgroupmaterialrequirementproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersgroups_ordersgroupmaterialrequirementproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersgroups_ordersgroupmaterialrequirementproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersgroups_ordersgroupmaterialrequirementproduct_id_seq OWNED BY public.arch_ordersgroups_ordersgroupmaterialrequirementproduct.id;


--
-- Name: arch_ordersgroups_ordersgroupproducedproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersgroups_ordersgroupproducedproduct (
    id bigint NOT NULL,
    ordersgroup_id bigint,
    product_id bigint,
    location_id bigint,
    document_id bigint,
    quantity numeric(14,5),
    accepted boolean DEFAULT false,
    externaldocumentnumber character varying(255),
    batch_id bigint,
    storagelocation_id bigint,
    palletnumber_id bigint,
    typeofpallet character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersgroups_ordersgroupproducedproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersgroups_ordersgroupproducedproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersgroups_ordersgroupproducedproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersgroups_ordersgroupproducedproduct_id_seq OWNED BY public.arch_ordersgroups_ordersgroupproducedproduct.id;


--
-- Name: arch_ordersgroups_ordersgroupproductstoissueentryhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersgroups_ordersgroupproductstoissueentryhelper (
    id bigint NOT NULL,
    ordersgroupmaterialrequirementproduct_id bigint,
    ordersgroupproductstoissuehelper_id bigint,
    quantity numeric(12,5),
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersgroups_ordersgroupproductstoissueentryhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersgroups_ordersgroupproductstoissueentryhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersgroups_ordersgroupproductstoissueentryhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersgroups_ordersgroupproductstoissueentryhelper_id_seq OWNED BY public.arch_ordersgroups_ordersgroupproductstoissueentryhelper.id;


--
-- Name: arch_ordersgroups_ordersgroupproductstoissuehelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersgroups_ordersgroupproductstoissuehelper (
    id bigint NOT NULL,
    ordersgroupmaterialrequirement_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersgroups_ordersgroupproductstoissuehelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersgroups_ordersgroupproductstoissuehelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersgroups_ordersgroupproductstoissuehelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersgroups_ordersgroupproductstoissuehelper_id_seq OWNED BY public.arch_ordersgroups_ordersgroupproductstoissuehelper.id;


--
-- Name: arch_ordersgroups_productionbalance; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersgroups_productionbalance (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(255),
    generated boolean,
    worker character varying(255),
    date timestamp without time zone,
    filename character varying(255),
    ordersgroup_id bigint,
    plannedmaterialcost character varying(255) DEFAULT '01nominal'::character varying,
    usenominalcostpricenotspecified boolean DEFAULT false,
    realmaterialcost character varying(255) DEFAULT '01ordersgroupsdocuments'::character varying,
    orderedquantity numeric(14,5),
    producedquantity numeric(14,5),
    quantitydeviation numeric(14,5),
    plannedcost numeric(14,5),
    realcost numeric(14,5),
    costdeviation numeric(14,5),
    active boolean DEFAULT true,
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersgroups_productionbalance_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersgroups_productionbalance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersgroups_productionbalance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersgroups_productionbalance_id_seq OWNED BY public.arch_ordersgroups_productionbalance.id;


--
-- Name: arch_ordersupplies_coverageanalysisfororder; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersupplies_coverageanalysisfororder (
    id bigint NOT NULL,
    order_id bigint,
    orderedproduct_id bigint,
    plannedquantity numeric(16,5),
    coveragedegree character varying(255),
    coveredfromtheday timestamp without time zone,
    deliverytime timestamp without time zone,
    componentsproductiondate timestamp without time zone,
    materialrequirementcoverage_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersupplies_coverageanalysisfororder_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersupplies_coverageanalysisfororder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersupplies_coverageanalysisfororder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersupplies_coverageanalysisfororder_id_seq OWNED BY public.arch_ordersupplies_coverageanalysisfororder.id;


--
-- Name: arch_ordersupplies_coveragelocation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersupplies_coveragelocation (
    id bigint NOT NULL,
    materialrequirementcoverage_id bigint,
    location_id bigint,
    parameter_id bigint,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersupplies_coveragelocation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersupplies_coveragelocation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersupplies_coveragelocation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersupplies_coveragelocation_id_seq OWNED BY public.arch_ordersupplies_coveragelocation.id;


--
-- Name: arch_ordersupplies_coverageorderstate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersupplies_coverageorderstate (
    id bigint NOT NULL,
    materialrequirementcoverage_id bigint,
    parameter_id bigint,
    state character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersupplies_coverageorderstate_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersupplies_coverageorderstate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersupplies_coverageorderstate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersupplies_coverageorderstate_id_seq OWNED BY public.arch_ordersupplies_coverageorderstate.id;


--
-- Name: arch_ordersupplies_coverageproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersupplies_coverageproduct (
    id bigint NOT NULL,
    materialrequirementcoverage_id bigint,
    product_id bigint,
    lackfromdate timestamp without time zone,
    demandquantity numeric(16,5),
    coveredquantity numeric(16,5),
    reservemissingquantity numeric(16,5),
    deliveredquantity numeric(16,5),
    locationsquantity numeric(16,5),
    state character varying(255),
    issubcontracted boolean DEFAULT false,
    ispurchased boolean DEFAULT false,
    productnumber character varying(255),
    productname character varying(1024),
    productunit character varying(255),
    producttype character varying(255),
    planedquantity numeric(16,5),
    producequantity numeric(16,5),
    fromselectedorder boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    company_id bigint,
    price numeric(12,5),
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersupplies_coverageproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersupplies_coverageproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersupplies_coverageproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersupplies_coverageproduct_id_seq OWNED BY public.arch_ordersupplies_coverageproduct.id;


--
-- Name: arch_ordersupplies_coverageproductlogging; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersupplies_coverageproductlogging (
    id bigint NOT NULL,
    coverageproduct_id bigint,
    date timestamp without time zone,
    delivery_id bigint,
    order_id bigint,
    operation_id bigint,
    reservemissingquantity numeric(16,5),
    changes numeric(16,5),
    eventtype character varying(255),
    state character varying(255),
    subcontractedoperation_id bigint,
    deliverynumberexternal character varying(255),
    warehousenumber character varying(255),
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersupplies_coverageproductlogging_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersupplies_coverageproductlogging_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersupplies_coverageproductlogging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersupplies_coverageproductlogging_id_seq OWNED BY public.arch_ordersupplies_coverageproductlogging.id;


--
-- Name: arch_ordersupplies_coverageproductselected; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersupplies_coverageproductselected (
    id bigint NOT NULL,
    coverageproduct_id bigint,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersupplies_coverageproductselected_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersupplies_coverageproductselected_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersupplies_coverageproductselected_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersupplies_coverageproductselected_id_seq OWNED BY public.arch_ordersupplies_coverageproductselected.id;


--
-- Name: arch_ordersupplies_materialrequirementcoverage; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_ordersupplies_materialrequirementcoverage (
    id bigint NOT NULL,
    number character varying(255),
    coveragetodate timestamp without time zone,
    actualdate timestamp without time zone,
    generateddate timestamp without time zone,
    generatedby character varying(255),
    generated boolean,
    saved boolean,
    coveragetype character varying(255),
    includedraftdeliveries boolean,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    filename character varying(1024),
    automaticsavecoverage boolean DEFAULT false,
    order_id bigint,
    entityversion bigint DEFAULT 0,
    ordergenerationinprogress boolean DEFAULT false,
    forordersgroup_id bigint,
    ordersgroupsgenerated boolean DEFAULT false,
    includeincalculationdeliveries character varying(255) DEFAULT '01confirmedDeliveries'::character varying,
    archived boolean DEFAULT false
);


--
-- Name: arch_ordersupplies_materialrequirementcoverage_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_ordersupplies_materialrequirementcoverage_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_ordersupplies_materialrequirementcoverage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_ordersupplies_materialrequirementcoverage_id_seq OWNED BY public.arch_ordersupplies_materialrequirementcoverage.id;


--
-- Name: arch_productflowthrudivision_issue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productflowthrudivision_issue (
    id bigint NOT NULL,
    warehouseissue_id bigint,
    product_id bigint,
    productincomponent_id bigint,
    demandquantity numeric(12,5),
    locationsquantity numeric(12,5),
    issuequantity numeric(12,5),
    location_id bigint,
    entityversion bigint DEFAULT 0,
    locationtoquantity numeric(12,5),
    quantityperunit numeric(12,5),
    issued boolean DEFAULT false,
    storagelocation_id bigint,
    additionaldemandquantity numeric(12,5),
    conversion numeric(12,5),
    dateofissued timestamp without time zone,
    document_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_productflowthrudivision_issue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productflowthrudivision_issue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productflowthrudivision_issue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productflowthrudivision_issue_id_seq OWNED BY public.arch_productflowthrudivision_issue.id;


--
-- Name: arch_productflowthrudivision_materialavailability; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productflowthrudivision_materialavailability (
    id bigint NOT NULL,
    order_id bigint,
    product_id bigint,
    availablequantity numeric(19,5),
    requiredquantity numeric(19,5),
    unit character varying(255),
    entityversion bigint DEFAULT 0,
    location_id bigint,
    availability character varying,
    replacement boolean DEFAULT false,
    batchesid character varying(255),
    batches character varying(255),
    batchesquantity numeric(19,5),
    archived boolean DEFAULT false
);


--
-- Name: arch_productflowthrudivision_materialavailability_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productflowthrudivision_materialavailability_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productflowthrudivision_materialavailability_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productflowthrudivision_materialavailability_id_seq OWNED BY public.arch_productflowthrudivision_materialavailability.id;


--
-- Name: arch_productflowthrudivision_productstoissue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productflowthrudivision_productstoissue (
    id bigint NOT NULL,
    warehouseissue_id bigint,
    product_id bigint,
    productincomponent_id bigint,
    demandquantity numeric(12,5),
    locationsquantity numeric(12,5),
    placeofissuequantity numeric(12,5),
    issuequantity numeric(12,5),
    location_id bigint,
    entityversion bigint DEFAULT 0,
    issued boolean DEFAULT false,
    storagelocation_id bigint,
    additionaldemandquantity numeric(12,5),
    conversion numeric(12,5),
    correction numeric(12,5),
    archived boolean DEFAULT false
);


--
-- Name: arch_productflowthrudivision_productstoissue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productflowthrudivision_productstoissue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productflowthrudivision_productstoissue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productflowthrudivision_productstoissue_id_seq OWNED BY public.arch_productflowthrudivision_productstoissue.id;


--
-- Name: arch_productflowthrudivision_producttoissuecorrection; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productflowthrudivision_producttoissuecorrection (
    id bigint NOT NULL,
    producttoissuecorrectionhelper_id bigint,
    warehouseissue_id bigint,
    product_id bigint,
    correctionquantity numeric(12,5),
    correctionquantityinadditionalunit numeric(12,5),
    quantitytoissue numeric(12,5),
    demandquantity numeric(12,5),
    conversion numeric(12,5),
    location_id bigint,
    description character varying(255),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    productstoissue_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_productflowthrudivision_producttoissuecorrection_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productflowthrudivision_producttoissuecorrection_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productflowthrudivision_producttoissuecorrection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productflowthrudivision_producttoissuecorrection_id_seq OWNED BY public.arch_productflowthrudivision_producttoissuecorrection.id;


--
-- Name: arch_productflowthrudivision_warehouseissue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productflowthrudivision_warehouseissue (
    id bigint NOT NULL,
    number character varying(255),
    description character varying(2048),
    order_id bigint,
    placeofissue_id bigint,
    division_id bigint,
    workerwhoissued_id bigint,
    workerwhocollected_id bigint,
    dateofissued timestamp without time zone,
    dateofcreation timestamp without time zone,
    technologyoperationcomponent_id bigint,
    collectionproducts character varying(255) DEFAULT '01onOrder'::character varying,
    state character varying(255) DEFAULT '01draft'::character varying,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    entityversion bigint DEFAULT 0,
    productstoissuemode character varying(255) DEFAULT '01allInputProducts'::character varying,
    archived boolean DEFAULT false
);


--
-- Name: arch_productflowthrudivision_warehouseissue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productflowthrudivision_warehouseissue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productflowthrudivision_warehouseissue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productflowthrudivision_warehouseissue_id_seq OWNED BY public.arch_productflowthrudivision_warehouseissue.id;


--
-- Name: arch_productflowthrudivision_warehouseissuestatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productflowthrudivision_warehouseissuestatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    warehouseissue_id bigint,
    shift_id bigint,
    additionalinformation character varying(255),
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_productflowthrudivision_warehouseissuestatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productflowthrudivision_warehouseissuestatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productflowthrudivision_warehouseissuestatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productflowthrudivision_warehouseissuestatechange_id_seq OWNED BY public.arch_productflowthrudivision_warehouseissuestatechange.id;


--
-- Name: arch_productioncounting_anomaly; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productioncounting_anomaly (
    id bigint NOT NULL,
    number character varying(255),
    productiontracking_id bigint,
    masterproduct_id bigint,
    product_id bigint,
    usedquantity numeric(14,5),
    state character varying(255) DEFAULT '01draft'::character varying,
    issued boolean DEFAULT false,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    location_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_productioncounting_anomaly_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productioncounting_anomaly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productioncounting_anomaly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productioncounting_anomaly_id_seq OWNED BY public.arch_productioncounting_anomaly.id;


--
-- Name: arch_productioncounting_anomalyexplanation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productioncounting_anomalyexplanation (
    id bigint NOT NULL,
    anomaly_id bigint,
    product_id bigint,
    location_id bigint,
    usedquantity numeric(14,5),
    givenquantity numeric(14,5),
    givenunit character varying(255),
    usewaste boolean DEFAULT false,
    description character varying(1024),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_productioncounting_anomalyexplanation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productioncounting_anomalyexplanation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productioncounting_anomalyexplanation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productioncounting_anomalyexplanation_id_seq OWNED BY public.arch_productioncounting_anomalyexplanation.id;


--
-- Name: arch_productioncounting_anomalyproductiontrackingentryhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productioncounting_anomalyproductiontrackingentryhelper (
    id bigint NOT NULL,
    anomalyproductiontracking_id bigint,
    trackingoperationproductincomponent_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_productioncounting_anomalyproductiontrackingentryhelper_id; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productioncounting_anomalyproductiontrackingentryhelper_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productioncounting_anomalyproductiontrackingentryhelper_id; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productioncounting_anomalyproductiontrackingentryhelper_id OWNED BY public.arch_productioncounting_anomalyproductiontrackingentryhelper.id;


--
-- Name: arch_productioncounting_anomalyreasoncontainer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productioncounting_anomalyreasoncontainer (
    id bigint NOT NULL,
    anomalyproductiontrackingentryhelper_id bigint,
    anomalyreason_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_productioncounting_anomalyreasoncontainer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productioncounting_anomalyreasoncontainer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productioncounting_anomalyreasoncontainer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productioncounting_anomalyreasoncontainer_id_seq OWNED BY public.arch_productioncounting_anomalyreasoncontainer.id;


--
-- Name: arch_productioncounting_lack; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productioncounting_lack (
    id bigint NOT NULL,
    trackingoperationproductoutcomponent_id bigint,
    lackquantity numeric(14,5),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_productioncounting_lack_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productioncounting_lack_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productioncounting_lack_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productioncounting_lack_id_seq OWNED BY public.arch_productioncounting_lack.id;


--
-- Name: arch_productioncounting_prodoutresourceattrval; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productioncounting_prodoutresourceattrval (
    id bigint NOT NULL,
    trackingoperationproductoutcomponent_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_productioncounting_prodoutresourceattrval_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productioncounting_prodoutresourceattrval_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productioncounting_prodoutresourceattrval_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productioncounting_prodoutresourceattrval_id_seq OWNED BY public.arch_productioncounting_prodoutresourceattrval.id;


--
-- Name: arch_productioncounting_productiontracking_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productioncounting_productiontracking_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productioncounting_productiontracking_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productioncounting_productiontracking_id_seq OWNED BY public.arch_productioncounting_productiontracking.id;


--
-- Name: arch_productioncounting_productiontrackingattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productioncounting_productiontrackingattachment (
    id bigint NOT NULL,
    productiontracking_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_productioncounting_productiontrackingattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productioncounting_productiontrackingattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productioncounting_productiontrackingattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productioncounting_productiontrackingattachment_id_seq OWNED BY public.arch_productioncounting_productiontrackingattachment.id;


--
-- Name: arch_productioncounting_productiontrackingdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.arch_productioncounting_productiontrackingdto AS
 SELECT arch_mv_productioncounting_productiontrackingdto.id,
    arch_mv_productioncounting_productiontrackingdto.number,
    arch_mv_productioncounting_productiontrackingdto.state,
    arch_mv_productioncounting_productiontrackingdto.createdate,
    arch_mv_productioncounting_productiontrackingdto.lasttracking,
    arch_mv_productioncounting_productiontrackingdto.timerangefrom,
    arch_mv_productioncounting_productiontrackingdto.timerangeto,
    arch_mv_productioncounting_productiontrackingdto.active,
    arch_mv_productioncounting_productiontrackingdto.order_id,
    arch_mv_productioncounting_productiontrackingdto.ordernumber,
    arch_mv_productioncounting_productiontrackingdto.orderstate,
    arch_mv_productioncounting_productiontrackingdto.technologyoperationcomponent_id,
    arch_mv_productioncounting_productiontrackingdto.technologyoperationcomponentnumber,
    arch_mv_productioncounting_productiontrackingdto.operation_id,
    arch_mv_productioncounting_productiontrackingdto.shift_id,
    arch_mv_productioncounting_productiontrackingdto.shiftname,
    arch_mv_productioncounting_productiontrackingdto.staff_id,
    arch_mv_productioncounting_productiontrackingdto.staffname,
    arch_mv_productioncounting_productiontrackingdto.division_id,
    arch_mv_productioncounting_productiontrackingdto.divisionnumber,
    arch_mv_productioncounting_productiontrackingdto.subcontractor_id,
    arch_mv_productioncounting_productiontrackingdto.subcontractorname,
    arch_mv_productioncounting_productiontrackingdto.repairorder_id,
    arch_mv_productioncounting_productiontrackingdto.repairordernumber,
    arch_mv_productioncounting_productiontrackingdto.correctionnumber,
    arch_mv_productioncounting_productiontrackingdto.productionline_id,
    arch_mv_productioncounting_productiontrackingdto.productionlinenumber,
    arch_mv_productioncounting_productiontrackingdto.ordersgroup,
    arch_mv_productioncounting_productiontrackingdto.productnumber,
    arch_mv_productioncounting_productiontrackingdto.productunit,
    arch_mv_productioncounting_productiontrackingdto.usedquantity,
    arch_mv_productioncounting_productiontrackingdto.companynumber,
    arch_mv_productioncounting_productiontrackingdto.outproductnumber
   FROM public.arch_mv_productioncounting_productiontrackingdto;


--
-- Name: arch_productioncounting_productiontrackingdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productioncounting_productiontrackingdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productioncounting_productiontrackingstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productioncounting_productiontrackingstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255) DEFAULT '01inProgress'::character varying,
    phase integer,
    worker character varying(255),
    productiontracking_id bigint,
    shift_id bigint,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_productioncounting_productiontrackingstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productioncounting_productiontrackingstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productioncounting_productiontrackingstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productioncounting_productiontrackingstatechange_id_seq OWNED BY public.arch_productioncounting_productiontrackingstatechange.id;


--
-- Name: arch_productioncounting_staffworktime; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productioncounting_staffworktime (
    id bigint NOT NULL,
    productionrecord_id bigint,
    worker_id bigint,
    labortime integer DEFAULT 0,
    effectiveexecutiontimestart timestamp without time zone,
    effectiveexecutiontimeend timestamp without time zone,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_productioncounting_staffworktime_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productioncounting_staffworktime_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productioncounting_staffworktime_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productioncounting_staffworktime_id_seq OWNED BY public.arch_productioncounting_staffworktime.id;


--
-- Name: arch_productioncounting_trackinginproductreplacementhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productioncounting_trackinginproductreplacementhelper (
    id bigint NOT NULL,
    productiontracking_id bigint,
    product_id bigint,
    quantity numeric(14,5),
    basicproduct_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_productioncounting_trackinginproductreplacementhelper_id_s; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productioncounting_trackinginproductreplacementhelper_id_s
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productioncounting_trackinginproductreplacementhelper_id_s; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productioncounting_trackinginproductreplacementhelper_id_s OWNED BY public.arch_productioncounting_trackinginproductreplacementhelper.id;


--
-- Name: arch_productioncounting_trackingoperationproductincomponent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productioncounting_trackingoperationproductincomponent (
    id bigint NOT NULL,
    productiontracking_id bigint,
    product_id bigint,
    usedquantity numeric(14,5),
    balance numeric(14,5),
    obtainedquantity numeric(14,5),
    remainedquantity numeric(14,5),
    effectiveusedquantity numeric(15,5),
    givenunit character varying(255),
    givenquantity numeric(14,5),
    entityversion bigint DEFAULT 0,
    typeofmaterial character varying(255) DEFAULT '01component'::character varying,
    wasteused boolean DEFAULT false,
    wasteusedonly boolean DEFAULT false,
    wasteusedquantity numeric,
    wasteunit character varying,
    additionalinformation character varying,
    replacementto_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_productioncounting_trackingoperationproductincomponent_id_; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productioncounting_trackingoperationproductincomponent_id_
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productioncounting_trackingoperationproductincomponent_id_; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productioncounting_trackingoperationproductincomponent_id_ OWNED BY public.arch_productioncounting_trackingoperationproductincomponent.id;


--
-- Name: arch_productioncounting_trackingoperationproductoutcomponent_id; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productioncounting_trackingoperationproductoutcomponent_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productioncounting_trackingoperationproductoutcomponent_id; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productioncounting_trackingoperationproductoutcomponent_id OWNED BY public.arch_productioncounting_trackingoperationproductoutcomponent.id;


--
-- Name: arch_productioncounting_usedbatch; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productioncounting_usedbatch (
    id bigint NOT NULL,
    trackingoperationproductincomponent_id bigint,
    batch_id bigint,
    quantity numeric(14,5),
    archived boolean DEFAULT false
);


--
-- Name: arch_productioncounting_usedbatch_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productioncounting_usedbatch_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productioncounting_usedbatch_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productioncounting_usedbatch_id_seq OWNED BY public.arch_productioncounting_usedbatch.id;


--
-- Name: arch_productionpershift_dailyprogress; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productionpershift_dailyprogress (
    id bigint NOT NULL,
    progressforday_id bigint,
    shift_id bigint,
    quantity numeric(12,5),
    locked boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    efficiencytime integer,
    archived boolean DEFAULT false
);


--
-- Name: arch_productionpershift_dailyprogress_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productionpershift_dailyprogress_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productionpershift_dailyprogress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productionpershift_dailyprogress_id_seq OWNED BY public.arch_productionpershift_dailyprogress.id;


--
-- Name: arch_productionpershift_productionpershift; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productionpershift_productionpershift (
    id bigint NOT NULL,
    order_id bigint,
    plannedprogresscorrectioncomment text,
    orderfinishdate timestamp without time zone,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_productionpershift_productionpershift_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productionpershift_productionpershift_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productionpershift_productionpershift_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productionpershift_productionpershift_id_seq OWNED BY public.arch_productionpershift_productionpershift.id;


--
-- Name: arch_productionpershift_progressforday; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productionpershift_progressforday (
    id bigint NOT NULL,
    day integer,
    corrected boolean DEFAULT false,
    dateofday date,
    actualdateofday date,
    entityversion bigint DEFAULT 0,
    productionpershift_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_productionpershift_progressforday_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productionpershift_progressforday_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productionpershift_progressforday_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productionpershift_progressforday_id_seq OWNED BY public.arch_productionpershift_progressforday.id;


--
-- Name: arch_productionpershift_reasontypeofcorrectionplan; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productionpershift_reasontypeofcorrectionplan (
    id bigint NOT NULL,
    productionpershift_id bigint,
    reasontype character varying(255),
    date timestamp without time zone,
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_productionpershift_reasontypeofcorrectionplan_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productionpershift_reasontypeofcorrectionplan_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productionpershift_reasontypeofcorrectionplan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productionpershift_reasontypeofcorrectionplan_id_seq OWNED BY public.arch_productionpershift_reasontypeofcorrectionplan.id;


--
-- Name: arch_productionscheduling_opercomptimecalculation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productionscheduling_opercomptimecalculation (
    id bigint NOT NULL,
    ordertimecalculation_id bigint,
    technologyoperationcomponent_id bigint,
    operationoffset integer,
    effectiveoperationrealizationtime integer,
    effectivedatefrom timestamp without time zone,
    effectivedateto timestamp without time zone,
    duration integer DEFAULT 0,
    machineworktime integer DEFAULT 0,
    laborworktime integer DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_productionscheduling_opercomptimecalculation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productionscheduling_opercomptimecalculation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productionscheduling_opercomptimecalculation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productionscheduling_opercomptimecalculation_id_seq OWNED BY public.arch_productionscheduling_opercomptimecalculation.id;


--
-- Name: arch_productionscheduling_ordertimecalculation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_productionscheduling_ordertimecalculation (
    id bigint NOT NULL,
    order_id bigint,
    effectivedatefrom timestamp without time zone,
    effectivedateto timestamp without time zone,
    archived boolean DEFAULT false
);


--
-- Name: arch_productionscheduling_ordertimecalculation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_productionscheduling_ordertimecalculation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_productionscheduling_ordertimecalculation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_productionscheduling_ordertimecalculation_id_seq OWNED BY public.arch_productionscheduling_ordertimecalculation.id;


--
-- Name: arch_qualitycontrol_qualitycontrol; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_qualitycontrol_qualitycontrol (
    id bigint NOT NULL,
    number character varying(255),
    product_id bigint,
    qualitycard_id bigint,
    controltype character varying(255) DEFAULT '01final'::character varying,
    batch_id bigint,
    date date,
    staff_id bigint,
    order_id bigint,
    qualityrating character varying(255),
    state character varying(255) DEFAULT '01new'::character varying,
    delivery_id bigint,
    description character varying(2048),
    archived boolean DEFAULT false
);


--
-- Name: arch_qualitycontrol_qualitycontrol_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_qualitycontrol_qualitycontrol_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_qualitycontrol_qualitycontrol_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_qualitycontrol_qualitycontrol_id_seq OWNED BY public.arch_qualitycontrol_qualitycontrol.id;


--
-- Name: arch_qualitycontrol_qualitycontrolattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_qualitycontrol_qualitycontrolattachment (
    id bigint NOT NULL,
    qualitycontrol_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255),
    archived boolean DEFAULT false
);


--
-- Name: arch_qualitycontrol_qualitycontrolattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_qualitycontrol_qualitycontrolattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_qualitycontrol_qualitycontrolattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_qualitycontrol_qualitycontrolattachment_id_seq OWNED BY public.arch_qualitycontrol_qualitycontrolattachment.id;


--
-- Name: arch_qualitycontrol_qualitycontrolattributeprodtracking; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_qualitycontrol_qualitycontrolattributeprodtracking (
    id bigint NOT NULL,
    productiontracking_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255),
    fromtechnology boolean DEFAULT false,
    moment character varying(255),
    adddate timestamp without time zone,
    archived boolean DEFAULT false
);


--
-- Name: arch_qualitycontrol_qualitycontrolattributeprodtracking_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_qualitycontrol_qualitycontrolattributeprodtracking_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_qualitycontrol_qualitycontrolattributeprodtracking_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_qualitycontrol_qualitycontrolattributeprodtracking_id_seq OWNED BY public.arch_qualitycontrol_qualitycontrolattributeprodtracking.id;


--
-- Name: arch_qualitycontrol_qualitycontrolattributevalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_qualitycontrol_qualitycontrolattributevalue (
    id bigint NOT NULL,
    qualitycontrol_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255),
    productiontracking_id bigint,
    fromqualitycard boolean DEFAULT false,
    priority integer,
    archived boolean DEFAULT false
);


--
-- Name: arch_qualitycontrol_qualitycontrolattributevalue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_qualitycontrol_qualitycontrolattributevalue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_qualitycontrol_qualitycontrolattributevalue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_qualitycontrol_qualitycontrolattributevalue_id_seq OWNED BY public.arch_qualitycontrol_qualitycontrolattributevalue.id;


--
-- Name: arch_qualitycontrol_qualitycontrolresource; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_qualitycontrol_qualitycontrolresource (
    id bigint NOT NULL,
    resourcenumber character varying(255),
    qualitycontrol_id bigint,
    resource_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_qualitycontrol_qualitycontrolresource_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_qualitycontrol_qualitycontrolresource_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_qualitycontrol_qualitycontrolresource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_qualitycontrol_qualitycontrolresource_id_seq OWNED BY public.arch_qualitycontrol_qualitycontrolresource.id;


--
-- Name: arch_qualitycontrol_qualitycontrolstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_qualitycontrol_qualitycontrolstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    qualitycontrol_id bigint,
    shift_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_qualitycontrol_qualitycontrolstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_qualitycontrol_qualitycontrolstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_qualitycontrol_qualitycontrolstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_qualitycontrol_qualitycontrolstatechange_id_seq OWNED BY public.arch_qualitycontrol_qualitycontrolstatechange.id;


--
-- Name: arch_repairs_repairorder_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_repairs_repairorder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_repairs_repairorder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_repairs_repairorder_id_seq OWNED BY public.arch_repairs_repairorder.id;


--
-- Name: arch_repairs_repairorderproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_repairs_repairorderproduct (
    id bigint NOT NULL,
    trackingoperationproductincomponent_id bigint,
    division_id bigint,
    location_id bigint,
    product_id bigint,
    faulttype_id bigint,
    description character varying(2048),
    givenquantity numeric(12,5),
    givenunit character varying(255),
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_repairs_repairorderproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_repairs_repairorderproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_repairs_repairorderproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_repairs_repairorderproduct_id_seq OWNED BY public.arch_repairs_repairorderproduct.id;


--
-- Name: arch_repairs_repairorderstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_repairs_repairorderstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    phase integer,
    worker character varying(255),
    repairorder_id bigint,
    shift_id bigint,
    status character varying,
    archived boolean DEFAULT false
);


--
-- Name: arch_repairs_repairorderstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_repairs_repairorderstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_repairs_repairorderstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_repairs_repairorderstatechange_id_seq OWNED BY public.arch_repairs_repairorderstatechange.id;


--
-- Name: arch_repairs_repairorderworktime; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_repairs_repairorderworktime (
    id bigint NOT NULL,
    repairorder_id bigint,
    staff_id bigint,
    labortime integer DEFAULT 0,
    effectiveexecutiontimestart timestamp without time zone,
    effectiveexecutiontimeend timestamp without time zone,
    archived boolean DEFAULT false
);


--
-- Name: arch_repairs_repairorderworktime_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_repairs_repairorderworktime_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_repairs_repairorderworktime_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_repairs_repairorderworktime_id_seq OWNED BY public.arch_repairs_repairorderworktime.id;


--
-- Name: arch_states_message; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_states_message (
    id bigint NOT NULL,
    type character varying(255),
    translationkey character varying(255),
    translationargs character varying(255),
    correspondfieldname character varying(255),
    autoclose boolean DEFAULT true,
    productiontrackingstatechange_id bigint,
    deliverystatechange_id bigint,
    assignmenttoshiftstatechange_id bigint,
    technologystatechange_id bigint,
    orderstatechange_id bigint,
    extrusionprotocolstatechange_id bigint,
    confectionprotocolstatechange_id bigint,
    palletstatechange_id bigint,
    batchstatechange_id bigint,
    trackingrecordstatechange_id bigint,
    requestforquotationstatechange_id bigint,
    offerstatechange_id bigint,
    negotiationstatechange_id bigint,
    warehouseissuestatechange_id bigint,
    palletlabelstatechange_id bigint,
    maintenanceeventstatechange_id bigint,
    entityversion bigint DEFAULT 0,
    plannedeventstatechange_id bigint,
    recurringeventstatechange_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_states_message_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_states_message_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_states_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_states_message_id_seq OWNED BY public.arch_states_message.id;


--
-- Name: arch_stoppage_stoppage; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_stoppage_stoppage (
    id bigint NOT NULL,
    order_id bigint,
    duration integer,
    entityversion bigint DEFAULT 0,
    productiontracking_id bigint,
    reason_id bigint,
    description character varying(1024),
    datefrom timestamp without time zone,
    dateto timestamp without time zone,
    archived boolean DEFAULT false
);


--
-- Name: arch_stoppage_stoppage_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_stoppage_stoppage_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_stoppage_stoppage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_stoppage_stoppage_id_seq OWNED BY public.arch_stoppage_stoppage.id;


--
-- Name: arch_technologies_barcodeoperationcomponent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_technologies_barcodeoperationcomponent (
    id bigint NOT NULL,
    operationcomponent_id bigint,
    code character varying(20),
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0,
    order_id bigint,
    archived boolean DEFAULT false
);


--
-- Name: arch_technologies_barcodeoperationcomponent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_technologies_barcodeoperationcomponent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_technologies_barcodeoperationcomponent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_technologies_barcodeoperationcomponent_id_seq OWNED BY public.arch_technologies_barcodeoperationcomponent.id;


--
-- Name: arch_urcmaterialavailability_requiredcomponent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.arch_urcmaterialavailability_requiredcomponent (
    id bigint NOT NULL,
    order_id bigint,
    technology_id bigint,
    product_id bigint,
    availablequantity numeric(19,5),
    reservedquantity numeric(19,5),
    requiredquantity numeric(19,5),
    unit character varying(255),
    availability character varying(255),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    entityversion bigint DEFAULT 0,
    archived boolean DEFAULT false
);


--
-- Name: arch_urcmaterialavailability_requiredcomponent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.arch_urcmaterialavailability_requiredcomponent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: arch_urcmaterialavailability_requiredcomponent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.arch_urcmaterialavailability_requiredcomponent_id_seq OWNED BY public.arch_urcmaterialavailability_requiredcomponent.id;


--
-- Name: assignmenttoshift_assignmenttoshift; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.assignmenttoshift_assignmenttoshift (
    id bigint NOT NULL,
    startdate date,
    shift_id bigint,
    state character varying(255) DEFAULT '01draft'::character varying,
    approvedattendancelist boolean,
    active boolean DEFAULT true,
    externalnumber integer NOT NULL,
    externalsynchronized boolean DEFAULT true,
    showlaststatechangeresult boolean DEFAULT false,
    laststatechangefails boolean DEFAULT false,
    laststatechangefailcause character varying(2048),
    factory_id bigint,
    entityversion bigint DEFAULT 0,
    crew_id bigint
);


--
-- Name: assignmenttoshift_assignmenttoshift_externalnumber_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.assignmenttoshift_assignmenttoshift_externalnumber_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: assignmenttoshift_assignmenttoshift_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.assignmenttoshift_assignmenttoshift_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: assignmenttoshift_assignmenttoshift_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.assignmenttoshift_assignmenttoshift_id_seq OWNED BY public.assignmenttoshift_assignmenttoshift.id;


--
-- Name: assignmenttoshift_assignmenttoshiftreport; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.assignmenttoshift_assignmenttoshiftreport (
    id bigint NOT NULL,
    number character varying(1024),
    name character varying(1024),
    datefrom date,
    dateto date,
    shift_id bigint,
    filename character varying(255),
    generated boolean DEFAULT false,
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    factory_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: assignmenttoshift_assignmenttoshiftreport_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.assignmenttoshift_assignmenttoshiftreport_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: assignmenttoshift_assignmenttoshiftreport_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.assignmenttoshift_assignmenttoshiftreport_id_seq OWNED BY public.assignmenttoshift_assignmenttoshiftreport.id;


--
-- Name: assignmenttoshift_assignmenttoshiftstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.assignmenttoshift_assignmenttoshiftstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    assignmenttoshift_id bigint,
    shift_id bigint,
    additionalinformation character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: assignmenttoshift_assignmenttoshiftstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.assignmenttoshift_assignmenttoshiftstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: assignmenttoshift_assignmenttoshiftstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.assignmenttoshift_assignmenttoshiftstatechange_id_seq OWNED BY public.assignmenttoshift_assignmenttoshiftstatechange.id;


--
-- Name: assignmenttoshift_multiassignmenttoshift; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.assignmenttoshift_multiassignmenttoshift (
    id bigint NOT NULL,
    productionline_id bigint,
    occupationtype character varying(255),
    occupationtypename character varying(255),
    occupationtypeenum character varying(255),
    masterorder_id bigint,
    assignmenttoshift_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: assignmenttoshift_multiassignmenttoshift_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.assignmenttoshift_multiassignmenttoshift_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: assignmenttoshift_multiassignmenttoshift_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.assignmenttoshift_multiassignmenttoshift_id_seq OWNED BY public.assignmenttoshift_multiassignmenttoshift.id;


--
-- Name: assignmenttoshift_staffassignmenttoshift; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.assignmenttoshift_staffassignmenttoshift (
    id bigint NOT NULL,
    assignmenttoshift_id bigint,
    worker_id bigint,
    productionline_id bigint,
    occupationtype character varying(255),
    occupationtypename character varying(255),
    state character varying(255) DEFAULT '01simple'::character varying,
    occupationtypeenum character varying(255),
    occupationtypevalueforgrid character varying(255),
    masterorder_id bigint,
    entityversion bigint DEFAULT 0,
    description character varying(255)
);


--
-- Name: assignmenttoshift_staffassignmenttoshift_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.assignmenttoshift_staffassignmenttoshift_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: assignmenttoshift_staffassignmenttoshift_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.assignmenttoshift_staffassignmenttoshift_id_seq OWNED BY public.assignmenttoshift_staffassignmenttoshift.id;


--
-- Name: avglaborcostcalcfororder_assignmentworkertoshift; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.avglaborcostcalcfororder_assignmentworkertoshift (
    id bigint NOT NULL,
    worker_id bigint,
    assignmenttoshift_id bigint,
    workedhours numeric(12,5),
    avglaborcostcalcfororder_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: avglaborcostcalcfororder_assignmentworkertoshift_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.avglaborcostcalcfororder_assignmentworkertoshift_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: avglaborcostcalcfororder_assignmentworkertoshift_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.avglaborcostcalcfororder_assignmentworkertoshift_id_seq OWNED BY public.avglaborcostcalcfororder_assignmentworkertoshift.id;


--
-- Name: avglaborcostcalcfororder_avglaborcostcalcfororder; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.avglaborcostcalcfororder_avglaborcostcalcfororder (
    id bigint NOT NULL,
    startdate date,
    finishdate date,
    order_id bigint,
    productionline_id bigint,
    basedon character varying(255) DEFAULT '01assignment'::character varying,
    averagelaborhourlycost numeric(12,5),
    entityversion bigint DEFAULT 0
);


--
-- Name: avglaborcostcalcfororder_avglaborcostcalcfororder_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.avglaborcostcalcfororder_avglaborcostcalcfororder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: avglaborcostcalcfororder_avglaborcostcalcfororder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.avglaborcostcalcfororder_avglaborcostcalcfororder_id_seq OWNED BY public.avglaborcostcalcfororder_avglaborcostcalcfororder.id;


--
-- Name: basic_address_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_address_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_address_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_address_id_seq OWNED BY public.basic_address.id;


--
-- Name: basic_assortment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_assortment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_assortment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_assortment_id_seq OWNED BY public.basic_assortment.id;


--
-- Name: basic_assortmentelement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_assortmentelement (
    id bigint NOT NULL,
    descriptiontype character varying(255),
    description character varying(2048),
    assortment_id bigint,
    main boolean DEFAULT false
);


--
-- Name: basic_assortmentelement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_assortmentelement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_assortmentelement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_assortmentelement_id_seq OWNED BY public.basic_assortmentelement.id;


--
-- Name: basic_productattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_productattachment (
    id bigint NOT NULL,
    product_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255)
);


--
-- Name: basic_qualitycard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_qualitycard (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(2048),
    description character varying(2048),
    state character varying(255) DEFAULT '01new'::character varying,
    sampling character varying(255)
);


--
-- Name: basic_subassembly; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_subassembly (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    workstationtype_id bigint,
    workstation_id bigint,
    serialnumber character varying(255),
    series character varying(255),
    producer character varying(255),
    productiondate date,
    lastrepairsdate date,
    active boolean DEFAULT true,
    type character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: basic_subassemblyattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_subassemblyattachment (
    id bigint NOT NULL,
    subassembly_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: basic_workstation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_workstation (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    description character varying(2048),
    workstationtype_id bigint,
    operation_id bigint,
    active boolean DEFAULT true,
    productionline_id bigint,
    division_id bigint,
    serialnumber character varying(255),
    udtnumber character varying(255),
    series character varying(255),
    producer character varying(255),
    productiondate date,
    wnknumber character varying(255),
    entityversion bigint DEFAULT 0,
    staff_id bigint,
    dateofadmission date,
    dateofwithdrawal date,
    state character varying(255) DEFAULT '01stopped'::character varying,
    minimumdimension numeric(12,5),
    minimumdimensionunit character varying(255),
    maximumdimension numeric(12,5),
    maximumdimensionunit character varying(255),
    virtual boolean DEFAULT false
);


--
-- Name: basic_workstationattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_workstationattachment (
    id bigint NOT NULL,
    workstation_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: cmmsmachineparts_machinepartattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_machinepartattachment (
    id bigint NOT NULL,
    product_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: cmmsmachineparts_tool; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_tool (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    description character varying(2048),
    toolcategory character varying(255),
    producer character varying(255),
    inventorynumber character varying(255),
    serialnumber character varying(255),
    unit character varying(255)
);


--
-- Name: cmmsmachineparts_toolattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_toolattachment (
    id bigint NOT NULL,
    tool_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255)
);


--
-- Name: deliveries_deliveryattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.deliveries_deliveryattachment (
    id bigint NOT NULL,
    delivery_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255)
);


--
-- Name: orders_order; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_order (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    description character varying(2048),
    commentreasontypecorrectiondatefrom character varying(255),
    commentreasontypecorrectiondateto character varying(255),
    commentreasondeviationeffectivestart character varying(255),
    commentreasondeviationeffectiveend character varying(255),
    externalnumber character varying(255),
    commentreasontypedeviationsquantity character varying(255),
    datefrom timestamp without time zone,
    dateto timestamp without time zone,
    effectivedatefrom timestamp without time zone,
    effectivedateto timestamp without time zone,
    deadline timestamp without time zone,
    correcteddatefrom timestamp without time zone,
    correcteddateto timestamp without time zone,
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    state character varying(255),
    company_id bigint,
    product_id bigint,
    technology_id bigint,
    productionline_id bigint,
    plannedquantity numeric(12,5),
    donequantity numeric(12,5),
    externalsynchronized boolean DEFAULT true,
    commissionedplannedquantity numeric(12,5),
    commissionedcorrectedquantity numeric(12,5),
    amountofproductproduced numeric(12,5),
    remainingamountofproducttoproduce numeric(12,5),
    ownlinechangeoverduration integer,
    registerproductiontime boolean,
    registerquantityinproduct boolean,
    laborworktime integer,
    includetpz boolean,
    inputproductsrequiredfortype character varying(255),
    generatedenddate timestamp without time zone,
    machineworktime integer,
    ownlinechangeover boolean DEFAULT false,
    registerquantityoutproduct boolean,
    operationdurationquantityunit character varying(255),
    realizationtime integer,
    calculate boolean,
    includeadditionaltime boolean,
    typeofproductionrecording character varying(255) DEFAULT '02cumulated'::character varying,
    masterorder_id bigint,
    active boolean DEFAULT true,
    productpriceperunit numeric(19,5),
    failuresyncmessage character varying(255),
    targetstate character varying(255),
    ignorerequiredcomponents boolean,
    automaticallymoveoverusage boolean DEFAULT false,
    updatecomponentsavailability boolean,
    technologyprototype_id bigint,
    level integer,
    parent_id bigint,
    ignoremissingcomponents boolean DEFAULT false,
    masterorderproduct_id bigint,
    dateschanged boolean DEFAULT false,
    sourcecorrecteddatefrom timestamp without time zone,
    sourcecorrecteddateto timestamp without time zone,
    sourcestartdate timestamp without time zone,
    sourcefinishdate timestamp without time zone,
    batchnumber character varying(255),
    root_id bigint,
    includeordersforcomponent boolean,
    plannedfinishallorders timestamp without time zone,
    plannedstartallorders timestamp without time zone,
    calculatedfinishallorders timestamp without time zone,
    registerfilled boolean,
    workplandelivered boolean DEFAULT false,
    calculatedstartallorders timestamp without time zone,
    scadacreatedorupdatestate character varying(255),
    entityversion bigint DEFAULT 0,
    workertochange character varying(255),
    masterorderproductcomponent_id bigint,
    wastesquantity numeric(12,5),
    existsrepairorders boolean DEFAULT false,
    ordercategory character varying(255),
    address_id bigint,
    finalproductiontracking boolean DEFAULT false,
    updatefinishdate boolean DEFAULT false,
    ordersgroup_id bigint,
    plannedquantityforadditionalunit numeric,
    division_id bigint,
    salesplan_id bigint,
    reportedproductionquantity numeric(12,5),
    expirationdate date,
    additionalfinalproducts character varying(255),
    optimizecuttingsolution text,
    vendorinfo character varying(255),
    priority integer DEFAULT 100
);


--
-- Name: orders_orderattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_orderattachment (
    id bigint NOT NULL,
    order_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255)
);


--
-- Name: qualitycontrol_qualitycardattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qualitycontrol_qualitycardattachment (
    id bigint NOT NULL,
    qualitycard_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255)
);


--
-- Name: qualitycontrol_qualitycontrol; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qualitycontrol_qualitycontrol (
    id bigint NOT NULL,
    number character varying(255),
    product_id bigint,
    qualitycard_id bigint,
    controltype character varying(255) DEFAULT '01final'::character varying,
    batch_id bigint,
    date date,
    staff_id bigint,
    order_id bigint,
    qualityrating character varying(255),
    state character varying(255) DEFAULT '01new'::character varying,
    delivery_id bigint,
    description character varying(2048)
);


--
-- Name: qualitycontrol_qualitycontrolattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qualitycontrol_qualitycontrolattachment (
    id bigint NOT NULL,
    qualitycontrol_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255)
);


--
-- Name: technologies_technologyattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.technologies_technologyattachment (
    id bigint NOT NULL,
    technology_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: basic_attachmentdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.basic_attachmentdto AS
 SELECT '01products'::text AS pinnedto,
    product.number AS pinnedtoobjectidentifier,
    product.name AS pinnedtoobjectidentifiername,
    (product.id)::integer AS pinnedtoobjectid,
    'basic_product'::text AS pinnedtomodelname,
    productattachment.attachment,
    productattachment.name,
    productattachment.size,
    upper((productattachment.ext)::text) AS ext,
    row_number() OVER () AS id,
    'basic/productDetails'::text AS pinnedtocorrespondingview
   FROM (public.basic_productattachment productattachment
     LEFT JOIN public.basic_product product ON ((productattachment.product_id = product.id)))
UNION ALL
 SELECT '02technologies'::text AS pinnedto,
    technology.number AS pinnedtoobjectidentifier,
    technology.name AS pinnedtoobjectidentifiername,
    (technology.id)::integer AS pinnedtoobjectid,
    'technologies_technology'::text AS pinnedtomodelname,
    technologyattachment.attachment,
    technologyattachment.name,
    technologyattachment.size,
    upper((technologyattachment.ext)::text) AS ext,
    (1000000 + row_number() OVER ()) AS id,
    'technologies/technologyDetails'::text AS pinnedtocorrespondingview
   FROM (public.technologies_technologyattachment technologyattachment
     LEFT JOIN public.technologies_technology technology ON ((technologyattachment.technology_id = technology.id)))
UNION ALL
 SELECT '03parts'::text AS pinnedto,
    machinepart.number AS pinnedtoobjectidentifier,
    machinepart.name AS pinnedtoobjectidentifiername,
    (machinepart.id)::integer AS pinnedtoobjectid,
    'basic_product'::text AS pinnedtomodelname,
    machinepartattachment.attachment,
    machinepartattachment.name,
    machinepartattachment.size,
    upper((machinepartattachment.ext)::text) AS ext,
    (2000000 + row_number() OVER ()) AS id,
    'cmmsMachineParts/machinePartDetails'::text AS pinnedtocorrespondingview
   FROM (public.cmmsmachineparts_machinepartattachment machinepartattachment
     LEFT JOIN public.basic_product machinepart ON ((machinepartattachment.product_id = machinepart.id)))
UNION ALL
 SELECT '04components'::text AS pinnedto,
    subassembly.number AS pinnedtoobjectidentifier,
    subassembly.name AS pinnedtoobjectidentifiername,
    (subassembly.id)::integer AS pinnedtoobjectid,
    'basic_product'::text AS pinnedtomodelname,
    subassemblyattachment.attachment,
    subassemblyattachment.name,
    subassemblyattachment.size,
    upper((subassemblyattachment.ext)::text) AS ext,
    (3000000 + row_number() OVER ()) AS id,
    'basic/subassemblyDetails'::text AS pinnedtocorrespondingview
   FROM (public.basic_subassemblyattachment subassemblyattachment
     LEFT JOIN public.basic_subassembly subassembly ON ((subassemblyattachment.subassembly_id = subassembly.id)))
UNION ALL
 SELECT '05batches'::text AS pinnedto,
    batch.number AS pinnedtoobjectidentifier,
    ''::text AS pinnedtoobjectidentifiername,
    (batch.id)::integer AS pinnedtoobjectid,
    'advancedgenealogy_batch'::text AS pinnedtomodelname,
    batchattachment.attachment,
    batchattachment.name,
    batchattachment.size,
    upper((batchattachment.ext)::text) AS ext,
    (4000000 + row_number() OVER ()) AS id,
    'advancedGenealogy/batchDetails'::text AS pinnedtocorrespondingview
   FROM (public.advancedgenealogy_batchattachment batchattachment
     LEFT JOIN public.advancedgenealogy_batch batch ON ((batchattachment.batch_id = batch.id)))
UNION ALL
 SELECT '06deliveries'::text AS pinnedto,
    delivery.number AS pinnedtoobjectidentifier,
    delivery.name AS pinnedtoobjectidentifiername,
    (delivery.id)::integer AS pinnedtoobjectid,
    'deliveries_delivery'::text AS pinnedtomodelname,
    deliveryattachment.attachment,
    deliveryattachment.name,
    deliveryattachment.size,
    upper((deliveryattachment.ext)::text) AS ext,
    (5000000 + row_number() OVER ()) AS id,
    'deliveries/deliveryDetails'::text AS pinnedtocorrespondingview
   FROM (public.deliveries_deliveryattachment deliveryattachment
     LEFT JOIN public.deliveries_delivery delivery ON ((deliveryattachment.delivery_id = delivery.id)))
UNION ALL
 SELECT '07qualityControls'::text AS pinnedto,
    qualitycontrol.number AS pinnedtoobjectidentifier,
    ''::text AS pinnedtoobjectidentifiername,
    (qualitycontrol.id)::integer AS pinnedtoobjectid,
    'qualitycontrol_qualitycontrol'::text AS pinnedtomodelname,
    qualitycontrolattachment.attachment,
    qualitycontrolattachment.name,
    qualitycontrolattachment.size,
    upper((qualitycontrolattachment.ext)::text) AS ext,
    (6000000 + row_number() OVER ()) AS id,
    'qualityControl/qualityControlDetails'::text AS pinnedtocorrespondingview
   FROM (public.qualitycontrol_qualitycontrolattachment qualitycontrolattachment
     LEFT JOIN public.qualitycontrol_qualitycontrol qualitycontrol ON ((qualitycontrolattachment.qualitycontrol_id = qualitycontrol.id)))
UNION ALL
 SELECT '08qualityCards'::text AS pinnedto,
    qualitycard.number AS pinnedtoobjectidentifier,
    qualitycard.name AS pinnedtoobjectidentifiername,
    (qualitycard.id)::integer AS pinnedtoobjectid,
    'basic_qualitycard'::text AS pinnedtomodelname,
    qualitycardattachment.attachment,
    qualitycardattachment.name,
    qualitycardattachment.size,
    upper((qualitycardattachment.ext)::text) AS ext,
    (7000000 + row_number() OVER ()) AS id,
    'qualityControl/qualityCardDetails'::text AS pinnedtocorrespondingview
   FROM (public.qualitycontrol_qualitycardattachment qualitycardattachment
     LEFT JOIN public.basic_qualitycard qualitycard ON ((qualitycardattachment.qualitycard_id = qualitycard.id)))
UNION ALL
 SELECT '09workstations'::text AS pinnedto,
    workstation.number AS pinnedtoobjectidentifier,
    workstation.name AS pinnedtoobjectidentifiername,
    (workstation.id)::integer AS pinnedtoobjectid,
    'basic_workstation'::text AS pinnedtomodelname,
    workstationattachment.attachment,
    workstationattachment.name,
    workstationattachment.size,
    upper((workstationattachment.ext)::text) AS ext,
    (8000000 + row_number() OVER ()) AS id,
    'basic/workstationDetails'::text AS pinnedtocorrespondingview
   FROM (public.basic_workstationattachment workstationattachment
     LEFT JOIN public.basic_workstation workstation ON ((workstationattachment.workstation_id = workstation.id)))
UNION ALL
 SELECT '10orders'::text AS pinnedto,
    o.number AS pinnedtoobjectidentifier,
    o.name AS pinnedtoobjectidentifiername,
    (o.id)::integer AS pinnedtoobjectid,
    'orders_order'::text AS pinnedtomodelname,
    orderattachment.attachment,
    orderattachment.name,
    orderattachment.size,
    upper((orderattachment.ext)::text) AS ext,
    (9000000 + row_number() OVER ()) AS id,
    'orders/orderDetails'::text AS pinnedtocorrespondingview
   FROM (public.orders_orderattachment orderattachment
     LEFT JOIN public.orders_order o ON ((orderattachment.order_id = o.id)))
UNION ALL
 SELECT '11tools'::text AS pinnedto,
    tool.number AS pinnedtoobjectidentifier,
    tool.name AS pinnedtoobjectidentifiername,
    (tool.id)::integer AS pinnedtoobjectid,
    'cmmsmachineparts_tool'::text AS pinnedtomodelname,
    toolattachment.attachment,
    toolattachment.name,
    toolattachment.size,
    upper((toolattachment.ext)::text) AS ext,
    (10000000 + row_number() OVER ()) AS id,
    'cmmsMachineParts/toolDetails'::text AS pinnedtocorrespondingview
   FROM (public.cmmsmachineparts_toolattachment toolattachment
     LEFT JOIN public.cmmsmachineparts_tool tool ON ((toolattachment.tool_id = tool.id)));


--
-- Name: basic_attachmentdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_attachmentdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_attribute; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_attribute (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    datatype character varying(255),
    valuetype character varying(255),
    "precision" integer,
    unit character varying(255),
    forproduct boolean DEFAULT false,
    forresource boolean DEFAULT false,
    forqualitycontrol boolean DEFAULT false,
    active boolean DEFAULT true
);


--
-- Name: basic_attribute_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_attribute_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_attribute_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_attribute_id_seq OWNED BY public.basic_attribute.id;


--
-- Name: basic_attributevalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_attributevalue (
    id bigint NOT NULL,
    attribute_id bigint,
    value character varying(255),
    description character varying(1024)
);


--
-- Name: basic_attributevalue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_attributevalue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_attributevalue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_attributevalue_id_seq OWNED BY public.basic_attributevalue.id;


--
-- Name: basic_company_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_company_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_company_id_seq OWNED BY public.basic_company.id;


--
-- Name: basic_country; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_country (
    id bigint NOT NULL,
    country character varying(255),
    code character varying(2),
    entityversion bigint DEFAULT 0
);


--
-- Name: basic_country_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_country_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_country_id_seq OWNED BY public.basic_country.id;


--
-- Name: basic_crew; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_crew (
    id bigint NOT NULL,
    number character varying(255),
    leader_id bigint,
    active boolean DEFAULT true,
    eventsscheduler boolean
);


--
-- Name: basic_crew_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_crew_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_crew_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_crew_id_seq OWNED BY public.basic_crew.id;


--
-- Name: basic_currency; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_currency (
    id bigint NOT NULL,
    currency character varying(255),
    alphabeticcode character varying(3),
    isocode integer,
    minorunit integer,
    exchangerate numeric(12,5) DEFAULT 1,
    entityversion bigint DEFAULT 0
);


--
-- Name: basic_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_currency_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_currency_id_seq OWNED BY public.basic_currency.id;


--
-- Name: basic_dashboardbutton; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_dashboardbutton (
    id bigint NOT NULL,
    parameter_id bigint,
    identifier character varying(255),
    item_id bigint,
    icon character varying(255),
    succession integer,
    active boolean DEFAULT false
);


--
-- Name: basic_dashboardbutton_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_dashboardbutton_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_dashboardbutton_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_dashboardbutton_id_seq OWNED BY public.basic_dashboardbutton.id;


--
-- Name: basic_division_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_division_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_division_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_division_id_seq OWNED BY public.basic_division.id;


--
-- Name: basic_factory; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_factory (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    city character varying(255),
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0,
    warehouse_id bigint
);


--
-- Name: basic_factory_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_factory_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_factory_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_factory_id_seq OWNED BY public.basic_factory.id;


--
-- Name: basic_faulttype; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_faulttype (
    id bigint NOT NULL,
    name character varying(255),
    appliesto character varying(255) DEFAULT '01workstationOrSubassembly'::character varying,
    entityversion bigint DEFAULT 0,
    isdefault boolean DEFAULT false,
    active boolean DEFAULT true
);


--
-- Name: basic_faulttype_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_faulttype_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_faulttype_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_faulttype_id_seq OWNED BY public.basic_faulttype.id;


--
-- Name: basic_forms; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_forms (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    company_id bigint,
    size numeric(12,5),
    unit character varying(255),
    active boolean DEFAULT true
);


--
-- Name: basic_forms_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_forms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_forms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_forms_id_seq OWNED BY public.basic_forms.id;


--
-- Name: basic_label; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_label (
    id bigint NOT NULL,
    name character varying(1024),
    description character varying(2048),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    active boolean DEFAULT true
);


--
-- Name: basic_label_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_label_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_label_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_label_id_seq OWNED BY public.basic_label.id;


--
-- Name: basic_licenseusage; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_licenseusage (
    id bigint NOT NULL,
    createtime timestamp without time zone,
    user_id bigint,
    staff_id bigint
);


--
-- Name: basic_licenseusage_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_licenseusage_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_licenseusage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_licenseusage_id_seq OWNED BY public.basic_licenseusage.id;


--
-- Name: basic_log; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_log (
    id bigint NOT NULL,
    createtime timestamp without time zone,
    user_id bigint,
    message text,
    item1 character varying(2048),
    item2 character varying(2048),
    item3 character varying(2048),
    details text,
    loglevel character varying(255) DEFAULT '01trace'::character varying,
    logtype character varying(255),
    action character varying(255)
);


--
-- Name: basic_log_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_log_id_seq OWNED BY public.basic_log.id;


--
-- Name: basic_machineworkingperiod; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_machineworkingperiod (
    id bigint NOT NULL,
    launchdate timestamp without time zone,
    stopdate timestamp without time zone,
    workingtime integer DEFAULT 0,
    workstation_id bigint,
    launchedby_id bigint,
    stoppedby_id bigint
);


--
-- Name: basic_machineworkingperiod_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_machineworkingperiod_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_machineworkingperiod_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_machineworkingperiod_id_seq OWNED BY public.basic_machineworkingperiod.id;


--
-- Name: basic_model; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_model (
    id bigint NOT NULL,
    name character varying(1024),
    assortment_id bigint,
    forms_id bigint,
    typeofproduct character varying(255),
    label_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    active boolean DEFAULT true
);


--
-- Name: basic_model_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_model_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_model_id_seq OWNED BY public.basic_model.id;


--
-- Name: basic_numberpattern; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_numberpattern (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    pattern character varying(255),
    usedin character varying(255),
    used boolean
);


--
-- Name: basic_numberpattern_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_numberpattern_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_numberpattern_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_numberpattern_id_seq OWNED BY public.basic_numberpattern.id;


--
-- Name: basic_numberpatternelement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_numberpatternelement (
    id bigint NOT NULL,
    numberpattern_id bigint,
    element character varying(255),
    value character varying(10),
    succession integer,
    sequencecycle character varying(255)
);


--
-- Name: basic_numberpatternelement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_numberpatternelement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_numberpatternelement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_numberpatternelement_id_seq OWNED BY public.basic_numberpatternelement.id;


--
-- Name: basic_palletnumber_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_palletnumber_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_palletnumber_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_palletnumber_id_seq OWNED BY public.basic_palletnumber.id;


--
-- Name: basic_palletnumberhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_palletnumberhelper (
    id bigint NOT NULL,
    quantity integer,
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    temporary boolean DEFAULT false
);


--
-- Name: basic_palletnumberhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_palletnumberhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_palletnumberhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_palletnumberhelper_id_seq OWNED BY public.basic_palletnumberhelper.id;


--
-- Name: basic_parameter; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_parameter (
    id bigint NOT NULL,
    country_id bigint,
    currency_id bigint,
    unit character varying(255),
    additionaltextinfooter character varying(256),
    company_id bigint,
    registerproductiontime boolean,
    reasonneededwhendelayedeffectivedatefrom boolean DEFAULT false,
    earliereffectivedatetotime integer DEFAULT 900,
    reasonneededwhencorrectingtherequestedvolume boolean DEFAULT false,
    reasonneededwhencorrectingdateto boolean DEFAULT false,
    reasonneededwhenchangingstatetodeclined boolean DEFAULT false,
    imageurlinworkplan character varying(255),
    hidedescriptioninworkplans boolean,
    defaultproductionline_id bigint,
    reasonneededwhenearliereffectivedateto boolean DEFAULT false,
    earliereffectivedatefromtime integer DEFAULT 900,
    defaultaddress character varying(255) DEFAULT '01companyAddress'::character varying,
    allowquantitychangeinacceptedorder boolean DEFAULT false,
    reasonneededwhendelayedeffectivedateto boolean DEFAULT false,
    justone boolean,
    registerquantityinproduct boolean,
    reasonneededwhenchangingstatetointerrupted boolean DEFAULT false,
    registerquantityoutproduct boolean,
    dontprintordersinworkplans boolean,
    location_id bigint,
    typeofproductionrecording character varying(255) DEFAULT '02cumulated'::character varying,
    dontprintinputproductsinworkplans boolean,
    delayedeffectivedatefromtime integer DEFAULT 900,
    hideemptycolumnsfororders boolean DEFAULT false,
    reasonneededwhenchangingstatetoabandoned boolean DEFAULT false,
    autocloseorder boolean,
    allowtoclose boolean,
    dontprintoutputproductsinworkplans boolean,
    inputproductsrequiredfortype character varying(255),
    otheraddress character varying(2048),
    reasonneededwhenearliereffectivedatefrom boolean DEFAULT false,
    defaultdescription character varying(2048),
    delayedeffectivedatetotime integer DEFAULT 900,
    hidetechnologyandorderinworkplans boolean,
    reasonneededwhencorrectingdatefrom boolean DEFAULT false,
    ssccnumberprefix character varying(11),
    lowerlimit numeric(12,5),
    negativetrend numeric(12,5),
    upperlimit numeric(12,5),
    positivetrend numeric(12,5),
    dueweight numeric(12,5),
    printoperationatfirstpageinworkplans boolean DEFAULT false,
    averagelaborhourlycostpb numeric(12,5),
    materialcostsusedpb character varying(255) DEFAULT '06costForOrder'::character varying,
    additionaloverheadpb numeric(12,5) DEFAULT (0)::numeric,
    materialcostmarginpb numeric(12,5) DEFAULT (0)::numeric,
    includetpzpb boolean DEFAULT true,
    productioncostmarginpb numeric(12,5) DEFAULT (0)::numeric,
    averagemachinehourlycostpb numeric(12,5),
    includeadditionaltimepb boolean DEFAULT true,
    batchnumberuniqueness character varying(255) DEFAULT '01globally'::character varying,
    defaultcoveragefromdays integer,
    includedraftdeliveries boolean,
    coveragetype character varying(255) DEFAULT '01all'::character varying,
    hideemptycolumnsforoffers boolean,
    hideemptycolumnsforrequests boolean,
    validateproductionrecordtimes boolean,
    workstationsquantityfromproductionline boolean,
    lockproductionprogress boolean DEFAULT false,
    hidebarcodeoperationcomponentinworkplans boolean,
    ignoremissingcomponents boolean DEFAULT true,
    additionaloutputrows integer,
    additionalinputrows integer,
    allowmultipleregisteringtimeforworker boolean DEFAULT false,
    pricebasedon character varying(255) DEFAULT '01nominalProductCost'::character varying,
    takeactualprogressinworkplans boolean,
    confectionplanrequirereasontypethreshold numeric(12,5),
    confectionplancorrectionreasontype character varying(255),
    automaticsavecoverage boolean,
    externaldeliveriesextension boolean DEFAULT false,
    warehouse_id bigint,
    documentstate character varying(255),
    positivepurchaseprice boolean DEFAULT true,
    sameordernumber boolean DEFAULT false,
    automaticdeliveriesminstate boolean DEFAULT true,
    possibleworktimedeviation numeric(12,5),
    ordersincludeperiod integer,
    includerequirements boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    labelsbtpath character varying(255),
    profitpb numeric(12,5),
    registrationpriceoverheadpb numeric(12,5),
    sourceofoperationcostspb character varying(255),
    acceptanceevents boolean,
    useblackbox boolean,
    generatewarehouseissuestoorders boolean,
    daysbeforeorderstart integer,
    issuelocation_id bigint,
    consumptionofrawmaterialsbasedonstandards boolean DEFAULT false,
    documentpositionparameters_id bigint,
    includecomponents boolean,
    warehouseissuesreservestates boolean DEFAULT false,
    drawndocuments character varying(255) DEFAULT '01transfer'::character varying,
    issuedquantityuptoneed boolean DEFAULT false,
    documentsstatus character varying(255) DEFAULT '01accepted'::character varying,
    warehouseissueproductssource character varying(255) DEFAULT '01order'::character varying,
    productstoissue character varying(255) DEFAULT '01allInputProducts'::character varying,
    trackingcorrectionrecalculatepps boolean DEFAULT false,
    deliveredbiggerthanordered boolean DEFAULT true,
    ordersganttparameters_id bigint,
    additionalimage character varying(255),
    autorecalculateorder boolean,
    ppsisautomatic boolean,
    ppsproducedamountrecalculateplan boolean,
    ppsalgorithm character varying(255),
    baselinkerparameters_id bigint,
    technologiesgeneratorcopyproductsize boolean,
    cartonlabelsbtpath character varying,
    maxproductsquantity integer,
    allowerrorsinmasterorderpositions boolean,
    companyname_id bigint,
    hideassignedstaff boolean DEFAULT false,
    fillorderdescriptionbasedontechnologydescription boolean,
    allowanomalycreationonacceptancerecord boolean DEFAULT false,
    includelevelandsuffix boolean DEFAULT true,
    orderedproductsunit character varying,
    allowincompleteunits boolean DEFAULT false,
    acceptrecordsfromterminal boolean DEFAULT false,
    allowchangestousedquantityonterminal boolean DEFAULT false,
    includeadditionaltimeps boolean DEFAULT false,
    includetpzps boolean DEFAULT false,
    ordersgenerationnotcompletedates boolean DEFAULT false,
    canchangeprodlineforacceptedorders boolean DEFAULT false,
    generateeachonseparatepage boolean,
    includewagegroups boolean DEFAULT false,
    ordersgeneratedbycoverage boolean DEFAULT false,
    automaticallygenerateordersforcomponents boolean DEFAULT false,
    seteffectivedatefromoninprogress boolean DEFAULT false,
    seteffectivedatetooncompleted boolean DEFAULT false,
    copydescription boolean DEFAULT false,
    exporttopdfonlyvisiblecolumns boolean DEFAULT false,
    additionalcartonlabelsquantity integer DEFAULT 50,
    maxcartonlabelsquantity integer DEFAULT 3000,
    exporttocsvonlyvisiblecolumns boolean DEFAULT false,
    flagpercentageofexecutionwithcolor boolean DEFAULT false,
    opertaskflagpercentexecutionwithcolor boolean DEFAULT false,
    automaticclosingoforderwithingroups boolean DEFAULT false,
    copynotesfrommasterorderposition boolean DEFAULT false,
    manuallysendwarehousedocuments boolean DEFAULT false,
    realizationfromstock boolean DEFAULT false,
    alwaysorderitemswithpersonalization boolean DEFAULT false,
    selectorder boolean DEFAULT true,
    availabilityofrawmaterials boolean DEFAULT true,
    selectoperationaltask boolean DEFAULT true,
    stoppages boolean DEFAULT false,
    repair boolean DEFAULT true,
    employeeprogress boolean DEFAULT true,
    includeunacceptableproduction boolean DEFAULT false,
    calculateamounttimeemployeesonacceptancerecord boolean DEFAULT false,
    notshowtasksdownloadedbyanotheremployee boolean DEFAULT false,
    createcollectiveorders boolean DEFAULT false,
    completemasterorderafterorderingpositions boolean DEFAULT false,
    hideorderedproductworkplan boolean DEFAULT false,
    selectiontasksbyorderdateinterminal boolean DEFAULT false,
    showprogress boolean DEFAULT false,
    showdelays boolean DEFAULT false,
    requiresupplieridentification boolean DEFAULT false,
    numberpattern_id bigint,
    generatebatchfororderedproduct boolean,
    generatebatchoforderedproduct boolean DEFAULT false,
    acceptbatchtrackingwhenclosingorder boolean DEFAULT false,
    completewarehousesflowwhilechecking boolean DEFAULT false,
    qualitycontrol boolean DEFAULT false,
    finalqualitycontrolwithoutresources boolean DEFAULT false,
    terminalproductattribute_id bigint,
    oeefor character varying(255) DEFAULT '01productionLine'::character varying,
    oeeworktimefrom character varying(255) DEFAULT '01staffWorkTimes'::character varying,
    range character varying(255) DEFAULT '01oneDivision'::character varying,
    division_id bigint,
    showqronordersgrouppdf boolean DEFAULT false,
    advisestartdateoftheorder boolean DEFAULT false,
    orderstartdatebasedon character varying(255),
    showchartondashboard boolean DEFAULT true,
    whattoshowondashboard character varying(255) DEFAULT '01orders'::character varying,
    dashboardoperation_id bigint,
    dashboardcomponentslocation_id bigint,
    dashboardproductsinputlocation_id bigint,
    momentofvalidation character varying(255) DEFAULT '01orderAcceptance'::character varying,
    moveproductstosubsequentoperations boolean DEFAULT false,
    demandcausesofwastes boolean DEFAULT false,
    wmsapk character varying(255),
    wmsversion character varying(255),
    applicationconfigured boolean DEFAULT false,
    materialcostsused character varying(255) DEFAULT '01nominal'::character varying,
    usenominalcostpricenotspecified boolean DEFAULT false,
    sourceofoperationcosts character varying(255) DEFAULT '01technologyOperation'::character varying,
    standardlaborcost_id bigint,
    averagemachinehourlycost numeric(12,5),
    averagelaborhourlycost numeric(12,5),
    includetpz boolean DEFAULT false,
    includeadditionaltime boolean DEFAULT false,
    materialcostmargin numeric(12,5) DEFAULT 0,
    productioncostmargin numeric(12,5) DEFAULT 0,
    additionaloverhead numeric(12,5) DEFAULT 0,
    registrationpriceoverhead numeric(12,5) DEFAULT 0,
    profit numeric(12,5) DEFAULT 0,
    applicationconfigurationfinished boolean DEFAULT false,
    generatepacksfororders boolean DEFAULT false,
    includepacksgeneratingprocessesfororder boolean DEFAULT false,
    optimalpacksize numeric(12,5),
    restfeedinglastpack numeric(12,5),
    deliveryusenominalcostwhenpricenotspecified boolean DEFAULT false,
    deliverypricefillbasedon character varying(255) DEFAULT '01lastPurchasePrice'::character varying,
    allowcheckedtechnologywithoutinproducts boolean DEFAULT false,
    requireassortment boolean DEFAULT false,
    changeorderdatesbasedonchangegroupdates boolean DEFAULT false,
    acceptedtechnologymarkedasdefault boolean DEFAULT false,
    terminalscanning character varying(255) DEFAULT '01operationNumber'::character varying,
    processsource character varying(255) DEFAULT '01orderPackages'::character varying,
    showproductdescriptiononordersgrouppdf boolean DEFAULT false,
    attributeonordersgrouppdf_id bigint,
    copyattributestosizeproducts boolean DEFAULT false,
    materialcostsusedmc character varying(255) DEFAULT '01nominal'::character varying,
    usenominalcostpricenotspecifiedmc boolean DEFAULT false,
    productattribute_id bigint,
    materialattribute_id bigint,
    attributeonthelabel_id bigint,
    requiretypeoffault boolean DEFAULT false,
    workingstationinputtype character varying(255) DEFAULT '01scanTheNumber'::character varying,
    allowchangeordeleteordertechnologicalprocess boolean DEFAULT false,
    technicalproductioncostoverhead numeric(12,5) DEFAULT 0,
    technicalproductioncostoverheadpb numeric(12,5) DEFAULT 0,
    synchronizeadditionalproductdata boolean DEFAULT false,
    processterminalplaceofperformance character varying(255) DEFAULT '01workstation'::character varying,
    emptylabelbtpath character varying(255),
    schedulesortorder character varying(255) DEFAULT '01desc'::character varying,
    workstationassigncriterion character varying(255) DEFAULT '01shortestTime'::character varying,
    workerassigncriterion character varying(255) DEFAULT '01workstationLastOperatorLatestFinished'::character varying,
    additionaltimeextendsoperation boolean DEFAULT true,
    synchronizeproductcategory boolean DEFAULT true,
    completenominalcostinarticleandproducts boolean DEFAULT false,
    copynominalcostfamilyofproductssizes boolean DEFAULT false,
    onlypackagesinproduction boolean DEFAULT false,
    allowtilelengthtobeedited boolean DEFAULT false,
    analyzeavailableresources boolean DEFAULT false,
    analyzeplannedquantity boolean DEFAULT false,
    analyzemaxquantity integer,
    numberpatternordergroup_id bigint,
    otcopydescriptionfromproductionorder boolean DEFAULT false,
    setorderdatesbasedontaskdates boolean DEFAULT false,
    automaticallygeneratetasksfororder boolean DEFAULT false,
    automaticallygenerateprocessesfororder boolean DEFAULT false,
    includeadditionaltimesg boolean,
    includetpzsg boolean,
    includetpzs boolean DEFAULT true,
    dashboardshowforproduct character varying(255) DEFAULT '01number'::character varying,
    dashboardshowdescription boolean DEFAULT false,
    receivedeliveryinordercurrency boolean DEFAULT false,
    sortbyproducttypepriorityordersgrouppdf boolean DEFAULT true,
    attributeonordersgrouprequirementpdf_id bigint,
    quantitymadeonthebasisofdashboard character varying(255) DEFAULT '01approvedProduction'::character varying,
    producingmorethanplanned boolean DEFAULT true,
    logo character varying(255),
    synchronizemasterorderattributes boolean DEFAULT false,
    synchronizedocumentpositionattributes boolean DEFAULT false,
    dashboardordersorting character varying(255) DEFAULT '01startDate'::character varying,
    completestationandemployeeingeneratedtasks boolean DEFAULT false,
    considerexceptionswhenpromptingcurrentshift boolean DEFAULT false,
    productionorderedquantityclosestheorder boolean DEFAULT false,
    receiptofproducts character varying(255) DEFAULT '01onAcceptanceRegistrationRecord'::character varying,
    releaseofmaterials character varying(255) DEFAULT '01onAcceptanceRegistrationRecord'::character varying,
    considerminimumstocklevelwhencreatingproductionorders boolean DEFAULT false,
    fillorderdescriptionbasedonproductdescription boolean DEFAULT false,
    ganttrunadjusterror boolean DEFAULT true,
    checkfortheexistenceofinputproductprices boolean DEFAULT false,
    automaticupdatecostnorms boolean DEFAULT false,
    costssource character varying(255) DEFAULT '01mes'::character varying,
    automaticreleaseaftergeneration boolean DEFAULT false,
    analyzeactualstaff boolean DEFAULT false,
    analyzeactualstaffmaxquantity integer,
    analyzegetquantityfromshiftassignment boolean DEFAULT false,
    setmasterorderdatebasedonorderdates boolean DEFAULT false,
    notshowtasksblockedbyprevious boolean DEFAULT false,
    promptdefaultlinefromtechnology boolean DEFAULT true,
    numberofficelicenses integer DEFAULT 1,
    numberterminallicenses integer DEFAULT 1,
    typeterminallicenses character varying(255) DEFAULT '01upToTenEmployees'::character varying,
    notshoworderfilters boolean DEFAULT false,
    notincludedateswhenretrievingorders boolean DEFAULT false,
    requirequalityrating boolean DEFAULT true,
    synchronizeproductsize boolean DEFAULT false,
    masterorderreleaselocation_id bigint,
    demandworkstation boolean DEFAULT false,
    skipfinishedtasks boolean DEFAULT false,
    onlyonebatchtrackingfororder boolean DEFAULT false,
    producedbatchfromordertrackingrecord boolean DEFAULT false,
    packaginglocation_id bigint,
    includeworkstationongetrrforot boolean DEFAULT false,
    notincludeworkstationwhensearchingot boolean DEFAULT false,
    generatetransferdocumentsonrepair boolean DEFAULT true,
    howmanydaysrecalculateplan integer DEFAULT 7,
    operationproductindefaultquantity numeric(14,5),
    operationproductoutdefaultquantity numeric(14,5),
    manyarticleswiththesameean boolean DEFAULT false,
    includeincalculationdeliveries character varying(255) DEFAULT '01confirmedDeliveries'::character varying,
    transferordersgrouptoordersforcomponents boolean DEFAULT false,
    automaticallyusethebatchplannedinorder boolean DEFAULT false,
    productdeliverybatchevidence boolean DEFAULT false,
    productdeliverybatchnumberpattern_id bigint,
    showmachineperiodregistration boolean DEFAULT false,
    mergingordersforcomponents boolean DEFAULT false,
    tasksselectionby character varying(255) DEFAULT '01orderDate'::character varying,
    recalculateplantasksorder character varying(255) DEFAULT '01operationsLevelAndTasksStartDate'::character varying,
    numbervisibleorderstasksondashboard integer DEFAULT 50,
    updatetechnologiesonpendingorders boolean DEFAULT false,
    sharingregistrationrecord boolean DEFAULT false,
    noexchangeratedownload boolean DEFAULT false,
    createfailtodowntime boolean DEFAULT false,
    optimizecuttinglengthattribute_id bigint,
    optimizecuttingfinalwasteunit character varying(255),
    optimizecuttingfinalwaste numeric(14,5),
    dimensioncontrolofproducts boolean DEFAULT false,
    showplannedeventsonchart boolean DEFAULT false,
    updateplannedeventfinishdate boolean DEFAULT false,
    copyattributestoproducts boolean DEFAULT false,
    technologiesgeneratorcopyproductattributes boolean DEFAULT false,
    allowtotalregistration boolean DEFAULT false,
    workingtimetotalregistration character varying(255) DEFAULT '01duplicatedForEachOrder'::character varying,
    wastesconsumerawmaterials boolean DEFAULT true,
    moldrewclient_id bigint,
    deadlinefororderbasedondeliverydate boolean DEFAULT false,
    deadlinefororderearlierthandeliverydate integer DEFAULT 0,
    operationaltasksrecalculationtoken character varying(36),
    plannerworkstationassigncriterion character varying(255) DEFAULT '01minDeadlineForOrder'::character varying,
    deadlinesort boolean DEFAULT true,
    operationlevelsort boolean DEFAULT true,
    orderprioritysort boolean DEFAULT false,
    abcanalysissort boolean DEFAULT false,
    allowmasterorderdeadlinechange boolean DEFAULT false,
    scheduleduration integer DEFAULT 90,
    plandimensioncontrolofproducts boolean DEFAULT false,
    orderdimensioncontrolofproducts boolean DEFAULT false,
    pricelistattribute1_id bigint,
    pricelistattribute2_id bigint,
    recalculateplanafterfinishtaskinterminal boolean DEFAULT false,
    numberapslicenses integer DEFAULT 0,
    numberwmsmobilelicenses integer DEFAULT 0
);


--
-- Name: basic_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_parameter_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_parameter_id_seq OWNED BY public.basic_parameter.id;


--
-- Name: basic_piece_rate_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_piece_rate_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_piecerate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_piecerate (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024)
);


--
-- Name: basic_piecerate_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_piecerate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_piecerate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_piecerate_id_seq OWNED BY public.basic_piecerate.id;


--
-- Name: basic_piecerateitem; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_piecerateitem (
    id bigint NOT NULL,
    piecerate_id bigint,
    actualrate numeric(9,2),
    datefrom date,
    dateto date
);


--
-- Name: basic_piecerateitem_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_piecerateitem_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_piecerateitem_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_piecerateitem_id_seq OWNED BY public.basic_piecerateitem.id;


--
-- Name: basic_product_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_product_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_product_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_product_id_seq OWNED BY public.basic_product.id;


--
-- Name: basic_productattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_productattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_productattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_productattachment_id_seq OWNED BY public.basic_productattachment.id;


--
-- Name: basic_productattributevalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_productattributevalue (
    id bigint NOT NULL,
    product_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255)
);


--
-- Name: basic_productattributevalue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_productattributevalue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_productattributevalue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_productattributevalue_id_seq OWNED BY public.basic_productattributevalue.id;


--
-- Name: basic_productdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.basic_productdto AS
SELECT
    NULL::bigint AS id,
    NULL::character varying(255) AS number,
    NULL::character varying(1024) AS name,
    NULL::character varying(255) AS globaltypeofmaterial,
    NULL::character varying(255) AS category,
    NULL::character varying(1024) AS parentname,
    NULL::character varying(255) AS ean,
    NULL::character varying(255) AS externalnumber,
    NULL::character varying(255) AS assortmentname,
    NULL::character varying(1024) AS modelname,
    NULL::character varying(255) AS norm,
    NULL::character varying(255) AS sizenumber,
    NULL::boolean AS hasattachments,
    NULL::boolean AS active,
    NULL::character varying(255) AS unit,
    NULL::character varying(255) AS additionalunit,
    NULL::character varying(255) AS entitytype,
    NULL::character varying(255) AS supplier,
    NULL::numeric(12,5) AS nominalcost,
    NULL::numeric(12,5) AS lastpurchasecost,
    NULL::character varying(255) AS batchnumberpattern,
    NULL::character varying(2048) AS description;


--
-- Name: basic_productdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_productdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_qualitycard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_qualitycard_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_qualitycard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_qualitycard_id_seq OWNED BY public.basic_qualitycard.id;


--
-- Name: basic_qualitycardstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_qualitycardstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    qualitycard_id bigint,
    shift_id bigint
);


--
-- Name: basic_qualitycardstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_qualitycardstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_qualitycardstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_qualitycardstatechange_id_seq OWNED BY public.basic_qualitycardstatechange.id;


--
-- Name: basic_reportcolumnwidth; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_reportcolumnwidth (
    id bigint NOT NULL,
    identifier character varying(255),
    name character varying(1024),
    width integer,
    chartype character varying(255),
    parameter_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: basic_reportcolumnwidth_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_reportcolumnwidth_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_reportcolumnwidth_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_reportcolumnwidth_id_seq OWNED BY public.basic_reportcolumnwidth.id;


--
-- Name: basic_shift_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_shift_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_shift_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_shift_id_seq OWNED BY public.basic_shift.id;


--
-- Name: basic_shifttimetableexception; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_shifttimetableexception (
    id bigint NOT NULL,
    name character varying(1024),
    fromdate timestamp without time zone,
    todate timestamp without time zone,
    type character varying(255) DEFAULT '01freeTime'::character varying,
    relatestoprevday boolean DEFAULT false,
    entityversion bigint DEFAULT 0
);


--
-- Name: basic_shifttimetableexception_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_shifttimetableexception_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_shifttimetableexception_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_shifttimetableexception_id_seq OWNED BY public.basic_shifttimetableexception.id;


--
-- Name: basic_size; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_size (
    id bigint NOT NULL,
    number character varying(255),
    succession integer,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    active boolean DEFAULT true
);


--
-- Name: basic_size_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_size_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_size_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_size_id_seq OWNED BY public.basic_size.id;


--
-- Name: basic_sizegroup; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_sizegroup (
    id bigint NOT NULL,
    number character varying(255),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    active boolean DEFAULT true
);


--
-- Name: basic_sizegroup_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_sizegroup_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_sizegroup_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_sizegroup_id_seq OWNED BY public.basic_sizegroup.id;


--
-- Name: basic_skill_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_skill_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_skill; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_skill (
    id bigint DEFAULT nextval('public.basic_skill_id_seq'::regclass) NOT NULL,
    name character varying(1024),
    description character varying(2048),
    maximumlevel integer,
    active boolean DEFAULT true
);


--
-- Name: basic_staff_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_staff_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_staff_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_staff_id_seq OWNED BY public.basic_staff.id;


--
-- Name: wagegroups_wagegroup; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.wagegroups_wagegroup (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(255),
    superiorwagegroup character varying(255),
    laborhourlycost numeric(12,5),
    laborhourlycostcurrency character varying(255),
    laborhourlycostfromwagegroup numeric(12,5),
    determinedindividually boolean,
    individuallaborhourlycost numeric(12,5),
    entityversion bigint DEFAULT 0
);


--
-- Name: basic_staffdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.basic_staffdto AS
 SELECT s.id,
    s.active,
    s.number,
    s.name,
    s.surname,
    s.post,
    pl.number AS productionlinenumber,
    d.number AS divisionnumber,
    d.name AS divisionname,
    w.number AS workstationnumber,
    w.name AS workstationname,
    c.name AS workforname,
    wg.number AS wagegroupnumber
   FROM (((((public.basic_staff s
     LEFT JOIN public.productionlines_productionline pl ON ((s.productionline_id = pl.id)))
     LEFT JOIN public.basic_division d ON ((s.division_id = d.id)))
     LEFT JOIN public.basic_workstation w ON ((s.workstation_id = w.id)))
     LEFT JOIN public.basic_company c ON ((s.workfor_id = c.id)))
     LEFT JOIN public.wagegroups_wagegroup wg ON ((s.wagegroup_id = wg.id)));


--
-- Name: basic_staffdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_staffdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_staffskill_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_staffskill_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_staffskill; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_staffskill (
    id bigint DEFAULT nextval('public.basic_staffskill_id_seq'::regclass) NOT NULL,
    staff_id bigint,
    skill_id bigint,
    level integer,
    active boolean DEFAULT true
);


--
-- Name: basic_subassembly_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_subassembly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_subassembly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_subassembly_id_seq OWNED BY public.basic_subassembly.id;


--
-- Name: basic_subassemblyattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_subassemblyattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_subassemblyattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_subassemblyattachment_id_seq OWNED BY public.basic_subassemblyattachment.id;


--
-- Name: basic_workstationtype; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_workstationtype (
    id bigint NOT NULL,
    name character varying(1024),
    number character varying(255),
    description character varying(2048),
    active boolean DEFAULT true,
    subassembly boolean,
    entityversion bigint DEFAULT 0
);


--
-- Name: basic_subassemblylistdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.basic_subassemblylistdto AS
 SELECT subassembly.id,
    subassembly.active,
    subassembly.number,
    subassembly.name,
    workstation.number AS workstationnumber,
    subassembly.type,
    workstationtype.number AS workstationtypenumber,
    subassembly.productiondate,
    event.maxdate AS lastrepairsdate
   FROM (((public.basic_subassembly subassembly
     LEFT JOIN public.basic_workstation workstation ON ((subassembly.workstation_id = workstation.id)))
     JOIN public.basic_workstationtype workstationtype ON ((subassembly.workstationtype_id = workstationtype.id)))
     LEFT JOIN ( SELECT plannedevent.subassembly_id AS subassemblyid,
            max(plannedevent.date) AS maxdate
           FROM public.cmmsmachineparts_plannedevent plannedevent
          WHERE (((plannedevent.state)::text = '05realized'::text) AND ((plannedevent.basedon)::text = '01date'::text) AND ((plannedevent.type)::text = '02repairs'::text))
          GROUP BY plannedevent.subassembly_id) event ON ((event.subassemblyid = subassembly.id)));


--
-- Name: basic_subassemblylistdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_subassemblylistdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_subassemblytoworkstationhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_subassemblytoworkstationhelper (
    id bigint NOT NULL,
    subassembly_id bigint,
    type character varying(255),
    workstation_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: basic_subassemblytoworkstationhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_subassemblytoworkstationhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_subassemblytoworkstationhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_subassemblytoworkstationhelper_id_seq OWNED BY public.basic_subassemblytoworkstationhelper.id;


--
-- Name: basic_substitutecomponent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_substitutecomponent (
    id bigint NOT NULL,
    product_id bigint,
    quantity numeric(9,5),
    baseproduct_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: basic_substitutecomponent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_substitutecomponent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_substitutecomponent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_substitutecomponent_id_seq OWNED BY public.basic_substitutecomponent.id;


--
-- Name: basic_technological_process_rate_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_technological_process_rate_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_technologicalprocessrate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_technologicalprocessrate (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024)
);


--
-- Name: basic_technologicalprocessrate_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_technologicalprocessrate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_technologicalprocessrate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_technologicalprocessrate_id_seq OWNED BY public.basic_technologicalprocessrate.id;


--
-- Name: basic_technologicalprocessrateitem; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_technologicalprocessrateitem (
    id bigint NOT NULL,
    technologicalprocessrate_id bigint,
    actualrate numeric(9,2),
    datefrom date,
    dateto date
);


--
-- Name: basic_technologicalprocessrateitem_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_technologicalprocessrateitem_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_technologicalprocessrateitem_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_technologicalprocessrateitem_id_seq OWNED BY public.basic_technologicalprocessrateitem.id;


--
-- Name: jointable_productionline_shifttimetableexception; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_productionline_shifttimetableexception (
    productionline_id bigint NOT NULL,
    shifttimetableexception_id bigint NOT NULL
);


--
-- Name: jointable_shift_shifttimetableexception; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_shift_shifttimetableexception (
    shift_id bigint NOT NULL,
    shifttimetableexception_id bigint NOT NULL
);


--
-- Name: basic_timetableexceptiondto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.basic_timetableexceptiondto AS
 SELECT shifttimetableexception.id,
    shifttimetableexception.name,
    shifttimetableexception.fromdate,
    shifttimetableexception.todate,
    shifttimetableexception.type,
    shifttimetableexception.relatestoprevday,
    array_to_string(ARRAY( SELECT shift.name
           FROM (public.jointable_shift_shifttimetableexception shift_shifttimetableexception
             LEFT JOIN public.basic_shift shift ON ((shift_shifttimetableexception.shift_id = shift.id)))
          WHERE (shift_shifttimetableexception.shifttimetableexception_id = shifttimetableexception.id)), ', '::text) AS shifts,
    array_to_string(ARRAY( SELECT productionline.number
           FROM (public.jointable_productionline_shifttimetableexception productionline_shifttimetableexception
             LEFT JOIN public.productionlines_productionline productionline ON ((productionline_shifttimetableexception.productionline_id = productionline.id)))
          WHERE (productionline_shifttimetableexception.shifttimetableexception_id = shifttimetableexception.id)), ', '::text) AS productionlines
   FROM public.basic_shifttimetableexception shifttimetableexception;


--
-- Name: basic_timetableexceptiondto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_timetableexceptiondto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_timetableexceptionpershiftdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.basic_timetableexceptionpershiftdto AS
 SELECT shifttimetableexception.id,
    shifttimetableexception.name,
    shifttimetableexception.fromdate,
    shifttimetableexception.todate,
    shifttimetableexception.type,
    shifttimetableexception.relatestoprevday,
    (shift_shifttimetableexception.shift_id)::integer AS shiftid,
    array_to_string(ARRAY( SELECT shift.name
           FROM (public.jointable_shift_shifttimetableexception shift_shifttimetableexception_1
             LEFT JOIN public.basic_shift shift ON ((shift_shifttimetableexception_1.shift_id = shift.id)))
          WHERE (shift_shifttimetableexception_1.shifttimetableexception_id = shifttimetableexception.id)), ', '::text) AS shifts,
    array_to_string(ARRAY( SELECT productionline.number
           FROM (public.jointable_productionline_shifttimetableexception productionline_shifttimetableexception
             LEFT JOIN public.productionlines_productionline productionline ON ((productionline_shifttimetableexception.productionline_id = productionline.id)))
          WHERE (productionline_shifttimetableexception.shifttimetableexception_id = shifttimetableexception.id)), ', '::text) AS productionlines
   FROM (public.basic_shifttimetableexception shifttimetableexception
     LEFT JOIN public.jointable_shift_shifttimetableexception shift_shifttimetableexception ON ((shifttimetableexception.id = shift_shifttimetableexception.shifttimetableexception_id)));


--
-- Name: basic_timetableexceptionpershiftdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_timetableexceptionpershiftdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_viewedactivity; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basic_viewedactivity (
    id bigint NOT NULL,
    user_id bigint,
    log_id bigint
);


--
-- Name: basic_viewedactivity_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_viewedactivity_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_viewedactivity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_viewedactivity_id_seq OWNED BY public.basic_viewedactivity.id;


--
-- Name: basic_workstation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_workstation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_workstation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_workstation_id_seq OWNED BY public.basic_workstation.id;


--
-- Name: basic_workstationattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_workstationattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_workstationattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_workstationattachment_id_seq OWNED BY public.basic_workstationattachment.id;


--
-- Name: basic_workstationdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.basic_workstationdto AS
 SELECT w.id,
    w.active,
    w.number,
    w.name,
    wt.name AS workstationtype,
    d.number AS division,
    w.wnknumber,
    (((stf.name)::text || ' '::text) || (stf.surname)::text) AS staff,
    w.dateofadmission,
    w.dateofwithdrawal,
    pl.name AS productionline,
    w.state
   FROM ((((public.basic_workstation w
     LEFT JOIN public.basic_workstationtype wt ON ((wt.id = w.workstationtype_id)))
     LEFT JOIN public.basic_division d ON ((w.division_id = d.id)))
     LEFT JOIN public.basic_staff stf ON ((stf.id = w.staff_id)))
     LEFT JOIN public.productionlines_productionline pl ON ((w.productionline_id = pl.id)));


--
-- Name: basic_workstationdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_workstationdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_workstationtype_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basic_workstationtype_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basic_workstationtype_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basic_workstationtype_id_seq OWNED BY public.basic_workstationtype.id;


--
-- Name: basicproductioncounting_basicproductioncounting; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basicproductioncounting_basicproductioncounting (
    id bigint NOT NULL,
    order_id bigint,
    product_id bigint,
    usedquantity numeric(14,5),
    producedquantity numeric(14,5),
    entityversion bigint DEFAULT 0
);


--
-- Name: basicproductioncounting_basicproductioncounting_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basicproductioncounting_basicproductioncounting_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basicproductioncounting_basicproductioncounting_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basicproductioncounting_basicproductioncounting_id_seq OWNED BY public.basicproductioncounting_basicproductioncounting.id;


--
-- Name: basicproductioncounting_productioncountingquantity; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basicproductioncounting_productioncountingquantity (
    id bigint NOT NULL,
    order_id bigint,
    product_id bigint,
    plannedquantity numeric(14,5),
    isnoncomponent boolean DEFAULT false,
    technologyoperationcomponent_id bigint,
    basicproductioncounting_id bigint,
    typeofmaterial character varying(255) DEFAULT '01component'::character varying,
    role character varying(255) DEFAULT '01used'::character varying,
    componentsoutputlocation_id bigint,
    componentslocation_id bigint,
    productsinputlocation_id bigint,
    productionflow character varying(255),
    productsflowlocation_id bigint,
    entityversion bigint DEFAULT 0,
    replacementto_id bigint,
    showmaterialcomponentinworkplan boolean DEFAULT false,
    technologyinputproducttype_id bigint,
    usedquantity numeric(14,5),
    producedquantity numeric(14,5),
    wastereceptionwarehouse_id bigint,
    attribute_id bigint
);


--
-- Name: basicproductioncounting_basicproductioncountingdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.basicproductioncounting_basicproductioncountingdto AS
 SELECT bpc.id,
    (bpc.order_id)::integer AS orderid,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    o.plannedquantity,
    bpc.usedquantity,
    bpc.producedquantity
   FROM ((public.basicproductioncounting_basicproductioncounting bpc
     JOIN public.basic_product product ON ((product.id = bpc.product_id)))
     JOIN public.orders_order o ON ((o.id = bpc.order_id)))
  WHERE (bpc.product_id = o.product_id)
UNION
 SELECT bpc.id,
    (bpc.order_id)::integer AS orderid,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    COALESCE(sum(pcq.plannedquantity), (0)::numeric) AS plannedquantity,
    bpc.usedquantity,
    bpc.producedquantity
   FROM (((public.basicproductioncounting_basicproductioncounting bpc
     JOIN public.basic_product product ON ((product.id = bpc.product_id)))
     JOIN public.orders_order o ON ((o.id = bpc.order_id)))
     LEFT JOIN public.basicproductioncounting_productioncountingquantity pcq ON (((pcq.order_id = bpc.order_id) AND (pcq.product_id = bpc.product_id) AND ((pcq.role)::text = '01used'::text))))
  WHERE (bpc.product_id <> o.product_id)
  GROUP BY bpc.id, bpc.order_id, product.number, product.name, product.unit, bpc.usedquantity, bpc.producedquantity;


--
-- Name: basicproductioncounting_basicproductioncountingdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basicproductioncounting_basicproductioncountingdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_productiontracking; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_productiontracking (
    id bigint NOT NULL,
    number character varying(255),
    order_id bigint,
    technologyinstanceoperationcomponent_id bigint,
    shift_id bigint,
    state character varying(255) DEFAULT '01draft'::character varying,
    lasttracking boolean,
    machinetime integer,
    labortime integer,
    staff_id bigint,
    workstationtype_id bigint,
    division_id bigint,
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    laststatechangefails boolean DEFAULT false,
    laststatechangefailcause character varying(255),
    isexternalsynchronized boolean DEFAULT true,
    timerangefrom timestamp without time zone,
    timerangeto timestamp without time zone,
    shiftstartday date,
    changeovertime integer,
    subcontractor_id bigint,
    technologyoperationcomponent_id bigint,
    entityversion bigint DEFAULT 0,
    repairorder_id bigint,
    correction_id bigint,
    iscorrection boolean DEFAULT false,
    planforordercompleted boolean DEFAULT false,
    workstation_id bigint,
    batch_id bigint,
    expirationdate date,
    qualityrating character varying(255),
    iscorrected boolean DEFAULT false,
    comments character varying(2048)
);


--
-- Name: productioncounting_trackingoperationproductoutcomponent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_trackingoperationproductoutcomponent (
    id bigint NOT NULL,
    productiontracking_id bigint,
    product_id bigint,
    usedquantity numeric(14,5),
    balance numeric(14,5),
    batch_id bigint,
    wastedquantity numeric(14,5),
    givenunit character varying(255),
    givenquantity numeric(14,5),
    entityversion bigint DEFAULT 0,
    wastesquantity numeric(14,5),
    typeofmaterial character varying(255) DEFAULT '01component'::character varying,
    storagelocation_id bigint,
    causeofwastes character varying(255),
    palletnumber_id bigint,
    manyreasonsforlacks boolean DEFAULT false,
    typeofpallet character varying(255)
);


--
-- Name: basicproductioncounting_producedquantity_helper; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.basicproductioncounting_producedquantity_helper AS
 SELECT sum(topoc.usedquantity) AS producedquantity,
    pt.order_id,
    topoc.product_id,
    pt.technologyoperationcomponent_id
   FROM (public.productioncounting_trackingoperationproductoutcomponent topoc
     JOIN public.productioncounting_productiontracking pt ON ((pt.id = topoc.productiontracking_id)))
  WHERE ((pt.state)::text = '02accepted'::text)
  GROUP BY pt.order_id, topoc.product_id, pt.technologyoperationcomponent_id;


--
-- Name: basicproductioncounting_producedquantity_withdraft; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.basicproductioncounting_producedquantity_withdraft AS
 SELECT sum(topoc.usedquantity) AS producedquantity,
    pt.order_id,
    topoc.product_id,
    pt.technologyoperationcomponent_id
   FROM (public.productioncounting_trackingoperationproductoutcomponent topoc
     JOIN public.productioncounting_productiontracking pt ON ((pt.id = topoc.productiontracking_id)))
  WHERE (((pt.state)::text = '02accepted'::text) OR ((pt.state)::text = '01draft'::text))
  GROUP BY pt.order_id, topoc.product_id, pt.technologyoperationcomponent_id;


--
-- Name: basicproductioncounting_productioncountingattributevalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basicproductioncounting_productioncountingattributevalue (
    id bigint NOT NULL,
    productioncountingquantity_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255)
);


--
-- Name: basicproductioncounting_productioncountingattributevalue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basicproductioncounting_productioncountingattributevalue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basicproductioncounting_productioncountingattributevalue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basicproductioncounting_productioncountingattributevalue_id_seq OWNED BY public.basicproductioncounting_productioncountingattributevalue.id;


--
-- Name: basicproductioncounting_productioncountingoperationrun; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basicproductioncounting_productioncountingoperationrun (
    id bigint NOT NULL,
    order_id bigint,
    technologyoperationcomponent_id bigint,
    runs numeric(12,5),
    entityversion bigint DEFAULT 0
);


--
-- Name: basicproductioncounting_productioncountingoperationrun_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basicproductioncounting_productioncountingoperationrun_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basicproductioncounting_productioncountingoperationrun_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basicproductioncounting_productioncountingoperationrun_id_seq OWNED BY public.basicproductioncounting_productioncountingoperationrun.id;


--
-- Name: basicproductioncounting_productioncountingquantity_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basicproductioncounting_productioncountingquantity_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basicproductioncounting_productioncountingquantity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basicproductioncounting_productioncountingquantity_id_seq OWNED BY public.basicproductioncounting_productioncountingquantity.id;


--
-- Name: basicproductioncounting_productioncountingquantitychange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basicproductioncounting_productioncountingquantitychange (
    id bigint NOT NULL,
    order_id bigint,
    product_id bigint,
    plannedquantitybefore numeric(14,5),
    plannedquantityafter numeric(14,5),
    dateandtime timestamp without time zone,
    worker character varying(255),
    changetype character varying(255)
);


--
-- Name: basicproductioncounting_productioncountingquantitychange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basicproductioncounting_productioncountingquantitychange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basicproductioncounting_productioncountingquantitychange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basicproductioncounting_productioncountingquantitychange_id_seq OWNED BY public.basicproductioncounting_productioncountingquantitychange.id;


--
-- Name: technologies_technologyinputproducttype; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.technologies_technologyinputproducttype (
    id bigint NOT NULL,
    name character varying(255),
    averageprice numeric(9,2),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    active boolean DEFAULT true
);


--
-- Name: basicproductioncounting_productioncountingquantitydto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.basicproductioncounting_productioncountingquantitydto AS
 SELECT pcq.id,
    (pcq.order_id)::integer AS orderid,
    (product.id)::integer AS productid,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    toc.id AS tocid,
    COALESCE(toc.nodenumber, ''::character varying) AS nodenumber,
    COALESCE(op.number, ''::character varying) AS operationnumber,
    COALESCE(op.name, ''::character varying) AS operationname,
    pcq.role,
    pcq.typeofmaterial,
    pcq.plannedquantity,
    COALESCE(pcq.usedquantity, (0)::numeric) AS usedquantity,
    COALESCE(pcq.producedquantity, (0)::numeric) AS producedquantity,
    replacementto.number AS replacementto,
    tipt.name AS technologyinputproducttypename,
        CASE
            WHEN (( SELECT count(*) AS count
               FROM public.basic_substitutecomponent
              WHERE (basic_substitutecomponent.baseproduct_id = product.id)) > 0) THEN true
            ELSE false
        END AS replacement
   FROM ((((((public.basicproductioncounting_productioncountingquantity pcq
     JOIN public.basic_product product ON ((product.id = pcq.product_id)))
     JOIN public.orders_order o ON ((o.id = pcq.order_id)))
     LEFT JOIN public.basic_product replacementto ON ((replacementto.id = pcq.replacementto_id)))
     LEFT JOIN public.technologies_technologyoperationcomponent toc ON ((pcq.technologyoperationcomponent_id = toc.id)))
     LEFT JOIN public.technologies_operation op ON ((op.id = toc.operation_id)))
     LEFT JOIN public.technologies_technologyinputproducttype tipt ON ((tipt.id = pcq.technologyinputproducttype_id)))
  WHERE ((o.typeofproductionrecording)::text = '02cumulated'::text)
UNION
 SELECT pcq.id,
    (pcq.order_id)::integer AS orderid,
    (product.id)::integer AS productid,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    toc.id AS tocid,
    toc.nodenumber,
    op.number AS operationnumber,
    op.name AS operationname,
    pcq.role,
    pcq.typeofmaterial,
    pcq.plannedquantity,
    COALESCE(pcq.usedquantity, (0)::numeric) AS usedquantity,
    COALESCE(pcq.producedquantity, (0)::numeric) AS producedquantity,
    replacementto.number AS replacementto,
    tipt.name AS technologyinputproducttypename,
        CASE
            WHEN (( SELECT count(*) AS count
               FROM public.basic_substitutecomponent
              WHERE (basic_substitutecomponent.baseproduct_id = product.id)) > 0) THEN true
            ELSE false
        END AS replacement
   FROM ((((((public.basicproductioncounting_productioncountingquantity pcq
     JOIN public.basic_product product ON ((product.id = pcq.product_id)))
     JOIN public.orders_order o ON ((o.id = pcq.order_id)))
     JOIN public.technologies_technologyoperationcomponent toc ON ((pcq.technologyoperationcomponent_id = toc.id)))
     JOIN public.technologies_operation op ON ((op.id = toc.operation_id)))
     LEFT JOIN public.basic_product replacementto ON ((replacementto.id = pcq.replacementto_id)))
     LEFT JOIN public.technologies_technologyinputproducttype tipt ON ((tipt.id = pcq.technologyinputproducttype_id)))
  WHERE ((o.typeofproductionrecording)::text = '03forEach'::text);


--
-- Name: basicproductioncounting_productioncountingquantitydto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basicproductioncounting_productioncountingquantitydto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_operationaltask; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_operationaltask (
    id bigint NOT NULL,
    number character varying(256),
    name character varying(1024),
    description character varying(2048),
    type character varying(255),
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    order_id bigint,
    entityversion bigint DEFAULT 0,
    staff_id bigint,
    workstation_id bigint,
    state character varying(255) DEFAULT '01pending'::character varying,
    technologyoperationcomponent_id bigint,
    product_id bigint,
    scheduleposition_id bigint,
    division_id bigint,
    actualstaff integer,
    suborder_id bigint
);


--
-- Name: basicproductioncounting_productioncountingquantitylistdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.basicproductioncounting_productioncountingquantitylistdto AS
 SELECT pcq.id,
    o.number AS ordernumber,
    (o.id)::integer AS orderid,
    ot.number AS operationaltasknumber,
    (ot.id)::integer AS operationaltaskid,
    COALESCE(ot.startdate, o.startdate) AS startdate,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    COALESCE(toc.nodenumber, ''::character varying) AS nodenumber,
    COALESCE(op.number, ''::character varying) AS operationnumber,
    COALESCE(op.name, ''::character varying) AS operationname,
    pcq.role,
    pcq.typeofmaterial,
    pcq.plannedquantity,
    COALESCE(pcq.usedquantity, (0)::numeric) AS usedquantity,
    COALESCE(pcq.producedquantity, (0)::numeric) AS producedquantity,
    replacementto.number AS replacementto,
    tipt.name AS technologyinputproducttypename
   FROM (((((((public.basicproductioncounting_productioncountingquantity pcq
     JOIN public.basic_product product ON ((product.id = pcq.product_id)))
     JOIN public.orders_order o ON ((o.id = pcq.order_id)))
     LEFT JOIN public.technologies_technologyoperationcomponent toc ON ((pcq.technologyoperationcomponent_id = toc.id)))
     LEFT JOIN public.technologies_operation op ON ((op.id = toc.operation_id)))
     LEFT JOIN public.technologies_technologyinputproducttype tipt ON ((tipt.id = pcq.technologyinputproducttype_id)))
     LEFT JOIN public.orders_operationaltask ot ON (((ot.order_id = o.id) AND (ot.technologyoperationcomponent_id = toc.id))))
     LEFT JOIN public.basic_product replacementto ON ((replacementto.id = pcq.replacementto_id)))
  WHERE (((o.typeofproductionrecording)::text = '02cumulated'::text) AND ((o.state)::text = ANY (ARRAY[('02accepted'::character varying)::text, ('03inProgress'::character varying)::text, ('06interrupted'::character varying)::text])))
UNION
 SELECT pcq.id,
    o.number AS ordernumber,
    (o.id)::integer AS orderid,
    ot.number AS operationaltasknumber,
    (ot.id)::integer AS operationaltaskid,
    COALESCE(ot.startdate, o.startdate) AS startdate,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    toc.nodenumber,
    op.number AS operationnumber,
    op.name AS operationname,
    pcq.role,
    pcq.typeofmaterial,
    pcq.plannedquantity,
    COALESCE(pcq.usedquantity, (0)::numeric) AS usedquantity,
    COALESCE(pcq.producedquantity, (0)::numeric) AS producedquantity,
    replacementto.number AS replacementto,
    tipt.name AS technologyinputproducttypename
   FROM (((((((public.basicproductioncounting_productioncountingquantity pcq
     JOIN public.basic_product product ON ((product.id = pcq.product_id)))
     JOIN public.orders_order o ON ((o.id = pcq.order_id)))
     JOIN public.technologies_technologyoperationcomponent toc ON ((pcq.technologyoperationcomponent_id = toc.id)))
     JOIN public.technologies_operation op ON ((op.id = toc.operation_id)))
     LEFT JOIN public.technologies_technologyinputproducttype tipt ON ((tipt.id = pcq.technologyinputproducttype_id)))
     LEFT JOIN public.orders_operationaltask ot ON (((ot.order_id = o.id) AND (ot.technologyoperationcomponent_id = toc.id))))
     LEFT JOIN public.basic_product replacementto ON ((replacementto.id = pcq.replacementto_id)))
  WHERE (((o.typeofproductionrecording)::text = '03forEach'::text) AND ((o.state)::text = ANY (ARRAY[('02accepted'::character varying)::text, ('03inProgress'::character varying)::text, ('06interrupted'::character varying)::text])));


--
-- Name: basicproductioncounting_productioncountingquantitylistdto_id_se; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basicproductioncounting_productioncountingquantitylistdto_id_se
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basicproductioncounting_productioncountingreplacementhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basicproductioncounting_productioncountingreplacementhelper (
    id bigint NOT NULL,
    order_id bigint,
    product_id bigint,
    basicproduct_id bigint,
    plannedquantity numeric(14,5),
    replacesquantity numeric(14,5),
    productioncountingquantity_id bigint
);


--
-- Name: basicproductioncounting_productioncountingreplacementhelper_id_; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basicproductioncounting_productioncountingreplacementhelper_id_
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basicproductioncounting_productioncountingreplacementhelper_id_; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basicproductioncounting_productioncountingreplacementhelper_id_ OWNED BY public.basicproductioncounting_productioncountingreplacementhelper.id;


--
-- Name: basicproductioncounting_section; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.basicproductioncounting_section (
    id bigint NOT NULL,
    productioncountingquantity_id bigint,
    length numeric(14,5),
    quantity integer,
    unit character varying(255)
);


--
-- Name: basicproductioncounting_section_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.basicproductioncounting_section_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: basicproductioncounting_section_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.basicproductioncounting_section_id_seq OWNED BY public.basicproductioncounting_section.id;


--
-- Name: productioncounting_trackingoperationproductincomponent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_trackingoperationproductincomponent (
    id bigint NOT NULL,
    productiontracking_id bigint,
    product_id bigint,
    usedquantity numeric(14,5),
    balance numeric(14,5),
    obtainedquantity numeric(14,5),
    remainedquantity numeric(14,5),
    effectiveusedquantity numeric(15,5),
    givenunit character varying(255),
    givenquantity numeric(14,5),
    entityversion bigint DEFAULT 0,
    typeofmaterial character varying(255) DEFAULT '01component'::character varying,
    wasteused boolean DEFAULT false,
    wasteusedonly boolean DEFAULT false,
    wasteusedquantity numeric,
    wasteunit character varying,
    additionalinformation character varying,
    replacementto_id bigint
);


--
-- Name: basicproductioncounting_usedquantity_helper; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.basicproductioncounting_usedquantity_helper AS
 SELECT sum(topic.usedquantity) AS usedquantity,
    pt.order_id,
    topic.product_id,
    pt.technologyoperationcomponent_id
   FROM (public.productioncounting_trackingoperationproductincomponent topic
     JOIN public.productioncounting_productiontracking pt ON ((pt.id = topic.productiontracking_id)))
  WHERE ((pt.state)::text = '02accepted'::text)
  GROUP BY pt.order_id, topic.product_id, pt.technologyoperationcomponent_id;


--
-- Name: cdnrcgoodfood_cancelprotocol; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cdnrcgoodfood_cancelprotocol (
    id bigint NOT NULL,
    extrusionprotocol_id bigint,
    confectionprotocol_id bigint,
    createdate timestamp without time zone,
    laststatechangefailcause character varying(8192),
    iscanceled boolean DEFAULT false
);


--
-- Name: cdnrcgoodfood_cancelprotocol_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cdnrcgoodfood_cancelprotocol_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cdnrcgoodfood_cancelprotocol_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cdnrcgoodfood_cancelprotocol_id_seq OWNED BY public.cdnrcgoodfood_cancelprotocol.id;


--
-- Name: cdnrcgoodfood_highestmasterordernum; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cdnrcgoodfood_highestmasterordernum (
    id bigint NOT NULL,
    type character varying(32),
    number integer,
    entityversion bigint DEFAULT 0
);


--
-- Name: cdnrcgoodfood_highestmasterordernum_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cdnrcgoodfood_highestmasterordernum_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cdnrcgoodfood_highestmasterordernum_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cdnrcgoodfood_highestmasterordernum_id_seq OWNED BY public.cdnrcgoodfood_highestmasterordernum.id;


--
-- Name: cmmsmachineparts_action; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_action (
    id bigint NOT NULL,
    name character varying(255),
    appliesto character varying(255) DEFAULT '01workstationOrSubassembly'::character varying,
    entityversion bigint DEFAULT 0,
    isdefault boolean DEFAULT false
);


--
-- Name: cmmsmachineparts_action_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_action_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_action_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_action_id_seq OWNED BY public.cmmsmachineparts_action.id;


--
-- Name: cmmsmachineparts_actionforplannedevent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_actionforplannedevent (
    id bigint NOT NULL,
    plannedevent_id bigint,
    description character varying(1024),
    action_id bigint,
    responsibleworker_id bigint,
    responsibleworkername character varying(255),
    state character varying(255) DEFAULT '01correct'::character varying,
    reason character varying(1024),
    entityversion bigint DEFAULT 0,
    actionname character varying(255)
);


--
-- Name: cmmsmachineparts_actionforplannedevent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_actionforplannedevent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_actionforplannedevent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_actionforplannedevent_id_seq OWNED BY public.cmmsmachineparts_actionforplannedevent.id;


--
-- Name: cmmsmachineparts_eventattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_eventattachment (
    id bigint NOT NULL,
    maintenanceevent_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: cmmsmachineparts_eventattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_eventattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_eventattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_eventattachment_id_seq OWNED BY public.cmmsmachineparts_eventattachment.id;


--
-- Name: cmmsmachineparts_machinepartattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_machinepartattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_machinepartattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_machinepartattachment_id_seq OWNED BY public.cmmsmachineparts_machinepartattachment.id;


--
-- Name: cmmsmachineparts_machinepartforevent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_machinepartforevent (
    id bigint NOT NULL,
    maintenanceevent_id bigint,
    machinepart_id bigint,
    warehouse_id bigint,
    plannedquantity numeric(14,5),
    availablequantity numeric(14,5),
    plannedevent_id bigint,
    machinepartname character varying(255),
    machinepartnumber character varying(255),
    machinepartunit character varying(255),
    warehousenumber character varying(255),
    entityversion bigint DEFAULT 0,
    recurringevent_id bigint
);


--
-- Name: cmmsmachineparts_machinepartforevent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_machinepartforevent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_machinepartforevent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_machinepartforevent_id_seq OWNED BY public.cmmsmachineparts_machinepartforevent.id;


--
-- Name: cmmsmachineparts_maintenanceevent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_maintenanceevent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_maintenanceevent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_maintenanceevent_id_seq OWNED BY public.cmmsmachineparts_maintenanceevent.id;


--
-- Name: cmmsmachineparts_maintenanceevent_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_maintenanceevent_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_maintenanceeventcontext; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_maintenanceeventcontext (
    id bigint NOT NULL,
    factory_id bigint,
    division_id bigint,
    generated boolean DEFAULT false,
    confirmed boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    datefrom date,
    dateto date
);


--
-- Name: cmmsmachineparts_maintenanceeventcontext_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_maintenanceeventcontext_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_maintenanceeventcontext_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_maintenanceeventcontext_id_seq OWNED BY public.cmmsmachineparts_maintenanceeventcontext.id;


--
-- Name: cmmsmachineparts_maintenanceeventlistdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.cmmsmachineparts_maintenanceeventlistdto AS
 SELECT maintenanceevent.id,
    maintenanceevent.number,
    maintenanceevent.type,
    maintenanceevent.createuser,
    maintenanceevent.createdate,
    maintenanceevent.state,
    maintenanceevent.description,
    context.id AS maintenanceeventcontext_id,
    (((staff.name)::text || ' '::text) || (staff.surname)::text) AS personreceivingname,
    (((reportingemployee.name)::text || ' '::text) || (reportingemployee.surname)::text) AS reportingemployeename,
    (factory.id)::integer AS factory_id,
    factory.number AS factorynumber,
    (division.id)::integer AS division_id,
    division.number AS divisionnumber,
    workstation.number AS workstationnumber,
    subassembly.number AS subassemblynumber,
    faulttype.name AS faulttypename,
    productionline.number AS productionlinenumber,
    maintenanceevent.highestpriority
   FROM (((((((((public.cmmsmachineparts_maintenanceevent maintenanceevent
     LEFT JOIN public.cmmsmachineparts_maintenanceeventcontext context ON ((maintenanceevent.maintenanceeventcontext_id = context.id)))
     LEFT JOIN public.basic_staff staff ON ((maintenanceevent.personreceiving_id = staff.id)))
     LEFT JOIN public.basic_staff reportingemployee ON ((maintenanceevent.reportingemployee_id = reportingemployee.id)))
     LEFT JOIN public.basic_factory factory ON ((maintenanceevent.factory_id = factory.id)))
     LEFT JOIN public.basic_division division ON ((maintenanceevent.division_id = division.id)))
     LEFT JOIN public.basic_workstation workstation ON ((maintenanceevent.workstation_id = workstation.id)))
     LEFT JOIN public.basic_subassembly subassembly ON ((maintenanceevent.subassembly_id = subassembly.id)))
     LEFT JOIN public.basic_faulttype faulttype ON ((maintenanceevent.faulttype_id = faulttype.id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((maintenanceevent.productionline_id = productionline.id)));


--
-- Name: cmmsmachineparts_maintenanceeventlistdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_maintenanceeventlistdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_maintenanceeventstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_maintenanceeventstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    maintenanceevent_id bigint,
    shift_id bigint,
    comment character varying(255),
    commentrequired boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    plannedeventtype character varying(255),
    plannedeventtyperequired boolean DEFAULT false
);


--
-- Name: cmmsmachineparts_maintenanceeventstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_maintenanceeventstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_maintenanceeventstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_maintenanceeventstatechange_id_seq OWNED BY public.cmmsmachineparts_maintenanceeventstatechange.id;


--
-- Name: cmmsmachineparts_maintenanceeventxlshelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_maintenanceeventxlshelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_maintenanceeventxlshelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_maintenanceeventxlshelper (
    id bigint DEFAULT nextval('public.cmmsmachineparts_maintenanceeventxlshelper_id_seq'::regclass) NOT NULL,
    query text,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: cmmsmachineparts_operationtool; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_operationtool (
    id bigint NOT NULL,
    toolcategory character varying(255),
    operation_id bigint,
    tool_id bigint,
    description character varying(2048),
    plannedquantity numeric(12,5),
    unit character varying(255),
    quantity numeric(12,5)
);


--
-- Name: cmmsmachineparts_operationtool_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_operationtool_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_operationtool_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_operationtool_id_seq OWNED BY public.cmmsmachineparts_operationtool.id;


--
-- Name: cmmsmachineparts_orderstoolrequirement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_orderstoolrequirement (
    id bigint NOT NULL,
    number character varying(256),
    name character varying(1024),
    generated boolean,
    worker character varying(255),
    date timestamp without time zone,
    filename character varying(255)
);


--
-- Name: cmmsmachineparts_orderstoolrequirement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_orderstoolrequirement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_orderstoolrequirement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_orderstoolrequirement_id_seq OWNED BY public.cmmsmachineparts_orderstoolrequirement.id;


--
-- Name: cmmsmachineparts_orderstoolrequirement_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_orderstoolrequirement_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_orderstoolrequirementtool; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_orderstoolrequirementtool (
    id bigint NOT NULL,
    orderstoolrequirement_id bigint,
    date date,
    order_id bigint,
    operation_id bigint,
    technologyoperationtool_id bigint,
    quantity numeric(14,5)
);


--
-- Name: cmmsmachineparts_orderstoolrequirementtool_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_orderstoolrequirementtool_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_orderstoolrequirementtool_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_orderstoolrequirementtool_id_seq OWNED BY public.cmmsmachineparts_orderstoolrequirementtool.id;


--
-- Name: cmmsmachineparts_plannedevent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_plannedevent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_plannedevent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_plannedevent_id_seq OWNED BY public.cmmsmachineparts_plannedevent.id;


--
-- Name: cmmsmachineparts_plannedeventattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_plannedeventattachment (
    id bigint NOT NULL,
    plannedevent_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: cmmsmachineparts_plannedeventattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_plannedeventattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_plannedeventattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_plannedeventattachment_id_seq OWNED BY public.cmmsmachineparts_plannedeventattachment.id;


--
-- Name: cmmsmachineparts_plannedeventcontext; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_plannedeventcontext (
    id bigint NOT NULL,
    factory_id bigint,
    division_id bigint,
    generated boolean DEFAULT false,
    confirmed boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    datefrom date,
    dateto date
);


--
-- Name: cmmsmachineparts_plannedeventcontext_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_plannedeventcontext_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_plannedeventcontext_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_plannedeventcontext_id_seq OWNED BY public.cmmsmachineparts_plannedeventcontext.id;


--
-- Name: cmmsmachineparts_sourcecost; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_sourcecost (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    factory_id bigint,
    defaultcost boolean DEFAULT false,
    active boolean DEFAULT true
);


--
-- Name: cmmsmachineparts_plannedeventlistdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.cmmsmachineparts_plannedeventlistdto AS
 SELECT e.id,
    e.number,
    e.type,
    (((owner.name)::text || ' '::text) || (owner.surname)::text) AS ownername,
    e.description,
    factory.number AS factorynumber,
    (factory.id)::integer AS factory_id,
    division.number AS divisionnumber,
    (division.id)::integer AS division_id,
    productionline.number AS productionlinenumber,
    workstation.number AS workstationnumber,
    subassembly.number AS subassemblynumber,
    (e.date)::timestamp without time zone AS date,
    e.counter,
    e.createuser,
    e.createdate,
    e.state,
    context.id AS plannedeventcontext_id,
    workstation.id AS workstation_id,
    subassembly.id AS subassembly_id,
    company.id AS company_id,
    sourcecost.id AS sourcecost_id
   FROM (((((((((public.cmmsmachineparts_plannedevent e
     LEFT JOIN public.basic_staff owner ON ((e.owner_id = owner.id)))
     JOIN public.basic_factory factory ON ((e.factory_id = factory.id)))
     JOIN public.basic_division division ON ((e.division_id = division.id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((e.productionline_id = productionline.id)))
     LEFT JOIN public.basic_workstation workstation ON ((e.workstation_id = workstation.id)))
     LEFT JOIN public.basic_subassembly subassembly ON ((e.subassembly_id = subassembly.id)))
     LEFT JOIN public.cmmsmachineparts_plannedeventcontext context ON ((e.plannedeventcontext_id = context.id)))
     LEFT JOIN public.basic_company company ON ((e.company_id = company.id)))
     LEFT JOIN public.cmmsmachineparts_sourcecost sourcecost ON ((e.sourcecost_id = sourcecost.id)));


--
-- Name: cmmsmachineparts_plannedeventlistdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_plannedeventlistdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_plannedeventrealization; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_plannedeventrealization (
    id bigint NOT NULL,
    plannedevent_id bigint,
    worker_id bigint,
    action_id bigint,
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    duration integer DEFAULT 0,
    entityversion bigint DEFAULT 0,
    confirmed boolean DEFAULT true
);


--
-- Name: cmmsmachineparts_plannedeventrealization_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_plannedeventrealization_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_plannedeventrealization_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_plannedeventrealization_id_seq OWNED BY public.cmmsmachineparts_plannedeventrealization.id;


--
-- Name: cmmsmachineparts_plannedeventstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_plannedeventstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    plannedevent_id bigint,
    shift_id bigint,
    comment character varying(255),
    commentrequired boolean DEFAULT false
);


--
-- Name: cmmsmachineparts_plannedeventstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_plannedeventstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_plannedeventstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_plannedeventstatechange_id_seq OWNED BY public.cmmsmachineparts_plannedeventstatechange.id;


--
-- Name: cmmsmachineparts_plannedeventxlshelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_plannedeventxlshelper (
    id bigint NOT NULL,
    query text,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: cmmsmachineparts_plannedeventxlshelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_plannedeventxlshelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_plannedeventxlshelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_plannedeventxlshelper_id_seq OWNED BY public.cmmsmachineparts_plannedeventxlshelper.id;


--
-- Name: cmmsmachineparts_sourcecost_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_sourcecost_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_sourcecost_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_sourcecost_id_seq OWNED BY public.cmmsmachineparts_sourcecost.id;


--
-- Name: cmmsmachineparts_sourcecostreportfilter; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_sourcecostreportfilter (
    id bigint NOT NULL,
    fromdate date,
    todate date,
    sourcecost_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    dontsave boolean
);


--
-- Name: cmmsmachineparts_sourcecostreportfilter_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_sourcecostreportfilter_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_sourcecostreportfilter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_sourcecostreportfilter_id_seq OWNED BY public.cmmsmachineparts_sourcecostreportfilter.id;


--
-- Name: cmmsmachineparts_staffworktime; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_staffworktime (
    id bigint NOT NULL,
    maintenanceevent_id bigint,
    worker_id bigint,
    labortime integer DEFAULT 0,
    effectiveexecutiontimestart timestamp without time zone,
    effectiveexecutiontimeend timestamp without time zone,
    entityversion bigint DEFAULT 0
);


--
-- Name: cmmsmachineparts_staffworktime_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_staffworktime_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_staffworktime_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_staffworktime_id_seq OWNED BY public.cmmsmachineparts_staffworktime.id;


--
-- Name: cmmsmachineparts_technologyoperationtool; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_technologyoperationtool (
    id bigint NOT NULL,
    toolcategory character varying(255),
    technologyoperationcomponent_id bigint,
    tool_id bigint,
    description character varying(2048),
    quantity numeric(12,5),
    unit character varying(255)
);


--
-- Name: cmmsmachineparts_technologyoperationtool_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_technologyoperationtool_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_technologyoperationtool_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_technologyoperationtool_id_seq OWNED BY public.cmmsmachineparts_technologyoperationtool.id;


--
-- Name: cmmsmachineparts_timeusagereportfilter; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsmachineparts_timeusagereportfilter (
    id bigint NOT NULL,
    fromdate date,
    todate date,
    workersselection character varying(255),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: cmmsmachineparts_timeusagereportfilter_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_timeusagereportfilter_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_timeusagereportfilter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_timeusagereportfilter_id_seq OWNED BY public.cmmsmachineparts_timeusagereportfilter.id;


--
-- Name: cmmsmachineparts_tool_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_tool_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_tool_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_tool_id_seq OWNED BY public.cmmsmachineparts_tool.id;


--
-- Name: cmmsmachineparts_toolattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_toolattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsmachineparts_toolattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsmachineparts_toolattachment_id_seq OWNED BY public.cmmsmachineparts_toolattachment.id;


--
-- Name: cmmsmachineparts_worktimeforuserdto_internal; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.cmmsmachineparts_worktimeforuserdto_internal AS
 SELECT u.username,
    swt.effectiveexecutiontimestart AS startdate,
    swt.effectiveexecutiontimeend AS finishdate,
    swt.labortime AS duration,
    me.number AS eventnumber,
    me.type AS eventtype,
    COALESCE(s.number, w.number, p.number, d.number, f.number) AS objectnumber,
    NULL::character varying AS actionname
   FROM (((((((public.cmmsmachineparts_staffworktime swt
     JOIN public.qcadoosecurity_user u ON ((swt.worker_id = u.staff_id)))
     JOIN public.cmmsmachineparts_maintenanceevent me ON ((me.id = swt.maintenanceevent_id)))
     JOIN public.basic_factory f ON ((me.factory_id = f.id)))
     JOIN public.basic_division d ON ((me.division_id = d.id)))
     LEFT JOIN public.productionlines_productionline p ON ((me.productionline_id = p.id)))
     LEFT JOIN public.basic_workstation w ON ((me.workstation_id = w.id)))
     LEFT JOIN public.basic_subassembly s ON ((me.subassembly_id = s.id)))
UNION ALL
 SELECT u.username,
    per.startdate,
    per.finishdate,
    per.duration,
    pe.number AS eventnumber,
    pe.type AS eventtype,
    COALESCE(s.number, w.number, p.number, d.number, f.number) AS objectnumber,
    a.name AS actionname
   FROM (((((((((public.cmmsmachineparts_plannedeventrealization per
     JOIN public.qcadoosecurity_user u ON ((per.worker_id = u.staff_id)))
     JOIN public.cmmsmachineparts_plannedevent pe ON ((pe.id = per.plannedevent_id)))
     JOIN public.basic_factory f ON ((pe.factory_id = f.id)))
     JOIN public.basic_division d ON ((pe.division_id = d.id)))
     LEFT JOIN public.productionlines_productionline p ON ((pe.productionline_id = p.id)))
     LEFT JOIN public.basic_workstation w ON ((pe.workstation_id = w.id)))
     LEFT JOIN public.basic_subassembly s ON ((pe.subassembly_id = s.id)))
     LEFT JOIN public.cmmsmachineparts_actionforplannedevent afpe ON ((per.action_id = afpe.id)))
     LEFT JOIN public.cmmsmachineparts_action a ON ((afpe.action_id = a.id)));


--
-- Name: cmmsmachineparts_worktimeforuserdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.cmmsmachineparts_worktimeforuserdto AS
 SELECT row_number() OVER () AS id,
    internal.username,
    internal.startdate,
    internal.finishdate,
    internal.duration,
    internal.eventnumber,
    internal.eventtype,
    internal.objectnumber,
    internal.actionname
   FROM public.cmmsmachineparts_worktimeforuserdto_internal internal;


--
-- Name: cmmsmachineparts_worktimeforuserdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsmachineparts_worktimeforuserdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsscheduler_actionforrecurringevent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsscheduler_actionforrecurringevent (
    id bigint NOT NULL,
    recurringevent_id bigint,
    description character varying(1024),
    action_id bigint
);


--
-- Name: cmmsscheduler_actionforrecurringevent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsscheduler_actionforrecurringevent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsscheduler_actionforrecurringevent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsscheduler_actionforrecurringevent_id_seq OWNED BY public.cmmsscheduler_actionforrecurringevent.id;


--
-- Name: cmmsscheduler_recurringevent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsscheduler_recurringevent (
    id bigint NOT NULL,
    number character varying(255),
    type character varying(255) DEFAULT '01review'::character varying,
    periodicitydate character varying(255),
    periodicitystate numeric(14,5),
    generation character varying(255) DEFAULT '01recurring'::character varying,
    description character varying(255),
    owner_id bigint,
    ownername character varying(255),
    state character varying(255) DEFAULT '01draft'::character varying,
    factory_id bigint,
    division_id bigint,
    productionline_id bigint,
    workstation_id bigint,
    subassembly_id bigint,
    company_id bigint,
    sourcecost_id bigint,
    plannedseparately boolean DEFAULT false,
    requiresshutdown boolean DEFAULT false,
    basedon character varying(255) DEFAULT '01date'::character varying,
    date date,
    counter numeric(14,5),
    countertolerance numeric(14,5),
    duration integer DEFAULT 0,
    effectiveduration integer DEFAULT 0,
    effectivecounter numeric(14,5),
    recurringeventcontext_id bigint,
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    nextgenerationdate date,
    nextdate date,
    multiplier integer DEFAULT 1
);


--
-- Name: cmmsscheduler_recurringevent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsscheduler_recurringevent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsscheduler_recurringevent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsscheduler_recurringevent_id_seq OWNED BY public.cmmsscheduler_recurringevent.id;


--
-- Name: cmmsscheduler_recurringeventattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsscheduler_recurringeventattachment (
    id bigint NOT NULL,
    recurringevent_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255)
);


--
-- Name: cmmsscheduler_recurringeventattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsscheduler_recurringeventattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsscheduler_recurringeventattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsscheduler_recurringeventattachment_id_seq OWNED BY public.cmmsscheduler_recurringeventattachment.id;


--
-- Name: cmmsscheduler_recurringeventcontext; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsscheduler_recurringeventcontext (
    id bigint NOT NULL,
    factory_id bigint,
    division_id bigint,
    generated boolean DEFAULT false,
    confirmed boolean DEFAULT false,
    datefrom date,
    dateto date
);


--
-- Name: cmmsscheduler_recurringeventcontext_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsscheduler_recurringeventcontext_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsscheduler_recurringeventcontext_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsscheduler_recurringeventcontext_id_seq OWNED BY public.cmmsscheduler_recurringeventcontext.id;


--
-- Name: cmmsscheduler_recurringeventstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.cmmsscheduler_recurringeventstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    recurringevent_id bigint,
    shift_id bigint
);


--
-- Name: cmmsscheduler_recurringeventstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.cmmsscheduler_recurringeventstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: cmmsscheduler_recurringeventstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.cmmsscheduler_recurringeventstatechange_id_seq OWNED BY public.cmmsscheduler_recurringeventstatechange.id;


--
-- Name: costcalculation_additionaldirectcost; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.costcalculation_additionaldirectcost (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    active boolean DEFAULT true
);


--
-- Name: costcalculation_additionaldirectcost_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.costcalculation_additionaldirectcost_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: costcalculation_additionaldirectcost_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.costcalculation_additionaldirectcost_id_seq OWNED BY public.costcalculation_additionaldirectcost.id;


--
-- Name: costcalculation_additionaldirectcostitem; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.costcalculation_additionaldirectcostitem (
    id bigint NOT NULL,
    additionaldirectcost_id bigint,
    actualcost numeric(9,2),
    datefrom date,
    dateto date
);


--
-- Name: costcalculation_additionaldirectcostitem_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.costcalculation_additionaldirectcostitem_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: costcalculation_additionaldirectcostitem_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.costcalculation_additionaldirectcostitem_id_seq OWNED BY public.costcalculation_additionaldirectcostitem.id;


--
-- Name: costcalculation_calculationresult; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.costcalculation_calculationresult (
    id bigint NOT NULL,
    costcalculation_id bigint,
    product_id bigint,
    technology_id bigint,
    materialcosts numeric(19,5),
    labourcost numeric(19,5),
    productioncosts numeric(19,5),
    totalcost numeric(19,5),
    registrationprice numeric(19,5),
    technicalproductioncost numeric(19,5),
    sellingprice numeric(19,5),
    nomaterialprice boolean DEFAULT false,
    profitvalue numeric(12,5),
    registrationpriceoverheadvalue numeric(12,5),
    materialcostmarginvalue numeric(12,5),
    labourcostmarginvalue numeric(12,5),
    totalmanufacturingcost numeric(19,5),
    technicalproductioncostoverheadvalue numeric(19,5)
);


--
-- Name: costcalculation_calculationresult_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.costcalculation_calculationresult_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: costcalculation_calculationresult_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.costcalculation_calculationresult_id_seq OWNED BY public.costcalculation_calculationresult.id;


--
-- Name: costcalculation_componentcost; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.costcalculation_componentcost (
    id bigint NOT NULL,
    costcalculation_id bigint,
    product_id bigint,
    priceperunit numeric(19,5)
);


--
-- Name: costcalculation_componentcost_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.costcalculation_componentcost_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: costcalculation_componentcost_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.costcalculation_componentcost_id_seq OWNED BY public.costcalculation_componentcost.id;


--
-- Name: costcalculation_costcalculation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.costcalculation_costcalculation (
    id bigint NOT NULL,
    number character varying(255),
    quantity numeric(12,5) DEFAULT 0,
    productioncostmargin numeric(19,5) DEFAULT (0)::numeric,
    materialcostmargin numeric(19,5) DEFAULT (0)::numeric,
    additionaloverhead numeric(19,5) DEFAULT (0)::numeric,
    description character varying(255),
    includetpz boolean DEFAULT true,
    includeadditionaltime boolean DEFAULT false,
    materialcostsused character varying(255) DEFAULT 'nominal'::character varying,
    date timestamp without time zone,
    generated boolean,
    filename character varying(255),
    includecomponents boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    sourceofoperationcosts character varying(255),
    registrationpriceoverhead numeric(19,5),
    profit numeric(19,5),
    standardlaborcost_id bigint,
    averagemachinehourlycost numeric(12,5),
    averagelaborhourlycost numeric(12,5),
    usenominalcostpricenotspecified boolean DEFAULT false,
    pdf boolean DEFAULT false,
    technicalproductioncostoverhead numeric(19,5) DEFAULT 0,
    offer_id bigint
);


--
-- Name: costcalculation_costcalculation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.costcalculation_costcalculation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: costcalculation_costcalculation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.costcalculation_costcalculation_id_seq OWNED BY public.costcalculation_costcalculation.id;


--
-- Name: costcalculation_orderadditionaldirectcost; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.costcalculation_orderadditionaldirectcost (
    id bigint NOT NULL,
    additionaldirectcost_id bigint,
    order_id bigint,
    actualcost numeric(9,2)
);


--
-- Name: costcalculation_orderadditionaldirectcost_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.costcalculation_orderadditionaldirectcost_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: costcalculation_orderadditionaldirectcost_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.costcalculation_orderadditionaldirectcost_id_seq OWNED BY public.costcalculation_orderadditionaldirectcost.id;


--
-- Name: costcalculation_standard_labor_cost_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.costcalculation_standard_labor_cost_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: costcalculation_standardlaborcost; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.costcalculation_standardlaborcost (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(255),
    laborcost numeric(19,5)
);


--
-- Name: costcalculation_standardlaborcost_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.costcalculation_standardlaborcost_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: costcalculation_standardlaborcost_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.costcalculation_standardlaborcost_id_seq OWNED BY public.costcalculation_standardlaborcost.id;


--
-- Name: costnormsformaterials_technologyinstoperproductincomp; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.costnormsformaterials_technologyinstoperproductincomp (
    id bigint NOT NULL,
    order_id bigint,
    product_id bigint,
    costfororder numeric(12,5) DEFAULT (0)::numeric,
    entityversion bigint DEFAULT 0,
    averagepricesubcontractor numeric(12,5) DEFAULT 0
);


--
-- Name: costnormsformaterials_technologyinstoperproductincomp_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.costnormsformaterials_technologyinstoperproductincomp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: costnormsformaterials_technologyinstoperproductincomp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.costnormsformaterials_technologyinstoperproductincomp_id_seq OWNED BY public.costnormsformaterials_technologyinstoperproductincomp.id;


--
-- Name: costnormsformaterials_technologyinstoperproductincompdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.costnormsformaterials_technologyinstoperproductincompdto AS
 SELECT tiopic.id,
    (tiopic.order_id)::integer AS orderid,
    p.number AS productnumber,
    p.name AS productname,
    p.nominalcost,
    ncur.alphabeticcode AS nominalcostcurrency,
    p.lastpurchasecost,
    lcur.alphabeticcode AS lastpurchasecostcurrency,
    p.averagecost,
    acur.alphabeticcode AS averagecostcurrency,
    tiopic.costfororder,
    cur.alphabeticcode AS costforordercurrency,
    p.lastoffercost,
    cur.alphabeticcode AS lastoffercostcurrency,
    p.averageoffercost,
    cur.alphabeticcode AS averageoffercostcurrency,
    p.costfornumber,
    p.unit
   FROM ((((((public.costnormsformaterials_technologyinstoperproductincomp tiopic
     JOIN public.basic_product p ON ((tiopic.product_id = p.id)))
     CROSS JOIN public.basic_parameter par)
     LEFT JOIN public.basic_currency cur ON ((cur.id = par.currency_id)))
     LEFT JOIN public.basic_currency acur ON ((acur.id = p.averagecostcurrency_id)))
     LEFT JOIN public.basic_currency lcur ON ((lcur.id = p.lastpurchasecostcurrency_id)))
     LEFT JOIN public.basic_currency ncur ON ((ncur.id = p.nominalcostcurrency_id)));


--
-- Name: costnormsformaterials_technologyinstoperproductincompdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.costnormsformaterials_technologyinstoperproductincompdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: costnormsforoperation_calculationoperationcomponent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.costnormsforoperation_calculationoperationcomponent (
    id bigint NOT NULL,
    nodenumber character varying(255),
    operation_id bigint,
    technologyoperationcomponent_id bigint,
    parent_id bigint,
    entitytype character varying(255) DEFAULT 'operation'::character varying,
    priority integer,
    tpz integer,
    tj integer,
    areproductquantitiesdivisible boolean DEFAULT false,
    istjdivisible boolean DEFAULT false,
    machineutilization numeric(12,5),
    laborutilization numeric(12,5),
    productioninonecycle numeric(12,5) DEFAULT (1)::numeric,
    nextoperationafterproducedtype character varying(255) DEFAULT '01all'::character varying,
    nextoperationafterproducedquantity numeric(12,5),
    timenextoperation integer,
    operationoffset integer,
    effectiveoperationrealizationtime integer,
    effectivedatefrom timestamp without time zone,
    effectivedateto timestamp without time zone,
    duration integer DEFAULT 0,
    machineworktime integer DEFAULT 0,
    laborworktime integer DEFAULT 0,
    operationcost numeric(12,5) DEFAULT (0)::numeric,
    totalmachineoperationcost numeric(12,5) DEFAULT (0)::numeric,
    totallaboroperationcost numeric(12,5) DEFAULT (0)::numeric,
    laborhourlycost numeric(12,5) DEFAULT (0)::numeric,
    machinehourlycost numeric(12,5) DEFAULT (0)::numeric,
    costcalculation_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: costnormsforoperation_calculationoperationcomponent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.costnormsforoperation_calculationoperationcomponent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: costnormsforoperation_calculationoperationcomponent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.costnormsforoperation_calculationoperationcomponent_id_seq OWNED BY public.costnormsforoperation_calculationoperationcomponent.id;


--
-- Name: deliveries_companyproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.deliveries_companyproduct (
    id bigint NOT NULL,
    company_id bigint,
    product_id bigint,
    isdefault boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    minimumorderquantity numeric(12,5),
    bufferfordeliverytimes integer
);


--
-- Name: deliveries_bufferfordeliverytimes_family; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.deliveries_bufferfordeliverytimes_family AS
 SELECT product.id AS product_id,
    _companyproductsfamily.bufferfordeliverytimes AS bufferfordeliverytimesfamily,
    _companyproductsfamily.company_id,
    _companyproductsfamily.product_id AS product_family_id
   FROM ((public.basic_product product
     LEFT JOIN public.basic_product parent ON ((parent.id = product.parent_id)))
     LEFT JOIN public.deliveries_companyproduct _companyproductsfamily ON ((_companyproductsfamily.product_id = parent.id)));


--
-- Name: deliveries_bufferfordeliverytimes_product; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.deliveries_bufferfordeliverytimes_product AS
 SELECT _companyproduct.bufferfordeliverytimes,
    _companyproduct.company_id,
    _companyproduct.product_id
   FROM (public.basic_product product
     LEFT JOIN public.deliveries_companyproduct _companyproduct ON ((_companyproduct.product_id = product.id)));


--
-- Name: deliveries_columnfordeliveries; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.deliveries_columnfordeliveries (
    id bigint NOT NULL,
    identifier character varying(255),
    name character varying(1024),
    description character varying(1024),
    columnfiller character varying(255),
    alignment character varying(255) DEFAULT '01left'::character varying,
    parameter_id bigint,
    succession integer,
    entityversion bigint DEFAULT 0
);


--
-- Name: deliveries_columnfordeliveries_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_columnfordeliveries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_columnfordeliveries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.deliveries_columnfordeliveries_id_seq OWNED BY public.deliveries_columnfordeliveries.id;


--
-- Name: deliveries_columnfororders; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.deliveries_columnfororders (
    id bigint NOT NULL,
    identifier character varying(255),
    name character varying(1024),
    description character varying(1024),
    columnfiller character varying(255),
    alignment character varying(255) DEFAULT '01left'::character varying,
    parameter_id bigint,
    succession integer,
    entityversion bigint DEFAULT 0
);


--
-- Name: deliveries_columnfororders_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_columnfororders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_columnfororders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.deliveries_columnfororders_id_seq OWNED BY public.deliveries_columnfororders.id;


--
-- Name: deliveries_companyproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_companyproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_companyproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.deliveries_companyproduct_id_seq OWNED BY public.deliveries_companyproduct.id;


--
-- Name: deliveries_deliveredpackage; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.deliveries_deliveredpackage (
    id bigint NOT NULL,
    delivery_id bigint,
    product_id bigint,
    deliveredquantity numeric(14,5)
);


--
-- Name: deliveries_deliveredpackage_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_deliveredpackage_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_deliveredpackage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.deliveries_deliveredpackage_id_seq OWNED BY public.deliveries_deliveredpackage.id;


--
-- Name: deliveries_deliveredproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.deliveries_deliveredproduct (
    id bigint NOT NULL,
    delivery_id bigint,
    product_id bigint,
    deliveredquantity numeric(12,5),
    damagedquantity numeric(12,5),
    priceperunit numeric(12,5),
    totalprice numeric(12,5),
    succession integer,
    operation_id bigint,
    offer_id bigint,
    batchnumber character varying(255),
    productiondate date,
    expirationdate date,
    entityversion bigint DEFAULT 0,
    palletnumber_id bigint,
    pallettype character varying(255),
    storagelocation_id bigint,
    additionalquantity numeric(12,5),
    conversion numeric(12,5),
    iswaste boolean,
    additionalunit character varying(255),
    damaged boolean DEFAULT false,
    batch_id bigint,
    orderedproduct_id bigint,
    qualityrating character varying(255)
);


--
-- Name: deliveries_deliveredproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_deliveredproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_deliveredproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.deliveries_deliveredproduct_id_seq OWNED BY public.deliveries_deliveredproduct.id;


--
-- Name: deliveries_deliveredproductattributeval; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.deliveries_deliveredproductattributeval (
    id bigint NOT NULL,
    deliveredproduct_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255)
);


--
-- Name: deliveries_deliveredproductattributeval_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_deliveredproductattributeval_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_deliveredproductattributeval_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.deliveries_deliveredproductattributeval_id_seq OWNED BY public.deliveries_deliveredproductattributeval.id;


--
-- Name: productcatalognumbers_productcatalognumbers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productcatalognumbers_productcatalognumbers (
    id bigint NOT NULL,
    catalognumber character varying(256),
    product_id bigint,
    company_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: supplynegotiations_offer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.supplynegotiations_offer (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    description character varying(2048),
    supplier_id bigint,
    requestforquotation_id bigint,
    offereddate timestamp without time zone,
    attachment character varying(255),
    transportcost numeric(12,5),
    state character varying(255) DEFAULT '01draft'::character varying,
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    workingdaysafterorder integer,
    negotiation_id bigint,
    entityversion bigint DEFAULT 0,
    offerdate date,
    currency_id bigint
);


--
-- Name: deliveries_deliveredproductdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.deliveries_deliveredproductdto AS
 SELECT deliveredproduct.id,
    deliveredproduct.succession,
    deliveredproduct.damagedquantity,
    deliveredproduct.deliveredquantity,
    deliveredproduct.priceperunit,
    deliveredproduct.totalprice,
    deliveredproduct.conversion,
    deliveredproduct.additionalquantity,
    deliveredproduct.iswaste,
    delivery.id AS delivery,
    (delivery.id)::integer AS deliveryid,
    delivery.supplier_id AS supplier,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    offer.number AS offernumber,
    operation.number AS operationnumber,
    storagelocation.number AS storagelocationnumber,
    palletnumber.number AS palletnumber,
    batch.number AS batchnumber,
    ( SELECT productcatalognumbers_productcatalognumbers.catalognumber
           FROM public.productcatalognumbers_productcatalognumbers
          WHERE ((productcatalognumbers_productcatalognumbers.product_id = product.id) AND (productcatalognumbers_productcatalognumbers.company_id = delivery.supplier_id))) AS productcatalognumber,
    deliveredproduct.pallettype,
    deliveredproduct.additionalunit,
    deliveredproduct.damaged,
    deliveredproduct.expirationdate
   FROM (((((((public.deliveries_deliveredproduct deliveredproduct
     LEFT JOIN public.deliveries_delivery delivery ON ((delivery.id = deliveredproduct.delivery_id)))
     LEFT JOIN public.basic_product product ON ((product.id = deliveredproduct.product_id)))
     LEFT JOIN public.supplynegotiations_offer offer ON ((offer.id = deliveredproduct.offer_id)))
     LEFT JOIN public.technologies_operation operation ON ((operation.id = deliveredproduct.operation_id)))
     LEFT JOIN public.materialflowresources_storagelocation storagelocation ON ((storagelocation.id = deliveredproduct.storagelocation_id)))
     LEFT JOIN public.basic_palletnumber palletnumber ON ((palletnumber.id = deliveredproduct.palletnumber_id)))
     LEFT JOIN public.advancedgenealogy_batch batch ON ((batch.id = deliveredproduct.batch_id)));


--
-- Name: deliveries_deliveredproductdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_deliveredproductdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_deliveredproductmulti; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.deliveries_deliveredproductmulti (
    id bigint NOT NULL,
    delivery_id bigint,
    palletnumber_id bigint,
    pallettype character varying(255),
    storagelocation_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: deliveries_deliveredproductmulti_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_deliveredproductmulti_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_deliveredproductmulti_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.deliveries_deliveredproductmulti_id_seq OWNED BY public.deliveries_deliveredproductmulti.id;


--
-- Name: deliveries_deliveredproductmultiposition; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.deliveries_deliveredproductmultiposition (
    id bigint NOT NULL,
    deliveredproductmulti_id bigint,
    product_id bigint,
    quantity numeric(12,5),
    additionalquantity numeric(12,5),
    conversion numeric(12,5),
    iswaste boolean,
    expirationdate date,
    unit character varying(255),
    additionalunit character varying(255),
    offer_id bigint,
    batch_id bigint,
    priceperunit numeric(12,5)
);


--
-- Name: deliveries_deliveredproductmultiposition_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_deliveredproductmultiposition_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_deliveredproductmultiposition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.deliveries_deliveredproductmultiposition_id_seq OWNED BY public.deliveries_deliveredproductmultiposition.id;


--
-- Name: deliveries_delivery_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_delivery_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_delivery_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.deliveries_delivery_id_seq OWNED BY public.deliveries_delivery.id;


--
-- Name: deliveries_deliveryattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_deliveryattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_deliveryattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.deliveries_deliveryattachment_id_seq OWNED BY public.deliveries_deliveryattachment.id;


--
-- Name: deliveries_deliverybypallettypereport; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.deliveries_deliverybypallettypereport (
    id bigint NOT NULL,
    fromdate date,
    todate date
);


--
-- Name: deliveries_deliverybypallettypereport_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_deliverybypallettypereport_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_deliverybypallettypereport_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.deliveries_deliverybypallettypereport_id_seq OWNED BY public.deliveries_deliverybypallettypereport.id;


--
-- Name: deliveries_deliverystatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.deliveries_deliverystatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    shift_id bigint,
    worker character varying(255),
    delivery_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: deliveries_deliverystatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_deliverystatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_deliverystatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.deliveries_deliverystatechange_id_seq OWNED BY public.deliveries_deliverystatechange.id;


--
-- Name: deliveries_orderedproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.deliveries_orderedproduct (
    id bigint NOT NULL,
    delivery_id bigint,
    product_id bigint,
    orderedquantity numeric(12,5),
    priceperunit numeric(12,5),
    totalprice numeric(12,5),
    description character varying(2048),
    succession integer,
    operation_id bigint,
    offer_id bigint,
    actualversion character varying(255),
    entityversion bigint DEFAULT 0,
    additionalquantity numeric(12,5),
    conversion numeric(12,5),
    deliveredquantity numeric,
    additionaldeliveredquantity numeric,
    batchnumber character varying(255),
    batch_id bigint,
    qualitycard_id bigint
);


--
-- Name: deliveries_orderedproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_orderedproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_orderedproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.deliveries_orderedproduct_id_seq OWNED BY public.deliveries_orderedproduct.id;


--
-- Name: supplynegotiations_negotiation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.supplynegotiations_negotiation (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    state character varying(255) DEFAULT '01draft'::character varying,
    generatedate timestamp without time zone,
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: deliveries_orderedproductdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.deliveries_orderedproductdto AS
 WITH product_attachments AS (
         SELECT product_1.id AS productid,
            (count(attachment.id) <> 0) AS hasattachments
           FROM (public.basic_product product_1
             LEFT JOIN public.basic_productattachment attachment ON ((attachment.product_id = product_1.id)))
          GROUP BY product_1.id
        )
 SELECT orderedproduct.id,
    orderedproduct.succession,
    orderedproduct.orderedquantity,
    orderedproduct.priceperunit,
    orderedproduct.totalprice,
    orderedproduct.conversion,
    orderedproduct.additionalquantity,
    orderedproduct.description,
    orderedproduct.actualversion,
    delivery.id AS delivery,
    (delivery.id)::integer AS deliveryid,
    delivery.supplier_id AS supplier,
    delivery.deliverydate,
    delivery.state AS deliverystate,
    delivery.number AS deliverynumber,
    delivery.name AS deliveryname,
    delivery.active AS deliveryactive,
    currency.alphabeticcode AS deliverycurrency,
    supplier.name AS suppliername,
    product.number AS productnumber,
    product.name AS productname,
    product.norm AS productnorm,
    product.unit AS productunit,
    product.additionalunit,
    offer.number AS offernumber,
    negotiation.number AS negotiationnumber,
    operation.number AS operationnumber,
    ( SELECT productcatalognumbers_productcatalognumbers.catalognumber
           FROM public.productcatalognumbers_productcatalognumbers
          WHERE ((productcatalognumbers_productcatalognumbers.product_id = product.id) AND (productcatalognumbers_productcatalognumbers.company_id = delivery.supplier_id))) AS productcatalognumber,
    COALESCE(orderedproduct.deliveredquantity, (0)::numeric) AS deliveredquantity,
    COALESCE(orderedproduct.additionaldeliveredquantity, (0)::numeric) AS additionaldeliveredquantity,
        CASE
            WHEN ((orderedproduct.orderedquantity - COALESCE(orderedproduct.deliveredquantity, (0)::numeric)) > (0)::numeric) THEN (orderedproduct.orderedquantity - COALESCE(orderedproduct.deliveredquantity, (0)::numeric))
            ELSE (0)::numeric
        END AS lefttoreceivequantity,
        CASE
            WHEN ((orderedproduct.additionalquantity - COALESCE(orderedproduct.additionaldeliveredquantity, (0)::numeric)) > (0)::numeric) THEN (orderedproduct.additionalquantity - COALESCE(orderedproduct.additionaldeliveredquantity, (0)::numeric))
            ELSE (0)::numeric
        END AS additionallefttoreceivequantity,
    attachments.hasattachments,
    batch.number AS batchnumber,
    qualitycard.number AS qualitycardnumber,
    parentproduct.number AS parentproductnumber,
    companyproduct.minimumorderquantity,
    companyproductsfamily.minimumorderquantity AS minimumfamilyorderquantity,
        CASE
            WHEN (companyproduct.minimumorderquantity IS NOT NULL) THEN companyproduct.minimumorderquantity
            ELSE companyproductsfamily.minimumorderquantity
        END AS minorderquantity,
        CASE
            WHEN ((companyproduct.minimumorderquantity IS NULL) AND (companyproductsfamily.minimumorderquantity IS NULL)) THEN false
            WHEN ((companyproduct.minimumorderquantity IS NOT NULL) AND (companyproduct.minimumorderquantity <= orderedproduct.orderedquantity)) THEN false
            WHEN ((companyproductsfamily.minimumorderquantity IS NOT NULL) AND (companyproductsfamily.minimumorderquantity <= orderedproduct.orderedquantity)) THEN false
            ELSE true
        END AS belowminorderquantity
   FROM (((((((((((((public.deliveries_orderedproduct orderedproduct
     LEFT JOIN public.deliveries_delivery delivery ON ((delivery.id = orderedproduct.delivery_id)))
     LEFT JOIN public.basic_currency currency ON ((currency.id = delivery.currency_id)))
     LEFT JOIN public.basic_company supplier ON ((supplier.id = delivery.supplier_id)))
     LEFT JOIN public.basic_product product ON ((product.id = orderedproduct.product_id)))
     LEFT JOIN public.basic_product parentproduct ON ((product.parent_id = parentproduct.id)))
     LEFT JOIN public.deliveries_companyproduct companyproduct ON (((product.id = companyproduct.product_id) AND (supplier.id = companyproduct.company_id))))
     LEFT JOIN public.deliveries_companyproduct companyproductsfamily ON (((parentproduct.id = companyproductsfamily.product_id) AND (supplier.id = companyproductsfamily.company_id))))
     LEFT JOIN public.supplynegotiations_offer offer ON ((offer.id = orderedproduct.offer_id)))
     LEFT JOIN public.supplynegotiations_negotiation negotiation ON ((negotiation.id = offer.negotiation_id)))
     LEFT JOIN public.technologies_operation operation ON ((operation.id = orderedproduct.operation_id)))
     LEFT JOIN product_attachments attachments ON ((attachments.productid = product.id)))
     LEFT JOIN public.advancedgenealogy_batch batch ON ((batch.id = orderedproduct.batch_id)))
     LEFT JOIN public.basic_qualitycard qualitycard ON ((qualitycard.id = orderedproduct.qualitycard_id)));


--
-- Name: deliveries_orderedproductdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_orderedproductdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_orderedproductlistdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.deliveries_orderedproductlistdto AS
 SELECT orderedproduct.id,
    orderedproduct.succession,
    orderedproduct.orderedquantity,
    orderedproduct.priceperunit,
    orderedproduct.conversion,
    orderedproduct.additionalquantity,
    orderedproduct.description,
    orderedproduct.actualversion,
    delivery.id AS delivery,
    (delivery.id)::integer AS deliveryid,
    delivery.supplier_id AS supplier,
    delivery.deliverydate,
    delivery.state AS deliverystate,
    delivery.number AS deliverynumber,
    delivery.name AS deliveryname,
    delivery.active AS deliveryactive,
    currency.alphabeticcode AS deliverycurrency,
    supplier.name AS suppliername,
    product.number AS productnumber,
    product.name AS productname,
    product.norm AS productnorm,
    product.unit AS productunit,
    offer.number AS offernumber,
    negotiation.number AS negotiationnumber,
    operation.number AS operationnumber,
    ( SELECT productcatalognumbers_productcatalognumbers.catalognumber
           FROM public.productcatalognumbers_productcatalognumbers
          WHERE ((productcatalognumbers_productcatalognumbers.product_id = product.id) AND (productcatalognumbers_productcatalognumbers.company_id = delivery.supplier_id))) AS productcatalognumber,
    (delivery.location_id)::integer AS location_id,
    COALESCE(orderedproduct.deliveredquantity, (0)::numeric) AS deliveredquantity,
    batch.number AS batchnumber
   FROM ((((((((public.deliveries_orderedproduct orderedproduct
     LEFT JOIN public.deliveries_delivery delivery ON ((orderedproduct.delivery_id = delivery.id)))
     LEFT JOIN public.basic_currency currency ON ((delivery.currency_id = currency.id)))
     LEFT JOIN public.basic_company supplier ON ((delivery.supplier_id = supplier.id)))
     LEFT JOIN public.basic_product product ON ((orderedproduct.product_id = product.id)))
     LEFT JOIN public.supplynegotiations_offer offer ON ((orderedproduct.offer_id = offer.id)))
     LEFT JOIN public.supplynegotiations_negotiation negotiation ON ((offer.negotiation_id = negotiation.id)))
     LEFT JOIN public.technologies_operation operation ON ((orderedproduct.operation_id = operation.id)))
     LEFT JOIN public.advancedgenealogy_batch batch ON ((batch.id = orderedproduct.batch_id)));


--
-- Name: deliveries_orderedproductlistdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_orderedproductlistdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_parameterdeliveryordercolumn; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.deliveries_parameterdeliveryordercolumn (
    id bigint NOT NULL,
    parameter_id bigint,
    columnfororders_id bigint,
    succession integer,
    entityversion bigint DEFAULT 0
);


--
-- Name: deliveries_parameterdeliveryordercolumn_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.deliveries_parameterdeliveryordercolumn_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: deliveries_parameterdeliveryordercolumn_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.deliveries_parameterdeliveryordercolumn_id_seq OWNED BY public.deliveries_parameterdeliveryordercolumn.id;


--
-- Name: emailnotifications_staffnotification; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.emailnotifications_staffnotification (
    id bigint NOT NULL,
    email character varying(255),
    staff_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    parameter_id bigint,
    createdeliveryminstate boolean,
    entityversion bigint DEFAULT 0,
    pmmnotification boolean DEFAULT false
);


--
-- Name: emailnotifications_staffnotification_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.emailnotifications_staffnotification_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: emailnotifications_staffnotification_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.emailnotifications_staffnotification_id_seq OWNED BY public.emailnotifications_staffnotification.id;


--
-- Name: goodfood_confectionadditionalinputproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_confectionadditionalinputproduct (
    id bigint NOT NULL,
    confectionprotocol_id bigint,
    batch_id bigint,
    product_id bigint,
    takenonquantity numeric(12,5),
    takenofquantity numeric(12,5),
    cullquantity numeric(12,5),
    effectivequantity numeric(12,5),
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_confectionadditionalinputproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_confectionadditionalinputproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_confectionadditionalinputproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_confectionadditionalinputproduct_id_seq OWNED BY public.goodfood_confectionadditionalinputproduct.id;


--
-- Name: goodfood_confectioncontext; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_confectioncontext (
    id bigint NOT NULL,
    day date,
    generated boolean DEFAULT false,
    confirmed boolean DEFAULT false,
    place character varying(255),
    productionline_id bigint,
    shift_id bigint,
    operator_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_confectioncontext_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_confectioncontext_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_confectioncontext_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_confectioncontext_id_seq OWNED BY public.goodfood_confectioncontext.id;


--
-- Name: goodfood_confectionfilmproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_confectionfilmproduct (
    id bigint NOT NULL,
    confectionprotocol_id bigint,
    filmproduct_id bigint,
    beyondrecipe boolean DEFAULT false
);


--
-- Name: goodfood_confectionfilmproductentry; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_confectionfilmproductentry (
    id bigint NOT NULL,
    batch_id bigint,
    confectionfilmproduct_id bigint,
    takenonquantity numeric(12,5),
    takenofquantity numeric(12,5),
    cullquantity numeric(12,5),
    effectivequantity numeric(12,5)
);


--
-- Name: goodfood_confectioninputproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_confectioninputproduct (
    id bigint NOT NULL,
    confectionprotocol_id bigint,
    batch_id bigint,
    product_id bigint,
    takenonquantity numeric(12,5),
    takenofquantity numeric(12,5),
    cullquantity numeric(12,5),
    effectivequantity numeric(12,5),
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_confectionprotocol; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_confectionprotocol (
    id bigint NOT NULL,
    generationdate date,
    state character varying(255) DEFAULT '01draft'::character varying,
    laststatechangefails boolean DEFAULT false,
    confectioncontext_id bigint,
    number character varying(1024),
    dayofshiftstart date,
    productionline_id bigint,
    toproduce numeric(12,5),
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    order_id bigint,
    ordernumber character varying(255),
    productnameandnumber character varying(255),
    qcp5code character varying(255),
    filmproduct_id bigint,
    restoneofcartonsquantity numeric(12,5),
    resttwoofcartonsquantity numeric(12,5),
    allpalletquantity numeric(12,5),
    quantityofallcartonsquantity numeric(12,5),
    wastewafers numeric(12,5),
    effectiveproducedquantity numeric(12,5),
    effectiveexecutiontimestart timestamp without time zone,
    effectiveexecutiontimeend timestamp without time zone,
    externalnumber integer NOT NULL,
    externalsynchronized boolean DEFAULT true,
    active boolean DEFAULT true,
    laststatechangefailcause character varying(8192),
    showlaststatechangeresult boolean DEFAULT false,
    isdoubled boolean DEFAULT false,
    additionalfilmproduct_id bigint,
    iscorrected boolean DEFAULT false,
    productiondate date,
    entityversion bigint DEFAULT 0,
    comments text,
    sendagaintoblackbox boolean DEFAULT false,
    finalprotocol boolean,
    plannextorderinfo character varying(8192),
    plannextorderinfoargs character varying(8192),
    plannextorderstatechangeinfo character varying
);


--
-- Name: goodfood_confectionfilmprepare; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.goodfood_confectionfilmprepare AS
 SELECT confectionprotocol.number AS protocolnumber,
    confectionprotocol.dayofshiftstart,
    confectionprotocol.state AS confectionprotocolstate,
    ordersorder.number AS ordernumber,
    productionline.number AS productionlinenumber,
    product.number AS productnumber,
    confectionfilmproductentry.cullquantity
   FROM (((((public.goodfood_confectionprotocol confectionprotocol
     JOIN public.productionlines_productionline productionline ON ((productionline.id = confectionprotocol.productionline_id)))
     JOIN public.orders_order ordersorder ON ((ordersorder.id = confectionprotocol.order_id)))
     JOIN public.goodfood_confectionfilmproduct confectionfilmproduct ON ((confectionfilmproduct.confectionprotocol_id = confectionprotocol.id)))
     LEFT JOIN public.goodfood_confectionfilmproductentry confectionfilmproductentry ON ((confectionfilmproduct.id = confectionfilmproductentry.confectionfilmproduct_id)))
     JOIN public.basic_product product ON ((product.id = confectionfilmproduct.filmproduct_id)))
UNION
 SELECT confectionprotocol.number AS protocolnumber,
    confectionprotocol.dayofshiftstart,
    confectionprotocol.state AS confectionprotocolstate,
    ordersorder.number AS ordernumber,
    productionline.number AS productionlinenumber,
    product.number AS productnumber,
    confectioninputproduct.cullquantity
   FROM ((((public.goodfood_confectionprotocol confectionprotocol
     JOIN public.productionlines_productionline productionline ON ((productionline.id = confectionprotocol.productionline_id)))
     JOIN public.orders_order ordersorder ON ((ordersorder.id = confectionprotocol.order_id)))
     JOIN public.goodfood_confectioninputproduct confectioninputproduct ON ((confectioninputproduct.confectionprotocol_id = confectionprotocol.id)))
     JOIN public.basic_product product ON ((product.id = confectioninputproduct.product_id)))
UNION
 SELECT confectionprotocol.number AS protocolnumber,
    confectionprotocol.dayofshiftstart,
    confectionprotocol.state AS confectionprotocolstate,
    ordersorder.number AS ordernumber,
    productionline.number AS productionlinenumber,
    product.number AS productnumber,
    confectioninputproduct.cullquantity
   FROM ((((public.goodfood_confectionprotocol confectionprotocol
     JOIN public.productionlines_productionline productionline ON ((productionline.id = confectionprotocol.productionline_id)))
     JOIN public.orders_order ordersorder ON ((ordersorder.id = confectionprotocol.order_id)))
     JOIN public.goodfood_confectionadditionalinputproduct confectioninputproduct ON ((confectioninputproduct.confectionprotocol_id = confectionprotocol.id)))
     JOIN public.basic_product product ON ((product.id = confectioninputproduct.product_id)));


--
-- Name: goodfood_confectionfilm; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.goodfood_confectionfilm AS
 SELECT row_number() OVER () AS id,
    cf.protocolnumber,
    cf.dayofshiftstart,
    cf.confectionprotocolstate,
    cf.ordernumber,
    cf.productionlinenumber,
    cf.productnumber,
    cf.cullquantity
   FROM public.goodfood_confectionfilmprepare cf;


--
-- Name: goodfood_confectionfilm_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_confectionfilm_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_confectionfilmproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_confectionfilmproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_confectionfilmproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_confectionfilmproduct_id_seq OWNED BY public.goodfood_confectionfilmproduct.id;


--
-- Name: goodfood_confectionfilmproductentry_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_confectionfilmproductentry_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_confectionfilmproductentry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_confectionfilmproductentry_id_seq OWNED BY public.goodfood_confectionfilmproductentry.id;


--
-- Name: goodfood_confectioninputproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_confectioninputproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_confectioninputproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_confectioninputproduct_id_seq OWNED BY public.goodfood_confectioninputproduct.id;


--
-- Name: goodfood_confectionprotocol_externalnumber_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_confectionprotocol_externalnumber_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_confectionprotocol_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_confectionprotocol_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_confectionprotocol_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_confectionprotocol_id_seq OWNED BY public.goodfood_confectionprotocol.id;


--
-- Name: goodfood_confectionprotocolcorrect; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_confectionprotocolcorrect (
    id bigint NOT NULL,
    confectionprotocol_id bigint,
    correctdate date,
    correctreason character varying(2048),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    isconfirmed boolean DEFAULT false,
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_confectionprotocolcorrect_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_confectionprotocolcorrect_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_confectionprotocolcorrect_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_confectionprotocolcorrect_id_seq OWNED BY public.goodfood_confectionprotocolcorrect.id;


--
-- Name: goodfood_confectionprotocoldto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.goodfood_confectionprotocoldto AS
 SELECT cp.id,
    cp.active,
    cp.number,
    cp.dayofshiftstart,
    shift.name AS confectioncontextshift,
    confectioncontext.place AS confectioncontextplace,
    productionline.number AS productionlinenumber,
    productionline.name AS productionlinename,
    o.number AS ordernumber,
    cp.qcp5code,
    staff.name AS confectioncontextoperatorname,
    staff.surname AS confectioncontextoperatorsurname,
    cp.state,
    cp.iscorrected,
    cp.generationdate
   FROM (((((public.goodfood_confectionprotocol cp
     JOIN public.productionlines_productionline productionline ON ((cp.productionline_id = productionline.id)))
     JOIN public.orders_order o ON ((cp.order_id = o.id)))
     LEFT JOIN public.goodfood_confectioncontext confectioncontext ON ((cp.confectioncontext_id = confectioncontext.id)))
     LEFT JOIN public.basic_shift shift ON ((confectioncontext.shift_id = shift.id)))
     LEFT JOIN public.basic_staff staff ON ((confectioncontext.operator_id = staff.id)));


--
-- Name: goodfood_confectionprotocoldto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_confectionprotocoldto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_confectionprotocolstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_confectionprotocolstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    shift_id bigint,
    worker character varying(255),
    confectionprotocol_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_confectionprotocolstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_confectionprotocolstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_confectionprotocolstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_confectionprotocolstatechange_id_seq OWNED BY public.goodfood_confectionprotocolstatechange.id;


--
-- Name: goodfood_confectionremainderinputproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_confectionremainderinputproduct (
    id bigint NOT NULL,
    confectionprotocol_id bigint,
    product_id bigint,
    usedquantity numeric(12,5),
    isdoubled boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    usedbatches text,
    beyondrecipe boolean DEFAULT false
);


--
-- Name: goodfood_confectionremainderinputproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_confectionremainderinputproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_confectionremainderinputproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_confectionremainderinputproduct_id_seq OWNED BY public.goodfood_confectionremainderinputproduct.id;


--
-- Name: goodfood_confectionstaff; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_confectionstaff (
    id bigint NOT NULL,
    confectionprotocol_id bigint,
    worker_id bigint,
    labortime integer,
    effectiveexecutiontimestart timestamp without time zone,
    effectiveexecutiontimeend timestamp without time zone,
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_confectionstaff_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_confectionstaff_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_confectionstaff_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_confectionstaff_id_seq OWNED BY public.goodfood_confectionstaff.id;


--
-- Name: goodfood_eventlog; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_eventlog (
    id bigint NOT NULL,
    eventtype character varying(255) DEFAULT '01other'::character varying,
    description character varying(2048),
    user_id bigint,
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    product_id bigint,
    ssccnumber character varying(20),
    quantity numeric(12,5),
    sourcelocation character varying(16),
    destinationlocation character varying(16),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_eventlog_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_eventlog_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_eventlog_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_eventlog_id_seq OWNED BY public.goodfood_eventlog.id;


--
-- Name: goodfood_extrusionaddedmixentry; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_extrusionaddedmixentry (
    id bigint NOT NULL,
    extrusionprotocol_id bigint,
    quantity numeric(9,2),
    entityversion bigint DEFAULT 0,
    extrusionmix_id bigint
);


--
-- Name: goodfood_extrusionaddedmixentry_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionaddedmixentry_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusionaddedmixentry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_extrusionaddedmixentry_id_seq OWNED BY public.goodfood_extrusionaddedmixentry.id;


--
-- Name: goodfood_extrusionaddedmixingredient; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_extrusionaddedmixingredient (
    id bigint NOT NULL,
    extrusionaddedmixentry_id bigint,
    extrusionmixingredient_id bigint,
    product_id bigint,
    batch_id bigint,
    quantity numeric(9,2),
    beyondrecipe boolean DEFAULT false
);


--
-- Name: goodfood_extrusionaddedmixingredient_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionaddedmixingredient_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusionaddedmixingredient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_extrusionaddedmixingredient_id_seq OWNED BY public.goodfood_extrusionaddedmixingredient.id;


--
-- Name: goodfood_extrusionbatchingredientdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.goodfood_extrusionbatchingredientdto AS
SELECT
    NULL::bigint AS id,
    NULL::bigint AS extrusionprotocol_id,
    NULL::character varying(255) AS productnumber,
    NULL::character varying(255) AS unit,
    NULL::character varying(255) AS batchnumber,
    NULL::numeric AS quantity;


--
-- Name: goodfood_extrusionbatchingredientdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionbatchingredientdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusioncontext; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_extrusioncontext (
    id bigint NOT NULL,
    day date,
    generated boolean DEFAULT false,
    confirmed boolean DEFAULT false,
    place character varying(255),
    productionline_id bigint,
    shift_id bigint,
    operator_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_extrusioncontext_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusioncontext_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusioncontext_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_extrusioncontext_id_seq OWNED BY public.goodfood_extrusioncontext.id;


--
-- Name: goodfood_extrusionmix; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_extrusionmix (
    id bigint NOT NULL,
    number character varying(1024),
    technology_id bigint,
    product_id bigint,
    productionline_id bigint,
    takenoffdate timestamp without time zone,
    shift_id bigint,
    quantity numeric(9,2),
    operator_id bigint,
    comment text,
    active boolean DEFAULT true
);


--
-- Name: goodfood_extrusionmix_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionmix_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusionmix_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_extrusionmix_id_seq OWNED BY public.goodfood_extrusionmix.id;


--
-- Name: goodfood_extrusionmix_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionmix_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusionmixingredient; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_extrusionmixingredient (
    id bigint NOT NULL,
    extrusionmix_id bigint,
    product_id bigint,
    batch_id bigint,
    quantity numeric(9,2),
    beyondrecipe boolean DEFAULT false
);


--
-- Name: goodfood_extrusionmixingredient_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionmixingredient_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusionmixingredient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_extrusionmixingredient_id_seq OWNED BY public.goodfood_extrusionmixingredient.id;


--
-- Name: goodfood_extrusionpouring; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_extrusionpouring (
    id bigint NOT NULL,
    extrusionprotocol_id bigint,
    finaladdedquantity numeric(9,2),
    addedquantity numeric(9,2),
    totalmixquantity numeric(12,5),
    addedquantitymanual boolean DEFAULT false,
    addedquantityrelatesto character varying(255) DEFAULT '01mix'::character varying,
    mixwaterquantity numeric(12,5),
    priority integer
);


--
-- Name: goodfood_extrusionpouring_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionpouring_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusionpouring_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_extrusionpouring_id_seq OWNED BY public.goodfood_extrusionpouring.id;


--
-- Name: goodfood_extrusionpouringdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.goodfood_extrusionpouringdto AS
 SELECT pouring.id,
    pouring.addedquantity,
    pouring.finaladdedquantity,
    pouring.addedquantitymanual,
    pouring.addedquantityrelatesto,
    pouring.extrusionprotocol_id,
    (pouring.extrusionprotocol_id)::integer AS extrusionprotocolid,
    pouring.priority
   FROM public.goodfood_extrusionpouring pouring;


--
-- Name: goodfood_extrusionpouringdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionpouringdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusionpouringingredient; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_extrusionpouringingredient (
    id bigint NOT NULL,
    extrusionpouring_id bigint,
    product_id bigint,
    batch_id bigint,
    quantity numeric(9,2),
    ratio numeric(12,5),
    manual boolean DEFAULT false,
    skip boolean DEFAULT false,
    frommix boolean DEFAULT false,
    requiredquantity numeric(9,2),
    quantityinmix numeric(12,5),
    beyondrecipe boolean DEFAULT false,
    addedbyuser boolean DEFAULT false,
    extrusionpouringmix_id bigint
);


--
-- Name: goodfood_extrusionpouringingredient_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionpouringingredient_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusionpouringingredient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_extrusionpouringingredient_id_seq OWNED BY public.goodfood_extrusionpouringingredient.id;


--
-- Name: goodfood_extrusionpouringmix; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_extrusionpouringmix (
    id bigint NOT NULL,
    extrusionpouring_id bigint,
    mixid character varying(255),
    requiredscalequantity numeric(9,2),
    scalequantity numeric(9,2),
    scalequantitymanual boolean DEFAULT false,
    totalmixquantity numeric(12,5),
    mixwaterquantity numeric(12,5)
);


--
-- Name: goodfood_extrusionpouringmix_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionpouringmix_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusionpouringmix_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_extrusionpouringmix_id_seq OWNED BY public.goodfood_extrusionpouringmix.id;


--
-- Name: goodfood_extrusionprotocol; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_extrusionprotocol (
    id bigint NOT NULL,
    generationdate date,
    state character varying(255) DEFAULT '01draft'::character varying,
    laststatechangefails boolean DEFAULT false,
    extrusioncontext_id bigint,
    number character varying(1024),
    dayofshiftstart date,
    productionline_id bigint,
    toproduce numeric(12,5),
    changeover integer,
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    numberofavailableworkstation integer,
    order_id bigint,
    ordernumber character varying(255),
    productnameandnumber character varying(255),
    mixproduct character varying(255),
    operatorworkstartdate timestamp without time zone,
    operatorworkfinishdate timestamp without time zone,
    externalnumber integer NOT NULL,
    externalsynchronized boolean DEFAULT true,
    active boolean DEFAULT true,
    laststatechangefailcause character varying(8192),
    showlaststatechangeresult boolean DEFAULT false,
    iscorrected boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    comments text,
    sendagaintoblackbox boolean DEFAULT false
);


--
-- Name: goodfood_extrusionprotocol_externalnumber_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionprotocol_externalnumber_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusionprotocol_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionprotocol_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusionprotocol_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_extrusionprotocol_id_seq OWNED BY public.goodfood_extrusionprotocol.id;


--
-- Name: goodfood_extrusionprotocolcorrect; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_extrusionprotocolcorrect (
    id bigint NOT NULL,
    extrusionprotocol_id bigint,
    correctdate date,
    correctreason character varying(2048),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    isconfirmed boolean DEFAULT false,
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_extrusionprotocolcorrect_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionprotocolcorrect_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusionprotocolcorrect_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_extrusionprotocolcorrect_id_seq OWNED BY public.goodfood_extrusionprotocolcorrect.id;


--
-- Name: goodfood_extrusionprotocoldto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.goodfood_extrusionprotocoldto AS
 SELECT ep.id,
    ep.active,
    ep.number,
    ep.dayofshiftstart,
    shift.name AS extrusioncontextshift,
    extrusioncontext.place AS extrusioncontextplace,
    productionline.number AS productionlinenumber,
    productionline.name AS productionlinename,
    o.number AS ordernumber,
    staff.name AS extrusioncontextoperatorname,
    staff.surname AS extrusioncontextoperatorsurname,
    ep.state,
    ep.iscorrected,
    ep.generationdate
   FROM (((((public.goodfood_extrusionprotocol ep
     JOIN public.productionlines_productionline productionline ON ((ep.productionline_id = productionline.id)))
     JOIN public.orders_order o ON ((ep.order_id = o.id)))
     LEFT JOIN public.goodfood_extrusioncontext extrusioncontext ON ((ep.extrusioncontext_id = extrusioncontext.id)))
     LEFT JOIN public.basic_shift shift ON ((extrusioncontext.shift_id = shift.id)))
     LEFT JOIN public.basic_staff staff ON ((extrusioncontext.operator_id = staff.id)));


--
-- Name: goodfood_extrusionprotocoldto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionprotocoldto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusionprotocolstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_extrusionprotocolstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    shift_id bigint,
    worker character varying(255),
    extrusionprotocol_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_extrusionprotocolstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionprotocolstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusionprotocolstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_extrusionprotocolstatechange_id_seq OWNED BY public.goodfood_extrusionprotocolstatechange.id;


--
-- Name: goodfood_extrusionsouse; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_extrusionsouse (
    id bigint NOT NULL,
    extrusionprotocol_id bigint,
    category character varying(255),
    datesouse timestamp without time zone,
    datedownload timestamp without time zone,
    worker_id bigint,
    wetness numeric(5,2),
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_extrusionsouse_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionsouse_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusionsouse_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_extrusionsouse_id_seq OWNED BY public.goodfood_extrusionsouse.id;


--
-- Name: goodfood_extrusiontakenoffmixentry; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_extrusiontakenoffmixentry (
    id bigint NOT NULL,
    extrusionprotocol_id bigint,
    quantity numeric(9,2),
    entityversion bigint DEFAULT 0,
    extrusionmix_id bigint
);


--
-- Name: goodfood_extrusiontakenoffmixentry_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusiontakenoffmixentry_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusiontakenoffmixentry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_extrusiontakenoffmixentry_id_seq OWNED BY public.goodfood_extrusiontakenoffmixentry.id;


--
-- Name: goodfood_extrusiontakenoffmixingredient; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_extrusiontakenoffmixingredient (
    id bigint NOT NULL,
    extrusiontakenoffmixentry_id bigint,
    extrusionmixingredient_id bigint,
    product_id bigint,
    batch_id bigint,
    quantity numeric(9,2),
    beyondrecipe boolean DEFAULT false
);


--
-- Name: goodfood_extrusiontakenoffmixingredient_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusiontakenoffmixingredient_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_extrusiontakenoffmixingredient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_extrusiontakenoffmixingredient_id_seq OWNED BY public.goodfood_extrusiontakenoffmixingredient.id;


--
-- Name: goodfood_extrusionusedbatchingredientdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.goodfood_extrusionusedbatchingredientdto AS
SELECT
    NULL::bigint AS id,
    NULL::bigint AS extrusionprotocol_id,
    NULL::character varying(255) AS productnumber,
    NULL::character varying(255) AS unit,
    NULL::character varying(255) AS batchnumber,
    NULL::integer AS priority,
    NULL::numeric AS quantity;


--
-- Name: goodfood_extrusionusedbatchingredientdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_extrusionusedbatchingredientdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_goodfoodreport; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_goodfoodreport (
    id bigint NOT NULL,
    number character varying(1024),
    name character varying(1024),
    datefrom date,
    dateto date,
    filename character varying(255),
    generated boolean DEFAULT false,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_goodfoodreport_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_goodfoodreport_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_goodfoodreport_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_goodfoodreport_id_seq OWNED BY public.goodfood_goodfoodreport.id;


--
-- Name: goodfood_labeldto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_labeldto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_pallet; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_pallet (
    id bigint NOT NULL,
    palletcontext_id bigint,
    palletlabel_id bigint,
    typeoflogistics character varying(255) DEFAULT '01fullPallet'::character varying,
    printedcount integer,
    ssccnumber character varying(20),
    palletnumber character varying(6),
    secondpallet_id bigint,
    state character varying(255),
    isstateerror boolean,
    stateerror character varying(255),
    registrationdate timestamp without time zone,
    senddate timestamp without time zone,
    active boolean DEFAULT true,
    packagescount integer,
    laststatechangefails boolean DEFAULT false,
    laststatechangefailcause character varying(2048),
    externalnumber integer NOT NULL,
    externalsynchronized boolean DEFAULT true,
    eurocod character varying(7),
    entityversion bigint DEFAULT 0,
    sendagaintoblackbox boolean DEFAULT false,
    product_id bigint
);


--
-- Name: goodfood_pallet_externalnumber_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_pallet_externalnumber_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_pallet_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_pallet_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_pallet_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_pallet_id_seq OWNED BY public.goodfood_pallet.id;


--
-- Name: goodfood_palletcontext; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_palletcontext (
    id bigint NOT NULL,
    confirmed boolean DEFAULT false,
    day date,
    shift_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    operator_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_palletlabel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_palletlabel (
    id bigint NOT NULL,
    palletcontext_id bigint,
    printedcount integer,
    firstssccnumber character varying(20),
    firstpalletnumber character varying(6),
    lastssccnumber character varying(20),
    lastpalletnumber character varying(6),
    masterorder_id bigint,
    productionline_id bigint,
    batchnumber character varying(255),
    bestbefore character varying(255),
    registrationdate date,
    active boolean DEFAULT true,
    batch_id bigint,
    state character varying(255) DEFAULT '01draft'::character varying,
    entityversion bigint DEFAULT 0
);


--
-- Name: masterorders_masterorder; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_masterorder (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    description character varying(2048),
    externalnumber character varying(255),
    deadline timestamp without time zone,
    addmasterprefixtonumber boolean,
    masterorderstate character varying(255),
    company_id bigint,
    externalsynchronized boolean DEFAULT true,
    generationdateoneec date,
    cancelsynchronizationreason character varying(255),
    active boolean DEFAULT true,
    pw2prod boolean DEFAULT false,
    batch_id bigint,
    masterorderdefinition_id bigint,
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    entityversion bigint DEFAULT 0,
    sendagaintoblackbox boolean DEFAULT false,
    dateofreceipt timestamp without time zone,
    address_id bigint,
    externalproductionorderid character varying(255),
    ponumber character varying(255),
    direction character varying(255),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying,
    updateuser character varying,
    deliverynotenumber character varying,
    cancelsynchronizationtype character varying,
    companypayer_id bigint,
    productioncode character varying,
    commissionnumber character varying,
    machinetype character varying,
    pipedriveupdate timestamp without time zone,
    state character varying(255) DEFAULT '01new'::character varying,
    asanataskid character varying,
    asanatasknameupdated boolean DEFAULT false,
    asanataskcommentadded boolean DEFAULT false,
    sendagaintoasana boolean DEFAULT false,
    sendagaintoasanatries integer DEFAULT 0,
    asanastatecompleteddate timestamp without time zone,
    colourral character varying(255),
    salesplan_id bigint,
    materialsissued boolean DEFAULT false,
    warehouseorder boolean DEFAULT false,
    synchronize boolean DEFAULT false,
    synchronizationdate timestamp without time zone
);


--
-- Name: masterorders_masterorderproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_masterorderproduct (
    id bigint NOT NULL,
    product_id bigint,
    technology_id bigint,
    masterorder_id bigint,
    masterorderquantity numeric(14,5),
    cumulatedorderquantity numeric(14,5),
    producedorderquantity numeric(14,5),
    entityversion bigint DEFAULT 0,
    lefttorelease numeric(14,5),
    comments text,
    masterorderpositionstatus character varying(255),
    quantitytakenfromwarehouse numeric(14,5),
    quantityremainingtoorder numeric(14,5),
    deliverydate timestamp without time zone,
    line character varying(255),
    vendorinfo character varying(255),
    vendorso character varying(255),
    price numeric(14,5),
    priceslistprice numeric(9,2)
);


--
-- Name: qcadoomodel_unitconversionitem; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadoomodel_unitconversionitem (
    id bigint NOT NULL,
    quantityfrom numeric(12,5),
    quantityto numeric(12,5),
    unitfrom character varying(255),
    unitto character varying(255),
    globalunitconversionsaggregate_id bigint,
    product_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_palletactivedto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.goodfood_palletactivedto AS
 WITH orders_orderproduct AS (
         SELECT orders_order.masterorder_id,
            sum(orders_order.plannedquantity) AS orderquantity
           FROM public.orders_order
          WHERE (orders_order.masterorder_id IS NOT NULL)
          GROUP BY orders_order.masterorder_id
        )
 SELECT pallet.id,
    pallet.registrationdate,
    pallet.senddate,
    palletcontext.day AS palletcontextday,
    shift.name AS palletcontextshiftname,
    staff.name AS palletcontextoperatorname,
    staff.surname AS palletcontextoperatorsurname,
    productionline.number AS productionlinenumber,
    masterorder.number AS masterordernumber,
    product.number AS productnumber,
    pallet.ssccnumber,
    pallet.palletnumber,
    secondpallet.palletnumber AS secondpalletnumber,
        CASE
            WHEN (orderproduct.masterorder_id IS NULL) THEN ((row_number() OVER (PARTITION BY masterorder.id ORDER BY pallet.id) || ' z '::text) || (ceiling((masterorderproduct.masterorderquantity / unitconversionitem.quantityfrom)))::integer)
            ELSE ((row_number() OVER (PARTITION BY masterorder.id ORDER BY pallet.id) || ' z '::text) || (ceiling((orderproduct.orderquantity / unitconversionitem.quantityfrom)))::integer)
        END AS numberofpallets,
    pallet.state,
    pallet.laststatechangefails
   FROM (((((((((((public.goodfood_pallet pallet
     LEFT JOIN public.goodfood_pallet secondpallet ON ((secondpallet.id = pallet.secondpallet_id)))
     LEFT JOIN public.goodfood_palletcontext palletcontext ON ((palletcontext.id = pallet.palletcontext_id)))
     LEFT JOIN public.goodfood_palletlabel palletlabel ON ((palletlabel.id = pallet.palletlabel_id)))
     LEFT JOIN public.basic_shift shift ON ((shift.id = palletcontext.shift_id)))
     LEFT JOIN public.basic_staff staff ON ((staff.id = palletcontext.operator_id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((productionline.id = palletlabel.productionline_id)))
     LEFT JOIN public.masterorders_masterorder masterorder ON ((masterorder.id = palletlabel.masterorder_id)))
     LEFT JOIN public.masterorders_masterorderproduct masterorderproduct ON ((masterorderproduct.masterorder_id = masterorder.id)))
     LEFT JOIN orders_orderproduct orderproduct ON ((orderproduct.masterorder_id = masterorder.id)))
     LEFT JOIN public.basic_product product ON ((product.id = masterorderproduct.product_id)))
     LEFT JOIN public.qcadoomodel_unitconversionitem unitconversionitem ON (((unitconversionitem.product_id = product.id) AND ((unitconversionitem.unitfrom)::text = 'szt.'::text) AND ((unitconversionitem.unitto)::text = 'paleta'::text))))
  WHERE (pallet.active = true);


--
-- Name: goodfood_palletactivedto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_palletactivedto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_palletcontext_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_palletcontext_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_palletcontext_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_palletcontext_id_seq OWNED BY public.goodfood_palletcontext.id;


--
-- Name: goodfood_palletdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.goodfood_palletdto AS
 WITH orders_orderproduct AS (
         SELECT orders_order.masterorder_id,
            sum(orders_order.plannedquantity) AS orderquantity
           FROM public.orders_order
          WHERE (orders_order.masterorder_id IS NOT NULL)
          GROUP BY orders_order.masterorder_id
        )
 SELECT pallet.id,
    pallet.registrationdate,
    pallet.senddate,
    palletcontext.day AS palletcontextday,
    shift.name AS palletcontextshiftname,
    staff.name AS palletcontextoperatorname,
    staff.surname AS palletcontextoperatorsurname,
    productionline.number AS productionlinenumber,
    masterorder.number AS masterordernumber,
    product.number AS productnumber,
    pallet.ssccnumber,
    pallet.palletnumber,
    secondpallet.palletnumber AS secondpalletnumber,
        CASE
            WHEN (orderproduct.masterorder_id IS NULL) THEN ((row_number() OVER (PARTITION BY masterorder.id ORDER BY pallet.id) || ' z '::text) || (ceiling((masterorderproduct.masterorderquantity / unitconversionitem.quantityfrom)))::integer)
            ELSE ((row_number() OVER (PARTITION BY masterorder.id ORDER BY pallet.id) || ' z '::text) || (ceiling((orderproduct.orderquantity / unitconversionitem.quantityfrom)))::integer)
        END AS numberofpallets,
    pallet.state,
    pallet.laststatechangefails,
    pallet.active
   FROM (((((((((((public.goodfood_pallet pallet
     LEFT JOIN public.goodfood_pallet secondpallet ON ((secondpallet.id = pallet.secondpallet_id)))
     LEFT JOIN public.goodfood_palletcontext palletcontext ON ((palletcontext.id = pallet.palletcontext_id)))
     LEFT JOIN public.goodfood_palletlabel palletlabel ON ((palletlabel.id = pallet.palletlabel_id)))
     LEFT JOIN public.basic_shift shift ON ((shift.id = palletcontext.shift_id)))
     LEFT JOIN public.basic_staff staff ON ((staff.id = palletcontext.operator_id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((productionline.id = palletlabel.productionline_id)))
     LEFT JOIN public.masterorders_masterorder masterorder ON ((masterorder.id = palletlabel.masterorder_id)))
     LEFT JOIN public.masterorders_masterorderproduct masterorderproduct ON ((masterorderproduct.masterorder_id = masterorder.id)))
     LEFT JOIN orders_orderproduct orderproduct ON ((orderproduct.masterorder_id = masterorder.id)))
     LEFT JOIN public.basic_product product ON ((product.id = masterorderproduct.product_id)))
     LEFT JOIN public.qcadoomodel_unitconversionitem unitconversionitem ON (((unitconversionitem.product_id = product.id) AND ((unitconversionitem.unitfrom)::text = 'szt.'::text) AND ((unitconversionitem.unitto)::text = 'paleta'::text))));


--
-- Name: goodfood_palletdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_palletdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_palletlabel_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_palletlabel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_palletlabel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_palletlabel_id_seq OWNED BY public.goodfood_palletlabel.id;


--
-- Name: goodfood_palletlabelactivedto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.goodfood_palletlabelactivedto AS
 SELECT palletlabel.id,
    palletlabel.registrationdate,
    palletcontext.day AS palletcontextday,
    shift.name AS palletcontextshiftname,
    staff.name AS palletcontextoperatorname,
    staff.surname AS palletcontextoperatorsurname,
    productionline.number AS productionlinenumber,
    productionline.isblocked AS productionlineisblocked,
    masterorder.number AS masterordernumber,
    product.number AS productnumber,
    palletlabel.printedcount,
    palletlabel.firstssccnumber,
    palletlabel.lastssccnumber,
    palletlabel.state
   FROM (((((((public.goodfood_palletlabel palletlabel
     LEFT JOIN public.goodfood_palletcontext palletcontext ON ((palletcontext.id = palletlabel.palletcontext_id)))
     LEFT JOIN public.basic_shift shift ON ((shift.id = palletcontext.shift_id)))
     LEFT JOIN public.basic_staff staff ON ((staff.id = palletcontext.operator_id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((productionline.id = palletlabel.productionline_id)))
     LEFT JOIN public.masterorders_masterorder masterorder ON ((masterorder.id = palletlabel.masterorder_id)))
     LEFT JOIN public.masterorders_masterorderproduct masterorderproduct ON ((masterorderproduct.masterorder_id = masterorder.id)))
     LEFT JOIN public.basic_product product ON ((product.id = masterorderproduct.product_id)))
  WHERE (palletlabel.active = true);


--
-- Name: goodfood_palletlabelactivedto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_palletlabelactivedto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_palletlabeldto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.goodfood_palletlabeldto AS
 SELECT palletlabel.id,
    palletlabel.registrationdate,
    palletcontext.day AS palletcontextday,
    shift.name AS palletcontextshiftname,
    staff.name AS palletcontextoperatorname,
    staff.surname AS palletcontextoperatorsurname,
    productionline.number AS productionlinenumber,
    productionline.isblocked AS productionlineisblocked,
    masterorder.number AS masterordernumber,
    product.number AS productnumber,
    palletlabel.printedcount,
    palletlabel.firstssccnumber,
    palletlabel.lastssccnumber,
    palletlabel.state,
    palletlabel.active
   FROM (((((((public.goodfood_palletlabel palletlabel
     LEFT JOIN public.goodfood_palletcontext palletcontext ON ((palletcontext.id = palletlabel.palletcontext_id)))
     LEFT JOIN public.basic_shift shift ON ((shift.id = palletcontext.shift_id)))
     LEFT JOIN public.basic_staff staff ON ((staff.id = palletcontext.operator_id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((productionline.id = palletlabel.productionline_id)))
     LEFT JOIN public.masterorders_masterorder masterorder ON ((masterorder.id = palletlabel.masterorder_id)))
     LEFT JOIN public.masterorders_masterorderproduct masterorderproduct ON ((masterorderproduct.masterorder_id = masterorder.id)))
     LEFT JOIN public.basic_product product ON ((product.id = masterorderproduct.product_id)));


--
-- Name: goodfood_palletlabeldto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_palletlabeldto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_palletlabelstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_palletlabelstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    shift_id bigint,
    worker character varying(255),
    palletlabel_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_palletlabelstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_palletlabelstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_palletlabelstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_palletlabelstatechange_id_seq OWNED BY public.goodfood_palletlabelstatechange.id;


--
-- Name: goodfood_palletstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_palletstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    shift_id bigint,
    worker character varying(255),
    pallet_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_palletstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_palletstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_palletstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_palletstatechange_id_seq OWNED BY public.goodfood_palletstatechange.id;


--
-- Name: goodfood_palnumber; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_palnumber (
    id bigint NOT NULL,
    number character varying(255),
    masterorder_id bigint,
    ssccnumber character varying(20)
);


--
-- Name: goodfood_palnumber_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_palnumber_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_palnumber_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_palnumber_id_seq OWNED BY public.goodfood_palnumber.id;


--
-- Name: goodfood_printedlabel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_printedlabel (
    id bigint NOT NULL,
    cartonlabel character varying(255),
    masterorder_id bigint,
    ssccnumber character varying(1024),
    palletcontext_id bigint,
    productionline_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    active boolean DEFAULT true
);


--
-- Name: goodfood_printedlabel_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_printedlabel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_printedlabel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_printedlabel_id_seq OWNED BY public.goodfood_printedlabel.id;


--
-- Name: goodfood_printedlabeldto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.goodfood_printedlabeldto AS
 SELECT printedlabel.id,
    date(printedlabel.createdate) AS printdate,
    staff.name AS palletcontextoperatorname,
    staff.surname AS palletcontextoperatorsurname,
    productionline.number AS productionlinenumber,
    masterorder.number AS masterordernumber,
    product.number AS productnumber,
    printedlabel.ssccnumber,
    printedlabel.active
   FROM ((((((public.goodfood_printedlabel printedlabel
     JOIN public.goodfood_palletcontext palletcontext ON ((palletcontext.id = printedlabel.palletcontext_id)))
     JOIN public.basic_staff staff ON ((staff.id = palletcontext.operator_id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((productionline.id = printedlabel.productionline_id)))
     JOIN public.masterorders_masterorder masterorder ON ((masterorder.id = printedlabel.masterorder_id)))
     JOIN public.masterorders_masterorderproduct masterorderproduct ON ((masterorderproduct.masterorder_id = masterorder.id)))
     JOIN public.basic_product product ON ((product.id = masterorderproduct.product_id)));


--
-- Name: goodfood_printedlabeldto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_printedlabeldto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_ssccnumber; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.goodfood_ssccnumber (
    id bigint NOT NULL,
    prefix character varying(10),
    number integer,
    suffix integer,
    entityversion bigint DEFAULT 0
);


--
-- Name: goodfood_ssccnumber_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.goodfood_ssccnumber_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: goodfood_ssccnumber_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.goodfood_ssccnumber_id_seq OWNED BY public.goodfood_ssccnumber.id;


--
-- Name: hibernate_sequence; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.hibernate_sequence
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: integrationbartender_printer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.integrationbartender_printer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: integrationbartender_printer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.integrationbartender_printer (
    id bigint DEFAULT nextval('public.integrationbartender_printer_id_seq'::regclass) NOT NULL,
    name character varying(255),
    description character varying(2048),
    printertype character varying(255),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    active boolean DEFAULT true
);


--
-- Name: integrationbartender_printlabelshelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.integrationbartender_printlabelshelper (
    id bigint NOT NULL,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    quantity integer,
    masterorder_id bigint,
    printer_id bigint,
    path character varying(255),
    ssccnumbers text,
    order_id bigint,
    barcodeismasterorderid boolean DEFAULT false
);


--
-- Name: integrationbartender_sendtoprint; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.integrationbartender_sendtoprint (
    id bigint NOT NULL,
    printlabelshelper_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: jointable_order_printlabelshelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_order_printlabelshelper (
    printlabelshelper_id bigint NOT NULL,
    order_id bigint NOT NULL
);


--
-- Name: jointable_palletlabel_printlabelshelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_palletlabel_printlabelshelper (
    printlabelshelper_id bigint NOT NULL,
    palletlabel_id bigint NOT NULL
);


--
-- Name: jointable_printlabelshelper_printedlabel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_printlabelshelper_printedlabel (
    printedlabel_id bigint NOT NULL,
    printlabelshelper_id bigint NOT NULL
);


--
-- Name: integrationbartender_printedcartonlabeldto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.integrationbartender_printedcartonlabeldto AS
 SELECT printlabelshelper.id,
    sendtoprint.createdate,
    sendtoprint.createuser,
    (printlabelshelper.masterorder_id)::integer AS masterorder_id,
    masterorder.number AS masterordernumber,
    printlabelshelper.quantity,
    (printlabelshelper.printer_id)::integer AS printer_id,
    printer.name AS printername
   FROM ((((((public.integrationbartender_sendtoprint sendtoprint
     JOIN public.integrationbartender_printlabelshelper printlabelshelper ON ((printlabelshelper.id = sendtoprint.printlabelshelper_id)))
     JOIN public.masterorders_masterorder masterorder ON ((masterorder.id = printlabelshelper.masterorder_id)))
     JOIN public.integrationbartender_printer printer ON ((printer.id = printlabelshelper.printer_id)))
     LEFT JOIN public.jointable_palletlabel_printlabelshelper palletlabel_printlabelshelper ON ((palletlabel_printlabelshelper.printlabelshelper_id = printlabelshelper.id)))
     LEFT JOIN public.jointable_printlabelshelper_printedlabel printlabelshelper_printedlabel ON ((printlabelshelper_printedlabel.printlabelshelper_id = printlabelshelper.id)))
     LEFT JOIN public.jointable_order_printlabelshelper order_printlabelshelper ON ((order_printlabelshelper.printlabelshelper_id = printlabelshelper.id)))
  WHERE ((palletlabel_printlabelshelper.* IS NULL) AND (printlabelshelper_printedlabel.* IS NULL) AND (order_printlabelshelper.* IS NULL));


--
-- Name: integrationbartender_printedcartonlabeldto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.integrationbartender_printedcartonlabeldto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: integrationbartender_printedpalletlabeldto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.integrationbartender_printedpalletlabeldto AS
 SELECT row_number() OVER () AS id,
    sendtoprint.createdate,
    sendtoprint.createuser,
    ssccnumber.ssccnumber,
    (printlabelshelper.id)::integer AS printlabelshelper_id,
    (printlabelshelper.printer_id)::integer AS printer_id,
    printer.name AS printername
   FROM (((public.integrationbartender_sendtoprint sendtoprint
     JOIN public.integrationbartender_printlabelshelper printlabelshelper ON ((printlabelshelper.id = sendtoprint.printlabelshelper_id)))
     JOIN LATERAL unnest(string_to_array(printlabelshelper.ssccnumbers, ', '::text)) ssccnumber(ssccnumber) ON (true))
     JOIN public.integrationbartender_printer printer ON ((printer.id = printlabelshelper.printer_id)))
  WHERE (printlabelshelper.id IN ( SELECT jointable_palletlabel_printlabelshelper.printlabelshelper_id
           FROM public.jointable_palletlabel_printlabelshelper
        UNION
         SELECT jointable_printlabelshelper_printedlabel.printlabelshelper_id
           FROM public.jointable_printlabelshelper_printedlabel));


--
-- Name: integrationbartender_printedpalletlabeldto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.integrationbartender_printedpalletlabeldto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: integrationbartender_printlabelshelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.integrationbartender_printlabelshelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: integrationbartender_printlabelshelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.integrationbartender_printlabelshelper_id_seq OWNED BY public.integrationbartender_printlabelshelper.id;


--
-- Name: integrationbartender_sendtoprint_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.integrationbartender_sendtoprint_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: integrationbartender_sendtoprint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.integrationbartender_sendtoprint_id_seq OWNED BY public.integrationbartender_sendtoprint.id;


--
-- Name: integrationbaselinker_baselinkerparameters; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.integrationbaselinker_baselinkerparameters (
    id bigint NOT NULL,
    documenttype character varying(255) DEFAULT '01receipt'::character varying,
    locationfrom_id bigint,
    locationto_id bigint,
    createmasterorders boolean DEFAULT false,
    createdocuments boolean DEFAULT false
);


--
-- Name: integrationbaselinker_baselinkerparameters_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.integrationbaselinker_baselinkerparameters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: integrationbaselinker_baselinkerparameters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.integrationbaselinker_baselinkerparameters_id_seq OWNED BY public.integrationbaselinker_baselinkerparameters.id;


--
-- Name: integrationbaselinker_statusesfordocument; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.integrationbaselinker_statusesfordocument (
    id bigint NOT NULL,
    baselinkerparameters_id bigint,
    statustaken character varying(255),
    statusawarded character varying(255)
);


--
-- Name: integrationbaselinker_statusesfordocument_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.integrationbaselinker_statusesfordocument_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: integrationbaselinker_statusesfordocument_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.integrationbaselinker_statusesfordocument_id_seq OWNED BY public.integrationbaselinker_statusesfordocument.id;


--
-- Name: integrationbaselinker_statusesformasterorder; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.integrationbaselinker_statusesformasterorder (
    id bigint NOT NULL,
    baselinkerparameters_id bigint,
    statustaken character varying(255),
    statusawarded character varying(255)
);


--
-- Name: integrationbaselinker_statusesformasterorder_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.integrationbaselinker_statusesformasterorder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: integrationbaselinker_statusesformasterorder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.integrationbaselinker_statusesformasterorder_id_seq OWNED BY public.integrationbaselinker_statusesformasterorder.id;


--
-- Name: integrationscales_productionlineforscale; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.integrationscales_productionlineforscale (
    id bigint NOT NULL,
    productionline_id bigint,
    master boolean DEFAULT false,
    scale_id bigint
);


--
-- Name: integrationscales_productionlineforscale_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.integrationscales_productionlineforscale_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: integrationscales_productionlineforscale_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.integrationscales_productionlineforscale_id_seq OWNED BY public.integrationscales_productionlineforscale.id;


--
-- Name: integrationscales_scale; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.integrationscales_scale (
    id bigint NOT NULL,
    name character varying(255),
    comment character varying(255),
    port character varying(255),
    ip character varying(255),
    type character varying(255) DEFAULT '01siemens'::character varying
);


--
-- Name: integrationscales_scale_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.integrationscales_scale_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: integrationscales_scale_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.integrationscales_scale_id_seq OWNED BY public.integrationscales_scale.id;


--
-- Name: integrationscales_scaledto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.integrationscales_scaledto AS
SELECT
    NULL::bigint AS id,
    NULL::character varying(255) AS name,
    NULL::character varying(255) AS comment,
    NULL::character varying(255) AS type,
    NULL::text AS ip,
    NULL::text AS productionlines;


--
-- Name: integrationscales_scaledto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.integrationscales_scaledto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: jointable_action_subassembly; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_action_subassembly (
    action_id bigint NOT NULL,
    subassembly_id bigint NOT NULL
);


--
-- Name: jointable_action_workstation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_action_workstation (
    action_id bigint NOT NULL,
    workstation_id bigint NOT NULL
);


--
-- Name: jointable_action_workstationtype; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_action_workstationtype (
    action_id bigint NOT NULL,
    workstationtype_id bigint NOT NULL
);


--
-- Name: jointable_additionaldirectcost_technology; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_additionaldirectcost_technology (
    additionaldirectcost_id bigint NOT NULL,
    technology_id bigint NOT NULL
);


--
-- Name: jointable_anomaly_anomalyreason; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_anomaly_anomalyreason (
    anomalyreason_id bigint NOT NULL,
    anomaly_id bigint NOT NULL
);


--
-- Name: jointable_batch_productioncountingquantity; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_batch_productioncountingquantity (
    productioncountingquantity_id bigint NOT NULL,
    batch_id bigint NOT NULL
);


--
-- Name: jointable_company_negotiation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_company_negotiation (
    negotiation_id bigint NOT NULL,
    company_id bigint NOT NULL
);


--
-- Name: jointable_company_subassembly; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_company_subassembly (
    company_id bigint NOT NULL,
    subassembly_id bigint NOT NULL
);


--
-- Name: jointable_company_workstation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_company_workstation (
    company_id bigint NOT NULL,
    workstation_id bigint NOT NULL
);


--
-- Name: jointable_costcalculation_technology; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_costcalculation_technology (
    costcalculation_id bigint NOT NULL,
    technology_id bigint NOT NULL
);


--
-- Name: jointable_division_productionline; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_division_productionline (
    productionline_id bigint NOT NULL,
    division_id bigint NOT NULL
);


--
-- Name: jointable_faulttype_subassembly; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_faulttype_subassembly (
    faulttype_id bigint NOT NULL,
    subassembly_id bigint NOT NULL
);


--
-- Name: jointable_faulttype_workstation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_faulttype_workstation (
    workstation_id bigint NOT NULL,
    faulttype_id bigint NOT NULL
);


--
-- Name: jointable_faulttype_workstationtype; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_faulttype_workstationtype (
    workstationtype_id bigint NOT NULL,
    faulttype_id bigint NOT NULL
);


--
-- Name: jointable_group_role; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_group_role (
    group_id bigint NOT NULL,
    role_id bigint NOT NULL
);


--
-- Name: jointable_issue_productstoissuehelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_issue_productstoissuehelper (
    productstoissuehelper_id bigint NOT NULL,
    issue_id bigint NOT NULL
);


--
-- Name: jointable_masterorder_masterordersmaterialrequirement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_masterorder_masterordersmaterialrequirement (
    masterorder_id bigint NOT NULL,
    masterordersmaterialrequirement_id bigint NOT NULL
);


--
-- Name: jointable_materialrequirement_order; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_materialrequirement_order (
    materialrequirement_id bigint NOT NULL,
    order_id bigint NOT NULL
);


--
-- Name: jointable_materialrequirementcoverage_order; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_materialrequirementcoverage_order (
    materialrequirementcoverage_id bigint NOT NULL,
    order_id bigint NOT NULL
);


--
-- Name: jointable_multiassignmenttoshift_staff; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_multiassignmenttoshift_staff (
    multiassignmenttoshift_id bigint NOT NULL,
    staff_id bigint NOT NULL
);


--
-- Name: jointable_oee_productionline; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_oee_productionline (
    oee_id bigint NOT NULL,
    productionline_id bigint NOT NULL
);


--
-- Name: jointable_oee_workstation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_oee_workstation (
    oee_id bigint NOT NULL,
    workstation_id bigint NOT NULL
);


--
-- Name: jointable_operation_workstation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_operation_workstation (
    workstation_id bigint NOT NULL,
    operation_id bigint NOT NULL
);


--
-- Name: jointable_operationaltask_staff; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_operationaltask_staff (
    staff_id bigint NOT NULL,
    operationaltask_id bigint NOT NULL
);


--
-- Name: jointable_order_orderstoolrequirement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_order_orderstoolrequirement (
    order_id bigint NOT NULL,
    orderstoolrequirement_id bigint NOT NULL
);


--
-- Name: jointable_order_productionbalance; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_order_productionbalance (
    productionbalance_id bigint NOT NULL,
    order_id bigint NOT NULL
);


--
-- Name: jointable_order_productionlineschedule; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_order_productionlineschedule (
    order_id bigint NOT NULL,
    productionlineschedule_id bigint NOT NULL
);


--
-- Name: jointable_order_schedule; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_order_schedule (
    order_id bigint NOT NULL,
    schedule_id bigint NOT NULL
);


--
-- Name: jointable_order_staff; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_order_staff (
    order_id bigint NOT NULL,
    staff_id bigint NOT NULL
);


--
-- Name: jointable_order_workplan; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_order_workplan (
    workplan_id bigint NOT NULL,
    order_id bigint NOT NULL
);


--
-- Name: jointable_palletnumber_palletnumberhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_palletnumber_palletnumberhelper (
    palletnumberhelper_id bigint NOT NULL,
    palletnumber_id bigint NOT NULL
);


--
-- Name: jointable_parameter_productionline; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_parameter_productionline (
    parameter_id bigint NOT NULL,
    productionline_id bigint NOT NULL
);


--
-- Name: jointable_plannedevent_plannedevent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_plannedevent_plannedevent (
    plannedevent_id bigint NOT NULL,
    relatedevent_id bigint NOT NULL
);


--
-- Name: jointable_plannedevent_staff; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_plannedevent_staff (
    plannedevent_id bigint NOT NULL,
    staff_id bigint NOT NULL
);


--
-- Name: jointable_product_qualitycard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_product_qualitycard (
    product_id bigint NOT NULL,
    qualitycard_id bigint NOT NULL
);


--
-- Name: jointable_product_salesvolumemulti; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_product_salesvolumemulti (
    product_id bigint NOT NULL,
    salesvolumemulti_id bigint NOT NULL
);


--
-- Name: jointable_product_scale; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_product_scale (
    product_id bigint NOT NULL,
    scale_id bigint NOT NULL
);


--
-- Name: jointable_product_storagelocation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_product_storagelocation (
    product_id bigint NOT NULL,
    storagelocation_id bigint NOT NULL
);


--
-- Name: jointable_product_warehouseminimumstatemulti; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_product_warehouseminimumstatemulti (
    product_id bigint NOT NULL,
    warehouseminimumstatemulti_id bigint NOT NULL
);


--
-- Name: jointable_productionline_scale; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_productionline_scale (
    productionline_id bigint NOT NULL,
    scale_id bigint NOT NULL
);


--
-- Name: jointable_productionline_shift; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_productionline_shift (
    productionline_id bigint NOT NULL,
    shift_id bigint NOT NULL
);


--
-- Name: jointable_productionline_technology; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_productionline_technology (
    technology_id bigint NOT NULL,
    productionline_id bigint NOT NULL
);


--
-- Name: jointable_productionline_technologygroup; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_productionline_technologygroup (
    technologygroup_id bigint NOT NULL,
    productionline_id bigint NOT NULL
);


--
-- Name: jointable_size_sizegroup; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_size_sizegroup (
    size_id bigint NOT NULL,
    sizegroup_id bigint NOT NULL
);


--
-- Name: jointable_staff_timeusagereportfilter; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_staff_timeusagereportfilter (
    staff_id bigint NOT NULL,
    timeusagereportfilter_id bigint NOT NULL
);


--
-- Name: jointable_stocktaking_storagelocation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_stocktaking_storagelocation (
    stocktaking_id bigint NOT NULL,
    storagelocation_id bigint NOT NULL
);


--
-- Name: jointable_storagelocation_storagelocationnumberhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_storagelocation_storagelocationnumberhelper (
    storagelocation_id bigint NOT NULL,
    storagelocationnumberhelper_id bigint NOT NULL
);


--
-- Name: jointable_storagelocation_warehousestockreport; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_storagelocation_warehousestockreport (
    storagelocation_id bigint NOT NULL,
    warehousestockreport_id bigint NOT NULL
);


--
-- Name: jointable_technologyoperationcomponent_workstation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jointable_technologyoperationcomponent_workstation (
    technologyoperationcomponent_id bigint NOT NULL,
    workstation_id bigint NOT NULL
);


--
-- Name: linechangeovernorms_groupsview_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.linechangeovernorms_groupsview_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: linechangeovernorms_linechangeovernorms; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.linechangeovernorms_linechangeovernorms (
    id bigint NOT NULL,
    number character varying(255),
    changeovertype character varying(255) DEFAULT '01fromTechForSpecificLine'::character varying,
    fromtechnology_id bigint,
    totechnology_id bigint,
    fromtechnologygroup_id bigint,
    totechnologygroup_id bigint,
    productionline_id bigint,
    duration integer,
    name character varying(1024),
    entityversion bigint DEFAULT 0
);


--
-- Name: linechangeovernorms_linechangeovernorms_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.linechangeovernorms_linechangeovernorms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: linechangeovernorms_linechangeovernorms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.linechangeovernorms_linechangeovernorms_id_seq OWNED BY public.linechangeovernorms_linechangeovernorms.id;


--
-- Name: linechangeovernorms_linechangeovernormsdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.linechangeovernorms_linechangeovernormsdto AS
 SELECT linechangeovernorms.number,
    linechangeovernorms.name,
    linechangeovernorms.duration,
    linechangeovernorms.changeovertype,
    linechangeovernorms.productionline_id,
    linechangeovernorms.fromtechnology_id AS technologyfrom_id,
    linechangeovernorms.totechnology_id AS technologyto_id,
    technologyfrom.number AS technologyfromnumber,
    technologyto.number AS technologytonumber
   FROM ((public.linechangeovernorms_linechangeovernorms linechangeovernorms
     JOIN public.technologies_technology technologyfrom ON ((technologyfrom.id = linechangeovernorms.fromtechnology_id)))
     JOIN public.technologies_technology technologyto ON ((technologyto.id = linechangeovernorms.totechnology_id)))
  WHERE ((linechangeovernorms.changeovertype)::text = '01forTechnology'::text)
UNION ALL
 SELECT linechangeovernorms.number,
    linechangeovernorms.name,
    linechangeovernorms.duration,
    linechangeovernorms.changeovertype,
    linechangeovernorms.productionline_id,
    technologyfrom.id AS technologyfrom_id,
    technologyto.id AS technologyto_id,
    technologyfrom.number AS technologyfromnumber,
    technologyto.number AS technologytonumber
   FROM ((((public.linechangeovernorms_linechangeovernorms linechangeovernorms
     JOIN public.technologies_technologygroup technologygroupfrom ON ((technologygroupfrom.id = linechangeovernorms.fromtechnologygroup_id)))
     JOIN public.technologies_technology technologyfrom ON (((technologyfrom.technologygroup_id = technologygroupfrom.id) AND (technologyfrom.active = true))))
     JOIN public.technologies_technologygroup technologygroupto ON ((technologygroupto.id = linechangeovernorms.totechnologygroup_id)))
     JOIN public.technologies_technology technologyto ON (((technologyto.technologygroup_id = technologygroupto.id) AND (technologyto.active = true))))
  WHERE ((linechangeovernorms.changeovertype)::text = '02forTechnologyGroup'::text);


--
-- Name: linechangeovernorms_normflatview_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.linechangeovernorms_normflatview_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: linechangeovernorms_ordersnormview; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.linechangeovernorms_ordersnormview AS
 SELECT (((ordersorder.id)::text || ', '::text) || (linechangeovernormsdto.number)::text) AS id,
    ordersorder.id AS orderid,
    ordersorder.number,
    linechangeovernormsdto.number AS normnumber,
    linechangeovernormsdto.name AS normname,
    linechangeovernormsdto.duration,
    linechangeovernormsdto.technologyfromnumber,
    linechangeovernormsdto.technologytonumber
   FROM (public.orders_order ordersorder
     JOIN public.linechangeovernorms_linechangeovernormsdto linechangeovernormsdto ON (((linechangeovernormsdto.technologyto_id = ordersorder.technology_id) AND (linechangeovernormsdto.technologyfrom_id = ( SELECT previousorder.technology_id
           FROM public.orders_order previousorder
          WHERE ((previousorder.active = true) AND (previousorder.productionline_id = ordersorder.productionline_id) AND (previousorder.finishdate < ordersorder.finishdate) AND ((previousorder.state)::text <> ALL (ARRAY[('05declined'::character varying)::text, ('07abandoned'::character varying)::text])))
          ORDER BY previousorder.finishdate DESC
         LIMIT 1)))))
  WHERE ((ordersorder.active = true) AND (ordersorder.finishdate > (now() - '1 mon'::interval)) AND (((linechangeovernormsdto.productionline_id IS NOT NULL) AND (linechangeovernormsdto.productionline_id = ordersorder.productionline_id)) OR (linechangeovernormsdto.productionline_id IS NULL)))
  ORDER BY linechangeovernormsdto.changeovertype, linechangeovernormsdto.productionline_id;


--
-- Name: linechangeovernorms_ordersnormview_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.linechangeovernorms_ordersnormview_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: linechangeovernormsfororders_linechangeoverfororderdtohelper; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.linechangeovernormsfororders_linechangeoverfororderdtohelper AS
 SELECT ordersorder.id,
    ordersorder.active,
    ordersorder.number AS ordernumber,
    ordersorder.startdate AS orderstartdate,
    ordersorder.finishdate AS orderfinishdate,
    productionline.number AS productionlinenumber,
    linechangeovernormsdto.number AS linechangeovernormsnumber,
    linechangeovernormsdto.name AS linechangeovernormsname,
    COALESCE(ordersorder.ownlinechangeoverduration, linechangeovernormsdto.duration) AS linechangeoverduration
   FROM ((public.orders_order ordersorder
     LEFT JOIN public.productionlines_productionline productionline ON ((productionline.id = ordersorder.productionline_id)))
     JOIN public.linechangeovernorms_linechangeovernormsdto linechangeovernormsdto ON (((linechangeovernormsdto.technologyto_id = ordersorder.technology_id) AND (linechangeovernormsdto.technologyfrom_id = ( SELECT previousorder.technology_id
           FROM public.orders_order previousorder
          WHERE ((previousorder.productionline_id = ordersorder.productionline_id) AND (previousorder.finishdate < ordersorder.startdate) AND ((previousorder.state)::text <> ALL (ARRAY[('05declined'::character varying)::text, ('07abandoned'::character varying)::text])))
          ORDER BY previousorder.finishdate DESC
         LIMIT 1)) AND (((linechangeovernormsdto.productionline_id IS NOT NULL) AND (linechangeovernormsdto.productionline_id = ordersorder.productionline_id)) OR (linechangeovernormsdto.productionline_id IS NULL)))))
  WHERE ((ordersorder.state)::text <> ALL (ARRAY[('05declined'::character varying)::text, ('07abandoned'::character varying)::text]))
  ORDER BY linechangeovernormsdto.changeovertype, linechangeovernormsdto.productionline_id;


--
-- Name: linechangeovernormsfororders_linechangeoverfororderdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.linechangeovernormsfororders_linechangeoverfororderdto AS
 SELECT ordersorder.id,
    ordersorder.active,
    ordersorder.number AS ordernumber,
    linechangeoverfororderdto.orderstartdate,
    linechangeoverfororderdto.orderfinishdate,
    linechangeoverfororderdto.productionlinenumber,
    linechangeoverfororderdto.linechangeovernormsnumber,
    linechangeoverfororderdto.linechangeovernormsname,
    linechangeoverfororderdto.linechangeoverduration
   FROM (public.orders_order ordersorder
     JOIN LATERAL ( SELECT linechangeovernormsfororders_linechangeoverfororderdtohelper.id,
            linechangeovernormsfororders_linechangeoverfororderdtohelper.active,
            linechangeovernormsfororders_linechangeoverfororderdtohelper.ordernumber,
            linechangeovernormsfororders_linechangeoverfororderdtohelper.orderstartdate,
            linechangeovernormsfororders_linechangeoverfororderdtohelper.orderfinishdate,
            linechangeovernormsfororders_linechangeoverfororderdtohelper.productionlinenumber,
            linechangeovernormsfororders_linechangeoverfororderdtohelper.linechangeovernormsnumber,
            linechangeovernormsfororders_linechangeoverfororderdtohelper.linechangeovernormsname,
            linechangeovernormsfororders_linechangeoverfororderdtohelper.linechangeoverduration
           FROM public.linechangeovernormsfororders_linechangeoverfororderdtohelper
          WHERE (linechangeovernormsfororders_linechangeoverfororderdtohelper.id = ordersorder.id)
         LIMIT 1) linechangeoverfororderdto ON ((1 = 1)))
  WHERE ((ordersorder.state)::text <> ALL (ARRAY[('05declined'::character varying)::text, ('07abandoned'::character varying)::text]));


--
-- Name: linechangeovernormsfororders_linechangeoverfororderdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.linechangeovernormsfororders_linechangeoverfororderdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: linechangeovernormsfororders_linechangeoverfororderdtohelper_id; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.linechangeovernormsfororders_linechangeoverfororderdtohelper_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_generatingordershelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_generatingordershelper (
    id bigint NOT NULL,
    selectedentities character varying(4096),
    startdate timestamp without time zone,
    finishdate timestamp without time zone
);


--
-- Name: masterorders_generatingordershelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_generatingordershelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_generatingordershelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_generatingordershelper_id_seq OWNED BY public.masterorders_generatingordershelper.id;


--
-- Name: masterorders_masterorder_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_masterorder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_masterorder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_masterorder_id_seq OWNED BY public.masterorders_masterorder.id;


--
-- Name: masterorders_masterorderdefinition_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_masterorderdefinition_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_masterorderdefinition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_masterorderdefinition_id_seq OWNED BY public.masterorders_masterorderdefinition.id;


--
-- Name: masterorders_masterorderposition_manyproducts; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.masterorders_masterorderposition_manyproducts AS
SELECT
    NULL::bigint AS id,
    NULL::character varying(255) AS masterorderdefinitionnumber,
    NULL::integer AS masterorderid,
    NULL::integer AS productid,
    NULL::integer AS masterorderproductid,
    NULL::character varying(1024) AS name,
    NULL::character varying(255) AS number,
    NULL::timestamp without time zone AS deadline,
    NULL::character varying(255) AS masterorderstatus,
    NULL::character varying(255) AS masterorderpositionstatus,
    NULL::numeric AS masterorderquantity,
    NULL::numeric AS cumulatedmasterorderquantity,
    NULL::numeric AS producedorderquantity,
    NULL::numeric AS lefttorelease,
    NULL::text AS comments,
    NULL::character varying(255) AS productnumber,
    NULL::character varying(1024) AS productname,
    NULL::character varying(255) AS unit,
    NULL::character varying(255) AS technologyname,
    NULL::character varying(255) AS companyname,
    NULL::boolean AS active,
    NULL::character varying(255) AS companypayer,
    NULL::character varying(255) AS assortmentname,
    NULL::character varying(255) AS state,
    NULL::character varying(2048) AS description,
    NULL::numeric(14,5) AS quantitytakenfromwarehouse,
    NULL::numeric(14,5) AS quantityremainingtoorder,
    NULL::numeric(14,5) AS quantityremainingtoorderwithoutstock,
    NULL::character varying(1024) AS modelname,
    NULL::character varying(255) AS companycategory,
    NULL::character varying(255) AS salesplannumber,
    NULL::character varying(255) AS salesplanname,
    NULL::numeric AS warehouseminimumstatequantity,
    NULL::boolean AS warehouseorder,
    NULL::numeric AS warehousestate,
    NULL::numeric AS deliveredquantity,
    NULL::numeric AS producequantity,
    NULL::numeric(14,5) AS price;


--
-- Name: masterorders_masterorderpositiondto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.masterorders_masterorderpositiondto AS
 SELECT masterorders_masterorderposition_manyproducts.id,
    masterorders_masterorderposition_manyproducts.masterorderdefinitionnumber,
    masterorders_masterorderposition_manyproducts.masterorderid,
    masterorders_masterorderposition_manyproducts.productid,
    masterorders_masterorderposition_manyproducts.masterorderproductid,
    masterorders_masterorderposition_manyproducts.name,
    masterorders_masterorderposition_manyproducts.number,
    masterorders_masterorderposition_manyproducts.deadline,
    masterorders_masterorderposition_manyproducts.masterorderstatus,
    masterorders_masterorderposition_manyproducts.masterorderpositionstatus,
    masterorders_masterorderposition_manyproducts.masterorderquantity,
    masterorders_masterorderposition_manyproducts.cumulatedmasterorderquantity,
    masterorders_masterorderposition_manyproducts.producedorderquantity,
    masterorders_masterorderposition_manyproducts.lefttorelease,
    masterorders_masterorderposition_manyproducts.comments,
    masterorders_masterorderposition_manyproducts.productnumber,
    masterorders_masterorderposition_manyproducts.productname,
    masterorders_masterorderposition_manyproducts.unit,
    masterorders_masterorderposition_manyproducts.technologyname,
    masterorders_masterorderposition_manyproducts.companyname,
    masterorders_masterorderposition_manyproducts.active,
    masterorders_masterorderposition_manyproducts.companypayer,
    masterorders_masterorderposition_manyproducts.assortmentname,
    masterorders_masterorderposition_manyproducts.state,
    masterorders_masterorderposition_manyproducts.description,
    masterorders_masterorderposition_manyproducts.quantitytakenfromwarehouse,
    masterorders_masterorderposition_manyproducts.quantityremainingtoorder,
    masterorders_masterorderposition_manyproducts.quantityremainingtoorderwithoutstock,
    masterorders_masterorderposition_manyproducts.modelname,
    masterorders_masterorderposition_manyproducts.companycategory,
    masterorders_masterorderposition_manyproducts.salesplannumber,
    masterorders_masterorderposition_manyproducts.salesplanname,
    COALESCE(masterorders_masterorderposition_manyproducts.warehouseminimumstatequantity, (0)::numeric) AS warehouseminimumstatequantity,
    masterorders_masterorderposition_manyproducts.warehouseorder,
    masterorders_masterorderposition_manyproducts.warehousestate,
    masterorders_masterorderposition_manyproducts.deliveredquantity,
    masterorders_masterorderposition_manyproducts.producequantity,
    masterorders_masterorderposition_manyproducts.price
   FROM public.masterorders_masterorderposition_manyproducts;


--
-- Name: masterorders_salesplan; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_salesplan (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(255),
    description character varying(2048),
    state character varying(255),
    datefrom date,
    dateto date
);


--
-- Name: masterorders_masterorderdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.masterorders_masterorderdto AS
 SELECT masterorder.id,
    masterorderdefinition.number AS masterorderdefinitionnumber,
    masterorder.number,
    masterorder.name,
    masterorder.deadline,
    company.number AS company,
    companypayer.number AS companypayer,
    COALESCE((orderedpositions.count)::integer, 0) AS orderedpositionquantity,
    COALESCE((cumulatedpositions.count)::integer, 0) AS commissionedpositionquantity,
    (COALESCE((orderedpositions.count)::integer, 0) - COALESCE((cumulatedpositions.count)::integer, 0)) AS quantityforcommission,
    masterorder.masterorderstate,
    masterorder.active,
    masterorder.pipedriveupdate,
    masterorder.state,
    masterorder.externalnumber,
    masterorder.externalsynchronized,
    masterorder.asanataskid,
    masterorder.description,
    salesplan.number AS salesplannumber,
    salesplan.name AS salesplanname,
    company.contractorcategory AS companycategory,
    masterorder.warehouseorder
   FROM ((((((public.masterorders_masterorder masterorder
     LEFT JOIN public.masterorders_salesplan salesplan ON ((salesplan.id = masterorder.salesplan_id)))
     LEFT JOIN public.masterorders_masterorderdefinition masterorderdefinition ON ((masterorderdefinition.id = masterorder.masterorderdefinition_id)))
     LEFT JOIN public.basic_company company ON ((company.id = masterorder.company_id)))
     LEFT JOIN public.basic_company companypayer ON ((companypayer.id = masterorder.companypayer_id)))
     LEFT JOIN ( SELECT masterorders_masterorderpositiondto.masterorderid,
            count(*) AS count
           FROM public.masterorders_masterorderpositiondto
          GROUP BY masterorders_masterorderpositiondto.masterorderid) orderedpositions ON ((orderedpositions.masterorderid = masterorder.id)))
     LEFT JOIN ( SELECT masterorders_masterorderpositiondto.masterorderid,
            count(*) AS count
           FROM public.masterorders_masterorderpositiondto
          WHERE (masterorders_masterorderpositiondto.cumulatedmasterorderquantity > (0)::numeric)
          GROUP BY masterorders_masterorderpositiondto.masterorderid) cumulatedpositions ON ((cumulatedpositions.masterorderid = masterorder.id)));


--
-- Name: masterorders_masterorderdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_masterorderdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_masterorderposition_manyproducts_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_masterorderposition_manyproducts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_masterorderposition_oneproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_masterorderposition_oneproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_masterorderpositiondto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_masterorderpositiondto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_masterorderproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_masterorderproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_masterorderproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_masterorderproduct_id_seq OWNED BY public.masterorders_masterorderproduct.id;


--
-- Name: masterorders_masterorderproductattrvalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_masterorderproductattrvalue (
    id bigint NOT NULL,
    masterorderproduct_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255),
    succession integer
);


--
-- Name: masterorders_masterorderproductattrvalue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_masterorderproductattrvalue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_masterorderproductattrvalue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_masterorderproductattrvalue_id_seq OWNED BY public.masterorders_masterorderproductattrvalue.id;


--
-- Name: masterorders_masterordersmaterialrequirement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_masterordersmaterialrequirement (
    id bigint NOT NULL,
    number character varying(256),
    name character varying(1024),
    generated boolean,
    worker character varying(255),
    date timestamp without time zone,
    includecomponents boolean DEFAULT false
);


--
-- Name: masterorders_masterordersmaterialrequirement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_masterordersmaterialrequirement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_masterordersmaterialrequirement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_masterordersmaterialrequirement_id_seq OWNED BY public.masterorders_masterordersmaterialrequirement.id;


--
-- Name: masterorders_masterordersmaterialrequirement_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_masterordersmaterialrequirement_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_masterordersmaterialrequirementproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_masterordersmaterialrequirementproduct (
    id bigint NOT NULL,
    masterordersmaterialrequirement_id bigint,
    product_id bigint,
    technologyinputproducttype_id bigint,
    quantity numeric(14,5),
    currentstock numeric(14,5),
    neededquantity numeric(14,5),
    supplier_id bigint
);


--
-- Name: masterorders_masterordersmaterialrequirementproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_masterordersmaterialrequirementproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_masterordersmaterialrequirementproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_masterordersmaterialrequirementproduct_id_seq OWNED BY public.masterorders_masterordersmaterialrequirementproduct.id;


--
-- Name: masterorders_orderedproductconfigurator; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_orderedproductconfigurator (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024)
);


--
-- Name: masterorders_orderedproductconfigurator_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_orderedproductconfigurator_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_orderedproductconfigurator_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_orderedproductconfigurator_id_seq OWNED BY public.masterorders_orderedproductconfigurator.id;


--
-- Name: masterorders_orderedproductconfiguratorattribute; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_orderedproductconfiguratorattribute (
    id bigint NOT NULL,
    orderedproductconfigurator_id bigint,
    attribute_id bigint,
    succession integer
);


--
-- Name: masterorders_orderedproductconfiguratorattribute_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_orderedproductconfiguratorattribute_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_orderedproductconfiguratorattribute_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_orderedproductconfiguratorattribute_id_seq OWNED BY public.masterorders_orderedproductconfiguratorattribute.id;


--
-- Name: masterorders_ordersgenerationhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_ordersgenerationhelper (
    id bigint NOT NULL,
    plannedquantity numeric(12,5),
    datefrom timestamp without time zone,
    dateto timestamp without time zone
);


--
-- Name: masterorders_ordersgenerationhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_ordersgenerationhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_ordersgenerationhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_ordersgenerationhelper_id_seq OWNED BY public.masterorders_ordersgenerationhelper.id;


--
-- Name: masterorders_outsourceprocessingcomponenthelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_outsourceprocessingcomponenthelper (
    id bigint NOT NULL,
    quantity numeric(12,5),
    datefrom timestamp without time zone,
    dateto timestamp without time zone
);


--
-- Name: masterorders_outsourceprocessingcomponenthelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_outsourceprocessingcomponenthelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_outsourceprocessingcomponenthelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_outsourceprocessingcomponenthelper_id_seq OWNED BY public.masterorders_outsourceprocessingcomponenthelper.id;


--
-- Name: masterorders_position_deliveryproductquantityhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_position_deliveryproductquantityhelper (
    id bigint NOT NULL,
    product_id bigint,
    quantity numeric(11,5)
);


--
-- Name: masterorders_position_deliveryproductquantityhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_position_deliveryproductquantityhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_position_deliveryproductquantityhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_position_deliveryproductquantityhelper_id_seq OWNED BY public.masterorders_position_deliveryproductquantityhelper.id;


--
-- Name: masterorders_position_warehousestatehelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_position_warehousestatehelper (
    id bigint NOT NULL,
    product_id bigint,
    location_id bigint,
    quantity numeric(12,5)
);


--
-- Name: masterorders_position_warehousestatehelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_position_warehousestatehelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_position_warehousestatehelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_position_warehousestatehelper_id_seq OWNED BY public.masterorders_position_warehousestatehelper.id;


--
-- Name: masterorders_priceslist; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_priceslist (
    id bigint NOT NULL,
    product_id bigint,
    productcategory character varying(255),
    attribute1value_id bigint,
    value1 character varying(255),
    attribute2value_id bigint,
    value2 character varying(255),
    price numeric(9,2),
    datefrom date,
    dateto date
);


--
-- Name: masterorders_priceslist_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_priceslist_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_priceslist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_priceslist_id_seq OWNED BY public.masterorders_priceslist.id;


--
-- Name: masterorders_productsbyattributeentryhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_productsbyattributeentryhelper (
    id bigint NOT NULL,
    productsbyattributehelper_id bigint,
    product_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255)
);


--
-- Name: masterorders_productsbyattributeentryhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_productsbyattributeentryhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_productsbyattributeentryhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_productsbyattributeentryhelper_id_seq OWNED BY public.masterorders_productsbyattributeentryhelper.id;


--
-- Name: masterorders_productsbyattributehelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_productsbyattributehelper (
    id bigint NOT NULL,
    masterorder_id bigint,
    product_id bigint,
    orderedquantity numeric(12,5),
    comments character varying(2048)
);


--
-- Name: masterorders_productsbyattributehelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_productsbyattributehelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_productsbyattributehelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_productsbyattributehelper_id_seq OWNED BY public.masterorders_productsbyattributehelper.id;


--
-- Name: masterorders_productsbysizeentryhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_productsbysizeentryhelper (
    id bigint NOT NULL,
    size_id bigint,
    productsbysizehelper_id bigint,
    quantity numeric(12,5),
    product_id bigint
);


--
-- Name: masterorders_productsbysizeentryhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_productsbysizeentryhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_productsbysizeentryhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_productsbysizeentryhelper_id_seq OWNED BY public.masterorders_productsbysizeentryhelper.id;


--
-- Name: masterorders_productsbysizehelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_productsbysizehelper (
    id bigint NOT NULL,
    product_id bigint,
    totalquantity numeric(12,5),
    masterorder_id bigint,
    salesplan_id bigint,
    ordersgroup_id bigint
);


--
-- Name: masterorders_productsbysizehelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_productsbysizehelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_productsbysizehelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_productsbysizehelper_id_seq OWNED BY public.masterorders_productsbysizehelper.id;


--
-- Name: masterorders_sales_plan_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_sales_plan_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_salesplan_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_salesplan_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_salesplan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_salesplan_id_seq OWNED BY public.masterorders_salesplan.id;


--
-- Name: masterorders_salesplanmaterialrequirement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_salesplanmaterialrequirement (
    id bigint NOT NULL,
    number character varying(256),
    salesplan_id bigint,
    generated boolean,
    worker character varying(255),
    date timestamp without time zone,
    includecomponents boolean DEFAULT false
);


--
-- Name: masterorders_salesplanmaterialrequirement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_salesplanmaterialrequirement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_salesplanmaterialrequirement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_salesplanmaterialrequirement_id_seq OWNED BY public.masterorders_salesplanmaterialrequirement.id;


--
-- Name: masterorders_salesplanmaterialrequirement_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_salesplanmaterialrequirement_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_salesplanmaterialrequirementproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_salesplanmaterialrequirementproduct (
    id bigint NOT NULL,
    salesplanmaterialrequirement_id bigint,
    product_id bigint,
    quantity numeric(14,5),
    sizegroup_id bigint,
    sumforsizes numeric(14,5),
    currentstock numeric(14,5),
    neededquantity numeric(14,5),
    supplier_id bigint,
    minimumorderquantity numeric(12,5),
    isdeliverycreated boolean DEFAULT false
);


--
-- Name: masterorders_salesplanmaterialrequirementproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_salesplanmaterialrequirementproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_salesplanmaterialrequirementproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_salesplanmaterialrequirementproduct_id_seq OWNED BY public.masterorders_salesplanmaterialrequirementproduct.id;


--
-- Name: masterorders_salesplanordersgroupentryhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_salesplanordersgroupentryhelper (
    id bigint NOT NULL,
    salesplanordersgrouphelper_id bigint,
    productfamily_id bigint,
    product_id bigint,
    plannedquantity numeric(12,5),
    orderedquantity numeric(12,5),
    orderquantity numeric(12,5),
    technology_id bigint
);


--
-- Name: masterorders_salesplanordersgroupentryhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_salesplanordersgroupentryhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_salesplanordersgroupentryhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_salesplanordersgroupentryhelper_id_seq OWNED BY public.masterorders_salesplanordersgroupentryhelper.id;


--
-- Name: masterorders_salesplanordersgrouphelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_salesplanordersgrouphelper (
    id bigint NOT NULL,
    salesplan_id bigint
);


--
-- Name: masterorders_salesplanordersgrouphelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_salesplanordersgrouphelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_salesplanordersgrouphelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_salesplanordersgrouphelper_id_seq OWNED BY public.masterorders_salesplanordersgrouphelper.id;


--
-- Name: ordersgroups_ordersgroup; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersgroups_ordersgroup (
    id bigint NOT NULL,
    number character varying(255),
    assortment_id bigint,
    productionline_id bigint,
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    deadline timestamp without time zone,
    quantity numeric(14,5),
    producedquantity numeric(14,5),
    remainingquantity numeric(14,5),
    state character varying(255) DEFAULT '01draft'::character varying,
    active boolean DEFAULT true,
    masterorder_id bigint,
    parent_id bigint,
    remainingquantityinorders numeric(14,5),
    description character varying(2048),
    salesplan_id bigint
);


--
-- Name: masterorders_salesplanpalnnedproductdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.masterorders_salesplanpalnnedproductdto AS
 SELECT o.id AS orderid,
    og.id AS ordergroupid,
    sp.id AS salesplanid,
    o.product_id AS productid,
    o.plannedquantity
   FROM ((public.orders_order o
     LEFT JOIN public.ordersgroups_ordersgroup og ON ((og.id = o.ordersgroup_id)))
     LEFT JOIN public.masterorders_salesplan sp ON (((sp.id = o.salesplan_id) OR (sp.id = og.salesplan_id))))
  WHERE (sp.id IS NOT NULL);


--
-- Name: masterorders_salesplanproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_salesplanproduct (
    id bigint NOT NULL,
    salesplan_id bigint NOT NULL,
    product_id bigint NOT NULL,
    technology_id bigint,
    plannedquantity numeric(14,5),
    orderedquantity numeric(14,5) DEFAULT 0,
    surplusfromplan numeric(14,5),
    orderedtowarehouse numeric(14,5) DEFAULT 0
);


--
-- Name: masterorders_salesplanproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_salesplanproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_salesplanproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_salesplanproduct_id_seq OWNED BY public.masterorders_salesplanproduct.id;


--
-- Name: masterorders_salesplanproductdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.masterorders_salesplanproductdto AS
 SELECT spp.id,
    (spp.salesplan_id)::integer AS salesplanid,
    spp.salesplan_id,
    p.number AS productnumber,
    p.name AS productname,
    p.entitytype AS productentitytype,
    assortment.name AS productassortment,
    family.number AS productfamily,
    model.name AS productmodel,
    p.unit AS productunit,
    t.number AS technologynumber,
    spp.plannedquantity,
    spp.orderedquantity,
    spp.surplusfromplan,
        CASE
            WHEN ((p.entitytype)::text = '01particularProduct'::text) THEN COALESCE(( SELECT sum(sppp.plannedquantity) AS sum
               FROM public.masterorders_salesplanpalnnedproductdto sppp
              WHERE ((sppp.salesplanid = spp.salesplan_id) AND (sppp.productid = p.id))), (0)::numeric)
            ELSE COALESCE(( SELECT sum(sppp.plannedquantity) AS sum
               FROM public.masterorders_salesplanpalnnedproductdto sppp
              WHERE ((sppp.salesplanid = spp.salesplan_id) AND (sppp.productid IN ( SELECT prod.id
                       FROM public.basic_product prod
                      WHERE (prod.parent_id = p.id))))), (0)::numeric)
        END AS ordersplannedquantity,
    spp.orderedtowarehouse
   FROM (((((public.masterorders_salesplanproduct spp
     JOIN public.basic_product p ON ((spp.product_id = p.id)))
     LEFT JOIN public.basic_assortment assortment ON ((p.assortment_id = assortment.id)))
     LEFT JOIN public.basic_model model ON ((p.model_id = model.id)))
     LEFT JOIN public.technologies_technology t ON ((t.id = spp.technology_id)))
     LEFT JOIN public.basic_product family ON ((p.parent_id = family.id)));


--
-- Name: masterorders_salesplanproductdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_salesplanproductdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_salesplanstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_salesplanstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    salesplan_id bigint,
    shift_id bigint,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255)
);


--
-- Name: masterorders_salesplanstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_salesplanstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_salesplanstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_salesplanstatechange_id_seq OWNED BY public.masterorders_salesplanstatechange.id;


--
-- Name: masterorders_salesvolume; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_salesvolume (
    id bigint NOT NULL,
    product_id bigint,
    dailysalesvolume numeric(14,5),
    optimalstock numeric(14,5),
    currentstock numeric(14,5),
    stockfordays integer
);


--
-- Name: masterorders_salesvolume_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_salesvolume_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_salesvolume_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_salesvolume_id_seq OWNED BY public.masterorders_salesvolume.id;


--
-- Name: masterorders_salesvolumemulti; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.masterorders_salesvolumemulti (
    id bigint NOT NULL,
    dailysalesvolume numeric(14,5),
    optimalstock numeric(14,5),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: masterorders_salesvolumemulti_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.masterorders_salesvolumemulti_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: masterorders_salesvolumemulti_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.masterorders_salesvolumemulti_id_seq OWNED BY public.masterorders_salesvolumemulti.id;


--
-- Name: materialflow_location_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflow_location_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflow_location_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflow_location_id_seq OWNED BY public.materialflow_location.id;


--
-- Name: materialflow_userlocation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflow_userlocation (
    id bigint NOT NULL,
    location_id bigint,
    user_id bigint
);


--
-- Name: materialflow_userlocation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflow_userlocation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflow_userlocation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflow_userlocation_id_seq OWNED BY public.materialflow_userlocation.id;


--
-- Name: materialflowresources_costnormsgenerator; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_costnormsgenerator (
    id bigint NOT NULL,
    costssource character varying(255) DEFAULT '01mes'::character varying,
    productstoupdate character varying(255) DEFAULT '01all'::character varying,
    entityversion bigint DEFAULT 0
);


--
-- Name: materialflowresources_costnormsgenerator_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_costnormsgenerator_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_costnormsgenerator_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_costnormsgenerator_id_seq OWNED BY public.materialflowresources_costnormsgenerator.id;


--
-- Name: materialflowresources_costnormslocation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_costnormslocation (
    id bigint NOT NULL,
    costnormsgenerator_id bigint,
    location_id bigint,
    entityversion bigint DEFAULT 0,
    parameter_id bigint
);


--
-- Name: materialflowresources_costnormslocation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_costnormslocation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_costnormslocation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_costnormslocation_id_seq OWNED BY public.materialflowresources_costnormslocation.id;


--
-- Name: materialflowresources_defaultstoragelocationdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.materialflowresources_defaultstoragelocationdto AS
 SELECT row_number() OVER () AS id,
    storagelocation.active,
    storagelocation.number,
    storagelocation.location_id,
    product_storagelocation.storagelocation_id,
    product_storagelocation.product_id
   FROM (public.materialflowresources_storagelocation storagelocation
     RIGHT JOIN public.jointable_product_storagelocation product_storagelocation ON ((product_storagelocation.storagelocation_id = storagelocation.id)));


--
-- Name: materialflowresources_defaultstoragelocationdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_defaultstoragelocationdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_document; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_document (
    id bigint NOT NULL,
    number character varying(255) NOT NULL,
    type character varying(255) NOT NULL,
    "time" timestamp without time zone,
    state character varying(255) DEFAULT '01draft'::character varying,
    locationfrom_id bigint,
    locationto_id bigint,
    user_id bigint,
    delivery_id bigint,
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    order_id bigint,
    description character varying(2048),
    suborder_id bigint,
    company_id bigint,
    maintenanceevent_id bigint,
    entityversion bigint DEFAULT 0,
    plannedevent_id bigint,
    name character varying(255),
    createlinkeddocument boolean,
    linkeddocumentlocation_id bigint,
    address_id bigint,
    generationdate timestamp without time zone,
    filename character varying(255),
    acceptationinprogress boolean DEFAULT false,
    externalnumber character varying(255),
    issend boolean DEFAULT false,
    wms boolean DEFAULT false,
    datesendtowms timestamp without time zone,
    stateinwms character varying(255),
    pickingworker character varying(255),
    dateconfirmationofcompletion timestamp without time zone,
    editinwms boolean DEFAULT true,
    staff_id bigint,
    ordersgroup_id bigint,
    invoicenumber character varying(2048)
);


--
-- Name: materialflowresources_document_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_document_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_document_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_document_id_seq OWNED BY public.materialflowresources_document.id;


--
-- Name: materialflowresources_document_number_mm; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_document_number_mm
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_document_number_pw; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_document_number_pw
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_document_number_pz; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_document_number_pz
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_document_number_rw; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_document_number_rw
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_document_number_wz; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_document_number_wz
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_documentdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.materialflowresources_documentdto AS
 SELECT document.id,
    document.number,
    document.description,
    document.name,
    document.type,
    document."time",
    document.state,
    document.active,
    (locationfrom.id)::integer AS locationfrom_id,
    locationfrom.number AS locationfromnumber,
    (locationto.id)::integer AS locationto_id,
    locationto.number AS locationtonumber,
    (company.id)::integer AS company_id,
    company.name AS companyname,
        CASE
            WHEN (address.name IS NULL) THEN (address.number)::text
            ELSE (((address.number)::text || ' - '::text) || (address.name)::text)
        END AS documentaddress,
    (securityuser.id)::integer AS user_id,
    (((securityuser.firstname)::text || ' '::text) || (securityuser.lastname)::text) AS username,
    (maintenanceevent.id)::integer AS maintenanceevent_id,
    maintenanceevent.number AS maintenanceeventnumber,
    (plannedevent.id)::integer AS plannedevent_id,
    plannedevent.number AS plannedeventnumber,
    (delivery.id)::integer AS delivery_id,
    delivery.number AS deliverynumber,
    (ordersorder.id)::integer AS order_id,
    ordersorder.number AS ordernumber,
    (suborder.id)::integer AS suborder_id,
    suborder.number AS subordernumber,
    document.issend,
    document.wms,
    document.stateinwms,
    document.pickingworker,
    (((stf.surname)::text || ' '::text) || (stf.name)::text) AS staff,
    og.number AS ordersgroup,
    document.invoicenumber
   FROM ((((((((((((public.materialflowresources_document document
     LEFT JOIN public.materialflow_location locationfrom ON ((locationfrom.id = document.locationfrom_id)))
     LEFT JOIN public.materialflow_location locationto ON ((locationto.id = document.locationto_id)))
     LEFT JOIN public.basic_company company ON ((company.id = document.company_id)))
     LEFT JOIN public.basic_address address ON ((address.id = document.address_id)))
     LEFT JOIN public.qcadoosecurity_user securityuser ON ((securityuser.id = document.user_id)))
     LEFT JOIN public.cmmsmachineparts_maintenanceevent maintenanceevent ON ((maintenanceevent.id = document.maintenanceevent_id)))
     LEFT JOIN public.cmmsmachineparts_plannedevent plannedevent ON ((plannedevent.id = document.plannedevent_id)))
     LEFT JOIN public.deliveries_delivery delivery ON ((delivery.id = document.delivery_id)))
     LEFT JOIN public.orders_order ordersorder ON ((ordersorder.id = document.order_id)))
     LEFT JOIN public.subcontractorportal_suborder suborder ON ((suborder.id = document.suborder_id)))
     LEFT JOIN public.basic_staff stf ON ((stf.id = document.staff_id)))
     LEFT JOIN public.ordersgroups_ordersgroup og ON ((og.id = document.ordersgroup_id)));


--
-- Name: materialflowresources_documentdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_documentdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_documentpositionparameters; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_documentpositionparameters (
    id bigint NOT NULL,
    suggestresource boolean DEFAULT false,
    acceptanceofdocumentbeforeprinting boolean DEFAULT false,
    notshowprices boolean DEFAULT false,
    presenttotalamountandrest boolean DEFAULT false,
    pallettoshift integer,
    palletwithfreeplace integer,
    fillresourceirrespectiveofconversion boolean DEFAULT false,
    numberofmonthsforpositionsdata integer DEFAULT 1,
    colorresourcesafterdeadline boolean DEFAULT false,
    shortexpirydate integer DEFAULT 14,
    transferpallettoreceivingwarehouse boolean DEFAULT false,
    runningoutofstockdays integer DEFAULT 0
);


--
-- Name: materialflowresources_documentpositionparameters_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_documentpositionparameters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_documentpositionparameters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_documentpositionparameters_id_seq OWNED BY public.materialflowresources_documentpositionparameters.id;


--
-- Name: materialflowresources_documentpositionparametersitem; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_documentpositionparametersitem (
    id bigint NOT NULL,
    checked boolean DEFAULT true,
    editable boolean DEFAULT true,
    parameters_id bigint,
    name character varying(255),
    ordering integer,
    forattribute boolean DEFAULT false,
    attribute_id bigint
);


--
-- Name: materialflowresources_documentpositionparametersitem_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_documentpositionparametersitem_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_documentpositionparametersitem_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_documentpositionparametersitem_id_seq OWNED BY public.materialflowresources_documentpositionparametersitem.id;


--
-- Name: materialflowresources_documentstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_documentstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    document_id bigint,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    worker character varying(255)
);


--
-- Name: materialflowresources_documentstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_documentstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_documentstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_documentstatechange_id_seq OWNED BY public.materialflowresources_documentstatechange.id;


--
-- Name: materialflowresources_importstoragelocation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_importstoragelocation (
    id bigint NOT NULL,
    location_id bigint,
    positionsfile character varying(255)
);


--
-- Name: materialflowresources_importstoragelocation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_importstoragelocation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_importstoragelocation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_importstoragelocation_id_seq OWNED BY public.materialflowresources_importstoragelocation.id;


--
-- Name: materialflowresources_palletbalance; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_palletbalance (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(255),
    datefrom date,
    dateto date,
    includeweekends boolean DEFAULT false,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    generated boolean DEFAULT false,
    filename character varying(255),
    generateddate date,
    generatedby character varying
);


--
-- Name: materialflowresources_palletbalance_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_palletbalance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_palletbalance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_palletbalance_id_seq OWNED BY public.materialflowresources_palletbalance.id;


--
-- Name: materialflowresources_palletmovehelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_palletmovehelper (
    id bigint NOT NULL
);


--
-- Name: materialflowresources_palletmovehelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_palletmovehelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_palletmovehelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_palletmovehelper_id_seq OWNED BY public.materialflowresources_palletmovehelper.id;


--
-- Name: materialflowresources_resource; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_resource (
    id bigint NOT NULL,
    location_id bigint,
    product_id bigint,
    quantity numeric(14,5),
    price numeric(12,5) DEFAULT (0)::numeric,
    _batch character varying(255),
    "time" timestamp without time zone NOT NULL,
    productiondate date,
    expirationdate date,
    iscorrected boolean,
    entityversion bigint DEFAULT 0,
    storagelocation_id bigint,
    number character varying(255) NOT NULL,
    quantityinadditionalunit numeric(14,5),
    conversion numeric(12,5) DEFAULT (0)::numeric,
    palletnumber_id bigint,
    typeofpallet character varying(255),
    givenunit character varying(255),
    username character varying(255),
    waste boolean DEFAULT false,
    availablequantity numeric(14,5),
    reservedquantity numeric(14,5),
    deliverynumber character varying,
    documentnumber character varying,
    batch_id bigint,
    blockedforqualitycontrol boolean DEFAULT false,
    qualityrating character varying(255)
);


--
-- Name: materialflowresources_palletstoragestatedetailsdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.materialflowresources_palletstoragestatedetailsdto AS
 SELECT resource.id,
    true AS active,
    resource.number AS resourcenumber,
    product.number AS productnumber,
    product.name AS productname,
    resource.quantity,
    product.unit,
    resource.quantityinadditionalunit AS additionalquantity,
    resource.givenunit AS additionalunit,
    resource.expirationdate,
    palletnumber.number AS palletnumber,
    palletnumber.active AS palletnumberactive,
    resource.typeofpallet,
    storagelocation.number AS storagelocationnumber,
    location.number AS locationnumber,
    (location.id)::integer AS location_id,
    resource.palletnumber_id AS palletid
   FROM ((((public.materialflowresources_resource resource
     LEFT JOIN public.basic_product product ON ((product.id = resource.product_id)))
     LEFT JOIN public.basic_palletnumber palletnumber ON ((palletnumber.id = resource.palletnumber_id)))
     LEFT JOIN public.materialflowresources_storagelocation storagelocation ON ((storagelocation.id = resource.storagelocation_id)))
     LEFT JOIN public.materialflow_location location ON ((location.id = resource.location_id)))
  WHERE (resource.palletnumber_id IS NOT NULL)
  ORDER BY palletnumber.number;


--
-- Name: materialflowresources_palletstoragestatedetailsdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_palletstoragestatedetailsdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_palletstoragestatedto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.materialflowresources_palletstoragestatedto AS
 SELECT palletstoragestatedetails.palletid AS id,
    true AS active,
    palletstoragestatedetails.palletnumber,
    palletstoragestatedetails.palletnumberactive,
    palletstoragestatedetails.typeofpallet,
    palletstoragestatedetails.storagelocationnumber,
    palletstoragestatedetails.locationnumber,
    (sum(palletstoragestatedetails.quantity))::numeric(14,5) AS totalquantity,
    NULL::bigint AS palletmovehelper_id,
    NULL::bigint AS newstoragelocation_id,
    NULL::bigint AS newpalletnumber_id,
    palletstoragestatedetails.location_id
   FROM public.materialflowresources_palletstoragestatedetailsdto palletstoragestatedetails
  GROUP BY palletstoragestatedetails.palletid, palletstoragestatedetails.palletnumber, palletstoragestatedetails.palletnumberactive, palletstoragestatedetails.typeofpallet, palletstoragestatedetails.storagelocationnumber, palletstoragestatedetails.locationnumber, palletstoragestatedetails.location_id
  ORDER BY palletstoragestatedetails.palletnumber, palletstoragestatedetails.locationnumber;


--
-- Name: materialflowresources_palletstoragestatedto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_palletstoragestatedto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_position; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_position (
    id bigint NOT NULL,
    document_id bigint,
    product_id bigint,
    quantity numeric(14,5),
    price numeric(12,5) DEFAULT (0)::numeric,
    productiondate date,
    expirationdate date,
    number integer,
    resource_id bigint,
    givenunit character varying(255),
    givenquantity numeric(14,5),
    entityversion bigint DEFAULT 0,
    storagelocation_id bigint,
    conversion numeric(12,5) DEFAULT (0)::numeric,
    palletnumber_id bigint,
    typeofpallet character varying(255),
    waste boolean DEFAULT false,
    resourcereceiptdocument character varying,
    lastresource boolean DEFAULT false,
    resourcenumber character varying(255),
    externaldocumentnumber character varying(255),
    orderid integer,
    sellingprice numeric(12,5) DEFAULT '0'::numeric,
    batch_id bigint,
    qualityrating character varying(255),
    pickingdate timestamp without time zone,
    pickingworker_id bigint,
    documentpart_id bigint
);


--
-- Name: materialflowresources_position_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_position_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_position_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_position_id_seq OWNED BY public.materialflowresources_position.id;


--
-- Name: materialflowresources_positionaddmultihelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_positionaddmultihelper (
    id bigint NOT NULL
);


--
-- Name: materialflowresources_positionaddmultihelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_positionaddmultihelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_positionaddmultihelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_positionaddmultihelper_id_seq OWNED BY public.materialflowresources_positionaddmultihelper.id;


--
-- Name: materialflowresources_positionattributevalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_positionattributevalue (
    id bigint NOT NULL,
    position_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255)
);


--
-- Name: materialflowresources_positionattributevalue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_positionattributevalue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_positionattributevalue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_positionattributevalue_id_seq OWNED BY public.materialflowresources_positionattributevalue.id;


--
-- Name: materialflowresources_positiondto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.materialflowresources_positiondto AS
 SELECT "position".id,
    locationfrom.number AS locationfrom,
    locationto.number AS locationto,
    product.number AS productnumber,
    product.name AS productname,
    product.globaltypeofmaterial AS productglobaltypeofmaterial,
    product.category AS productcategory,
    "position".quantity,
    "position".price,
    product.unit AS productunit,
    document."time" AS documentdate,
    ("position".expirationdate)::timestamp without time zone AS expirationdate,
    ("position".productiondate)::timestamp without time zone AS productiondate,
        CASE
            WHEN ("position".externaldocumentnumber IS NULL) THEN document.type
            ELSE '03internalOutbound'::character varying(255)
        END AS documenttype,
    document.state,
        CASE
            WHEN ("position".externaldocumentnumber IS NULL) THEN document.number
            ELSE "position".externaldocumentnumber
        END AS documentnumber,
    document.name AS documentname,
    company.name AS companyname,
        CASE
            WHEN (address.name IS NULL) THEN (address.number)::text
            ELSE (((address.number)::text || ' - '::text) || (address.name)::text)
        END AS documentaddress,
    batch.number AS batch,
    storagelocation.number AS storagelocation,
    "position".waste,
    delivery.number AS deliverynumber,
    plannedevent.number AS plannedeventnumber,
    maintenanceevent.number AS maintenanceeventnumber,
    suborder.number AS subordernumber,
    ordersorder.number AS ordernumber,
    "position".typeofpallet AS pallettype,
    palletnumber.number AS palletnumber,
    (locationfrom.id)::integer AS locationfrom_id,
    (locationto.id)::integer AS locationto_id,
    "position".givenquantity,
    "position".givenunit,
    "position".conversion,
    (document.id)::integer AS documentid,
        CASE
            WHEN ("position".orderid IS NULL) THEN (document.order_id)::integer
            ELSE "position".orderid
        END AS orderid,
    round(("position".price * "position".quantity), 5) AS value,
    "position".resourcenumber,
    "position".sellingprice,
    (((staff.surname)::text || ' '::text) || (staff.name)::text) AS staff,
    (document.suborder_id)::integer AS suborderid,
    document.invoicenumber
   FROM (((((((((((((((public.materialflowresources_position "position"
     LEFT JOIN public.materialflowresources_document document ON ((document.id = "position".document_id)))
     LEFT JOIN public.materialflow_location locationfrom ON ((locationfrom.id = document.locationfrom_id)))
     LEFT JOIN public.materialflow_location locationto ON ((locationto.id = document.locationto_id)))
     JOIN public.basic_product product ON ((product.id = "position".product_id)))
     LEFT JOIN public.basic_company company ON ((company.id = document.company_id)))
     LEFT JOIN public.basic_address address ON ((address.id = document.address_id)))
     LEFT JOIN public.materialflowresources_storagelocation storagelocation ON ((storagelocation.id = "position".storagelocation_id)))
     LEFT JOIN public.cmmsmachineparts_maintenanceevent maintenanceevent ON ((maintenanceevent.id = document.maintenanceevent_id)))
     LEFT JOIN public.cmmsmachineparts_plannedevent plannedevent ON ((plannedevent.id = document.plannedevent_id)))
     LEFT JOIN public.deliveries_delivery delivery ON ((delivery.id = document.delivery_id)))
     LEFT JOIN public.subcontractorportal_suborder suborder ON ((suborder.id = document.suborder_id)))
     LEFT JOIN public.orders_order ordersorder ON (((ordersorder.id = document.order_id) OR (ordersorder.id = "position".orderid))))
     LEFT JOIN public.basic_palletnumber palletnumber ON ((palletnumber.id = "position".palletnumber_id)))
     LEFT JOIN public.advancedgenealogy_batch batch ON ((batch.id = "position".batch_id)))
     LEFT JOIN public.basic_staff staff ON ((staff.id = document.staff_id)));


--
-- Name: materialflowresources_positiondto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_positiondto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_reservation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_reservation (
    id bigint NOT NULL,
    location_id bigint,
    product_id bigint,
    quantity numeric(12,5),
    position_id bigint,
    productstoissue_id bigint,
    resource_id bigint,
    order_id bigint,
    orderproductresourcereservation_id bigint,
    date timestamp without time zone
);


--
-- Name: materialflowresources_reservation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_reservation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_reservation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_reservation_id_seq OWNED BY public.materialflowresources_reservation.id;


--
-- Name: materialflowresources_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_resource_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_resource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_resource_id_seq OWNED BY public.materialflowresources_resource.id;


--
-- Name: materialflowresources_resource_number_2014; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_resource_number_2014
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_resource_number_2015; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_resource_number_2015
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_resource_number_2016; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_resource_number_2016
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_resource_number_2017; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_resource_number_2017
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_resourceattributevalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_resourceattributevalue (
    id bigint NOT NULL,
    resource_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255),
    fromdefinition boolean DEFAULT false
);


--
-- Name: materialflowresources_resourceattributevalue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_resourceattributevalue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_resourceattributevalue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_resourceattributevalue_id_seq OWNED BY public.materialflowresources_resourceattributevalue.id;


--
-- Name: materialflowresources_resourceattributevalueaftercorrection; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_resourceattributevalueaftercorrection (
    id bigint NOT NULL,
    resourcecorrection_id bigint,
    attribute_id bigint,
    value character varying(255)
);


--
-- Name: materialflowresources_resourceattributevalueaftercorrection_id_; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_resourceattributevalueaftercorrection_id_
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_resourceattributevalueaftercorrection_id_; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_resourceattributevalueaftercorrection_id_ OWNED BY public.materialflowresources_resourceattributevalueaftercorrection.id;


--
-- Name: materialflowresources_resourceattributevaluebeforecorrection; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_resourceattributevaluebeforecorrection (
    id bigint NOT NULL,
    resourcecorrection_id bigint,
    attribute_id bigint,
    value character varying(255)
);


--
-- Name: materialflowresources_resourceattributevaluebeforecorrection_id; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_resourceattributevaluebeforecorrection_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_resourceattributevaluebeforecorrection_id; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_resourceattributevaluebeforecorrection_id OWNED BY public.materialflowresources_resourceattributevaluebeforecorrection.id;


--
-- Name: materialflowresources_resourcecorrection; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_resourcecorrection (
    id bigint NOT NULL,
    number character varying(255),
    product_id bigint,
    newquantity numeric(14,5),
    oldquantity numeric(14,5),
    location_id bigint,
    "time" timestamp without time zone,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    _oldbatch character varying(255),
    resource_id bigint,
    entityversion bigint DEFAULT 0,
    oldstoragelocation_id bigint,
    newstoragelocation_id bigint,
    oldprice numeric(12,5),
    newprice numeric(12,5),
    _newbatch character varying,
    oldpalletnumber_id bigint,
    newpalletnumber_id bigint,
    oldtypeofpallet character varying,
    newtypeofpallet character varying,
    oldexpirationdate date,
    newexpirationdate date,
    productiondate date,
    oldconversion numeric,
    newconversion numeric,
    resourcenumber character varying(255),
    deliverynumber character varying,
    oldbatch_id bigint,
    newbatch_id bigint,
    oldqualityrating character varying(255),
    newqualityrating character varying(255)
);


--
-- Name: materialflowresources_resourcecorrection_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_resourcecorrection_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_resourcecorrection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_resourcecorrection_id_seq OWNED BY public.materialflowresources_resourcecorrection.id;


--
-- Name: materialflowresources_resourcecorrectiondto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.materialflowresources_resourcecorrectiondto AS
 SELECT resourcecorrection.id,
    resourcecorrection.createdate,
    product.number AS productnumber,
    product.name AS productname,
    resourcecorrection.resourcenumber,
    resourcecorrection.number AS correctionnumber,
    (resourcecorrection.oldquantity <> resourcecorrection.newquantity) AS quantitycorrected,
    (COALESCE(resourcecorrection.oldprice, (0)::numeric) <> COALESCE(resourcecorrection.newprice, (0)::numeric)) AS pricecorrected,
    ((COALESCE(resourcecorrection.oldbatch_id, (0)::bigint))::text <> (COALESCE(resourcecorrection.newbatch_id, (0)::bigint))::text) AS batchcorrected,
    (COALESCE(resourcecorrection.oldexpirationdate, '1900-01-01'::date) <> COALESCE(resourcecorrection.newexpirationdate, '1900-01-01'::date)) AS expirationdatecorrected,
    (COALESCE(resourcecorrection.oldstoragelocation_id, (0)::bigint) <> COALESCE(resourcecorrection.newstoragelocation_id, (0)::bigint)) AS storagelocationcorrected,
    (COALESCE(resourcecorrection.oldpalletnumber_id, (0)::bigint) <> COALESCE(resourcecorrection.newpalletnumber_id, (0)::bigint)) AS palletnumbercorrected,
    ((COALESCE(resourcecorrection.oldtypeofpallet, ''::character varying))::text <> (COALESCE(resourcecorrection.newtypeofpallet, ''::character varying))::text) AS typeofpalletcorrected,
    resourcecorrection.deliverynumber,
    (resourcecorrection.location_id)::integer AS location_id,
    location.number AS locationnumber,
    newpallet.number AS newpalletnumber,
    oldpallet.number AS oldpalletnumber,
    newstoragelocation.number AS newstoragelocationnumber,
    oldstoragelocation.number AS oldstoragelocationnumber,
        CASE
            WHEN (( SELECT count(*) AS count
               FROM public.materialflowresources_resourceattributevalueaftercorrection resourceattributevalue
              WHERE (resourceattributevalue.resourcecorrection_id = resourcecorrection.id)) > 0) THEN true
            WHEN (( SELECT count(*) AS count
               FROM public.materialflowresources_resourceattributevaluebeforecorrection resourceattributevalue
              WHERE (resourceattributevalue.resourcecorrection_id = resourcecorrection.id)) > 0) THEN true
            ELSE false
        END AS attributecorrection,
    ((COALESCE(resourcecorrection.oldqualityrating, ''::character varying))::text <> (COALESCE(resourcecorrection.newqualityrating, ''::character varying))::text) AS qualityratingcorrected,
    resourcecorrection.newqualityrating,
    resourcecorrection.oldqualityrating
   FROM (((((((public.materialflowresources_resourcecorrection resourcecorrection
     JOIN public.basic_product product ON ((product.id = resourcecorrection.product_id)))
     LEFT JOIN public.materialflowresources_resource resource ON ((resource.id = resourcecorrection.resource_id)))
     LEFT JOIN public.materialflow_location location ON ((location.id = resourcecorrection.location_id)))
     LEFT JOIN public.basic_palletnumber newpallet ON ((newpallet.id = resourcecorrection.newpalletnumber_id)))
     LEFT JOIN public.basic_palletnumber oldpallet ON ((oldpallet.id = resourcecorrection.oldpalletnumber_id)))
     LEFT JOIN public.materialflowresources_storagelocation newstoragelocation ON ((newstoragelocation.id = resourcecorrection.newstoragelocation_id)))
     LEFT JOIN public.materialflowresources_storagelocation oldstoragelocation ON ((oldstoragelocation.id = resourcecorrection.oldstoragelocation_id)));


--
-- Name: materialflowresources_resourcecorrectiondto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_resourcecorrectiondto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_resourcedto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.materialflowresources_resourcedto AS
 SELECT resource.id,
    resource.number,
    resource.quantity,
    resource.quantityinadditionalunit,
    location.number AS locationnumber,
    product.number AS productnumber,
    product.name AS productname,
    product.globaltypeofmaterial AS productglobaltypeofmaterial,
    product.unit AS productunit,
    product.category AS productcategory,
    resource.givenunit,
    resource.conversion,
    resource.reservedquantity,
    resource.availablequantity,
    resource.price,
    (resource.quantity * resource.price) AS value,
    resource."time",
    resource.productiondate,
    resource.expirationdate,
    batch.number AS batchnumber,
    storagelocation.number AS storagelocationnumber,
    palletnumber.number AS palletnumber,
    resource.typeofpallet,
    resource.username,
    resource.iscorrected,
    resource.waste,
    resource.deliverynumber,
    (resource.location_id)::integer AS location_id,
    NULL::bigint AS positionaddmultihelper_id,
    resource.documentnumber,
    resource.qualityrating,
    resource.blockedforqualitycontrol,
    COALESCE(supplier.number, document_supplier.number) AS suppliernumber,
        CASE
            WHEN ( SELECT materialflowresources_documentpositionparameters.colorresourcesafterdeadline
               FROM public.materialflowresources_documentpositionparameters
             LIMIT 1) THEN (1)::numeric
            ELSE (0)::numeric
        END AS colorresourcesafterdeadline,
        CASE
            WHEN (resource.expirationdate < CURRENT_DATE) THEN 'red-cell'::character varying(255)
            WHEN (( SELECT (materialflowresources_documentpositionparameters.shortexpirydate IS NOT NULL)
               FROM public.materialflowresources_documentpositionparameters
             LIMIT 1) AND (resource.expirationdate >= CURRENT_DATE) AND (resource.expirationdate <= (CURRENT_DATE + ((( SELECT materialflowresources_documentpositionparameters.shortexpirydate
               FROM public.materialflowresources_documentpositionparameters
             LIMIT 1))::double precision * '1 day'::interval)))) THEN 'orange-cell'::character varying(255)
            ELSE NULL::character varying
        END AS expirationdatecellcolor
   FROM (((((((((public.materialflowresources_resource resource
     JOIN public.materialflow_location location ON ((location.id = resource.location_id)))
     JOIN public.basic_product product ON ((product.id = resource.product_id)))
     LEFT JOIN public.basic_palletnumber palletnumber ON ((palletnumber.id = resource.palletnumber_id)))
     LEFT JOIN public.materialflowresources_storagelocation storagelocation ON ((storagelocation.id = resource.storagelocation_id)))
     LEFT JOIN public.advancedgenealogy_batch batch ON ((batch.id = resource.batch_id)))
     LEFT JOIN public.deliveries_delivery delivery ON (((delivery.number)::text = (resource.deliverynumber)::text)))
     LEFT JOIN public.basic_company supplier ON ((delivery.supplier_id = supplier.id)))
     LEFT JOIN public.materialflowresources_document document ON (((document.number)::text = (resource.documentnumber)::text)))
     LEFT JOIN public.basic_company document_supplier ON ((document.company_id = document_supplier.id)));


--
-- Name: materialflowresources_resourcedto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_resourcedto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_resourcestock; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_resourcestock (
    id bigint NOT NULL,
    location_id bigint,
    product_id bigint
);


--
-- Name: materialflowresources_resourcestock_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_resourcestock_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_resourcestock_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_resourcestock_id_seq OWNED BY public.materialflowresources_resourcestock.id;


--
-- Name: warehouseminimalstate_warehouseminimumstate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.warehouseminimalstate_warehouseminimumstate (
    id bigint NOT NULL,
    product_id bigint,
    location_id bigint,
    minimumstate numeric(12,5),
    optimalorderquantity numeric(12,5),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: materialflowresources_resourcestockdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.materialflowresources_resourcestockdto AS
 WITH minimum_states AS (
         SELECT warehouseminimumstate.product_id,
            warehouseminimumstate.location_id,
            sum(warehouseminimumstate.minimumstate) AS quantity
           FROM public.warehouseminimalstate_warehouseminimumstate warehouseminimumstate
          GROUP BY warehouseminimumstate.product_id, warehouseminimumstate.location_id
        ), quantities AS (
         SELECT resource.product_id,
            resource.location_id,
            sum(resource.quantity) AS quantity,
            sum(resource.quantityinadditionalunit) AS quantityinadditionalunit,
            sum((resource.quantity * resource.price)) AS totalvalue
           FROM public.materialflowresources_resource resource
          GROUP BY resource.product_id, resource.location_id
        ), blocked_quantities AS (
         SELECT resource.product_id,
            resource.location_id,
            sum(resource.quantity) AS quantity
           FROM public.materialflowresources_resource resource
          WHERE (resource.blockedforqualitycontrol = true)
          GROUP BY resource.product_id, resource.location_id
        ), reserved_quantities AS (
         SELECT reservation.product_id,
            reservation.location_id,
            sum(reservation.quantity) AS quantity
           FROM public.materialflowresources_reservation reservation
          GROUP BY reservation.product_id, reservation.location_id
        ), ordered_quantities AS (
         SELECT orderedproduct.product_id,
            delivery.location_id,
            sum(orderedproduct.orderedquantity) AS quantity
           FROM (public.deliveries_orderedproduct orderedproduct
             JOIN public.deliveries_delivery delivery ON ((delivery.id = orderedproduct.delivery_id)))
          WHERE ((delivery.active = true) AND ((delivery.state)::text = ANY (ARRAY[('01draft'::character varying)::text, ('02prepared'::character varying)::text, ('03duringCorrection'::character varying)::text, ('05approved'::character varying)::text])))
          GROUP BY orderedproduct.product_id, delivery.location_id
        )
 SELECT resourcestock.id,
    (resourcestock.location_id)::integer AS location_id,
    (resourcestock.product_id)::integer AS product_id,
    location.number AS locationnumber,
    location.name AS locationname,
    product.number AS productnumber,
    product.name AS productname,
    product.globaltypeofmaterial AS productglobaltypeofmaterial,
    product.unit AS productunit,
    family.number AS familynumber,
    COALESCE(minimum_states.quantity, (0)::numeric) AS minimumstate,
    COALESCE(quantities.quantity, (0)::numeric) AS quantity,
    COALESCE(quantities.quantityinadditionalunit, (0)::numeric) AS quantityinadditionalunit,
    COALESCE(quantities.totalvalue, (0)::numeric) AS totalvalue,
    COALESCE(ordered_quantities.quantity, (0)::numeric) AS orderedquantity,
    COALESCE(reserved_quantities.quantity, (0)::numeric) AS reservedquantity,
    (COALESCE(quantities.quantity, (0)::numeric) - COALESCE(reserved_quantities.quantity, (0)::numeric)) AS availablequantity,
    COALESCE(blocked_quantities.quantity, (0)::numeric) AS blockedquantity,
    COALESCE(product.additionalunit, product.unit) AS productadditionalunit
   FROM ((((((((public.materialflowresources_resourcestock resourcestock
     JOIN public.materialflow_location location ON ((location.id = resourcestock.location_id)))
     JOIN public.basic_product product ON ((product.id = resourcestock.product_id)))
     LEFT JOIN public.basic_product family ON ((product.parent_id = family.id)))
     LEFT JOIN minimum_states ON (((minimum_states.product_id = resourcestock.product_id) AND (minimum_states.location_id = resourcestock.location_id))))
     LEFT JOIN quantities ON (((quantities.product_id = resourcestock.product_id) AND (quantities.location_id = resourcestock.location_id))))
     LEFT JOIN blocked_quantities ON (((blocked_quantities.product_id = resourcestock.product_id) AND (blocked_quantities.location_id = resourcestock.location_id))))
     LEFT JOIN ordered_quantities ON (((ordered_quantities.product_id = resourcestock.product_id) AND (ordered_quantities.location_id = resourcestock.location_id))))
     LEFT JOIN reserved_quantities ON (((reserved_quantities.product_id = resourcestock.product_id) AND (reserved_quantities.location_id = resourcestock.location_id))));


--
-- Name: materialflowresources_resourcestockdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_resourcestockdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_resourcestockdto_internal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_resourcestockdto_internal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_stocktaking; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_stocktaking (
    id bigint NOT NULL,
    number character varying(255),
    stocktakingdate date,
    generationdate timestamp without time zone,
    category character varying(255),
    wastemode character varying(255) DEFAULT '01ALL'::character varying,
    storagelocationmode character varying(255) DEFAULT '01ALL'::character varying,
    location_id bigint,
    generated boolean DEFAULT false,
    filename character varying(255),
    active boolean DEFAULT true
);


--
-- Name: materialflowresources_stocktaking_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_stocktaking_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_stocktaking_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_stocktaking_id_seq OWNED BY public.materialflowresources_stocktaking.id;


--
-- Name: materialflowresources_storagelocation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_storagelocation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_storagelocation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_storagelocation_id_seq OWNED BY public.materialflowresources_storagelocation.id;


--
-- Name: materialflowresources_storagelocationdto_internal; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.materialflowresources_storagelocationdto_internal AS
 SELECT location.number AS locationnumber,
    storagelocation.number AS storagelocationnumber,
    product.number AS productnumber,
    product.name AS productname,
    COALESCE(sum(resource.quantity), (0)::numeric) AS resourcequantity,
    product.unit AS productunit,
    COALESCE(sum(resource.quantityinadditionalunit), (0)::numeric) AS quantityinadditionalunit,
    COALESCE(product.additionalunit, product.unit) AS productadditionalunit,
    (location.id)::integer AS location_id
   FROM (((public.materialflowresources_storagelocation storagelocation
     JOIN public.materialflow_location location ON ((storagelocation.location_id = location.id)))
     LEFT JOIN public.materialflowresources_resource resource ON ((resource.storagelocation_id = storagelocation.id)))
     LEFT JOIN public.basic_product product ON ((product.id = resource.product_id)))
  WHERE (storagelocation.active = true)
  GROUP BY location.number, location.id, storagelocation.number, product.number, product.name, product.unit, COALESCE(product.additionalunit, product.unit);


--
-- Name: materialflowresources_storagelocationdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.materialflowresources_storagelocationdto AS
 SELECT row_number() OVER () AS id,
    internal.locationnumber,
    internal.storagelocationnumber,
    internal.productnumber,
    internal.productname,
    internal.resourcequantity,
    internal.productunit,
    internal.quantityinadditionalunit,
    internal.productadditionalunit,
    internal.location_id
   FROM public.materialflowresources_storagelocationdto_internal internal;


--
-- Name: materialflowresources_storagelocationdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_storagelocationdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_storagelocationhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_storagelocationhelper (
    id bigint NOT NULL,
    prefix character varying(255),
    number character varying(255),
    location_id bigint,
    placestoragelocation boolean DEFAULT false,
    numberofstoragelocations numeric(12,5),
    maximumnumberofpallets numeric(12,5),
    highstoragelocation boolean
);


--
-- Name: materialflowresources_storagelocationhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_storagelocationhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_storagelocationhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_storagelocationhelper_id_seq OWNED BY public.materialflowresources_storagelocationhelper.id;


--
-- Name: materialflowresources_storagelocationnumberhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_storagelocationnumberhelper (
    id bigint NOT NULL
);


--
-- Name: materialflowresources_storagelocationnumberhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_storagelocationnumberhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_storagelocationnumberhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_storagelocationnumberhelper_id_seq OWNED BY public.materialflowresources_storagelocationnumberhelper.id;


--
-- Name: materialflowresources_warehousestock_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_warehousestock_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_warehousestocklistdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_warehousestocklistdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_warehousestocklistdto_internal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_warehousestocklistdto_internal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_warehousestockreport; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialflowresources_warehousestockreport (
    id bigint NOT NULL,
    warehousestockdate date,
    generationdate timestamp without time zone,
    category character varying(255),
    wastemode character varying(255) DEFAULT '01ALL'::character varying,
    storagelocationmode character varying(255) DEFAULT '01ALL'::character varying,
    location_id bigint,
    generated boolean DEFAULT false,
    filename character varying(255),
    active boolean DEFAULT true
);


--
-- Name: materialflowresources_warehousestockreport_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialflowresources_warehousestockreport_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialflowresources_warehousestockreport_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialflowresources_warehousestockreport_id_seq OWNED BY public.materialflowresources_warehousestockreport.id;


--
-- Name: materialrequirementcoveragefororder_columnforcoveragesfororder; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialrequirementcoveragefororder_columnforcoveragesfororder (
    id bigint NOT NULL,
    identifier character varying(255),
    name character varying(1024),
    description character varying(1024),
    columnfiller character varying(255),
    alignment character varying(255) DEFAULT '01left'::character varying,
    succession integer,
    entityversion bigint DEFAULT 0
);


--
-- Name: materialrequirementcoveragefororder_columnforcoveragesfororder_; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialrequirementcoveragefororder_columnforcoveragesfororder_
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialrequirementcoveragefororder_columnforcoveragesfororder_; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialrequirementcoveragefororder_columnforcoveragesfororder_ OWNED BY public.materialrequirementcoveragefororder_columnforcoveragesfororder.id;


--
-- Name: materialrequirementcoveragefororder_coveragefororder; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialrequirementcoveragefororder_coveragefororder (
    id bigint NOT NULL,
    number character varying(255),
    coveragetodate timestamp without time zone,
    actualdate timestamp without time zone,
    generateddate timestamp without time zone,
    generatedby character varying(255),
    generated boolean,
    saved boolean,
    filename character varying(1024),
    coveragetype character varying(255) DEFAULT '01all'::character varying,
    includedraftdeliveries boolean,
    order_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    generatedorders boolean,
    entityversion bigint DEFAULT 0
);


--
-- Name: materialrequirementcoveragefororder_coveragefororder_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialrequirementcoveragefororder_coveragefororder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialrequirementcoveragefororder_coveragefororder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialrequirementcoveragefororder_coveragefororder_id_seq OWNED BY public.materialrequirementcoveragefororder_coveragefororder.id;


--
-- Name: materialrequirementcoveragefororder_coveragelocation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialrequirementcoveragefororder_coveragelocation (
    id bigint NOT NULL,
    coveragefororder_id bigint,
    location_id bigint,
    parameter_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: materialrequirementcoveragefororder_coveragelocation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialrequirementcoveragefororder_coveragelocation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialrequirementcoveragefororder_coveragelocation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialrequirementcoveragefororder_coveragelocation_id_seq OWNED BY public.materialrequirementcoveragefororder_coveragelocation.id;


--
-- Name: materialrequirementcoveragefororder_coverageproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialrequirementcoveragefororder_coverageproduct (
    id bigint NOT NULL,
    coveragefororder_id bigint,
    product_id bigint,
    lackfromdate timestamp without time zone,
    demandquantity numeric(12,5),
    coveredquantity numeric(12,5),
    reservemissingquantity numeric(12,5),
    deliveredquantity numeric(12,5),
    locationsquantity numeric(12,5),
    state character varying(255),
    ispurchased boolean DEFAULT false,
    issubcontracted boolean DEFAULT false,
    producttype character varying(255),
    order_id bigint,
    planedquantity numeric(12,5),
    entityversion bigint DEFAULT 0
);


--
-- Name: materialrequirementcoveragefororder_coverageproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialrequirementcoveragefororder_coverageproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialrequirementcoveragefororder_coverageproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialrequirementcoveragefororder_coverageproduct_id_seq OWNED BY public.materialrequirementcoveragefororder_coverageproduct.id;


--
-- Name: materialrequirements_materialrequirement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialrequirements_materialrequirement (
    id bigint NOT NULL,
    name character varying(1024),
    number character varying(256),
    date timestamp without time zone,
    worker character varying(255),
    mrpalgorithm character varying(255) DEFAULT '01onlyComponents'::character varying,
    generated boolean,
    filename character varying(255),
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0,
    includewarehouse boolean DEFAULT false,
    showcurrentstocklevel boolean DEFAULT false,
    includestartdateorder boolean DEFAULT false,
    location_id bigint
);


--
-- Name: materialrequirements_materialrequirement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialrequirements_materialrequirement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialrequirements_materialrequirement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialrequirements_materialrequirement_id_seq OWNED BY public.materialrequirements_materialrequirement.id;


--
-- Name: materialrequirements_materialrequirementproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.materialrequirements_materialrequirementproduct (
    id bigint NOT NULL,
    materialrequirement_id bigint,
    product_id bigint,
    location_id bigint,
    quantity numeric(14,5),
    currentstock numeric(14,5),
    orderstartdate date,
    batch_id bigint,
    batchstock numeric(14,5)
);


--
-- Name: materialrequirements_materialrequirementproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.materialrequirements_materialrequirementproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: materialrequirements_materialrequirementproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.materialrequirements_materialrequirementproduct_id_seq OWNED BY public.materialrequirements_materialrequirementproduct.id;


--
-- Name: mobilewms_wmsdocumentpart; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.mobilewms_wmsdocumentpart (
    id bigint NOT NULL,
    number character varying(255),
    part integer,
    company character varying(255),
    stateinwms character varying(255),
    pickingworker character varying(255),
    document_id bigint,
    parts integer,
    type character varying(255) NOT NULL,
    documentdate timestamp without time zone
);


--
-- Name: mobilewms_wmsdocumentpart_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.mobilewms_wmsdocumentpart_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: mobilewms_wmsdocumentpart_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.mobilewms_wmsdocumentpart_id_seq OWNED BY public.mobilewms_wmsdocumentpart.id;


--
-- Name: model_card_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.model_card_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: technologiesgenerator_generatorcontext; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.technologiesgenerator_generatorcontext (
    id bigint NOT NULL,
    technology_id bigint,
    product_id bigint,
    fetchtechnologiesforcomponents boolean DEFAULT true,
    createandswapproducts boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    generated boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    saved boolean DEFAULT true,
    generationinprogress boolean DEFAULT false,
    number character varying(255)
);


--
-- Name: productioncounting_performanceanalysisdetaildto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_performanceanalysisdetaildto AS
 SELECT productiontracking.id,
    productiontracking.active,
    (productionline.id)::integer AS productionline_id,
    productionline.number AS productionlinenumber,
    (staff.id)::integer AS staff_id,
    (((staff.surname)::text || ' '::text) || (staff.name)::text) AS staffname,
    (assortment.id)::integer AS assortment_id,
    assortment.name AS assortmentname,
    (product.id)::integer AS product_id,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    size.number AS sizenumber,
    tpl.standardperformance AS performancenorm,
    ((COALESCE(trackingoperationproductoutcomponent.usedquantity, (0)::numeric) + COALESCE(trackingoperationproductoutcomponent.wastesquantity, (0)::numeric)))::numeric(14,5) AS donequantity,
    ((((COALESCE(trackingoperationproductoutcomponent.usedquantity, (0)::numeric) + COALESCE(trackingoperationproductoutcomponent.wastesquantity, (0)::numeric)) * (60)::numeric) / tpl.standardperformance))::integer AS timebasedonnorms,
    (shift.id)::integer AS shift_id,
    shift.name AS shiftname,
    productiontracking.timerangefrom,
    productiontracking.timerangeto,
    (ordersorder.id)::integer AS order_id,
    ordersorder.number AS ordernumber,
    (tcontext.id)::integer AS generator_id,
    tcontext.number AS generatorname,
    COALESCE(productiontracking.shiftstartday, (productiontracking.timerangefrom)::date) AS timerangefromwithouttime,
    (productiontracking.timerangeto)::date AS timerangetowithouttime,
    date_part('epoch'::text, (productiontracking.timerangeto - productiontracking.timerangefrom)) AS labortimesum
   FROM (((((((((((public.productioncounting_productiontracking productiontracking
     LEFT JOIN public.orders_order ordersorder ON ((ordersorder.id = productiontracking.order_id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((productionline.id = ordersorder.productionline_id)))
     LEFT JOIN public.basic_staff staff ON ((staff.id = productiontracking.staff_id)))
     LEFT JOIN public.productioncounting_trackingoperationproductoutcomponent trackingoperationproductoutcomponent ON ((trackingoperationproductoutcomponent.productiontracking_id = productiontracking.id)))
     LEFT JOIN public.basic_product product ON ((product.id = trackingoperationproductoutcomponent.product_id)))
     LEFT JOIN public.basic_assortment assortment ON ((assortment.id = product.assortment_id)))
     LEFT JOIN public.basic_size size ON ((size.id = product.size_id)))
     LEFT JOIN public.technologies_technologyproductionline tpl ON (((tpl.technology_id = ordersorder.technology_id) AND tpl.master)))
     LEFT JOIN public.basic_shift shift ON ((shift.id = productiontracking.shift_id)))
     LEFT JOIN public.technologies_technology technologyprototype ON ((ordersorder.technology_id = technologyprototype.id)))
     LEFT JOIN public.technologiesgenerator_generatorcontext tcontext ON ((tcontext.id = technologyprototype.generatorcontext_id)))
  WHERE ((productiontracking.state)::text = ANY (ARRAY[('01draft'::character varying)::text, ('02accepted'::character varying)::text]))
UNION ALL
 SELECT productiontracking.id,
    productiontracking.active,
    (productionline.id)::integer AS productionline_id,
    productionline.number AS productionlinenumber,
    (staff.id)::integer AS staff_id,
    (((staff.surname)::text || ' '::text) || (staff.name)::text) AS staffname,
    (assortment.id)::integer AS assortment_id,
    assortment.name AS assortmentname,
    (product.id)::integer AS product_id,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    size.number AS sizenumber,
    tpl.standardperformance AS performancenorm,
    ((COALESCE(trackingoperationproductoutcomponent.usedquantity, (0)::numeric) + COALESCE(trackingoperationproductoutcomponent.wastesquantity, (0)::numeric)))::numeric(14,5) AS donequantity,
    ((((COALESCE(trackingoperationproductoutcomponent.usedquantity, (0)::numeric) + COALESCE(trackingoperationproductoutcomponent.wastesquantity, (0)::numeric)) * (60)::numeric) / tpl.standardperformance))::integer AS timebasedonnorms,
    (shift.id)::integer AS shift_id,
    shift.name AS shiftname,
    productiontracking.timerangefrom,
    productiontracking.timerangeto,
    (ordersorder.id)::integer AS order_id,
    ordersorder.number AS ordernumber,
    (tcontext.id)::integer AS generator_id,
    tcontext.number AS generatorname,
    COALESCE(productiontracking.shiftstartday, (productiontracking.timerangefrom)::date) AS timerangefromwithouttime,
    (productiontracking.timerangeto)::date AS timerangetowithouttime,
    date_part('epoch'::text, (productiontracking.timerangeto - productiontracking.timerangefrom)) AS labortimesum
   FROM (((((((((((public.arch_productioncounting_productiontracking productiontracking
     LEFT JOIN public.arch_orders_order ordersorder ON ((ordersorder.id = productiontracking.order_id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((productionline.id = ordersorder.productionline_id)))
     LEFT JOIN public.basic_staff staff ON ((staff.id = productiontracking.staff_id)))
     LEFT JOIN public.arch_productioncounting_trackingoperationproductoutcomponent trackingoperationproductoutcomponent ON ((trackingoperationproductoutcomponent.productiontracking_id = productiontracking.id)))
     LEFT JOIN public.basic_product product ON ((product.id = trackingoperationproductoutcomponent.product_id)))
     LEFT JOIN public.basic_assortment assortment ON ((assortment.id = product.assortment_id)))
     LEFT JOIN public.basic_size size ON ((size.id = product.size_id)))
     LEFT JOIN public.technologies_technologyproductionline tpl ON (((tpl.technology_id = ordersorder.technology_id) AND tpl.master)))
     LEFT JOIN public.basic_shift shift ON ((shift.id = productiontracking.shift_id)))
     LEFT JOIN public.technologies_technology technologyprototype ON ((ordersorder.technology_id = technologyprototype.id)))
     LEFT JOIN public.technologiesgenerator_generatorcontext tcontext ON ((tcontext.id = technologyprototype.generatorcontext_id)))
  WHERE ((productiontracking.state)::text = ANY (ARRAY[('01draft'::character varying)::text, ('02accepted'::character varying)::text]));


--
-- Name: productioncounting_performanceanalysislabortimesumdto_helper; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_performanceanalysislabortimesumdto_helper AS
 SELECT performanceanalysisdetaildto.staff_id,
    performanceanalysisdetaildto.timerangefromwithouttime,
        CASE
            WHEN (min(performanceanalysisdetaildto.labortimesum) <> max(performanceanalysisdetaildto.labortimesum)) THEN (0)::double precision
            ELSE min(performanceanalysisdetaildto.labortimesum)
        END AS labortimesum
   FROM public.productioncounting_performanceanalysisdetaildto performanceanalysisdetaildto
  GROUP BY performanceanalysisdetaildto.staff_id, performanceanalysisdetaildto.timerangefromwithouttime, performanceanalysisdetaildto.shift_id, performanceanalysisdetaildto.productionline_id;


--
-- Name: productioncounting_performanceanalysisdto_helper; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_performanceanalysisdto_helper AS
 SELECT
        CASE
            WHEN (min(helper.labortimesum) = (0)::double precision) THEN (0)::numeric
            ELSE ((((sub.dailyperformance)::numeric)::double precision / sum(helper.labortimesum)))::numeric(14,2)
        END AS dailyperformance,
    sub.productionlinequantity,
    sub.staff_id,
    sub.timerangefromwithouttime
   FROM (( SELECT (100 * sum(performanceanalysisdetaildto.timebasedonnorms)) AS dailyperformance,
            count(DISTINCT performanceanalysisdetaildto.productionline_id) AS productionlinequantity,
            performanceanalysisdetaildto.staff_id,
            performanceanalysisdetaildto.timerangefromwithouttime
           FROM public.productioncounting_performanceanalysisdetaildto performanceanalysisdetaildto
          GROUP BY performanceanalysisdetaildto.staff_id, performanceanalysisdetaildto.timerangefromwithouttime) sub
     LEFT JOIN public.productioncounting_performanceanalysislabortimesumdto_helper helper ON (((helper.staff_id = sub.staff_id) AND (helper.timerangefromwithouttime = sub.timerangefromwithouttime))))
  GROUP BY sub.staff_id, sub.timerangefromwithouttime, sub.productionlinequantity, sub.dailyperformance;


--
-- Name: mv_productioncounting_performanceanalysisdto; Type: MATERIALIZED VIEW; Schema: public; Owner: -
--

CREATE MATERIALIZED VIEW public.mv_productioncounting_performanceanalysisdto AS
 SELECT row_number() OVER () AS id,
    bool_or(performanceanalysisdetaildto.active) AS active,
    performanceanalysisdetaildto.productionline_id,
    performanceanalysisdetaildto.productionlinenumber,
    performanceanalysisdetaildto.staff_id,
    performanceanalysisdetaildto.staffname,
    COALESCE((sum(performanceanalysisdetaildto.timebasedonnorms))::integer, 0) AS timebasedonnormssum,
        CASE
            WHEN (min(performanceanalysisdetaildto.labortimesum) <> max(performanceanalysisdetaildto.labortimesum)) THEN 0
            ELSE (min(performanceanalysisdetaildto.labortimesum))::integer
        END AS labortimesum,
        CASE
            WHEN (min(performanceanalysisdetaildto.labortimesum) <> max(performanceanalysisdetaildto.labortimesum)) THEN (COALESCE(sum(performanceanalysisdetaildto.timebasedonnorms), (0)::bigint))::integer
            ELSE (((COALESCE((sum(performanceanalysisdetaildto.timebasedonnorms))::integer, 0))::double precision - min(performanceanalysisdetaildto.labortimesum)))::integer
        END AS timedeviation,
        CASE
            WHEN (min(performanceanalysisdetaildto.labortimesum) <> max(performanceanalysisdetaildto.labortimesum)) THEN (0)::numeric
            ELSE (((((100)::numeric * (sum(performanceanalysisdetaildto.timebasedonnorms))::numeric))::double precision / min(performanceanalysisdetaildto.labortimesum)))::numeric(14,2)
        END AS performance,
    performanceanalysisdetaildto.shift_id,
    performanceanalysisdetaildto.shiftname,
    performanceanalysisdetaildto.timerangefromwithouttime AS timerangefrom,
    performanceanalysisdetaildto.timerangetowithouttime AS timerangeto,
    sum(performanceanalysisdetaildto.donequantity) AS donequantity,
    (min(helper.productionlinequantity))::integer AS productionlinequantity,
    (count(DISTINCT performanceanalysisdetaildto.assortment_id))::integer AS assortmentquantity,
    (min(helper.dailyperformance))::numeric(14,2) AS dailyperformance
   FROM (public.productioncounting_performanceanalysisdetaildto performanceanalysisdetaildto
     LEFT JOIN public.productioncounting_performanceanalysisdto_helper helper ON (((performanceanalysisdetaildto.staff_id = helper.staff_id) AND (performanceanalysisdetaildto.timerangefromwithouttime = helper.timerangefromwithouttime))))
  GROUP BY performanceanalysisdetaildto.productionline_id, performanceanalysisdetaildto.productionlinenumber, performanceanalysisdetaildto.staff_id, performanceanalysisdetaildto.staffname, performanceanalysisdetaildto.shift_id, performanceanalysisdetaildto.shiftname, performanceanalysisdetaildto.timerangefromwithouttime, performanceanalysisdetaildto.timerangetowithouttime
  WITH NO DATA;


--
-- Name: number_pattern_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.number_pattern_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: nutritionfacts_nutrientcalculation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.nutritionfacts_nutrientcalculation (
    id bigint NOT NULL,
    product_id bigint,
    productportion numeric(12,5),
    formatue boolean DEFAULT true,
    formatusa boolean DEFAULT true,
    generated boolean,
    entityversion bigint DEFAULT 0
);


--
-- Name: nutritionfacts_nutrientcalculation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.nutritionfacts_nutrientcalculation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: nutritionfacts_nutrientcalculation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.nutritionfacts_nutrientcalculation_id_seq OWNED BY public.nutritionfacts_nutrientcalculation.id;


--
-- Name: nutritionfacts_nutrition; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.nutritionfacts_nutrition (
    id bigint NOT NULL,
    name character varying(255),
    nameen character varying(255),
    unit character varying(255),
    nutritiongroup_id bigint,
    priority integer,
    rwsvalue numeric(12,5),
    reportue boolean DEFAULT true,
    dvvalue numeric(12,5),
    entityversion bigint DEFAULT 0
);


--
-- Name: nutritionfacts_nutrition_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.nutritionfacts_nutrition_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: nutritionfacts_nutrition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.nutritionfacts_nutrition_id_seq OWNED BY public.nutritionfacts_nutrition.id;


--
-- Name: nutritionfacts_nutritionelement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.nutritionfacts_nutritionelement (
    id bigint NOT NULL,
    nutrition_id bigint,
    quantity numeric(12,5),
    product_id bigint,
    prototypeproduct_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: nutritionfacts_nutritionelement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.nutritionfacts_nutritionelement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: nutritionfacts_nutritionelement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.nutritionfacts_nutritionelement_id_seq OWNED BY public.nutritionfacts_nutritionelement.id;


--
-- Name: nutritionfacts_nutritiongroup; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.nutritionfacts_nutritiongroup (
    id bigint NOT NULL,
    name character varying(255),
    priority integer,
    rws character varying(255) DEFAULT '02drws'::character varying,
    entityversion bigint DEFAULT 0
);


--
-- Name: nutritionfacts_nutritiongroup_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.nutritionfacts_nutritiongroup_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: nutritionfacts_nutritiongroup_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.nutritionfacts_nutritiongroup_id_seq OWNED BY public.nutritionfacts_nutritiongroup.id;


--
-- Name: nutritionfacts_prototypeproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.nutritionfacts_prototypeproduct (
    id bigint NOT NULL,
    name character varying(255),
    number character varying(255),
    status character varying(255) DEFAULT '01draft'::character varying,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    generated boolean,
    productportion numeric(12,5),
    entityversion bigint DEFAULT 0
);


--
-- Name: nutritionfacts_prototypeproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.nutritionfacts_prototypeproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: nutritionfacts_prototypeproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.nutritionfacts_prototypeproduct_id_seq OWNED BY public.nutritionfacts_prototypeproduct.id;


--
-- Name: nutritionfacts_prototypeproductcomponent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.nutritionfacts_prototypeproductcomponent (
    id bigint NOT NULL,
    prototypeproduct_id bigint,
    quantity numeric(12,5),
    product_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: nutritionfacts_prototypeproductcomponent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.nutritionfacts_prototypeproductcomponent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: nutritionfacts_prototypeproductcomponent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.nutritionfacts_prototypeproductcomponent_id_seq OWNED BY public.nutritionfacts_prototypeproductcomponent.id;


--
-- Name: oee_oee; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.oee_oee (
    id bigint NOT NULL,
    datefrom date,
    dateto date,
    oeefor character varying(255) DEFAULT '01productionLine'::character varying,
    oeepercent numeric(12,5),
    generated boolean,
    date timestamp without time zone,
    worker character varying(255),
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: oee_oee_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.oee_oee_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: oee_oee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.oee_oee_id_seq OWNED BY public.oee_oee.id;


--
-- Name: oee_oeevalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.oee_oeevalue (
    id bigint NOT NULL,
    oee_id bigint,
    productionline_id bigint,
    workstation_id bigint,
    totalavailabletime integer,
    effectivetime integer,
    oeepercent numeric(12,5)
);


--
-- Name: oee_oeevalue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.oee_oeevalue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: oee_oeevalue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.oee_oeevalue_id_seq OWNED BY public.oee_oeevalue.id;


--
-- Name: oee_productionlinedto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.oee_productionlinedto AS
 SELECT productionline.id,
    productionline.number,
    productionline.name,
    productionline.active,
    string_agg((division.number)::text, ', '::text) AS divisions
   FROM ((public.productionlines_productionline productionline
     LEFT JOIN public.jointable_division_productionline division_productionline ON ((division_productionline.productionline_id = productionline.id)))
     LEFT JOIN public.basic_division division ON ((division.id = division_productionline.division_id)))
  GROUP BY productionline.id, productionline.number, productionline.name, productionline.active;


--
-- Name: oee_productionlinedto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.oee_productionlinedto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: oee_workstationdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.oee_workstationdto AS
 SELECT workstation.id,
    workstation.number,
    workstation.name,
    workstation.active,
    productionline.number AS productionlinenumber,
    string_agg((division.number)::text, ', '::text) AS divisions
   FROM (((public.basic_workstation workstation
     LEFT JOIN public.productionlines_productionline productionline ON ((productionline.id = workstation.productionline_id)))
     LEFT JOIN public.jointable_division_productionline division_productionline ON ((division_productionline.productionline_id = productionline.id)))
     LEFT JOIN public.basic_division division ON ((division.id = division_productionline.division_id)))
  GROUP BY workstation.id, workstation.number, workstation.name, workstation.active, productionline.number;


--
-- Name: oee_workstationdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.oee_workstationdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_changedateshelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_changedateshelper (
    id bigint NOT NULL,
    datefrom timestamp without time zone,
    dateto timestamp without time zone,
    commentreasontypecorrectiondatefrom character varying(255),
    commentreasontypecorrectiondateto character varying(255),
    ids character varying(255),
    orderids character varying(255)
);


--
-- Name: orders_changedateshelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_changedateshelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_changedateshelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_changedateshelper_id_seq OWNED BY public.orders_changedateshelper.id;


--
-- Name: orders_dimensioncontrolattribute; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_dimensioncontrolattribute (
    id bigint NOT NULL,
    parameter_id bigint,
    attribute_id bigint
);


--
-- Name: orders_dimensioncontrolattribute_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_dimensioncontrolattribute_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_dimensioncontrolattribute_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_dimensioncontrolattribute_id_seq OWNED BY public.orders_dimensioncontrolattribute.id;


--
-- Name: orders_group_material_requirement_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_group_material_requirement_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_group_production_balance_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_group_production_balance_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_operational_task_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_operational_task_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_operationaltask_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_operationaltask_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_operationaltask_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_operationaltask_id_seq OWNED BY public.orders_operationaltask.id;


--
-- Name: orders_operationaltaskdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.orders_operationaltaskdto AS
 SELECT operationaltask.id,
    operationaltask.number,
    operationaltask.name,
    operationaltask.description,
    operationaltask.type,
    operationaltask.state,
    operationaltask.startdate,
    operationaltask.finishdate,
    operationaltask.actualstaff,
    (((staff.surname)::text || ' '::text) || (staff.name)::text) AS staffname,
    division.number AS divisionnumber,
    productionline.number AS productionlinenumber,
    workstation.number AS workstationnumber,
    (workstation.id)::integer AS workstationid,
    (ordersorder.id)::integer AS orderid,
    ordersorder.number AS ordernumber,
    (technologyoperationcomponent.id)::integer AS tocid,
    (technologyoperationcomponent.operation_id)::integer AS operationid,
    technologyoperationcomponent.nodenumber AS technologyoperationcomponentnodenumber,
    technologyoperationcomponent.issubcontracting AS technologyoperationcomponentissubcontracting,
    (product.number)::text AS productnumber,
    (product.name)::text AS productname,
    (product.unit)::text AS productunit,
    NULL::numeric AS plannedquantity,
    NULL::numeric AS usedquantity,
    NULL::numeric AS remainingquantity,
    NULL::numeric AS doneinpercentage,
    NULL::integer AS suborderid
   FROM (((((((public.orders_operationaltask operationaltask
     LEFT JOIN public.basic_staff staff ON ((staff.id = operationaltask.staff_id)))
     LEFT JOIN public.basic_division division ON ((operationaltask.division_id = division.id)))
     LEFT JOIN public.basic_workstation workstation ON ((workstation.id = operationaltask.workstation_id)))
     LEFT JOIN public.orders_order ordersorder ON ((ordersorder.id = operationaltask.order_id)))
     LEFT JOIN public.technologies_technologyoperationcomponent technologyoperationcomponent ON ((technologyoperationcomponent.id = operationaltask.technologyoperationcomponent_id)))
     LEFT JOIN public.basic_product product ON ((product.id = operationaltask.product_id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((productionline.id = workstation.productionline_id)))
  WHERE ((operationaltask.type)::text = '01otherCase'::text)
UNION ALL
 SELECT operationaltask.id,
    operationaltask.number,
    operationaltask.name,
    operationaltask.description,
    operationaltask.type,
    operationaltask.state,
    operationaltask.startdate,
    operationaltask.finishdate,
    operationaltask.actualstaff,
    (((staff.surname)::text || ' '::text) || (staff.name)::text) AS staffname,
    division.number AS divisionnumber,
    productionline.number AS productionlinenumber,
    workstation.number AS workstationnumber,
    (workstation.id)::integer AS workstationid,
    (ordersorder.id)::integer AS orderid,
    ordersorder.number AS ordernumber,
    (technologyoperationcomponent.id)::integer AS tocid,
    (technologyoperationcomponent.operation_id)::integer AS operationid,
    technologyoperationcomponent.nodenumber AS technologyoperationcomponentnodenumber,
    technologyoperationcomponent.issubcontracting AS technologyoperationcomponentissubcontracting,
    (product.number)::text AS productnumber,
    (product.name)::text AS productname,
    (product.unit)::text AS productunit,
    productioncountingquantitydto.plannedquantity,
    GREATEST(productioncountingquantitydto.producedquantity, (0)::numeric) AS usedquantity,
    GREATEST((COALESCE(productioncountingquantitydto.plannedquantity, (0)::numeric) - COALESCE(productioncountingquantitydto.producedquantity, (0)::numeric)), (0)::numeric) AS remainingquantity,
    ceil(((COALESCE(productioncountingquantitydto.producedquantity, (0)::numeric) * (100)::numeric) / productioncountingquantitydto.plannedquantity)) AS doneinpercentage,
    (operationaltask.suborder_id)::integer AS suborderid
   FROM ((((((((public.orders_operationaltask operationaltask
     LEFT JOIN public.basic_staff staff ON ((staff.id = operationaltask.staff_id)))
     LEFT JOIN public.basic_division division ON ((operationaltask.division_id = division.id)))
     LEFT JOIN public.basic_workstation workstation ON ((workstation.id = operationaltask.workstation_id)))
     LEFT JOIN public.orders_order ordersorder ON ((ordersorder.id = operationaltask.order_id)))
     LEFT JOIN public.technologies_technologyoperationcomponent technologyoperationcomponent ON ((technologyoperationcomponent.id = operationaltask.technologyoperationcomponent_id)))
     LEFT JOIN public.basic_product product ON ((product.id = operationaltask.product_id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((productionline.id = workstation.productionline_id)))
     LEFT JOIN public.basicproductioncounting_productioncountingquantitydto productioncountingquantitydto ON (((productioncountingquantitydto.orderid = ordersorder.id) AND (productioncountingquantitydto.tocid = technologyoperationcomponent.id) AND ((productioncountingquantitydto.role)::text = '02produced'::text) AND (((productioncountingquantitydto.typeofmaterial)::text = '02intermediate'::text) OR ((productioncountingquantitydto.typeofmaterial)::text = '03finalProduct'::text)))))
  WHERE ((operationaltask.type)::text = '02executionOperationInOrder'::text);


--
-- Name: orders_operationaltaskdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_operationaltaskdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_operationaltaskstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_operationaltaskstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    operationaltask_id bigint,
    shift_id bigint
);


--
-- Name: orders_operationaltaskstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_operationaltaskstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_operationaltaskstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_operationaltaskstatechange_id_seq OWNED BY public.orders_operationaltaskstatechange.id;


--
-- Name: orders_workstationchangeoverforoperationaltask; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_workstationchangeoverforoperationaltask (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    description character varying(2048),
    workstation_id bigint,
    currentoperationaltask_id bigint,
    previousoperationaltask_id bigint,
    changeovertype character varying(255) DEFAULT '01anyChange'::character varying,
    workstationchangeovernorm_id bigint,
    attribute_id bigint,
    fromattributevalue_id bigint,
    toattributevalue_id bigint,
    startdate timestamp without time zone,
    finishdate timestamp without time zone,
    duration integer,
    isparallel boolean
);


--
-- Name: orders_operationaltaskwithcolordto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.orders_operationaltaskwithcolordto AS
 WITH operational_task_staff AS (
         SELECT jos.operationaltask_id,
            string_agg((((staff.surname)::text || ' '::text) || (staff.name)::text), ', '::text) AS staffname
           FROM (public.jointable_operationaltask_staff jos
             JOIN public.basic_staff staff ON ((jos.staff_id = staff.id)))
          GROUP BY jos.operationaltask_id
        )
 SELECT operationaltask.id,
    operationaltask.number,
    operationaltask.name,
    operationaltask.description,
    operationaltask.type,
    operationaltask.state,
    operationaltask.startdate,
    operationaltask.finishdate,
    ots.staffname,
    division.number AS divisionnumber,
    (workstation.id)::integer AS workstationid,
    workstation.number AS workstationnumber,
    (ordersorder.id)::integer AS orderid,
    ordersorder.number AS ordernumber,
    (technologyoperationcomponent.id)::integer AS tocid,
    technologyoperationcomponent.nodenumber AS technologyoperationcomponentnodenumber,
    technologyoperationcomponent.issubcontracting AS technologyoperationcomponentissubcontracting,
    (product.number)::text AS productnumber,
    (product.name)::text AS productname,
    NULL::text AS productunit,
    NULL::numeric AS plannedquantity,
    NULL::numeric AS usedquantity,
    NULL::numeric AS remainingquantity,
    NULL::numeric AS doneinpercentage,
    NULL::numeric AS opertaskflagpercentexecutionwithcolor,
    NULL::character varying AS percentageofexecutioncellcolor,
    (orderproduct.number)::text AS orderproductnumber,
    (orderproduct.name)::text AS orderproductname,
    operationaltask.actualstaff,
    NULL::numeric AS wastesquantity,
    NULL::integer AS suborder_id,
    NULL::text AS subordernumber,
    (count(workstationchangeoverforoperationaltask.id) <> 0) AS haschangeovers
   FROM ((((((((public.orders_operationaltask operationaltask
     LEFT JOIN public.orders_workstationchangeoverforoperationaltask workstationchangeoverforoperationaltask ON ((workstationchangeoverforoperationaltask.currentoperationaltask_id = operationaltask.id)))
     LEFT JOIN operational_task_staff ots ON ((operationaltask.id = ots.operationaltask_id)))
     LEFT JOIN public.basic_division division ON ((operationaltask.division_id = division.id)))
     LEFT JOIN public.basic_workstation workstation ON ((workstation.id = operationaltask.workstation_id)))
     LEFT JOIN public.orders_order ordersorder ON ((ordersorder.id = operationaltask.order_id)))
     LEFT JOIN public.technologies_technologyoperationcomponent technologyoperationcomponent ON ((technologyoperationcomponent.id = operationaltask.technologyoperationcomponent_id)))
     LEFT JOIN public.basic_product product ON ((product.id = operationaltask.product_id)))
     LEFT JOIN public.basic_product orderproduct ON ((orderproduct.id = ordersorder.product_id)))
  WHERE ((operationaltask.type)::text = '01otherCase'::text)
  GROUP BY operationaltask.id, operationaltask.number, operationaltask.name, operationaltask.description, operationaltask.type, operationaltask.state, operationaltask.startdate, operationaltask.finishdate, ots.staffname, division.number, ((workstation.id)::integer), workstation.number, ((ordersorder.id)::integer), ordersorder.number, ((technologyoperationcomponent.id)::integer), technologyoperationcomponent.nodenumber, technologyoperationcomponent.issubcontracting, (product.number)::text, (product.name)::text, (product.unit)::text, (orderproduct.number)::text, (orderproduct.name)::text, operationaltask.actualstaff
UNION ALL
 SELECT operationaltask.id,
    operationaltask.number,
    operationaltask.name,
    operationaltask.description,
    operationaltask.type,
    operationaltask.state,
    operationaltask.startdate,
    operationaltask.finishdate,
    ots.staffname,
    division.number AS divisionnumber,
    (workstation.id)::integer AS workstationid,
    workstation.number AS workstationnumber,
    (ordersorder.id)::integer AS orderid,
    ordersorder.number AS ordernumber,
    (technologyoperationcomponent.id)::integer AS tocid,
    technologyoperationcomponent.nodenumber AS technologyoperationcomponentnodenumber,
    technologyoperationcomponent.issubcontracting AS technologyoperationcomponentissubcontracting,
    (product.number)::text AS productnumber,
    (product.name)::text AS productname,
    (product.unit)::text AS productunit,
    productioncountingquantitydto.plannedquantity,
    max(GREATEST(productioncountingquantitydto.producedquantity, (0)::numeric)) AS usedquantity,
    max(GREATEST((COALESCE(productioncountingquantitydto.plannedquantity, (0)::numeric) - COALESCE(productioncountingquantitydto.producedquantity, (0)::numeric)), (0)::numeric)) AS remainingquantity,
    max(ceil(((COALESCE(productioncountingquantitydto.producedquantity, (0)::numeric) * (100)::numeric) / productioncountingquantitydto.plannedquantity))) AS doneinpercentage,
    max(
        CASE
            WHEN (( SELECT basic_parameter.opertaskflagpercentexecutionwithcolor
               FROM public.basic_parameter
             LIMIT 1) AND ((operationaltask.type)::text = '02executionOperationInOrder'::text)) THEN (1)::numeric
            ELSE (0)::numeric
        END) AS opertaskflagpercentexecutionwithcolor,
    max((
        CASE
            WHEN (((COALESCE(productioncountingquantitydto.producedquantity, (0)::numeric) * (100)::numeric) / productioncountingquantitydto.plannedquantity) >= (100)::numeric) THEN 'green-cell'::character varying(255)
            WHEN (((COALESCE(productioncountingquantitydto.producedquantity, (0)::numeric) * (100)::numeric) / productioncountingquantitydto.plannedquantity) = (0)::numeric) THEN 'red-cell'::character varying(255)
            ELSE 'yellow-cell'::character varying(255)
        END)::text) AS percentageofexecutioncellcolor,
    (orderproduct.number)::text AS orderproductnumber,
    (orderproduct.name)::text AS orderproductname,
    operationaltask.actualstaff,
    sum((COALESCE(trackingoperationproductoutcomponent.wastesquantity, (0)::numeric))::numeric(14,5)) AS wastesquantity,
    (suborder.id)::integer AS suborder_id,
    (suborder.number)::text AS subordernumber,
    (count(workstationchangeoverforoperationaltask.id) <> 0) AS haschangeovers
   FROM ((((((((((((public.orders_operationaltask operationaltask
     LEFT JOIN public.orders_workstationchangeoverforoperationaltask workstationchangeoverforoperationaltask ON ((workstationchangeoverforoperationaltask.currentoperationaltask_id = operationaltask.id)))
     LEFT JOIN operational_task_staff ots ON ((operationaltask.id = ots.operationaltask_id)))
     LEFT JOIN public.basic_division division ON ((operationaltask.division_id = division.id)))
     LEFT JOIN public.basic_workstation workstation ON ((workstation.id = operationaltask.workstation_id)))
     LEFT JOIN public.orders_order ordersorder ON ((ordersorder.id = operationaltask.order_id)))
     LEFT JOIN public.technologies_technologyoperationcomponent technologyoperationcomponent ON ((technologyoperationcomponent.id = operationaltask.technologyoperationcomponent_id)))
     LEFT JOIN public.basic_product product ON ((product.id = operationaltask.product_id)))
     LEFT JOIN public.basic_product orderproduct ON ((orderproduct.id = ordersorder.product_id)))
     LEFT JOIN public.basicproductioncounting_productioncountingquantitydto productioncountingquantitydto ON (((productioncountingquantitydto.orderid = ordersorder.id) AND (productioncountingquantitydto.tocid = technologyoperationcomponent.id) AND ((productioncountingquantitydto.role)::text = '02produced'::text) AND (((productioncountingquantitydto.typeofmaterial)::text = '02intermediate'::text) OR ((productioncountingquantitydto.typeofmaterial)::text = '03finalProduct'::text)))))
     LEFT JOIN public.productioncounting_productiontracking productiontracking ON (((productiontracking.order_id = ordersorder.id) AND (productiontracking.technologyoperationcomponent_id = technologyoperationcomponent.id) AND ((productiontracking.state)::text = ('02accepted'::character varying)::text))))
     LEFT JOIN public.productioncounting_trackingoperationproductoutcomponent trackingoperationproductoutcomponent ON (((trackingoperationproductoutcomponent.productiontracking_id = productiontracking.id) AND (trackingoperationproductoutcomponent.product_id = product.id))))
     LEFT JOIN public.subcontractorportal_suborder suborder ON ((suborder.id = operationaltask.suborder_id)))
  WHERE ((operationaltask.type)::text = '02executionOperationInOrder'::text)
  GROUP BY operationaltask.id, operationaltask.number, operationaltask.name, operationaltask.description, operationaltask.type, operationaltask.state, operationaltask.startdate, operationaltask.finishdate, ots.staffname, division.number, ((workstation.id)::integer), workstation.number, ((ordersorder.id)::integer), ordersorder.number, ((technologyoperationcomponent.id)::integer), technologyoperationcomponent.nodenumber, technologyoperationcomponent.issubcontracting, (product.number)::text, (product.name)::text, (product.unit)::text, productioncountingquantitydto.plannedquantity, (orderproduct.number)::text, (orderproduct.name)::text, operationaltask.actualstaff, ((suborder.id)::integer), (suborder.number)::text;


--
-- Name: orders_operationaltaskwithcolordto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_operationaltaskwithcolordto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_order_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_order_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_order_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_order_id_seq OWNED BY public.orders_order.id;


--
-- Name: orders_order_pack_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_order_pack_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_orderattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_orderattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_orderattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_orderattachment_id_seq OWNED BY public.orders_orderattachment.id;


--
-- Name: orders_ordercategorycolor; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_ordercategorycolor (
    id bigint NOT NULL,
    parameter_id bigint,
    ordercategory character varying(255),
    color character varying(255)
);


--
-- Name: orders_ordercategorycolor_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_ordercategorycolor_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_ordercategorycolor_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_ordercategorycolor_id_seq OWNED BY public.orders_ordercategorycolor.id;


--
-- Name: orders_orderdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.orders_orderdto AS
 SELECT orders_order.id,
    orders_order.active,
    orders_order.number,
    orders_order.name,
    orders_order.state,
    orders_order.typeofproductionrecording,
    orders_order.plannedquantity
   FROM public.orders_order;


--
-- Name: orders_orderdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_orderdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_orderlistdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.orders_orderlistdto AS
 SELECT ordersorder.id,
    ordersorder.active,
    ordersorder.number,
    ordersorder.name,
    ordersorder.description,
    ordersorder.datefrom,
    ordersorder.dateto,
    ordersorder.startdate,
    ordersorder.finishdate,
    ordersorder.state,
    ordersorder.externalnumber,
    ordersorder.externalsynchronized,
    ordersorder.plannedquantity,
    ordersorder.donequantity,
    ordersorder.workplandelivered,
    ordersorder.deadline,
    ordersorder.ordercategory,
    ordersorder.typeofproductionrecording,
    COALESCE(ordersorder.plannedquantityforadditionalunit, ordersorder.plannedquantity) AS plannedquantityforadditionalunit,
    COALESCE(product.additionalunit, product.unit) AS unitforadditionalunit,
    product.number AS productnumber,
    product.name AS productname,
    ordersorder.additionalfinalproducts,
    technology.number AS technologynumber,
    product.unit,
    masterorder.number AS masterordernumber,
    division.name AS divisionname,
    company.name AS companyname,
    address.number AS addressnumber,
    masterorderdefinition.number AS masterorderdefinitionnumber,
        CASE
            WHEN (EXISTS ( SELECT repairoder.id
               FROM public.repairs_repairorder repairoder
              WHERE (repairoder.order_id = ordersorder.id))) THEN true
            ELSE false
        END AS existsrepairorders,
    (masterorder.id)::integer AS masterorderid,
    ordersgroup.number AS ordersgroupnumber,
    productionline.number AS productionlinenumber,
    ''::character varying(255) AS annotation,
    (product.id)::integer AS productid,
    ordersorder.reportedproductionquantity,
    (productionline.id)::integer AS productionlineid,
    (ordersorder.correcteddatefrom IS NOT NULL) AS datechange
   FROM (((((((((public.orders_order ordersorder
     JOIN public.basic_product product ON ((product.id = ordersorder.product_id)))
     LEFT JOIN public.technologies_technology technology ON ((technology.id = ordersorder.technology_id)))
     LEFT JOIN public.basic_company company ON ((company.id = ordersorder.company_id)))
     LEFT JOIN public.basic_address address ON ((address.id = ordersorder.address_id)))
     LEFT JOIN public.masterorders_masterorder masterorder ON ((masterorder.id = ordersorder.masterorder_id)))
     LEFT JOIN public.masterorders_masterorderdefinition masterorderdefinition ON ((masterorderdefinition.id = masterorder.masterorderdefinition_id)))
     LEFT JOIN public.ordersgroups_ordersgroup ordersgroup ON ((ordersorder.ordersgroup_id = ordersgroup.id)))
     LEFT JOIN public.basic_division division ON ((division.id = ordersorder.division_id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((productionline.id = ordersorder.productionline_id)));


--
-- Name: orders_orderlistdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_orderlistdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_orderpack; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_orderpack (
    id bigint NOT NULL,
    number character varying(255),
    order_id bigint,
    quantity numeric(12,5),
    state character varying(255) DEFAULT '01pending'::character varying
);


--
-- Name: orders_orderpack_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_orderpack_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_orderpack_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_orderpack_id_seq OWNED BY public.orders_orderpack.id;


--
-- Name: orders_orderpackdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.orders_orderpackdto AS
 SELECT oop.id,
    (o.id)::integer AS orderid,
    oop.number,
    o.number AS ordernumber,
    p.number AS orderproduct,
    o.state AS orderstate,
    s.number AS size,
    o.plannedquantity AS orderquantity,
    oop.quantity,
    p.unit,
    oop.state
   FROM (((public.orders_orderpack oop
     JOIN public.orders_order o ON ((o.id = oop.order_id)))
     JOIN public.basic_product p ON ((o.product_id = p.id)))
     LEFT JOIN public.basic_size s ON ((p.size_id = s.id)));


--
-- Name: orders_orderpackdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_orderpackdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_orderpackstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_orderpackstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    orderpack_id bigint,
    shift_id bigint
);


--
-- Name: orders_orderpackstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_orderpackstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_orderpackstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_orderpackstatechange_id_seq OWNED BY public.orders_orderpackstatechange.id;


--
-- Name: orders_orderplanninglistdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.orders_orderplanninglistdto AS
 WITH order_packs AS (
         SELECT order_1.id AS orderid,
            (count(pack.id) <> 0) AS haspacks
           FROM (public.orders_order order_1
             LEFT JOIN public.orders_orderpack pack ON ((pack.order_id = order_1.id)))
          GROUP BY order_1.id
        )
 SELECT ordersorder.id,
    ordersorder.active,
    ordersorder.number,
    ordersorder.name,
    ordersorder.additionalfinalproducts,
    ordersorder.datefrom,
    ordersorder.dateto,
    ordersorder.startdate,
    ordersorder.finishdate,
    ordersorder.state,
    ordersorder.externalnumber,
    ordersorder.externalsynchronized,
    ordersorder.plannedquantity,
    ordersorder.workplandelivered,
    ordersorder.ordercategory,
    COALESCE(ordersorder.amountofproductproduced, (0)::numeric) AS amountofproductproduced,
    COALESCE(ordersorder.wastesquantity, (0)::numeric) AS wastesquantity,
    GREATEST(COALESCE(ordersorder.remainingamountofproducttoproduce, (0)::numeric), (0)::numeric) AS remainingamountofproducttoproduce,
    product.number AS productnumber,
    technology.number AS technologynumber,
    product.unit,
    productionline.number AS productionlinenumber,
    masterorder.number AS masterordernumber,
    masterorder.name AS masterordername,
    masterorder.machinetype,
    division.name AS divisionname,
    division.number AS divisionnumber,
    COALESCE(ordersorder.plannedquantityforadditionalunit, ordersorder.plannedquantity) AS plannedquantityforadditionalunit,
    COALESCE(product.additionalunit, product.unit) AS unitforadditionalunit,
    company.number AS company,
    ordersorder.description,
    product.name AS productname,
    ''::character varying(255) AS annotation,
    ceil(((COALESCE(ordersorder.donequantity, (0)::numeric) * (100)::numeric) / NULLIF(ordersorder.plannedquantity, (0)::numeric))) AS doneinpercentage,
        CASE
            WHEN ( SELECT basic_parameter.flagpercentageofexecutionwithcolor
               FROM public.basic_parameter
             LIMIT 1) THEN (1)::numeric
            ELSE (0)::numeric
        END AS flagpercentageofexecutionwithcolor,
        CASE
            WHEN (((COALESCE(ordersorder.donequantity, (0)::numeric) * (100)::numeric) / NULLIF(ordersorder.plannedquantity, (0)::numeric)) >= (100)::numeric) THEN 'green-cell'::character varying(255)
            WHEN (((COALESCE(ordersorder.donequantity, (0)::numeric) * (100)::numeric) / NULLIF(ordersorder.plannedquantity, (0)::numeric)) = (0)::numeric) THEN 'red-cell'::character varying(255)
            ELSE 'yellow-cell'::character varying(255)
        END AS percentageofexecutioncellcolor,
    ordersorder.deadline,
    (date_part('day'::text, (date_trunc('day'::text, ordersorder.deadline) - (('now'::text)::date)::timestamp without time zone)))::integer AS daystodeadline,
    packs.haspacks,
    salesplan.number AS salesplannumber,
    ordersorder.priority,
    (ordersorder.correcteddatefrom IS NOT NULL) AS datechange
   FROM ((((((((public.orders_order ordersorder
     JOIN public.basic_product product ON ((product.id = ordersorder.product_id)))
     LEFT JOIN public.technologies_technology technology ON ((technology.id = ordersorder.technology_id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((productionline.id = ordersorder.productionline_id)))
     LEFT JOIN public.masterorders_masterorder masterorder ON ((masterorder.id = ordersorder.masterorder_id)))
     LEFT JOIN public.basic_division division ON ((division.id = ordersorder.division_id)))
     LEFT JOIN public.basic_company company ON ((company.id = ordersorder.company_id)))
     LEFT JOIN order_packs packs ON ((packs.orderid = ordersorder.id)))
     LEFT JOIN public.masterorders_salesplan salesplan ON ((salesplan.id = ordersorder.salesplan_id)));


--
-- Name: orders_orderplanninglistdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_orderplanninglistdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_orderstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_orderstatechange (
    id bigint NOT NULL,
    comment character varying(255),
    reasonrequired boolean DEFAULT false,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255) DEFAULT '01inProgress'::character varying,
    phase integer,
    worker character varying(255),
    order_id bigint,
    shift_id bigint,
    additionalinformation character varying(255),
    sourcecorrecteddatefrom timestamp without time zone,
    sourcecorrecteddateto timestamp without time zone,
    sourcestartdate timestamp without time zone,
    sourcefinishdate timestamp without time zone,
    targetcorrecteddatefrom timestamp without time zone,
    targetcorrecteddateto timestamp without time zone,
    targetstartdate timestamp without time zone,
    targetfinishdate timestamp without time zone,
    dateschanged boolean DEFAULT false,
    entityversion bigint DEFAULT 0
);


--
-- Name: orders_orderstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_orderstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_orderstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_orderstatechange_id_seq OWNED BY public.orders_orderstatechange.id;


--
-- Name: orders_ordertechnologicalprocess; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_ordertechnologicalprocess (
    id bigint NOT NULL,
    number character varying(255),
    orderpack_id bigint,
    order_id bigint,
    product_id bigint,
    operation_id bigint,
    technologicalprocess_id bigint,
    quantity numeric(12,5),
    worker_id bigint,
    date timestamp without time zone,
    wastesquantity numeric(12,5),
    technologyoperationcomponent_id bigint,
    createdate timestamp without time zone
);


--
-- Name: orders_ordertechnologicalprocess_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_ordertechnologicalprocess_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_ordertechnologicalprocess_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_ordertechnologicalprocess_id_seq OWNED BY public.orders_ordertechnologicalprocess.id;


--
-- Name: orders_ordertechnologicalprocess_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_ordertechnologicalprocess_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_ordertechnologicalprocesswaste; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_ordertechnologicalprocesswaste (
    id bigint NOT NULL,
    number character varying(255),
    ordertechnologicalprocess_id bigint,
    orderpack_id bigint,
    order_id bigint,
    product_id bigint,
    technologicalprocess_id bigint,
    wastequantity numeric(12,5),
    causeofwaste character varying(255),
    worker_id bigint,
    date timestamp without time zone,
    description character varying(2048)
);


--
-- Name: technologies_technologicalprocess; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.technologies_technologicalprocess (
    id bigint NOT NULL,
    name character varying(1024),
    workstationtype_id bigint,
    workstation_id bigint,
    tj integer DEFAULT 0,
    extendedtimeforsizegroup boolean DEFAULT false,
    increasepercent integer,
    sizegroup_id bigint,
    technologicalprocessrate_id bigint,
    tpz integer DEFAULT 0,
    additionaltime integer DEFAULT 0
);


--
-- Name: orders_ordertechnologicalprocessdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.orders_ordertechnologicalprocessdto AS
 WITH ordertechnologicalprocesswastes AS (
         SELECT ordertechnologicalprocesswaste.ordertechnologicalprocess_id,
            sum(ordertechnologicalprocesswaste.wastequantity) AS wastesquantity
           FROM public.orders_ordertechnologicalprocesswaste ordertechnologicalprocesswaste
          GROUP BY ordertechnologicalprocesswaste.ordertechnologicalprocess_id
        )
 SELECT ordertechnologicalprocess.id,
    ordertechnologicalprocess.number,
    (orderpack.id)::integer AS orderpackid,
    orderpack.number AS orderpacknumber,
    (ordersorder.id)::integer AS orderid,
    ordersorder.number AS ordernumber,
    ordersorder.startdate AS orderstartdate,
    (product.id)::integer AS productid,
    product.number AS productnumber,
    model.name AS modelname,
    size.number AS sizenumber,
    (operation.id)::integer AS operationid,
    operation.number AS operationnumber,
    technologyoperationcomponent.id AS technologyoperationcomponentid,
    technologyoperationcomponent.technologicalprocesslist_id AS technologicalprocesslistid,
    workstationtype.number AS workstationtypenumber,
    workstation.number AS workstationnumber,
    (technologicalprocess.id)::integer AS technologicalprocessid,
    technologicalprocess.name AS technologicalprocessname,
    technologicalprocess.technologicalprocessrate_id AS technologicalprocessrateid,
    ordertechnologicalprocess.quantity,
    product.unit AS productunit,
    (((staff.surname)::text || ' '::text) || (staff.name)::text) AS worker,
    ordertechnologicalprocess.createdate,
    ordertechnologicalprocess.date,
    COALESCE(ordertechnologicalprocesswastes.wastesquantity, (0)::numeric) AS wastesquantity
   FROM ((((((((((((public.orders_ordertechnologicalprocess ordertechnologicalprocess
     LEFT JOIN public.orders_orderpack orderpack ON ((orderpack.id = ordertechnologicalprocess.orderpack_id)))
     LEFT JOIN public.orders_order ordersorder ON ((ordersorder.id = ordertechnologicalprocess.order_id)))
     LEFT JOIN public.basic_product product ON ((product.id = ordertechnologicalprocess.product_id)))
     LEFT JOIN public.basic_model model ON ((model.id = product.model_id)))
     LEFT JOIN public.basic_size size ON ((size.id = product.size_id)))
     LEFT JOIN public.technologies_operation operation ON ((operation.id = ordertechnologicalprocess.operation_id)))
     LEFT JOIN public.technologies_technologyoperationcomponent technologyoperationcomponent ON ((technologyoperationcomponent.id = ordertechnologicalprocess.technologyoperationcomponent_id)))
     LEFT JOIN public.technologies_technologicalprocess technologicalprocess ON ((technologicalprocess.id = ordertechnologicalprocess.technologicalprocess_id)))
     LEFT JOIN public.basic_workstationtype workstationtype ON ((workstationtype.id = technologicalprocess.workstationtype_id)))
     LEFT JOIN public.basic_workstation workstation ON ((workstation.id = technologicalprocess.workstation_id)))
     LEFT JOIN public.basic_staff staff ON ((staff.id = ordertechnologicalprocess.worker_id)))
     LEFT JOIN ordertechnologicalprocesswastes ordertechnologicalprocesswastes ON ((ordertechnologicalprocesswastes.ordertechnologicalprocess_id = ordertechnologicalprocess.id)));


--
-- Name: orders_ordertechnologicalprocessdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_ordertechnologicalprocessdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_ordertechnologicalprocesspart; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_ordertechnologicalprocesspart (
    id bigint NOT NULL,
    number character varying(255),
    quantity numeric(12,5),
    ordertechnologicalprocess_id bigint
);


--
-- Name: orders_ordertechnologicalprocesspart_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_ordertechnologicalprocesspart_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_ordertechnologicalprocesspart_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_ordertechnologicalprocesspart_id_seq OWNED BY public.orders_ordertechnologicalprocesspart.id;


--
-- Name: orders_ordertechnologicalprocesswaste_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_ordertechnologicalprocesswaste_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_ordertechnologicalprocesswaste_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_ordertechnologicalprocesswaste_id_seq OWNED BY public.orders_ordertechnologicalprocesswaste.id;


--
-- Name: orders_ordertechnologicalprocesswaste_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_ordertechnologicalprocesswaste_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_ordertechnologicalprocesswastedto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.orders_ordertechnologicalprocesswastedto AS
 SELECT ordertechnologicalprocesswaste.id,
    ordertechnologicalprocesswaste.number,
    ordertechnologicalprocesswaste.date,
    (((staff.name)::text || ' '::text) || (staff.surname)::text) AS worker,
    ordertechnologicalprocesswaste.wastequantity,
    product.unit AS productunit,
    ordertechnologicalprocesswaste.causeofwaste,
    (orderpack.id)::integer AS orderpackid,
    orderpack.number AS orderpacknumber,
    (technologicalprocess.id)::integer AS technologicalprocessid,
    technologicalprocess.name AS technologicalprocessname,
    (ordersorder.id)::integer AS orderid,
    ordersorder.number AS ordernumber,
    (product.id)::integer AS productid,
    product.number AS productnumber,
    (ordertechnologicalprocess.id)::integer AS ordertechnologicalprocessid,
    ordertechnologicalprocess.number AS ordertechnologyprocessnumber,
    ordertechnologicalprocess.date AS ordertechnologicalprocessdate,
    (((orderstaff.name)::text || ' '::text) || (orderstaff.surname)::text) AS ordertechnologicalprocessworker
   FROM (((((((public.orders_ordertechnologicalprocesswaste ordertechnologicalprocesswaste
     LEFT JOIN public.basic_staff staff ON ((staff.id = ordertechnologicalprocesswaste.worker_id)))
     LEFT JOIN public.orders_orderpack orderpack ON ((orderpack.id = ordertechnologicalprocesswaste.orderpack_id)))
     LEFT JOIN public.technologies_technologicalprocess technologicalprocess ON ((technologicalprocess.id = ordertechnologicalprocesswaste.technologicalprocess_id)))
     LEFT JOIN public.orders_order ordersorder ON ((ordersorder.id = ordertechnologicalprocesswaste.order_id)))
     LEFT JOIN public.basic_product product ON ((product.id = ordertechnologicalprocesswaste.product_id)))
     LEFT JOIN public.orders_ordertechnologicalprocess ordertechnologicalprocess ON ((ordertechnologicalprocess.id = ordertechnologicalprocesswaste.ordertechnologicalprocess_id)))
     LEFT JOIN public.basic_staff orderstaff ON ((orderstaff.id = ordertechnologicalprocess.worker_id)));


--
-- Name: orders_ordertechnologicalprocesswastedto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_ordertechnologicalprocesswastedto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_prod_line_schedule_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_prod_line_schedule_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_productionlineschedule; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_productionlineschedule (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(255),
    starttime timestamp without time zone,
    state character varying(255) DEFAULT '01draft'::character varying,
    durationofordercalculatedonbasis character varying(255) DEFAULT '01timeConsumingTechnology'::character varying,
    sortorder character varying(255) DEFAULT '01longestOrders'::character varying,
    productionlineassigncriterion character varying(255) DEFAULT '01leastProductionLines'::character varying,
    approvetime timestamp without time zone,
    allowproductionlinechange boolean DEFAULT false
);


--
-- Name: orders_productionlineschedule_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_productionlineschedule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_productionlineschedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_productionlineschedule_id_seq OWNED BY public.orders_productionlineschedule.id;


--
-- Name: orders_productionlinescheduleposition; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_productionlinescheduleposition (
    id bigint NOT NULL,
    productionlineschedule_id bigint,
    order_id bigint,
    productionline_id bigint,
    linechangeovernorm_id bigint,
    starttime timestamp without time zone,
    endtime timestamp without time zone,
    additionaltime integer DEFAULT 0
);


--
-- Name: orders_productionlinescheduleposition_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_productionlinescheduleposition_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_productionlinescheduleposition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_productionlinescheduleposition_id_seq OWNED BY public.orders_productionlinescheduleposition.id;


--
-- Name: orders_productionlineschedulestatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_productionlineschedulestatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    productionlineschedule_id bigint,
    shift_id bigint
);


--
-- Name: orders_productionlineschedulestatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_productionlineschedulestatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_productionlineschedulestatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_productionlineschedulestatechange_id_seq OWNED BY public.orders_productionlineschedulestatechange.id;


--
-- Name: orders_reasontypecorrectiondatefrom; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_reasontypecorrectiondatefrom (
    id bigint NOT NULL,
    order_id bigint,
    reasontypeofchangingorderstate character varying(255),
    date timestamp without time zone,
    entityversion bigint DEFAULT 0,
    changedateshelper_id bigint
);


--
-- Name: orders_reasontypecorrectiondatefrom_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_reasontypecorrectiondatefrom_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_reasontypecorrectiondatefrom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_reasontypecorrectiondatefrom_id_seq OWNED BY public.orders_reasontypecorrectiondatefrom.id;


--
-- Name: orders_reasontypecorrectiondateto; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_reasontypecorrectiondateto (
    id bigint NOT NULL,
    order_id bigint,
    reasontypeofchangingorderstate character varying(255),
    date timestamp without time zone,
    entityversion bigint DEFAULT 0,
    changedateshelper_id bigint
);


--
-- Name: orders_reasontypecorrectiondateto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_reasontypecorrectiondateto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_reasontypecorrectiondateto_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_reasontypecorrectiondateto_id_seq OWNED BY public.orders_reasontypecorrectiondateto.id;


--
-- Name: orders_reasontypedeviationeffectiveend; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_reasontypedeviationeffectiveend (
    id bigint NOT NULL,
    order_id bigint,
    reasontypeofchangingorderstate character varying(255),
    date timestamp without time zone,
    entityversion bigint DEFAULT 0
);


--
-- Name: orders_reasontypedeviationeffectiveend_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_reasontypedeviationeffectiveend_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_reasontypedeviationeffectiveend_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_reasontypedeviationeffectiveend_id_seq OWNED BY public.orders_reasontypedeviationeffectiveend.id;


--
-- Name: orders_reasontypedeviationeffectivestart; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_reasontypedeviationeffectivestart (
    id bigint NOT NULL,
    order_id bigint,
    reasontypeofchangingorderstate character varying(255),
    date timestamp without time zone,
    entityversion bigint DEFAULT 0
);


--
-- Name: orders_reasontypedeviationeffectivestart_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_reasontypedeviationeffectivestart_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_reasontypedeviationeffectivestart_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_reasontypedeviationeffectivestart_id_seq OWNED BY public.orders_reasontypedeviationeffectivestart.id;


--
-- Name: orders_reasontypeofchangingorderstate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_reasontypeofchangingorderstate (
    id bigint NOT NULL,
    orderstatechange_id bigint,
    reasontypeofchangingorderstate character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: orders_reasontypeofchangingorderstate_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_reasontypeofchangingorderstate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_reasontypeofchangingorderstate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_reasontypeofchangingorderstate_id_seq OWNED BY public.orders_reasontypeofchangingorderstate.id;


--
-- Name: orders_schedule; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_schedule (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(255),
    starttime timestamp without time zone,
    state character varying(255) DEFAULT '01draft'::character varying,
    sortorder character varying(255) DEFAULT '01desc'::character varying,
    workstationassigncriterion character varying(255) DEFAULT '01shortestTime'::character varying,
    workerassigncriterion character varying(255) DEFAULT '01workstationLastOperatorLatestFinished'::character varying,
    approvetime timestamp without time zone,
    additionaltimeextendsoperation boolean DEFAULT true,
    includetpz boolean DEFAULT true,
    onlyworkstationsoflinefromorder boolean DEFAULT false,
    token character varying(36),
    plannerworkstationassigncriterion character varying(255) DEFAULT '01minDeadlineForOrder'::character varying,
    deadlinesort boolean DEFAULT true,
    operationlevelsort boolean DEFAULT true,
    orderprioritysort boolean DEFAULT false,
    abcanalysissort boolean DEFAULT false,
    includetpzchanged boolean DEFAULT false
);


--
-- Name: orders_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_schedule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_schedule_id_seq OWNED BY public.orders_schedule.id;


--
-- Name: orders_schedule_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_schedule_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_scheduleposition; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_scheduleposition (
    id bigint NOT NULL,
    schedule_id bigint,
    technologyoperationcomponent_id bigint,
    additionaltime integer DEFAULT 0,
    machineworktime integer DEFAULT 0,
    laborworktime integer DEFAULT 0,
    order_id bigint,
    product_id bigint,
    workstation_id bigint,
    quantity numeric(14,5),
    starttime timestamp without time zone,
    endtime timestamp without time zone,
    staff_id bigint,
    operationruns numeric(12,5),
    partialoperationruns numeric(12,5)
);


--
-- Name: orders_scheduleposition_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_scheduleposition_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_scheduleposition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_scheduleposition_id_seq OWNED BY public.orders_scheduleposition.id;


--
-- Name: orders_workstationchangeoverforscheduleposition; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_workstationchangeoverforscheduleposition (
    id bigint NOT NULL,
    currentscheduleposition_id bigint,
    previousscheduleposition_id bigint,
    previousoperationaltask_id bigint,
    workstationchangeovernorm_id bigint,
    startdate timestamp without time zone,
    finishdate timestamp without time zone
);


--
-- Name: orders_schedulepositiondto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.orders_schedulepositiondto AS
 SELECT scheduleposition.id,
    (schedule.id)::integer AS scheduleid,
    (((staff.surname)::text || ' '::text) || (staff.name)::text) AS staffname,
    workstation.number AS workstationnumber,
    technologyoperationcomponent.nodenumber,
    operation.name AS operationname,
    operation.number AS operationnumber,
    _order.number AS ordernumber,
    orderproduct.number AS orderproductnumber,
    _order.plannedquantity AS orderproductplanedquantity,
    product.name AS productname,
    product.number AS productnumber,
    product.unit AS productunit,
    scheduleposition.quantity,
    scheduleposition.additionaltime,
    scheduleposition.machineworktime,
    scheduleposition.laborworktime,
    scheduleposition.starttime,
    scheduleposition.endtime,
    (sum(date_part('epoch'::text, (wcsp.finishdate - wcsp.startdate))))::integer AS setuptime,
    _order.deadline AS orderdeadline,
    (scheduleposition.endtime > _order.deadline) AS endtimeafterorderdeadline
   FROM (((((((((public.orders_scheduleposition scheduleposition
     LEFT JOIN public.orders_schedule schedule ON ((schedule.id = scheduleposition.schedule_id)))
     LEFT JOIN public.orders_order _order ON ((_order.id = scheduleposition.order_id)))
     LEFT JOIN public.basic_product orderproduct ON ((orderproduct.id = _order.product_id)))
     LEFT JOIN public.basic_product product ON ((product.id = scheduleposition.product_id)))
     LEFT JOIN public.basic_staff staff ON ((staff.id = scheduleposition.staff_id)))
     LEFT JOIN public.technologies_technologyoperationcomponent technologyoperationcomponent ON ((technologyoperationcomponent.id = scheduleposition.technologyoperationcomponent_id)))
     LEFT JOIN public.technologies_operation operation ON ((operation.id = technologyoperationcomponent.operation_id)))
     LEFT JOIN public.basic_workstation workstation ON ((workstation.id = scheduleposition.workstation_id)))
     LEFT JOIN public.orders_workstationchangeoverforscheduleposition wcsp ON ((wcsp.currentscheduleposition_id = scheduleposition.id)))
  GROUP BY scheduleposition.id, ((schedule.id)::integer), (((staff.surname)::text || ' '::text) || (staff.name)::text), workstation.number, technologyoperationcomponent.nodenumber, operation.name, operation.number, _order.number, orderproduct.number, _order.plannedquantity, product.name, product.number, product.unit, scheduleposition.quantity, scheduleposition.additionaltime, scheduleposition.machineworktime, scheduleposition.laborworktime, scheduleposition.starttime, scheduleposition.endtime, _order.deadline, (scheduleposition.endtime > _order.deadline);


--
-- Name: orders_schedulepositiondto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_schedulepositiondto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_schedulestatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_schedulestatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    schedule_id bigint,
    shift_id bigint
);


--
-- Name: orders_schedulestatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_schedulestatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_schedulestatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_schedulestatechange_id_seq OWNED BY public.orders_schedulestatechange.id;


--
-- Name: orders_setcategory; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_setcategory (
    id bigint NOT NULL,
    ordercategory character varying(255)
);


--
-- Name: orders_setcategory_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_setcategory_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_setcategory_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_setcategory_id_seq OWNED BY public.orders_setcategory.id;


--
-- Name: orders_splitorderchild; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_splitorderchild (
    id bigint NOT NULL,
    splitorderparent_id bigint,
    number character varying(255),
    name character varying(1024),
    datefrom timestamp without time zone,
    dateto timestamp without time zone,
    plannedquantity numeric(12,5),
    unit character varying(255)
);


--
-- Name: orders_splitorderchild_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_splitorderchild_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_splitorderchild_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_splitorderchild_id_seq OWNED BY public.orders_splitorderchild.id;


--
-- Name: orders_splitorderhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_splitorderhelper (
    id bigint NOT NULL,
    datefrom timestamp without time zone,
    dateto timestamp without time zone,
    parts integer
);


--
-- Name: orders_splitorderhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_splitorderhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_splitorderhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_splitorderhelper_id_seq OWNED BY public.orders_splitorderhelper.id;


--
-- Name: orders_splitorderparent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_splitorderparent (
    id bigint NOT NULL,
    splitorderhelper_id bigint,
    order_id bigint,
    number character varying(255),
    name character varying(1024),
    datefrom timestamp without time zone,
    dateto timestamp without time zone,
    plannedquantity numeric(12,5),
    unit character varying(255)
);


--
-- Name: orders_splitorderparent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_splitorderparent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_splitorderparent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_splitorderparent_id_seq OWNED BY public.orders_splitorderparent.id;


--
-- Name: orders_typeofcorrectioncauses; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.orders_typeofcorrectioncauses (
    id bigint NOT NULL,
    order_id bigint,
    reasontype character varying(255),
    date timestamp without time zone,
    entityversion bigint DEFAULT 0
);


--
-- Name: orders_typeofcorrectioncauses_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_typeofcorrectioncauses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_typeofcorrectioncauses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_typeofcorrectioncauses_id_seq OWNED BY public.orders_typeofcorrectioncauses.id;


--
-- Name: orders_workstationchangeoverforoperationaltask_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_workstationchangeoverforoperationaltask_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_workstationchangeoverforoperationaltask_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_workstationchangeoverforoperationaltask_id_seq OWNED BY public.orders_workstationchangeoverforoperationaltask.id;


--
-- Name: orders_workstationchangeoverforoperationaltaskdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.orders_workstationchangeoverforoperationaltaskdto AS
 SELECT workstationchangeoverforoperationaltask.id,
    workstationchangeoverforoperationaltask.number,
    workstationchangeoverforoperationaltask.name,
    workstationchangeoverforoperationaltask.description,
    (workstation.id)::integer AS workstation_id,
    workstation.number AS workstationnumber,
    (currentoperationaltask.id)::integer AS currentoperationaltask_id,
    currentoperationaltask.number AS currentoperationaltasknumber,
    currentoperationaltask.name AS currentoperationaltaskname,
    (currentorder.id)::integer AS currentoperationaltaskorder_id,
    currentorder.number AS currentoperationaltaskordernumber,
    (currentproduct.id)::integer AS currentoperationaltaskorderproduct_id,
    currentproduct.number AS currentoperationaltaskorderproductnumber,
    (previousoperationaltask.id)::integer AS previousoperationaltask_id,
    previousoperationaltask.number AS previousoperationaltasknumber,
    previousoperationaltask.name AS previousoperationaltaskname,
    (previousorder.id)::integer AS previousoperationaltaskorder_id,
    previousorder.number AS previousoperationaltaskordernumber,
    (previousproduct.id)::integer AS previousoperationaltaskorderproduct_id,
    previousproduct.number AS previousoperationaltaskorderproductnumber,
    workstationchangeoverforoperationaltask.changeovertype,
    (attribute.id)::integer AS attribute_id,
    attribute.number AS attributenumber,
    fromattributevalue.value AS fromattributevaluevalue,
    toattributevalue.value AS toattributevaluevalue,
    workstationchangeoverforoperationaltask.startdate,
    workstationchangeoverforoperationaltask.finishdate,
    workstationchangeoverforoperationaltask.duration,
    workstationchangeoverforoperationaltask.isparallel
   FROM ((((((((((public.orders_workstationchangeoverforoperationaltask workstationchangeoverforoperationaltask
     LEFT JOIN public.basic_workstation workstation ON ((workstation.id = workstationchangeoverforoperationaltask.workstation_id)))
     LEFT JOIN public.orders_operationaltask currentoperationaltask ON ((currentoperationaltask.id = workstationchangeoverforoperationaltask.currentoperationaltask_id)))
     LEFT JOIN public.orders_order currentorder ON ((currentorder.id = currentoperationaltask.order_id)))
     LEFT JOIN public.basic_product currentproduct ON ((currentproduct.id = currentorder.product_id)))
     LEFT JOIN public.orders_operationaltask previousoperationaltask ON ((previousoperationaltask.id = workstationchangeoverforoperationaltask.previousoperationaltask_id)))
     LEFT JOIN public.orders_order previousorder ON ((previousorder.id = previousoperationaltask.order_id)))
     LEFT JOIN public.basic_product previousproduct ON ((previousproduct.id = previousorder.product_id)))
     LEFT JOIN public.basic_attribute attribute ON ((attribute.id = workstationchangeoverforoperationaltask.attribute_id)))
     LEFT JOIN public.basic_attributevalue fromattributevalue ON ((fromattributevalue.id = workstationchangeoverforoperationaltask.fromattributevalue_id)))
     LEFT JOIN public.basic_attributevalue toattributevalue ON ((toattributevalue.id = workstationchangeoverforoperationaltask.toattributevalue_id)));


--
-- Name: orders_workstationchangeoverforoperationaltaskdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_workstationchangeoverforoperationaltaskdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_workstationchangeoverforscheduleposition_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.orders_workstationchangeoverforscheduleposition_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: orders_workstationchangeoverforscheduleposition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.orders_workstationchangeoverforscheduleposition_id_seq OWNED BY public.orders_workstationchangeoverforscheduleposition.id;


--
-- Name: ordersforsubproductsgeneration_relatedorderdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.ordersforsubproductsgeneration_relatedorderdto AS
 SELECT o.id,
    o.number,
    o.name,
    p.number AS productnumber,
    o.plannedquantity,
    COALESCE(o.amountofproductproduced, (0)::numeric) AS producedquantity,
    o.datefrom,
    o.dateto,
    COALESCE(pl.number, ''::character varying(255)) AS productionlinenumber,
    o.state,
    (o.root_id)::integer AS rootid,
    COALESCE(o.level, 0) AS level,
    NULL::bigint AS order_id
   FROM ((public.orders_order o
     JOIN public.basic_product p ON ((p.id = o.product_id)))
     LEFT JOIN public.productionlines_productionline pl ON ((pl.id = o.productionline_id)));


--
-- Name: ordersforsubproductsgeneration_relatedorderdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersforsubproductsgeneration_relatedorderdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersforsubproductsgeneration_suborders; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersforsubproductsgeneration_suborders (
    id bigint NOT NULL,
    order_id bigint,
    ordersgroup_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    ordersgroupsgenerated boolean DEFAULT false,
    generatedorders boolean DEFAULT false,
    ordergenerationinprogress boolean DEFAULT false
);


--
-- Name: ordersforsubproductsgeneration_suborders_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersforsubproductsgeneration_suborders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersforsubproductsgeneration_suborders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersforsubproductsgeneration_suborders_id_seq OWNED BY public.ordersforsubproductsgeneration_suborders.id;


--
-- Name: ordersgantt_ordersganttparameters; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersgantt_ordersganttparameters (
    id bigint NOT NULL,
    datasource character varying(255) DEFAULT '01orders'::character varying,
    manualwritingplan boolean DEFAULT true,
    calculateorderstime boolean DEFAULT true,
    detectcollisions boolean DEFAULT false,
    donotletcollisions boolean DEFAULT false,
    changeovernormsfrom character varying(255) DEFAULT '01lack'::character varying,
    typeofsave character varying(255) DEFAULT '01saveOnly'::character varying
);


--
-- Name: ordersgantt_ordersganttparameters_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersgantt_ordersganttparameters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersgantt_ordersganttparameters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersgantt_ordersganttparameters_id_seq OWNED BY public.ordersgantt_ordersganttparameters.id;


--
-- Name: ordersgroups_drafrptquantitydto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.ordersgroups_drafrptquantitydto AS
SELECT
    NULL::bigint AS id,
    NULL::character varying(255) AS number,
    NULL::numeric AS sum;


--
-- Name: ordersgroups_drafrptquantitydto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersgroups_drafrptquantitydto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: technologies_productionlinetechnologygroup; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.technologies_productionlinetechnologygroup (
    id bigint NOT NULL,
    technologygroup_id bigint,
    productionline_id bigint
);


--
-- Name: ordersgroups_ordersgroupdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.ordersgroups_ordersgroupdto AS
 WITH technology_group_numbers AS (
         SELECT o.ordersgroup_id,
            string_agg(DISTINCT (tg.number)::text, ', '::text) AS number
           FROM ((public.orders_order o
             JOIN public.technologies_technology t ON ((o.technology_id = t.id)))
             JOIN public.technologies_technologygroup tg ON ((t.technologygroup_id = tg.id)))
          WHERE (o.ordersgroup_id IS NOT NULL)
          GROUP BY o.ordersgroup_id
        ), performance AS (
         SELECT o.ordersgroup_id,
            first_value(tpl.standardperformance) OVER (PARTITION BY o.ordersgroup_id ORDER BY o.id) AS performancenorm
           FROM (public.orders_order o
             LEFT JOIN public.technologies_technologyproductionline tpl ON (((tpl.technology_id = o.technology_id) AND tpl.master)))
        )
 SELECT DISTINCT ordersgroup.id,
    ordersgroup.active,
    ordersgroup.number,
    assortment.name AS assortmentname,
    productionline.number AS productionlinenumber,
    ordersgroup.startdate,
    ordersgroup.finishdate,
    ordersgroup.deadline,
    ordersgroup.quantity,
    ordersgroup.producedquantity,
    ordersgroup.remainingquantity,
    ordersgroup.state,
    company.number AS company,
    ordersgroup.remainingquantityinorders,
    (COALESCE(ordersgroup.producedquantity, (0)::numeric) + COALESCE(drafrptquantity.sum, (0)::numeric)) AS producedquantitywithdraft,
    (COALESCE(ordersgroup.remainingquantityinorders, (0)::numeric) - COALESCE(drafrptquantity.sum, (0)::numeric)) AS remainingquantityinorderswithdraft,
    tgn.number AS technologygroup,
    p.performancenorm,
    (masterorder.deadline)::date AS clientdate,
    masterorder.number AS masterordernumber,
    salesplan.number AS salesplannumber,
    salesplan.name AS salesplanname,
    ( SELECT (count(productionlinetechnologygroup.id) <> 0)
           FROM (public.technologies_productionlinetechnologygroup productionlinetechnologygroup
             LEFT JOIN public.technologies_technologygroup technologygroup ON ((productionlinetechnologygroup.technologygroup_id = technologygroup.id)))
          WHERE ((productionlinetechnologygroup.productionline_id = ordersgroup.productionline_id) AND ((tgn.number ~~ (('%'::text || (technologygroup.number)::text) || '%'::text)) OR ((tgn.number IS NULL) AND (productionlinetechnologygroup.technologygroup_id IS NULL))))) AS materials,
    masterorder.id AS masterorderid,
    ordersgroup.description
   FROM ((((((((public.ordersgroups_ordersgroup ordersgroup
     LEFT JOIN public.basic_assortment assortment ON ((ordersgroup.assortment_id = assortment.id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((ordersgroup.productionline_id = productionline.id)))
     LEFT JOIN public.masterorders_masterorder masterorder ON ((ordersgroup.masterorder_id = masterorder.id)))
     LEFT JOIN public.masterorders_salesplan salesplan ON ((salesplan.id = ordersgroup.salesplan_id)))
     LEFT JOIN public.basic_company company ON ((company.id = masterorder.company_id)))
     LEFT JOIN public.ordersgroups_drafrptquantitydto drafrptquantity ON ((ordersgroup.id = drafrptquantity.id)))
     LEFT JOIN technology_group_numbers tgn ON ((tgn.ordersgroup_id = ordersgroup.id)))
     LEFT JOIN performance p ON ((p.ordersgroup_id = ordersgroup.id)));


--
-- Name: ordersgroups_masterordergroupswithmaterials; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.ordersgroups_masterordergroupswithmaterials AS
 SELECT mo.id AS master_order_id,
    ( SELECT count(gro.id) AS count
           FROM public.ordersgroups_ordersgroupdto gro
          WHERE ((gro.masterorderid = mo.id) AND (gro.materials = true))) AS groupswithmaterials,
    ( SELECT count(gro.id) AS count
           FROM public.ordersgroups_ordersgroupdto gro
          WHERE ((gro.masterorderid = mo.id) AND (gro.materials = true) AND (gro.remainingquantityinorderswithdraft = (0)::numeric))) AS groupswithmaterialsdone
   FROM public.masterorders_masterorder mo
  WHERE ((mo.materialsissued = false) AND ((mo.state)::text = ANY (ARRAY[('01new'::character varying)::text, ('02inExecution'::character varying)::text])));


--
-- Name: ordersgroups_ordersgroup_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersgroups_ordersgroup_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersgroups_ordersgroup_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersgroups_ordersgroup_id_seq OWNED BY public.ordersgroups_ordersgroup.id;


--
-- Name: ordersgroups_ordersgroupdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersgroups_ordersgroupdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersgroups_ordersgroupissuedmaterial; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersgroups_ordersgroupissuedmaterial (
    id bigint NOT NULL,
    ordersgroup_id bigint,
    product_id bigint,
    quantity numeric(14,5),
    value numeric(14,5),
    averageprice numeric(11,2)
);


--
-- Name: ordersgroups_ordersgroupissuedmaterial_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersgroups_ordersgroupissuedmaterial_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersgroups_ordersgroupissuedmaterial_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersgroups_ordersgroupissuedmaterial_id_seq OWNED BY public.ordersgroups_ordersgroupissuedmaterial.id;


--
-- Name: ordersgroups_ordersgroupissuedmaterialposition; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersgroups_ordersgroupissuedmaterialposition (
    id bigint NOT NULL,
    ordersgroupissuedmaterial_id bigint,
    documentnumber character varying(255),
    quantity numeric(14,5),
    price numeric(14,5),
    value numeric(14,5),
    externaldocumentid character varying(255)
);


--
-- Name: ordersgroups_ordersgroupissuedmaterialposition_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersgroups_ordersgroupissuedmaterialposition_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersgroups_ordersgroupissuedmaterialposition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersgroups_ordersgroupissuedmaterialposition_id_seq OWNED BY public.ordersgroups_ordersgroupissuedmaterialposition.id;


--
-- Name: ordersgroups_ordersgroupmaterialrequirement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersgroups_ordersgroupmaterialrequirement (
    id bigint NOT NULL,
    number character varying(256),
    ordersgroup_id bigint,
    generated boolean,
    worker character varying(255),
    date timestamp without time zone,
    filename character varying(255)
);


--
-- Name: ordersgroups_ordersgroupmaterialrequirement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersgroups_ordersgroupmaterialrequirement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersgroups_ordersgroupmaterialrequirement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersgroups_ordersgroupmaterialrequirement_id_seq OWNED BY public.ordersgroups_ordersgroupmaterialrequirement.id;


--
-- Name: ordersgroups_ordersgroupmaterialrequirementproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersgroups_ordersgroupmaterialrequirementproduct (
    id bigint NOT NULL,
    ordersgroupmaterialrequirement_id bigint,
    product_id bigint,
    quantity numeric(14,5),
    currentstock numeric(14,5),
    technologyinputproducttype_id bigint,
    orderstartdate date,
    division_id bigint,
    location_id bigint,
    issuedquantity numeric(14,5),
    supplier_id bigint
);


--
-- Name: ordersgroups_ordersgroupmaterialrequirementproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersgroups_ordersgroupmaterialrequirementproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersgroups_ordersgroupmaterialrequirementproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersgroups_ordersgroupmaterialrequirementproduct_id_seq OWNED BY public.ordersgroups_ordersgroupmaterialrequirementproduct.id;


--
-- Name: ordersgroups_ordersgroupproducedproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersgroups_ordersgroupproducedproduct (
    id bigint NOT NULL,
    ordersgroup_id bigint,
    product_id bigint,
    location_id bigint,
    document_id bigint,
    quantity numeric(14,5),
    accepted boolean DEFAULT false,
    externaldocumentnumber character varying(255),
    batch_id bigint,
    storagelocation_id bigint,
    palletnumber_id bigint,
    typeofpallet character varying(255)
);


--
-- Name: ordersgroups_ordersgroupproducedproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersgroups_ordersgroupproducedproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersgroups_ordersgroupproducedproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersgroups_ordersgroupproducedproduct_id_seq OWNED BY public.ordersgroups_ordersgroupproducedproduct.id;


--
-- Name: ordersgroups_ordersgroupproductstoissueentryhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersgroups_ordersgroupproductstoissueentryhelper (
    id bigint NOT NULL,
    ordersgroupmaterialrequirementproduct_id bigint,
    ordersgroupproductstoissuehelper_id bigint,
    quantity numeric(12,5)
);


--
-- Name: ordersgroups_ordersgroupproductstoissueentryhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersgroups_ordersgroupproductstoissueentryhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersgroups_ordersgroupproductstoissueentryhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersgroups_ordersgroupproductstoissueentryhelper_id_seq OWNED BY public.ordersgroups_ordersgroupproductstoissueentryhelper.id;


--
-- Name: ordersgroups_ordersgroupproductstoissuehelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersgroups_ordersgroupproductstoissuehelper (
    id bigint NOT NULL,
    ordersgroupmaterialrequirement_id bigint
);


--
-- Name: ordersgroups_ordersgroupproductstoissuehelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersgroups_ordersgroupproductstoissuehelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersgroups_ordersgroupproductstoissuehelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersgroups_ordersgroupproductstoissuehelper_id_seq OWNED BY public.ordersgroups_ordersgroupproductstoissuehelper.id;


--
-- Name: ordersgroups_plannedworkingtimeanalysisdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.ordersgroups_plannedworkingtimeanalysisdto AS
 SELECT DISTINCT ordersgroup.id,
    ordersgroup.active,
    company.number AS company,
    productionline.number AS productionlinenumber,
    assortment.name AS assortmentname,
    ordersgroup.number,
    ordersgroup.quantity,
    first_value(product.unit) OVER (PARTITION BY ordersgroup.id ORDER BY ordersorder.id) AS unit,
    first_value(tpl.standardperformance) OVER (PARTITION BY ordersgroup.id ORDER BY ordersorder.id) AS performancenorm,
    public.duration_to_string((((ordersgroup.quantity * (60)::numeric) / first_value(tpl.standardperformance) OVER (PARTITION BY ordersgroup.id ORDER BY ordersorder.id)))::integer) AS timebasedonnorms,
    ((((ordersgroup.quantity * (60)::numeric) / first_value(tpl.standardperformance) OVER (PARTITION BY ordersgroup.id ORDER BY ordersorder.id)) / (((8 * 60) * 60))::numeric))::numeric(14,1) AS shiftquantity,
    ordersgroup.startdate,
    ordersgroup.finishdate,
    masterorder.deadline,
    first_value(tcontext.number) OVER (PARTITION BY ordersgroup.id ORDER BY ordersorder.id) AS generatorname
   FROM (((((((((public.ordersgroups_ordersgroup ordersgroup
     JOIN public.basic_assortment assortment ON ((ordersgroup.assortment_id = assortment.id)))
     JOIN public.productionlines_productionline productionline ON ((ordersgroup.productionline_id = productionline.id)))
     JOIN public.masterorders_masterorder masterorder ON ((ordersgroup.masterorder_id = masterorder.id)))
     LEFT JOIN public.basic_company company ON ((company.id = masterorder.company_id)))
     LEFT JOIN public.orders_order ordersorder ON ((ordersorder.ordersgroup_id = ordersgroup.id)))
     LEFT JOIN public.basic_product product ON ((ordersorder.product_id = product.id)))
     LEFT JOIN public.technologies_technology technologyprototype ON ((ordersorder.technology_id = technologyprototype.id)))
     LEFT JOIN public.technologiesgenerator_generatorcontext tcontext ON ((tcontext.id = technologyprototype.generatorcontext_id)))
     LEFT JOIN public.technologies_technologyproductionline tpl ON (((tpl.technology_id = ordersorder.technology_id) AND tpl.master)))
  WHERE (((ordersgroup.state)::text = ANY (ARRAY[('01draft'::character varying)::text, ('02inProgress'::character varying)::text])) AND (ordersorder.remainingamountofproducttoproduce <> (0)::numeric))
UNION ALL
 SELECT DISTINCT ordersgroup.id,
    ordersgroup.active,
    company.number AS company,
    productionline.number AS productionlinenumber,
    assortment.name AS assortmentname,
    ordersgroup.number,
    ordersgroup.quantity,
    first_value(product.unit) OVER (PARTITION BY ordersgroup.id ORDER BY ordersorder.id) AS unit,
    first_value(tpl.standardperformance) OVER (PARTITION BY ordersgroup.id ORDER BY ordersorder.id) AS performancenorm,
    public.duration_to_string((((ordersgroup.quantity * (60)::numeric) / first_value(tpl.standardperformance) OVER (PARTITION BY ordersgroup.id ORDER BY ordersorder.id)))::integer) AS timebasedonnorms,
    ((((ordersgroup.quantity * (60)::numeric) / first_value(tpl.standardperformance) OVER (PARTITION BY ordersgroup.id ORDER BY ordersorder.id)) / (((8 * 60) * 60))::numeric))::numeric(14,1) AS shiftquantity,
    ordersgroup.startdate,
    ordersgroup.finishdate,
    masterorder.deadline,
    first_value(tcontext.number) OVER (PARTITION BY ordersgroup.id ORDER BY ordersorder.id) AS generatorname
   FROM (((((((((public.arch_ordersgroups_ordersgroup ordersgroup
     JOIN public.basic_assortment assortment ON ((ordersgroup.assortment_id = assortment.id)))
     JOIN public.productionlines_productionline productionline ON ((ordersgroup.productionline_id = productionline.id)))
     JOIN public.arch_masterorders_masterorder masterorder ON ((ordersgroup.masterorder_id = masterorder.id)))
     LEFT JOIN public.basic_company company ON ((company.id = masterorder.company_id)))
     LEFT JOIN public.orders_order ordersorder ON ((ordersorder.ordersgroup_id = ordersgroup.id)))
     LEFT JOIN public.basic_product product ON ((ordersorder.product_id = product.id)))
     LEFT JOIN public.technologies_technology technologyprototype ON ((ordersorder.technology_id = technologyprototype.id)))
     LEFT JOIN public.technologiesgenerator_generatorcontext tcontext ON ((tcontext.id = technologyprototype.generatorcontext_id)))
     LEFT JOIN public.technologies_technologyproductionline tpl ON (((tpl.technology_id = ordersorder.technology_id) AND tpl.master)))
  WHERE (((ordersgroup.state)::text = ANY (ARRAY[('01draft'::character varying)::text, ('02inProgress'::character varying)::text])) AND (ordersorder.remainingamountofproducttoproduce <> (0)::numeric));


--
-- Name: ordersgroups_plannedworkingtimeanalysisdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersgroups_plannedworkingtimeanalysisdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersgroups_productionbalance; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersgroups_productionbalance (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(255),
    generated boolean,
    worker character varying(255),
    date timestamp without time zone,
    filename character varying(255),
    ordersgroup_id bigint,
    plannedmaterialcost character varying(255) DEFAULT '01nominal'::character varying,
    usenominalcostpricenotspecified boolean DEFAULT false,
    realmaterialcost character varying(255) DEFAULT '01ordersgroupsdocuments'::character varying,
    orderedquantity numeric(14,5),
    producedquantity numeric(14,5),
    quantitydeviation numeric(14,5),
    plannedcost numeric(14,5),
    realcost numeric(14,5),
    costdeviation numeric(14,5),
    active boolean DEFAULT true
);


--
-- Name: ordersgroups_productionbalance_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersgroups_productionbalance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersgroups_productionbalance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersgroups_productionbalance_id_seq OWNED BY public.ordersgroups_productionbalance.id;


--
-- Name: ordersgroups_sizegroupcolor; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersgroups_sizegroupcolor (
    id bigint NOT NULL,
    parameter_id bigint,
    sizegroup_id bigint,
    color character varying(255),
    succession integer
);


--
-- Name: ordersgroups_sizegroupcolor_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersgroups_sizegroupcolor_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersgroups_sizegroupcolor_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersgroups_sizegroupcolor_id_seq OWNED BY public.ordersgroups_sizegroupcolor.id;


--
-- Name: ordersupplies_columnforcoverages; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersupplies_columnforcoverages (
    id bigint NOT NULL,
    identifier character varying(255),
    name character varying(1024),
    description character varying(1024),
    columnfiller character varying(255),
    alignment character varying(255) DEFAULT '01left'::character varying,
    succession integer,
    entityversion bigint DEFAULT 0
);


--
-- Name: ordersupplies_columnforcoverages_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersupplies_columnforcoverages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersupplies_columnforcoverages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersupplies_columnforcoverages_id_seq OWNED BY public.ordersupplies_columnforcoverages.id;


--
-- Name: ordersupplies_coverageanalysisfororder; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersupplies_coverageanalysisfororder (
    id bigint NOT NULL,
    order_id bigint,
    orderedproduct_id bigint,
    plannedquantity numeric(16,5),
    coveragedegree character varying(255),
    coveredfromtheday timestamp without time zone,
    deliverytime timestamp without time zone,
    componentsproductiondate timestamp without time zone,
    materialrequirementcoverage_id bigint
);


--
-- Name: ordersupplies_coverageanalysisfororder_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersupplies_coverageanalysisfororder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersupplies_coverageanalysisfororder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersupplies_coverageanalysisfororder_id_seq OWNED BY public.ordersupplies_coverageanalysisfororder.id;


--
-- Name: ordersupplies_coverageanalysisfororderdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.ordersupplies_coverageanalysisfororderdto AS
 SELECT cafo.id,
    cafo.componentsproductiondate,
    cafo.coveragedegree,
    cafo.coveredfromtheday,
    cafo.deliverytime,
    cafo.plannedquantity,
    op.number AS orderedproductnumber,
    op.name AS orderedproductname,
    op.unit AS orderedproductunit,
    o.name AS ordername,
    o.number AS ordernumber,
    o.startdate AS orderstartdate,
    o.finishdate AS orderfinishdate,
    (cafo.materialrequirementcoverage_id)::integer AS materialrequirementcoverageid
   FROM ((public.ordersupplies_coverageanalysisfororder cafo
     LEFT JOIN public.basic_product op ON ((op.id = cafo.orderedproduct_id)))
     LEFT JOIN public.orders_order o ON ((o.id = cafo.order_id)));


--
-- Name: ordersupplies_coverageanalysisfororderdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersupplies_coverageanalysisfororderdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersupplies_coveragelocation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersupplies_coveragelocation (
    id bigint NOT NULL,
    materialrequirementcoverage_id bigint,
    location_id bigint,
    parameter_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: ordersupplies_coveragelocation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersupplies_coveragelocation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersupplies_coveragelocation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersupplies_coveragelocation_id_seq OWNED BY public.ordersupplies_coveragelocation.id;


--
-- Name: ordersupplies_coverageorderstate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersupplies_coverageorderstate (
    id bigint NOT NULL,
    materialrequirementcoverage_id bigint,
    parameter_id bigint,
    state character varying(255)
);


--
-- Name: ordersupplies_coverageorderstate_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersupplies_coverageorderstate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersupplies_coverageorderstate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersupplies_coverageorderstate_id_seq OWNED BY public.ordersupplies_coverageorderstate.id;


--
-- Name: ordersupplies_coverageproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersupplies_coverageproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersupplies_coverageproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersupplies_coverageproduct (
    id bigint DEFAULT nextval('public.ordersupplies_coverageproduct_id_seq'::regclass) NOT NULL,
    materialrequirementcoverage_id bigint,
    product_id bigint,
    lackfromdate timestamp without time zone,
    demandquantity numeric(16,5),
    coveredquantity numeric(16,5),
    reservemissingquantity numeric(16,5),
    deliveredquantity numeric(16,5),
    locationsquantity numeric(16,5),
    state character varying(255),
    issubcontracted boolean DEFAULT false,
    ispurchased boolean DEFAULT false,
    productnumber character varying(255),
    productname character varying(1024),
    productunit character varying(255),
    producttype character varying(255),
    planedquantity numeric(16,5),
    producequantity numeric(16,5),
    fromselectedorder boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    company_id bigint,
    price numeric(12,5)
);


--
-- Name: ordersupplies_coverageproductdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.ordersupplies_coverageproductdto AS
 SELECT coverageproduct.id,
    (coverageproduct.materialrequirementcoverage_id)::integer AS materialrequirementcoverageid,
    (coverageproduct.product_id)::integer AS productid,
    coverageproduct.lackfromdate,
    coverageproduct.demandquantity,
    coverageproduct.coveredquantity,
    coverageproduct.reservemissingquantity,
    coverageproduct.deliveredquantity,
    coverageproduct.locationsquantity,
    coverageproduct.state,
    coverageproduct.issubcontracted,
    coverageproduct.ispurchased,
    coverageproduct.productnumber,
    coverageproduct.productname,
    _parent.name AS productparent,
    coverageproduct.productunit,
    coverageproduct.producttype,
    coverageproduct.planedquantity,
    coverageproduct.producequantity,
    coverageproduct.fromselectedorder,
    coverageproduct.entityversion,
    (coverageproduct.company_id)::integer AS companyid,
    _company.name AS companyname,
        CASE
            WHEN (( SELECT count(*) AS count
               FROM public.basic_substitutecomponent
              WHERE (basic_substitutecomponent.baseproduct_id = _product.id)) > 0) THEN true
            ELSE false
        END AS replacement,
    COALESCE(bufferfordeliverytimes_product.bufferfordeliverytimes, bufferfordeliverytimes_family.bufferfordeliverytimesfamily, _company.buffer) AS deliverybuffer,
    (coverageproduct.lackfromdate - make_interval(days => COALESCE(bufferfordeliverytimes_product.bufferfordeliverytimes, bufferfordeliverytimes_family.bufferfordeliverytimesfamily, _company.buffer))) AS orderatlatest,
    coverageproduct.price,
    (coverageproduct.demandquantity * coverageproduct.price) AS value
   FROM (((((public.ordersupplies_coverageproduct coverageproduct
     JOIN public.basic_product _product ON ((_product.id = coverageproduct.product_id)))
     LEFT JOIN public.basic_product _parent ON ((_parent.id = _product.parent_id)))
     LEFT JOIN public.basic_company _company ON ((_company.id = coverageproduct.company_id)))
     LEFT JOIN public.deliveries_bufferfordeliverytimes_product bufferfordeliverytimes_product ON (((bufferfordeliverytimes_product.product_id = _product.id) AND (bufferfordeliverytimes_product.company_id = _company.id))))
     LEFT JOIN public.deliveries_bufferfordeliverytimes_family bufferfordeliverytimes_family ON (((bufferfordeliverytimes_family.product_id = _product.id) AND (bufferfordeliverytimes_family.company_id = _company.id))));


--
-- Name: ordersupplies_coverageproductdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersupplies_coverageproductdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersupplies_coverageproductgenerated; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersupplies_coverageproductgenerated (
    id bigint NOT NULL,
    productid integer,
    entityversion bigint DEFAULT 0
);


--
-- Name: ordersupplies_coverageproductgenerated_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersupplies_coverageproductgenerated_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersupplies_coverageproductgenerated_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersupplies_coverageproductgenerated_id_seq OWNED BY public.ordersupplies_coverageproductgenerated.id;


--
-- Name: ordersupplies_coverageproductlogging_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersupplies_coverageproductlogging_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersupplies_coverageproductlogging; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersupplies_coverageproductlogging (
    id bigint DEFAULT nextval('public.ordersupplies_coverageproductlogging_id_seq'::regclass) NOT NULL,
    coverageproduct_id bigint,
    date timestamp without time zone,
    delivery_id bigint,
    order_id bigint,
    operation_id bigint,
    reservemissingquantity numeric(16,5),
    changes numeric(16,5),
    eventtype character varying(255),
    state character varying(255),
    subcontractedoperation_id bigint,
    deliverynumberexternal character varying(255),
    warehousenumber character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: ordersupplies_coverageproductselected; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersupplies_coverageproductselected (
    id bigint NOT NULL,
    coverageproduct_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: ordersupplies_coverageproductselected_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersupplies_coverageproductselected_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersupplies_coverageproductselected_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersupplies_coverageproductselected_id_seq OWNED BY public.ordersupplies_coverageproductselected.id;


--
-- Name: ordersupplies_coverageproducttypedto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.ordersupplies_coverageproducttypedto AS
 SELECT prod.id AS productid,
    tech.id AS technologyid,
    '02intermediate'::text AS producttype
   FROM (public.basic_product prod
     LEFT JOIN public.technologies_technology tech ON ((tech.product_id = prod.id)))
  WHERE ((tech.technologytype IS NULL) AND ((tech.state)::text = '02accepted'::text) AND (tech.master = true));


--
-- Name: ordersupplies_materialrequirementcoverage; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ordersupplies_materialrequirementcoverage (
    id bigint NOT NULL,
    number character varying(255),
    coveragetodate timestamp without time zone,
    actualdate timestamp without time zone,
    generateddate timestamp without time zone,
    generatedby character varying(255),
    generated boolean,
    saved boolean,
    coveragetype character varying(255),
    includedraftdeliveries boolean,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    filename character varying(1024),
    automaticsavecoverage boolean DEFAULT false,
    order_id bigint,
    entityversion bigint DEFAULT 0,
    ordergenerationinprogress boolean DEFAULT false,
    forordersgroup_id bigint,
    ordersgroupsgenerated boolean DEFAULT false,
    includeincalculationdeliveries character varying(255) DEFAULT '01confirmedDeliveries'::character varying
);


--
-- Name: ordersupplies_materialrequirementcoverage_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersupplies_materialrequirementcoverage_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersupplies_materialrequirementcoverage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ordersupplies_materialrequirementcoverage_id_seq OWNED BY public.ordersupplies_materialrequirementcoverage.id;


--
-- Name: ordersupplies_materialrequirementcoveragedto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.ordersupplies_materialrequirementcoveragedto AS
 SELECT ordersupplies_materialrequirementcoverage.id,
    ordersupplies_materialrequirementcoverage.number,
    ordersupplies_materialrequirementcoverage.coveragetodate,
    ordersupplies_materialrequirementcoverage.actualdate,
    ordersupplies_materialrequirementcoverage.generateddate,
    ordersupplies_materialrequirementcoverage.generatedby
   FROM public.ordersupplies_materialrequirementcoverage
  WHERE (ordersupplies_materialrequirementcoverage.saved = true);


--
-- Name: ordersupplies_materialrequirementcoveragedto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersupplies_materialrequirementcoveragedto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersupplies_orderdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersupplies_orderdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersupplies_productioncountingproducedquantity; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.ordersupplies_productioncountingproducedquantity AS
 SELECT COALESCE(sum(topoc.usedquantity), (0)::numeric) AS producedquantity,
    pt.order_id,
    topoc.product_id
   FROM ((public.productioncounting_trackingoperationproductoutcomponent topoc
     JOIN public.productioncounting_productiontracking pt ON ((pt.id = topoc.productiontracking_id)))
     JOIN public.orders_order o ON ((o.id = pt.order_id)))
  WHERE (((pt.state)::text = ANY (ARRAY[('02accepted'::character varying)::text])) AND ((o.state)::text = ANY (ARRAY[('03inProgress'::character varying)::text, ('06interrupted'::character varying)::text])))
  GROUP BY pt.order_id, topoc.product_id, pt.technologyoperationcomponent_id;


--
-- Name: ordersupplies_productioncountingproducedquantitydrafts; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.ordersupplies_productioncountingproducedquantitydrafts AS
 SELECT COALESCE(sum(topoc.usedquantity), (0)::numeric) AS producedquantity,
    pt.order_id,
    topoc.product_id,
    o.product_id AS order_product_id
   FROM ((public.productioncounting_trackingoperationproductoutcomponent topoc
     JOIN public.productioncounting_productiontracking pt ON ((pt.id = topoc.productiontracking_id)))
     JOIN public.orders_order o ON ((o.id = pt.order_id)))
  WHERE (((pt.state)::text = ANY (ARRAY[('01draft'::character varying)::text, ('02accepted'::character varying)::text])) AND ((o.state)::text = ANY (ARRAY[('03inProgress'::character varying)::text, ('06interrupted'::character varying)::text])))
  GROUP BY pt.order_id, topoc.product_id, pt.technologyoperationcomponent_id, o.product_id;


--
-- Name: ordersupplies_productioncountingquantityinput; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.ordersupplies_productioncountingquantityinput AS
 SELECT pcq.id,
    (o.id)::integer AS orderid,
    o.startdate,
    o.state AS orderstate,
    (product.id)::integer AS productid,
    (toc.operation_id)::integer AS operationid,
    (pcq.technologyoperationcomponent_id)::integer AS technologyoperationcomponentid,
    pcq.plannedquantity,
    COALESCE(pcq.usedquantity, (0)::numeric) AS usedquantity,
    GREATEST((pcq.plannedquantity - COALESCE(pcq.usedquantity, (0)::numeric)), (0)::numeric) AS quantity,
    '04orderInput'::text AS eventtype,
    COALESCE((coverageproducttype.producttype)::character varying(255), '01component'::character varying(255)) AS producttype,
    (o.product_id)::integer AS orderproductid,
    product.averagecost AS price,
    COALESCE(product.averagecost, (0)::numeric) AS averagecost,
    COALESCE(product.lastpurchasecost, (0)::numeric) AS lastpurchasecost,
    COALESCE(product.nominalcost, (0)::numeric) AS nominalcost,
    COALESCE(product.lastoffercost, (0)::numeric) AS lastoffercost,
    COALESCE(product.averageoffercost, (0)::numeric) AS averageoffercost,
    COALESCE(product.lastoffercost, product.lastpurchasecost, (0)::numeric) AS offercostorlastpurchase
   FROM ((((public.basicproductioncounting_productioncountingquantity pcq
     JOIN public.orders_order o ON ((o.id = pcq.order_id)))
     JOIN public.basic_product product ON ((product.id = pcq.product_id)))
     LEFT JOIN public.technologies_technologyoperationcomponent toc ON ((pcq.technologyoperationcomponent_id = toc.id)))
     LEFT JOIN public.ordersupplies_coverageproducttypedto coverageproducttype ON ((coverageproducttype.productid = pcq.product_id)))
  WHERE (((pcq.role)::text = '01used'::text) AND ((pcq.typeofmaterial)::text = ANY (ARRAY[('01component'::character varying)::text])) AND ((o.state)::text = ANY (ARRAY[('01pending'::character varying)::text, ('02accepted'::character varying)::text, ('03inProgress'::character varying)::text, ('06interrupted'::character varying)::text])) AND (o.active = true) AND ((o.typeofproductionrecording)::text = '02cumulated'::text))
UNION
 SELECT pcq.id,
    (o.id)::integer AS orderid,
    o.startdate,
    o.state AS orderstate,
    (product.id)::integer AS productid,
    (toc.operation_id)::integer AS operationid,
    (pcq.technologyoperationcomponent_id)::integer AS technologyoperationcomponentid,
    pcq.plannedquantity,
    COALESCE(pcq.usedquantity, (0)::numeric) AS usedquantity,
    GREATEST((pcq.plannedquantity - COALESCE(pcq.usedquantity, (0)::numeric)), (0)::numeric) AS quantity,
    '03operationInput'::text AS eventtype,
    COALESCE((coverageproducttype.producttype)::character varying(255), '01component'::character varying(255)) AS producttype,
    (o.product_id)::integer AS orderproductid,
    product.averagecost AS price,
    COALESCE(product.averagecost, (0)::numeric) AS averagecost,
    COALESCE(product.lastpurchasecost, (0)::numeric) AS lastpurchasecost,
    COALESCE(product.nominalcost, (0)::numeric) AS nominalcost,
    COALESCE(product.lastoffercost, (0)::numeric) AS lastoffercost,
    COALESCE(product.averageoffercost, (0)::numeric) AS averageoffercost,
    COALESCE(product.lastoffercost, product.lastpurchasecost, (0)::numeric) AS offercostorlastpurchase
   FROM ((((public.basicproductioncounting_productioncountingquantity pcq
     JOIN public.orders_order o ON ((o.id = pcq.order_id)))
     JOIN public.basic_product product ON ((product.id = pcq.product_id)))
     JOIN public.technologies_technologyoperationcomponent toc ON ((pcq.technologyoperationcomponent_id = toc.id)))
     LEFT JOIN public.ordersupplies_coverageproducttypedto coverageproducttype ON ((coverageproducttype.productid = pcq.product_id)))
  WHERE (((pcq.role)::text = '01used'::text) AND ((pcq.typeofmaterial)::text = ANY (ARRAY[('01component'::character varying)::text])) AND ((o.state)::text = ANY (ARRAY[('01pending'::character varying)::text, ('02accepted'::character varying)::text, ('03inProgress'::character varying)::text, ('06interrupted'::character varying)::text])) AND (o.active = true) AND ((o.typeofproductionrecording)::text = '03forEach'::text));


--
-- Name: ordersupplies_productioncountingquantityinput_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersupplies_productioncountingquantityinput_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersupplies_productioncountingquantityoutput; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.ordersupplies_productioncountingquantityoutput AS
 SELECT pcq.id,
    (o.id)::integer AS orderid,
    o.finishdate,
    o.state AS orderstate,
    (product.id)::integer AS productid,
    (toc.operation_id)::integer AS operationid,
    (pcq.technologyoperationcomponent_id)::integer AS technologyoperationcomponentid,
    pcq.plannedquantity,
    COALESCE(pcq.producedquantity, (0)::numeric) AS producedquantity,
    GREATEST((pcq.plannedquantity - COALESCE(pcq.producedquantity, (0)::numeric)), (0)::numeric) AS quantity,
    '05orderOutput'::text AS eventtype,
    pcq.typeofmaterial AS producttype,
    product.averagecost AS price,
    COALESCE(product.averagecost, (0)::numeric) AS averagecost,
    COALESCE(product.lastpurchasecost, (0)::numeric) AS lastpurchasecost,
    COALESCE(product.nominalcost, (0)::numeric) AS nominalcost,
    COALESCE(product.lastoffercost, (0)::numeric) AS lastoffercost,
    COALESCE(product.averageoffercost, (0)::numeric) AS averageoffercost,
    COALESCE(product.lastoffercost, product.lastpurchasecost, (0)::numeric) AS offercostorlastpurchase
   FROM (((public.basicproductioncounting_productioncountingquantity pcq
     JOIN public.orders_order o ON ((o.id = pcq.order_id)))
     JOIN public.basic_product product ON ((product.id = pcq.product_id)))
     JOIN public.technologies_technologyoperationcomponent toc ON ((pcq.technologyoperationcomponent_id = toc.id)))
  WHERE (((pcq.role)::text = '02produced'::text) AND (((pcq.typeofmaterial)::text = '03finalProduct'::text) OR ((pcq.typeofmaterial)::text = '05additionalFinalProduct'::text)) AND ((o.state)::text = ANY (ARRAY[('01pending'::character varying)::text, ('02accepted'::character varying)::text, ('03inProgress'::character varying)::text, ('06interrupted'::character varying)::text])) AND (o.active = true));


--
-- Name: ordersupplies_productioncountingquantityoutput_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ordersupplies_productioncountingquantityoutput_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ordersupplies_productioncountingusedquantity; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.ordersupplies_productioncountingusedquantity AS
 SELECT sum(topic.usedquantity) AS usedquantity,
    pt.order_id,
    topic.product_id,
    pt.technologyoperationcomponent_id
   FROM ((public.productioncounting_trackingoperationproductincomponent topic
     JOIN public.productioncounting_productiontracking pt ON ((pt.id = topic.productiontracking_id)))
     JOIN public.orders_order o ON ((o.id = pt.order_id)))
  WHERE (((pt.state)::text = ANY (ARRAY[('02accepted'::character varying)::text])) AND ((o.state)::text = ANY (ARRAY[('03inProgress'::character varying)::text, ('06interrupted'::character varying)::text])))
  GROUP BY pt.order_id, topic.product_id, pt.technologyoperationcomponent_id;


--
-- Name: productcatalognumbers_productcatalognumbers_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productcatalognumbers_productcatalognumbers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productcatalognumbers_productcatalognumbers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productcatalognumbers_productcatalognumbers_id_seq OWNED BY public.productcatalognumbers_productcatalognumbers.id;


--
-- Name: productflowthrudivision_issue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productflowthrudivision_issue (
    id bigint NOT NULL,
    warehouseissue_id bigint,
    product_id bigint,
    productincomponent_id bigint,
    demandquantity numeric(12,5),
    locationsquantity numeric(12,5),
    issuequantity numeric(12,5),
    location_id bigint,
    entityversion bigint DEFAULT 0,
    locationtoquantity numeric(12,5),
    quantityperunit numeric(12,5),
    issued boolean DEFAULT false,
    additionaldemandquantity numeric(12,5),
    conversion numeric(12,5),
    dateofissued timestamp without time zone,
    document_id bigint
);


--
-- Name: productflowthrudivision_issue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_issue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_issue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productflowthrudivision_issue_id_seq OWNED BY public.productflowthrudivision_issue.id;


--
-- Name: productflowthrudivision_warehouseissue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productflowthrudivision_warehouseissue (
    id bigint NOT NULL,
    number character varying(255),
    description character varying(2048),
    order_id bigint,
    placeofissue_id bigint,
    division_id bigint,
    workerwhoissued_id bigint,
    workerwhocollected_id bigint,
    dateofissued timestamp without time zone,
    dateofcreation timestamp without time zone,
    technologyoperationcomponent_id bigint,
    collectionproducts character varying(255) DEFAULT '01onOrder'::character varying,
    state character varying(255) DEFAULT '01draft'::character varying,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    entityversion bigint DEFAULT 0,
    productstoissuemode character varying(255) DEFAULT '01allInputProducts'::character varying
);


--
-- Name: productflowthrudivision_issuedto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productflowthrudivision_issuedto AS
 SELECT issue.id,
    warehouseissue.number AS warehouseissuenumber,
    product.name AS productname,
    product.number AS productnumber,
    product.unit AS productunit,
    issue.demandquantity,
    issue.issuequantity,
    issue.locationtoquantity,
    issue.quantityperunit,
    issue.locationsquantity,
    issue.additionaldemandquantity,
    issue.issued,
    issue.conversion,
    issue.dateofissued,
    warehouseissue.state AS warehouseissuestate,
    location.number AS locationnumber,
    (location.id)::integer AS locationid,
    document.number AS documentnumber,
    document.state AS documentstate
   FROM ((((public.productflowthrudivision_issue issue
     LEFT JOIN public.productflowthrudivision_warehouseissue warehouseissue ON ((warehouseissue.id = issue.warehouseissue_id)))
     LEFT JOIN public.basic_product product ON ((product.id = issue.product_id)))
     LEFT JOIN public.materialflow_location location ON ((location.id = issue.location_id)))
     LEFT JOIN public.materialflowresources_document document ON ((document.id = issue.document_id)));


--
-- Name: productflowthrudivision_issuedto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_issuedto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_materialavailability; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productflowthrudivision_materialavailability (
    id bigint NOT NULL,
    order_id bigint,
    product_id bigint,
    availablequantity numeric(19,5),
    requiredquantity numeric(19,5),
    unit character varying(255),
    entityversion bigint DEFAULT 0,
    location_id bigint,
    availability character varying,
    replacement boolean DEFAULT false,
    batchesid character varying(255),
    batches character varying(255),
    batchesquantity numeric(19,5)
);


--
-- Name: productflowthrudivision_materialavailability_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_materialavailability_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_materialavailability_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productflowthrudivision_materialavailability_id_seq OWNED BY public.productflowthrudivision_materialavailability.id;


--
-- Name: productflowthrudivision_materialavailabilitydto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productflowthrudivision_materialavailabilitydto AS
 SELECT materialavailability.id,
    materialavailability.order_id,
    (materialavailability.order_id)::integer AS orderid,
    materialavailability.product_id,
    (materialavailability.product_id)::integer AS productid,
    materialavailability.location_id,
    (materialavailability.location_id)::integer AS locationid,
    location.number AS locationnumber,
    ordersorder.number AS ordernumber,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    materialavailability.availablequantity,
    materialavailability.requiredquantity,
    materialavailability.unit,
    materialavailability.availability,
    materialavailability.replacement,
    materialavailability.batchesid,
    materialavailability.batches,
    COALESCE(materialavailability.batchesquantity, (0)::numeric) AS batchesquantity,
        CASE
            WHEN ((materialavailability.requiredquantity > COALESCE(materialavailability.batchesquantity, (0)::numeric)) AND (materialavailability.batchesid IS NOT NULL)) THEN 'red-cell'::text
            ELSE 'base-cell'::text
        END AS batchesquantityclass,
    (defaultstoragelocationdto.storagelocation_id)::integer AS storagelocationid,
    defaultstoragelocationdto.number AS storagelocationnumber
   FROM ((((public.productflowthrudivision_materialavailability materialavailability
     JOIN public.orders_order ordersorder ON ((ordersorder.id = materialavailability.order_id)))
     JOIN public.basic_product product ON ((product.id = materialavailability.product_id)))
     LEFT JOIN public.materialflow_location location ON ((location.id = materialavailability.location_id)))
     LEFT JOIN public.materialflowresources_defaultstoragelocationdto defaultstoragelocationdto ON (((defaultstoragelocationdto.location_id = location.id) AND (defaultstoragelocationdto.product_id = product.id))));


--
-- Name: productflowthrudivision_materialavailabilitydto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_materialavailabilitydto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_modelcard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productflowthrudivision_modelcard (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    generated boolean,
    filename character varying(255),
    date timestamp without time zone,
    worker character varying(255),
    materialcostsused character varying(255) DEFAULT 'nominal'::character varying,
    usenominalcostpricenotspecified boolean DEFAULT false
);


--
-- Name: productflowthrudivision_modelcard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_modelcard_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_modelcard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productflowthrudivision_modelcard_id_seq OWNED BY public.productflowthrudivision_modelcard.id;


--
-- Name: productflowthrudivision_modelcardproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productflowthrudivision_modelcardproduct (
    id bigint NOT NULL,
    modelcard_id bigint,
    product_id bigint,
    technology_id bigint,
    quantity numeric(14,5),
    succession integer
);


--
-- Name: productflowthrudivision_modelcardproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_modelcardproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_modelcardproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productflowthrudivision_modelcardproduct_id_seq OWNED BY public.productflowthrudivision_modelcardproduct.id;


--
-- Name: productflowthrudivision_opertaskmaterialavailability; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productflowthrudivision_opertaskmaterialavailability (
    id bigint NOT NULL,
    operationaltask_id bigint,
    product_id bigint,
    location_id bigint,
    availablequantity numeric(19,5),
    requiredquantity numeric(19,5),
    unit character varying(255),
    availability character varying(255),
    replacement boolean DEFAULT false,
    batchesid character varying(255),
    batches character varying(255),
    batchesquantity numeric(19,5),
    typeofmaterial character varying(255),
    produced numeric(19,5)
);


--
-- Name: productflowthrudivision_opertaskmaterialavailability_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_opertaskmaterialavailability_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_opertaskmaterialavailability_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productflowthrudivision_opertaskmaterialavailability_id_seq OWNED BY public.productflowthrudivision_opertaskmaterialavailability.id;


--
-- Name: productflowthrudivision_opertaskmaterialavailabilitydto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productflowthrudivision_opertaskmaterialavailabilitydto AS
 SELECT materialavailability.id,
    materialavailability.operationaltask_id,
    (materialavailability.operationaltask_id)::integer AS operationaltaskid,
    materialavailability.product_id,
    (materialavailability.product_id)::integer AS productid,
    materialavailability.location_id,
    (materialavailability.location_id)::integer AS locationid,
    location.number AS locationnumber,
    operationaltask.number AS operationaltasknumber,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    materialavailability.availablequantity,
    materialavailability.requiredquantity,
    materialavailability.unit,
    materialavailability.availability,
    materialavailability.replacement,
    materialavailability.batchesid,
    materialavailability.batches,
    COALESCE(materialavailability.batchesquantity, (0)::numeric) AS batchesquantity,
        CASE
            WHEN ((materialavailability.requiredquantity > COALESCE(materialavailability.batchesquantity, (0)::numeric)) AND (materialavailability.batchesid IS NOT NULL)) THEN 'red-cell'::text
            ELSE 'base-cell'::text
        END AS batchesquantityclass,
    materialavailability.typeofmaterial,
    COALESCE(materialavailability.produced, (0)::numeric) AS produced
   FROM (((public.productflowthrudivision_opertaskmaterialavailability materialavailability
     JOIN public.orders_operationaltask operationaltask ON ((operationaltask.id = materialavailability.operationaltask_id)))
     JOIN public.basic_product product ON ((product.id = materialavailability.product_id)))
     LEFT JOIN public.materialflow_location location ON ((location.id = materialavailability.location_id)));


--
-- Name: productflowthrudivision_opertaskmaterialavailabilitydto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_opertaskmaterialavailabilitydto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_orderproductresourcereservation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productflowthrudivision_orderproductresourcereservation (
    id bigint NOT NULL,
    resource_id bigint,
    resourcenumber character varying(255),
    planedquantity numeric(12,5),
    usedquantity numeric(12,5),
    productioncountingquantity_id bigint,
    priority integer,
    resourceunit character varying(255),
    creationdate timestamp without time zone
);


--
-- Name: productflowthrudivision_orderproductresourcereservation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_orderproductresourcereservation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_orderproductresourcereservation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productflowthrudivision_orderproductresourcereservation_id_seq OWNED BY public.productflowthrudivision_orderproductresourcereservation.id;


--
-- Name: productflowthrudivision_plannedconsumptioninorderdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productflowthrudivision_plannedconsumptioninorderdto AS
 SELECT pcq.id,
    (o.id)::integer AS orderid,
    o.number AS ordernumber,
    o.startdate AS orderstartdate,
    o.state AS orderstate,
    o.plannedquantity AS orderplanedquantity,
    COALESCE(o.donequantity, (0)::numeric) AS orderdonequantity,
    op.number AS orderproduct,
    op.unit AS orderunit,
    pl.number AS productionlinenumber,
    (p.id)::integer AS productid,
    op.name AS productnumber,
    p.unit AS productunit,
    pcq.plannedquantity AS productplannedquantity,
    pcq.usedquantity AS productusedquantity,
    GREATEST((pcq.plannedquantity - COALESCE(pcq.usedquantity, (0)::numeric)), (0)::numeric) AS productactualneedquantity,
    d.number AS divisionnumber
   FROM (((((public.basicproductioncounting_productioncountingquantity pcq
     LEFT JOIN public.orders_order o ON ((o.id = pcq.order_id)))
     LEFT JOIN public.basic_product p ON ((p.id = pcq.product_id)))
     LEFT JOIN public.basic_product op ON ((op.id = o.product_id)))
     LEFT JOIN public.basic_division d ON ((d.id = o.division_id)))
     LEFT JOIN public.productionlines_productionline pl ON ((pl.id = o.productionline_id)))
  WHERE (((pcq.role)::text = '01used'::text) AND ((pcq.typeofmaterial)::text = ANY (ARRAY[('01component'::character varying)::text])) AND ((o.state)::text = ANY (ARRAY[('01pending'::character varying)::text, ('02accepted'::character varying)::text, ('03inProgress'::character varying)::text, ('06interrupted'::character varying)::text])) AND (o.active = true));


--
-- Name: productflowthrudivision_plannedconsumptioninorderdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_plannedconsumptioninorderdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_productandquantityhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productflowthrudivision_productandquantityhelper (
    id bigint NOT NULL,
    product_id bigint,
    location_id bigint,
    locationsquantity numeric(12,5)
);


--
-- Name: productflowthrudivision_productandquantityhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_productandquantityhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_productandquantityhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productflowthrudivision_productandquantityhelper_id_seq OWNED BY public.productflowthrudivision_productandquantityhelper.id;


--
-- Name: productflowthrudivision_productstoissue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productflowthrudivision_productstoissue (
    id bigint NOT NULL,
    warehouseissue_id bigint,
    product_id bigint,
    productincomponent_id bigint,
    demandquantity numeric(12,5),
    locationsquantity numeric(12,5),
    placeofissuequantity numeric(12,5),
    issuequantity numeric(12,5),
    location_id bigint,
    entityversion bigint DEFAULT 0,
    issued boolean DEFAULT false,
    additionaldemandquantity numeric(12,5),
    conversion numeric(12,5),
    correction numeric(12,5)
);


--
-- Name: productflowthrudivision_productstoissue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_productstoissue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_productstoissue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productflowthrudivision_productstoissue_id_seq OWNED BY public.productflowthrudivision_productstoissue.id;


--
-- Name: productflowthrudivision_productstoissuehelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productflowthrudivision_productstoissuehelper (
    id bigint NOT NULL,
    locationfrom_id bigint,
    productstoissueids character varying(255),
    generated boolean DEFAULT false,
    additionalinfo character varying(255)
);


--
-- Name: productflowthrudivision_productstoissuehelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_productstoissuehelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_productstoissuehelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productflowthrudivision_productstoissuehelper_id_seq OWNED BY public.productflowthrudivision_productstoissuehelper.id;


--
-- Name: productflowthrudivision_producttoissuecorrection; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productflowthrudivision_producttoissuecorrection (
    id bigint NOT NULL,
    producttoissuecorrectionhelper_id bigint,
    warehouseissue_id bigint,
    product_id bigint,
    correctionquantity numeric(12,5),
    correctionquantityinadditionalunit numeric(12,5),
    quantitytoissue numeric(12,5),
    demandquantity numeric(12,5),
    conversion numeric(12,5),
    location_id bigint,
    description character varying(255),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    productstoissue_id bigint
);


--
-- Name: productflowthrudivision_producttoissuecorrection_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_producttoissuecorrection_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_producttoissuecorrection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productflowthrudivision_producttoissuecorrection_id_seq OWNED BY public.productflowthrudivision_producttoissuecorrection.id;


--
-- Name: productflowthrudivision_producttoissuecorrectionhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productflowthrudivision_producttoissuecorrectionhelper (
    id bigint NOT NULL,
    locationfrom_id bigint,
    locationto_id bigint,
    productstoissueids character varying(255)
);


--
-- Name: productflowthrudivision_producttoissuecorrectionhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_producttoissuecorrectionhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_producttoissuecorrectionhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productflowthrudivision_producttoissuecorrectionhelper_id_seq OWNED BY public.productflowthrudivision_producttoissuecorrectionhelper.id;


--
-- Name: productflowthrudivision_producttoissuedto_internal; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productflowthrudivision_producttoissuedto_internal AS
 SELECT row_number() OVER () AS id,
    resource.location_id,
    (resource.product_id)::integer AS product_id,
    sum(resource.quantity) AS quantity
   FROM public.materialflowresources_resource resource
  GROUP BY resource.location_id, resource.product_id;


--
-- Name: qcadooplugin_plugin; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadooplugin_plugin (
    id bigint NOT NULL,
    identifier character varying(255),
    version character varying(255),
    state character varying(255),
    issystem boolean,
    entityversion bigint DEFAULT 0,
    groupname character varying(255),
    license character varying(255)
);


--
-- Name: productflowthrudivision_producttoissuedto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productflowthrudivision_producttoissuedto AS
 SELECT producttoissue.id,
    issue.number AS issuenumber,
    locationfrom.number AS locationfromnumber,
    locationto.number AS locationtonumber,
    o.number AS ordernumber,
    o.startdate AS orderstartdate,
    issue.state,
    product.number AS productnumber,
    product.name AS productname,
    producttoissue.demandquantity,
    o.plannedquantity AS orderquantity,
    round((producttoissue.demandquantity / o.plannedquantity), 5) AS quantityperunit,
    producttoissue.conversion,
    product.additionalunit AS unitadditional,
    producttoissue.issuequantity AS issuedquantity,
        CASE
            WHEN (((producttoissue.demandquantity - producttoissue.issuequantity) - COALESCE(producttoissue.correction, (0)::numeric)) < (0)::numeric) THEN (0)::numeric
            ELSE ((producttoissue.demandquantity - producttoissue.issuequantity) - COALESCE(producttoissue.correction, (0)::numeric))
        END AS quantitytoissue,
        CASE
            WHEN (((producttoissue.demandquantity - producttoissue.issuequantity) - COALESCE(producttoissue.correction, (0)::numeric)) < (0)::numeric) THEN (0)::numeric
            ELSE round((((producttoissue.demandquantity - producttoissue.issuequantity) - COALESCE(producttoissue.correction, (0)::numeric)) * producttoissue.conversion))
        END AS quantitytoissueinaddunit,
        CASE
            WHEN (((plu.state)::text = 'DISABLED'::text) AND (warehousestockfrom.quantity IS NULL)) THEN (0)::numeric
            WHEN (((plu.state)::text = 'DISABLED'::text) AND (warehousestockfrom.quantity IS NOT NULL)) THEN warehousestockfrom.quantity
            WHEN ((locationfrom.externalnumber IS NULL) AND (warehousestockfrom.quantity IS NULL)) THEN (0)::numeric
            WHEN ((locationfrom.externalnumber IS NULL) AND (warehousestockfrom.quantity IS NOT NULL)) THEN warehousestockfrom.quantity
            WHEN ((locationfrom.externalnumber IS NOT NULL) AND (warehousestockfromexternal.locationsquantity IS NULL)) THEN (0)::numeric
            WHEN ((locationfrom.externalnumber IS NOT NULL) AND (warehousestockfromexternal.locationsquantity IS NOT NULL)) THEN warehousestockfromexternal.locationsquantity
            ELSE warehousestockfrom.quantity
        END AS quantityinlocationfrom,
        CASE
            WHEN (((plu.state)::text = 'DISABLED'::text) AND (warehousestockto.quantity IS NULL)) THEN (0)::numeric
            WHEN (((plu.state)::text = 'DISABLED'::text) AND (warehousestockto.quantity IS NOT NULL)) THEN warehousestockto.quantity
            WHEN ((locationfrom.externalnumber IS NULL) AND (warehousestockto.quantity IS NULL)) THEN (0)::numeric
            WHEN ((locationfrom.externalnumber IS NULL) AND (warehousestockto.quantity IS NOT NULL)) THEN warehousestockto.quantity
            WHEN ((locationfrom.externalnumber IS NOT NULL) AND (warehousestocktoexternal.locationsquantity IS NULL)) THEN (0)::numeric
            WHEN ((locationfrom.externalnumber IS NOT NULL) AND (warehousestocktoexternal.locationsquantity IS NOT NULL)) THEN warehousestocktoexternal.locationsquantity
            ELSE warehousestockfrom.quantity
        END AS quantityinlocationto,
    product.unit,
        CASE
            WHEN ((producttoissue.demandquantity <= producttoissue.issuequantity) OR (((producttoissue.demandquantity - producttoissue.issuequantity) - COALESCE(producttoissue.correction, (0)::numeric)) <= (0)::numeric)) THEN true
            ELSE false
        END AS issued,
    product.id AS productid,
    producttoissue.correction,
    (locationfrom.id)::integer AS locationfrom_id,
    (locationto.id)::integer AS locationto_id
   FROM ((((((((((public.productflowthrudivision_productstoissue producttoissue
     JOIN public.qcadooplugin_plugin plu ON (((plu.identifier)::text = 'integration'::text)))
     LEFT JOIN public.productflowthrudivision_warehouseissue issue ON ((producttoissue.warehouseissue_id = issue.id)))
     LEFT JOIN public.materialflow_location locationfrom ON ((issue.placeofissue_id = locationfrom.id)))
     LEFT JOIN public.materialflow_location locationto ON ((producttoissue.location_id = locationto.id)))
     LEFT JOIN public.orders_order o ON ((issue.order_id = o.id)))
     LEFT JOIN public.basic_product product ON ((producttoissue.product_id = product.id)))
     LEFT JOIN public.productflowthrudivision_producttoissuedto_internal warehousestockfrom ON (((warehousestockfrom.product_id = producttoissue.product_id) AND (warehousestockfrom.location_id = locationfrom.id))))
     LEFT JOIN public.productflowthrudivision_producttoissuedto_internal warehousestockto ON (((warehousestockto.product_id = producttoissue.product_id) AND (warehousestockto.location_id = locationto.id))))
     LEFT JOIN public.productflowthrudivision_productandquantityhelper warehousestockfromexternal ON (((warehousestockfromexternal.product_id = producttoissue.product_id) AND (warehousestockfromexternal.location_id = locationfrom.id))))
     LEFT JOIN public.productflowthrudivision_productandquantityhelper warehousestocktoexternal ON (((warehousestocktoexternal.product_id = producttoissue.product_id) AND (warehousestocktoexternal.location_id = locationto.id))))
  WHERE ((issue.state)::text = ANY (ARRAY[('01draft'::character varying)::text, ('02inProgress'::character varying)::text]));


--
-- Name: productflowthrudivision_producttoissuedto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_producttoissuedto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_producttoissuedto_internal_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_producttoissuedto_internal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_trackingproductresourcereservation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productflowthrudivision_trackingproductresourcereservation (
    id bigint NOT NULL,
    priority integer,
    orderproductresourcereservation_id bigint,
    trackingoperationproductincomponent_id bigint,
    usedquantity numeric(12,5)
);


--
-- Name: productflowthrudivision_trackingproductresourcereservation_id_s; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_trackingproductresourcereservation_id_s
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_trackingproductresourcereservation_id_s; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productflowthrudivision_trackingproductresourcereservation_id_s OWNED BY public.productflowthrudivision_trackingproductresourcereservation.id;


--
-- Name: productflowthrudivision_warehouseissue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_warehouseissue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_warehouseissue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productflowthrudivision_warehouseissue_id_seq OWNED BY public.productflowthrudivision_warehouseissue.id;


--
-- Name: productflowthrudivision_warehouseissue_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_warehouseissue_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_warehouseissuestatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productflowthrudivision_warehouseissuestatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    warehouseissue_id bigint,
    shift_id bigint,
    additionalinformation character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: productflowthrudivision_warehouseissuestatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productflowthrudivision_warehouseissuestatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productflowthrudivision_warehouseissuestatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productflowthrudivision_warehouseissuestatechange_id_seq OWNED BY public.productflowthrudivision_warehouseissuestatechange.id;


--
-- Name: productioncounting_anomaly; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_anomaly (
    id bigint NOT NULL,
    number character varying(255),
    productiontracking_id bigint,
    masterproduct_id bigint,
    product_id bigint,
    usedquantity numeric(14,5),
    state character varying(255) DEFAULT '01draft'::character varying,
    issued boolean DEFAULT false,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    location_id bigint
);


--
-- Name: productioncounting_anomaly_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_anomaly_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_anomaly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_anomaly_id_seq OWNED BY public.productioncounting_anomaly.id;


--
-- Name: productioncounting_anomalyreason; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_anomalyreason (
    id bigint NOT NULL,
    name character varying(255),
    defaultreason boolean DEFAULT false
);


--
-- Name: productioncounting_anomalydto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_anomalydto AS
 SELECT DISTINCT anomaly.id,
    anomaly.number,
    anomaly.usedquantity,
    anomaly.state,
    anomaly.issued,
    anomaly.createdate,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    ordersorder.number AS ordernumber,
    productionline.number AS productionlinenumber,
    division.number AS divisionnumber,
    productiontracking.number AS productiontrackingnumber,
    array_to_string(ARRAY( SELECT reson.name
           FROM (public.jointable_anomaly_anomalyreason anomaly_anomalyreason
             LEFT JOIN public.productioncounting_anomalyreason reson ON ((anomaly_anomalyreason.anomalyreason_id = reson.id)))
          WHERE (anomaly_anomalyreason.anomaly_id = anomaly.id)), ', '::text) AS reasons
   FROM (((((public.productioncounting_anomaly anomaly
     LEFT JOIN public.productioncounting_productiontracking productiontracking ON ((anomaly.productiontracking_id = productiontracking.id)))
     LEFT JOIN public.orders_order ordersorder ON ((ordersorder.id = productiontracking.order_id)))
     LEFT JOIN public.basic_product product ON ((anomaly.product_id = product.id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((productionline.id = ordersorder.productionline_id)))
     LEFT JOIN public.basic_division division ON ((division.id = productiontracking.division_id)));


--
-- Name: productioncounting_anomalydto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_anomalydto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_anomalyexplanation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_anomalyexplanation (
    id bigint NOT NULL,
    anomaly_id bigint,
    product_id bigint,
    location_id bigint,
    usedquantity numeric(14,5),
    givenquantity numeric(14,5),
    givenunit character varying(255),
    usewaste boolean DEFAULT false,
    description character varying(1024),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: productioncounting_anomalyexplanation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_anomalyexplanation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_anomalyexplanation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_anomalyexplanation_id_seq OWNED BY public.productioncounting_anomalyexplanation.id;


--
-- Name: productioncounting_anomalyexplanationdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_anomalyexplanationdto AS
 SELECT anomalyexplanation.id,
    anomalyexplanation.usedquantity,
    anomalyexplanation.description,
    anomalyexplanation.createuser,
    anomalyexplanation.createdate,
    (anomaly.id)::integer AS anomalyid,
    product.number AS productnumber,
    product.name AS productname,
    materialflow_location.number AS locationnumber,
        CASE
            WHEN anomalyexplanation.usewaste THEN anomalyexplanation.givenunit
            ELSE product.unit
        END AS productunit
   FROM (((public.productioncounting_anomalyexplanation anomalyexplanation
     JOIN public.productioncounting_anomaly anomaly ON ((anomaly.id = anomalyexplanation.anomaly_id)))
     LEFT JOIN public.basic_product product ON ((product.id = anomalyexplanation.product_id)))
     LEFT JOIN public.materialflow_location ON ((materialflow_location.id = anomalyexplanation.location_id)));


--
-- Name: productioncounting_anomalyexplanationdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_anomalyexplanationdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_anomalyproductiontrackingentryhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_anomalyproductiontrackingentryhelper (
    id bigint NOT NULL,
    anomalyproductiontracking_id bigint,
    trackingoperationproductincomponent_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: productioncounting_anomalyproductiontrackingentryhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_anomalyproductiontrackingentryhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_anomalyproductiontrackingentryhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_anomalyproductiontrackingentryhelper_id_seq OWNED BY public.productioncounting_anomalyproductiontrackingentryhelper.id;


--
-- Name: productioncounting_anomalyproductiontrackinghelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_anomalyproductiontrackinghelper (
    id bigint NOT NULL,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: productioncounting_anomalyproductiontrackinghelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_anomalyproductiontrackinghelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_anomalyproductiontrackinghelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_anomalyproductiontrackinghelper_id_seq OWNED BY public.productioncounting_anomalyproductiontrackinghelper.id;


--
-- Name: productioncounting_anomalyreason_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_anomalyreason_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_anomalyreason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_anomalyreason_id_seq OWNED BY public.productioncounting_anomalyreason.id;


--
-- Name: productioncounting_anomalyreasoncontainer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_anomalyreasoncontainer (
    id bigint NOT NULL,
    anomalyproductiontrackingentryhelper_id bigint,
    anomalyreason_id bigint
);


--
-- Name: productioncounting_anomalyreasoncontainer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_anomalyreasoncontainer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_anomalyreasoncontainer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_anomalyreasoncontainer_id_seq OWNED BY public.productioncounting_anomalyreasoncontainer.id;


--
-- Name: productioncounting_beforeadditionalactionsanalysisentry; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_beforeadditionalactionsanalysisentry AS
 SELECT row_number() OVER () AS id,
    pl.number AS productionlinenumber,
    ord.number AS ordernumber,
    c.number AS companynumber,
    assortment.name AS assortmentname,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    size.number AS sizenumber,
    sum(COALESCE(topoc.usedquantity, (0)::numeric)) AS quantity,
    sum(COALESCE(topoc.wastesquantity, (0)::numeric)) AS wastes,
    (sum(COALESCE(topoc.usedquantity, (0)::numeric)) + sum(COALESCE(topoc.wastesquantity, (0)::numeric))) AS donequantity,
    date(date_trunc('day'::text, pt.timerangefrom)) AS timerangefrom,
    date(date_trunc('day'::text, pt.timerangeto)) AS timerangeto,
    shift.name AS shiftname,
    tcontext.number AS technologygeneratornumber
   FROM (((((((((((((public.productioncounting_productiontracking pt
     JOIN public.orders_order ord ON ((ord.id = pt.order_id)))
     JOIN public.technologies_technology technologyprototype ON ((technologyprototype.id = ord.technology_id)))
     JOIN public.technologies_technology technology ON ((technology.id = ord.technology_id)))
     LEFT JOIN public.technologiesgenerator_generatorcontext tcontext ON ((tcontext.id = technologyprototype.generatorcontext_id)))
     LEFT JOIN public.orders_order parentorder ON ((ord.parent_id = parentorder.id)))
     LEFT JOIN public.technologies_technology parenttechnology ON ((parenttechnology.id = parentorder.technology_id)))
     LEFT JOIN public.basic_shift shift ON ((pt.shift_id = shift.id)))
     LEFT JOIN public.productionlines_productionline pl ON ((ord.productionline_id = pl.id)))
     LEFT JOIN public.basic_company c ON ((c.id = ord.company_id)))
     JOIN public.productioncounting_trackingoperationproductoutcomponent topoc ON ((pt.id = topoc.productiontracking_id)))
     JOIN public.basic_product product ON ((topoc.product_id = product.id)))
     LEFT JOIN public.basic_assortment assortment ON ((product.assortment_id = assortment.id)))
     LEFT JOIN public.basic_size size ON ((size.id = product.size_id)))
  WHERE ((technology.additionalactions = false) AND ((parenttechnology.additionalactions = true) OR (ord.parent_id IS NULL)) AND ((product.id = ord.product_id) OR ((pt.technologyoperationcomponent_id IS NOT NULL) AND ((topoc.typeofmaterial)::text = '02intermediate'::text))))
  GROUP BY ord.number, shift.name, (date_trunc('day'::text, pt.timerangefrom)), (date_trunc('day'::text, pt.timerangeto)), pl.number, c.number, assortment.name, product.number, product.name, product.unit, size.number, tcontext.number
UNION ALL
 SELECT row_number() OVER () AS id,
    pl.number AS productionlinenumber,
    ord.number AS ordernumber,
    c.number AS companynumber,
    assortment.name AS assortmentname,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    size.number AS sizenumber,
    sum(COALESCE(topoc.usedquantity, (0)::numeric)) AS quantity,
    sum(COALESCE(topoc.wastesquantity, (0)::numeric)) AS wastes,
    (sum(COALESCE(topoc.usedquantity, (0)::numeric)) + sum(COALESCE(topoc.wastesquantity, (0)::numeric))) AS donequantity,
    date(date_trunc('day'::text, pt.timerangefrom)) AS timerangefrom,
    date(date_trunc('day'::text, pt.timerangeto)) AS timerangeto,
    shift.name AS shiftname,
    tcontext.number AS technologygeneratornumber
   FROM (((((((((((((public.arch_productioncounting_productiontracking pt
     JOIN public.arch_orders_order ord ON ((ord.id = pt.order_id)))
     JOIN public.technologies_technology technologyprototype ON ((technologyprototype.id = ord.technology_id)))
     JOIN public.technologies_technology technology ON ((technology.id = ord.technology_id)))
     LEFT JOIN public.technologiesgenerator_generatorcontext tcontext ON ((tcontext.id = technologyprototype.generatorcontext_id)))
     LEFT JOIN public.arch_orders_order parentorder ON ((ord.parent_id = parentorder.id)))
     LEFT JOIN public.technologies_technology parenttechnology ON ((parenttechnology.id = parentorder.technology_id)))
     LEFT JOIN public.basic_shift shift ON ((pt.shift_id = shift.id)))
     LEFT JOIN public.productionlines_productionline pl ON ((ord.productionline_id = pl.id)))
     LEFT JOIN public.basic_company c ON ((c.id = ord.company_id)))
     JOIN public.arch_productioncounting_trackingoperationproductoutcomponent topoc ON ((pt.id = topoc.productiontracking_id)))
     JOIN public.basic_product product ON ((topoc.product_id = product.id)))
     LEFT JOIN public.basic_assortment assortment ON ((product.assortment_id = assortment.id)))
     LEFT JOIN public.basic_size size ON ((size.id = product.size_id)))
  WHERE ((technology.additionalactions = false) AND ((parenttechnology.additionalactions = true) OR (ord.parent_id IS NULL)) AND ((product.id = ord.product_id) OR ((pt.technologyoperationcomponent_id IS NOT NULL) AND ((topoc.typeofmaterial)::text = '02intermediate'::text))))
  GROUP BY ord.number, shift.name, (date_trunc('day'::text, pt.timerangefrom)), (date_trunc('day'::text, pt.timerangeto)), pl.number, c.number, assortment.name, product.number, product.name, product.unit, size.number, tcontext.number;


--
-- Name: productioncounting_beforeadditionalactionsanalysisentry_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_beforeadditionalactionsanalysisentry_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_employeepieceworksettlementdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_employeepieceworksettlementdto AS
 SELECT (((staff.name)::text || ' '::text) || (staff.surname)::text) AS worker,
    COALESCE(productiontracking.shiftstartday, (productiontracking.createdate)::date) AS date,
    shift.name AS shiftname,
    ordersorder.number AS ordernumber,
    NULL::text AS operationnumber,
    product.number AS productnumber,
    product.name AS productname,
    COALESCE(sum(trackingoperationproductoutcomponent.usedquantity), (0)::numeric) AS producedquantity,
    COALESCE(max(piecerateitem.rate), (0)::numeric) AS rate,
    (COALESCE(sum(trackingoperationproductoutcomponent.usedquantity), (0)::numeric) * COALESCE(max(piecerateitem.rate), (0)::numeric)) AS cost
   FROM ((((((((public.productioncounting_productiontracking productiontracking
     LEFT JOIN public.productioncounting_trackingoperationproductoutcomponent trackingoperationproductoutcomponent ON (((trackingoperationproductoutcomponent.productiontracking_id = productiontracking.id) AND ((trackingoperationproductoutcomponent.typeofmaterial)::text = '03finalProduct'::text))))
     JOIN public.orders_order ordersorder ON ((ordersorder.id = productiontracking.order_id)))
     JOIN public.technologies_technology technology ON ((technology.id = ordersorder.technology_id)))
     JOIN public.basic_product product ON ((product.id = trackingoperationproductoutcomponent.product_id)))
     LEFT JOIN public.basic_shift shift ON ((shift.id = productiontracking.shift_id)))
     LEFT JOIN public.basic_staff staff ON ((staff.id = productiontracking.staff_id)))
     LEFT JOIN public.basic_piecerate piecerate ON ((piecerate.id = technology.piecerate_id)))
     LEFT JOIN LATERAL ( SELECT piecerateitem_1.actualrate AS rate
           FROM public.basic_piecerateitem piecerateitem_1
          WHERE ((piecerateitem_1.piecerate_id = piecerate.id) AND (piecerateitem_1.datefrom <= COALESCE(productiontracking.shiftstartday, (productiontracking.createdate)::date)))
          ORDER BY piecerateitem_1.datefrom DESC
         LIMIT 1) piecerateitem ON ((1 = 1)))
  WHERE (((productiontracking.state)::text = '02accepted'::text) AND ((ordersorder.typeofproductionrecording)::text = '02cumulated'::text) AND (technology.pieceworkproduction = true))
  GROUP BY (((staff.name)::text || ' '::text) || (staff.surname)::text), COALESCE(productiontracking.shiftstartday, (productiontracking.createdate)::date), shift.name, ordersorder.number, NULL::text, product.number, product.name
UNION ALL
 SELECT (((staff.name)::text || ' '::text) || (staff.surname)::text) AS worker,
    COALESCE(productiontracking.shiftstartday, (productiontracking.createdate)::date) AS date,
    shift.name AS shiftname,
    ordersorder.number AS ordernumber,
    operation.number AS operationnumber,
    product.number AS productnumber,
    product.name AS productname,
    COALESCE(sum(trackingoperationproductoutcomponent.usedquantity), (0)::numeric) AS producedquantity,
    COALESCE(max(piecerateitem.rate), (0)::numeric) AS rate,
    (COALESCE(sum(trackingoperationproductoutcomponent.usedquantity), (0)::numeric) * COALESCE(max(piecerateitem.rate), (0)::numeric)) AS cost
   FROM (((((((((public.productioncounting_productiontracking productiontracking
     LEFT JOIN public.productioncounting_trackingoperationproductoutcomponent trackingoperationproductoutcomponent ON (((trackingoperationproductoutcomponent.productiontracking_id = productiontracking.id) AND (((trackingoperationproductoutcomponent.typeofmaterial)::text = '02intermediate'::text) OR ((trackingoperationproductoutcomponent.typeofmaterial)::text = '03finalProduct'::text)))))
     JOIN public.orders_order ordersorder ON ((ordersorder.id = productiontracking.order_id)))
     JOIN public.technologies_technologyoperationcomponent technologyoperationcomponent ON ((technologyoperationcomponent.id = productiontracking.technologyoperationcomponent_id)))
     JOIN public.technologies_operation operation ON ((operation.id = technologyoperationcomponent.operation_id)))
     JOIN public.basic_product product ON ((product.id = trackingoperationproductoutcomponent.product_id)))
     LEFT JOIN public.basic_shift shift ON ((shift.id = productiontracking.shift_id)))
     LEFT JOIN public.basic_staff staff ON ((staff.id = productiontracking.staff_id)))
     LEFT JOIN public.basic_piecerate piecerate ON ((piecerate.id = technologyoperationcomponent.piecerate_id)))
     LEFT JOIN LATERAL ( SELECT piecerateitem_1.actualrate AS rate
           FROM public.basic_piecerateitem piecerateitem_1
          WHERE ((piecerateitem_1.piecerate_id = piecerate.id) AND (piecerateitem_1.datefrom <= COALESCE(productiontracking.shiftstartday, (productiontracking.createdate)::date)))
          ORDER BY piecerateitem_1.datefrom DESC
         LIMIT 1) piecerateitem ON ((1 = 1)))
  WHERE (((productiontracking.state)::text = '02accepted'::text) AND ((ordersorder.typeofproductionrecording)::text = '03forEach'::text) AND (technologyoperationcomponent.pieceworkproduction = true))
  GROUP BY (((staff.name)::text || ' '::text) || (staff.surname)::text), COALESCE(productiontracking.shiftstartday, (productiontracking.createdate)::date), shift.name, ordersorder.number, operation.number, product.number, product.name;


--
-- Name: productioncounting_finalproductanalysisentry; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_finalproductanalysisentry AS
 SELECT row_number() OVER () AS id,
    pl.number AS productionlinenumber,
    ord.number AS ordernumber,
    c.number AS companynumber,
    assortment.name AS assortmentname,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    size.number AS sizenumber,
    sum(COALESCE(topoc.usedquantity, (0)::numeric)) AS quantity,
    sum(COALESCE(topoc.wastesquantity, (0)::numeric)) AS wastes,
    (sum(COALESCE(topoc.usedquantity, (0)::numeric)) + sum(COALESCE(topoc.wastesquantity, (0)::numeric))) AS donequantity,
    date(date_trunc('day'::text, pt.timerangefrom)) AS timerangefrom,
    date(date_trunc('day'::text, pt.timerangeto)) AS timerangeto,
    shift.name AS shiftname,
    tcontext.number AS technologygeneratornumber
   FROM ((((((((((public.productioncounting_trackingoperationproductoutcomponent topoc
     JOIN public.productioncounting_productiontracking pt ON ((pt.id = topoc.productiontracking_id)))
     JOIN public.orders_order ord ON ((ord.id = pt.order_id)))
     JOIN public.basic_product product ON ((topoc.product_id = product.id)))
     JOIN public.technologies_technology technology ON ((technology.id = ord.technology_id)))
     LEFT JOIN public.basic_shift shift ON ((pt.shift_id = shift.id)))
     LEFT JOIN public.basic_assortment assortment ON ((product.assortment_id = assortment.id)))
     LEFT JOIN public.basic_size size ON ((size.id = product.size_id)))
     LEFT JOIN public.productionlines_productionline pl ON ((ord.productionline_id = pl.id)))
     LEFT JOIN public.basic_company c ON ((c.id = ord.company_id)))
     LEFT JOIN public.technologiesgenerator_generatorcontext tcontext ON ((tcontext.id = technology.generatorcontext_id)))
  WHERE ((ord.parent_id IS NULL) AND ((product.id = ord.product_id) OR ((pt.technologyoperationcomponent_id IS NOT NULL) AND ((topoc.typeofmaterial)::text = '02intermediate'::text)) OR ((topoc.typeofmaterial)::text = '05additionalFinalProduct'::text)))
  GROUP BY ord.number, shift.name, (date_trunc('day'::text, pt.timerangefrom)), (date_trunc('day'::text, pt.timerangeto)), pl.number, c.number, assortment.name, product.number, product.name, product.unit, size.number, tcontext.number
UNION ALL
 SELECT row_number() OVER () AS id,
    pl.number AS productionlinenumber,
    ord.number AS ordernumber,
    c.number AS companynumber,
    assortment.name AS assortmentname,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    size.number AS sizenumber,
    sum(COALESCE(topoc.usedquantity, (0)::numeric)) AS quantity,
    sum(COALESCE(topoc.wastesquantity, (0)::numeric)) AS wastes,
    (sum(COALESCE(topoc.usedquantity, (0)::numeric)) + sum(COALESCE(topoc.wastesquantity, (0)::numeric))) AS donequantity,
    date(date_trunc('day'::text, pt.timerangefrom)) AS timerangefrom,
    date(date_trunc('day'::text, pt.timerangeto)) AS timerangeto,
    shift.name AS shiftname,
    tcontext.number AS technologygeneratornumber
   FROM ((((((((((public.arch_productioncounting_trackingoperationproductoutcomponent topoc
     JOIN public.arch_productioncounting_productiontracking pt ON ((pt.id = topoc.productiontracking_id)))
     JOIN public.arch_orders_order ord ON ((ord.id = pt.order_id)))
     JOIN public.basic_product product ON ((topoc.product_id = product.id)))
     JOIN public.technologies_technology technology ON ((technology.id = ord.technology_id)))
     LEFT JOIN public.basic_shift shift ON ((pt.shift_id = shift.id)))
     LEFT JOIN public.basic_assortment assortment ON ((product.assortment_id = assortment.id)))
     LEFT JOIN public.basic_size size ON ((size.id = product.size_id)))
     LEFT JOIN public.productionlines_productionline pl ON ((ord.productionline_id = pl.id)))
     LEFT JOIN public.basic_company c ON ((c.id = ord.company_id)))
     LEFT JOIN public.technologiesgenerator_generatorcontext tcontext ON ((tcontext.id = technology.generatorcontext_id)))
  WHERE ((ord.parent_id IS NULL) AND ((product.id = ord.product_id) OR ((pt.technologyoperationcomponent_id IS NOT NULL) AND ((topoc.typeofmaterial)::text = '02intermediate'::text)) OR ((topoc.typeofmaterial)::text = '05additionalFinalProduct'::text)))
  GROUP BY ord.number, shift.name, (date_trunc('day'::text, pt.timerangefrom)), (date_trunc('day'::text, pt.timerangeto)), pl.number, c.number, assortment.name, product.number, product.name, product.unit, size.number, tcontext.number;


--
-- Name: productioncounting_finalproductanalysisentry_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_finalproductanalysisentry_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_lack; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_lack (
    id bigint NOT NULL,
    trackingoperationproductoutcomponent_id bigint,
    lackquantity numeric(14,5),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: productioncounting_lack_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_lack_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_lack_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_lack_id_seq OWNED BY public.productioncounting_lack.id;


--
-- Name: productioncounting_lackreason; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_lackreason (
    id bigint NOT NULL,
    lack_id bigint,
    causeofwastes character varying(255),
    description character varying(1024),
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: productioncounting_lackdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_lackdto AS
 SELECT lack.id,
    (lack.trackingoperationproductoutcomponent_id)::integer AS trackingoperationproductoutcomponentid,
    lack.lackquantity,
    product.unit AS productunit,
    array_to_string(ARRAY( SELECT (((lackreason.causeofwastes)::text || ' - '::text) || (COALESCE(lackreason.description, ''::character varying))::text)
           FROM (public.productioncounting_lackreason lackreason
             LEFT JOIN public.productioncounting_lack l ON ((lackreason.lack_id = l.id)))
          WHERE (lackreason.lack_id = lack.id)), '</br>'::text) AS reasons
   FROM ((public.productioncounting_lack lack
     LEFT JOIN public.productioncounting_trackingoperationproductoutcomponent tooc ON ((tooc.id = lack.trackingoperationproductoutcomponent_id)))
     LEFT JOIN public.basic_product product ON ((product.id = tooc.product_id)));


--
-- Name: productioncounting_lackdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_lackdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_lackreason_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_lackreason_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_lackreason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_lackreason_id_seq OWNED BY public.productioncounting_lackreason.id;


--
-- Name: productioncounting_orderbalance; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_orderbalance (
    id bigint NOT NULL,
    productionbalance_id bigint,
    ordernumber character varying(255),
    productnumber character varying(255),
    productname character varying(255),
    plannedquantity numeric(12,5),
    producedquantity numeric(12,5),
    deviation numeric(12,5),
    productunit character varying(255),
    plannedmaterialcosts numeric(12,5),
    materialcosts numeric(12,5),
    materialcostsdeviation numeric(12,5),
    plannedproductioncosts numeric(12,5),
    productioncosts numeric(12,5),
    productioncostsdeviation numeric(12,5),
    technicalproductioncosts numeric(12,5),
    materialcostmargin numeric(12,5),
    materialcostmarginvalue numeric(12,5),
    productioncostmargin numeric(12,5),
    productioncostmarginvalue numeric(12,5),
    additionaloverhead numeric(12,5),
    directadditionalcost numeric(12,5),
    totalcosts numeric(12,5),
    registrationprice numeric(12,5),
    registrationpriceoverhead numeric(12,5),
    registrationpriceoverheadvalue numeric(12,5),
    realproductioncosts numeric(12,5),
    technicalproductioncostoverhead numeric(12,5),
    technicalproductioncostoverheadvalue numeric(12,5),
    totalmanufacturingcost numeric(12,5),
    profit numeric(12,5),
    profitvalue numeric(12,5),
    sellprice numeric(12,5),
    externalservicescost numeric(12,5)
);


--
-- Name: productioncounting_orderbalance_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_orderbalance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_orderbalance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_orderbalance_id_seq OWNED BY public.productioncounting_orderbalance.id;


--
-- Name: productioncounting_performanceanalysisdetaildto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_performanceanalysisdetaildto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_performanceanalysisdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_performanceanalysisdto AS
 SELECT row_number() OVER () AS id,
    bool_or(performanceanalysisdetaildto.active) AS active,
    performanceanalysisdetaildto.productionline_id,
    performanceanalysisdetaildto.productionlinenumber,
    performanceanalysisdetaildto.staff_id,
    performanceanalysisdetaildto.staffname,
    COALESCE((sum(performanceanalysisdetaildto.timebasedonnorms))::integer, 0) AS timebasedonnormssum,
        CASE
            WHEN (min(performanceanalysisdetaildto.labortimesum) <> max(performanceanalysisdetaildto.labortimesum)) THEN 0
            ELSE (min(performanceanalysisdetaildto.labortimesum))::integer
        END AS labortimesum,
        CASE
            WHEN (min(performanceanalysisdetaildto.labortimesum) <> max(performanceanalysisdetaildto.labortimesum)) THEN (COALESCE(sum(performanceanalysisdetaildto.timebasedonnorms), (0)::bigint))::integer
            ELSE (((COALESCE((sum(performanceanalysisdetaildto.timebasedonnorms))::integer, 0))::double precision - min(performanceanalysisdetaildto.labortimesum)))::integer
        END AS timedeviation,
        CASE
            WHEN (min(performanceanalysisdetaildto.labortimesum) <> max(performanceanalysisdetaildto.labortimesum)) THEN (0)::numeric
            ELSE (((((100)::numeric * (sum(performanceanalysisdetaildto.timebasedonnorms))::numeric))::double precision / min(performanceanalysisdetaildto.labortimesum)))::numeric(14,2)
        END AS performance,
    performanceanalysisdetaildto.shift_id,
    performanceanalysisdetaildto.shiftname,
    performanceanalysisdetaildto.timerangefromwithouttime AS timerangefrom,
    performanceanalysisdetaildto.timerangetowithouttime AS timerangeto,
    sum(performanceanalysisdetaildto.donequantity) AS donequantity,
    (min(helper.productionlinequantity))::integer AS productionlinequantity,
    (count(DISTINCT performanceanalysisdetaildto.assortment_id))::integer AS assortmentquantity,
    (min(helper.dailyperformance))::numeric(14,2) AS dailyperformance
   FROM (public.productioncounting_performanceanalysisdetaildto performanceanalysisdetaildto
     LEFT JOIN public.productioncounting_performanceanalysisdto_helper helper ON (((performanceanalysisdetaildto.staff_id = helper.staff_id) AND (performanceanalysisdetaildto.timerangefromwithouttime = helper.timerangefromwithouttime))))
  GROUP BY performanceanalysisdetaildto.productionline_id, performanceanalysisdetaildto.productionlinenumber, performanceanalysisdetaildto.staff_id, performanceanalysisdetaildto.staffname, performanceanalysisdetaildto.shift_id, performanceanalysisdetaildto.shiftname, performanceanalysisdetaildto.timerangefromwithouttime, performanceanalysisdetaildto.timerangetowithouttime;


--
-- Name: productioncounting_performanceanalysisdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_performanceanalysisdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_performanceanalysismv; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_performanceanalysismv AS
 SELECT mv_productioncounting_performanceanalysisdto.id,
    mv_productioncounting_performanceanalysisdto.active,
    mv_productioncounting_performanceanalysisdto.productionline_id,
    mv_productioncounting_performanceanalysisdto.productionlinenumber,
    mv_productioncounting_performanceanalysisdto.staff_id,
    mv_productioncounting_performanceanalysisdto.staffname,
    public.duration_to_string(mv_productioncounting_performanceanalysisdto.timebasedonnormssum) AS timebasedonnormssum,
    public.duration_to_string(mv_productioncounting_performanceanalysisdto.labortimesum) AS labortimesum,
    public.duration_to_string(mv_productioncounting_performanceanalysisdto.timedeviation) AS timedeviation,
    mv_productioncounting_performanceanalysisdto.performance,
    mv_productioncounting_performanceanalysisdto.shift_id,
    mv_productioncounting_performanceanalysisdto.shiftname,
    mv_productioncounting_performanceanalysisdto.timerangefrom,
    mv_productioncounting_performanceanalysisdto.timerangeto,
    mv_productioncounting_performanceanalysisdto.donequantity,
    mv_productioncounting_performanceanalysisdto.productionlinequantity,
    mv_productioncounting_performanceanalysisdto.assortmentquantity,
    mv_productioncounting_performanceanalysisdto.dailyperformance
   FROM public.mv_productioncounting_performanceanalysisdto;


--
-- Name: productioncounting_performanceanalysismv_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_performanceanalysismv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_prodoutresourceattrval; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_prodoutresourceattrval (
    id bigint NOT NULL,
    trackingoperationproductoutcomponent_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255)
);


--
-- Name: productioncounting_prodoutresourceattrval_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_prodoutresourceattrval_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_prodoutresourceattrval_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_prodoutresourceattrval_id_seq OWNED BY public.productioncounting_prodoutresourceattrval.id;


--
-- Name: productioncounting_productionanalysisdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_productionanalysisdto AS
SELECT
    NULL::bigint AS id,
    NULL::boolean AS active,
    NULL::integer AS productionline_id,
    NULL::character varying(255) AS productionlinenumber,
    NULL::integer AS company_id,
    NULL::character varying(255) AS companynumber,
    NULL::integer AS staff_id,
    NULL::text AS staffname,
    NULL::integer AS assortment_id,
    NULL::character varying(255) AS assortmentname,
    NULL::integer AS product_id,
    NULL::character varying(255) AS productnumber,
    NULL::character varying(1024) AS productname,
    NULL::character varying(255) AS productunit,
    NULL::character varying(255) AS sizenumber,
    NULL::numeric AS usedquantity,
    NULL::numeric AS wastesquantity,
    NULL::numeric AS donequantity,
    NULL::character varying(255) AS causeofwastes,
    NULL::integer AS shift_id,
    NULL::character varying(1024) AS shiftname,
    NULL::date AS timerangefrom,
    NULL::date AS timerangeto,
    NULL::integer AS generator_id,
    NULL::character varying(255) AS generatorname,
    NULL::integer AS order_id,
    NULL::character varying(255) AS ordernumber,
    NULL::character varying(255) AS obtainedmasterordernumber,
    NULL::character varying(255) AS technologygroupnumber,
    NULL::character varying(255) AS typeofmaterial;


--
-- Name: productioncounting_productionanalysisdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_productionanalysisdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_productionbalance; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_productionbalance (
    id bigint NOT NULL,
    generated boolean,
    name character varying(1024),
    date timestamp without time zone,
    worker character varying(255),
    description character varying(255),
    filename character varying(1024),
    includetpz boolean DEFAULT true,
    includeadditionaltime boolean DEFAULT false,
    materialcostmargin numeric(12,5) DEFAULT (0)::numeric,
    materialcostsused character varying(255) DEFAULT '01nominal'::character varying,
    productioncostmargin numeric(12,5) DEFAULT (0)::numeric,
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0,
    sourceofoperationcosts character varying(255) DEFAULT '01technologyOperation'::character varying,
    registrationpriceoverhead numeric,
    profit numeric,
    number character varying(255),
    additionaloverhead numeric(12,5) DEFAULT (0)::numeric,
    includewagegroups boolean DEFAULT false,
    technicalproductioncostoverhead numeric(12,5) DEFAULT 0
);


--
-- Name: productioncounting_productionbalance_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_productionbalance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_productionbalance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_productionbalance_id_seq OWNED BY public.productioncounting_productionbalance.id;


--
-- Name: productioncounting_productiontracking_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_productiontracking_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_productiontracking_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_productiontracking_id_seq OWNED BY public.productioncounting_productiontracking.id;


--
-- Name: productioncounting_productiontracking_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_productiontracking_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_productiontrackingattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_productiontrackingattachment (
    id bigint NOT NULL,
    productiontracking_id bigint,
    attachment character varying(255),
    name character varying(255),
    size numeric(12,5),
    ext character varying(255)
);


--
-- Name: productioncounting_productiontrackingattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_productiontrackingattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_productiontrackingattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_productiontrackingattachment_id_seq OWNED BY public.productioncounting_productiontrackingattachment.id;


--
-- Name: productioncounting_productiontrackingdraftdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_productiontrackingdraftdto AS
 SELECT productiontracking.id,
    productiontracking.number,
    productiontracking.state,
    productiontracking.createdate,
    productiontracking.lasttracking,
    productiontracking.timerangefrom,
    productiontracking.timerangeto,
    productiontracking.active,
    (ordersorder.id)::integer AS order_id,
    ordersorder.number AS ordernumber,
    ordersorder.state AS orderstate,
    (technologyoperationcomponent.id)::integer AS technologyoperationcomponent_id,
    COALESCE((((technologyoperationcomponent.nodenumber)::text || ' '::text) || (operation.name)::text), ''::text) AS technologyoperationcomponentnumber,
    (operation.id)::integer AS operation_id,
    (shift.id)::integer AS shift_id,
    shift.name AS shiftname,
    (staff.id)::integer AS staff_id,
    (((staff.surname)::text || ' '::text) || (staff.name)::text) AS staffname,
    (division.id)::integer AS division_id,
    division.number AS divisionnumber,
    (subcontractor.id)::integer AS subcontractor_id,
    subcontractor.name AS subcontractorname,
    (repairorder.id)::integer AS repairorder_id,
    repairorder.number AS repairordernumber,
    productiontrackingcorrection.number AS correctionnumber,
    (productionline.id)::integer AS productionline_id,
    productionline.number AS productionlinenumber,
    ordersgroup.number AS ordersgroup,
    concat(product.number, ' - ', product.name) AS productnumber,
    product.unit AS productunit,
    outcomponent.usedquantity,
    company.number AS companynumber,
    COALESCE((((outproduct.number)::text || ' - '::text) || (outproduct.name)::text), (((product.number)::text || ' - '::text) || (product.name)::text)) AS outproductnumber
   FROM ((((((((((((((((public.productioncounting_productiontracking productiontracking
     JOIN public.orders_order ordersorder ON ((ordersorder.id = productiontracking.order_id)))
     JOIN public.basic_product product ON ((ordersorder.product_id = product.id)))
     JOIN public.productionlines_productionline productionline ON ((productionline.id = ordersorder.productionline_id)))
     LEFT JOIN public.technologies_technologyoperationcomponent technologyoperationcomponent ON ((technologyoperationcomponent.id = productiontracking.technologyoperationcomponent_id)))
     LEFT JOIN public.technologies_operation operation ON ((operation.id = technologyoperationcomponent.operation_id)))
     LEFT JOIN public.basic_shift shift ON ((shift.id = productiontracking.shift_id)))
     LEFT JOIN public.basic_staff staff ON ((staff.id = productiontracking.staff_id)))
     LEFT JOIN public.basic_division division ON ((division.id = productiontracking.division_id)))
     LEFT JOIN public.basic_company subcontractor ON ((subcontractor.id = productiontracking.subcontractor_id)))
     LEFT JOIN public.productioncounting_productiontracking productiontrackingcorrection ON ((productiontrackingcorrection.id = productiontracking.correction_id)))
     LEFT JOIN public.repairs_repairorder repairorder ON ((repairorder.id = productiontracking.repairorder_id)))
     LEFT JOIN public.ordersgroups_ordersgroup ordersgroup ON ((ordersgroup.id = ordersorder.ordersgroup_id)))
     LEFT JOIN public.basic_company company ON ((company.id = ordersorder.company_id)))
     LEFT JOIN public.basicproductioncounting_productioncountingquantity pcq ON (((pcq.order_id = ordersorder.id) AND (pcq.technologyoperationcomponent_id = technologyoperationcomponent.id) AND ((pcq.typeofmaterial)::text = ANY (ARRAY[('02intermediate'::character varying)::text, ('03finalProduct'::character varying)::text])) AND ((pcq.role)::text = '02produced'::text))))
     LEFT JOIN public.basic_product outproduct ON ((pcq.product_id = outproduct.id)))
     LEFT JOIN public.productioncounting_trackingoperationproductoutcomponent outcomponent ON ((((outcomponent.product_id = outproduct.id) OR (outcomponent.product_id = product.id)) AND (productiontracking.id = outcomponent.productiontracking_id))))
  WHERE ((productiontracking.state)::text = '01draft'::text);


--
-- Name: productioncounting_productiontrackingdraftdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_productiontrackingdraftdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_productiontrackingdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_productiontrackingdto AS
 SELECT productiontracking.id,
    productiontracking.number,
    productiontracking.state,
    productiontracking.createdate,
    productiontracking.lasttracking,
    productiontracking.timerangefrom,
    productiontracking.timerangeto,
        CASE
            WHEN (productiontracking.shiftstartday IS NULL) THEN (productiontracking.createdate)::date
            ELSE productiontracking.shiftstartday
        END AS datefromforoee,
        CASE
            WHEN (productiontracking.shiftstartday IS NULL) THEN (productiontracking.createdate)::date
            ELSE productiontracking.shiftstartday
        END AS datetoforoee,
    productiontracking.active,
    (ordersorder.id)::integer AS order_id,
    ordersorder.number AS ordernumber,
    ordersorder.state AS orderstate,
    ordersorder.startdate AS orderstartdate,
    (technologyoperationcomponent.id)::integer AS technologyoperationcomponent_id,
    COALESCE((((technologyoperationcomponent.nodenumber)::text || ' '::text) || (operation.name)::text), ''::text) AS technologyoperationcomponentnumber,
    (operation.id)::integer AS operation_id,
    (shift.id)::integer AS shift_id,
    shift.name AS shiftname,
    (staff.id)::integer AS staff_id,
    (((staff.surname)::text || ' '::text) || (staff.name)::text) AS staffname,
    (division.id)::integer AS division_id,
    division.number AS divisionnumber,
    (subcontractor.id)::integer AS subcontractor_id,
    subcontractor.name AS subcontractorname,
    (repairorder.id)::integer AS repairorder_id,
    repairorder.number AS repairordernumber,
    productiontrackingcorrection.number AS correctionnumber,
    (productionline.id)::integer AS productionline_id,
    productionline.number AS productionlinenumber,
    ordersgroup.number AS ordersgroup,
    concat(product.number, ' - ', product.name) AS productnumber,
    product.unit AS productunit,
    outcomponent.usedquantity,
    company.number AS companynumber,
    COALESCE((((outproduct.number)::text || ' - '::text) || (outproduct.name)::text), (((product.number)::text || ' - '::text) || (product.name)::text)) AS outproductnumber,
    productiontracking.shiftstartday,
    productiontracking.createuser,
    workstation.number AS workstationnumber,
    productiontracking.comments
   FROM (((((((((((((((((public.productioncounting_productiontracking productiontracking
     JOIN public.orders_order ordersorder ON ((ordersorder.id = productiontracking.order_id)))
     JOIN public.basic_product product ON ((ordersorder.product_id = product.id)))
     JOIN public.productionlines_productionline productionline ON ((productionline.id = ordersorder.productionline_id)))
     LEFT JOIN public.technologies_technologyoperationcomponent technologyoperationcomponent ON ((technologyoperationcomponent.id = productiontracking.technologyoperationcomponent_id)))
     LEFT JOIN public.technologies_operation operation ON ((operation.id = technologyoperationcomponent.operation_id)))
     LEFT JOIN public.basic_shift shift ON ((shift.id = productiontracking.shift_id)))
     LEFT JOIN public.basic_staff staff ON ((staff.id = productiontracking.staff_id)))
     LEFT JOIN public.basic_division division ON ((division.id = productiontracking.division_id)))
     LEFT JOIN public.basic_company subcontractor ON ((subcontractor.id = productiontracking.subcontractor_id)))
     LEFT JOIN public.basic_workstation workstation ON ((workstation.id = productiontracking.workstation_id)))
     LEFT JOIN public.productioncounting_productiontracking productiontrackingcorrection ON ((productiontrackingcorrection.id = productiontracking.correction_id)))
     LEFT JOIN public.repairs_repairorder repairorder ON ((repairorder.id = productiontracking.repairorder_id)))
     LEFT JOIN public.ordersgroups_ordersgroup ordersgroup ON ((ordersgroup.id = ordersorder.ordersgroup_id)))
     LEFT JOIN public.basic_company company ON ((company.id = ordersorder.company_id)))
     LEFT JOIN public.basicproductioncounting_productioncountingquantity pcq ON (((pcq.order_id = ordersorder.id) AND (pcq.technologyoperationcomponent_id = technologyoperationcomponent.id) AND ((pcq.typeofmaterial)::text = ANY (ARRAY[('02intermediate'::character varying)::text, ('03finalProduct'::character varying)::text])) AND ((pcq.role)::text = '02produced'::text))))
     LEFT JOIN public.basic_product outproduct ON ((pcq.product_id = outproduct.id)))
     LEFT JOIN public.productioncounting_trackingoperationproductoutcomponent outcomponent ON ((((outcomponent.product_id = outproduct.id) OR (outcomponent.product_id = product.id)) AND (productiontracking.id = outcomponent.productiontracking_id))));


--
-- Name: productioncounting_productiontrackingdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_productiontrackingdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_trackingoperationproductincomponenthelper; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_trackingoperationproductincomponenthelper AS
SELECT
    NULL::bigint AS id,
    NULL::integer AS productiontracking_id,
    NULL::integer AS product_id,
    NULL::character varying(255) AS productnumber,
    NULL::character varying(1024) AS productname,
    NULL::character varying(255) AS productunit,
    NULL::numeric AS plannedquantity,
    NULL::numeric(14,5) AS usedquantity,
    NULL::character varying(255) AS batchnumber,
    NULL::character varying(255) AS producedbatchnumber;


--
-- Name: productioncounting_trackingoperationproductoutcomponenthelper; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_trackingoperationproductoutcomponenthelper AS
SELECT
    NULL::bigint AS id,
    NULL::integer AS productiontracking_id,
    NULL::integer AS product_id,
    NULL::character varying(255) AS productnumber,
    NULL::character varying(1024) AS productname,
    NULL::character varying(255) AS productunit,
    NULL::numeric AS plannedquantity,
    NULL::numeric(14,5) AS usedquantity,
    NULL::character varying(255) AS batchnumber,
    NULL::character varying(255) AS producedbatchnumber;


--
-- Name: productioncounting_trackingoperationproductcomponentdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_trackingoperationproductcomponentdto AS
 SELECT row_number() OVER () AS id,
    trackingoperationproductcomponentdto.productiontracking_id,
    trackingoperationproductcomponentdto.product_id,
    trackingoperationproductcomponentdto.productnumber,
    trackingoperationproductcomponentdto.productname,
    trackingoperationproductcomponentdto.productunit,
    trackingoperationproductcomponentdto.plannedquantity,
    trackingoperationproductcomponentdto.usedquantity,
    trackingoperationproductcomponentdto.batchnumber,
    trackingoperationproductcomponentdto.typeofrecord,
    trackingoperationproductcomponentdto.producedbatchnumber
   FROM ( SELECT trackingoperationproductincomponentdto.productiontracking_id,
            trackingoperationproductincomponentdto.product_id,
            trackingoperationproductincomponentdto.productnumber,
            trackingoperationproductincomponentdto.productname,
            trackingoperationproductincomponentdto.productunit,
            trackingoperationproductincomponentdto.plannedquantity,
            trackingoperationproductincomponentdto.usedquantity,
            trackingoperationproductincomponentdto.batchnumber,
            '01in'::text AS typeofrecord,
            COALESCE(outtracking.producedbatchnumber, outtracking.batchnumber) AS producedbatchnumber
           FROM (public.productioncounting_trackingoperationproductincomponenthelper trackingoperationproductincomponentdto
             LEFT JOIN public.productioncounting_trackingoperationproductoutcomponenthelper outtracking ON ((outtracking.productiontracking_id = trackingoperationproductincomponentdto.productiontracking_id)))
        UNION
         SELECT trackingoperationproductoutcomponentdto.productiontracking_id,
            trackingoperationproductoutcomponentdto.product_id,
            trackingoperationproductoutcomponentdto.productnumber,
            trackingoperationproductoutcomponentdto.productname,
            trackingoperationproductoutcomponentdto.productunit,
            trackingoperationproductoutcomponentdto.plannedquantity,
            trackingoperationproductoutcomponentdto.usedquantity,
            ''::text AS batchnumber,
            '02out'::text AS typeofrecord,
            COALESCE(trackingoperationproductoutcomponentdto.producedbatchnumber, trackingoperationproductoutcomponentdto.batchnumber) AS producedbatchnumber
           FROM public.productioncounting_trackingoperationproductoutcomponenthelper trackingoperationproductoutcomponentdto) trackingoperationproductcomponentdto;


--
-- Name: productioncounting_productiontrackingforproductdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_productiontrackingforproductdto AS
 SELECT row_number() OVER () AS id,
    productiontrackingdto.number,
    productiontrackingdto.state,
    productiontrackingdto.createdate,
    productiontrackingdto.lasttracking,
    productiontrackingdto.timerangefrom,
    productiontrackingdto.timerangeto,
    productiontrackingdto.active,
    productiontrackingdto.order_id,
    productiontrackingdto.ordernumber,
    productiontrackingdto.orderstate,
    productiontrackingdto.orderstartdate,
    productiontrackingdto.technologyoperationcomponent_id,
    productiontrackingdto.technologyoperationcomponentnumber,
    productiontrackingdto.operation_id,
    productiontrackingdto.shift_id,
    productiontrackingdto.shiftname,
    productiontrackingdto.staff_id,
    productiontrackingdto.staffname,
    productiontrackingdto.division_id,
    productiontrackingdto.divisionnumber,
    productiontrackingdto.subcontractor_id,
    productiontrackingdto.subcontractorname,
    trackingoperationproductcomponentdto.product_id,
    trackingoperationproductcomponentdto.productnumber,
    trackingoperationproductcomponentdto.productname,
    trackingoperationproductcomponentdto.productunit,
    trackingoperationproductcomponentdto.plannedquantity,
    COALESCE(trackingoperationproductcomponentdto.usedquantity, (0)::numeric(14,5)) AS usedquantity,
    (productiontrackingdto.id)::integer AS productiontracking_id,
    trackingoperationproductcomponentdto.batchnumber,
    trackingoperationproductcomponentdto.typeofrecord,
    trackingoperationproductcomponentdto.producedbatchnumber
   FROM (public.productioncounting_trackingoperationproductcomponentdto trackingoperationproductcomponentdto
     LEFT JOIN public.productioncounting_productiontrackingdto productiontrackingdto ON ((productiontrackingdto.id = trackingoperationproductcomponentdto.productiontracking_id)));


--
-- Name: productioncounting_productiontrackingforproductdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_productiontrackingforproductdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_productiontrackingforproductgroupeddto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_productiontrackingforproductgroupeddto AS
 SELECT row_number() OVER () AS id,
    productiontrackingforproductdto.active,
    productiontrackingforproductdto.order_id,
    productiontrackingforproductdto.ordernumber,
    (productiontrackingforproductdto.orderstartdate)::date AS orderstartdate,
    productiontrackingforproductdto.technologyoperationcomponent_id,
    productiontrackingforproductdto.technologyoperationcomponentnumber,
    productiontrackingforproductdto.operation_id,
    productiontrackingforproductdto.product_id,
    productiontrackingforproductdto.productnumber,
    productiontrackingforproductdto.productname,
    productiontrackingforproductdto.productunit,
    productiontrackingforproductdto.plannedquantity,
    sum(productiontrackingforproductdto.usedquantity) AS usedquantity,
    (sum(productiontrackingforproductdto.usedquantity) - productiontrackingforproductdto.plannedquantity) AS quantitydeviation,
    productiontrackingforproductdto.typeofrecord
   FROM public.productioncounting_productiontrackingforproductdto productiontrackingforproductdto
  GROUP BY productiontrackingforproductdto.active, productiontrackingforproductdto.order_id, productiontrackingforproductdto.ordernumber, productiontrackingforproductdto.orderstartdate, productiontrackingforproductdto.technologyoperationcomponent_id, productiontrackingforproductdto.technologyoperationcomponentnumber, productiontrackingforproductdto.operation_id, productiontrackingforproductdto.product_id, productiontrackingforproductdto.productnumber, productiontrackingforproductdto.productname, productiontrackingforproductdto.productunit, productiontrackingforproductdto.plannedquantity, productiontrackingforproductdto.typeofrecord;


--
-- Name: productioncounting_productiontrackingforproductgroupeddto_id_se; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_productiontrackingforproductgroupeddto_id_se
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_productiontrackingstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_productiontrackingstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255) DEFAULT '01inProgress'::character varying,
    phase integer,
    worker character varying(255),
    productiontracking_id bigint,
    shift_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: productioncounting_productiontrackingstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_productiontrackingstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_productiontrackingstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_productiontrackingstatechange_id_seq OWNED BY public.productioncounting_productiontrackingstatechange.id;


--
-- Name: productioncounting_staffworktime; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_staffworktime (
    id bigint NOT NULL,
    productionrecord_id bigint,
    worker_id bigint,
    labortime integer DEFAULT 0,
    effectiveexecutiontimestart timestamp without time zone,
    effectiveexecutiontimeend timestamp without time zone,
    entityversion bigint DEFAULT 0
);


--
-- Name: productioncounting_staffworktime_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_staffworktime_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_staffworktime_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_staffworktime_id_seq OWNED BY public.productioncounting_staffworktime.id;


--
-- Name: productioncounting_trackinginproductreplacementhelper; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_trackinginproductreplacementhelper (
    id bigint NOT NULL,
    productiontracking_id bigint,
    product_id bigint,
    quantity numeric(14,5),
    basicproduct_id bigint
);


--
-- Name: productioncounting_trackinginproductreplacementhelper_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_trackinginproductreplacementhelper_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_trackinginproductreplacementhelper_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_trackinginproductreplacementhelper_id_seq OWNED BY public.productioncounting_trackinginproductreplacementhelper.id;


--
-- Name: productioncounting_trackingoperationproductcomponentdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_trackingoperationproductcomponentdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_trackingoperationproductincomponent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_trackingoperationproductincomponent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_trackingoperationproductincomponent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_trackingoperationproductincomponent_id_seq OWNED BY public.productioncounting_trackingoperationproductincomponent.id;


--
-- Name: productioncounting_usedbatch; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productioncounting_usedbatch (
    id bigint NOT NULL,
    trackingoperationproductincomponent_id bigint,
    batch_id bigint,
    quantity numeric(14,5)
);


--
-- Name: productioncounting_trackingoperationproductincomponentdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_trackingoperationproductincomponentdto AS
 SELECT trackingoperationproductincomponent.id,
    (productiontracking.id)::integer AS productiontrackingid,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    (product.id)::integer AS productid,
    COALESCE(sum(productioncountingquantity.plannedquantity), (0)::numeric) AS plannedquantity,
    trackingoperationproductincomponent.usedquantity,
    trackingoperationproductincomponent.obtainedquantity,
    trackingoperationproductincomponent.remainedquantity,
    trackingoperationproductincomponent.effectiveusedquantity,
    (string_agg((batch.number)::text, ', '::text))::character varying(255) AS batchnumber,
        CASE
            WHEN (( SELECT count(*) AS count
               FROM public.basic_substitutecomponent
              WHERE (basic_substitutecomponent.baseproduct_id = product.id)) > 0) THEN true
            ELSE false
        END AS replacement,
    productreplacement.number AS productreplacementnumber,
    (productreplacement.id)::integer AS productreplacementid
   FROM ((((((public.productioncounting_trackingoperationproductincomponent trackingoperationproductincomponent
     LEFT JOIN public.productioncounting_productiontracking productiontracking ON ((productiontracking.id = trackingoperationproductincomponent.productiontracking_id)))
     LEFT JOIN public.basic_product product ON ((product.id = trackingoperationproductincomponent.product_id)))
     LEFT JOIN public.basic_product productreplacement ON ((productreplacement.id = trackingoperationproductincomponent.replacementto_id)))
     LEFT JOIN public.productioncounting_usedbatch usedbatch ON ((usedbatch.trackingoperationproductincomponent_id = trackingoperationproductincomponent.id)))
     LEFT JOIN public.advancedgenealogy_batch batch ON ((batch.id = usedbatch.batch_id)))
     LEFT JOIN public.basicproductioncounting_productioncountingquantity productioncountingquantity ON (((productioncountingquantity.order_id = productiontracking.order_id) AND (productioncountingquantity.product_id = trackingoperationproductincomponent.product_id) AND ((productioncountingquantity.role)::text = '01used'::text))))
  WHERE (productiontracking.technologyoperationcomponent_id IS NULL)
  GROUP BY trackingoperationproductincomponent.id, productiontracking.id, product.number, product.name, product.unit, product.id, trackingoperationproductincomponent.usedquantity, trackingoperationproductincomponent.obtainedquantity, trackingoperationproductincomponent.remainedquantity, trackingoperationproductincomponent.effectiveusedquantity, productreplacement.number, productreplacement.id
UNION
 SELECT trackingoperationproductincomponent.id,
    (productiontracking.id)::integer AS productiontrackingid,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    (product.id)::integer AS productid,
    COALESCE(sum(productioncountingquantity.plannedquantity), (0)::numeric) AS plannedquantity,
    trackingoperationproductincomponent.usedquantity,
    trackingoperationproductincomponent.obtainedquantity,
    trackingoperationproductincomponent.remainedquantity,
    trackingoperationproductincomponent.effectiveusedquantity,
    (string_agg((batch.number)::text, ', '::text))::character varying(255) AS batchnumber,
        CASE
            WHEN (( SELECT count(*) AS count
               FROM public.basic_substitutecomponent
              WHERE (basic_substitutecomponent.baseproduct_id = product.id)) > 0) THEN true
            ELSE false
        END AS replacement,
    productreplacement.number AS productreplacementnumber,
    (productreplacement.id)::integer AS productreplacementid
   FROM ((((((public.productioncounting_trackingoperationproductincomponent trackingoperationproductincomponent
     LEFT JOIN public.productioncounting_productiontracking productiontracking ON ((productiontracking.id = trackingoperationproductincomponent.productiontracking_id)))
     LEFT JOIN public.basic_product product ON ((product.id = trackingoperationproductincomponent.product_id)))
     LEFT JOIN public.basic_product productreplacement ON ((productreplacement.id = trackingoperationproductincomponent.replacementto_id)))
     LEFT JOIN public.productioncounting_usedbatch usedbatch ON ((usedbatch.trackingoperationproductincomponent_id = trackingoperationproductincomponent.id)))
     LEFT JOIN public.advancedgenealogy_batch batch ON ((batch.id = usedbatch.batch_id)))
     LEFT JOIN public.basicproductioncounting_productioncountingquantity productioncountingquantity ON (((productioncountingquantity.order_id = productiontracking.order_id) AND (productioncountingquantity.technologyoperationcomponent_id = productiontracking.technologyoperationcomponent_id) AND (productioncountingquantity.product_id = trackingoperationproductincomponent.product_id) AND ((productioncountingquantity.role)::text = '01used'::text))))
  WHERE (productiontracking.technologyoperationcomponent_id IS NOT NULL)
  GROUP BY trackingoperationproductincomponent.id, productiontracking.id, product.number, product.name, product.unit, product.id, trackingoperationproductincomponent.usedquantity, trackingoperationproductincomponent.obtainedquantity, trackingoperationproductincomponent.remainedquantity, trackingoperationproductincomponent.effectiveusedquantity, productiontracking.technologyoperationcomponent_id, productreplacement.number, productreplacement.id;


--
-- Name: productioncounting_trackingoperationproductincomponentdto_id_se; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_trackingoperationproductincomponentdto_id_se
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_trackingoperationproductincomponenthelper_id; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_trackingoperationproductincomponenthelper_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_trackingoperationproductoutcomponent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_trackingoperationproductoutcomponent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_trackingoperationproductoutcomponent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_trackingoperationproductoutcomponent_id_seq OWNED BY public.productioncounting_trackingoperationproductoutcomponent.id;


--
-- Name: productioncounting_trackingoperationproductoutcomponentdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.productioncounting_trackingoperationproductoutcomponentdto AS
SELECT
    NULL::bigint AS id,
    NULL::integer AS productiontrackingid,
    NULL::character varying(255) AS productnumber,
    NULL::character varying(1024) AS productname,
    NULL::character varying(255) AS productunit,
    NULL::numeric AS plannedquantity,
    NULL::numeric AS producedsum,
    NULL::numeric AS wastessum,
    NULL::numeric AS remainingquantity,
    NULL::numeric(14,5) AS wastesquantity,
    NULL::numeric(14,5) AS usedquantity,
    NULL::numeric(14,5) AS wastedquantity,
    NULL::character varying(255) AS batchnumber,
    NULL::character varying(255) AS typeofmaterial;


--
-- Name: productioncounting_trackingoperationproductoutcomponentdto_id_s; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_trackingoperationproductoutcomponentdto_id_s
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_trackingoperationproductoutcomponenthelper_i; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_trackingoperationproductoutcomponenthelper_i
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_usedbatch_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productioncounting_usedbatch_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productioncounting_usedbatch_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productioncounting_usedbatch_id_seq OWNED BY public.productioncounting_usedbatch.id;


--
-- Name: productionlines_factorystructureelement; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionlines_factorystructureelement (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(255),
    parent_id bigint,
    priority integer,
    nodenumber character varying(255),
    entitytype character varying(255) DEFAULT 'factory'::character varying,
    current boolean DEFAULT false,
    subassembly_id bigint,
    workstation_id bigint,
    entityid integer,
    maintenanceevent_id bigint,
    entityversion bigint DEFAULT 0,
    productionline_id bigint
);


--
-- Name: productionlines_factorystructureelement_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionlines_factorystructureelement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionlines_factorystructureelement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionlines_factorystructureelement_id_seq OWNED BY public.productionlines_factorystructureelement.id;


--
-- Name: productionlines_productionline_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionlines_productionline_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionlines_productionline_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionlines_productionline_id_seq OWNED BY public.productionlines_productionline.id;


--
-- Name: productionlines_workstationtypecomponent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionlines_workstationtypecomponent (
    id bigint NOT NULL,
    productionline_id bigint,
    workstationtype_id bigint,
    quantity integer DEFAULT 1,
    entityversion bigint DEFAULT 0,
    datefrom timestamp without time zone,
    dateto timestamp without time zone
);


--
-- Name: productionlines_workstationtypecomponent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionlines_workstationtypecomponent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionlines_workstationtypecomponent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionlines_workstationtypecomponent_id_seq OWNED BY public.productionlines_workstationtypecomponent.id;


--
-- Name: productionpershift_balance; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionpershift_balance (
    id bigint NOT NULL,
    context_id bigint,
    day date,
    shiftname character varying(255),
    ordernumber character varying(255),
    productnumber character varying(255),
    productunit character varying(255),
    registeredquantity numeric(14,5),
    plannedquantity numeric(12,5),
    difference numeric(14,5),
    percentagedeviation numeric(16,5),
    entityversion bigint DEFAULT 0
);


--
-- Name: productionpershift_balance_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionpershift_balance_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionpershift_balance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionpershift_balance_id_seq OWNED BY public.productionpershift_balance.id;


--
-- Name: productionpershift_balancecontext; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionpershift_balancecontext (
    id bigint NOT NULL,
    fromdate date,
    todate date,
    viewisinitialized boolean,
    plannedquantityrequired boolean,
    deviationrequired boolean,
    deviationthreshold numeric(16,5),
    entityversion bigint DEFAULT 0
);


--
-- Name: productionpershift_balancecontext_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionpershift_balancecontext_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionpershift_balancecontext_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionpershift_balancecontext_id_seq OWNED BY public.productionpershift_balancecontext.id;


--
-- Name: productionpershift_dailyprogress; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionpershift_dailyprogress (
    id bigint NOT NULL,
    progressforday_id bigint,
    shift_id bigint,
    quantity numeric(12,5),
    locked boolean DEFAULT false,
    entityversion bigint DEFAULT 0,
    efficiencytime integer
);


--
-- Name: productionpershift_dailyprogress_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionpershift_dailyprogress_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionpershift_dailyprogress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionpershift_dailyprogress_id_seq OWNED BY public.productionpershift_dailyprogress.id;


--
-- Name: productionpershift_plandailyprogress; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionpershift_plandailyprogress (
    id bigint NOT NULL,
    progressforday_id bigint,
    shift_id bigint,
    quantity numeric(12,5),
    efficiencytime integer
);


--
-- Name: productionpershift_plandailyprogress_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionpershift_plandailyprogress_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionpershift_plandailyprogress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionpershift_plandailyprogress_id_seq OWNED BY public.productionpershift_plandailyprogress.id;


--
-- Name: productionpershift_planproductionpershift; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionpershift_planproductionpershift (
    id bigint NOT NULL,
    order_id bigint,
    productionlineschedule_id bigint,
    productionline_id bigint
);


--
-- Name: productionpershift_planproductionpershift_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionpershift_planproductionpershift_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionpershift_planproductionpershift_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionpershift_planproductionpershift_id_seq OWNED BY public.productionpershift_planproductionpershift.id;


--
-- Name: productionpershift_planprogressforday; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionpershift_planprogressforday (
    id bigint NOT NULL,
    day integer,
    dateofday date,
    actualdateofday date,
    productionpershift_id bigint
);


--
-- Name: productionpershift_planprogressforday_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionpershift_planprogressforday_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionpershift_planprogressforday_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionpershift_planprogressforday_id_seq OWNED BY public.productionpershift_planprogressforday.id;


--
-- Name: productionpershift_ppsreport; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionpershift_ppsreport (
    id bigint NOT NULL,
    number character varying(1024),
    name character varying(1024),
    datefrom date,
    dateto date,
    filename character varying(255),
    generated boolean DEFAULT false,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: productionpershift_ppsreport_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionpershift_ppsreport_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionpershift_ppsreport_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionpershift_ppsreport_id_seq OWNED BY public.productionpershift_ppsreport.id;


--
-- Name: productionpershift_productionpershift; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionpershift_productionpershift (
    id bigint NOT NULL,
    order_id bigint,
    plannedprogresscorrectioncomment text,
    orderfinishdate timestamp without time zone,
    entityversion bigint DEFAULT 0
);


--
-- Name: productionpershift_productionpershift_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionpershift_productionpershift_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionpershift_productionpershift_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionpershift_productionpershift_id_seq OWNED BY public.productionpershift_productionpershift.id;


--
-- Name: productionpershift_progressforday; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionpershift_progressforday (
    id bigint NOT NULL,
    day integer,
    corrected boolean DEFAULT false,
    dateofday date,
    actualdateofday date,
    entityversion bigint DEFAULT 0,
    productionpershift_id bigint
);


--
-- Name: productionpershift_progressforday_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionpershift_progressforday_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionpershift_progressforday_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionpershift_progressforday_id_seq OWNED BY public.productionpershift_progressforday.id;


--
-- Name: productionpershift_reasontypeofcorrectionplan; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionpershift_reasontypeofcorrectionplan (
    id bigint NOT NULL,
    productionpershift_id bigint,
    reasontype character varying(255),
    date timestamp without time zone,
    entityversion bigint DEFAULT 0
);


--
-- Name: productionpershift_reasontypeofcorrectionplan_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionpershift_reasontypeofcorrectionplan_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionpershift_reasontypeofcorrectionplan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionpershift_reasontypeofcorrectionplan_id_seq OWNED BY public.productionpershift_reasontypeofcorrectionplan.id;


--
-- Name: productionplans_dimensioncontrolattribute; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionplans_dimensioncontrolattribute (
    id bigint NOT NULL,
    parameter_id bigint,
    attribute_id bigint
);


--
-- Name: productionplans_dimensioncontrolattribute_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionplans_dimensioncontrolattribute_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionplans_dimensioncontrolattribute_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionplans_dimensioncontrolattribute_id_seq OWNED BY public.productionplans_dimensioncontrolattribute.id;


--
-- Name: productionscheduling_opercomptimecalculation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionscheduling_opercomptimecalculation (
    id bigint NOT NULL,
    ordertimecalculation_id bigint,
    technologyoperationcomponent_id bigint,
    operationoffset integer,
    effectiveoperationrealizationtime integer,
    effectivedatefrom timestamp without time zone,
    effectivedateto timestamp without time zone,
    duration integer DEFAULT 0,
    machineworktime integer DEFAULT 0,
    laborworktime integer DEFAULT 0
);


--
-- Name: productionscheduling_opercomptimecalculation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionscheduling_opercomptimecalculation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionscheduling_opercomptimecalculation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionscheduling_opercomptimecalculation_id_seq OWNED BY public.productionscheduling_opercomptimecalculation.id;


--
-- Name: productionscheduling_ordertimecalculation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionscheduling_ordertimecalculation (
    id bigint NOT NULL,
    order_id bigint,
    effectivedatefrom timestamp without time zone,
    effectivedateto timestamp without time zone
);


--
-- Name: productionscheduling_ordertimecalculation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionscheduling_ordertimecalculation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionscheduling_ordertimecalculation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionscheduling_ordertimecalculation_id_seq OWNED BY public.productionscheduling_ordertimecalculation.id;


--
-- Name: productionscheduling_planopercomptimecalculation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionscheduling_planopercomptimecalculation (
    id bigint NOT NULL,
    ordertimecalculation_id bigint,
    technologyoperationcomponent_id bigint,
    operationoffset integer,
    effectiveoperationrealizationtime integer,
    effectivedatefrom timestamp without time zone,
    effectivedateto timestamp without time zone
);


--
-- Name: productionscheduling_planopercomptimecalculation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionscheduling_planopercomptimecalculation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionscheduling_planopercomptimecalculation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionscheduling_planopercomptimecalculation_id_seq OWNED BY public.productionscheduling_planopercomptimecalculation.id;


--
-- Name: productionscheduling_planordertimecalculation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.productionscheduling_planordertimecalculation (
    id bigint NOT NULL,
    order_id bigint,
    productionlineschedule_id bigint,
    productionline_id bigint,
    effectivedatefrom timestamp without time zone,
    effectivedateto timestamp without time zone
);


--
-- Name: productionscheduling_planordertimecalculation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.productionscheduling_planordertimecalculation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: productionscheduling_planordertimecalculation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.productionscheduling_planordertimecalculation_id_seq OWNED BY public.productionscheduling_planordertimecalculation.id;


--
-- Name: qcadoocustomtranslation_customtranslation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadoocustomtranslation_customtranslation (
    id bigint NOT NULL,
    pluginidentifier character varying(255),
    key character varying(1024),
    propertiestranslation character varying(1024),
    customtranslation character varying(1024),
    active boolean DEFAULT false,
    locale character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: qcadoocustomtranslation_customtranslation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadoocustomtranslation_customtranslation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadoocustomtranslation_customtranslation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadoocustomtranslation_customtranslation_id_seq OWNED BY public.qcadoocustomtranslation_customtranslation.id;


--
-- Name: qcadoomodel_dictionary; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadoomodel_dictionary (
    id bigint NOT NULL,
    name character varying(255),
    pluginidentifier character varying(255),
    active boolean,
    entityversion bigint DEFAULT 0
);


--
-- Name: qcadoomodel_dictionary_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadoomodel_dictionary_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadoomodel_dictionary_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadoomodel_dictionary_id_seq OWNED BY public.qcadoomodel_dictionary.id;


--
-- Name: qcadoomodel_dictionaryitem; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadoomodel_dictionaryitem (
    id bigint NOT NULL,
    name character varying(255),
    externalnumber character varying(255),
    description character varying(2048),
    technicalcode character varying(255),
    dictionary_id bigint,
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0,
    isinteger boolean DEFAULT false,
    priority integer
);


--
-- Name: qcadoomodel_dictionaryitem_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadoomodel_dictionaryitem_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadoomodel_dictionaryitem_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadoomodel_dictionaryitem_id_seq OWNED BY public.qcadoomodel_dictionaryitem.id;


--
-- Name: qcadoomodel_globalunitconversionsaggregate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadoomodel_globalunitconversionsaggregate (
    id bigint NOT NULL,
    entityversion bigint DEFAULT 0
);


--
-- Name: qcadoomodel_globalunitconversionsaggregate_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadoomodel_globalunitconversionsaggregate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadoomodel_globalunitconversionsaggregate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadoomodel_globalunitconversionsaggregate_id_seq OWNED BY public.qcadoomodel_globalunitconversionsaggregate.id;


--
-- Name: qcadoomodel_unitconversionitem_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadoomodel_unitconversionitem_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadoomodel_unitconversionitem_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadoomodel_unitconversionitem_id_seq OWNED BY public.qcadoomodel_unitconversionitem.id;


--
-- Name: qcadooplugin_plugin_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadooplugin_plugin_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadooplugin_plugin_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadooplugin_plugin_id_seq OWNED BY public.qcadooplugin_plugin.id;


--
-- Name: qcadoosecurity_group; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadoosecurity_group (
    id bigint NOT NULL,
    name character varying(255),
    description text,
    identifier character varying(255),
    entityversion bigint DEFAULT 0,
    permissiontype character varying(255) DEFAULT '02officeLicense'::character varying
);


--
-- Name: qcadoosecurity_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadoosecurity_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadoosecurity_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadoosecurity_group_id_seq OWNED BY public.qcadoosecurity_group.id;


--
-- Name: qcadoosecurity_passwordresettoken; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadoosecurity_passwordresettoken (
    id bigint NOT NULL,
    user_id bigint NOT NULL,
    token character varying(36) NOT NULL,
    active boolean DEFAULT true,
    expirationtime timestamp without time zone NOT NULL
);


--
-- Name: qcadoosecurity_passwordresettoken_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadoosecurity_passwordresettoken_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadoosecurity_passwordresettoken_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadoosecurity_passwordresettoken_id_seq OWNED BY public.qcadoosecurity_passwordresettoken.id;


--
-- Name: qcadoosecurity_persistenttoken; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadoosecurity_persistenttoken (
    id bigint NOT NULL,
    username character varying(255),
    series character varying(255),
    token character varying(255),
    lastused timestamp without time zone,
    entityversion bigint DEFAULT 0
);


--
-- Name: qcadoosecurity_persistenttoken_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadoosecurity_persistenttoken_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadoosecurity_persistenttoken_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadoosecurity_persistenttoken_id_seq OWNED BY public.qcadoosecurity_persistenttoken.id;


--
-- Name: qcadoosecurity_role; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadoosecurity_role (
    id bigint NOT NULL,
    identifier character varying(255),
    description text,
    entityversion bigint DEFAULT 0
);


--
-- Name: qcadoosecurity_role_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadoosecurity_role_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadoosecurity_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadoosecurity_role_id_seq OWNED BY public.qcadoosecurity_role.id;


--
-- Name: qcadoosecurity_user_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadoosecurity_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadoosecurity_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadoosecurity_user_id_seq OWNED BY public.qcadoosecurity_user.id;


--
-- Name: qcadooview_alert; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadooview_alert (
    id bigint NOT NULL,
    message text,
    type character varying(255) DEFAULT 'information'::character varying,
    expirationdate timestamp without time zone,
    sound boolean DEFAULT false
);


--
-- Name: qcadooview_alert_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadooview_alert_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadooview_alert_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadooview_alert_id_seq OWNED BY public.qcadooview_alert.id;


--
-- Name: qcadooview_category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadooview_category (
    id bigint NOT NULL,
    pluginidentifier character varying(255),
    name character varying(255),
    succession integer,
    authrole character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: qcadooview_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadooview_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadooview_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadooview_category_id_seq OWNED BY public.qcadooview_category.id;


--
-- Name: qcadooview_item; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadooview_item (
    id bigint NOT NULL,
    pluginidentifier character varying(255),
    name character varying(255),
    active boolean DEFAULT true,
    category_id bigint,
    view_id bigint,
    succession integer,
    authrole character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: qcadooview_item_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadooview_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadooview_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadooview_item_id_seq OWNED BY public.qcadooview_item.id;


--
-- Name: qcadooview_systeminfo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadooview_systeminfo (
    id bigint NOT NULL,
    nextupdatetime timestamp without time zone
);


--
-- Name: qcadooview_systeminfo_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadooview_systeminfo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadooview_systeminfo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadooview_systeminfo_id_seq OWNED BY public.qcadooview_systeminfo.id;


--
-- Name: qcadooview_view; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadooview_view (
    id bigint NOT NULL,
    pluginidentifier character varying(255),
    name character varying(255),
    view character varying(255),
    url character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: qcadooview_view_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadooview_view_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadooview_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadooview_view_id_seq OWNED BY public.qcadooview_view.id;


--
-- Name: qcadooview_viewedalert; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qcadooview_viewedalert (
    id bigint NOT NULL,
    user_id bigint,
    alert_id bigint
);


--
-- Name: qcadooview_viewedalert_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qcadooview_viewedalert_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qcadooview_viewedalert_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qcadooview_viewedalert_id_seq OWNED BY public.qcadooview_viewedalert.id;


--
-- Name: qualitycontrol_changequalitycards; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qualitycontrol_changequalitycards (
    id bigint NOT NULL,
    cleanqualitycard boolean DEFAULT false,
    qualitycard_id bigint,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255)
);


--
-- Name: qualitycontrol_changequalitycards_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_changequalitycards_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_changequalitycards_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qualitycontrol_changequalitycards_id_seq OWNED BY public.qualitycontrol_changequalitycards.id;


--
-- Name: qualitycontrol_deliveryqualitycontrol; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qualitycontrol_deliveryqualitycontrol (
    id bigint NOT NULL,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    delivery_id bigint
);


--
-- Name: qualitycontrol_deliveryqualitycontrol_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_deliveryqualitycontrol_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_deliveryqualitycontrol_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qualitycontrol_deliveryqualitycontrol_id_seq OWNED BY public.qualitycontrol_deliveryqualitycontrol.id;


--
-- Name: qualitycontrol_qualitycardattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_qualitycardattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_qualitycardattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qualitycontrol_qualitycardattachment_id_seq OWNED BY public.qualitycontrol_qualitycardattachment.id;


--
-- Name: qualitycontrol_qualitycarddto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.qualitycontrol_qualitycarddto AS
 SELECT qc.id,
    qc.number,
    qc.name,
    qc.description,
    qc.state,
    (count(qualitycardattachment.id) <> 0) AS attachmentsexists
   FROM (public.basic_qualitycard qc
     LEFT JOIN public.qualitycontrol_qualitycardattachment qualitycardattachment ON ((qualitycardattachment.qualitycard_id = qc.id)))
  GROUP BY qc.id, qc.number, qc.name, qc.description, qc.state;


--
-- Name: qualitycontrol_qualitycarddto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_qualitycarddto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_qualitycontrol_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_qualitycontrol_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_qualitycontrol_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qualitycontrol_qualitycontrol_id_seq OWNED BY public.qualitycontrol_qualitycontrol.id;


--
-- Name: qualitycontrol_qualitycontrol_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_qualitycontrol_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_qualitycontrolattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_qualitycontrolattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_qualitycontrolattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qualitycontrol_qualitycontrolattachment_id_seq OWNED BY public.qualitycontrol_qualitycontrolattachment.id;


--
-- Name: qualitycontrol_qualitycontrolattribute; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qualitycontrol_qualitycontrolattribute (
    id bigint NOT NULL,
    qualitycard_id bigint,
    attribute_id bigint,
    priority integer,
    attributenumber character varying(255)
);


--
-- Name: qualitycontrol_qualitycontrolattribute_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_qualitycontrolattribute_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_qualitycontrolattribute_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qualitycontrol_qualitycontrolattribute_id_seq OWNED BY public.qualitycontrol_qualitycontrolattribute.id;


--
-- Name: qualitycontrol_qualitycontrolattributedeliveredprod; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qualitycontrol_qualitycontrolattributedeliveredprod (
    id bigint NOT NULL,
    qualitydeliveredproduct_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255)
);


--
-- Name: qualitycontrol_qualitycontrolattributedeliveredprod_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_qualitycontrolattributedeliveredprod_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_qualitycontrolattributedeliveredprod_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qualitycontrol_qualitycontrolattributedeliveredprod_id_seq OWNED BY public.qualitycontrol_qualitycontrolattributedeliveredprod.id;


--
-- Name: qualitycontrol_qualitycontrolattributeprodtracking; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qualitycontrol_qualitycontrolattributeprodtracking (
    id bigint NOT NULL,
    productiontracking_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255),
    fromtechnology boolean DEFAULT false,
    moment character varying(255),
    adddate timestamp without time zone
);


--
-- Name: qualitycontrol_qualitycontrolattributeprodtracking_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_qualitycontrolattributeprodtracking_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_qualitycontrolattributeprodtracking_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qualitycontrol_qualitycontrolattributeprodtracking_id_seq OWNED BY public.qualitycontrol_qualitycontrolattributeprodtracking.id;


--
-- Name: qualitycontrol_qualitycontrolattributetoc; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qualitycontrol_qualitycontrolattributetoc (
    id bigint NOT NULL,
    qualitycontrolattribute_id bigint,
    technologyoperationcomponent_id bigint,
    moment character varying(255)
);


--
-- Name: qualitycontrol_qualitycontrolattributetoc_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_qualitycontrolattributetoc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_qualitycontrolattributetoc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qualitycontrol_qualitycontrolattributetoc_id_seq OWNED BY public.qualitycontrol_qualitycontrolattributetoc.id;


--
-- Name: qualitycontrol_qualitycontrolattributetocdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.qualitycontrol_qualitycontrolattributetocdto AS
 SELECT qcatoc.id,
    (qcatoc.technologyoperationcomponent_id)::integer AS technologyoperationcomponentid,
    qcatoc.technologyoperationcomponent_id,
    qcatoc.qualitycontrolattribute_id,
    qcatoc.moment,
    qca.priority,
    a.number AS attributenumber,
    a.name AS attributename,
    a.datatype AS attributedatatype,
    a.valuetype AS attributevaluetype
   FROM ((public.qualitycontrol_qualitycontrolattributetoc qcatoc
     JOIN public.qualitycontrol_qualitycontrolattribute qca ON ((qcatoc.qualitycontrolattribute_id = qca.id)))
     JOIN public.basic_attribute a ON ((qca.attribute_id = a.id)));


--
-- Name: qualitycontrol_qualitycontrolattributetocdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_qualitycontrolattributetocdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_qualitycontrolattributevalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qualitycontrol_qualitycontrolattributevalue (
    id bigint NOT NULL,
    qualitycontrol_id bigint,
    attribute_id bigint,
    attributevalue_id bigint,
    value character varying(255),
    productiontracking_id bigint,
    fromqualitycard boolean DEFAULT false,
    priority integer
);


--
-- Name: qualitycontrol_qualitycontrolattributevalue_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_qualitycontrolattributevalue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_qualitycontrolattributevalue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qualitycontrol_qualitycontrolattributevalue_id_seq OWNED BY public.qualitycontrol_qualitycontrolattributevalue.id;


--
-- Name: qualitycontrol_qualitycontroldto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.qualitycontrol_qualitycontroldto AS
 SELECT qc.id,
    qc.number,
    qc.date,
    qc.controltype,
    qc.state,
    qc.qualityrating,
    p.number AS product,
    b.number AS batch,
    o.number AS ordernumber,
    (((stf.name)::text || ' '::text) || (stf.surname)::text) AS staff,
    (count(qualitycontrolattachment.id) <> 0) AS attachmentsexists,
    qc.description,
    d.number AS delivery
   FROM ((((((public.qualitycontrol_qualitycontrol qc
     JOIN public.basic_product p ON ((p.id = qc.product_id)))
     LEFT JOIN public.qualitycontrol_qualitycontrolattachment qualitycontrolattachment ON ((qualitycontrolattachment.qualitycontrol_id = qc.id)))
     LEFT JOIN public.advancedgenealogy_batch b ON ((b.id = qc.batch_id)))
     LEFT JOIN public.orders_order o ON ((o.id = qc.order_id)))
     LEFT JOIN public.deliveries_delivery d ON ((d.id = qc.delivery_id)))
     LEFT JOIN public.basic_staff stf ON ((stf.id = qc.staff_id)))
  GROUP BY qc.id, qc.number, qc.date, qc.controltype, qc.state, qc.qualityrating, p.number, b.number, o.number, (((stf.name)::text || ' '::text) || (stf.surname)::text), qc.description, d.number;


--
-- Name: qualitycontrol_qualitycontroldto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_qualitycontroldto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_qualitycontrolresource; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qualitycontrol_qualitycontrolresource (
    id bigint NOT NULL,
    resourcenumber character varying(255),
    qualitycontrol_id bigint,
    resource_id bigint
);


--
-- Name: qualitycontrol_qualitycontrolresource_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_qualitycontrolresource_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_qualitycontrolresource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qualitycontrol_qualitycontrolresource_id_seq OWNED BY public.qualitycontrol_qualitycontrolresource.id;


--
-- Name: qualitycontrol_qualitycontrolstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qualitycontrol_qualitycontrolstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    qualitycontrol_id bigint,
    shift_id bigint
);


--
-- Name: qualitycontrol_qualitycontrolstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_qualitycontrolstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_qualitycontrolstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qualitycontrol_qualitycontrolstatechange_id_seq OWNED BY public.qualitycontrol_qualitycontrolstatechange.id;


--
-- Name: qualitycontrol_qualitydeliveredproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.qualitycontrol_qualitydeliveredproduct (
    id bigint NOT NULL,
    deliveryqualitycontrol_id bigint,
    qualitycard_id bigint,
    qualityrating character varying(255),
    product_id bigint,
    batch_id bigint,
    batchnumber character varying(255),
    deliveredquantity numeric(12,5),
    priceperunit numeric(12,5),
    storagelocation_id bigint,
    orderedproduct_id bigint,
    productiondate date,
    expirationdate date
);


--
-- Name: qualitycontrol_qualitydeliveredproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.qualitycontrol_qualitydeliveredproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: qualitycontrol_qualitydeliveredproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.qualitycontrol_qualitydeliveredproduct_id_seq OWNED BY public.qualitycontrol_qualitydeliveredproduct.id;


--
-- Name: repairs_repairorder_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.repairs_repairorder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: repairs_repairorder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.repairs_repairorder_id_seq OWNED BY public.repairs_repairorder.id;


--
-- Name: repairs_repairorder_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.repairs_repairorder_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: repairs_repairorderdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.repairs_repairorderdto AS
 SELECT repairorder.id,
    repairorder.number,
    repairorder.state,
    repairorder.createdate,
    repairorder.startdate,
    repairorder.enddate,
    repairorder.quantitytorepair,
    repairorder.quantityrepaired,
    repairorder.lack,
    repairorder.active,
    (orderdto.id)::integer AS order_id,
    orderdto.number AS ordernumber,
    (division.id)::integer AS division_id,
    division.number AS divisionnumber,
    (shift.id)::integer AS shift_id,
    shift.name AS shiftname,
    (product.id)::integer AS product_id,
    product.number AS productnumber,
    product.name AS productname,
    product.unit AS productunit,
    (productiontrackingdto.id)::integer AS productiontracking_id,
    productiontrackingdto.number AS productiontrackingnumber,
    ft.name AS faulttype
   FROM ((((((public.repairs_repairorder repairorder
     JOIN public.basic_faulttype ft ON ((ft.id = repairorder.faulttype_id)))
     LEFT JOIN public.orders_orderdto orderdto ON ((orderdto.id = repairorder.order_id)))
     LEFT JOIN public.basic_division division ON ((division.id = repairorder.division_id)))
     LEFT JOIN public.basic_shift shift ON ((shift.id = repairorder.shift_id)))
     LEFT JOIN public.basic_product product ON ((product.id = repairorder.product_id)))
     LEFT JOIN public.productioncounting_productiontracking productiontrackingdto ON ((productiontrackingdto.id = repairorder.productiontracking_id)));


--
-- Name: repairs_repairorderdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.repairs_repairorderdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: repairs_repairorderproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.repairs_repairorderproduct (
    id bigint NOT NULL,
    trackingoperationproductincomponent_id bigint,
    division_id bigint,
    location_id bigint,
    product_id bigint,
    faulttype_id bigint,
    description character varying(2048),
    givenquantity numeric(12,5),
    givenunit character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: repairs_repairorderproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.repairs_repairorderproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: repairs_repairorderproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.repairs_repairorderproduct_id_seq OWNED BY public.repairs_repairorderproduct.id;


--
-- Name: repairs_repairorderstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.repairs_repairorderstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    phase integer,
    worker character varying(255),
    repairorder_id bigint,
    shift_id bigint,
    status character varying
);


--
-- Name: repairs_repairorderstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.repairs_repairorderstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: repairs_repairorderstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.repairs_repairorderstatechange_id_seq OWNED BY public.repairs_repairorderstatechange.id;


--
-- Name: repairs_repairorderworktime; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.repairs_repairorderworktime (
    id bigint NOT NULL,
    repairorder_id bigint,
    staff_id bigint,
    labortime integer DEFAULT 0,
    effectiveexecutiontimestart timestamp without time zone,
    effectiveexecutiontimeend timestamp without time zone
);


--
-- Name: repairs_repairorderworktime_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.repairs_repairorderworktime_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: repairs_repairorderworktime_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.repairs_repairorderworktime_id_seq OWNED BY public.repairs_repairorderworktime.id;


--
-- Name: states_message; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.states_message (
    id bigint NOT NULL,
    type character varying(255),
    translationkey character varying(255),
    translationargs character varying(255),
    correspondfieldname character varying(255),
    autoclose boolean DEFAULT true,
    productiontrackingstatechange_id bigint,
    deliverystatechange_id bigint,
    assignmenttoshiftstatechange_id bigint,
    technologystatechange_id bigint,
    orderstatechange_id bigint,
    extrusionprotocolstatechange_id bigint,
    confectionprotocolstatechange_id bigint,
    palletstatechange_id bigint,
    batchstatechange_id bigint,
    trackingrecordstatechange_id bigint,
    requestforquotationstatechange_id bigint,
    offerstatechange_id bigint,
    negotiationstatechange_id bigint,
    warehouseissuestatechange_id bigint,
    palletlabelstatechange_id bigint,
    maintenanceeventstatechange_id bigint,
    entityversion bigint DEFAULT 0,
    plannedeventstatechange_id bigint,
    recurringeventstatechange_id bigint
);


--
-- Name: states_message_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.states_message_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: states_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.states_message_id_seq OWNED BY public.states_message.id;


--
-- Name: stoppage_stoppage; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.stoppage_stoppage (
    id bigint NOT NULL,
    order_id bigint,
    duration integer,
    entityversion bigint DEFAULT 0,
    productiontracking_id bigint,
    reason_id bigint,
    description character varying(1024),
    datefrom timestamp without time zone,
    dateto timestamp without time zone
);


--
-- Name: stoppage_stoppage_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.stoppage_stoppage_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: stoppage_stoppage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.stoppage_stoppage_id_seq OWNED BY public.stoppage_stoppage.id;


--
-- Name: stoppage_stoppagereason; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.stoppage_stoppagereason (
    id bigint NOT NULL,
    name character varying(255),
    description character varying(1024),
    type character varying(255) DEFAULT '02other'::character varying
);


--
-- Name: stoppage_stoppagedto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.stoppage_stoppagedto AS
 SELECT stoppage.id,
    ordersorder.number AS ordernumber,
    ordersorder.state AS orderstate,
    productiontracking.number AS productiontrackingnumber,
    productiontracking.state AS productiontrackingstate,
    stoppagereason.name AS reasonname,
    stoppage.description,
    public.duration_to_string(stoppage.duration) AS duration,
    stoppage.datefrom,
    stoppage.dateto,
    productionline.number AS productionlinenumber,
    workstation.number AS workstationnumber,
    (((staff.name)::text || ' '::text) || (staff.surname)::text) AS staffname,
    COALESCE(productiontrackingdivision.number, orderdivision.number) AS divisionnumber
   FROM ((((((((public.stoppage_stoppage stoppage
     JOIN public.orders_order ordersorder ON ((ordersorder.id = stoppage.order_id)))
     JOIN public.stoppage_stoppagereason stoppagereason ON ((stoppagereason.id = stoppage.reason_id)))
     LEFT JOIN public.productioncounting_productiontracking productiontracking ON ((productiontracking.id = stoppage.productiontracking_id)))
     LEFT JOIN public.productionlines_productionline productionline ON ((productionline.id = ordersorder.productionline_id)))
     LEFT JOIN public.basic_workstation workstation ON ((workstation.id = productiontracking.workstation_id)))
     LEFT JOIN public.basic_staff staff ON ((staff.id = productiontracking.staff_id)))
     LEFT JOIN public.basic_division productiontrackingdivision ON ((productiontrackingdivision.id = productiontracking.division_id)))
     LEFT JOIN public.basic_division orderdivision ON ((orderdivision.id = ordersorder.division_id)));


--
-- Name: stoppage_stoppagedto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.stoppage_stoppagedto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: stoppage_stoppagereason_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.stoppage_stoppagereason_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: stoppage_stoppagereason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.stoppage_stoppagereason_id_seq OWNED BY public.stoppage_stoppagereason.id;


--
-- Name: sub_order_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sub_order_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_subordercost; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.subcontractorportal_subordercost (
    id bigint NOT NULL,
    deliveredquantity numeric(14,5) DEFAULT (0)::numeric,
    unitprice numeric(14,5) DEFAULT (0)::numeric,
    totalprice numeric(14,5) DEFAULT (0)::numeric,
    suborder_id bigint,
    product_id bigint,
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0,
    operationaltask_id bigint,
    order_id bigint
);


--
-- Name: subcontractorportal_cost_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_cost_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_cost_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_cost_id_seq OWNED BY public.subcontractorportal_subordercost.id;


--
-- Name: subcontractorportal_suborderevent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.subcontractorportal_suborderevent (
    id bigint NOT NULL,
    date timestamp without time zone,
    prevvalue character varying(255),
    currvalue character varying(255),
    type character varying(255),
    action character varying(255),
    staff_id bigint,
    suborder_id bigint,
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0
);


--
-- Name: subcontractorportal_event_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_event_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_event_id_seq OWNED BY public.subcontractorportal_suborderevent.id;


--
-- Name: subcontractorportal_subordermessage; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.subcontractorportal_subordermessage (
    id bigint NOT NULL,
    date date,
    createdat timestamp without time zone,
    description character varying(255),
    staff_id bigint,
    company_id bigint,
    suborder_id bigint,
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0
);


--
-- Name: subcontractorportal_message_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_message_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_message_id_seq OWNED BY public.subcontractorportal_subordermessage.id;


--
-- Name: subcontractorportal_operation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.subcontractorportal_operation (
    id bigint NOT NULL,
    orderid integer,
    operationid integer,
    cost integer,
    number character varying(255),
    operation character varying(255),
    ordernumber character varying(255),
    ordername character varying(255),
    datefrom timestamp without time zone,
    dateto timestamp without time zone,
    status character varying(255),
    company_id bigint,
    operationcomponent_id bigint,
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0
);


--
-- Name: subcontractorportal_operation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_operation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_operation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_operation_id_seq OWNED BY public.subcontractorportal_operation.id;


--
-- Name: subcontractorportal_suborderrealisation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.subcontractorportal_suborderrealisation (
    id bigint NOT NULL,
    date date,
    producedquantity numeric(12,5),
    remainingquantity numeric(12,5),
    product_id bigint,
    suborder_id bigint,
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0
);


--
-- Name: subcontractorportal_realisation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_realisation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_realisation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_realisation_id_seq OWNED BY public.subcontractorportal_suborderrealisation.id;


--
-- Name: subcontractorportal_suborder_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_suborder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_suborder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_suborder_id_seq OWNED BY public.subcontractorportal_suborder.id;


--
-- Name: subcontractorportal_suborderattachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.subcontractorportal_suborderattachment (
    id bigint NOT NULL,
    attachment character varying(255),
    name character varying(255),
    ext character varying(255),
    size numeric(12,5),
    suborder_id bigint,
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0
);


--
-- Name: subcontractorportal_suborderattachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_suborderattachment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_suborderattachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_suborderattachment_id_seq OWNED BY public.subcontractorportal_suborderattachment.id;


--
-- Name: subcontractorportal_subordercost_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_subordercost_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_subordercost_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_subordercost_id_seq OWNED BY public.subcontractorportal_subordercost.id;


--
-- Name: subcontractorportal_suborderinput; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.subcontractorportal_suborderinput (
    id bigint NOT NULL,
    unit character varying(20),
    plannedquantity numeric(14,5),
    deliveredquantity numeric(14,5),
    remainingquantity numeric(14,5),
    product_id bigint,
    location_id bigint,
    suborder_id bigint,
    active boolean DEFAULT true,
    operations character varying(20),
    entityversion bigint DEFAULT 0
);


--
-- Name: subcontractorportal_suborderoutput; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.subcontractorportal_suborderoutput (
    id bigint NOT NULL,
    unit character varying(20),
    plannedquantity numeric(14,5) DEFAULT (0)::numeric,
    deliveredquantity numeric(14,5) DEFAULT (0)::numeric,
    producedquantity numeric(14,5) DEFAULT (0)::numeric,
    remainingquantity numeric(14,5) DEFAULT (0)::numeric,
    unitprice numeric(14,5) DEFAULT (0)::numeric,
    createdmanually boolean DEFAULT false,
    product_id bigint,
    location_id bigint,
    suborder_id bigint,
    active boolean DEFAULT true,
    operations character varying(20),
    entityversion bigint DEFAULT 0
);


--
-- Name: subcontractorportal_suborderdto; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW public.subcontractorportal_suborderdto AS
 WITH suborderinputsum AS (
         SELECT subcontractorportal_suborderinput.suborder_id,
            sum(subcontractorportal_suborderinput.plannedquantity) AS plannedreleasequantity,
            sum(subcontractorportal_suborderinput.deliveredquantity) AS releasequantity
           FROM public.subcontractorportal_suborderinput
          GROUP BY subcontractorportal_suborderinput.suborder_id
        ), suborderoutputsum AS (
         SELECT subcontractorportal_suborderoutput.suborder_id,
            sum(subcontractorportal_suborderoutput.plannedquantity) AS plannedreceiptquantity,
            sum(subcontractorportal_suborderoutput.deliveredquantity) AS receiptquantity
           FROM public.subcontractorportal_suborderoutput
          GROUP BY subcontractorportal_suborderoutput.suborder_id
        )
 SELECT suborder.id,
    suborder.active,
    suborder.number,
    (company.id)::integer AS companyid,
    company.name AS companyname,
    suborder.datefrom,
    suborder.dateto,
    suborder.description,
    suborder.state,
    COALESCE(suborderinputsum.plannedreleasequantity, (0)::numeric) AS plannedreleasequantity,
    COALESCE(suborderinputsum.releasequantity, (0)::numeric) AS releasequantity,
    COALESCE(suborderoutputsum.plannedreceiptquantity, (0)::numeric) AS plannedreceiptquantity,
    COALESCE(suborderoutputsum.receiptquantity, (0)::numeric) AS receiptquantity
   FROM (((public.subcontractorportal_suborder suborder
     LEFT JOIN public.basic_company company ON ((company.id = suborder.company_id)))
     LEFT JOIN suborderinputsum suborderinputsum ON ((suborderinputsum.suborder_id = suborder.id)))
     LEFT JOIN suborderoutputsum suborderoutputsum ON ((suborderoutputsum.suborder_id = suborder.id)));


--
-- Name: subcontractorportal_suborderdto_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_suborderdto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_suborderevent_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_suborderevent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_suborderevent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_suborderevent_id_seq OWNED BY public.subcontractorportal_suborderevent.id;


--
-- Name: subcontractorportal_suborderinput_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_suborderinput_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_suborderinput_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_suborderinput_id_seq OWNED BY public.subcontractorportal_suborderinput.id;


--
-- Name: subcontractorportal_suborderissuedproductsreport; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.subcontractorportal_suborderissuedproductsreport (
    id bigint NOT NULL,
    number character varying(256),
    name character varying(1024),
    datefrom date,
    dateto date,
    company_id bigint,
    withoutfinishedsuborders boolean DEFAULT false,
    withoutfullyreceivedsuborders boolean DEFAULT false,
    generated boolean,
    worker character varying(255),
    date timestamp without time zone,
    filename character varying(255)
);


--
-- Name: subcontractorportal_suborderissuedproductsreport_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_suborderissuedproductsreport_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_suborderissuedproductsreport_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_suborderissuedproductsreport_id_seq OWNED BY public.subcontractorportal_suborderissuedproductsreport.id;


--
-- Name: subcontractorportal_suborderissuedproductsreport_number_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_suborderissuedproductsreport_number_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_subordermessage_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_subordermessage_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_subordermessage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_subordermessage_id_seq OWNED BY public.subcontractorportal_subordermessage.id;


--
-- Name: subcontractorportal_suborderoperation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.subcontractorportal_suborderoperation (
    id bigint NOT NULL,
    orderid integer,
    operationid integer,
    cost numeric(14,5),
    number character varying(255),
    operation character varying(255),
    ordernumber character varying(255),
    ordername character varying(255),
    datefrom timestamp without time zone,
    dateto timestamp without time zone,
    status character varying(255),
    company_id bigint,
    suborder_id bigint,
    operationcomponent_id bigint,
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0
);


--
-- Name: subcontractorportal_suborderoperation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_suborderoperation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_suborderoperation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_suborderoperation_id_seq OWNED BY public.subcontractorportal_suborderoperation.id;


--
-- Name: subcontractorportal_suborderoutput_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_suborderoutput_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_suborderoutput_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_suborderoutput_id_seq OWNED BY public.subcontractorportal_suborderoutput.id;


--
-- Name: subcontractorportal_suborderrealisation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_suborderrealisation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_suborderrealisation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_suborderrealisation_id_seq OWNED BY public.subcontractorportal_suborderrealisation.id;


--
-- Name: subcontractorportal_suborderstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.subcontractorportal_suborderstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    suborder_id bigint,
    shift_id bigint
);


--
-- Name: subcontractorportal_suborderstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_suborderstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_suborderstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_suborderstatechange_id_seq OWNED BY public.subcontractorportal_suborderstatechange.id;


--
-- Name: subcontractorportal_subordertmp; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.subcontractorportal_subordertmp (
    id bigint NOT NULL,
    number character varying(255),
    ordernumber character varying(255),
    datefrom timestamp without time zone,
    dateto timestamp without time zone,
    planneddatefrom timestamp without time zone,
    planneddateto timestamp without time zone,
    status character varying(255),
    company_id bigint,
    active boolean DEFAULT true,
    entityversion bigint DEFAULT 0
);


--
-- Name: subcontractorportal_subordertmp_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.subcontractorportal_subordertmp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: subcontractorportal_subordertmp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.subcontractorportal_subordertmp_id_seq OWNED BY public.subcontractorportal_subordertmp.id;


--
-- Name: supplynegotiations_columnforoffers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.supplynegotiations_columnforoffers (
    id bigint NOT NULL,
    identifier character varying(255),
    name character varying(1024),
    description character varying(1024),
    columnfiller character varying(255),
    alignment character varying(255) DEFAULT '01left'::character varying,
    parameter_id bigint,
    succession integer,
    entityversion bigint DEFAULT 0
);


--
-- Name: supplynegotiations_columnforoffers_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.supplynegotiations_columnforoffers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: supplynegotiations_columnforoffers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.supplynegotiations_columnforoffers_id_seq OWNED BY public.supplynegotiations_columnforoffers.id;


--
-- Name: supplynegotiations_columnforrequests; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.supplynegotiations_columnforrequests (
    id bigint NOT NULL,
    identifier character varying(255),
    name character varying(1024),
    description character varying(1024),
    columnfiller character varying(255),
    alignment character varying(255) DEFAULT '01left'::character varying,
    parameter_id bigint,
    succession integer,
    entityversion bigint DEFAULT 0
);


--
-- Name: supplynegotiations_columnforrequests_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.supplynegotiations_columnforrequests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: supplynegotiations_columnforrequests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.supplynegotiations_columnforrequests_id_seq OWNED BY public.supplynegotiations_columnforrequests.id;


--
-- Name: supplynegotiations_negotiation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.supplynegotiations_negotiation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: supplynegotiations_negotiation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.supplynegotiations_negotiation_id_seq OWNED BY public.supplynegotiations_negotiation.id;


--
-- Name: supplynegotiations_negotiationproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.supplynegotiations_negotiationproduct (
    id bigint NOT NULL,
    negotiation_id bigint,
    product_id bigint,
    neededquantity numeric(12,5),
    approveddeliveredquantity numeric(12,5),
    draftdeliveredquantity numeric(12,5),
    leftquantity numeric(12,5),
    duedate timestamp without time zone,
    operation_id bigint,
    requestforquotationsnumber integer,
    entityversion bigint DEFAULT 0
);


--
-- Name: supplynegotiations_negotiationproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.supplynegotiations_negotiationproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: supplynegotiations_negotiationproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.supplynegotiations_negotiationproduct_id_seq OWNED BY public.supplynegotiations_negotiationproduct.id;


--
-- Name: supplynegotiations_negotiationstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.supplynegotiations_negotiationstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    negotiation_id bigint,
    shift_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: supplynegotiations_negotiationstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.supplynegotiations_negotiationstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: supplynegotiations_negotiationstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.supplynegotiations_negotiationstatechange_id_seq OWNED BY public.supplynegotiations_negotiationstatechange.id;


--
-- Name: supplynegotiations_offer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.supplynegotiations_offer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: supplynegotiations_offer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.supplynegotiations_offer_id_seq OWNED BY public.supplynegotiations_offer.id;


--
-- Name: supplynegotiations_offerproduct; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.supplynegotiations_offerproduct (
    id bigint NOT NULL,
    offer_id bigint,
    product_id bigint,
    quantity numeric(12,5),
    priceperunit numeric(12,5),
    totalprice numeric(12,5),
    operation_id bigint,
    succession integer,
    actualversion character varying(255),
    entityversion bigint DEFAULT 0
);


--
-- Name: supplynegotiations_offerproduct_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.supplynegotiations_offerproduct_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: supplynegotiations_offerproduct_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.supplynegotiations_offerproduct_id_seq OWNED BY public.supplynegotiations_offerproduct.id;


--
-- Name: supplynegotiations_offerstatechange; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.supplynegotiations_offerstatechange (
    id bigint NOT NULL,
    dateandtime timestamp without time zone,
    sourcestate character varying(255),
    targetstate character varying(255),
    status character varying(255),
    phase integer,
    worker character varying(255),
    offer_id bigint,
    shift_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: supplynegotiations_offerstatechange_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.supplynegotiations_offerstatechange_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: supplynegotiations_offerstatechange_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.supplynegotiations_offerstatechange_id_seq OWNED BY public.supplynegotiations_offerstatechange.id;


--
-- Name: supplynegotiations_parametercolumnforoffers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.supplynegotiations_parametercolumnforoffers (
    id bigint NOT NULL,
    parameter_id bigint,
    columnforoffers_id bigint,
    succession integer,
    entityversion bigint DEFAULT 0
);


--
-- Name: supplynegotiations_parametercolumnforoffers_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.supplynegotiations_parametercolumnforoffers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: supplynegotiations_parametercolumnforoffers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.supplynegotiations_parametercolumnforoffers_id_seq OWNED BY public.supplynegotiations_parametercolumnforoffers.id;


--
-- Name: supplynegotiations_parametercolumnforrequests; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.supplynegotiations_parametercolumnforrequests (
    id bigint NOT NULL,
    parameter_id bigint,
    columnforrequests_id bigint,
    succession integer,
    entityversion bigint DEFAULT 0
);


--
-- Name: supplynegotiations_parametercolumnforrequests_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.supplynegotiations_parametercolumnforrequests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: supplynegotiations_parametercolumnforrequests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.supplynegotiations_parametercolumnforrequests_id_seq OWNED BY public.supplynegotiations_parametercolumnforrequests.id;


--
-- Name: supplynegotiations_requestforquotation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.supplynegotiations_requestforquotation (
    id bigint NOT NULL,
    number character varying(255),
    name character varying(1024),
    description character varying(2048),
    supplier_id bigint,
    desireddate timestamp without time zone,
    active boolean DEFAULT true,
    createdate timestamp without time zone,
    updatedate timestamp without time zone,
    createuser character varying(255),
    updateuser character varying(255),
    state character varying(255) DEFAULT '01draft'::character varying,
    workingdaysafterorder integer,
    negotiation_id bigint,
    entityversion bigint DEFAULT 0
);


--
-- Name: supplynegotiations_requestforquotation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.supplynegotiations_requestforquotation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: supplynegotiations_requestforquotation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.supplynegotiations_requestforquotation_id_seq OWNED BY public.