/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree.
 */

#pragma once
#include <cstdint>
#include <type_traits>

namespace torchrec {

namespace bits_impl {
template <typename T>
struct Clz {
  int operator()(T v) const;
};

template <typename T>
struct Ctz {
  int operator()(T v) const;
};
} // namespace bits_impl

/**
 * Returns the number of leading 0-bits in t, starting at the most significant
 * bit position. If t is 0, the result is undefined.
 * clz stands for counting leading zeros.
 */
template <typename T>
inline int clz(T t) {
  bits_impl::Clz<T> clz;
  return clz(t);
}

/**
 * Returns the number of trailing 0-bits in t, starting at the least significant
 * bit position. If t is 0, the result is undefined.
 * ctz stands for counting trailing zeros.
 */
template <typename T>
inline int ctz(T t) {
  bits_impl::Ctz<T> ctz;
  return ctz(t);
}

} // namespace torchrec
