#include <System.h>

System::NTP::NTP(Node* parent, const char* name) : Node(parent, name) {
	
}

void System::NTP::setup() {
	this->readFile();
	this->applySettings();
}

void System::NTP::loop() {
	
}

void System::NTP::applySettings() {
	// ugly but it is the easyest way
	switch(this->settings.tz) {
		case 0: configTime(TZ_Africa_Abidjan, (char*)this->settings.host.c_str());break;
		case 1: configTime(TZ_Africa_Accra, (char*)this->settings.host.c_str());break;
		case 2: configTime(TZ_Africa_Addis_Ababa, (char*)this->settings.host.c_str());break;
		case 3: configTime(TZ_Africa_Algiers, (char*)this->settings.host.c_str());break;
		case 4: configTime(TZ_Africa_Asmara, (char*)this->settings.host.c_str());break;
		case 5: configTime(TZ_Africa_Bamako, (char*)this->settings.host.c_str());break;
		case 6: configTime(TZ_Africa_Bangui, (char*)this->settings.host.c_str());break;
		case 7: configTime(TZ_Africa_Banjul, (char*)this->settings.host.c_str());break;
		case 8: configTime(TZ_Africa_Bissau, (char*)this->settings.host.c_str());break;
		case 9: configTime(TZ_Africa_Blantyre, (char*)this->settings.host.c_str());break;
		case 10: configTime(TZ_Africa_Brazzaville, (char*)this->settings.host.c_str());break;
		case 11: configTime(TZ_Africa_Bujumbura, (char*)this->settings.host.c_str());break;
		case 12: configTime(TZ_Africa_Cairo, (char*)this->settings.host.c_str());break;
		case 13: configTime(TZ_Africa_Casablanca, (char*)this->settings.host.c_str());break;
		case 14: configTime(TZ_Africa_Ceuta, (char*)this->settings.host.c_str());break;
		case 15: configTime(TZ_Africa_Conakry, (char*)this->settings.host.c_str());break;
		case 16: configTime(TZ_Africa_Dakar, (char*)this->settings.host.c_str());break;
		case 17: configTime(TZ_Africa_Dar_es_Salaam, (char*)this->settings.host.c_str());break;
		case 18: configTime(TZ_Africa_Djibouti, (char*)this->settings.host.c_str());break;
		case 19: configTime(TZ_Africa_Douala, (char*)this->settings.host.c_str());break;
		case 20: configTime(TZ_Africa_El_Aaiun, (char*)this->settings.host.c_str());break;
		case 21: configTime(TZ_Africa_Freetown, (char*)this->settings.host.c_str());break;
		case 22: configTime(TZ_Africa_Gaborone, (char*)this->settings.host.c_str());break;
		case 23: configTime(TZ_Africa_Harare, (char*)this->settings.host.c_str());break;
		case 24: configTime(TZ_Africa_Johannesburg, (char*)this->settings.host.c_str());break;
		case 25: configTime(TZ_Africa_Juba, (char*)this->settings.host.c_str());break;
		case 26: configTime(TZ_Africa_Kampala, (char*)this->settings.host.c_str());break;
		case 27: configTime(TZ_Africa_Khartoum, (char*)this->settings.host.c_str());break;
		case 28: configTime(TZ_Africa_Kigali, (char*)this->settings.host.c_str());break;
		case 29: configTime(TZ_Africa_Kinshasa, (char*)this->settings.host.c_str());break;
		case 30: configTime(TZ_Africa_Lagos, (char*)this->settings.host.c_str());break;
		case 31: configTime(TZ_Africa_Libreville, (char*)this->settings.host.c_str());break;
		case 32: configTime(TZ_Africa_Lome, (char*)this->settings.host.c_str());break;
		case 33: configTime(TZ_Africa_Luanda, (char*)this->settings.host.c_str());break;
		case 34: configTime(TZ_Africa_Lubumbashi, (char*)this->settings.host.c_str());break;
		case 35: configTime(TZ_Africa_Lusaka, (char*)this->settings.host.c_str());break;
		case 36: configTime(TZ_Africa_Malabo, (char*)this->settings.host.c_str());break;
		case 37: configTime(TZ_Africa_Maputo, (char*)this->settings.host.c_str());break;
		case 38: configTime(TZ_Africa_Maseru, (char*)this->settings.host.c_str());break;
		case 39: configTime(TZ_Africa_Mbabane, (char*)this->settings.host.c_str());break;
		case 40: configTime(TZ_Africa_Mogadishu, (char*)this->settings.host.c_str());break;
		case 41: configTime(TZ_Africa_Monrovia, (char*)this->settings.host.c_str());break;
		case 42: configTime(TZ_Africa_Nairobi, (char*)this->settings.host.c_str());break;
		case 43: configTime(TZ_Africa_Ndjamena, (char*)this->settings.host.c_str());break;
		case 44: configTime(TZ_Africa_Niamey, (char*)this->settings.host.c_str());break;
		case 45: configTime(TZ_Africa_Nouakchott, (char*)this->settings.host.c_str());break;
		case 46: configTime(TZ_Africa_Ouagadougou, (char*)this->settings.host.c_str());break;
		case 47: configTime(TZ_Africa_PortomNovo, (char*)this->settings.host.c_str());break;
		case 48: configTime(TZ_Africa_Sao_Tome, (char*)this->settings.host.c_str());break;
		case 49: configTime(TZ_Africa_Tripoli, (char*)this->settings.host.c_str());break;
		case 50: configTime(TZ_Africa_Tunis, (char*)this->settings.host.c_str());break;
		case 51: configTime(TZ_Africa_Windhoek, (char*)this->settings.host.c_str());break;
		case 52: configTime(TZ_America_Adak, (char*)this->settings.host.c_str());break;
		case 53: configTime(TZ_America_Anchorage, (char*)this->settings.host.c_str());break;
		case 54: configTime(TZ_America_Anguilla, (char*)this->settings.host.c_str());break;
		case 55: configTime(TZ_America_Antigua, (char*)this->settings.host.c_str());break;
		case 56: configTime(TZ_America_Araguaina, (char*)this->settings.host.c_str());break;
		case 57: configTime(TZ_America_Argentina_Buenos_Aires, (char*)this->settings.host.c_str());break;
		case 58: configTime(TZ_America_Argentina_Catamarca, (char*)this->settings.host.c_str());break;
		case 59: configTime(TZ_America_Argentina_Cordoba, (char*)this->settings.host.c_str());break;
		case 60: configTime(TZ_America_Argentina_Jujuy, (char*)this->settings.host.c_str());break;
		case 61: configTime(TZ_America_Argentina_La_Rioja, (char*)this->settings.host.c_str());break;
		case 62: configTime(TZ_America_Argentina_Mendoza, (char*)this->settings.host.c_str());break;
		case 63: configTime(TZ_America_Argentina_Rio_Gallegos, (char*)this->settings.host.c_str());break;
		case 64: configTime(TZ_America_Argentina_Salta, (char*)this->settings.host.c_str());break;
		case 65: configTime(TZ_America_Argentina_San_Juan, (char*)this->settings.host.c_str());break;
		case 66: configTime(TZ_America_Argentina_San_Luis, (char*)this->settings.host.c_str());break;
		case 67: configTime(TZ_America_Argentina_Tucuman, (char*)this->settings.host.c_str());break;
		case 68: configTime(TZ_America_Argentina_Ushuaia, (char*)this->settings.host.c_str());break;
		case 69: configTime(TZ_America_Aruba, (char*)this->settings.host.c_str());break;
		case 70: configTime(TZ_America_Asuncion, (char*)this->settings.host.c_str());break;
		case 71: configTime(TZ_America_Atikokan, (char*)this->settings.host.c_str());break;
		case 72: configTime(TZ_America_Bahia, (char*)this->settings.host.c_str());break;
		case 73: configTime(TZ_America_Bahia_Banderas, (char*)this->settings.host.c_str());break;
		case 74: configTime(TZ_America_Barbados, (char*)this->settings.host.c_str());break;
		case 75: configTime(TZ_America_Belem, (char*)this->settings.host.c_str());break;
		case 76: configTime(TZ_America_Belize, (char*)this->settings.host.c_str());break;
		case 77: configTime(TZ_America_BlancmSablon, (char*)this->settings.host.c_str());break;
		case 78: configTime(TZ_America_Boa_Vista, (char*)this->settings.host.c_str());break;
		case 79: configTime(TZ_America_Bogota, (char*)this->settings.host.c_str());break;
		case 80: configTime(TZ_America_Boise, (char*)this->settings.host.c_str());break;
		case 81: configTime(TZ_America_Cambridge_Bay, (char*)this->settings.host.c_str());break;
		case 82: configTime(TZ_America_Campo_Grande, (char*)this->settings.host.c_str());break;
		case 83: configTime(TZ_America_Cancun, (char*)this->settings.host.c_str());break;
		case 84: configTime(TZ_America_Caracas, (char*)this->settings.host.c_str());break;
		case 85: configTime(TZ_America_Cayenne, (char*)this->settings.host.c_str());break;
		case 86: configTime(TZ_America_Cayman, (char*)this->settings.host.c_str());break;
		case 87: configTime(TZ_America_Chicago, (char*)this->settings.host.c_str());break;
		case 88: configTime(TZ_America_Chihuahua, (char*)this->settings.host.c_str());break;
		case 89: configTime(TZ_America_Costa_Rica, (char*)this->settings.host.c_str());break;
		case 90: configTime(TZ_America_Creston, (char*)this->settings.host.c_str());break;
		case 91: configTime(TZ_America_Cuiaba, (char*)this->settings.host.c_str());break;
		case 92: configTime(TZ_America_Curacao, (char*)this->settings.host.c_str());break;
		case 93: configTime(TZ_America_Danmarkshavn, (char*)this->settings.host.c_str());break;
		case 94: configTime(TZ_America_Dawson, (char*)this->settings.host.c_str());break;
		case 95: configTime(TZ_America_Dawson_Creek, (char*)this->settings.host.c_str());break;
		case 96: configTime(TZ_America_Denver, (char*)this->settings.host.c_str());break;
		case 97: configTime(TZ_America_Detroit, (char*)this->settings.host.c_str());break;
		case 98: configTime(TZ_America_Dominica, (char*)this->settings.host.c_str());break;
		case 99: configTime(TZ_America_Edmonton, (char*)this->settings.host.c_str());break;
		case 100: configTime(TZ_America_Eirunepe, (char*)this->settings.host.c_str());break;
		case 101: configTime(TZ_America_El_Salvador, (char*)this->settings.host.c_str());break;
		case 102: configTime(TZ_America_Fortaleza, (char*)this->settings.host.c_str());break;
		case 103: configTime(TZ_America_Fort_Nelson, (char*)this->settings.host.c_str());break;
		case 104: configTime(TZ_America_Glace_Bay, (char*)this->settings.host.c_str());break;
		case 105: configTime(TZ_America_Godthab, (char*)this->settings.host.c_str());break;
		case 106: configTime(TZ_America_Goose_Bay, (char*)this->settings.host.c_str());break;
		case 107: configTime(TZ_America_Grand_Turk, (char*)this->settings.host.c_str());break;
		case 108: configTime(TZ_America_Grenada, (char*)this->settings.host.c_str());break;
		case 109: configTime(TZ_America_Guadeloupe, (char*)this->settings.host.c_str());break;
		case 110: configTime(TZ_America_Guatemala, (char*)this->settings.host.c_str());break;
		case 111: configTime(TZ_America_Guayaquil, (char*)this->settings.host.c_str());break;
		case 112: configTime(TZ_America_Guyana, (char*)this->settings.host.c_str());break;
		case 113: configTime(TZ_America_Halifax, (char*)this->settings.host.c_str());break;
		case 114: configTime(TZ_America_Havana, (char*)this->settings.host.c_str());break;
		case 115: configTime(TZ_America_Hermosillo, (char*)this->settings.host.c_str());break;
		case 116: configTime(TZ_America_Indiana_Indianapolis, (char*)this->settings.host.c_str());break;
		case 117: configTime(TZ_America_Indiana_Knox, (char*)this->settings.host.c_str());break;
		case 118: configTime(TZ_America_Indiana_Marengo, (char*)this->settings.host.c_str());break;
		case 119: configTime(TZ_America_Indiana_Petersburg, (char*)this->settings.host.c_str());break;
		case 120: configTime(TZ_America_Indiana_Tell_City, (char*)this->settings.host.c_str());break;
		case 121: configTime(TZ_America_Indiana_Vevay, (char*)this->settings.host.c_str());break;
		case 122: configTime(TZ_America_Indiana_Vincennes, (char*)this->settings.host.c_str());break;
		case 123: configTime(TZ_America_Indiana_Winamac, (char*)this->settings.host.c_str());break;
		case 124: configTime(TZ_America_Inuvik, (char*)this->settings.host.c_str());break;
		case 125: configTime(TZ_America_Iqaluit, (char*)this->settings.host.c_str());break;
		case 126: configTime(TZ_America_Jamaica, (char*)this->settings.host.c_str());break;
		case 127: configTime(TZ_America_Juneau, (char*)this->settings.host.c_str());break;
		case 128: configTime(TZ_America_Kentucky_Louisville, (char*)this->settings.host.c_str());break;
		case 129: configTime(TZ_America_Kentucky_Monticello, (char*)this->settings.host.c_str());break;
		case 130: configTime(TZ_America_Kralendijk, (char*)this->settings.host.c_str());break;
		case 131: configTime(TZ_America_La_Paz, (char*)this->settings.host.c_str());break;
		case 132: configTime(TZ_America_Lima, (char*)this->settings.host.c_str());break;
		case 133: configTime(TZ_America_Los_Angeles, (char*)this->settings.host.c_str());break;
		case 134: configTime(TZ_America_Lower_Princes, (char*)this->settings.host.c_str());break;
		case 135: configTime(TZ_America_Maceio, (char*)this->settings.host.c_str());break;
		case 136: configTime(TZ_America_Managua, (char*)this->settings.host.c_str());break;
		case 137: configTime(TZ_America_Manaus, (char*)this->settings.host.c_str());break;
		case 138: configTime(TZ_America_Marigot, (char*)this->settings.host.c_str());break;
		case 139: configTime(TZ_America_Martinique, (char*)this->settings.host.c_str());break;
		case 140: configTime(TZ_America_Matamoros, (char*)this->settings.host.c_str());break;
		case 141: configTime(TZ_America_Mazatlan, (char*)this->settings.host.c_str());break;
		case 142: configTime(TZ_America_Menominee, (char*)this->settings.host.c_str());break;
		case 143: configTime(TZ_America_Merida, (char*)this->settings.host.c_str());break;
		case 144: configTime(TZ_America_Metlakatla, (char*)this->settings.host.c_str());break;
		case 145: configTime(TZ_America_Mexico_City, (char*)this->settings.host.c_str());break;
		case 146: configTime(TZ_America_Miquelon, (char*)this->settings.host.c_str());break;
		case 147: configTime(TZ_America_Moncton, (char*)this->settings.host.c_str());break;
		case 148: configTime(TZ_America_Monterrey, (char*)this->settings.host.c_str());break;
		case 149: configTime(TZ_America_Montevideo, (char*)this->settings.host.c_str());break;
		case 150: configTime(TZ_America_Montreal, (char*)this->settings.host.c_str());break;
		case 151: configTime(TZ_America_Montserrat, (char*)this->settings.host.c_str());break;
		case 152: configTime(TZ_America_Nassau, (char*)this->settings.host.c_str());break;
		case 153: configTime(TZ_America_New_York, (char*)this->settings.host.c_str());break;
		case 154: configTime(TZ_America_Nipigon, (char*)this->settings.host.c_str());break;
		case 155: configTime(TZ_America_Nome, (char*)this->settings.host.c_str());break;
		case 156: configTime(TZ_America_Noronha, (char*)this->settings.host.c_str());break;
		case 157: configTime(TZ_America_North_Dakota_Beulah, (char*)this->settings.host.c_str());break;
		case 158: configTime(TZ_America_North_Dakota_Center, (char*)this->settings.host.c_str());break;
		case 159: configTime(TZ_America_North_Dakota_New_Salem, (char*)this->settings.host.c_str());break;
		case 160: configTime(TZ_America_Ojinaga, (char*)this->settings.host.c_str());break;
		case 161: configTime(TZ_America_Panama, (char*)this->settings.host.c_str());break;
		case 162: configTime(TZ_America_Pangnirtung, (char*)this->settings.host.c_str());break;
		case 163: configTime(TZ_America_Paramaribo, (char*)this->settings.host.c_str());break;
		case 164: configTime(TZ_America_Phoenix, (char*)this->settings.host.c_str());break;
		case 165: configTime(TZ_America_PortmaumPrince, (char*)this->settings.host.c_str());break;
		case 166: configTime(TZ_America_Port_of_Spain, (char*)this->settings.host.c_str());break;
		case 167: configTime(TZ_America_Porto_Velho, (char*)this->settings.host.c_str());break;
		case 168: configTime(TZ_America_Puerto_Rico, (char*)this->settings.host.c_str());break;
		case 169: configTime(TZ_America_Punta_Arenas, (char*)this->settings.host.c_str());break;
		case 170: configTime(TZ_America_Rainy_River, (char*)this->settings.host.c_str());break;
		case 171: configTime(TZ_America_Rankin_Inlet, (char*)this->settings.host.c_str());break;
		case 172: configTime(TZ_America_Recife, (char*)this->settings.host.c_str());break;
		case 173: configTime(TZ_America_Regina, (char*)this->settings.host.c_str());break;
		case 174: configTime(TZ_America_Resolute, (char*)this->settings.host.c_str());break;
		case 175: configTime(TZ_America_Rio_Branco, (char*)this->settings.host.c_str());break;
		case 176: configTime(TZ_America_Santarem, (char*)this->settings.host.c_str());break;
		case 177: configTime(TZ_America_Santiago, (char*)this->settings.host.c_str());break;
		case 178: configTime(TZ_America_Santo_Domingo, (char*)this->settings.host.c_str());break;
		case 179: configTime(TZ_America_Sao_Paulo, (char*)this->settings.host.c_str());break;
		case 180: configTime(TZ_America_Scoresbysund, (char*)this->settings.host.c_str());break;
		case 181: configTime(TZ_America_Sitka, (char*)this->settings.host.c_str());break;
		case 182: configTime(TZ_America_St_Barthelemy, (char*)this->settings.host.c_str());break;
		case 183: configTime(TZ_America_St_Johns, (char*)this->settings.host.c_str());break;
		case 184: configTime(TZ_America_St_Kitts, (char*)this->settings.host.c_str());break;
		case 185: configTime(TZ_America_St_Lucia, (char*)this->settings.host.c_str());break;
		case 186: configTime(TZ_America_St_Thomas, (char*)this->settings.host.c_str());break;
		case 187: configTime(TZ_America_St_Vincent, (char*)this->settings.host.c_str());break;
		case 188: configTime(TZ_America_Swift_Current, (char*)this->settings.host.c_str());break;
		case 189: configTime(TZ_America_Tegucigalpa, (char*)this->settings.host.c_str());break;
		case 190: configTime(TZ_America_Thule, (char*)this->settings.host.c_str());break;
		case 191: configTime(TZ_America_Thunder_Bay, (char*)this->settings.host.c_str());break;
		case 192: configTime(TZ_America_Tijuana, (char*)this->settings.host.c_str());break;
		case 193: configTime(TZ_America_Toronto, (char*)this->settings.host.c_str());break;
		case 194: configTime(TZ_America_Tortola, (char*)this->settings.host.c_str());break;
		case 195: configTime(TZ_America_Vancouver, (char*)this->settings.host.c_str());break;
		case 196: configTime(TZ_America_Whitehorse, (char*)this->settings.host.c_str());break;
		case 197: configTime(TZ_America_Winnipeg, (char*)this->settings.host.c_str());break;
		case 198: configTime(TZ_America_Yakutat, (char*)this->settings.host.c_str());break;
		case 199: configTime(TZ_America_Yellowknife, (char*)this->settings.host.c_str());break;
		case 200: configTime(TZ_Antarctica_Casey, (char*)this->settings.host.c_str());break;
		case 201: configTime(TZ_Antarctica_Davis, (char*)this->settings.host.c_str());break;
		case 202: configTime(TZ_Antarctica_DumontDUrville, (char*)this->settings.host.c_str());break;
		case 203: configTime(TZ_Antarctica_Macquarie, (char*)this->settings.host.c_str());break;
		case 204: configTime(TZ_Antarctica_Mawson, (char*)this->settings.host.c_str());break;
		case 205: configTime(TZ_Antarctica_McMurdo, (char*)this->settings.host.c_str());break;
		case 206: configTime(TZ_Antarctica_Palmer, (char*)this->settings.host.c_str());break;
		case 207: configTime(TZ_Antarctica_Rothera, (char*)this->settings.host.c_str());break;
		case 208: configTime(TZ_Antarctica_Syowa, (char*)this->settings.host.c_str());break;
		case 209: configTime(TZ_Antarctica_Troll, (char*)this->settings.host.c_str());break;
		case 210: configTime(TZ_Antarctica_Vostok, (char*)this->settings.host.c_str());break;
		case 211: configTime(TZ_Arctic_Longyearbyen, (char*)this->settings.host.c_str());break;
		case 212: configTime(TZ_Asia_Aden, (char*)this->settings.host.c_str());break;
		case 213: configTime(TZ_Asia_Almaty, (char*)this->settings.host.c_str());break;
		case 214: configTime(TZ_Asia_Amman, (char*)this->settings.host.c_str());break;
		case 215: configTime(TZ_Asia_Anadyr, (char*)this->settings.host.c_str());break;
		case 216: configTime(TZ_Asia_Aqtau, (char*)this->settings.host.c_str());break;
		case 217: configTime(TZ_Asia_Aqtobe, (char*)this->settings.host.c_str());break;
		case 218: configTime(TZ_Asia_Ashgabat, (char*)this->settings.host.c_str());break;
		case 219: configTime(TZ_Asia_Atyrau, (char*)this->settings.host.c_str());break;
		case 220: configTime(TZ_Asia_Baghdad, (char*)this->settings.host.c_str());break;
		case 221: configTime(TZ_Asia_Bahrain, (char*)this->settings.host.c_str());break;
		case 222: configTime(TZ_Asia_Baku, (char*)this->settings.host.c_str());break;
		case 223: configTime(TZ_Asia_Bangkok, (char*)this->settings.host.c_str());break;
		case 224: configTime(TZ_Asia_Barnaul, (char*)this->settings.host.c_str());break;
		case 225: configTime(TZ_Asia_Beirut, (char*)this->settings.host.c_str());break;
		case 226: configTime(TZ_Asia_Bishkek, (char*)this->settings.host.c_str());break;
		case 227: configTime(TZ_Asia_Brunei, (char*)this->settings.host.c_str());break;
		case 228: configTime(TZ_Asia_Chita, (char*)this->settings.host.c_str());break;
		case 229: configTime(TZ_Asia_Choibalsan, (char*)this->settings.host.c_str());break;
		case 230: configTime(TZ_Asia_Colombo, (char*)this->settings.host.c_str());break;
		case 231: configTime(TZ_Asia_Damascus, (char*)this->settings.host.c_str());break;
		case 232: configTime(TZ_Asia_Dhaka, (char*)this->settings.host.c_str());break;
		case 233: configTime(TZ_Asia_Dili, (char*)this->settings.host.c_str());break;
		case 234: configTime(TZ_Asia_Dubai, (char*)this->settings.host.c_str());break;
		case 235: configTime(TZ_Asia_Dushanbe, (char*)this->settings.host.c_str());break;
		case 236: configTime(TZ_Asia_Famagusta, (char*)this->settings.host.c_str());break;
		case 237: configTime(TZ_Asia_Gaza, (char*)this->settings.host.c_str());break;
		case 238: configTime(TZ_Asia_Hebron, (char*)this->settings.host.c_str());break;
		case 239: configTime(TZ_Asia_Ho_Chi_Minh, (char*)this->settings.host.c_str());break;
		case 240: configTime(TZ_Asia_Hong_Kong, (char*)this->settings.host.c_str());break;
		case 241: configTime(TZ_Asia_Hovd, (char*)this->settings.host.c_str());break;
		case 242: configTime(TZ_Asia_Irkutsk, (char*)this->settings.host.c_str());break;
		case 243: configTime(TZ_Asia_Jakarta, (char*)this->settings.host.c_str());break;
		case 244: configTime(TZ_Asia_Jayapura, (char*)this->settings.host.c_str());break;
		case 245: configTime(TZ_Asia_Jerusalem, (char*)this->settings.host.c_str());break;
		case 246: configTime(TZ_Asia_Kabul, (char*)this->settings.host.c_str());break;
		case 247: configTime(TZ_Asia_Kamchatka, (char*)this->settings.host.c_str());break;
		case 248: configTime(TZ_Asia_Karachi, (char*)this->settings.host.c_str());break;
		case 249: configTime(TZ_Asia_Kathmandu, (char*)this->settings.host.c_str());break;
		case 250: configTime(TZ_Asia_Khandyga, (char*)this->settings.host.c_str());break;
		case 251: configTime(TZ_Asia_Kolkata, (char*)this->settings.host.c_str());break;
		case 252: configTime(TZ_Asia_Krasnoyarsk, (char*)this->settings.host.c_str());break;
		case 253: configTime(TZ_Asia_Kuala_Lumpur, (char*)this->settings.host.c_str());break;
		case 254: configTime(TZ_Asia_Kuching, (char*)this->settings.host.c_str());break;
		case 255: configTime(TZ_Asia_Kuwait, (char*)this->settings.host.c_str());break;
		case 256: configTime(TZ_Asia_Macau, (char*)this->settings.host.c_str());break;
		case 257: configTime(TZ_Asia_Magadan, (char*)this->settings.host.c_str());break;
		case 258: configTime(TZ_Asia_Makassar, (char*)this->settings.host.c_str());break;
		case 259: configTime(TZ_Asia_Manila, (char*)this->settings.host.c_str());break;
		case 260: configTime(TZ_Asia_Muscat, (char*)this->settings.host.c_str());break;
		case 261: configTime(TZ_Asia_Nicosia, (char*)this->settings.host.c_str());break;
		case 262: configTime(TZ_Asia_Novokuznetsk, (char*)this->settings.host.c_str());break;
		case 263: configTime(TZ_Asia_Novosibirsk, (char*)this->settings.host.c_str());break;
		case 264: configTime(TZ_Asia_Omsk, (char*)this->settings.host.c_str());break;
		case 265: configTime(TZ_Asia_Oral, (char*)this->settings.host.c_str());break;
		case 266: configTime(TZ_Asia_Phnom_Penh, (char*)this->settings.host.c_str());break;
		case 267: configTime(TZ_Asia_Pontianak, (char*)this->settings.host.c_str());break;
		case 268: configTime(TZ_Asia_Pyongyang, (char*)this->settings.host.c_str());break;
		case 269: configTime(TZ_Asia_Qatar, (char*)this->settings.host.c_str());break;
		case 270: configTime(TZ_Asia_Qyzylorda, (char*)this->settings.host.c_str());break;
		case 271: configTime(TZ_Asia_Riyadh, (char*)this->settings.host.c_str());break;
		case 272: configTime(TZ_Asia_Sakhalin, (char*)this->settings.host.c_str());break;
		case 273: configTime(TZ_Asia_Samarkand, (char*)this->settings.host.c_str());break;
		case 274: configTime(TZ_Asia_Seoul, (char*)this->settings.host.c_str());break;
		case 275: configTime(TZ_Asia_Shanghai, (char*)this->settings.host.c_str());break;
		case 276: configTime(TZ_Asia_Singapore, (char*)this->settings.host.c_str());break;
		case 277: configTime(TZ_Asia_Srednekolymsk, (char*)this->settings.host.c_str());break;
		case 278: configTime(TZ_Asia_Taipei, (char*)this->settings.host.c_str());break;
		case 279: configTime(TZ_Asia_Tashkent, (char*)this->settings.host.c_str());break;
		case 280: configTime(TZ_Asia_Tbilisi, (char*)this->settings.host.c_str());break;
		case 281: configTime(TZ_Asia_Tehran, (char*)this->settings.host.c_str());break;
		case 282: configTime(TZ_Asia_Thimphu, (char*)this->settings.host.c_str());break;
		case 283: configTime(TZ_Asia_Tokyo, (char*)this->settings.host.c_str());break;
		case 284: configTime(TZ_Asia_Tomsk, (char*)this->settings.host.c_str());break;
		case 285: configTime(TZ_Asia_Ulaanbaatar, (char*)this->settings.host.c_str());break;
		case 286: configTime(TZ_Asia_Urumqi, (char*)this->settings.host.c_str());break;
		case 287: configTime(TZ_Asia_UstmNera, (char*)this->settings.host.c_str());break;
		case 288: configTime(TZ_Asia_Vientiane, (char*)this->settings.host.c_str());break;
		case 289: configTime(TZ_Asia_Vladivostok, (char*)this->settings.host.c_str());break;
		case 290: configTime(TZ_Asia_Yakutsk, (char*)this->settings.host.c_str());break;
		case 291: configTime(TZ_Asia_Yangon, (char*)this->settings.host.c_str());break;
		case 292: configTime(TZ_Asia_Yekaterinburg, (char*)this->settings.host.c_str());break;
		case 293: configTime(TZ_Asia_Yerevan, (char*)this->settings.host.c_str());break;
		case 294: configTime(TZ_Atlantic_Azores, (char*)this->settings.host.c_str());break;
		case 295: configTime(TZ_Atlantic_Bermuda, (char*)this->settings.host.c_str());break;
		case 296: configTime(TZ_Atlantic_Canary, (char*)this->settings.host.c_str());break;
		case 297: configTime(TZ_Atlantic_Cape_Verde, (char*)this->settings.host.c_str());break;
		case 298: configTime(TZ_Atlantic_Faroe, (char*)this->settings.host.c_str());break;
		case 299: configTime(TZ_Atlantic_Madeira, (char*)this->settings.host.c_str());break;
		case 300: configTime(TZ_Atlantic_Reykjavik, (char*)this->settings.host.c_str());break;
		case 301: configTime(TZ_Atlantic_South_Georgia, (char*)this->settings.host.c_str());break;
		case 302: configTime(TZ_Atlantic_Stanley, (char*)this->settings.host.c_str());break;
		case 303: configTime(TZ_Atlantic_St_Helena, (char*)this->settings.host.c_str());break;
		case 304: configTime(TZ_Australia_Adelaide, (char*)this->settings.host.c_str());break;
		case 305: configTime(TZ_Australia_Brisbane, (char*)this->settings.host.c_str());break;
		case 306: configTime(TZ_Australia_Broken_Hill, (char*)this->settings.host.c_str());break;
		case 307: configTime(TZ_Australia_Currie, (char*)this->settings.host.c_str());break;
		case 308: configTime(TZ_Australia_Darwin, (char*)this->settings.host.c_str());break;
		case 309: configTime(TZ_Australia_Eucla, (char*)this->settings.host.c_str());break;
		case 310: configTime(TZ_Australia_Hobart, (char*)this->settings.host.c_str());break;
		case 311: configTime(TZ_Australia_Lindeman, (char*)this->settings.host.c_str());break;
		case 312: configTime(TZ_Australia_Lord_Howe, (char*)this->settings.host.c_str());break;
		case 313: configTime(TZ_Australia_Melbourne, (char*)this->settings.host.c_str());break;
		case 314: configTime(TZ_Australia_Perth, (char*)this->settings.host.c_str());break;
		case 315: configTime(TZ_Australia_Sydney, (char*)this->settings.host.c_str());break;
		case 316: configTime(TZ_Europe_Amsterdam, (char*)this->settings.host.c_str());break;
		case 317: configTime(TZ_Europe_Andorra, (char*)this->settings.host.c_str());break;
		case 318: configTime(TZ_Europe_Astrakhan, (char*)this->settings.host.c_str());break;
		case 319: configTime(TZ_Europe_Athens, (char*)this->settings.host.c_str());break;
		case 320: configTime(TZ_Europe_Belgrade, (char*)this->settings.host.c_str());break;
		case 321: configTime(TZ_Europe_Berlin, (char*)this->settings.host.c_str());break;
		case 322: configTime(TZ_Europe_Bratislava, (char*)this->settings.host.c_str());break;
		case 323: configTime(TZ_Europe_Brussels, (char*)this->settings.host.c_str());break;
		case 324: configTime(TZ_Europe_Bucharest, (char*)this->settings.host.c_str());break;
		case 325: configTime(TZ_Europe_Budapest, (char*)this->settings.host.c_str());break;
		case 326: configTime(TZ_Europe_Busingen, (char*)this->settings.host.c_str());break;
		case 327: configTime(TZ_Europe_Chisinau, (char*)this->settings.host.c_str());break;
		case 328: configTime(TZ_Europe_Copenhagen, (char*)this->settings.host.c_str());break;
		case 329: configTime(TZ_Europe_Dublin, (char*)this->settings.host.c_str());break;
		case 330: configTime(TZ_Europe_Gibraltar, (char*)this->settings.host.c_str());break;
		case 331: configTime(TZ_Europe_Guernsey, (char*)this->settings.host.c_str());break;
		case 332: configTime(TZ_Europe_Helsinki, (char*)this->settings.host.c_str());break;
		case 333: configTime(TZ_Europe_Isle_of_Man, (char*)this->settings.host.c_str());break;
		case 334: configTime(TZ_Europe_Istanbul, (char*)this->settings.host.c_str());break;
		case 335: configTime(TZ_Europe_Jersey, (char*)this->settings.host.c_str());break;
		case 336: configTime(TZ_Europe_Kaliningrad, (char*)this->settings.host.c_str());break;
		case 337: configTime(TZ_Europe_Kiev, (char*)this->settings.host.c_str());break;
		case 338: configTime(TZ_Europe_Kirov, (char*)this->settings.host.c_str());break;
		case 339: configTime(TZ_Europe_Lisbon, (char*)this->settings.host.c_str());break;
		case 340: configTime(TZ_Europe_Ljubljana, (char*)this->settings.host.c_str());break;
		case 341: configTime(TZ_Europe_London, (char*)this->settings.host.c_str());break;
		case 342: configTime(TZ_Europe_Luxembourg, (char*)this->settings.host.c_str());break;
		case 343: configTime(TZ_Europe_Madrid, (char*)this->settings.host.c_str());break;
		case 344: configTime(TZ_Europe_Malta, (char*)this->settings.host.c_str());break;
		case 345: configTime(TZ_Europe_Mariehamn, (char*)this->settings.host.c_str());break;
		case 346: configTime(TZ_Europe_Minsk, (char*)this->settings.host.c_str());break;
		case 347: configTime(TZ_Europe_Monaco, (char*)this->settings.host.c_str());break;
		case 348: configTime(TZ_Europe_Moscow, (char*)this->settings.host.c_str());break;
		case 349: configTime(TZ_Europe_Oslo, (char*)this->settings.host.c_str());break;
		case 350: configTime(TZ_Europe_Paris, (char*)this->settings.host.c_str());break;
		case 351: configTime(TZ_Europe_Podgorica, (char*)this->settings.host.c_str());break;
		case 352: configTime(TZ_Europe_Prague, (char*)this->settings.host.c_str());break;
		case 353: configTime(TZ_Europe_Riga, (char*)this->settings.host.c_str());break;
		case 354: configTime(TZ_Europe_Rome, (char*)this->settings.host.c_str());break;
		case 355: configTime(TZ_Europe_Samara, (char*)this->settings.host.c_str());break;
		case 356: configTime(TZ_Europe_San_Marino, (char*)this->settings.host.c_str());break;
		case 357: configTime(TZ_Europe_Sarajevo, (char*)this->settings.host.c_str());break;
		case 358: configTime(TZ_Europe_Saratov, (char*)this->settings.host.c_str());break;
		case 359: configTime(TZ_Europe_Simferopol, (char*)this->settings.host.c_str());break;
		case 360: configTime(TZ_Europe_Skopje, (char*)this->settings.host.c_str());break;
		case 361: configTime(TZ_Europe_Sofia, (char*)this->settings.host.c_str());break;
		case 362: configTime(TZ_Europe_Stockholm, (char*)this->settings.host.c_str());break;
		case 363: configTime(TZ_Europe_Tallinn, (char*)this->settings.host.c_str());break;
		case 364: configTime(TZ_Europe_Tirane, (char*)this->settings.host.c_str());break;
		case 365: configTime(TZ_Europe_Ulyanovsk, (char*)this->settings.host.c_str());break;
		case 366: configTime(TZ_Europe_Uzhgorod, (char*)this->settings.host.c_str());break;
		case 367: configTime(TZ_Europe_Vaduz, (char*)this->settings.host.c_str());break;
		case 368: configTime(TZ_Europe_Vatican, (char*)this->settings.host.c_str());break;
		case 369: configTime(TZ_Europe_Vienna, (char*)this->settings.host.c_str());break;
		case 370: configTime(TZ_Europe_Vilnius, (char*)this->settings.host.c_str());break;
		case 371: configTime(TZ_Europe_Volgograd, (char*)this->settings.host.c_str());break;
		case 372: configTime(TZ_Europe_Warsaw, (char*)this->settings.host.c_str());break;
		case 373: configTime(TZ_Europe_Zagreb, (char*)this->settings.host.c_str());break;
		case 374: configTime(TZ_Europe_Zaporozhye, (char*)this->settings.host.c_str());break;
		case 375: configTime(TZ_Europe_Zurich, (char*)this->settings.host.c_str());break;
		case 376: configTime(TZ_Indian_Antananarivo, (char*)this->settings.host.c_str());break;
		case 377: configTime(TZ_Indian_Chagos, (char*)this->settings.host.c_str());break;
		case 378: configTime(TZ_Indian_Christmas, (char*)this->settings.host.c_str());break;
		case 379: configTime(TZ_Indian_Cocos, (char*)this->settings.host.c_str());break;
		case 380: configTime(TZ_Indian_Comoro, (char*)this->settings.host.c_str());break;
		case 381: configTime(TZ_Indian_Kerguelen, (char*)this->settings.host.c_str());break;
		case 382: configTime(TZ_Indian_Mahe, (char*)this->settings.host.c_str());break;
		case 383: configTime(TZ_Indian_Maldives, (char*)this->settings.host.c_str());break;
		case 384: configTime(TZ_Indian_Mauritius, (char*)this->settings.host.c_str());break;
		case 385: configTime(TZ_Indian_Mayotte, (char*)this->settings.host.c_str());break;
		case 386: configTime(TZ_Indian_Reunion, (char*)this->settings.host.c_str());break;
		case 387: configTime(TZ_Pacific_Apia, (char*)this->settings.host.c_str());break;
		case 388: configTime(TZ_Pacific_Auckland, (char*)this->settings.host.c_str());break;
		case 389: configTime(TZ_Pacific_Bougainville, (char*)this->settings.host.c_str());break;
		case 390: configTime(TZ_Pacific_Chatham, (char*)this->settings.host.c_str());break;
		case 391: configTime(TZ_Pacific_Chuuk, (char*)this->settings.host.c_str());break;
		case 392: configTime(TZ_Pacific_Easter, (char*)this->settings.host.c_str());break;
		case 393: configTime(TZ_Pacific_Efate, (char*)this->settings.host.c_str());break;
		case 394: configTime(TZ_Pacific_Enderbury, (char*)this->settings.host.c_str());break;
		case 395: configTime(TZ_Pacific_Fakaofo, (char*)this->settings.host.c_str());break;
		case 396: configTime(TZ_Pacific_Fiji	, (char*)this->settings.host.c_str());break;
		case 397: configTime(TZ_Pacific_Funafuti, (char*)this->settings.host.c_str());break;
		case 398: configTime(TZ_Pacific_Galapagos, (char*)this->settings.host.c_str());break;
		case 399: configTime(TZ_Pacific_Gambier, (char*)this->settings.host.c_str());break;
		case 400: configTime(TZ_Pacific_Guadalcanal, (char*)this->settings.host.c_str());break;
		case 401: configTime(TZ_Pacific_Guam, (char*)this->settings.host.c_str());break;
		case 402: configTime(TZ_Pacific_Honolulu, (char*)this->settings.host.c_str());break;
		case 403: configTime(TZ_Pacific_Kiritimati, (char*)this->settings.host.c_str());break;
		case 404: configTime(TZ_Pacific_Kosrae, (char*)this->settings.host.c_str());break;
		case 405: configTime(TZ_Pacific_Kwajalein, (char*)this->settings.host.c_str());break;
		case 406: configTime(TZ_Pacific_Majuro, (char*)this->settings.host.c_str());break;
		case 407: configTime(TZ_Pacific_Marquesas, (char*)this->settings.host.c_str());break;
		case 408: configTime(TZ_Pacific_Midway, (char*)this->settings.host.c_str());break;
		case 409: configTime(TZ_Pacific_Nauru, (char*)this->settings.host.c_str());break;
		case 410: configTime(TZ_Pacific_Niue, (char*)this->settings.host.c_str());break;
		case 411: configTime(TZ_Pacific_Norfolk, (char*)this->settings.host.c_str());break;
		case 412: configTime(TZ_Pacific_Noumea, (char*)this->settings.host.c_str());break;
		case 413: configTime(TZ_Pacific_Pago_Pago, (char*)this->settings.host.c_str());break;
		case 414: configTime(TZ_Pacific_Palau, (char*)this->settings.host.c_str());break;
		case 415: configTime(TZ_Pacific_Pitcairn, (char*)this->settings.host.c_str());break;
		case 416: configTime(TZ_Pacific_Pohnpei, (char*)this->settings.host.c_str());break;
		case 417: configTime(TZ_Pacific_Port_Moresby, (char*)this->settings.host.c_str());break;
		case 418: configTime(TZ_Pacific_Rarotonga, (char*)this->settings.host.c_str());break;
		case 419: configTime(TZ_Pacific_Saipan, (char*)this->settings.host.c_str());break;
		case 420: configTime(TZ_Pacific_Tahiti, (char*)this->settings.host.c_str());break;
		case 421: configTime(TZ_Pacific_Tarawa, (char*)this->settings.host.c_str());break;
		case 422: configTime(TZ_Pacific_Tongatapu, (char*)this->settings.host.c_str());break;
		case 423: configTime(TZ_Pacific_Wake, (char*)this->settings.host.c_str());break;
		case 424: configTime(TZ_Pacific_Wallis, (char*)this->settings.host.c_str());break;
		case 425: configTime(TZ_Etc_GMT, (char*)this->settings.host.c_str());break;
		case 426: configTime(TZ_Etc_GMTm0, (char*)this->settings.host.c_str());break;
		case 427: configTime(TZ_Etc_GMTm1, (char*)this->settings.host.c_str());break;
		case 428: configTime(TZ_Etc_GMTm2, (char*)this->settings.host.c_str());break;
		case 429: configTime(TZ_Etc_GMTm3, (char*)this->settings.host.c_str());break;
		case 430: configTime(TZ_Etc_GMTm4, (char*)this->settings.host.c_str());break;
		case 431: configTime(TZ_Etc_GMTm5, (char*)this->settings.host.c_str());break;
		case 432: configTime(TZ_Etc_GMTm6, (char*)this->settings.host.c_str());break;
		case 433: configTime(TZ_Etc_GMTm7, (char*)this->settings.host.c_str());break;
		case 434: configTime(TZ_Etc_GMTm8, (char*)this->settings.host.c_str());break;
		case 435: configTime(TZ_Etc_GMTm9, (char*)this->settings.host.c_str());break;
		case 436: configTime(TZ_Etc_GMTm10, (char*)this->settings.host.c_str());break;
		case 437: configTime(TZ_Etc_GMTm11, (char*)this->settings.host.c_str());break;
		case 438: configTime(TZ_Etc_GMTm12, (char*)this->settings.host.c_str());break;
		case 439: configTime(TZ_Etc_GMTm13, (char*)this->settings.host.c_str());break;
		case 440: configTime(TZ_Etc_GMTm14, (char*)this->settings.host.c_str());break;
		case 441: configTime(TZ_Etc_GMT0, (char*)this->settings.host.c_str());break;
		case 442: configTime(TZ_Etc_GMTp0, (char*)this->settings.host.c_str());break;
		case 443: configTime(TZ_Etc_GMTp1, (char*)this->settings.host.c_str());break;
		case 444: configTime(TZ_Etc_GMTp2, (char*)this->settings.host.c_str());break;
		case 445: configTime(TZ_Etc_GMTp3, (char*)this->settings.host.c_str());break;
		case 446: configTime(TZ_Etc_GMTp4, (char*)this->settings.host.c_str());break;
		case 447: configTime(TZ_Etc_GMTp5, (char*)this->settings.host.c_str());break;
		case 448: configTime(TZ_Etc_GMTp6, (char*)this->settings.host.c_str());break;
		case 449: configTime(TZ_Etc_GMTp7, (char*)this->settings.host.c_str());break;
		case 450: configTime(TZ_Etc_GMTp8, (char*)this->settings.host.c_str());break;
		case 451: configTime(TZ_Etc_GMTp9, (char*)this->settings.host.c_str());break;
		case 452: configTime(TZ_Etc_GMTp10, (char*)this->settings.host.c_str());break;
		case 453: configTime(TZ_Etc_GMTp11, (char*)this->settings.host.c_str());break;
		case 454: configTime(TZ_Etc_GMTp12, (char*)this->settings.host.c_str());break;
		case 455: configTime(TZ_Etc_UCT, (char*)this->settings.host.c_str());break;
		case 456: configTime(TZ_Etc_UTC, (char*)this->settings.host.c_str());break;
		case 457: configTime(TZ_Etc_Greenwich, (char*)this->settings.host.c_str());break;
		case 458: configTime(TZ_Etc_Universal, (char*)this->settings.host.c_str());break;
		case 459: configTime(TZ_Etc_Zulu, (char*)this->settings.host.c_str());break;
	}
}

void System::NTP::state(JsonObject& params, JsonObject& response, JsonObject& broadcast) {
	JsonObject object = this->rootIT(response);
	JsonObject state = object.createNestedObject("state");
	this->JSON(state);
	
	time_t t = time(nullptr);
	tm* ltm = localtime(&t);
	
	state["host"] = this->settings.host;
	state["tz"] = this->settings.tz;
	state["now"] = // improve this, wtf
		String(ltm->tm_mday) + "/" + String(ltm->tm_mon) + "/" + String(1900 + ltm->tm_year) + " " +
		String(ltm->tm_hour) + ":" + (10 <= ltm->tm_min ? "" : "0") + String(ltm->tm_min);
}

void System::NTP::getPing(JsonObject& response) {
	JsonObject object = this->rootIT(response);
	JsonObject mparams = object.createNestedObject("state");
	
	time_t t = time(nullptr);
	tm* ltm = localtime(&t);
	mparams["now"] = // improve this, wtf
		String(ltm->tm_mday) + "/" + String(ltm->tm_mon) + "/" + String(1900 + ltm->tm_year) + " " +
		String(ltm->tm_hour) + ":" + (10 <= ltm->tm_min ? "" : "0") + String(ltm->tm_min);
}

void System::NTP::JSON(JsonObject& ntp) {
	ntp["host"] = this->settings.host;
	ntp["tz"] = this->settings.tz;
}

void System::NTP::fromJSON(JsonObject& params) {
	if (params.containsKey("host")) { this->settings.host = params["host"].as<String>(); }
	if (params.containsKey("tz")) {this->settings.tz = params["tz"]; }
}


