static const char HTML[] PROGMEM = R""""(
<!DOCTYPE html>
<html lang='en'>
	<head>
		<meta charset='UTF-8'>
<script type='text/javascript'>
ArrayBuffer.prototype.toB64=function(url=false){let base64Chars='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'+(url?'-_':'+/');let str='',ui8=new Uint8Array(this);for(let i=0,b=0;i<ui8.length;i++){let ui=ui8[i],le=2*(i%3),p=2+le,na=(ui>>p);str+=base64Chars[na|b];let p2=2**p-1,ml=(4-le);b=(ui&p2)<<ml;if(0==ml||i==(ui8.length-1)){str+=base64Chars[b];b=0;}}
while(!url&&(str.length&3)>0)str+='=';return str;};ArrayBuffer.prototype.toB16=function(){let str='';let uia=new Uint8Array(this);for(let ui of uia){let b16=ui.toString(16);str+=b16.padStart(2,'0');}
return str;};String.prototype.b64ToAB=function(url=false){let base64Chars='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'+(url?'-_':'+/');let str=this.replace(/=/gi,'');let length=Math.floor(str.length*6/8);let arrayBuffer=new ArrayBuffer(length);let uia=new Uint8Array(arrayBuffer);for(let i=0,si=-1;i<length;i++){let m=2*(i%3),e1=6-m,b1=2**e1-1;si+=+(0==i%3);let c=str[si],ci1=base64Chars.indexOf(c);uia[i]=(ci1&b1)<<(2+m);let e2=4-m,b2=63-(2**e2-1),c2=str[++si]||'A',ci2=base64Chars.indexOf(c2);uia[i]|=(ci2&b2)>>(4-m);}
return arrayBuffer;};String.prototype.b16ToAB=function(){let str=(0==(this.length%2))?this:('0'+this);let arrayBuffer=new ArrayBuffer(str.length/2);let uia=new Uint8Array(arrayBuffer);for(let j=0;j<uia.length;j++){let s=str.substring(2*j,2*j+2);uia[j]=parseInt(s,16);}
return arrayBuffer;};String.prototype.JWK=async function(){let promise=new Promise((resolve,reject)=>{let worker=new Worker('lib/crypto/JwkGenerator.js?v=1');worker.onmessage=function(e){resolve(e.data);this.terminate();};worker.postMessage(this);});return promise;};Number.prototype.battery=function(){let bin3v3=1024;let binMax=3.9*bin3v3/3.3;let binMin=3.5*bin3v3/3.3;let range=binMax-binMin;let read=2*this-binMin;let percentage=Math.max(0,Math.min(100*(read/range),100));return percentage;};Number.prototype.mod=function(n){return((this%n)+n)%n;};let Node=function(parent,name){this.parent=parent;this.name=name;this.children=[];};Node.prototype.name='';Node.prototype.addNode=function(node){this.tag.append(node.tag);this.children.push(node);};Node.prototype.oncommand=function(command){for(let key in command){let attribute=this[key];if('function'==typeof attribute){let mparams=command[key];attribute.call(this,mparams);}}
for(let key in command){let attribute=this[key];if('object'==typeof attribute){if(attribute.oncommand){let icommand=command[key];attribute.oncommand(icommand);}else{console.log(`Unimplemented ${key}.oncommand(command)`);}}else if('function'!=typeof attribute){console.log(`Unknown property ${this.name}.${key}`);}}};Node.prototype.stateCommand=function(){let command={};command.state={};return command;};Node.prototype.command=function(command){let pcommand={};pcommand[this.name]=command;this.parent.command(pcommand);};Node.prototype.log=function(params){console.log(this.name+' : '+params.text);};Node.prototype.hasChanges=function(){let hasChanges=this.isChanged();for(let node of this.children){hasChanges=hasChanges||node.hasChanges();}
return hasChanges;};Node.prototype.isChanged=function(){return false;};Node.prototype.save=function(command){for(let key in this.children){let node=this.children[key];let hasChanges=node.hasChanges();if(hasChanges){let icommand=command[node.name]=command[node.name]||{};node.save(icommand);}}};Node.prototype.validate=function(){let valid=true;for(let key in this.children){let node=this.children[key];valid=node.validate()&&valid;}
return valid;};Node.prototype.showMessage=function(message,html=false){this.parent.showMessage(message,html);};let NetworkNode=function(parent,name,host='',port=80){Node.call(this,parent,name);this.host=host;this.hport=port;this.wport=8080;this.aes=null;this.jlid=null;this.syncID=0;this.errors=0;};for(let i in Node.prototype)
NetworkNode.prototype[i]=Node.prototype[i];NetworkNode.prototype.onLoggedin=function(){};NetworkNode.prototype.onConnected=function(){};NetworkNode.prototype.onLoginError=function(){};NetworkNode.prototype.onSynced=function(){};NetworkNode.prototype.onErrorSyncing=function(){};NetworkNode.prototype.onLoggedOut=function(){};NetworkNode.prototype.reconnectTimeout=null;NetworkNode.prototype.init=function(){this.requestJLID();};NetworkNode.prototype.setJLID=function(jlid){this.jlid=jlid;this.syncID=this.jlid.l-Date.now()+1;};NetworkNode.prototype.getJLID=function(){let jlid={};jlid.b=this.jlid.b;jlid.l=this.syncID+Date.now();return jlid;};NetworkNode.prototype.requestJLID=function(){this.sendRequest('/s','',this.onjlid.bind(this));};NetworkNode.prototype.onjlid=function(response){if(!response.error){let jlid=JSON.parse(response);this.setJLID(jlid);this.onSynced();}else{console.log('error syncing, trying again ...');console.log(response);setTimeout(this.requestJLID.bind(this),2*1000);}};NetworkNode.prototype.okClicked=function(){if(this.jlid){if(this.changeButton.showing){this.change();}else{this.login();}}};NetworkNode.prototype.signin=function(user,pass){let hash=Sha256.hash(user+pass);this.hsignin(hash);};NetworkNode.prototype.hsignin=function(hash){this.aesm=new AESM(hash);this.httpCommand({'login':{}},this.loggedin.bind(this));};NetworkNode.prototype.change=function(user,pass,newUser,newPass){let hash=Sha256.hash(user+pass);this.aesm=new AESM(hash);let newHash=Sha256.hash(newUser+newPass);let newKey=newHash.b16ToAB().toB64();let params={};params.key=newKey;this.httpCommand({'change':params},this.loggedin.bind(this));this.aesm=new AESM(newHash);};NetworkNode.prototype.loggedin=function(response){try{let dataSTR=this.aesm.decrypt(response);console.log(dataSTR);let commands=JSON.parse(dataSTR);switch(commands[0].error){case 1:this.setJLID(commands[0].jlid);this.onLoginError();break;default:this.wport=commands[0].wport;this.onLoggedin(commands[0]);this.connect();break;}}catch(e){this.onLoginError();console.error(e,e.stack);}};NetworkNode.prototype.httpCommand=async function(params,callback){let command={};command.id=this.getJLID();command.p=params;let commandSTR=JSON.stringify(command);let edata=this.aesm.encrypt(commandSTR);this.sendRequest('/u',edata,callback);};NetworkNode.prototype.sendRequest=function(path,data='',callback){let encodedData=encodeURIComponent(data);let request=new XMLHttpRequest();request.open('GET',`http://${this.host}:${this.hport}${path}?d=${encodedData}`);request.onreadystatechange=()=>{if(4==request.readyState){if(200==request.status){try{callback(request.responseText);}catch(e){let response={};response.error=4;response.cause=e;callback(response);}}}};request.onerror=(e)=>{console.log('Network error, trying again ...');this.errors+=1;if(5>=this.errors){setTimeout(this.sendRequest.bind(this,path,data,callback),3*1000);}else{this.logout();}};request.send();};NetworkNode.prototype.command=function(params){console.log(JSON.stringify(params));if(this.socket&&WebSocket.OPEN==this.socket.readyState){let command={};command.id=this.getJLID();command.p=params;let commandSTR=JSON.stringify(command);let edata=this.aesm.encrypt(commandSTR);this.socket.send(edata);}else{this.httpCommand(params,(responseText)=>{try{let dataSTR=this.aesm.decrypt(responseText);console.log(dataSTR);let commands=JSON.parse(dataSTR);for(let command of commands){this.execute(command);}}catch(e){console.error(e,e.stack);}});}};NetworkNode.prototype.userCommand=function(params){this.command(params);};NetworkNode.prototype.logout=function(){this.errors=0;clearTimeout(this.reconnectTimeout);this.onLoggedOut();try{if(this.socket){this.socket.onclose=()=>{};this.socket.close();}}catch(e){console.error(e,e.stack);}};NetworkNode.prototype.connect=function(){try{clearTimeout(this.reconnectTimeout);this.socket=new WebSocket(`ws://${this.host}:${this.wport}/`,['arduino']);this.socket.onopen=this.onopen.bind(this);this.socket.onerror=this.onerror.bind(this);this.socket.onmessage=this.onmessage.bind(this);this.socket.onclose=this.onclose.bind(this);}catch(e){console.error(e,e.stack);}};NetworkNode.prototype.onopen=function(){this.onConnected();};NetworkNode.prototype.onerror=function(error){};NetworkNode.prototype.onclose=function(e){clearTimeout(this.reconnectTimeout);this.reconnectTimeout=setTimeout(this.connect.bind(this),3*1000);};NetworkNode.prototype.onmessage=function(e){try{let dataSTR=this.aesm.decrypt(e.data);console.log(dataSTR);let command=JSON.parse(dataSTR);this.execute(command);}catch(e){console.error(e,e.stack);}};NetworkNode.prototype.execute=function(command){switch(command.error){case 1:this.errors+=1;if(5>=this.errors){this.setJLID(command.jlid);console.log('Error on user command, trying again ...');setTimeout(this.userCommand.bind(this,command.c),1000);}else{this.logout();}
break;default:this.errors=0;this.oncommand(command);break;}};'use strict';(function(root){function checkInt(value){return(parseInt(value)===value);}
function checkInts(arrayish){if(!checkInt(arrayish.length)){return false;}
for(var i=0;i<arrayish.length;i++){if(!checkInt(arrayish[i])||arrayish[i]<0||arrayish[i]>255){return false;}}
return true;}
function coerceArray(arg,copy){if(arg.buffer&&ArrayBuffer.isView(arg)&&arg.name==='Uint8Array'){if(copy){if(arg.slice){arg=arg.slice();}else{arg=Array.prototype.slice.call(arg);}}
return arg;}
if(Array.isArray(arg)){if(!checkInts(arg)){throw new Error('Array contains invalid value: '+arg);}
return new Uint8Array(arg);}
if(checkInt(arg.length)&&checkInts(arg)){return new Uint8Array(arg);}
throw new Error('unsupported array-like object');}
function createArray(length){return new Uint8Array(length);}
function copyArray(sourceArray,targetArray,targetStart,sourceStart,sourceEnd){if(sourceStart!=null||sourceEnd!=null){if(sourceArray.slice){sourceArray=sourceArray.slice(sourceStart,sourceEnd);}else{sourceArray=Array.prototype.slice.call(sourceArray,sourceStart,sourceEnd);}}
targetArray.set(sourceArray,targetStart);}
var convertUtf8=(function(){function toBytes(text){var result=[],i=0;text=encodeURI(text);while(i<text.length){var c=text.charCodeAt(i++);if(c===37){result.push(parseInt(text.substr(i,2),16))
i+=2;}else{result.push(c)}}
return coerceArray(result);}
function fromBytes(bytes){var result=[],i=0;while(i<bytes.length){var c=bytes[i];if(c<128){result.push(String.fromCharCode(c));i++;}else if(c>191&&c<224){result.push(String.fromCharCode(((c&0x1f)<<6)|(bytes[i+1]&0x3f)));i+=2;}else{result.push(String.fromCharCode(((c&0x0f)<<12)|((bytes[i+1]&0x3f)<<6)|(bytes[i+2]&0x3f)));i+=3;}}
return result.join('');}
return{toBytes:toBytes,fromBytes:fromBytes,}})();var convertHex=(function(){function toBytes(text){var result=[];for(var i=0;i<text.length;i+=2){result.push(parseInt(text.substr(i,2),16));}
return result;}
var Hex='0123456789abcdef';function fromBytes(bytes){var result=[];for(var i=0;i<bytes.length;i++){var v=bytes[i];result.push(Hex[(v&0xf0)>>4]+Hex[v&0x0f]);}
return result.join('');}
return{toBytes:toBytes,fromBytes:fromBytes,}})();var numberOfRounds={16:10,24:12,32:14}
var rcon=[0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80,0x1b,0x36,0x6c,0xd8,0xab,0x4d,0x9a,0x2f,0x5e,0xbc,0x63,0xc6,0x97,0x35,0x6a,0xd4,0xb3,0x7d,0xfa,0xef,0xc5,0x91];var S=[0x63,0x7c,0x77,0x7b,0xf2,0x6b,0x6f,0xc5,0x30,0x01,0x67,0x2b,0xfe,0xd7,0xab,0x76,0xca,0x82,0xc9,0x7d,0xfa,0x59,0x47,0xf0,0xad,0xd4,0xa2,0xaf,0x9c,0xa4,0x72,0xc0,0xb7,0xfd,0x93,0x26,0x36,0x3f,0xf7,0xcc,0x34,0xa5,0xe5,0xf1,0x71,0xd8,0x31,0x15,0x04,0xc7,0x23,0xc3,0x18,0x96,0x05,0x9a,0x07,0x12,0x80,0xe2,0xeb,0x27,0xb2,0x75,0x09,0x83,0x2c,0x1a,0x1b,0x6e,0x5a,0xa0,0x52,0x3b,0xd6,0xb3,0x29,0xe3,0x2f,0x84,0x53,0xd1,0x00,0xed,0x20,0xfc,0xb1,0x5b,0x6a,0xcb,0xbe,0x39,0x4a,0x4c,0x58,0xcf,0xd0,0xef,0xaa,0xfb,0x43,0x4d,0x33,0x85,0x45,0xf9,0x02,0x7f,0x50,0x3c,0x9f,0xa8,0x51,0xa3,0x40,0x8f,0x92,0x9d,0x38,0xf5,0xbc,0xb6,0xda,0x21,0x10,0xff,0xf3,0xd2,0xcd,0x0c,0x13,0xec,0x5f,0x97,0x44,0x17,0xc4,0xa7,0x7e,0x3d,0x64,0x5d,0x19,0x73,0x60,0x81,0x4f,0xdc,0x22,0x2a,0x90,0x88,0x46,0xee,0xb8,0x14,0xde,0x5e,0x0b,0xdb,0xe0,0x32,0x3a,0x0a,0x49,0x06,0x24,0x5c,0xc2,0xd3,0xac,0x62,0x91,0x95,0xe4,0x79,0xe7,0xc8,0x37,0x6d,0x8d,0xd5,0x4e,0xa9,0x6c,0x56,0xf4,0xea,0x65,0x7a,0xae,0x08,0xba,0x78,0x25,0x2e,0x1c,0xa6,0xb4,0xc6,0xe8,0xdd,0x74,0x1f,0x4b,0xbd,0x8b,0x8a,0x70,0x3e,0xb5,0x66,0x48,0x03,0xf6,0x0e,0x61,0x35,0x57,0xb9,0x86,0xc1,0x1d,0x9e,0xe1,0xf8,0x98,0x11,0x69,0xd9,0x8e,0x94,0x9b,0x1e,0x87,0xe9,0xce,0x55,0x28,0xdf,0x8c,0xa1,0x89,0x0d,0xbf,0xe6,0x42,0x68,0x41,0x99,0x2d,0x0f,0xb0,0x54,0xbb,0x16];var Si=[0x52,0x09,0x6a,0xd5,0x30,0x36,0xa5,0x38,0xbf,0x40,0xa3,0x9e,0x81,0xf3,0xd7,0xfb,0x7c,0xe3,0x39,0x82,0x9b,0x2f,0xff,0x87,0x34,0x8e,0x43,0x44,0xc4,0xde,0xe9,0xcb,0x54,0x7b,0x94,0x32,0xa6,0xc2,0x23,0x3d,0xee,0x4c,0x95,0x0b,0x42,0xfa,0xc3,0x4e,0x08,0x2e,0xa1,0x66,0x28,0xd9,0x24,0xb2,0x76,0x5b,0xa2,0x49,0x6d,0x8b,0xd1,0x25,0x72,0xf8,0xf6,0x64,0x86,0x68,0x98,0x16,0xd4,0xa4,0x5c,0xcc,0x5d,0x65,0xb6,0x92,0x6c,0x70,0x48,0x50,0xfd,0xed,0xb9,0xda,0x5e,0x15,0x46,0x57,0xa7,0x8d,0x9d,0x84,0x90,0xd8,0xab,0x00,0x8c,0xbc,0xd3,0x0a,0xf7,0xe4,0x58,0x05,0xb8,0xb3,0x45,0x06,0xd0,0x2c,0x1e,0x8f,0xca,0x3f,0x0f,0x02,0xc1,0xaf,0xbd,0x03,0x01,0x13,0x8a,0x6b,0x3a,0x91,0x11,0x41,0x4f,0x67,0xdc,0xea,0x97,0xf2,0xcf,0xce,0xf0,0xb4,0xe6,0x73,0x96,0xac,0x74,0x22,0xe7,0xad,0x35,0x85,0xe2,0xf9,0x37,0xe8,0x1c,0x75,0xdf,0x6e,0x47,0xf1,0x1a,0x71,0x1d,0x29,0xc5,0x89,0x6f,0xb7,0x62,0x0e,0xaa,0x18,0xbe,0x1b,0xfc,0x56,0x3e,0x4b,0xc6,0xd2,0x79,0x20,0x9a,0xdb,0xc0,0xfe,0x78,0xcd,0x5a,0xf4,0x1f,0xdd,0xa8,0x33,0x88,0x07,0xc7,0x31,0xb1,0x12,0x10,0x59,0x27,0x80,0xec,0x5f,0x60,0x51,0x7f,0xa9,0x19,0xb5,0x4a,0x0d,0x2d,0xe5,0x7a,0x9f,0x93,0xc9,0x9c,0xef,0xa0,0xe0,0x3b,0x4d,0xae,0x2a,0xf5,0xb0,0xc8,0xeb,0xbb,0x3c,0x83,0x53,0x99,0x61,0x17,0x2b,0x04,0x7e,0xba,0x77,0xd6,0x26,0xe1,0x69,0x14,0x63,0x55,0x21,0x0c,0x7d];var T1=[0xc66363a5,0xf87c7c84,0xee777799,0xf67b7b8d,0xfff2f20d,0xd66b6bbd,0xde6f6fb1,0x91c5c554,0x60303050,0x02010103,0xce6767a9,0x562b2b7d,0xe7fefe19,0xb5d7d762,0x4dababe6,0xec76769a,0x8fcaca45,0x1f82829d,0x89c9c940,0xfa7d7d87,0xeffafa15,0xb25959eb,0x8e4747c9,0xfbf0f00b,0x41adadec,0xb3d4d467,0x5fa2a2fd,0x45afafea,0x239c9cbf,0x53a4a4f7,0xe4727296,0x9bc0c05b,0x75b7b7c2,0xe1fdfd1c,0x3d9393ae,0x4c26266a,0x6c36365a,0x7e3f3f41,0xf5f7f702,0x83cccc4f,0x6834345c,0x51a5a5f4,0xd1e5e534,0xf9f1f108,0xe2717193,0xabd8d873,0x62313153,0x2a15153f,0x0804040c,0x95c7c752,0x46232365,0x9dc3c35e,0x30181828,0x379696a1,0x0a05050f,0x2f9a9ab5,0x0e070709,0x24121236,0x1b80809b,0xdfe2e23d,0xcdebeb26,0x4e272769,0x7fb2b2cd,0xea75759f,0x1209091b,0x1d83839e,0x582c2c74,0x341a1a2e,0x361b1b2d,0xdc6e6eb2,0xb45a5aee,0x5ba0a0fb,0xa45252f6,0x763b3b4d,0xb7d6d661,0x7db3b3ce,0x5229297b,0xdde3e33e,0x5e2f2f71,0x13848497,0xa65353f5,0xb9d1d168,0x00000000,0xc1eded2c,0x40202060,0xe3fcfc1f,0x79b1b1c8,0xb65b5bed,0xd46a6abe,0x8dcbcb46,0x67bebed9,0x7239394b,0x944a4ade,0x984c4cd4,0xb05858e8,0x85cfcf4a,0xbbd0d06b,0xc5efef2a,0x4faaaae5,0xedfbfb16,0x864343c5,0x9a4d4dd7,0x66333355,0x11858594,0x8a4545cf,0xe9f9f910,0x04020206,0xfe7f7f81,0xa05050f0,0x783c3c44,0x259f9fba,0x4ba8a8e3,0xa25151f3,0x5da3a3fe,0x804040c0,0x058f8f8a,0x3f9292ad,0x219d9dbc,0x70383848,0xf1f5f504,0x63bcbcdf,0x77b6b6c1,0xafdada75,0x42212163,0x20101030,0xe5ffff1a,0xfdf3f30e,0xbfd2d26d,0x81cdcd4c,0x180c0c14,0x26131335,0xc3ecec2f,0xbe5f5fe1,0x359797a2,0x884444cc,0x2e171739,0x93c4c457,0x55a7a7f2,0xfc7e7e82,0x7a3d3d47,0xc86464ac,0xba5d5de7,0x3219192b,0xe6737395,0xc06060a0,0x19818198,0x9e4f4fd1,0xa3dcdc7f,0x44222266,0x542a2a7e,0x3b9090ab,0x0b888883,0x8c4646ca,0xc7eeee29,0x6bb8b8d3,0x2814143c,0xa7dede79,0xbc5e5ee2,0x160b0b1d,0xaddbdb76,0xdbe0e03b,0x64323256,0x743a3a4e,0x140a0a1e,0x924949db,0x0c06060a,0x4824246c,0xb85c5ce4,0x9fc2c25d,0xbdd3d36e,0x43acacef,0xc46262a6,0x399191a8,0x319595a4,0xd3e4e437,0xf279798b,0xd5e7e732,0x8bc8c843,0x6e373759,0xda6d6db7,0x018d8d8c,0xb1d5d564,0x9c4e4ed2,0x49a9a9e0,0xd86c6cb4,0xac5656fa,0xf3f4f407,0xcfeaea25,0xca6565af,0xf47a7a8e,0x47aeaee9,0x10080818,0x6fbabad5,0xf0787888,0x4a25256f,0x5c2e2e72,0x381c1c24,0x57a6a6f1,0x73b4b4c7,0x97c6c651,0xcbe8e823,0xa1dddd7c,0xe874749c,0x3e1f1f21,0x964b4bdd,0x61bdbddc,0x0d8b8b86,0x0f8a8a85,0xe0707090,0x7c3e3e42,0x71b5b5c4,0xcc6666aa,0x904848d8,0x06030305,0xf7f6f601,0x1c0e0e12,0xc26161a3,0x6a35355f,0xae5757f9,0x69b9b9d0,0x17868691,0x99c1c158,0x3a1d1d27,0x279e9eb9,0xd9e1e138,0xebf8f813,0x2b9898b3,0x22111133,0xd26969bb,0xa9d9d970,0x078e8e89,0x339494a7,0x2d9b9bb6,0x3c1e1e22,0x15878792,0xc9e9e920,0x87cece49,0xaa5555ff,0x50282878,0xa5dfdf7a,0x038c8c8f,0x59a1a1f8,0x09898980,0x1a0d0d17,0x65bfbfda,0xd7e6e631,0x844242c6,0xd06868b8,0x824141c3,0x299999b0,0x5a2d2d77,0x1e0f0f11,0x7bb0b0cb,0xa85454fc,0x6dbbbbd6,0x2c16163a];var T2=[0xa5c66363,0x84f87c7c,0x99ee7777,0x8df67b7b,0x0dfff2f2,0xbdd66b6b,0xb1de6f6f,0x5491c5c5,0x50603030,0x03020101,0xa9ce6767,0x7d562b2b,0x19e7fefe,0x62b5d7d7,0xe64dabab,0x9aec7676,0x458fcaca,0x9d1f8282,0x4089c9c9,0x87fa7d7d,0x15effafa,0xebb25959,0xc98e4747,0x0bfbf0f0,0xec41adad,0x67b3d4d4,0xfd5fa2a2,0xea45afaf,0xbf239c9c,0xf753a4a4,0x96e47272,0x5b9bc0c0,0xc275b7b7,0x1ce1fdfd,0xae3d9393,0x6a4c2626,0x5a6c3636,0x417e3f3f,0x02f5f7f7,0x4f83cccc,0x5c683434,0xf451a5a5,0x34d1e5e5,0x08f9f1f1,0x93e27171,0x73abd8d8,0x53623131,0x3f2a1515,0x0c080404,0x5295c7c7,0x65462323,0x5e9dc3c3,0x28301818,0xa1379696,0x0f0a0505,0xb52f9a9a,0x090e0707,0x36241212,0x9b1b8080,0x3ddfe2e2,0x26cdebeb,0x694e2727,0xcd7fb2b2,0x9fea7575,0x1b120909,0x9e1d8383,0x74582c2c,0x2e341a1a,0x2d361b1b,0xb2dc6e6e,0xeeb45a5a,0xfb5ba0a0,0xf6a45252,0x4d763b3b,0x61b7d6d6,0xce7db3b3,0x7b522929,0x3edde3e3,0x715e2f2f,0x97138484,0xf5a65353,0x68b9d1d1,0x00000000,0x2cc1eded,0x60402020,0x1fe3fcfc,0xc879b1b1,0xedb65b5b,0xbed46a6a,0x468dcbcb,0xd967bebe,0x4b723939,0xde944a4a,0xd4984c4c,0xe8b05858,0x4a85cfcf,0x6bbbd0d0,0x2ac5efef,0xe54faaaa,0x16edfbfb,0xc5864343,0xd79a4d4d,0x55663333,0x94118585,0xcf8a4545,0x10e9f9f9,0x06040202,0x81fe7f7f,0xf0a05050,0x44783c3c,0xba259f9f,0xe34ba8a8,0xf3a25151,0xfe5da3a3,0xc0804040,0x8a058f8f,0xad3f9292,0xbc219d9d,0x48703838,0x04f1f5f5,0xdf63bcbc,0xc177b6b6,0x75afdada,0x63422121,0x30201010,0x1ae5ffff,0x0efdf3f3,0x6dbfd2d2,0x4c81cdcd,0x14180c0c,0x35261313,0x2fc3ecec,0xe1be5f5f,0xa2359797,0xcc884444,0x392e1717,0x5793c4c4,0xf255a7a7,0x82fc7e7e,0x477a3d3d,0xacc86464,0xe7ba5d5d,0x2b321919,0x95e67373,0xa0c06060,0x98198181,0xd19e4f4f,0x7fa3dcdc,0x66442222,0x7e542a2a,0xab3b9090,0x830b8888,0xca8c4646,0x29c7eeee,0xd36bb8b8,0x3c281414,0x79a7dede,0xe2bc5e5e,0x1d160b0b,0x76addbdb,0x3bdbe0e0,0x56643232,0x4e743a3a,0x1e140a0a,0xdb924949,0x0a0c0606,0x6c482424,0xe4b85c5c,0x5d9fc2c2,0x6ebdd3d3,0xef43acac,0xa6c46262,0xa8399191,0xa4319595,0x37d3e4e4,0x8bf27979,0x32d5e7e7,0x438bc8c8,0x596e3737,0xb7da6d6d,0x8c018d8d,0x64b1d5d5,0xd29c4e4e,0xe049a9a9,0xb4d86c6c,0xfaac5656,0x07f3f4f4,0x25cfeaea,0xafca6565,0x8ef47a7a,0xe947aeae,0x18100808,0xd56fbaba,0x88f07878,0x6f4a2525,0x725c2e2e,0x24381c1c,0xf157a6a6,0xc773b4b4,0x5197c6c6,0x23cbe8e8,0x7ca1dddd,0x9ce87474,0x213e1f1f,0xdd964b4b,0xdc61bdbd,0x860d8b8b,0x850f8a8a,0x90e07070,0x427c3e3e,0xc471b5b5,0xaacc6666,0xd8904848,0x05060303,0x01f7f6f6,0x121c0e0e,0xa3c26161,0x5f6a3535,0xf9ae5757,0xd069b9b9,0x91178686,0x5899c1c1,0x273a1d1d,0xb9279e9e,0x38d9e1e1,0x13ebf8f8,0xb32b9898,0x33221111,0xbbd26969,0x70a9d9d9,0x89078e8e,0xa7339494,0xb62d9b9b,0x223c1e1e,0x92158787,0x20c9e9e9,0x4987cece,0xffaa5555,0x78502828,0x7aa5dfdf,0x8f038c8c,0xf859a1a1,0x80098989,0x171a0d0d,0xda65bfbf,0x31d7e6e6,0xc6844242,0xb8d06868,0xc3824141,0xb0299999,0x775a2d2d,0x111e0f0f,0xcb7bb0b0,0xfca85454,0xd66dbbbb,0x3a2c1616];var T3=[0x63a5c663,0x7c84f87c,0x7799ee77,0x7b8df67b,0xf20dfff2,0x6bbdd66b,0x6fb1de6f,0xc55491c5,0x30506030,0x01030201,0x67a9ce67,0x2b7d562b,0xfe19e7fe,0xd762b5d7,0xabe64dab,0x769aec76,0xca458fca,0x829d1f82,0xc94089c9,0x7d87fa7d,0xfa15effa,0x59ebb259,0x47c98e47,0xf00bfbf0,0xadec41ad,0xd467b3d4,0xa2fd5fa2,0xafea45af,0x9cbf239c,0xa4f753a4,0x7296e472,0xc05b9bc0,0xb7c275b7,0xfd1ce1fd,0x93ae3d93,0x266a4c26,0x365a6c36,0x3f417e3f,0xf702f5f7,0xcc4f83cc,0x345c6834,0xa5f451a5,0xe534d1e5,0xf108f9f1,0x7193e271,0xd873abd8,0x31536231,0x153f2a15,0x040c0804,0xc75295c7,0x23654623,0xc35e9dc3,0x18283018,0x96a13796,0x050f0a05,0x9ab52f9a,0x07090e07,0x12362412,0x809b1b80,0xe23ddfe2,0xeb26cdeb,0x27694e27,0xb2cd7fb2,0x759fea75,0x091b1209,0x839e1d83,0x2c74582c,0x1a2e341a,0x1b2d361b,0x6eb2dc6e,0x5aeeb45a,0xa0fb5ba0,0x52f6a452,0x3b4d763b,0xd661b7d6,0xb3ce7db3,0x297b5229,0xe33edde3,0x2f715e2f,0x84971384,0x53f5a653,0xd168b9d1,0x00000000,0xed2cc1ed,0x20604020,0xfc1fe3fc,0xb1c879b1,0x5bedb65b,0x6abed46a,0xcb468dcb,0xbed967be,0x394b7239,0x4ade944a,0x4cd4984c,0x58e8b058,0xcf4a85cf,0xd06bbbd0,0xef2ac5ef,0xaae54faa,0xfb16edfb,0x43c58643,0x4dd79a4d,0x33556633,0x85941185,0x45cf8a45,0xf910e9f9,0x02060402,0x7f81fe7f,0x50f0a050,0x3c44783c,0x9fba259f,0xa8e34ba8,0x51f3a251,0xa3fe5da3,0x40c08040,0x8f8a058f,0x92ad3f92,0x9dbc219d,0x38487038,0xf504f1f5,0xbcdf63bc,0xb6c177b6,0xda75afda,0x21634221,0x10302010,0xff1ae5ff,0xf30efdf3,0xd26dbfd2,0xcd4c81cd,0x0c14180c,0x13352613,0xec2fc3ec,0x5fe1be5f,0x97a23597,0x44cc8844,0x17392e17,0xc45793c4,0xa7f255a7,0x7e82fc7e,0x3d477a3d,0x64acc864,0x5de7ba5d,0x192b3219,0x7395e673,0x60a0c060,0x81981981,0x4fd19e4f,0xdc7fa3dc,0x22664422,0x2a7e542a,0x90ab3b90,0x88830b88,0x46ca8c46,0xee29c7ee,0xb8d36bb8,0x143c2814,0xde79a7de,0x5ee2bc5e,0x0b1d160b,0xdb76addb,0xe03bdbe0,0x32566432,0x3a4e743a,0x0a1e140a,0x49db9249,0x060a0c06,0x246c4824,0x5ce4b85c,0xc25d9fc2,0xd36ebdd3,0xacef43ac,0x62a6c462,0x91a83991,0x95a43195,0xe437d3e4,0x798bf279,0xe732d5e7,0xc8438bc8,0x37596e37,0x6db7da6d,0x8d8c018d,0xd564b1d5,0x4ed29c4e,0xa9e049a9,0x6cb4d86c,0x56faac56,0xf407f3f4,0xea25cfea,0x65afca65,0x7a8ef47a,0xaee947ae,0x08181008,0xbad56fba,0x7888f078,0x256f4a25,0x2e725c2e,0x1c24381c,0xa6f157a6,0xb4c773b4,0xc65197c6,0xe823cbe8,0xdd7ca1dd,0x749ce874,0x1f213e1f,0x4bdd964b,0xbddc61bd,0x8b860d8b,0x8a850f8a,0x7090e070,0x3e427c3e,0xb5c471b5,0x66aacc66,0x48d89048,0x03050603,0xf601f7f6,0x0e121c0e,0x61a3c261,0x355f6a35,0x57f9ae57,0xb9d069b9,0x86911786,0xc15899c1,0x1d273a1d,0x9eb9279e,0xe138d9e1,0xf813ebf8,0x98b32b98,0x11332211,0x69bbd269,0xd970a9d9,0x8e89078e,0x94a73394,0x9bb62d9b,0x1e223c1e,0x87921587,0xe920c9e9,0xce4987ce,0x55ffaa55,0x28785028,0xdf7aa5df,0x8c8f038c,0xa1f859a1,0x89800989,0x0d171a0d,0xbfda65bf,0xe631d7e6,0x42c68442,0x68b8d068,0x41c38241,0x99b02999,0x2d775a2d,0x0f111e0f,0xb0cb7bb0,0x54fca854,0xbbd66dbb,0x163a2c16];var T4=[0x6363a5c6,0x7c7c84f8,0x777799ee,0x7b7b8df6,0xf2f20dff,0x6b6bbdd6,0x6f6fb1de,0xc5c55491,0x30305060,0x01010302,0x6767a9ce,0x2b2b7d56,0xfefe19e7,0xd7d762b5,0xababe64d,0x76769aec,0xcaca458f,0x82829d1f,0xc9c94089,0x7d7d87fa,0xfafa15ef,0x5959ebb2,0x4747c98e,0xf0f00bfb,0xadadec41,0xd4d467b3,0xa2a2fd5f,0xafafea45,0x9c9cbf23,0xa4a4f753,0x727296e4,0xc0c05b9b,0xb7b7c275,0xfdfd1ce1,0x9393ae3d,0x26266a4c,0x36365a6c,0x3f3f417e,0xf7f702f5,0xcccc4f83,0x34345c68,0xa5a5f451,0xe5e534d1,0xf1f108f9,0x717193e2,0xd8d873ab,0x31315362,0x15153f2a,0x04040c08,0xc7c75295,0x23236546,0xc3c35e9d,0x18182830,0x9696a137,0x05050f0a,0x9a9ab52f,0x0707090e,0x12123624,0x80809b1b,0xe2e23ddf,0xebeb26cd,0x2727694e,0xb2b2cd7f,0x75759fea,0x09091b12,0x83839e1d,0x2c2c7458,0x1a1a2e34,0x1b1b2d36,0x6e6eb2dc,0x5a5aeeb4,0xa0a0fb5b,0x5252f6a4,0x3b3b4d76,0xd6d661b7,0xb3b3ce7d,0x29297b52,0xe3e33edd,0x2f2f715e,0x84849713,0x5353f5a6,0xd1d168b9,0x00000000,0xeded2cc1,0x20206040,0xfcfc1fe3,0xb1b1c879,0x5b5bedb6,0x6a6abed4,0xcbcb468d,0xbebed967,0x39394b72,0x4a4ade94,0x4c4cd498,0x5858e8b0,0xcfcf4a85,0xd0d06bbb,0xefef2ac5,0xaaaae54f,0xfbfb16ed,0x4343c586,0x4d4dd79a,0x33335566,0x85859411,0x4545cf8a,0xf9f910e9,0x02020604,0x7f7f81fe,0x5050f0a0,0x3c3c4478,0x9f9fba25,0xa8a8e34b,0x5151f3a2,0xa3a3fe5d,0x4040c080,0x8f8f8a05,0x9292ad3f,0x9d9dbc21,0x38384870,0xf5f504f1,0xbcbcdf63,0xb6b6c177,0xdada75af,0x21216342,0x10103020,0xffff1ae5,0xf3f30efd,0xd2d26dbf,0xcdcd4c81,0x0c0c1418,0x13133526,0xecec2fc3,0x5f5fe1be,0x9797a235,0x4444cc88,0x1717392e,0xc4c45793,0xa7a7f255,0x7e7e82fc,0x3d3d477a,0x6464acc8,0x5d5de7ba,0x19192b32,0x737395e6,0x6060a0c0,0x81819819,0x4f4fd19e,0xdcdc7fa3,0x22226644,0x2a2a7e54,0x9090ab3b,0x8888830b,0x4646ca8c,0xeeee29c7,0xb8b8d36b,0x14143c28,0xdede79a7,0x5e5ee2bc,0x0b0b1d16,0xdbdb76ad,0xe0e03bdb,0x32325664,0x3a3a4e74,0x0a0a1e14,0x4949db92,0x06060a0c,0x24246c48,0x5c5ce4b8,0xc2c25d9f,0xd3d36ebd,0xacacef43,0x6262a6c4,0x9191a839,0x9595a431,0xe4e437d3,0x79798bf2,0xe7e732d5,0xc8c8438b,0x3737596e,0x6d6db7da,0x8d8d8c01,0xd5d564b1,0x4e4ed29c,0xa9a9e049,0x6c6cb4d8,0x5656faac,0xf4f407f3,0xeaea25cf,0x6565afca,0x7a7a8ef4,0xaeaee947,0x08081810,0xbabad56f,0x787888f0,0x25256f4a,0x2e2e725c,0x1c1c2438,0xa6a6f157,0xb4b4c773,0xc6c65197,0xe8e823cb,0xdddd7ca1,0x74749ce8,0x1f1f213e,0x4b4bdd96,0xbdbddc61,0x8b8b860d,0x8a8a850f,0x707090e0,0x3e3e427c,0xb5b5c471,0x6666aacc,0x4848d890,0x03030506,0xf6f601f7,0x0e0e121c,0x6161a3c2,0x35355f6a,0x5757f9ae,0xb9b9d069,0x86869117,0xc1c15899,0x1d1d273a,0x9e9eb927,0xe1e138d9,0xf8f813eb,0x9898b32b,0x11113322,0x6969bbd2,0xd9d970a9,0x8e8e8907,0x9494a733,0x9b9bb62d,0x1e1e223c,0x87879215,0xe9e920c9,0xcece4987,0x5555ffaa,0x28287850,0xdfdf7aa5,0x8c8c8f03,0xa1a1f859,0x89898009,0x0d0d171a,0xbfbfda65,0xe6e631d7,0x4242c684,0x6868b8d0,0x4141c382,0x9999b029,0x2d2d775a,0x0f0f111e,0xb0b0cb7b,0x5454fca8,0xbbbbd66d,0x16163a2c];var T5=[0x51f4a750,0x7e416553,0x1a17a4c3,0x3a275e96,0x3bab6bcb,0x1f9d45f1,0xacfa58ab,0x4be30393,0x2030fa55,0xad766df6,0x88cc7691,0xf5024c25,0x4fe5d7fc,0xc52acbd7,0x26354480,0xb562a38f,0xdeb15a49,0x25ba1b67,0x45ea0e98,0x5dfec0e1,0xc32f7502,0x814cf012,0x8d4697a3,0x6bd3f9c6,0x038f5fe7,0x15929c95,0xbf6d7aeb,0x955259da,0xd4be832d,0x587421d3,0x49e06929,0x8ec9c844,0x75c2896a,0xf48e7978,0x99583e6b,0x27b971dd,0xbee14fb6,0xf088ad17,0xc920ac66,0x7dce3ab4,0x63df4a18,0xe51a3182,0x97513360,0x62537f45,0xb16477e0,0xbb6bae84,0xfe81a01c,0xf9082b94,0x70486858,0x8f45fd19,0x94de6c87,0x527bf8b7,0xab73d323,0x724b02e2,0xe31f8f57,0x6655ab2a,0xb2eb2807,0x2fb5c203,0x86c57b9a,0xd33708a5,0x302887f2,0x23bfa5b2,0x02036aba,0xed16825c,0x8acf1c2b,0xa779b492,0xf307f2f0,0x4e69e2a1,0x65daf4cd,0x0605bed5,0xd134621f,0xc4a6fe8a,0x342e539d,0xa2f355a0,0x058ae132,0xa4f6eb75,0x0b83ec39,0x4060efaa,0x5e719f06,0xbd6e1051,0x3e218af9,0x96dd063d,0xdd3e05ae,0x4de6bd46,0x91548db5,0x71c45d05,0x0406d46f,0x605015ff,0x1998fb24,0xd6bde997,0x894043cc,0x67d99e77,0xb0e842bd,0x07898b88,0xe7195b38,0x79c8eedb,0xa17c0a47,0x7c420fe9,0xf8841ec9,0x00000000,0x09808683,0x322bed48,0x1e1170ac,0x6c5a724e,0xfd0efffb,0x0f853856,0x3daed51e,0x362d3927,0x0a0fd964,0x685ca621,0x9b5b54d1,0x24362e3a,0x0c0a67b1,0x9357e70f,0xb4ee96d2,0x1b9b919e,0x80c0c54f,0x61dc20a2,0x5a774b69,0x1c121a16,0xe293ba0a,0xc0a02ae5,0x3c22e043,0x121b171d,0x0e090d0b,0xf28bc7ad,0x2db6a8b9,0x141ea9c8,0x57f11985,0xaf75074c,0xee99ddbb,0xa37f60fd,0xf701269f,0x5c72f5bc,0x44663bc5,0x5bfb7e34,0x8b432976,0xcb23c6dc,0xb6edfc68,0xb8e4f163,0xd731dcca,0x42638510,0x13972240,0x84c61120,0x854a247d,0xd2bb3df8,0xaef93211,0xc729a16d,0x1d9e2f4b,0xdcb230f3,0x0d8652ec,0x77c1e3d0,0x2bb3166c,0xa970b999,0x119448fa,0x47e96422,0xa8fc8cc4,0xa0f03f1a,0x567d2cd8,0x223390ef,0x87494ec7,0xd938d1c1,0x8ccaa2fe,0x98d40b36,0xa6f581cf,0xa57ade28,0xdab78e26,0x3fadbfa4,0x2c3a9de4,0x5078920d,0x6a5fcc9b,0x547e4662,0xf68d13c2,0x90d8b8e8,0x2e39f75e,0x82c3aff5,0x9f5d80be,0x69d0937c,0x6fd52da9,0xcf2512b3,0xc8ac993b,0x10187da7,0xe89c636e,0xdb3bbb7b,0xcd267809,0x6e5918f4,0xec9ab701,0x834f9aa8,0xe6956e65,0xaaffe67e,0x21bccf08,0xef15e8e6,0xbae79bd9,0x4a6f36ce,0xea9f09d4,0x29b07cd6,0x31a4b2af,0x2a3f2331,0xc6a59430,0x35a266c0,0x744ebc37,0xfc82caa6,0xe090d0b0,0x33a7d815,0xf104984a,0x41ecdaf7,0x7fcd500e,0x1791f62f,0x764dd68d,0x43efb04d,0xccaa4d54,0xe49604df,0x9ed1b5e3,0x4c6a881b,0xc12c1fb8,0x4665517f,0x9d5eea04,0x018c355d,0xfa877473,0xfb0b412e,0xb3671d5a,0x92dbd252,0xe9105633,0x6dd64713,0x9ad7618c,0x37a10c7a,0x59f8148e,0xeb133c89,0xcea927ee,0xb761c935,0xe11ce5ed,0x7a47b13c,0x9cd2df59,0x55f2733f,0x1814ce79,0x73c737bf,0x53f7cdea,0x5ffdaa5b,0xdf3d6f14,0x7844db86,0xcaaff381,0xb968c43e,0x3824342c,0xc2a3405f,0x161dc372,0xbce2250c,0x283c498b,0xff0d9541,0x39a80171,0x080cb3de,0xd8b4e49c,0x6456c190,0x7bcb8461,0xd532b670,0x486c5c74,0xd0b85742];var T6=[0x5051f4a7,0x537e4165,0xc31a17a4,0x963a275e,0xcb3bab6b,0xf11f9d45,0xabacfa58,0x934be303,0x552030fa,0xf6ad766d,0x9188cc76,0x25f5024c,0xfc4fe5d7,0xd7c52acb,0x80263544,0x8fb562a3,0x49deb15a,0x6725ba1b,0x9845ea0e,0xe15dfec0,0x02c32f75,0x12814cf0,0xa38d4697,0xc66bd3f9,0xe7038f5f,0x9515929c,0xebbf6d7a,0xda955259,0x2dd4be83,0xd3587421,0x2949e069,0x448ec9c8,0x6a75c289,0x78f48e79,0x6b99583e,0xdd27b971,0xb6bee14f,0x17f088ad,0x66c920ac,0xb47dce3a,0x1863df4a,0x82e51a31,0x60975133,0x4562537f,0xe0b16477,0x84bb6bae,0x1cfe81a0,0x94f9082b,0x58704868,0x198f45fd,0x8794de6c,0xb7527bf8,0x23ab73d3,0xe2724b02,0x57e31f8f,0x2a6655ab,0x07b2eb28,0x032fb5c2,0x9a86c57b,0xa5d33708,0xf2302887,0xb223bfa5,0xba02036a,0x5ced1682,0x2b8acf1c,0x92a779b4,0xf0f307f2,0xa14e69e2,0xcd65daf4,0xd50605be,0x1fd13462,0x8ac4a6fe,0x9d342e53,0xa0a2f355,0x32058ae1,0x75a4f6eb,0x390b83ec,0xaa4060ef,0x065e719f,0x51bd6e10,0xf93e218a,0x3d96dd06,0xaedd3e05,0x464de6bd,0xb591548d,0x0571c45d,0x6f0406d4,0xff605015,0x241998fb,0x97d6bde9,0xcc894043,0x7767d99e,0xbdb0e842,0x8807898b,0x38e7195b,0xdb79c8ee,0x47a17c0a,0xe97c420f,0xc9f8841e,0x00000000,0x83098086,0x48322bed,0xac1e1170,0x4e6c5a72,0xfbfd0eff,0x560f8538,0x1e3daed5,0x27362d39,0x640a0fd9,0x21685ca6,0xd19b5b54,0x3a24362e,0xb10c0a67,0x0f9357e7,0xd2b4ee96,0x9e1b9b91,0x4f80c0c5,0xa261dc20,0x695a774b,0x161c121a,0x0ae293ba,0xe5c0a02a,0x433c22e0,0x1d121b17,0x0b0e090d,0xadf28bc7,0xb92db6a8,0xc8141ea9,0x8557f119,0x4caf7507,0xbbee99dd,0xfda37f60,0x9ff70126,0xbc5c72f5,0xc544663b,0x345bfb7e,0x768b4329,0xdccb23c6,0x68b6edfc,0x63b8e4f1,0xcad731dc,0x10426385,0x40139722,0x2084c611,0x7d854a24,0xf8d2bb3d,0x11aef932,0x6dc729a1,0x4b1d9e2f,0xf3dcb230,0xec0d8652,0xd077c1e3,0x6c2bb316,0x99a970b9,0xfa119448,0x2247e964,0xc4a8fc8c,0x1aa0f03f,0xd8567d2c,0xef223390,0xc787494e,0xc1d938d1,0xfe8ccaa2,0x3698d40b,0xcfa6f581,0x28a57ade,0x26dab78e,0xa43fadbf,0xe42c3a9d,0x0d507892,0x9b6a5fcc,0x62547e46,0xc2f68d13,0xe890d8b8,0x5e2e39f7,0xf582c3af,0xbe9f5d80,0x7c69d093,0xa96fd52d,0xb3cf2512,0x3bc8ac99,0xa710187d,0x6ee89c63,0x7bdb3bbb,0x09cd2678,0xf46e5918,0x01ec9ab7,0xa8834f9a,0x65e6956e,0x7eaaffe6,0x0821bccf,0xe6ef15e8,0xd9bae79b,0xce4a6f36,0xd4ea9f09,0xd629b07c,0xaf31a4b2,0x312a3f23,0x30c6a594,0xc035a266,0x37744ebc,0xa6fc82ca,0xb0e090d0,0x1533a7d8,0x4af10498,0xf741ecda,0x0e7fcd50,0x2f1791f6,0x8d764dd6,0x4d43efb0,0x54ccaa4d,0xdfe49604,0xe39ed1b5,0x1b4c6a88,0xb8c12c1f,0x7f466551,0x049d5eea,0x5d018c35,0x73fa8774,0x2efb0b41,0x5ab3671d,0x5292dbd2,0x33e91056,0x136dd647,0x8c9ad761,0x7a37a10c,0x8e59f814,0x89eb133c,0xeecea927,0x35b761c9,0xede11ce5,0x3c7a47b1,0x599cd2df,0x3f55f273,0x791814ce,0xbf73c737,0xea53f7cd,0x5b5ffdaa,0x14df3d6f,0x867844db,0x81caaff3,0x3eb968c4,0x2c382434,0x5fc2a340,0x72161dc3,0x0cbce225,0x8b283c49,0x41ff0d95,0x7139a801,0xde080cb3,0x9cd8b4e4,0x906456c1,0x617bcb84,0x70d532b6,0x74486c5c,0x42d0b857];var T7=[0xa75051f4,0x65537e41,0xa4c31a17,0x5e963a27,0x6bcb3bab,0x45f11f9d,0x58abacfa,0x03934be3,0xfa552030,0x6df6ad76,0x769188cc,0x4c25f502,0xd7fc4fe5,0xcbd7c52a,0x44802635,0xa38fb562,0x5a49deb1,0x1b6725ba,0x0e9845ea,0xc0e15dfe,0x7502c32f,0xf012814c,0x97a38d46,0xf9c66bd3,0x5fe7038f,0x9c951592,0x7aebbf6d,0x59da9552,0x832dd4be,0x21d35874,0x692949e0,0xc8448ec9,0x896a75c2,0x7978f48e,0x3e6b9958,0x71dd27b9,0x4fb6bee1,0xad17f088,0xac66c920,0x3ab47dce,0x4a1863df,0x3182e51a,0x33609751,0x7f456253,0x77e0b164,0xae84bb6b,0xa01cfe81,0x2b94f908,0x68587048,0xfd198f45,0x6c8794de,0xf8b7527b,0xd323ab73,0x02e2724b,0x8f57e31f,0xab2a6655,0x2807b2eb,0xc2032fb5,0x7b9a86c5,0x08a5d337,0x87f23028,0xa5b223bf,0x6aba0203,0x825ced16,0x1c2b8acf,0xb492a779,0xf2f0f307,0xe2a14e69,0xf4cd65da,0xbed50605,0x621fd134,0xfe8ac4a6,0x539d342e,0x55a0a2f3,0xe132058a,0xeb75a4f6,0xec390b83,0xefaa4060,0x9f065e71,0x1051bd6e,0x8af93e21,0x063d96dd,0x05aedd3e,0xbd464de6,0x8db59154,0x5d0571c4,0xd46f0406,0x15ff6050,0xfb241998,0xe997d6bd,0x43cc8940,0x9e7767d9,0x42bdb0e8,0x8b880789,0x5b38e719,0xeedb79c8,0x0a47a17c,0x0fe97c42,0x1ec9f884,0x00000000,0x86830980,0xed48322b,0x70ac1e11,0x724e6c5a,0xfffbfd0e,0x38560f85,0xd51e3dae,0x3927362d,0xd9640a0f,0xa621685c,0x54d19b5b,0x2e3a2436,0x67b10c0a,0xe70f9357,0x96d2b4ee,0x919e1b9b,0xc54f80c0,0x20a261dc,0x4b695a77,0x1a161c12,0xba0ae293,0x2ae5c0a0,0xe0433c22,0x171d121b,0x0d0b0e09,0xc7adf28b,0xa8b92db6,0xa9c8141e,0x198557f1,0x074caf75,0xddbbee99,0x60fda37f,0x269ff701,0xf5bc5c72,0x3bc54466,0x7e345bfb,0x29768b43,0xc6dccb23,0xfc68b6ed,0xf163b8e4,0xdccad731,0x85104263,0x22401397,0x112084c6,0x247d854a,0x3df8d2bb,0x3211aef9,0xa16dc729,0x2f4b1d9e,0x30f3dcb2,0x52ec0d86,0xe3d077c1,0x166c2bb3,0xb999a970,0x48fa1194,0x642247e9,0x8cc4a8fc,0x3f1aa0f0,0x2cd8567d,0x90ef2233,0x4ec78749,0xd1c1d938,0xa2fe8cca,0x0b3698d4,0x81cfa6f5,0xde28a57a,0x8e26dab7,0xbfa43fad,0x9de42c3a,0x920d5078,0xcc9b6a5f,0x4662547e,0x13c2f68d,0xb8e890d8,0xf75e2e39,0xaff582c3,0x80be9f5d,0x937c69d0,0x2da96fd5,0x12b3cf25,0x993bc8ac,0x7da71018,0x636ee89c,0xbb7bdb3b,0x7809cd26,0x18f46e59,0xb701ec9a,0x9aa8834f,0x6e65e695,0xe67eaaff,0xcf0821bc,0xe8e6ef15,0x9bd9bae7,0x36ce4a6f,0x09d4ea9f,0x7cd629b0,0xb2af31a4,0x23312a3f,0x9430c6a5,0x66c035a2,0xbc37744e,0xcaa6fc82,0xd0b0e090,0xd81533a7,0x984af104,0xdaf741ec,0x500e7fcd,0xf62f1791,0xd68d764d,0xb04d43ef,0x4d54ccaa,0x04dfe496,0xb5e39ed1,0x881b4c6a,0x1fb8c12c,0x517f4665,0xea049d5e,0x355d018c,0x7473fa87,0x412efb0b,0x1d5ab367,0xd25292db,0x5633e910,0x47136dd6,0x618c9ad7,0x0c7a37a1,0x148e59f8,0x3c89eb13,0x27eecea9,0xc935b761,0xe5ede11c,0xb13c7a47,0xdf599cd2,0x733f55f2,0xce791814,0x37bf73c7,0xcdea53f7,0xaa5b5ffd,0x6f14df3d,0xdb867844,0xf381caaf,0xc43eb968,0x342c3824,0x405fc2a3,0xc372161d,0x250cbce2,0x498b283c,0x9541ff0d,0x017139a8,0xb3de080c,0xe49cd8b4,0xc1906456,0x84617bcb,0xb670d532,0x5c74486c,0x5742d0b8];var T8=[0xf4a75051,0x4165537e,0x17a4c31a,0x275e963a,0xab6bcb3b,0x9d45f11f,0xfa58abac,0xe303934b,0x30fa5520,0x766df6ad,0xcc769188,0x024c25f5,0xe5d7fc4f,0x2acbd7c5,0x35448026,0x62a38fb5,0xb15a49de,0xba1b6725,0xea0e9845,0xfec0e15d,0x2f7502c3,0x4cf01281,0x4697a38d,0xd3f9c66b,0x8f5fe703,0x929c9515,0x6d7aebbf,0x5259da95,0xbe832dd4,0x7421d358,0xe0692949,0xc9c8448e,0xc2896a75,0x8e7978f4,0x583e6b99,0xb971dd27,0xe14fb6be,0x88ad17f0,0x20ac66c9,0xce3ab47d,0xdf4a1863,0x1a3182e5,0x51336097,0x537f4562,0x6477e0b1,0x6bae84bb,0x81a01cfe,0x082b94f9,0x48685870,0x45fd198f,0xde6c8794,0x7bf8b752,0x73d323ab,0x4b02e272,0x1f8f57e3,0x55ab2a66,0xeb2807b2,0xb5c2032f,0xc57b9a86,0x3708a5d3,0x2887f230,0xbfa5b223,0x036aba02,0x16825ced,0xcf1c2b8a,0x79b492a7,0x07f2f0f3,0x69e2a14e,0xdaf4cd65,0x05bed506,0x34621fd1,0xa6fe8ac4,0x2e539d34,0xf355a0a2,0x8ae13205,0xf6eb75a4,0x83ec390b,0x60efaa40,0x719f065e,0x6e1051bd,0x218af93e,0xdd063d96,0x3e05aedd,0xe6bd464d,0x548db591,0xc45d0571,0x06d46f04,0x5015ff60,0x98fb2419,0xbde997d6,0x4043cc89,0xd99e7767,0xe842bdb0,0x898b8807,0x195b38e7,0xc8eedb79,0x7c0a47a1,0x420fe97c,0x841ec9f8,0x00000000,0x80868309,0x2bed4832,0x1170ac1e,0x5a724e6c,0x0efffbfd,0x8538560f,0xaed51e3d,0x2d392736,0x0fd9640a,0x5ca62168,0x5b54d19b,0x362e3a24,0x0a67b10c,0x57e70f93,0xee96d2b4,0x9b919e1b,0xc0c54f80,0xdc20a261,0x774b695a,0x121a161c,0x93ba0ae2,0xa02ae5c0,0x22e0433c,0x1b171d12,0x090d0b0e,0x8bc7adf2,0xb6a8b92d,0x1ea9c814,0xf1198557,0x75074caf,0x99ddbbee,0x7f60fda3,0x01269ff7,0x72f5bc5c,0x663bc544,0xfb7e345b,0x4329768b,0x23c6dccb,0xedfc68b6,0xe4f163b8,0x31dccad7,0x63851042,0x97224013,0xc6112084,0x4a247d85,0xbb3df8d2,0xf93211ae,0x29a16dc7,0x9e2f4b1d,0xb230f3dc,0x8652ec0d,0xc1e3d077,0xb3166c2b,0x70b999a9,0x9448fa11,0xe9642247,0xfc8cc4a8,0xf03f1aa0,0x7d2cd856,0x3390ef22,0x494ec787,0x38d1c1d9,0xcaa2fe8c,0xd40b3698,0xf581cfa6,0x7ade28a5,0xb78e26da,0xadbfa43f,0x3a9de42c,0x78920d50,0x5fcc9b6a,0x7e466254,0x8d13c2f6,0xd8b8e890,0x39f75e2e,0xc3aff582,0x5d80be9f,0xd0937c69,0xd52da96f,0x2512b3cf,0xac993bc8,0x187da710,0x9c636ee8,0x3bbb7bdb,0x267809cd,0x5918f46e,0x9ab701ec,0x4f9aa883,0x956e65e6,0xffe67eaa,0xbccf0821,0x15e8e6ef,0xe79bd9ba,0x6f36ce4a,0x9f09d4ea,0xb07cd629,0xa4b2af31,0x3f23312a,0xa59430c6,0xa266c035,0x4ebc3774,0x82caa6fc,0x90d0b0e0,0xa7d81533,0x04984af1,0xecdaf741,0xcd500e7f,0x91f62f17,0x4dd68d76,0xefb04d43,0xaa4d54cc,0x9604dfe4,0xd1b5e39e,0x6a881b4c,0x2c1fb8c1,0x65517f46,0x5eea049d,0x8c355d01,0x877473fa,0x0b412efb,0x671d5ab3,0xdbd25292,0x105633e9,0xd647136d,0xd7618c9a,0xa10c7a37,0xf8148e59,0x133c89eb,0xa927eece,0x61c935b7,0x1ce5ede1,0x47b13c7a,0xd2df599c,0xf2733f55,0x14ce7918,0xc737bf73,0xf7cdea53,0xfdaa5b5f,0x3d6f14df,0x44db8678,0xaff381ca,0x68c43eb9,0x24342c38,0xa3405fc2,0x1dc37216,0xe2250cbc,0x3c498b28,0x0d9541ff,0xa8017139,0x0cb3de08,0xb4e49cd8,0x56c19064,0xcb84617b,0x32b670d5,0x6c5c7448,0xb85742d0];var U1=[0x00000000,0x0e090d0b,0x1c121a16,0x121b171d,0x3824342c,0x362d3927,0x24362e3a,0x2a3f2331,0x70486858,0x7e416553,0x6c5a724e,0x62537f45,0x486c5c74,0x4665517f,0x547e4662,0x5a774b69,0xe090d0b0,0xee99ddbb,0xfc82caa6,0xf28bc7ad,0xd8b4e49c,0xd6bde997,0xc4a6fe8a,0xcaaff381,0x90d8b8e8,0x9ed1b5e3,0x8ccaa2fe,0x82c3aff5,0xa8fc8cc4,0xa6f581cf,0xb4ee96d2,0xbae79bd9,0xdb3bbb7b,0xd532b670,0xc729a16d,0xc920ac66,0xe31f8f57,0xed16825c,0xff0d9541,0xf104984a,0xab73d323,0xa57ade28,0xb761c935,0xb968c43e,0x9357e70f,0x9d5eea04,0x8f45fd19,0x814cf012,0x3bab6bcb,0x35a266c0,0x27b971dd,0x29b07cd6,0x038f5fe7,0x0d8652ec,0x1f9d45f1,0x119448fa,0x4be30393,0x45ea0e98,0x57f11985,0x59f8148e,0x73c737bf,0x7dce3ab4,0x6fd52da9,0x61dc20a2,0xad766df6,0xa37f60fd,0xb16477e0,0xbf6d7aeb,0x955259da,0x9b5b54d1,0x894043cc,0x87494ec7,0xdd3e05ae,0xd33708a5,0xc12c1fb8,0xcf2512b3,0xe51a3182,0xeb133c89,0xf9082b94,0xf701269f,0x4de6bd46,0x43efb04d,0x51f4a750,0x5ffdaa5b,0x75c2896a,0x7bcb8461,0x69d0937c,0x67d99e77,0x3daed51e,0x33a7d815,0x21bccf08,0x2fb5c203,0x058ae132,0x0b83ec39,0x1998fb24,0x1791f62f,0x764dd68d,0x7844db86,0x6a5fcc9b,0x6456c190,0x4e69e2a1,0x4060efaa,0x527bf8b7,0x5c72f5bc,0x0605bed5,0x080cb3de,0x1a17a4c3,0x141ea9c8,0x3e218af9,0x302887f2,0x223390ef,0x2c3a9de4,0x96dd063d,0x98d40b36,0x8acf1c2b,0x84c61120,0xaef93211,0xa0f03f1a,0xb2eb2807,0xbce2250c,0xe6956e65,0xe89c636e,0xfa877473,0xf48e7978,0xdeb15a49,0xd0b85742,0xc2a3405f,0xccaa4d54,0x41ecdaf7,0x4fe5d7fc,0x5dfec0e1,0x53f7cdea,0x79c8eedb,0x77c1e3d0,0x65daf4cd,0x6bd3f9c6,0x31a4b2af,0x3fadbfa4,0x2db6a8b9,0x23bfa5b2,0x09808683,0x07898b88,0x15929c95,0x1b9b919e,0xa17c0a47,0xaf75074c,0xbd6e1051,0xb3671d5a,0x99583e6b,0x97513360,0x854a247d,0x8b432976,0xd134621f,0xdf3d6f14,0xcd267809,0xc32f7502,0xe9105633,0xe7195b38,0xf5024c25,0xfb0b412e,0x9ad7618c,0x94de6c87,0x86c57b9a,0x88cc7691,0xa2f355a0,0xacfa58ab,0xbee14fb6,0xb0e842bd,0xea9f09d4,0xe49604df,0xf68d13c2,0xf8841ec9,0xd2bb3df8,0xdcb230f3,0xcea927ee,0xc0a02ae5,0x7a47b13c,0x744ebc37,0x6655ab2a,0x685ca621,0x42638510,0x4c6a881b,0x5e719f06,0x5078920d,0x0a0fd964,0x0406d46f,0x161dc372,0x1814ce79,0x322bed48,0x3c22e043,0x2e39f75e,0x2030fa55,0xec9ab701,0xe293ba0a,0xf088ad17,0xfe81a01c,0xd4be832d,0xdab78e26,0xc8ac993b,0xc6a59430,0x9cd2df59,0x92dbd252,0x80c0c54f,0x8ec9c844,0xa4f6eb75,0xaaffe67e,0xb8e4f163,0xb6edfc68,0x0c0a67b1,0x02036aba,0x10187da7,0x1e1170ac,0x342e539d,0x3a275e96,0x283c498b,0x26354480,0x7c420fe9,0x724b02e2,0x605015ff,0x6e5918f4,0x44663bc5,0x4a6f36ce,0x587421d3,0x567d2cd8,0x37a10c7a,0x39a80171,0x2bb3166c,0x25ba1b67,0x0f853856,0x018c355d,0x13972240,0x1d9e2f4b,0x47e96422,0x49e06929,0x5bfb7e34,0x55f2733f,0x7fcd500e,0x71c45d05,0x63df4a18,0x6dd64713,0xd731dcca,0xd938d1c1,0xcb23c6dc,0xc52acbd7,0xef15e8e6,0xe11ce5ed,0xf307f2f0,0xfd0efffb,0xa779b492,0xa970b999,0xbb6bae84,0xb562a38f,0x9f5d80be,0x91548db5,0x834f9aa8,0x8d4697a3];var U2=[0x00000000,0x0b0e090d,0x161c121a,0x1d121b17,0x2c382434,0x27362d39,0x3a24362e,0x312a3f23,0x58704868,0x537e4165,0x4e6c5a72,0x4562537f,0x74486c5c,0x7f466551,0x62547e46,0x695a774b,0xb0e090d0,0xbbee99dd,0xa6fc82ca,0xadf28bc7,0x9cd8b4e4,0x97d6bde9,0x8ac4a6fe,0x81caaff3,0xe890d8b8,0xe39ed1b5,0xfe8ccaa2,0xf582c3af,0xc4a8fc8c,0xcfa6f581,0xd2b4ee96,0xd9bae79b,0x7bdb3bbb,0x70d532b6,0x6dc729a1,0x66c920ac,0x57e31f8f,0x5ced1682,0x41ff0d95,0x4af10498,0x23ab73d3,0x28a57ade,0x35b761c9,0x3eb968c4,0x0f9357e7,0x049d5eea,0x198f45fd,0x12814cf0,0xcb3bab6b,0xc035a266,0xdd27b971,0xd629b07c,0xe7038f5f,0xec0d8652,0xf11f9d45,0xfa119448,0x934be303,0x9845ea0e,0x8557f119,0x8e59f814,0xbf73c737,0xb47dce3a,0xa96fd52d,0xa261dc20,0xf6ad766d,0xfda37f60,0xe0b16477,0xebbf6d7a,0xda955259,0xd19b5b54,0xcc894043,0xc787494e,0xaedd3e05,0xa5d33708,0xb8c12c1f,0xb3cf2512,0x82e51a31,0x89eb133c,0x94f9082b,0x9ff70126,0x464de6bd,0x4d43efb0,0x5051f4a7,0x5b5ffdaa,0x6a75c289,0x617bcb84,0x7c69d093,0x7767d99e,0x1e3daed5,0x1533a7d8,0x0821bccf,0x032fb5c2,0x32058ae1,0x390b83ec,0x241998fb,0x2f1791f6,0x8d764dd6,0x867844db,0x9b6a5fcc,0x906456c1,0xa14e69e2,0xaa4060ef,0xb7527bf8,0xbc5c72f5,0xd50605be,0xde080cb3,0xc31a17a4,0xc8141ea9,0xf93e218a,0xf2302887,0xef223390,0xe42c3a9d,0x3d96dd06,0x3698d40b,0x2b8acf1c,0x2084c611,0x11aef932,0x1aa0f03f,0x07b2eb28,0x0cbce225,0x65e6956e,0x6ee89c63,0x73fa8774,0x78f48e79,0x49deb15a,0x42d0b857,0x5fc2a340,0x54ccaa4d,0xf741ecda,0xfc4fe5d7,0xe15dfec0,0xea53f7cd,0xdb79c8ee,0xd077c1e3,0xcd65daf4,0xc66bd3f9,0xaf31a4b2,0xa43fadbf,0xb92db6a8,0xb223bfa5,0x83098086,0x8807898b,0x9515929c,0x9e1b9b91,0x47a17c0a,0x4caf7507,0x51bd6e10,0x5ab3671d,0x6b99583e,0x60975133,0x7d854a24,0x768b4329,0x1fd13462,0x14df3d6f,0x09cd2678,0x02c32f75,0x33e91056,0x38e7195b,0x25f5024c,0x2efb0b41,0x8c9ad761,0x8794de6c,0x9a86c57b,0x9188cc76,0xa0a2f355,0xabacfa58,0xb6bee14f,0xbdb0e842,0xd4ea9f09,0xdfe49604,0xc2f68d13,0xc9f8841e,0xf8d2bb3d,0xf3dcb230,0xeecea927,0xe5c0a02a,0x3c7a47b1,0x37744ebc,0x2a6655ab,0x21685ca6,0x10426385,0x1b4c6a88,0x065e719f,0x0d507892,0x640a0fd9,0x6f0406d4,0x72161dc3,0x791814ce,0x48322bed,0x433c22e0,0x5e2e39f7,0x552030fa,0x01ec9ab7,0x0ae293ba,0x17f088ad,0x1cfe81a0,0x2dd4be83,0x26dab78e,0x3bc8ac99,0x30c6a594,0x599cd2df,0x5292dbd2,0x4f80c0c5,0x448ec9c8,0x75a4f6eb,0x7eaaffe6,0x63b8e4f1,0x68b6edfc,0xb10c0a67,0xba02036a,0xa710187d,0xac1e1170,0x9d342e53,0x963a275e,0x8b283c49,0x80263544,0xe97c420f,0xe2724b02,0xff605015,0xf46e5918,0xc544663b,0xce4a6f36,0xd3587421,0xd8567d2c,0x7a37a10c,0x7139a801,0x6c2bb316,0x6725ba1b,0x560f8538,0x5d018c35,0x40139722,0x4b1d9e2f,0x2247e964,0x2949e069,0x345bfb7e,0x3f55f273,0x0e7fcd50,0x0571c45d,0x1863df4a,0x136dd647,0xcad731dc,0xc1d938d1,0xdccb23c6,0xd7c52acb,0xe6ef15e8,0xede11ce5,0xf0f307f2,0xfbfd0eff,0x92a779b4,0x99a970b9,0x84bb6bae,0x8fb562a3,0xbe9f5d80,0xb591548d,0xa8834f9a,0xa38d4697];var U3=[0x00000000,0x0d0b0e09,0x1a161c12,0x171d121b,0x342c3824,0x3927362d,0x2e3a2436,0x23312a3f,0x68587048,0x65537e41,0x724e6c5a,0x7f456253,0x5c74486c,0x517f4665,0x4662547e,0x4b695a77,0xd0b0e090,0xddbbee99,0xcaa6fc82,0xc7adf28b,0xe49cd8b4,0xe997d6bd,0xfe8ac4a6,0xf381caaf,0xb8e890d8,0xb5e39ed1,0xa2fe8cca,0xaff582c3,0x8cc4a8fc,0x81cfa6f5,0x96d2b4ee,0x9bd9bae7,0xbb7bdb3b,0xb670d532,0xa16dc729,0xac66c920,0x8f57e31f,0x825ced16,0x9541ff0d,0x984af104,0xd323ab73,0xde28a57a,0xc935b761,0xc43eb968,0xe70f9357,0xea049d5e,0xfd198f45,0xf012814c,0x6bcb3bab,0x66c035a2,0x71dd27b9,0x7cd629b0,0x5fe7038f,0x52ec0d86,0x45f11f9d,0x48fa1194,0x03934be3,0x0e9845ea,0x198557f1,0x148e59f8,0x37bf73c7,0x3ab47dce,0x2da96fd5,0x20a261dc,0x6df6ad76,0x60fda37f,0x77e0b164,0x7aebbf6d,0x59da9552,0x54d19b5b,0x43cc8940,0x4ec78749,0x05aedd3e,0x08a5d337,0x1fb8c12c,0x12b3cf25,0x3182e51a,0x3c89eb13,0x2b94f908,0x269ff701,0xbd464de6,0xb04d43ef,0xa75051f4,0xaa5b5ffd,0x896a75c2,0x84617bcb,0x937c69d0,0x9e7767d9,0xd51e3dae,0xd81533a7,0xcf0821bc,0xc2032fb5,0xe132058a,0xec390b83,0xfb241998,0xf62f1791,0xd68d764d,0xdb867844,0xcc9b6a5f,0xc1906456,0xe2a14e69,0xefaa4060,0xf8b7527b,0xf5bc5c72,0xbed50605,0xb3de080c,0xa4c31a17,0xa9c8141e,0x8af93e21,0x87f23028,0x90ef2233,0x9de42c3a,0x063d96dd,0x0b3698d4,0x1c2b8acf,0x112084c6,0x3211aef9,0x3f1aa0f0,0x2807b2eb,0x250cbce2,0x6e65e695,0x636ee89c,0x7473fa87,0x7978f48e,0x5a49deb1,0x5742d0b8,0x405fc2a3,0x4d54ccaa,0xdaf741ec,0xd7fc4fe5,0xc0e15dfe,0xcdea53f7,0xeedb79c8,0xe3d077c1,0xf4cd65da,0xf9c66bd3,0xb2af31a4,0xbfa43fad,0xa8b92db6,0xa5b223bf,0x86830980,0x8b880789,0x9c951592,0x919e1b9b,0x0a47a17c,0x074caf75,0x1051bd6e,0x1d5ab367,0x3e6b9958,0x33609751,0x247d854a,0x29768b43,0x621fd134,0x6f14df3d,0x7809cd26,0x7502c32f,0x5633e910,0x5b38e719,0x4c25f502,0x412efb0b,0x618c9ad7,0x6c8794de,0x7b9a86c5,0x769188cc,0x55a0a2f3,0x58abacfa,0x4fb6bee1,0x42bdb0e8,0x09d4ea9f,0x04dfe496,0x13c2f68d,0x1ec9f884,0x3df8d2bb,0x30f3dcb2,0x27eecea9,0x2ae5c0a0,0xb13c7a47,0xbc37744e,0xab2a6655,0xa621685c,0x85104263,0x881b4c6a,0x9f065e71,0x920d5078,0xd9640a0f,0xd46f0406,0xc372161d,0xce791814,0xed48322b,0xe0433c22,0xf75e2e39,0xfa552030,0xb701ec9a,0xba0ae293,0xad17f088,0xa01cfe81,0x832dd4be,0x8e26dab7,0x993bc8ac,0x9430c6a5,0xdf599cd2,0xd25292db,0xc54f80c0,0xc8448ec9,0xeb75a4f6,0xe67eaaff,0xf163b8e4,0xfc68b6ed,0x67b10c0a,0x6aba0203,0x7da71018,0x70ac1e11,0x539d342e,0x5e963a27,0x498b283c,0x44802635,0x0fe97c42,0x02e2724b,0x15ff6050,0x18f46e59,0x3bc54466,0x36ce4a6f,0x21d35874,0x2cd8567d,0x0c7a37a1,0x017139a8,0x166c2bb3,0x1b6725ba,0x38560f85,0x355d018c,0x22401397,0x2f4b1d9e,0x642247e9,0x692949e0,0x7e345bfb,0x733f55f2,0x500e7fcd,0x5d0571c4,0x4a1863df,0x47136dd6,0xdccad731,0xd1c1d938,0xc6dccb23,0xcbd7c52a,0xe8e6ef15,0xe5ede11c,0xf2f0f307,0xfffbfd0e,0xb492a779,0xb999a970,0xae84bb6b,0xa38fb562,0x80be9f5d,0x8db59154,0x9aa8834f,0x97a38d46];var U4=[0x00000000,0x090d0b0e,0x121a161c,0x1b171d12,0x24342c38,0x2d392736,0x362e3a24,0x3f23312a,0x48685870,0x4165537e,0x5a724e6c,0x537f4562,0x6c5c7448,0x65517f46,0x7e466254,0x774b695a,0x90d0b0e0,0x99ddbbee,0x82caa6fc,0x8bc7adf2,0xb4e49cd8,0xbde997d6,0xa6fe8ac4,0xaff381ca,0xd8b8e890,0xd1b5e39e,0xcaa2fe8c,0xc3aff582,0xfc8cc4a8,0xf581cfa6,0xee96d2b4,0xe79bd9ba,0x3bbb7bdb,0x32b670d5,0x29a16dc7,0x20ac66c9,0x1f8f57e3,0x16825ced,0x0d9541ff,0x04984af1,0x73d323ab,0x7ade28a5,0x61c935b7,0x68c43eb9,0x57e70f93,0x5eea049d,0x45fd198f,0x4cf01281,0xab6bcb3b,0xa266c035,0xb971dd27,0xb07cd629,0x8f5fe703,0x8652ec0d,0x9d45f11f,0x9448fa11,0xe303934b,0xea0e9845,0xf1198557,0xf8148e59,0xc737bf73,0xce3ab47d,0xd52da96f,0xdc20a261,0x766df6ad,0x7f60fda3,0x6477e0b1,0x6d7aebbf,0x5259da95,0x5b54d19b,0x4043cc89,0x494ec787,0x3e05aedd,0x3708a5d3,0x2c1fb8c1,0x2512b3cf,0x1a3182e5,0x133c89eb,0x082b94f9,0x01269ff7,0xe6bd464d,0xefb04d43,0xf4a75051,0xfdaa5b5f,0xc2896a75,0xcb84617b,0xd0937c69,0xd99e7767,0xaed51e3d,0xa7d81533,0xbccf0821,0xb5c2032f,0x8ae13205,0x83ec390b,0x98fb2419,0x91f62f17,0x4dd68d76,0x44db8678,0x5fcc9b6a,0x56c19064,0x69e2a14e,0x60efaa40,0x7bf8b752,0x72f5bc5c,0x05bed506,0x0cb3de08,0x17a4c31a,0x1ea9c814,0x218af93e,0x2887f230,0x3390ef22,0x3a9de42c,0xdd063d96,0xd40b3698,0xcf1c2b8a,0xc6112084,0xf93211ae,0xf03f1aa0,0xeb2807b2,0xe2250cbc,0x956e65e6,0x9c636ee8,0x877473fa,0x8e7978f4,0xb15a49de,0xb85742d0,0xa3405fc2,0xaa4d54cc,0xecdaf741,0xe5d7fc4f,0xfec0e15d,0xf7cdea53,0xc8eedb79,0xc1e3d077,0xdaf4cd65,0xd3f9c66b,0xa4b2af31,0xadbfa43f,0xb6a8b92d,0xbfa5b223,0x80868309,0x898b8807,0x929c9515,0x9b919e1b,0x7c0a47a1,0x75074caf,0x6e1051bd,0x671d5ab3,0x583e6b99,0x51336097,0x4a247d85,0x4329768b,0x34621fd1,0x3d6f14df,0x267809cd,0x2f7502c3,0x105633e9,0x195b38e7,0x024c25f5,0x0b412efb,0xd7618c9a,0xde6c8794,0xc57b9a86,0xcc769188,0xf355a0a2,0xfa58abac,0xe14fb6be,0xe842bdb0,0x9f09d4ea,0x9604dfe4,0x8d13c2f6,0x841ec9f8,0xbb3df8d2,0xb230f3dc,0xa927eece,0xa02ae5c0,0x47b13c7a,0x4ebc3774,0x55ab2a66,0x5ca62168,0x63851042,0x6a881b4c,0x719f065e,0x78920d50,0x0fd9640a,0x06d46f04,0x1dc37216,0x14ce7918,0x2bed4832,0x22e0433c,0x39f75e2e,0x30fa5520,0x9ab701ec,0x93ba0ae2,0x88ad17f0,0x81a01cfe,0xbe832dd4,0xb78e26da,0xac993bc8,0xa59430c6,0xd2df599c,0xdbd25292,0xc0c54f80,0xc9c8448e,0xf6eb75a4,0xffe67eaa,0xe4f163b8,0xedfc68b6,0x0a67b10c,0x036aba02,0x187da710,0x1170ac1e,0x2e539d34,0x275e963a,0x3c498b28,0x35448026,0x420fe97c,0x4b02e272,0x5015ff60,0x5918f46e,0x663bc544,0x6f36ce4a,0x7421d358,0x7d2cd856,0xa10c7a37,0xa8017139,0xb3166c2b,0xba1b6725,0x8538560f,0x8c355d01,0x97224013,0x9e2f4b1d,0xe9642247,0xe0692949,0xfb7e345b,0xf2733f55,0xcd500e7f,0xc45d0571,0xdf4a1863,0xd647136d,0x31dccad7,0x38d1c1d9,0x23c6dccb,0x2acbd7c5,0x15e8e6ef,0x1ce5ede1,0x07f2f0f3,0x0efffbfd,0x79b492a7,0x70b999a9,0x6bae84bb,0x62a38fb5,0x5d80be9f,0x548db591,0x4f9aa883,0x4697a38d];function convertToInt32(bytes){var result=[];for(var i=0;i<bytes.length;i+=4){result.push((bytes[i]<<24)|(bytes[i+1]<<16)|(bytes[i+2]<<8)|bytes[i+3]);}
return result;}
var AES=function(key){if(!(this instanceof AES)){throw Error('AES must be instanitated with `new`');}
Object.defineProperty(this,'key',{value:coerceArray(key,true)});this._prepare();}
AES.prototype._prepare=function(){var rounds=numberOfRounds[this.key.length];if(rounds==null){throw new Error('invalid key size (must be 16, 24 or 32 bytes)');}
this._Ke=[];this._Kd=[];for(var i=0;i<=rounds;i++){this._Ke.push([0,0,0,0]);this._Kd.push([0,0,0,0]);}
var roundKeyCount=(rounds+1)*4;var KC=this.key.length/4;var tk=convertToInt32(this.key);var index;for(var i=0;i<KC;i++){index=i>>2;this._Ke[index][i%4]=tk[i];this._Kd[rounds-index][i%4]=tk[i];}
var rconpointer=0;var t=KC,tt;while(t<roundKeyCount){tt=tk[KC-1];tk[0]^=((S[(tt>>16)&0xFF]<<24)^(S[(tt>>8)&0xFF]<<16)^(S[tt&0xFF]<<8)^S[(tt>>24)&0xFF]^(rcon[rconpointer]<<24));rconpointer+=1;if(KC!=8){for(var i=1;i<KC;i++){tk[i]^=tk[i-1];}}else{for(var i=1;i<(KC/2);i++){tk[i]^=tk[i-1];}
tt=tk[(KC/2)-1];tk[KC/2]^=(S[tt&0xFF]^(S[(tt>>8)&0xFF]<<8)^(S[(tt>>16)&0xFF]<<16)^(S[(tt>>24)&0xFF]<<24));for(var i=(KC/2)+1;i<KC;i++){tk[i]^=tk[i-1];}}
var i=0,r,c;while(i<KC&&t<roundKeyCount){r=t>>2;c=t%4;this._Ke[r][c]=tk[i];this._Kd[rounds-r][c]=tk[i++];t++;}}
for(var r=1;r<rounds;r++){for(var c=0;c<4;c++){tt=this._Kd[r][c];this._Kd[r][c]=(U1[(tt>>24)&0xFF]^U2[(tt>>16)&0xFF]^U3[(tt>>8)&0xFF]^U4[tt&0xFF]);}}}
AES.prototype.encrypt=function(plaintext){if(plaintext.length!=16){throw new Error('invalid plaintext size (must be 16 bytes)');}
var rounds=this._Ke.length-1;var a=[0,0,0,0];var t=convertToInt32(plaintext);for(var i=0;i<4;i++){t[i]^=this._Ke[0][i];}
for(var r=1;r<rounds;r++){for(var i=0;i<4;i++){a[i]=(T1[(t[i]>>24)&0xff]^T2[(t[(i+1)%4]>>16)&0xff]^T3[(t[(i+2)%4]>>8)&0xff]^T4[t[(i+3)%4]&0xff]^this._Ke[r][i]);}
t=a.slice();}
var result=createArray(16),tt;for(var i=0;i<4;i++){tt=this._Ke[rounds][i];result[4*i]=(S[(t[i]>>24)&0xff]^(tt>>24))&0xff;result[4*i+1]=(S[(t[(i+1)%4]>>16)&0xff]^(tt>>16))&0xff;result[4*i+2]=(S[(t[(i+2)%4]>>8)&0xff]^(tt>>8))&0xff;result[4*i+3]=(S[t[(i+3)%4]&0xff]^tt)&0xff;}
return result;}
AES.prototype.decrypt=function(ciphertext){if(ciphertext.length!=16){throw new Error('invalid ciphertext size (must be 16 bytes)');}
var rounds=this._Kd.length-1;var a=[0,0,0,0];var t=convertToInt32(ciphertext);for(var i=0;i<4;i++){t[i]^=this._Kd[0][i];}
for(var r=1;r<rounds;r++){for(var i=0;i<4;i++){a[i]=(T5[(t[i]>>24)&0xff]^T6[(t[(i+3)%4]>>16)&0xff]^T7[(t[(i+2)%4]>>8)&0xff]^T8[t[(i+1)%4]&0xff]^this._Kd[r][i]);}
t=a.slice();}
var result=createArray(16),tt;for(var i=0;i<4;i++){tt=this._Kd[rounds][i];result[4*i]=(Si[(t[i]>>24)&0xff]^(tt>>24))&0xff;result[4*i+1]=(Si[(t[(i+3)%4]>>16)&0xff]^(tt>>16))&0xff;result[4*i+2]=(Si[(t[(i+2)%4]>>8)&0xff]^(tt>>8))&0xff;result[4*i+3]=(Si[t[(i+1)%4]&0xff]^tt)&0xff;}
return result;}
var ModeOfOperationECB=function(key){if(!(this instanceof ModeOfOperationECB)){throw Error('AES must be instanitated with `new`');}
this.description='Electronic Code Block';this.name='ecb';this._aes=new AES(key);}
ModeOfOperationECB.prototype.encrypt=function(plaintext){plaintext=coerceArray(plaintext);if((plaintext.length%16)!==0){throw new Error('invalid plaintext size (must be multiple of 16 bytes)');}
var ciphertext=createArray(plaintext.length);var block=createArray(16);for(var i=0;i<plaintext.length;i+=16){copyArray(plaintext,block,0,i,i+16);block=this._aes.encrypt(block);copyArray(block,ciphertext,i);}
return ciphertext;}
ModeOfOperationECB.prototype.decrypt=function(ciphertext){ciphertext=coerceArray(ciphertext);if((ciphertext.length%16)!==0){throw new Error('invalid ciphertext size (must be multiple of 16 bytes)');}
var plaintext=createArray(ciphertext.length);var block=createArray(16);for(var i=0;i<ciphertext.length;i+=16){copyArray(ciphertext,block,0,i,i+16);block=this._aes.decrypt(block);copyArray(block,plaintext,i);}
return plaintext;}
var ModeOfOperationCBC=function(key,iv){if(!(this instanceof ModeOfOperationCBC)){throw Error('AES must be instanitated with `new`');}
this.description='Cipher Block Chaining';this.name='cbc';if(!iv){iv=createArray(16);}else if(iv.length!=16){throw new Error('invalid initialation vector size (must be 16 bytes)');}
this._lastCipherblock=coerceArray(iv,true);this._aes=new AES(key);}
ModeOfOperationCBC.prototype.encrypt=function(plaintext){plaintext=coerceArray(plaintext);if((plaintext.length%16)!==0){throw new Error('invalid plaintext size (must be multiple of 16 bytes)');}
var ciphertext=createArray(plaintext.length);var block=createArray(16);for(var i=0;i<plaintext.length;i+=16){copyArray(plaintext,block,0,i,i+16);for(var j=0;j<16;j++){block[j]^=this._lastCipherblock[j];}
this._lastCipherblock=this._aes.encrypt(block);copyArray(this._lastCipherblock,ciphertext,i);}
return ciphertext;}
ModeOfOperationCBC.prototype.decrypt=function(ciphertext){ciphertext=coerceArray(ciphertext);if((ciphertext.length%16)!==0){throw new Error('invalid ciphertext size (must be multiple of 16 bytes)');}
var plaintext=createArray(ciphertext.length);var block=createArray(16);for(var i=0;i<ciphertext.length;i+=16){copyArray(ciphertext,block,0,i,i+16);block=this._aes.decrypt(block);for(var j=0;j<16;j++){plaintext[i+j]=block[j]^this._lastCipherblock[j];}
copyArray(ciphertext,this._lastCipherblock,0,i,i+16);}
return plaintext;}
var ModeOfOperationCFB=function(key,iv,segmentSize){if(!(this instanceof ModeOfOperationCFB)){throw Error('AES must be instanitated with `new`');}
this.description='Cipher Feedback';this.name='cfb';if(!iv){iv=createArray(16);}else if(iv.length!=16){throw new Error('invalid initialation vector size (must be 16 size)');}
if(!segmentSize){segmentSize=1;}
this.segmentSize=segmentSize;this._shiftRegister=coerceArray(iv,true);this._aes=new AES(key);}
ModeOfOperationCFB.prototype.encrypt=function(plaintext){if((plaintext.length%this.segmentSize)!=0){throw new Error('invalid plaintext size (must be segmentSize bytes)');}
var encrypted=coerceArray(plaintext,true);var xorSegment;for(var i=0;i<encrypted.length;i+=this.segmentSize){xorSegment=this._aes.encrypt(this._shiftRegister);for(var j=0;j<this.segmentSize;j++){encrypted[i+j]^=xorSegment[j];}
copyArray(this._shiftRegister,this._shiftRegister,0,this.segmentSize);copyArray(encrypted,this._shiftRegister,16-this.segmentSize,i,i+this.segmentSize);}
return encrypted;}
ModeOfOperationCFB.prototype.decrypt=function(ciphertext){if((ciphertext.length%this.segmentSize)!=0){throw new Error('invalid ciphertext size (must be segmentSize bytes)');}
var plaintext=coerceArray(ciphertext,true);var xorSegment;for(var i=0;i<plaintext.length;i+=this.segmentSize){xorSegment=this._aes.encrypt(this._shiftRegister);for(var j=0;j<this.segmentSize;j++){plaintext[i+j]^=xorSegment[j];}
copyArray(this._shiftRegister,this._shiftRegister,0,this.segmentSize);copyArray(ciphertext,this._shiftRegister,16-this.segmentSize,i,i+this.segmentSize);}
return plaintext;}
var ModeOfOperationOFB=function(key,iv){if(!(this instanceof ModeOfOperationOFB)){throw Error('AES must be instanitated with `new`');}
this.description='Output Feedback';this.name='ofb';if(!iv){iv=createArray(16);}else if(iv.length!=16){throw new Error('invalid initialation vector size (must be 16 bytes)');}
this._lastPrecipher=coerceArray(iv,true);this._lastPrecipherIndex=16;this._aes=new AES(key);}
ModeOfOperationOFB.prototype.encrypt=function(plaintext){var encrypted=coerceArray(plaintext,true);for(var i=0;i<encrypted.length;i++){if(this._lastPrecipherIndex===16){this._lastPrecipher=this._aes.encrypt(this._lastPrecipher);this._lastPrecipherIndex=0;}
encrypted[i]^=this._lastPrecipher[this._lastPrecipherIndex++];}
return encrypted;}
ModeOfOperationOFB.prototype.decrypt=ModeOfOperationOFB.prototype.encrypt;var Counter=function(initialValue){if(!(this instanceof Counter)){throw Error('Counter must be instanitated with `new`');}
if(initialValue!==0&&!initialValue){initialValue=1;}
if(typeof(initialValue)==='number'){this._counter=createArray(16);this.setValue(initialValue);}else{this.setBytes(initialValue);}}
Counter.prototype.setValue=function(value){if(typeof(value)!=='number'||parseInt(value)!=value){throw new Error('invalid counter value (must be an integer)');}
for(var index=15;index>=0;--index){this._counter[index]=value%256;value=value>>8;}}
Counter.prototype.setBytes=function(bytes){bytes=coerceArray(bytes,true);if(bytes.length!=16){throw new Error('invalid counter bytes size (must be 16 bytes)');}
this._counter=bytes;};Counter.prototype.increment=function(){for(var i=15;i>=0;i--){if(this._counter[i]===255){this._counter[i]=0;}else{this._counter[i]++;break;}}}
var ModeOfOperationCTR=function(key,counter){if(!(this instanceof ModeOfOperationCTR)){throw Error('AES must be instanitated with `new`');}
this.description='Counter';this.name='ctr';if(!(counter instanceof Counter)){counter=new Counter(counter)}
this._counter=counter;this._remainingCounter=null;this._remainingCounterIndex=16;this._aes=new AES(key);}
ModeOfOperationCTR.prototype.encrypt=function(plaintext){var encrypted=coerceArray(plaintext,true);for(var i=0;i<encrypted.length;i++){if(this._remainingCounterIndex===16){this._remainingCounter=this._aes.encrypt(this._counter._counter);this._remainingCounterIndex=0;this._counter.increment();}
encrypted[i]^=this._remainingCounter[this._remainingCounterIndex++];}
return encrypted;}
ModeOfOperationCTR.prototype.decrypt=ModeOfOperationCTR.prototype.encrypt;function pkcs7pad(data){data=coerceArray(data,true);var padder=16-(data.length%16);var result=createArray(data.length+padder);copyArray(data,result);for(var i=data.length;i<result.length;i++){result[i]=padder;}
return result;}
function pkcs7strip(data){data=coerceArray(data,true);if(data.length<16){throw new Error('PKCS#7 invalid length');}
var padder=data[data.length-1];if(padder>16){throw new Error('PKCS#7 padding byte out of range');}
var length=data.length-padder;for(var i=0;i<padder;i++){if(data[length+i]!==padder){throw new Error('PKCS#7 invalid padding byte');}}
var result=createArray(length);copyArray(data,result,0,0,length);return result;}
var aesjs={AES:AES,Counter:Counter,ModeOfOperation:{ecb:ModeOfOperationECB,cbc:ModeOfOperationCBC,cfb:ModeOfOperationCFB,ofb:ModeOfOperationOFB,ctr:ModeOfOperationCTR},utils:{hex:convertHex,utf8:convertUtf8},padding:{pkcs7:{pad:pkcs7pad,strip:pkcs7strip}},_arrayTest:{coerceArray:coerceArray,createArray:createArray,copyArray:copyArray,}};if(typeof exports!=='undefined'){module.exports=aesjs}else if(typeof(define)==='function'&&define.amd){define(aesjs);}else{if(root.aesjs){aesjs._aesjs=root.aesjs;}
root.aesjs=aesjs;}})(this);let AESM=function(key){this.encoder=new TextEncoder('UTF-8');this.decoder=new TextDecoder('UTF-8');let keyBuffer=key.b16ToAB();this.key=new Uint8Array(keyBuffer);};AESM.prototype.encrypt=function(text){var iv=new Uint8Array(16);window.crypto.getRandomValues(iv);let textBytes=aesjs.padding.pkcs7.pad(this.encoder.encode(text));var aesCbc=new aesjs.ModeOfOperation.cbc(this.key,iv);var encryptedBytes=aesCbc.encrypt(textBytes);var encryptedHex=aesjs.utils.hex.fromBytes(encryptedBytes);var c=new Int8Array(iv.length+encryptedBytes.length);c.set(iv);c.set(encryptedBytes,iv.length);let edata=c.buffer.toB64();return edata;};AESM.prototype.decrypt=function(encrypted64){let buffer=encrypted64.b64ToAB();var iv=new Uint8Array(buffer,0,16);let edata=new Uint8Array(buffer,16);var aesCbc=new aesjs.ModeOfOperation.cbc(this.key,iv);let decryptedBytes=aesCbc.decrypt(edata);let paddedData=aesjs.padding.pkcs7.strip(decryptedBytes);let data=this.decoder.decode(paddedData);return data;};'use strict';var Sha256={};Sha256.hash=function(msg,options){var defaults={msgFormat:'string',outFormat:'hex'};var opt=Object.assign(defaults,options);switch(opt.msgFormat){default:case'string':msg=Sha256.utf8Encode(msg);break;case'hex-bytes':msg=Sha256.hexBytesToString(msg);break;}
var K=[0x428a2f98,0x71374491,0xb5c0fbcf,0xe9b5dba5,0x3956c25b,0x59f111f1,0x923f82a4,0xab1c5ed5,0xd807aa98,0x12835b01,0x243185be,0x550c7dc3,0x72be5d74,0x80deb1fe,0x9bdc06a7,0xc19bf174,0xe49b69c1,0xefbe4786,0x0fc19dc6,0x240ca1cc,0x2de92c6f,0x4a7484aa,0x5cb0a9dc,0x76f988da,0x983e5152,0xa831c66d,0xb00327c8,0xbf597fc7,0xc6e00bf3,0xd5a79147,0x06ca6351,0x14292967,0x27b70a85,0x2e1b2138,0x4d2c6dfc,0x53380d13,0x650a7354,0x766a0abb,0x81c2c92e,0x92722c85,0xa2bfe8a1,0xa81a664b,0xc24b8b70,0xc76c51a3,0xd192e819,0xd6990624,0xf40e3585,0x106aa070,0x19a4c116,0x1e376c08,0x2748774c,0x34b0bcb5,0x391c0cb3,0x4ed8aa4a,0x5b9cca4f,0x682e6ff3,0x748f82ee,0x78a5636f,0x84c87814,0x8cc70208,0x90befffa,0xa4506ceb,0xbef9a3f7,0xc67178f2];var H=[0x6a09e667,0xbb67ae85,0x3c6ef372,0xa54ff53a,0x510e527f,0x9b05688c,0x1f83d9ab,0x5be0cd19];msg+=String.fromCharCode(0x80);var l=msg.length/4+2;var N=Math.ceil(l/16);var M=new Array(N);for(var i=0;i<N;i++){M[i]=new Array(16);for(var j=0;j<16;j++){M[i][j]=(msg.charCodeAt(i*64+j*4)<<24)|(msg.charCodeAt(i*64+j*4+1)<<16)|(msg.charCodeAt(i*64+j*4+2)<<8)|(msg.charCodeAt(i*64+j*4+3));}}
var lenHi=((msg.length-1)*8)/Math.pow(2,32);var lenLo=((msg.length-1)*8)>>>0;M[N-1][14]=Math.floor(lenHi);M[N-1][15]=lenLo;for(var i=0;i<N;i++){var W=new Array(64);for(var t=0;t<16;t++)W[t]=M[i][t];for(var t=16;t<64;t++){W[t]=(Sha256.σ1(W[t-2])+W[t-7]+Sha256.σ0(W[t-15])+W[t-16])>>>0;}
var a=H[0],b=H[1],c=H[2],d=H[3],e=H[4],f=H[5],g=H[6],h=H[7];for(var t=0;t<64;t++){var T1=h+Sha256.Σ1(e)+Sha256.Ch(e,f,g)+K[t]+W[t];var T2=Sha256.Σ0(a)+Sha256.Maj(a,b,c);h=g;g=f;f=e;e=(d+T1)>>>0;d=c;c=b;b=a;a=(T1+T2)>>>0;}
H[0]=(H[0]+a)>>>0;H[1]=(H[1]+b)>>>0;H[2]=(H[2]+c)>>>0;H[3]=(H[3]+d)>>>0;H[4]=(H[4]+e)>>>0;H[5]=(H[5]+f)>>>0;H[6]=(H[6]+g)>>>0;H[7]=(H[7]+h)>>>0;}
for(var h=0;h<H.length;h++)H[h]=('00000000'+H[h].toString(16)).slice(-8);var separator=opt.outFormat=='hex-w'?' ':'';return H.join(separator);};Sha256.ROTR=function(n,x){return(x>>>n)|(x<<(32-n));};Sha256.Σ0=function(x){return Sha256.ROTR(2,x)^Sha256.ROTR(13,x)^Sha256.ROTR(22,x);};Sha256.Σ1=function(x){return Sha256.ROTR(6,x)^Sha256.ROTR(11,x)^Sha256.ROTR(25,x);};Sha256.σ0=function(x){return Sha256.ROTR(7,x)^Sha256.ROTR(18,x)^(x>>>3);};Sha256.σ1=function(x){return Sha256.ROTR(17,x)^Sha256.ROTR(19,x)^(x>>>10);};Sha256.Ch=function(x,y,z){return(x&y)^(~x&z);};Sha256.Maj=function(x,y,z){return(x&y)^(x&z)^(y&z);};Sha256.utf8Encode=function(str){return unescape(encodeURIComponent(str));};Sha256.hexBytesToString=function(hexStr){hexStr=hexStr.replace(' ','');var str='';for(var i=0;i<hexStr.length;i+=2){str+=String.fromCharCode(parseInt(hexStr.slice(i,i+2),16));}
return str;};if(typeof module!='undefined'&&module.exports)module.exports=Sha256;let IntegerValidator=function(inputRow,min=-Number.MAX_SAFE_INTEGER,max=Number.MAX_SAFE_INTEGER){this.inputRow=inputRow;this.min=min;this.max=max;this.inputRow.input.input.step=1;this.inputRow.input.input.min=min;this.inputRow.input.input.max=max;};IntegerValidator.prototype.validate=function(){let value=this.inputRow.value()|0;value=Math.max(this.min,Math.min(value,this.max));this.inputRow.set(value);};IntegerValidator.prototype.value=function(){let value=this.inputRow.input.input.value.trim()|0;return value;};let FloatValidator=function(inputRow,min=-Number.MAX_SAFE_INTEGER,max=Number.MAX_SAFE_INTEGER){this.inputRow=inputRow;this.min=min;this.max=max;this.inputRow.input.input.min=min;this.inputRow.input.input.max=max;};FloatValidator.prototype.validate=function(){let value=this.inputRow.value();value=parseFloat(value)||0;value=Math.max(this.min,Math.min(value,this.max));this.inputRow.set(value);};FloatValidator.prototype.value=function(){let value=this.inputRow.input.input.value.trim();value=parseFloat(value);return value;};let InputRow=function(parent,label,type='text',placeholder='',disabled=false,maxLength=253){this.parent=parent;this.tag=document.createElement('div');this.tag.className='InputRow';this.name=document.createElement('div');this.name.className='Name';this.name.textContent=label;this.tag.append(this.name);this.input=new InputRow.Input(this,type,placeholder,disabled,maxLength);this.tag.append(this.input.tag);this.help=document.createElement('div');this.help.className='Help';this.help.textContent='?';this.tag.append(this.help);this.help.style.display='none';this.help.onclick=this.helpClicked.bind(this);this.validator=null;this.onkeydown=null;this.default='';this.changed=false;};InputRow.prototype.setHelp=function(message){this.help.message=message;this.help.style.display='';};InputRow.prototype.helpClicked=function(){this.parent.showMessage(this.help.message);};InputRow.prototype.message=function(message){this.input.messages.textContent=message;};InputRow.prototype.value=function(){let value='';if(this.validator){value=this.validator.value();}else if('checkbox'==this.input.input.type){value=this.input.input.checked;}else{value=this.input.input.value.trim();}
return value;};InputRow.prototype.set=function(value){if('checkbox'!=this.input.input.type){this.input.input.value=value;}else{this.input.input.checked=!!value;}};InputRow.prototype.pong=function(value){this.default=value;if(!this.changed||this.input.input.disabled){if(document.activeElement!=this.input.input){this.message('');this.set(value);}}
this.onchanged();};InputRow.prototype.onchanged=function(e){if(this.validator)this.validator.validate();let value=this.value();this.changed=(this.default!=value);this.name.style['font-weight']=this.changed?'bold':'';if(this.onchange)this.onchange(this);this.message('');};InputRow.prototype.keydown=function(e){if(this.onkeydown)this.onkeydown(e);switch(e.keyCode){case 27:this.esc();break;}};InputRow.prototype.esc=function(){this.set(this.default);this.onchanged();};InputRow.prototype.addOptions=function(options){this.input.addOptions(options);};InputRow.prototype.setOptions=function(options){this.input.setOptions(options);};InputRow.prototype.enable=function(enabled){this.input.input.disabled=!enabled;};InputRow.prototype.blur=function(){this.input.input.blur();};InputRow.Input=function(parent,type='text',placeholder='',disabled=false,maxLength=253){this.parent=parent;this.tag=document.createElement('div');this.tag.className='Input';this.messages=document.createElement('div');this.messages.className='Messages';this.messages.textContent='';this.tag.append(this.messages);if('select'!=type){this.input=document.createElement('input');this.input.className='Large';this.input.type=type;this.input['maxlength']=maxLength;this.input.placeholder=placeholder;this.input.onkeydown=(e)=>{this.parent.keydown(e);};}else{this.input=document.createElement('select');}
this.input.onchange=(e)=>{this.parent.onchanged(e);};this.input.disabled=!!disabled;this.tag.append(this.input);};InputRow.Input.prototype.setOptions=function(options){this.input.selectedIndex=0;this.input.options.length=0;this.addOptions(options);};InputRow.Input.prototype.addOptions=function(options){for(let opt of options){let option=new Option(opt[0],opt[1]);option.disabled=!!opt[2];this.input.add(option);}};let StatusRow=function(parent,label){this.parent=parent;this.tag=document.createElement('div');this.tag.className='InputRow';this.name=document.createElement('div');this.name.className='Name';this.name.textContent=label;this.tag.append(this.name);this.input=new StatusRow.Input(this);this.tag.append(this.input.tag);};StatusRow.prototype.pong=function(pong){if(WL_CONNECTED==pong.status){this.name.textContent=STATUS[pong.status];this.input.label.textContent=pong.ssid;}else{this.name.textContent='status';this.input.label.textContent=STATUS[pong.status];}
switch(pong.status){case 3:this.input.point.style['background-color']='#0F0';break;case 1:case 4:case 6:this.input.point.style['background-color']='#F00';break;default:this.input.point.style['background-color']='#FF0';break;}};StatusRow.prototype.setStatus=function(status){this.input.label.textContent=STATUS[status];switch(status){case 3:this.input.point.style['background-color']='#0F0';break;case 1:case 4:case 6:this.input.point.style['background-color']='#F00';break;default:this.input.point.style['background-color']='#FF0';break;}};StatusRow.Input=function(parent){this.parent=parent;this.tag=document.createElement('div');this.tag.className='Input';this.point=document.createElement('div');this.point.className='Point';this.tag.append(this.point);this.label=document.createElement('div');this.label.className='Label';this.label.textContent='unknown';this.label.style='font-size: 90%; width: 100%;';this.tag.append(this.label);};let Signal=function(parent,label){this.parent=parent;this.tag=document.createElement('div');this.tag.className='InputRow';this.name=document.createElement('div');this.name.className='Name';this.name.textContent=label;this.tag.append(this.name);this.input=new Signal.Input(this,label);this.tag.append(this.input.tag);};Signal.prototype.pong=function(pong){let db=(WL_CONNECTED!=pong.status)?-500:pong.ss;this.input.setDb(db);};Signal.prototype.fromMillis=function(millis){let db=-500;if(100>=millis){db=-10;}else if(300>=millis){db=-90;}else if(800>=millis){db=-130;}else if(5000>=millis){db=-200;}
this.input.setDb(db);};Signal.Input=function(parent){this.parent=parent;this.tag=document.createElement('div');this.tag.className='Input';this.icon=new Signal.Input.Icon(this);this.tag.append(this.icon.tag);};Signal.Input.prototype.setDb=function(db){this.icon.setDb(db);};Signal.Input.prototype.setLevel=function(level){this.icon.setLevel(level);};Signal.Input.Icon=function(parent){this.parent=parent;this.tag=document.createElement('div');this.tag.className='SignalIcon';for(let i=0;i<4;i++){this[i]=document.createElement('div');this[i].className=`Bar B0${i+1}`;this.tag.append(this[i]);}};Signal.Input.Icon.prototype.setDb=function(db){let level=3;if(+db<-400){level=-1;}else if(+db<-130){level=0;}else if(+db<-90){level=1;}else if(+db<-50){level=2;}
this.setLevel(level);};Signal.Input.Icon.prototype.setLevel=function(level){let color='#0E0';if(-1==level){color='';}else if(0==level){color='#E00';}else if(1==level){color='#EE0';}else if(2==level){color='#9E0';}
for(let i=0;i<4;i++){this[i].style['background-color']=(i<=level)?color:'';}};let NetworkRow=function(parent){this.parent=parent;this.tag=document.createElement('div');this.tag.className='NetworkRow';this.name=document.createElement('div');this.name.className='Name';this.name.textContent='';this.tag.append(this.name);this.signal=new Signal.Input.Icon(this);this.tag.append(this.signal.tag);this.lock=document.createElement('div');this.lock.className='Lock';this.tag.append(this.lock);this.tag.onclick=this.clicked.bind(this);};NetworkRow.prototype.clicked=function(){this.parent.networkClicked(this);};NetworkRow.prototype.setData=function(data){this.name.textContent=data.ssid;this.signal.setDb(data.rssi);};let NetworkRows=function(parent){this.parent=parent;this.tag=document.createElement('div');this.tag.className='NetworkRows NetworkRowsHidden';this.rows=[];this.length=0;};NetworkRows.prototype.networkClicked=function(row){this.parent.networkClicked(row);};NetworkRows.prototype.reset=function(){this.length=0;this.tag.classList.add('NetworkRowsHidden');for(let networkRow of this.rows){networkRow.tag.style.display='none';}};NetworkRows.prototype.addNetwork=function(network){let networkRow=this.rows[this.length++];if(!networkRow){networkRow=new NetworkRow(this);this.rows.push(networkRow);this.tag.append(networkRow.tag);}
networkRow.setData(network);networkRow.tag.style.display='';this.tag.classList.remove('NetworkRowsHidden');};let NetworksList=function(parent){this.parent=parent;this.tag=document.createElement('div');this.tag.className='NetworksList';this.networkRows=new NetworkRows(this);this.tag.append(this.networkRows.tag)
this.messages=document.createElement('div');this.messages.className='Messages';this.messages.textContent='scan for nearby routers';this.tag.append(this.messages);this.scanbutton=document.createElement('div');this.scanbutton.className='Button';this.scanbutton.textContent='scan';this.scanbutton.onclick=this.scanClicked.bind(this);this.tag.append(this.scanbutton);this.scaning=false;this.totalScaned=0;};NetworksList.prototype.reset=function(message){this.scaning=false;this.scanbutton.textContent='scan';this.messages.textContent=message;this.networkRows.reset();};NetworksList.prototype.scanClicked=function(){if(!this.scaning){this.scaning=true;this.scanbutton.textContent='scaning';this.messages.textContent='scaning ...';this.networkRows.reset();this.parent.scanClicked();}};NetworksList.prototype.scaningResult=function(result){this.totalScaned=result.value|0;if(0<this.totalScaned){this.requestNetwork(0);}};NetworksList.prototype.requestNetwork=function(index){let command={};command.network={};command.network.i=index;this.parent.command(command);};NetworksList.prototype.onNetwork=function(network){this.addNetwork(network);if(this.totalScaned>(network.index+1)){this.requestNetwork(network.index+1);}else{this.scaning=false;this.scanbutton.textContent='refresh';this.messages.textContent='';}};NetworksList.prototype.addNetwork=function(network){this.networkRows.addNetwork(network);};NetworksList.prototype.networkClicked=function(row){this.parent.networkClicked(row);};let Advanced=function(parent,label){this.parent=parent;this.tag=document.createElement('div');this.tag.className='Advanced';this.title=new Advanced.Title(this,label);this.title.tag.onclick=this.toggleWindow.bind(this);this.tag.append(this.title.tag);this.window=new Advanced.Window(this);this.tag.append(this.window.tag);};Advanced.prototype.close=function(){this.window.tag.classList.remove('WindowOpen');this.title.arrow.classList.remove('ArrowDown');};Advanced.prototype.open=function(){this.window.tag.classList.add('WindowOpen');this.title.arrow.classList.add('ArrowDown');};Advanced.prototype.toggleWindow=function(){this.window.tag.classList.toggle('WindowOpen');this.title.arrow.classList.toggle('ArrowDown');};Advanced.prototype.addInput=function(tag){this.window.tag.append(tag);};Advanced.prototype.append=function(tag){this.addInput(tag);};Advanced.Title=function(parent,label){this.parent=parent;this.tag=document.createElement('div');this.tag.className='Title';this.arrow=document.createElement('div');this.arrow.className='Arrow';this.tag.append(this.arrow);this.label=document.createElement('div');this.label.className='Label';this.label.textContent=label;this.tag.append(this.label);};Advanced.Window=function(parent){this.parent=parent;this.tag=document.createElement('div');this.tag.className='Window';};let Tabs=function(parent){this.parent=parent;this.tag=document.createElement('div');this.tag.className='Tabs';this.selected=0;this.tags=[];};Tabs.prototype.addTab=function(tag,label,selected=false){let index=this.tags.length;this.tags.push(tag);tag.style['display']=selected?'':'none';this[index]=document.createElement('div');this[index].className='Tab T0'+index+(!!selected?' Selected':'');this[index].textContent=label;this[index].onclick=this.clicked.bind(this,index);this.tag.append(this[index]);if(selected)this.selected=index;};Tabs.prototype.clicked=function(index){this[this.selected].classList.remove('Selected');this.tags[this.selected].style['display']='none';this[this.selected=index].classList.add('Selected');this.tags[this.selected].style['display']='';if(this.parent.tabClicked){this.parent.tabClicked(this.tags[this.selected]);}};Tabs.prototype.selectedTag=function(){return this.tags[this.selected];};let Messages=function(parent){this.parent=parent;this.tag=document.createElement('div');this.tag.className='SystemMessages';this.window=new Messages.Window(this,'','OK');this.tag.append(this.window.tag);this.wicon=document.createElement('div');this.wicon.className='Icon';this.tag.append(this.wicon);this.wicon.icon=document.createElement('div');this.wicon.icon.className='Icon';this.wicon.append(this.wicon.icon);this.window.tag.style['display']='none';this.wicon.style['display']='none';};Messages.prototype.showMessage=function(message,html=false){this.tag.style['display']='';this.window.tag.style['display']='';if(html){this.window.label.innerHTML='';setTimeout(()=>{this.window.label.innerHTML=message;},0);}else{this.window.label.textContent=message;}
this.wicon.style['display']='none';this.parent.setOpacity(0.6);};Messages.prototype.hideWaiting=function(){this.wicon.style['display']='none';if('none'==this.window.tag.style['display']){this.tag.style['display']='none';this.parent.setOpacity(1);}};Messages.prototype.showWaiting=function(message){this.tag.style['display']='';if('none'==this.window.tag.style['display']){this.wicon.style['display']='';this.parent.setOpacity(0.6);}};Messages.prototype.okClicked=function(){this.window.tag.style['display']='none';this.wicon.style['display']='none';this.tag.style['display']='none';this.parent.setOpacity(1);};Messages.Window=function(parent){this.parent=parent;this.tag=document.createElement('div');this.tag.className='Window';this.label=document.createElement('div');this.label.className='Label';this.label.textContent='';this.tag.append(this.label);this.button=document.createElement('div');this.button.className='Button';this.button.textContent='\u2716';this.button.onclick=()=>{this.parent.okClicked();};this.tag.append(this.button);};let PINS={};PINS=[];PINS.push(['unused',-1]);PINS.push(['GPIO0 - D3',0]);PINS.push(['GPIO1',1]);PINS.push(['GPIO2 - D4',2]);PINS.push(['GPIO3',3]);PINS.push(['GPIO4 - D2',4]);PINS.push(['GPIO5 - D1',5]);PINS.push(['GPIO6',6]);PINS.push(['GPIO7',7]);PINS.push(['GPIO8',8]);PINS.push(['GPIO9',9]);PINS.push(['GPIO10',10]);PINS.push(['GPIO11',11]);PINS.push(['GPIO12 - D6',12]);PINS.push(['GPIO13 - D7',13]);PINS.push(['GPIO14 - D5',14]);PINS.push(['GPIO15 - D8',15]);PINS.push(['GPIO16 - D0',16]);let Login=function(parent){this.parent=parent;this.tag=document.createElement('div');this.tag.className='Login';this.title=document.createElement('div');this.title.className='Title';this.title.textContent='Administration login:';this.tag.append(this.title);this.separator=document.createElement('div');this.separator.className='Separator';this.tag.append(this.separator);this.explanation=document.createElement('div');this.explanation.className='TextContent';this.explanation.textContent='Administration interface';this.tag.append(this.explanation);this.username=new InputRow(this,'user','text','',false);this.username.onkeydown=(e)=>{if(13==e.keyCode)this.okClicked();};this.tag.append(this.username.tag);this.password=new InputRow(this,'pass','password','',false);this.password.onkeydown=(e)=>{if(13==e.keyCode)this.okClicked();};this.tag.append(this.password.tag);this.changeButton=document.createElement('div');this.changeButton.className='Button Change';this.changeButton.textContent='change user / password';this.changeButton.showing=false;this.changeButton.onclick=this.toggleNewUser.bind(this);this.tag.append(this.changeButton);this.newUser=new InputRow(this,'new user','text','',true);this.newUser.tag.style.display='none';this.newUser.onkeydown=(e)=>{if(13==e.keyCode)this.okClicked();};this.tag.append(this.newUser.tag);this.password1=new InputRow(this,'pass','password','',true);this.password1.tag.style.display='none';this.password1.onkeydown=(e)=>{if(13==e.keyCode)this.okClicked();};this.tag.append(this.password1.tag);this.password2=new InputRow(this,'repeat','password','',true);this.password2.tag.style.display='none';this.password2.onkeydown=(e)=>{if(13==e.keyCode)this.okClicked();};this.tag.append(this.password2.tag);this.okButton=document.createElement('div');this.okButton.className='Button';this.okButton.textContent='login';this.okButton.onclick=this.login.bind(this);this.tag.append(this.okButton);this.message=document.createElement('div');this.message.className='TextContent';this.message.textContent='welcome';this.tag.append(this.message);};Login.prototype.init=function(){this.message.textContent='syncing ...';};Login.prototype.toggleNewUser=function(){let show=this.changeButton.showing=!this.changeButton.showing;this.newUser.tag.style.display=show?'':'none';this.password1.tag.style.display=show?'':'none';this.password2.tag.style.display=show?'':'none';let buttonText=show?'ok':'login';this.okButton.textContent=show?'ok':'login';;this.okButton.onclick=show?this.change.bind(this):this.login.bind(this);this.changeButton.textContent=show?'cancel':'change user / password';};Login.prototype.onErrorSyncing=function(){this.message.textContent='error syncing, trying again ...';};Login.prototype.onSynced=function(){this.username.enable(true);this.password.enable(true);this.newUser.enable(true);this.password1.enable(true);this.password2.enable(true);this.message.textContent='welcome';};Login.prototype.okClicked=function(){if(this.changeButton.showing){this.change();}else{this.login();}};Login.prototype.validateLogin=function(){let user=this.username.value().toLowerCase();let pass=this.password.value();let validUser=(''!=user);let userMessage=validUser?'':'invalid user';this.username.message(userMessage);let validPass=(''!=pass);let passMessage=validPass?'':'invalid password';this.password.message(passMessage);return(validUser&&validPass);};Login.prototype.validateNewUser=function(){let user=this.newUser.value().toLowerCase();let pass1=this.password1.value();let pass2=this.password2.value();let validUser=(''!=user);let userMessage=validUser?'':'invalid user';this.newUser.message(userMessage);let validPass1=(''!=pass1);let passMessage1=validPass1?'':'invalid password';this.password1.message(passMessage1);let validPass2=(''!=pass2);let passMessage2=validPass2?'':'invalid password';this.password2.message(passMessage2);let validPass=validPass1&&validPass2;if(validPass){validPass=(pass1==pass2);let passMessage=validPass?'':'invalid passwords';this.password1.message(passMessage);this.password2.message(passMessage);if(!validPass){this.password1.set('');this.password2.set('');}}
return(validUser&&validPass);};Login.prototype.change=function(){let validLogin=this.validateLogin();let validNewUser=this.validateNewUser();if(validLogin&&validNewUser){let user=this.username.value().toLowerCase();;let pass=this.password.value();let newUser=this.newUser.value().toLowerCase();;let newPass=this.password1.value();this.parent.change(user,pass,newUser,newPass);this.username.set('');this.password.set('');this.newUser.set('');this.password1.set('');this.password2.set('');}};Login.prototype.login=function(){let validLogin=this.validateLogin();if(validLogin){let user=this.username.value().toLowerCase();let pass=this.password.value();this.parent.signin(user,pass);this.username.set('');this.password.set('');}};Login.prototype.onLoginError=function(){this.username.message('invalid user');this.password.message('invalid password');this.newUser.message('');this.password1.message('');this.password2.message('');this.message.textContent='error signing in, try again ...';};Login.prototype.onLoggedin=function(){};Login.prototype.onConnected=function(){this.parent.onLogin();};Login.prototype.oncommand=function(command){this.parent.oncommand(command);};Login.prototype.userCommand=function(command){this.user.command(command);};let WL_IDLE_STATUS=0;let WL_CONNECTED=3;let MODES=[];MODES[0]=['unknown',0];MODES[1]=['802.11b',1];MODES[2]=['802.11g',2];let STATUS={};STATUS[WL_IDLE_STATUS]='idle';STATUS[1]='configured SSID cannot be reached';STATUS[2]='Scan completed';STATUS[WL_CONNECTED]='connected';STATUS[4]='password is incorrect';STATUS[5]='connection lost';STATUS[6]='disconnected';let BGN=[];BGN[0]=['unknown',0];BGN[1]=['802.11b',1];BGN[2]=['802.11g',2];BGN[3]=['802.11n',3];let WiFi=function(parent,name){Node.call(this,parent,name);this.tag=document.createElement('div');this.tag.className='WiFi';this.tag.node=this;this.title=document.createElement('div');this.title.className='Title';this.title.textContent='WiFI Settings:';this.tag.append(this.title);this.separator=document.createElement('div');this.separator.className='Separator';this.tag.append(this.separator);this.mode=new InputRow(this,'mode','select','');this.mode.addOptions(WiFi.MODES);this.tag.append(this.mode.tag);this.mode.pong(3);this.bgn=new InputRow(this,'phy mode','select','');this.bgn.addOptions(BGN);this.tag.append(this.bgn.tag);this.tabs=new Tabs(this);this.tag.append(this.tabs.tag);this.client=new WiFiClient(this,'client');this.addNode(this.client);this.tabs.addTab(this.client.tag,'Client',true);this.ap=new AccessPoint(this,'ap');this.ap.tag.style['display']='none';this.addNode(this.ap);this.tabs.addTab(this.ap.tag,'Access Point',false);this.selected=0;};for(let i in Node.prototype)
WiFi.prototype[i]=Node.prototype[i];WiFi.prototype.init=function(){};WiFi.prototype.stateCommand=function(){let command=Node.prototype.stateCommand.call(this);command.state={};command.client=this.client.stateCommand();command.ap=this.ap.stateCommand();return command;};WiFi.prototype.state=function(params){this.loaded=true;this.bgn.pong(params.bgn);this.mode.pong(params.mode);};WiFi.prototype.scanClicked=function(){let command={};command.n='scan';command.p={};this.console.addTextLine('Scanning netorks ...');};WiFi.prototype.onScanned=function(result){this.networksList.scaningResult(result);};WiFi.prototype.networkClicked=function(row){this.ssid.set(row.name.textContent);this.ssid.onchanged();};WiFi.prototype.dhcpChanged=function(){let dhcp=this.dhcp.value();this.enableDHCPFields(dhcp);};WiFi.prototype.enableDHCPFields=function(dhcp){this.ip.enable(!dhcp);this.netmask.enable(!dhcp);this.gateway.enable(!dhcp);this.dns1.enable(!dhcp);this.dns2.enable(!dhcp);};WiFi.prototype.validate=function(){let valid=Node.prototype.validate.call(this);let mode=this.bgn.value();let validMode=(0<mode);let modeMessage=validMode?'':'invalid phy mode';this.bgn.message(modeMessage);return valid&&validMode;};WiFi.prototype.isChanged=function(){return this.bgn.changed||this.mode.changed;};WiFi.prototype.save=function(command){Node.prototype.save.call(this,command);let wifi=command.save={};if(this.mode.changed)
wifi.mode=this.mode.value()|0;if(this.bgn.changed)
wifi.bgn=this.bgn.value()|0;};WiFi.MODES=[];WiFi.MODES[0]=['WIFI_OFF',0];WiFi.MODES[1]=['WIFI_STA',1];WiFi.MODES[2]=['WIFI_AP',2];WiFi.MODES[3]=['WIFI_AP_STA',3];let WiFiClient=function(parent,name){Node.call(this,parent,name);this.tag=document.createElement('div');this.tag.className='WiFiClient';this.status=new StatusRow(this,'status');this.tag.append(this.status.tag);this.signal=new Signal(this,'signal');this.tag.append(this.signal.tag);this.disconnectButton=document.createElement('div');this.disconnectButton.className='Button DisconnectButton';this.disconnectButton.textContent='disconnect';this.disconnectButton.onclick=this.disconnect.bind(this);this.tag.append(this.disconnectButton);this.separator=document.createElement('div');this.separator.className='Separator';this.tag.append(this.separator);this.connection=new Advanced(this,'Network connection');this.connection.className='Advanced';this.tag.append(this.connection.tag);this.ssid=new InputRow(this,'SSID');this.connection.addInput(this.ssid.tag);this.pass=new InputRow(this,'PASS','password','hidden');this.connection.addInput(this.pass.tag);this.networksList=new NetworksList(this);this.connection.addInput(this.networksList.tag);this.advanced=new Advanced(this,'Advanced');this.advanced.className='Advanced';this.tag.append(this.advanced.tag);this.hostname=new InputRow(this,'hostname','text','');this.advanced.addInput(this.hostname.tag);this.dhcp=new InputRow(this,'DCHP','checkbox','');this.dhcp.input.input.checked=true;this.dhcp.input.input.className='';this.dhcp.onchange=this.dhcpChanged.bind(this);this.advanced.addInput(this.dhcp.tag);this.ip=new InputRow(this,'ip','text','',true);this.advanced.addInput(this.ip.tag);this.netmask=new InputRow(this,'netmask','text','',true);this.advanced.addInput(this.netmask.tag);this.gateway=new InputRow(this,'gateway','text','',true);this.advanced.addInput(this.gateway.tag);this.dns1=new InputRow(this,'DNS 1','text','',true);this.advanced.addInput(this.dns1.tag);this.dns2=new InputRow(this,'DNS 2','text','',true);this.advanced.addInput(this.dns2.tag);this.mac=new InputRow(this,'MAC','text','',true);this.advanced.addInput(this.mac.tag);this.console=new Console();this.tag.append(this.console.tag);this.fping=true;};for(let i in Node.prototype)
WiFiClient.prototype[i]=Node.prototype[i];WiFiClient.prototype.init=function(){this.savebutton.onclick=this.saveClicked.bind(this);this.ssid.onkeydown=(e)=>{if(13==e.keyCode)setTimeout(this.saveClicked.bind(this),0);return true;};this.pass.onkeydown=(e)=>{if(13==e.keyCode)setTimeout(this.saveClicked.bind(this),0);return true;};this.console.addTextLine('WiFi console v1.0');};WiFiClient.prototype.state=function(params){if('status'in params)this.status.pong(params);if('ss'in params)this.signal.pong(params);if('cssid'in params)this.ssid.pong(params.cssid);if('hn'in params)this.hostname.pong(params.hn);if('ip'in params)this.ip.pong(params.ip);if('sm'in params)this.netmask.pong(params.sm);if('gw'in params)this.gateway.pong(params.gw);if('mac'in params)this.mac.pong(params.mac);if('dns1'in params)this.dns1.pong(params.dns1);if('dns2'in params)this.dns2.pong(params.dns2);if('dhcp'in params){let dhcp=!!params.dhcp;this.dhcp.pong(dhcp);dhcp=this.dhcp.value();this.enableDHCPFields(dhcp);}
if(this.fping){this.fping=false;if(WL_CONNECTED!=params.status){this.connection.toggleWindow();if(WL_IDLE_STATUS==params.status){this.networksList.scanClicked();}}}};WiFiClient.prototype.disconnect=function(){let command={};command.disconnect={};this.command(command);document.location.reload();};WiFiClient.prototype.scanClicked=function(){let command={};command.scan={};this.command(command);this.console.addTextLine('Scanning networks ...');};WiFiClient.prototype.scanned=function(result){this.networksList.scaningResult(result);};WiFiClient.prototype.network=function(network){this.networksList.onNetwork(network);};WiFiClient.prototype.networkClicked=function(row){this.ssid.set(row.name.textContent);this.ssid.onchanged();};WiFiClient.prototype.dhcpChanged=function(){let dhcp=this.dhcp.value();this.enableDHCPFields(dhcp);};WiFiClient.prototype.enableDHCPFields=function(dhcp){this.ip.enable(!dhcp);this.netmask.enable(!dhcp);this.gateway.enable(!dhcp);this.dns1.enable(!dhcp);this.dns2.enable(!dhcp);if(dhcp){this.ip.esc();this.netmask.esc();this.gateway.esc();this.dns1.esc();this.dns2.esc();}};WiFiClient.prototype.log=function(params){var now=new Date(1000*params.tstm);let date=now.toLocaleDateString('en-US',TSTMP_OPTIONS);let line='['+date+'] '+params.text;this.console.addTextLine(line);};WiFiClient.prototype.validate=function(){let valid=Node.prototype.validate.call(this);let validSSID=true;if(this.ssid.changed){let SSID=this.ssid.value();validSSID=(0<SSID.length);let ssidMessage=validSSID?'':'SSID connot be empty';this.ssid.message(ssidMessage);}
let dhcp=this.dhcp.value()|0;let ip=this.ip.value();let validIP=dhcp||IPREGEX.test(ip);this.ip.message(validIP?'':'invalid address');let nm=this.netmask.value();let validNM=dhcp||IPREGEX.test(nm);this.netmask.message(validNM?'':'invalid address');let gw=this.gateway.value();let validGW=dhcp||IPREGEX.test(gw);this.gateway.message(validGW?'':'invalid address');let dns1=this.dns1.value();let validDNS1=dhcp||IPREGEX.test(dns1);this.dns1.message(validDNS1?'':'invalid address');let dns2=this.dns2.value();let validDNS2=dhcp||IPREGEX.test(dns2)||!dns2;this.dns2.message(validDNS2?'':'invalid address');let validData=validIP&&validNM&&validGW&&validDNS1&&validDNS2;return valid&&validSSID&&validData;};WiFiClient.prototype.isChanged=function(){return this.ssid.changed||this.pass.changed||this.hostname.changed||this.dhcp.changed||this.ip.changed||this.netmask.changed||this.gateway.changed||this.dns1.changed||this.dns2.changed;};WiFiClient.prototype.save=function(command){Node.prototype.save.call(this,command);let wifi=command.save={};if(this.ssid.changed||this.pass.changed){wifi.ssid=this.ssid.value();wifi.pass=this.pass.value();}
this.pass.set('');this.pass.pong('');if(this.hostname.changed)
wifi.hn=this.hostname.value();let dhcp=this.dhcp.value();if(this.dhcp.changed)
wifi.dhcp=this.dhcp.value()|0;if(this.ip.changed||(this.dhcp.changed&&!dhcp))
wifi.ip=this.ip.value();if(this.netmask.changed||(this.dhcp.changed&&!dhcp))
wifi.nm=this.netmask.value();if(this.gateway.changed||(this.dhcp.changed&&!dhcp))
wifi.gw=this.gateway.value();if(this.dns1.changed||(this.dhcp.changed&&!dhcp))
wifi.dns1=this.dns1.value();if(this.dns2.changed||(this.dhcp.changed&&!dhcp))
wifi.dns2=this.dns2.value();};let AccessPoint=function(parent,name){Node.call(this,parent,name);this.tag=document.createElement('div');this.tag.className='ChoiceRow';this.ssid=new InputRow(this,'SSID','text','');this.ssid.onkeydown=(e)=>{if(13==e.keyCode)setTimeout(this.saveClicked.bind(this),0);return true;};this.tag.append(this.ssid.tag);this.pass=new InputRow(this,'PASS','password','hidden');this.pass.onkeydown=(e)=>{if(13==e.keyCode)setTimeout(this.saveClicked.bind(this),0);return true;};this.tag.append(this.pass.tag);this.separator=document.createElement('div');this.separator.className='Separator';this.tag.append(this.separator);this.advanced=new Advanced(this,'Advanced');this.advanced.className='Advanced';this.tag.append(this.advanced.tag);this.explanation=document.createElement('div');this.explanation.className='TextContent';this.explanation.textContent='disabled options are not available in this version';this.advanced.addInput(this.explanation);this.hidden=new InputRow(this,'hidden','checkbox','');this.hidden.input.input.className='';this.advanced.addInput(this.hidden.tag);this.beacon=new InputRow(this,'beacon','number','');this.advanced.addInput(this.beacon.tag);this.stations=new InputRow(this,'max connections','select','');let stnOptions=[];for(let i=1;i<=8;i++)stnOptions.push([i,i]);this.stations.addOptions(stnOptions);this.advanced.addInput(this.stations.tag);this.channel=new InputRow(this,'channel','select','');let chnOptions=[];for(let i=1;i<=13;i++)chnOptions.push([i,i]);this.channel.addOptions(chnOptions);this.advanced.append(this.channel.tag);this.ip=new InputRow(this,'ip','text','',true);this.advanced.addInput(this.ip.tag);this.gateway=new InputRow(this,'gateway','text','',true);this.advanced.addInput(this.gateway.tag);this.netmask=new InputRow(this,'netmask','text','',true);this.advanced.addInput(this.netmask.tag);this.connections=new InputRow(this,'connections','text','',true);this.advanced.addInput(this.connections.tag);this.mac=new InputRow(this,'MAC','text','',true);this.advanced.addInput(this.mac.tag);};for(let i in Node.prototype)
AccessPoint.prototype[i]=Node.prototype[i];AccessPoint.prototype.init=function(){};AccessPoint.prototype.validate=async function(){let valid=Node.prototype.validate.call(this);let SSID=this.ssid.value();let ssidValid=(0<SSID.length);let ssidMessage=ssidValid?'':'SSID connot be empty';this.ssid.message(ssidMessage);return valid&&ssidValid;};AccessPoint.prototype.onSaved=function(pong){this.parent.hideWaiting();this.pong(pong);};AccessPoint.prototype.state=function(params){this.ssid.pong(params.ssid);this.channel.pong(params.channel);this.ip.pong(params.ip);this.hidden.pong(params.hidden);this.beacon.pong(params.beacon);this.gateway.pong(params.gw);this.netmask.pong(params.netmask);this.connections.pong(params.stations);this.mac.pong(params.mac);};AccessPoint.prototype.isChanged=function(){return this.ssid.changed||this.pass.changed||this.channel.changed||this.ip.changed||this.hidden.changed||this.beacon.changed||this.gateway.changed||this.netmask.changed;};AccessPoint.prototype.save=function(command){Node.prototype.save.call(this,command);let ap=command.save={};if(this.ssid.changed||this.pass.changed){ap.ssid=this.ssid.value();ap.pass=this.pass.value();}
this.pass.set('');this.pass.pong('');if(this.channel.changed)
ap.channel=this.channel.value()|0;if(this.hidden.changed)
ap.hidden=this.hidden.value()|0;if(this.beacon.changed)
ap.beacon=this.beacon.value()|0;if(this.ip.changed)
ap.ip=this.ip.value();if(this.gateway.changed)
ap.gateway=this.gateway.value();if(this.netmask.changed)
ap.netmask=this.netmask.value();};let Console=function(parent){this.parent=parent;this.tag=document.createElement('div');this.tag.className='Console';this.length=0;this.lines=0;this.elements=[];};Console.MAX_LINES=40;Console.prototype.init=function(data){};Console.prototype.addTextLine=function(text){let lineElement=null;if(Console.MAX_LINES>this.length){this.length+=1;lineElement=document.createElement('div');lineElement.className='Line';this.tag.append(lineElement);this.elements.push(lineElement);}else{let index=(this.lines%this.length);lineElement=this.elements[index];}
lineElement.textContent=text;lineElement.style['order']=-(this.lines++);};Console.prototype.pong=function(pong){};let System=function(parent,name){Node.call(this,parent,name);this.tag=document.createElement('div');this.tag.className='System';this.tag.node=this;this.title=document.createElement('div');this.title.className='Title';this.title.textContent='System';this.tag.append(this.title);this.separator=document.createElement('div');this.separator.className='Separator';this.tag.append(this.separator);this.up=new InputRow(this,'UP time','text','',true);this.tag.append(this.up.tag);this.version=new InputRow(this,'version','text','',true);this.tag.append(this.version.tag);this.upgradeButton=document.createElement('div');this.upgradeButton.className='Button UpgradeButton DisabledButton';this.upgradeButton.textContent='checking version ...';this.upgradeButton.onclick=this.upgrade.bind(this);this.upgradeButton.enabled=false;this.tag.append(this.upgradeButton);this.separator=document.createElement('div');this.separator.className='Separator';this.tag.append(this.separator);this.ntp=new NTP(this,'ntp');this.addNode(this.ntp);this.separator=document.createElement('div');this.separator.className='Separator';this.tag.append(this.separator);this.esps=new ESPS(this,'esp');this.addNode(this.esps);this.vurl=null;};for(let i in Node.prototype)
System.prototype[i]=Node.prototype[i];System.prototype.init=function(){};System.prototype.stateCommand=function(){let command=Node.prototype.stateCommand.call(this);command.ntp=this.ntp.stateCommand();command.esps=this.esps.stateCommand();return command;};System.prototype.state=function(params){this.loaded=true;if('version'in params)this.version.pong(params.version);if('up'in params){let up=GetUpTimeString(+params.up/1000,false);this.up.pong(up);}
if('vurl'in params){this.vurl=params.vurl;if(params.vurl){this.requestVersion();}else{this.upgradeButton.style['display']='none';}}};System.prototype.upgrade=function(){if(this.upgradeButton.enabled){let command={};command.upgrade={};this.command(command);this.parent.messages.showWaiting();}};System.prototype.upgrading=function(params){console.log(params);if(params.error){this.parent.messages.hideWaiting();switch(params.error){case 9:this.parent.messages.showMessage('HTTP UPGRADE FAILED');break;case 10:this.parent.messages.showMessage('NO UPGRADE AVAILABLE');break;case 14:this.parent.messages.showMessage('VERSION MISMATCH ERROR');break;case 16:this.parent.messages.showMessage('HTTP 404 ERROR');break;case 12:this.parent.messages.showMessage('UNABLE TO CONNECT');break;default:this.parent.messages.showMessage('UNKNOWN ERROR '+params.error);break;}}};System.prototype.onUpgraded=function(params){console.log(params);};System.prototype.requestVersion=function(){let request=new XMLHttpRequest();request.open('GET',this.vurl+'/version.php');request.onreadystatechange=()=>{if(4==request.readyState){if(200==request.status){this.onVersion(request.responseText);}}};request.onerror=(e)=>{console.log('RequestVersion: Network error, trying again ...');setTimeout(this.requestVersion.bind(this),60*1000);};request.send();};System.prototype.onVersion=function(params){try{let actual=this.version.value()|0;let version=params|0;if(version>actual){this.upgradeButton.enabled=true;this.upgradeButton.textContent=`\u267B upgrade to version ${version}`;this.upgradeButton.classList.remove('DisabledButton');}else{this.upgradeButton.enabled=false;this.upgradeButton.textContent=`system is up to date`;this.upgradeButton.classList.add('DisabledButton');}}catch(e){console.error(e,e.stack);}};let TIMEZONES=['TZ_Africa_Abidjan','TZ_Africa_Accra','TZ_Africa_Addis_Ababa','TZ_Africa_Algiers','TZ_Africa_Asmara','TZ_Africa_Bamako','TZ_Africa_Bangui','TZ_Africa_Banjul','TZ_Africa_Bissau','TZ_Africa_Blantyre','TZ_Africa_Brazzaville','TZ_Africa_Bujumbura','TZ_Africa_Cairo','TZ_Africa_Casablanca','TZ_Africa_Ceuta','TZ_Africa_Conakry','TZ_Africa_Dakar','TZ_Africa_Dar_es_Salaam','TZ_Africa_Djibouti','TZ_Africa_Douala','TZ_Africa_El_Aaiun','TZ_Africa_Freetown','TZ_Africa_Gaborone','TZ_Africa_Harare','TZ_Africa_Johannesburg','TZ_Africa_Juba','TZ_Africa_Kampala','TZ_Africa_Khartoum','TZ_Africa_Kigali','TZ_Africa_Kinshasa','TZ_Africa_Lagos','TZ_Africa_Libreville','TZ_Africa_Lome','TZ_Africa_Luanda','TZ_Africa_Lubumbashi','TZ_Africa_Lusaka','TZ_Africa_Malabo','TZ_Africa_Maputo','TZ_Africa_Maseru','TZ_Africa_Mbabane','TZ_Africa_Mogadishu','TZ_Africa_Monrovia','TZ_Africa_Nairobi','TZ_Africa_Ndjamena','TZ_Africa_Niamey','TZ_Africa_Nouakchott','TZ_Africa_Ouagadougou','TZ_Africa_PortomNovo','TZ_Africa_Sao_Tome','TZ_Africa_Tripoli','TZ_Africa_Tunis','TZ_Africa_Windhoek','TZ_America_Adak','TZ_America_Anchorage','TZ_America_Anguilla','TZ_America_Antigua','TZ_America_Araguaina','TZ_America_Argentina_Buenos_Aires','TZ_America_Argentina_Catamarca','TZ_America_Argentina_Cordoba','TZ_America_Argentina_Jujuy','TZ_America_Argentina_La_Rioja','TZ_America_Argentina_Mendoza','TZ_America_Argentina_Rio_Gallegos','TZ_America_Argentina_Salta','TZ_America_Argentina_San_Juan','TZ_America_Argentina_San_Luis','TZ_America_Argentina_Tucuman','TZ_America_Argentina_Ushuaia','TZ_America_Aruba','TZ_America_Asuncion','TZ_America_Atikokan','TZ_America_Bahia','TZ_America_Bahia_Banderas','TZ_America_Barbados','TZ_America_Belem','TZ_America_Belize','TZ_America_BlancmSablon','TZ_America_Boa_Vista','TZ_America_Bogota','TZ_America_Boise','TZ_America_Cambridge_Bay','TZ_America_Campo_Grande','TZ_America_Cancun','TZ_America_Caracas','TZ_America_Cayenne','TZ_America_Cayman','TZ_America_Chicago','TZ_America_Chihuahua','TZ_America_Costa_Rica','TZ_America_Creston','TZ_America_Cuiaba','TZ_America_Curacao','TZ_America_Danmarkshavn','TZ_America_Dawson','TZ_America_Dawson_Creek','TZ_America_Denver','TZ_America_Detroit','TZ_America_Dominica','TZ_America_Edmonton','TZ_America_Eirunepe','TZ_America_El_Salvador','TZ_America_Fortaleza','TZ_America_Fort_Nelson','TZ_America_Glace_Bay','TZ_America_Godthab','TZ_America_Goose_Bay','TZ_America_Grand_Turk','TZ_America_Grenada','TZ_America_Guadeloupe','TZ_America_Guatemala','TZ_America_Guayaquil','TZ_America_Guyana','TZ_America_Halifax','TZ_America_Havana','TZ_America_Hermosillo','TZ_America_Indiana_Indianapolis','TZ_America_Indiana_Knox','TZ_America_Indiana_Marengo','TZ_America_Indiana_Petersburg','TZ_America_Indiana_Tell_City','TZ_America_Indiana_Vevay','TZ_America_Indiana_Vincennes','TZ_America_Indiana_Winamac','TZ_America_Inuvik','TZ_America_Iqaluit','TZ_America_Jamaica','TZ_America_Juneau','TZ_America_Kentucky_Louisville','TZ_America_Kentucky_Monticello','TZ_America_Kralendijk','TZ_America_La_Paz','TZ_America_Lima','TZ_America_Los_Angeles','TZ_America_Lower_Princes','TZ_America_Maceio','TZ_America_Managua','TZ_America_Manaus','TZ_America_Marigot','TZ_America_Martinique','TZ_America_Matamoros','TZ_America_Mazatlan','TZ_America_Menominee','TZ_America_Merida','TZ_America_Metlakatla','TZ_America_Mexico_City','TZ_America_Miquelon','TZ_America_Moncton','TZ_America_Monterrey','TZ_America_Montevideo','TZ_America_Montreal','TZ_America_Montserrat','TZ_America_Nassau','TZ_America_New_York','TZ_America_Nipigon','TZ_America_Nome','TZ_America_Noronha','TZ_America_North_Dakota_Beulah','TZ_America_North_Dakota_Center','TZ_America_North_Dakota_New_Salem','TZ_America_Ojinaga','TZ_America_Panama','TZ_America_Pangnirtung','TZ_America_Paramaribo','TZ_America_Phoenix','TZ_America_PortmaumPrince','TZ_America_Port_of_Spain','TZ_America_Porto_Velho','TZ_America_Puerto_Rico','TZ_America_Punta_Arenas','TZ_America_Rainy_River','TZ_America_Rankin_Inlet','TZ_America_Recife','TZ_America_Regina','TZ_America_Resolute','TZ_America_Rio_Branco','TZ_America_Santarem','TZ_America_Santiago','TZ_America_Santo_Domingo','TZ_America_Sao_Paulo','TZ_America_Scoresbysund','TZ_America_Sitka','TZ_America_St_Barthelemy','TZ_America_St_Johns','TZ_America_St_Kitts','TZ_America_St_Lucia','TZ_America_St_Thomas','TZ_America_St_Vincent','TZ_America_Swift_Current','TZ_America_Tegucigalpa','TZ_America_Thule','TZ_America_Thunder_Bay','TZ_America_Tijuana','TZ_America_Toronto','TZ_America_Tortola','TZ_America_Vancouver','TZ_America_Whitehorse','TZ_America_Winnipeg','TZ_America_Yakutat','TZ_America_Yellowknife','TZ_Antarctica_Casey','TZ_Antarctica_Davis','TZ_Antarctica_DumontDUrville','TZ_Antarctica_Macquarie','TZ_Antarctica_Mawson','TZ_Antarctica_McMurdo','TZ_Antarctica_Palmer','TZ_Antarctica_Rothera','TZ_Antarctica_Syowa','TZ_Antarctica_Troll','TZ_Antarctica_Vostok','TZ_Arctic_Longyearbyen','TZ_Asia_Aden','TZ_Asia_Almaty','TZ_Asia_Amman','TZ_Asia_Anadyr','TZ_Asia_Aqtau','TZ_Asia_Aqtobe','TZ_Asia_Ashgabat','TZ_Asia_Atyrau','TZ_Asia_Baghdad','TZ_Asia_Bahrain','TZ_Asia_Baku','TZ_Asia_Bangkok','TZ_Asia_Barnaul','TZ_Asia_Beirut','TZ_Asia_Bishkek','TZ_Asia_Brunei','TZ_Asia_Chita','TZ_Asia_Choibalsan','TZ_Asia_Colombo','TZ_Asia_Damascus','TZ_Asia_Dhaka','TZ_Asia_Dili','TZ_Asia_Dubai','TZ_Asia_Dushanbe','TZ_Asia_Famagusta','TZ_Asia_Gaza','TZ_Asia_Hebron','TZ_Asia_Ho_Chi_Minh','TZ_Asia_Hong_Kong','TZ_Asia_Hovd','TZ_Asia_Irkutsk','TZ_Asia_Jakarta','TZ_Asia_Jayapura','TZ_Asia_Jerusalem','TZ_Asia_Kabul','TZ_Asia_Kamchatka','TZ_Asia_Karachi','TZ_Asia_Kathmandu','TZ_Asia_Khandyga','TZ_Asia_Kolkata','TZ_Asia_Krasnoyarsk','TZ_Asia_Kuala_Lumpur','TZ_Asia_Kuching','TZ_Asia_Kuwait','TZ_Asia_Macau','TZ_Asia_Magadan','TZ_Asia_Makassar','TZ_Asia_Manila','TZ_Asia_Muscat','TZ_Asia_Nicosia','TZ_Asia_Novokuznetsk','TZ_Asia_Novosibirsk','TZ_Asia_Omsk','TZ_Asia_Oral','TZ_Asia_Phnom_Penh','TZ_Asia_Pontianak','TZ_Asia_Pyongyang','TZ_Asia_Qatar','TZ_Asia_Qyzylorda','TZ_Asia_Riyadh','TZ_Asia_Sakhalin','TZ_Asia_Samarkand','TZ_Asia_Seoul','TZ_Asia_Shanghai','TZ_Asia_Singapore','TZ_Asia_Srednekolymsk','TZ_Asia_Taipei','TZ_Asia_Tashkent','TZ_Asia_Tbilisi','TZ_Asia_Tehran','TZ_Asia_Thimphu','TZ_Asia_Tokyo','TZ_Asia_Tomsk','TZ_Asia_Ulaanbaatar','TZ_Asia_Urumqi','TZ_Asia_UstmNera','TZ_Asia_Vientiane','TZ_Asia_Vladivostok','TZ_Asia_Yakutsk','TZ_Asia_Yangon','TZ_Asia_Yekaterinburg','TZ_Asia_Yerevan','TZ_Atlantic_Azores','TZ_Atlantic_Bermuda','TZ_Atlantic_Canary','TZ_Atlantic_Cape_Verde','TZ_Atlantic_Faroe','TZ_Atlantic_Madeira','TZ_Atlantic_Reykjavik','TZ_Atlantic_South_Georgia','TZ_Atlantic_Stanley','TZ_Atlantic_St_Helena','TZ_Australia_Adelaide','TZ_Australia_Brisbane','TZ_Australia_Broken_Hill','TZ_Australia_Currie','TZ_Australia_Darwin','TZ_Australia_Eucla','TZ_Australia_Hobart','TZ_Australia_Lindeman','TZ_Australia_Lord_Howe','TZ_Australia_Melbourne','TZ_Australia_Perth','TZ_Australia_Sydney','TZ_Europe_Amsterdam','TZ_Europe_Andorra','TZ_Europe_Astrakhan','TZ_Europe_Athens','TZ_Europe_Belgrade','TZ_Europe_Berlin','TZ_Europe_Bratislava','TZ_Europe_Brussels','TZ_Europe_Bucharest','TZ_Europe_Budapest','TZ_Europe_Busingen','TZ_Europe_Chisinau','TZ_Europe_Copenhagen','TZ_Europe_Dublin','TZ_Europe_Gibraltar','TZ_Europe_Guernsey','TZ_Europe_Helsinki','TZ_Europe_Isle_of_Man','TZ_Europe_Istanbul','TZ_Europe_Jersey','TZ_Europe_Kaliningrad','TZ_Europe_Kiev','TZ_Europe_Kirov','TZ_Europe_Lisbon','TZ_Europe_Ljubljana','TZ_Europe_London','TZ_Europe_Luxembourg','TZ_Europe_Madrid','TZ_Europe_Malta','TZ_Europe_Mariehamn','TZ_Europe_Minsk','TZ_Europe_Monaco','TZ_Europe_Moscow','TZ_Europe_Oslo','TZ_Europe_Paris','TZ_Europe_Podgorica','TZ_Europe_Prague','TZ_Europe_Riga','TZ_Europe_Rome','TZ_Europe_Samara','TZ_Europe_San_Marino','TZ_Europe_Sarajevo','TZ_Europe_Saratov','TZ_Europe_Simferopol','TZ_Europe_Skopje','TZ_Europe_Sofia','TZ_Europe_Stockholm','TZ_Europe_Tallinn','TZ_Europe_Tirane','TZ_Europe_Ulyanovsk','TZ_Europe_Uzhgorod','TZ_Europe_Vaduz','TZ_Europe_Vatican','TZ_Europe_Vienna','TZ_Europe_Vilnius','TZ_Europe_Volgograd','TZ_Europe_Warsaw','TZ_Europe_Zagreb','TZ_Europe_Zaporozhye','TZ_Europe_Zurich','TZ_Indian_Antananarivo','TZ_Indian_Chagos','TZ_Indian_Christmas','TZ_Indian_Cocos','TZ_Indian_Comoro','TZ_Indian_Kerguelen','TZ_Indian_Mahe','TZ_Indian_Maldives','TZ_Indian_Mauritius','TZ_Indian_Mayotte','TZ_Indian_Reunion','TZ_Pacific_Apia','TZ_Pacific_Auckland','TZ_Pacific_Bougainville','TZ_Pacific_Chatham','TZ_Pacific_Chuuk','TZ_Pacific_Easter','TZ_Pacific_Efate','TZ_Pacific_Enderbury','TZ_Pacific_Fakaofo','TZ_Pacific_Fiji ','TZ_Pacific_Funafuti','TZ_Pacific_Galapagos','TZ_Pacific_Gambier','TZ_Pacific_Guadalcanal','TZ_Pacific_Guam','TZ_Pacific_Honolulu','TZ_Pacific_Kiritimati','TZ_Pacific_Kosrae','TZ_Pacific_Kwajalein','TZ_Pacific_Majuro','TZ_Pacific_Marquesas','TZ_Pacific_Midway','TZ_Pacific_Nauru','TZ_Pacific_Niue','TZ_Pacific_Norfolk','TZ_Pacific_Noumea','TZ_Pacific_Pago_Pago','TZ_Pacific_Palau','TZ_Pacific_Pitcairn','TZ_Pacific_Pohnpei','TZ_Pacific_Port_Moresby','TZ_Pacific_Rarotonga','TZ_Pacific_Saipan','TZ_Pacific_Tahiti','TZ_Pacific_Tarawa','TZ_Pacific_Tongatapu','TZ_Pacific_Wake','TZ_Pacific_Wallis','TZ_Etc_GMT','TZ_Etc_GMTm0','TZ_Etc_GMTm1','TZ_Etc_GMTm2','TZ_Etc_GMTm3','TZ_Etc_GMTm4','TZ_Etc_GMTm5','TZ_Etc_GMTm6','TZ_Etc_GMTm7','TZ_Etc_GMTm8','TZ_Etc_GMTm9','TZ_Etc_GMTm10','TZ_Etc_GMTm11','TZ_Etc_GMTm12','TZ_Etc_GMTm13','TZ_Etc_GMTm14','TZ_Etc_GMT0','TZ_Etc_GMTp0','TZ_Etc_GMTp1','TZ_Etc_GMTp2','TZ_Etc_GMTp3','TZ_Etc_GMTp4','TZ_Etc_GMTp5','TZ_Etc_GMTp6','TZ_Etc_GMTp7','TZ_Etc_GMTp8','TZ_Etc_GMTp9','TZ_Etc_GMTp10','TZ_Etc_GMTp11','TZ_Etc_GMTp12','TZ_Etc_UCT','TZ_Etc_UTC','TZ_Etc_Greenwich','TZ_Etc_Universal','TZ_Etc_Zulu'];let NTP=function(parent,name){Node.call(this,parent,name);this.tag=document.createElement('div');this.tag.className='NTP';this.ntpConfiguration=new Advanced(this,'Network Time Protocol (NTP)');this.ntpConfiguration.className='Advanced';this.tag.append(this.ntpConfiguration.tag);this.ntpConfiguration.window.tag.classList.add('WindowOpen');this.ntpConfiguration.title.arrow.classList.add('ArrowDown');this.host=new InputRow(this,'host','text','');this.ntpConfiguration.append(this.host.tag);this.tzone=new InputRow(this,'timezone','select','');this.tzone.addOptions(NTP.TIMEZONES);this.ntpConfiguration.append(this.tzone.tag);this.now=new InputRow(this,'Local time','text','',true);this.ntpConfiguration.append(this.now.tag);};for(let i in Node.prototype)
NTP.prototype[i]=Node.prototype[i];NTP.TIMEZONES=[];for(let i=0;i<TIMEZONES.length;i++){NTP.TIMEZONES.push([TIMEZONES[i],i]);}
NTP.prototype.init=function(){};NTP.prototype.state=function(params){if('host'in params)
this.host.pong(params.host);if('tz'in params)
this.tzone.pong(params.tz);if('now'in params){this.now.pong(params.now);}};NTP.prototype.isChanged=function(){return this.host.changed||this.tzone.changed;};NTP.prototype.save=function(command){Node.prototype.save.call(this,command);let ntp=command.save={};if(this.host.changed)
ntp.host=this.host.value();if(this.tzone.changed)
ntp.tz=this.tzone.value()|0;};let ESPS=function(parent,name){Node.call(this,parent,name);this.tag=document.createElement('div');this.tag.className='ESPS';this.esp8266=new Advanced(this,'ESP8266 System');this.esp8266.className='Advanced';this.tag.append(this.esp8266.tag);this.fullv=document.createElement('div');this.fullv.classList.add('FullVersion');this.esp8266.append(this.fullv);this.id=new InputRow(this,'id','text','',true);this.esp8266.append(this.id.tag);this.cpuf=new InputRow(this,'CPU','text','',true);this.esp8266.append(this.cpuf.tag);this.heap=new InputRow(this,'heap','text','',true);this.heap.set(0);this.esp8266.append(this.heap.tag);this.heapf=new InputRow(this,'Fragmentation','text','',true);this.heapf.set(0);this.esp8266.append(this.heapf.tag);this.csize=new InputRow(this,'Chip Size','text','',true);this.csize.set(0);this.esp8266.append(this.csize.tag);this.ssize=new InputRow(this,'Sketch Size','text','',true);this.ssize.set(0);this.esp8266.append(this.ssize.tag);this.sfree=new InputRow(this,'Free Space','text','',true);this.sfree.set(0);this.esp8266.append(this.sfree.tag);this.fsize=new InputRow(this,'Flash Size','text','',true);this.fsize.set(0);this.esp8266.append(this.fsize.tag);this.flid=new InputRow(this,'Flash id','text','',true);this.esp8266.append(this.flid.tag);this.fvid=new InputRow(this,'Flash vendor','text','',true);this.esp8266.append(this.fvid.tag);this.md5=new InputRow(this,'MD5','text','',true);this.md5.set(0);this.esp8266.append(this.md5.tag);this.bootv=new InputRow(this,'boot version','text','',true);this.esp8266.append(this.bootv.tag);this.bootm=new InputRow(this,'boot mode','text','',true);this.esp8266.append(this.bootm.tag);};for(let i in Node.prototype)
ESPS.prototype[i]=Node.prototype[i];ESPS.prototype.init=function(){};ESPS.prototype.pong=function(params){};ESPS.prototype.state=function(params){if('id'in params)this.id.pong(params.id);if('fullv'in params)this.fullv.textContent=params.fullv;if('bootv'in params)this.bootv.pong(params.bootv);if('bootm'in params)this.bootm.pong(params.bootm);if('cpuf'in params)this.cpuf.pong(params.cpuf+' Mhz');if('flid'in params)this.flid.pong(params.flid);if('fvid'in params)this.fvid.pong(params.fvid);if('csize'in params)this.csize.pong(params.csize+' - '+SIZE(params.csize));if('fsize'in params)this.fsize.pong(params.fsize+' - '+SIZE(params.fsize));if('ssize'in params)this.ssize.pong(params.ssize+' - '+SIZE(params.ssize));if('md5'in params)this.md5.pong(params.md5);if('sfree'in params)this.sfree.pong(params.sfree+' - '+SIZE(params.sfree));if('heap'in params)this.heap.pong(params.heap+' - '+SIZE(params.heap));if('heapf'in params)this.heapf.pong(params.heapf+'%');};let SIZE=function(total){var size='0.00 B';if(total>0){var e=Math.floor(Math.log(total)/Math.log(1024));size=(total/Math.pow(1024,e)).toFixed(2)+' KMGTP'.charAt(e)+'b';}
return size;};let GetUpTimeString=function(d,secs){var r={};var s={years:31536000,months:2592000,days:86400,hours:3600,minutes:60,seconds:1};Object.keys(s).forEach(function(key){r[key]=Math.floor(d/s[key]);d-=r[key]*s[key];});var uptime=(0<r.years)?(r.years+'y '):'';uptime+=(0<r.months)?(r.months+'m '):'';uptime+=(0<r.days)?(r.days+'d '):'';uptime+=(0<r.hours)?(r.hours+'h '):'';uptime+=((!secs)||(0<r.minutes))?(r.minutes+'m'):'';if(!!secs){if(0<r.minutes)uptime+=' ';uptime+=(r.seconds+'s');}
return uptime;};let Wan=function(parent,name){Node.call(this,parent,name);this.tag=document.createElement('div');this.tag.className='Wan';this.tag.node=this;this.title=document.createElement('div');this.title.className='Title';this.title.textContent='WAN Settings:';this.tag.append(this.title);this.separator=document.createElement('div');this.separator.className='Separator';this.tag.append(this.separator);this.id=new InputRow(this,'Gateway ID','text','',false);this.tag.append(this.id.tag);this.signal=new Signal(this,'server');this.tag.append(this.signal.tag);this.stats=document.createElement('div');this.stats.className='TextContent';this.stats.textContent='requsting stats ...';this.tag.append(this.stats);this.ttnConfiguration=new Advanced(this,'Configuration');this.ttnConfiguration.className='Advanced';this.tag.append(this.ttnConfiguration.tag);this.host=new InputRow(this,'host','text','',false);this.ttnConfiguration.addInput(this.host.tag);this.port=new InputRow(this,'port','number','',false,5);this.port.validator=new IntegerValidator(this.port,1,65535);this.ttnConfiguration.addInput(this.port.tag);this.istat=new InputRow(this,'ping','number','');this.istat.validator=new IntegerValidator(this.istat,10);this.ttnConfiguration.addInput(this.istat.tag);this.istat.setHelp('How often, in seconds, the gateway should send a STAT packet to TTN server.');this.ipull=new InputRow(this,'pull','number','');this.ipull.validator=new IntegerValidator(this.ipull,10);this.ttnConfiguration.addInput(this.ipull.tag);this.ipull.setHelp('How often, in seconds, the gateway should send a PULL_PKT packet to TTN server..');this.desc=new InputRow(this,'Description','text','');this.ttnConfiguration.addInput(this.desc.tag);this.mail=new InputRow(this,'e-mail','text','mail@example.com');this.ttnConfiguration.addInput(this.mail.tag);this.platform=new InputRow(this,'Platform','text','ESP8266');this.ttnConfiguration.addInput(this.platform.tag);this.lon=new InputRow(this,'Longitude','number','');this.lon.validator=new FloatValidator(this.lon);this.ttnConfiguration.addInput(this.lon.tag);this.lon.validator=new FloatValidator(this.lon);this.lat=new InputRow(this,'Latitude','number','');this.lat.validator=new FloatValidator(this.lat);this.ttnConfiguration.append(this.lat.tag);this.lat.validator=new FloatValidator(this.lat);this.alt=new InputRow(this,'Altitude','number','');this.alt.validator=new FloatValidator(this.alt);this.ttnConfiguration.addInput(this.alt.tag);this.alt.validator=new FloatValidator(this.alt);this.separator=document.createElement('div');this.separator.className='Separator';this.tag.append(this.separator);this.explanation=document.createElement('div');this.explanation.className='TextContent';this.explanation.textContent='Wan Server connection console log:';this.tag.append(this.explanation);this.console=new Console();this.tag.append(this.console.tag);this.lastACK=Date.now()-(3*60*1000);this.signalCallback=null;};for(let i in Node.prototype)
Wan.prototype[i]=Node.prototype[i];Wan.prototype.init=function(data){};Wan.prototype.onmessage=function(data){this[data.n](data.p);};Wan.prototype.onSaved=function(hrdwr){this.parent.hideWaiting();this.hrdwr(hrdwr);};Wan.prototype.ack=function(params){this.lastACK=Date.now();this.log(params);};Wan.prototype.tic=function(){let ticInterval=60*1000;clearTimeout(this.signalCallback);this.ticCallback=setTimeout(this.tic.bind(this),ticInterval);this.updateSignal();};Wan.prototype.updateSignal=function(){let now=Date.now();let diff=now-this.lastACK;let maxLevel=3;let minLevel=-1;let totalLevel=maxLevel-minLevel;let timeRule=totalLevel*60*1000;let normalized=diff/timeRule;let discrette=Math.floor(normalized*totalLevel);let meassuredLevel=maxLevel-discrette;let level=Math.max(minLevel,Math.min(meassuredLevel,maxLevel));this.signal.input.setLevel(level);};Wan.prototype.log=function(params){var now=new Date(1000*params.tstm);let date=now.toLocaleDateString('en-US',TSTMP_OPTIONS);let line='['+date+'] '+params.text;this.console.addTextLine(line);};Wan.prototype.isChanged=function(command){let changed=this.id.changed||this.host.changed||this.port.changed||this.desc.changed;changed=changed||this.mail.changed||this.platform.changed||this.lon.changed;changed=changed||this.lat.changed||this.alt.changed||this.istat.changed||this.ipull.changed;return changed;};Wan.prototype.save=function(command){Node.prototype.save.call(this,command);let wan=command.save={};if(this.id.changed)wan.id=this.id.value();if(this.host.changed)wan.host=this.host.value();if(this.port.changed)wan.port=this.port.value()|0;if(this.desc.changed)wan.desc=this.desc.value();if(this.mail.changed)wan.mail=this.mail.value();if(this.platform.changed)wan.platform=this.platform.value();if(this.lon.changed)wan.lon=this.lon.value();if(this.lat.changed)wan.lat=this.lat.value();if(this.alt.changed)wan.alt=this.alt.value();if(this.istat.changed)wan.istat=1000*this.istat.value();if(this.ipull.changed)wan.ipull=1000*this.ipull.value();};Wan.prototype.state=function(wan){if('id'in wan)this.id.pong(wan.id);if('host'in wan)this.host.pong(wan.host);if('port'in wan)this.port.pong(wan.port);if('desc'in wan)this.desc.pong(wan.desc);if('mail'in wan)this.mail.pong(wan.mail);if('platform'in wan)this.platform.pong(wan.platform);if('lon'in wan)this.lon.pong(wan.lon);if('lat'in wan)this.lat.pong(wan.lat);if('alt'in wan)this.alt.pong(wan.alt);if('istat'in wan){let istat=(wan.istat/1000).toFixed(2);this.istat.pong(istat);}
if('ipull'in wan){let ipull=(wan.ipull/1000).toFixed(2);this.ipull.pong(ipull);}
if('now'in wan){let now=Date.now();let timeDiff=now-(+wan.now);this.lastACK=+wan.ack+timeDiff;this.tic();}
if(wan.stats){this.stats.textContent=`up:${wan.stats.rxnb} ::: sent:${wan.stats.rxfw} ::: down:${wan.stats.dwnb} ::: emitted:${wan.stats.txnb}`;}};Wan.prototype.pong=function(pong){};Wan.prototype.showMessage=function(message){this.parent.showMessage(message,true);};let TXPWS=[];TXPWS.push(['2 dB',2]);TXPWS.push(['3 dB',3]);TXPWS.push(['4 dB',4]);TXPWS.push(['5 dB',5]);TXPWS.push(['6 dB',6]);TXPWS.push(['7 dB',7]);TXPWS.push(['8 dB',8]);TXPWS.push(['9 dB',9]);TXPWS.push(['10 dB',10]);TXPWS.push(['11 dB',11]);TXPWS.push(['12 dB',12]);TXPWS.push(['13 dB',13]);TXPWS.push(['14 dB',14]);TXPWS.push(['15 dB',15]);TXPWS.push(['16 dB',16]);TXPWS.push(['17 dB',17]);TXPWS.push(['18 dB',18]);TXPWS.push(['19 dB',19]);TXPWS.push(['20 dB',20]);let SFACS=[];SFACS[0]=['6',6];SFACS[1]=['7',7];SFACS[2]=['8',8];SFACS[3]=['9',9];SFACS[4]=['10',10];SFACS[5]=['11',11];SFACS[6]=['12',12];let SBWS=[];SBWS[0]=['7800 Hz',7800];SBWS[1]=['10400 Hz',10400];SBWS[2]=['15600 Hz',15600];SBWS[3]=['20800 Hz',20800];SBWS[4]=['31250 Hz',31250];SBWS[5]=['41700 Hz',41700];SBWS[6]=['62500 Hz',62500];SBWS[7]=['125000 Hz',125000];SBWS[8]=['250000 Hz',250000];let CRATS=[];CRATS[0]=['5',5];CRATS[1]=['6',6];CRATS[2]=['7',7];CRATS[3]=['8',8];let RFM=function(parent,name){Node.call(this,parent,name);this.tag=document.createElement('div');this.tag.className='RFM';this.tag.node=this;this.title=document.createElement('div');this.title.className='Title';this.title.textContent='Radio Frequency Module:';this.tag.append(this.title);this.title.style.width='calc(100% - 1.2em)';this.separator=document.createElement('div');this.separator.className='Separator';this.tag.append(this.separator);this.status=new StatusRow(this,'status');this.tag.append(this.status.tag);this.status.input.label.textContent='initialized';this.status.input.point.style['background-color']='#0F0';this.freq=new InputRow(this,'Frequency MHz','text','');this.tag.append(this.freq.tag);this.freq.validator=new FloatValidator(this.freq);this.freq.setHelp('This is the frequency the Radio Frequency Module is currently operaing at.');this.configuration=new Advanced(this,'Configuration');this.configuration.tag.className='Advanced';this.tag.append(this.configuration.tag);this.minfreq=new InputRow(this,'MAX Frequency','text','');this.minfreq.tag.classList.add('Boundary');this.configuration.append(this.minfreq.tag);this.minfreq.validator=new FloatValidator(this.minfreq);this.minfreq.setHelp(`MHz min and max are the boundaries the Radio Frequency Module can operate at. TTN is going to tell the gateway the frequency it should use to emit DOWN packets, if it's outside this boundaries, the gateway will answer TTN with an 'unsupported frequency error'.`);this.maxfreq=new InputRow(this,'MIN Frequency','text','');this.maxfreq.tag.classList.add('Boundary');this.configuration.append(this.maxfreq.tag);this.maxfreq.validator=new FloatValidator(this.maxfreq);this.txpw=new InputRow(this,'TX power','select','');this.txpw.addOptions(TXPWS);this.configuration.append(this.txpw.tag);this.txpw.setHelp('This is the default power the module should emmit with.');this.cad=new InputRow(this,'CAD','checkbox','');this.cad.input.input.className='';this.cad.input.input.disabled=true;this.configuration.append(this.cad.tag);this.cad.setHelp(`CAD Stands for Channel Activity Detection, this version doesn't supoprt it, it will be added in a future release.`);this.sfac=new InputRow(this,'Spreading Factor','select','');this.sfac.addOptions(SFACS);this.configuration.append(this.sfac.tag);this.sfac.setHelp('This is the Spreading Factor the Radio Frequency Module is going to use to receive packets if CAD is turned OFF (wich in this version is still unsupported). TTN is going to tell the gateway which SF it should use to emit DOWN packets.');this.sbw=new InputRow(this,'Band Width','select','');this.sbw.addOptions(SBWS);this.configuration.append(this.sbw.tag);this.sbw.setHelp('This is the Bandwidth the Radio Frequency Module is going to use to receive packets if CAD is turned OFF (wich in this version is still unsupported). TTN is going to tell the gateway wich Bandwidth configuration it should use to emit DOWN packets.');this.plength=new InputRow(this,'Preamble Length','text','');this.plength.tag.classList.add('Short');this.configuration.append(this.plength.tag);this.plength.validator=new IntegerValidator(this.plength,1);this.plength.setHelp('This is an advanced configuration, default value should work, yet you can change it if you need.');this.sw=new InputRow(this,'Sync Word','text','');this.sw.tag.classList.add('Short');this.configuration.append(this.sw.tag);this.sw.validator=new ByteValidator(this.sw);this.sw.setHelp('This is an advanced configuration, default value should work, yet you can change it if you need.');this.pins=new Advanced(this,'PIN connections');this.pins.tag.className='Advanced Pins';this.tag.append(this.pins.tag);this.explanation=document.createElement('div');this.explanation.className='TextContent';this.explanation.textContent='PIN configuration (disabled options are not available in this version)';this.pins.append(this.explanation);this.separator=document.createElement('div');this.separator.className='Separator';this.pins.append(this.separator);this.miso=new InputRow(this,'MISO','select','',true);this.miso.addOptions(PINS);this.pins.append(this.miso.tag);this.mosi=new InputRow(this,'MOSI','select','',true);this.mosi.addOptions(PINS);this.pins.append(this.mosi.tag);this.sck=new InputRow(this,'SCK','select','',true);this.sck.addOptions(PINS);this.pins.append(this.sck.tag);this.nss=new InputRow(this,'nss','select','');this.nss.addOptions(PINS);this.pins.append(this.nss.tag);this.rst=new InputRow(this,'reset','select','');this.rst.addOptions(PINS);this.pins.append(this.rst.tag);for(let i=0;i<=5;i++){let diox=this[`dio${i}`]=new InputRow(this,`dio${i}`,'select','',!!i);diox.addOptions(PINS);this.pins.append(diox.tag);}
this.separator=document.createElement('div');this.separator.className='Separator';this.tag.append(this.separator);this.explanation=document.createElement('div');this.explanation.className='TextContent';this.explanation.textContent='Radio Frequency Module console log:';this.tag.append(this.explanation);this.console=new Console();this.tag.append(this.console.tag);};for(let i in Node.prototype)
RFM.prototype[i]=Node.prototype[i];RFM.prototype.init=function(data){this.console.addTextLine('RX/TX console v1.0');};RFM.prototype.onopen=function(){this.console.addTextLine('RFM Module console v1.0 connected');};RFM.prototype.onerror=function(error){this.console.addTextLine(''+error);};RFM.prototype.onclose=function(e){this.console.addTextLine('disconnected from server, reconnecting ...');setTimeout(this.connect.bind(this),2000);};RFM.prototype.onmessage=function(data){let name=data.n;let params=data.p;if(!(name in this)){console.log('no method found: ');console.log(data);}
this[name](params);};RFM.prototype.log=function(params){var now=new Date(1000*params.tstm);let date=now.toLocaleDateString('en-US',TSTMP_OPTIONS);let line='['+date+'] '+params.text;this.console.addTextLine(line);};RFM.prototype.isChanged=function(){let changed=this.freq.changed||this.minfreq.changed||this.maxfreq.changed||this.txpw.changed||this.sfac.changed||this.sbw.changed||this.plength.changed||this.sw.changed||this.miso.changed||this.mosi.changed||this.sck.changed||this.nss.changed||this.rst.changed;for(let i=0;i<=5;i++)
changed=changed||this[`dio${i}`].changed;return changed;};RFM.prototype.save=function(command){Node.prototype.save.call(this,command);let rfm=command.save={};rfm.freq={};rfm.freq.curr=(1000000*this.freq.value())|0;rfm.freq.min=(1000000*this.minfreq.value())|0;rfm.freq.max=(1000000*this.maxfreq.value())|0;rfm.txpw=this.txpw.value()|0;rfm.cad=0;rfm.sf=this.sfac.value()|0;rfm.sbw=this.sbw.value()|0;rfm.plength=this.plength.value();rfm.sw=this.sw.value();rfm.pins={};rfm.pins.miso=this.miso.value()|0;rfm.pins.mosi=this.mosi.value()|0;rfm.pins.sck=this.sck.value()|0;rfm.pins.nss=this.nss.value()|0;rfm.pins.rst=this.rst.value()|0;rfm.pins.dio=[];for(let i=0;i<=5;i++)
rfm.pins.dio[i]=this[`dio${i}`].value()|0;};RFM.prototype.onSaved=function(pong){this.parent.hideWaiting();this.pong(pong);};RFM.prototype.state=function(params){this.loaded=true;if('status'in params){this.status.input.label.textContent=params.status?'initialized':'stoped';this.status.input.point.style['background-color']=params.status?'#0F0':'#F00';}
if('freq'in params){this.freq.pong(params.freq.curr/1000000);this.minfreq.pong(params.freq.min/1000000);this.maxfreq.pong(params.freq.max/1000000);}
if('cad'in params){this.cad.pong(params.cad);}
if('txpw'in params){this.txpw.pong(params.txpw);}
if('sfac'in params){this.sfac.pong(params.sfac);}
if('sbw'in params){this.sbw.pong(params.sbw);}
if('plength'in params){this.plength.pong(params.plength);}
if('sw'in params){let sw=params.sw||'1';this.sw.pong('0x'+`${sw.toString(16)}`.padStart(2,'0'));}
if('pins'in params){this.miso.pong(params.pins.miso);this.mosi.pong(params.pins.mosi);this.sck.pong(params.pins.sck);this.nss.pong(params.pins.nss);this.rst.pong(params.pins.rst);for(let i=0;i<params.pins.dio.length;i++){let diox=this[`dio${i}`];if(diox){let dio=params.pins.dio[i];diox.pong(dio);}}}};RFM.prototype.showMessage=function(message){this.parent.showMessage(message,true);};let ByteValidator=function(inputRow,min=0,max=255){this.inputRow=inputRow;this.min=min;this.max=max;this.inputRow.input.input.step=1;this.inputRow.input.input.min=min;this.inputRow.input.input.max=max;};ByteValidator.prototype.validate=function(){let value=this.inputRow.value()|0;value=Math.max(this.min,Math.min(value,this.max));value=`0x${value.toString(16).padStart(2, '0')}`;this.inputRow.set(value);};ByteValidator.prototype.value=function(){let value=this.inputRow.input.input.value.trim()|0;return value;};let IPREGEX=/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;let TSTMP_OPTIONS={year:'numeric',month:'numeric',day:'numeric',hour:'numeric',minute:'numeric',second:'numeric'};let TIC_OPTIONS={year:'numeric',month:'numeric',day:'numeric',hour:'numeric',minute:'numeric'};let IP=`${location.hostname}`;let LoRaWanGateway=function(parent){NetworkNode.call(this,parent,'root',IP);this.tag=document.createElement('div');this.tag.className='Configuration LoRaWanGateway';this.login=new Login(this);this.tag.append(this.login.tag);this.app=document.createElement('div');this.app.className='App';this.tag.append(this.app);this.tabs=new Tabs(this);this.app.append(this.tabs.tag);this.nodes=document.createElement('div');this.nodes.className='Nodes';this.app.append(this.nodes);this.wifi=new WiFi(this,'wifi');this.addNode(this.wifi);this.tabs.addTab(this.wifi.tag,'WiFi',true);this.wan=new Wan(this,'wan');this.wan.tag.style['display']='none';this.addNode(this.wan);this.tabs.addTab(this.wan.tag,'WAN',false);this.rfm=new RFM(this,'rfm');this.rfm.tag.style['display']='none';this.addNode(this.rfm);this.tabs.addTab(this.rfm.tag,'RFM',false);this.system=new System(this,'system');this.system.tag.style['display']='none';this.addNode(this.system);this.tabs.addTab(this.system.tag,'System',false);this.savebutton=document.createElement('div');this.savebutton.className='Button';this.savebutton.textContent='Save Settings';this.app.append(this.savebutton);this.savebutton.onclick=this.saveClicked.bind(this);this.messages=new Messages(this);this.messages.tag.style['display']='none';this.tag.append(this.messages.tag);this.iping=15*1000;this.cping=null;};for(let i in NetworkNode.prototype)
LoRaWanGateway.prototype[i]=NetworkNode.prototype[i];LoRaWanGateway.prototype.init=function(){NetworkNode.prototype.init.call(this);this.login.init();this.wifi.init();this.system.init();this.showLogin(true);};LoRaWanGateway.prototype.addNode=function(node){this.children.push(node);this.nodes.append(node.tag);};LoRaWanGateway.prototype.showLogin=function(show){this.login.tag.style['display']=show?'':'none';this.app.style['display']=!show?'':'none';};LoRaWanGateway.prototype.setOpacity=function(opacity){this.login.tag.style['opacity']=opacity;this.app.style['opacity']=opacity;};LoRaWanGateway.prototype.onLoggedin=function(){this.showLogin(false);this.messages.showWaiting();let command={};command.wifi=this.wifi.stateCommand();this.command(command);this.ping();};LoRaWanGateway.prototype.onLoggedOut=function(){document.location.reload();};LoRaWanGateway.prototype.onConnected=function(){};LoRaWanGateway.prototype.ping=function(){let command={};command.ping={};this.command(command);clearTimeout(this.cping);this.cping=setTimeout(this.ping.bind(this),this.iping);};LoRaWanGateway.prototype.tabClicked=function(tag){let node=tag.node;if(!node.loaded){this.messages.showWaiting();let command={};command[node.name]=node.stateCommand();this.command(command);}};LoRaWanGateway.prototype.oncommand=function(command){Node.prototype.oncommand.call(this,command);this.messages.hideWaiting();};LoRaWanGateway.prototype.onSynced=function(){this.login.onSynced();};LoRaWanGateway.prototype.signin=function(user,pass){NetworkNode.prototype.signin.call(this,user,pass);this.messages.showWaiting();};LoRaWanGateway.prototype.change=function(user,pass,newUser,newPass){NetworkNode.prototype.change.call(this,user,pass,newUser,newPass);this.messages.showWaiting();};LoRaWanGateway.prototype.onLoginError=function(){this.messages.hideWaiting();this.login.onLoginError();};LoRaWanGateway.prototype.showMessage=function(message,html=false){this.messages.showMessage(message,html);};LoRaWanGateway.prototype.loggedOut=function(){this.showLogin(true);};LoRaWanGateway.prototype.saveClicked=function(){let hasChanges=this.hasChanges();if(hasChanges){let valid=this.validate();if(valid){this.messages.showWaiting();let command={};this.save(command);this.command(command);}}};window.onload=()=>{let config=document.getElementById('config');window.app=new LoRaWanGateway();config.append(window.app.tag);window.app.init();};</script>
<style>div.Configuration{width:100%}div.Waiting{position:absolute;top:0;left:0;right:0;bottom:0;background:transparent}div.Configuration div.SystemMessages{position:fixed;z-index:2;top:0;bottom:0;left:0;right:0;display:flex;justify-content:center;align-items:center}div.Configuration div.SystemMessages div.Window{position:relative;background:linear-gradient(#c9c9c9,#eee,#c9c9c9);box-shadow:0 0 1em #333;border-radius:3px;width:90%}div.Configuration div.SystemMessages div.Window div.Button{position:absolute;top:-0.5em;left:-0.65em;width:1.1em;height:1.1em;margin:0;padding:.4em;border-radius:50%;box-shadow:0 0 .2em #616161}div.Configuration div.SystemMessages div.Label{position:relative;padding:2em 2em 1em;overflow-y:auto}@keyframes RotateClock{from{transform:rotate(0)}to{transform:rotate(360deg)}}@keyframes RotateCounterClock{from{transform:rotate(0)}to{transform:rotate(-360deg)}}div.Icon{position:absolute;top:calc(50% - .5em);left:calc(50% - .5em);height:1em;width:1em;background-color:transparent;border-top:.5em solid #EEE;border-right:.5em solid #288e8e;border-bottom:.5em solid #EEE;border-left:.5em solid #288e8e;border-radius:50%;opacity:1 !important;box-shadow:var(--short-box-shadow);animation:RotateClock 2s linear infinite}div.Configuration div.SystemMessages div.Icon div.Icon{display:none;height:.5em;width:.5em;background-color:transparent;border-right:.5em solid #EEE;border-bottom:.5em solid #288e8e;border-left:.5em solid #EEE;border-top:.5em solid #288e8e;border-radius:50%;opacity:1 !important;animation:RotateCounterClock 1s linear infinite}div.PageContent div.TextContent{padding:3% 0 1% 0;text-shadow:-1px 1px #EEE;width:98%;margin:0 1%;font-size:85%;text-align:center}div.PageContent div.ChoiceRow{vertical-align:middle;text-align:left;text-shadow:-1px 1px #EEE;width:100%;text-align:center}div.ContentWraper{max-width:70vh}div.NetworksList{width:calc(98% - 4px);text-align:left;margin:1em 1%}div.NetworkRows{width:100%;height:calc(9em - 8px);overflow-y:auto;overflow-x:hidden;transition:height .3s;vertical-align:middle;box-shadow:var(--short-box-shadow);background-color:rgba(50,50,50,0.1)}div.NetworkRowsHidden{height:0}div.NetworkRow{width:100%;height:2em;line-height:2em;cursor:pointer}div.NetworkRow:hover{background-color:rgba(255,255,255,0.2)}div.NetworkRow:hover:active{background-color:rgba(255,255,255,0.4)}div.NetworkRow div.Name{width:calc(98% - 2em - 2em);margin:.5% 1%}div.NetworksList div.Button{padding:0 !important;margin:.5em !important;max-width:5em;height:2em;line-height:2em;width:5em;vertical-align:middle}div.NetworksList div.Messages{text-align:right;width:calc(100% - 1% - 1em - 5em);color:#888;font-style:italic}div.Advanced{width:100%;margin:1em 0 .5em}div.Advanced div.Window{width:100%;max-height:0;transition:max-height .3s;overflow:hidden;margin:1em 0 0 0}div.Advanced div.WindowOpen{max-height:100vh !important}div.Advanced div.Title{width:100%;cursor:pointer;font-weight:bold;font-style:italic;text-align:left;text-indent:1em}div.Advanced div.Title div.Label{vertical-align:middle;text-align:left;text-indent:1em}div.Advanced div.Title div.Arrow{border-left:.6em solid #888;border-right:0;border-bottom:.4em solid transparent;border-top:.4em solid transparent;transition:transform .3s;vertical-align:middle}div.Advanced div.Title div.ArrowDown{transform:rotateZ(90deg)}div.Separator{width:calc(100% - 1em);margin:.5em .5em;border-top:1px solid #AAA;border-bottom:1px solid #CCC}.Button{background:linear-gradient(var(--light-color) 25%,var(--dark-color) 80%);box-shadow:var(--short-box-shadow);text-shadow:none;text-align:center;font-weight:bold;color:white;cursor:pointer;user-select:none;-moz-user-select:none;-webkit-user-select:none;-ms-user-select:none;border:1px solid #777;padding:1em 0;margin:1em .5em;width:calc(100% - 1em - 2px)}div.Input .Button{padding:.5em 0;margin:0;width:95%}.Button:hover:active{background:linear-gradient(var(--dark-color) 15%,var(--light-color) 80%)}div.DisabledButton{background:linear-gradient(#b9b9b9 5%,#656565 60%)}div.DisabledButton:hover:active{background:linear-gradient(#656565 5%,#b9b9b9 60%)}div.Configuration div.Change{cursor:pointer;padding:.5em 0;margin:1% calc(50% - 7em);font-size:80%;width:14em;color:#DDD;text-shadow:none;user-select:none}div.InputRow{width:100%;margin:.5em 0}div.InputRow div.Name{vertical-align:middle;text-align:right;width:28%;padding:0 2% 0 0}div.InputRow div.Input div.Value{text-align:left;width:98%;padding:0 2% 0 0}div.InputRow div.Input{vertical-align:middle;text-align:left;width:calc(70% - 1.5em)}div.InputRow div.Input input{text-align:center;padding:.3em 0}div.InputRow div.Input input.Large{width:95%;max-width:25em}div.InputRow div.Input input.Short{width:40%}div.Help{width:1em;background-color:#288e8e;border-radius:40%;padding:.1em;box-shadow:0 0 1px #555;color:white;cursor:pointer;text-shadow:-1px 1px #333;text-align:center}div.InputRow div.Help:hover{background-color:#3cacac}div.InputRow div.Input div.Messages{position:absolute;bottom:100%;left:0;right:0;width:100%;font-size:.7em;color:red}div.InputRow div.Input div.Value{font-style:italic}div.InputRow div.Input div.Point{position:absolute;width:5px;height:5px;top:calc(50% - 2.5px);bottom:calc(50% - 2.5px);border-radius:50%;background-color:#F00;box-shadow:0 0 3px #272}div.InputRow div.Input div.Label{text-indent:10px}div.SignalIcon{--swidth:2em;--sheight:1em;height:var(--sheight);width:var(--swidth)}div.SignalIcon div.Bar{position:absolute;width:.3em;bottom:0;background-color:grey;border-top:1px solid #BBB;border-left:1px solid #BBB;border-right:1px solid #777;border-bottom:1px solid #777;box-shadow:0 0 1px #111}div.SignalIcon div.B01{height:.25em;left:.1em}div.SignalIcon div.B02{height:.5em;left:.6em}div.SignalIcon div.B03{height:.75em;left:1.1em}div.SignalIcon div.B04{height:1em;left:1.6em}div.PageContent div.Tabs{vertical-align:middle;text-shadow:-1px 1px #EEE;width:100%;text-align:center;overflow:hidden;display:flex}div.Tab{display:flex;cursor:pointer;background-color:rgba(0,0,0,0.2);padding:.75em 0;flex-grow:1;justify-content:center}div.Selected{background-color:transparent}div.SwitchButton{width:10em;height:3em;vertical-align:middle;cursor:pointer}div.SwitchButton div.Background{position:absolute;top:38%;bottom:38%;left:10%;right:10%;background-color:#f6f6f6;border-radius:3px;box-shadow:inset 0 0 4px #777;cursor:pointer}div.SwitchButton div.Circle{position:absolute;top:.5em;bottom:.5em;background-color:red;cursor:pointer;border-radius:50%;box-shadow:0 0 5px #777;transition:left .2s,right .2s}div.SwitchButton div.CircleON{right:5%;left:calc(95% - 2em);background-image:radial-gradient(circle,yellow,#f06d06)}div.SwitchButton div.CircleOFF{left:5%;right:calc(95% - 2em);background-image:radial-gradient(circle,#cacaca,#847a73)}div.SwitchButton div.Waiting{left:calc(50% - 1em);right:calc(50% - 1em);background-image:radial-gradient(circle,#cacaca,#847a73)}body{margin:0;padding:0;color:#555;background-color:#ebebda;--short-box-shadow:0 0 3px #111;--light-color:#288e8e;--dark-color:#1f5e5e}div{position:relative;display:inline-block}input{text-align:center}h1{font-size:5vw;text-align:center}div.header{width:100%;background:linear-gradient(#145a5a,#288e8e);box-shadow:0 0 4px #222}.logo_colour{color:#cc9514}div.header,div.header div.logo,div.header div.logo div.title{display:flex;justify-content:center;align-items:center}div.header div.logo div.title{color:#555;font-size:1.5em;padding:.25em 0;font-family:monospace;color:white;font-style:italic;font-weight:bold}@media(orientation:portrait){div.header div.logo div.title{font-size:1.25em}}@media(orientation:landscape){div.header div.logo div.title{font-size:1.5em}}div.PageContent{width:calc(100% - 2px - 1em);margin:.5em;text-align:center;background-color:#BBB;border:1px solid #CCC}div.PageContent div.ContentMarc{padding:0;color:#555;width:100%;font-family:Arial,Helvetica,Sans-serif;background:linear-gradient(#c9c9c9,#eee,#c9c9c9);box-shadow:0 0 5px #777}@media(orientation:portrait){div.PageContent{width:calc(100% - 2px);margin:.5em 0}}div.ContentFooter{width:100%;display:flex;flex-wrap:wrap;justify-content:center}div.ContentFooter div.TextContent{width:100%}div.ContentFooter div.CopyR{width:100%;font-size:80%;margin:1em 0}div.ContentFooter div.FooterLogo{width:80%;max-width:25em}div.ContentWraper{width:100%;margin:0;max-width:130vh}div.Configuration div.Selected{background-color:transparent;font-weight:bold;border-top:1px solid #EEE;border-right:1px solid #CCC;border-left:1px solid #EEE;border-bottom:1px solid transparent;box-shadow:0 0 4px #7d7d7d}div.Configuration div.Title{width:100%;text-align:left;margin:3% 0 .5%;font-weight:bold;text-indent:.5em}div.Configuration div.WiFi div.Tabs{margin:1em 0;overflow:hidden}div.Configuration div.WiFi div.Tabs div.Tab{width:calc(50% - 8px);border-bottom:1px solid #EEE;margin-top:4px;margin-bottom:-1px}div.Configuration div.WiFi div.Tabs div.T00{border-radius:5px 0 0 0;margin-left:4px}div.Configuration div.WiFi div.Tabs div.T01{border-radius:0 5px 0 0;margin-right:4px}div.WiFiClient{width:100%}div.WiFiClient div.DisconnectButton{width:8em;margin:0;padding:.5em;margin-left:calc(100% - 11em);font-size:80%}div.Console{display:flex;flex-direction:column-reverse;width:calc(100% - 1em);margin:0 .5em;height:10em;background-color:white;box-shadow:0 0 5px #888;text-align:left;font-family:monospace;font-size:85%;overflow-y:auto}div.Console div.Line{width:99%;margin:.5%}div.System{width:100%}div.System div.FullVersion{font-family:monospace;font-size:90%}div.System div.UpgradeButton{width:100%;max-width:15em;padding:.5em 0;margin:.25em 0 .5em}div.NTP{width:calc(100% - 3px);margin:1% 0;padding:3px;text-align:center}div.ESPS{width:calc(100% - 3px);margin:1% 0;padding:3px;text-align:center}div.ESPS div.FullVersion,div.ESPS div.FullVersion div.Input input{width:calc(100% - 6px);max-width:initial;text-align:center}div.ESPS div.FullVersion div.Name{display:none}div.ESPS div.FullVersion div.Input{width:100%;margin:initial;padding:initial}div.ESPS div.FullVersion div.Input input{background:transparent;border-color:transparent}div.Wan{width:100%}div.RFM{width:100%}div.RFM div.InputRow div.Name{width:38%}div.RFM div.InputRow div.Input{width:calc(60% - 1.2em)}div.Boundary input,div.Boundary{font-style:italic}div.Boundary div.Name{font-style:italic}div.Boundary div.Input input.Large{color:#555}div.Pins div.InputRow{width:50%}</style>
		
				
		<meta name='viewport' content='width=device-width, initial-scale=1, user-scalable=no'/>
		<title>Configuration</title>
		<link rel='shortcut icon' href=''>

			</head>
	<body>
		<div class='header'>
			<div class='logo'>
				<div class='title'>pulsartronic.com</div>
			</div>
		</div>
		<div class='PageContent'>
			<div class='ContentMarc'>
				<div class='ContentWraper' id='config'></div>
				<div class="ContentFooter">
					<div class="TextContent">PULSARTRONIC.COM</div>
					<div class="FooterLogo">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 459 459" version="1.1"width="100%" height="100%"><g><g id="memory"><path style="fill:#288e8e;"d="M306,153H153v153h153V153z M255,255h-51v-51h51V255z M459,204v-51h-51v-51c0-28.05-22.95-51-51-51h-51V0h-51v51h-51V0h-51 v51h-51c-28.05,0-51,22.95-51,51v51H0v51h51v51H0v51h51v51c0,28.05,22.95,51,51,51h51v51h51v-51h51v51h51v-51h51 c28.05,0,51-22.95,51-51v-51h51v-51h-51v-51H459z M357,357H102V102h255V357z"/></g></g></svg>
					</div>
					<div class="CopyR">
						copyright © 2019 - <span id="Year"></span><script>document.getElementById('Year').textContent = ((new Date()).getFullYear())</script> | pulsartronic.com | all rights reserved
					<div>
				</div>
			</div>
		</div>
	</body>
</html>


)"""";
