# Labels used at Public Lab :label:
At Public Lab, we use labels to categorize and keep up with issues and pull requests.

We use these labels to mainly help our reviewers/maintainers review our work and also, these labels keep our **plots2** repository organized.

Before contributing to the organization, one should be aware of these and keep them in mind while creating any issues or pull requests.

## Issue labels
For keeping the issues in a systematic way, we use labels which describe the type of issue, the  ` programming language ` used in the issue and so on.
Some of the most used labels are:-
* ` help-wanted ` which indicates the issue requires help by anyone willing to contribute.
* ` first-timers-only ` which are meant to welcome newcomers in the community. They need to be well-formatted using the *[First-timers Issue Template](https://github.com/publiclab/plots2/blob/main/.github/ISSUE_TEMPLATE/--first-timers-only.md)*. :tada: :smiley:
* ` fto-candidate ` issues are issues which are meant to be solved by **first timers** but they aren't well-formatted. These issues can be converted into ` first-timers-only ` issues using the friendly template.
* ` bug ` which tells that the issue is regarding one of our programs which faces problems when a certain task is executed. :bug:
* ` enhancement ` explains that the issue is to improve upon one of our existing features. :bulb:
* ` planning ` - These issues can be used as a place for discussion on a long term or a big project. :computer:
* ` break-me-up ` says that this certain issue could be and should be broken into smaller self-contained projects for cleaner code separation, more discrete tests, and, easier and iterative collaboration.
* ` add-code-links `/` more-detail-please ` tells the issue lacks proper description and perhaps needs code links or the location of the problem. :link:
* Labels like ` HTML ` , ` CSS ` , ` Ruby ` and ` JavaScript ` tell the **programming language** of the issue.
* ` design ` - This says that the issue requires more design work and discussion (i.e. mockups and sketches).
* ` documentation ` - This tells that a certain feature lacks proper documentation or needs more documents. :orange_book:
* ` testing ` - These issues are usually for adding `unit tests`, `integration tests` or any other tests for a particular feature/program. :heavy_check_mark:
* ` outreach ` - The outreach issues involve community involvement and helping people who're stuck somewhere. :tada: :raising_hand_man:
* Some issues have been labeled with ` summer-of-code ` , ` outreachy ` , ` first-timers-only `, ` gci-candidate ` and ` rgsoc ` which mean that these issues have been reserved for students who're participating in these events.
* ` discussion `/` brainstorm ` - Issues that need discussion and requirements need to be elucidated. :brain:
* ` hacktoberfest ` - These are issues opened for the month-long global celebration of open-source run by [Digital Ocean](https://hacktoberfest.digitalocean.com/) to encourage people to contribute to open-source projects.

## Pull request labels
For faster review and adoption, we add labels to pull requests too.
Some commonly used PR labels are:-
* ` work-in-progress `/` in-progress ` - This indicates that the pull request is still being worked upon.
* ` needs-help ` - This says that someone is stuck somewhere and needs help to figure that out.
* ` ready-for-review `/` review-me ` - This means seeking for review from Public Lab reviewers.
* ` readytomerge `/` ready ` - This means that the PR is ready for a merge.

For pull requests marked with **work in progress**/**in progress**, **needs-help**, or **review-me**/**ready-for-review**, here's a checklist of things you can ask for to help a project towards completion:

  * 🎉 encouragement 😄 👍
  * 🔗 links to original issues that they solve with fixes #0000 format in issue body
  * ✍️ more descriptive titles (for quick scanning down a list)
  * 🐞 debugging (if Travis tests did not pass)
  * 👩‍💻 any tips/suggestions on the code itself -- especially simplifying or reducing repetition, increasing readability
  * ✔️ tests to safeguard the new code
  * 📸 screenshots please, if it includes a new design or behavior!
