# This file should contain all the record creation needed to seed the database with its default values.
# The data can then be loaded with the rake db:seed (or created alongside the db with db:setup).
#
# Examples:
#
#   cities = City.create([{ name: 'Chicago' }, { name: 'Copenhagen' }])
#   Mayor.create(name: 'Emanuel', city: cities.first)

# set up a tag for all_notes subscription
everything_tag = Tag.create! "name"=>"everything", "description"=>"", "weight"=>0

# set up 3 basic users: admin, mod, and user
admin = User.create! "username" => "admin",
  "email" => "admin@example.com",
  "status" => 1,
  "openid_identifier" => nil,
  "password" => "password",
  "password_confirmation" => "password"
admin.role = "admin"
admin.save()

mod = User.create! "username" => "moderator",
  "email" => "moderator@example.com",
  "status" => 1,
  "password" => "password",
  "password_confirmation" => "password"
mod.role = "moderator"
mod.save({})

basic_user = User.create! "username" => "user",
  "email" => "user@example.com",
  "status" => 1,
  "password" => "password",
  "password_confirmation" => "password"
basic_user.role = "basic"
basic_user.save({})

# set up some records, otherwise rails will throw errors on visiting these pages
%w{about media events getting-started donate stats licenses}.each do |page|
  web_page = Node.create! "type"=>"page", "title"=>page.capitalize, "uid"=>admin.id,
    "status"=>1, "comment"=>0, "cached_likes"=>0
  #web_node_counter = DrupalNodeCounter.create! "nid"=>web_page.nid,
    #"totalcount"=>1
  web_node_revisions = Revision.create! "nid"=>web_page.nid,
    "uid"=>admin.uid, "title"=>page.capitalize, "body"=>"#{page} - page", "teaser"=>"",
    "log"=>"", "format"=>1
end

# set up a blog entry with a comment and a like
blog_post = Node.create! "type"=>"note", "title"=>"Blog Post", "uid"=>admin.id,
  "status"=>1, "comment"=>1, "cached_likes"=>1
blog_post_revisions = Revision.create! "nid"=>blog_post.nid,
    "uid"=>admin.uid, "title"=>"Blog Post", "body"=>"Blog post body", "teaser"=>"",
    "log"=>"", "format"=>1
blog_post_tag = Tag.create! "name"=>"blog", "description"=>"", "weight"=>0
blog_post_community_tag = NodeTag.create! "tid"=>blog_post_tag.id,
  "nid"=>blog_post.id, "uid"=>admin.id
blog_post_comment = Comment.create! "nid"=>blog_post.id, "uid"=>admin.id,
  "subject"=>"", "comment"=>"Example Comment\r\n", "hostname"=>"", "status"=>1,
  "format"=>1, "thread"=>"01/"

# Create 35 maps for the /maps sections
35.times do |t|
  map_node = Node.create! "type"=>"map", "title"=>"test map #{t}", "uid"=>1,
    "status"=>1
  map_node_revision =  Revision.create! "nid" => map_node.nid, "vid" => map_node.nid,
    "uid"=>1, "title"=>"Test Map #{t}", "body"=>"Body of revision #{t}" 
  tag_lat = Tag.create! name: "lat:#{rand(80)}", description: "Desc #{t}", weight: 5
  tag_lon = Tag.create! name: "lon:#{rand(80)}", description: "Desc #{t}", weight: 5
  comm_tag_lat = NodeTag.create! nid: map_node.nid, tid: tag_lat.tid, uid: 1
  comm_tag_lon = NodeTag.create! nid: map_node.nid, tid: tag_lon.tid, uid: 1
  content_type_mape = DrupalContentTypeMap.create! "vid"=>map_node.nid,
    "nid"=>map_node.nid, "field_publication_date_value"=>Time.now.to_s(:short),
    "field_capture_date_value"=>Time.now.to_s(:short),
    "field_tms_url_value"=>"https://archive.publiclaboratory.org/leaflet/?\
    tms=https://archive.publiclab.org/2013/2013-04-15-us-massachusetts-plum-\
    island/tms/&lon=-70.80848&lat=42.7952&zoom=16", "field_license_value"=>"publicdomain",
    "field_raw_images_value"=>"", "field_cartographer_notes_value"=>"No notes",
    "field_notes_value"=>"No note value",  "field_zoom_min_value"=>1,
    "field_zoom_max_value"=>14, "authorship"=>"Admin"
end

# create a bunch of random tags
tagnames = ['one', 'two', 'three', 'four', 'five', 'six']
80.times { try { Node.find(rand(Node.count-2)+1).add_tag(tagnames[rand(tagnames.length-1)],User.first) } }
# Create a footer message
footer_feature = Node.create! "type"=>"feature", "title"=>"footer-notice", "uid"=>admin.id
Revision.create! "nid"=>footer_feature.nid, "uid"=>admin.uid, "title"=>"footer-notice", "body"=>"The footer is empty during local development", "teaser"=>"", "log"=>"", "format"=>1
# Create home intro message
home_intro_feature = Node.create! "type"=>"feature", "title"=>"home-intro", "uid"=>admin.id
Revision.create! "nid"=>home_intro_feature.nid, "uid"=>admin.uid, "title"=>"home-intro",
                  "body"=>"Welcome to the plots2 application!
                  This message is displayed only to developers running the code in a development environment (normally it's the front page content!).
                  To use a lot of the features on this site, even locally, you'll have to <a href='/login'>log in</a>. Default username and password are
                  username: admin, moderator, or user and password: password. If you run into trouble, please reach out at https://publiclab.org/chat or in our getting started issue at https://github.com/publiclab/plots2/issues/3840 .
                  To test UI changes related to 'Translation-System' please login and 'Switch on Translation' from the drop-down menu visible on hoverig over profile picture in top navigation bar, then navigate to <a href='/change_locale/es'>/change_locale/es</a> (for spanish, for example) to change languages.",
                  "teaser"=>"", "log"=>"", "format"=>1
