# PublicLab - Hacktoberfest
Welcome to PublicLab! This document contains all the information you need to contribute to PublicLab during Hacktoberfest. Make sure that you follow the quality standards to make it easier for maintainers and contributors to accept your Pull Requests (PRs)! For an overview of how our Code Community works together, see [https://code.publiclab.org/](https://code.publiclab.org).

## Hacktoberfest Values
- All people are invited to participate! There is no prerequisite needed per-say, and we are always here to help! Remember that our community has people from all over the world and have unique skills. If you have any questions at any time, feel free to ping us on [Gitter](https://publiclab.org/chat) or the [Weekly Check-Ins](https://github.com/publiclab/plots2/issues?q=is%3Aissue+weekly+community+check+in) on GitHub.
- We would love to see many PRs coming from you - however, make sure that they fit the quality guidelines (see below). PRs which are made just for the sake of completing Hacktoberfest hurt both the maintainers and the contributors. As the Hacktoberfest website eloquently puts it, “Quantity is fun; quality is key.”
- The code you contribute doesn’t end just in October - it ends up being used by hundreds of thousands of people worldwide. Although Hacktoberfest ends in a month, the open-source community doesn’t. We all welcome you to become part of the PublicLab community, even after October!

## About PublicLab
PublicLab is a community and non-profit that aims to democratise science to address environmental issues affecting people. We pursue ecological justice through community science and open source. We raise awareness about health impacts, improve the scientific agency, build new scientific and technological skills, and mitigate certain exposures.

Read more about us [here](https://publiclab.org/about).

## Hacktoberfest Issues
All contributors, please keep in mind the following points before working on particular issues:
- All issues that will be considered a part of Hacktoberfest will have the "__Hacktoberfest__" label.
- If there is an issue you are interested in working on, please comment on the issue so that we and any future contributors are aware. This is necessary so that at the end of the day, two people don’t work on the same issue and submit two different PRs.
- If there has been no recent activity on an issue for some time, ping the person who had last claimed it, asking if they are still working on it. If they aren’t, you are free to take up the issue for yourself!

We also encourage you to raise new issues! We constantly strive to improve PublicLab, and you can help by pointing out issues.
- Make sure that you abide by the new issue guideline that is available when you open one.
- Provide as much information about the bug you can. If it is a UI bug, please provide some screenshots. If there is some issue while setting it up on your local system, provide server logs so that we can help out!
- If you notice an issue, we encourage you to open it first and get it approved by the maintainers. Opening a PR without doing this may result in it being marked as spam.

If there are any other problems you face - for example, while setting up the project on your local system - the fastest way to resolve it would be by dropping a message on the Gitter chat. Someone from the community will respond ASAP. Raising an issue on GitHub for these reasons is generally discouraged.

If you face any issues with the local installation, try using Gitpod instead!

__If there are any security issues that you uncover, DO NOT post them on GitHub. Send a message on Gitter saying that you have found a security issue, and one of the maintainers will personally message you.__

## Hacktoberfest Pull Requests
Before making any PR, make sure you read the contributing docs (CONTRIBUTING.md).
- Fork the PublicLab repo that you want to work on.
- Make sure that you work on a new branch for every new issue. That way, it is easier to manage various PRs simultaneously.

While making a PR, keep in mind the following:
- The PR must contain commits you made yourself. We will not accept automated commits from bots.
- We only accept changes solving a particular issue and the specific code changes mentioned within the issue. We will not merge any change outside of this scope.
- When you find an issue, we encourage you to open it first and get it approved by the maintainers. Opening a PR without doing this may result in it being marked as spam.

When you make a PR, the contents are auto-populated on GitHub. Try to fill as many fields as you can so that reviewers can quickly check your PR. Remember to mention the issue that is resolved by the PR.

Usually, the issues that we have assigned for Hacktoberfest will be done with a few lines of code. If you do have any questions, feel free to ask. Please refrain from making PRs that do not have any substance, just to boost your PR count. It hurts both you and us as a community, and no one ends up benefiting from it. For more information, refer to [this page](https://hacktoberfest.digitalocean.com/resources/qualitystandards) and [this one](https://hacktoberfestswaglist.com/contributing).

Please do not keep pinging maintainers on GitHub or Gitter. We expect there to be many PRs, and it will take us some time to review and respond to every one of them. However, if it has been a few days and you haven’t heard anything, post a link to your PR in the Gitter chat, and someone will review it.

We hope you enjoy your experience with Hacktoberfest and with PublicLab. Hope to see you around, and good luck!