Hi, this is a [first-timers-only issue](https://code.publiclab.org/#r=all). This means we've worked to make it more legible to folks who either **haven't contributed to our codebase before, or even folks who haven't contributed to open source before**.

If that's you, we're interested in helping you take the first step and can answer questions and help you out as you do. Note that we're especially interested in contributions from people from underrepresented groups in free and open-source software!

We know that the process of creating a pull request is one of the biggest barrier for new contributors. This issue is for you 💝

If you have contributed before, **consider leaving this one for someone new**, and looking through our general [help wanted](https://github.com/publiclab/plots2/labels/help-wanted) issues. Thanks!

### 🤔 What you will need to know.

Nothing. This issue is meant to welcome you to Open Source :) We are happy to walk you through the process.

### 📋 Step by Step

- [ ] 🙋 **Claim this issue**: Claim the issue by commenting. If someone else has claimed it, ask if they've opened a pull request already and if they're stuck -- maybe you can help them solve a problem or move it along!
<details>
  <summary>💡 <i>Learn how to claim</i> 🙋</summary>
  <h3>Claiming an issue</h3>
  <p>Unless the issue is marked as reserved for someone, you can just say "I'd like to try this!" and then you've claimed it - no need to wait for someone to assign it to you. Just be sure you link your pull request (PR) to this issue so we can see where your solution is.</p>
  <p>And open one early if possible - even before you've completed it with additional commits - and others can help you figure out any issues you may face.</p>
</details>

- [ ] 📝 **Update** the file [$FILENAME]($BRANCH_URL) in the `$REPO` repository (press the little pen Icon) and edit the line as shown below.

[See this page](https://code.publiclab.org/#r=all) for some help in taking your first steps!

Below is a "diff" showing in red (and a `-`) which lines to remove, and in green (and a `+`) which lines to add:

```diff
$DIFF
```

- [ ] 💾 **Commit** your changes

- [ ] 🔀 **Start a Pull Request**. There are two ways how you can start a pull request:

1. If you are not familiar with GitHub or the pull request model, [here is a guide you can follow](https://guides.github.com/activities/hello-world/) on how GitHub works.
2. If you are familiar with the terminal or would like to learn to use it, [here is a great tutorial](https://egghead.io/series/how-to-contribute-to-an-open-source-project-on-github) on how to send a pull request using the terminal.

3. You can also [edit files directly in your browser](https://help.github.com/articles/editing-files-in-your-repository/) and open a pull request from there.

- [ ] 🏁 **Done** Ask in the comments for a review :)

### Please keep us updated

💬⏰ - We encourage contributors to be respectful to the community and provide an update **within a week** of claiming a first-timers-only issue. We're happy to keep it assigned to you as long as you need if you update us with a request for more time or help, but if we don't see any activity a week after you claim it we may reassign it to give someone else a chance. Thank you in advance!

If this happens to you, don't sweat it! Grab another open issue.

### Is someone else already working on this?

🔗- We encourage contributors to link to the original issue in their pull request so all users can easily see if someone's already started on it.

👥- **If someone seems stuck, offer them some help!** Otherwise, [take a look at some other issues you can help with](https://code.publiclab.org/#r=all). Thanks!

### 🤔❓ Questions?

Leave a comment below, and [reach out in our chatroom](https://publiclab.org/chat)!
