# 个人工具箱（2024 年 7 月 29 日更新）

## 前言

***Note: Developing an Astro website for this yu-tools project —— 「[tools.pseudoyu.com](https://tools.pseudoyu.com/)」.***

自己一直是个工具控，也一直信奉着“工欲善其事，必先利其器”的理念，总是不断折腾和优化自己的硬件与软件，针对自己的一个特定需求会试图找到最优解，现在也慢慢找到了最适合自己使用习惯的解决方案。因为工作、学习和个人兴趣，设备经过很多次迭代，在这个时间节点作一下记录，后续也会不断更新，希望能够对其他人有所参考。

> 注：下文所提及的所有软件服务均为本人购买/订阅或学生资格所享有的教育授权，请支持正版！

## 主要设备

![yu_new_desk_setup](https://image.pseudoyu.com/images/yu_new_desk_setup.jpg)

### :computer: 电脑及配件

- **Apple Mac Studio (2022)，M1 Max，64GB RAM，1T SSD**，家里主力电脑，疫情在家很提升工作学习幸福感
- **Apple MacBook Pro (14-inch, 2023) 银色，M2 Max，64GB RAM，1T SSD**，因为出门比较多，还是用公司的设备津贴添置了 14 寸，确实比 16 带出去负担小多了
- **Apple MacBook Pro (16-inch，2019) 银色，2.4 GHz 八核 Intel Core i9，32GB RAM，2T SSD**，~~高频使用，基本走哪都会背着，在公司外接显示屏使用~~，原本高频使用，后来因为 Intel 的续航和散热各种实在有点痛苦，更新了 M 芯片后闲置了，放在家里接了个显示器
- **Google Pixelbook Go 黑色，Intel Core i7，16GB RAM, 256GB Storage**，~~最近打算把自己业余学习项目以及 Crypto 相关的转到瘦客户端开发的模式，闲鱼淘了一个，真不错，配置了基本开发环境~~，后面也还是很少用到，给家人带去公司轻度办公使用
- **Raspberry Pi 3B+，1.4GHz 四核 ARM Cortex-A53，1G RAM，64 GB MicroSD**，~~几年前折腾的树莓派，最近寄来了，现在 SSH 连接作为一个开发机使用~~，配置有点老了，基本上放着当装饰了，有考虑要不要入个 4b 系列的
- **戴尔 U2720Q 4K 显示器**，又新增了一个显示器，屏幕素质和色彩比明基好，感觉 27 寸也比较足够了，现在主要配合 Mac Studio 使用
- **几硕 FlipGo 16 寸，Pro 版本**，当作 Obsidian 记笔记、终端以及 ChatGPT 专用屏使用
- **明基（BenQ）EW3270U 4K 显示器**，，在这个价位的 4K 里已经很不错了，现在连着之前 Intel 的 16 寸 MBP 用
- **明基（BenQ）ScreenBar Halo 屏幕挂灯**，有了这个后基本上家里没开过主光源了，可以无线控制调节，很有氛围感
- **HHKB Professional Hybrid Type-S 双模静音版键盘，白色有刻**，有点重，但是外出算是不错的选择，自己添置了一个键盘亚克力垫
- **Leopold FC660C 45g 静音版，灰白**，终于集齐了静电容三大经典，有线的所以长期连家里的 Mac Studio
- **Xikii Industry 瀚文 75 客制化键盘，高能制造局限定款**，和 B 站联名的小粉键盘，现在放在家里的 MBP 上用
- **NuPhy Air60 无线键盘**，厂家寄过来的，手感一般但是颜值很高，不过后面还是主要用 HHKB，不过确实真的很轻便，还刚好能卡在 MBP 上
- ~~**RealForce PFU 联名版 87 键，黑色**，备用键盘，也是静电容经典了，但是没有很习惯，可能后面玩游戏会用，毕竟 HHKB 键位特殊~~，寄给朋友了
- ~~**MM-Studio Class65 V2 客制化双模机械键盘，复古白**~~，原本想通过这把入坑客制化，但是没心情折腾了，等了三个月发团，刚到手就原价转卖了
- **Apple Magic Keyboard 键盘，白色**，开始用 HHKB 后闲置了
- **Logitech MX Master 3 鼠标，灰色**，主力鼠标，手感和侧键功能都很棒，配合剪视频也很棒
- **Apple Magic Mouse 2 鼠标，白色**，手感不太行，闲置了
- **Apple Magic Trackpad 触控板，白色**，在家配合着鼠标使用，体验感不错
- **闪极 100W Pro 氮化镓 GaN 充电器，黄色**，外出携带，终于摆脱了苹果 96w 的大块头充电器
- **闪极全透明移动电源**，收到的礼物，很酷炫，不过据说很容易有划痕，当艺术品摆着了
- **制糖磁吸无线充电座**，和谜底时钟的联名款，用来无线充电和当支架体验不错，但是感觉充 AirPods Pro 有点发热，最近也比较少用了
- **制糖 120w 小电拼**，贴在家里书桌凳子下面，多口确实很方便，不过感觉电流声有点重
- **制糖 35w DIY 充电头**，收到的礼物，上面画了一只章鱼

### :iphone: 手机及平板

- **Apple iPhone 13 蓝色，256GB**，主力手机，配合苹果全家桶体验很好，不过手机基本上戒了，主要就用作沟通和看看资讯，应该很久都不会换了
- **OnePlus 7 Pro，6.67"，Snapdragon 855，256GB**，之前在香港的时候刷机 Root 了，配合 Google 全家桶很适合留学用，而且拍照风格很自然，不过现在也很少用了
- ~~**Apple iPad Air (第三代)，256GB**，主要用来作拓展屏或者放视频了，很少作什么生产力工具使用，大部分电脑能做的都不会放到 iPad 上做~~，给我妹妹用了

### :movie_camera: 相机及配件

- **Sony A7M3 微单相机，黑色**，大学攒了好久才买的第一台微单，摄影和视频都很全能，跟着我好多年了，到现在依然很够用
- **Sony 24-105mm F4 相机镜头**，跟相机一起买的，出门基本上这一只大师镜头就足够应对绝大多数场景，虽然光圈只有 F4，但是成像品质真的高
- **Sony 55mm F1.8 蔡司相机镜头**，收到的礼物，也是最喜欢的定焦镜头，主要用来拍人像
- **Sony ZV-1 II Vlog 相机**，更多为了记录生活买的，确实带出去心智负担小很多，调了和 A7M3 一样的图像配置来保证画面一致
- **罗德 Wireless Go 无线麦克风**，之前录视频用得比较多，便携易用，声音也很不错，后面会考虑多录一些视频
- **DJI RS 3**，相机稳定器，之前用过如影 S，但是体验一般，终于第三代了，打算开始拍一些视频
- **Shure MV7**，桌面麦克风，打算用来录制一些自媒体视频和课程等

### :headphones: 音箱及耳机

- **Apple Airpods 耳机**，很老的版本了，不过戴着确实会更无感一些
- ~~**Apple Airpods Pro 降噪耳机**，原本不太习惯入耳式，后来体验了降噪后就离不开了~~，给家人用了
- **Apple HomePod mini 音箱**，家里电脑主要输出设备，家里 Mac Studio 和显示器自带音质都不太行
- **Divoom Ditoo 像素复古音箱**，收到的礼物，现在放在桌面作装饰，基本上没放过音乐
- **小爱智能音箱**，联动家里的各类智能家居

### :package: 存储设备

- **三星 T5 SSD，1TB**，主要用来存储摄影和视频素材，很小，传输速度很快
- **希捷移动硬盘，1TB**，Mac Studio 用来 Time Machine 备份使用的

### 🎮 休闲娱乐

- **Kindle Oasis 2 电子书阅读器**，以前看得比较多，现在基本上看实体书以及手机 Books 上看
- **Nintendo Switch 主机，动物森友会特别版**，主要用来玩宝可梦，[从 18 年开始陆陆续续也买了不少游戏](https://pseudoyu.notion.site/f5f9e6e31b4744a7a1284eaf55451462?v=6e3be0ced2f44305b9ff3a8298e72de5)，很多都还没来得及玩，卡带收藏爱好者
- **Steam Deck 512G**，收到的礼物，填补了我没有 Win 主机来玩游戏的设备空缺，不过其实一直没什么空玩，现在 OLED 版本都出了
- **Nintendo Switch Pro 手柄，任天堂明星大乱斗特别版**，体验感比自带的 Joy-Con 好多了
- **Pokemon Go Plus**，记录自己睡眠，原本也有手机 app，但是得一直开着很耗电所以买来单独记录了
- **Apple TV, 4K 港版**，家里目前使用的电视盒子，主要配合 Infuse 来用，以及直接看 HBO Max

## 软件工具

![my_softwares_in_may_2022](https://image.pseudoyu.com/images/my_softwares_in_may_2022.png)

### 🛠 系统拓展

- **CleanMyMac X**，电脑管家，主要用来清理缓存和软件卸载
- **AppCleaner**，功能很单一的应用卸载工具
- **One Switch**，菜单栏快捷工具，主要用来组织电脑休眠使用的
- **Alfred 4**，快捷启动工具，配合一些 Workflow 功能很丰富，现在主要还用了它的剪贴板历史功能
- **Raycast**，另一款强大的快捷启动工具，主要提供了一些多应用拓展支持，与 Alfred 4 配合使用
- **Hammperspoon**，~~主要用来通过 `Option + hjkl` 组合键来弥补 HHKB 没有上下左右键的一些场景~~，现在基本上也不怎么用了，也有了一些其他更方便的映射方案了
- **Bartender 4**，菜单栏管理工具，主要隐藏一些软件服务菜单栏图标
- **BetterTouchTool**，触控板及 Touchbar 管理，主要给 Macbook Pro 配置触控版用的
- **yabai + skhd**，开源的 Mac 窗口管理工具，通过多桌面+自动分屏+配置 vim-like 的快捷键来进行手动管理，体验感很好，~~弃用了 Magnet 和 BetterTouchTool 附带的窗口吸附功能~~，后来有点不兼容新版本，又改回了 BetterTouchTool
- ~~**Magnet**，分屏工具，已弃用~~
- ~~**AltTab**，和 Windows 体验一致的多窗口切换工具，可以选择同个应用的多个不同项目~~，后来类似的需求用 Manico 替代了
- **iStat Menus**，系统状态显示，主要显示 CPU、内存和网络等状态
- **AirBuddy**，耳机管理工具，感觉连接耳机更顺滑了一些
- **HazeOver**，桌面效果工具，显示效果很不错，但是后面配合 stage manager 之后会有些干扰，也不用了
- **Plash**，动态桌面拓展，在主屏幕放了一个简约的动态时间显示，也几乎不耗资源
- **Activate**，~~一个模拟未激活 Windows 系统的的工具~~，尝鲜了一下后不怎么用了
- **DaisyDisk**，磁盘管理，偶尔用来追踪大文件
- **Menubar X**，菜单栏网页拓展，之前偶尔挂一些小工具，现在用得也少了
- **Logi Options+**，罗技配置工具，配置鼠标功能按键用的，不过基本上用的默认值
- **MonitorControl**，开源的显示屏亮度管理工具，因为家里 Mac Studio 是用的外接显示器，不能直接键盘或者设置调节，这个完美解决
- **CheatSheet**，长按 Command 键就可以显示所有的快捷键，也可以直接点击调用
- **Syntax Highlight**，一个开源的预览拓展，通过空格能够对一些编程语言进行语法高亮，简单预览可以不用打开编辑器了
- **TinderTool**，一个免费的系统设置拓展工具，提供了很多实用的额外配置，我主要用来去除截图阴影
- **KeyCastr**，一个开源的键盘按键显示工具，比如按下对应的键会显示，用于录制一些教程
- **Dockface**，一个在 Dock 栏显示系统状态的小拓展工具，Surge 的作者做的，体验了一下还挺有意思
- ~~**Maccy**，一个开源的剪贴板工具，很简约，不过感觉我还是更适应 Alfred 的操作逻辑，还在适应看看~~，目前还是回归了 Alfred
- **RunCat**，一个在菜单栏跑动的小猫，显示系统运行状态的，挺有意思的一个小组件
- **Manico**，~~快捷键设置应用启动，听说了好多年最近才真正用上~~，用 Raycast 内置的快捷键配置功能实现了
- **Rewind**，一个记录和检索电脑行为的 AI 应用，感觉兼具了检索和 Time Machine 这样的文件备份功能，还有会议自动总结，每日行为这样的功能，体验了一阵子很有意思，不过其实还没有过多真正有生产力的用途，更多是尝鲜
- **Command X**，一个为 macos 提供文件剪切功能的拓展
- **Hyperduck**，用 ios 端发送应用到 macOS，替代隔空传送
- **HEIC Converter**，把 iPhone 拍出来的图片转成比较通用的 png/jpg 格式
- **Top Notch**，终于还是受不了 MBP 的刘海了，用这个工具把刘海隐藏了
- **Applite**，用于管理 homebrew casks 安装的软件，可以自动更新和卸载
- **IconChamp**，一个 App 图标管理软件，不怎么更新了，也有 bug，但是貌似是唯一可用的应用

### 📁 文件管理

- **OneDrive**，5TB 空间，存储大部分个人数据，通过客户端挂载本地目录来同步，速度不错
- **iCloud**，200GB 空间，主要用于照片备份与软件数据同步
- **Dropbox**，2GB 空间，主要配合 Cryptomator 对敏感数据加密备份
- **IPFS Desktop**，去中心化存储，主要还是连接本地文件下载，目前还没有持续运行
- ~~**坚果云**，用来同步简悦配置和文档~~，放弃简悦了）
- ~~**阿里云盘**，主要用来保存一些影视、剧集资源~~，不怎么用了
- ~~**Google Drive**，1TB 空间~~，因学校从 Google 服务转向 Microsoft 服务，已弃用
- ~~**百度网盘**，存储影音及备份工具~~，以前存储大量视频剪辑文件用，已弃用

### 🔐 安全工具

- **ElPass**，密码管理工具，界面很喜欢，OTP 以及 Server 管理功能很惊艳，现在所有帐号、密码、证件和银行卡都在这里管理了，用 iCloud 和 Dropbox 进行同步和备份
- **GPG Keychain**，macOS GPG 加密工具客户端，主要用来为 Git 提交进行签名
- **Cryptomator**，文件目录加密工具，用于加密备份证件等隐私数据，配合网盘使用
- ~~**DAMA**，图片隐私打码工具，通过 TestFlight 尝鲜了测试版~~，后面好像不更新了

### 🌏 网络工具

- **Surge**，网络代理、调试工具，家里的 Mac Studio 通过 Surge 来作为家里 Wifi 的 DHCP 服务器，接管家里的网络实现全网代理，主要给 iPad 访问外网以及 Switch 下载游戏加速用
- **AdGuard Home**，通过网络流量过滤与 DNS 实现去广告，很强大
- **ClashX**，网络代理工具，买 Surge 前主力用的，现在留了一个备用线路
- ~~**Tunnelblick**，openvpn 客户端，连接公司内网服务器使用~~，换工作后不用了
- ~~**OpenVPN Connect**，openvpn 客户端，不过经常会让我电脑断网~~，还是换成 Tunnelblick 了
- **VNC Viewer**，远程桌面工具，用来连接树莓派显示桌面
- **Arc**，最近刚更换为 Arc，使用体验很好，Chrome 迁移没什么成本
  - **AdGuard**，去广告插件
  - **MetaMask**，钱包插件
  - **Elpass**，自动填充密码
  - ~~**简悦 + 同步助手**，通过插件记录稍后读和批注，并且增加了简悦自动同步的工作流，摘录的语句会自动同步到 Logseq 中~~，弃用了，全面拥抱 Readwise
  - **豆伴**，备份和查看豆瓣数据
  - **YouTube Dual Subtitles**，支持多语言字幕
  - **YouTubeEnhancer**，增强 YouTube 播放器功能
  - **React Developer Tool**，在浏览器中使用 React 开发工具
  - **Quick source viewer**，便捷格式化查看源码插件
  - **IPFS Companion**，去中心化存储，主要用来查看 IPFS 网页
  - **uBlacklist**，屏蔽一些推广营销的搜索结果，规则用的是『[GitHub - cobaltdisco/Google-Chinese-Results-Blocklist](https://github.com/cobaltdisco/Google-Chinese-Results-Blocklist)』
  - **Instapaper**，稍后读应用，保存一些比较精品的文章
  - **LanguageTool**，语法检查插件
  - **ClearURLs**，去掉链接里的各种应用跟踪参数的
  - **Immersive Translate**，双语对照的英文翻译插件，owen 做的，作为早期支持者送了一年的会员，更多还是用 DeepL，偶尔用 ChatGPT 翻译
  - **MetaDock**，增加区块链浏览器信息的插件
  - **Minimal Theme for Twitter / X**，精简 Twitter 界面
  - **Not yet, AV1**，去掉 AV1 播放格式，忘记为什么装了，用起来比较无感
  - **Notepal**，同步微信读书的笔记到 Readwise，Randy 做的，很依赖这个来管理我的读书信息
  - **Pinboard Tools**，添加书签到 pinboard 平台的，换了 Arc 后发现还是插件版本好用一点，直接直接用菜单栏 js 的
  - **Readwise Highlighter**，用来给文章添加收藏和加批注的
  - **Refgen**，复制的时候去掉后面的链接并且转换为 markdown 格式的小工具，reorx 做的
  - **RSSHub Radar**，检测当前页面 RSSHub 链接
  - **Time Tower**，记录在各个网页上花的时间，类似于 Wakatime/RescueTime，但是完全本地化
- ~~**Chrome**，因为开始用 Chromebook，所以把主力浏览器换成了 Chrome~~，只有 Chromebook 还在用，其他的设备切换为 Arc 了，插件同上
- ~~**Safari**，~~主力~~辅助浏览器，通过 iCloud 多设备同步~~，改用 Arc 后电脑端完全弃用了，手机还是在用
  - **AdGuard Home**，去广告插件
  - **Elpass**，自动填充密码
  - **Downie**，下载插件，一键识别媒体并下载
  - **NetNewsWire**，自动抓取网站订阅链接
  - **Vinegar+Baking Soda**，把 YouTube 以及其他一些视频网站的视频播放器转回 HTML5 播放器，简约，体验感很不错
  - **uBlacklist**，屏蔽一些推广营销的搜索结果，规则用的是『[GitHub - cobaltdisco/Google-Chinese-Results-Blocklist](https://github.com/cobaltdisco/Google-Chinese-Results-Blocklist)』
  - **Instapaper Save**，稍后读应用，保存一些比较精品的文章
  - **LanguageTool**，语法检查插件
- **Brave**，主要用来调试合约使用

### 🧰 实用工具

- **Bob**，划词/截图翻译工具，配合 [DeepL X 拓展插件](https://github.com/clubxdev/bob-plugin-deeplx)和 [zu1k](https://zu1k.com) 大佬发布的 [DeepL Free Api Docker 镜像](https://github.com/zu1k/deepl-api-rs)，完美体验，后面还更新了独立的 OCR 功能，更强大了
- **Tern-Subtitle File Translator**，我配合了 IBM 提供的 API，进行字幕自动中英翻译
- ~~**qBittorrent**，通过 RSS 管理器来订阅特定 PT 站的番剧等媒体资源，自动更新下载~~，订阅了流媒体后用得比较少
- **Downie**，视频源下载工具，下载 YouTube 或者 B 站的一些视频，作剪辑素材用
- **PicGo**，图床管理工具，主要写博客的时候上传图片到 GitHub 图床并且生成自定义的 Markdown 格式，可以直接嵌入文章
- **BetterZip**，压缩/解压工具，基本上装机必备了，目前遇到的格式都支持了
- **PDF Expert**，PDF 查看编辑工具，主要用来做一些合并和编辑，查看的话经常还是用自带的 Preview
- **PDF Squeezer**，PDF 压缩工具，压缩效果很不错，使用也很方便
- **TinyPNG4Mac**，之前博客图片上传前都会压一下，功能很简单，操作也比较方便
- **Image Smith**，图片压缩工具，很不错，但是作为博客上传来说没有 TinyPNG4Mac 方便，备用
- **Rime 鼠须管**，定制化输入法，体验很好且数据本地保存，安全稳定
- **Input Source Pro**，输入法自动切换软件，可以为不同应用/网页自动切换输入法
- **Time Machine**，备份工具，主要给 Mac Studio 作实时备份用
- **brew**，Homebrew 安装工具，基本上开发有关的都用 brew 装了，方便管理升级
- **TestFlight**，尝鲜一些测试版软件用
- **DropZone 4**，一个菜单栏工具，可以把文件暂存，之后统一发送或者整理，也可以利用一些拓展功能进行例如图片压缩、上传云盘和服务器等，对比了另一款 Dropover 还是更喜欢这个的设计和功能，免费功能就完全足够了
- **CleanShot X**，一个强大的截图拓展工具，因为我经常写一些教程，这个可以做一些额外编辑以及录屏这些，还可以分享到云端
- **Hazel 5**，自动化同步 macOS 文件，用来把坚果云的简悦目录同步到 Logseq 目录，后来也利用自动化整理下载文件夹便于清理
- **numi**，基于文本的计算器，用了免费版来计算汇率
- **Noise Smith**，白噪音工具，可以自己组合各种声音，适合做背景音
- **Raspberry Pi Imager**，给树莓派制作镜像的官方工具
- **LanguageTool**，一个类似于 Grammarly 的语法检查工具，使用了一下感觉不错
- ~~**Adobe Acrobat**，有了 Adobe 的正版授权，就装上了，那么多年过去居然还是感觉很卡~~，Preview + PDF Expert 完全够用了
- ~~**图压**，刚看到一个新的压缩工具，据说比 TinyPNG 好用，看起来可配置项比较多，会试试~~，还是更喜欢
- ~~**ChatGPT**，ChatGPT 的 macOS 端，整体使用比网页端稳定一些~~
- **QuickGPT**，一个 macOS 端的 GPT 套壳应用，使用起来很轻量
- **Amazing AI**，通过 Apple M 芯片绘图的应用，用的 Stable Diffusion，很有意思
- **Aiko**，音频转译工具
- **Whisper Transciption**，同样是音频转文字，但是支持很多生成格式，也有对 Podcast 的处理
- **ChatGPT**，用上了官方客户端，配合 Plus 体验良好
- **Haye.ai**，朋友「[STRRL](https://x.com/strrlthedev)」开发的 AI 助手工具，经常用来翻译和优化语言

### 📝 记录工具

- **Logseq**，现在主力的生活记录、任务管理和笔记工具，基于双向链接打造了自己的信息管理系统，而且通过 Journal 以文本条目的形式记录没有心智负担，建议可以看一下 [Randy](https://lutaonan.com) 的 <[我如何使用 Logseq 管理我的生活和笔记](https://www.bilibili.com/video/BV1X44y1K7X1)>，很有启发；还增加了简悦自动同步的工作流，摘录的语句会自动同步到 Logseq 中，方便查看
- **Obsidian**，因为更好的插件生态和 markdown 编辑体验，最近在迁移，主要参照「[How I use Obsidian](https://macwright.com/2024/06/16/how-i-use-obsidian)」这篇进行配置
- **Notion**，原本作笔记和任务管理，后来都迁移到了 Logseq，所以就只作为软件订阅管理、游戏记录的一些工具，数据库还是很强大的
- **Hook**，文件资源双向链接工具，目前主要用来追踪本地的一些视频之类的大文件，可以以链接的形式嵌入到 Logseq 里
- **Office 365**，主要文档/PPT/表格处理工具，其实工作后已经主要都是 Markdown 写为主了，但是最后还是得通过 Word 来排版
- **iWork 全家桶**，Apple 自带文档处理工具
- **Typora**，主要 Markdown 编辑器，最完美的 Markdown 编辑器了，偶尔要转存一些文本的时候也会通过 Alfred 唤出来
- ~~**妙言**，[tw93](https://github.com/tw93) 大佬开发的 Markdown 编辑器，比较简约，尝试一下~~，后来没在用了
- ~~**Nota**，一个正处于 beta 阶段的很强大的所见即所得 Markdown 编辑器，正在探索新功能~~，后来没在用了
- **MarginNote 3**，用来阅读一些论文、书籍的工具，用得不算很多
- ~~**XMind8 Pro**，主要思维导图工具，之前在学校的时候做笔记用的比较多，工作后反而系统性学习整理得少了，需要保持习惯~~，偶尔使用还是用 logseq 插件或者是 Heptabase 内置的
- **Pinboard**，老牌的书签管理工具，结合 n8n 自动化记录到我的 [Telegram 频道里](https://t.me/pseudoyulife)，方便查看
- ~~**Craft**，趁黑五五折订阅了 Pro 会员，其实笔记倒是不需要，已经完全在 Logseq 了，没有迁移的打算，这个主要想用来替代腾讯文档这些的，又不想用飞书，一直想体验下~~，还是有点用不习惯，可能没有太多在线协作的需求
- **Heptabase**，最近开始尝试的一个白板笔记应用，~~很惊喜~~，其实用了快一年了，还是觉得太重，不打算续订了

### 👨🏻‍💻 开发工具

- 编辑器
  - **JetBrains GoLand**，主力工作 Go 开发 IDE，很强大，目前用 Edu 身份订阅着全家桶，希望后面能通过开源项目续着
    - ~~**IntelliJ New UI**，尝试一下预览版的 UI，舒服多了~~
    - **Material Theme UI + Atom Material Icons**，很美观的主题
    - **GitHub Copilot**，代码 AI 补全，很智能
    - **GitToolBox**，提示一些 Git 状态信息
    - **IdeaVim**，配置 Vim 键位
    - ~~**PlantUML Integration**，用来画 UML 图，目前感觉写和预览体验最好的平台了~~
    - **WakaTime**，用来记录编码项目、语言和所用时间
  - **JetBrains RustRover**，开始写 Rust 用的，确实比 VS Code 配置起来要方便和强大多了
    - **Material Theme UI + Atom Material Icons**，很美观的主题
    - **GitHub Copilot**，代码 AI 补全，很智能
    - **GitToolBox**，提示一些 Git 状态信息
    - **IdeaVim**，配置 Vim 键位
    - **WakaTime**，用来记录编码项目、语言和所用时间
  - **VS Code**，代码编辑工具，辅助开发
    - **Serendipity**，新尝试的一个很喜欢的主题
    - **GitHub Copilot**，代码 AI 补全，重度依赖
    - **GitLens**，增加 Git 提交状态提示及拓展其他功能
    - **Beancount**，用来复式记账，配合 fava 工具进行可视化
    - **Markdown All in One**，用来增强对 Markdown 的支持，主要用来写博客
    - **Rainbow Brackets**，给配对的括号加上颜色
    - **go**，Go 语言环境支持
    - **rust-analyzer**，实时编译和分析 Rust 代码，提示代码中的错误，并对类型进行标注
    - **rust syntax**，rust 语法高亮
    - **crates**，分析当前项目的依赖是否是最新版本
    - **better toml**，语法高亮，并展示 toml 文件中的错误
    - **rust test lens**，快速运行某个 Rust 测试
    - **Solidity + HardHat**，Solidity 本地编写的语法高亮与格式化支持，HardHat 支持
    - ~~**solidity**，智能合约编写支持，用了上一个，弃用了~~
    - **WakaTime**，用来记录编码项目、语言和所用时间
    - **Activitus Bar**，隐藏活动栏，在状态栏中展示
    - **ES7+ React/Redux/React-Native snippets**，React 代码快捷提示插件
    - **PostCSS Language Support**，CSS 调整的语言支持
    - **Tailwind CSS IntelliSense**，Tailwind CSS 的代码提示
  - ~~**Atom**，完全转向 VS Code，所以也不用了，体验差太多了~~
  - ~~**JetBrains PyCharm Professional Edition**，Python 编辑器，现在不怎么永乐~~
  - **Xcode**，macOS 及 iOS 开发 IDE
    - **CopilotForXcode**，GitHub Copilot 的 Xcode 插件
  - **Codux**，一个 React IDE，写前端的时候试试
  - ~~**Fleet**，申请了快一年的内测，等到了公测，但目前连插件市场都没有（体验了一下有点失望）~~
- 终端
  - **iTerm2**，之前一直用，现在主要用来切多个服务器，~~作为主力终端了~~
  - **Warp**，新尝试的 Rust 编写的终端，体验感很棒，~~果然还是更喜欢自己折腾的方案~~，因为成熟的体验和新增了很多 AI 功能又换回来了
  - **NeoVim**，~~配置了 GitHub Copilot 等，尝试转移自己的开发流程到 Vim~~，转移失败，下次再试试
  - **Alacritty**，一个简洁可定制的终端工具，不怎么用了，有点重复
  - **X-CMD**，朋友 [niracler](https://t.me/niracler_channel) 在做的一个工具，最近重装电脑后打算尝试用这个来搭建自己的整套命令行环境
- 服务器管理
  - **ssh**，配合 Warp 和 iTerm2 的 Profile 来连接服务器用
  - **Termius**，服务器管理工具，主要是可以云端同步配置，跟公司同事调试测试的时候都不需要自己再配本地环境，比较方便，然后也使用 SFTP 来传文件
  - **ServerCat**，服务器状态监控，界面很不错
  - **Fetch**，备用远程文件传输工具，很老牌了
- 数据库管理
  - **TablePlus**，主力数据库管理工具，可以连 MySQL 和 PostgreSQL，支持多种数据库，界面好看，比较方便
  - **Sequel Ace**，备用数据库管理工具，是之前开源版本 Sequel Pro 的一个维护版本，界面简约但是功能很强大
  - **JetBrains DataGrip**，主要通过 Groovy 脚本来自动导出数据库的 Markdown 文件，很方便写文档
  - **Arctype**，最近新发现的一个的一个很好看的数据库管理工具，支持 MySQL 和 PostgreSQL，主要的特色是可以建立多个 workspaces，比起单纯的分组能更好地管理项目
- 接口调试
  - **Paw/RapidAPI**，主力接口调试工具，限免的时候注册的，速度很快，多环境以及分支管理很强大，后面改名了
  - **Bruno**，一个新的有意思的接口调试工具，还是有些功能残缺，但也能够满足基本的需求
  - ~~**HTTPie**，是个很有名的命令行工具，我获得了 Mac App 版的测试资格，界面真好看~~，尝鲜一下，主力还是 RapidAPI
  - ~~**Postman**，以前用的接口调试工具，但是界面太繁杂了，而且反应有点慢，弃用了~~
- 文档查看: **Dash**，配合 Alfred 查文档很方便
- 容器
  - **Orb Stack**，经过了一阵子的使用，用 Orb Stack 代替了下述所有的了，很稳定，界面也很好看
  - **Colima**，~~一个容器工具，以命令行的形式来管理容器，方便且占用资源少~~，完全用 Orb Stack 替代了
  - **Docker Desktop**，~~虽然占资源很高，但是确实方便。原本弃用了，但是由于使用项目使用 docker 的 Buildx 特性还是恢复使用了~~,Orb Stack 替代了
  - **Minikube**，打算考一下 CKAD，搭建本地 k8s 集群环境用的
- 绘图工具
  - **PlantUML**，配合 GoLand 里插件通过语法画流程图，修改和版本维护很方便
  - **Excalidraw**，一个更美观的架构图绘制工具，在线版本就很好用
  - **Draw.io**，一些很复杂的架构图和部署图通过这个客户端画，有点简陋但是够用
- 版本控制
  - **git**，版本管理工具
    - [git-cz](https://github.com/commitizen/cz-cli)，交互式规范化提交信息
    - [git-chglog](https://github.com/git-chglog/git-chglog)，用来自动生成格式化 CHANGELOG
    - [git-delta](https://github.com/dandavison/delta)，git 语法输出语法高亮工具
  - **GitHub**，我的个人博客、图床以及开发项目都通过 GitHub 管理，后面工作也转向 GitHub 进行管理
  - **GitKraken**，~~GitHub Education 送的，界面还不错，偶尔看看~~，还是更习惯命令行
  - **Tower**，~~GitHub Education 送的~~，几乎没用过
  - ~~**Fork**，git 客户端工具（已弃用，改为命令行配合 alias）~~
  - ~~**GitLab**，工作项目通过公司 GitLab 进行管理~~，换工作后不用了
- 实用工具
  - **DevUtils**，最近项目里频繁用到 json 格式化和时间戳转换，总是搜索在线工具很麻烦，趁着黑五入手了，感觉不错！
  - **CodeSpeedy**，~~Randy 开发的一个可以管理和同步代码片段并同步到 VSCode 的工具~~，不用了

### 📹 视频剪辑

- **Final Cut Pro X**，当时优惠价买了全家桶，从 PR 转到了 FCPX 作为主力剪辑工具，在 macOS 上比 PR 体验好多了
- **Davince Resolve**，之前学过一点但是主要用的还是 FCPX，重新学一下，免费版就差不多
- **Adobe Premiere Pro 2023**，以前用了三四年 PR 转到了 FCPX，但是留着偶尔处理一些复杂效果还不错
- **Adobe After Effect 2023**，至今没学明白，本科的时候很想搞特效，但是没好好学
- **Adobe Media Encoder 2023**，这个倒是真的很好用，当时 PR 压制一堆视频的时候全靠这个了
- **Adobe Audition 2023**，Mac 上确实没有什么很好的音频处理工具，Logic Pro 感觉有点大材小用且复杂度有点高，做一些基本的声音处理 AU 还是更强的
- **剪映专业版**，语音识别智能匹配字幕的功能很强大，3.0 版本还支持导出 `.srt` 格式了，再通过一个开源的 [srt2fcpxml](https://github.com/GanymedeNil/srt2fcpxml) 工具转回 FCPX 兼容的的字幕格式导入回 FCPX，简化字幕制作工作流，再也不用自己一点点对时间轴了
- **Compressor**，主力压制工具，配合 FCPX 一些预设可以很便捷联动导出
- **HandBrake**，备用开源视频压制工具，作一些简单压缩转码使用了
- **大拍档剪辑助手**，用来清理 FCPX 的缓存，也有一些无版权音乐下载、素材管理的小工具

### 📷 图片处理

- **Affinity Photo**，替代 Photoshop 的修图和调色工具，我拍完照后会用来处理和套 Luts
- **Pixelmator Pro**，黑五半价买的，据说很强大，不过还没怎么用
- **Luminar 4**，做一些简单的效果处理会比 Affinity Photo 更便捷
- **Adobe Photoshop 2023**，以前重度依赖，之前为了教一个朋友又重新学了一下，不过大部分日常需求我都用 Affinity Photo 了
- **Adobe illustration 2023**，编辑矢量图的，以前弄过一点字体，也没深度用过
- **Adobe InDesign 2023**，用来排版的，不过感觉自己还是用 Photoshop 做更习惯

### 📮 邮件管理

- **Mail**，Apple 自带邮件客户端，回归原生了
- **Alimail**，工作用邮箱
- **Outlook**，主要用来管理 Office365 开发者帐号
- ~~**Spark**，电子邮件聚合工具，多端同步也很快，现在所有邮箱都通过 Spark 来管理了，突然学校邮箱登录不上了，而且好像升级订阅制了，舍弃了~~

### 📨 信息管理

- **Telegram + n8n**，个人信息流聚合系统，把自己的 Twitter、YouTube、GitHub、豆瓣、Spotify 资讯聚合到个人群组里，方便梳理和记录
- ~~**NetNewsWire**，RSS 订阅工具，多端同步很方便，慢慢转向 RSS 为自己的主要信息输入了（改成了自建的网页版 Miniflux）~~
- ~~**Spring**，尝试的新推特客户端，不过感觉消息通知这一块有点问题，还在体验（因为 API 问题失效了）~~
- ~~**TweetBot**，在电脑端用来发布和刷 Twitter 的客户端，主要是可以通过时间轴排列，用 Spring 完全替代了~~
- **Books**，Apple 自带图书应用，可导入 epub 或 pdf 文件阅读
- 域名及个人网站
  - **GitHub Pages**，配合 GitHub Action 实现自动部署
  - **Cloudflare**，管理域名，以及对网站进行 CDN 加速
  - **Vercel**，配合 Railway 的数据库部署了博客的 Cusdis 评论系统
  - **Railway**，也是一个 PaaS 平台，部署了 Cusdis 的数据库和 umami 全套网站数据统计系统
- [**豆瓣**](https://www.douban.com/people/pseudo-yu)，通过 GitHub Action 每天抓取豆瓣提供的 RSS，统计我的影音和书籍并更新到 GitHub 主页和个人网站介绍页里，也通过 Chrome 的一个叫“豆伴”的插件来定时备份和导出
- **Notion Calendar/Cron**，主要用来管理自己 Google Calendar 上的日程

### 💬 通讯社交

- **微信**，生活和工作大部分都还是会通过微信沟通
- ~~**Texts**，一个可以聚合多个平台的即时通讯管理工具，如 Telegram、Twitter 私信、Discord、领英等，可以不用开那么多了~~，后来用得相对也少一点了，功能上还是不能代替掉所有的原有客户端，就没必要多开了
- **Telegram**，新建了[个人频道](https://t.me/pseudoyulife)，添加了自己的信息流自动化系统，并且用来代替微信存储临时文件，常用
- **腾讯会议**，工作用，主要会议工具
- **Zoom**，最近跟在留学的朋友一起讨论问题又下回来了
- **Microsoft Teams**，偶尔参加一些线上研讨会使用
- **Swiftcord**，原生的 Discord 客户端，更简洁一点
- ~~**钉钉**，工作沟通以及偶尔处理我妹妹学校的一些信息用~~，卸载了
- ~~**飞书**，因为少数派约稿需要通过飞书沟通，使用了一下，体验感比钉钉强多了~~，但是也不太爱用
- **Slack**，上 Uedmy 的一门课程跨入社群使用的，后来工作 IM 也是用的这个
- ~~**Rocket.Chat**，工作中使用的一个协作软件，可以集成 GitLab 提交等~~，离职后不用了
- ~~**Gather**，有趣的线上交流，正在推荐身边的朋友用，像宝可梦一样，能减轻疫情带来的距离感（好吧还是没人用）~~
- ~~**Discord**，主要参加一些项目获取资讯用的，换了 Swiftcord，已弃用~~
- ~~**QQ**，大学时学校常用，已弃用~~

### 🎸 影音娱乐

- **IINA**，之前订阅了 Infuse，但是感觉其实用得很少，而且对字幕识别这些一般般，所以放弃了还是选择了之前常用的开源方案 IINA
- ~~**Infuse**，视频播放及媒体管理工具，全平台可用且支持格式很多，配合 Plex 这些媒体服务器可以建立自己本地的动漫、电影和剧集库，已弃用~~
- ~~**Plex Media Server**，流媒体管理服务器，可以指定本地目录自动获取元数据进行媒体库管理，后来改为阿里云服务器进行远程访问，mac 本地服务端就弃用了~~
- ~~**Apple Music**，主要听歌软件，配合 iOS 上的 Music Mate 慢慢建立自己的音乐库~~，取消订阅了
- **Spotify**，主要听歌软件，主要是能接入 n8n 把喜欢的歌单记录进 Telegram 频道，歌单功能也很强大
- **Apple Podcasts**，主要用来听一些播客
- ~~**爱奇艺**，送的会员，偶尔用来追一些热门自制剧~~，会员到期后不续了
- **Netflix**，用来追一些最新剧集，新加坡订阅
- ~~**Disney+**，用来看一些迪士尼动画、漫威剧集和电影，不过用得也不多了，也是新加坡订阅~~，去掉订阅了
- ~~**HBO Go**，订阅了台湾的 HBO，用来看权游和重温硅谷~~，追完后取消订阅了
- **HBO Max**，拼车拼了一个，主要看硅谷
- **YPlayer**，自动识别音视频字幕的，体验了一下还可以

### 📲 手机 App

![yu_ios_apps](https://image.pseudoyu.com/images/yu_ios_apps.png)

- 🛠 系统拓展
  - **熊猫吃短信**，过滤垃圾短信，很好用
  - **AdGuard**，浏览网页去广告工具
  - **AT**，重要日期纪念日/倒计时
  - **OffScreen**，使用手机时间追踪
  - **谜底时钟**，个性化时钟组件
  - **谜底黑胶**，个性化音乐播放组件
  - **谜底空白**，在屏幕中设置空白位置
  - **Vinegar+Baking Soda**，浏览器看视频使用 HTML5 播放器插件
  - ~~**Lock Launcher**，配合 iOS 16 的锁屏插件使用~~，后来非常少用了
  - ~~**Cloak**，一个可以隐藏 App 的拓展软件~~，尝鲜了一下后几乎也没怎么用过了
  - **仓输入法**，因为用 Rime 所以体验了一下，感觉目前成熟度还是一般，切换回了系统自带
- 📁 文件管理
  - **文件**，Apple 自带本地及 iCloud 文件管理
  - **OneDrive**，iOS 端
- 🔐 安全工具
  - **Elpass**，密码管理工具 iOS 端，支持双重验证
  - **Google Authenticator**，Google 双重验证工具
  - **Microsoft Authenticator**，Microsoft 双重验证工具
  - **DAMA**，图片隐私打码工具
  - **隐私洞见**，一个能够分析各 App 隐私报告的工具
- 🌏 网络工具
  - **Surge**，Surge 代理工具 iOS 端
  - **Shadowrocket**，备用代理工具
  - **Speedtest**，网络测速工具
  - **小米 WIFI**，管理家庭 Wifi 及设备
  - **SGNetworkTest**，Surge 作者做的测速小工具，体验一下
- 🧰 实用工具
  - **欧陆词典**，字典应用，可导入不同源
  - **翻译**，苹果自带翻译工具
  - **ServerCat**，服务器状态检测工具移动端
  - **快捷指令**，进行各类自动化操作
  - **TestFlight**，尝鲜一些测试版应用
  - **One Search**，聚合搜索不同应用的内容
  - **Noise Smith**，白噪音工具，可以自己组合各种声音，适合做背景音
  - **PomoNow 2**，一个很有设计感的番茄钟，打算再试试番茄工作法了
  - **TablePlus**，数据库手机端，操作很不方便，但作为紧急备用还不错
  - **LEMO FM**，一个很有设计感的白噪音工具
  - **OpenCat**，一个 ChatGPT 套壳 App
  - **ChatX**，同样是 ChatGPT 套壳应用，但是页面更简洁好看
  - **ReadID Me**，一个小应用，当时担心自己护照感应有问题，发现这个可以通过 NFC 来检测
  - **Creator's App**，Sony 相机的手机端应用
- 📝 记录工具
  - **Logseq**，iOS 端，主要用来查看
  - **Office 365**，iOS 端，通过 Office365 帐号和 OneDrive 进行同步
  - **iWork 全家桶**，iOS 端
  - ~~**Notability**，笔记工具~~，不怎么用 iPad 了
  - **Heptabase**，iOS 端
- 🪙 数字资产
  - **imToken**，iOS 数字钱包
  - **TokenPocket**，iOS 数字钱包
  - **币安**，Binance 交易所 iOS 客户端
  - **欧易**，OKEX 交易所 iOS 客户端
  - **火币**，Huobi 交易所 iOS 客户端
- 🏚 家庭管理
  - **Home**，苹果自带家庭应用，目前主要用来管 HomePod mini
  - **米家**，管理小米智能家居设备
  - **小爱音箱**，连接和管理小爱智能音箱，语音控制智能家居
  - **点音**，Divoom 像素音箱管理
  - **Yeelight**，控制氛围灯模式
  - **小佩宠物**，控制宠物智能家居
  - **Health**，苹果自带健康数据记录应用，主要用来记录睡眠
  - ~~**Grow**，联动健康应用，生成健康数据~~，懒得用了后来
  - **Zepp Life**，联动小米体重秤等，记录健康数据
  - **EBO**，管理家里的 EBO 机器人的应用
- 📨 信息管理
  - **Spark**，iOS 端
  - **NetNewsWire**，iOS 端
  - **Apple Books**，电子书阅读器，主要导入 epub 格式看
  - ~~**Patreon**，订阅及赞助支持某些技术大佬的平台~~，后来也不怎么用了
  - **Twitter**，iOS 端，主要国外资讯获取与发布平台
  - **Spring**，iOS 端，同样消息通知这一块有点问题
  - **Instagram**，iOS 端，主要用来发布摄影和日常照片
  - **Facebook**，iOS 端，个人状态更新平台，离开香港后用得比较少
  - **微博**，官方客户端，主要股票内资讯获取与发布平台
  - **豆瓣**，iOS 端
  - **少数派**，用来看一些工具类资讯
  - **Instapaper**，稍后读应用 iOS 端
  - ~~**Outlook**，iOS 端~~，转用自带为主
  - **Mail**，苹果自带邮件应用
  - **GitHub**，发现了移动端更新了修改代码功能，就下载备用一些
  - **RSSBud**，RSSHub 的 iOS 端，用得不算多
  - **DailyArt**，订阅了终生，每天会发一张艺术品的图
  - **xLog Mobile**，xLog 区块链博客的 iOS 端，作为查看还是不错的
  - ~~**Threads**，跟 ins 同源的 Fediverse 应用~~，体验了一阵子后再也没打开了
  - **Readwise Reader**，手机端看 RSS
- 👨🏻‍💻 工作求职
  - **LinkedIn**，看一些外企的机会
  - **BOSS 直骋**，国内找工作主要用
  - **脉脉**，查询一些公司资讯用
- 💰 支付工具
  - **支付宝**，日常最主要支付工具
  - **招商银行**，招行卡管理
  - **掌上生活**，招行信用卡管理
  - **中国工商银行**，工行卡管理
  - **AlipayHK**，香港支付宝账户
- 🚆 交通出行
  - **Maps**，苹果自带地图应用，主要用来搜路线
  - **高德地图**，公司加班打车用这个
  - **携程旅行**，用来定机票和酒店
  - **铁路 12306**，用来定高铁票，不过后面大多在携程里直接定了
  - **航旅纵横 Pro**，用来查询航班信息、值机以及统计自己的出行，很好用
  - **北京通**，用来查询健康宝信息，配合 Locker Launcher 使用所以下载了 App
  - **足迹**，记录我每天的行为轨迹
  - **Bolt**，在泰国打车很方便
- 🛍 生活工具
  - **饿了么**，点外卖和水果
  - **淘宝**，买一些日常用品
  - **京东**，主要买数码产品和小家电
  - **大众点评**，查询一些店的评价
  - **大麦**，看一些演出展览
  - **闲鱼**，偶尔会看下一些二手
  - **当当**，买纸质书，大多技术为主
  - **OpenRice**，在国外找餐厅之类的，类似大众点评
  - **Tripadvisor**，国外的马蜂窝
  - **乐刻运动**，用来约健身私教课
- 💬 通讯社交
  - **微信**，iOS 端
  - **腾讯会议**，iOS 端
  - **钉钉**，iOS 端
  - **Zoom**，iOS 端
  - **Telegram**，iOS 端
  - **Discord**，iOS 端
  - **Ivory**，Mastodon 的移动端，不过免费版只能看不能发
  - ~~**Clubhouse**，语音聊天室工具，热度过去了现在用得也比较少了~~
  - ~~**QQ**，iOS 客户端，已弃用~~
- 🎸 影音娱乐
  - ~~**Infuse**，iOS 端，可以局域网连接 Mac Studio 的 Plex 媒体库服务器，取消订阅后弃用了~~
  - **YouTube**，用来看各类国外博主与技术视频
  - **哔哩哔哩**，主要用来看关注的各类博主更新
  - **爱奇艺**，iOS 客户端
  - **Apple Music**，iOS 端
  - **Spotify**，iOS 端
  - **Music Mate**，探索新音乐，慢慢建立自己的音乐库
  - **Dtd Playlist**，场景歌单软件，设计很有惊喜感，我目前使用 Music Mate 和谜底黑胶一起用，基本解决了听歌选择问题
  - **Apple Podcasts**，主要通过 iOS 端收听播客
  - **Pokémon Go**，最爱的游戏了，在香港留下了很多记忆，可惜回来后玩不了了
  - **YPlayer**，自动识别音视频字幕，手机端

## Star 历史

[![Star History Chart](https://api.star-history.com/svg?repos=pseudoyu/yu-tools&type=Date)](https://star-history.com/#pseudoyu/yu-tools&Date)

## 贡献者

<!-- readme: collaborators,contributors -start -->
<table>
<tr>
    <td align="center">
        <a href="https://github.com/pseudoyu">
            <img src="https://avatars.githubusercontent.com/u/69753389?v=4" width="100;" alt="pseudoyu"/>
            <br />
            <sub><b>Pseudoyu</b></sub>
        </a>
    </td>
    <td align="center">
        <a href="https://github.com/ycluis">
            <img src="https://avatars.githubusercontent.com/u/96339674?v=4" width="100;" alt="ycluis"/>
            <br />
            <sub><b>Ycluislabs</b></sub>
        </a>
    </td></tr>
</table>
<!-- readme: collaborators,contributors -end -->
