import { FC } from "react";

const SequenceDiagram: FC = () => {
  return (
    <div className="py-4" id="sequence-diagram">
      <svg
        version="1.1"
        xmlns="http://www.w3.org/2000/svg"
        width="824"
        height="1488"
      >
        <defs />
        <g>
          <g />
          <g />
          <g />
          <g />
          <g />
          <g />
          <g />
          <g />
          <g />
          <g />
          <g />
          <g />
          <g />
          <g />
          <g />
          <g />
          <g />
          <g />
          <g />
          <g>
            <rect
              fill="white"
              stroke="none"
              x="0"
              y="0"
              width="824"
              height="1488"
            />
          </g>
          <g>
            <text
              fill="black"
              stroke="none"
              fontFamily="sans-serif"
              fontSize="16.5pt"
              fontStyle="normal"
              fontWeight="normal"
              textDecoration="normal"
              x="336.416192680625"
              y="28.27246725"
              textAnchor="start"
              dominantBaseline="alphabetic"
            >
              Detect Injection
            </text>
          </g>
          <g />
          <g>
            <path
              fill="none"
              stroke="black"
              paintOrder="fill stroke markers"
              d=" M 25.2591166875 148.61893617750002 L 25.2591166875 1488.7338838275002"
              strokeMiterlimit="10"
              strokeWidth="1.5706926250000002"
              strokeDasharray="14.498701153846154,6.282770500000001"
            />
            <path
              fill="none"
              stroke="black"
              paintOrder="fill stroke markers"
              d=" M 267.53088565625 148.61893617750002 L 267.53088565625 1488.7338838275002"
              strokeMiterlimit="10"
              strokeWidth="1.5706926250000002"
              strokeDasharray="14.498701153846154,6.282770500000001"
            />
            <path
              fill="none"
              stroke="black"
              paintOrder="fill stroke markers"
              d=" M 450.86987678125 148.61893617750002 L 450.86987678125 1488.7338838275002"
              strokeMiterlimit="10"
              strokeWidth="1.5706926250000002"
              strokeDasharray="14.498701153846154,6.282770500000001"
            />
            <path
              fill="none"
              stroke="black"
              paintOrder="fill stroke markers"
              d=" M 624.20398509375 148.61893617750002 L 624.20398509375 1488.7338838275002"
              strokeMiterlimit="10"
              strokeWidth="1.5706926250000002"
              strokeDasharray="14.498701153846154,6.282770500000001"
            />
            <path
              fill="none"
              stroke="black"
              paintOrder="fill stroke markers"
              d=" M 730.22754661125 148.61893617750002 L 730.22754661125 1488.7338838275002"
              strokeMiterlimit="10"
              strokeWidth="1.5706926250000002"
              strokeDasharray="14.498701153846154,6.282770500000001"
            />
          </g>
          <g>
            <g>
              <path
                fill="white"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 36.0026542425 68.89057853250002 A 10.743537555 10.743537555 0 1 1 36.00264887073167 68.8798349967356 M 25.2591166875 79.63411608750002 L 25.2591166875 102.62905611750003 M 11.6883324075 87.92737314750002 L 38.8299009675 87.92737314750002 M 25.2591166875 102.62905611750003 L 11.6883324075 124.11613122750002 M 25.2591166875 102.62905611750003 L 38.8299009675 124.11613122750002"
                strokeMiterlimit="10"
                strokeWidth="3.2042129550000005"
                strokeDasharray=""
              />
            </g>
            <g>
              <g />
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="9.42415575"
                y="142.96444272750003"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                User
              </text>
            </g>
            <path fill="none" stroke="none" />
            <g>
              <path
                fill="white"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 205.94033096 97.72849512750001 L 329.12144035250003 97.72849512750001 L 329.12144035250003 148.61893617750002 L 205.94033096 148.61893617750002 L 205.94033096 97.72849512750001 Z"
                strokeMiterlimit="10"
                strokeWidth="3.01572984"
                strokeDasharray=""
              />
            </g>
            <g>
              <g />
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="226.3907489375"
                y="129.77062467750002"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                RebuffClient
              </text>
            </g>
            <path fill="none" stroke="none" />
            <g>
              <path
                fill="white"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 389.279322085 97.72849512750001 L 512.4604314775 97.72849512750001 L 512.4604314775 148.61893617750002 L 389.279322085 148.61893617750002 L 389.279322085 97.72849512750001 Z"
                strokeMiterlimit="10"
                strokeWidth="3.01572984"
                strokeDasharray=""
              />
            </g>
            <g>
              <g />
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="409.7297400625"
                y="129.77062467750002"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                RebuffAIAPI
              </text>
            </g>
            <path fill="none" stroke="none" />
            <g>
              <path
                fill="white"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 589.16372336625 97.72849512750001 L 659.24424682125 97.72849512750001 L 659.24424682125 148.61893617750002 L 589.16372336625 148.61893617750002 L 589.16372336625 97.72849512750001 Z"
                strokeMiterlimit="10"
                strokeWidth="3.01572984"
                strokeDasharray=""
              />
            </g>
            <g>
              <g />
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="609.61414134375"
                y="129.77062467750002"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                LLM
              </text>
            </g>
            <path fill="none" stroke="none" />
            <g>
              <path
                fill="white"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 678.09255832125 97.72849512750001 L 782.36253490125 97.72849512750001 L 782.36253490125 148.61893617750002 L 678.09255832125 148.61893617750002 L 678.09255832125 97.72849512750001 Z"
                strokeMiterlimit="10"
                strokeWidth="3.01572984"
                strokeDasharray=""
              />
            </g>
            <g>
              <g />
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="698.54297629875"
                y="129.77062467750002"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                VectorDB
              </text>
            </g>
          </g>
          <g>
            <path
              fill="white"
              stroke="black"
              paintOrder="fill stroke markers"
              d=" M 258.10672990625 210.81836412750005 L 276.95504140625 210.81836412750005 L 276.95504140625 895.0120715775001 L 258.10672990625 895.0120715775001 L 258.10672990625 210.81836412750005"
              strokeMiterlimit="10"
              strokeWidth="1.5706926250000002"
              strokeDasharray=""
            />
            <path
              fill="white"
              stroke="black"
              paintOrder="fill stroke markers"
              d=" M 441.44572103125 263.59363632750006 L 460.29403253125 263.59363632750006 L 460.29403253125 842.2367993775001 L 441.44572103125 842.2367993775001 L 441.44572103125 263.59363632750006"
              strokeMiterlimit="10"
              strokeWidth="1.5706926250000002"
              strokeDasharray=""
            />
            <path
              fill="white"
              stroke="black"
              paintOrder="fill stroke markers"
              d=" M 614.7798293437501 523.7003350275 L 633.62814084375 523.7003350275 L 633.62814084375 576.4756072275001 L 614.7798293437501 576.4756072275001 L 614.7798293437501 523.7003350275"
              strokeMiterlimit="10"
              strokeWidth="1.5706926250000002"
              strokeDasharray=""
            />
            <path
              fill="white"
              stroke="black"
              paintOrder="fill stroke markers"
              d=" M 720.80339086125 708.4137877275001 L 739.6517023612499 708.4137877275001 L 739.6517023612499 761.1890599275001 L 720.80339086125 761.1890599275001 L 720.80339086125 708.4137877275001"
              strokeMiterlimit="10"
              strokeWidth="1.5706926250000002"
              strokeDasharray=""
            />
            <path
              fill="white"
              stroke="black"
              paintOrder="fill stroke markers"
              d=" M 258.10672990625 947.7873437775002 L 276.95504140625 947.7873437775002 L 276.95504140625 1106.1131603775002 L 258.10672990625 1106.1131603775002 L 258.10672990625 947.7873437775002"
              strokeMiterlimit="10"
              strokeWidth="1.5706926250000002"
              strokeDasharray=""
            />
            <path
              fill="white"
              stroke="black"
              paintOrder="fill stroke markers"
              d=" M 614.7798293437501 1000.5626159775002 L 633.62814084375 1000.5626159775002 L 633.62814084375 1053.3378881775002 L 614.7798293437501 1053.3378881775002 L 614.7798293437501 1000.5626159775002"
              strokeMiterlimit="10"
              strokeWidth="1.5706926250000002"
              strokeDasharray=""
            />
            <path
              fill="white"
              stroke="black"
              paintOrder="fill stroke markers"
              d=" M 258.10672990625 1158.8884325775002 L 276.95504140625 1158.8884325775002 L 276.95504140625 1422.7647935775003 L 258.10672990625 1422.7647935775003 L 258.10672990625 1158.8884325775002"
              strokeMiterlimit="10"
              strokeWidth="1.5706926250000002"
              strokeDasharray=""
            />
            <path
              fill="white"
              stroke="black"
              paintOrder="fill stroke markers"
              d=" M 441.44572103125 1211.6637047775002 L 460.29403253125 1211.6637047775002 L 460.29403253125 1369.9895213775003 L 441.44572103125 1369.9895213775003 L 441.44572103125 1211.6637047775002"
              strokeMiterlimit="10"
              strokeWidth="1.5706926250000002"
              strokeDasharray=""
            />
            <path
              fill="white"
              stroke="black"
              paintOrder="fill stroke markers"
              d=" M 720.80339086125 1264.4389769775003 L 739.6517023612499 1264.4389769775003 L 739.6517023612499 1317.2142491775003 L 720.80339086125 1317.2142491775003 L 720.80339086125 1264.4389769775003"
              strokeMiterlimit="10"
              strokeWidth="1.5706926250000002"
              strokeDasharray=""
            />
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="105.91866485312501"
                  y="186.31555917750003"
                  width="71.5285168875"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="108.745911578125"
                y="203.27903952750003"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                user input
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 25.2591166875 210.81836412750005 L 242.58828677124998 210.81836412750005"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray=""
              />
              <g transform="translate(258.10672990625,210.81836412750005) translate(-258.10672990625,-210.81836412750005)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 242.39980365625 202.96490100250006 L 258.10672990625 210.81836412750005 L 242.39980365625 218.67182725250004 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="299.25887668125"
                  y="239.09083137750005"
                  width="119.883009075"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="302.08612340625"
                y="256.0543117275001"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                detect_injection()
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 276.95504140625 263.59363632750006 L 425.92727789625 263.59363632750006"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray=""
              />
              <g transform="translate(441.44572103125,263.59363632750006) translate(-441.44572103125,-263.59363632750006)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 425.73879478125 255.74017320250007 L 441.44572103125 263.59363632750006 L 425.73879478125 271.4470994525001 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="482.59786780625"
                  y="342.75654462750003"
                  width="54.858595012500004"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="485.42511453125"
                y="359.72002497750003"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                stage 1
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 460.29403253125 367.2593495775001 L 535.6872785312501 367.2593495775001 L 535.6872785312501 391.76215452750006 L 475.81247566625 391.76215452750006"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray="7.5393246000000005"
              />
              <g transform="translate(460.29403253125,391.76215452750006) translate(-460.29403253125,-391.76215452750006)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 476.00095878125 383.90869140250004 L 460.29403253125 391.76215452750006 L 476.00095878125 399.6156176525001 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="490.51168616562506"
                  y="499.19753007750006"
                  width="94.05048954375"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="493.3389328906251"
                y="516.1610104275001"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                validate input
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 460.29403253125 523.7003350275 L 599.2613862087501 523.7003350275"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray=""
              />
              <g transform="translate(614.7798293437501,523.7003350275) translate(-614.7798293437501,-523.7003350275)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 599.07290309375 515.8468719025001 L 614.7798293437501 523.7003350275 L 599.07290309375 531.5537981525 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="482.59786780625006"
                  y="551.9728022775"
                  width="109.8781262625"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="485.4251145312501"
                y="568.9362826275001"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                validation result
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 614.7798293437501 576.4756072275001 L 475.81247566625 576.4756072275001"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray="7.5393246000000005"
              />
              <g transform="translate(460.29403253125,576.4756072275001) translate(-460.29403253125,-576.4756072275001)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 476.00095878125 568.6221441025001 L 460.29403253125 576.4756072275001 L 476.00095878125 584.3290703525 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="549.78201184625"
                  y="683.9109827775001"
                  width="81.5333997"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="552.60925857125"
                y="700.8744631275001"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                check input
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 460.29403253125 708.4137877275001 L 705.28494772625 708.4137877275001"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray=""
              />
              <g transform="translate(720.80339086125,708.4137877275001) translate(-720.80339086125,-708.4137877275001)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 705.09646461125 700.5603246025001 L 720.80339086125 708.4137877275001 L 705.09646461125 716.2672508525001 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="547.705595830625"
                  y="736.6862549775001"
                  width="85.68623173125"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="550.532842555625"
                y="753.6497353275001"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                check result
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 720.80339086125 761.1890599275001 L 475.81247566625 761.1890599275001"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray="7.5393246000000005"
              />
              <g transform="translate(460.29403253125,761.1890599275001) translate(-460.29403253125,-761.1890599275001)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 476.00095878125 753.3355968025002 L 460.29403253125 761.1890599275001 L 476.00095878125 769.0425230525001 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="325.519863009375"
                  y="817.7339944275001"
                  width="67.36103641875"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="328.347109734375"
                y="834.6974747775001"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                response
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 441.44572103125 842.2367993775001 L 292.47348454125 842.2367993775001"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray="7.5393246000000005"
              />
              <g transform="translate(276.95504140625,842.2367993775001) translate(-276.95504140625,-842.2367993775001)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 292.66196765625 834.3833362525002 L 276.95504140625 842.2367993775001 L 292.66196765625 850.0902625025001 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="108.00240508750001"
                  y="870.5092666275001"
                  width="67.36103641875"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="110.8296518125"
                y="887.4727469775002"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                response
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 258.10672990625 895.0120715775001 L 40.7775598225 895.0120715775001"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray="7.5393246000000005"
              />
              <g transform="translate(25.2591166875,895.0120715775001) translate(-25.2591166875,-895.0120715775001)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 40.966042937500006 887.1586084525002 L 25.2591166875 895.0120715775001 L 40.966042937500006 902.8655347025001 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="47.5629519625"
                  y="923.2845388275001"
                  width="188.23994266875"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="50.3901986875"
                y="940.2480191775002"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                user input with canary word
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 25.2591166875 947.7873437775002 L 242.58828677124998 947.7873437775002"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray=""
              />
              <g transform="translate(258.10672990625,947.7873437775002) translate(-258.10672990625,-947.7873437775002)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 242.39980365625 939.9338806525002 L 258.10672990625 947.7873437775002 L 242.39980365625 955.6408069025001 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="342.995022634375"
                  y="976.0598110275001"
                  width="205.74482548125"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="345.822269359375"
                y="993.0232913775002"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                send prompt with canary word
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 276.95504140625 1000.5626159775002 L 599.2613862087501 1000.5626159775002"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray=""
              />
              <g transform="translate(614.7798293437501,1000.5626159775002) translate(-614.7798293437501,-1000.5626159775002)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 599.07290309375 992.7091528525002 L 614.7798293437501 1000.5626159775002 L 599.07290309375 1008.4160791025001 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="373.83364568125"
                  y="1028.8350832275003"
                  width="144.0675793875"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="376.66089240625"
                y="1045.7985635775"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                response completion
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 614.7798293437501 1053.3378881775002 L 292.47348454125 1053.3378881775002"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray="7.5393246000000005"
              />
              <g transform="translate(276.95504140625,1053.3378881775002) translate(-276.95504140625,-1053.3378881775002)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 292.66196765625 1045.4844250525002 L 276.95504140625 1053.3378881775002 L 292.66196765625 1061.1913513025002 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="66.32027618125001"
                  y="1081.6103554275003"
                  width="150.72529423125"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="69.14752290625"
                y="1098.5738357775"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                detect_canary_word()
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 258.10672990625 1106.1131603775002 L 40.7775598225 1106.1131603775002"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray="7.5393246000000005"
              />
              <g transform="translate(25.2591166875,1106.1131603775002) translate(-25.2591166875,-1106.1131603775002)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 40.966042937500006 1098.2596972525002 L 25.2591166875 1106.1131603775002 L 40.966042937500006 1113.9666235025002 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="63.3979129"
                  y="1134.3856276275003"
                  width="156.57002079375"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="66.225159625"
                y="1151.3491079775001"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                user input (leak==true)
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 25.2591166875 1158.8884325775002 L 242.58828677124998 1158.8884325775002"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray=""
              />
              <g transform="translate(258.10672990625,1158.8884325775002) translate(-258.10672990625,-1158.8884325775002)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 242.39980365625 1151.0349694525003 L 258.10672990625 1158.8884325775002 L 242.39980365625 1166.7418957025002 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="313.85604465"
                  y="1187.1608998275003"
                  width="90.6886731375"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="316.683291375"
                y="1204.1243801775001"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                report_leak()
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 276.95504140625 1211.6637047775002 L 425.92727789625 1211.6637047775002"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray=""
              />
              <g transform="translate(441.44572103125,1211.6637047775002) translate(-441.44572103125,-1211.6637047775002)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 425.73879478125 1203.8102416525003 L 441.44572103125 1211.6637047775002 L 425.73879478125 1219.5171679025002 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="554.788115361875"
                  y="1239.9361720275003"
                  width="71.52119266875"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="557.615362086875"
                y="1256.8996523775002"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                log_leak()
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 460.29403253125 1264.4389769775003 L 705.28494772625 1264.4389769775003"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray=""
              />
              <g transform="translate(720.80339086125,1264.4389769775003) translate(-720.80339086125,-1264.4389769775003)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 705.09646461125 1256.5855138525003 L 720.80339086125 1264.4389769775003 L 705.09646461125 1272.2924401025002 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="528.9446095025"
                  y="1292.7114442275004"
                  width="123.2082043875"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="531.7718562275"
                y="1309.6749245775002"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                save confirmation
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 720.80339086125 1317.2142491775003 L 475.81247566625 1317.2142491775003"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray="7.5393246000000005"
              />
              <g transform="translate(460.29403253125,1317.2142491775003) translate(-460.29403253125,-1317.2142491775003)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 476.00095878125 1309.3607860525003 L 460.29403253125 1317.2142491775003 L 476.00095878125 1325.0677123025002 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="315.522304415625"
                  y="1345.4867164275004"
                  width="87.35615360625"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="318.349551140625"
                y="1362.4501967775002"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                confirmation
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 441.44572103125 1369.9895213775003 L 292.47348454125 1369.9895213775003"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray="7.5393246000000005"
              />
              <g transform="translate(276.95504140625,1369.9895213775003) translate(-276.95504140625,-1369.9895213775003)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 292.66196765625 1362.1360582525003 L 276.95504140625 1369.9895213775003 L 292.66196765625 1377.8429845025003 Z"
                />
              </g>
            </g>
            <g>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="98.00484649375001"
                  y="1398.2619886275004"
                  width="87.35615360625"
                  height="24.50280495"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="11pt"
                fontStyle="normal"
                fontWeight="normal"
                textDecoration="normal"
                x="100.83209321875"
                y="1415.2254689775002"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                confirmation
              </text>
            </g>
            <g>
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 258.10672990625 1422.7647935775003 L 40.7775598225 1422.7647935775003"
                strokeMiterlimit="10"
                strokeWidth="1.5706926250000002"
                strokeDasharray="7.5393246000000005"
              />
              <g transform="translate(25.2591166875,1422.7647935775003) translate(-25.2591166875,-1422.7647935775003)">
                <path
                  fill="black"
                  stroke="none"
                  paintOrder="stroke fill markers"
                  d=" M 40.966042937500006 1414.9113304525004 L 25.2591166875 1422.7647935775003 L 40.966042937500006 1430.6182567025003 Z"
                />
              </g>
            </g>
            <g>
              <g />
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 384.90078653125 291.86610357750004 L 545.11143428125 291.86610357750004 L 545.11143428125 420.03462177750004 L 384.90078653125 420.03462177750004 L 384.90078653125 291.86610357750004 Z"
                strokeMiterlimit="10"
                strokeWidth="2.6926159285714286"
                strokeDasharray=""
              />
              <path
                fill="white"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 384.90078653125 291.86610357750004 L 384.90078653125 314.48407737750006 L 436.60131578125 314.48407737750006 L 447.91030268124996 303.1750904775 L 447.91030268124996 291.86610357750004 L 384.90078653125 291.86610357750004"
                strokeMiterlimit="10"
                strokeWidth="2.6926159285714286"
                strokeDasharray=""
              />
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="8.8pt"
                fontStyle="normal"
                fontWeight="bold"
                textDecoration="normal"
                x="403.74909803125"
                y="306.94475277750007"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                alt
              </text>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="463.93136745625"
                  y="293.3739684975001"
                  width="101.02168095"
                  height="19.602243960000003"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="8.8pt"
                fontStyle="normal"
                fontWeight="bold"
                textDecoration="normal"
                x="466.75861418125"
                y="306.94475277750007"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                [heuristic check]
              </text>
            </g>
            <g>
              <g />
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 375.47663078125 448.3070890275 L 690.17307534375 448.3070890275 L 690.17307534375 604.7480744775 L 375.47663078125 604.7480744775 L 375.47663078125 448.3070890275 Z"
                strokeMiterlimit="10"
                strokeWidth="2.6926159285714286"
                strokeDasharray=""
              />
              <path
                fill="white"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 375.47663078125 448.3070890275 L 375.47663078125 470.9250628275 L 427.17716003124997 470.9250628275 L 438.48614693124995 459.6160759275 L 438.48614693124995 448.3070890275 L 375.47663078125 448.3070890275"
                strokeMiterlimit="10"
                strokeWidth="2.6926159285714286"
                strokeDasharray=""
              />
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="8.8pt"
                fontStyle="normal"
                fontWeight="bold"
                textDecoration="normal"
                x="394.32494228125"
                y="463.38573822750004"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                alt
              </text>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="454.50721170624996"
                  y="449.81495394750004"
                  width="75.66230595"
                  height="19.602243960000003"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="8.8pt"
                fontStyle="normal"
                fontWeight="bold"
                textDecoration="normal"
                x="457.33445843124997"
                y="463.38573822750004"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                [LLM check]
              </text>
            </g>
            <g>
              <g />
              <path
                fill="none"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 375.47663078125 633.0205417275001 L 796.19663686125 633.0205417275001 L 796.19663686125 789.4615271775001 L 375.47663078125 789.4615271775001 L 375.47663078125 633.0205417275001 Z"
                strokeMiterlimit="10"
                strokeWidth="2.6926159285714286"
                strokeDasharray=""
              />
              <path
                fill="white"
                stroke="black"
                paintOrder="fill stroke markers"
                d=" M 375.47663078125 633.0205417275001 L 375.47663078125 655.6385155275001 L 427.17716003124997 655.6385155275001 L 438.48614693124995 644.3295286275002 L 438.48614693124995 633.0205417275001 L 375.47663078125 633.0205417275001"
                strokeMiterlimit="10"
                strokeWidth="2.6926159285714286"
                strokeDasharray=""
              />
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="8.8pt"
                fontStyle="normal"
                fontWeight="bold"
                textDecoration="normal"
                x="394.32494228125"
                y="648.0991909275001"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                alt
              </text>
              <g>
                <rect
                  fill="white"
                  stroke="none"
                  x="454.50721170624996"
                  y="634.5284066475001"
                  width="101.683790325"
                  height="19.602243960000003"
                />
              </g>
              <text
                fill="black"
                stroke="none"
                fontFamily="sans-serif"
                fontSize="8.8pt"
                fontStyle="normal"
                fontWeight="bold"
                textDecoration="normal"
                x="457.33445843124997"
                y="648.0991909275001"
                textAnchor="start"
                dominantBaseline="alphabetic"
              >
                [vectordb check]
              </text>
            </g>
          </g>
          <g />
          <g />
          <g />
          <g />
          <g />
        </g>
      </svg>
    </div>
  );
};

export default SequenceDiagram;
