#include "Dolphin/dsp.h"
#include "types.h"
#include "JSystem/JAudio/DSP.h"

static DSPTaskInfo audio_task ATTRIBUTE_ALIGN(32);
static u16 AUDIO_YIELD_BUFFER[4096] ATTRIBUTE_ALIGN(32);

u16 jdsp[] ATTRIBUTE_ALIGN(32) = {
	0x029F, 0x0012, 0x0000, 0x0000, 0x02FF, 0x0000, 0x02FF, 0x0000, 0x02FF, 0x0000, 0x02FF, 0x0000, 0x02FF, 0x0000, 0x029F, 0x05B8, 0x029F,
	0x004E, 0x1205, 0x02BF, 0x0057, 0x8100, 0x009F, 0x1000, 0x0080, 0x0000, 0x005F, 0x1B1E, 0x02BF, 0x0688, 0x02BF, 0x04C0, 0x02BF, 0x0E1B,
	0x0E00, 0x02BF, 0x066A, 0x009E, 0x1111, 0x02BF, 0x0674, 0x0E00, 0x00FE, 0x034E, 0x1305, 0x029F, 0x06C5, 0x00DF, 0x0357, 0x00FF, 0x0345,
	0x00DE, 0x0356, 0x1FFE, 0x0340, 0x00FF, 0x00FF, 0x0344, 0x1479, 0x0240, 0x007E, 0x00FE, 0x0343, 0x0200, 0x0075, 0x1C1E, 0x170F, 0x0092,
	0x00FF, 0x0E04, 0x02BF, 0x066A, 0x00DE, 0x0356, 0x02BF, 0x0674, 0x029F, 0x002D, 0x1205, 0x02BF, 0x0057, 0x0E01, 0x02BF, 0x066A, 0x1305,
	0x029F, 0x002D, 0x1202, 0x1203, 0x1204, 0x1306, 0x8E00, 0x8C00, 0x8B00, 0x009E, 0xFFFF, 0x1D1E, 0x1D3E, 0x1D5E, 0x1D7E, 0x0092, 0x00FF,
	0x02DF, 0x0090, 0x0000, 0x0C00, 0x0081, 0x0358, 0x007E, 0x0071, 0x193E, 0x1B1E, 0x193E, 0x1B1E, 0x02DF, 0x029F, 0x0043, 0x029F, 0x0043,
	0x029F, 0x0095, 0x029F, 0x0243, 0x029F, 0x0073, 0x029F, 0x0580, 0x029F, 0x0592, 0x029F, 0x0469, 0x029F, 0x041D, 0x029F, 0x0485, 0x029F,
	0x044D, 0x029F, 0x0043, 0x029F, 0x0043, 0x029F, 0x0043, 0x029F, 0x00B2, 0x029F, 0x0043, 0x029F, 0x0043, 0x0080, 0x0380, 0x0E04, 0x02BF,
	0x0067, 0x0081, 0x0382, 0x009F, 0x0000, 0x0080, 0x0280, 0x02BF, 0x0523, 0x0081, 0x0384, 0x009F, 0x0300, 0x0080, 0x0020, 0x02BF, 0x0523,
	0x00DE, 0x0345, 0x00FE, 0x0342, 0x02BF, 0x0BEC, 0x029F, 0x0043, 0x0080, 0x0374, 0x0E01, 0x00FE, 0x0377, 0x00FE, 0x037C, 0x02BF, 0x0067,
	0x00DE, 0x0345, 0x00FE, 0x0376, 0x029F, 0x0043, 0x0081, 0x034C, 0x009F, 0x0400, 0x0080, 0x00C0, 0x02BF, 0x0523, 0x02DF, 0x0081, 0x034C,
	0x009F, 0x0400, 0x0080, 0x0080, 0x0081, 0x034C, 0x193E, 0x193C, 0x0098, 0x0000, 0x7000, 0x02BF, 0x0532, 0x02DF, 0x191E, 0x191A, 0x005F,
	0x64A0, 0x1B7E, 0x1B7A, 0x02DF, 0x191E, 0x191A, 0x007F, 0x00E8, 0x32B2, 0x65A0, 0x33BA, 0x64A1, 0x0000, 0x02DF, 0x8A00, 0x157F, 0x1C20,
	0x1C03, 0x193A, 0x9051, 0x925B, 0x007F, 0x00F7, 0x4651, 0x92B2, 0x4651, 0x92B2, 0x8B00, 0x02DF, 0x8A00, 0x191A, 0x9050, 0x9250, 0x005F,
	0x92A0, 0x8B00, 0x02DF, 0x8100, 0x8900, 0x0E50, 0x0080, 0x0D00, 0x005E, 0x1B1F, 0x0080, 0x0D60, 0x005E, 0x1B1F, 0x02BF, 0x0E46, 0x8100,
	0x8900, 0x0E50, 0x0080, 0x0CA0, 0x005E, 0x1B1F, 0x0080, 0x0F40, 0x005E, 0x1B1F, 0x0080, 0x0FA0, 0x005E, 0x1B1F, 0x0080, 0x0A00, 0x005E,
	0x1B1F, 0x0080, 0x09A0, 0x005E, 0x1B1F, 0x02DF, 0x00C0, 0x03A0, 0x191A, 0x00DF, 0x03A1, 0x009B, 0x00A0, 0x0081, 0x0393, 0x18BC, 0xB871,
	0xBC00, 0x0080, 0x0050, 0x0508, 0x02BF, 0x0525, 0x00DE, 0x0390, 0x02A0, 0x0001, 0x029D, 0x0145, 0x0080, 0x0398, 0x0E08, 0x00C1, 0x03A1,
	0x02BF, 0x0B2E, 0x0F50, 0x00C0, 0x03A1, 0x00DA, 0x0394, 0x8600, 0x0295, 0x0152, 0x1C7A, 0x00D8, 0x0395, 0x02BF, 0x00EB, 0x0F50, 0x00C0,
	0x03A1, 0x00DA, 0x0396, 0x8600, 0x0295, 0x015F, 0x1C7A, 0x00D8, 0x0397, 0x02BF, 0x00EB, 0x00DE, 0x0390, 0x02A0, 0x0002, 0x02DD, 0x0080,
	0x0398, 0x0E08, 0x00C1, 0x03A1, 0x02BF, 0x0B2E, 0x02DF, 0x8900, 0x009F, 0x0DC0, 0x00FF, 0x03A1, 0x009F, 0x03A8, 0x00FF, 0x03A2, 0x009F,
	0x03A4, 0x00FF, 0x03A0, 0x1104, 0x019F, 0x00C0, 0x03A2, 0x0083, 0x0390, 0x0F0E, 0x02BF, 0x00DA, 0x00DA, 0x0390, 0x8600, 0x0295, 0x0191,
	0x00DF, 0x03A1, 0x1C7F, 0x0550, 0x1C1F, 0x0F06, 0x02BF, 0x00DA, 0x02BF, 0x0127, 0x00DE, 0x03A2, 0x0410, 0x00FE, 0x03A2, 0x00DE, 0x03A1,
	0x0460, 0x00FE, 0x03A1, 0x00DE, 0x03A0, 0x7400, 0x00FE, 0x03A0, 0x0F50, 0x0080, 0x0C00, 0x0083, 0x0E80, 0x0098, 0x7FFF, 0x02BF, 0x00EB,
	0x0F50, 0x0080, 0x0C00, 0x0083, 0x0EE0, 0x0098, 0xB820, 0x02BF, 0x00EB, 0x0F28, 0x0080, 0x0C78, 0x0083, 0x0E80, 0x0098, 0xB820, 0x02BF,
	0x00EB, 0x0F28, 0x0080, 0x0C78, 0x0083, 0x0EE0, 0x0098, 0x7FFF, 0x02BF, 0x00EB, 0x8100, 0x8900, 0x0E50, 0x0080, 0x0C00, 0x005E, 0x1B1F,
	0x0080, 0x0C50, 0x005E, 0x1B1F, 0x02DF, 0x00C0, 0x03A0, 0x181A, 0x8100, 0x181E, 0x00DB, 0x0391, 0x7400, 0xD100, 0x0270, 0x8100, 0x1B1E,
	0x00DF, 0x03A1, 0x009B, 0x00A0, 0x0081, 0x0393, 0x18BC, 0xB871, 0xBC00, 0x0080, 0x0050, 0x02BF, 0x0532, 0x02DF, 0x8900, 0x0F28, 0x0080,
	0x0C50, 0x0083, 0x0EA8, 0x0098, 0xB820, 0x02BF, 0x00EB, 0x8900, 0x0F28, 0x0080, 0x0C50, 0x0083, 0x0F08, 0x0098, 0x7FFF, 0x02BF, 0x00EB,
	0x009F, 0x0DC0, 0x00FF, 0x03A1, 0x009F, 0x03A8, 0x00FF, 0x03A2, 0x009F, 0x03A4, 0x00FF, 0x03A0, 0x1104, 0x0228, 0x00C0, 0x03A2, 0x0083,
	0x0390, 0x0F0E, 0x02BF, 0x00DA, 0x00DA, 0x0390, 0x8600, 0x0295, 0x021A, 0x02BF, 0x01D0, 0x00DE, 0x03A2, 0x0410, 0x00FE, 0x03A2, 0x00DE,
	0x03A1, 0x0460, 0x00FE, 0x03A1, 0x00DE, 0x03A0, 0x7400, 0x00FE, 0x03A0, 0x02DF, 0x0081, 0x0386, 0x009F, 0x03A8, 0x0080, 0x0040, 0x02BF,
	0x0523, 0x02DF, 0x191E, 0x189C, 0x4800, 0x1B1E, 0x1B1C, 0x02DF, 0x8100, 0x8900, 0x00DF, 0x0354, 0x00DE, 0x034E, 0x8200, 0x0293, 0x0239,
	0x02DF, 0x0080, 0x0388, 0x0081, 0x0067, 0x0E02, 0x173F, 0x00DE, 0x0344, 0x00FE, 0x0341, 0x00DE, 0x0345, 0x00FE, 0x038E, 0x8100, 0x00FE,
	0x0355, 0x02BF, 0x022A, 0x02BF, 0x05A4, 0x00DE, 0x0341, 0x007E, 0x0418, 0x02BF, 0x0102, 0x02BF, 0x016C, 0x02BF, 0x095F, 0x00DE, 0x0355,
	0x7400, 0x00FE, 0x0355, 0x8100, 0x00FE, 0x0354, 0x00DE, 0x0342, 0x007E, 0x03C0, 0x02BF, 0x0239, 0x8100, 0x8900, 0x00DE, 0x0354, 0x147C,
	0x0200, 0x04FC, 0x1C1E, 0x181F, 0x00DE, 0x0354, 0x0240, 0x000F, 0x3D80, 0x03C0, 0x8000, 0x029C, 0x03BC, 0x00D8, 0x0354, 0x009A, 0x0180,
	0x8100, 0x00DE, 0x0380, 0x00DC, 0x0381, 0x9000, 0x9400, 0x00FE, 0x034C, 0x00FC, 0x034D, 0x02BF, 0x00C1, 0x00DA, 0x0400, 0x8600, 0x0295,
	0x03BC, 0x00DA, 0x0401, 0x8600, 0x0294, 0x03BC, 0x00DA, 0x0433, 0x00FA, 0x03F8, 0x00DA, 0x0406, 0x8600, 0x0294, 0x0E06, 0x8100, 0x00DE,
	0x0480, 0x0609, 0x0295, 0x02BD, 0x0605, 0x0295, 0x02BD, 0x0608, 0x0295, 0x098F, 0x0610, 0x0295, 0x0A14, 0x0620, 0x0295, 0x0A9A, 0x0621,
	0x0295, 0x0AA2, 0x029F, 0x087C, 0x00D8, 0x0402, 0x8100, 0x8900, 0x00DC, 0x0430, 0x8D00, 0x0950, 0xA000, 0xA400, 0x1404, 0x8C00, 0x1FFE,
	0x0083, 0x0580, 0x02BF, 0x073D, 0x029F, 0x02D0, 0x0080, 0x0580, 0x0081, 0x0520, 0x0099, 0x0000, 0x02BF, 0x0D86, 0x00DA, 0x04A8, 0x8600,
	0x0295, 0x02E1, 0x0080, 0x0520, 0x02BF, 0x0C84, 0x009E, 0x0520, 0x00FE, 0x038F, 0x8900, 0x00DF, 0x0484, 0x0340, 0x001F, 0xB900, 0x0295,
	0x0311, 0x00DE, 0x038F, 0x5C00, 0x00FE, 0x038F, 0x1C7E, 0x0080, 0x0440, 0x05FE, 0x02BF, 0x00DA, 0x0080, 0x0490, 0x00C1, 0x038F, 0x8900,
	0x00DF, 0x0484, 0x0340, 0x001F, 0x02BF, 0x0B4D, 0x00DE, 0x038F, 0x0450, 0x1C1E, 0x0083, 0x0440, 0x8900, 0x00DF, 0x0484, 0x0340, 0x001F,
	0x05FE, 0x02BF, 0x00DA, 0x00DE, 0x0484, 0x0240, 0x0020, 0x0295, 0x0333, 0x0080, 0x04A4, 0x00C1, 0x038F, 0x0082, 0x0454, 0x0083, 0x04A7,
	0x18FA, 0x8600, 0x0294, 0x0331, 0x18FA, 0x8600, 0x0294, 0x0331, 0x18FA, 0x8600, 0x0294, 0x0331, 0x8100, 0x18FE, 0x0280, 0x7FFF, 0x0295,
	0x0333, 0x02BF, 0x0B68, 0x8100, 0x00DE, 0x042C, 0xB100, 0x0295, 0x033D, 0x02BF, 0x0CD3, 0x029F, 0x03B2, 0x8100, 0x1C9E, 0x1CDE, 0x7400,
	0x1CFE, 0x8100, 0x00DE, 0x0407, 0xB100, 0x0295, 0x0355, 0x00C3, 0x038F, 0x0007, 0x0080, 0x0477, 0x0084, 0xFFFF, 0x0087, 0xFFFF, 0x199A,
	0x6554, 0x005E, 0x65AD, 0x00DA, 0x0485, 0x8600, 0x0295, 0x036B, 0x8900, 0x0086, 0x0005, 0x0082, 0x040A, 0x1106, 0x0363, 0x18DE, 0x147F,
	0x4D36, 0xB900, 0x0294, 0x036B, 0x009A, 0x0001, 0x00FA, 0x0401, 0x8F00, 0x0086, 0x0002, 0x0082, 0x0408, 0x1106, 0x039B, 0x8100, 0x195E,
	0x1200, 0xB100, 0x0275, 0x1300, 0x1C7E, 0x195E, 0x195F, 0x5C00, 0x14FB, 0x1F5E, 0x1F1C, 0x185E, 0x0240, 0x00FF, 0x1F7E, 0x185E, 0x1478,
	0x009C, 0x0000, 0xD100, 0x0295, 0x0390, 0x185E, 0x0272, 0x7400, 0x0271, 0x7800, 0x1A5E, 0x0006, 0x00DE, 0x038F, 0x5600, 0x029D, 0x0399,
	0x1C1E, 0x02BF, 0x0CA9, 0x0000, 0x1B5F, 0x000A, 0x8E00, 0x8100, 0x00DE, 0x0407, 0xB100, 0x0295, 0x03B2, 0x00C3, 0x038F, 0x0087, 0x004F,
	0x001F, 0x0080, 0x0477, 0x0084, 0xFFFF, 0x0087, 0xFFFF, 0x19FA, 0x6557, 0x005E, 0x65AF, 0x00DA, 0x0406, 0x8600, 0x0294, 0x03BA, 0x8100,
	0x00FE, 0x0404, 0x02BF, 0x00CA, 0x00DE, 0x0354, 0x7400, 0x00FE, 0x0354, 0x0E00, 0x00FE, 0x034E, 0x0E04, 0x02BF, 0x066A, 0x00DE, 0x0355,
	0x0260, 0xFF00, 0x02BF, 0x0674, 0x02BF, 0x0C0A, 0x02BF, 0x0C1C, 0x02BF, 0x0C71, 0x00DE, 0x0341, 0x7800, 0x00FE, 0x0341, 0x0080, 0x09A0,
	0x0083, 0x0D00, 0x0F50, 0x0098, 0x5A82, 0x02BF, 0x00EB, 0x0080, 0x09A0, 0x0083, 0x0D60, 0x0F50, 0x02BF, 0x00EB, 0x0083, 0x0D00, 0x02BF,
	0x0CC1, 0x0081, 0x0388, 0x009F, 0x0D00, 0x0080, 0x0050, 0x02BF, 0x0530, 0x0080, 0x0FA0, 0x0083, 0x0D60, 0x0F50, 0x0098, 0x8000, 0x02BF,
	0x00EB, 0x0083, 0x0D60, 0x02BF, 0x0CC1, 0x0081, 0x038A, 0x009F, 0x0D60, 0x0080, 0x0050, 0x02BF, 0x0530, 0x009A, 0x0000, 0x0098, 0x00A0,
	0x0080, 0x0388, 0x02BF, 0x0233, 0x0080, 0x038A, 0x02BF, 0x0233, 0x02BF, 0x01EA, 0x0000, 0x0000, 0x0080, 0x002D, 0x029F, 0x0603, 0x0080,
	0x0346, 0x02BF, 0x0067, 0x02BF, 0x0067, 0x0081, 0x0346, 0x193E, 0x193C, 0x009F, 0x0400, 0x00C0, 0x0345, 0x02BF, 0x0525, 0x0081, 0x0348,
	0x193E, 0x193C, 0x009F, 0x0800, 0x00C0, 0x0345, 0x02BF, 0x0525, 0x0081, 0x0346, 0x193E, 0x193C, 0x009F, 0x0800, 0x00C0, 0x0345, 0x02BF,
	0x0532, 0x0081, 0x0348, 0x193E, 0x193C, 0x009F, 0x0400, 0x00C0, 0x0345, 0x02BF, 0x0532, 0x029F, 0x0043, 0x0080, 0x0346, 0x02BF, 0x0067,
	0x02BF, 0x0067, 0x0081, 0x0346, 0x193E, 0x193C, 0x009F, 0x0400, 0x00C0, 0x0345, 0x02BF, 0x0525, 0x0081, 0x0348, 0x193E, 0x193C, 0x009F,
	0x0400, 0x00C0, 0x0345, 0x02BF, 0x0532, 0x029F, 0x0043, 0x0080, 0x0346, 0x02BF, 0x0067, 0x02BF, 0x0067, 0x0081, 0x0346, 0x193E, 0x193C,
	0x009F, 0x0400, 0x00C0, 0x0345, 0x02BF, 0x0555, 0x0081, 0x0348, 0x193E, 0x193C, 0x009F, 0x0400, 0x00C0, 0x0345, 0x02BF, 0x0532, 0x029F,
	0x0043, 0x0080, 0x0346, 0x02BF, 0x0067, 0x02BF, 0x0067, 0x0081, 0x0346, 0x193E, 0x193C, 0x009F, 0x0400, 0x00C0, 0x0344, 0x02BF, 0x0525,
	0x0081, 0x0348, 0x193E, 0x193C, 0x009F, 0x0800, 0x00C0, 0x0344, 0x02BF, 0x0525, 0x0080, 0x0400, 0x0083, 0x0800, 0x0084, 0x0000, 0x00DA,
	0x0345, 0x00DF, 0x0344, 0x8F00, 0x197B, 0xB800, 0x197B, 0x007F, 0x04B2, 0x199E, 0xBC00, 0x80B2, 0x0000, 0x8E00, 0x0081, 0x0346, 0x193E,
	0x193C, 0x009F, 0x0400, 0x00C0, 0x0344, 0x02BF, 0x0532, 0x029F, 0x0043, 0x0092, 0x00FF, 0x8100, 0x0080, 0x0B00, 0x10FF, 0x1B1E, 0x1B1E,
	0x8100, 0x009F, 0x0B00, 0x0080, 0x0100, 0x02BF, 0x0573, 0x02DF, 0x02BF, 0x04E1, 0x00DF, 0x04FB, 0x009E, 0x0B00, 0x4C00, 0x1C1E, 0x181E,
	0x7400, 0x1A1E, 0x02BF, 0x04EA, 0x8100, 0x00FE, 0x04FB, 0x02DF, 0x0092, 0x00FF, 0x8100, 0x009F, 0x0B00, 0x0080, 0x0040, 0x029F, 0x0555,
	0x8100, 0x009F, 0x0B00, 0x0080, 0x0050, 0x029F, 0x0573, 0x02BF, 0x04E1, 0x8900, 0x0080, 0x04FC, 0x8100, 0x1104, 0x0505, 0x0000, 0x191E,
	0x0000, 0x1110, 0x0503, 0x02C0, 0x0001, 0x027D, 0x7500, 0x147F, 0x0000, 0x0000, 0x0000, 0x00DE, 0x04FC, 0x00FE, 0x0B48, 0x00DE, 0x04FD,
	0x00FE, 0x0B49, 0x00DE, 0x04FE, 0x00FE, 0x0B4A, 0x00DE, 0x04FF, 0x00FE, 0x0B4B, 0x009E, 0x0B00, 0x4C00, 0x1C1E, 0x181E, 0x7400, 0x1A1E,
	0x02BF, 0x04EA, 0x02DF, 0x02BF, 0x04EA, 0x02DF, 0x193E, 0x193C, 0x2FCD, 0x0F00, 0x2FC9, 0x2ECE, 0x2CCF, 0x1FE0, 0x1501, 0x2FCB, 0x02BF,
	0x0536, 0x02DF, 0x193E, 0x193C, 0x2FCD, 0x0F01, 0x029F, 0x0527, 0x26C9, 0x02A0, 0x0004, 0x029C, 0x0536, 0x02DF, 0x193E, 0x193C, 0x00FF,
	0xFFCD, 0x0F00, 0x00FF, 0xFFC9, 0x00FE, 0xFFCE, 0x00FC, 0xFFCF, 0x1FE0, 0x1501, 0x00FF, 0xFFCB, 0x02DF, 0x00DE, 0xFFC9, 0x02A0, 0x0004,
	0x029C, 0x054C, 0x02DF, 0x193E, 0x193C, 0x0240, 0x7FFF, 0x02BF, 0x0561, 0x007A, 0x055F, 0x26D3, 0x1B3E, 0x0000, 0x0000, 0x0000, 0x02DF,
	0x1C3F, 0x0F0A, 0x2FD1, 0x1F5E, 0x1F1C, 0x009E, 0xFFFF, 0x2ED6, 0x2ED7, 0x1FDA, 0x1F98, 0x147F, 0x2ED8, 0x2CD9, 0x1F40, 0x02DF, 0x193E,
	0x193C, 0x0090, 0x0001, 0x02BF, 0x0561, 0x007A, 0x057E, 0x193E, 0x2ED3, 0x0000, 0x0000, 0x0000, 0x0000, 0x02DF, 0x0080, 0x0346, 0x02BF,
	0x0067, 0x02BF, 0x0067, 0x0081, 0x0346, 0x00DF, 0x0349, 0x0340, 0xFFFF, 0x00C0, 0x0345, 0x02BF, 0x0523, 0x029F, 0x0043, 0x0080, 0x0346,
	0x02BF, 0x0067, 0x02BF, 0x0067, 0x0081, 0x0346, 0x00DF, 0x0349, 0x0340, 0xFFFF, 0x00C0, 0x0345, 0x02BF, 0x0530, 0x029F, 0x0043, 0x0092,
	0x00FF, 0x009E, 0xFFFF, 0x2ED4, 0x2ED5, 0x2ED6, 0x2ED7, 0x02DF, 0x00FF, 0xFFD1, 0x0340, 0x0003, 0x7900, 0x02CA, 0x00FE, 0xFFD8, 0x00FC,
	0xFFD9, 0x02DF, 0x1205, 0x8E00, 0x00F0, 0x03FD, 0x00FC, 0x03FF, 0xF400, 0x00FC, 0x03FE, 0x00FA, 0x03FA, 0x8100, 0x00DE, 0xFFFE, 0x02C0,
	0x8000, 0x029C, 0x06B9, 0x00DA, 0xFFFF, 0x8600, 0x0294, 0x0692, 0x00DE, 0xFFFE, 0x02C0, 0x8000, 0x029C, 0x05CF, 0x0240, 0x000F, 0x1F5E,
	0x7400, 0x0C00, 0x1404, 0x00FE, 0x034E, 0x1FDA, 0x1F40, 0x0200, 0x04FC, 0x1C1E, 0x00DE, 0xFFFF, 0x1A1E, 0x1C1A, 0x00DE, 0x03FE, 0x00DC,
	0x03FF, 0x00D0, 0x03FD, 0x00DA, 0x03FA, 0x1305, 0x02FF, 0x009A, 0x0002, 0x00FA, 0x03A3, 0x00E0, 0x03F9, 0x02BF, 0x067C, 0x16FC, 0xDCD1,
	0x16FD, 0x0002, 0x16FB, 0x0001, 0x0021, 0x0617, 0x0618, 0x0658, 0x065B, 0x00E0, 0x03F9, 0x009E, 0x0005, 0x02BF, 0x066A, 0x8E00, 0x8100,
	0x8900, 0x02BF, 0x065E, 0x27FF, 0x009E, 0x05FF, 0x4C00, 0x1C7E, 0x0313, 0x1C7F, 0x176F, 0x0021, 0x0021, 0x009A, 0x0002, 0x00FA, 0x03A3,
	0x8100, 0x8900, 0x02BF, 0x065E, 0x24FF, 0x02BF, 0x0664, 0x25FF, 0x02BF, 0x0664, 0x27FF, 0x2ECE, 0x2CCF, 0x16C9, 0x0001, 0x2FCD, 0x2DCB,
	0x8100, 0x8900, 0x02BF, 0x065E, 0x24FF, 0x1C9E, 0x1CBC, 0x02BF, 0x0664, 0x25FF, 0x02BF, 0x0664, 0x27FF, 0x1CDF, 0x1CFD, 0x8100, 0x02BF,
	0x065E, 0x26FF, 0x1C1E, 0x8900, 0x02BF, 0x0664, 0x20FF, 0x1F5F, 0x02BF, 0x065E, 0x21FF, 0x02BF, 0x065E, 0x23FF, 0x26C9, 0x02A0, 0x0004,
	0x029C, 0x064C, 0x1206, 0x1203, 0x1204, 0x1205, 0x029F, 0x80B5, 0x0021, 0x029F, 0x8000, 0x0021, 0x00C0, 0x03F9, 0x170F, 0x26FE, 0x02C0,
	0x8000, 0x029C, 0x065E, 0x02DF, 0x27FE, 0x03C0, 0x8000, 0x029C, 0x0664, 0x02DF, 0x02BF, 0x0682, 0x16FC, 0xDCD1, 0x2EFD, 0x16FB, 0x0001,
	0x02BF, 0x0682, 0x02DF, 0x02BF, 0x0682, 0x16FC, 0xF355, 0x2EFD, 0x02BF, 0x0682, 0x02DF, 0x26FC, 0x02C0, 0x8000, 0x029D, 0x067C, 0x02DF,
	0x27FC, 0x03C0, 0x8000, 0x029D, 0x0682, 0x02DF, 0x009A, 0x0280, 0x00FA, 0x0350, 0x00FA, 0x0351, 0x0A00, 0x00FA, 0x0352, 0x02DF, 0x00E0,
	0x03FB, 0x00E8, 0x03FC, 0x00C0, 0x0350, 0x0088, 0x002F, 0x1B1A, 0x00DE, 0xFFFE, 0x02C0, 0x8000, 0x029C, 0x069B, 0x00DC, 0xFFFF, 0x1B1E,
	0x1B1C, 0x1FDA, 0x7800, 0x1F5E, 0x8600, 0x0294, 0x069B, 0x8100, 0x00DE, 0x0352, 0x7400, 0x00FE, 0x0352, 0x00E0, 0x0350, 0x00C0, 0x03FB,
	0x00C8, 0x03FC, 0x029F, 0x05E6, 0x00E0, 0x03FB, 0x00E8, 0x03FC, 0x00C0, 0x0350, 0x0088, 0x002F, 0x0A00, 0x1B1A, 0x029F, 0x06AB, 0x00C0,
	0x0351, 0x0088, 0x002F, 0x00DA, 0x0352, 0x8600, 0x0295, 0x06ED, 0x1205, 0x00DA, 0x0352, 0x1FDA, 0x7800, 0x00FE, 0x0352, 0x1305, 0x0081,
	0x0356, 0x191E, 0x02C0, 0x8000, 0x029D, 0x06F1, 0x1F5E, 0x8600, 0x0295, 0x06F5, 0x007A, 0x06E6, 0x191E, 0x1B3E, 0x191E, 0x1B3E, 0x00E0,
	0x0351, 0x0088, 0xFFFF, 0x029F, 0x002F, 0x0088, 0xFFFF, 0x029F, 0x002D, 0x00E0, 0x0351, 0x029F, 0x06C9, 0x0080, 0x06C5, 0x029F, 0x05F0,
	0x8100, 0x0E10, 0x2232, 0x8600, 0x02D5, 0x5400, 0x0200, 0x0458, 0x1C1E, 0x1FDA, 0x04FE, 0x1F1E, 0x191E, 0x0291, 0x070C, 0x191A, 0x0058,
	0x64A0, 0x6433, 0x1B7E, 0x02DF, 0x02BF, 0x06F9, 0x8100, 0x2632, 0x5C00, 0x2E32, 0x0092, 0x00FF, 0x02DF, 0x00DE, 0x04FB, 0x7400, 0x00FE,
	0x04FB, 0x8100, 0x2E32, 0x2E66, 0x2E67, 0x268A, 0x248B, 0x2E3A, 0x2C3B, 0x268C, 0x248D, 0x2E38, 0x2C39, 0x02DF, 0x8100, 0x2689, 0x0240,
	0x000F, 0x1F5E, 0x8100, 0x0E10, 0x5400, 0x2E32, 0x268A, 0x248B, 0x2288, 0x2089, 0x5800, 0x0A00, 0x2032, 0x5800, 0x2E3A, 0x2C3B, 0x02DF,
	0x0092, 0x0004, 0x8100, 0x2604, 0xB100, 0x02B4, 0x0717, 0x8100, 0x2601, 0xB100, 0x0294, 0x07E5, 0x2232, 0xC900, 0x0293, 0x070E, 0x5500,
	0x02BF, 0x06F9, 0x223A, 0x8600, 0x0294, 0x0759, 0x8100, 0x263B, 0x8200, 0x0291, 0x07AB, 0x8100, 0x1FDF, 0x040F, 0x147C, 0x1F7E, 0x0C00,
	0x1404, 0x1F1E, 0x0A00, 0x8100, 0x263A, 0x243B, 0x5800, 0x0290, 0x0771, 0x8100, 0x263B, 0x5C00, 0x2E32, 0x8100, 0x2E3A, 0x2E3B, 0x029F,
	0x0777, 0x2E3A, 0x2C3B, 0x0C00, 0x1FD8, 0x5C00, 0x2E32, 0x8100, 0x1FDB, 0x02BF, 0x07EB, 0x2232, 0x8600, 0x0295, 0x07A8, 0x0A10, 0x8100,
	0x1FC3, 0x5400, 0x1C7E, 0x0080, 0x0458, 0x197E, 0x197A, 0x100E, 0x64A2, 0x1B1E, 0x1B1A, 0x8100, 0x263A, 0x243B, 0xB100, 0x0294, 0x07A8,
	0x2232, 0x8600, 0x0295, 0x07A8, 0x0080, 0x0467, 0x8100, 0x268B, 0xB100, 0x0295, 0x07A8, 0x0200, 0x000F, 0x0240, 0x000F, 0x0200, 0x0458,
	0x1C7E, 0x007A, 0x07A7, 0x18FE, 0x1A9E, 0x0092, 0x00FF, 0x02DF, 0xB100, 0x0295, 0x07BB, 0x5D00, 0x040F, 0x147C, 0x0C00, 0x00E3, 0x0363,
	0x02BF, 0x07EB, 0x00DE, 0x0363, 0x223B, 0x4400, 0x1C7E, 0x8100, 0x2681, 0xB100, 0x0295, 0x07E3, 0x2380, 0x2688, 0x2489, 0x1408, 0x14F4,
	0x2380, 0x8D00, 0xC810, 0xAE00, 0x8C00, 0xF000, 0x4E00, 0x238C, 0x218D, 0x4A00, 0x2E38, 0x2C39, 0x2682, 0x2E67, 0x2683, 0x2E66, 0x00E3,
	0x0363, 0x0083, 0x0458, 0x8100, 0x0E01, 0x02BF, 0x07EB, 0x00C3, 0x0363, 0x02BF, 0x0729, 0x029F, 0x0749, 0x0E01, 0x2E01, 0x8100, 0x005F,
	0x1B7E, 0x0092, 0x00FF, 0x02DF, 0x00FF, 0x0360, 0x00FE, 0x0361, 0x2638, 0x2439, 0x0F05, 0x02BF, 0x05AD, 0x2638, 0x2439, 0x8900, 0x00DF,
	0x0361, 0x2280, 0xD000, 0x6F00, 0x4C00, 0x2E38, 0x2C39, 0x8100, 0x00DE, 0x0361, 0x007E, 0x086B, 0x0080, 0xFFD3, 0x0084, 0x0000, 0x199E,
	0x8900, 0x1FFE, 0x1401, 0x0240, 0x001E, 0x0200, 0x0300, 0x1C3E, 0x157C, 0x0340, 0x000F, 0x0A11, 0x5500, 0x8100, 0x2680, 0x0605, 0x0295,
	0x0832, 0x009A, 0x00F0, 0x0B0F, 0x0082, 0x0364, 0x1998, 0x6000, 0x1107, 0x0829, 0x3400, 0x1408, 0x6032, 0x3644, 0x140C, 0x6032, 0x3400,
	0x1408, 0x6032, 0x3600, 0x140C, 0x1B5E, 0x029F, 0x0852, 0x009A, 0xC000, 0x0082, 0x0364, 0x1998, 0x6000, 0x1103, 0x0845, 0x1408, 0x3400,
	0x6032, 0x140A, 0x3400, 0x6032, 0x140C, 0x3400, 0x6032, 0x140E, 0x3444, 0x6032, 0x1408, 0x3400, 0x6032, 0x140A, 0x3400, 0x6032, 0x140C,
	0x3400, 0x6032, 0x140E, 0x3400, 0x1B5E, 0x8F00, 0x1F7F, 0x2066, 0x2767, 0x193A, 0x1939, 0x0080, 0x0364, 0x1C80, 0xA000, 0xEA70, 0x1108,
	0x0866, 0x3A93, 0xA478, 0x1485, 0xE833, 0x3B92, 0xA570, 0x1585, 0xEA3B, 0x2F67, 0x8E00, 0x1FF8, 0x2F66, 0x8900, 0x00DF, 0x0360, 0x02DF,
	0xB100, 0x02D5, 0x04FE, 0x1F1E, 0x191E, 0x0291, 0x087A, 0x191A, 0x0058, 0x64A0, 0x6433, 0x1B7E, 0x02DF, 0x8100, 0x1F5E, 0x00D8, 0x0402,
	0x00DC, 0x0430, 0x0080, 0x0520, 0x00DF, 0x0480, 0x1501, 0x0340, 0x007E, 0x0300, 0x0891, 0x1C5F, 0x175F, 0x00FC, 0x0430, 0x029F, 0x02D8,
	0x029F, 0x08B2, 0x029F, 0x08ED, 0x029F, 0x08D5, 0x029F, 0x08C2, 0x029F, 0x08FB, 0x029F, 0x08B1, 0x029F, 0x0919, 0x029F, 0x091C, 0x029F,
	0x08B1, 0x029F, 0x08B1, 0x029F, 0x093A, 0x029F, 0x08F3, 0x029F, 0x08F7, 0x029F, 0x08B1, 0x029F, 0x08B1, 0x029F, 0x08B1, 0x02DF, 0x1401,
	0x009B, 0xC000, 0x0099, 0x4000, 0x1150, 0x08BF, 0x02C0, 0x0001, 0x027C, 0x1B1B, 0x027D, 0x1B19, 0x4800, 0x147F, 0x02DF, 0x1402, 0x8900,
	0x1FB8, 0x1501, 0x009B, 0xC000, 0x0099, 0x4000, 0x1150, 0x08D2, 0x02C0, 0x0003, 0x027C, 0x1B1B, 0x027D, 0x1B19, 0x4C00, 0x147E, 0x02DF,
	0x1401, 0x0081, 0x0CA0, 0x009B, 0xC000, 0x0099, 0x4000, 0x8900, 0x0082, 0x0000, 0x1150, 0x08EA, 0x02C0, 0x0001, 0x027C, 0x1B1B, 0x027D,
	0x1B19, 0x183D, 0x4900, 0x1FE2, 0x4C39, 0x147F, 0x02DF, 0x8900, 0x1FB8, 0x157F, 0x1050, 0x4C20, 0x02DF, 0x0082, 0x0180, 0x029F, 0x08FD,
	0x0082, 0x01C0, 0x029F, 0x08FD, 0x0082, 0x0140, 0x008A, 0x003F, 0x0086, 0x0000, 0x1406, 0x8900, 0x1FB8, 0x1505, 0x009B, 0x003F, 0x009A,
	0x0000, 0x3600, 0x1CDE, 0x001A, 0x3400, 0x1150, 0x0913, 0x4C4A, 0x3606, 0x1CDE, 0x340E, 0x1B19, 0x1FC2, 0x147A, 0x008A, 0xFFFF, 0x02DF,
	0x1050, 0x1B18, 0x02DF, 0x0082, 0x0100, 0x008A, 0x003F, 0x0086, 0x0000, 0x1406, 0x8900, 0x1FB8, 0x1505, 0x009B, 0x003F, 0x009A, 0x0000,
	0x3600, 0x1CDE, 0x001A, 0x3400, 0x1150, 0x0934, 0x4C4A, 0x3606, 0x1CDE, 0x340E, 0x1B19, 0x1FC2, 0x147A, 0x008A, 0xFFFF, 0x02DF, 0x0082,
	0x0100, 0x008A, 0x003F, 0x0086, 0x0000, 0x0081, 0x0CA0, 0x1406, 0x8900, 0x1FB8, 0x1505, 0x009B, 0x003F, 0x009A, 0x0000, 0x3600, 0x1CDE,
	0x001A, 0x3400, 0x1150, 0x0959, 0x1939, 0xA000, 0x140A, 0x4E00, 0x1476, 0x4C4A, 0x3606, 0x1CDE, 0x340E, 0x1B19, 0x1FC2, 0x147A, 0x008A,
	0xFFFF, 0x02DF, 0x0080, 0x01BE, 0x1918, 0x191A, 0x0080, 0x0180, 0x0083, 0x0180, 0x9070, 0x1FFE, 0x1120, 0x0970, 0x7C00, 0xD450, 0x6533,
	0xC550, 0x1501, 0x643B, 0x0080, 0x01FE, 0x191A, 0x1918, 0x0080, 0x01C0, 0x0083, 0x01C0, 0x1FF8, 0x9070, 0xF800, 0x0240, 0x01FF, 0x0260,
	0x2000, 0x02BF, 0x0983, 0x02DF, 0xB900, 0x0272, 0x7C00, 0x1F7E, 0x4700, 0x1110, 0x098D, 0x473B, 0x473B, 0x473B, 0x473B, 0x02DF, 0x0092,
	0x0004, 0x2002, 0x8100, 0x8900, 0x2430, 0x8D00, 0x0950, 0xA000, 0xA400, 0x1404, 0x8C00, 0x1FFE, 0x0083, 0x0580, 0x2201, 0x8600, 0x0294,
	0x09B1, 0x2204, 0x8600, 0x02B4, 0x09F9, 0x8100, 0x2605, 0xB100, 0x0295, 0x09BE, 0x8100, 0x2E05, 0x2281, 0x8600, 0x0294, 0x09B8, 0x8100,
	0x005F, 0x1B7E, 0x7400, 0x2E01, 0x029F, 0x09F2, 0x2688, 0x2489, 0x2E34, 0x2C35, 0x02BF, 0x09F9, 0x00FF, 0x0360, 0x2638, 0x2439, 0x0F05,
	0x02BF, 0x05AD, 0x00DF, 0x0360, 0x8100, 0x263A, 0xB100, 0x0294, 0x09D9, 0x263B, 0x5C00, 0x0290, 0x09D9, 0x223B, 0x02BF, 0x0A0A, 0x5500,
	0x0A01, 0x00FA, 0x0405, 0x029F, 0x09AB, 0x1F5F, 0x02BF, 0x0A0A, 0x00FA, 0x0362, 0x8100, 0x263A, 0x243B, 0x1570, 0x0A01, 0x0081, 0x0405,
	0x5C00, 0xB100, 0x0275, 0x1A3A, 0x2E3A, 0x2C3B, 0x2638, 0x2439, 0x00D8, 0x0362, 0x7000, 0x2C39, 0x2E38, 0x0092, 0x00FF, 0x029F, 0x02D0,
	0x8100, 0x2E34, 0x2E35, 0x2334, 0x2135, 0x268A, 0x248B, 0x5A00, 0x2E3A, 0x2C3B, 0x2634, 0x2435, 0x238C, 0x218D, 0x4A00, 0x2E38, 0x2C39,
	0x8100, 0x2E05, 0x02DF, 0x0080, 0xFFD3, 0x0084, 0x0000, 0x007A, 0x0A12, 0x199E, 0x1488, 0x1B7E, 0x02DF, 0x0092, 0x0004, 0x2002, 0x8100,
	0x8900, 0x2430, 0x8D00, 0x0950, 0xA000, 0xA400, 0x1404, 0x8C00, 0x1FFE, 0x0083, 0x0580, 0x2201, 0x8600, 0x0294, 0x0A36, 0x2204, 0x8600,
	0x02B4, 0x0A7F, 0x8100, 0x2605, 0xB100, 0x0295, 0x0A43, 0x8100, 0x2E05, 0x2281, 0x8600, 0x0294, 0x0A3D, 0x8100, 0x005F, 0x1B7E, 0x7400,
	0x2E01, 0x029F, 0x0A78, 0x2688, 0x2489, 0x2E34, 0x2C35, 0x02BF, 0x0A7F, 0x00FF, 0x0360, 0x2638, 0x2439, 0x0F06, 0x02BF, 0x05AD, 0x00DF,
	0x0360, 0x8100, 0x263A, 0xB100, 0x0294, 0x0A5E, 0x263B, 0x5C00, 0x0290, 0x0A5E, 0x223B, 0x02BF, 0x0A91, 0x5500, 0x0A01, 0x00FA, 0x0405,
	0x029F, 0x0A30, 0x1F5F, 0x02BF, 0x0A91, 0x00FA, 0x0362, 0x8100, 0x263A, 0x243B, 0x1570, 0x0A01, 0x0081, 0x0405, 0x5C00, 0xB100, 0x0275,
	0x1A3A, 0x2E3A, 0x2C3B, 0x2638, 0x2439, 0x00D8, 0x0362, 0x7000, 0x7000, 0x2C39, 0x2E38, 0x0092, 0x00FF, 0x029F, 0x02D0, 0x8100, 0x2E34,
	0x2E35, 0x2334, 0x2135, 0x268A, 0x248B, 0x5A00, 0x2E3A, 0x2C3B, 0x2634, 0x2435, 0x1401, 0x238C, 0x218D, 0x4A00, 0x2E38, 0x2C39, 0x8100,
	0x2E05, 0x02DF, 0x0080, 0xFFD3, 0x0084, 0x0000, 0x007A, 0x0A98, 0x199E, 0x1B7E, 0x02DF, 0x8900, 0x0F50, 0x0083, 0x0520, 0x02BF, 0x0AB3,
	0x029F, 0x02D8, 0x00D8, 0x0402, 0x8100, 0x8900, 0x00DC, 0x0430, 0x0A50, 0x9000, 0x9400, 0x1404, 0x1FFE, 0x0083, 0x0580, 0x02BF, 0x0AB3,
	0x029F, 0x02D0, 0x0092, 0x0004, 0x8100, 0x263A, 0x243B, 0x1F1F, 0x0A00, 0x5800, 0x0292, 0x0AD1, 0x8900, 0x00C0, 0x043B, 0x02BF, 0x0AF6,
	0x8100, 0x1FD8, 0x223B, 0x5400, 0x0007, 0x1979, 0x005E, 0x1B79, 0x0F01, 0x2F01, 0x8900, 0x2F3B, 0x0092, 0x00FF, 0x02DF, 0x2E3A, 0x2C3B,
	0x8100, 0x8900, 0x268A, 0x2734, 0x5C00, 0x2E36, 0x5000, 0x0290, 0x0AF0, 0x00C0, 0x0436, 0x02BF, 0x0AF6, 0x8100, 0x1FD8, 0x2236, 0x5400,
	0x1C1E, 0x8100, 0x2E34, 0x2688, 0x2489, 0x2E8C, 0x2C8D, 0x02BF, 0x0AF6, 0x0092, 0x00FF, 0x02DF, 0x1C18, 0x02BF, 0x0AF6, 0x0092, 0x00FF,
	0x02DF, 0x8100, 0x1FC0, 0xB100, 0x02D5, 0x8900, 0x2734, 0x0340, 0x0001, 0x0B00, 0x1F3F, 0x268C, 0x248D, 0x8900, 0x2534, 0x1501, 0x4C00,
	0x5A00, 0x5A00, 0x1C20, 0x1FE0, 0x0502, 0x1C1F, 0x009F, 0x0B00, 0x0092, 0x00FF, 0x02BF, 0x0525, 0x0092, 0x0004, 0x2734, 0x1F61, 0x4700,
	0x2F34, 0x0080, 0x0B00, 0x8900, 0x1FF9, 0xB900, 0x0274, 0x0008, 0x8900, 0x1FE1, 0x191E, 0x0701, 0x0293, 0x0B2C, 0x191A, 0x05FE, 0x005F,
	0x64A0, 0x1B7E, 0x1B7A, 0x02DF, 0x1B7E, 0x02DF, 0x8A00, 0x0083, 0x03E8, 0x191E, 0x191A, 0x1006, 0x64A0, 0x1B7E, 0x1B7A, 0x0080, 0x03E8,
	0x0088, 0x0007, 0x1150, 0x0B48, 0x1C61, 0x84C3, 0xF2C3, 0xF2C3, 0xF2C3, 0xF2C3, 0xF2C3, 0xF2C3, 0xF2C3, 0xF200, 0xFE00, 0x1B3E, 0x0088,
	0xFFFF, 0x8B00, 0x02DF, 0x8A00, 0x05FE, 0x0083, 0x03E8, 0x191E, 0x191A, 0x005F, 0x64A0, 0x1B7E, 0x1B7A, 0x0080, 0x03E8, 0x0501, 0x1D1F,
	0x1150, 0x0B63, 0x1C61, 0x84C3, 0x005F, 0xF2C3, 0xF200, 0xFE00, 0x1B3E, 0x0088, 0xFFFF, 0x8B00, 0x02DF, 0x0083, 0x03E8, 0x191E, 0x191A,
	0x64A0, 0x64A0, 0x1B7E, 0x1B7A, 0x0080, 0x03E8, 0x0088, 0x0003, 0x0085, 0x0000, 0x0087, 0x0000, 0x1FC2, 0x195B, 0x1959, 0x195F, 0x195A,
	0x1C5E, 0x1FDA, 0x1C61, 0x8A00, 0x8F00, 0x191A, 0xB850, 0xE250, 0xEA50, 0xE8E8, 0xB650, 0x1127, 0x0B93, 0xE3A8, 0x197E, 0xE850, 0xEAF8,
	0xBF50, 0xE2A9, 0x197F, 0xEA50, 0xE8E8, 0xB650, 0xE3A8, 0x197E, 0xE850, 0xEAF8, 0xBF00, 0x1BFF, 0x197F, 0x8E00, 0x8B00, 0x0088, 0xFFFF,
	0x1B5B, 0x1B59, 0x1B5F, 0x1B5E, 0x02DF, 0x0083, 0x03E8, 0x191E, 0x191A, 0x64A0, 0x64A0, 0x1B7E, 0x1B7A, 0x0080, 0x03E8, 0x0088, 0x0003,
	0x0085, 0x0000, 0x0087, 0x0000, 0x1FC2, 0x195B, 0x1959, 0x195F, 0x195A, 0x1C5E, 0x1FDA, 0x1C61, 0x8A00, 0x8F00, 0x191A, 0xB800, 0xE350,
	0xE250, 0xEA00, 0xEA50, 0xE877, 0xECE8, 0xB200, 0x1127, 0x0BD8, 0xE250, 0xE3A8, 0x197E, 0xE800, 0xE850, 0xEA7F, 0xEEF8, 0xBB00, 0xE350,
	0xE2A9, 0x197F, 0xEA00, 0xEA50, 0xE877, 0xECE8, 0xB200, 0xE250, 0xE3A8, 0x197E, 0xE800, 0xE850, 0xEA7F, 0xEEF8, 0xBB00, 0x1BFF, 0x197F,
	0x8E00, 0x8B00, 0x0088, 0xFFFF, 0x1B5B, 0x1B59, 0x1B5F, 0x1B5E, 0x02DF, 0x0EFF, 0x00FE, 0x03F2, 0x8100, 0x00FE, 0x03F0, 0x00FE, 0x03F6,
	0x009E, 0x0100, 0x00FE, 0x03F7, 0x00DA, 0x03F7, 0x009E, 0x8000, 0x5400, 0x00FE, 0x03F5, 0x0E30, 0x00FE, 0x03F3, 0x0E10, 0x00FE, 0x03F4,
	0x009E, 0x0096, 0x00FE, 0x03F1, 0x02DF, 0x0080, 0x0A00, 0x8100, 0x00DE, 0x03F0, 0x8900, 0xB100, 0x0275, 0x0550, 0x00FF, 0x03F0, 0x0200,
	0x0A60, 0x1C7E, 0x0F4E, 0x02BF, 0x00DA, 0x02DF, 0x00DE, 0x03F1, 0x0200, 0x0A60, 0x1C7E, 0x8100, 0x8900, 0x009F, 0x00A0, 0x00DE, 0x03F1,
	0x5D00, 0x0E50, 0x0750, 0x0270, 0x5D00, 0x00DA, 0x03F2, 0x8600, 0x0290, 0x0C4D, 0x00DE, 0x03F3, 0x5C00, 0x0293, 0x0C38, 0x029F, 0x0C52,
	0x00DB, 0x03F7, 0x009E, 0x8000, 0x4600, 0x029F, 0x0C44, 0x00DB, 0x03F7, 0x009E, 0x8000, 0x5600, 0x00FE, 0x03F5, 0x1FDA, 0x7C00, 0x1F5E,
	0x00FE, 0x03F2, 0x029F, 0x0C52, 0x00DE, 0x03F4, 0x5D00, 0x0293, 0x0C3F, 0x8900, 0x00DD, 0x03F5, 0x1501, 0x8100, 0x00DC, 0x03F6, 0x008B,
	0x009F, 0x0080, 0x0A00, 0x0900, 0x1150, 0x0C65, 0x1878, 0x4C00, 0x1CFE, 0x001F, 0x1FD9, 0x1B18, 0x009F, 0x0A60, 0x1FC3, 0x5C00, 0x00FE,
	0x03F1, 0x00FC, 0x03F6, 0x008B, 0xFFFF, 0x02DF, 0x0F50, 0x0080, 0x0A00, 0x0083, 0x0D60, 0x0098, 0x3FFF, 0x02BF, 0x00EB, 0x0F50, 0x0080,
	0x0A00, 0x0083, 0x0D00, 0x0098, 0x3FFF, 0x02BF, 0x00EB, 0x02DF, 0x8A00, 0x8F00, 0x8100, 0x00DE, 0x0404, 0xB100, 0x0295, 0x0C91, 0x8100,
	0x00FE, 0x0478, 0x00FE, 0x0479, 0x00DF, 0x0479, 0x00DB, 0x0478, 0x0900, 0x0084, 0x0000, 0x1150, 0x0CA1, 0x199E, 0x5C7C, 0xC000, 0x6E00,
	0x1488, 0x4A00, 0x1B1E, 0x1F7E, 0x00FB, 0x0478, 0x00FF, 0x0479, 0x8B00, 0x8E00, 0x02DF, 0xB900, 0x0294, 0x0CAF, 0x6800, 0xB100, 0x02D5,
	0x1C23, 0x197E, 0x191B, 0xD858, 0x1120, 0x0CB9, 0xDCD3, 0x6231, 0xDCD3, 0x6231, 0x4900, 0x1108, 0x0CBF, 0xDCD3, 0x6231, 0xDCD3, 0x6231,
	0x02DF, 0x8F00, 0x8D00, 0x1C03, 0x00D9, 0x038E, 0x0B04, 0x197A, 0xB053, 0xB600, 0x1128, 0x0CCF, 0x3AD3, 0xB630, 0x3AD3, 0xB630, 0x8C00,
	0x8E00, 0x02DF, 0x00DA, 0x0485, 0x8600, 0x0295, 0x0CE5, 0x8100, 0x00DE, 0x042A, 0x147F, 0x00FE, 0x042B, 0xB100, 0x0294, 0x0CE5, 0x009A,
	0x0001, 0x00FA, 0x0401, 0x8F00, 0x8100, 0x00DE, 0x0428, 0x1478, 0x00DF, 0x0428, 0x0340, 0x007F, 0x1F1E, 0x1F5F, 0x0220, 0x007F, 0x1F3E,
	0x0320, 0x007F, 0x1F7F, 0x8100, 0x8900, 0x009F, 0x0200, 0x1FD8, 0x4C00, 0x1C1E, 0x1818, 0x1FDA, 0x4C00, 0x1C1E, 0x181A, 0x1FD9, 0x4C00,
	0x1C1E, 0x1819, 0x1FDB, 0x4C00, 0x1C1E, 0x181B, 0x8A00, 0x0080, 0x0B00, 0x9800, 0xAE00, 0xB630, 0x9630, 0x6E30, 0x1B1E, 0x8B00, 0x0080,
	0x0B00, 0x0081, 0x0B04, 0x00DA, 0x042A, 0x02BF, 0x0D65, 0x0081, 0x0B08, 0x0080, 0x0B00, 0x00DA, 0x042A, 0x00DE, 0x0429, 0x8A00, 0xC000,
	0x8B00, 0x6E00, 0x1F5E, 0x02BF, 0x0D65, 0x0080, 0x0B00, 0x0081, 0x0B0C, 0x8100, 0x8900, 0x00DE, 0x042B, 0x00DF, 0x042A, 0x00FE, 0x042A,
	0x5C00, 0x1F5E, 0x02BF, 0x0D70, 0x0080, 0x0B0C, 0x0081, 0x0B10, 0x00DA, 0x0429, 0x02BF, 0x0D65, 0x0081, 0x0B04, 0x0082, 0x0B0C, 0x0083,
	0x0D7E, 0x1108, 0x0D62, 0x195F, 0x15FB, 0x1F1D, 0x1F5F, 0x193F, 0x00E1, 0x0B24, 0x00E2, 0x0B25, 0x021B, 0x00E3, 0x0B26, 0x1C7E, 0x00C0,
	0x038F, 0x02BF, 0x0CA9, 0x00C1, 0x0B24, 0x00C2, 0x0B25, 0x00C3, 0x0B26, 0x0000, 0x8E00, 0x02DF, 0x8A00, 0x191F, 0xD078, 0xD678, 0xD631,
	0x191F, 0xD631, 0x6E31, 0x1B3E, 0x8B00, 0x02DF, 0x8A00, 0x8D00, 0x1F7E, 0x1918, 0xA840, 0xAE40, 0xAE31, 0x1918, 0xAE31, 0x6E31, 0x1B3E,
	0x8C00, 0x8B00, 0x02DF, 0x0D00, 0x0D60, 0x0F40, 0x0CA0, 0x0E80, 0x0EE0, 0x0C00, 0x0C50, 0x00F9, 0x0361, 0x1FC0, 0x0200, 0xFFFC, 0x1C1E,
	0x1C5E, 0x0083, 0x043C, 0x197E, 0x197F, 0x80A2, 0x64A3, 0x6530, 0x1B1F, 0x1C02, 0x8100, 0x00DE, 0x0402, 0x00FE, 0x0362, 0x1474, 0x1F7E,
	0x1F3C, 0x8900, 0x00DD, 0x0430, 0x1504, 0x0604, 0x0290, 0x0DFA, 0x1FDD, 0x0082, 0x02B0, 0x1050, 0x4B2A, 0x1FBE, 0x00FE, 0x0360, 0x8900,
	0x1FBE, 0x0AF8, 0x009B, 0x00FC, 0x00D8, 0x0361, 0x0082, 0x02B0, 0x0083, 0x02B0, 0x195E, 0x3480, 0x1128, 0x0DBF, 0x367A, 0x35B3, 0x3772,
	0x34BB, 0x8A00, 0x0082, 0x02B0, 0x00DD, 0x0430, 0x1504, 0x1FE0, 0x8100, 0x00DE, 0x0362, 0x1474, 0x1F7E, 0x1F3C, 0x8F00, 0x1943, 0x4BC3,
	0x90C3, 0xF2C3, 0xF2C3, 0xF200, 0xFE00, 0x1C1F, 0x1943, 0x4BC3, 0x90C3, 0x114E, 0x0DE1, 0xF2C3, 0xF2C3, 0xF231, 0x1C1F, 0x1943, 0x4BC3,
	0x92C3, 0xF2C3, 0xF2C3, 0xF231, 0xFE00, 0x1B3E, 0x8B00, 0x8E00, 0x00FE, 0x0433, 0x1C1F, 0x150C, 0x0340, 0x0FFF, 0x00FF, 0x0430, 0x0083,
	0x043C, 0x191E, 0x191F, 0x80A0, 0x64A1, 0x6533, 0x1B7F, 0x02DF, 0x1FE0, 0x1C1F, 0x1128, 0x0E03, 0x4B70, 0x1B3E, 0x1C1F, 0x4B70, 0x1B3E,
	0x1C1F, 0x029F, 0x0DE9, 0x0083, 0x0520, 0x00DE, 0x0433, 0x1050, 0x1B7E, 0x029F, 0x02D8, 0x1C20, 0x185F, 0x1F7F, 0x193A, 0x6400, 0x0078,
	0x0E18, 0x5659, 0x6730, 0x5551, 0x6438, 0x1A5B, 0x02DF, 0x0098, 0x8240, 0x00F8, 0x04E8, 0x0098, 0x7FFF, 0x00F8, 0x04E9, 0x0098, 0x7DBF,
	0x00F8, 0x04EA, 0x0098, 0x843F, 0x00F8, 0x04EB, 0x0098, 0xB23B, 0x00F8, 0x04F0, 0x0098, 0x7FFF, 0x00F8, 0x04F1, 0x0098, 0x4DC4, 0x00F8,
	0x04F2, 0x0098, 0xD808, 0x00F8, 0x04F3, 0x0098, 0x0000, 0x0080, 0x04EC, 0x1004, 0x1B18, 0x0080, 0x04F4, 0x1004, 0x1B18, 0x02DF, 0x0080,
	0x0F40, 0x0083, 0x0B00, 0x8900, 0x0F50, 0x0098, 0x6784, 0x02BF, 0x00FA, 0x0080, 0x04E8, 0x0082, 0x04EC, 0x0081, 0x0B00, 0x8900, 0x0F50,
	0x0080, 0x0B00, 0x0083, 0x0D00, 0x0098, 0x7FFF, 0x02BF, 0x00EB, 0x8900, 0x0F50, 0x0080, 0x0B00, 0x0083, 0x0D60, 0x0098, 0xB820, 0x02BF,
	0x00EB, 0x0080, 0x0CA0, 0x0083, 0x0B00, 0x8900, 0x0F50, 0x0098, 0x6784, 0x02BF, 0x00FA, 0x0080, 0x04E8, 0x0082, 0x04F4, 0x0081, 0x0B00,
	0x8900, 0x0F50, 0x0080, 0x0B00, 0x0083, 0x0D00, 0x0098, 0x47E0, 0x02BF, 0x00EB, 0x8900, 0x0F50, 0x0080, 0x0B00, 0x0083, 0x0D60, 0x0098,
	0x8001, 0x02BF, 0x00EB, 0x02DF, 0x0000,
};

/**
 * @note Address: 0x800AA900
 * @note Size: 0x38
 */
static void DspHandShake(void* a1)
{
	do {
		;
	} while (!DSPCheckMailFromDSP());
	DSPReadMailFromDSP();
	DSPCheckMailFromDSP();
	Dsp_Running_Start();
}

/**
 * @note Address: 0x800AA940
 * @note Size: 0xAC
 */
void DspBoot(DSPCallback callback)
{
	DspInitWork();
	audio_task.priority          = 0xF0;
	audio_task.iram_mmem_addr    = (u16*)(0x80000000 + (size_t)jdsp);
	audio_task.iram_length       = sizeof(jdsp);
	audio_task.iram_addr         = nullptr;
	audio_task.dram_mmem_addr    = (u16*)(0x80000000 + (size_t)AUDIO_YIELD_BUFFER);
	audio_task.dram_length       = sizeof(AUDIO_YIELD_BUFFER);
	audio_task.dram_addr         = 0;
	audio_task.dsp_init_vector   = 0;
	audio_task.dsp_resume_vector = 0x10;
	audio_task.init_cb           = DspHandShake;
	audio_task.res_cb            = nullptr;
	audio_task.done_cb           = nullptr;
	audio_task.req_cb            = callback;
	DSPInit();
	DSPAddPriorTask(&audio_task);
}

/**
 * @note Address: 0x800AAA00
 * @note Size: 0xE8
 */
int DSPSendCommands2(u32* p1, u32 mailCount, void (*callBack)(u16))
{
	u32* mail;
	s32 i;
	BOOL interruptFlag;
	s32 startWorkStatus;

	while (Dsp_Running_Check() == 0) { };

	interruptFlag = OSDisableInterrupts();
	if (DSPCheckMailToDSP()) {
		OSRestoreInterrupts(interruptFlag);
		return -1;
	}

	DSPSendMailToDSP(mailCount);
	DSPAssertInt();
	while (DSPCheckMailToDSP() != 0)
		;

	if (mailCount == 0) {
		mailCount = 1;
	}

	if (callBack != nullptr) {
		startWorkStatus = DspStartWork(p1[0], callBack);
	}

	mail = p1;
	for (i = 0; i < mailCount; i++) {
		DSPSendMailToDSP(mail[i]);
		while (DSPCheckMailToDSP() != 0)
			;
	}

	OSRestoreInterrupts(interruptFlag);
	return startWorkStatus;
}

typedef struct {
	u16 _00;
	u16 _02;
	void (*_04)(u16);
} TaskWorkStruct;

static TaskWorkStruct taskwork[16];

/**
 * @note Address: 0x800AAB00
 * @note Size: 0x2C
 */
void DspInitWork()
{
	for (u32 i = 0; i < 16; i++) {
		taskwork[i]._04 = nullptr;
	}
}

static u32 taskreadp;
static u32 taskwritep;

/**
 * @note Address: 0x800AAB40
 * @note Size: 0x48
 */
int DspStartWork(u32 p1, void (*p2)(u16))
{
	u32 taskWritePrev = taskwritep;
	u32 writeVal      = ((taskWritePrev + 1) & 0xf);
	if (writeVal == taskreadp) {
		return 0;
	}

	taskwritep                  = writeVal;
	taskwork[taskWritePrev]._00 = p1 >> 0x10;
	taskwork[taskWritePrev]._04 = p2;
	return taskWritePrev + 1;
}

/**
 * @note Address: 0x800AABA0
 * @note Size: 0x68
 */
void DspFinishWork(u16 p1)
{
	if (p1 == taskwork[taskreadp]._00) {
		if (taskwork[taskreadp]._04) {
			taskwork[taskreadp]._04(taskreadp);
		}

		taskreadp = (taskreadp + 1) & 0xf;
	}
}
