import pytest
from primeqa.qg.models.qg_model import QGModel
from transformers import T5Tokenizer, T5ForConditionalGeneration


@pytest.mark.parametrize("model_name",["t5-small"])
def test_qg_model(model_name):
    hqm = QGModel(model_name, modality='hybrid')
    assert type(hqm.model)==T5ForConditionalGeneration
    assert type((hqm.tokenizer)==T5Tokenizer)

    table = {
        'header': [['Year', []], ['Title', []], ['Role', []]], 
        'data': [[['1986', []], ['Impure Thoughts', ['/wiki/Impure_Thoughts']], ['Patty Stubbs', []]], 
            [['1988', []], ['My Stepmother Is an Alien', ['/wiki/My_Stepmother_Is_an_Alien']], ['Jessie Mills', []]], 
            [['1998', []], ['Dead Man on Campus', ['/wiki/Dead_Man_on_Campus']], ['Lucy', []]], 
            [['1999', []], ['American Pie', ['/wiki/American_Pie_(film)']], ['Michelle Flaherty', ['/wiki/Michelle_Flaherty']]], 
            [['2000', []], ['Boys and Girls', ['/wiki/Boys_and_Girls_(2000_film)']], ['Betty', []]], 
            [['2001', []], ['American Pie 2', ['/wiki/American_Pie_2']], ['Michelle Flaherty', []]], 
            [['2001', []], ['Beyond the City Limits', []], ['Lexi', []]], 
            [['2003', []], ['American Wedding', ['/wiki/American_Wedding']], ['Michelle Flaherty', []]], 
            [['2006', []], ['Date Movie', ['/wiki/Date_Movie']], ['Julia Jones', []]], 
            [['2006', []], ['Farce of the Penguins', ['/wiki/Farce_of_the_Penguins']], ['Hottie Penguin', []]], 
            [['2011', []], ['Love , Wedding , Marriage', ['/wiki/Love,_Wedding,_Marriage']], ['Courtney', []]], 
            [['2012', []], ['American Reunion', ['/wiki/American_Reunion']], ['Michelle Levenstein', []]], 
            [['2016', []], ['Do You Take This Man', []], ['Rachael', []]], 
            [['2018', []], ['You Might Be the Killer', ['/wiki/You_Might_Be_the_Killer']], ['Chuck', []]], 
            [['2020', []], ['Flora & Ulysses', ['/wiki/Flora_&_Ulysses_(film)']], ['Phyllis Buckman', []]]], 
        'title': 'Alyson Hannigan', 'section_title': 'Filmography -- Film', 'uid': 'abcdID123'
        }

    passages = {'/wiki/Impure_Thoughts': "Impure Thoughts is a 1986 American comedy film . The film was directed by Michael A. Simpson . It marked Alyson Hannigan 's feature film debut .", 
            '/wiki/My_Stepmother_Is_an_Alien': "My Stepmother Is an Alien is a 1988 American comic science fiction film directed by Richard Benjamin . The film stars Kim Basinger as Celeste , an extraterrestrial woman sent on a secret mission to Earth , after her home planet 's gravity is mistakenly disrupted by Steven Mills ( Dan Aykroyd ) , a widowed scientist raising his daughter Jessie ( Alyson Hannigan ) as a single father . The film 's screenplay was written by Herschel Weingrod , Timothy Harris and Jonathan Reynolds , based on an earlier script by Jericho Stone , who originally pitched the film to Paramount Pictures as a drama which would serve as an allegory about child abuse . When Paramount optioned the story , they suggested that it would be more believable as a comedy . The film was unproduced for four years until Weintraub Entertainment Group put it into production in 1988 . My Stepmother Is an Alien was a box-office bomb , grossing $ 13.8 million against a $ 19 million budget . The film also received negative reviews from critics , with most of the responses panning the film 's humor and screenplay . Although , Basinger and costar Jon Lovitz generally received favorable reviews for their comedic performances . In the New York Times review , Aykroyd was singled out for criticism in his performance as a romantic lead .", 
            '/wiki/Dead_Man_on_Campus': "Dead Man on Campus is a 1998 black comedy film starring Mark-Paul Gosselaar and Tom Everett Scott . It centers on the urban legend that a student gets straight As if their roommate commits suicide ( see pass by catastrophe ) . Two failing friends attempt to find a depressed roommate to push him over the edge and receive As . To boost ticket sales , the film 's U.S. release was timed with the start of the new college school year in late August 1998 . It was the first film by MTV Films to have an R rating . The film was shot at University of the Pacific in Stockton , California .", 
            '/wiki/American_Pie_(film)': "American Pie is a 1999 American teen sex comedy film written by Adam Herz and directed by brothers Paul and Chris Weitz , in their directorial film debut . It is the first film in the American Pie theatrical series . The film was a box-office hit and spawned three direct sequels : American Pie 2 ( 2001 ) , American Wedding ( 2003 ) , and American Reunion ( 2012 ) . The film concentrates on five best friends ( Jim , Kevin , Oz , Finch , and Stifler ) who attend East Great Falls High . With the exception of Stifler ( who has already lost his virginity ) , the guys make a pact to lose their virginity before their high school graduation . The title is borrowed from the song of the same name and refers to a scene in the film , in which the protagonist is caught masturbating with a pie after being told that third base feels like warm apple pie . Writer Adam Herz has stated that the title also refers to the quest of losing one 's virginity in high school , which is as American as apple pie . In addition to the primary American Pie saga , there are four direct-to-DVD spin-off films bearing the title American Pie Presents : Band Camp ( 2005 ) , The Naked Mile ( 2006 ) , Beta House ( 2007 ) , and The Book of Love ( 2009 ) . In response to the success of American Reunion , a fifth theatrical film , under the working title American Pie 5 was announced on August 4 , 2012 . In August 2017 , Seann William Scott said in an interview that the fourth film probably had not made enough at the domestic box office to warrant another film .", 
            '/wiki/Michelle_Flaherty': 'This is a list of characters from the film series American Pie consisting of American Pie ( 1999 ) , American Pie 2 ( 2001 ) , American Wedding ( 2003 ) , American Pie Presents : Band Camp ( 2005 ) , American Pie Presents : The Naked Mile ( 2006 ) , American Pie Presents : Beta House ( 2007 ) , American Pie Presents : The Book of Love ( 2009 ) , and American Reunion ( 2012 ) . Only one character , Noah Levenstein played by Eugene Levy , has appeared in all eight released films . Biggs , Hannigan , Scott , Nicholas , Thomas , Coolidge , Cho , Isfield , Cheek , and Owen all play their characters in four films each ; other characters appear in fewer films .', 
            '/wiki/Boys_and_Girls_(2000_film)': 'Boys and Girls is a 2000 American comedy film directed by Robert Iscove . The two main characters , Ryan ( played by Freddie Prinze , Jr. ) and Jennifer ( Claire Forlani ) , meet each other initially as adolescents , and later realize that their lives are intertwined through fate .', 
            '/wiki/American_Pie_2': 'American Pie 2 is a 2001 American sex comedy film directed by James B. Rogers and written by Adam Herz and David H. Steinberg from a story by Herz . A sequel to the 1999 comedy film American Pie , it the second film in the American Pie series and stars Jason Biggs , Shannon Elizabeth , Alyson Hannigan , Chris Klein , Natasha Lyonne , Thomas Ian Nicholas , Tara Reid , Seann William Scott , Mena Suvari , Eddie Kaye Thomas , and Eugene Levy . The film follows the sexual exploits of five friends - Jim Levenstein , Kevin Myers , Steve Stifler , Oz Ostreicher , and Paul Finch - and their attempts to have the greatest summer party ever , at a summer beach house in Grand Haven , Michigan . American Pie 2 was released in the United States on August 10 , 2001 , and grossed over $ 145 million in the US and $ 142 million overseas on a budget of $ 30 million , making it highest grossing film in the franchise at just under $ 288 million worldwide . The film was followed by American Wedding .', 
            '/wiki/American_Wedding': "American Wedding ( known as American Pie 3 : The Wedding or American Pie : The Wedding , in some countries ) is a 2003 American sex comedy film and a sequel to American Pie and American Pie 2 . It is the third ( originally intended final ) installment in the American Pie theatrical series . It was written by Adam Herz and directed by Jesse Dylan . Another sequel , American Reunion , was released nine years later . This also stands as the last film in the series to be written by Herz , who conceptualized the franchise . Though the film mainly focuses on the union of Jim Levenstein and Michelle Flaherty , for the first time in the series , the story centers on Steve Stifler , and his outrageous antics including his attempt to organize a bachelor party , teaching Jim to dance for the wedding , and competing with Finch to win the heart of Michelle 's sister , Cadence .", 
            '/wiki/Date_Movie': "Date Movie is a 2006 American parody romantic comedy film written and directed by Jason Friedberg and Aaron Seltzer . The film was released on February 17 , 2006 by 20th Century Fox . A parody of the romantic comedy genre , much of the story line is based on My Big Fat Greek Wedding , Meet the Fockers , Hitch , Legally Blonde , and Bridget Jones 's Diary . It stars Alyson Hannigan , Adam Campbell , Sophie Monk , Tony Cox , Jennifer Coolidge , Eddie Griffin , and Fred Willard . The film was panned by critics and has a 7% rating on Rotten Tomatoes , but was a box office success .", 
            '/wiki/Farce_of_the_Penguins': "Farce of the Penguins is a 2007 American direct-to-video parody directed by Bob Saget . It is a parody of the 2005 French feature-length nature documentary March of the Penguins , directed and co written by Luc Jacquet . The film features Samuel L. Jackson as narrator , with the two main characters voiced by Bob Saget and Lewis Black . Five of Saget 's former Full House co stars also lent their voices to the film . Additional voices were provided by Tracy Morgan , Christina Applegate , James Belushi , Whoopi Goldberg , Dane Cook , Abe Vigoda , Mo'Nique , and others .", 
            '/wiki/Love,_Wedding,_Marriage': 'Love , Wedding , Marriage is a 2011 American romantic comedy film directed by Dermot Mulroney and starring Mandy Moore , Kellan Lutz , James Brolin , Jane Seymour and Christopher Lloyd .', 
            '/wiki/American_Reunion': 'American Reunion ( also known as American Pie 4 : Reunion or American Pie : Reunion in certain countries ) is a 2012 American ensemble sex comedy film written and directed by Jon Hurwitz and Hayden Schlossberg . It is the fourth installment in the American Pie theatrical series . The film received mixed reviews from critics , and grossed $ 250 million worldwide .', 
            '/wiki/You_Might_Be_the_Killer': 'You Might Be the Killer is a 2018 American meta supernatural slasher film directed by Brett Simmons and written by Covis Berzoyne , Thomas P. Vitale , and Simmons , based on an idea by Chuck Wendig and Sam Sykes . The film stars Fran Kranz and Alyson Hannigan , and features Brittany S. Hall , Patrick Reginald Walker , Keith David , and Bryan Price in supporting roles .', 
            '/wiki/Flora_&_Ulysses_(film)': "Flora & Ulysses is an upcoming family film based on the children 's novel of the same name by Kate DiCamillo that is set to debut on Disney+ . The film is directed by Lena Khan , produced by Gil Netter from a screenplay written by Brad Copeland and stars Matilda Lawler , Alyson Hannigan , Ben Schwartz , Benjamin Evan Ainsworth and Danny Pudi ."
           }

    data_list = [(table, passages)]
    id_list = ["abcID123"]


    gqs = hqm.generate_questions(data_list, 
                                    num_questions_per_instance = 5,
                                    hallucination_prop=0.25,
                                    num_beams=5,
                                    id_list=id_list
                                )
    assert(len(gqs)>0)
