# Tutorials
<!-- [<i class="fas fa-edit"></i> Edit on GitHub](https://github.com/primeqa/primeqa/edit/main/docs/tutorials/index.md)         -->
<h3 align="center">
    <img width="350" alt="primeqa" src="../_static/img/PrimeQA.png">
</h3>

New to [PrimeQA](https://github.com/primeqa/primeqa)? Trying to figure out how to use the various components? 

No worries we got you covered. These tutorials will get you acquainted with the PrimeQA functionalities in order for you to create your next awesome search application.


## Tutorials
| Name                                     | Colab                                                                                                                                                                                                                                     | Source Code                                                                                                                                      |
| ---------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------ |
| Index your document collection with DPR | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/drive/1itJl5iWJ8fEVK5sqTe_yJu1IQ8KpGkuq#scrollTo=SPqwU9eIigIg)  | [01_Index_Documents_with_DPR.ipynb](01_Index_Documents_with_DPR.ipynb) 
| Generative QA: Retrieve and Generate (RAG) with Neural retrievers and readers from either HuggingFace or OpenAI models | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/drive/1cJ3BzLIdgKbayQFZB4QWTRIF0B92CHYa)  | [02_Retrieve_and_Generate_Answers_to_Questions_with_RAG.ipynb](02_Retrieve_and_Generate_Answers_to_Questions_with_RAG.ipynb)
| Bring your own search and re-rank with PrimeQA embeddings | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/drive/1zPypFF88PNEyFmi-CtQnVHYhZOMdzQVt)  | [03_ReRank_search_results.ipynb](03_ReRank_search_results.ipynb)
| Build QA models by fine-tuning LLMs with QLORA algorithm | [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/drive/1qkVvYJOUonE5eLQQozqTkZtHlCqfY6Un)  | [04_Finetune_LLM_for_QA_with_QLORA.ipynb](04_Finetune_LLM_for_QA_with_QLORA.ipynb)

