#ifndef CONTROLLER_VOICE_H
#define CONTROLLER_VOICE_H

#include "PR/ultratypes.h"

typedef struct {
    /* 0x0 */ u8 dummy;
    /* 0x1 */ u8 txsize;
    /* 0x2 */ u8 rxsize;
    /* 0x3 */ u8 cmd;
    /* 0x4 */ u8 addrh;
    /* 0x5 */ u8 addrl;
    /* 0x6 */ u8 data[2];
    /* 0x8 */ u8 datacrc;
} __OSVoiceRead2Format;

typedef struct {
    /* 0x0 */ u8 dummy;
    /* 0x1 */ u8 txsize;
    /* 0x2 */ u8 rxsize;
    /* 0x3 */ u8 cmd;
    /* 0x4 */ u8 addrh;
    /* 0x5 */ u8 addrl;
    /* 0x6 */ u8 data[36];
    /* 0x2A */ u8 datacrc;
} __OSVoiceRead36Format;

typedef struct {
    /* 0x0 */ u8 dummy;
    /* 0x1 */ u8 txsize;
    /* 0x2 */ u8 rxsize;
    /* 0x3 */ u8 cmd;
    /* 0x4 */ u8 addrh;
    /* 0x5 */ u8 addrl;
    /* 0x6 */ u8 data[4];
    /* 0xA */ u8 datacrc;
} __OSVoiceWrite4Format;

typedef struct {
    /* 0x0 */ u8 dummy;
    /* 0x1 */ u8 txsize;
    /* 0x2 */ u8 rxsize;
    /* 0x3 */ u8 cmd;
    /* 0x4 */ u8 addrh;
    /* 0x5 */ u8 addrl;
    /* 0x6 */ u8 data[20];
    /* 0x1A */ u8 datacrc;
} __OSVoiceWrite20Format;

typedef struct {
    /* 0x0 */ u8 txsize;
    /* 0x1 */ u8 rxsize;
    /* 0x2 */ u8 cmd;
    /* 0x3 */ u8 data;
    /* 0x4 */ u8 scrc;
    /* 0x5 */ u8 datacrc;
} __OSVoiceSWriteFormat;

#endif // CONTROLLER_VOICE_H
