<h1 align="center">Automated Course Content Generator 🤖</h1>

<p align="center">
Empower your teaching with AI-driven course creation!
</p>

## 📘 Introduction

The Automated Course Content Generator (ACCG) is an AI-based Streamlit application developed to assist SMEs, Content Creators, and Educators in creating detailed and comprehensive course content effortlessly. By inputting key parameters such as Course Name, Target Audience Education Level, Course Difficulty Level, and Course Credit, users receive a dynamically generated course outline. This tool also generates quiz questions and provides the complete course content in a downloadable PDF format, as well as PPT! (New)

## 🤖 Meet ACCG

ACCG uses advanced language models like GPT-3.5 Turbo/4 Turbo and Meta’s LLama-3-70B-Instruct. It simplifies the process of generating tailored educational content, making course design more efficient and effective.
<p align="center">
  <img src="https://img.shields.io/badge/Python-%233776AB.svg?style=for-the-badge&logo=Python&logoColor=white" alt="Python">
  <img src="https://img.shields.io/badge/OpenAI-%23FFFFFF.svg?style=for-the-badge&logo=OpenAI&logoColor=black" alt="OpenAI">
  <img src="https://img.shields.io/badge/Streamlit-%23FF0000.svg?style=for-the-badge&logo=Streamlit&logoColor=red&color=white" alt="Streamlit">
  <img src="https://img.shields.io/badge/Meta-LLama--3-%233776AB.svg?style=for-the-badge&logo=Meta&logoColor=white" alt="Meta LLama-3">
</p>

## Checkout the demo here!
## 👉 [ACCG-Demo](https://www.veed.io/view/fd48948d-6db0-4411-ada7-cfd40ffb19d4?panel=share)
Next Version of ACCG -> Automated Course Development (ACD) with additional features and functionalities is coming soon! 

(Update: Pushed the next version to ACD test branch👀)

## 🌟 Features

- **Interactive Course Customization** 🎨: Input your course details to generate a customized outline.
- **Detailed Content Generation** 📝: Create comprehensive content for each module and lesson.
- **Quiz Generation** 🧩: Automatically generate quizzes for each module based on the module content.
- **PDF Export** 📄: Download the complete course content as a neatly formatted PDF.
- **PPT Export (New!)** 📄: Download the complete course content as a neatly formatted PPT.
- **LATEX**

## 📝 Functionality

The ACCG leverages advanced language models and intelligent algorithms to generate detailed and engaging course content. Users can input specific parameters and generate tailored educational material, including outlines, lessons, and quizzes. The tool streamlines the course creation process, making it more efficient and user-friendly.

## 🚀 Usage

1. **Open the Application**: Navigate to the Streamlit app in your browser.
2. **Enter Course Details**: Fill in the course name, target audience education level, difficulty level, number of modules, course duration, and course credit.
3. **Generate Course Outline**: Click the "Generate Course Outline" button to create a comprehensive course outline.
4. **View and Modify Content**: Review the generated content and make any necessary modifications.
5. **Generate Complete Course**: Once satisfied, generate the complete course content.
6. **Download PDF**: Download the generated course content as a PDF file.

## 🏆 Project Details

### Tech Stack

- **Python** 🐍
- **Streamlit** 📊
- **OpenAI's GPT-3.5 Turbo/4 Turbo** 🤖
- **Meta’s LLama-3-70B-Instruct** 🦙
- **Mega prompting** ✨
- **GitHub** 🐙
- **VS-Code** 💻

## Project Structure

```plaintext
automated-course-content-generator/
│
├── prompts/
│   ├── tabler_prompt.py
│   ├── dictator_prompt.py
│   └── quizzy_prompt.py
│
├── app.py
├── README.md
├── requirements.txt
└── .env.example
```

### Key Contributions and Achievements 🌟

- Led the development of the Streamlit application, ensuring a seamless user experience.
- Collaborated with team members to optimize code efficiency and maintainability.
- Implemented Prompt Engineering techniques to enhance AI-generated content quality.
- Contributed to version control and project management on GitHub.

### Impact and Results 🚀

#### Quantitative Outcomes 📊

- Increased course creation efficiency.
- Achieving a 70-80% reduction in course development time.

#### Qualitative Outcomes 💡

- Enhanced course quality through Bloom’s Taxonomy and relevance through AI-generated content suggestions.
- Empowered users to tailor courses to specific audience needs and educational levels.
- Streamlined the course creation process, resulting in higher user satisfaction.

## ⚖️ License
This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.



<!--## ⚖️ License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.--!>
