package perfmon2.libpfm;
import java.util.Collections;
import java.util.Iterator;
import org.bridj.BridJ;
import org.bridj.CRuntime;
import org.bridj.FlagSet;
import org.bridj.IntValuedEnum;
import org.bridj.Pointer;
import org.bridj.ann.Library;
import org.bridj.ann.Runtime;
/**
 * Wrapper for library <b>libpfm</b><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("libpfm") 
@Runtime(CRuntime.class) 
public class LibpfmLibrary {
	static {
		BridJ.register();
	}
	/**
	 * attr->type field values<br>
	 * enum values<br>
	 * <i>native declaration : perf_event.h:42</i>
	 */
	public enum perf_type_id implements IntValuedEnum<perf_type_id > {
		PERF_TYPE_HARDWARE(0),
		PERF_TYPE_SOFTWARE(1),
		PERF_TYPE_TRACEPOINT(2),
		PERF_TYPE_HW_CACHE(3),
		PERF_TYPE_RAW(4),
		PERF_TYPE_BREAKPOINT(5),
		PERF_TYPE_MAX(6);
		perf_type_id(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<perf_type_id > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<perf_type_id > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * attr->config values for generic HW PMU events<br>
	 * they get mapped onto actual events by the kernel<br>
	 * enum values<br>
	 * <i>native declaration : perf_event.h:57</i>
	 */
	public enum perf_hw_id implements IntValuedEnum<perf_hw_id > {
		PERF_COUNT_HW_CPU_CYCLES(0),
		PERF_COUNT_HW_INSTRUCTIONS(1),
		PERF_COUNT_HW_CACHE_REFERENCES(2),
		PERF_COUNT_HW_CACHE_MISSES(3),
		PERF_COUNT_HW_BRANCH_INSTRUCTIONS(4),
		PERF_COUNT_HW_BRANCH_MISSES(5),
		PERF_COUNT_HW_BUS_CYCLES(6),
		PERF_COUNT_HW_STALLED_CYCLES_FRONTEND(7),
		PERF_COUNT_HW_STALLED_CYCLES_BACKEND(8),
		PERF_COUNT_HW_REF_CPU_CYCLES(9),
		PERF_COUNT_HW_MAX(10);
		perf_hw_id(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<perf_hw_id > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<perf_hw_id > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * attr->config values for generic HW cache events<br>
	 * they get mapped onto actual events by the kernel<br>
	 * enum values<br>
	 * <i>native declaration : perf_event.h:76</i>
	 */
	public enum perf_hw_cache_id implements IntValuedEnum<perf_hw_cache_id > {
		PERF_COUNT_HW_CACHE_L1D(0),
		PERF_COUNT_HW_CACHE_L1I(1),
		PERF_COUNT_HW_CACHE_LL(2),
		PERF_COUNT_HW_CACHE_DTLB(3),
		PERF_COUNT_HW_CACHE_ITLB(4),
		PERF_COUNT_HW_CACHE_BPU(5),
		PERF_COUNT_HW_CACHE_NODE(6),
		PERF_COUNT_HW_CACHE_MAX(7);
		perf_hw_cache_id(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<perf_hw_cache_id > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<perf_hw_cache_id > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : perf_event.h:87</i>
	 */
	public enum perf_hw_cache_op_id implements IntValuedEnum<perf_hw_cache_op_id > {
		PERF_COUNT_HW_CACHE_OP_READ(0),
		PERF_COUNT_HW_CACHE_OP_WRITE(1),
		PERF_COUNT_HW_CACHE_OP_PREFETCH(2),
		PERF_COUNT_HW_CACHE_OP_MAX(3);
		perf_hw_cache_op_id(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<perf_hw_cache_op_id > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<perf_hw_cache_op_id > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : perf_event.h:94</i>
	 */
	public enum perf_hw_cache_op_result_id implements IntValuedEnum<perf_hw_cache_op_result_id > {
		PERF_COUNT_HW_CACHE_RESULT_ACCESS(0),
		PERF_COUNT_HW_CACHE_RESULT_MISS(1),
		PERF_COUNT_HW_CACHE_RESULT_MAX(2);
		perf_hw_cache_op_result_id(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<perf_hw_cache_op_result_id > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<perf_hw_cache_op_result_id > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * attr->config values for SW events<br>
	 * enum values<br>
	 * <i>native declaration : perf_event.h:103</i>
	 */
	public enum perf_sw_ids implements IntValuedEnum<perf_sw_ids > {
		PERF_COUNT_SW_CPU_CLOCK(0),
		PERF_COUNT_SW_TASK_CLOCK(1),
		PERF_COUNT_SW_PAGE_FAULTS(2),
		PERF_COUNT_SW_CONTEXT_SWITCHES(3),
		PERF_COUNT_SW_CPU_MIGRATIONS(4),
		PERF_COUNT_SW_PAGE_FAULTS_MIN(5),
		PERF_COUNT_SW_PAGE_FAULTS_MAJ(6),
		PERF_COUNT_SW_ALIGNMENT_FAULTS(7),
		PERF_COUNT_SW_EMULATION_FAULTS(8),
		PERF_COUNT_SW_MAX(9);
		perf_sw_ids(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<perf_sw_ids > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<perf_sw_ids > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * attr->sample_type values<br>
	 * enum values<br>
	 * <i>native declaration : perf_event.h:119</i>
	 */
	public enum perf_event_sample_format implements IntValuedEnum<perf_event_sample_format > {
		PERF_SAMPLE_IP(1 << 0),
		PERF_SAMPLE_TID(1 << 1),
		PERF_SAMPLE_TIME(1 << 2),
		PERF_SAMPLE_ADDR(1 << 3),
		PERF_SAMPLE_READ(1 << 4),
		PERF_SAMPLE_CALLCHAIN(1 << 5),
		PERF_SAMPLE_ID(1 << 6),
		PERF_SAMPLE_CPU(1 << 7),
		PERF_SAMPLE_PERIOD(1 << 8),
		PERF_SAMPLE_STREAM_ID(1 << 9),
		PERF_SAMPLE_RAW(1 << 10),
		PERF_SAMPLE_BRANCH_STACK(1 << 11),
		PERF_SAMPLE_REGS_USER(1 << 12),
		PERF_SAMPLE_STACK_USER(1 << 13),
		PERF_SAMPLE_WEIGHT(1 << 14),
		PERF_SAMPLE_DATA_SRC(1 << 15),
		PERF_SAMPLE_MAX(1 << 16);
		perf_event_sample_format(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<perf_event_sample_format > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<perf_event_sample_format > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * branch_sample_type values<br>
	 * enum values<br>
	 * <i>native declaration : perf_event.h:142</i>
	 */
	public enum perf_branch_sample_type implements IntValuedEnum<perf_branch_sample_type > {
		PERF_SAMPLE_BRANCH_USER(1 << 0),
		PERF_SAMPLE_BRANCH_KERNEL(1 << 1),
		PERF_SAMPLE_BRANCH_HV(1 << 2),
		PERF_SAMPLE_BRANCH_ANY(1 << 3),
		PERF_SAMPLE_BRANCH_ANY_CALL(1 << 4),
		PERF_SAMPLE_BRANCH_ANY_RETURN(1 << 5),
		PERF_SAMPLE_BRANCH_IND_CALL(1 << 6),
		PERF_SAMPLE_BRANCH_MAX(1 << 7);
		perf_branch_sample_type(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<perf_branch_sample_type > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<perf_branch_sample_type > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : perf_event.h:153</i>
	 */
	public enum perf_sample_regs_abi implements IntValuedEnum<perf_sample_regs_abi > {
		PERF_SAMPLE_REGS_ABI_NONE(0),
		PERF_SAMPLE_REGS_ABI_32(1),
		PERF_SAMPLE_REGS_ABI_64(2);
		perf_sample_regs_abi(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<perf_sample_regs_abi > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<perf_sample_regs_abi > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * attr->read_format values<br>
	 * enum values<br>
	 * <i>native declaration : perf_event.h:162</i>
	 */
	public enum perf_event_read_format implements IntValuedEnum<perf_event_read_format > {
		PERF_FORMAT_TOTAL_TIME_ENABLED(1 << 0),
		PERF_FORMAT_TOTAL_TIME_RUNNING(1 << 1),
		PERF_FORMAT_ID(1 << 2),
		PERF_FORMAT_GROUP(1 << 3),
		PERF_FORMAT_MAX(1 << 4);
		perf_event_read_format(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<perf_event_read_format > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<perf_event_read_format > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * ioctl() 3rd argument<br>
	 * enum values<br>
	 * <i>native declaration : perf_event.h:282</i>
	 */
	public enum perf_event_ioc_flags implements IntValuedEnum<perf_event_ioc_flags > {
		PERF_IOC_FLAG_GROUP(1 << 0);
		perf_event_ioc_flags(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<perf_event_ioc_flags > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<perf_event_ioc_flags > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * header->type values<br>
	 * enum values<br>
	 * <i>native declaration : perf_event.h:341</i>
	 */
	public enum perf_event_type implements IntValuedEnum<perf_event_type > {
		PERF_RECORD_MMAP(1),
		PERF_RECORD_LOST(2),
		PERF_RECORD_COMM(3),
		PERF_RECORD_EXIT(4),
		PERF_RECORD_THROTTLE(5),
		PERF_RECORD_UNTHROTTLE(6),
		PERF_RECORD_FORK(7),
		PERF_RECORD_READ(8),
		PERF_RECORD_SAMPLE(9),
		PERF_RECORD_MMAP2(10),
		PERF_RECORD_MAX(11);
		perf_event_type(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<perf_event_type > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<perf_event_type > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : perf_event.h:355</i>
	 */
	public enum perf_callchain_context implements IntValuedEnum<perf_callchain_context > {
		PERF_CONTEXT_HV(-32),
		PERF_CONTEXT_KERNEL(-128),
		PERF_CONTEXT_USER(-512),
		PERF_CONTEXT_GUEST(-2048),
		PERF_CONTEXT_GUEST_KERNEL(-2176),
		PERF_CONTEXT_GUEST_USER(-2560),
		PERF_CONTEXT_MAX(-4095);
		perf_callchain_context(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<perf_callchain_context > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<perf_callchain_context > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : pfmlib.h</i>
	 */
	public enum pfm_pmu_t implements IntValuedEnum<pfm_pmu_t > {
		/** no PMU */
		PFM_PMU_NONE(0),
		PFM_PMU_GEN_IA64(1),
		PFM_PMU_ITANIUM(2),
		PFM_PMU_ITANIUM2(3),
		PFM_PMU_MONTECITO(4),
		PFM_PMU_AMD64(5),
		PFM_PMU_I386_P6(6),
		PFM_PMU_INTEL_NETBURST(7),
		PFM_PMU_INTEL_NETBURST_P(8),
		PFM_PMU_COREDUO(9),
		PFM_PMU_I386_PM(10),
		PFM_PMU_INTEL_CORE(11),
		PFM_PMU_INTEL_PPRO(12),
		PFM_PMU_INTEL_PII(13),
		PFM_PMU_INTEL_ATOM(14),
		PFM_PMU_INTEL_NHM(15),
		PFM_PMU_INTEL_NHM_EX(16),
		PFM_PMU_INTEL_NHM_UNC(17),
		PFM_PMU_INTEL_X86_ARCH(18),
		PFM_PMU_MIPS_20KC(19),
		PFM_PMU_MIPS_24K(20),
		PFM_PMU_MIPS_25KF(21),
		PFM_PMU_MIPS_34K(22),
		PFM_PMU_MIPS_5KC(23),
		PFM_PMU_MIPS_74K(24),
		PFM_PMU_MIPS_R10000(25),
		PFM_PMU_MIPS_R12000(26),
		PFM_PMU_MIPS_RM7000(27),
		PFM_PMU_MIPS_RM9000(28),
		PFM_PMU_MIPS_SB1(29),
		PFM_PMU_MIPS_VR5432(30),
		PFM_PMU_MIPS_VR5500(31),
		PFM_PMU_MIPS_ICE9A(32),
		PFM_PMU_MIPS_ICE9B(33),
		PFM_PMU_POWERPC(34),
		PFM_PMU_CELL(35),
		PFM_PMU_SPARC_ULTRA12(36),
		PFM_PMU_SPARC_ULTRA3(37),
		PFM_PMU_SPARC_ULTRA3I(38),
		PFM_PMU_SPARC_ULTRA3PLUS(39),
		PFM_PMU_SPARC_ULTRA4PLUS(40),
		PFM_PMU_SPARC_NIAGARA1(41),
		PFM_PMU_SPARC_NIAGARA2(42),
		PFM_PMU_PPC970(43),
		PFM_PMU_PPC970MP(44),
		PFM_PMU_POWER3(45),
		PFM_PMU_POWER4(46),
		PFM_PMU_POWER5(47),
		PFM_PMU_POWER5p(48),
		PFM_PMU_POWER6(49),
		PFM_PMU_POWER7(50),
		PFM_PMU_PERF_EVENT(51),
		PFM_PMU_INTEL_WSM(52),
		PFM_PMU_INTEL_WSM_DP(53),
		PFM_PMU_INTEL_WSM_UNC(54),
		PFM_PMU_AMD64_K7(55),
		PFM_PMU_AMD64_K8_REVB(56),
		PFM_PMU_AMD64_K8_REVC(57),
		PFM_PMU_AMD64_K8_REVD(58),
		PFM_PMU_AMD64_K8_REVE(59),
		PFM_PMU_AMD64_K8_REVF(60),
		PFM_PMU_AMD64_K8_REVG(61),
		PFM_PMU_AMD64_FAM10H_BARCELONA(62),
		PFM_PMU_AMD64_FAM10H_SHANGHAI(63),
		PFM_PMU_AMD64_FAM10H_ISTANBUL(64),
		PFM_PMU_ARM_CORTEX_A8(65),
		PFM_PMU_ARM_CORTEX_A9(66),
		PFM_PMU_TORRENT(67),
		PFM_PMU_INTEL_SNB(68),
		PFM_PMU_AMD64_FAM14H_BOBCAT(69),
		PFM_PMU_AMD64_FAM15H_INTERLAGOS(70),
		PFM_PMU_INTEL_SNB_EP(71),
		PFM_PMU_AMD64_FAM12H_LLANO(72),
		PFM_PMU_AMD64_FAM11H_TURION(73),
		PFM_PMU_INTEL_IVB(74),
		PFM_PMU_ARM_CORTEX_A15(75),
		PFM_PMU_INTEL_SNB_UNC_CB0(76),
		PFM_PMU_INTEL_SNB_UNC_CB1(77),
		PFM_PMU_INTEL_SNB_UNC_CB2(78),
		PFM_PMU_INTEL_SNB_UNC_CB3(79),
		PFM_PMU_INTEL_SNBEP_UNC_CB0(80),
		PFM_PMU_INTEL_SNBEP_UNC_CB1(81),
		PFM_PMU_INTEL_SNBEP_UNC_CB2(82),
		PFM_PMU_INTEL_SNBEP_UNC_CB3(83),
		PFM_PMU_INTEL_SNBEP_UNC_CB4(84),
		PFM_PMU_INTEL_SNBEP_UNC_CB5(85),
		PFM_PMU_INTEL_SNBEP_UNC_CB6(86),
		PFM_PMU_INTEL_SNBEP_UNC_CB7(87),
		PFM_PMU_INTEL_SNBEP_UNC_HA(88),
		PFM_PMU_INTEL_SNBEP_UNC_IMC0(89),
		PFM_PMU_INTEL_SNBEP_UNC_IMC1(90),
		PFM_PMU_INTEL_SNBEP_UNC_IMC2(91),
		PFM_PMU_INTEL_SNBEP_UNC_IMC3(92),
		PFM_PMU_INTEL_SNBEP_UNC_PCU(93),
		PFM_PMU_INTEL_SNBEP_UNC_QPI0(94),
		PFM_PMU_INTEL_SNBEP_UNC_QPI1(95),
		PFM_PMU_INTEL_SNBEP_UNC_UBOX(96),
		PFM_PMU_INTEL_SNBEP_UNC_R2PCIE(97),
		PFM_PMU_INTEL_SNBEP_UNC_R3QPI0(98),
		PFM_PMU_INTEL_SNBEP_UNC_R3QPI1(99),
		PFM_PMU_INTEL_KNC(100),
		PFM_PMU_S390X_CPUM_CF(101),
		PFM_PMU_ARM_1176(102),
		PFM_PMU_INTEL_IVB_EP(103),
		PFM_PMU_INTEL_HSW(104),
		PFM_PMU_INTEL_IVB_UNC_CB0(105),
		PFM_PMU_INTEL_IVB_UNC_CB1(106),
		PFM_PMU_INTEL_IVB_UNC_CB2(107),
		PFM_PMU_INTEL_IVB_UNC_CB3(108),
		PFM_PMU_POWER8(109),
		PFM_PMU_INTEL_RAPL(110),
		PFM_PMU_INTEL_SLM(111),
		PFM_PMU_AMD64_FAM15H_NB(112),
		PFM_PMU_ARM_QCOM_KRAIT(113),
		PFM_PMU_PERF_EVENT_RAW(114),
		PFM_PMU_INTEL_IVBEP_UNC_CB0(115),
		PFM_PMU_INTEL_IVBEP_UNC_CB1(116),
		PFM_PMU_INTEL_IVBEP_UNC_CB2(117),
		PFM_PMU_INTEL_IVBEP_UNC_CB3(118),
		PFM_PMU_INTEL_IVBEP_UNC_CB4(119),
		PFM_PMU_INTEL_IVBEP_UNC_CB5(120),
		PFM_PMU_INTEL_IVBEP_UNC_CB6(121),
		PFM_PMU_INTEL_IVBEP_UNC_CB7(122),
		PFM_PMU_INTEL_IVBEP_UNC_CB8(123),
		PFM_PMU_INTEL_IVBEP_UNC_CB9(124),
		PFM_PMU_INTEL_IVBEP_UNC_CB10(125),
		PFM_PMU_INTEL_IVBEP_UNC_CB11(126),
		PFM_PMU_INTEL_IVBEP_UNC_CB12(127),
		PFM_PMU_INTEL_IVBEP_UNC_CB13(128),
		PFM_PMU_INTEL_IVBEP_UNC_CB14(129),
		PFM_PMU_INTEL_IVBEP_UNC_HA0(130),
		PFM_PMU_INTEL_IVBEP_UNC_HA1(131),
		PFM_PMU_INTEL_IVBEP_UNC_IMC0(132),
		PFM_PMU_INTEL_IVBEP_UNC_IMC1(133),
		PFM_PMU_INTEL_IVBEP_UNC_IMC2(134),
		PFM_PMU_INTEL_IVBEP_UNC_IMC3(135),
		PFM_PMU_INTEL_IVBEP_UNC_IMC4(136),
		PFM_PMU_INTEL_IVBEP_UNC_IMC5(137),
		PFM_PMU_INTEL_IVBEP_UNC_IMC6(138),
		PFM_PMU_INTEL_IVBEP_UNC_IMC7(139),
		PFM_PMU_INTEL_IVBEP_UNC_PCU(140),
		PFM_PMU_INTEL_IVBEP_UNC_QPI0(141),
		PFM_PMU_INTEL_IVBEP_UNC_QPI1(142),
		PFM_PMU_INTEL_IVBEP_UNC_QPI2(143),
		PFM_PMU_INTEL_IVBEP_UNC_UBOX(144),
		PFM_PMU_INTEL_IVBEP_UNC_R2PCIE(145),
		PFM_PMU_INTEL_IVBEP_UNC_R3QPI0(146),
		PFM_PMU_INTEL_IVBEP_UNC_R3QPI1(147),
		PFM_PMU_INTEL_IVBEP_UNC_R3QPI2(148),
		PFM_PMU_INTEL_IVBEP_UNC_IRP(149),
		PFM_PMU_S390X_CPUM_SF(150),
		PFM_PMU_ARM_CORTEX_A57(151),
		PFM_PMU_ARM_CORTEX_A53(152),
		PFM_PMU_ARM_CORTEX_A7(153),
		PFM_PMU_INTEL_HSW_EP(154),
		PFM_PMU_INTEL_BDW(155),
		PFM_PMU_ARM_XGENE(156),
		/** end marker */
		PFM_PMU_MAX(157);
		pfm_pmu_t(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<pfm_pmu_t > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<pfm_pmu_t > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : pfmlib.h</i>
	 */
	public enum pfm_pmu_type_t implements IntValuedEnum<pfm_pmu_type_t > {
		/** unknown PMU type */
		PFM_PMU_TYPE_UNKNOWN(0),
		PFM_PMU_TYPE_CORE(1),
		PFM_PMU_TYPE_UNCORE(2),
		PFM_PMU_TYPE_OS_GENERIC(3),
		PFM_PMU_TYPE_MAX(4);
		pfm_pmu_type_t(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<pfm_pmu_type_t > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<pfm_pmu_type_t > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : pfmlib.h</i>
	 */
	public enum pfm_attr_t implements IntValuedEnum<pfm_attr_t > {
		/** no attribute */
		PFM_ATTR_NONE(0),
		PFM_ATTR_UMASK(1),
		PFM_ATTR_MOD_BOOL(2),
		PFM_ATTR_MOD_INTEGER(3),
		PFM_ATTR_RAW_UMASK(4),
		/** end-marker */
		PFM_ATTR_MAX(5);
		pfm_attr_t(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<pfm_attr_t > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<pfm_attr_t > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : pfmlib.h</i>
	 */
	public enum pfm_dtype_t implements IntValuedEnum<pfm_dtype_t > {
		/** unkown */
		PFM_DTYPE_UNKNOWN(0),
		PFM_DTYPE_UINT64(1),
		PFM_DTYPE_INT64(2),
		PFM_DTYPE_DOUBLE(3),
		PFM_DTYPE_FIXED(4),
		PFM_DTYPE_RATIO(5),
		PFM_DTYPE_CHAR8(6),
		/** end-marker */
		PFM_DTYPE_MAX(7);
		pfm_dtype_t(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<pfm_dtype_t > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<pfm_dtype_t > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : pfmlib.h</i>
	 */
	public enum pfm_attr_ctrl_t implements IntValuedEnum<pfm_attr_ctrl_t > {
		/** unknown */
		PFM_ATTR_CTRL_UNKNOWN(0),
		PFM_ATTR_CTRL_PMU(1),
		PFM_ATTR_CTRL_PERF_EVENT(2),
		PFM_ATTR_CTRL_MAX(3);
		pfm_attr_ctrl_t(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<pfm_attr_ctrl_t > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<pfm_attr_ctrl_t > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : pfmlib.h</i>
	 */
	public enum pfm_os_t implements IntValuedEnum<pfm_os_t > {
		/** only PMU */
		PFM_OS_NONE(0),
		PFM_OS_PERF_EVENT(1),
		PFM_OS_PERF_EVENT_EXT(2),
		PFM_OS_MAX(3);
		pfm_os_t(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<pfm_os_t > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<pfm_os_t > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_ATTR_SIZE_VER0 = (int)64;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_ATTR_SIZE_VER1 = (int)72;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_ATTR_SIZE_VER2 = (int)80;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_EVENT_IOC_ENABLE = (int)(((0) << (((0 + 8) + 8) + 14)) | (('$') << (0 + 8)) | ((0) << 0) | ((0) << ((0 + 8) + 8)));
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_EVENT_IOC_DISABLE = (int)(((0) << (((0 + 8) + 8) + 14)) | (('$') << (0 + 8)) | ((1) << 0) | ((0) << ((0 + 8) + 8)));
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_EVENT_IOC_REFRESH = (int)(((0) << (((0 + 8) + 8) + 14)) | (('$') << (0 + 8)) | ((2) << 0) | ((0) << ((0 + 8) + 8)));
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_EVENT_IOC_RESET = (int)(((0) << (((0 + 8) + 8) + 14)) | (('$') << (0 + 8)) | ((3) << 0) | ((0) << ((0 + 8) + 8)));
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_EVENT_IOC_SET_OUTPUT = (int)(((0) << (((0 + 8) + 8) + 14)) | (('$') << (0 + 8)) | ((5) << 0) | ((0) << ((0 + 8) + 8)));
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_EVENT_MISC_CPUMODE_MASK = (int)(3 << 0);
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_EVENT_MISC_CPUMODE_UNKNOWN = (int)(0 << 0);
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_EVENT_MISC_KERNEL = (int)(1 << 0);
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_EVENT_MISC_USER = (int)(2 << 0);
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_EVENT_MISC_HYPERVISOR = (int)(3 << 0);
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_RECORD_MISC_GUEST_KERNEL = (int)(4 << 0);
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_RECORD_MISC_GUEST_USER = (int)(5 << 0);
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_RECORD_MISC_EXACT = (int)(1 << 14);
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_RECORD_MISC_EXACT_IP = (int)(1 << 14);
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_RECORD_MISC_EXT_RESERVED = (int)(1 << 15);
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_FLAG_FD_NO_GROUP = (int)(1 << 0);
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_FLAG_FD_OUTPUT = (int)(1 << 1);
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_FLAG_PID_CGROUP = (int)(1 << 2);
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_OP_NA = (int)0x01;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_OP_LOAD = (int)0x02;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_OP_STORE = (int)0x04;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_OP_PFETCH = (int)0x08;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_OP_EXEC = (int)0x10;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_OP_SHIFT = (int)0;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LVL_NA = (int)0x01;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LVL_HIT = (int)0x02;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LVL_MISS = (int)0x04;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LVL_L1 = (int)0x08;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LVL_LFB = (int)0x10;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LVL_L2 = (int)0x20;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LVL_L3 = (int)0x40;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LVL_LOC_RAM = (int)0x80;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LVL_REM_RAM1 = (int)0x100;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LVL_REM_RAM2 = (int)0x200;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LVL_REM_CCE1 = (int)0x400;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LVL_REM_CCE2 = (int)0x800;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LVL_IO = (int)0x1000;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LVL_UNC = (int)0x2000;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LVL_SHIFT = (int)5;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_SNOOP_NA = (int)0x01;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_SNOOP_NONE = (int)0x02;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_SNOOP_HIT = (int)0x04;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_SNOOP_MISS = (int)0x08;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_SNOOP_HITM = (int)0x10;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_SNOOP_SHIFT = (int)19;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LOCK_NA = (int)0x01;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LOCK_LOCKED = (int)0x02;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_LOCK_SHIFT = (int)24;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_TLB_NA = (int)0x01;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_TLB_HIT = (int)0x02;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_TLB_MISS = (int)0x04;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_TLB_L1 = (int)0x08;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_TLB_L2 = (int)0x10;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_TLB_WK = (int)0x20;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_TLB_OS = (int)0x40;
	/** <i>native declaration : perf_event.h</i> */
	public static final int PERF_MEM_TLB_SHIFT = (int)26;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int LIBPFM_VERSION = (int)(4 << 16 | 0);
	/** <i>native declaration : pfmlib.h</i> */
	public static final int LIBPFM_ABI_VERSION = (int)0;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_PLM0 = (int)0x01;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_PLM1 = (int)0x02;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_PLM2 = (int)0x04;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_PLM3 = (int)0x08;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_PLMH = (int)0x10;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_PMU_INFO_ABI0 = (int)56;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_EVENT_INFO_ABI0 = (int)64;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_ATTR_INFO_ABI0 = (int)64;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_RAW_ENCODE_ABI0 = (int)32;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_SUCCESS = (int)0;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_ERR_NOTSUPP = (int)-1;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_ERR_INVAL = (int)-2;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_ERR_NOINIT = (int)-3;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_ERR_NOTFOUND = (int)-4;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_ERR_FEATCOMB = (int)-5;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_ERR_UMASK = (int)-6;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_ERR_NOMEM = (int)-7;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_ERR_ATTR = (int)-8;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_ERR_ATTR_VAL = (int)-9;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_ERR_ATTR_SET = (int)-10;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_ERR_TOOMANY = (int)-11;
	/** <i>native declaration : pfmlib.h</i> */
	public static final int PFM_ERR_TOOSMALL = (int)-12;
	/** <i>native declaration : /usr/local/include/perfmon/pfmlib_perf_event.h</i> */
	public static final int PFM_PERF_ENCODE_ABI0 = (int)40;
	/**
	 * initialization, configuration, errors<br>
	 * Original signature : <code>pfm_err_t pfm_initialize()</code><br>
	 * <i>native declaration : pfmlib.h:415</i>
	 */
	public static native int pfm_initialize();
	/**
	 * Original signature : <code>void pfm_terminate()</code><br>
	 * <i>native declaration : pfmlib.h:416</i>
	 */
	public static native void pfm_terminate();
	/**
	 * Original signature : <code>char* pfm_strerror(int)</code><br>
	 * <i>native declaration : pfmlib.h:417</i>
	 */
	public static native Pointer<Byte > pfm_strerror(int code);
	/**
	 * Original signature : <code>int pfm_get_version()</code><br>
	 * <i>native declaration : pfmlib.h:418</i>
	 */
	public static native int pfm_get_version();
	/**
	 * PMU API<br>
	 * Original signature : <code>pfm_err_t pfm_get_pmu_info(pfm_pmu_t, pfm_pmu_info_t*)</code><br>
	 * <i>native declaration : pfmlib.h:423</i>
	 */
	public static native int pfm_get_pmu_info(IntValuedEnum<LibpfmLibrary.pfm_pmu_t > pmu, Pointer<pfm_pmu_info_t > output);
	/**
	 * event API<br>
	 * Original signature : <code>int pfm_get_event_next(int)</code><br>
	 * <i>native declaration : pfmlib.h:428</i>
	 */
	public static native int pfm_get_event_next(int idx);
	/**
	 * Original signature : <code>int pfm_find_event(const char*)</code><br>
	 * <i>native declaration : pfmlib.h:429</i>
	 */
	public static native int pfm_find_event(Pointer<Byte > str);
	/**
	 * Original signature : <code>pfm_err_t pfm_get_event_info(int, pfm_os_t, pfm_event_info_t*)</code><br>
	 * <i>native declaration : pfmlib.h:430</i>
	 */
	public static native int pfm_get_event_info(int idx, IntValuedEnum<LibpfmLibrary.pfm_os_t > os, Pointer<pfm_event_info_t > output);
	/**
	 * event encoding API<br>
	 * content of args depends on value of os (refer to man page)<br>
	 * Original signature : <code>pfm_err_t pfm_get_os_event_encoding(const char*, int, pfm_os_t, void*)</code><br>
	 * <i>native declaration : pfmlib.h:437</i>
	 */
	public static native int pfm_get_os_event_encoding(Pointer<Byte > str, int dfl_plm, IntValuedEnum<LibpfmLibrary.pfm_os_t > os, Pointer<? > args);
	/**
	 * attribute API<br>
	 * Original signature : <code>pfm_err_t pfm_get_event_attr_info(int, int, pfm_os_t, pfm_event_attr_info_t*)</code><br>
	 * <i>native declaration : pfmlib.h:442</i>
	 */
	public static native int pfm_get_event_attr_info(int eidx, int aidx, IntValuedEnum<LibpfmLibrary.pfm_os_t > os, Pointer<pfm_event_attr_info_t > output);
	/**
	 * library validation API<br>
	 * Original signature : <code>pfm_err_t pfm_pmu_validate(pfm_pmu_t, FILE*)</code><br>
	 * <i>native declaration : pfmlib.h:447</i>
	 */
	public static native int pfm_pmu_validate(IntValuedEnum<LibpfmLibrary.pfm_pmu_t > pmu_id, Pointer fp);
	/**
	 * older encoding API<br>
	 * Original signature : <code>pfm_err_t pfm_get_event_encoding(const char*, int, char**, int*, uint64_t**, int*)</code><br>
	 * <i>native declaration : pfmlib.h:452</i>
	 */
	public static native int pfm_get_event_encoding(Pointer<Byte > str, int dfl_plm, Pointer<Pointer<Byte > > fstr, Pointer<Integer > idx, Pointer<Pointer<Long > > codes, Pointer<Integer > count);
	/**
	 * old interface, maintained for backward compatibility with older versions o<br>
	 * the library. Should use pfm_get_os_event_encoding() now<br>
	 * Original signature : <code>pfm_err_t pfm_get_perf_event_encoding(const char*, int, perf_event_attr*, char**, int*)</code><br>
	 * <i>native declaration : /usr/local/include/perfmon/pfmlib_perf_event.h:53</i>
	 */
	public static native int pfm_get_perf_event_encoding(Pointer<Byte > str, int dfl_plm, Pointer<perf_event_attr > output, Pointer<Pointer<Byte > > fstr, Pointer<Integer > idx);
}
