/*
 * Decompiled with CFR 0.152.
 */
package net.fusejna.types;

import com.sun.jna.IntegerType;
import net.fusejna.Platform;

public class TypeMode
extends IntegerType {
    public static final long maskNodeType = 61440L;
    public static final long S_IFSOCK = 49152L;
    public static final long S_IFLNK = 40960L;
    public static final long S_IFREG = 32768L;
    public static final long S_IFBLK = 24576L;
    public static final long S_IFDIR = 16384L;
    public static final long S_IFCHR = 8192L;
    public static final long S_IFIFO = 4096L;
    public static final long S_ISUID = 2048L;
    public static final long S_ISGID = 1024L;
    public static final long S_ISVTX = 512L;
    public static final long S_IRUSR = 256L;
    public static final long S_IWUSR = 128L;
    public static final long S_IXUSR = 64L;
    public static final long S_IRGRP = 32L;
    public static final long S_IWGRP = 16L;
    public static final long S_IXGRP = 8L;
    public static final long S_IROTH = 4L;
    public static final long S_IWOTH = 2L;
    public static final long S_IXOTH = 1L;
    private static final int size;

    public TypeMode() {
        super(size);
    }

    public TypeMode(long value) {
        super(size, value);
    }

    static {
        switch (Platform.platform()) {
            case MAC: 
            case MAC_MACFUSE: 
            case FREEBSD: {
                size = 2;
                break;
            }
            case LINUX_I686: 
            case LINUX_PPC: 
            case LINUX_X86_64: {
                size = Platform.size(Integer.class);
                break;
            }
            default: {
                size = 0;
            }
        }
    }

    public static enum NodeType {
        FILE,
        DIRECTORY,
        SYMBOLIC_LINK,
        SOCKET,
        FIFO,
        BLOCK_DEVICE;


        public static final NodeType fromBits(long bits) {
            int intBits = (int)(bits & 0xF000L);
            switch (intBits) {
                case 32768: {
                    return FILE;
                }
                case 16384: {
                    return DIRECTORY;
                }
                case 40960: {
                    return SYMBOLIC_LINK;
                }
                case 49152: {
                    return SOCKET;
                }
                case 4096: {
                    return FIFO;
                }
                case 24576: {
                    return BLOCK_DEVICE;
                }
            }
            return null;
        }

        public final long getBits() {
            switch (this) {
                case FILE: {
                    return 32768L;
                }
                case DIRECTORY: {
                    return 16384L;
                }
                case SYMBOLIC_LINK: {
                    return 40960L;
                }
                case SOCKET: {
                    return 49152L;
                }
                case FIFO: {
                    return 4096L;
                }
                case BLOCK_DEVICE: {
                    return 24576L;
                }
            }
            return -1L;
        }
    }

    public static final class ModeWrapper
    implements IModeWrapper {
        private long bits;

        public ModeWrapper(long bits) {
            this.bits = bits;
        }

        public ModeWrapper(TypeMode mode) {
            this(mode.longValue());
        }

        @Override
        public final long mode() {
            return this.bits;
        }

        @Override
        public final ModeWrapper mode(long bits) {
            this.bits = bits;
            return this;
        }

        @Override
        public final ModeWrapper setMode(NodeType type) {
            return this.setMode(type, true, true, true, true, true, true, true, true, true);
        }

        @Override
        public final ModeWrapper setMode(NodeType type, boolean readable, boolean writable, boolean executable) {
            return this.setMode(type, readable, writable, executable, readable, writable, executable, readable, writable, executable);
        }

        @Override
        public final ModeWrapper setMode(NodeType type, boolean ownerReadable, boolean ownerWritable, boolean ownerExecutable, boolean groupReadable, boolean groupWritable, boolean groupExecutable, boolean otherReadable, boolean otherWritable, boolean otherExecutable) {
            long mode = (type == null ? NodeType.FILE : type).getBits();
            mode |= (ownerReadable ? 256L : 0L) | (ownerWritable ? 128L : 0L) | (ownerExecutable ? 64L : 0L);
            mode |= (groupReadable ? 32L : 0L) | (groupWritable ? 16L : 0L) | (groupExecutable ? 8L : 0L);
            return this.mode(mode |= (otherReadable ? 4L : 0L) | (otherWritable ? 2L : 0L) | (otherExecutable ? 1L : 0L));
        }

        public final String toString() {
            return (Object)((Object)this.type()) + String.format("(%o)", this.bits);
        }

        @Override
        public final NodeType type() {
            return NodeType.fromBits(this.bits);
        }
    }

    public static interface IModeWrapper {
        public long mode();

        public IModeWrapper mode(long var1);

        public IModeWrapper setMode(NodeType var1);

        public IModeWrapper setMode(NodeType var1, boolean var2, boolean var3, boolean var4);

        public IModeWrapper setMode(NodeType var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10);

        public NodeType type();
    }
}

