/*
 * Decompiled with CFR 0.152.
 */
package net.fusejna.examples;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.fusejna.ErrorCodes;
import net.fusejna.FuseException;
import net.fusejna.XattrFiller;
import net.fusejna.XattrListFiller;
import net.fusejna.examples.HelloFS;

public final class XattrExampleFS
extends HelloFS {
    private final Map<String, byte[]> helloTxtAttrs = new HashMap<String, byte[]>();

    public static void main(String ... args) throws FuseException {
        if (args.length != 1) {
            System.err.println("Usage: XattrExampleFS <mountpoint>");
            System.exit(1);
        }
        new XattrExampleFS().log(true).mount(args[0]);
    }

    @Override
    public int getxattr(String path, String xattr, XattrFiller filler, long size, long position) {
        if (!path.equals("/hello.txt")) {
            return -ErrorCodes.firstNonNull(ErrorCodes.ENOATTR(), ErrorCodes.ENOATTR(), ErrorCodes.ENODATA()).intValue();
        }
        if (!this.helloTxtAttrs.containsKey(xattr)) {
            return -ErrorCodes.firstNonNull(ErrorCodes.ENOATTR(), ErrorCodes.ENOATTR(), ErrorCodes.ENODATA()).intValue();
        }
        filler.set(this.helloTxtAttrs.get(xattr));
        return 0;
    }

    @Override
    public int listxattr(String path, XattrListFiller filler) {
        if (!path.equals("/hello.txt")) {
            return -ErrorCodes.ENOTSUP().intValue();
        }
        filler.add(this.helloTxtAttrs.keySet());
        return 0;
    }

    @Override
    public int removexattr(String path, String xattr) {
        if (!path.equals("/hello.txt")) {
            return -ErrorCodes.ENOTSUP().intValue();
        }
        if (!this.helloTxtAttrs.containsKey(xattr)) {
            return -ErrorCodes.ENOATTR().intValue();
        }
        this.helloTxtAttrs.remove(xattr);
        return 0;
    }

    @Override
    public int setxattr(String path, String xattr, ByteBuffer buf, long size, int flags, int position) {
        byte[] attr;
        if (!path.equals("/hello.txt")) {
            return -ErrorCodes.ENOTSUP().intValue();
        }
        if (!this.helloTxtAttrs.containsKey(xattr)) {
            attr = new byte[(int)(size + (long)position)];
            this.helloTxtAttrs.put(xattr, attr);
        } else {
            attr = this.helloTxtAttrs.get(xattr);
            if ((long)attr.length < size + (long)position) {
                attr = Arrays.copyOf(attr, (int)(size + (long)position));
            }
        }
        buf.get(attr, position, (int)size);
        return 0;
    }
}

