/*
 * Decompiled with CFR 0.152.
 */
package net.fusejna.examples;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.fusejna.DirectoryFiller;
import net.fusejna.ErrorCodes;
import net.fusejna.FuseException;
import net.fusejna.StructFuseFileInfo;
import net.fusejna.StructStat;
import net.fusejna.types.TypeMode;
import net.fusejna.util.FuseFilesystemAdapterAssumeImplemented;

public class MemoryFS
extends FuseFilesystemAdapterAssumeImplemented {
    private final MemoryDirectory rootDirectory = new MemoryDirectory("");

    public static void main(String ... args) throws FuseException {
        if (args.length != 1) {
            System.err.println("Usage: MemoryFS <mountpoint>");
            System.exit(1);
        }
        new MemoryFS().log(true).mount(args[0]);
    }

    public MemoryFS() {
        this.rootDirectory.add(new MemoryFile("Sample file.txt", "Hello there, feel free to look around.\n"));
        this.rootDirectory.add(new MemoryDirectory("Sample directory"));
        MemoryDirectory dirWithFiles = new MemoryDirectory("Directory with files");
        this.rootDirectory.add(dirWithFiles);
        dirWithFiles.add(new MemoryFile("hello.txt", "This is some sample text.\n"));
        dirWithFiles.add(new MemoryFile("hello again.txt", "This another file with text in it! Oh my!\n"));
        MemoryDirectory nestedDirectory = new MemoryDirectory("Sample nested directory");
        dirWithFiles.add(nestedDirectory);
        nestedDirectory.add(new MemoryFile("So deep.txt", "Man, I'm like, so deep in this here file structure.\n"));
    }

    @Override
    public int access(String path, int access) {
        return 0;
    }

    @Override
    public int create(String path, TypeMode.ModeWrapper mode, StructFuseFileInfo.FileInfoWrapper info) {
        if (this.getPath(path) != null) {
            return -ErrorCodes.EEXIST();
        }
        MemoryPath parent = this.getParentPath(path);
        if (parent instanceof MemoryDirectory) {
            ((MemoryDirectory)parent).mkfile(this.getLastComponent(path));
            return 0;
        }
        return -ErrorCodes.ENOENT();
    }

    @Override
    public int getattr(String path, StructStat.StatWrapper stat) {
        MemoryPath p = this.getPath(path);
        if (p != null) {
            p.getattr(stat);
            return 0;
        }
        return -ErrorCodes.ENOENT();
    }

    private String getLastComponent(String path) {
        while (path.substring(path.length() - 1).equals("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.isEmpty()) {
            return "";
        }
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private MemoryPath getParentPath(String path) {
        return this.rootDirectory.find(path.substring(0, path.lastIndexOf("/")));
    }

    private MemoryPath getPath(String path) {
        return this.rootDirectory.find(path);
    }

    @Override
    public int mkdir(String path, TypeMode.ModeWrapper mode) {
        if (this.getPath(path) != null) {
            return -ErrorCodes.EEXIST();
        }
        MemoryPath parent = this.getParentPath(path);
        if (parent instanceof MemoryDirectory) {
            ((MemoryDirectory)parent).mkdir(this.getLastComponent(path));
            return 0;
        }
        return -ErrorCodes.ENOENT();
    }

    @Override
    public int open(String path, StructFuseFileInfo.FileInfoWrapper info) {
        return 0;
    }

    @Override
    public int read(String path, ByteBuffer buffer, long size, long offset, StructFuseFileInfo.FileInfoWrapper info) {
        MemoryPath p = this.getPath(path);
        if (p == null) {
            return -ErrorCodes.ENOENT();
        }
        if (!(p instanceof MemoryFile)) {
            return -ErrorCodes.EISDIR();
        }
        return ((MemoryFile)p).read(buffer, size, offset);
    }

    @Override
    public int readdir(String path, DirectoryFiller filler) {
        MemoryPath p = this.getPath(path);
        if (p == null) {
            return -ErrorCodes.ENOENT();
        }
        if (!(p instanceof MemoryDirectory)) {
            return -ErrorCodes.ENOTDIR();
        }
        ((MemoryDirectory)p).read(filler);
        return 0;
    }

    @Override
    public int rename(String path, String newName) {
        MemoryPath p = this.getPath(path);
        if (p == null) {
            return -ErrorCodes.ENOENT();
        }
        MemoryPath newParent = this.getParentPath(newName);
        if (newParent == null) {
            return -ErrorCodes.ENOENT();
        }
        if (!(newParent instanceof MemoryDirectory)) {
            return -ErrorCodes.ENOTDIR();
        }
        p.delete();
        p.rename(newName.substring(newName.lastIndexOf("/")));
        ((MemoryDirectory)newParent).add(p);
        return 0;
    }

    @Override
    public int rmdir(String path) {
        MemoryPath p = this.getPath(path);
        if (p == null) {
            return -ErrorCodes.ENOENT();
        }
        if (!(p instanceof MemoryDirectory)) {
            return -ErrorCodes.ENOTDIR();
        }
        p.delete();
        return 0;
    }

    @Override
    public int truncate(String path, long offset) {
        MemoryPath p = this.getPath(path);
        if (p == null) {
            return -ErrorCodes.ENOENT();
        }
        if (!(p instanceof MemoryFile)) {
            return -ErrorCodes.EISDIR();
        }
        ((MemoryFile)p).truncate(offset);
        return 0;
    }

    @Override
    public int unlink(String path) {
        MemoryPath p = this.getPath(path);
        if (p == null) {
            return -ErrorCodes.ENOENT();
        }
        p.delete();
        return 0;
    }

    @Override
    public int write(String path, ByteBuffer buf, long bufSize, long writeOffset, StructFuseFileInfo.FileInfoWrapper wrapper) {
        MemoryPath p = this.getPath(path);
        if (p == null) {
            return -ErrorCodes.ENOENT();
        }
        if (!(p instanceof MemoryFile)) {
            return -ErrorCodes.EISDIR();
        }
        return ((MemoryFile)p).write(buf, bufSize, writeOffset);
    }

    private abstract class MemoryPath {
        private String name;
        private MemoryDirectory parent;

        private MemoryPath(String name) {
            this(name, (MemoryDirectory)null);
        }

        private MemoryPath(String name, MemoryDirectory parent) {
            this.name = name;
            this.parent = parent;
        }

        private void delete() {
            if (this.parent != null) {
                this.parent.contents.remove(this);
                this.parent = null;
            }
        }

        protected MemoryPath find(String path) {
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.equals(this.name) || path.isEmpty()) {
                return this;
            }
            return null;
        }

        protected abstract void getattr(StructStat.StatWrapper var1);

        private void rename(String newName) {
            while (newName.startsWith("/")) {
                newName = newName.substring(1);
            }
            this.name = newName;
        }
    }

    private final class MemoryFile
    extends MemoryPath {
        private ByteBuffer contents;

        private MemoryFile(String name) {
            super(name);
            this.contents = ByteBuffer.allocate(0);
        }

        private MemoryFile(String name, MemoryDirectory parent) {
            super(name, parent);
            this.contents = ByteBuffer.allocate(0);
        }

        public MemoryFile(String name, String text) {
            super(name);
            this.contents = ByteBuffer.allocate(0);
            try {
                byte[] contentBytes = text.getBytes("UTF-8");
                this.contents = ByteBuffer.wrap(contentBytes);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }

        @Override
        protected void getattr(StructStat.StatWrapper stat) {
            stat.setMode(TypeMode.NodeType.FILE);
            stat.size(this.contents.capacity());
        }

        private int read(ByteBuffer buffer, long size, long offset) {
            int bytesToRead = (int)Math.min((long)this.contents.capacity() - offset, size);
            byte[] bytesRead = new byte[bytesToRead];
            this.contents.position((int)offset);
            this.contents.get(bytesRead, 0, bytesToRead);
            buffer.put(bytesRead);
            this.contents.position(0);
            return bytesToRead;
        }

        private void truncate(long size) {
            if (size < (long)this.contents.capacity()) {
                ByteBuffer newContents = ByteBuffer.allocate((int)size);
                byte[] bytesRead = new byte[(int)size];
                this.contents.get(bytesRead);
                newContents.put(bytesRead);
                this.contents = newContents;
            }
        }

        private int write(ByteBuffer buffer, long bufSize, long writeOffset) {
            int maxWriteIndex = (int)(writeOffset + bufSize);
            if (maxWriteIndex > this.contents.capacity()) {
                ByteBuffer newContents = ByteBuffer.allocate(maxWriteIndex);
                newContents.put(this.contents);
                this.contents = newContents;
            }
            byte[] bytesToWrite = new byte[(int)bufSize];
            buffer.get(bytesToWrite, 0, (int)bufSize);
            this.contents.position((int)writeOffset);
            this.contents.put(bytesToWrite);
            this.contents.position(0);
            return (int)bufSize;
        }
    }

    private final class MemoryDirectory
    extends MemoryPath {
        private final List<MemoryPath> contents;

        private MemoryDirectory(String name) {
            super(name);
            this.contents = new ArrayList<MemoryPath>();
        }

        private MemoryDirectory(String name, MemoryDirectory parent) {
            super(name, parent);
            this.contents = new ArrayList<MemoryPath>();
        }

        public void add(MemoryPath p) {
            this.contents.add(p);
            p.parent = this;
        }

        @Override
        protected MemoryPath find(String path) {
            if (super.find(path) != null) {
                return super.find(path);
            }
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!path.contains("/")) {
                for (MemoryPath p : this.contents) {
                    if (!p.name.equals(path)) continue;
                    return p;
                }
                return null;
            }
            String nextName = path.substring(0, path.indexOf("/"));
            String rest = path.substring(path.indexOf("/"));
            for (MemoryPath p : this.contents) {
                if (!p.name.equals(nextName)) continue;
                return p.find(rest);
            }
            return null;
        }

        @Override
        protected void getattr(StructStat.StatWrapper stat) {
            stat.setMode(TypeMode.NodeType.DIRECTORY);
        }

        private void mkdir(String lastComponent) {
            this.contents.add(new MemoryDirectory(lastComponent, this));
        }

        public void mkfile(String lastComponent) {
            this.contents.add(new MemoryFile(lastComponent, this));
        }

        public void read(DirectoryFiller filler) {
            for (MemoryPath p : this.contents) {
                filler.add(p.name);
            }
        }
    }
}

