/*
 * Decompiled with CFR 0.152.
 */
package net.fusejna.examples;

import java.io.File;
import java.nio.ByteBuffer;
import net.fusejna.DirectoryFiller;
import net.fusejna.ErrorCodes;
import net.fusejna.FuseException;
import net.fusejna.StructFuseFileInfo;
import net.fusejna.StructStat;
import net.fusejna.types.TypeMode;
import net.fusejna.util.FuseFilesystemAdapterFull;

public class HelloFS
extends FuseFilesystemAdapterFull {
    final String filename = "/hello.txt";
    final String contents = "Hello World!\n";

    public static void main(String ... args) throws FuseException {
        if (args.length != 1) {
            System.err.println("Usage: HelloFS <mountpoint>");
            System.exit(1);
        }
        new HelloFS().log(true).mount(args[0]);
    }

    @Override
    public int getattr(String path, StructStat.StatWrapper stat) {
        if (path.equals(File.separator)) {
            stat.setMode(TypeMode.NodeType.DIRECTORY);
            return 0;
        }
        if (path.equals("/hello.txt")) {
            stat.setMode(TypeMode.NodeType.FILE).size("Hello World!\n".length());
            return 0;
        }
        return -ErrorCodes.ENOENT();
    }

    @Override
    public int read(String path, ByteBuffer buffer, long size, long offset, StructFuseFileInfo.FileInfoWrapper info) {
        String s = "Hello World!\n".substring((int)offset, (int)Math.max(offset, Math.min((long)"Hello World!\n".length() - offset, offset + size)));
        buffer.put(s.getBytes());
        return s.getBytes().length;
    }

    @Override
    public int readdir(String path, DirectoryFiller filler) {
        filler.add("/hello.txt");
        return 0;
    }
}

