/*
 * Decompiled with CFR 0.152.
 */
package net.fusejna;

import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
import net.fusejna.StructTimespec;

public class StructTimeBuffer
extends Structure {
    public static final List<String> FIELD_ORDER = Arrays.asList("actime", "modtime");
    public StructTimespec.ByValue actime;
    public StructTimespec.ByValue modtime;

    @Override
    protected List<String> getFieldOrder() {
        return FIELD_ORDER;
    }

    public static final class TimeBufferWrapper {
        private final StructTimeBuffer timeBuffer;

        TimeBufferWrapper(StructTimeBuffer timeBuffer) {
            this.timeBuffer = timeBuffer;
        }

        public final long ac_nsec() {
            return this.timeBuffer.actime.nsec();
        }

        public final long ac_sec() {
            return this.timeBuffer.actime.sec();
        }

        public final TimeBufferWrapper ac_set(double time) {
            this.timeBuffer.actime.set(time);
            return this;
        }

        public final TimeBufferWrapper ac_set(long sec, long nsec) {
            this.timeBuffer.actime.set(sec, nsec);
            return this;
        }

        public final TimeBufferWrapper ac_setMillis(long millis) {
            this.timeBuffer.actime.setMillis(millis);
            return this;
        }

        public final TimeBufferWrapper ac_setSeconds(long seconds) {
            this.timeBuffer.actime.setSeconds(seconds);
            return this;
        }

        public final TimeBufferWrapper both_set(double time) {
            this.ac_set(time);
            this.mod_set(time);
            return this;
        }

        public final TimeBufferWrapper both_set(long sec, long nsec) {
            this.ac_set(sec, nsec);
            this.mod_set(sec, nsec);
            return this;
        }

        public final TimeBufferWrapper both_setMillis(long millis) {
            this.ac_setMillis(millis);
            this.mod_setMillis(millis);
            return this;
        }

        public final TimeBufferWrapper both_setSeconds(long seconds) {
            this.ac_setSeconds(seconds);
            this.mod_setSeconds(seconds);
            return this;
        }

        public final long mod_nsec() {
            return this.timeBuffer.modtime.nsec();
        }

        public final long mod_sec() {
            return this.timeBuffer.modtime.sec();
        }

        public final TimeBufferWrapper mod_set(double time) {
            this.timeBuffer.modtime.set(time);
            return this;
        }

        public final TimeBufferWrapper mod_set(long sec, long nsec) {
            this.timeBuffer.modtime.set(sec, nsec);
            return this;
        }

        public final TimeBufferWrapper mod_setMillis(long millis) {
            this.timeBuffer.modtime.setMillis(millis);
            return this;
        }

        public final TimeBufferWrapper mod_setSeconds(long seconds) {
            this.timeBuffer.modtime.setSeconds(seconds);
            return this;
        }

        public final String toString() {
            return this.timeBuffer.toString();
        }

        final void write() {
            this.timeBuffer.write();
        }
    }

    public static final class ByValue
    extends StructTimeBuffer
    implements Structure.ByValue {
    }

    public static final class ByReference
    extends StructTimeBuffer
    implements Structure.ByReference {
    }
}

