/*
 * Decompiled with CFR 0.152.
 */
package net.fusejna;

import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
import net.fusejna.StructTimespec;
import net.fusejna.types.TypeBlkCnt;
import net.fusejna.types.TypeBlkSize;
import net.fusejna.types.TypeDev;
import net.fusejna.types.TypeGen;
import net.fusejna.types.TypeGid;
import net.fusejna.types.TypeIno;
import net.fusejna.types.TypeLspare;
import net.fusejna.types.TypeMode;
import net.fusejna.types.TypeNLink;
import net.fusejna.types.TypeOff;
import net.fusejna.types.TypeQspare;
import net.fusejna.types.TypeUInt32;
import net.fusejna.types.TypeUid;

public abstract class StructStat
extends Structure {
    abstract void st_atime(long var1, long var3);

    abstract long st_atime_nsec();

    abstract long st_atime_sec();

    abstract void st_birthtime(long var1, long var3);

    abstract long st_birthtime_nsec();

    abstract long st_birthtime_sec();

    abstract long st_blksize();

    abstract void st_blksize(long var1);

    abstract long st_blocks();

    abstract void st_blocks(long var1);

    abstract void st_ctime(long var1, long var3);

    abstract long st_ctime_nsec();

    abstract long st_ctime_sec();

    abstract long st_dev();

    abstract void st_dev(long var1);

    abstract long st_gen();

    abstract void st_gen(long var1);

    abstract long st_gid();

    abstract void st_gid(long var1);

    abstract long st_ino();

    abstract void st_ino(long var1);

    abstract long st_lspare();

    abstract void st_lspare(long var1);

    abstract long st_mode();

    abstract void st_mode(long var1);

    abstract void st_mtime(long var1, long var3);

    abstract long st_mtime_nsec();

    abstract long st_mtime_sec();

    abstract long st_nlink();

    abstract void st_nlink(long var1);

    abstract long st_qspare();

    abstract void st_qspare(long var1);

    abstract long st_rdev();

    abstract void st_rdev(long var1);

    abstract long st_size();

    abstract void st_size(long var1);

    abstract long st_uid();

    abstract void st_uid(long var1);

    public static class X86_64
    extends StructStat {
        public static final List<String> FIELD_ORDER = Arrays.asList("st_dev", "st_ino", "st_nlink", "st_mode", "st_uid", "st_gid", "__pad0", "st_rdev", "st_size", "st_blksize", "st_blocks", "st_atime", "st_mtime", "st_ctime");
        public TypeDev st_dev;
        public TypeIno st_ino;
        public TypeNLink st_nlink;
        public TypeMode st_mode;
        public TypeUid st_uid;
        public TypeGid st_gid;
        public int __pad0;
        public TypeDev st_rdev;
        public TypeOff st_size;
        public TypeBlkSize st_blksize;
        public TypeBlkCnt st_blocks;
        public StructTimespec.ByValue st_atime;
        public StructTimespec.ByValue st_mtime;
        public StructTimespec.ByValue st_ctime;

        @Override
        protected List<String> getFieldOrder() {
            return FIELD_ORDER;
        }

        @Override
        final void st_atime(long sec, long nsec) {
            this.st_atime.set(sec, nsec);
        }

        @Override
        final long st_atime_nsec() {
            return this.st_atime.nsec();
        }

        @Override
        final long st_atime_sec() {
            return this.st_atime.sec();
        }

        @Override
        final void st_birthtime(long sec, long nsec) {
        }

        @Override
        final long st_birthtime_nsec() {
            return -1L;
        }

        @Override
        final long st_birthtime_sec() {
            return -1L;
        }

        @Override
        final long st_blksize() {
            return this.st_blksize.longValue();
        }

        @Override
        final void st_blksize(long st_blksize) {
            this.st_blksize.setValue(st_blksize);
        }

        @Override
        final long st_blocks() {
            return this.st_blocks.longValue();
        }

        @Override
        final void st_blocks(long st_blocks) {
            this.st_blocks.setValue(st_blocks);
        }

        @Override
        final void st_ctime(long sec, long nsec) {
            this.st_ctime.set(sec, nsec);
        }

        @Override
        final long st_ctime_nsec() {
            return this.st_ctime.nsec();
        }

        @Override
        final long st_ctime_sec() {
            return this.st_ctime.sec();
        }

        @Override
        final long st_dev() {
            return this.st_dev.longValue();
        }

        @Override
        final void st_dev(long st_dev) {
            this.st_dev.setValue(st_dev);
        }

        @Override
        final long st_gen() {
            return -1L;
        }

        @Override
        final void st_gen(long st_gen) {
        }

        @Override
        final long st_gid() {
            return this.st_gid.longValue();
        }

        @Override
        final void st_gid(long st_gid) {
            this.st_gid.setValue(st_gid);
        }

        @Override
        final long st_ino() {
            return this.st_ino.longValue();
        }

        @Override
        final void st_ino(long st_ino) {
            this.st_ino.setValue(st_ino);
        }

        @Override
        final long st_lspare() {
            return -1L;
        }

        @Override
        final void st_lspare(long st_lspare) {
        }

        @Override
        final long st_mode() {
            return this.st_mode.longValue();
        }

        @Override
        final void st_mode(long st_mode) {
            this.st_mode.setValue(st_mode);
        }

        @Override
        final void st_mtime(long sec, long nsec) {
            this.st_mtime.set(sec, nsec);
        }

        @Override
        final long st_mtime_nsec() {
            return this.st_mtime.nsec();
        }

        @Override
        final long st_mtime_sec() {
            return this.st_mtime.sec();
        }

        @Override
        final long st_nlink() {
            return this.st_nlink.longValue();
        }

        @Override
        final void st_nlink(long st_nlink) {
            this.st_nlink.setValue(st_nlink);
        }

        @Override
        final long st_qspare() {
            return -1L;
        }

        @Override
        final void st_qspare(long st_qspare) {
        }

        @Override
        final long st_rdev() {
            return this.st_rdev.longValue();
        }

        @Override
        final void st_rdev(long st_rdev) {
            this.st_rdev.setValue(st_rdev);
        }

        @Override
        final long st_size() {
            return this.st_size.longValue();
        }

        @Override
        final void st_size(long st_size) {
            this.st_size.setValue(st_size);
        }

        @Override
        final long st_uid() {
            return this.st_uid.longValue();
        }

        @Override
        final void st_uid(long st_uid) {
            this.st_uid.setValue(st_uid);
        }

        public static final class ByValue
        extends X86_64
        implements Structure.ByValue {
        }

        public static final class ByReference
        extends X86_64
        implements Structure.ByReference {
        }
    }

    public static final class StatWrapper
    implements TypeMode.IModeWrapper {
        private final StructStat structStat;
        private final String path;
        private final TypeMode.ModeWrapper modeWrapper;

        StatWrapper(String path, StructStat structStat) {
            this.path = path;
            this.structStat = structStat;
            this.modeWrapper = new TypeMode.ModeWrapper(structStat.st_mode());
        }

        StatWrapper(StructStat structStat) {
            this(null, structStat);
        }

        public final StatWrapper atime(long sec) {
            return this.atime(sec, 0L);
        }

        public final StatWrapper atime(long sec, long nsec) {
            this.structStat.st_atime(sec, nsec);
            return this;
        }

        public final StatWrapper blksize(long blksize) {
            this.structStat.st_blksize(blksize);
            return this;
        }

        public final StatWrapper blocks(long blocks) {
            this.structStat.st_blocks(blocks);
            return this;
        }

        public final StatWrapper ctime(long sec) {
            return this.ctime(sec, 0L);
        }

        public final StatWrapper ctime(long sec, long nsec) {
            this.structStat.st_ctime(sec, nsec);
            return this;
        }

        public final StatWrapper dev(long dev) {
            this.structStat.st_dev(dev);
            return this;
        }

        public final StatWrapper gen(long gen) {
            this.structStat.st_gen(gen);
            return this;
        }

        public final StatWrapper gid(long gid) {
            this.structStat.st_gid(gid);
            return this;
        }

        public final StatWrapper ino(long ino) {
            this.structStat.st_ino(ino);
            return this;
        }

        public final StatWrapper lspare(long lspare) {
            this.structStat.st_lspare(lspare);
            return this;
        }

        @Override
        public long mode() {
            return this.modeWrapper.mode();
        }

        @Override
        public StatWrapper mode(long bits) {
            this.modeWrapper.mode(bits);
            return this;
        }

        public final StatWrapper mtime(long sec) {
            return this.mtime(sec, 0L);
        }

        public final StatWrapper mtime(long sec, long nsec) {
            this.structStat.st_mtime(sec, nsec);
            return this;
        }

        public final StatWrapper nlink(long nlink) {
            this.structStat.st_nlink(nlink);
            return this;
        }

        public final StatWrapper qspare(long qspare) {
            this.structStat.st_qspare(qspare);
            return this;
        }

        public final StatWrapper rdev(long rdev) {
            this.structStat.st_rdev(rdev);
            return this;
        }

        public final StatWrapper setAllTimes(long sec, long nsec) {
            return this.setTimes(sec, nsec, sec, nsec, sec, nsec);
        }

        public final StatWrapper setAllTimesMillis(long millis) {
            long sec = millis / 1000L;
            long nsec = millis % 1000L * 1000000L;
            return this.setAllTimes(sec, nsec);
        }

        public final StatWrapper setAllTimesSec(long sec) {
            return this.setAllTimesSec(sec, sec, sec);
        }

        public final StatWrapper setAllTimesSec(long atime, long mtime, long ctime) {
            return this.setAllTimesSec(atime, mtime, ctime, ctime);
        }

        public final StatWrapper setAllTimesSec(long atime, long mtime, long ctime, long birthtime) {
            return this.setTimes(atime, 0L, mtime, 0L, ctime, 0L);
        }

        @Override
        public StatWrapper setMode(TypeMode.NodeType type) {
            this.modeWrapper.setMode(type);
            return this;
        }

        @Override
        public StatWrapper setMode(TypeMode.NodeType type, boolean readable, boolean writable, boolean executable) {
            this.modeWrapper.setMode(type, readable, writable, executable);
            return this;
        }

        @Override
        public StatWrapper setMode(TypeMode.NodeType type, boolean ownerReadable, boolean ownerWritable, boolean ownerExecutable, boolean groupReadable, boolean groupWritable, boolean groupExecutable, boolean otherReadable, boolean otherWritable, boolean otherExecutable) {
            this.modeWrapper.setMode(type, ownerReadable, ownerWritable, ownerExecutable, groupReadable, groupWritable, groupExecutable, otherReadable, otherWritable, otherExecutable);
            return this;
        }

        public final StatWrapper setTimes(long atime_sec, long atime_nsec, long mtime_sec, long mtime_nsec, long ctime_sec, long ctime_nsec) {
            return this.setTimes(atime_sec, atime_nsec, mtime_sec, mtime_nsec, ctime_sec, ctime_nsec, ctime_sec, ctime_nsec);
        }

        public final StatWrapper setTimes(long atime_sec, long atime_nsec, long mtime_sec, long mtime_nsec, long ctime_sec, long ctime_nsec, long birthtime_sec, long birthtime_nsec) {
            this.structStat.st_atime(atime_sec, atime_nsec);
            this.structStat.st_mtime(mtime_sec, mtime_nsec);
            this.structStat.st_ctime(ctime_sec, ctime_nsec);
            this.structStat.st_birthtime(birthtime_sec, birthtime_nsec);
            return this;
        }

        public final StatWrapper size(long size) {
            this.structStat.st_size(size);
            return this;
        }

        public final String toString() {
            this.structStat.st_mode(this.modeWrapper.mode());
            if (this.path != null) {
                return this.path + "\n" + this.structStat;
            }
            return this.structStat.toString();
        }

        @Override
        public TypeMode.NodeType type() {
            return this.modeWrapper.type();
        }

        public final StatWrapper uid(long uid) {
            this.structStat.st_uid(uid);
            return this;
        }

        final void write() {
            this.structStat.st_mode(this.modeWrapper.mode());
            this.structStat.write();
        }
    }

    public static class PowerPC
    extends StructStat {
        public static final List<String> FIELD_ORDER = Arrays.asList("st_dev", "st_ino", "st_mode", "st_nlink", "st_uid", "st_gid", "st_rdev", "__pad0", "st_size", "st_blksize", "st_blocks", "st_atime", "st_mtime", "st_ctime");
        public TypeDev st_dev;
        public TypeIno st_ino;
        public TypeMode st_mode;
        public TypeNLink st_nlink;
        public TypeUid st_uid;
        public TypeGid st_gid;
        public TypeDev st_rdev;
        public short __pad0;
        public TypeOff st_size;
        public TypeBlkSize st_blksize;
        public TypeBlkCnt st_blocks;
        public StructTimespec.ByValue st_atime;
        public StructTimespec.ByValue st_mtime;
        public StructTimespec.ByValue st_ctime;

        @Override
        protected List<String> getFieldOrder() {
            return FIELD_ORDER;
        }

        @Override
        final void st_atime(long sec, long nsec) {
            this.st_atime.set(sec, nsec);
        }

        @Override
        final long st_atime_nsec() {
            return this.st_atime.nsec();
        }

        @Override
        final long st_atime_sec() {
            return this.st_atime.sec();
        }

        @Override
        final void st_birthtime(long sec, long nsec) {
        }

        @Override
        final long st_birthtime_nsec() {
            return -1L;
        }

        @Override
        final long st_birthtime_sec() {
            return -1L;
        }

        @Override
        final long st_blksize() {
            return this.st_blksize.longValue();
        }

        @Override
        final void st_blksize(long st_blksize) {
            this.st_blksize.setValue(st_blksize);
        }

        @Override
        final long st_blocks() {
            return this.st_blocks.longValue();
        }

        @Override
        final void st_blocks(long st_blocks) {
            this.st_blocks.setValue(st_blocks);
        }

        @Override
        final void st_ctime(long sec, long nsec) {
            this.st_ctime.set(sec, nsec);
        }

        @Override
        final long st_ctime_nsec() {
            return this.st_ctime.nsec();
        }

        @Override
        final long st_ctime_sec() {
            return this.st_ctime.sec();
        }

        @Override
        final long st_dev() {
            return this.st_dev.longValue();
        }

        @Override
        final void st_dev(long st_dev) {
            this.st_dev.setValue(st_dev);
        }

        @Override
        final long st_gen() {
            return -1L;
        }

        @Override
        final void st_gen(long st_gen) {
        }

        @Override
        final long st_gid() {
            return this.st_gid.longValue();
        }

        @Override
        final void st_gid(long st_gid) {
            this.st_gid.setValue(st_gid);
        }

        @Override
        final long st_ino() {
            return this.st_ino.longValue();
        }

        @Override
        final void st_ino(long st_ino) {
            this.st_ino.setValue(st_ino);
        }

        @Override
        final long st_lspare() {
            return -1L;
        }

        @Override
        final void st_lspare(long st_lspare) {
        }

        @Override
        final long st_mode() {
            return this.st_mode.longValue();
        }

        @Override
        final void st_mode(long st_mode) {
            this.st_mode.setValue(st_mode);
        }

        @Override
        final void st_mtime(long sec, long nsec) {
            this.st_mtime.set(sec, nsec);
        }

        @Override
        final long st_mtime_nsec() {
            return this.st_mtime.nsec();
        }

        @Override
        final long st_mtime_sec() {
            return this.st_mtime.sec();
        }

        @Override
        final long st_nlink() {
            return this.st_nlink.longValue();
        }

        @Override
        final void st_nlink(long st_nlink) {
            this.st_nlink.setValue(st_nlink);
        }

        @Override
        final long st_qspare() {
            return -1L;
        }

        @Override
        final void st_qspare(long st_qspare) {
        }

        @Override
        final long st_rdev() {
            return this.st_rdev.longValue();
        }

        @Override
        final void st_rdev(long st_rdev) {
            this.st_rdev.setValue(st_rdev);
        }

        @Override
        final long st_size() {
            return this.st_size.longValue();
        }

        @Override
        final void st_size(long st_size) {
            this.st_size.setValue(st_size);
        }

        @Override
        final long st_uid() {
            return this.st_uid.longValue();
        }

        @Override
        final void st_uid(long st_uid) {
            this.st_uid.setValue(st_uid);
        }

        public static final class ByValue
        extends PowerPC
        implements Structure.ByValue {
        }

        public static final class ByReference
        extends PowerPC
        implements Structure.ByReference {
        }
    }

    public static class Mac
    extends StructStat {
        public static final List<String> FIELD_ORDER = Arrays.asList("st_dev", "st_mode", "st_nlink", "st_ino", "st_uid", "st_gid", "st_rdev", "st_atime", "st_mtime", "st_ctime", "st_birthtime", "st_size", "st_blocks", "st_blksize", "st_gen", "st_lspare", "st_qspare");
        public TypeDev st_dev;
        public TypeMode st_mode;
        public TypeNLink st_nlink;
        public TypeIno st_ino;
        public TypeUid st_uid;
        public TypeGid st_gid;
        public TypeDev st_rdev;
        public StructTimespec.ByValue st_atime;
        public StructTimespec.ByValue st_mtime;
        public StructTimespec.ByValue st_ctime;
        public StructTimespec.ByValue st_birthtime;
        public TypeOff st_size;
        public TypeBlkCnt st_blocks;
        public TypeBlkSize st_blksize;
        public TypeGen st_gen;
        public TypeLspare st_lspare;
        public TypeQspare st_qspare;

        @Override
        protected List<String> getFieldOrder() {
            return FIELD_ORDER;
        }

        @Override
        final void st_atime(long sec, long nsec) {
            this.st_atime.set(sec, nsec);
        }

        @Override
        final long st_atime_nsec() {
            return this.st_atime.nsec();
        }

        @Override
        final long st_atime_sec() {
            return this.st_atime.sec();
        }

        @Override
        final void st_birthtime(long sec, long nsec) {
            this.st_birthtime.set(sec, nsec);
        }

        @Override
        final long st_birthtime_nsec() {
            return this.st_birthtime.nsec();
        }

        @Override
        final long st_birthtime_sec() {
            return this.st_birthtime.sec();
        }

        @Override
        final long st_blksize() {
            return this.st_blksize.longValue();
        }

        @Override
        final void st_blksize(long st_blksize) {
            this.st_blksize.setValue(st_blksize);
        }

        @Override
        final long st_blocks() {
            return this.st_blocks.longValue();
        }

        @Override
        final void st_blocks(long st_blocks) {
            this.st_blocks.setValue(st_blocks);
        }

        @Override
        final void st_ctime(long sec, long nsec) {
            this.st_ctime.set(sec, nsec);
        }

        @Override
        final long st_ctime_nsec() {
            return this.st_ctime.nsec();
        }

        @Override
        final long st_ctime_sec() {
            return this.st_ctime.sec();
        }

        @Override
        final long st_dev() {
            return this.st_dev.longValue();
        }

        @Override
        final void st_dev(long st_dev) {
            this.st_dev.setValue(st_dev);
        }

        @Override
        final long st_gen() {
            return this.st_gen.longValue();
        }

        @Override
        final void st_gen(long st_gen) {
            this.st_gen.setValue(st_gen);
        }

        @Override
        final long st_gid() {
            return this.st_gid.longValue();
        }

        @Override
        final void st_gid(long st_gid) {
            this.st_gid.setValue(st_gid);
        }

        @Override
        final long st_ino() {
            return this.st_ino.longValue();
        }

        @Override
        final void st_ino(long st_ino) {
            this.st_ino.setValue(st_ino);
        }

        @Override
        final long st_lspare() {
            return this.st_lspare.longValue();
        }

        @Override
        final void st_lspare(long st_lspare) {
            this.st_lspare.setValue(st_lspare);
        }

        @Override
        final long st_mode() {
            return this.st_mode.longValue();
        }

        @Override
        final void st_mode(long st_mode) {
            this.st_mode.setValue(st_mode);
        }

        @Override
        final void st_mtime(long sec, long nsec) {
            this.st_mtime.set(sec, nsec);
        }

        @Override
        final long st_mtime_nsec() {
            return this.st_mtime.nsec();
        }

        @Override
        final long st_mtime_sec() {
            return this.st_mtime.sec();
        }

        @Override
        final long st_nlink() {
            return this.st_nlink.longValue();
        }

        @Override
        final void st_nlink(long st_nlink) {
            this.st_nlink.setValue(st_nlink);
        }

        @Override
        final long st_qspare() {
            return this.st_qspare.longValue();
        }

        @Override
        final void st_qspare(long st_qspare) {
            this.st_qspare.setValue(st_qspare);
        }

        @Override
        final long st_rdev() {
            return this.st_rdev.longValue();
        }

        @Override
        final void st_rdev(long st_rdev) {
            this.st_rdev.setValue(st_rdev);
        }

        @Override
        final long st_size() {
            return this.st_size.longValue();
        }

        @Override
        final void st_size(long st_size) {
            this.st_size.setValue(st_size);
        }

        @Override
        final long st_uid() {
            return this.st_uid.longValue();
        }

        @Override
        final void st_uid(long st_uid) {
            this.st_uid.setValue(st_uid);
        }

        public static final class ByValue
        extends Mac
        implements Structure.ByValue {
        }

        public static final class ByReference
        extends Mac
        implements Structure.ByReference {
        }
    }

    public static class I686
    extends StructStat {
        public static final List<String> FIELD_ORDER = Arrays.asList("st_dev", "__pad1", "__st_ino", "st_mode", "st_nlink", "st_uid", "st_gid", "st_rdev", "__pad2", "st_size", "st_blksize", "st_blocks", "st_atime", "st_mtime", "st_ctime", "st_ino");
        public TypeDev st_dev;
        public short __pad1;
        public TypeUInt32 __st_ino;
        public TypeMode st_mode;
        public TypeNLink st_nlink;
        public TypeUid st_uid;
        public TypeGid st_gid;
        public TypeDev st_rdev;
        public short __pad2;
        public TypeOff st_size;
        public TypeBlkSize st_blksize;
        public TypeBlkCnt st_blocks;
        public StructTimespec.ByValue st_atime;
        public StructTimespec.ByValue st_mtime;
        public StructTimespec.ByValue st_ctime;
        public TypeIno st_ino;

        @Override
        protected List<String> getFieldOrder() {
            return FIELD_ORDER;
        }

        @Override
        final void st_atime(long sec, long nsec) {
            this.st_atime.set(sec, nsec);
        }

        @Override
        final long st_atime_nsec() {
            return this.st_atime.nsec();
        }

        @Override
        final long st_atime_sec() {
            return this.st_atime.sec();
        }

        @Override
        final void st_birthtime(long sec, long nsec) {
        }

        @Override
        final long st_birthtime_nsec() {
            return -1L;
        }

        @Override
        final long st_birthtime_sec() {
            return -1L;
        }

        @Override
        final long st_blksize() {
            return this.st_blksize.longValue();
        }

        @Override
        final void st_blksize(long st_blksize) {
            this.st_blksize.setValue(st_blksize);
        }

        @Override
        final long st_blocks() {
            return this.st_blocks.longValue();
        }

        @Override
        final void st_blocks(long st_blocks) {
            this.st_blocks.setValue(st_blocks);
        }

        @Override
        final void st_ctime(long sec, long nsec) {
            this.st_ctime.set(sec, nsec);
        }

        @Override
        final long st_ctime_nsec() {
            return this.st_ctime.nsec();
        }

        @Override
        final long st_ctime_sec() {
            return this.st_ctime.sec();
        }

        @Override
        final long st_dev() {
            return this.st_dev.longValue();
        }

        @Override
        final void st_dev(long st_dev) {
            this.st_dev.setValue(st_dev);
        }

        @Override
        final long st_gen() {
            return -1L;
        }

        @Override
        final void st_gen(long st_gen) {
        }

        @Override
        final long st_gid() {
            return this.st_gid.longValue();
        }

        @Override
        final void st_gid(long st_gid) {
            this.st_gid.setValue(st_gid);
        }

        @Override
        final long st_ino() {
            return this.st_ino.longValue();
        }

        @Override
        final void st_ino(long st_ino) {
            this.st_ino.setValue(st_ino);
        }

        @Override
        final long st_lspare() {
            return -1L;
        }

        @Override
        final void st_lspare(long st_lspare) {
        }

        @Override
        final long st_mode() {
            return this.st_mode.longValue();
        }

        @Override
        final void st_mode(long st_mode) {
            this.st_mode.setValue(st_mode);
        }

        @Override
        final void st_mtime(long sec, long nsec) {
            this.st_mtime.set(sec, nsec);
        }

        @Override
        final long st_mtime_nsec() {
            return this.st_mtime.nsec();
        }

        @Override
        final long st_mtime_sec() {
            return this.st_mtime.sec();
        }

        @Override
        final long st_nlink() {
            return this.st_nlink.longValue();
        }

        @Override
        final void st_nlink(long st_nlink) {
            this.st_nlink.setValue(st_nlink);
        }

        @Override
        final long st_qspare() {
            return -1L;
        }

        @Override
        final void st_qspare(long st_qspare) {
        }

        @Override
        final long st_rdev() {
            return this.st_rdev.longValue();
        }

        @Override
        final void st_rdev(long st_rdev) {
            this.st_rdev.setValue(st_rdev);
        }

        @Override
        final long st_size() {
            return this.st_size.longValue();
        }

        @Override
        final void st_size(long st_size) {
            this.st_size.setValue(st_size);
        }

        @Override
        final long st_uid() {
            return this.st_uid.longValue();
        }

        @Override
        final void st_uid(long st_uid) {
            this.st_uid.setValue(st_uid);
        }

        public static final class ByValue
        extends I686
        implements Structure.ByValue {
        }

        public static final class ByReference
        extends I686
        implements Structure.ByReference {
        }
    }

    public static class BSD
    extends StructStat {
        public static final List<String> FIELD_ORDER = Arrays.asList("st_dev", "st_ino", "st_mode", "st_nlink", "st_uid", "st_gid", "st_rdev", "st_atime", "st_mtime", "st_ctime", "st_size", "st_blocks", "st_blksize");
        public TypeDev st_dev;
        public TypeIno st_ino;
        public TypeMode st_mode;
        public TypeNLink st_nlink;
        public TypeUid st_uid;
        public TypeGid st_gid;
        public TypeDev st_rdev;
        public StructTimespec.ByValue st_atime;
        public StructTimespec.ByValue st_mtime;
        public StructTimespec.ByValue st_ctime;
        public TypeOff st_size;
        public TypeBlkCnt st_blocks;
        public TypeBlkSize st_blksize;

        @Override
        protected List<String> getFieldOrder() {
            return FIELD_ORDER;
        }

        @Override
        final void st_atime(long sec, long nsec) {
            this.st_atime.set(sec, nsec);
        }

        @Override
        final long st_atime_nsec() {
            return this.st_atime.nsec();
        }

        @Override
        final long st_atime_sec() {
            return this.st_atime.sec();
        }

        @Override
        final void st_birthtime(long sec, long nsec) {
        }

        @Override
        final long st_birthtime_nsec() {
            return -1L;
        }

        @Override
        final long st_birthtime_sec() {
            return -1L;
        }

        @Override
        final long st_blksize() {
            return this.st_blksize.longValue();
        }

        @Override
        final void st_blksize(long st_blksize) {
            this.st_blksize.setValue(st_blksize);
        }

        @Override
        final long st_blocks() {
            return this.st_blocks.longValue();
        }

        @Override
        final void st_blocks(long st_blocks) {
            this.st_blocks.setValue(st_blocks);
        }

        @Override
        final void st_ctime(long sec, long nsec) {
            this.st_ctime.set(sec, nsec);
        }

        @Override
        final long st_ctime_nsec() {
            return this.st_ctime.nsec();
        }

        @Override
        final long st_ctime_sec() {
            return this.st_ctime.sec();
        }

        @Override
        final long st_dev() {
            return this.st_dev.longValue();
        }

        @Override
        final void st_dev(long st_dev) {
            this.st_dev.setValue(st_dev);
        }

        @Override
        final long st_gen() {
            return -1L;
        }

        @Override
        final void st_gen(long st_gen) {
        }

        @Override
        final long st_gid() {
            return this.st_gid.longValue();
        }

        @Override
        final void st_gid(long st_gid) {
            this.st_gid.setValue(st_gid);
        }

        @Override
        final long st_ino() {
            return this.st_ino.longValue();
        }

        @Override
        final void st_ino(long st_ino) {
            this.st_ino.setValue(st_ino);
        }

        @Override
        final long st_lspare() {
            return -1L;
        }

        @Override
        final void st_lspare(long st_lspare) {
        }

        @Override
        final long st_mode() {
            return this.st_mode.longValue();
        }

        @Override
        final void st_mode(long st_mode) {
            this.st_mode.setValue(st_mode);
        }

        @Override
        final void st_mtime(long sec, long nsec) {
            this.st_mtime.set(sec, nsec);
        }

        @Override
        final long st_mtime_nsec() {
            return this.st_mtime.nsec();
        }

        @Override
        final long st_mtime_sec() {
            return this.st_mtime.sec();
        }

        @Override
        final long st_nlink() {
            return this.st_nlink.longValue();
        }

        @Override
        final void st_nlink(long st_nlink) {
            this.st_nlink.setValue(st_nlink);
        }

        @Override
        final long st_qspare() {
            return -1L;
        }

        @Override
        final void st_qspare(long st_qspare) {
        }

        @Override
        final long st_rdev() {
            return this.st_rdev.longValue();
        }

        @Override
        final void st_rdev(long st_rdev) {
            this.st_rdev.setValue(st_rdev);
        }

        @Override
        final long st_size() {
            return this.st_size.longValue();
        }

        @Override
        final void st_size(long st_size) {
            this.st_size.setValue(st_size);
        }

        @Override
        final long st_uid() {
            return this.st_uid.longValue();
        }

        @Override
        final void st_uid(long st_uid) {
            this.st_uid.setValue(st_uid);
        }

        public static final class ByValue
        extends BSD
        implements Structure.ByValue {
        }

        public static final class ByReference
        extends BSD
        implements Structure.ByReference {
        }
    }
}

