/*
 * Decompiled with CFR 0.152.
 */
package net.fusejna;

import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
import net.fusejna.FuseFilesystem;
import net.fusejna.Platform;
import net.fusejna.StructFlock;
import net.fusejna.StructFuseConnInfo;
import net.fusejna.StructFuseFileInfo;
import net.fusejna.StructStat;
import net.fusejna.StructStatvfs;
import net.fusejna.StructTimeBuffer;
import net.fusejna.types.TypeDev;
import net.fusejna.types.TypeGid;
import net.fusejna.types.TypeMode;
import net.fusejna.types.TypeOff;
import net.fusejna.types.TypeSize;
import net.fusejna.types.TypeUInt32;
import net.fusejna.types.TypeUid;

public class StructFuseOperations
extends Structure {
    public static final List<String> FIELD_ORDER = Arrays.asList("getattr", "readlink", "getdir", "mknod", "mkdir", "unlink", "rmdir", "symlink", "rename", "link", "chmod", "chown", "truncate", "utime", "open", "read", "write", "statfs", "flush", "release", "fsync", "setxattr", "getxattr", "listxattr", "removexattr", "opendir", "readdir", "releasedir", "fsyncdir", "init", "destroy", "access", "create", "ftruncate", "fgetattr", "lock", "utimens", "bmap");
    public Callback getattr;
    public Callback readlink;
    public Pointer getdir = null;
    public Callback mknod;
    public Callback mkdir;
    public Callback unlink;
    public Callback rmdir;
    public Callback symlink;
    public Callback rename;
    public Callback link;
    public Callback chmod;
    public Callback chown;
    public Callback truncate;
    public Pointer utime = null;
    public Callback open;
    public Callback read;
    public Callback write;
    public Callback statfs;
    public Callback flush;
    public Callback release;
    public Callback fsync;
    public Callback setxattr;
    public Callback getxattr;
    public Callback listxattr;
    public Callback removexattr;
    public Callback opendir;
    public Callback readdir;
    public Callback releasedir;
    public Callback fsyncdir;
    public Callback init;
    public Callback destroy;
    public Callback access;
    public Callback create;
    public Callback ftruncate;
    public Callback fgetattr;
    public Callback lock;
    public Callback utimens;
    public Callback bmap;

    public StructFuseOperations(final FuseFilesystem filesystem) {
        switch (Platform.platform()) {
            case LINUX_X86_64: {
                this.getattr = new Callback(){

                    public final int callback(String path, StructStat.X86_64.ByReference stat) {
                        return filesystem._getattr(path, stat);
                    }
                };
                this.fgetattr = new Callback(){

                    public final int callback(String path, StructStat.X86_64.ByReference stat, StructFuseFileInfo.ByReference info) {
                        return filesystem._fgetattr(path, stat, info);
                    }
                };
                break;
            }
            case LINUX_I686: {
                this.getattr = new Callback(){

                    public final int callback(String path, StructStat.I686.ByReference stat) {
                        return filesystem._getattr(path, stat);
                    }
                };
                this.fgetattr = new Callback(){

                    public final int callback(String path, StructStat.I686.ByReference stat, StructFuseFileInfo.ByReference info) {
                        return filesystem._fgetattr(path, stat, info);
                    }
                };
                break;
            }
            case LINUX_PPC: {
                this.getattr = new Callback(){

                    public final int callback(String path, StructStat.PowerPC.ByReference stat) {
                        return filesystem._getattr(path, stat);
                    }
                };
                this.fgetattr = new Callback(){

                    public final int callback(String path, StructStat.PowerPC.ByReference stat, StructFuseFileInfo.ByReference info) {
                        return filesystem._fgetattr(path, stat, info);
                    }
                };
                break;
            }
            case MAC: {
                this.getattr = new Callback(){

                    public final int callback(String path, StructStat.Mac.ByReference stat) {
                        return filesystem._getattr(path, stat);
                    }
                };
                this.fgetattr = new Callback(){

                    public final int callback(String path, StructStat.Mac.ByReference stat, StructFuseFileInfo.ByReference info) {
                        return filesystem._fgetattr(path, stat, info);
                    }
                };
                break;
            }
            case FREEBSD: 
            case MAC_MACFUSE: {
                this.getattr = new Callback(){

                    public final int callback(String path, StructStat.BSD.ByReference stat) {
                        return filesystem._getattr(path, stat);
                    }
                };
                this.fgetattr = new Callback(){

                    public final int callback(String path, StructStat.BSD.ByReference stat, StructFuseFileInfo.ByReference info) {
                        return filesystem._fgetattr(path, stat, info);
                    }
                };
            }
        }
        this.readlink = new Callback(){

            public final int callback(String path, Pointer buffer, TypeSize size) {
                return filesystem._readlink(path, buffer, size);
            }
        };
        this.mknod = new Callback(){

            public final int callback(String path, TypeMode mode, TypeDev dev) {
                return filesystem._mknod(path, mode, dev);
            }
        };
        this.mkdir = new Callback(){

            public final int callback(String path, TypeMode mode) {
                return filesystem._mkdir(path, mode);
            }
        };
        this.unlink = new Callback(){

            public final int callback(String path) {
                return filesystem._unlink(path);
            }
        };
        this.rmdir = new Callback(){

            public final int callback(String path) {
                return filesystem._rmdir(path);
            }
        };
        this.symlink = new Callback(){

            public final int callback(String path, String target) {
                return filesystem._symlink(path, target);
            }
        };
        this.rename = new Callback(){

            public final int callback(String path, String newName) {
                return filesystem._rename(path, newName);
            }
        };
        this.link = new Callback(){

            public final int callback(String path, String target) {
                return filesystem._link(path, target);
            }
        };
        this.chmod = new Callback(){

            public final int callback(String path, TypeMode mode) {
                return filesystem._chmod(path, mode);
            }
        };
        this.chown = new Callback(){

            public final int callback(String path, TypeUid uid, TypeGid gid) {
                return filesystem._chown(path, uid, gid);
            }
        };
        this.truncate = new Callback(){

            public final int callback(String path, TypeOff offset) {
                return filesystem._truncate(path, offset);
            }
        };
        this.open = new Callback(){

            public final int callback(String path, StructFuseFileInfo.ByReference info) {
                return filesystem._open(path, info);
            }
        };
        this.read = new Callback(){

            public final int callback(String path, Pointer buffer, TypeSize size, TypeOff offset, StructFuseFileInfo.ByReference info) {
                return filesystem._read(path, buffer, size, offset, info);
            }
        };
        this.write = new Callback(){

            public final int callback(String path, Pointer buffer, TypeSize size, TypeOff offset, StructFuseFileInfo.ByReference info) {
                return filesystem._write(path, buffer, size, offset, info);
            }
        };
        switch (Platform.platform()) {
            case FREEBSD: {
                this.statfs = new Callback(){

                    public final int callback(String path, StructStatvfs.FreeBSD.ByReference statsvfs) {
                        return filesystem._statfs(path, statsvfs);
                    }
                };
                break;
            }
            default: {
                this.statfs = new Callback(){

                    public final int callback(String path, StructStatvfs.NotFreeBSD.ByReference statsvfs) {
                        return filesystem._statfs(path, statsvfs);
                    }
                };
            }
        }
        this.flush = new Callback(){

            public final int callback(String path, StructFuseFileInfo.ByReference info) {
                return filesystem._flush(path, info);
            }
        };
        this.release = new Callback(){

            public final int callback(String path, StructFuseFileInfo.ByReference info) {
                return filesystem._release(path, info);
            }
        };
        this.fsync = new Callback(){

            public final int callback(String path, int datasync, StructFuseFileInfo.ByReference info) {
                return filesystem._fsync(path, datasync, info);
            }
        };
        switch (Platform.platform()) {
            case MAC: 
            case MAC_MACFUSE: {
                this.setxattr = new Callback(){

                    public final int callback(String path, String xattr, Pointer value, TypeSize size, int flags, int position) {
                        return filesystem._setxattr(path, xattr, value, size, flags, position);
                    }
                };
                this.getxattr = new Callback(){

                    public final int callback(String path, String xattr, Pointer buffer, TypeSize size, TypeUInt32 position) {
                        return filesystem._getxattr(path, xattr, buffer, size, position);
                    }
                };
                break;
            }
            default: {
                this.setxattr = new Callback(){

                    public final int callback(String path, String xattr, Pointer value, TypeSize size, int flags) {
                        return filesystem._setxattr(path, xattr, value, size, flags, 0);
                    }
                };
                this.getxattr = new Callback(){

                    public final int callback(String path, String xattr, Pointer buffer, TypeSize size) {
                        return filesystem._getxattr(path, xattr, buffer, size, null);
                    }
                };
            }
        }
        this.listxattr = new Callback(){

            public final int callback(String path, Pointer buffer, TypeSize size) {
                return filesystem._listxattr(path, buffer, size);
            }
        };
        this.removexattr = new Callback(){

            public final int callback(String path, String xattr) {
                return filesystem._removexattr(path, xattr);
            }
        };
        this.opendir = new Callback(){

            public final int callback(String path, StructFuseFileInfo.ByReference info) {
                return filesystem._opendir(path, info);
            }
        };
        this.readdir = new Callback(){

            public final int callback(String path, Pointer buf, Pointer fillFunction, TypeOff offset, StructFuseFileInfo.ByReference info) {
                return filesystem._readdir(path, buf, fillFunction, offset, info);
            }
        };
        this.releasedir = new Callback(){

            public final int callback(String path, StructFuseFileInfo.ByReference info) {
                return filesystem._releasedir(path, info);
            }
        };
        this.fsyncdir = new Callback(){

            public final int callback(String path, int datasync, StructFuseFileInfo.ByReference info) {
                return filesystem._fsyncdir(path, datasync, info);
            }
        };
        this.init = new Callback(){

            public final Pointer callback(StructFuseConnInfo.ByReference conn) {
                filesystem._init(conn);
                return null;
            }
        };
        this.destroy = new Callback(){

            public final void callback(Pointer user_data) {
                filesystem._destroy();
            }
        };
        this.access = new Callback(){

            public final int callback(String path, int access) {
                return filesystem._access(path, access);
            }
        };
        this.create = new Callback(){

            public final int callback(String path, TypeMode mode, StructFuseFileInfo.ByReference info) {
                return filesystem._create(path, mode, info);
            }
        };
        this.ftruncate = new Callback(){

            public final int callback(String path, TypeOff offset, StructFuseFileInfo.ByReference info) {
                return filesystem._ftruncate(path, offset, info);
            }
        };
        switch (Platform.platform()) {
            case MAC: 
            case FREEBSD: 
            case MAC_MACFUSE: {
                this.lock = new Callback(){

                    public final int callback(String path, StructFuseFileInfo.ByReference info, int cmd, StructFlock.FreeBSD.ByReference flock) {
                        return filesystem._lock(path, info, cmd, flock);
                    }
                };
                break;
            }
            default: {
                this.lock = new Callback(){

                    public final int callback(String path, StructFuseFileInfo.ByReference info, int cmd, StructFlock.NotFreeBSD.ByReference flock) {
                        return filesystem._lock(path, info, cmd, flock);
                    }
                };
            }
        }
        this.utimens = new Callback(){

            public final int callback(String path, StructTimeBuffer.ByReference timebuffer) {
                return filesystem._utimens(path, timebuffer);
            }
        };
        this.bmap = new Callback(){

            public final int callback(String path, StructFuseFileInfo.ByReference info) {
                return filesystem._bmap(path, info);
            }
        };
    }

    @Override
    protected List<String> getFieldOrder() {
        return FIELD_ORDER;
    }

    public static final class ByValue
    extends StructFuseOperations
    implements Structure.ByValue {
        public ByValue(FuseFilesystem filesystem) {
            super(filesystem);
        }
    }

    public static final class ByReference
    extends StructFuseOperations
    implements Structure.ByReference {
        public ByReference(FuseFilesystem filesystem) {
            super(filesystem);
        }
    }
}

