/*
 * Decompiled with CFR 0.152.
 */
package net.fusejna;

import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
import net.fusejna.types.TypeUInt64;

public class StructFuseFileInfo
extends Structure {
    public static final List<String> FIELD_ORDER = Arrays.asList("flags", "fh_old", "writepage", "flags_bitfield", "fh", "lock_owner");
    public static final int openMask = 3;
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_CREAT = 64;
    public static final int O_EXCL = 128;
    public static final int O_NOCTTY = 256;
    public static final int O_TRUNC = 512;
    public static final int O_APPEND = 1024;
    public static final int O_NONBLOCK = 2048;
    public static final int O_NDELAY = 2048;
    public static final int O_SYNC = 4096;
    public static final int O_ASYNC = 8192;
    public static final int O_DIRECT = 16384;
    public static final int O_DIRECTORY = 65536;
    public static final int O_NOFOLLOW = 131072;
    public static final int O_NOATIME = 262144;
    public static final int O_CLOEXEC = 524288;
    public int flags;
    public NativeLong fh_old;
    public int writepage;
    private static final int BIT_DIRECT_IO = 1;
    private static final int BIT_KEEP_CACHE = 2;
    private static final int BIT_FLUSH = 4;
    private static final int BIT_NONSEEKABLE = 8;
    private static final int BIT_FLOCKRELEASE = 16;
    public int flags_bitfield;
    public TypeUInt64 fh;
    public TypeUInt64 lock_owner;

    @Override
    protected List<String> getFieldOrder() {
        return FIELD_ORDER;
    }

    public static final class FileInfoWrapper {
        private int flags;
        private boolean modified = false;
        private final StructFuseFileInfo fileinfo;
        private final String path;

        FileInfoWrapper(String path, StructFuseFileInfo fileinfo) {
            this.path = path;
            this.fileinfo = fileinfo;
            this.flags = fileinfo.flags;
        }

        FileInfoWrapper(StructFuseFileInfo fileinfo) {
            this(null, fileinfo);
        }

        public final boolean append() {
            return (this.flags & 0x400) != 0;
        }

        public final FileInfoWrapper append(boolean append) {
            this.modified = true;
            this.flags = this.flags & 0xFFFFFBFF | (append ? 1024 : 0);
            return this;
        }

        public final boolean create() {
            return (this.flags & 0x40) != 0;
        }

        public final FileInfoWrapper create(boolean create) {
            this.modified = true;
            this.flags = this.flags & 0xFFFFFFBF | (create ? 64 : 0);
            return this;
        }

        public final boolean direct_io() {
            return (this.fileinfo.flags_bitfield & 1) != 0;
        }

        public final FileInfoWrapper direct_io(boolean direct_io) {
            this.modified = true;
            this.fileinfo.flags_bitfield = direct_io ? (this.fileinfo.flags_bitfield |= 1) : (this.fileinfo.flags_bitfield &= 0xFFFFFFFE);
            return this;
        }

        public final long fh() {
            return this.fileinfo.fh.longValue();
        }

        public final FileInfoWrapper fh(long fh) {
            this.modified = true;
            this.fileinfo.fh.setValue(fh);
            return this;
        }

        public final long fh_old() {
            return this.fileinfo.fh_old.longValue();
        }

        public final FileInfoWrapper fh_old(long fh_old) {
            this.modified = true;
            this.fileinfo.fh_old.setValue(fh_old);
            return this;
        }

        public final int flags() {
            return this.flags;
        }

        public final FileInfoWrapper flags(int flags) {
            this.modified = true;
            this.flags = flags;
            return this;
        }

        public final boolean flockrelease() {
            return (this.fileinfo.flags_bitfield & 0x10) != 0;
        }

        public final FileInfoWrapper flockrelease(boolean flockrelease) {
            this.modified = true;
            this.fileinfo.flags_bitfield = flockrelease ? (this.fileinfo.flags_bitfield |= 0x10) : (this.fileinfo.flags_bitfield &= 0xFFFFFFEF);
            return this;
        }

        public final boolean flush() {
            return (this.fileinfo.flags_bitfield & 4) != 0;
        }

        public final FileInfoWrapper flush(boolean flush) {
            this.modified = true;
            this.fileinfo.flags_bitfield = flush ? (this.fileinfo.flags_bitfield |= 4) : (this.fileinfo.flags_bitfield &= 0xFFFFFFFB);
            return this;
        }

        public final boolean keep_cache() {
            return (this.fileinfo.flags_bitfield & 2) != 0;
        }

        public final FileInfoWrapper keep_cache(boolean keep_cache) {
            this.modified = true;
            this.fileinfo.flags_bitfield = keep_cache ? (this.fileinfo.flags_bitfield |= 2) : (this.fileinfo.flags_bitfield &= 0xFFFFFFFD);
            return this;
        }

        public final long lock_owner() {
            return this.fileinfo.lock_owner.longValue();
        }

        public final FileInfoWrapper lock_owner(long lock_owner) {
            this.modified = true;
            this.fileinfo.lock_owner.setValue(lock_owner);
            return this;
        }

        public final boolean nonseekable() {
            return (this.fileinfo.flags_bitfield & 8) != 0;
        }

        public final FileInfoWrapper nonseekable(boolean nonseekable) {
            this.modified = true;
            this.fileinfo.flags_bitfield = nonseekable ? (this.fileinfo.flags_bitfield |= 8) : (this.fileinfo.flags_bitfield &= 0xFFFFFFF7);
            return this;
        }

        public final OpenMode openMode() {
            return OpenMode.fromBits(this.flags);
        }

        public final FileInfoWrapper openMode(OpenMode openMode) {
            this.modified = true;
            this.flags = this.flags & 0xFFFFFFFC | openMode.getBits();
            return this;
        }

        public final String toString() {
            if (this.path != null) {
                return this.path + "\n" + this.fileinfo;
            }
            return this.fileinfo.toString();
        }

        public final boolean truncate() {
            return (this.flags & 0x200) != 0;
        }

        public final FileInfoWrapper truncate(boolean truncate) {
            this.modified = true;
            this.flags = this.flags & 0xFFFFFDFF | (truncate ? 512 : 0);
            return this;
        }

        final void write() {
            if (this.modified) {
                this.fileinfo.flags = this.flags;
                this.fileinfo.write();
            }
            this.modified = false;
        }

        public final boolean writepage() {
            return this.fileinfo.writepage != 0;
        }

        public final FileInfoWrapper writepage(boolean writepage) {
            this.modified = true;
            this.fileinfo.writepage = writepage ? 1 : 0;
            return this;
        }

        public static enum OpenMode {
            READONLY,
            WRITEONLY,
            READWRITE;


            public static final OpenMode fromBits(int bits) {
                switch (bits &= 3) {
                    case 0: {
                        return READONLY;
                    }
                    case 1: {
                        return WRITEONLY;
                    }
                    case 2: {
                        return READWRITE;
                    }
                }
                return null;
            }

            public final int getBits() {
                switch (this) {
                    case READONLY: {
                        return 0;
                    }
                    case WRITEONLY: {
                        return 1;
                    }
                    case READWRITE: {
                        return 2;
                    }
                }
                return 0;
            }
        }
    }

    public static final class ByValue
    extends StructFuseFileInfo
    implements Structure.ByValue {
    }

    public static final class ByReference
    extends StructFuseFileInfo
    implements Structure.ByReference {
    }
}

