/*
 * Decompiled with CFR 0.152.
 */
package net.fusejna;

import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
import net.fusejna.types.TypeOff;
import net.fusejna.types.TypePid;

public abstract class StructFlock
extends Structure {
    public static final int F_RDLCK = 0;
    public static final int F_WRLCK = 1;
    public static final int F_UNLCK = 2;

    abstract long l_len();

    abstract void l_len(long var1);

    abstract long l_pid();

    abstract void l_pid(long var1);

    abstract long l_start();

    abstract void l_start(long var1);

    abstract long l_sysid();

    abstract void l_sysid(long var1);

    abstract long l_type();

    abstract void l_type(long var1);

    abstract long l_whence();

    abstract void l_whence(long var1);

    public static class NotFreeBSD
    extends StructFlock {
        public static final List<String> FIELD_ORDER = Arrays.asList("l_type", "l_whence", "l_start", "l_len", "l_pid");
        public short l_type;
        public short l_whence;
        public TypeOff l_start;
        public TypeOff l_len;
        public TypePid l_pid;

        @Override
        protected List<String> getFieldOrder() {
            return FIELD_ORDER;
        }

        @Override
        final long l_len() {
            return this.l_len.longValue();
        }

        @Override
        final void l_len(long l_len) {
            this.l_len.setValue(l_len);
        }

        @Override
        final long l_pid() {
            return this.l_pid.longValue();
        }

        @Override
        final void l_pid(long l_pid) {
            this.l_pid.setValue(l_pid);
        }

        @Override
        final long l_start() {
            return this.l_start.longValue();
        }

        @Override
        final void l_start(long l_start) {
            this.l_start.setValue(l_start);
        }

        @Override
        final long l_sysid() {
            return -1L;
        }

        @Override
        final void l_sysid(long l_sysid) {
        }

        @Override
        final long l_type() {
            return this.l_type;
        }

        @Override
        final void l_type(long l_type) {
            this.l_type = (short)l_type;
        }

        @Override
        final long l_whence() {
            return this.l_whence;
        }

        @Override
        final void l_whence(long l_whence) {
            this.l_whence = (short)l_whence;
        }

        public static final class ByValue
        extends FreeBSD
        implements Structure.ByValue {
        }

        public static final class ByReference
        extends FreeBSD
        implements Structure.ByReference {
        }
    }

    public static class FreeBSD
    extends StructFlock {
        public static final List<String> FIELD_ORDER = Arrays.asList("l_start", "l_len", "l_pid", "l_type", "l_whence", "l_sysid");
        public TypeOff l_start;
        public TypeOff l_len;
        public TypePid l_pid;
        public short l_type;
        public short l_whence;
        public int l_sysid;

        @Override
        protected List<String> getFieldOrder() {
            return FIELD_ORDER;
        }

        @Override
        final long l_len() {
            return this.l_len.longValue();
        }

        @Override
        final void l_len(long l_len) {
            this.l_len.setValue(l_len);
        }

        @Override
        final long l_pid() {
            return this.l_pid.longValue();
        }

        @Override
        final void l_pid(long l_pid) {
            this.l_pid.setValue(l_pid);
        }

        @Override
        final long l_start() {
            return this.l_start.longValue();
        }

        @Override
        final void l_start(long l_start) {
            this.l_start.setValue(l_start);
        }

        @Override
        final long l_sysid() {
            return this.l_sysid;
        }

        @Override
        final void l_sysid(long l_sysid) {
            this.l_sysid = (int)l_sysid;
        }

        @Override
        final long l_type() {
            return this.l_type;
        }

        @Override
        final void l_type(long l_type) {
            this.l_type = (short)l_type;
        }

        @Override
        final long l_whence() {
            return this.l_whence;
        }

        @Override
        final void l_whence(long l_whence) {
            this.l_whence = (short)l_whence;
        }

        public static final class ByValue
        extends FreeBSD
        implements Structure.ByValue {
        }

        public static final class ByReference
        extends FreeBSD
        implements Structure.ByReference {
        }
    }

    public static final class FlockWrapper {
        private final StructFlock structFlock;
        private final String path;

        FlockWrapper(String path, StructFlock structFlock) {
            this.path = path;
            this.structFlock = structFlock;
        }

        FlockWrapper(StructFlock structFlock) {
            this(null, structFlock);
        }

        public final FlockType flockType() {
            return FlockType.fromBits(this.type());
        }

        public final FlockWrapper flockType(FlockType type) {
            return this.type(type.getBits());
        }

        public final long len() {
            return this.structFlock.l_len();
        }

        public final FlockWrapper len(long l_len) {
            this.structFlock.l_len(l_len);
            return this;
        }

        public final long pid() {
            return this.structFlock.l_pid();
        }

        public final FlockWrapper pid(long l_pid) {
            this.structFlock.l_pid(l_pid);
            return this;
        }

        public final long start() {
            return this.structFlock.l_start();
        }

        public final FlockWrapper start(long l_start) {
            this.structFlock.l_start(l_start);
            return this;
        }

        public final long sysid() {
            return this.structFlock.l_sysid();
        }

        public final FlockWrapper sysid(long l_sysid) {
            this.structFlock.l_sysid(l_sysid);
            return this;
        }

        public final String toString() {
            if (this.path != null) {
                return this.path + "\n" + this.structFlock;
            }
            return this.structFlock.toString();
        }

        public final long type() {
            return this.structFlock.l_type();
        }

        public final FlockWrapper type(long l_type) {
            this.structFlock.l_type(l_type);
            return this;
        }

        public final long whence() {
            return this.structFlock.l_whence();
        }

        public final FlockWrapper whence(long l_whence) {
            this.structFlock.l_whence(l_whence);
            return this;
        }

        final void write() {
            this.structFlock.write();
        }
    }

    public static enum FlockType {
        READ_LOCK,
        WRITE_LOCK,
        NO_LOCK;


        public static FlockType fromBits(long bits) {
            switch ((int)bits) {
                case 0: {
                    return READ_LOCK;
                }
                case 1: {
                    return WRITE_LOCK;
                }
                case 2: {
                    return NO_LOCK;
                }
            }
            return null;
        }

        public long getBits() {
            switch (this) {
                case READ_LOCK: {
                    return 0L;
                }
                case WRITE_LOCK: {
                    return 1L;
                }
                case NO_LOCK: {
                    return 2L;
                }
            }
            return -1L;
        }
    }
}

