/*
 * Decompiled with CFR 0.152.
 */
package net.fusejna;

import com.sun.jna.Native;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.fusejna.LibDl;
import net.fusejna.LibFuse;

public final class Platform {
    private static final String[] osxFuseLibraries = new String[]{"fuse4x", "osxfuse", "macfuse", "fuse"};
    private static PlatformEnum platform = null;
    private static LibFuse libFuse = null;
    private static Lock initLock = new ReentrantLock();

    static final LibFuse fuse() {
        if (libFuse == null) {
            Platform.init();
        }
        return libFuse;
    }

    private static final void init() {
        if (libFuse != null) {
            return;
        }
        initLock.lock();
        if (libFuse == null) {
            switch (com.sun.jna.Platform.getOSType()) {
                case 4: {
                    platform = PlatformEnum.FREEBSD;
                    libFuse = (LibFuse)Native.loadLibrary("fuse", LibFuse.class);
                    break;
                }
                case 0: {
                    LibDl dl = (LibDl)Native.loadLibrary("iconv", LibDl.class);
                    dl.dlopen("iconv", 257);
                    libFuse = null;
                    for (String library : osxFuseLibraries) {
                        try {
                            LibFuse.LibMacFuseProbe probe = (LibFuse.LibMacFuseProbe)Native.loadLibrary(library, LibFuse.LibMacFuseProbe.class);
                            probe.macfuse_version();
                            platform = PlatformEnum.MAC_MACFUSE;
                            libFuse = (LibFuse)Native.loadLibrary(library, LibFuse.class);
                            break;
                        }
                        catch (Throwable e) {
                            try {
                                LibFuse.LibFuseProbe probe = (LibFuse.LibFuseProbe)Native.loadLibrary(library, LibFuse.LibFuseProbe.class);
                                platform = PlatformEnum.MAC;
                                libFuse = (LibFuse)Native.loadLibrary(library, LibFuse.class);
                                break;
                            }
                            catch (Throwable e2) {
                            }
                        }
                    }
                    if (libFuse != null) break;
                    libFuse = (LibFuse)Native.loadLibrary("fuse", LibFuse.class);
                    break;
                }
                default: {
                    platform = com.sun.jna.Platform.isIntel() ? (com.sun.jna.Platform.is64Bit() ? PlatformEnum.LINUX_X86_64 : PlatformEnum.LINUX_I686) : PlatformEnum.LINUX_PPC;
                    libFuse = (LibFuse)Native.loadLibrary("fuse", LibFuse.class);
                }
            }
        }
        initLock.unlock();
    }

    public static final PlatformEnum platform() {
        if (platform == null) {
            Platform.init();
        }
        return platform;
    }

    public static final int size(Class cls) {
        return Native.getNativeSize(cls);
    }

    public static enum PlatformEnum {
        LINUX_X86_64,
        LINUX_I686,
        LINUX_PPC,
        MAC,
        MAC_MACFUSE,
        FREEBSD;

    }
}

