/*
 * Decompiled with CFR 0.152.
 */
package net.fusejna;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fusejna.DirectoryFiller;
import net.fusejna.FlockCommand;
import net.fusejna.FuseFilesystem;
import net.fusejna.StructFlock;
import net.fusejna.StructFuseFileInfo;
import net.fusejna.StructStat;
import net.fusejna.StructStatvfs;
import net.fusejna.StructTimeBuffer;
import net.fusejna.XattrFiller;
import net.fusejna.XattrListFiller;
import net.fusejna.types.TypeMode;

final class LoggedFuseFilesystem
extends FuseFilesystem {
    private static final String methodSuccess = "Method succeeded.";
    private static final String methodFailure = "Exception thrown: ";
    private static final String methodResult = " Result: ";
    private final String className;
    private final Logger actualLogger;
    private final FuseFilesystem filesystem;

    LoggedFuseFilesystem(FuseFilesystem filesystem, Logger logger) {
        this.filesystem = filesystem;
        this.actualLogger = logger;
        this.className = filesystem.getClass().getName();
    }

    @Override
    public int access(final String path, final int access) {
        return this.log("access", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.access(path, access);
            }
        }, path, access);
    }

    @Override
    public void afterUnmount(final File mountPoint) {
        this.log("afterUnmount", new LoggedVoidMethod(){

            @Override
            public void invoke() {
                LoggedFuseFilesystem.this.filesystem.afterUnmount(mountPoint);
            }
        }, mountPoint.toString(), new Object[0]);
    }

    @Override
    public void beforeMount(final File mountPoint) {
        this.log("beforeMount", new LoggedVoidMethod(){

            @Override
            public void invoke() {
                LoggedFuseFilesystem.this.filesystem.beforeMount(mountPoint);
            }
        }, mountPoint.toString(), new Object[0]);
    }

    @Override
    public void beforeUnmount(final File mountPoint) {
        this.log("beforeUnmount", new LoggedVoidMethod(){

            @Override
            public void invoke() {
                LoggedFuseFilesystem.this.filesystem.beforeUnmount(mountPoint);
            }
        }, mountPoint.toString(), new Object[0]);
    }

    @Override
    public int bmap(final String path, final StructFuseFileInfo.FileInfoWrapper info) {
        return this.log("bmap", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.bmap(path, info);
            }
        }, path, info);
    }

    @Override
    public int chmod(final String path, final TypeMode.ModeWrapper mode) {
        return this.log("chmod", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.chmod(path, mode);
            }
        }, path, mode);
    }

    @Override
    public int chown(final String path, final long uid, final long gid) {
        return this.log("chown", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.chown(path, uid, gid);
            }
        }, path, uid, gid);
    }

    @Override
    public int create(final String path, final TypeMode.ModeWrapper mode, final StructFuseFileInfo.FileInfoWrapper info) {
        return this.log("create", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.create(path, mode, info);
            }
        }, path, mode, info);
    }

    @Override
    public void destroy() {
        this.log("destroy", new LoggedVoidMethod(){

            @Override
            public void invoke() {
                LoggedFuseFilesystem.this.filesystem.destroy();
            }
        });
    }

    @Override
    public int fgetattr(final String path, final StructStat.StatWrapper stat, final StructFuseFileInfo.FileInfoWrapper info) {
        return this.log("fgetattr", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.fgetattr(path, stat, info);
            }
        }, path, stat);
    }

    @Override
    public int flush(final String path, final StructFuseFileInfo.FileInfoWrapper info) {
        return this.log("flush", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.flush(path, info);
            }
        }, path, info);
    }

    @Override
    public int fsync(final String path, final int datasync, final StructFuseFileInfo.FileInfoWrapper info) {
        return this.log("flush", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.fsync(path, datasync, info);
            }
        }, path, info);
    }

    @Override
    public int fsyncdir(final String path, final int datasync, final StructFuseFileInfo.FileInfoWrapper info) {
        return this.log("fsyncdir", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.fsyncdir(path, datasync, info);
            }
        }, path, info);
    }

    @Override
    public int ftruncate(final String path, final long offset, final StructFuseFileInfo.FileInfoWrapper info) {
        return this.log("getattr", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.ftruncate(path, offset, info);
            }
        }, path, offset, info);
    }

    @Override
    public int getattr(final String path, final StructStat.StatWrapper stat) {
        return this.log("getattr", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.getattr(path, stat);
            }
        }, path, stat);
    }

    @Override
    protected String getName() {
        return this.log("getName", null, new LoggedMethod<String>(){

            @Override
            public String invoke() {
                return LoggedFuseFilesystem.this.filesystem.getName();
            }
        });
    }

    @Override
    protected String[] getOptions() {
        return this.log("getOptions", null, new LoggedMethod<String[]>(){

            @Override
            public String[] invoke() {
                return LoggedFuseFilesystem.this.filesystem.getOptions();
            }
        });
    }

    @Override
    public int getxattr(final String path, final String xattr, final XattrFiller filler, final long size, final long position) {
        return this.log("getxattr", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.getxattr(path, xattr, filler, size, position);
            }
        }, path, xattr, filler, size, position);
    }

    @Override
    public void init() {
        this.log("init", new LoggedVoidMethod(){

            @Override
            public void invoke() {
                LoggedFuseFilesystem.this.filesystem.init();
            }
        });
    }

    @Override
    public int link(final String path, final String target) {
        return this.log("link", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.link(path, target);
            }
        }, path, target);
    }

    @Override
    public int listxattr(final String path, final XattrListFiller filler) {
        return this.log("listxattr", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.listxattr(path, filler);
            }
        }, path, filler);
    }

    @Override
    public int lock(final String path, final StructFuseFileInfo.FileInfoWrapper info, final FlockCommand command, final StructFlock.FlockWrapper flock) {
        return this.log("lock", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.lock(path, info, command, flock);
            }
        }, path, new Object[]{info, command, flock});
    }

    private void log(String methodName, LoggedVoidMethod method) {
        this.log(methodName, method, null, (Object[])null);
    }

    private void log(String methodName, LoggedVoidMethod method, String path, Object ... args) {
        try {
            this.actualLogger.entering(this.className, methodName, args);
            method.invoke();
            this.actualLogger.logp(Level.INFO, this.className, methodName, (path == null ? "" : "[" + path + "] ") + methodSuccess, args);
            this.actualLogger.exiting(this.className, methodName, args);
        }
        catch (Throwable e) {
            this.logException(e, methodName, null, args);
        }
    }

    private <T> T log(String methodName, T defaultValue, LoggedMethod<T> method) {
        return this.log(methodName, defaultValue, method, null, (Object[])null);
    }

    private <T> T log(String methodName, T defaultValue, LoggedMethod<T> method, String path, Object ... args) {
        try {
            this.actualLogger.entering(this.className, methodName, args);
            T result = method.invoke();
            this.actualLogger.logp(Level.INFO, this.className, methodName, (path == null ? "" : "[" + path + "] ") + methodSuccess + methodResult + result, args);
            this.actualLogger.exiting(this.className, methodName, args);
            return result;
        }
        catch (Throwable e) {
            return this.logException(e, methodName, defaultValue, args);
        }
    }

    private <T> T logException(Throwable e, String methodName, T defaultValue, Object ... args) {
        StackTraceElement[] stack = e.getStackTrace();
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement element : stack) {
            builder.append("\n" + element);
        }
        this.actualLogger.logp(Level.SEVERE, this.className, methodName, methodFailure + e + builder.toString(), args);
        return defaultValue;
    }

    @Override
    public int mkdir(final String path, final TypeMode.ModeWrapper mode) {
        return this.log("mkdir", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.mkdir(path, mode);
            }
        }, path, mode);
    }

    @Override
    public int mknod(final String path, final TypeMode.ModeWrapper mode, final long dev) {
        return this.log("mknod", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.mknod(path, mode, dev);
            }
        }, path, mode, dev);
    }

    @Override
    public int open(final String path, final StructFuseFileInfo.FileInfoWrapper info) {
        return this.log("open", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.open(path, info);
            }
        }, path, info);
    }

    @Override
    public int opendir(final String path, final StructFuseFileInfo.FileInfoWrapper info) {
        return this.log("opendir", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.opendir(path, info);
            }
        }, path, info);
    }

    @Override
    public int read(final String path, final ByteBuffer buffer, final long size, final long offset, final StructFuseFileInfo.FileInfoWrapper info) {
        return this.log("read", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.read(path, buffer, size, offset, info);
            }
        }, path, buffer, size, offset, info);
    }

    @Override
    public int readdir(final String path, final DirectoryFiller filler) {
        return this.log("readdir", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.readdir(path, filler);
            }
        }, path, filler);
    }

    @Override
    public int readlink(final String path, final ByteBuffer buffer, final long size) {
        return this.log("readlink", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.readlink(path, buffer, size);
            }
        }, path, buffer, size);
    }

    @Override
    public int release(final String path, final StructFuseFileInfo.FileInfoWrapper info) {
        return this.log("release", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.release(path, info);
            }
        }, path, info);
    }

    @Override
    public int releasedir(final String path, final StructFuseFileInfo.FileInfoWrapper info) {
        return this.log("releasedir", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.releasedir(path, info);
            }
        }, path, info);
    }

    @Override
    public int removexattr(final String path, final String xattr) {
        return this.log("remtoexattr", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.removexattr(path, xattr);
            }
        }, path, xattr);
    }

    @Override
    public int rename(final String path, final String newName) {
        return this.log("rename", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.rename(path, newName);
            }
        });
    }

    @Override
    public int rmdir(final String path) {
        return this.log("rmdir", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.rmdir(path);
            }
        }, path, new Object[0]);
    }

    @Override
    void setFinalMountPoint(File mountPoint) {
        super.setFinalMountPoint(mountPoint);
        this.filesystem.setFinalMountPoint(mountPoint);
    }

    @Override
    public int setxattr(final String path, final String name, final ByteBuffer buf, final long size, final int flags, final int position) {
        return this.log("setxattr", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.setxattr(path, name, buf, size, flags, position);
            }
        }, path, name, buf, size, flags, position);
    }

    @Override
    public int statfs(final String path, final StructStatvfs.StatvfsWrapper wrapper) {
        return this.log("statfs", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.statfs(path, wrapper);
            }
        }, path, wrapper);
    }

    @Override
    public int symlink(final String path, final String target) {
        return this.log("symlink", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.symlink(path, target);
            }
        }, path, target);
    }

    @Override
    public int truncate(final String path, final long offset) {
        return this.log("truncate", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.truncate(path, offset);
            }
        }, path, offset);
    }

    @Override
    public int unlink(final String path) {
        return this.log("unlink", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.unlink(path);
            }
        }, path, new Object[0]);
    }

    @Override
    public int utimens(final String path, final StructTimeBuffer.TimeBufferWrapper wrapper) {
        return this.log("utimens", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.utimens(path, wrapper);
            }
        }, path, wrapper);
    }

    @Override
    public int write(final String path, final ByteBuffer buf, final long bufSize, final long writeOffset, final StructFuseFileInfo.FileInfoWrapper wrapper) {
        return this.log("write", 0, new LoggedMethod<Integer>(){

            @Override
            public Integer invoke() {
                return LoggedFuseFilesystem.this.filesystem.write(path, buf, bufSize, writeOffset, wrapper);
            }
        }, path, buf, bufSize, writeOffset, wrapper);
    }

    private static interface LoggedVoidMethod {
        public void invoke();
    }

    private static interface LoggedMethod<T> {
        public T invoke();
    }
}

