/*
 * Decompiled with CFR 0.152.
 */
package net.fusejna;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import net.fusejna.FuseException;
import net.fusejna.FuseFilesystem;
import net.fusejna.InvalidPermissionsMountpointException;
import net.fusejna.LibFuse;
import net.fusejna.LoggedFuseFilesystem;
import net.fusejna.NotADirectoryMountpointException;
import net.fusejna.Platform;
import net.fusejna.ProcessGobbler;
import net.fusejna.StructFuseContext;
import net.fusejna.StructFuseOperations;
import net.fusejna.types.TypeSize;

public final class FuseJna {
    private static LibFuse libFuse = null;
    private static Lock initLock = new ReentrantLock();
    private static Lock filesystemNameLock = new ReentrantLock();
    private static final Random defaultFilesystemRandom = new Random();
    private static final Map<File, String> filesystemNames = new HashMap<File, String>();
    private static final long errorSleepDuration = 750L;
    private static String fusermount = "fusermount";
    private static String umount = "umount";
    private static int currentUid = 0;
    private static int currentGid = 0;

    private static final String getFilesystemName(File mountPoint, String fuseName) {
        String suffix;
        filesystemNameLock.lock();
        if (filesystemNames.put(mountPoint, fuseName) == null) {
            filesystemNameLock.unlock();
            return fuseName;
        }
        do {
            suffix = Long.toString(defaultFilesystemRandom.nextLong());
        } while (filesystemNames.put(mountPoint, fuseName + suffix) != null);
        filesystemNameLock.unlock();
        return fuseName + suffix;
    }

    static StructFuseContext getFuseContext() {
        return FuseJna.init().fuse_get_context();
    }

    static final int getGid() {
        return currentGid;
    }

    static final int getUid() {
        return currentUid;
    }

    private static final boolean handleShutdownHooks() {
        SecurityManager security = System.getSecurityManager();
        if (security == null) {
            return true;
        }
        try {
            security.checkPermission(new RuntimePermission("shutdownHooks"));
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    static final LibFuse init() throws UnsatisfiedLinkError {
        if (libFuse != null) {
            return libFuse;
        }
        initLock.lock();
        if (libFuse == null) {
            libFuse = Platform.fuse();
        }
        try {
            currentUid = Integer.parseInt(new ProcessGobbler("id", "-u").getStdout());
            currentGid = Integer.parseInt(new ProcessGobbler("id", "-g").getStdout());
        }
        catch (Exception exception) {
            // empty catch block
        }
        initLock.unlock();
        return libFuse;
    }

    static final void mount(FuseFilesystem filesystem, File mountPoint, boolean blocking) throws FuseException {
        Integer result;
        String[] argv;
        Logger logger;
        mountPoint = mountPoint.getAbsoluteFile();
        try {
            mountPoint = mountPoint.getCanonicalFile();
        }
        catch (IOException e) {
            throw new NotADirectoryMountpointException(mountPoint);
        }
        if (!mountPoint.isDirectory()) {
            throw new NotADirectoryMountpointException(mountPoint);
        }
        if (!(mountPoint.canRead() && mountPoint.canWrite() && mountPoint.canExecute())) {
            boolean successful = true;
            try {
                successful = mountPoint.setReadable(true) && successful;
                successful = mountPoint.setWritable(true) && successful;
                successful = mountPoint.setExecutable(true) && successful;
            }
            catch (Exception e) {
                throw new InvalidPermissionsMountpointException(mountPoint);
            }
            if (!successful) {
                throw new InvalidPermissionsMountpointException(mountPoint);
            }
        }
        if ((logger = filesystem.getLogger()) != null) {
            filesystem = new LoggedFuseFilesystem(filesystem, logger);
        }
        filesystem.setFinalMountPoint(mountPoint);
        String filesystemName = FuseJna.getFilesystemName(mountPoint, filesystem.getFuseName());
        String[] options = filesystem.getOptions();
        if (options == null) {
            argv = new String[3];
        } else {
            argv = new String[3 + options.length];
            for (int i = 0; i < options.length; ++i) {
                argv[i + 2] = options[i];
            }
        }
        argv[0] = filesystemName;
        argv[1] = "-f";
        argv[argv.length - 1] = mountPoint.getAbsolutePath();
        LibFuse fuse = FuseJna.init();
        StructFuseOperations operations = new StructFuseOperations(filesystem);
        if (FuseJna.handleShutdownHooks()) {
            Runtime.getRuntime().addShutdownHook(filesystem.getUnmountHook());
        }
        if (blocking) {
            result = fuse.fuse_main_real(argv.length, argv, operations, new TypeSize(operations), null);
            FuseJna.unregisterFilesystemName(mountPoint);
        } else {
            MountThread mountThread = new MountThread(filesystemName, fuse, argv, mountPoint, operations);
            try {
                Thread.sleep(750L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            result = mountThread.getResult();
        }
        if (result != null && result != 0) {
            throw new FuseException(result);
        }
    }

    public static final void setFusermount(String fusermount) {
        FuseJna.fusermount = fusermount;
    }

    public static final void setUmount(String umount) {
        FuseJna.umount = umount;
    }

    public static int unmount(File mountPoint) throws IOException {
        ProcessGobbler process;
        try {
            process = new ProcessGobbler(fusermount, "-z", "-u", mountPoint.toString());
        }
        catch (IOException e) {
            process = new ProcessGobbler(umount, mountPoint.toString());
        }
        return process.getReturnCode();
    }

    static void unmount(FuseFilesystem fuseFilesystem) throws IOException, FuseException {
        File mountPoint;
        int result;
        if (FuseJna.handleShutdownHooks()) {
            try {
                Runtime.getRuntime().removeShutdownHook(fuseFilesystem.getUnmountHook());
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        if ((result = FuseJna.unmount(mountPoint = fuseFilesystem.getMountPoint())) != 0) {
            throw new FuseException(result);
        }
        FuseJna.unregisterFilesystemName(fuseFilesystem.getMountPoint());
    }

    private static final void unregisterFilesystemName(File mountPoint) {
        filesystemNameLock.lock();
        filesystemNames.remove(mountPoint);
        filesystemNameLock.unlock();
    }

    private static final class MountThread
    extends Thread {
        private Integer result = null;
        private final String[] args;
        private final StructFuseOperations operations;
        private final LibFuse fuse;
        private final File mountPoint;

        private MountThread(String filesystemName, LibFuse fuse, String[] args, File mountPoint, StructFuseOperations operations) {
            super(filesystemName + "-fuse");
            this.fuse = fuse;
            this.args = args;
            this.mountPoint = mountPoint;
            this.operations = operations;
            this.start();
        }

        private final Integer getResult() {
            return this.result;
        }

        @Override
        public final void run() {
            this.result = this.fuse.fuse_main_real(this.args.length, this.args, this.operations, new TypeSize(this.operations), null);
            FuseJna.unregisterFilesystemName(this.mountPoint);
        }
    }
}

