/*
 * Decompiled with CFR 0.152.
 */
package net.fusejna;

import com.sun.jna.Function;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.fusejna.AutoUnmountHook;
import net.fusejna.DirectoryFiller;
import net.fusejna.DirectoryFillerImpl;
import net.fusejna.FlockCommand;
import net.fusejna.FuseException;
import net.fusejna.FuseJna;
import net.fusejna.StructFlock;
import net.fusejna.StructFuseConnInfo;
import net.fusejna.StructFuseContext;
import net.fusejna.StructFuseFileInfo;
import net.fusejna.StructStat;
import net.fusejna.StructStatvfs;
import net.fusejna.StructTimeBuffer;
import net.fusejna.XattrFiller;
import net.fusejna.XattrListFiller;
import net.fusejna.types.TypeDev;
import net.fusejna.types.TypeGid;
import net.fusejna.types.TypeMode;
import net.fusejna.types.TypeOff;
import net.fusejna.types.TypePid;
import net.fusejna.types.TypeSize;
import net.fusejna.types.TypeUInt32;
import net.fusejna.types.TypeUid;

public abstract class FuseFilesystem {
    private static final String defaultFilesystemName = "userfs-";
    private static final Pattern regexNormalizeFilesystemName = Pattern.compile("[^a-zA-Z]");
    private final ReentrantLock mountLock = new ReentrantLock();
    private final AutoUnmountHook unmountHook = new AutoUnmountHook(this);
    private File mountPoint = null;
    private Logger logger = null;

    @FuseMethod
    final int _access(String path, int access) {
        return this.access(path, access);
    }

    @FuseMethod
    final int _bmap(String path, StructFuseFileInfo info) {
        StructFuseFileInfo.FileInfoWrapper wrapper = new StructFuseFileInfo.FileInfoWrapper(path, info);
        int result = this.bmap(path, wrapper);
        wrapper.write();
        return result;
    }

    @FuseMethod
    final int _chmod(String path, TypeMode mode) {
        return this.chmod(path, new TypeMode.ModeWrapper(mode));
    }

    @FuseMethod
    final int _chown(String path, TypeUid uid, TypeGid gid) {
        return this.chown(path, uid.longValue(), gid.longValue());
    }

    @FuseMethod
    final int _create(String path, TypeMode mode, StructFuseFileInfo info) {
        StructFuseFileInfo.FileInfoWrapper wrapper = new StructFuseFileInfo.FileInfoWrapper(path, info);
        int result = this.create(path, new TypeMode.ModeWrapper(mode), wrapper);
        wrapper.write();
        return result;
    }

    @FuseMethod
    final void _destroy() {
        this.destroy();
    }

    @FuseMethod
    final int _fgetattr(String path, StructStat stat, StructFuseFileInfo info) {
        StructStat.StatWrapper swrapper = new StructStat.StatWrapper(path, stat);
        this.defaultStat(swrapper, FuseJna.getUid(), FuseJna.getGid());
        StructFuseFileInfo.FileInfoWrapper fwrapper = new StructFuseFileInfo.FileInfoWrapper(path, info);
        int result = this.fgetattr(path, swrapper, fwrapper);
        swrapper.write();
        fwrapper.write();
        return result;
    }

    @FuseMethod
    final int _flush(String path, StructFuseFileInfo info) {
        return this.flush(path, new StructFuseFileInfo.FileInfoWrapper(path, info));
    }

    @FuseMethod
    final int _fsync(String path, int datasync, StructFuseFileInfo info) {
        return this.fsync(path, datasync, new StructFuseFileInfo.FileInfoWrapper(path, info));
    }

    @FuseMethod
    final int _fsyncdir(String path, int datasync, StructFuseFileInfo info) {
        StructFuseFileInfo.FileInfoWrapper wrapper = new StructFuseFileInfo.FileInfoWrapper(path, info);
        int result = this.fsyncdir(path, datasync, wrapper);
        wrapper.write();
        return result;
    }

    @FuseMethod
    final int _ftruncate(String path, TypeOff offset, StructFuseFileInfo info) {
        StructFuseFileInfo.FileInfoWrapper wrapper = new StructFuseFileInfo.FileInfoWrapper(path, info);
        int result = this.ftruncate(path, offset.longValue(), wrapper);
        wrapper.write();
        return result;
    }

    @FuseMethod
    final int _getattr(String path, StructStat stat) {
        StructStat.StatWrapper wrapper = new StructStat.StatWrapper(path, stat);
        this.defaultStat(wrapper, FuseJna.getUid(), FuseJna.getGid());
        int result = this.getattr(path, wrapper);
        wrapper.write();
        return result;
    }

    @FuseMethod
    final int _getxattr(String path, String xattr, Pointer buffer, TypeSize size, TypeUInt32 position) {
        long sizeValue = size.longValue();
        int positionValue = position == null ? 0 : position.intValue();
        XattrFiller filler = new XattrFiller(buffer == null ? null : buffer.getByteBuffer(0L, sizeValue), sizeValue, positionValue);
        int result = this.getxattr(path, xattr, filler, sizeValue, position == null ? 0L : position.longValue());
        return result < 0 ? result : (int)filler.getSize();
    }

    @FuseMethod
    final void _init(StructFuseConnInfo conn) {
        this.init();
    }

    @FuseMethod
    final int _link(String path, String target) {
        return this.link(path, target);
    }

    @FuseMethod
    final int _listxattr(String path, Pointer buffer, TypeSize size) {
        long sizeValue = size.longValue();
        XattrListFiller filler = new XattrListFiller(buffer == null ? null : buffer.getByteBuffer(0L, sizeValue), sizeValue);
        int result = this.listxattr(path, filler);
        return result < 0 ? result : (int)filler.requiredSize();
    }

    @FuseMethod
    final int _lock(String path, StructFuseFileInfo info, int cmd, StructFlock flock) {
        StructFuseFileInfo.FileInfoWrapper fileWrapper = new StructFuseFileInfo.FileInfoWrapper(path, info);
        StructFlock.FlockWrapper flockWrapper = new StructFlock.FlockWrapper(path, flock);
        int result = this.lock(path, fileWrapper, FlockCommand.fromBits(cmd), flockWrapper);
        fileWrapper.write();
        flockWrapper.write();
        return result;
    }

    @FuseMethod
    final int _mkdir(String path, TypeMode mode) {
        return this.mkdir(path, new TypeMode.ModeWrapper(mode));
    }

    @FuseMethod
    final int _mknod(String path, TypeMode mode, TypeDev dev) {
        return this.mknod(path, new TypeMode.ModeWrapper(mode), dev.longValue());
    }

    @FuseMethod
    final int _open(String path, StructFuseFileInfo info) {
        StructFuseFileInfo.FileInfoWrapper wrapper = new StructFuseFileInfo.FileInfoWrapper(path, info);
        int result = this.open(path, wrapper);
        wrapper.write();
        return result;
    }

    @FuseMethod
    final int _opendir(String path, StructFuseFileInfo info) {
        StructFuseFileInfo.FileInfoWrapper wrapper = new StructFuseFileInfo.FileInfoWrapper(path, info);
        int result = this.opendir(path, wrapper);
        wrapper.write();
        return result;
    }

    @FuseMethod
    final int _read(String path, Pointer buffer, TypeSize size, TypeOff offset, StructFuseFileInfo info) {
        long bufSize = size.longValue();
        long readOffset = offset.longValue();
        ByteBuffer buf = buffer.getByteBuffer(0L, bufSize);
        StructFuseFileInfo.FileInfoWrapper wrapper = new StructFuseFileInfo.FileInfoWrapper(path, info);
        int result = this.read(path, buf, bufSize, readOffset, wrapper);
        wrapper.write();
        return result;
    }

    @FuseMethod
    final int _readdir(String path, Pointer buf, Pointer fillFunction, TypeOff offset, StructFuseFileInfo info) {
        return this.readdir(path, new DirectoryFillerImpl(buf, Function.getFunction(fillFunction)));
    }

    @FuseMethod
    final int _readlink(String path, Pointer buffer, TypeSize size) {
        long bufSize = size.longValue();
        ByteBuffer buf = buffer.getByteBuffer(0L, bufSize);
        int result = this.readlink(path, buf, bufSize);
        if (result == 0) {
            try {
                buf.put((byte)0);
            }
            catch (BufferOverflowException e) {
                ((ByteBuffer)buf.position(buf.limit() - 1)).put((byte)0);
            }
        }
        return result;
    }

    @FuseMethod
    final int _release(String path, StructFuseFileInfo info) {
        return this.release(path, new StructFuseFileInfo.FileInfoWrapper(path, info));
    }

    @FuseMethod
    final int _releasedir(String path, StructFuseFileInfo info) {
        StructFuseFileInfo.FileInfoWrapper wrapper = new StructFuseFileInfo.FileInfoWrapper(path, info);
        int result = this.releasedir(path, wrapper);
        wrapper.write();
        return result;
    }

    @FuseMethod
    final int _removexattr(String path, String xattr) {
        return this.removexattr(path, xattr);
    }

    @FuseMethod
    final int _rename(String path, String newName) {
        return this.rename(path, newName);
    }

    @FuseMethod
    final int _rmdir(String path) {
        return this.rmdir(path);
    }

    @FuseMethod
    final int _setxattr(String path, String xattr, Pointer value, TypeSize size, int flags, int position) {
        long sizeValue = size.longValue();
        ByteBuffer val = value.getByteBuffer(0L, sizeValue);
        return this.setxattr(path, xattr, val, sizeValue, flags, position);
    }

    @FuseMethod
    final int _statfs(String path, StructStatvfs statsvfs) {
        StructStatvfs.StatvfsWrapper wrapper = new StructStatvfs.StatvfsWrapper(path, statsvfs);
        int result = this.statfs(path, wrapper);
        wrapper.write();
        return result;
    }

    @FuseMethod
    final int _symlink(String path, String target) {
        return this.symlink(path, target);
    }

    @FuseMethod
    final int _truncate(String path, TypeOff offset) {
        return this.truncate(path, offset.longValue());
    }

    @FuseMethod
    final int _unlink(String path) {
        return this.unlink(path);
    }

    @FuseMethod
    final int _utimens(String path, StructTimeBuffer timebuffer) {
        StructTimeBuffer.TimeBufferWrapper wrapper = new StructTimeBuffer.TimeBufferWrapper(timebuffer);
        int result = this.utimens(path, wrapper);
        wrapper.write();
        return result;
    }

    @FuseMethod
    final int _write(String path, Pointer buffer, TypeSize size, TypeOff offset, StructFuseFileInfo info) {
        long bufSize = size.longValue();
        long writeOffset = offset.longValue();
        ByteBuffer buf = buffer.getByteBuffer(0L, bufSize);
        StructFuseFileInfo.FileInfoWrapper wrapper = new StructFuseFileInfo.FileInfoWrapper(path, info);
        int result = this.write(path, buf, bufSize, writeOffset, wrapper);
        wrapper.write();
        return result;
    }

    @UserMethod
    public abstract int access(String var1, int var2);

    public abstract void afterUnmount(File var1);

    public abstract void beforeMount(File var1);

    public abstract void beforeUnmount(File var1);

    @UserMethod
    public abstract int bmap(String var1, StructFuseFileInfo.FileInfoWrapper var2);

    @UserMethod
    public abstract int chmod(String var1, TypeMode.ModeWrapper var2);

    @UserMethod
    public abstract int chown(String var1, long var2, long var4);

    @UserMethod
    public abstract int create(String var1, TypeMode.ModeWrapper var2, StructFuseFileInfo.FileInfoWrapper var3);

    protected void defaultStat(StructStat.StatWrapper wrapper, long uid, long gid) {
        wrapper.setMode(TypeMode.NodeType.DIRECTORY).setAllTimesMillis(System.currentTimeMillis()).nlink(1L).uid(FuseJna.getUid()).gid(FuseJna.getGid());
    }

    @UserMethod
    public abstract void destroy();

    @UserMethod
    public abstract int fgetattr(String var1, StructStat.StatWrapper var2, StructFuseFileInfo.FileInfoWrapper var3);

    @UserMethod
    public abstract int flush(String var1, StructFuseFileInfo.FileInfoWrapper var2);

    @UserMethod
    public abstract int fsync(String var1, int var2, StructFuseFileInfo.FileInfoWrapper var3);

    @UserMethod
    public abstract int fsyncdir(String var1, int var2, StructFuseFileInfo.FileInfoWrapper var3);

    @UserMethod
    public abstract int ftruncate(String var1, long var2, StructFuseFileInfo.FileInfoWrapper var4);

    @UserMethod
    public abstract int getattr(String var1, StructStat.StatWrapper var2);

    protected final StructFuseContext getFuseContext() {
        if (!this.isMounted()) {
            throw new IllegalStateException("Cannot get FUSE context if the filesystem is not mounted.");
        }
        return FuseJna.getFuseContext();
    }

    protected TypeGid getFuseContextGid() {
        return this.getFuseContext().gid;
    }

    protected TypePid getFuseContextPid() {
        return this.getFuseContext().pid;
    }

    protected TypeUid getFuseContextUid() {
        return this.getFuseContext().uid;
    }

    final String getFuseName() {
        String name = this.getName();
        if (name == null) {
            return defaultFilesystemName;
        }
        if ((name = regexNormalizeFilesystemName.matcher(name).replaceAll("")).isEmpty()) {
            return defaultFilesystemName;
        }
        return name.toLowerCase();
    }

    final Logger getLogger() {
        return this.logger;
    }

    public final File getMountPoint() {
        this.mountLock.lock();
        File mountPoint = this.mountPoint;
        this.mountLock.unlock();
        return mountPoint;
    }

    protected abstract String getName();

    protected abstract String[] getOptions();

    final AutoUnmountHook getUnmountHook() {
        return this.unmountHook;
    }

    @UserMethod
    public abstract int getxattr(String var1, String var2, XattrFiller var3, long var4, long var6);

    @FuseMethod
    public abstract void init();

    public final boolean isMounted() {
        return this.getMountPoint() != null;
    }

    @UserMethod
    public abstract int link(String var1, String var2);

    @UserMethod
    public abstract int listxattr(String var1, XattrListFiller var2);

    @UserMethod
    public abstract int lock(String var1, StructFuseFileInfo.FileInfoWrapper var2, FlockCommand var3, StructFlock.FlockWrapper var4);

    protected final FuseFilesystem log(boolean logging) {
        return this.log(logging ? Logger.getLogger(this.getClass().getCanonicalName()) : null);
    }

    protected final FuseFilesystem log(Logger logger) {
        this.mountLock.lock();
        if (this.mountPoint != null) {
            this.mountLock.unlock();
            throw new IllegalStateException("Cannot turn logging on/orr when filesystem is already mounted.");
        }
        this.logger = logger;
        this.mountLock.unlock();
        return this;
    }

    @UserMethod
    public abstract int mkdir(String var1, TypeMode.ModeWrapper var2);

    @UserMethod
    public abstract int mknod(String var1, TypeMode.ModeWrapper var2, long var3);

    public final void mount(File mountPoint) throws FuseException {
        this.mount(mountPoint, true);
    }

    public final void mount(File mountPoint, boolean blocking) throws UnsatisfiedLinkError, FuseException {
        this.mountLock.lock();
        if (this.isMounted()) {
            throw new IllegalStateException(this.getFuseName() + " is already mounted at " + this.mountPoint);
        }
        this.mountPoint = mountPoint;
        this.mountLock.unlock();
        this.beforeMount(mountPoint);
        FuseJna.mount(this, mountPoint, blocking);
    }

    public final void mount(String mountPoint) throws FuseException {
        this.mount(new File(mountPoint), true);
    }

    @UserMethod
    public abstract int open(String var1, StructFuseFileInfo.FileInfoWrapper var2);

    @UserMethod
    public abstract int opendir(String var1, StructFuseFileInfo.FileInfoWrapper var2);

    @UserMethod
    public abstract int read(String var1, ByteBuffer var2, long var3, long var5, StructFuseFileInfo.FileInfoWrapper var7);

    @UserMethod
    public abstract int readdir(String var1, DirectoryFiller var2);

    @UserMethod
    public abstract int readlink(String var1, ByteBuffer var2, long var3);

    @UserMethod
    public abstract int release(String var1, StructFuseFileInfo.FileInfoWrapper var2);

    @UserMethod
    public abstract int releasedir(String var1, StructFuseFileInfo.FileInfoWrapper var2);

    @UserMethod
    public abstract int removexattr(String var1, String var2);

    @UserMethod
    public abstract int rename(String var1, String var2);

    @UserMethod
    public abstract int rmdir(String var1);

    void setFinalMountPoint(File mountPoint) {
        this.mountLock.lock();
        this.mountPoint = mountPoint;
        this.mountLock.unlock();
    }

    @UserMethod
    public abstract int setxattr(String var1, String var2, ByteBuffer var3, long var4, int var6, int var7);

    @UserMethod
    public abstract int statfs(String var1, StructStatvfs.StatvfsWrapper var2);

    @UserMethod
    public abstract int symlink(String var1, String var2);

    @UserMethod
    public abstract int truncate(String var1, long var2);

    @UserMethod
    public abstract int unlink(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unmount() throws IOException, FuseException {
        this.mountLock.lock();
        try {
            if (!this.isMounted()) {
                return;
            }
            this.beforeUnmount(this.mountPoint);
            File oldMountPoint = this.mountPoint;
            FuseJna.unmount(this);
            this.mountPoint = null;
            this.afterUnmount(oldMountPoint);
        }
        finally {
            this.mountLock.unlock();
        }
    }

    @UserMethod
    public abstract int utimens(String var1, StructTimeBuffer.TimeBufferWrapper var2);

    @UserMethod
    public abstract int write(String var1, ByteBuffer var2, long var3, long var5, StructFuseFileInfo.FileInfoWrapper var7);

    private static @interface UserMethod {
    }

    private static @interface FuseMethod {
    }
}

