/*
 * Decompiled with CFR 0.152.
 */
package net.fusejna;

import com.sun.jna.Function;
import com.sun.jna.Pointer;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.fusejna.DirectoryFiller;
import net.fusejna.types.TypeOff;

public final class DirectoryFillerImpl
implements DirectoryFiller {
    private static final String currentDirectory = ".";
    private static final String parentDirectory = "..";
    private final Pointer buf;
    private final Function nativeFunction;
    private final Set<String> addedFiles = new HashSet<String>();

    DirectoryFillerImpl(Pointer buf, Function nativeFunction) {
        this.buf = buf;
        this.nativeFunction = nativeFunction;
        this.add(currentDirectory, parentDirectory);
    }

    @Override
    public final boolean add(Iterable<String> files) {
        for (String file : files) {
            Object[] args;
            int result;
            if (file == null) continue;
            if (file.contains(File.separator)) {
                file = new File(file).getName();
            }
            if (!this.addedFiles.add(file) || (result = this.nativeFunction.invokeInt(args = new Object[]{this.buf, file, null, new TypeOff(0L)})) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean add(String ... files) {
        return this.add(Arrays.asList(files));
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        int count = 0;
        for (String file : this.addedFiles) {
            output.append(file);
            if (count < this.addedFiles.size() - 1) {
                output.append(", ");
            }
            ++count;
        }
        return output.toString();
    }
}

