---
name: Onboarding Issue
about: Onboard a new developer to our API-first approach
title: 'Onboarding Issue'
labels: onboarding
assignees: ''

---

# A day in the life of an API-developer: On-boarding issue 

![image](https://user-images.githubusercontent.com/1872314/210010257-d906dd06-9928-43a5-877f-6d9a70e95b88.png)

We are thrilled to have you and like your first day to be educational and fun, so you will learn about our API-first development workflow by having fun with Lego, Postman and OpenAI (DALL-E, GPT-3) 🏢 ➡️ 🤖 ➡️ 🍫 🚗 🖼️

## Tours overview

We will touch many aspects of both the producer as well as consumer lifecycle for API-first development.

![image](https://user-images.githubusercontent.com/1872314/210010512-f2100dc0-5038-43ac-95cb-3998097661fb.png)

There are three tours available:
* API Consumer Tour - Short one, covers how to 
  - [ ] discover via search / private API network
  - [ ] *Optional* discover via published documentation
  - [ ] evaluate / fork
  - [ ] *Optional* Explore workspace types and their visibility (comparison to GitHub [here](https://www.postman.com/jonico-postman))
  - [ ] integrate (client) already published APIs as an end user 
  - [ ] *Optional* suggest changes to the API (documentation) - pull requests - shortest producer cycle
  - [ ] *Optional* Use tests and collection variables to chain multiple APIs together
  - [ ] *Optional* Use comments on request level to suggest adding a new material - longer producer cycle
  - [ ] *Optional* Use collection comment to suggest adding our own company/new material - longest producer cycle

* API Producer Tour - Collaboration Aspects Documentation - Shortest one
  - [ ] get notified about new pull requests
  - [ ] review pull requests, ask for follow up changes
  - [ ] merge pull requests
  - [ ] *Optional* see updated online docs
  
* API Producer Tour - Design Aspect - Longest One, covers how to
  - [ ] *Optional* find out what changes have been requested
  - [ ] define and design a new API functionality
  - [ ] develop it in a separate branch
  - [ ] add OpenAPI responses using helper collections
  - [ ] *Optional* discover OpenAI workspaces from Postman Public API network search
  - [ ] integrate with CI/CD
  - [ ] *Optional* collaborate with coworkers
  - [ ] add test cases using data files
  - [ ] *Optional* run Postman test collections from UI with data files and special environments
  - [ ] generate collections out of OpenAPI definitions
  - [ ] add Mock server responses
  - [ ] *Optional* discover GitHub workspaces from Postman Public API network categories
  - [ ] *Optional* test security and governance rules
  - [ ] Publish/deploy new API version
  - [ ] *Optional* observe governance and security checks with a monitor
  - [ ] *Optional* Publish/distribute public developer documentation with special DocuMock environment
 
* API  Producer Tour - Implementation Aspects - Medium one, covers how to
    - [ ] discover what changes needs to be done
    - [ ] *Optional* fork integration tests to workspace
    - [ ] evaluate / environments
    - [ ] figure out what changed between versions
    - [ ] integrate with ci/cd and work in isolation
    - [ ] code generation (external/internal)
    - [ ]   Optional discover GitHub workspaces from Postman Public API network categories
    - [ ] run tests manually
    - [ ] Postman and CI/CD environments (Heroku)
    - [ ] faker library and data files
    - [ ] monitor staging and production
    - [ ] publish docu

## The API Consumer Tour - Fun with AI and lego

- [ ] There are multiple ways how you can discover our **A(i)ppealing companies API**. The easiest way would be to just search for "AI lego" in the Postman search bar and restrict your search to our private API network

<img width="761" alt="image" src="https://user-images.githubusercontent.com/1872314/210241912-3cffa046-d109-496e-88ce-13a83402aae4.png">

- You can also manually navigate to the ([AI Examples folders](https://automotive-demo.postman.co/network/private/folders/55311)) in our private API network. 

<img width="507" alt="image" src="https://user-images.githubusercontent.com/1872314/210242076-8fd91e48-e22e-475a-baa6-f1c1dfb89a2c.png">

The highlighted entry is the [Public A(i)ppealing Companies Workspace](https://automotive-demo.postman.co/network/private/workspaces/210e7615-f69f-4322-a87f-1d8135fe05bd). Inside the workspace, you will find [the collection](https://www.postman.com/automotive-demo/workspace/public-a-i-ppealing-companies/collection/24483733-47e300a5-2444-4bd9-b655-fe248d247a23?action=share&creator=24483733) that is backing the [public facing documentation](https://auto-demo.postmansolutions.com/). This collection was automatically generated by the OpenAPI definition of its [corresponding internal workspace](https://automotive-demo.postman.co/workspace/A(i)ppealing-Companies~3b7a128e-030d-4781-ab59-73c6a77eda88/api/60abd0b4-cf4a-4a74-a18c-4fcb45e61554).

<img width="1030" alt="image" src="https://user-images.githubusercontent.com/1872314/210012228-a103efaa-d999-4199-927a-ee861070823f.png">

- [ ] This is how our [A(i)ppealing Companies API ](https://auto-demo.postmansolutions.com/) will look in our public developer portal and how our end users can evaluate its functionalities without leaving their browser, just click on the "Run in Postman" button to fork and evaluate the API

![image](https://user-images.githubusercontent.com/1872314/210011063-844c9ee2-2d2a-44d1-975f-6b2fa88afaf8.png)

Fork to your personal namespace

<img width="542" alt="image" src="https://user-images.githubusercontent.com/1872314/210243940-d48cbcd9-0df7-4d53-afaf-7a00fed1b08c.png">

- [ ] Navigate to the `List all companies` request, hit the send button and then click on the navigate tab to get an overview of the curated companies and their products

<img width="1124" alt="image" src="https://user-images.githubusercontent.com/1872314/210244218-da3c8518-f213-47ea-bd6f-58fcbac58c2c.png">

- [ ] Now, we like to actually get some pictures generated by AI, switch to the `Get company` request and select one of the curated companies and material as parameter, hit send and visualize

<img width="1124" alt="image" src="https://user-images.githubusercontent.com/1872314/210244926-b40d862d-9816-42bd-95bf-94de97e06758.png">

- [ ] *Optional* To integrate the API in your own apps, open the code tab on the right, and switch to your favourite programming language. You can also change the environment on the upper right to `DocuStaging` and hit send again to see how the generated code snippets change:

<img width="1124" alt="image" src="https://user-images.githubusercontent.com/1872314/210245472-b37c6247-d419-4452-b4f7-5347152e83db.png">

- [ ] *Optional* If you like to suggest some changes on the API, feel free to suggest the change you like to see and create a pull request (your workspace needs to be public for this to work)

<img width="887" alt="image" src="https://user-images.githubusercontent.com/1872314/210247300-c3dabeae-5fc0-4e44-81c6-487bb3e33723.png">


- [ ] *Optional* If you like to understand which OpenAI APIs can be used to implement the A(i)ppealing companies API, have a look at the [OpenAI POC (fun with lego)](https://automotive-demo.postman.co/workspace/A(i)ppealing-Companies~3b7a128e-030d-4781-ab59-73c6a77eda88/collection/24483733-1be24a1b-a0f3-4a9b-91b2-655f7cd78f5b?action=share&creator=24483733) collection. Its `OpenAI Experiments` folder shows the used API calls whereas the `API MashUp` folder chains multiple requests of the different APIs together by using collection variables and test scripts.

<img width="1019" alt="image" src="https://user-images.githubusercontent.com/1872314/210120972-e716e9b0-14bf-4a3a-9112-0047605082c2.png">

- [ ] *Optional* Now, let's try what happens when we try out a completely new material like `platin`, go to the [A(i)ppealing companies 1.2.x Playground](https://automotive-demo.postman.co/workspace/3b7a128e-030d-4781-ab59-73c6a77eda88/collection/24483733-75b85d49-37d0-4905-bcfd-f92839faadef?action=share&creator=24483733) and try out what happens if we set the material to `platin`.

<img width="849" alt="image" src="https://user-images.githubusercontent.com/1872314/210254472-bd719c66-49c3-495e-8ad9-da0576aaadca.png">

As you can see, platin is not yet supported, so let's ask the API producers to introduce that material in a request comment

<img width="1244" alt="image" src="https://user-images.githubusercontent.com/1872314/210254325-8f778886-bd31-4778-9ea2-49e9fba8cb1f.png">

- [ ] *Optional* While we are it, we can also ask for our own company and product to be included as default example and in the list of curated companies, this time, we use the ability to comment on the parameter level and on the connection level

<img width="918" alt="image" src="https://user-images.githubusercontent.com/1872314/210255010-d544d955-695d-4826-845e-7e3e6c28a5ff.png">

<img width="1240" alt="image" src="https://user-images.githubusercontent.com/1872314/210255287-05a3767b-3228-4c07-83f2-464e9f50313f.png">


## The API Producer Tour - Very short - Collaboration Aspect Docs

- [ ] Once your API consumer created the pull request with the suggested material change, you will get a new notification

<img width="394" alt="image" src="https://user-images.githubusercontent.com/1872314/210248729-5da138cf-fac9-4ed1-9670-5ff74d51b204.png">

Click on _View Pull Request_ to review the change

<img width="628" alt="image" src="https://user-images.githubusercontent.com/1872314/210249094-5bac510b-34b7-4707-b2d6-5a7221e8abcb.png">

- [ ] If we like the change, we can approve, and merge it right away, in this case, we like to have a change and use the commenting functionality to ask for that change

<img width="628" alt="image" src="https://user-images.githubusercontent.com/1872314/210249948-45358aaf-efa5-45ba-bf6d-9ec3db7c85bf.png">

- [ ] The API consumer would receive a notification with our comment

<img width="447" alt="image" src="https://user-images.githubusercontent.com/1872314/210250115-5775e0e7-a852-4f91-b809-5feb611dff9a.png">

Based on the comment, a new change can be suggested by modifying the collection again

<img width="1666" alt="image" src="https://user-images.githubusercontent.com/1872314/210250536-9fc69017-f652-427f-ad6d-7f7f010557e5.png">

- [ ] Once satisfied with the change it can get approved and merged

<img width="761" alt="image" src="https://user-images.githubusercontent.com/1872314/210251053-2b18e416-171e-4d3d-a878-b5be24418bff.png">

- [ ] *Optional* Check the [online docs](https://auto-demo.postmansolutions.com/#7aa0225b-9b37-41af-b51e-21b6a12aa6f9), they have been updated automatically

## The API Producer Tour - Design Aspects

- [ ] *Optional* Check your notifications to learn about the API design (and implementation) change that is asked for

<img width="382" alt="image" src="https://user-images.githubusercontent.com/1872314/210257489-5638596e-9584-4723-8fbe-c9464bd02203.png">

<img width="1236" alt="image" src="https://user-images.githubusercontent.com/1872314/210257557-983e8191-8d4d-44d7-a5e9-b4d059de5135.png">

Tell the requestor that you are on it and resolve the comment

<img width="350" alt="image" src="https://user-images.githubusercontent.com/1872314/210257743-49ecac86-5502-4ef6-9dfb-c554b4f16436.png">

- [ ] *Optional* You are asked to design a new feature for the A(i)ppealing Companies API, you will discover the related [company internal workspace ](https://automotive-demo.postman.co/network/private/workspaces/3b7a128e-030d-4781-ab59-73c6a77eda88) that is part of our private API network ([AI Examples folders](https://automotive-demo.postman.co/network/private/folders/55311)), **just search for "AI lego"**

<img width="1345" alt="image" src="https://user-images.githubusercontent.com/1872314/210011563-cf0d42b3-f541-4541-8632-100f6eb619b5.png">

- [ ] Our goal is to **design a curated product example for our own company and introduce a new material** to create visually appealing representations, to test our API definition related changes in isolation, we will create a new branch called after our company

<img width="1030" alt="image" src="https://user-images.githubusercontent.com/1872314/210012698-c9b71815-4ea8-46b0-87b6-62c4c0eb6790.png">

- [ ] *Optional* We do not need to manually create the example record for our company, instead we can use the [OpenAI POC (fun with lego)](https://automotive-demo.postman.co/workspace/A(i)ppealing-Companies~3b7a128e-030d-4781-ab59-73c6a77eda88/collection/24483733-1be24a1b-a0f3-4a9b-91b2-655f7cd78f5b?action=share&creator=24483733) with its built-in visualizations, tests and collection variables to make use of the OpenAI API to create the records and mocks semi-automatically.

<img width="1039" alt="image" src="https://user-images.githubusercontent.com/1872314/210021008-d3bd3086-137c-4796-ba7d-d369d57435df.png">


- [ ] *Optional* You may wonder how we learned about the functionalities of the OpenAI API with its text and image generation facilities. We actually found the API and its collection in [Postman's Public API network](https://postman.com/explore) by searching for term **OpenAI**. We could have also browsed [Postman's Artificial Intelligence Category](https://www.postman.com/category/artificial-intelligence) to find the API. Any public workspace / API could be published to the world wide community, maybe one step in the future when our API is ready for prime time 😊 

![image](https://user-images.githubusercontent.com/1872314/210019944-eff0e1bd-b498-4c9a-8278-3627ce06fcb7.png)

- [ ] Replace the first response example with the one for your company, change the example for the `companyId` to our id, add the new material to the allowed enum values for the material parameter and set it as example value, push the changes upstream and create a PR

<img width="1039" alt="image" src="https://user-images.githubusercontent.com/1872314/210020028-5b12d752-a1bf-4e24-8371-09f8523ff2cb.png">


- [ ] You will recognize, that the test cases will still fail as the Mock Server for the API conformance does not know anything about our company yet, let's examine the log

![image](https://user-images.githubusercontent.com/1872314/210017330-f5cb4e1a-4f9e-4237-bf60-cff9c22010fc.png)

- [ ] **Optional** You can run the same test suite from Postman when you run the `Governance Checks` collection with the [CuratedMocks](https://automotive-demo.postman.co/workspace/A(i)ppealing-Companies~3b7a128e-030d-4781-ab59-73c6a77eda88/environment/24483733-6c43e13c-0e7c-4212-b88d-8ef352752230) environment and the `data/companies.csv` data file.

<img width="1158" alt="image" src="https://user-images.githubusercontent.com/1872314/210017763-f68ae508-85b5-4e92-a380-a707e57e3da4.png">

- [ ] To fix the problem, we will need to create a Mock response for our company in the [CuratedMockResponses](https://automotive-demo.postman.co/workspace/A(i)ppealing-Companies~3b7a128e-030d-4781-ab59-73c6a77eda88/collection/24483733-dbf631a1-0bbd-4e39-95f5-97723eeb7942?action=share&creator=24483733) collection. There are multiple ways to do this, but one easy way would be to create a new collection from our OpenAPI definition, copy it to the workspace, and finally copy the generated `OK` example response of the `Get Company` request to the `Get company` request of the [Mock collection](https://automotive-demo.postman.co/workspace/A(i)ppealing-Companies~3b7a128e-030d-4781-ab59-73c6a77eda88/collection/24483733-dbf631a1-0bbd-4e39-95f5-97723eeb7942?action=share&creator=24483733). Please rename the response to `OK (your company)` for better readability.

<img width="1274" alt="image" src="https://user-images.githubusercontent.com/1872314/210019355-79ff7cce-595c-4711-a077-ba631a4b145e.png">

- [ ] To also list your company in the list of curated company responses, replace the content of the [Mock collections's](https://automotive-demo.postman.co/workspace/A(i)ppealing-Companies~3b7a128e-030d-4781-ab59-73c6a77eda88/collection/24483733-dbf631a1-0bbd-4e39-95f5-97723eeb7942?action=share&creator=24483733) `OK` response of the `List all companies` response with your generated one.

<img width="1274" alt="image" src="https://user-images.githubusercontent.com/1872314/210019593-079b849a-948a-4337-9d3e-1bc7b718c975.png">

- [ ] You will see your PR updated with your generated product picture:

![image](https://user-images.githubusercontent.com/1872314/210021139-7e1c70b4-32e3-4553-84af-c265227cff00.png)

- [ ] *Optional* If you wonder how the results of the tests appeared in your PR, have a look at the `Update GitHub PR / Issue` request. It is using previously set collection variables in combination with pre-request and test scripts.

<img width="780" alt="image" src="https://user-images.githubusercontent.com/1872314/210120162-aa3d59e9-d09b-43cb-96c8-7d4a501daaa5.png">

<img width="780" alt="image" src="https://user-images.githubusercontent.com/1872314/210120169-f25ff4e1-c76c-49d8-9e4e-3e8049c92ed2.png">

The request itself has been copied from our version of the [GitHub Web API Reference](https://automotive-demo.postman.co/workspace/3b7a128e-030d-4781-ab59-73c6a77eda88/collection/24483733-fd611ee8-9f45-4ef7-9135-77d26725093d?action=share&creator=24483733) which has been forked from the [public workspace](https://www.postman.com/api-evangelist/workspace/github) in Postman's Public API Network DevOps category.

- [ ] **Optional** The governance tests also include API governance and security checks, try to trigger a breaking test by adding a trailing slash to an endpoint or have a look at realtime rule validation by changing the API version number to something non-semver

<img width="914" alt="image" src="https://user-images.githubusercontent.com/1872314/210021437-0702e1d0-947c-4164-b42c-f5eada40dcfa.png">

![image](https://user-images.githubusercontent.com/1872314/210021520-29cb2750-79b3-4137-b1d1-8efd1109e162.png)

- [ ] Fix any kind of temporary compliance and security errors you have introduced and bump the version number of the API (increase the patch version), commit and push your changes.

- [ ] Publish your API design with a release note

<img width="424" alt="image" src="https://user-images.githubusercontent.com/1872314/210021832-f272c0a8-7ef7-4f15-a577-72829cc1e419.png">

- [ ] *Optional* Fork the `Governance Checks` collection of your newly created API version to the workspace, rename them to add the API version number and create a monitor that is running them daily with with the [MonitorCuratedMocks](https://automotive-demo.postman.co/workspace/A(i)ppealing-Companies~3b7a128e-030d-4781-ab59-73c6a77eda88/environment/24483733-b211d08a-9fd7-4fab-ad2d-4ba7d5f520f2) environment and the `data/companies.csv` data file.

<img width="966" alt="image" src="https://user-images.githubusercontent.com/1872314/210022393-41de2c6e-6ced-4b7e-aefb-da45600c081e.png">

- [ ] *Optional* Publish the documentation from the generated collection you copied to your workspace together with the [DocuMock Environment](https://automotive-demo.postman.co/workspace/A(i)ppealing-Companies~3b7a128e-030d-4781-ab59-73c6a77eda88/environment/24483733-53f673f2-1856-4fa0-adaa-5e7e961f455d)

<img width="841" alt="image" src="https://user-images.githubusercontent.com/1872314/210023512-aeaa6127-b837-441d-841b-f066d5b7474b.png">

So far, we can test your API with our mock data, no new pictures will actually be generated and the "ai" mode does not work either - for this we need a real backend implementation of our new API which brings us to the internal consumer flow.

## The API Producer Flow - Implementation Aspects

- [ ] *Optional* To implement the new version of our API, you will discover the related [company internal workspace ](https://automotive-demo.postman.co/network/private/workspaces/3b7a128e-030d-4781-ab59-73c6a77eda88) who is part of our private API network ([AI Examples folders](https://automotive-demo.postman.co/network/private/folders/55311)). Select the latest version of the API, scroll down to the release logs to see what has changed.

<img width="1004" alt="image" src="https://user-images.githubusercontent.com/1872314/210085570-4661e56d-de22-44cb-995d-cfeaf0ed1170.png">

- [ ] *Optional* If you like to find out the differences between the previously implemented API in detail, have a look at the [API object itself ](https://automotive-demo.postman.co/workspace/A(i)ppealing-Companies~3b7a128e-030d-4781-ab59-73c6a77eda88/api/60abd0b4-cf4a-4a74-a18c-4fcb45e61554), and check the Git branch associated with the versions you like to compare:

<img width="292" alt="image" src="https://user-images.githubusercontent.com/1872314/210086017-6681e1d9-860d-4fe5-8eab-fdc413529d59.png">

You can use GitHub's [branch comparison feature](https://github.com/postman-solutions-eng/aippealing-companies/compare/introduce-gold...our-company?diff=unified) for the details:

![image](https://user-images.githubusercontent.com/1872314/210086613-cd939a26-b7ef-4a3e-bed6-93ce29b0a2f4.png)

- [ ] In our particular case, the associated API test suites did not change significantly (only ids), so there is no need to fork the API version specific test suites into our workspace again, if there was a bigger change, we would need to fork at least the Governance Checks collection of the versioned API and adjust our CI/CD config. In our case, we just inspect the runs of the [matching Integration Tests collection](https://automotive-demo.postman.co/workspace/3b7a128e-030d-4781-ab59-73c6a77eda88/collection/24483733-6e0f8fd9-c222-483e-83c7-524b0483c3cb?action=share&creator=24483733).

<img width="1311" alt="image" src="https://user-images.githubusercontent.com/1872314/210088058-26300ba9-f168-45c8-b90a-202d6523c727.png">

- [ ] *Optional* If we manually run the the suite with our updated `data/companies.csv` against the [CuratedMocks](https://automotive-demo.postman.co/workspace/3b7a128e-030d-4781-ab59-73c6a77eda88/environment/24483733-6c43e13c-0e7c-4212-b88d-8ef352752230) collection, we should see all tests pass as this is the same setup as for the API-first producer lifecycle. However, if we switch the environment to staging, which is used for CI/CD and run it manually again, we will get a validation error as the new material is not yet recognized by the backend.

<img width="1311" alt="image" src="https://user-images.githubusercontent.com/1872314/210088269-0db83f62-c947-4795-ac86-b29711fe2fb1.png">

- [ ] Inside the PR of the API changes, we see a new [Heroku preview environment](https://dashboard.heroku.com/pipelines/85e8061f-a320-4856-9135-d4add7d4ec2c) that is used to run our integration test suite against the reference implementation in the same branch.

![image](https://user-images.githubusercontent.com/1872314/210089022-37bfe51f-bf4d-49ea-9987-5e40df7c4f24.png)

As we have not changed the backend (other than the new test case) yet, we will see similar validation errors in CI/CD as we did when running the integration test suite manually in Postman.

![image](https://user-images.githubusercontent.com/1872314/210089664-5ef9cd5d-15de-4170-ad89-0eab9e7d1de3.png)

    - [ ] To change the backend code, you could either use the internal server code generator

<img width="1246" alt="image" src="https://user-images.githubusercontent.com/1872314/210252017-11f0ef3a-15b3-47c1-8f15-1e41c381933e.png">

or an external generator like OpenAPI Tools

<img width="1720" alt="image" src="https://user-images.githubusercontent.com/1872314/210252399-735e62b8-603d-4405-881f-74d6b2c7fd6d.png">

Review the changes proposed, commit and push them to your branch

   - [ ] After the backend code has been adjusted to accept the new material you introduced, the iteration for your newly introduced company will fail for a different reason - there is no curated data for your company in the backend yet.

![image](https://user-images.githubusercontent.com/1872314/210107311-779c1975-fd20-4d1a-a771-c73649f55b1a.png)

To solve this issue, copy the `OK` example response from the [CuratedMockResponses](https://automotive-demo.postman.co/workspace/3b7a128e-030d-4781-ab59-73c6a77eda88/collection/24483733-dbf631a1-0bbd-4e39-95f5-97723eeb7942?action=share&creator=24483733) collection to `data/companies.json` in your branch, commit and push.

After that, test cases should successfully run through 🎉  

<img width="1106" alt="image" src="https://user-images.githubusercontent.com/1872314/210109049-5aa62bb9-a56a-4adc-8cbb-8a466b6bc631.png">

- [ ] *Optional* If you wonder how the results of the tests appeared in your PR, have a look at the `Update GitHub PR / Issue` request. It is using previously set collection variables in combination with pre-request and test scripts.

<img width="780" alt="image" src="https://user-images.githubusercontent.com/1872314/210120162-aa3d59e9-d09b-43cb-96c8-7d4a501daaa5.png">

<img width="780" alt="image" src="https://user-images.githubusercontent.com/1872314/210120169-f25ff4e1-c76c-49d8-9e4e-3e8049c92ed2.png">

The request itself has been copied from our version of the [GitHub Web API Reference](https://automotive-demo.postman.co/workspace/3b7a128e-030d-4781-ab59-73c6a77eda88/collection/24483733-fd611ee8-9f45-4ef7-9135-77d26725093d?action=share&creator=24483733) which has been forked from the [public workspace](https://www.postman.com/api-evangelist/workspace/github) in Postman's Public API Network DevOps category.

- [ ] *Optional* If you ran the integration suite manually against the [staging environment](https://automotive-demo.postman.co/workspace/3b7a128e-030d-4781-ab59-73c6a77eda88/environment/24483733-d838aaef-4fe8-4bcc-85d6-d8e7b0cc880a), it would still fail at this point as we have not yet promoted the preview build in our branch to staging:

<img width="1106" alt="image" src="https://user-images.githubusercontent.com/1872314/210109154-7559bb67-9fc2-429e-9670-b6fb984cc021.png">

We could adjust the [preview environment's](https://automotive-demo.postman.co/workspace/3b7a128e-030d-4781-ab59-73c6a77eda88/environment/24483733-bacd70b7-7492-4585-a6ce-d0d08febfd05) baseUrl to point to the Heroku preview env if we wanted to simulate what CI/CD does in our branch with the review app.

<img width="1533" alt="image" src="https://user-images.githubusercontent.com/1872314/210109260-d329e38d-0d13-46d9-96c1-85edc30c4bf0.png">

- [ ] We can now merge the pull request to promote the preview build to staging.

![image](https://user-images.githubusercontent.com/1872314/210118394-2cc73528-167c-4883-bd8d-a6129a76cbc0.png)

- [ ] *Optional* Make a copy of the integration test suite and change the company with a random name using the [faker library](https://learning.postman.com/docs/writing-scripts/script-references/variables-list/), run it multiple iterations against staging

<img width="878" alt="image" src="https://user-images.githubusercontent.com/1872314/210119000-d52a3e75-d8e2-4166-9289-bdb631e7d0fa.png">

- [ ] *Optional* If we are satisfied with the tests and behaviour in the staging environment, we can [promote the staging build to production](https://dashboard.heroku.com/pipelines/85e8061f-a320-4856-9135-d4add7d4ec2c) in Heroku and [trigger a manual workflow](https://github.com/jonico/aippealing-companies-impl-openai/actions/workflows/integration-tests-production.yml) for prod tests.

![image](https://user-images.githubusercontent.com/1872314/210118478-eb22ae25-0591-4f4d-ab5c-8f2527380022.png)

- [ ] *Optional* Update the [Published Docs](https://automotive-demo.postman.co/workspace/A(i)ppealing-Companies~3b7a128e-030d-4781-ab59-73c6a77eda88/collection/24483733-47e300a5-2444-4bd9-b655-fe248d247a23?action=share&creator=24483733) collection with your newly introduced material and see how the [connected public facing documentation](https://auto-demo.postmansolutions.com/) automatically updates as well.

<img width="841" alt="image" src="https://user-images.githubusercontent.com/1872314/210022776-ee31ef2f-39a9-4fc5-a075-11244625d511.png">

- [ ] *Optional* Have a look at the setup monitors and their environments, add a new monitor that runs tests for random companies every day from three different companies

<img width="1647" alt="image" src="https://user-images.githubusercontent.com/1872314/210118870-c723d2a0-909a-4955-b1e6-7dc67e683966.png">





## Advanced Features probably for another day 😅 

- [ ] Live collections
- [ ] API contract generator
- [ ] API fuzzing / naughty strings
- [ ] Deployment to API gateways
- [ ] Integration with APM
- [ ] Integration Overview
- [ ] Capturing network requests
- [ ] GraphQL, AsyncAPI, Open API 3.1 Webhooks, gRPC
- [ ] Flows
- [ ] Access rights / administration
- [ ] Custom spectral rules for security and compliance
- [ ] Externalized test libraries
- [ ] Advanced response visualization
- [ ] Visual Studio Code Integration
- [ ] Partner Workspaces
- [ ] Custom token scanning
- [ ] Accessing Postman via API for further integration (custom dev portal publishing, server/client code generation)
- [ ] Find out more about environments and partial variable overrides in CI/CD
- [ ] Checking workspace best practices for InnerSource and OpenSource
