//===-------- IDETypeCheckingIDZone.def -------------------------*- C++ -*-===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2019 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
//
//  This definition file describes the types in the IDE requests
//  TypeID zone, for use with the TypeID template.
//
//===----------------------------------------------------------------------===//

POLAR_REQUEST(IDETypeChecking, HasDynamicMemberLookupAttributeRequest,
bool(TypeBase *), Cached, NoLocationInfo)

POLAR_REQUEST(IDETypeChecking, IsDeclApplicableRequest,
bool(DeclApplicabilityOwner), Cached, NoLocationInfo)

POLAR_REQUEST(IDETypeChecking, RootAndResultTypeOfKeypathDynamicMemberRequest,
   TypePair(SubscriptDecl *), Cached, NoLocationInfo)

POLAR_REQUEST(IDETypeChecking, RootTypeOfKeypathDynamicMemberRequest,
   Type(SubscriptDecl *), Uncached, NoLocationInfo)

POLAR_REQUEST(IDETypeChecking, TypeRelationCheckRequest,
bool(TypeRelationCheckInput), Cached, NoLocationInfo)
