//===-- EducationalNotes.def - Diagnostic Documentation Content -*- C++ -*-===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2019 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
//
// This file associates diagnostics with relevant educational notes which
// explain important concepts.
//
//===----------------------------------------------------------------------===//

#ifndef EDUCATIONAL_NOTES
#  error Must define EDUCATIONAL_NOTES
#endif

// EDUCATIONAL_NOTES(DIAG_ID, EDUCATIONAL_NOTE_FILENAMES...)

EDUCATIONAL_NOTES(non_nominal_no_initializers, "nominal-types.md")
EDUCATIONAL_NOTES(non_nominal_extension, "nominal-types.md")
EDUCATIONAL_NOTES(associated_type_witness_conform_impossible,
                  "nominal-types.md")

#undef EDUCATIONAL_NOTES
