//===--- DiagnosticsClangImporter.def - Diagnostics Text --------*- C++ -*-===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2017 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//
//
//  This file defines diagnostics for the Clang importer.
//  Each diagnostic is described using one of three kinds (error, warning, or
//  note) along with a unique identifier, category, options, and text, and is
//  followed by a signature describing the diagnostic argument kinds.
//
//===----------------------------------------------------------------------===//

#if !(defined(DIAG) || (defined(ERROR) && defined(WARNING) && defined(NOTE) && defined(REMARK)))
#  error Must define either DIAG or the set {ERROR,WARNING,NOTE,REMARK}
#endif

#ifndef ERROR
#  define ERROR(ID,Options,Text,Signature)   \
  DIAG(ERROR,ID,Options,Text,Signature)
#endif

#ifndef WARNING
#  define WARNING(ID,Options,Text,Signature) \
  DIAG(WARNING,ID,Options,Text,Signature)
#endif

#ifndef NOTE
#  define NOTE(ID,Options,Text,Signature) \
  DIAG(NOTE,ID,Options,Text,Signature)
#endif

#ifndef REMARK
#  define REMARK(ID,Options,Text,Signature) \
  DIAG(REMARK,ID,Options,Text,Signature)
#endif

WARNING(warning_from_clang,none,
  "%0", (StringRef))
ERROR(error_from_clang,none,
  "%0", (StringRef))
NOTE(note_from_clang,none,
  "%0", (StringRef))
REMARK(remark_from_clang,none,
  "%0", (StringRef))

ERROR(clang_cannot_build_module,Fatal,
  "could not build %select{C|Objective-C}0 module '%1'", (bool, StringRef))

ERROR(bridging_header_missing,Fatal,
  "bridging header '%0' does not exist", (StringRef))
ERROR(bridging_header_error,Fatal,
  "failed to import bridging header '%0'", (StringRef))
WARNING(could_not_rewrite_bridging_header,none,
  "failed to serialize bridging header; "
  "target may not be debuggable outside of its original project", ())
ERROR(bridging_header_pch_error,Fatal,
   "failed to emit precompiled header '%0' for bridging header '%1'",
   (StringRef, StringRef))

ERROR(emit_pcm_error,Fatal,
   "failed to emit precompiled module '%0' for module map '%1'",
   (StringRef, StringRef))
ERROR(dump_pcm_error,Fatal,
   "failed to dump precompiled module '%0'", (StringRef))

WARNING(invalid_swift_name_method,none,
  "too %select{few|many}0 parameters in swift_name attribute (expected %1; "
  "got %2)", (bool, unsigned, unsigned))

NOTE(note_while_importing, none, "while importing '%0'", (StringRef))
ERROR(swift_name_protocol_static, none, "swift_name cannot be used to define "
                                         "%select{static member|init}0 on "
                                         "protocol",
      (bool))
ERROR(swift_name_no_prototype, none,
      "swift_name cannot be used on a non-prototyped function declaration", ())

WARNING(inconsistent_swift_name,none,
        "inconsistent Swift name for Objective-C %select{method|property}0 "
        "'%1' in '%2' (%3 in '%4' vs. %5 in '%6')",
        (bool, StringRef, StringRef, DeclName, StringRef, DeclName,
         StringRef))

WARNING(unresolvable_clang_decl,none,
        "imported declaration '%0' could not be mapped to '%1'",
        (StringRef, StringRef))

NOTE(unresolvable_clang_decl_is_a_framework_bug,none,
     "please report this issue to the owners of '%0'",
     (StringRef))

WARNING(implicit_bridging_header_imported_from_module,none,
        "implicit import of bridging header '%0' via module %1 "
        "is deprecated and will be removed in a later version of Swift",
        (StringRef, Identifier))

#ifndef DIAG_NO_UNDEF
# if defined(DIAG)
#  undef DIAG
# endif
# undef NOTE
# undef WARNING
# undef ERROR
# undef REMARK
#endif
