<?php
// This source file is part of the polarphp.org open source project
//
// Copyright (c) 2017 - 2019 polarphp software foundation
// Copyright (c) 2017 - 2019 zzu_softboy <zzu_softboy@163.com>
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://polarphp.org/LICENSE.txt for license information
// See https://polarphp.org/CONTRIBUTORS.txt for the list of polarphp project authors
//
// Created by polarboy on 2019/10/29.

return array(
   ['class' => 'InternalKeyword', 'name' => 'End', 'kind' => 'END', 'text' => 'end of file', 'serializationCode' => 0],
   ['class' => 'Keyword', 'name' => 'Line', 'kind' => 'T_LINE', 'text' => '__LINE__', 'serializationCode' => 300],
   ['class' => 'Keyword', 'name' => 'File', 'kind' => 'T_FILE', 'text' => '__FILE__', 'serializationCode' => 301],
   ['class' => 'Keyword', 'name' => 'Dir', 'kind' => 'T_DIR', 'text' => '__DIR__', 'serializationCode' => 302],
   ['class' => 'Keyword', 'name' => 'ClassConst', 'kind' => 'T_CLASS_CONST', 'text' => '__CLASS__', 'serializationCode' => 303],
   ['class' => 'Keyword', 'name' => 'TraitConst', 'kind' => 'T_TRAIT_CONST', 'text' => '__TRAIT__', 'serializationCode' => 304],
   ['class' => 'Keyword', 'name' => 'MethodConst', 'kind' => 'T_METHOD_CONST', 'text' => '__METHOD__', 'serializationCode' => 305],
   ['class' => 'Keyword', 'name' => 'FuncConst', 'kind' => 'T_FUNC_CONST', 'text' => '__FUNCTION__', 'serializationCode' => 306],
   ['class' => 'Keyword', 'name' => 'NamespaceConst', 'kind' => 'T_NS_CONST', 'text' => '__NAMESPACE__', 'serializationCode' => 307],
   ['class' => 'DeclKeyword', 'name' => 'Namespace', 'kind' => 'T_NAMESPACE', 'text' => 'namespace', 'serializationCode' => 308],
   ['class' => 'DeclKeyword', 'name' => 'Class', 'kind' => 'T_CLASS', 'text' => 'class', 'serializationCode' => 309],
   ['class' => 'DeclKeyword', 'name' => 'Trait', 'kind' => 'T_TRAIT', 'text' => 'trait', 'serializationCode' => 310],
   ['class' => 'DeclKeyword', 'name' => 'Interface', 'kind' => 'T_INTERFACE', 'text' => 'interface', 'serializationCode' => 311],
   ['class' => 'DeclKeyword', 'name' => 'Extends', 'kind' => 'T_EXTENDS', 'text' => 'extends', 'serializationCode' => 312],
   ['class' => 'DeclKeyword', 'name' => 'Implements', 'kind' => 'T_IMPLEMENTS', 'text' => 'implements', 'serializationCode' => 313],
   ['class' => 'DeclKeyword', 'name' => 'Function', 'kind' => 'T_FUNCTION', 'text' => 'function', 'serializationCode' => 314],
   ['class' => 'DeclKeyword', 'name' => 'Fn', 'kind' => 'T_FN', 'text' => 'fn', 'serializationCode' => 315],
   ['class' => 'DeclKeyword', 'name' => 'Const', 'kind' => 'T_CONST', 'text' => 'const', 'serializationCode' => 316],
   ['class' => 'DeclKeyword', 'name' => 'Var', 'kind' => 'T_VAR', 'text' => 'var', 'serializationCode' => 317],
   ['class' => 'DeclKeyword', 'name' => 'Use', 'kind' => 'T_USE', 'text' => 'use', 'serializationCode' => 318],
   ['class' => 'DeclKeyword', 'name' => 'Insteadof', 'kind' => 'T_INSTEADOF', 'text' => 'insteadof', 'serializationCode' => 319],
   ['class' => 'DeclKeyword', 'name' => 'As', 'kind' => 'T_AS', 'text' => 'as', 'serializationCode' => 320],
   ['class' => 'DeclKeyword', 'name' => 'Global', 'kind' => 'T_GLOBAL', 'text' => 'global', 'serializationCode' => 321],
   ['class' => 'DeclKeyword', 'name' => 'Static', 'kind' => 'T_STATIC', 'text' => 'static', 'serializationCode' => 322],
   ['class' => 'DeclKeyword', 'name' => 'Abstract', 'kind' => 'T_ABSTRACT', 'text' => 'abstract', 'serializationCode' => 323],
   ['class' => 'DeclKeyword', 'name' => 'Final', 'kind' => 'T_FINAL', 'text' => 'final', 'serializationCode' => 324],
   ['class' => 'DeclKeyword', 'name' => 'Private', 'kind' => 'T_PRIVATE', 'text' => 'private', 'serializationCode' => 325],
   ['class' => 'DeclKeyword', 'name' => 'Protected', 'kind' => 'T_PROTECTED', 'text' => 'protected', 'serializationCode' => 326],
   ['class' => 'DeclKeyword', 'name' => 'Public', 'kind' => 'T_PUBLIC', 'text' => 'public', 'serializationCode' => 327],
   ['class' => 'DeclKeyword', 'name' => 'List', 'kind' => 'T_LIST', 'text' => 'list', 'serializationCode' => 328],
   ['class' => 'DeclKeyword', 'name' => 'Array', 'kind' => 'T_ARRAY', 'text' => 'array', 'serializationCode' => 329],
   ['class' => 'DeclKeyword', 'name' => 'Callable', 'kind' => 'T_CALLABLE', 'text' => 'callable', 'serializationCode' => 330],
   ['class' => 'DeclKeyword', 'name' => 'ThreadLocal', 'kind' => 'T_THREAD_LOCAL', 'text' => 'thread_local', 'serializationCode' => 331],
   ['class' => 'DeclKeyword', 'name' => 'Module', 'kind' => 'T_MODULE', 'text' => 'module', 'serializationCode' => 332],
   ['class' => 'DeclKeyword', 'name' => 'Package', 'kind' => 'T_PACKAGE', 'text' => 'package', 'serializationCode' => 333],
   ['class' => 'DeclKeyword', 'name' => 'Async', 'kind' => 'T_ASYNC', 'text' => 'async', 'serializationCode' => 334],
   ['class' => 'DeclKeyword', 'name' => 'Export', 'kind' => 'T_EXPORT', 'text' => 'export', 'serializationCode' => 335],
   ['class' => 'StmtKeyword', 'name' => 'Defer', 'kind' => 'T_DEFER', 'text' => 'defer', 'serializationCode' => 336],
   ['class' => 'StmtKeyword', 'name' => 'If', 'kind' => 'T_IF', 'text' => 'if', 'serializationCode' => 337],
   ['class' => 'StmtKeyword', 'name' => 'ElseIf', 'kind' => 'T_ELSEIF', 'text' => 'elseif', 'serializationCode' => 338],
   ['class' => 'StmtKeyword', 'name' => 'Else', 'kind' => 'T_ELSE', 'text' => 'else', 'serializationCode' => 339],
   ['class' => 'StmtKeyword', 'name' => 'Echo', 'kind' => 'T_ECHO', 'text' => 'echo', 'serializationCode' => 340],
   ['class' => 'StmtKeyword', 'name' => 'Do', 'kind' => 'T_DO', 'text' => 'do', 'serializationCode' => 341],
   ['class' => 'StmtKeyword', 'name' => 'While', 'kind' => 'T_WHILE', 'text' => 'while', 'serializationCode' => 342],
   ['class' => 'StmtKeyword', 'name' => 'For', 'kind' => 'T_FOR', 'text' => 'for', 'serializationCode' => 343],
   ['class' => 'StmtKeyword', 'name' => 'Foreach', 'kind' => 'T_FOREACH', 'text' => 'foreach', 'serializationCode' => 344],
   ['class' => 'StmtKeyword', 'name' => 'Switch', 'kind' => 'T_SWITCH', 'text' => 'switch', 'serializationCode' => 345],
   ['class' => 'StmtKeyword', 'name' => 'Case', 'kind' => 'T_CASE', 'text' => 'case', 'serializationCode' => 346],
   ['class' => 'StmtKeyword', 'name' => 'Default', 'kind' => 'T_DEFAULT', 'text' => 'default', 'serializationCode' => 347],
   ['class' => 'StmtKeyword', 'name' => 'Break', 'kind' => 'T_BREAK', 'text' => 'break', 'serializationCode' => 348],
   ['class' => 'StmtKeyword', 'name' => 'Continue', 'kind' => 'T_CONTINUE', 'text' => 'continue', 'serializationCode' => 349],
   ['class' => 'StmtKeyword', 'name' => 'Fallthrough', 'kind' => 'T_FALLTHROUGH', 'text' => 'fallthrough', 'serializationCode' => 350],
   ['class' => 'StmtKeyword', 'name' => 'Goto', 'kind' => 'T_GOTO', 'text' => 'goto', 'serializationCode' => 351],
   ['class' => 'StmtKeyword', 'name' => 'Return', 'kind' => 'T_RETURN', 'text' => 'return', 'serializationCode' => 352],
   ['class' => 'StmtKeyword', 'name' => 'Try', 'kind' => 'T_TRY', 'text' => 'try', 'serializationCode' => 353],
   ['class' => 'StmtKeyword', 'name' => 'Catch', 'kind' => 'T_CATCH', 'text' => 'catch', 'serializationCode' => 354],
   ['class' => 'StmtKeyword', 'name' => 'Finally', 'kind' => 'T_FINALLY', 'text' => 'finally', 'serializationCode' => 355],
   ['class' => 'StmtKeyword', 'name' => 'Throw', 'kind' => 'T_THROW', 'text' => 'throw', 'serializationCode' => 356],
   ['class' => 'ExprKeyword', 'name' => 'Unset', 'kind' => 'T_UNSET', 'text' => 'unset', 'serializationCode' => 357],
   ['class' => 'ExprKeyword', 'name' => 'Isset', 'kind' => 'T_ISSET', 'text' => 'isset', 'serializationCode' => 358],
   ['class' => 'ExprKeyword', 'name' => 'Empty', 'kind' => 'T_EMPTY', 'text' => 'empty', 'serializationCode' => 359],
   ['class' => 'ExprKeyword', 'name' => 'HaltCompiler', 'kind' => 'T_HALT_COMPILER', 'text' => '__halt_compiler', 'serializationCode' => 360],
   ['class' => 'ExprKeyword', 'name' => 'Eval', 'kind' => 'T_EVAL', 'text' => 'eval', 'serializationCode' => 361],
   ['class' => 'ExprKeyword', 'name' => 'Include', 'kind' => 'T_INCLUDE', 'text' => 'include', 'serializationCode' => 362],
   ['class' => 'ExprKeyword', 'name' => 'IncludeOnce', 'kind' => 'T_INCLUDE_ONCE', 'text' => 'include_once', 'serializationCode' => 363],
   ['class' => 'ExprKeyword', 'name' => 'Require', 'kind' => 'T_REQUIRE', 'text' => 'require', 'serializationCode' => 364],
   ['class' => 'ExprKeyword', 'name' => 'RequireOnce', 'kind' => 'T_REQUIRE_ONCE', 'text' => 'require_once', 'serializationCode' => 365],
   ['class' => 'ExprKeyword', 'name' => 'LogicOr', 'kind' => 'T_LOGICAL_OR', 'text' => 'or', 'serializationCode' => 366],
   ['class' => 'ExprKeyword', 'name' => 'LogicXor', 'kind' => 'T_LOGICAL_XOR', 'text' => 'xor', 'serializationCode' => 367],
   ['class' => 'ExprKeyword', 'name' => 'LogicAnd', 'kind' => 'T_LOGICAL_AND', 'text' => 'and', 'serializationCode' => 368],
   ['class' => 'ExprKeyword', 'name' => 'Print', 'kind' => 'T_PRINT', 'text' => 'print', 'serializationCode' => 369],
   ['class' => 'ExprKeyword', 'name' => 'Yield', 'kind' => 'T_YIELD', 'text' => 'yield', 'serializationCode' => 370],
   ['class' => 'ExprKeyword', 'name' => 'YieldFrom', 'kind' => 'T_YIELD_FROM', 'text' => 'yield from', 'serializationCode' => 371],
   ['class' => 'ExprKeyword', 'name' => 'Instanceof', 'kind' => 'T_INSTANCEOF', 'text' => 'instanceof', 'serializationCode' => 372],
   ['class' => 'ExprKeyword', 'name' => 'IntCast', 'kind' => 'T_INT_CAST', 'text' => '(int)', 'serializationCode' => 373],
   ['class' => 'ExprKeyword', 'name' => 'DoubleCast', 'kind' => 'T_DOUBLE_CAST', 'text' => '(double)', 'serializationCode' => 374],
   ['class' => 'ExprKeyword', 'name' => 'StringCast', 'kind' => 'T_STRING_CAST', 'text' => '(string)', 'serializationCode' => 375],
   ['class' => 'ExprKeyword', 'name' => 'ArrayCast', 'kind' => 'T_ARRAY_CAST', 'text' => '(array)', 'serializationCode' => 376],
   ['class' => 'ExprKeyword', 'name' => 'ObjectCast', 'kind' => 'T_OBJECT_CAST', 'text' => '(object)', 'serializationCode' => 377],
   ['class' => 'ExprKeyword', 'name' => 'BoolCast', 'kind' => 'T_BOOL_CAST', 'text' => '(bool)', 'serializationCode' => 378],
   ['class' => 'ExprKeyword', 'name' => 'UnsetCast', 'kind' => 'T_UNSET_CAST', 'text' => '(unset)', 'serializationCode' => 379],
   ['class' => 'ExprKeyword', 'name' => 'New', 'kind' => 'T_NEW', 'text' => 'new', 'serializationCode' => 380],
   ['class' => 'ExprKeyword', 'name' => 'Clone', 'kind' => 'T_CLONE', 'text' => 'clone', 'serializationCode' => 381],
   ['class' => 'ExprKeyword', 'name' => 'Exit', 'kind' => 'T_EXIT', 'text' => 'exit', 'serializationCode' => 382],
   ['class' => 'ExprKeyword', 'name' => 'Declare', 'kind' => 'T_DECLARE', 'text' => 'declare', 'serializationCode' => 383],
   ['class' => 'ExprKeyword', 'name' => 'ClassRefStatic', 'kind' => 'T_CLASS_REF_STATIC', 'text' => 'static', 'serializationCode' => 384],
   ['class' => 'ExprKeyword', 'name' => 'ClassRefSelf', 'kind' => 'T_CLASS_REF_SELF', 'text' => 'self', 'serializationCode' => 385],
   ['class' => 'ExprKeyword', 'name' => 'ClassRefParent', 'kind' => 'T_CLASS_REF_PARENT', 'text' => 'parent', 'serializationCode' => 386],
   ['class' => 'ExprKeyword', 'name' => 'ObjRef', 'kind' => 'T_OBJ_REF', 'text' => 'this', 'serializationCode' => 387],
   ['class' => 'ExprKeyword', 'name' => 'True', 'kind' => 'T_TRUE', 'text' => 'true', 'serializationCode' => 388],
   ['class' => 'ExprKeyword', 'name' => 'False', 'kind' => 'T_FALSE', 'text' => 'false', 'serializationCode' => 389],
   ['class' => 'ExprKeyword', 'name' => 'Null', 'kind' => 'T_NULL', 'text' => 'null', 'serializationCode' => 390],
   ['class' => 'ExprKeyword', 'name' => 'Await', 'kind' => 'T_AWAIT', 'text' => 'await', 'serializationCode' => 391],
   ['class' => 'Punctuator', 'name' => 'PlusSign', 'kind' => 'T_PLUS_SIGN', 'text' => '+', 'serializationCode' => 392],
   ['class' => 'Punctuator', 'name' => 'MinusSign', 'kind' => 'T_MINUS_SIGN', 'text' => '-', 'serializationCode' => 393],
   ['class' => 'Punctuator', 'name' => 'MulSign', 'kind' => 'T_MUL_SIGN', 'text' => '*', 'serializationCode' => 394],
   ['class' => 'Punctuator', 'name' => 'DivSign', 'kind' => 'T_DIV_SIGN', 'text' => '/', 'serializationCode' => 395],
   ['class' => 'Punctuator', 'name' => 'ModSign', 'kind' => 'T_MOD_SIGN', 'text' => '%', 'serializationCode' => 396],
   ['class' => 'Punctuator', 'name' => 'Equal', 'kind' => 'T_EQUAL', 'text' => '=', 'serializationCode' => 397],
   ['class' => 'Punctuator', 'name' => 'StrConcat', 'kind' => 'T_STR_CONCAT', 'text' => '.', 'serializationCode' => 398],
   ['class' => 'Punctuator', 'name' => 'PlusEqual', 'kind' => 'T_PLUS_EQUAL', 'text' => '+=', 'serializationCode' => 399],
   ['class' => 'Punctuator', 'name' => 'MinusEqual', 'kind' => 'T_MINUS_EQUAL', 'text' => '-=', 'serializationCode' => 400],
   ['class' => 'Punctuator', 'name' => 'MulEqual', 'kind' => 'T_MUL_EQUAL', 'text' => '*=', 'serializationCode' => 401],
   ['class' => 'Punctuator', 'name' => 'DivEqual', 'kind' => 'T_DIV_EQUAL', 'text' => '/=', 'serializationCode' => 402],
   ['class' => 'Punctuator', 'name' => 'StrConcatEqual', 'kind' => 'T_STR_CONCAT_EQUAL', 'text' => '.=', 'serializationCode' => 403],
   ['class' => 'Punctuator', 'name' => 'ModEqual', 'kind' => 'T_MOD_EQUAL', 'text' => '%=', 'serializationCode' => 404],
   ['class' => 'Punctuator', 'name' => 'AndEqual', 'kind' => 'T_AND_EQUAL', 'text' => '&=', 'serializationCode' => 405],
   ['class' => 'Punctuator', 'name' => 'OrEqual', 'kind' => 'T_OR_EQUAL', 'text' => '|=', 'serializationCode' => 406],
   ['class' => 'Punctuator', 'name' => 'XorEqual', 'kind' => 'T_XOR_EQUAL', 'text' => '^=', 'serializationCode' => 407],
   ['class' => 'Punctuator', 'name' => 'ShiftLeftEqual', 'kind' => 'T_SL_EQUAL', 'text' => '<<=', 'serializationCode' => 408],
   ['class' => 'Punctuator', 'name' => 'ShiftRightEqual', 'kind' => 'T_SR_EQUAL', 'text' => '>>=', 'serializationCode' => 409],
   ['class' => 'Punctuator', 'name' => 'CoalesceEqual', 'kind' => 'T_COALESCE_EQUAL', 'text' => '\?\?=', 'serializationCode' => 410],
   ['class' => 'Punctuator', 'name' => 'BooleanOr', 'kind' => 'T_BOOLEAN_OR', 'text' => '||', 'serializationCode' => 411],
   ['class' => 'Punctuator', 'name' => 'BooleanAnd', 'kind' => 'T_BOOLEAN_AND', 'text' => '&&', 'serializationCode' => 412],
   ['class' => 'Punctuator', 'name' => 'IsEqual', 'kind' => 'T_IS_EQUAL', 'text' => '==', 'serializationCode' => 413],
   ['class' => 'Punctuator', 'name' => 'IsNotEqual', 'kind' => 'T_IS_NOT_EQUAL', 'text' => '!=', 'serializationCode' => 414],
   ['class' => 'Punctuator', 'name' => 'IsIdentical', 'kind' => 'T_IS_IDENTICAL', 'text' => '===', 'serializationCode' => 415],
   ['class' => 'Punctuator', 'name' => 'IsNotIdentical', 'kind' => 'T_IS_NOT_IDENTICAL', 'text' => '!==', 'serializationCode' => 416],
   ['class' => 'Punctuator', 'name' => 'IsSmaller', 'kind' => 'T_IS_SMALLER', 'text' => '<', 'serializationCode' => 417],
   ['class' => 'Punctuator', 'name' => 'IsSmallerOrEqual', 'kind' => 'T_IS_SMALLER_OR_EQUAL', 'text' => '<=', 'serializationCode' => 418],
   ['class' => 'Punctuator', 'name' => 'IsGreaterOrEqual', 'kind' => 'T_IS_GREATER_OR_EQUAL', 'text' => '>=', 'serializationCode' => 419],
   ['class' => 'Punctuator', 'name' => 'IsGreater', 'kind' => 'T_IS_GREATER', 'text' => '>', 'serializationCode' => 420],
   ['class' => 'Punctuator', 'name' => 'Spaceship', 'kind' => 'T_SPACESHIP', 'text' => '<=>', 'serializationCode' => 421],
   ['class' => 'Punctuator', 'name' => 'ShiftLeft', 'kind' => 'T_SL', 'text' => '<<', 'serializationCode' => 422],
   ['class' => 'Punctuator', 'name' => 'ShiftRight', 'kind' => 'T_SR', 'text' => '>>', 'serializationCode' => 423],
   ['class' => 'Punctuator', 'name' => 'Inc', 'kind' => 'T_INC', 'text' => '++', 'serializationCode' => 424],
   ['class' => 'Punctuator', 'name' => 'Dec', 'kind' => 'T_DEC', 'text' => '--', 'serializationCode' => 425],
   ['class' => 'Punctuator', 'name' => 'NamespaceSeparator', 'kind' => 'T_NS_SEPARATOR', 'text' => '\\\\', 'serializationCode' => 426],
   ['class' => 'Punctuator', 'name' => 'Ellipsis', 'kind' => 'T_ELLIPSIS', 'text' => '...', 'serializationCode' => 427],
   ['class' => 'Punctuator', 'name' => 'Coalesce', 'kind' => 'T_COALESCE', 'text' => '??', 'serializationCode' => 428],
   ['class' => 'Punctuator', 'name' => 'Pow', 'kind' => 'T_POW', 'text' => '**', 'serializationCode' => 429],
   ['class' => 'Punctuator', 'name' => 'PowEqual', 'kind' => 'T_POW_EQUAL', 'text' => '**=', 'serializationCode' => 430],
   ['class' => 'Punctuator', 'name' => 'ObjectOperator', 'kind' => 'T_OBJECT_OPERATOR', 'text' => '->', 'serializationCode' => 431],
   ['class' => 'Punctuator', 'name' => 'DoubleArrow', 'kind' => 'T_DOUBLE_ARROW', 'text' => '=>', 'serializationCode' => 432],
   ['class' => 'Punctuator', 'name' => 'DollarOpenCurlyBraces', 'kind' => 'T_DOLLAR_OPEN_CURLY_BRACES', 'text' => '${', 'serializationCode' => 433],
   ['class' => 'Punctuator', 'name' => 'CurlyOpen', 'kind' => 'T_CURLY_OPEN', 'text' => '{$', 'serializationCode' => 434],
   ['class' => 'Punctuator', 'name' => 'PaamayimNekudotayim', 'kind' => 'T_PAAMAYIM_NEKUDOTAYIM', 'text' => '::', 'serializationCode' => 435],
   ['class' => 'Punctuator', 'name' => 'LeftParen', 'kind' => 'T_LEFT_PAREN', 'text' => '(', 'serializationCode' => 436],
   ['class' => 'Punctuator', 'name' => 'RightParen', 'kind' => 'T_RIGHT_PAREN', 'text' => ')', 'serializationCode' => 437],
   ['class' => 'Punctuator', 'name' => 'LeftBrace', 'kind' => 'T_LEFT_BRACE', 'text' => '{', 'serializationCode' => 438],
   ['class' => 'Punctuator', 'name' => 'RightBrace', 'kind' => 'T_RIGHT_BRACE', 'text' => '}', 'serializationCode' => 439],
   ['class' => 'Punctuator', 'name' => 'LeftSquareBracket', 'kind' => 'T_LEFT_SQUARE_BRACKET', 'text' => '[', 'serializationCode' => 440],
   ['class' => 'Punctuator', 'name' => 'RightSquareBracket', 'kind' => 'T_RIGHT_SQUARE_BRACKET', 'text' => ']', 'serializationCode' => 441],
   ['class' => 'Punctuator', 'name' => 'LeftAngle', 'kind' => 'T_LEFT_ANGLE', 'text' => '<', 'serializationCode' => 442],
   ['class' => 'Punctuator', 'name' => 'RightAngle', 'kind' => 'T_RIGHT_ANGLE', 'text' => '>', 'serializationCode' => 443],
   ['class' => 'Punctuator', 'name' => 'Comma', 'kind' => 'T_COMMA', 'text' => ',', 'serializationCode' => 444],
   ['class' => 'Punctuator', 'name' => 'Colon', 'kind' => 'T_COLON', 'text' => ':', 'serializationCode' => 445],
   ['class' => 'Punctuator', 'name' => 'Semicolon', 'kind' => 'T_SEMICOLON', 'text' => ';', 'serializationCode' => 446],
   ['class' => 'Punctuator', 'name' => 'Backtick', 'kind' => 'T_BACKTICK', 'text' => '`', 'serializationCode' => 447],
   ['class' => 'Punctuator', 'name' => 'SingleStrQuote', 'kind' => 'T_SINGLE_QUOTE', 'text' => '\'', 'serializationCode' => 448],
   ['class' => 'Punctuator', 'name' => 'DoubleStrQuote', 'kind' => 'T_DOUBLE_QUOTE', 'text' => '\"', 'serializationCode' => 449],
   ['class' => 'Punctuator', 'name' => 'VerticalBar', 'kind' => 'T_VBAR', 'text' => '|', 'serializationCode' => 450],
   ['class' => 'Punctuator', 'name' => 'Caret', 'kind' => 'T_CARET', 'text' => '^', 'serializationCode' => 451],
   ['class' => 'Punctuator', 'name' => 'ExclamationMark', 'kind' => 'T_EXCLAMATION_MARK', 'text' => '!', 'serializationCode' => 452],
   ['class' => 'Punctuator', 'name' => 'Tilde', 'kind' => 'T_TILDE', 'text' => '~', 'serializationCode' => 453],
   ['class' => 'Punctuator', 'name' => 'Dollar', 'kind' => 'T_DOLLAR_SIGN', 'text' => '$', 'serializationCode' => 454],
   ['class' => 'Punctuator', 'name' => 'QuestionMark', 'kind' => 'T_QUESTION_MARK', 'text' => '?', 'serializationCode' => 455],
   ['class' => 'Punctuator', 'name' => 'ErrorSuppressSign', 'kind' => 'T_ERROR_SUPPRESS_SIGN', 'text' => '@', 'serializationCode' => 456],
   ['class' => 'Punctuator', 'name' => 'Ampersand', 'kind' => 'T_AMPERSAND', 'text' => '&', 'serializationCode' => 457],
   ['class' => 'Misc', 'name' => 'LNumber', 'kind' => 'T_LNUMBER', 'text' => 'integer number', 'valueType' => 'std::int64_t',
      'serializationCode' => 458],
   ['class' => 'Misc', 'name' => 'DNumber', 'kind' => 'T_DNUMBER', 'text' => 'floating-point number', 'valueType' => 'double',
      'serializationCode' => 459],
   ['class' => 'Misc', 'name' => 'IdentifierString', 'kind' => 'T_IDENTIFIER_STRING', 'text' => 'identifier',
      'valueType' => 'std::string', 'serializationCode' => 460],
   ['class' => 'Misc', 'name' => 'Variable', 'kind' => 'T_VARIABLE', 'text' => 'variable', 'valueType' => 'std::string',
      'serializationCode' => 461],
   ['class' => 'Misc', 'name' => 'EncapsedAndWhitespace', 'kind' => 'T_ENCAPSED_AND_WHITESPACE',
      'text' => 'quoted-string and whitespace', 'valueType' => 'std::string', 'serializationCode' => 462],
   ['class' => 'Misc', 'name' => 'ConstantEncapsedString', 'kind' => 'T_CONSTANT_ENCAPSED_STRING', 'text' => 'quoted-string',
      'valueType' => 'std::string', 'serializationCode' => 463],
   ['class' => 'Misc', 'name' => 'StringVarName', 'kind' => 'T_STRING_VARNAME', 'text' => 'variable name',
      'valueType' => 'std::string', 'serializationCode' => 464],
   ['class' => 'Misc', 'name' => 'NumString', 'kind' => 'T_NUM_STRING', 'text' => 'number', 'valueType' => 'std::string',
      'serializationCode' => 465],
   ['class' => 'Misc', 'name' => 'WhiteSpace', 'kind' => 'T_WHITESPACE', 'text' => 'whitespace', 'serializationCode' => 466],
   ['class' => 'Misc', 'name' => 'PrefixOperator', 'kind' => 'T_PREFIX_OPERATOR', 'text' => 'prefix operator', 'serializationCode' => 467],
   ['class' => 'Misc', 'name' => 'PostfixOperator', 'kind' => 'T_POSTFIX_OPERATOR', 'text' => 'postfix operator', 'serializationCode' => 468],
   ['class' => 'Misc', 'name' => 'BinaryOperator', 'kind' => 'T_BINARY_OPERATOR', 'text' => 'binary operator', 'serializationCode' => 469],
   ['class' => 'Misc', 'name' => 'Comment', 'kind' => 'T_COMMENT', 'text' => 'comment', 'serializationCode' => 470],
   ['class' => 'Misc', 'name' => 'DocComment', 'kind' => 'T_DOC_COMMENT', 'text' => 'doc comment', 'serializationCode' => 471],
   ['class' => 'Misc', 'name' => 'OpenTag', 'kind' => 'T_OPEN_TAG', 'text' => 'open tag', 'serializationCode' => 472],
   ['class' => 'Misc', 'name' => 'OpenTagWithEcho', 'kind' => 'T_OPEN_TAG_WITH_ECHO', 'text' => 'open tag with echo',
      'serializationCode' => 473],
   ['class' => 'Misc', 'name' => 'CloseTag', 'kind' => 'T_CLOSE_TAG', 'text' => 'close tag', 'serializationCode' => 474],
   ['class' => 'Misc', 'name' => 'StartHereDoc', 'kind' => 'T_START_HEREDOC', 'text' => 'heredoc start',
      'serializationCode' => 475],
   ['class' => 'Misc', 'name' => 'EndHereDoc', 'kind' => 'T_END_HEREDOC', 'text' => 'heredoc end',
      'serializationCode' => 476],
   ['class' => 'Misc', 'name' => 'Error', 'kind' => 'T_ERROR', 'text' => 'error', 'valueType' => 'std::string',
      'serializationCode' => 477],
   ['class' => 'Misc', 'name' => 'Unknown', 'kind' => 'T_UNKNOWN_MARK', 'text' => 'unknown token',
      'serializationCode' => 478]
);