# Error Code ERR_002

## Error Description

Error code `ERR_002` occurs when it is not possible to download the Android/iOS plugin.

## Common Causes

Common causes of this error may include:

1. **Connection Issues**: There may be problems with your application's internet connection, preventing the download of the plugin.

2. **Plugin Unavailability**: The plugin you are trying to download may not be currently available on the specified download location. This can be due to outdated information on [godot-admob-versions](https://github.com/poingstudios/godot-admob-versions) or the corresponding versions not being released on [godot-admob-ios](https://github.com/poingstudios/godot-admob-ios) or [godot-admob-android](https://github.com/poingstudios/godot-admob-android).

## Solution

Here are the steps to resolve error `ERR_002`:

1. **Check Network Connection**: Verify your application's internet connection. If the connection is functional, proceed to the next step.

2. **Plugin Availability**: Confirm the availability of the plugin by checking the repositories on GitHub: [godot-admob-versions](https://github.com/poingstudios/godot-admob-versions), [godot-admob-ios](https://github.com/poingstudios/godot-admob-ios), and [godot-admob-android](https://github.com/poingstudios/godot-admob-android).

3. **Retry Download**: If the plugin is available, attempt to download it again. Sometimes, network issues can cause temporary download failures.

## What to Do If the Problem Continues

If you continue to experience issues or encounter problems, please consider opening an issue on the repository at [godot-admob-plugin](https://github.com/poingstudios/godot-admob-plugin).
