# Error Code ERR_001

## Error Description

Error code `ERR_001` occurs when the supported dynamic version for AdMob couldn't be obtained, and the latest supported version listed may be outdated.

## Common Causes

Common causes of this error may include:

1. **Connection Issues**: There may be problems with your application's internet connection, preventing the download of the plugin.

2. **Invalid .json File**: The .json file used for version retrieval may be invalid or corrupted.

## Solution

Here are the steps to resolve error `ERR_001`:

1. **Check Connection**: Verify your application's internet connection. A good address to test your connection is at [godot-admob-versions](https://github.com/poingstudios/godot-admob-versions/blob/master/versions.json). If the connection is functional, proceed to the next step.

2. **Invalid .json File**: If the JSON file is invalid, try manually downloading it from the `Project->Tools->Android Download Manager->Android/iOS->LatestVersion` section. Please note that you may download an outdated version. It is recommended to create an issue on GitHub to address this issue, and if you have any questions, feel free to inquire about the latest version.

## What to Do If the Problem Continues

If you continue to experience issues or encounter problems, please consider opening an issue on the repository at [godot-admob-versions](https://github.com/poingstudios/godot-admob-versions).
